/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package eric.JSprogram;

import eric.GUI.themes;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import rene.util.xml.XmlTree;
import rene.util.xml.XmlWriter;

/**
 *
 * @author erichake
 */
public class ScriptItem extends JMenuItem implements ActionListener{
    private String name,source;

    public ScriptItem(XmlTree tree) {
        super(tree.getTag().getValue("Name"));
        name=tree.getTag().getValue("Name");
//        this.setText(name);
        source=tree.getText();
        source=source.replaceAll("^[\n]*", "");
        source=source.replace("&lt;", "<");
        source=source.replace("&gt;", ">");
//        System.out.println(name+":"+content);
        
        addActionListener(this);
        setFont(themes.TabMenusFont);
    }

    public ScriptItem(String N,String S){
        super(N);
        name=N;
        source=S;
        addActionListener(this);
        setFont(themes.TabMenusFont);
    }

    public String getScriptName(){
        return name;
    }
    public String getScriptSource(){
        return source;
    }
    public void setScriptName(String s){
        name=s;
    }
    public void setScriptSource(String s){
        source=s;
    }

    public void saveScript(final XmlWriter xml) {
        xml.startTagStart("Script");
        xml.printArg("Name", name);
        xml.startTagEndNewLine();
        xml.println(source);
        xml.endTagNewLine("Script");
    }
    
    public void action() {
        JSRun.runScript(source);
    }

    public void actionPerformed(ActionEvent e) {
        action();
    }

}
