/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/


#ifndef _DATASETCLIENT_H_
#define _DATASETCLIENT_H_

//
// $Id: DatasetClient.H,v 1.2 2000/10/02 20:48:41 lijewski Exp $
//

extern "C"
{
    //
    // "format" is the printf format for numerical display ( ex:  "%5.3f" ).
    // "label"  is the first part of the window title ( ex: "myfabname" ).
    // "element" is a single element of a MultiFab (which is a fab).
    // "nvar" is the number of variables in a Real array.
    // "lodim" and "hidim" are array dimensions of size [BL_SPACEDIM]
    //
    bool ArrayView (FArrayBox* fab);
    bool ArrayViewFab (FArrayBox* fab);
    bool ArrayViewFabFormatLabel (FArrayBox*  fab,
                                  const char* format,
                                  const char* label);
    //
    // View a single fab from the multifab.
    //
    bool ArrayViewMultiFabElement (MultiFab* multifab,
                                   int       element);
    bool ArrayViewMultiFabElementFormatLabel (MultiFab*   multifab,
                                              int         element,
                                              const char* format,
                                              const char* label);
    //
    // View the entire multifab.
    //
    bool ArrayViewMultiFab (MultiFab* multifab);
    bool ArrayViewMultiFabFormatLabel (MultiFab*   multifab,
                                       const char* format,
                                       const char* label);

    bool ArrayViewReal (Real*      data,
                        const int* lodim,
                        const int* hidim);
    bool ArrayViewRealFormatLabel (Real*       data,
                                   const int*  lodim,
                                   const int*  hidim,
                                   const char* format,
                                   const char* label);
    bool ArrayViewRealNVar (Real*      data,
                            int        nvar,
                            const int* lodim,
                            const int* hidim);
    bool ArrayViewRealNVarFormatLabel (Real*       data,
                                       int         nvar,
                                       const int*  lodim,
                                       const int*  hidim,
                                       const char* format,
                                       const char* label);
#if (BL_SPACEDIM == 2)
    bool ArrayViewRealDims (Real* data,
                            int   xlo,
                            int   ylo,
                            int   xhi,
                            int   yhi);
    bool ArrayViewRealDimsFormatLabel (Real*       data,
                                       int         xlo,
                                       int         ylo,
                                       int         xhi,
                                       int         yhi,
                                       const char* format,
                                       const char* label);

    bool ArrayViewRealNVarDims (Real* data,
                                int   nvar,
                                int   xlo,
                                int   ylo,
                                int   xhi,
                                int   yhi);
    bool ArrayViewRealNVarDimsFormatLabel (Real*       data,
                                           int         nvar,
                                           int         xlo,
                                           int         ylo,
                                           int         xhi,
                                           int         yhi,
                                           const char* format,
                                           const char* label);
#else
    bool ArrayViewRealDims (Real* data,
                            int   xlo,
                            int   ylo,
                            int   zlo,
                            int   xhi,
                            int   yhi,
                            int   zhi);
    bool ArrayViewRealDimsFormatLabel (Real*       data,
                                       int         xlo,
                                       int         ylo,
                                       int         zlo,
                                       int         xhi,
                                       int         yhi,
                                       int         zhi,
                                       const char* format,
                                       const char* label);
    bool ArrayViewRealNVarDims (Real* data,
                                int   nvar,
                                int   xlo,
                                int   ylo,
                                int   zlo,
                                int   xhi,
                                int   yhi,
                                int   zhi);
    bool ArrayViewRealNVarDimsFormatLabel (Real*       data,
                                           int         nvar,
                                           int         xlo,
                                           int         ylo,
                                           int         zlo,
                                           int         xhi,
                                           int         yhi,
                                           int         zhi,
                                           const char* format,
                                           const char* label);
#endif

    bool ArrayViewRealPtrArrayNVarDims (Real*       data[],
                                        int         nvar,
                                        const int*  lodim,
                                        const int*  hidim,
                                        const char* format,
                                        const char* label);
    //
    // Stuff for TagBoxs and TagBoxArrays as well.
    //
    bool ArrayViewTagBox (TagBox* tb);
    bool ArrayViewTagBoxArray (TagBoxArray* tba);
};

//
// This class is a helper class for the ArrayView stuff.
//
// We define it's member functions in the same module as the above defined
// functions that we want accessible by the debugger.  We then define an
// object of this class in any module that includes this file.  Since the
// compiler MUST construct and destruct that object, it'll have to link in
// the module that contains those member functions, which just happens to
// contain the definitions for the above functions.
//

class ArrayViewHelperClass
{
public:
    ArrayViewHelperClass ();
    ~ArrayViewHelperClass ();
};

static ArrayViewHelperClass An_Array_View_Helper_Class_Object;

#endif /*_DATASETCLIENT_H_*/
