/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

#include "REAL.H"
#include "ArrayLim.H"

#define SDIM 3

      subroutine TRANSV(v,DIMS(v),dx,domnlo,
     &     avVR,avVT,avVZ,Nbin,DIMS(av),maxbin)
      implicit none
      integer DIMDEC(v)
      integer DIMDEC(av)
      REAL_T  v(DIMV(v),SDIM)
      REAL_T avVR(DIMV(av))
      REAL_T avVT(DIMV(av))
      REAL_T avVZ(DIMV(av))
      integer Nbin(DIMV(av))
      REAL_T dx(SDIM), domnlo(SDIM)
      integer i,j,k,n,bsize,maxbin,bin
c      REAL_T binVRSQ(0:maxbin),binVTSQ(0:maxbin),binVZSQ(0:maxbin)
      REAL_T x,y,vx,vy,vz,vr,vt,rat,r,st,ct,kk
      integer ishift , ishm,npts
      integer irlo,irhi
      integer jrlo,jrhi
      integer krlo,krhi
      REAL_T  energy,scale,sum

      kk = ARG_L3(av)
      bsize = 5

      ishm = 1.5/dx(1)
      krlo = 1.5/dx(3)
      krhi = 4.5/dx(3)
      irlo = 1.5/dx(1)
      irhi = 3.0/dx(1)
      npts = (krhi-krlo+1)*(irhi-irlo+1)
      jrhi = ARG_H2(v)
      jrlo = jrhi - 50

      npts = npts *(jrhi-jrlo+1)
      

      scale = 0.d0

         sum = 0.d0

#if 1

      do j=jrlo,jrhi


         do k=krlo,krhi
            do i=irlo,irhi+ishm

              sum = sum+v(i,j,k,1)

            enddo
         enddo
         enddo

         sum = sum / ((krhi-krlo+1)*(irhi+ishm-irlo+1)*(jrhi-jrlo+1))

      do j=ARG_L2(v), ARG_H2(v)

         do k=krlo,krhi
            do i=irlo,irhi+ishm

              v(i,j,k,1)  = v(i,j,k,1) - sum

            enddo
         enddo
         enddo

#endif

      do ishift = 0,ishm

         sum = 0.d0

      do j=jrlo,jrhi
         do k=krlo,krhi
            do i=irlo,irhi

              sum = sum+v(i,j,k,1)*v(i+ishift,j,k,1)

            enddo
         enddo
         enddo

         sum = sum/npts
         if(ishift .eq.0)then
              energy = sum
         endif

         write(6,*)" level, shift",j,ishift,sum,sum/energy

         scale = scale + sum /energy

      enddo
         write(6,*)" scale",j,scale,scale*dx(1)

      end
