/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

#ifdef BL_LANG_FORT
#  define FORT_RESID        residv
#  define FORT_GSRBV        gsrbv
#  define FORT_GSRBV_RZ     gsrbvrz
#else
#if defined(BL_FORT_USE_UNDERSCORE)
#  define FORT_RESID        residv_
#  define FORT_GSRBV        gsrbv_
#  define FORT_GSRBV_RZ     gsrbvrz_
#elif defined(BL_FORT_USE_UPPERCASE)
#  define FORT_RESID        RESIDV
#  define FORT_GSRBV        GSRBV
#  define FORT_GSRBV_RZ     GSRBVRZ
#elif defined(BL_FORT_USE_LOWERCASE)
#  define FORT_RESID        residv
#  define FORT_GSRBV        gsrbv
#  define FORT_GSRBV_RZ     gsrbvrz
#endif

#include <ArrayLim.H>

extern "C" {

  void FORT_RESID(Real * resid, Real * phi, Real * source, 
                  Real * areax, Real * areay, 
#if (BL_SPACEDIM == 3)
                  Real * areaz,
#endif
                  Real * alpha,
                  ARLIM_P(lo), ARLIM_P(hi),
                  const Real * dx, 
#if (BL_SPACEDIM == 2)
                  const int* irz,
#endif
		  Real * norm,
		  int * bc, int * level, int * idir, Real* mu, int * ng);

  void FORT_GSRBV(Real * phi, Real * source, 
                  Real * areax, Real * areay, 
#if (BL_SPACEDIM == 3)
                  Real * areaz,
#endif
                  Real * alpha,
                  ARLIM_P(lo), ARLIM_P(hi),
		  const Real * dx, int * bc,
                  int * level, int * idir, 
		  int * nngsrb, Real* mu, 
#if (BL_SPACEDIM == 2)
                  const int* irz,
#endif
                  int *ng);
};
#endif
