/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

#ifndef _main_F_H_
#define _main_F_H_ 

#include <ArrayLim.H>

#if	defined(BL_LANG_FORT)

#if (BL_SPACEDIM == 2)
#define FORT_FILLCRSE  fillcrse2d
#define FORT_FILLFINE  fillfine2d
#define FORT_MAKEMU    makemu2d
#define FORT_FILLRHS    fillrhs2d
#endif

#if (BL_SPACEDIM == 3)
#define FORT_FILLCRSE  fillcrse3d
#define FORT_FILLFINE  fillfine3d
#define FORT_MAKEMU    makemu3d
#define FORT_FILLRHS    fillrhs3d
#endif

#else

#if (BL_SPACEDIM == 2)
#ifdef BL_FORT_USE_UPPERCASE
#define FORT_FILLCRSE  FILLCRSE2D
#define FORT_FILLFINE  FILLFINE2D
#define FORT_MAKEMU    MAKEMU2D
#define FORT_FILLRHS    FILLRHS2D
#endif
#ifdef BL_FORT_USE_UNDERSCORE
#define FORT_FILLCRSE  fillcrse2d_
#define FORT_FILLFINE  fillfine2d_
#define FORT_MAKEMU    makemu2d_
#define FORT_FILLRHS    fillrhs2d_
#endif
#endif

#if (BL_SPACEDIM == 3)
#ifdef BL_FORT_USE_UPPERCASE
#define FORT_FILLCRSE  FILLCRSE3D
#define FORT_FILLFINE  FILLFINE3D
#define FORT_MAKEMU    MAKEMU2D
#define FORT_FILLRHS    FILLRHS2D
#endif
#ifdef BL_FORT_USE_UNDERSCORE
#define FORT_FILLCRSE  fillcrse3d_
#define FORT_FILLFINE  fillfine3d_
#define FORT_MAKEMU    makemu3d_
#define FORT_FILLRHS    fillrhs3d_
#endif

#endif

extern "C"
{
    void FORT_FILLCRSE (
	REAL* crse, ARLIM_P(crse_lo), ARLIM_P(crse_hi),
	const REAL* h, const int* nc
	);
    void FORT_FILLFINE (
	REAL* fine, ARLIM_P(fine_lo), ARLIM_P(fine_hi),
	const REAL* h, const int* nc
	);
    void FORT_FILLRHS (
	REAL* fine, ARLIM_P(fine_lo), ARLIM_P(fine_hi),
	const REAL* h, const int* nc
	);
    void FORT_MAKEMU(
		     REAL*mu, ARLIM_P(mulo),ARLIM_P(muhi),
		     const REAL* h, int&idir );
};

#endif
#endif
