/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

#ifdef BL_LANG_FORT
#  define FORT_INITSIGV     initsigv
#  define FORT_COARSIGV     coarsesigv
#  define FORT_RESID        resv
#  define FORT_RHSNORM      frhsnorm
#  define FORT_GSRBV        gsrbv
#  define FORT_RESTRICT     coarsev
#  define FORT_INTERPOLATE  interpv
#else
#if defined (BL_FORT_USE_UNDERSCORE)
#  define FORT_INITSIGV     initsigv_
#  define FORT_COARSIGV     coarsesigv_
#  define FORT_RESID        resv_
#  define FORT_RHSNORM      frhsnorm_
#  define FORT_GSRBV        gsrbv_
#  define FORT_RESTRICT     coarsev_
#  define FORT_INTERPOLATE  interpv_
#elif defined (BL_FORT_USE_UPPERCASE)
#  define FORT_INITSIGV     INITSIGV
#  define FORT_COARSIGV     COARSESIGV
#  define FORT_RESID        RESV
#  define FORT_RHSNORM      FRHSNORM
#  define FORT_GSRBV        GSRBV
#  define FORT_RESTRICT     COARSEV
#  define FORT_INTERPOLATE  INTERPV
#elif defined (BL_FORT_USE_LOWERCASE)
#  define FORT_INITSIGV     initsigv
#  define FORT_COARSIGV     coarsesigv
#  define FORT_RESID        resv
#  define FORT_RHSNORM      frhsnorm
#  define FORT_GSRBV        gsrbv
#  define FORT_RESTRICT     coarsev
#  define FORT_INTERPOLATE  interpv
#endif

extern "C" {

  void FORT_RHSNORM(Real * staten, Real * source, 
                    const int& lo_mg_1, const int& lo_mg_2, const int& lo_mg_3,
                    const int& hi_mg_1, const int& hi_mg_2, const int& hi_mg_3,
                    Real * rhsnrm, 
                    Real * uinx_lo, Real * uinx_hi,
                    Real * uiny_lo, Real * uiny_hi,
                    Real * uinz_lo, Real * uinz_hi);

  void FORT_INITSIGV(Real * sigma , Real * rho, Real * mu,
                     const int& lo_mg_1, const int& lo_mg_2, const int& lo_mg_3,
                     const int& hi_mg_1, const int& hi_mg_2, const int& hi_mg_3);

  void FORT_RESID(Real * resid, Real * phi, Real * source, Real * sigma,
                  Real * uinx_lo, Real * uinx_hi,
                  Real * uiny_lo, Real * uiny_hi,
                  Real * uinz_lo, Real * uinz_hi,
                  const int& lo_mg_1, const int& lo_mg_2, const int& lo_mg_3,
                  const int& hi_mg_1, const int& hi_mg_2, const int& hi_mg_3,
                  Real * _hx, Real * _hy, Real * _hz, Real * rnorm, 
		  int * bcx_lo, int * bcx_hi,
		  int * bcy_lo, int * bcy_hi,
		  int * bcz_lo, int * bcz_hi,
		  int * level);

  void FORT_COARSIGV(Real * sigma, Real * sigma_crse,
                     const int& lo_mg_1, const int& lo_mg_2, const int& lo_mg_3,
                     const int& hi_mg_1, const int& hi_mg_2, const int& hi_mg_3,
                     const int& locmg_1, const int& locmg_2, const int& locmg_3,
                     const int& hicmg_1, const int& hicmg_2, const int& hicmg_3);

  void FORT_GSRBV(Real * phi, Real * source, Real * sigma, 
                  Real * uinx_lo, Real * uinx_hi,
                  Real * uiny_lo, Real * uiny_hi,
                  Real * uinz_lo, Real * uinz_hi,
                  const int& lo_mg_1, const int& lo_mg_2, const int& lo_mg_3,
                  const int& hi_mg_1, const int& hi_mg_2, const int& hi_mg_3,
		  Real * _hx, Real * _hy, Real * _hz, 
		  int * bcx_lo, int * bcx_hi,
		  int * bcy_lo, int * bcy_hi,
		  int * bcz_lo, int * bcz_hi,
		  int * level, int * nngsrb);

  void FORT_RESTRICT(Real * res, Real * resc,
                     const int& lo_mg_1, const int& lo_mg_2, const int& lo_mg_3,
                     const int& hi_mg_1, const int& hi_mg_2, const int& hi_mg_3,
                     const int& locmg_1, const int& locmg_2, const int& locmg_3,
                     const int& hicmg_1, const int& hicmg_2, const int& hicmg_3);

  void FORT_INTERPOLATE(Real * phi, Real * deltac,
                        const int& lo_mg_1, const int& lo_mg_2, 
                        const int& lo_mg_3,
                        const int& hi_mg_1, const int& hi_mg_2, 
                        const int& hi_mg_3,
                        const int& loc_mg_1, const int& loc_mg_2, 
                        const int& loc_mg_3,
                        const int& hic_mg_1, const int& hic_mg_2, 
                        const int& hic_mg_3);
};
#endif
