/* cdw
 * Copyright (C) 2002 Varkonyi Balazs
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include <stdio.h>
#include <unistd.h>
#include <string.h>

#include <dirent.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <time.h>
#include <regex.h>

#include "cdw_ncurses.h"

#include "config_cdw.h"

#include "cdw_config.h"
#include "gettext.h"

#ifdef HAVE_LIBMYSQLCLIENT
#include <mysql/mysql.h>

#define HAVE_DISKCATALOG
MYSQL mysql;
MYSQL_RES *result;
MYSQL_ROW row;
#endif

#ifdef HAVE_LIBSQLITE
#include <sqlite.h>

#define HAVE_DISKCATALOG
typedef struct SQLITE_RST {
    char **result;
    int nrow;
    int ncol;
} SQLITE_RES;

sqlite *sqlite_db;
int rc;
char *errmsg=0;
SQLITE_RES *result;
char **row;
#endif

#ifdef HAVE_DISKCATALOG
char query[1000];
int i, maxfiles=0;
struct file_list_struct {
    char *files;
    int	type;
    char *type_name;
    char *cd_name;
    int size;
    int cd_num;
} file_list[202000];

ITEM **items, **cditems, **fileitems;
MENU *cddbmenu;
int choices, dir_level, pos, screenpos, search=0;
char var_type[60], var_disk[60], var_dir[2000];
char file[255];
struct conf config;

struct cddb_menu {
    char all[20];
    char add[20];
    char scr[20];
    char del[20];
    char qut[20];
    char nul[1];
} cddbmenu_const;

struct cddbwins {
    WINDOW *main;
    WINDOW *select;
    WINDOW *menu;
    WINDOW *list;
    WINDOW *info;
    WINDOW *page_info;
} cddbwin;
int size;
char cdbpass[60];
char msg[60];

/* Function declarations */
int add_to_dic_sub();
void show_all();
void delete_from_db(struct file_list_struct info);
void insert_disk(char *disk, char *cd_num, char *type);
/* End of function declarations */


#ifdef HAVE_LIBSQLITE
int sqliteRegexpCompare(const unsigned char *zPattern, const unsigned char *zString)
{
    regex_t *regex;
    regmatch_t *matches;
    int rv;
    int match;

    if ((regex=(regex_t *)malloc(sizeof(regex_t)))==NULL) fprintf(stderr, "Error: malloc() failed!\n");
    rv=regcomp(regex, zPattern, REG_EXTENDED | REG_ICASE);
    if (rv){
	fprintf(stderr, "Regcomp error in rule: %s\n", zPattern);
	return 1;
    }
    if ((matches=(regmatch_t *)malloc((regex->re_nsub+1)*sizeof(regmatch_t)))==NULL) fprintf(stderr, "Error: malloc() failed!\n");
    rv=regexec(regex, zString, regex->re_nsub+1, matches, 0);
    free(matches);
    regfree(regex);
    if (rv)
	return 0;
    else
	return 1;
}

static void regexpFunc(sqlite_func *context, int arg, const char **argv)
{
  if( argv[0]==0 || argv[1]==0 ) return;
  sqlite_set_result_int(context, sqliteRegexpCompare((const unsigned char*)argv[0], (const unsigned char*)argv[1]));
}
#endif

int add_to_dic()
{
    char cdname[60], category[60], cd_num[5], command[255], cmd[255];
    int ret;
    cdw_rv_t passwd_entered;

#ifdef HAVE_LIBMYSQLCLIENT
    if (strlen(cdbpass)<=0) {
	strcpy(cdbpass, "\0");
	sprintf(msg, "%s %s", config.cdbuser, _("password"));
	passwd_entered=inputbox(_("Enter password"), msg, cdbpass, CDW_HASH, 59);
    } else
	passwd_entered=CDW_OK;
#endif
#ifdef HAVE_LIBSQLITE
    passwd_entered=CDW_OK;
#endif
    if (passwd_entered==CDW_OK){
	strcpy(cdname, "\0");
	strcpy(cd_num, "\0");
	strcpy(category, "none\0");
	if (inputbox(_("CD name"), _("Enter CD name:"), cdname, 0, 59) == CDW_OK) {
		if (inputbox(_("CD Number"), _("Number of disk:"), cd_num, 0, 4) == CDW_OK){
		    if (inputbox(_("Category"), _("Enter category:"), category, 0, 59) == CDW_OK){
		    sprintf(cmd, "mount %s", config.cdrw_device);
		    run_command(cmd, _("Mounting cdrom..."), 0, 0, 0, "");
		    insert_disk(cdname, cd_num, category);
		    sprintf(cmd, "umount %s", config.mountpoint);
		    run_command(cmd, _("Unmounting cdrom..."), 0, 0, 0, "");
		    return 1;
		}
	    }
	}
    }
}

int none(struct dirent *unused)
{
    if (strcmp(unused->d_name,".") && strcmp(unused->d_name,"..")) {
	return 1;
    }
    else
	return 0;
}

#ifdef HAVE_LIBMYSQLCLIENT
int scan_content(char *dir, MYSQL mysql, int cd_id, int dirlength)
#endif
#ifdef HAVE_LIBSQLITE
int scan_content(char *dir, sqlite *sqlite_db, int cd_id, int dirlength)
#endif
{
    struct dirent **eps;
    struct stat *finfo;
    int n, ok, cnt, type;
    char *dname, *ch, *date[25], insertdir[200];
    struct tm *filetime;
    time_t fitime;
    char query[500];
#ifdef HAVE_LIBMYSQLCLIENT
    MYSQL_RES *result;
#endif

    n = scandir(dir, &eps, (void *)none, alphasort);
    if (n>=0) {
	for (cnt=0; cnt<n; ++cnt){
    	    ch=(char *) malloc(strlen(eps[cnt]->d_name)+strlen(dir)+4);
	    sprintf(ch,"%s/%s",dir,eps[cnt]->d_name);
	    finfo=(struct stat *)malloc(sizeof(finfo)+100);
	    ok=lstat(ch,finfo);
	    type=S_ISLNK(finfo->st_mode);
	    if ( (eps[cnt]->d_type=DT_DIR) && (type==0) )
#ifdef HAVE_LIBMYSQLCLIENT
		scan_content(ch, mysql, cd_id, dirlength);
#endif
#ifdef HAVE_LIBSQLITE
		scan_content(ch, sqlite_db, cd_id, dirlength);
#endif
	    if (ok=stat(ch,finfo)!=0);
	    else {
		fitime=finfo->st_mtime;
		filetime=localtime(&fitime);
		strftime((char *)date, 25, "%Y-%m-%d", filetime);

		if (strlen(dir)!=dirlength){
		    strcpy((char *)insertdir, dir+dirlength+1);
		    sprintf(query, "INSERT INTO content (file, size, date, cd_id) VALUES (\"%s/%s\",'%d','%s', %d);", insertdir, eps[cnt]->d_name, finfo->st_size, date, cd_id);
		} else
		    sprintf(query, "INSERT INTO content (file, size, date, cd_id) VALUES (\"%s\",'%d','%s', %d);", eps[cnt]->d_name, finfo->st_size, date, cd_id);
#ifdef HAVE_LIBMYSQLCLIENT
		if (mysql_query(&mysql, query)) {
		    fprintf(stderr, "%s: %s\n", _("Failed"), mysql_error(&mysql));
		}
#endif
#ifdef HAVE_LIBSQLITE
		rc=sqlite_exec(sqlite_db, query, NULL, 0, &errmsg);
		if (rc!=SQLITE_OK){
		    fprintf(stderr, "%s\n", errmsg);
		}
#endif
	    }
	    free(finfo);
    	    free(ch);
	}
    }
    return size;
}

void display_error(char *message)
{
    if (LINES>0) {
	    dialogbox(_("Error"), message, DIALOG_OK, CDW_COLORS_ERROR);
    } else {
	;
    }
}

int connect_database()
{
    char message[200];
    FILE *dbfile;
    int do_create=2;
#ifdef HAVE_LIBMYSQLCLIENT
    mysql_init(&mysql);
    if (!mysql_real_connect(&mysql, config.cdbhost, config.cdbuser, cdbpass, "cdw", 0, NULL, 0)){
	sprintf(message, "%s", mysql_error(&mysql));
#endif
#ifdef HAVE_LIBSQLITE
    if ( (dbfile=fopen(config.sqlite_file, "r"))==NULL ){
	if (LINES>0) {
		do_create=dialogbox(_("File not exists"), _("SQLite database file not exists!\nMay I create it?"), 3, CDW_COLORS_WARNING);
	} else {
		;
	}
    } else {
       fclose(dbfile);
    }
    switch(do_create) {
	case 1:
	    return 1;
	    break;
	case 0:
	    sqlite_db=sqlite_open(config.sqlite_file, 1, &errmsg);
	    rc=sqlite_exec(sqlite_db, "CREATE TABLE cd (cd_id INTEGER PRIMARY KEY, name VARCHAR(150) NOT NULL, number INTEGER(5)  DEFAULT '0', type INTEGER(5) NOT NULL DEFAULT '0', date TIMESTAMP DEFAULT '0')", NULL, 0, &errmsg);
	    if (rc!=SQLITE_OK) display_error(errmsg);
	    rc=sqlite_exec(sqlite_db, "CREATE TABLE content (content_id INTEGER(6) PRIMARY KEY, file TEXT NOT NULL, size VARCHAR NOT NULL DEFAULT '', date TIMESTAMP DEFAULT '0', cd_id INTEGER NOT NULL DEFAULT '0')", NULL, 0, &errmsg);
	    if (rc!=SQLITE_OK) display_error(errmsg);
	    rc=sqlite_exec(sqlite_db, "CREATE TABLE type (type_id INTEGER PRIMARY KEY, name VARCHAR NOT NULL DEFAULT '')", NULL, 0, &errmsg);
	    if (rc!=SQLITE_OK) display_error(errmsg);
	    break;
	default:
	    sqlite_db=sqlite_open(config.sqlite_file, 1, &errmsg);
	    break;
    }
    if (!sqlite_db) {
	sprintf(message, "%s", errmsg);
#endif
	if (strlen(message)<=0)
	    sprintf(message, _("Unknown error! Check the settings!"));
	display_error(message);
	return 1;
    }
#ifdef HAVE_LIBSQLITE
    sqlite_create_function(sqlite_db, "regexp", 2, regexpFunc, 0);
    sqlite_function_type(sqlite_db, "regexp", SQLITE_NUMERIC);
#endif
    return 0;
}

int add_content(char *dir, int cd_id)
{
    if (connect_database()==0){
#ifdef HAVE_LIBMYSQLCLIENT
	scan_content(dir, mysql, cd_id, strlen(dir));
	mysql_close(&mysql);
#endif
#ifdef HAVE_LIBSQLITE
	scan_content(dir, sqlite_db, cd_id, strlen(dir));
	sqlite_close(sqlite_db);
#endif
    }
}

#ifdef HAVE_LIBMYSQLCLIENT
MYSQL_RES* query_content(char *type, char *disk, char *dir)
#endif
#ifdef HAVE_LIBSQLITE
SQLITE_RES *query_content(char *type, char *disk, char *dir)
#endif
{

    if (connect_database()==0){
	sprintf(query, "SELECT cd.number, cd.name, content.file, content.size, content.date, type.name FROM content LEFT JOIN cd ON content.cd_id=cd.cd_id left join type on cd.type=type.type_id WHERE content.cd_id>0");
	if (strcmp(dir, "*")!=0){
	    sprintf(query, "%s AND UPPER(content.file) LIKE UPPER(\"%s/%%\")", query, dir);
	}
	if (strcmp(disk,"*")!=0){
	    sprintf(query, "%s AND cd.name='%s'", query, disk);
	}
	if (strcmp(type,"*")!=0){
	    sprintf(query, "%s AND type.name='%s'", query, type);
	}
	sprintf(query, "%s ORDER BY cd.number, cd.name", query);
#ifdef HAVE_LIBMYSQLCLIENT
	if (mysql_query(&mysql, query)) {
		display_error((char *)mysql_error(&mysql));
		/* fprintf(stderr, "%s: %s\n", _("Failed"), mysql_error(&mysql)); */
		return NULL;
	} else {
	    result=mysql_store_result(&mysql);
	    return result;
	}
#endif
#ifdef HAVE_LIBSQLITE
	result=(SQLITE_RES *)malloc(sizeof(SQLITE_RES));
	rc=sqlite_get_table(sqlite_db, query, &result->result, &result->nrow, &result->ncol, &errmsg);
	if (rc!=SQLITE_OK) {
	    display_error(errmsg);
	    //fprintf(stderr, "%s: %s\n", _("Failed"), errmsg);
	    return NULL;
	} else {
	    return result;
	}
#endif
    }
}

#ifdef HAVE_LIBMYSQLCLIENT
MYSQL_RES* search_content(char *file, char *type, char *disk, char *dir)
#endif
#ifdef HAVE_LIBSQLITE
SQLITE_RES *search_content(char *file, char *type, char *disk, char *dir)
#endif
{
    int i;

    if (connect_database()==0){
	sprintf(query, "SELECT cd.number, cd.name, content.file, content.size, content.date, type.name FROM content LEFT JOIN cd ON content.cd_id=cd.cd_id left join type on cd.type=type.type_id WHERE content.cd_id>0");
#ifdef HAVE_LIBMYSQLCLIENT
	if (strcmp(dir, "*")!=0){
	    sprintf(query, "%s AND content.file REGEXP '%s'", query, dir);
	}
	if (strcmp(file, "*")!=0){
	    sprintf(query, "%s AND content.file REGEXP '%s'", query, file);
	}
	if (strcmp(disk,"*")!=0){
	    sprintf(query, "%s AND cd.name=\"%s\"", query, disk);
	}
	if (strcmp(type,"*")!=0){
	    sprintf(query, "%s AND type.name=\"%s\"", query, type);
	}
	sprintf(query, "%s ORDER BY cd.number, cd.name", query);
	if (mysql_query(&mysql, query)) {
		display_error((char *)mysql_error(&mysql));
		//fprintf(stderr, "%s: %s\n", _("Failed"), mysql_error(&mysql));
		return NULL;
	} else {
	    result=mysql_store_result(&mysql);
	    return result;
	}
#endif
#ifdef HAVE_LIBSQLITE
	if (strcmp(dir, "*")!=0){
	    sprintf(query, "%s AND regexp('%s', content.file)", query, dir);
	}
	if (strcmp(file, "*")!=0){
	    sprintf(query, "%s AND regexp('%s', content.file)", query, file);
	}
	if (strcmp(disk,"*")!=0){
	    sprintf(query, "%s AND cd.name=\"%s\"", query, disk);
	}
	if (strcmp(type,"*")!=0){
	    sprintf(query, "%s AND type.name=\"%s\"", query, type);
	}
	sprintf(query, "%s ORDER BY cd.number, cd.name", query);
	rc=sqlite_get_table(sqlite_db, query, &result->result, &result->nrow, &result->ncol, &errmsg);
	if (rc!=SQLITE_OK) {
		display_error(errmsg);
		//fprintf(stderr, "%s: %s\n", _("Failed"), errmsg);
		return NULL;
	} else {
	    return result;
	}
#endif
    }
}

int add_disk(char *cdname, int no, int type, char *date)
{
    if (connect_database()==0){
	sprintf(query, "INSERT INTO cd (name, number, type, date) VALUES (\"%s\",%d,%d, '%s');", cdname, no, type, date);
#ifdef HAVE_LIBMYSQLCLIENT
	if (mysql_query(&mysql, query)) {
		display_error((char *)mysql_error(&mysql));
		//fprintf(stderr, "%s: %s\n", _("Failed"), mysql_error(&mysql));
	}
	i=mysql_insert_id(&mysql);
	mysql_close(&mysql);
#endif
#ifdef HAVE_LIBSQLITE
	rc=sqlite_exec(sqlite_db, query, NULL, 0, &errmsg);
	i=sqlite_last_insert_rowid(sqlite_db);
	if (rc!=SQLITE_OK) {
		display_error(errmsg);
		//fprintf(stderr, "%s: %s\n", _("Failed"), errmsg);
	}
	sqlite_close(sqlite_db);
#endif
    }
    return i;
}

#ifdef HAVE_LIBMYSQLCLIENT
MYSQL_RES* query_disk(char *cdname, int no, char *type)
#endif
#ifdef HAVE_LIBSQLITE
SQLITE_RES *query_disk(char *cdname, int no, char *type)
#endif
{
    if (connect_database()==0){
	sprintf(query, "SELECT cd.cd_id, cd.name, cd.number, type.name, cd.date FROM cd LEFT JOIN type ON cd.type=type.type_id WHERE cd.cd_id>0");
	if (strcmp(cdname, "*")!=0){
	    sprintf(query, "%s AND UPPER(cd.name) LIKE UPPER(\"%%%s%%\")", query, cdname);
	}
	if (no!=0){
	    sprintf(query, "%s AND cd.number=%d", query, no);
	}
	if (strcmp(type, "*")!=0){
	    sprintf(query, "%s AND type.name=\"%s\"", query, type);
	}
	sprintf(query, "%s ORDER BY cd.number, cd.name", query);
#ifdef HAVE_LIBMYSQLCLIENT
	if (mysql_query(&mysql, query)) {
		display_error((char *)mysql_error(&mysql));
		//fprintf(stderr, "%s: %s\n", _("Failed"), mysql_error(&mysql));
		return NULL;
	} else {
	    result=mysql_store_result(&mysql);
	    return result;
	}
#endif
#ifdef HAVE_LIBSQLITE
	rc=sqlite_get_table(sqlite_db, query, &result->result, &result->nrow, &result->ncol, &errmsg);
	if (rc!=SQLITE_OK) {
	    display_error(errmsg);
	    //fprintf(stderr, "%s: %s\n", _("Failed"), errmsg);
	    return NULL;
	} else {
	    return result;
	}
#endif
    }
}

int add_type(char *type)
{
    if (connect_database()==0){
	sprintf(query, "INSERT INTO type (name) VALUES (\"%s\");", type);
#ifdef HAVE_LIBMYSQLCLIENT
	if (mysql_query(&mysql, query)) {
		display_error((char *)mysql_error(&mysql));
		//fprintf(stderr, "%s: %s\n", _("Failed"), mysql_error(&mysql));
	}
	mysql_close(&mysql);
#endif
#ifdef HAVE_LIBSQLITE
	rc=sqlite_exec(sqlite_db, query, NULL, 0, &errmsg);
	if (rc!=SQLITE_OK) {
		display_error(errmsg);
		//fprintf(stderr, "%s: %s\n", _("Failed"), errmsg);
	}
	sqlite_close(sqlite_db);
#endif
    }
}

#ifdef HAVE_LIBMYSQLCLIENT
MYSQL_RES* query_type(char *type)
#endif
#ifdef HAVE_LIBSQLITE
SQLITE_RES *query_type(char *type)
#endif
{
    if (connect_database()==0){
        sprintf(query, "SELECT type.type_id, type.name FROM type", type);
	if (strcmp(type, "*")!=0){
	    sprintf(query, "%s WHERE UPPER(type.name)=UPPER(\"%s\")", query, type);
	}
	sprintf(query, "%s ORDER BY type.type_id", query);
#ifdef HAVE_LIBMYSQLCLIENT
	if (mysql_query(&mysql, query)) {
		display_error((char *)mysql_error(&mysql));
		//fprintf(stderr, "%s: %s\n", _("Failed"), mysql_error(&mysql));
		return NULL;
	} else {
	    result=mysql_store_result(&mysql);
	    return result;
	}
#endif
#ifdef HAVE_LIBSQLITE
	result=(SQLITE_RES *)malloc(sizeof(SQLITE_RES));
	rc=sqlite_get_table(sqlite_db, query, &result->result, &result->nrow, &result->ncol, &errmsg);
	if (rc!=SQLITE_OK) {
		display_error(errmsg);
		//fprintf(stderr, "%s: %s\n", _("Failed"), errmsg);
		return NULL;
	} else {
	    return result;
	}
#endif
    }
}

int switch_type(char *type)
{
	int i;

	if (connect_database()==0){
    	    sprintf(query, "SELECT type.type_id, type.name FROM type WHERE UPPER('%s')=UPPER(type.name) ORDER BY type.type_id", type);
#ifdef HAVE_LIBMYSQLCLIENT
	    if (mysql_query(&mysql, query)) {
		display_error((char *)mysql_error(&mysql));
		//fprintf(stderr, "%s: %s\n", _("Failed"), mysql_error(&mysql));
	    } else {
		result=mysql_store_result(&mysql);
		if (mysql_num_rows(result)>0){
		    row=mysql_fetch_row(result);
		    i=atoi(row[0]);
		} else {
		    i=0;
		}
	    }
	    mysql_close(&mysql);
#endif
#ifdef HAVE_LIBSQLITE
	    result=(SQLITE_RES *)malloc(sizeof(SQLITE_RES));
	    rc=sqlite_get_table(sqlite_db, query, &result->result, &result->nrow, &result->ncol, &errmsg);
	    if (rc!=SQLITE_OK){
		display_error(errmsg);
		//fprintf(stderr, "%s: %s\n", _("Failed"), errmsg);
		return 1;
	    }
	    if (result->nrow>0) i=atoi(result->result[2]);
	    else i=0;
	    sqlite_free_table(result->result);
	    sqlite_close(sqlite_db);
#endif
	}
	return i;
}

int delete_disk(char *cdname, int no, char *type)
{
	int retval, type_no;

	type_no=switch_type(type);
	if (connect_database()==0){
	    sprintf(query, "SELECT cd.cd_id FROM cd WHERE UPPER(cd.name)=UPPER('%s') AND cd.number=%d AND cd.type=%d", cdname, no, type_no);
#ifdef HAVE_LIBMYSQLCLIENT
	    if (mysql_query(&mysql, query)) {
		display_error((char *)mysql_error(&mysql));
		//fprintf(stderr, "%s: %s\n", _("Failed"), mysql_error(&mysql));
	    } else {
		result=mysql_store_result(&mysql);
		row=mysql_fetch_row(result);
		retval=atoi(row[0]);
	    }
	    mysql_close(&mysql);
#endif
#ifdef HAVE_LIBSQLITE
	    rc=sqlite_get_table(sqlite_db, query, &result->result, &result->nrow, &result->ncol, &errmsg);
	    if (rc!=SQLITE_OK) {
		display_error(errmsg);
		//fprintf(stderr, "%s: %s\n", _("Failed"), errmsg);
	    } else {
		row=(*result).result+result->ncol;
		retval=atoi(row[0]);
	    }
#endif
	}
	if (connect_database()==0){
	    sprintf(query, "DELETE FROM cd WHERE UPPER(cd.name)=UPPER(\"%s\") AND cd.number=%d AND cd.type=%d", cdname, no, type_no);
#ifdef HAVE_LIBMYSQLCLIENT
	    if (mysql_query(&mysql, query)) {
		display_error((char *)mysql_error(&mysql));
		//fprintf(stderr, "%s: %s\n", _("Failed"), mysql_error(&mysql));
	    }
	    mysql_close(&mysql);
#endif
#ifdef HAVE_LIBSQLITE
	    rc=sqlite_exec(sqlite_db, query, NULL, 0, &errmsg);
	    if (rc!=SQLITE_OK){
		display_error(errmsg);
		//fprintf(stderr, "%s: %s\n", _("Failed"), errmsg);
	    }
	    sqlite_close(sqlite_db);
#endif
	}
	return retval;
}

int delete_content(int cd_id)
{
	if (connect_database()==0){
	    sprintf(query, "DELETE FROM content WHERE content.cd_id=%d", cd_id);
#ifdef HAVE_LIBMYSQLCLIENT
	    if (mysql_query(&mysql, query)) {
		display_error((char *)mysql_error(&mysql));
		//fprintf(stderr, "%s: %s\n", _("Failed"), mysql_error(&mysql));
	    }
	    mysql_close(&mysql);
#endif
#ifdef HAVE_LIBSQLITE
	    rc=sqlite_exec(sqlite_db, query, NULL, 0, &errmsg);
	    if (rc!=SQLITE_OK){
		display_error(errmsg);
		//fprintf(stderr, "%s: %s\n", _("Failed"), errmsg);
	    }
	    sqlite_close(sqlite_db);
#endif
	}
}

// MUST REVIEW LATER
int delete_type(char *type)
{
    int type_no;
    int cds[1000], i=0, z;

    type_no=switch_type(type);
    if (connect_database()==0){
        sprintf(query, "DELETE FROM type WHERE type.type_id=%d", type_no);
#ifdef HAVE_LIBMYSQLCLIENT
        if (mysql_query(&mysql, query)) {
	    display_error((char *)mysql_error(&mysql));
    	    //fprintf(stderr, "%s: %s\n", _("Failed"), mysql_error(&mysql));
	}
	mysql_close(&mysql);
#endif
#ifdef HAVE_LIBSQLITE
	rc=sqlite_exec(sqlite_db, query, NULL, 0, &errmsg);
	if (rc!=SQLITE_OK){
	    display_error(errmsg);
	    //fprintf(stderr, "%s: %s\n", _("Failed"), errmsg);
	}
	sqlite_close(sqlite_db);
#endif
    }
    if (connect_database()==0){
	sprintf(query, "SELECT cd.cd_id FROM cd WHERE cd.type=%d", type_no);
#ifdef HAVE_LIBMYSQLCLIENT
	if (mysql_query(&mysql, query)) {
	    display_error((char *)mysql_error(&mysql));
	    //fprintf(stderr, "%s: %s\n", _("Failed"), mysql_error(&mysql));
	} else {
	    result=mysql_store_result(&mysql);
	    i=0;
	    while (row=mysql_fetch_row(result)){
		cds[i]=atoi(row[0]);
		i++;
	    }
	}
	mysql_close(&mysql);
#endif
#ifdef HAVE_LIBSQLITE
	rc=sqlite_get_table(sqlite_db, query, &result->result, &result->nrow, &result->ncol, &errmsg);
	if (rc!=SQLITE_OK){
	    display_error(errmsg);
	    //fprintf(stderr, "%s: %s\n", _("Failed"), errmsg);
	} else {
	    for (i=1; i<=result->nrow; i++){
		row=(*result).result+(i*result->ncol);
		cds[i-1]=atoi(row[0]);
	    }
	    i--;
	}
	sqlite_free_table(result->result);
	sqlite_close(sqlite_db);
#endif
    }
    if (connect_database()==0){
    	sprintf(query, "DELETE FROM cd WHERE cd.type=%d", type_no);
#ifdef HAVE_LIBMYSQLCLIENT
    	if (mysql_query(&mysql, query)) {
	    display_error((char *)mysql_error(&mysql));
    	    //fprintf(stderr, "%s: %s\n", _("Failed"), mysql_error(&mysql));
	}
	mysql_close(&mysql);
#endif
#ifdef HAVE_LIBSQLITE
	rc=sqlite_exec(sqlite_db, query, NULL, 0, &errmsg);
	if (rc!=SQLITE_OK){
	    display_error(errmsg);
	    //fprintf(stderr, "%s: %s\n", _("Failed"), errmsg);
	}
	sqlite_close(sqlite_db);
#endif
    }
    for (z=0; z<i; z++){
	if (connect_database()==0){
    	    sprintf(query, "DELETE FROM content WHERE content.cd_id=%d", cds[z]);
#ifdef HAVE_LIBMYSQLCLIENT
    	    if (mysql_query(&mysql, query)) {
		display_error((char *)mysql_error(&mysql));
    		//fprintf(stderr, "%s: %s\n", _("Failed"), mysql_error(&mysql));
	    }
	    mysql_close(&mysql);
#endif
#ifdef HAVE_LIBSQLITE
	rc=sqlite_exec(sqlite_db, query, NULL, 0, &errmsg);
	if (rc!=SQLITE_OK){
	    display_error(errmsg);
	    //fprintf(stderr, "%s: %s\n", _("Failed"), errmsg);
	}
	sqlite_close(sqlite_db);
#endif
	}
    }
}

int load_disk(char *type, char *diskname, char* dir)
{
#ifdef HAVE_LIBMYSQLCLIENT
    MYSQL_RES *disk;
#endif
#ifdef HAVE_LIBSQLITE
    SQLITE_RES *disk;
#endif
    int c=0, i, found, count, forcounter;
    char *line, itemname[100];
    char *linestr;

    file_list[0].cd_num=0;
    file_list[0].files=(char *)malloc(1);
    file_list[0].files[0]='\0';
    file_list[0].cd_name=(char *)malloc(1);
    file_list[0].cd_name[0]='\0';
    if (dir_level==0) {
	if ((disk=(void *)query_type("*"))!=NULL) {
#ifdef HAVE_LIBMYSQLCLIENT
	    while (row=mysql_fetch_row(disk)) {
#endif
#ifdef HAVE_LIBSQLITE
	    for (forcounter=1; forcounter<=result->nrow; forcounter++) {
		row=(*disk).result+(forcounter*disk->ncol);
//		row=disk->result;
//		row+=forcounter*result->ncol;
#endif
		file_list[c].files=(char *)malloc(strlen(row[1])+2);
		sprintf(file_list[c].files, "%s", row[1]);
		file_list[c].cd_name=(char *)malloc(1);
		sprintf(file_list[c].cd_name, "");
		file_list[c].type_name=(char *)malloc(1);
		sprintf(file_list[c].type_name, "");
		file_list[c].type=0;
		file_list[c].size=0;
		wattrset(cddbwin.list, A_BOLD | COLOR_PAIR(1));
		mvwprintw(cddbwin.list, c, 0, "/%.*s", getmaxx(cddbwin.list)-6, file_list[c].files);
		c++;
	    }
	}
#ifdef HAVE_LIBMYSQLCLIENT
	mysql_close(&mysql);
#endif
#ifdef HAVE_LIBSQLITE
	sqlite_free_table(result->result);
	sqlite_close(sqlite_db);
#endif
	wrefresh(cddbwin.list);
    }
    if (dir_level==1) {
	char num[6];
	if ( (search!=1) && ((disk=query_disk(diskname, 0, type))!=NULL) ) {
#ifdef HAVE_LIBMYSQLCLIENT
	    while ((row=mysql_fetch_row(disk))) {
#endif
#ifdef HAVE_LIBSQLITE
	    for (forcounter=1; forcounter<=result->nrow; forcounter++) {
		row=(*disk).result+(forcounter*disk->ncol);
		//row=disk->result;
		//row+=forcounter*result->ncol;
#endif
		file_list[c].files=(char *)malloc(strlen(row[1])+4);
		sprintf(file_list[c].files, "%s", row[1]);
		file_list[c].cd_name=(char *)malloc(1);
		sprintf(file_list[c].cd_name, "");
		file_list[c].type_name=(char *)malloc(strlen(row[3])+1);
		sprintf(file_list[c].type_name, "%s", row[3]);
		file_list[c].type=1;
		file_list[c].size=0;
		file_list[c].cd_num=atoi(row[2]);
		wattrset(cddbwin.list, A_BOLD | COLOR_PAIR(1));
		sprintf(num, "%d", file_list[c].cd_num);
		mvwprintw(cddbwin.list, c, 0, "/%d - %.*s", file_list[c].cd_num, getmaxx(cddbwin.list)-5, file_list[c].files);
		c++;
	    }
	}
	if ( (search==1) && ((disk=search_content(file, type, diskname, dir))!=NULL) ) {
#ifdef HAVE_LIBMYSQLCLIENT
 	    while ((row=mysql_fetch_row(disk))) {
#endif
#ifdef HAVE_LIBSQLITE
	    for (forcounter=1; forcounter<=result->nrow; forcounter++) {
		row=(*disk).result+(forcounter*disk->ncol);
		//row=result->result;
		//row+=forcounter*result->ncol;
#endif
  		line=file_list[c].files=(char *)malloc(strlen(row[1])+4);
		sprintf(line, "%s", row[1]);
		found=0;
		for (i=0; i<c; i++){
		   if (strcmp(line, file_list[i].files)==0)
			found=1;
		}
		if (found==0) {
		   file_list[c].files=(char *)malloc(strlen(row[1])+4);
		   sprintf(file_list[c].files, "%s", row[1]);
		   file_list[c].cd_name=(char *)malloc(1);
		   sprintf(file_list[c].cd_name, "");
		   file_list[c].type_name=(char *)malloc(strlen(row[5])+1);
		   sprintf(file_list[c].type_name, "%s", row[5]);
		   file_list[c].type=1;
		   file_list[c].size=0;
		   file_list[c].cd_num=atoi(row[0]);
		   wattrset(cddbwin.list, A_BOLD | COLOR_PAIR(1));
		   sprintf(num, "%d", file_list[c].cd_num);
		   mvwprintw(cddbwin.list, c, 0, "/%d - %.*s", file_list[c].cd_num, getmaxx(cddbwin.list)-5, file_list[c].files);
		   c++;
		}
	     }
	}
#ifdef HAVE_LIBMYSQLCLIENT
	mysql_close(&mysql);
#endif
#ifdef HAVE_LIBSQLITE
	//sqlite_free_table(result->result);
	sqlite_close(sqlite_db);
#endif
	wrefresh(cddbwin.list);
    }
    if (dir_level>=2) {
	if (search==1){
	    disk=search_content(file, type, diskname, dir);
	} else {
	    disk=query_content(type, diskname, dir);
	}
	if (disk!=NULL) {
	    int count;
	    for (count=0; count<2; count++){
#ifdef HAVE_LIBMYSQLCLIENT
		while (row=mysql_fetch_row(disk)) {
#endif
#ifdef HAVE_LIBSQLITE
		for (forcounter=1; forcounter<=result->nrow; forcounter++) {
		    row=(*disk).result+(forcounter*disk->ncol);
#endif
		    line=(char *) malloc(strlen(row[2])+5);
		    file_list[c].type_name=(char *)malloc(strlen(row[5])+4);
		    sprintf(file_list[c].type_name, "%s", row[5]);
		    file_list[c].cd_name=(char *)malloc(strlen(row[1])+1);
		    sprintf(file_list[c].cd_name, "%s", row[1]);
		    sprintf(line, "%s", row[2]);
		    linestr=strtok((char *)line, (char *)"/");
		    if (dir_level>2)
			for (i=1; i<=(dir_level-2); i++){
			    linestr=strtok(NULL, "/");
			}
		    line=linestr;
		    linestr=strtok(NULL, "/");
		    if (linestr==NULL)
			file_list[c].type=3;
		    else
			file_list[c].type=2;
		    if (line!=NULL) {
			found=0;
			for (i=0; i<c; i++){
			    if (strcmp(line, file_list[i].files)==0)
				found=1;
			}
			if (found==0) {
			    if ((count==0) && (file_list[c].type==2)){
				file_list[c].files=(char *)malloc(strlen(line)+1);
				sprintf(file_list[c].files, "%s", line);
				file_list[c].size=0;
				file_list[c].cd_num=atoi(row[0]);
				c++;
			    }
			    if ((count==1) && (file_list[c].type==3)){
				file_list[c].files=(char *)malloc(strlen(line)+2);
				sprintf(file_list[c].files, "%s", line);
				file_list[c].size=atoi(row[3]);
				file_list[c].cd_num=atoi(row[0]);
				c++;
			    }
			}
		    }
		}
#ifdef HAVE_LIBMYSQLCLIENT
		mysql_data_seek(disk, 0);
#endif
#ifdef HAVE_LIBSQLITE
		row=disk->result;
		row+=forcounter*result->nrow;
#endif
	    }
	    for (i=0; i<c; i++){
			if (file_list[i].type==2){
			    wattrset(cddbwin.list, A_BOLD | COLOR_PAIR(1));
			    mvwprintw(cddbwin.list, i, 0, "/%.*s", getmaxx(cddbwin.list)-7, file_list[i].files);
			    mvwprintw(cddbwin.list, i, getmaxx(cddbwin.list)-5, "DIR");
			} else {
			    wattrset(cddbwin.list, COLOR_PAIR(1));
			    mvwprintw(cddbwin.list, i, 0, "%.*s", getmaxx(cddbwin.list)-6, file_list[i].files);
			    mvwprintw(cddbwin.list, i, getmaxx(cddbwin.list)-5, "File");
			}
	    }
#ifdef HAVE_LIBMYSQLCLIENT
	    mysql_close(&mysql);
#endif
#ifdef HAVE_LIBSQLITE
	    sqlite_free_table(result->result);
	    sqlite_close(sqlite_db);
#endif
	    wrefresh(cddbwin.list);
	}
    }
    maxfiles=--c;
    return maxfiles;
}

void status_line(struct file_list_struct info)
{
    char str[10];
    int maxpage, page;
    char page_str[10];
    char dir_str[255];

    switch (info.type) {
	case 0:
	    strcpy(str, "Type");
	    break;
	case 1:
	    strcpy(str, "Disk");
	    break;
	case 2:
	    strcpy(str, "Directory");
	    break;
	case 3:
	    strcpy(str, "File");
	    break;
    }
    werase(cddbwin.info);
    if (search==1)
	mvwprintw(cddbwin.select, 0, getmaxx(cddbwin.select)-strlen(_(" Search [ ] "))-1, _(" Search [X] "));
    else
	mvwprintw(cddbwin.select, 0, getmaxx(cddbwin.select)-strlen(_(" Search [ ] "))-1, _(" Search [ ] "));
    wrefresh(cddbwin.select);
    if (maxfiles>=0) {
	if (info.type<3){
	    wattrset(cddbwin.info, COLOR_PAIR(1));
	    mvwprintw(cddbwin.info, 0, 0, _("Name: "));
	    wattrset(cddbwin.info, A_BOLD | COLOR_PAIR(8));
	    mvwprintw(cddbwin.info, 0, 6, "[ %.*s ]", getmaxx(cddbwin.info)-10, info.files);
	} else {
	    wattrset(cddbwin.info, COLOR_PAIR(1));
	    mvwprintw(cddbwin.info, 0, 0, _("Name: "));
	    wattrset(cddbwin.info, A_BOLD | COLOR_PAIR(8));
	    mvwprintw(cddbwin.info, 0, 6, "%.*s", getmaxx(cddbwin.info)-5, info.files);
	}
	wattrset(cddbwin.info, COLOR_PAIR(1));
	mvwprintw(cddbwin.info, 1, 0, _("Size: "));
	wattrset(cddbwin.info, A_BOLD | COLOR_PAIR(8));
	mvwprintw(cddbwin.info, 1, 6, "%d Kb", info.size / 1024);
	if (strcmp(info.type_name, "")!=0){
	    wattrset(cddbwin.info, COLOR_PAIR(1));
	    mvwprintw(cddbwin.info, 2, 0, _("Type: "));
	    wattrset(cddbwin.info, A_BOLD | COLOR_PAIR(8));
	    mvwprintw(cddbwin.info, 2, 6, "%s", info.type_name);
	}
	if (strcmp(info.cd_name, "")!=0){
	    wattrset(cddbwin.info, COLOR_PAIR(1));
	    mvwprintw(cddbwin.info, 3, 0, _("Disk: "));
	    wattrset(cddbwin.info, A_BOLD | COLOR_PAIR(8));
	    mvwprintw(cddbwin.info, 3, 6, "(%d) %.*s", info.cd_num, getmaxx(cddbwin.list)-5, info.cd_name);
	}
	wrefresh(cddbwin.info);
	maxpage=maxfiles/getmaxy(cddbwin.list);
	if ( ((maxpage*getmaxy(cddbwin.list))!=maxfiles) || (maxpage==0) )
	    maxpage++;
	page=(pos/getmaxy(cddbwin.list))+1;
	wattrset(cddbwin.page_info, COLOR_PAIR(1));
	mvwhline(cddbwin.page_info, 0, 0, ACS_HLINE, getmaxx(cddbwin.page_info));
	sprintf(page_str, "( %d / %d )", page, maxpage);
	mvwprintw(cddbwin.page_info, 0, getmaxx(cddbwin.page_info)-strlen(page_str), "%s", page_str);
	if (dir_level>=3) {
	    sprintf(dir_str, "(/%s)", var_dir);
	    if (strlen(dir_str)>(getmaxx(cddbwin.page_info)-strlen(page_str))){
		dir_str[getmaxx(cddbwin.page_info)-strlen(page_str)]='\0';
	    }
	    wattrset(cddbwin.page_info, A_BOLD | COLOR_PAIR(1));
	    mvwprintw(cddbwin.page_info, 0, 0, "%s", dir_str);
	}
	wrefresh(cddbwin.page_info);
    }
}

void print_highlight(int pos, struct file_list_struct file_p, int isreverse)
{
  if (dir_level!=1) {
    if (file_p.type<=2){
	if (strlen(file_p.files)>0){
	    if (isreverse==0)
    		wattrset(cddbwin.list, A_REVERSE | COLOR_PAIR(1));
	    else
		wattrset(cddbwin.list, A_BOLD | COLOR_PAIR(1));
    	    mvwprintw(cddbwin.list, pos, 0, "/%.*s", getmaxx(cddbwin.list)-7, file_p.files);
	}
    }
    if (file_p.type==3){
	if (isreverse==0)
    	    wattrset(cddbwin.list, A_REVERSE | COLOR_PAIR(1));
	else
	    wattrset(cddbwin.list, COLOR_PAIR(1));
    	mvwprintw(cddbwin.list, pos, 0, "%.*s", getmaxx(cddbwin.list)-6, file_p.files);
    }
  } else {
    char num[6];
    if (file_p.cd_num!=0){
	if (isreverse==0)
	    wattrset(cddbwin.list, A_REVERSE | COLOR_PAIR(1));
	else
	    wattrset(cddbwin.list, A_BOLD | COLOR_PAIR(1));
	sprintf(num, "%d", file_p.cd_num);
	mvwprintw(cddbwin.list, pos, 0, "/%d - %.*s", file_p.cd_num, getmaxx(cddbwin.list)-(strlen(num)+5), file_p.files);
    }
  }
}

void cddb_menu()
{
    int c;

    print_highlight(pos, file_list[pos], 0);
    wrefresh(cddbwin.list);
    status_line(file_list[pos]);

    while (c!=KEY_LEFT) {
	c=wgetch(cddbwin.main);
	switch(c){
	    case KEY_DOWN:
		if (pos<maxfiles) {
		    pos++;
		    if ( ((pos%(getmaxy(cddbwin.list)))!=0) || (pos==0) ){
			if (pos<getmaxy(cddbwin.list))
			    screenpos=pos;
			else
			    screenpos=pos%getmaxy(cddbwin.list);
			print_highlight(screenpos-1, file_list[pos-1], 1);
			print_highlight(screenpos, file_list[pos], 0);
			wrefresh(cddbwin.list);
		    }
		    else {
			werase(cddbwin.list);
			for (i=pos-1; i<=maxfiles; i++){
			    print_highlight(i-pos, file_list[i], 1);
			    if (file_list[i].type==2)
				mvwprintw(cddbwin.list, i-pos, getmaxx(cddbwin.list)-5, "DIR");
			    else if (file_list[i].type==3)
				mvwprintw(cddbwin.list, i-pos, getmaxx(cddbwin.list)-5, "File");
			}
			screenpos=pos%getmaxy(cddbwin.list);
			print_highlight(screenpos, file_list[pos], 0);
			wrefresh(cddbwin.list);
		    }
		}
		break;
	    case KEY_END:
		if (pos<maxfiles) {
		    pos=maxfiles-(maxfiles%getmaxy(cddbwin.list));
//		    mvwprintw(cddbwin.main, 1, 1, "Pos: %d, Max: %d", pos, maxfiles);
//		    wrefresh(cddbwin.main);
		    werase(cddbwin.list);
		    wrefresh(cddbwin.info);
		    for (i=pos; i<=maxfiles; i++){
			print_highlight(i-pos, file_list[i], 1);
			if (file_list[i].type==2)
			    mvwprintw(cddbwin.list, i-pos, getmaxx(cddbwin.list)-5, "DIR");
			else if (file_list[i].type==3)
			    mvwprintw(cddbwin.list, i-pos, getmaxx(cddbwin.list)-5, "File");
		    }
		    pos=maxfiles;
		    screenpos=pos%getmaxy(cddbwin.list);
		    print_highlight(screenpos, file_list[pos], 0);
		    wrefresh(cddbwin.list);
		}
		break;
	    case KEY_HOME:
		if (pos>0) {
		    pos=0;
		    werase(cddbwin.list);
		    wrefresh(cddbwin.info);
		    for (i=0; i<=maxfiles; i++){
			print_highlight(i-pos, file_list[i], 1);
			if (file_list[i].type==2)
			    mvwprintw(cddbwin.list, i-pos, getmaxx(cddbwin.list)-5, "DIR");
			else if (file_list[i].type==3)
			    mvwprintw(cddbwin.list, i-pos, getmaxx(cddbwin.list)-5, "File");
		    }
		    screenpos=0;
		    print_highlight(screenpos, file_list[pos], 0);
		    wrefresh(cddbwin.list);
		}
		break;
	    case KEY_UP:
		if (pos>0) {
		    pos--;
		    if ( ((pos%(getmaxy(cddbwin.list)))!=getmaxy(cddbwin.list)-1) || (pos==0) ){
			if (pos<getmaxy(cddbwin.list))
			    screenpos=pos;
			else
			    screenpos=pos%getmaxy(cddbwin.list);
			print_highlight(screenpos+1, file_list[pos+1], 1);
			print_highlight(screenpos, file_list[pos], 0);
			wrefresh(cddbwin.list);
		    }
		    else {
			werase(cddbwin.list);
			for (i=(pos-getmaxy(cddbwin.list)); i<=maxfiles; i++){
			    print_highlight(i-(pos-getmaxy(cddbwin.list))-1, file_list[i], 1);
			    if (file_list[i].type==2)
			        mvwprintw(cddbwin.list, i-(pos-getmaxy(cddbwin.list))-1, getmaxx(cddbwin.list)-5, "DIR");
			    else if (file_list[i].type==3)
			        mvwprintw(cddbwin.list, i-(pos-getmaxy(cddbwin.list))-1, getmaxx(cddbwin.list)-5, "File");
			}
			screenpos=getmaxy(cddbwin.list)-1;
			print_highlight(screenpos, file_list[pos], 0);
			wrefresh(cddbwin.list);
		    }
		}
		break;
	    case 10:
		if (file_list[pos].type==0) {
		    dir_level=dir_level+1;
		    wattrset(cddbwin.list, COLOR_PAIR(1));
		    werase(cddbwin.list);
		    sprintf(var_type, "%s", file_list[pos].files);
		    load_disk((char *)var_type, "*", "*");
		    if (file_list[0].cd_num==0){
			dir_level=0;
			wattrset(cddbwin.list, COLOR_PAIR(1));
			werase(cddbwin.list);
			sprintf(var_type, "%s", file_list[pos].files);
			load_disk((char *)var_type, "*", "*");
		    }
		    pos=0;
		}
		else if (file_list[pos].type==1) {
		    dir_level=dir_level+1;
		    wattrset(cddbwin.list, COLOR_PAIR(1));
		    werase(cddbwin.list);
		    sprintf(var_disk, "%s", file_list[pos].files);
		    sprintf(var_dir, "*");
		    load_disk((char *)var_type, (char *)var_disk, "*");
		    pos=0;
		}
		else if (file_list[pos].type==2) {
		    dir_level=dir_level+1;
		    wattrset(cddbwin.list, COLOR_PAIR(1));
		    werase(cddbwin.list);
		    if (dir_level>3)
			sprintf(var_dir, "%s/%s", var_dir, file_list[pos].files);
		    else
			sprintf(var_dir, "%s", file_list[pos].files);
		    load_disk((char *)var_type, (char *)var_disk, (char *)var_dir);
		    pos=0;
		}
		break;
	    case KEY_BACKSPACE:
	    case '/':
		if (dir_level==1) {
		    dir_level--;
		    wattrset(cddbwin.list, COLOR_PAIR(1));
		    werase(cddbwin.list);
		    sprintf(var_disk, "*");
		    sprintf(var_type, "*");
		    sprintf(var_dir, "*");
		    load_disk("*", "*", "*");
		    pos=0;
		}
		else if (dir_level==2) {
		    dir_level--;
		    wattrset(cddbwin.list, COLOR_PAIR(1));
		    werase(cddbwin.list);
		    sprintf(var_disk, "*");
		    sprintf(var_dir, "*");
		    load_disk((char *)var_type, "*", "*");
		    pos=0;
		}
		else if (dir_level==3) {
		    dir_level--;
		    wattrset(cddbwin.list, COLOR_PAIR(1));
		    werase(cddbwin.list);
		    sprintf(var_dir, "*");
		    werase(cddbwin.list);
		    load_disk((char *)var_type, (char *)var_disk, (char *)var_dir);
		    pos=0;
		}
		else if (dir_level>3) {
		    char *dir;
		    char *line;

		    dir_level--;
		    line=(char *) malloc(strlen(var_dir)+5);
		    sprintf(line, "%s", var_dir);
		    dir=strtok(line, "/");
		    sprintf(var_dir, "%s", dir);
		    for (i=1; i<=(dir_level-3); i++){
			dir=strtok(NULL, "/");
			sprintf(var_dir, "%s/%s", var_dir, dir);
		    }
		    wattrset(cddbwin.list, COLOR_PAIR(1));
		    werase(cddbwin.list);
		    load_disk((char *)var_type, (char *)var_disk, (char *)var_dir);
		    pos=0;
		}
		break;
	    case 'A':
	    case 'a':
		add_to_dic_sub();
		break;
	    case 'D':
	    case 'd':
		if (strlen(file_list[pos].files)>0){
		    if (dir_level==0) {
			char message[600];
			sprintf(message, "%s\n %s?", _("Are you sure do you want to delete category:"), file_list[pos].files);
			if (dialogbox(_("Confirm"), message, 3, CDW_COLORS_DIALOG)==0) {
			   delete_from_db(file_list[pos]);
			   if (file_list[0].cd_num==0){
			      dir_level=0;
			      wattrset(cddbwin.list, COLOR_PAIR(1));
			      werase(cddbwin.list);
			      sprintf(var_type, "%s", file_list[pos].files);
			      load_disk((char *)var_type, "*", "*");
			   }
			}
		    }
		    if (dir_level==1) {
			char message[600];
			sprintf(message, "%s\n %s?", _("Are you sure do you want to delete disk:"), file_list[pos].files);
			if (dialogbox(_("Confirm"), message, 3, CDW_COLORS_DIALOG)==0) {
			   delete_from_db(file_list[pos]);
			   if (file_list[0].cd_num==0){
			       dir_level=0;
			       wattrset(cddbwin.list, COLOR_PAIR(1));
			       werase(cddbwin.list);
			       sprintf(var_type, "%s", file_list[pos].files);
			       load_disk((char *)var_type, "*", "*");
			   }
			}
		    }
		    wrefresh(derwin(cddbwin.main,LINES-1,COLS-1,0,0));
		}
		break;
	    case 'S':
	    case 's':
		show_all();
		break;
	    }
	    if (pos<getmaxy(cddbwin.list))
	        screenpos=pos;
	    else
	        screenpos=pos%getmaxy(cddbwin.list);
	    print_highlight(screenpos, file_list[pos], 0);
	    wrefresh(cddbwin.list);
	    status_line(file_list[pos]);
    }
    if (pos<getmaxy(cddbwin.list))
	screenpos=pos;
    else
	screenpos=pos%getmaxy(cddbwin.list);
    print_highlight(screenpos, file_list[pos], 1);
    wrefresh(cddbwin.list);
}

void main_screen()
{
    cddbwin.main=newwin(LINES-1,COLS-1,0,0);
    wbkgd(cddbwin.main, COLOR_PAIR(1));
    werase(cddbwin.main);
    box(cddbwin.main,0,0);
    keypad(cddbwin.main, TRUE);
    mvwaddch(cddbwin.main, 2, 0, ACS_LTEE);
    mvwhline(cddbwin.main, 2, 1, ACS_HLINE, COLS-3);
    mvwaddch(cddbwin.main, 2, COLS-2, ACS_RTEE);
    wattrset(cddbwin.main, A_BOLD | COLOR_PAIR(3));
    mvwprintw(cddbwin.main, 1, (COLS / 2) - ((strlen(_("Disk Catalog"))+8) / 2), "::: %s :::", _("Disk Catalog"));
    wattrset(cddbwin.main, COLOR_PAIR(1));

    // *** Main Menu ***
    strcpy(cddbmenu_const.all, _(" Show all disks "));
    strcpy(cddbmenu_const.add, _(" Add disk       "));
    strcpy(cddbmenu_const.scr, _(" Search         "));
    strcpy(cddbmenu_const.del, _(" Delete         "));
    strcpy(cddbmenu_const.qut, _(" Quit Catalog   "));

    items = (ITEM **)calloc(11, sizeof(ITEM *));

    items[0]=new_item(cddbmenu_const.all, "");
    items[1]=new_item(cddbmenu_const.add, "");
    items[2]=new_item(cddbmenu_const.scr, "");
    items[3]=new_item(cddbmenu_const.del, "");
    items[4]=new_item(cddbmenu_const.qut, "");
    items[5]=new_item((char *)0, "");
    // *****************

    cddbmenu = new_menu((ITEM **)items);
    set_menu_win(cddbmenu, cddbwin.main);
    set_menu_sub(cddbmenu, derwin(cddbwin.main, LINES-8, 26, 5, 3));
    set_menu_fore(cddbmenu, COLOR_PAIR(4) | A_REVERSE);
    set_menu_back(cddbmenu, COLOR_PAIR(4));
    set_menu_mark(cddbmenu, "");
    cddbwin.select=derwin(cddbwin.main, LINES-5, COLS-29, 3, 27);
    cddbwin.menu=derwin(cddbwin.main, LINES-5, 26, 3, 1);
    box(derwin(cddbwin.main, LINES-5, 26, 3, 1),0,0);
    box(cddbwin.select,0,0);
    mvwaddch(cddbwin.menu, 0, 2, ACS_RTEE);
    mvwprintw(cddbwin.menu, 0, 3," %s ", _("Catalog Menu"));
    waddch(cddbwin.menu, ACS_LTEE);

    mvwaddch(cddbwin.select, 0, 2, ACS_RTEE);
    mvwprintw(cddbwin.select, 0, 3," %s ",_("Catalogized files"));
    waddch(cddbwin.select, ACS_LTEE);
    mvwaddch(cddbwin.select, LINES-11, 0, ACS_LTEE);
    mvwhline(cddbwin.select, LINES-11, 1, ACS_HLINE, COLS-31);
    mvwaddch(cddbwin.select, LINES-11, COLS-30, ACS_RTEE);
    mvwprintw(cddbwin.select, 0, getmaxx(cddbwin.select)-strlen(_(" Search [ ] "))-1, _(" Search [ ] "));
    cddbwin.list=derwin(cddbwin.select, LINES-12, COLS-31, 1, 1);
    cddbwin.info=derwin(cddbwin.select, 4, COLS-31, LINES-10, 1);
    cddbwin.page_info=derwin(cddbwin.select, 1, COLS-31, LINES-11, 1);

    wattrset(cddbwin.main, A_BOLD | COLOR_PAIR(2));
    post_menu(cddbmenu);
    wrefresh(cddbwin.main);
}

void insert_disk(char *disk, char *cd_num, char *type)
{
    int id;

    if (switch_type((char *)type)==0){
	add_type((char *)type);
    }
    id=add_disk((char *)disk, atoi(cd_num), switch_type((char *)type), "2004-01-01");
    add_content(config.mountpoint, id);
}

int add_to_dic_sub()
{
    int i;
    if (add_to_dic()==1){
	werase(cddbwin.info);
	werase(cddbwin.list);
	wrefresh(cddbwin.info);
	dir_level=0;
	sprintf(var_type, "*");
	sprintf(var_disk, "*");
	sprintf(var_dir, "*");
	i=load_disk("*", "*", "*");
	pos=0;
	status_line(file_list[pos]);
    }
    if ( strcmp(config.eject, "1")==0 ){
        eject_tray(config.cdrom);
    }
    wrefresh(derwin(cddbwin.main,LINES-1,COLS-1,0,0));
    return i;
}

int search_in_dic()
{
    int ret;
#ifdef HAVE_LIBMYSQLCLIENT
    MYSQL_RES *disk;
#endif
#ifdef HAVE_LIBSQLITE
    SQLITE_RES *disk;
#endif
    int c=0, i, found, count;
    char *line, itemname[100];
    char *linestr;

    if (inputbox(_("Search in content"), _("Enter query string:"), file, 0, 254) == CDW_OK) {
	if (file[0]=='\0'){
	   search==0;
	   werase(cddbwin.info);
	   werase(cddbwin.list);
	   wrefresh(cddbwin.info);
           sprintf(var_type, "*");
	   sprintf(var_disk, "*");
	   sprintf(var_dir, "*");
	   i=load_disk("*", "*", "*");
	   pos=0;
	   status_line(file_list[pos]);
	}
	else {
		dir_level=1;
		search=1;
		werase(cddbwin.info);
		werase(cddbwin.list);
		wrefresh(cddbwin.info);
		sprintf(var_type, "*");
		sprintf(var_disk, "*");
		sprintf(var_dir, "*");
		i=load_disk("*", "*", "*");
		pos=0;
		status_line(file_list[pos]);
	}
    }
}

void show_all()
{
    werase(cddbwin.info);
    werase(cddbwin.list);
    wrefresh(cddbwin.info);
    dir_level=1;
    sprintf(var_type, "*");
    sprintf(var_disk, "*");
    sprintf(var_dir, "*");
    search=0;
    i=load_disk("*", "*", "*");
    pos=0;
    status_line(file_list[pos]);
}

void delete_from_db(struct file_list_struct info)
{
    int cd_id;

    if (dir_level==1) {
	cd_id=delete_disk(info.files, info.cd_num, info.type_name);
	delete_content(cd_id);
	werase(cddbwin.info);
	werase(cddbwin.list);
	wrefresh(cddbwin.info);
	i=load_disk(var_type, var_disk, "*");
	pos=0;
	status_line(file_list[pos]);
    }
    if (dir_level==0) {
	werase(cddbwin.info);
	werase(cddbwin.list);
	wrefresh(cddbwin.info);
	delete_type(info.files);
	i=load_disk("*", "*", "*");
	pos=0;
	status_line(file_list[pos]);
    }
}

int cddb_window()
{
    char *in;
    int c, i=-1, page=1, quit=0;
    cdw_rv_t passwd_entered;

    read_conf();
    strcpy(cdbpass, "\0");
    sprintf(msg, "%s %s", config.cdbuser, _("password"));
#ifdef HAVE_LIBMYSQLCLIENT
    passwd_entered=inputbox(_("Enter password"), msg, cdbpass, CDW_HASH, 59);
#endif
#ifdef HAVE_LIBSQLITE
    passwd_entered=CDW_OK;
#endif
    if (passwd_entered==CDW_OK) {
	main_screen();
	dir_level=0;
	if (connect_database()!=0){
	    return -1;
	} else {
#ifdef HAVE_LIBMYSQLCLIENT
	mysql_close(&mysql);
#endif
#ifdef HAVE_LIBSQLITE
	sqlite_close(sqlite_db);
	result=(SQLITE_RES *)malloc(sizeof(SQLITE_RES));
#endif
	i=load_disk("*", "*", "*");
	pos=0;
	status_line(file_list[pos]);
	while ( (c!='q') && (quit==0) ){
	    c=wgetch(cddbwin.main);
	    switch(c){
		// -------- MENU --------
		case KEY_F(1):
		    show_help_cddb();
		    wrefresh(derwin(cddbwin.main,LINES-1,COLS-1,0,0));
		    break;
		case 'A':
		case 'a':
		    i=add_to_dic_sub();
		    break;
		case 'S':
		case 's':
		    show_all();
		    break;
		case KEY_HOME:
		    menu_driver(cddbmenu, REQ_FIRST_ITEM);
		    break;
		case KEY_END:
		    menu_driver(cddbmenu, REQ_LAST_ITEM);
		    break;
		case KEY_DOWN:
		    menu_driver(cddbmenu, REQ_DOWN_ITEM);
		    break;
		case KEY_UP:
		    menu_driver(cddbmenu, REQ_UP_ITEM);
		    break;
		case KEY_RIGHT:
		    if (i>=0){
			cddb_menu();
			menu_driver(cddbmenu, REQ_FIRST_ITEM);
		    }
		    break;
		case 10:
		    // Show all
		    if ( item_index(current_item(cddbmenu)) == 0 ){
			show_all();
		    }
		    // Add disk
		    if ( item_index(current_item(cddbmenu)) == 1 ){
			i=add_to_dic_sub();
		    }
		    // Search
		    if ( item_index(current_item(cddbmenu)) == 2 ){
			search_in_dic();
			wrefresh(derwin(cddbwin.main,LINES-1,COLS-1,0,0));
		    }
		    // Delete
		    if ( item_index(current_item(cddbmenu)) == 3 ){
			if (strlen(file_list[pos].files)>0){
			    if (dir_level==0) {
				char message[600];
				sprintf(message, "%s\n %s?", _("Are you sure do you want to delete category:"), file_list[pos].files);
				if (dialogbox(_("Confirm"), message, 3, CDW_COLORS_DIALOG)==0) {
				   delete_from_db(file_list[pos]);
				   if (file_list[0].cd_num==0){
				      dir_level=0;
				      wattrset(cddbwin.list, COLOR_PAIR(1));
				      werase(cddbwin.list);
				      sprintf(var_type, "%s", file_list[pos].files);
				      load_disk((char *)var_type, "*", "*");
				   }
				}
			    }
			    if (dir_level==1) {
			       char message[600];
			       sprintf(message, "%s\n %s?", _("Are you sure do you want to delete disk:"), file_list[pos].files);
			       if (dialogbox(_("Confirm"), message, 3, CDW_COLORS_DIALOG)==0) {
				   delete_from_db(file_list[pos]);
				   if (file_list[0].cd_num==0){
				       dir_level=0;
				       wattrset(cddbwin.list, COLOR_PAIR(1));
				       werase(cddbwin.list);
				       sprintf(var_type, "%s", file_list[pos].files);
				       load_disk((char *)var_type, "*", "*");
				   }
			       }
			    }
			}
			wrefresh(derwin(cddbwin.main,LINES-1,COLS-1,0,0));
		    }
		    // Quit
		    if ( item_index(current_item(cddbmenu)) == 4){
			quit=1;
			//exit(1);
		    }
		    break;
	    }
	    wrefresh(cddbwin.main);
	}
	unpost_menu(cddbmenu);
	free_menu(cddbmenu);
	for(i = 0; i < choices; ++i)
	    free_item(items[i]);
	delwin(cddbwin.main);
	return 0;
	}
    }
}
#endif
