#ifndef H_CDW_DYNAMIC_LABEL
#define H_CDW_DYNAMIC_LABEL

#include "main.h"
#include "cdw_ncurses.h"


typedef struct {
	WINDOW *parent;  /* parent window of the widget */

	char *content;
	FIELD *field;
	int n_cols;

	/* For consistency with other widget types that have driver function. */
	int widget_id;

} CDW_DYNAMIC_LABEL;



CDW_DYNAMIC_LABEL *cdw_dynamic_label_new(WINDOW *parent, FIELD *field, int n_cols, const char *content);
void     cdw_dynamic_label_delete(CDW_DYNAMIC_LABEL **label);
cdw_rv_t cdw_dynamic_label_set_new(CDW_DYNAMIC_LABEL *label, const char *content);
cdw_rv_t cdw_dynamic_label_set_new_temporary(CDW_DYNAMIC_LABEL *label, const char *temporary_content, unsigned int seconds, cdw_colors_t colors);

#endif /* #ifndef H_CDW_DYNAMIC_LABEL */
