#!/bin/sh

spitshell=cat
package=charybdis

echo "Extracting $package/src/version.c..."

if test -r version.c.last
then
   generation=`sed -n 's/^const char \*generation = \"\(.*\)\";/\1/p' < version.c.last`
   if test ! "$generation" ; then generation=0; fi
else
   generation=0
fi

generation=`expr $generation + 1`

if test "$EXTERNAL_BUILD_TIMESTAMP" = ''; then
    creation=`LC_ALL=C date | \
awk '{if (NF == 6) \
         { print $1 " "  $2 " " $3 " "  $6 " at " $4 " " $5 } \
else \
         { print $1 " "  $2 " " $3 " " $7 " at " $4 " " $5 " " $6 }}'`
else
    creation="$EXTERNAL_BUILD_TIMESTAMP"
fi

$spitshell >version.c <<!SUB!THIS!
/*
 *   $package - Internet Relay Chat, src/version.c
 *   Copyright (C) 1990 Chelsea Ashley Dyerman
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * This file is generated by version.c.SH. Any changes made will go away.
 */

#include "patchlevel.h"
#include "serno.h"
#include "stdinc.h"

const char *generation = "$generation";
const char *creation = "$creation";
const char *ircd_version = PATCHLEVEL;
const char *serno = SERNO;
const unsigned long int datecode = DATECODE;

const char *infotext[] =
{
  "$package --",
  "Based on the original code written by Jarkko Oikarinen",
  "Copyright (c) 1988-1991 University of Oulu, Computing Center",
  "Copyright (c) 1996-2001 Hybrid Development Team",
  "Copyright (c) 2002-2009 ircd-ratbox Development Team",
  "Copyright (c) 2005-2016 charybdis development team",
  " ",
  "This program is free software; you can redistribute it and/or",
  "modify it under the terms of the GNU General Public License as",
  "published by the Free Software Foundation; either version 2, or",
  "(at your option) any later version.",
  " ",
!SUB!THIS!

sed 's/^$/ /;s/.*/\  "&\",/' ../CREDITS >> version.c
$spitshell >>version.c <<!SUB!THISTOO!
  " ",
  NULL,
};
!SUB!THISTOO!
