
find_package(SDL2 NO_MODULE QUIET)

if(SDL2_FOUND AND (NOT TARGET SDL2::SDL2))
	add_library(SDL2::SDL2 UNKNOWN IMPORTED GLOBAL)
	if(NOT SDL2_LIBDIR)
		set(SDL2_LIBDIR "${libdir}")
	endif()
	find_library(SDL2_LIBRARY SDL2 PATHS "${SDL2_LIBDIR}" NO_DEFAULT_PATH)
	if(SDL2_LIBRARY)
		string(STRIP "${SDL2_LIBRARIES}" SDL2_LIBRARIES)
		set_target_properties(SDL2::SDL2 PROPERTIES
				IMPORTED_LOCATION "${SDL2_LIBRARY}"
				IMPORTED_LINK_INTERFACE_LIBRARIES "${SDL2_LIBRARIES}"
				INTERFACE_LINK_DIRECTORIES "${SDL2_LIBDIR}"
				INTERFACE_INCLUDE_DIRECTORIES "${SDL2_INCLUDE_DIRS}")
	else()
		set(SDL2_FOUND FALSE)
	endif()
endif()

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(SDL2 CONFIG_MODE)
