# +=========================================================================+
# || /usr/share/cipux/etc/cipux-dog.perl                                   ||
# ||                                                                       ||
# || Configuration of different external CipUX::Dog commands.              ||
# || CipUX::Dog can optional be used by the CipUX task layer.              ||
# ||                                                                       ||
# ||                                                                       ||
# +=========================================================================+

# do NOT change the ordering of the configuration sections

my $prefix = "/usr/bin";

# %dog_cfg
$cfg = {

    cipux_dogs => {

        # this will create a home dir and sync /etc/skel and the role skel
        create_homedir => {
            commands => {
                '1' => {
                    'shell' => $prefix . '/sometool_homedir_create',
                    'args'  => [qw(--user @user@ --role @role@)],
                },
            },
        },

        # this will restore a home dir from skel without deleting content
        # restore referes here to the skel perspective
        restore_homedir => {
            commands => [
                '1' => {
                    'shell' => $prefix . '/sometool_homedir_restore',
                    'args'  => [qw(--user @user@ --role @role@)],
                },
            ],
        },

       # this will make a backup, wipe out the homedir and then creates
       # it again and syncronize skels
        reset_homedir => {
            commands => [
                '1' => {
                    'shell' => $prefix . '/sometool_homedir_backup',
                    'args'  => [qw(--user @user@ --role @role@)],
                },
                '2' => {
                    'shell' => $prefix . '/sometool_homedir_reset',
                    'args'  => [qw(--user @user@ --role @role@)],
                },
            ],
        },
    },

};

# In future (not implemented jet) this might create a user with
# "2nd Forbach Skel". You have to add a second "--skel %cipuxSkeletonUid"
# to all relevant commands. Example:
# commands => [
#   'sometool_homedir_reset --user %uid --skel %cipuxRole \
#                           --skel %cipuxSkeletonUid'
#             ],
#
