/* ramachandran.cpp: ramachandran plot class */
//C Copyright (C) 2000-2006 Kevin Cowtan and University of York
//L
//L  This library is free software and is distributed under the terms
//L  and conditions of version 2.1 of the GNU Lesser General Public
//L  Licence (LGPL) with the following additional clause:
//L
//L     `You may also combine or link a "work that uses the Library" to
//L     produce a work containing portions of the Library, and distribute
//L     that work under terms of your choice, provided that you give
//L     prominent notice with each copy of the work that the specified
//L     version of the Library is used in it, and that you include or
//L     provide public access to the complete corresponding
//L     machine-readable source code for the Library including whatever
//L     changes were used in the work. (i.e. If you make changes to the
//L     Library you must distribute those, but you do not need to
//L     distribute source or object code to those portions of the work
//L     not covered by this licence.)'
//L
//L  Note that this clause grants an additional right and does not impose
//L  any additional restriction, and so does not affect compatibility
//L  with the GNU General Public Licence (GPL). If you wish to negotiate
//L  other terms, please contact the maintainer.
//L
//L  You can redistribute it and/or modify the library under the terms of
//L  the GNU Lesser General Public License as published by the Free Software
//L  Foundation; either version 2.1 of the License, or (at your option) any
//L  later version.
//L
//L  This library is distributed in the hope that it will be useful, but
//L  WITHOUT ANY WARRANTY; without even the implied warranty of
//L  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//L  Lesser General Public License for more details.
//L
//L  You should have received a copy of the CCP4 licence and/or GNU
//L  Lesser General Public License along with this library; if not, write
//L  to the CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
//L  The GNU Lesser General Public can also be obtained by writing to the
//L  Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
//L  MA 02111-1307 USA


#include "ramachandran.h"


namespace clipper {

namespace data {

  int rama_data_size = 36;
  ftype32 rama_gly[] = {
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     1,    9,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,// 0
     0,    0,    0,    0,    0,    0,    0,    7,    1,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    1,    7,
     0,    2,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,// 1
     0,    0,    0,    0,    0,    0,    0,    3,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    5,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,// 2
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    3,
     3,    0,    0,    0,    0,    0,    0,    0,    3,    3,    0,    0,// 3
     0,    0,    0,   11,   37,   21,   10,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    4,   15,   18,   74,
    36,    3,    5,    2,    0,    0,    0,    0,    3,    3,    0,    0,// 4
     1,    3,   30,  146,  193,  137,   30,    6,    0,    0,    0,    0,
     0,    0,    0,    0,    1,    0,    0,    1,   16,   60,  237,  329,
   131,   25,    7,    2,    0,    3,    2,    0,    0,    0,    0,    1,// 5
    42,  154,  432,  857,  603,  201,   52,    3,    0,    0,    0,    0,
     3,    8,    0,    3,    8,    8,   49,   97,  204,  334,  409,  593,
   320,   63,   11,    0,    0,    4,    3,    0,    0,    2,    5,   15,// 6
   616, 1527, 1975, 1407,  577,  144,   51,    0,    0,    0,    0,    0,
     1,    0,    0,    5,   34,   93,  178,  366,  452,  310,  236,  305,
   210,   53,   22,   16,    3,    2,    0,    0,    7,    9,   26,  111,// 7
  2655, 2916, 2032,  816,  205,   61,   14,   10,    5,    2,    7,   11,
    13,    5,   19,   73,  171,  337,  524,  493,  460,  222,  127,   97,
    57,   28,   21,   12,    4,   19,   31,   29,   24,   41,  196, 1032,// 8
  2461, 1984,  840,  240,   74,   29,   16,    5,   10,   15,   15,   22,
    23,   40,   75,  253,  356,  406,  464,  420,  289,  144,   53,   24,
    20,   19,   15,   15,    0,   19,   26,   30,   41,  145,  798, 1998,// 9
  1122,  937,  278,   55,   30,    6,   16,    6,   19,   12,   29,   39,
    51,   83,  119,  216,  327,  228,  292,  250,  168,  101,   47,   32,
     9,   19,    6,    9,   12,    0,    9,   30,   40,  218,  929, 1231,//10
   467,  301,  148,   54,    6,    3,    3,    0,    6,    2,   26,   28,
    41,   50,   66,  173,  205,  172,  190,  206,  112,   45,   17,   22,
     2,   12,   11,    7,    3,    0,    5,   12,   58,  195,  402,  443,//11
   190,  104,   33,   19,   24,   10,    5,    0,    1,   10,   17,   15,
    29,   36,   71,   87,  127,  173,  156,  135,   68,   48,   32,   13,
     7,   16,    5,    4,    7,    1,   16,   13,   16,   86,  102,  111,//12
    64,   32,   12,   11,   32,    9,    0,    0,    0,    7,    8,   11,
    10,   38,   43,   61,   86,  106,  112,  140,  132,   67,   40,   15,
     9,   12,    1,    0,   13,   10,    2,   11,   11,   24,   68,  101,//13
    15,   11,    9,    2,    3,    1,    0,    0,    0,    2,    3,    0,
    14,    9,   28,   45,  101,  102,  169,  169,  162,  112,   60,   18,
     2,    1,    0,    0,    5,    2,    0,   10,   16,   15,   26,   36,//14
     7,   12,    5,    0,    0,    0,    0,    0,    0,    2,    5,    4,
    10,    4,   31,   40,   76,  139,  259,  193,  137,  116,   51,   18,
     4,    0,    0,    1,    0,    4,    6,    1,   21,    8,   11,   18,//15
     4,    8,    0,    0,    0,    0,    0,    1,   12,    0,    1,    6,
     0,    7,    6,   27,   93,  150,  202,  253,  211,  105,   30,   23,
     6,    5,    3,    8,    1,   17,   16,    0,    0,    1,    3,   10,//16
     0,    0,    0,    0,    0,    6,    1,   10,    0,    0,    1,    6,
     9,    6,    9,   30,  104,  187,  324,  399,  208,  126,   48,   19,
    12,    6,    3,    0,    0,    3,    1,    0,    0,    0,    0,    0,//17
     0,    2,    1,    0,    0,    6,    0,    0,    0,    0,    0,   10,
    10,   16,   38,   35,  153,  303,  421,  352,  184,   72,   54,   19,
    21,    8,    7,    0,    0,    0,    0,    5,    4,    1,    0,    1,//18
     4,    6,    3,    0,    1,    3,    1,    9,    0,    0,    0,    3,
     3,   18,   38,   72,  191,  401,  430,  252,  172,   74,   40,    9,
     9,    0,   11,    6,    7,    0,    0,    3,   12,   10,    2,    8,//19
    18,    1,    0,    3,   12,    8,   11,    3,    0,    2,    0,    0,
     1,   23,   71,  164,  338,  358,  286,  185,  125,   46,   17,    5,
     1,    7,    4,   10,    2,    0,    0,    0,    0,    1,    0,    1,//20
     4,   14,   12,    6,    5,    4,    0,    0,    2,    8,    0,    1,
    14,   39,   97,  183,  245,  212,  178,  143,  107,   51,   36,   13,
    11,    1,    4,    7,    0,    0,    0,    0,    0,    0,    0,    0,//21
     7,   21,   18,   46,   23,    4,   10,    1,    0,    0,    0,    6,
    25,   62,  150,  258,  187,  143,  150,  125,   62,   16,   35,   17,
    14,    7,    4,    1,    3,    6,    0,    0,    0,    1,    6,    2,//22
    24,   31,   34,   55,   25,   13,    9,    4,    0,    0,    1,   20,
    40,   82,  144,  259,  208,  150,  148,  151,   88,   50,   33,   26,
    25,   11,    7,   14,    8,    4,   14,    0,    0,   10,   19,   21,//23
    24,   61,   51,   26,   24,    5,    6,    2,    0,    0,    0,   15,
    42,  107,  142,  154,  151,  140,  113,  141,   96,   76,   31,   22,
     9,   16,   19,   13,    7,    8,   12,    1,    0,    4,   23,   28,//24
    86,  126,  147,   42,   16,   27,   25,    3,    0,    1,    3,   35,
    54,   94,  145,  114,  153,  147,  180,  151,  129,  114,   86,   33,
    24,   31,   22,   22,   25,   11,   24,    6,    9,   20,   24,   40,//25
   244,  273,  176,   62,    6,   16,   20,    6,    1,    4,   31,   58,
    80,   90,  107,  157,  181,  206,  254,  225,  269,  151,  100,   87,
    41,   43,   30,   20,   18,   24,   10,    1,   10,   34,   73,  137,//26
   499,  309,  145,   71,   18,   30,   21,   36,   30,   25,   22,   43,
    45,  132,  180,  216,  225,  325,  436,  455,  378,  138,   72,   51,
    21,   37,   28,    3,   17,   26,    5,   21,   32,   79,  158,  357,//27
   463,  119,   15,   44,   15,   33,   40,   30,   24,   27,   19,   35,
    53,  113,  225,  313,  425,  594,  531,  432,  223,   92,   34,    8,
     0,    5,    4,    7,    8,   13,   28,  104,  249,  318,  354,  531,//28
   174,   21,    1,    0,    1,   17,   10,    3,    4,   13,   20,   23,
    72,  120,  275,  490,  579,  477,  271,  124,   48,   17,    2,    0,
     0,    0,    8,    7,    0,   13,   91,  851, 2514, 1280,  752,  630,//29
    36,    3,    7,    1,    0,    1,    0,    0,    0,    0,    1,    5,
    48,  158,  339,  299,  137,  111,   57,   29,    2,    1,    0,    0,
     0,    0,    0,    0,    0,   11,  179, 2348, 4535, 1658,  748,  240,//30
     4,    0,   16,    1,    0,    0,    0,    0,    0,    0,    5,   12,
    14,   74,  122,   40,    1,   10,    7,    2,    0,    0,    0,    0,
     0,    0,    0,    0,   10,   12,  140,  626,  736,  309,   95,   15,//31
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    2,    1,
    13,    6,    4,    0,    0,    0,   11,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    4,   10,   60,   85,   28,    8,    0,    0,//32
     0,    0,    0,    0,    0,    3,    9,    0,    0,    0,    0,    0,
     3,    9,    3,    6,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,   11,   10,    5,    6,    5,    0,    0,    0,    0,//33
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    5,    7,    3,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,   10,    4,    0,    0,    0,    0,    0,    0,    0,//34
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,//35
  };
  ftype32 rama_pro[] = {
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,// 0
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,// 1
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,// 2
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,// 3
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,// 4
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,// 5
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,// 6
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,// 7
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,// 8
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,// 9
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,//10
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,//11
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,//12
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,//13
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,//14
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,//15
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,//16
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,//17
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,//18
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,//19
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,//20
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,//21
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,//22
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,//23
     0,    0,    0,    0,    0,    2,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,//24
     3,    7,    8,    8,   18,   16,    7,    0,    0,    0,    0,    0,
     0,    0,    3,    7,   11,   11,    6,    4,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,//25
    89,   84,   65,   44,    8,    7,   10,    0,    0,    0,    0,    4,
    23,   29,   25,   34,   70,   44,   34,    9,    0,    0,    0,    1,
     3,    0,    0,    0,    0,    0,    0,    0,    0,    0,    9,   47,//26
   245,  142,  121,   55,   11,   26,   52,   86,   22,   15,   15,   16,
    45,   95,  111,  269,  327,  234,  109,   37,    3,    2,    2,    2,
     6,    0,    0,    0,    0,    0,    0,    0,    0,    9,  122,  217,//27
   399,  100,   43,   21,   45,  111,  203,  246,  126,   59,   69,   61,
   149,  349,  658, 1240, 1354,  828,  239,   58,   16,   12,    7,    6,
     1,    4,    2,    0,    0,    0,    0,    0,   28,  138,  434,  704,//28
   309,   35,   10,    3,   10,   67,  101,   68,   42,   34,   26,   75,
   280,  912, 2196, 3282, 2681, 1103,  162,   21,    3,    1,    1,    2,
    11,    4,    2,    4,    2,    1,    7,   45,  400, 1155, 1852, 1359,//29
    62,    9,    2,    5,    4,    3,    8,    0,    0,    9,   36,   37,
   404, 1893, 3871, 3571, 1491,  290,   38,   11,    0,    0,    0,    0,
     0,    0,    0,    4,    2,   14,   48,  615, 2889, 4269, 2608,  601,//30
     0,    4,    3,    0,    0,    0,    0,    0,    0,    4,   14,   19,
   366, 1302, 1543,  683,  130,    8,    1,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    3,   93,  961, 2346, 1684,  400,   18,//31
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    3,   20,
    82,  119,   85,   14,    1,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,   19,   81,  230,  242,   85,   11,    0,//32
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,   10,   11,
     8,    2,    5,    3,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    4,    0,    0,    5,   33,   31,    4,    1,    0,    0,//33
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    3,    6,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    8,    0,    0,    0,    2,    3,    0,    0,    0,    0,//34
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,//35
  };
  ftype32 rama_ngp[] = {
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    4,    0,    0,    2,    3,    0,    0,    0,    0,// 0
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    1,    1,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    1,    7,    5,    2,    0,    0,    0,    0,    0,    0,// 1
     0,    0,    0,    0,    0,    3,    4,    0,    0,    0,    0,    0,
     0,    5,    4,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    3,    1,    3,    8,    0,    0,    0,    0,// 2
     0,    0,    0,    0,    1,   26,   46,   23,    2,    1,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     1,   10,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,// 3
     0,    0,    1,   14,  170,  518,  444,  135,   18,    3,    4,    5,
     0,    0,    0,    0,    0,    0,    0,    0,    1,    7,   10,   29,
    22,    6,    5,    0,    0,    0,    0,    0,    0,    0,    0,    0,// 4
     0,    7,  164,  821, 2467, 2335,  972,  229,   38,    7,   10,    8,
     0,    0,    0,    0,    0,    0,    0,    1,    4,   29,   51,  157,
    87,   29,   22,    0,    0,    0,    0,    0,    0,    5,    2,    0,// 5
    46,  354, 1203, 2297, 2859, 1352,  417,  140,   36,    3,   19,   19,
     3,    0,    0,    1,    2,    7,   29,    9,   36,   49,   58,   85,
    90,   45,   22,    1,    3,   14,   22,   11,   18,   16,   15,   10,// 6
   276,  752,  962,  848,  373,   77,   42,   30,   15,    5,   10,   10,
     9,    3,    6,    8,   14,   16,   42,   15,    9,   13,   11,   10,
    16,   14,    8,    0,    2,   26,   99,   65,   35,   12,   32,   65,// 7
   166,  207,  109,   52,    7,   10,    9,   15,   17,    5,    5,    7,
     3,    6,   18,   22,   16,    7,    3,    1,    0,    0,    1,    0,
     0,    0,    0,    0,    0,    7,   33,   39,   17,    6,   21,  111,// 8
    18,   15,    0,    0,    0,    3,    6,    1,   12,    0,   10,    1,
     9,   11,    5,    8,    1,    0,    0,    0,    2,   10,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    1,    0,    0,    2,   14,// 9
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    1,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,//10
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    4,    1,//11
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    5,    2,//12
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    1,    4,    0,    0,    0,//13
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     1,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    5,   14,    3,    1,    0,//14
     0,    0,    0,    0,    0,    5,    3,    0,    0,    0,    0,    3,
     8,    9,    0,    0,    0,    0,    0,    1,    1,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    0,    7,    2,    0,//15
     0,    0,    0,    0,    0,    3,    2,    0,    0,    0,    0,    0,
     0,    3,    0,    0,    0,    0,    0,    4,    6,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,    3,    1,    0,    0,//16
     0,    0,    0,    0,    0,    0,    0,    0,    3,    3,    0,    0,
     0,    0,    6,   16,   12,   16,    3,    0,    1,    2,    0,    0,
     0,    0,    0,    0,    0,    5,    2,    0,    5,    2,    0,    0,//17
     0,    0,    0,    0,    0,    0,    0,    4,    5,    7,    8,    5,
     4,   11,   36,   74,  164,  192,   69,   20,    4,    7,    0,    0,
     0,    0,    0,    0,    0,    7,    3,    0,    0,    0,    0,    0,//18
     2,    2,    3,    1,    3,    7,    9,   23,   37,   57,   40,   35,
    62,  161,  397,  884, 1539, 1299,  524,  153,   31,    8,    0,    0,
     0,    1,    6,    0,    0,    5,    3,    0,    0,    0,    0,    0,//19
    16,   22,   24,   18,   31,   41,   55,  135,  119,  122,  187,  269,
   365,  760, 1462, 2646, 4068, 2973, 1140,  323,   91,   27,    2,    0,
     1,    2,   16,    2,   20,   13,   11,    2,    8,    9,    5,    2,//20
    65,  105,  141,   97,  107,  112,  206,  297,  260,  302,  376,  583,
   976, 1843, 3301, 4919, 5142, 3134, 1234,  421,  112,   36,   12,    2,
     5,   15,    9,    9,   13,   42,   22,   11,   15,   40,   34,   36,//21
   215,  326,  337,  260,  286,  224,  427,  636,  531,  416,  627, 1304,
  2420, 4039, 5543, 6810, 6445, 3344, 1056,  322,  109,   11,   10,   11,
    15,   17,    3,   19,   33,   92,   76,   61,   39,   78,  103,  174,//22
   807,  852,  845,  653,  539,  340,  574, 1144, 1005,  652,  999, 2377,
  5342, 8103, 7864, 7454, 6508, 3025,  893,  281,  109,   29,   13,   17,
    29,   18,   15,   42,   72,   91,  122,  192,  213,  318,  367,  670,//23
  1774, 1897, 1793, 1122,  556,  188,  227,  471,  600,  823, 1461, 3182,
  7185,10522, 7989, 5999, 4607, 1941,  688,  286,  147,   58,   60,   21,
    49,   29,   27,   68,   76,  128,  222,  341,  383,  670, 1032, 1362,//24
  2961, 3726, 2711, 1208,  435,  157,  106,   90,  221,  646, 1795, 4095,
  8039, 9609, 6837, 4629, 3183, 1428,  604,  199,   87,   32,   29,    7,
    19,   30,   48,   55,   93,  136,  278,  545,  710, 1067, 1726, 2191,//25
  5516, 5175, 2490,  769,  268,  141,  209,  303,  458,  875, 2273, 4174,
  6766, 7542, 5419, 3686, 2828, 1522,  709,  257,   65,   18,   29,    8,
    15,   30,   19,   34,   83,  147,  324, 1002, 1361, 1833, 2523, 3674,//26
  7319, 4002, 1093,  251,  193,  284,  568,  878, 1058, 1420, 2200, 3704,
  5133, 6007, 4894, 3567, 3106, 1918,  926,  405,   72,    4,    4,    6,
     4,   31,    3,    7,   51,  130,  424, 1324, 2216, 3224, 4255, 6717,//27
  4905, 1403,  224,   68,   80,  205,  495,  811,  922,  945, 1401, 2495,
  4199, 6009, 5594, 5039, 4551, 2869,  990,  337,   49,    5,    0,    0,
     0,    2,    0,    2,   39,  113,  547, 2674, 6560, 7703, 7839, 8289,//28
  1646,  228,   24,   16,   11,   52,   44,   93,  153,  115,  312, 1043,
  2929, 6120, 7732, 6801, 4734, 1953,  396,   36,    4,    1,    0,    0,
     0,    0,    5,    3,   12,   65, 1086,21027,57767,28567,15321, 8073,//29
   188,   23,    3,    0,    5,    3,    0,    2,   15,   23,   40,  295,
  1803, 5781, 7356, 4257, 1641,  351,   28,    4,    0,    0,    0,    0,
     6,    5,    2,    3,   14,   74, 2655,49493,86255,29323,10531, 2193,//30
     5,    4,    3,    0,    0,    0,    0,    0,    0,    6,    6,   85,
   795, 2705, 2139,  709,   97,    7,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    2,   14,   85, 1433,10936,11859, 4044,  687,   60,//31
     0,    0,    0,    0,    0,    0,    0,    0,    0,    5,    4,   39,
   187,  346,  118,   18,    3,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    1,   17,   48,  323,  729,  469,  110,    5,    2,//32
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,   17,
    36,   15,    1,    4,    7,    0,    0,    0,    0,    0,    0,    0,
     4,    3,    0,    2,   12,   25,   26,   41,    8,    4,   15,    1,//33
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    6,    6,
    18,    4,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     3,    2,    0,    0,    0,    7,    3,   13,    0,    0,    2,    0,//34
     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,   12,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    4,    2,    6,    0,    0,    0,    0,//35
  };

  int rama5_data_size = 72;
  ftype32 rama5_gly[] = {
  // 0
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 1
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 2
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 3
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 4
  0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 5
  0,0,0,0,0,0,0,1,3,4,5,4,4,3,2,1,1,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,1,2,3,4,5,5,3,2,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 6
  0,0,0,0,1,4,7,12,16,18,17,14,10,7,4,3,2,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,1,1,2,4,7,10,13,15,14,10,5,2,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 7
  0,0,2,5,12,21,35,51,61,62,53,40,25,15,8,4,2,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
  1,1,1,2,4,8,14,21,28,33,34,30,22,12,5,2,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 8
  1,5,12,25,44,75,117,157,178,175,145,111,84,30,14,6,3,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,
  2,3,5,9,15,24,35,48,58,63,62,55,40,23,11,4,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 9
  10,22,43,74,121,192,279,346,381,402,336,227,143,56,23,9,3,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,5,
  7,11,17,26,38,53,71,90,105,121,128,100,67,41,20,8,3,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,4,
  // 10
  35,65,108,169,259,374,560,622,689,668,551,400,230,102,35,12,3,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,4,8,13,
  20,30,43,59,78,98,137,164,193,228,188,137,103,65,34,14,5,1,
  0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,3,6,16,
  // 11
  96,147,220,318,465,682,931,1045,1207,1190,812,494,305,135,80,14,3,1,
  0,0,0,0,0,0,0,0,0,0,0,1,2,4,8,13,21,33,
  48,80,91,114,138,160,205,248,291,319,234,224,167,89,44,20,8,3,
  1,0,0,0,0,0,0,0,1,1,1,1,2,3,4,10,24,58,
  // 12
  202,282,397,606,852,1104,1390,1687,1973,2022,1179,573,352,158,52,15,4,1,
  0,0,0,0,0,0,0,0,0,1,2,3,7,13,21,34,60,74,
  102,181,167,193,221,306,391,445,331,346,251,204,183,95,49,24,11,5,
  2,1,1,1,2,2,2,2,2,2,3,3,4,7,14,32,69,133,
  // 13
  375,506,662,940,1119,1290,1398,1690,2039,1881,1042,595,312,140,48,14,4,1,
  1,1,1,1,1,0,0,0,1,3,6,11,19,31,48,73,116,136,
  169,304,324,369,379,402,405,379,321,295,251,213,183,127,50,25,14,9,
  4,3,3,4,5,5,6,6,6,6,7,8,11,20,42,85,152,246,
  // 14
  609,800,1069,1226,1286,1271,1376,1477,1329,1078,715,462,246,114,37,12,5,3,
  2,3,3,3,3,2,2,3,5,9,16,26,41,61,95,156,164,218,
  283,435,431,536,475,407,399,321,294,260,216,183,146,105,58,25,22,19,
  6,5,6,7,9,9,10,10,10,11,12,15,25,49,97,173,280,435,
  // 15
  966,1261,1585,1748,1363,1171,1121,1041,860,687,480,340,178,87,24,10,5,5,
  5,5,6,6,6,6,6,7,12,20,32,49,73,103,148,258,253,372,
  408,525,541,559,550,499,389,326,301,266,226,153,104,61,40,35,21,14,
  7,8,9,11,12,13,14,14,15,16,19,28,50,97,177,298,483,753,
  // 16
  1481,1628,1517,1393,1176,1029,881,687,567,447,294,182,93,45,17,9,7,7,
  7,8,10,11,11,11,12,15,22,41,52,80,158,212,215,322,372,439,
  558,560,591,509,472,439,323,264,247,183,160,140,94,57,39,67,24,10,
  9,9,12,15,16,16,52,17,18,21,28,45,85,159,273,447,670,1042,
  // 17
  1415,1475,1546,1259,1001,793,550,414,318,254,153,82,45,40,21,9,8,9,
  10,12,14,16,18,18,20,24,37,78,83,118,173,226,295,418,502,540,
  485,432,562,535,414,347,268,278,200,174,133,103,61,54,37,46,38,16,
  9,10,14,17,17,19,35,22,47,26,38,66,123,230,407,608,858,1192,
  // 18
  1393,1359,1277,988,726,527,395,285,166,106,63,60,28,20,13,9,11,12,
  14,16,18,22,24,25,28,41,68,88,116,153,184,261,331,379,421,477,
  576,441,419,361,308,344,244,227,163,132,106,61,48,43,34,24,21,12,
  9,9,12,14,49,16,22,19,66,30,47,84,180,294,510,721,1014,1286,
  // 19
  1058,958,910,751,502,342,246,148,86,52,28,21,20,13,9,11,14,16,
  37,20,25,34,45,34,34,56,112,99,117,176,242,315,329,341,328,354,
  478,430,407,312,247,207,168,178,141,98,72,55,48,40,31,22,14,10,
  8,7,8,9,10,11,14,32,25,33,53,97,209,355,668,852,1018,1065,
  // 20
  805,696,619,469,329,225,150,102,52,32,17,16,19,13,9,13,16,19,
  29,21,27,35,43,35,49,91,106,102,142,192,193,337,342,281,272,322,
  360,332,268,234,207,186,149,114,98,80,68,81,49,39,26,18,19,15,
  7,5,5,5,7,9,14,29,23,33,54,93,169,374,575,832,819,831,
  // 21
  572,548,395,308,278,176,92,45,27,17,12,10,10,9,9,16,27,18,
  19,35,35,28,30,44,48,60,61,86,116,232,179,253,292,269,268,317,
  294,248,247,200,183,168,135,153,113,96,60,53,48,38,23,16,22,17,
  5,3,3,3,4,7,15,21,21,30,50,84,151,298,484,530,546,633,
  // 22
  379,320,280,235,193,101,55,27,17,12,9,8,8,8,9,16,28,15,
  16,17,28,50,29,48,45,53,69,94,106,111,143,213,188,214,189,207,
  256,243,202,182,177,135,136,133,119,87,82,58,50,46,55,29,19,6,
  3,2,1,2,3,5,10,14,17,26,42,97,129,223,343,355,427,404,
  // 23
  261,210,160,122,98,57,32,19,18,22,10,8,7,7,8,9,10,11,
  13,16,19,21,24,29,34,38,52,60,81,93,133,193,166,194,165,196,
  192,167,203,171,153,129,130,131,115,81,58,63,53,34,20,17,10,4,
  2,1,1,2,3,4,6,9,13,21,35,77,103,184,216,206,234,243,
  // 24
  130,112,111,75,51,34,22,15,16,19,9,7,7,6,6,7,7,9,
  11,13,16,19,21,24,29,32,50,63,97,83,99,164,146,210,163,176,
  179,191,204,185,164,131,135,132,105,104,62,60,53,34,20,9,5,3,
  2,1,1,2,2,4,5,7,18,45,27,46,98,82,108,137,163,193,
  // 25
  88,76,55,43,32,22,16,12,9,8,7,6,6,5,5,5,9,15,
  10,11,13,15,17,19,29,34,33,40,55,70,85,105,109,132,185,212,
  162,154,198,189,165,171,132,157,107,81,59,45,33,22,13,8,5,3,
  1,1,1,2,2,3,4,6,9,14,35,45,42,64,102,101,102,111,
  // 26
  70,52,35,30,26,17,11,9,8,6,6,5,4,4,3,4,9,17,
  10,9,11,12,14,15,24,32,58,42,44,57,105,101,123,153,151,207,
  167,172,201,224,212,198,206,160,117,88,61,44,32,24,12,7,4,2,
  1,1,1,2,2,2,3,5,9,13,17,23,32,75,73,76,61,81,
  // 27
  34,29,24,24,22,14,8,6,6,5,4,3,3,2,2,2,3,5,
  6,7,8,9,10,12,14,20,25,27,33,44,58,73,94,124,119,195,
  198,216,204,227,253,203,180,153,119,93,59,38,32,33,12,6,3,2,
  1,1,1,2,2,2,21,8,9,12,16,47,26,83,43,45,45,41,
  // 28
  23,20,17,16,13,8,6,4,4,3,3,2,2,1,1,2,2,3,
  5,6,7,7,8,9,12,15,19,23,29,39,52,67,85,125,135,166,
  262,215,202,197,185,183,167,137,167,86,52,37,23,17,8,5,3,1,
  1,1,2,2,2,2,15,7,9,13,17,29,22,25,29,33,34,30,
  // 29
  15,13,13,11,7,5,4,2,2,2,1,1,1,1,1,1,2,3,
  4,5,6,6,6,7,10,13,17,21,28,50,65,103,124,116,142,183,
  216,202,255,203,213,187,191,130,124,74,43,46,26,11,6,3,2,1,
  1,1,2,3,3,3,4,6,9,12,16,18,19,19,20,23,26,21,
  // 30
  9,7,21,18,3,2,2,1,1,1,0,0,0,0,1,1,2,3,
  4,5,5,5,5,5,8,11,15,19,28,49,82,81,97,135,197,270,
  252,273,276,240,244,209,163,166,111,62,38,24,14,8,4,2,1,1,
  1,2,2,3,3,4,4,6,7,10,12,14,14,13,12,15,16,14,
  // 31
  4,3,3,2,1,1,0,0,0,0,0,0,0,0,0,1,2,3,
  3,4,4,5,4,5,7,9,13,18,26,41,62,98,109,153,194,320,
  305,309,288,271,260,217,174,130,80,76,50,19,11,6,3,1,1,1,
  1,2,3,3,4,4,5,5,6,6,8,9,9,8,8,8,12,6,
  // 32
  3,2,1,1,1,0,0,0,0,0,0,0,0,0,0,1,2,2,
  3,3,3,27,11,5,6,9,12,18,27,51,71,101,133,168,239,292,
  314,351,341,386,303,213,211,144,68,47,28,16,10,5,3,1,1,1,
  1,2,3,4,4,4,39,5,4,4,4,5,5,4,4,4,32,5,
  // 33
  2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,2,2,
  3,3,3,4,4,5,7,9,13,19,30,51,71,98,141,212,276,334,
  338,362,362,396,338,226,198,126,65,39,24,15,10,6,4,2,1,1,
  1,2,3,3,4,4,5,4,3,3,2,2,2,2,2,2,2,2,
  // 34
  1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,2,
  2,3,3,5,6,8,8,10,14,20,32,50,79,147,170,236,292,307,
  424,431,387,349,233,176,164,93,61,37,23,15,11,8,5,3,1,1,
  1,1,2,3,3,3,3,3,2,2,1,1,1,1,1,1,1,1,
  // 35
  1,1,1,1,1,1,1,0,0,0,35,0,0,0,1,1,1,2,
  2,2,3,6,10,11,11,12,17,31,64,81,82,173,229,324,379,467,
  529,415,378,362,272,199,112,72,51,39,22,15,12,11,8,5,2,1,
  1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,
  // 36
  1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,
  1,2,3,6,11,13,13,14,23,43,56,59,88,138,206,372,381,418,
  611,418,381,372,206,138,88,59,56,43,23,14,13,13,11,6,3,2,
  1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,
  // 37
  1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,
  1,1,2,5,8,11,12,15,22,39,51,72,112,199,272,362,378,415,
  529,467,379,324,229,173,82,81,64,31,17,12,11,11,10,6,3,2,
  2,2,1,1,1,0,0,0,35,0,0,0,1,1,1,1,1,1,
  // 38
  1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,2,1,
  1,1,1,3,5,8,11,15,23,37,61,93,164,176,233,350,387,431,
  424,307,292,236,170,147,79,50,32,20,14,10,8,8,6,5,3,3,
  2,2,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,
  // 39
  2,2,2,2,2,2,2,2,2,3,3,4,5,4,4,3,3,2,
  1,1,1,2,4,6,10,15,24,39,65,126,198,226,338,396,362,362,
  338,334,276,212,141,98,71,51,30,19,13,9,7,5,4,4,3,3,
  3,2,2,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,
  // 40
  3,5,32,4,4,4,5,5,4,4,4,5,39,4,4,4,3,2,
  1,1,1,1,3,5,10,16,28,47,68,144,211,213,303,386,341,351,
  314,292,239,168,133,101,71,51,27,18,12,9,6,5,11,27,3,3,
  3,2,2,1,0,0,0,0,0,0,0,0,0,0,1,1,1,2,
  // 41
  4,6,12,8,8,8,9,9,8,6,6,5,5,4,4,3,3,2,
  1,1,1,1,3,6,11,19,50,76,80,130,174,217,260,271,288,309,
  305,320,194,153,109,98,62,41,26,18,13,9,7,5,4,5,4,4,
  3,3,2,1,0,0,0,0,0,0,0,0,0,1,1,2,3,3,
  // 42
  9,14,16,15,12,13,14,14,12,10,7,6,4,4,3,3,2,2,
  1,1,1,2,4,8,14,24,38,62,111,166,163,209,244,240,276,273,
  252,270,197,135,97,81,82,49,28,19,15,11,8,5,5,5,5,5,
  4,3,2,1,1,0,0,0,0,1,1,1,2,2,3,18,21,7,
  // 43
  15,21,26,23,20,19,19,18,16,12,9,6,4,3,3,3,2,1,
  1,1,2,3,6,11,26,46,43,74,124,130,191,187,213,203,255,202,
  216,183,142,116,124,103,65,50,28,21,17,13,10,7,6,6,6,5,
  4,3,2,1,1,1,1,1,1,2,2,2,4,5,7,11,13,13,
  // 44
  23,30,34,33,29,25,22,29,17,13,9,7,15,2,2,2,2,1,
  1,1,3,5,8,17,23,37,52,86,167,137,167,183,185,197,202,215,
  262,166,135,125,85,67,52,39,29,23,19,15,12,9,8,7,7,6,
  5,3,2,2,1,1,2,2,3,3,4,4,6,8,13,16,17,20,
  // 45
  34,41,45,45,43,83,26,47,16,12,9,8,21,2,2,2,1,1,
  1,2,3,6,12,33,32,38,59,93,119,153,180,203,253,227,204,216,
  198,195,119,124,94,73,58,44,33,27,25,20,14,12,10,9,8,7,
  6,5,3,2,2,2,3,3,4,5,6,6,8,14,22,24,24,29,
  // 46
  70,81,61,76,73,75,32,23,17,13,9,5,3,2,2,2,1,1,
  1,2,4,7,12,24,32,44,61,88,117,160,206,198,212,224,201,172,
  167,207,151,153,123,101,105,57,44,42,58,32,24,15,14,12,11,9,
  10,17,9,4,3,4,4,5,6,6,8,9,11,17,26,30,35,52,
  // 47
  88,111,102,101,102,64,42,45,35,14,9,6,4,3,2,2,1,1,
  1,3,5,8,13,22,33,45,59,81,107,157,132,171,165,189,198,154,
  162,212,185,132,109,105,85,70,55,40,33,34,29,19,17,15,13,11,
  10,15,9,5,5,5,6,6,7,8,9,12,16,22,32,43,55,76,
  // 48
  130,193,163,137,108,82,98,46,27,45,18,7,5,4,2,2,1,1,
  2,3,5,9,20,34,53,60,62,104,105,132,135,131,164,185,204,191,
  179,176,163,210,146,164,99,83,97,63,50,32,29,24,21,19,16,13,
  11,9,7,7,6,6,7,7,9,19,16,15,22,34,51,75,111,112,
  // 49
  261,243,234,206,216,184,103,77,35,21,13,9,6,4,3,2,1,1,
  2,4,10,17,20,34,53,63,58,81,115,131,130,129,153,171,203,167,
  192,196,165,194,166,193,133,93,81,60,52,38,34,29,24,21,19,16,
  13,11,10,9,8,7,7,8,10,22,18,19,32,57,98,122,160,210,
  // 50
  379,404,427,355,343,223,129,97,42,26,17,14,10,5,3,2,1,2,
  3,6,19,29,55,46,50,58,82,87,119,133,136,135,177,182,202,243,
  256,207,189,214,188,213,143,111,106,94,69,53,45,48,29,50,28,17,
  16,15,28,16,9,8,8,8,9,12,17,27,55,101,193,235,280,320,
  // 51
  572,633,546,530,484,298,151,84,50,30,21,21,15,7,4,3,3,3,
  5,17,22,16,23,38,48,53,60,96,113,153,135,168,183,200,247,248,
  294,317,268,269,292,253,179,232,116,86,61,60,48,44,30,28,35,35,
  19,18,27,16,9,9,10,10,12,17,27,45,92,176,278,308,395,548,
  // 52
  805,831,819,832,575,374,169,93,54,33,23,29,14,9,7,5,5,5,
  7,15,19,18,26,39,49,81,68,80,98,114,149,186,207,234,268,332,
  360,322,272,281,342,337,193,192,142,102,106,91,49,35,43,35,27,21,
  29,19,16,13,9,13,19,16,17,32,52,102,150,225,329,469,619,696,
  // 53
  1058,1065,1018,852,668,355,209,97,53,33,25,32,14,11,10,9,8,7,
  8,10,14,22,31,40,48,55,72,98,141,178,168,207,247,312,407,430,
  478,354,328,341,329,315,242,176,117,99,112,56,34,34,45,34,25,20,
  37,16,14,11,9,13,20,21,28,52,86,148,246,342,502,751,910,958,
  // 54
  1393,1286,1014,721,510,294,180,84,47,30,66,19,22,16,49,14,12,9,
  9,12,21,24,34,43,48,61,106,132,163,227,244,344,308,361,419,441,
  576,477,421,379,331,261,184,153,116,88,68,41,28,25,24,22,18,16,
  14,12,11,9,13,20,28,60,63,106,166,285,395,527,726,988,1277,1359,
  // 55
  1415,1192,858,608,407,230,123,66,38,26,47,22,35,19,17,17,14,10,
  9,16,38,46,37,54,61,103,133,174,200,278,268,347,414,535,562,432,
  485,540,502,418,295,226,173,118,83,78,37,24,20,18,18,16,14,12,
  10,9,8,9,21,40,45,82,153,254,318,414,550,793,1001,1259,1546,1475,
  // 56
  1481,1042,670,447,273,159,85,45,28,21,18,17,52,16,16,15,12,9,
  9,10,24,67,39,57,94,140,160,183,247,264,323,439,472,509,591,560,
  558,439,372,322,215,212,158,80,52,41,22,15,12,11,11,11,10,8,
  7,7,7,9,17,45,93,182,294,447,566,687,880,1029,1175,1393,1517,1628,
  // 57
  966,753,483,298,177,97,50,28,19,16,15,14,14,13,12,11,9,8,
  7,14,21,35,40,61,104,153,226,266,301,326,389,499,550,559,541,525,
  408,372,253,258,148,103,73,49,32,20,12,7,6,6,6,6,6,5,
  5,5,5,10,24,87,178,340,480,687,860,1040,1120,1170,1362,1748,1585,1261,
  // 58
  609,435,280,173,97,49,25,15,12,11,10,10,10,9,9,7,6,5,
  6,19,22,25,58,105,146,183,216,260,294,321,399,407,475,536,431,435,
  283,218,164,156,95,61,41,26,16,9,5,3,2,2,3,3,3,3,
  2,3,5,12,37,114,246,462,714,1078,1329,1476,1375,1271,1285,1226,1069,800,
  // 59
  375,246,152,85,42,20,11,8,7,6,6,6,6,5,5,4,3,3,
  4,9,14,25,50,127,183,213,251,295,321,379,405,402,379,369,324,304,
  169,136,116,73,48,31,19,11,6,3,1,0,0,0,1,1,1,1,
  1,1,4,14,48,140,312,595,1041,1881,2038,1689,1397,1289,1118,940,662,506,
  // 60
  202,133,69,32,14,7,4,3,3,2,2,2,2,2,2,1,1,1,
  2,5,11,24,49,95,183,204,251,346,331,445,391,306,221,193,167,181,
  102,74,60,34,21,13,7,3,2,1,0,0,0,0,0,0,0,0,
  0,1,4,15,52,158,352,573,1178,2021,1972,1686,1389,1103,852,606,397,282,
  // 61
  96,58,24,10,4,3,2,1,1,1,1,0,0,0,0,0,0,0,
  1,3,8,20,44,89,167,224,234,319,291,248,205,160,138,114,91,80,
  48,33,21,13,8,4,2,1,0,0,0,0,0,0,0,0,0,0,
  0,1,3,14,80,135,305,494,812,1190,1206,1044,930,681,464,318,220,147,
  // 62
  35,16,6,3,2,1,1,1,0,0,0,0,0,0,0,0,0,0,
  0,1,5,14,34,65,103,137,188,228,193,164,137,98,78,59,43,30,
  20,13,8,4,2,1,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,3,12,35,102,230,400,551,668,688,622,560,374,259,169,108,65,
  // 63
  10,4,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,3,8,20,41,67,100,128,121,105,90,71,53,38,26,17,11,
  7,5,3,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,3,9,23,56,143,227,336,402,381,346,279,191,121,74,43,22,
  // 64
  1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,1,4,11,23,40,55,62,63,58,48,35,24,15,9,5,3,
  2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,3,6,14,30,84,111,145,175,178,157,117,75,44,25,12,5,
  // 65
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,2,5,12,22,30,34,33,28,21,14,8,4,2,1,1,
  1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,2,4,8,15,25,40,53,62,61,51,35,21,12,5,2,0,
  // 66
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,2,5,10,14,15,13,10,7,4,2,1,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,2,3,4,7,10,14,17,18,16,12,7,4,1,0,0,0,
  // 67
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,2,3,5,5,4,3,2,1,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,1,1,2,3,4,4,5,4,3,1,0,0,0,0,0,0,
  // 68
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,
  // 69
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 70
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 71
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  };
  ftype32 rama5_pro[] = {
  // 0
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 1
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 2
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 3
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 4
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 5
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 6
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 7
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 8
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 9
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 10
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 11
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 12
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 13
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 14
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 15
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 16
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 17
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 18
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 19
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 20
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 21
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 22
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 23
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 24
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 25
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 26
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 27
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 28
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 29
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 30
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 31
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 32
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 33
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 34
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 35
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 36
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 37
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 38
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 39
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 40
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 41
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 42
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 43
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 44
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 45
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 46
  0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 47
  1,1,2,2,3,3,4,4,4,4,3,2,1,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,1,2,2,3,3,3,3,3,
  2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 48
  7,8,9,10,10,10,10,10,8,7,6,4,3,1,0,0,0,0,
  0,0,0,0,0,0,1,2,3,4,5,6,8,10,11,11,10,9,
  7,5,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,5,
  // 49
  24,26,26,26,26,24,22,18,15,11,9,7,5,3,2,0,0,0,
  0,0,0,0,1,3,5,7,8,10,13,16,20,24,26,26,24,21,
  16,12,8,4,2,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,1,2,5,8,14,19,
  // 50
  56,59,59,56,51,45,38,30,23,17,13,49,51,8,6,4,2,0,
  0,0,1,3,6,9,13,17,20,24,31,40,49,56,60,58,53,44,
  34,24,16,9,4,1,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,1,4,9,17,27,40,50,
  // 51
  112,111,105,95,83,71,57,45,34,27,23,46,49,24,22,17,11,7,
  4,4,5,9,15,22,30,37,45,56,73,94,114,129,135,128,114,94,
  70,47,29,16,8,4,1,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,1,5,14,27,45,68,90,105,
  // 52
  200,197,178,139,116,96,76,61,48,42,42,47,53,56,52,44,33,24,
  17,14,16,23,33,45,60,76,97,127,167,212,253,281,288,271,235,186,
  134,87,52,29,15,7,4,2,1,1,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,1,6,17,36,66,106,147,177,194,
  // 53
  549,301,257,189,146,114,90,73,63,61,69,82,95,101,98,84,67,51,
  38,32,34,43,60,82,111,149,202,344,415,452,529,573,572,523,439,336,
  233,148,85,47,25,13,7,4,3,2,1,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,2,7,19,46,91,156,230,291,326,332,
  // 54
  440,356,283,253,180,120,95,80,74,81,99,121,142,157,156,136,106,81,
  63,54,56,70,96,135,192,273,388,538,712,887,1019,1156,1059,910,834,539,
  485,223,128,67,35,18,10,6,4,3,1,1,1,1,1,1,1,1,
  0,0,0,0,0,0,0,3,10,27,64,129,224,341,453,604,589,517,
  // 55
  596,432,308,236,161,113,89,129,110,174,122,151,180,302,301,181,142,106,
  85,74,78,98,138,206,312,471,695,1058,1289,1616,1869,1981,1657,1392,1115,844,
  507,316,196,94,43,22,12,8,5,3,2,1,1,2,2,2,2,1,
  0,0,0,0,0,0,4,15,46,110,216,363,533,697,818,906,881,776,
  // 56
  721,493,320,204,133,93,74,88,85,134,131,190,206,269,337,202,159,119,
  96,87,94,122,185,297,481,766,1192,1752,2124,2509,2701,2849,2510,2098,1523,1066,
  624,413,247,110,46,23,12,8,6,3,2,1,2,2,3,3,2,2,
  1,0,0,0,0,5,20,69,179,356,610,867,1104,1276,1381,1386,1267,1001,
  // 57
  817,526,303,171,100,66,54,55,67,91,123,226,262,227,290,184,148,113,
  93,88,100,148,249,414,730,1187,1810,2681,3165,3521,3561,3703,3479,2832,1876,1126,
  690,492,243,105,43,20,11,7,5,3,2,1,2,2,3,3,3,2,
  1,0,0,0,4,20,77,218,468,815,1263,1639,1911,2046,2116,1977,1623,1168,
  // 58
  872,555,348,126,64,39,34,38,51,72,99,125,144,153,153,139,115,91,
  78,77,96,172,315,547,1052,1676,2350,3241,4104,4390,4452,4223,4187,3139,1965,1186,
  673,362,184,78,33,15,8,5,3,2,1,1,1,2,3,3,2,2,
  1,0,0,2,13,59,192,465,892,1424,1979,2471,2875,3010,2804,2445,2093,1463,
  // 59
  781,440,195,79,33,19,18,23,34,49,67,85,98,102,99,88,74,61,
  55,59,85,168,342,643,1264,2006,2729,4348,5144,5262,5401,4751,3633,2907,1712,1047,
  571,284,129,53,21,10,6,3,2,1,0,0,1,2,2,2,2,1,
  0,0,0,5,31,121,344,753,1341,2021,2903,3684,4287,4109,3624,2862,1957,1231,
  // 60
  603,306,120,41,14,8,8,13,19,27,37,47,53,55,53,47,39,34,
  33,40,70,154,339,679,1266,2017,2892,4099,4624,5144,4698,3924,3003,2018,1331,791,
  408,188,78,29,11,5,3,1,0,0,0,0,0,1,1,1,1,0,
  0,0,1,10,53,186,479,979,1680,2519,3559,4542,4411,3925,3198,2384,1673,1038,
  // 61
  390,167,58,16,5,3,4,6,9,13,17,20,22,22,21,18,16,15,
  16,24,54,136,315,639,1172,1809,2626,3504,3932,4174,3645,3010,2225,1429,889,491,
  236,99,37,13,5,2,1,0,0,0,0,0,0,0,0,0,0,0,
  0,0,2,16,72,226,545,1091,1862,2726,3711,4199,4050,3519,2733,1944,1282,757,
  // 62
  204,73,21,5,1,1,2,3,4,5,5,6,7,6,5,5,4,5,
  7,14,39,107,257,525,1089,1532,2111,2774,2967,2742,2357,1871,1349,870,497,248,
  106,39,13,5,2,1,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,4,20,77,226,532,1047,1936,2975,3469,3210,3129,2600,2046,1379,851,456,
  // 63
  77,22,4,0,0,0,1,1,1,1,1,1,1,1,0,0,1,2,
  3,9,26,73,180,372,803,1081,1407,1849,1755,1661,1415,1076,722,422,214,92,
  34,11,4,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,5,21,69,188,412,863,1440,1763,1987,2118,2015,1697,1254,811,452,210,
  // 64
  17,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,5,16,44,106,220,392,594,801,934,965,881,704,491,294,149,64,23,
  7,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,6,19,53,133,281,501,773,1044,1236,1288,1172,926,629,362,172,63,
  // 65
  1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,2,8,23,52,107,191,290,379,431,425,361,262,160,81,34,11,3,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,5,15,36,81,162,279,418,547,624,618,524,375,221,106,38,9,
  // 66
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,3,10,22,42,73,109,139,150,137,104,66,34,13,4,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,4,11,23,44,79,128,182,226,240,218,164,100,48,17,4,0,
  // 67
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,1,4,8,14,21,30,35,36,30,20,11,4,1,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,3,7,13,22,35,50,63,70,66,52,32,15,6,2,0,0,
  // 68
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,1,2,4,5,6,6,6,5,3,2,1,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,1,3,6,10,14,17,18,16,12,7,3,1,0,0,0,0,
  // 69
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,1,3,4,5,5,4,3,1,0,0,0,0,0,0,0,
  // 70
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,
  // 71
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  };
  ftype32 rama5_ngp[] = {
  // 0
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 1
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 2
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 3
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 4
  0,0,0,0,0,0,0,0,1,2,2,3,3,2,1,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 5
  0,0,0,0,0,0,1,3,5,7,9,10,9,7,4,2,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 6
  0,0,0,0,1,3,7,13,19,23,24,24,21,15,9,5,3,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,1,1,1,1,1,7,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 7
  0,0,0,2,6,13,24,35,45,51,57,46,37,26,17,9,5,2,
  1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,1,1,2,2,2,2,2,1,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 8
  0,1,4,10,19,34,53,71,89,90,96,86,65,42,27,14,7,3,
  1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,1,5,3,3,4,4,4,3,2,1,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 9
  2,6,12,24,41,65,91,114,140,147,142,121,97,58,39,18,9,4,
  2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,1,1,2,7,4,6,9,6,5,4,3,2,1,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 10
  7,14,26,43,68,101,130,158,208,235,211,149,129,73,46,22,10,5,
  2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,1,1,2,3,5,6,13,16,8,7,6,4,3,2,1,
  0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,3,
  // 11
  14,25,41,64,102,148,206,247,317,288,202,153,108,68,41,19,9,4,
  2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,1,1,1,2,2,4,5,6,13,19,9,9,8,4,3,2,1,
  0,0,0,0,1,1,2,2,1,1,1,1,1,1,1,1,3,7,
  // 12
  21,36,56,95,144,181,210,250,245,212,173,128,80,53,38,20,8,4,
  2,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,3,
  5,1,1,2,5,4,3,5,6,7,9,9,8,6,4,3,2,1,
  0,0,0,1,1,2,3,3,3,2,2,7,1,1,2,6,7,12,
  // 13
  28,48,76,105,132,167,174,181,170,142,112,83,55,33,19,12,7,3,
  2,1,1,1,1,1,0,0,0,0,0,0,0,2,1,0,1,1,
  5,1,1,1,2,2,3,3,4,5,7,8,6,4,3,2,1,1,
  0,0,1,1,2,5,6,5,4,3,3,3,2,2,3,7,12,16,
  // 14
  32,51,73,92,98,125,122,123,109,91,69,48,31,18,10,6,3,2,
  1,1,1,1,1,1,1,1,0,0,0,0,0,4,1,1,3,1,
  5,1,1,1,1,2,2,2,3,3,4,4,3,3,2,1,1,0,
  0,0,1,1,2,5,7,6,5,4,3,2,2,3,4,6,16,19,
  // 15
  38,41,55,57,70,87,73,70,58,47,34,23,13,8,9,3,2,1,
  1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,3,2,
  1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,0,0,
  0,0,1,1,2,3,4,5,4,4,3,2,2,3,4,6,11,24,
  // 16
  22,26,31,36,39,39,37,32,26,19,13,7,4,3,4,1,1,1,
  1,1,0,0,0,0,1,1,1,1,3,1,1,6,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,1,2,2,3,3,3,3,2,2,2,2,3,6,14,22,
  // 17
  13,16,18,20,20,18,16,12,9,5,3,2,1,1,1,1,1,0,
  0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,1,2,2,2,2,2,1,1,1,2,3,4,8,10,
  // 18
  7,8,9,9,8,7,5,3,2,1,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,1,1,1,1,1,1,0,0,1,2,3,4,6,
  // 19
  3,4,3,3,2,2,1,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,3,
  // 20
  1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,
  // 21
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 22
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 23
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 24
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 25
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 26
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 27
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 28
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 29
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 30
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 31
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 32
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 33
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,1,1,2,3,3,3,3,2,
  2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 34
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,1,1,2,3,5,7,10,11,12,11,8,
  6,4,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,
  // 35
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
  1,1,1,1,1,1,2,3,4,7,11,16,21,27,30,30,27,22,
  16,10,5,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,
  // 36
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,
  2,2,2,3,3,4,5,8,12,18,26,37,49,60,67,68,59,47,
  34,22,12,6,3,1,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 37
  0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,3,3,4,
  4,5,6,6,7,10,13,19,29,40,57,75,96,122,126,128,107,86,
  63,42,23,12,6,3,1,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 38
  1,1,1,1,1,1,1,1,1,1,2,2,4,5,6,6,7,11,
  13,9,11,12,15,19,26,38,59,75,107,137,167,208,208,205,196,141,
  101,69,39,20,11,5,3,1,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 39
  2,2,3,3,3,3,3,3,3,3,4,12,8,10,10,13,16,14,
  15,16,22,25,27,36,49,65,91,127,171,229,296,332,361,353,264,218,
  137,93,56,31,15,8,4,2,1,0,0,0,0,0,0,0,0,0,
  0,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,1,
  // 40
  4,5,6,6,7,7,7,6,5,6,7,9,12,22,32,18,19,29,
  24,24,29,37,54,78,84,108,146,215,278,328,381,429,457,434,342,261,
  180,105,76,45,25,12,11,3,1,0,0,0,0,0,0,0,0,1,
  1,1,1,1,2,2,1,1,1,1,1,1,1,1,2,2,3,3,
  // 41
  8,10,11,12,12,12,12,14,13,14,12,15,19,27,31,29,28,32,
  37,39,45,56,79,100,132,182,230,298,365,453,489,546,529,508,381,289,
  204,121,73,40,23,12,6,3,1,0,0,0,0,0,1,1,1,1,
  1,2,2,3,6,3,3,2,2,2,2,6,2,3,4,4,5,7,
  // 42
  16,18,20,21,21,20,18,23,23,22,20,25,30,40,43,50,44,43,
  45,56,66,86,117,154,195,264,328,404,484,568,599,663,613,595,435,312,
  218,126,74,44,24,14,6,3,1,1,1,1,1,1,1,1,1,1,
  2,2,3,4,9,4,4,4,4,4,4,8,5,7,7,9,11,13,
  // 43
  29,32,34,35,38,32,29,34,27,33,36,39,50,62,56,60,62,58,
  62,74,93,127,163,227,298,385,457,563,632,705,761,773,712,615,498,334,
  232,130,76,46,26,16,7,3,2,1,1,1,1,1,1,1,1,2,
  2,3,4,5,6,6,7,7,7,7,8,8,17,15,15,17,20,24,
  // 44
  49,53,55,58,71,52,49,52,46,44,41,53,61,71,77,77,90,74,
  76,102,129,173,234,329,455,547,647,719,818,893,900,863,816,673,497,332,
  213,140,75,43,25,13,7,4,2,1,1,2,2,2,2,2,2,2,
  3,4,5,7,8,9,10,10,11,12,13,15,18,23,26,30,44,44,
  // 45
  87,90,92,97,87,87,86,62,69,48,50,59,77,85,109,90,104,106,
  102,116,170,247,320,441,602,704,800,899,957,953,908,906,852,654,474,318,
  200,131,72,46,23,13,7,4,3,2,2,2,2,2,2,2,2,3,
  4,5,7,8,10,16,15,15,21,22,31,25,30,39,45,51,71,87,
  // 46
  125,134,146,142,122,117,99,72,62,59,54,62,68,86,89,87,103,118,
  119,136,190,275,387,531,719,826,938,1035,1020,961,922,873,758,604,440,298,
  186,114,65,39,22,13,8,5,3,2,2,2,2,2,2,2,3,5,
  7,6,11,10,12,16,18,23,30,33,36,41,50,60,74,102,110,118,
  // 47
  183,205,205,198,184,150,115,89,71,65,51,57,61,77,86,87,102,120,
  134,159,229,323,453,633,845,992,1098,1123,1092,975,916,833,712,568,405,264,
  164,100,58,34,21,13,8,6,4,3,3,2,4,4,3,3,4,5,
  8,8,15,14,17,22,23,31,39,47,53,60,74,83,104,138,157,163,
  // 48
  268,274,276,264,252,214,165,110,84,64,45,42,52,56,73,91,93,112,
  160,190,258,389,519,713,950,1152,1199,1156,1103,945,873,781,637,497,351,236,
  171,95,53,32,23,16,8,13,5,4,3,3,10,5,3,4,5,6,
  7,9,11,19,20,28,32,43,52,60,70,84,117,128,167,182,208,258,
  // 49
  337,366,358,347,335,227,179,124,81,63,41,35,36,41,49,62,84,99,
  149,192,294,443,598,802,1022,1212,1201,1141,1084,974,821,647,617,454,310,223,
  145,79,49,30,19,12,8,12,4,4,3,2,3,3,3,4,7,7,
  7,9,11,14,20,29,37,58,71,80,92,121,154,168,197,258,286,314,
  // 50
  461,473,471,407,331,254,204,125,76,48,41,39,34,35,42,56,77,95,
  136,205,304,453,615,808,1065,1099,1132,1117,1006,878,735,617,497,364,264,185,
  124,80,47,29,18,11,7,5,3,3,2,2,2,3,4,5,5,5,
  11,10,11,20,21,36,49,70,85,102,115,145,183,214,276,324,396,404,
  // 51
  541,533,521,421,342,247,176,111,71,47,33,33,39,38,45,61,81,105,
  153,229,327,470,604,778,927,1001,1028,998,880,762,635,554,443,355,255,181,
  117,79,47,31,18,11,6,7,3,2,2,2,2,3,4,5,4,5,
  6,9,12,18,24,40,58,81,106,134,157,192,232,277,345,406,454,498,
  // 52
  638,615,559,438,339,244,153,99,69,45,33,34,47,49,56,74,94,123,
  170,248,344,465,575,732,850,960,988,928,828,707,592,514,432,368,263,190,
  127,84,50,32,20,12,5,6,4,1,1,1,2,2,3,3,3,4,
  5,9,13,18,28,46,69,95,134,178,219,260,314,360,451,516,585,601,
  // 53
  814,726,639,464,305,192,126,76,57,39,35,46,50,59,76,91,110,146,
  178,258,339,464,571,709,859,894,952,898,795,719,610,502,436,336,262,208,
  157,96,62,32,18,9,4,4,4,1,1,1,1,1,6,5,2,3,
  4,7,10,20,31,47,82,132,210,280,340,397,468,530,554,615,720,748,
  // 54
  852,709,512,344,227,147,90,57,36,32,35,51,71,78,96,123,130,159,
  227,251,312,382,536,628,744,808,846,858,774,675,614,541,489,438,286,224,
  154,104,79,36,19,9,4,1,0,0,0,1,1,1,1,1,1,2,
  3,6,9,16,34,61,125,205,336,500,598,665,709,732,762,806,855,846,
  // 55
  774,587,424,286,174,102,58,36,28,27,41,50,70,93,110,119,120,150,
  193,219,273,360,481,558,670,741,804,827,776,728,651,584,532,446,304,229,
  159,100,63,38,18,8,3,1,0,0,0,0,0,1,1,1,1,1,
  2,6,10,18,39,89,210,437,726,978,1131,1221,1151,1058,1013,981,960,853,
  // 56
  653,464,312,199,117,65,35,24,21,21,31,36,52,70,84,96,96,112,
  133,174,216,287,383,465,590,707,785,833,789,764,703,633,547,452,333,239,
  158,98,52,31,16,7,2,0,0,0,0,0,0,0,0,0,0,1,
  1,4,9,19,56,171,440,872,1360,1764,2020,2034,1906,1590,1327,1128,1023,807,
  // 57
  540,383,230,131,71,36,19,14,14,15,20,27,36,46,55,77,71,82,
  92,131,160,215,310,406,530,694,782,850,847,806,752,669,560,471,344,230,
  152,86,43,22,13,6,1,0,0,0,0,0,0,0,0,0,0,0,
  1,3,8,25,96,330,783,1436,2174,2765,3134,3095,2745,2166,1700,1356,1078,746,
  // 58
  419,265,154,78,37,17,8,6,6,9,15,18,22,28,33,38,42,47,
  56,77,110,147,225,341,495,613,759,893,913,893,788,694,570,422,272,182,
  129,59,30,14,6,2,0,0,0,0,0,0,0,0,0,0,0,0,
  1,2,8,35,159,506,1132,1975,3103,4118,4744,4533,3614,2736,2105,1578,1098,695,
  // 59
  306,178,90,40,17,7,3,2,3,4,8,10,12,15,18,20,22,25,
  31,42,63,105,197,283,407,577,692,871,986,872,719,592,439,311,204,126,
  74,39,18,8,3,1,0,0,0,0,0,0,0,0,0,0,0,0,
  0,2,9,47,209,626,1346,2431,4229,6649,7923,6169,4175,3105,2229,1507,828,503,
  // 60
  202,102,45,17,6,2,1,1,1,1,2,3,4,6,7,8,9,11,
  14,21,37,68,122,215,323,471,611,774,747,628,522,411,334,216,138,83,
  45,22,9,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,2,9,52,223,647,1372,2484,4373,5829,5886,4645,3662,2606,1686,1025,599,365,
  // 61
  113,50,19,6,2,1,0,0,0,0,0,1,1,1,2,3,3,4,
  5,10,20,43,86,155,245,360,468,572,531,458,375,280,205,136,82,46,
  22,9,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,11,47,191,548,1175,2068,3274,4073,4070,3486,2735,1907,1190,691,395,224,
  // 62
  50,18,5,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,
  2,4,11,27,57,111,183,257,327,370,347,310,237,177,115,71,39,19,
  8,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,10,34,133,386,852,1473,2138,2530,2611,2330,1790,1198,711,397,218,112,
  // 63
  15,4,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,2,6,15,35,66,112,165,195,222,212,171,126,86,53,29,14,6,
  2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,6,21,75,215,503,860,1219,1444,1493,1293,957,611,343,183,93,42,
  // 64
  2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,3,8,19,37,66,89,110,109,104,81,57,35,19,9,3,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,4,12,36,97,225,399,560,666,668,560,391,231,123,61,27,9,
  // 65
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,2,4,9,19,30,40,47,48,42,32,20,11,5,2,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,4,6,17,40,78,138,198,231,220,172,111,63,35,14,4,1,
  // 66
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,1,2,4,8,13,16,18,17,14,9,5,2,1,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,2,3,6,13,24,40,55,61,54,40,25,13,9,2,0,0,
  // 67
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,1,2,3,5,5,5,5,3,2,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,1,2,5,7,11,13,13,11,7,4,2,1,0,0,0,
  // 68
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,1,1,2,2,1,1,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,1,2,2,3,3,3,2,1,0,0,0,0,0,0,
  // 69
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,
  // 70
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 71
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  };
  ftype32 rama5_ngl[] = {
  // 0
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 1
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 2
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 3
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 4
  0,0,0,0,0,0,0,0,1,1,2,3,3,2,1,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 5
  0,0,0,0,0,0,1,2,5,7,8,9,8,6,4,2,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 6
  0,0,0,0,1,3,7,12,18,22,23,22,19,14,9,5,2,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,1,1,1,1,1,6,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 7
  0,0,0,2,6,13,22,33,43,48,54,44,35,25,16,9,4,2,
  1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,1,1,2,2,2,2,1,1,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 8
  0,1,4,9,18,32,50,67,84,85,90,81,61,39,25,13,7,3,
  1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,1,5,2,3,4,4,3,3,2,1,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 9
  2,5,12,22,39,62,86,107,131,138,133,114,91,55,37,17,8,4,
  2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,1,1,2,7,4,6,8,6,5,4,3,2,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 10
  6,13,24,40,64,95,123,148,198,221,201,144,121,68,43,21,9,4,
  2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,1,1,2,3,4,5,12,15,8,6,5,4,3,2,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,3,
  // 11
  13,23,39,60,96,139,193,234,299,271,189,145,101,63,38,17,9,4,
  2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,1,1,1,2,2,4,5,6,12,19,8,9,8,4,3,2,1,
  0,0,0,0,1,1,1,2,1,1,1,1,1,1,1,1,3,6,
  // 12
  20,34,53,89,139,169,198,238,232,200,163,120,78,50,36,19,8,3,
  2,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,3,
  5,1,1,1,5,4,3,4,5,6,8,8,7,6,4,3,2,1,
  0,0,0,1,1,2,3,3,3,2,2,7,1,1,2,6,7,11,
  // 13
  26,45,72,100,126,157,164,172,160,133,106,79,52,31,18,11,6,3,
  1,1,1,1,1,1,0,0,0,0,0,0,0,2,0,0,1,1,
  5,1,1,1,2,2,2,3,4,5,7,7,6,4,3,2,1,1,
  0,0,1,1,2,5,6,5,4,3,2,3,2,2,3,6,12,15,
  // 14
  30,48,68,86,93,118,114,115,104,85,65,46,29,17,9,6,3,2,
  1,1,1,1,1,1,1,1,0,0,0,0,0,3,1,0,2,1,
  5,1,1,1,1,1,2,2,2,3,4,4,3,2,2,1,1,0,
  0,0,1,1,2,5,6,5,5,4,3,2,2,2,3,6,15,18,
  // 15
  36,39,52,54,66,82,69,67,55,44,33,21,13,8,8,3,2,1,
  1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,0,3,2,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,
  0,0,0,1,2,3,4,4,4,3,3,2,2,2,4,6,11,24,
  // 16
  21,24,29,34,36,37,35,30,25,18,12,7,4,3,3,1,1,1,
  1,0,0,0,0,0,1,1,1,1,2,1,1,5,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,1,2,2,3,3,3,3,2,2,2,2,3,6,15,21,
  // 17
  13,15,17,19,19,17,15,11,8,5,3,2,1,1,1,1,0,0,
  0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,1,1,2,2,2,2,1,1,1,1,2,4,7,9,
  // 18
  7,8,9,9,8,6,5,3,2,1,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,1,1,1,1,1,0,0,0,1,1,2,4,5,
  // 19
  3,3,3,3,2,1,1,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,
  // 20
  1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
  // 21
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 22
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 23
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 24
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 25
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 26
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 27
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 28
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 29
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 30
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 31
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 32
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 33
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,1,1,2,3,3,3,3,2,
  2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 34
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,1,2,3,5,7,9,11,11,10,8,
  6,3,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,
  // 35
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
  1,1,1,1,1,1,2,3,4,7,10,15,20,25,29,29,26,21,
  15,9,5,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,
  // 36
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,
  2,2,2,2,3,4,5,8,12,17,25,35,46,56,63,64,55,44,
  32,20,12,6,3,1,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 37
  0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,3,3,4,
  4,5,5,6,7,9,12,18,27,38,53,71,91,115,119,121,101,81,
  59,39,22,12,6,3,1,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 38
  0,1,1,1,1,1,1,1,1,1,2,2,3,5,5,5,7,10,
  12,9,10,12,14,18,25,36,55,70,101,129,158,196,195,192,185,134,
  96,65,37,19,10,5,2,1,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 39
  2,2,3,3,3,3,2,2,3,3,4,11,7,9,10,13,15,13,
  14,15,21,24,26,34,46,62,85,120,162,216,280,313,342,337,250,206,
  130,88,53,30,14,7,3,2,0,0,0,0,0,0,0,0,0,0,
  0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,
  // 40
  4,5,5,6,6,7,7,5,5,6,7,9,11,20,30,17,19,27,
  23,23,27,34,51,73,79,102,138,202,262,310,358,404,431,410,322,246,
  171,99,71,42,24,11,10,3,1,0,0,0,0,0,0,0,0,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3,
  // 41
  8,9,10,11,12,12,11,13,12,13,12,14,18,25,29,27,26,30,
  34,36,42,53,75,95,123,171,217,280,346,426,460,516,498,479,359,272,
  193,114,69,38,21,11,6,2,1,0,0,0,0,0,0,1,1,1,
  1,1,2,2,5,3,2,2,2,2,2,5,2,3,3,4,5,6,
  // 42
  15,17,18,19,20,18,17,22,22,20,18,24,28,38,40,47,41,41,
  43,52,62,82,112,146,183,249,308,381,460,536,565,629,578,561,409,294,
  206,118,70,41,23,13,6,3,1,1,0,1,1,1,1,1,1,1,
  2,2,3,4,8,4,4,4,3,3,4,8,5,6,7,8,10,12,
  // 43
  27,30,32,33,36,30,28,32,26,31,36,37,47,58,53,57,59,55,
  58,70,88,120,154,215,282,364,431,533,596,667,718,729,671,581,469,314,
  218,123,71,43,24,15,6,3,2,1,1,1,1,1,1,1,1,2,
  2,3,4,5,6,6,6,6,6,7,7,8,16,14,14,16,19,23,
  // 44
  46,50,52,54,67,49,46,49,44,41,38,50,57,70,72,73,85,70,
  72,96,123,164,220,309,429,516,613,679,772,844,848,813,770,634,467,314,
  201,132,70,41,23,12,6,3,2,1,1,1,2,2,2,2,2,2,
  3,4,5,6,7,8,9,10,10,11,13,14,17,22,25,29,41,42,
  // 45
  82,85,87,91,82,82,81,58,65,45,47,56,72,80,101,86,99,100,
  96,109,161,233,302,416,568,665,755,851,900,903,857,854,804,617,449,301,
  189,123,68,43,22,12,7,4,2,2,2,2,2,2,2,2,2,3,
  4,5,6,8,9,15,14,14,19,21,29,24,29,37,43,49,67,82,
  // 46
  118,127,139,133,115,110,94,68,58,56,51,58,64,81,84,82,97,111,
  111,128,180,260,365,501,679,777,884,977,958,907,870,824,717,571,415,281,
  176,108,62,37,20,12,7,4,3,2,2,2,2,2,2,2,3,4,
  7,6,10,9,12,15,17,21,28,31,34,39,47,57,70,96,104,112,
  // 47
  173,193,196,186,174,143,109,84,67,62,49,54,58,73,81,81,96,114,
  126,150,216,305,430,598,799,936,1036,1064,1031,919,864,786,672,537,381,250,
  155,94,55,32,20,12,8,5,4,3,2,2,3,4,3,3,3,5,
  7,7,14,13,16,21,22,29,36,45,51,57,70,78,98,130,148,154,
  // 48
  253,259,261,250,237,202,157,104,80,61,44,40,50,52,69,86,88,106,
  151,179,243,367,489,673,896,1088,1134,1093,1042,892,823,740,603,469,330,223,
  161,89,50,31,22,15,8,12,4,4,3,2,10,5,3,3,5,5,
  6,8,10,18,19,27,30,41,49,57,66,80,111,121,157,175,196,244,
  // 49
  319,347,340,331,319,216,170,117,76,60,39,33,34,39,46,58,79,93,
  139,181,278,418,563,758,968,1145,1133,1078,1024,923,776,614,583,429,293,211,
  137,75,47,29,18,11,7,11,4,3,3,2,2,3,3,4,6,7,
  6,8,10,13,19,27,36,54,66,76,86,114,146,158,186,246,271,297,
  // 50
  437,449,449,388,314,241,194,120,73,47,39,37,32,34,40,53,73,90,
  129,193,287,427,580,763,1003,1038,1068,1053,950,829,694,586,475,346,251,176,
  120,76,45,28,17,10,6,5,3,2,2,2,2,3,4,4,5,5,
  10,9,10,19,20,34,46,65,80,96,109,137,172,203,261,309,376,385,
  // 51
  516,509,498,403,327,238,169,107,69,46,33,33,39,38,45,58,77,100,
  145,216,308,445,571,735,876,943,971,946,834,723,604,528,426,342,246,175,
  116,77,46,30,17,10,6,6,3,2,2,2,2,2,4,4,4,4,
  6,8,11,17,23,38,55,76,100,126,149,181,218,262,328,388,433,475,
  // 52
  614,593,537,420,325,235,148,97,68,44,34,37,49,50,56,72,90,118,
  161,235,325,441,543,696,803,908,940,886,790,678,570,498,423,363,258,189,
  127,84,50,32,20,12,5,6,3,1,1,1,1,2,3,3,3,3,
  5,9,12,17,26,44,65,90,127,168,209,246,299,343,430,495,562,577,
  // 53
  790,703,618,447,297,188,124,76,57,40,36,49,53,61,77,90,107,140,
  171,245,321,440,543,679,816,851,907,869,773,702,603,503,446,342,269,213,
  160,99,64,33,18,9,4,4,4,1,1,1,1,1,6,4,2,3,
  4,7,10,19,29,44,78,125,198,264,321,377,446,510,534,596,696,723,
  // 54
  832,691,500,343,223,147,95,59,38,34,38,55,75,87,99,123,130,154,
  218,242,298,363,512,599,712,776,823,836,770,684,637,574,517,461,319,240,
  177,110,81,38,20,9,4,2,1,0,0,0,1,1,1,1,1,2,
  3,5,9,15,32,59,118,194,317,473,569,633,682,708,743,792,836,829,
  // 55
  761,577,417,282,173,102,60,41,32,35,45,55,75,104,120,121,119,147,
  187,210,259,345,463,537,647,723,794,839,799,774,722,655,595,494,347,264,
  178,112,68,40,20,9,4,1,0,0,0,0,0,1,1,1,1,1,
  2,6,10,17,36,84,198,413,687,929,1081,1172,1113,1036,1000,976,953,847,
  // 56
  655,464,312,199,118,66,38,28,24,27,36,45,66,80,101,102,98,112,
  131,169,207,278,372,455,582,707,810,884,854,859,819,759,655,545,404,283,
  184,120,60,34,18,8,3,1,0,0,0,0,0,0,0,0,0,1,
  1,4,9,18,52,162,416,827,1293,1683,1937,1964,1851,1566,1326,1145,1046,812,
  // 57
  557,392,234,133,72,38,21,16,16,19,26,39,54,56,72,84,75,83,
  92,129,156,210,305,405,540,719,839,946,970,954,909,848,721,602,441,279,
  180,109,52,25,15,7,2,1,0,0,0,0,0,0,0,0,0,0,
  1,3,7,23,91,313,744,1368,2073,2648,3019,3011,2691,2153,1721,1398,1117,768,
  // 58
  442,280,160,80,39,18,10,7,9,12,21,26,29,35,41,44,45,49,
  57,76,109,147,228,350,527,666,843,1036,1098,1109,998,922,799,580,372,238,
  157,74,37,17,8,3,1,0,0,0,0,0,0,0,0,0,0,0,
  1,2,7,33,151,482,1078,1887,2976,3952,4590,4416,3572,2748,2146,1646,1160,748,
  // 59
  328,188,95,42,18,7,4,3,4,7,11,13,16,19,22,24,25,27,
  32,43,64,107,203,301,450,649,811,1076,1235,1155,991,833,649,458,287,176,
  99,51,24,10,4,1,0,0,0,0,0,0,0,0,0,0,0,0,
  0,2,8,44,200,598,1287,2335,4067,6371,7643,6046,4198,3171,2316,1590,899,552,
  // 60
  221,110,48,18,7,3,1,1,2,3,4,5,7,8,9,10,11,12,
  15,22,40,76,132,240,374,555,733,974,1001,923,764,607,496,312,200,119,
  63,30,12,5,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,2,9,49,214,621,1319,2397,4211,5632,5760,4704,3736,2721,1783,1107,650,398,
  // 61
  127,56,20,6,2,1,0,0,0,1,1,1,2,2,3,3,4,4,
  6,10,22,48,97,180,299,439,591,747,727,668,553,424,315,202,123,68,
  33,14,5,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,10,45,185,530,1138,2010,3190,4002,4060,3558,2821,2007,1271,754,439,251,
  // 62
  58,21,6,2,0,0,0,0,0,0,0,0,0,0,0,1,1,1,
  2,5,12,30,68,135,237,329,441,519,494,435,348,265,181,111,62,31,
  13,4,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,9,33,130,377,833,1446,2124,2554,2655,2400,1864,1274,777,446,249,129,
  // 63
  18,5,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,2,7,18,42,82,147,213,268,314,295,249,193,137,87,49,24,10,
  3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,5,21,74,213,497,862,1225,1462,1518,1336,1006,663,388,214,111,50,
  // 64
  3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,4,10,23,46,82,115,145,152,149,122,90,58,33,16,6,2,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,4,12,36,99,228,408,570,684,695,595,429,265,149,76,34,12,
  // 65
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,2,5,11,23,38,52,63,67,62,48,32,18,9,3,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,4,6,18,42,82,150,209,248,240,194,132,79,45,18,6,1,
  // 66
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,1,2,5,10,16,21,24,24,20,14,8,4,1,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,2,3,7,15,27,46,61,70,63,49,32,18,11,3,0,0,
  // 67
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,1,2,4,5,7,7,6,4,2,1,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,1,1,3,5,9,13,16,16,14,10,6,3,1,0,0,0,
  // 68
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,1,1,2,2,2,1,1,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,1,1,2,3,3,4,3,2,1,0,0,0,0,0,0,
  // 69
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,
  // 70
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 71
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  };
  ftype32 rama5_all[] = {
  // 0
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 1
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 2
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 3
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 4
  0,0,0,0,0,0,0,0,1,1,2,2,2,2,1,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 5
  0,0,0,0,0,0,1,2,5,7,8,9,8,6,4,2,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 6
  0,0,0,0,1,3,7,12,18,21,23,22,18,13,8,5,2,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,1,1,2,2,2,1,1,6,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 7
  0,0,0,2,6,13,24,35,45,50,54,44,34,24,15,8,4,2,
  1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,1,2,3,4,5,5,5,4,2,1,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 8
  0,1,4,10,21,37,56,75,93,93,95,83,63,38,24,12,6,3,
  1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,1,1,3,4,9,8,9,9,9,7,5,3,1,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 9
  3,7,14,27,46,74,104,130,155,159,151,129,99,55,36,16,8,3,
  1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,1,2,3,4,6,9,15,14,16,18,14,10,7,5,3,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
  // 10
  9,18,32,53,82,125,165,195,246,267,235,169,132,73,43,19,9,4,
  2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,
  2,3,5,7,9,12,15,18,21,27,31,20,15,11,7,4,2,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,4,
  // 11
  21,36,57,89,133,190,265,312,377,347,250,185,119,73,43,17,8,4,
  2,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,2,4,
  6,8,10,12,15,18,24,29,32,37,41,28,27,16,9,5,2,1,
  0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,5,11,
  // 12
  38,61,90,143,209,249,303,364,405,366,251,166,101,60,38,19,7,3,
  2,1,1,1,1,0,0,0,0,0,0,0,0,1,2,4,6,11,
  15,14,18,21,25,35,42,40,33,33,34,26,22,15,9,5,3,1,
  1,0,0,1,1,2,3,3,3,2,2,7,2,2,3,9,13,23,
  // 13
  60,93,131,177,215,255,278,297,312,259,182,124,76,42,21,13,6,2,
  1,1,1,1,1,1,0,0,0,0,1,1,2,5,5,8,13,15,
  23,28,28,31,35,38,39,34,33,31,28,26,20,13,8,5,2,1,
  1,1,1,1,2,5,6,5,4,4,3,4,3,4,7,14,26,39,
  // 14
  85,115,153,186,201,222,221,229,219,173,124,84,50,26,12,6,3,2,
  1,1,1,1,1,1,1,1,1,1,2,3,4,9,10,14,20,22,
  31,41,39,42,42,40,39,32,32,28,23,20,16,11,7,4,2,1,
  1,1,1,2,3,6,7,6,5,4,4,4,4,7,13,23,42,58,
  // 15
  120,147,180,182,186,184,170,162,130,110,75,49,29,15,12,3,2,1,
  1,1,1,1,1,1,1,2,2,3,4,6,8,11,16,24,26,31,
  33,45,48,47,48,39,37,30,27,28,21,15,11,8,5,4,2,1,
  1,1,1,2,3,4,5,5,5,5,4,5,7,12,22,36,54,84,
  // 16
  154,167,150,161,142,128,115,94,74,56,39,24,13,6,5,2,1,1,
  1,1,1,1,1,2,2,2,3,5,7,9,15,25,21,28,36,37,
  54,49,57,48,45,37,32,28,23,18,14,10,7,6,4,5,3,1,
  1,1,1,2,3,4,7,5,5,4,5,6,10,18,31,48,88,113,
  // 17
  135,135,150,133,107,85,65,51,38,27,18,10,6,3,2,1,1,1,
  1,2,2,2,2,2,2,3,4,6,9,12,15,23,25,35,51,45,
  48,45,48,40,37,32,25,29,20,16,11,10,6,4,3,2,3,1,
  1,1,1,2,2,3,6,4,6,4,5,8,14,24,41,62,86,114,
  // 18
  117,113,116,97,73,55,40,27,18,12,7,4,3,2,3,1,1,1,
  2,2,2,2,2,3,3,4,7,7,9,13,17,22,29,35,36,39,
  45,41,39,32,31,25,21,20,16,10,8,7,5,4,3,2,2,1,
  1,0,1,2,2,2,2,3,4,4,5,9,17,29,45,70,87,111,
  // 19
  99,90,87,68,51,34,24,14,9,5,3,2,2,1,2,1,1,1,
  2,2,2,2,3,3,3,5,7,8,12,16,19,23,27,33,31,33,
  36,36,36,29,25,20,17,17,13,8,6,5,4,3,2,2,1,1,
  0,0,0,0,1,1,1,2,2,3,6,10,20,31,46,74,85,101,
  // 20
  77,67,63,46,33,22,14,10,4,3,2,1,1,1,1,1,1,1,
  2,2,2,2,3,3,4,10,11,10,17,18,19,29,26,30,26,30,
  30,31,26,24,20,16,13,11,9,7,6,7,4,3,2,2,1,1,
  0,0,0,0,0,1,1,1,2,3,6,9,17,32,46,69,72,84,
  // 21
  54,49,40,29,25,18,8,5,2,1,1,1,1,1,1,1,1,1,
  2,2,2,2,4,5,3,4,6,9,10,21,16,18,29,24,28,28,
  27,23,23,18,17,15,14,12,8,9,5,5,4,3,5,1,1,1,
  0,0,0,0,0,0,1,3,2,3,4,8,17,33,45,53,50,58,
  // 22
  36,29,25,21,19,9,5,3,1,1,1,1,0,0,1,1,1,1,
  1,2,2,2,3,4,3,4,5,7,8,12,14,17,16,19,18,18,
  18,22,19,15,16,14,10,9,10,7,8,7,4,2,2,1,1,0,
  0,0,0,0,0,0,0,1,1,2,4,7,14,21,26,33,38,37,
  // 23
  22,18,16,12,9,5,3,2,1,2,0,0,0,0,0,0,1,1,
  1,1,1,2,2,2,4,3,5,6,7,9,11,13,16,19,17,18,
  16,17,18,16,15,12,11,11,10,8,5,5,4,2,1,1,0,0,
  0,0,0,0,0,0,0,0,1,2,3,5,12,14,17,21,22,22,
  // 24
  14,11,11,7,4,3,2,1,1,2,0,0,0,0,0,0,0,1,
  1,1,1,1,2,2,3,3,4,5,6,7,9,13,14,20,15,17,
  16,16,18,18,15,12,12,11,9,10,6,5,4,4,1,1,0,0,
  0,0,0,0,0,0,0,0,1,1,2,4,9,8,11,14,14,16,
  // 25
  8,7,5,4,3,2,1,1,0,0,0,0,0,0,0,0,0,0,
  1,1,1,1,2,2,2,2,3,3,7,5,8,11,10,11,14,17,
  14,16,16,18,17,13,12,13,10,7,5,4,2,2,1,0,0,0,
  0,0,0,0,0,0,0,0,1,1,3,4,4,6,7,8,9,10,
  // 26
  5,4,3,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,
  0,0,1,1,1,1,1,2,5,3,3,4,8,7,13,15,12,17,
  16,17,15,18,20,14,18,12,10,8,6,4,2,1,1,0,0,0,
  0,0,0,2,0,0,0,0,1,1,2,2,3,4,5,6,8,6,
  // 27
  3,3,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,1,1,1,1,2,2,3,4,5,6,9,11,13,14,
  20,17,17,18,20,16,18,14,12,9,6,4,2,1,1,0,0,0,
  0,0,0,0,0,0,0,0,1,1,2,7,3,3,4,4,5,4,
  // 28
  2,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,1,1,1,2,2,3,3,5,7,8,10,13,15,
  16,16,18,17,19,18,16,13,12,8,5,3,2,1,0,0,0,0,
  0,0,0,0,0,0,0,0,1,1,1,3,2,3,3,3,3,2,
  // 29
  1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,1,1,1,1,2,2,3,5,8,10,10,13,18,
  17,19,20,19,18,18,14,12,9,6,5,4,2,1,0,0,0,0,
  0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,1,1,
  // 30
  0,0,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,1,1,1,2,2,5,7,8,12,12,20,24,
  25,26,25,23,22,22,16,14,12,5,4,2,1,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,
  // 31
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,1,1,1,2,4,6,11,12,13,17,28,
  30,26,29,26,25,23,16,10,7,9,4,1,1,0,0,0,0,0,
  0,0,0,0,0,0,1,0,0,0,1,1,1,1,1,0,0,0,
  // 32
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,1,1,2,2,5,8,10,15,16,19,25,
  33,31,35,32,30,18,21,12,6,4,2,1,0,0,0,0,0,0,
  0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,
  // 33
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,1,1,1,2,3,6,9,12,18,21,25,29,
  33,33,33,32,23,18,15,11,5,3,2,1,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 34
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,1,1,1,2,2,4,6,9,13,21,27,31,36,37,
  40,40,35,33,23,18,13,10,5,3,2,1,0,0,0,0,0,0,
  0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,
  // 35
  0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,1,1,
  1,1,1,1,1,2,2,4,6,9,14,21,26,40,49,51,64,61,
  60,44,36,34,26,20,12,7,4,3,2,1,0,3,0,0,0,0,
  0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,
  // 36
  0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,
  2,2,2,3,3,4,6,8,12,19,27,38,51,66,80,86,82,76,
  72,64,43,34,23,16,10,6,5,2,1,1,0,1,1,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 37
  0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,3,3,3,
  4,4,5,6,7,9,12,17,26,38,53,72,93,121,131,137,124,109,
  92,80,50,38,26,18,10,6,6,2,1,1,0,1,1,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 38
  1,1,1,1,1,1,1,1,1,1,2,2,3,5,5,5,6,9,
  11,8,9,11,13,17,23,34,52,68,98,126,158,195,204,205,206,158,
  121,93,61,37,26,17,9,6,3,2,1,3,1,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 39
  2,2,3,3,3,2,2,2,2,3,4,11,7,9,9,12,14,12,
  13,13,19,21,23,31,43,57,79,112,153,206,272,305,338,340,260,223,
  151,107,71,49,30,16,9,6,3,2,1,1,0,0,0,0,1,1,
  1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,
  // 40
  4,5,6,6,6,7,7,5,5,5,7,8,11,18,27,16,17,24,
  21,20,24,31,47,67,72,94,128,187,243,293,341,386,416,407,324,259,
  181,120,90,57,34,19,15,6,3,2,1,1,0,0,1,3,1,1,
  1,1,1,1,1,1,1,1,1,0,1,1,1,1,2,2,2,3,
  // 41
  8,9,11,11,11,12,12,13,11,12,11,13,16,24,27,25,24,28,
  31,32,38,49,68,86,112,157,202,261,321,399,434,487,474,467,354,278,
  200,130,81,50,29,19,11,6,3,2,1,1,1,1,1,1,1,1,
  1,2,2,2,5,2,2,2,2,1,1,5,2,3,3,4,5,6,
  // 42
  14,16,18,19,20,18,17,22,23,19,17,22,26,35,37,45,37,37,
  38,49,56,74,101,135,167,230,286,352,430,503,532,592,549,535,397,291,
  207,130,81,51,30,21,12,6,4,2,2,1,1,1,1,1,1,1,
  2,2,3,3,8,4,4,3,3,3,3,7,5,6,7,8,10,12,
  // 43
  26,29,33,32,34,30,28,31,25,29,32,34,44,53,49,53,55,51,
  54,64,80,109,140,196,256,336,397,492,555,622,675,681,636,551,454,303,
  214,126,81,53,35,22,12,7,4,3,2,2,2,2,2,1,1,2,
  2,3,4,4,5,6,6,6,6,6,7,7,14,14,13,15,18,22,
  // 44
  44,48,50,52,63,47,44,47,41,39,35,46,53,64,66,67,77,63,
  67,88,111,149,201,281,390,470,561,623,717,780,788,754,717,598,444,303,
  206,133,76,49,32,17,11,7,5,3,3,3,3,3,2,2,2,2,
  3,4,5,6,7,8,8,9,10,11,12,13,16,21,23,27,38,40,
  // 45
  77,80,84,87,77,80,76,56,60,41,43,51,65,73,93,78,90,91,
  87,100,145,211,274,381,519,608,692,781,832,840,801,793,749,580,431,293,
  188,129,74,51,29,18,12,8,5,4,4,4,3,3,3,3,3,3,
  4,5,6,7,9,14,13,13,18,20,26,22,26,36,42,46,62,78,
  // 46
  112,120,132,125,108,105,89,65,57,51,47,54,58,74,77,75,89,101,
  100,118,162,236,331,459,618,712,815,900,888,846,808,764,666,533,399,272,
  175,114,69,46,28,20,13,10,7,5,6,4,4,4,3,3,3,5,
  7,6,9,9,11,14,16,20,26,29,32,36,43,54,66,90,98,108,
  // 47
  164,183,186,178,168,135,105,81,64,57,45,49,53,67,74,76,87,103,
  115,134,195,278,391,547,732,856,950,971,948,855,805,734,629,499,361,240,
  156,102,65,43,29,22,15,12,8,6,7,5,6,6,4,4,4,6,
  8,7,13,13,16,20,20,26,34,41,49,54,64,72,93,123,139,147,
  // 48
  243,253,253,236,225,192,153,101,76,60,41,37,46,48,62,79,80,96,
  137,161,220,335,447,616,822,997,1037,1000,957,822,756,683,564,445,314,219,
  161,98,61,43,33,25,17,18,12,9,6,6,11,7,4,5,6,7,
  7,8,10,17,18,25,27,38,45,52,61,74,103,114,148,166,188,233,
  // 49
  318,342,336,318,309,215,164,116,73,57,37,31,32,36,42,52,71,85,
  126,166,253,379,512,692,884,1044,1033,986,936,849,719,572,546,405,282,207,
  141,88,59,42,32,26,20,19,11,12,7,6,5,5,6,7,7,8,
  7,8,13,13,18,25,32,50,60,69,79,105,136,150,176,234,263,289,
  // 50
  433,451,448,386,314,239,188,116,70,44,37,35,30,31,37,49,66,81,
  116,178,263,391,528,698,917,951,974,965,879,768,648,550,447,327,243,180,
  130,94,62,45,34,28,20,15,12,11,9,7,6,7,7,8,6,6,
  10,9,11,19,19,31,42,59,73,87,100,126,161,197,249,300,364,379,
  // 51
  524,523,509,413,335,238,168,106,67,47,31,31,37,34,41,53,70,91,
  132,195,279,407,524,676,806,873,893,871,772,668,560,499,409,331,241,183,
  132,97,66,51,41,32,22,19,14,11,8,7,6,6,7,8,5,5,
  7,11,12,17,21,35,51,76,91,116,137,168,207,252,317,381,429,482,
  // 52
  633,617,561,447,339,242,152,98,67,46,33,36,46,45,51,65,82,107,
  147,213,297,403,499,638,742,837,865,817,734,625,531,471,407,353,263,199,
  151,104,73,56,47,37,23,22,16,10,7,7,6,5,6,5,5,5,
  7,10,12,15,27,42,60,83,118,155,194,231,284,332,423,494,571,597,
  // 53
  822,738,655,478,327,200,132,79,57,39,36,46,50,57,71,83,97,128,
  156,221,289,404,499,616,750,782,831,800,713,650,560,476,431,339,277,229,
  193,123,89,60,46,40,25,19,14,10,9,5,5,4,10,6,4,4,
  6,7,10,18,27,40,72,115,182,245,302,357,427,495,531,612,719,759,
  // 54
  890,745,551,381,249,161,101,61,39,34,40,52,70,81,95,114,118,140,
  198,220,272,334,468,544,652,713,758,768,710,640,600,548,501,454,331,258,
  209,146,110,64,47,34,21,16,11,8,10,4,4,3,3,3,3,3,
  5,6,9,15,29,55,109,181,292,440,534,604,654,690,740,814,876,893,
  // 55
  824,629,462,310,194,118,68,43,32,34,44,53,70,97,110,112,109,135,
  171,191,238,320,423,490,595,667,734,773,740,729,690,629,582,492,359,280,
  205,143,102,73,44,30,20,13,8,5,4,3,2,2,2,2,2,2,
  3,6,10,16,34,79,183,381,634,863,1007,1099,1058,1009,996,995,1002,904,
  // 56
  705,509,346,221,133,75,42,30,25,27,35,42,62,74,93,95,92,104,
  121,159,188,254,341,417,533,658,753,819,795,799,774,732,643,544,415,302,
  212,152,87,61,38,28,15,9,5,3,2,2,1,1,1,1,1,2,
  3,4,8,17,49,150,383,763,1195,1559,1804,1847,1758,1507,1313,1165,1087,868,
  // 57
  589,424,258,148,82,43,23,18,17,18,24,36,50,52,67,78,69,76,
  85,118,143,192,281,376,501,670,781,882,908,905,864,818,706,597,450,297,
  200,133,73,46,28,16,9,5,3,2,1,1,1,1,1,1,1,1,
  2,3,7,22,85,288,685,1266,1926,2462,2823,2832,2543,2059,1679,1401,1145,797,
  // 58
  459,297,172,89,44,21,11,8,9,12,22,24,27,33,38,40,42,45,
  53,72,102,135,212,327,493,624,791,963,1034,1043,944,884,781,578,372,247,
  168,87,50,30,16,9,5,3,1,1,0,0,0,0,0,0,0,0,
  1,2,7,31,139,444,994,1752,2774,3735,4334,4174,3385,2628,2069,1607,1153,756,
  // 59
  331,194,101,46,20,9,5,4,5,6,11,12,15,18,20,22,23,25,
  29,40,59,99,189,283,428,612,765,1003,1158,1087,943,805,629,450,289,179,
  108,59,34,16,8,4,2,1,0,0,0,0,0,0,0,0,0,0,
  0,2,7,41,184,553,1192,2171,3797,6007,7154,5665,3961,3008,2204,1534,885,552,
  // 60
  218,112,50,20,7,3,2,2,2,3,4,5,6,8,9,9,10,11,
  14,20,37,71,124,226,354,526,692,913,946,872,724,577,473,300,196,124,
  67,35,17,7,3,1,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,8,46,198,577,1224,2225,3944,5350,5434,4448,3531,2581,1697,1057,627,388,
  // 61
  123,55,21,7,2,1,0,0,0,1,1,1,2,2,3,3,3,4,
  5,10,20,45,92,171,283,416,561,711,688,628,521,399,297,193,120,70,
  35,16,7,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,9,42,172,495,1058,1870,2989,3761,3808,3338,2658,1888,1193,710,417,241,
  // 62
  55,20,6,2,0,0,0,0,0,0,0,0,0,0,0,0,1,1,
  2,4,11,29,64,130,225,310,415,495,468,410,328,249,171,106,60,31,
  14,5,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,8,31,121,351,773,1345,1975,2385,2478,2236,1740,1188,725,416,234,122,
  // 63
  17,5,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,2,6,17,40,77,139,202,253,295,279,235,182,128,82,46,23,10,
  4,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,5,19,69,198,461,800,1138,1359,1407,1240,935,614,359,199,103,47,
  // 64
  3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,3,9,22,44,78,110,137,143,140,115,85,54,31,15,6,2,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,3,11,35,93,211,377,527,633,643,550,396,245,137,71,32,11,
  // 65
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,2,5,11,22,36,50,60,63,58,45,30,17,8,3,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,2,4,6,17,39,76,139,193,229,222,179,122,72,41,17,5,1,
  // 66
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,1,2,5,9,15,20,23,22,19,13,7,3,1,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,2,3,7,14,25,43,57,64,58,45,29,16,10,2,0,0,
  // 67
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,1,2,4,5,6,7,6,4,2,1,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,1,1,3,5,8,12,15,15,13,9,5,3,1,0,0,0,
  // 68
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,1,1,2,2,2,1,1,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,1,1,2,3,3,3,3,2,1,0,0,0,0,0,0,
  // 69
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,
  // 70
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 71
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  };
}


void Prob_phi_2d::init( const int& size )
{
  n = size;
  data_.clear();
  data_.resize( n*n, 0.0 );
}

void Prob_phi_2d::accumulate( const ftype32 table[] )
{ for ( int i = 0; i < data_.size(); i++ ) data_[i] += table[i]; }

/*! linear interpolation onto grid */
void Prob_phi_2d::accumulate( const ftype& phi1, const ftype& phi2, ftype wgt )
{
  int   i1_0, i2_0, i1_1, i2_1;
  ftype w1_0, w2_0, w1_1, w2_1;
  w1_1 = ftype(n) * phi1 / Util::twopi();
  w2_1 = ftype(n) * phi2 / Util::twopi();
  i1_0 = Util::intf( w1_1 );
  i2_0 = Util::intf( w2_1 );
  w1_1 -= ftype( i1_0 );
  w2_1 -= ftype( i2_0 );
  w1_0 = 1.0 - w1_1;
  w2_0 = 1.0 - w2_1;
  i1_0 = Util::mod( i1_0  , n );
  i2_0 = Util::mod( i2_0  , n );
  i1_1 = Util::mod( i1_0+1, n );
  i2_1 = Util::mod( i2_0+1, n );
  data( i1_0, i2_0 ) += wgt * w1_0 * w2_0;
  data( i1_0, i2_1 ) += wgt * w1_0 * w2_1;
  data( i1_1, i2_0 ) += wgt * w1_1 * w2_0;
  data( i1_1, i2_1 ) += wgt * w1_1 * w2_1;
}

/*! normalise mean value to 1/(2pi)^2 */
void Prob_phi_2d::normalise()
{
  ftype s = 0.0;
  for ( int i = 0; i < data_.size(); i++ ) s += data_[i];
  s = ftype( data_.size() ) / ( Util::twopi() * Util::twopi() * s );
  for ( int i = 0; i < data_.size(); i++ ) data_[i] *= s;
}

/*! linear interpolation off of grid */
ftype Prob_phi_2d::probability( const ftype& phi1, const ftype& phi2 ) const
{
  int   i1_0, i2_0, i1_1, i2_1;
  ftype w1_0, w2_0, w1_1, w2_1;
  w1_1 = ftype(n) * phi1 / Util::twopi();
  w2_1 = ftype(n) * phi2 / Util::twopi();
  i1_0 = Util::intf( w1_1 );
  i2_0 = Util::intf( w2_1 );
  w1_1 -= ftype( i1_0 );
  w2_1 -= ftype( i2_0 );
  w1_0 = 1.0 - w1_1;
  w2_0 = 1.0 - w2_1;
  i1_0 = Util::mod( i1_0  , n );
  i2_0 = Util::mod( i2_0  , n );
  i1_1 = Util::mod( i1_0+1, n );
  i2_1 = Util::mod( i2_0+1, n );
  return
    w1_0 * ( w2_0 * data( i1_0, i2_0 ) + w2_1 * data( i1_0, i2_1 ) ) +
    w1_1 * ( w2_0 * data( i1_1, i2_0 ) + w2_1 * data( i1_1, i2_1 ) );
}

String Prob_phi_2d::format() const
{
  String s;
  for ( int i = 0; i < n; i++ ) {
    for ( int j = 0; j < n; j++ ) {
      if ( j % 12 == 0 ) s += "\n ";
      int k = Util::intr( data(i,j) );
      s += String( k, 5 ) + ",";
    }
    s += "//" + String( i, 2 );
  }
  return s;
}


/*! Construct a Ramachandran plot of a given type.
  \param type The residue type of the plot. Options include:
  Ramachandran::Gly, Ramachandran::Pro, Ramachandran::NonGlyPro,
  Ramachandran::NonGly, Ramachandran::All */
Ramachandran::Ramachandran( TYPE type )
{ init( type ); }

/*! Construct a Ramachandran plot of a given type.
  \param type The residue type of the plot. Options include:
  Ramachandran::Gly, Ramachandran::Pro, Ramachandran::NonGlyPro,
  Ramachandran::NonGly, Ramachandran::All */
void Ramachandran::init( TYPE type )
{
  switch (type) {
  case Gly5:
    Prob_phi_2d::init( data::rama5_data_size );
    Prob_phi_2d::accumulate( data::rama5_gly );
    break;
  case Pro5:
    Prob_phi_2d::init( data::rama5_data_size );
    Prob_phi_2d::accumulate( data::rama5_pro );
    break;
  case NonGlyPro5:
    Prob_phi_2d::init( data::rama5_data_size );
    Prob_phi_2d::accumulate( data::rama5_ngp );
    break;
  case NonGly5:
    Prob_phi_2d::init( data::rama5_data_size );
    Prob_phi_2d::accumulate( data::rama5_ngl );
    break;
  case All5:
    Prob_phi_2d::init( data::rama5_data_size );
    Prob_phi_2d::accumulate( data::rama5_all );
    break;
  case Gly:
    Prob_phi_2d::init( data::rama_data_size );
    Prob_phi_2d::accumulate( data::rama_gly );
    break;
  case Pro:
    Prob_phi_2d::init( data::rama_data_size );
    Prob_phi_2d::accumulate( data::rama_pro );
    break;
  case NonGlyPro:
    Prob_phi_2d::init( data::rama_data_size );
    Prob_phi_2d::accumulate( data::rama_ngp );
    break;
  case NonGly:
    Prob_phi_2d::init( data::rama_data_size );
    Prob_phi_2d::accumulate( data::rama_ngp );
    Prob_phi_2d::accumulate( data::rama_pro );
    break;
  default:
    Prob_phi_2d::init( data::rama_data_size );
    Prob_phi_2d::accumulate( data::rama_ngp );
    Prob_phi_2d::accumulate( data::rama_pro );
    Prob_phi_2d::accumulate( data::rama_gly );
    break;
  }
  Prob_phi_2d::normalise();
  set_thresholds();
}

/*! Set thresholds for favorable and allowed regions of the
  Ramachandran plot. The US spelling is used because it is the same
  length as 'allowed'. I should get out more. Sorry.
  \param prob_favored The probability threshold for the favored region.
  \param prob_allowed The probability threshold for the allowed region.
 */
void Ramachandran::set_thresholds( ftype prob_favored, ftype prob_allowed )
{ p_favored = prob_favored; p_allowed = prob_allowed; }


} // namespace clipper
