function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

import React from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { Dropdown } from '../Dropdown';
import { noop } from '../../common/helpers';
import ApplicationLauncherToggle from './ApplicationLauncherToggle';
import ApplicationLauncherItem from './ApplicationLauncherItem';

const ApplicationLauncher = (_ref) => {
  let {
    open,
    grid,
    tooltip,
    tooltipPlacement,
    children,
    toggleLauncher,
    className
  } = _ref,
      propTypes = _objectWithoutProperties(_ref, ["open", "grid", "tooltip", "tooltipPlacement", "children", "toggleLauncher", "className"]);

  const classes = classNames('applauncher-pf dropdown', {
    'applauncher-pf-block-list': grid
  }, {
    open
  });
  return React.createElement("li", {
    className: classes
  }, React.createElement(ApplicationLauncherToggle, {
    tooltip: tooltip,
    tooltipPlacement: tooltipPlacement,
    onClick: () => toggleLauncher(),
    open: open
  }), React.createElement(Dropdown.Menu, {
    className: "dropdown-menu-right"
  }, children));
};

ApplicationLauncher.propTypes = {
  /** Additional element css classes */
  className: PropTypes.string,

  /** Children Node */
  children: PropTypes.node.isRequired,

  /** Toggle Tooltip */
  tooltip: PropTypes.string,

  /** tooltipPlacement */
  tooltipPlacement: PropTypes.string,

  /** Application Launcher Type (Default List) */
  grid: PropTypes.bool,

  /** open bool */
  open: PropTypes.bool,

  /** Toggle launcher func */
  toggleLauncher: PropTypes.func
};
ApplicationLauncher.defaultProps = {
  className: '',
  tooltip: '',
  tooltipPlacement: 'left',
  toggleLauncher: noop,
  grid: false,
  open: false
};
ApplicationLauncher.Toggle = ApplicationLauncherToggle;
ApplicationLauncher.Item = ApplicationLauncherItem;
export default ApplicationLauncher;