#define MAX_DECOY_PEP_LEN 40
#define DECOY_SIZE        3000

struct DecoysStruct
{
   char *szPeptide;
   double pdIonsN[MAX_DECOY_PEP_LEN];
   double pdIonsC[MAX_DECOY_PEP_LEN];
};

DecoysStruct decoyIons[] = {
   {"CCYPLFFVLLLTFTAWFLWFWLFFYYGIFK", {161.0379, 321.0686, 484.1319, 581.1847, 694.2687, 841.3371, 988.4056, 1087.4740, 1200.5580, 1313.6421, 1426.7262, 1527.7738, 1674.8423, 1775.8899, 1846.9270, 2033.0064, 2180.0748, 2293.1588, 2479.2382, 2626.3066, 2812.3859, 2925.4699, 3072.5384, 3219.6068, 3382.6701, 3545.7334, 3602.7549, 3715.8390, 3862.9074, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 294.1812, 407.2653, 464.2867, 627.3501, 790.4134, 937.4818, 1084.5502, 1197.6343, 1383.7136, 1530.7820, 1716.8613, 1829.9454, 1977.0138, 2163.0931, 2234.1302, 2335.1779, 2482.2463, 2583.2940, 2696.3781, 2809.4621, 2922.5462, 3021.6146, 3168.6830, 3315.7514, 3428.8355, 3525.8883, 3688.9516, 3848.9822, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FWYSYCILFLPIYYVFISYFILYSRPNWDR", {148.0757, 334.1550, 497.2183, 584.2504, 747.3137, 907.3443, 1020.4284, 1133.5125, 1280.5809, 1393.6649, 1490.7177, 1603.8018, 1766.8651, 1929.9284, 2028.9968, 2176.0653, 2289.1493, 2376.1813, 2539.2447, 2686.3131, 2799.3972, 2912.4812, 3075.5445, 3162.5766, 3318.6777, 3415.7305, 3529.7734, 3715.8527, 3830.8796, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 290.1459, 476.2252, 590.2681, 687.3209, 843.4220, 930.4540, 1093.5174, 1206.6014, 1319.6855, 1466.7539, 1629.8172, 1716.8493, 1829.9333, 1977.0017, 2076.0702, 2239.1335, 2402.1968, 2515.2809, 2612.3336, 2725.4177, 2872.4861, 2985.5702, 3098.6542, 3258.6849, 3421.7482, 3508.7803, 3671.8436, 3857.9229, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LLQWEEQLPYFEYIFERPDTLFYHDDYEYR", {114.0913, 227.1754, 355.2340, 541.3133, 670.3559, 799.3985, 927.4571, 1040.5411, 1137.5939, 1300.6572, 1447.7256, 1576.7682, 1739.8316, 1852.9156, 1999.9840, 2129.0266, 2285.1277, 2382.1805, 2497.2074, 2598.2551, 2711.3392, 2858.4076, 3021.4709, 3158.5298, 3273.5568, 3388.5837, 3551.6471, 3680.6896, 3843.7530, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 467.2249, 630.2882, 745.3151, 860.3421, 997.4010, 1160.4643, 1307.5327, 1420.6168, 1521.6645, 1636.6914, 1733.7442, 1889.8453, 2018.8879, 2165.9563, 2279.0404, 2442.1037, 2571.1463, 2718.2147, 2881.2780, 2978.3308, 3091.4149, 3219.4734, 3348.5160, 3477.5586, 3663.6379, 3791.6965, 3904.7806, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YYYYDYTFWLIVSFLQFVYFPNLVELFLLTK", {164.0706, 327.1339, 490.1973, 653.2606, 768.2875, 931.3509, 1032.3985, 1179.4670, 1365.5463, 1478.6303, 1591.7144, 1690.7828, 1777.8148, 1924.8833, 2037.9673, 2166.0259, 2313.0943, 2412.1627, 2575.2261, 2722.2945, 2819.3472, 2933.3902, 3046.4742, 3145.5426, 3274.5852, 3387.6693, 3534.7377, 3647.8218, 3760.9058, 3861.9535, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 248.1605, 361.2445, 474.3286, 621.3970, 734.4811, 863.5237, 962.5921, 1075.6762, 1189.7191, 1286.7719, 1433.8403, 1596.9036, 1695.9720, 1843.0404, 1971.0990, 2084.1831, 2231.2515, 2318.2835, 2417.3519, 2530.4360, 2643.5200, 2829.5994, 2976.6678, 3077.7155, 3240.7788, 3355.8057, 3518.8691, 3681.9324, 3844.9957, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"WIFGFCMISNCIIFVYTYSVWWIIHQFGCLR", {187.0866, 300.1707, 447.2391, 504.2605, 651.3289, 811.3596, 942.4001, 1055.4841, 1142.5162, 1256.5591, 1416.5897, 1529.6738, 1642.7579, 1789.8263, 1888.8947, 2051.9580, 2153.0057, 2316.0690, 2403.1011, 2502.1695, 2688.2488, 2874.3281, 2987.4122, 3100.4962, 3237.5551, 3365.6137, 3512.6821, 3569.7036, 3729.7343, 3842.8183, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 448.2337, 505.2551, 652.3235, 780.3821, 917.4410, 1030.5251, 1143.6092, 1329.6885, 1515.7678, 1614.8362, 1701.8682, 1864.9316, 1965.9792, 2129.0426, 2228.1110, 2375.1794, 2488.2635, 2601.3475, 2761.3782, 2875.4211, 2962.4531, 3075.5372, 3206.5777, 3366.6083, 3513.6767, 3570.6982, 3717.7666, 3830.8507, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FIVLFMYFLYCFYSFPLVQLFMVIPVWYYGR", {148.0757, 261.1598, 360.2282, 473.3122, 620.3806, 751.4211, 914.4845, 1061.5529, 1174.6369, 1337.7003, 1497.7309, 1644.7993, 1807.8627, 1894.8947, 2041.9631, 2139.0159, 2252.0999, 2351.1683, 2479.2269, 2592.3110, 2739.3794, 2870.4199, 2969.4883, 3082.5724, 3179.6251, 3278.6935, 3464.7729, 3627.8362, 3790.8995, 3847.9210, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 232.1404, 395.2037, 558.2671, 744.3464, 843.4148, 940.4676, 1053.5516, 1152.6200, 1283.6605, 1430.7289, 1543.8130, 1671.8716, 1770.9400, 1884.0241, 1981.0768, 2128.1452, 2215.1773, 2378.2406, 2525.3090, 2685.3397, 2848.4030, 2961.4870, 3108.5555, 3271.6188, 3402.6593, 3549.7277, 3662.8118, 3761.8802, 3874.9642, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NNCPQECHQQDNCYSHGNCNCRPCSTFFWHK", {115.0502, 229.0931, 389.1238, 486.1765, 614.2351, 743.2777, 903.3084, 1040.3673, 1168.4259, 1296.4844, 1411.5114, 1525.5543, 1685.5849, 1848.6483, 1935.6803, 2072.7392, 2129.7607, 2243.8036, 2403.8343, 2517.8772, 2677.9078, 2834.0089, 2931.0617, 3091.0924, 3178.1244, 3279.1721, 3426.2405, 3573.3089, 3759.3882, 3896.4471, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 284.1717, 470.2510, 617.3194, 764.3879, 865.4355, 952.4676, 1112.4982, 1209.5510, 1365.6521, 1525.6827, 1639.7257, 1799.7563, 1913.7992, 1970.8207, 2107.8796, 2194.9116, 2357.9750, 2518.0056, 2632.0485, 2747.0755, 2875.1341, 3003.1926, 3140.2516, 3300.2822, 3429.3248, 3557.3834, 3654.4361, 3814.4668, 3928.5097, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TTNWFSWWYLPITTPIWQGQLNFFWWFSQEK", {102.0550, 203.1026, 317.1456, 503.2249, 650.2933, 737.3253, 923.4046, 1109.4839, 1272.5473, 1385.6313, 1482.6841, 1595.7682, 1696.8158, 1797.8635, 1894.9163, 2008.0003, 2194.0797, 2322.1382, 2379.1597, 2507.2183, 2620.3023, 2734.3453, 2881.4137, 3028.4821, 3214.5614, 3400.6407, 3547.7091, 3634.7412, 3762.7997, 3891.8423, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 276.1554, 404.2140, 491.2460, 638.3144, 824.3937, 1010.4730, 1157.5415, 1304.6099, 1418.6528, 1531.7369, 1659.7954, 1716.8169, 1844.8755, 2030.9548, 2144.0389, 2241.0916, 2342.1393, 2443.1870, 2556.2710, 2653.3238, 2766.4079, 2929.4712, 3115.5505, 3301.6298, 3388.6619, 3535.7303, 3721.8096, 3835.8525, 3936.9002, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YGIEYGFNSFWLFIFWVLCHVMLLWVEMWTR", {164.0706, 221.0921, 334.1761, 463.2187, 626.2821, 683.3035, 830.3719, 944.4149, 1031.4469, 1178.5153, 1364.5946, 1477.6787, 1624.7471, 1737.8312, 1884.8996, 2070.9789, 2170.0473, 2283.1314, 2443.1620, 2580.2209, 2679.2893, 2810.3298, 2923.4139, 3036.4979, 3222.5773, 3321.6457, 3450.6883, 3581.7288, 3767.8081, 3868.8557, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 276.1666, 462.2459, 593.2864, 722.3290, 821.3974, 1007.4767, 1120.5608, 1233.6449, 1364.6854, 1463.7538, 1600.8127, 1760.8433, 1873.9274, 1972.9958, 2159.0751, 2306.1435, 2419.2276, 2566.2960, 2679.3801, 2865.4594, 3012.5278, 3099.5598, 3213.6028, 3360.6712, 3417.6926, 3580.7560, 3709.7986, 3822.8826, 3879.9041, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NCYFPVLWPIYDFSYGQNIEWFIEDFYEIIK", {115.0502, 275.0809, 438.1442, 585.2126, 682.2654, 781.3338, 894.4178, 1080.4971, 1177.5499, 1290.6340, 1453.6973, 1568.7242, 1715.7927, 1802.8247, 1965.8880, 2022.9095, 2150.9681, 2265.0110, 2378.0951, 2507.1376, 2693.2170, 2840.2854, 2953.3694, 3082.4120, 3197.4390, 3344.5074, 3507.5707, 3636.6133, 3749.6974, 3862.7814, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 373.2809, 502.3235, 665.3869, 812.4553, 927.4822, 1056.5248, 1169.6089, 1316.6773, 1502.7566, 1631.7992, 1744.8833, 1858.9262, 1986.9848, 2044.0062, 2207.0695, 2294.1016, 2441.1700, 2556.1969, 2719.2603, 2832.3443, 2929.3971, 3115.4764, 3228.5605, 3327.6289, 3424.6816, 3571.7501, 3734.8134, 3894.8440, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QQHLHQQQHHQQQHQHQQQHHQQQQHHADLR", {129.0659, 257.1244, 394.1833, 507.2674, 644.3263, 772.3849, 900.4435, 1028.5021, 1165.5610, 1302.6199, 1430.6785, 1558.7370, 1686.7956, 1823.8545, 1951.9131, 2088.9720, 2217.0306, 2345.0892, 2473.1477, 2610.2067, 2747.2656, 2875.3241, 3003.3827, 3131.4413, 3259.4999, 3396.5588, 3533.6177, 3604.6548, 3719.6818, 3832.7658, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 403.2300, 474.2671, 611.3260, 748.3849, 876.4435, 1004.5021, 1132.5606, 1260.6192, 1397.6781, 1534.7370, 1662.7956, 1790.8542, 1918.9128, 2055.9717, 2184.0303, 2321.0892, 2449.1477, 2577.2063, 2705.2649, 2842.3238, 2979.3827, 3107.4413, 3235.4999, 3363.5585, 3500.6174, 3613.7014, 3750.7603, 3878.8189, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"WWYITIYLFLWVVDVFHWYWAAAEFGFHHNK", {187.0866, 373.1659, 536.2292, 649.3133, 750.3610, 863.4450, 1026.5084, 1139.5924, 1286.6608, 1399.7449, 1585.8242, 1684.8926, 1783.9610, 1898.9880, 1998.0564, 2145.1248, 2282.1837, 2468.2630, 2631.3264, 2817.4057, 2888.4428, 2959.4799, 3030.5170, 3159.5596, 3306.6280, 3363.6495, 3510.7179, 3647.7768, 3784.8357, 3898.8787, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 261.1557, 398.2146, 535.2736, 682.3420, 739.3634, 886.4318, 1015.4744, 1086.5116, 1157.5487, 1228.5858, 1414.6651, 1577.7284, 1763.8077, 1900.8666, 2047.9351, 2147.0035, 2262.0304, 2361.0988, 2460.1672, 2646.2466, 2759.3306, 2906.3990, 3019.4831, 3182.5464, 3295.6305, 3396.6782, 3509.7622, 3672.8256, 3858.9049, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FSIFFMMIQVMWYMNNIFCFPILFLLFFIIK", {148.0757, 235.1077, 348.1918, 495.2602, 642.3286, 773.3691, 904.4096, 1017.4936, 1145.5522, 1244.6206, 1375.6611, 1561.7404, 1724.8038, 1855.8442, 1969.8872, 2083.9301, 2197.0142, 2344.0826, 2504.1132, 2651.1816, 2748.2344, 2861.3185, 2974.4025, 3121.4709, 3234.5550, 3347.6391, 3494.7075, 3641.7759, 3754.8600, 3867.9440, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 373.2809, 520.3493, 667.4178, 780.5018, 893.5859, 1040.6543, 1153.7384, 1266.8224, 1363.8752, 1510.9436, 1670.9743, 1818.0427, 1931.1267, 2045.1697, 2159.2126, 2290.2531, 2453.3164, 2639.3957, 2770.4362, 2869.5046, 2997.5632, 3110.6473, 3241.6877, 3372.7282, 3519.7966, 3666.8651, 3779.9491, 3866.9811, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DKPAIQFVFMFLHFTTPLQFLCLLLTWLFSWR", {116.0342, 244.1292, 341.1819, 412.2191, 525.3031, 653.3617, 800.4301, 899.4985, 1046.5669, 1177.6074, 1324.6758, 1437.7599, 1574.8188, 1721.8872, 1822.9349, 1923.9826, 2021.0354, 2134.1194, 2262.1780, 2409.2464, 2522.3305, 2682.3611, 2795.4452, 2908.5292, 3021.6133, 3122.6610, 3308.7403, 3421.8244, 3568.8928, 3655.9248, 3842.0041, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 361.1983, 448.2303, 595.2987, 708.3828, 894.4621, 995.5098, 1108.5938, 1221.6779, 1334.7620, 1494.7926, 1607.8767, 1754.9451, 1883.0037, 1996.0877, 2093.1405, 2194.1882, 2295.2358, 2442.3043, 2579.3632, 2692.4472, 2839.5156, 2970.5561, 3117.6245, 3216.6930, 3363.7614, 3491.8200, 3604.9040, 3675.9411, 3772.9939, 3901.0889, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"GNCVYVFDYYVPDCTDTSHDWVYVEWDDLRPR", {58.0287, 172.0717, 332.1023, 431.1707, 594.2341, 693.3025, 840.3709, 955.3978, 1118.4612, 1281.5245, 1380.5929, 1477.6457, 1592.6726, 1752.7033, 1853.7509, 1968.7779, 2069.8256, 2156.8576, 2293.9165, 2408.9434, 2595.0228, 2694.0912, 2857.1545, 2956.2229, 3085.2655, 3271.3448, 3386.3718, 3501.3987, 3614.4828, 3770.5839, 3867.6366, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 272.1717, 428.2728, 541.3569, 656.3838, 771.4108, 957.4901, 1086.5327, 1185.6011, 1348.6644, 1447.7328, 1633.8122, 1748.8391, 1885.8980, 1972.9300, 2073.9777, 2189.0047, 2290.0523, 2450.0830, 2565.1099, 2662.1627, 2761.2311, 2924.2944, 3087.3578, 3202.3847, 3349.4531, 3448.5215, 3611.5849, 3710.6533, 3870.6839, 3984.7269, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QGCTASHGPWHLQQCPYDCYSTNWCCYLQAER", {129.0659, 186.0873, 346.1180, 447.1656, 518.2028, 605.2348, 742.2937, 799.3152, 896.3679, 1082.4472, 1219.5062, 1332.5902, 1460.6488, 1588.7074, 1748.7380, 1845.7908, 2008.8541, 2123.8811, 2283.9117, 2446.9750, 2534.0071, 2635.0547, 2749.0977, 2935.1770, 3095.2076, 3255.2383, 3418.3016, 3531.3857, 3659.4442, 3730.4814, 3859.5240, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 375.1987, 503.2572, 616.3413, 779.4046, 939.4353, 1099.4659, 1285.5452, 1399.5882, 1500.6358, 1587.6679, 1750.7312, 1910.7619, 2025.7888, 2188.8521, 2285.9049, 2445.9355, 2573.9941, 2702.0527, 2815.1368, 2952.1957, 3138.2750, 3235.3277, 3292.3492, 3429.4081, 3516.4401, 3587.4773, 3688.5249, 3848.5556, 3905.5771, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"AGHQWCLCLECQIMLGDEEGYECICNIIEEQR", {72.0444, 129.0659, 266.1248, 394.1833, 580.2627, 740.2933, 853.3774, 1013.4080, 1126.4921, 1255.5347, 1415.5653, 1543.6239, 1656.7080, 1787.7484, 1900.8325, 1957.8540, 2072.8809, 2201.9235, 2330.9661, 2387.9876, 2551.0509, 2680.0935, 2840.1241, 2953.2082, 3113.2389, 3227.2818, 3340.3658, 3453.4499, 3582.4925, 3711.5351, 3839.5937, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 432.2201, 561.2627, 674.3468, 787.4308, 901.4738, 1061.5044, 1174.5885, 1334.6191, 1463.6617, 1626.7251, 1683.7465, 1812.7891, 1941.8317, 2056.8586, 2113.8801, 2226.9642, 2358.0047, 2471.0887, 2599.1473, 2759.1779, 2888.2205, 3001.3046, 3161.3353, 3274.4193, 3434.4500, 3620.5293, 3748.5879, 3885.6468, 3942.6682, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QQHHHQHHQHHQQLPHQHLPHSHQQQAMQQSR", {129.0659, 257.1244, 394.1833, 531.2423, 668.3012, 796.3597, 933.4187, 1070.4776, 1198.5361, 1335.5951, 1472.6540, 1600.7125, 1728.7711, 1841.8552, 1938.9080, 2075.9669, 2204.0254, 2341.0844, 2454.1684, 2551.2212, 2688.2801, 2775.3121, 2912.3710, 3040.4296, 3168.4882, 3296.5468, 3367.5839, 3498.6244, 3626.6829, 3754.7415, 3841.7735, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 262.1510, 390.2096, 518.2681, 649.3086, 720.3457, 848.4043, 976.4629, 1104.5215, 1241.5804, 1328.6124, 1465.6713, 1562.7241, 1675.8081, 1812.8671, 1940.9256, 2077.9845, 2175.0373, 2288.1214, 2416.1800, 2544.2385, 2681.2974, 2818.3564, 2946.4149, 3083.4738, 3220.5328, 3348.5913, 3485.6502, 3622.7092, 3759.7681, 3887.8266, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MNEWLYELYPMWSAALHCNQLCVWYGMEQANK", {132.0478, 246.0907, 375.1333, 561.2126, 674.2967, 837.3600, 966.4026, 1079.4866, 1242.5500, 1339.6027, 1470.6432, 1656.7225, 1743.7546, 1814.7917, 1885.8288, 1998.9129, 2135.9718, 2296.0024, 2410.0453, 2538.1039, 2651.1880, 2811.2186, 2910.2870, 3096.3664, 3259.4297, 3316.4512, 3447.4916, 3576.5342, 3704.5928, 3775.6299, 3889.6728, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 261.1557, 332.1928, 460.2514, 589.2940, 720.3345, 777.3560, 940.4193, 1126.4986, 1225.5670, 1385.5977, 1498.6817, 1626.7403, 1740.7832, 1900.8139, 2037.8728, 2150.9569, 2221.9940, 2293.0311, 2380.0631, 2566.1424, 2697.1829, 2794.2357, 2957.2990, 3070.3831, 3199.4257, 3362.4890, 3475.5731, 3661.6524, 3790.6950, 3904.7379, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NIYVCTHFLNFLHWFGMCVLVVTQALSWWLVR", {115.0502, 228.1343, 391.1976, 490.2660, 650.2967, 751.3443, 888.4032, 1035.4717, 1148.5557, 1262.5987, 1409.6671, 1522.7511, 1659.8100, 1845.8894, 1992.9578, 2049.9792, 2181.0197, 2341.0504, 2440.1188, 2553.2028, 2652.2713, 2751.3397, 2852.3874, 2980.4459, 3051.4830, 3164.5671, 3251.5991, 3437.6784, 3623.7578, 3736.8418, 3835.9102, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 274.1874, 387.2714, 573.3507, 759.4301, 846.4621, 959.5461, 1030.5833, 1158.6418, 1259.6895, 1358.7579, 1457.8263, 1570.9104, 1669.9788, 1830.0095, 1961.0500, 2018.0714, 2165.1398, 2351.2191, 2488.2781, 2601.3621, 2748.4305, 2862.4735, 2975.5575, 3122.6259, 3259.6849, 3360.7325, 3520.7632, 3619.8316, 3782.8949, 3895.9790, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EVELCIGIFCQFCINLSLHWYDSHLLMYTLLR", {130.0499, 229.1183, 358.1609, 471.2449, 631.2756, 744.3597, 801.3811, 914.4652, 1061.5336, 1221.5642, 1349.6228, 1496.6912, 1656.7219, 1769.8059, 1883.8489, 1996.9329, 2083.9650, 2197.0490, 2334.1079, 2520.1873, 2683.2506, 2798.2775, 2885.3096, 3022.3685, 3135.4525, 3248.5366, 3379.5771, 3542.6404, 3643.6881, 3756.7722, 3869.8562, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 401.2871, 502.3348, 665.3981, 796.4386, 909.5226, 1022.6067, 1159.6656, 1246.6976, 1361.7246, 1524.7879, 1710.8672, 1847.9261, 1961.0102, 2048.0422, 2161.1263, 2275.1692, 2388.2533, 2548.2839, 2695.3523, 2823.4109, 2983.4416, 3130.5100, 3243.5941, 3300.6155, 3413.6996, 3573.7302, 3686.8143, 3815.8569, 3914.9253, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PSYYSIRPICHMCIMVLFIILALVYCPFPLYR", {98.0600, 185.0921, 348.1554, 511.2187, 598.2508, 711.3348, 867.4359, 964.4887, 1077.5728, 1237.6034, 1374.6623, 1505.7028, 1665.7335, 1778.8175, 1909.8580, 2008.9264, 2122.0105, 2269.0789, 2382.1630, 2495.2470, 2608.3311, 2679.3682, 2792.4523, 2891.5207, 3054.5840, 3214.6147, 3311.6674, 3458.7358, 3555.7886, 3668.8727, 3831.9360, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 451.2663, 548.3191, 695.3875, 792.4403, 952.4709, 1115.5343, 1214.6027, 1327.6867, 1398.7239, 1511.8079, 1624.8920, 1737.9760, 1885.0445, 1998.1285, 2097.1969, 2228.2374, 2341.3215, 2501.3521, 2632.3926, 2769.4515, 2929.4822, 3042.5662, 3139.6190, 3295.7201, 3408.8042, 3495.8362, 3658.8995, 3821.9629, 3908.9949, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"KPTWIHLAIWTQSLLWLIWAWAMQETVFNNFR", {129.1022, 226.1550, 327.2027, 513.2820, 626.3661, 763.4250, 876.5090, 947.5461, 1060.6302, 1246.7095, 1347.7572, 1475.8158, 1562.8478, 1675.9319, 1789.0159, 1975.0953, 2088.1793, 2201.2634, 2387.3427, 2458.3798, 2644.4591, 2715.4962, 2846.5367, 2974.5953, 3103.6379, 3204.6856, 3303.7540, 3450.8224, 3564.8653, 3678.9082, 3825.9767, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 436.2303, 550.2732, 697.3416, 796.4100, 897.4577, 1026.5003, 1154.5589, 1285.5994, 1356.6365, 1542.7158, 1613.7529, 1799.8322, 1912.9163, 2026.0004, 2212.0797, 2325.1637, 2438.2478, 2525.2798, 2653.3384, 2754.3861, 2940.4654, 3053.5495, 3124.5866, 3237.6706, 3374.7296, 3487.8136, 3673.8929, 3774.9406, 3871.9934, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PQQHHPQQHHPHTPHHQMSPHPQHHTQYEHHR", {98.0600, 226.1186, 354.1772, 491.2361, 628.2950, 725.3478, 853.4064, 981.4649, 1118.5239, 1255.5828, 1352.6355, 1489.6944, 1590.7421, 1687.7949, 1824.8538, 1961.9127, 2089.9713, 2221.0118, 2308.0438, 2405.0966, 2542.1555, 2639.2082, 2767.2668, 2904.3257, 3041.3846, 3142.4323, 3270.4909, 3433.5542, 3562.5968, 3699.6557, 3836.7146, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 312.1779, 449.2368, 578.2794, 741.3427, 869.4013, 970.4490, 1107.5079, 1244.5668, 1372.6254, 1469.6781, 1606.7370, 1703.7898, 1790.8218, 1921.8623, 2049.9209, 2186.9798, 2324.0387, 2421.0915, 2522.1392, 2659.1981, 2756.2508, 2893.3097, 3030.3687, 3158.4272, 3286.4858, 3383.5386, 3520.5975, 3657.6564, 3785.7150, 3913.7735, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"HQQQQHQNHSHQQQLQHHQLQQLQQTQYPPEK", {138.0662, 266.1248, 394.1833, 522.2419, 650.3005, 787.3594, 915.4180, 1029.4609, 1166.5198, 1253.5519, 1390.6108, 1518.6693, 1646.7279, 1774.7865, 1887.8706, 2015.9291, 2152.9881, 2290.0470, 2418.1055, 2531.1896, 2659.2482, 2787.3068, 2900.3908, 3028.4494, 3156.5080, 3257.5557, 3385.6142, 3548.6776, 3645.7303, 3742.7831, 3871.8257, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 276.1554, 373.2082, 470.2609, 633.3243, 761.3828, 862.4305, 990.4891, 1118.5477, 1231.6317, 1359.6903, 1487.7489, 1600.8329, 1728.8915, 1865.9504, 2003.0093, 2131.0679, 2244.1520, 2372.2106, 2500.2691, 2628.3277, 2765.3866, 2852.4187, 2989.4776, 3103.5205, 3231.5791, 3368.6380, 3496.6966, 3624.7551, 3752.8137, 3880.8723, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FLSPWAETDDYNQIDCQETFNLYMNWTDKPIR", {148.0757, 261.1598, 348.1918, 445.2445, 631.3239, 702.3610, 831.4036, 932.4512, 1047.4782, 1162.5051, 1325.5685, 1439.6114, 1567.6700, 1680.7540, 1795.7810, 1955.8116, 2083.8702, 2212.9128, 2313.9605, 2461.0289, 2575.0718, 2688.1559, 2851.2192, 2982.2597, 3096.3026, 3282.3819, 3383.4296, 3498.4566, 3626.5515, 3723.6043, 3836.6883, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 385.2558, 513.3507, 628.3777, 729.4254, 915.5047, 1029.5476, 1160.5881, 1323.6514, 1436.7355, 1550.7784, 1697.8468, 1798.8945, 1927.9371, 2055.9957, 2216.0263, 2331.0533, 2444.1373, 2572.1959, 2686.2388, 2849.3022, 2964.3291, 3079.3560, 3180.4037, 3309.4463, 3380.4834, 3566.5627, 3663.6155, 3750.6475, 3863.7316, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YLWRPSEPFWWLLVLSAMVLLSYFSLAYPWLR", {164.0706, 277.1547, 463.2340, 619.3351, 716.3879, 803.4199, 932.4625, 1029.5152, 1176.5837, 1362.6630, 1548.7423, 1661.8263, 1774.9104, 1873.9788, 1987.0629, 2074.0949, 2145.1320, 2276.1725, 2375.2409, 2488.3250, 2601.4091, 2688.4411, 2851.5044, 2998.5728, 3085.6049, 3198.6889, 3269.7260, 3432.7894, 3529.8421, 3715.9214, 3829.0055, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 474.2823, 571.3351, 734.3984, 805.4355, 918.5196, 1005.5516, 1152.6200, 1315.6834, 1402.7154, 1515.7995, 1628.8835, 1727.9519, 1858.9924, 1930.0295, 2017.0616, 2130.1456, 2229.2140, 2342.2981, 2455.3822, 2641.4615, 2827.5408, 2974.6092, 3071.6620, 3200.7046, 3287.7366, 3384.7894, 3540.8905, 3726.9698, 3840.0539, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"CDEMQELLDIICQQQKPYHMFEAQFMNTPIFK", {161.0379, 276.0649, 405.1075, 536.1479, 664.2065, 793.2491, 906.3332, 1019.4172, 1134.4442, 1247.5283, 1360.6123, 1520.6430, 1648.7015, 1776.7601, 1904.8187, 2032.9137, 2129.9664, 2293.0298, 2430.0887, 2561.1291, 2708.1976, 2837.2402, 2908.2773, 3036.3358, 3183.4043, 3314.4447, 3428.4877, 3529.5354, 3626.5881, 3739.6722, 3886.7406, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 294.1812, 407.2653, 504.3180, 605.3657, 719.4087, 850.4491, 997.5176, 1125.5761, 1196.6132, 1325.6558, 1472.7242, 1603.7647, 1740.8236, 1903.8870, 2000.9397, 2129.0347, 2257.0933, 2385.1519, 2513.2104, 2673.2411, 2786.3251, 2899.4092, 3014.4362, 3127.5202, 3240.6043, 3369.6469, 3497.7055, 3628.7459, 3757.7885, 3872.8155, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YFFFFLLEDHMEEIKPEQLSMNVNFLYNLPLK", {164.0706, 311.1390, 458.2074, 605.2758, 752.3443, 865.4283, 978.5124, 1107.5550, 1222.5819, 1359.6408, 1490.6813, 1619.7239, 1748.7665, 1861.8506, 1989.9455, 2086.9983, 2216.0409, 2344.0995, 2457.1835, 2544.2156, 2675.2560, 2789.2990, 2888.3674, 3002.4103, 3149.4787, 3262.5628, 3425.6261, 3539.6690, 3652.7531, 3749.8059, 3862.8899, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 357.2496, 470.3337, 584.3766, 747.4400, 860.5240, 1007.5924, 1121.6354, 1220.7038, 1334.7467, 1465.7872, 1552.8192, 1665.9033, 1793.9619, 1923.0044, 2020.0572, 2148.1522, 2261.2362, 2390.2788, 2519.3214, 2650.3619, 2787.4208, 2902.4478, 3031.4904, 3144.5744, 3257.6585, 3404.7269, 3551.7953, 3698.8637, 3845.9321, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ATANNYYAYSICIEVFNFELWVQQYDVFNFHR", {72.0444, 173.0921, 244.1292, 358.1721, 472.2150, 635.2784, 798.3417, 869.3788, 1032.4421, 1119.4742, 1232.5582, 1392.5889, 1505.6729, 1634.7155, 1733.7839, 1880.8524, 1994.8953, 2141.9637, 2271.0063, 2384.0904, 2570.1697, 2669.2381, 2797.2967, 2925.3552, 3088.4186, 3203.4455, 3302.5139, 3449.5823, 3563.6253, 3710.6937, 3847.7526, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 312.1779, 459.2463, 573.2892, 720.3576, 819.4260, 934.4530, 1097.5163, 1225.5749, 1353.6335, 1452.7019, 1638.7812, 1751.8653, 1880.9078, 2027.9763, 2142.0192, 2289.0876, 2388.1560, 2517.1986, 2630.2827, 2790.3133, 2903.3974, 2990.4294, 3153.4927, 3224.5299, 3387.5932, 3550.6565, 3664.6994, 3778.7424, 3849.7795, 3950.8272, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SNLEELFDLFHNVDRPCNQEAWDAYQLYWVSR", {88.0393, 202.0822, 315.1663, 444.2089, 573.2515, 686.3355, 833.4040, 948.4309, 1061.5150, 1208.5834, 1345.6423, 1459.6852, 1558.7536, 1673.7806, 1829.8817, 1926.9345, 2086.9651, 2201.0080, 2329.0666, 2458.1092, 2529.1463, 2715.2256, 2830.2526, 2901.2897, 3064.3530, 3192.4116, 3305.4957, 3468.5590, 3654.6383, 3753.7067, 3840.7387, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 262.1510, 361.2194, 547.2987, 710.3620, 823.4461, 951.5047, 1114.5680, 1185.6051, 1300.6321, 1486.7114, 1557.7485, 1686.7911, 1814.8497, 1928.8926, 2088.9232, 2185.9760, 2342.0771, 2457.1041, 2556.1725, 2670.2154, 2807.2743, 2954.3427, 3067.4268, 3182.4537, 3329.5221, 3442.6062, 3571.6488, 3700.6914, 3813.7755, 3927.8184, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"HSWGFVFEAQCCHALNVFNFVLWLLHLWSQEK", {138.0662, 225.0982, 411.1775, 468.1990, 615.2674, 714.3358, 861.4042, 990.4468, 1061.4839, 1189.5425, 1349.5732, 1509.6038, 1646.6627, 1717.6998, 1830.7839, 1944.8268, 2043.8952, 2190.9637, 2305.0066, 2452.0750, 2551.1434, 2664.2275, 2850.3068, 2963.3909, 3076.4749, 3213.5338, 3326.6179, 3512.6972, 3599.7292, 3727.7878, 3856.8304, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 276.1554, 404.2140, 491.2460, 677.3253, 790.4094, 927.4683, 1040.5524, 1153.6364, 1339.7157, 1452.7998, 1551.8682, 1698.9366, 1812.9796, 1960.0480, 2059.1164, 2173.1593, 2286.2434, 2357.2805, 2494.3394, 2654.3700, 2814.4007, 2942.4593, 3013.4964, 3142.5390, 3289.6074, 3388.6758, 3535.7442, 3592.7657, 3778.8450, 3865.8770, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"IYMCCGMPTILMQFIYWMEYYPSEYENLGPIK", {114.0913, 277.1547, 408.1952, 568.2258, 728.2565, 785.2779, 916.3184, 1013.3712, 1114.4188, 1227.5029, 1340.5870, 1471.6275, 1599.6860, 1746.7544, 1859.8385, 2022.9018, 2208.9812, 2340.0216, 2469.0642, 2632.1276, 2795.1909, 2892.2437, 2979.2757, 3108.3183, 3271.3816, 3400.4242, 3514.4671, 3627.5512, 3684.5726, 3781.6254, 3894.7095, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 357.2496, 414.2711, 527.3552, 641.3981, 770.4407, 933.5040, 1062.5466, 1149.5786, 1246.6314, 1409.6947, 1572.7581, 1701.8006, 1832.8411, 2018.9204, 2181.9838, 2295.0678, 2442.1362, 2570.1948, 2701.2353, 2814.3194, 2927.4034, 3028.4511, 3125.5039, 3256.5444, 3313.5658, 3473.5965, 3633.6271, 3764.6676, 3927.7309, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YEYYEQVGQSQWFFSFFPMGQMYPVLQLVFDR", {164.0706, 293.1132, 456.1765, 619.2399, 748.2824, 876.3410, 975.4094, 1032.4309, 1160.4895, 1247.5215, 1375.5801, 1561.6594, 1708.7278, 1855.7962, 1942.8283, 2089.8967, 2236.9651, 2334.0178, 2465.0583, 2522.0798, 2650.1384, 2781.1789, 2944.2422, 3041.2950, 3140.3634, 3253.4474, 3381.5060, 3494.5901, 3593.6585, 3740.7269, 3855.7538, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 290.1459, 437.2143, 536.2827, 649.3668, 777.4254, 890.5094, 989.5778, 1086.6306, 1249.6939, 1380.7344, 1508.7930, 1565.8145, 1696.8549, 1793.9077, 1940.9761, 2088.0445, 2175.0766, 2322.1450, 2469.2134, 2655.2927, 2783.3513, 2870.3833, 2998.4419, 3055.4634, 3154.5318, 3282.5903, 3411.6329, 3574.6963, 3737.7596, 3866.8022, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MEKPASDFYMLINIVCMYLEYFYINIDEIFHK", {132.0478, 261.0904, 389.1853, 486.2381, 557.2752, 644.3072, 759.3342, 906.4026, 1069.4659, 1200.5064, 1313.5905, 1426.6745, 1540.7174, 1653.8015, 1752.8699, 1912.9006, 2043.9411, 2207.0044, 2320.0885, 2449.1310, 2612.1944, 2759.2628, 2922.3261, 3035.4102, 3149.4531, 3262.5372, 3377.5641, 3506.6067, 3619.6908, 3766.7592, 3903.8181, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 284.1717, 431.2401, 544.3242, 673.3668, 788.3937, 901.4778, 1015.5207, 1128.6048, 1291.6681, 1438.7365, 1601.7999, 1730.8425, 1843.9265, 2006.9898, 2138.0303, 2298.0610, 2397.1294, 2510.2135, 2624.2564, 2737.3404, 2850.4245, 2981.4650, 3144.5283, 3291.5967, 3406.6237, 3493.6557, 3564.6928, 3661.7456, 3789.8405, 3918.8831, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"AECWGIPHLDPSDDELWFYYETPWCDLHLQVR", {72.0444, 201.0870, 361.1176, 547.1969, 604.2184, 717.3025, 814.3552, 951.4141, 1064.4982, 1179.5252, 1276.5779, 1363.6099, 1478.6369, 1593.6638, 1722.7064, 1835.7905, 2021.8698, 2168.9382, 2332.0015, 2495.0649, 2624.1075, 2725.1551, 2822.2079, 3008.2872, 3168.3179, 3283.3448, 3396.4289, 3533.4878, 3646.5719, 3774.6304, 3873.6988, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 274.1874, 402.2459, 515.3300, 652.3889, 765.4730, 880.4999, 1040.5306, 1226.6099, 1323.6627, 1424.7103, 1553.7529, 1716.8163, 1879.8796, 2026.9480, 2213.0273, 2326.1114, 2455.1540, 2570.1809, 2685.2079, 2772.2399, 2869.2926, 2984.3196, 3097.4037, 3234.4626, 3331.5153, 3444.5994, 3501.6209, 3687.7002, 3847.7308, 3976.7734, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NYEYFIDQIMLTHEVLDYDYLQSHQNEQSTQR", {115.0502, 278.1135, 407.1561, 570.2195, 717.2879, 830.3719, 945.3989, 1073.4575, 1186.5415, 1317.5820, 1430.6661, 1531.7137, 1668.7727, 1797.8152, 1896.8837, 2009.9677, 2124.9947, 2288.0580, 2403.0849, 2566.1483, 2679.2323, 2807.2909, 2894.3229, 3031.3819, 3159.4404, 3273.4834, 3402.5260, 3530.5845, 3617.6166, 3718.6642, 3846.7228, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 404.2252, 491.2572, 619.3158, 748.3584, 862.4013, 990.4599, 1127.5188, 1214.5509, 1342.6094, 1455.6935, 1618.7568, 1733.7838, 1896.8471, 2011.8740, 2124.9581, 2224.0265, 2353.0691, 2490.1280, 2591.1757, 2704.2598, 2835.3002, 2948.3843, 3076.4429, 3191.4698, 3304.5539, 3451.6223, 3614.6856, 3743.7282, 3906.7916, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LLWYFPIMSTLLSPYFEIVTFIGFTVWYILWR", {114.0913, 227.1754, 413.2547, 576.3180, 723.3865, 820.4392, 933.5233, 1064.5638, 1151.5958, 1252.6435, 1365.7275, 1478.8116, 1565.8436, 1662.8964, 1825.9597, 1973.0281, 2102.0707, 2215.1548, 2314.2232, 2415.2709, 2562.3393, 2675.4234, 2732.4448, 2879.5132, 2980.5609, 3079.6293, 3265.7087, 3428.7720, 3541.8560, 3654.9401, 3841.0194, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 361.1983, 474.2823, 587.3664, 750.4297, 936.5090, 1035.5774, 1136.6251, 1283.6935, 1340.7150, 1453.7991, 1600.8675, 1701.9152, 1800.9836, 1914.0676, 2043.1102, 2190.1786, 2353.2420, 2450.2947, 2537.3268, 2650.4108, 2763.4949, 2864.5426, 2951.5746, 3082.6151, 3195.6992, 3292.7519, 3439.8203, 3602.8837, 3788.9630, 3902.0470, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MFEPDPYWYHTDYPEYPPGPPYLEDWSPDCEK", {132.0478, 279.1162, 408.1588, 505.2115, 620.2385, 717.2912, 880.3546, 1066.4339, 1229.4972, 1366.5561, 1467.6038, 1582.6307, 1745.6941, 1842.7468, 1971.7894, 2134.8528, 2231.9055, 2328.9583, 2385.9797, 2483.0325, 2580.0853, 2743.1486, 2856.2327, 2985.2753, 3100.3022, 3286.3815, 3373.4135, 3470.4663, 3585.4933, 3745.5239, 3874.5665, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 276.1554, 436.1860, 551.2130, 648.2658, 735.2978, 921.3771, 1036.4040, 1165.4466, 1278.5307, 1441.5940, 1538.6468, 1635.6996, 1692.7210, 1789.7738, 1886.8265, 2049.8899, 2178.9325, 2275.9852, 2439.0486, 2554.0755, 2655.1232, 2792.1821, 2955.2454, 3141.3247, 3304.3881, 3401.4408, 3516.4678, 3613.5205, 3742.5631, 3889.6315, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"CFSYEDEGADCAHYFISFFMAFFYIVGETYYR", {161.0379, 308.1063, 395.1384, 558.2017, 687.2443, 802.2712, 931.3138, 988.3353, 1059.3724, 1174.3993, 1334.4300, 1405.4671, 1542.5260, 1705.5893, 1852.6578, 1965.7418, 2052.7739, 2199.8423, 2346.9107, 2477.9512, 2548.9883, 2696.0567, 2843.1251, 3006.1884, 3119.2725, 3218.3409, 3275.3624, 3404.4050, 3505.4527, 3668.5160, 3831.5793, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 501.2456, 602.2933, 731.3359, 788.3573, 887.4258, 1000.5098, 1163.5732, 1310.6416, 1457.7100, 1528.7471, 1659.7876, 1806.8560, 1953.9244, 2040.9564, 2154.0405, 2301.1089, 2464.1722, 2601.2312, 2672.2683, 2832.2989, 2947.3259, 3018.3630, 3075.3844, 3204.4270, 3319.4540, 3448.4966, 3611.5599, 3698.5919, 3845.6603, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"IGINLWILYCTLMAQLPMIWIWHMFIFGYDLR", {114.0913, 171.1128, 284.1969, 398.2398, 511.3239, 697.4032, 810.4872, 923.5713, 1086.6346, 1246.6653, 1347.7130, 1460.7970, 1591.8375, 1662.8746, 1790.9332, 1904.0173, 2001.0700, 2132.1105, 2245.1946, 2431.2739, 2544.3579, 2730.4373, 2867.4962, 2998.5367, 3145.6051, 3258.6891, 3405.7576, 3462.7790, 3625.8423, 3740.8693, 3853.9534, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 403.2300, 566.2933, 623.3148, 770.3832, 883.4672, 1030.5356, 1161.5761, 1298.6350, 1484.7144, 1597.7984, 1783.8777, 1896.9618, 2028.0023, 2125.0550, 2238.1391, 2366.1977, 2437.2348, 2568.2753, 2681.3593, 2782.4070, 2942.4377, 3105.5010, 3218.5851, 3331.6691, 3517.7484, 3630.8325, 3744.8754, 3857.9595, 3914.9810, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NDCEDEQDAYDQENDQDQQSEVMCLWQSNHNR", {115.0502, 230.0771, 390.1078, 519.1504, 634.1773, 763.2199, 891.2785, 1006.3054, 1077.3426, 1240.4059, 1355.4328, 1483.4914, 1612.5340, 1726.5769, 1841.6039, 1969.6624, 2084.6894, 2212.7480, 2340.8065, 2427.8386, 2556.8812, 2655.9496, 2786.9901, 2947.0207, 3060.1048, 3246.1841, 3374.2427, 3461.2747, 3575.3176, 3712.3765, 3826.4195, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 289.1619, 426.2208, 540.2637, 627.2957, 755.3543, 941.4336, 1054.5177, 1214.5484, 1345.5888, 1444.6572, 1573.6998, 1660.7319, 1788.7904, 1916.8490, 2031.8760, 2159.9345, 2274.9615, 2389.0044, 2518.0470, 2646.1056, 2761.1325, 2924.1959, 2995.2330, 3110.2599, 3238.3185, 3367.3611, 3482.3880, 3611.4306, 3771.4613, 3886.4882, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DIALYWTHALCESDTAYNQVYLLTWYWNGECR", {116.0342, 229.1183, 300.1554, 413.2395, 576.3028, 762.3821, 863.4298, 1000.4887, 1071.5258, 1184.6099, 1344.6405, 1473.6831, 1560.7151, 1675.7421, 1776.7898, 1847.8269, 2010.8902, 2124.9331, 2252.9917, 2352.0601, 2515.1235, 2628.2075, 2741.2916, 2842.3393, 3028.4186, 3191.4819, 3377.5612, 3491.6041, 3548.6256, 3677.6682, 3837.6988, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 335.1496, 464.1922, 521.2137, 635.2566, 821.3359, 984.3992, 1170.4785, 1271.5262, 1384.6103, 1497.6943, 1660.7577, 1759.8261, 1887.8847, 2001.9276, 2164.9909, 2236.0280, 2337.0757, 2452.1027, 2539.1347, 2668.1773, 2828.2079, 2941.2920, 3012.3291, 3149.3880, 3250.4357, 3436.5150, 3599.5783, 3712.6624, 3783.6995, 3896.7836, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"HWYQSWAVFFDCLCVLDFEMTLSHFGTTYLFK", {138.0662, 324.1455, 487.2088, 615.2674, 702.2994, 888.3787, 959.4159, 1058.4843, 1205.5527, 1352.6211, 1467.6480, 1627.6787, 1740.7628, 1900.7934, 1999.8618, 2112.9459, 2227.9728, 2375.0412, 2504.0838, 2635.1243, 2736.1720, 2849.2561, 2936.2881, 3073.3470, 3220.4154, 3277.4369, 3378.4846, 3479.5322, 3642.5956, 3755.6796, 3902.7480, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 294.1812, 407.2653, 570.3286, 671.3763, 772.4240, 829.4454, 976.5138, 1113.5728, 1200.6048, 1313.6888, 1414.7365, 1545.7770, 1674.8196, 1821.8880, 1936.9150, 2049.9990, 2149.0674, 2309.0981, 2422.1822, 2582.2128, 2697.2397, 2844.3082, 2991.3766, 3090.4450, 3161.4821, 3347.5614, 3434.5934, 3562.6520, 3725.7153, 3911.7947, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DNTFNTWYEFFQDPTCQALTLTCAKPSFHYFR", {116.0342, 230.0771, 331.1248, 478.1932, 592.2362, 693.2838, 879.3632, 1042.4265, 1171.4691, 1318.5375, 1465.6059, 1593.6645, 1708.6914, 1805.7442, 1906.7919, 2066.8225, 2194.8811, 2265.9182, 2379.0023, 2480.0500, 2593.1340, 2694.1817, 2854.2123, 2925.2495, 3053.3444, 3150.3972, 3237.4292, 3384.4976, 3521.5565, 3684.6199, 3831.6883, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 485.2507, 622.3096, 769.3780, 856.4100, 953.4628, 1081.5578, 1152.5949, 1312.6255, 1413.6732, 1526.7573, 1627.8050, 1740.8890, 1811.9261, 1939.9847, 2100.0154, 2201.0630, 2298.1158, 2413.1427, 2541.2013, 2688.2697, 2835.3382, 2964.3807, 3127.4441, 3313.5234, 3414.5711, 3528.6140, 3675.6824, 3776.7301, 3890.7730, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LSHHQQQQLQHQQQHQQQHQLHAQQMHPHSYR", {114.0913, 201.1234, 338.1823, 475.2412, 603.2998, 731.3583, 859.4169, 987.4755, 1100.5596, 1228.6181, 1365.6771, 1493.7356, 1621.7942, 1749.8528, 1886.9117, 2014.9703, 2143.0289, 2271.0874, 2408.1463, 2536.2049, 2649.2890, 2786.3479, 2857.3850, 2985.4436, 3113.5022, 3244.5427, 3381.6016, 3478.6543, 3615.7132, 3702.7453, 3865.8086, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 425.2143, 562.2732, 659.3260, 796.3849, 927.4254, 1055.4840, 1183.5425, 1254.5797, 1391.6386, 1504.7226, 1632.7812, 1769.8401, 1897.8987, 2025.9573, 2154.0158, 2291.0748, 2419.1333, 2547.1919, 2675.2505, 2812.3094, 2940.3680, 3053.4520, 3181.5106, 3309.5692, 3437.6278, 3565.6864, 3702.7453, 3839.8042, 3926.8362, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YCEYNTIDHYHYTAYSFYGVVCLHLLVYISIR", {164.0706, 324.1013, 453.1438, 616.2072, 730.2501, 831.2978, 944.3818, 1059.4088, 1196.4677, 1359.5310, 1496.5899, 1659.6533, 1760.7009, 1831.7381, 1994.8014, 2081.8334, 2228.9018, 2391.9652, 2448.9866, 2548.0550, 2647.1235, 2807.1541, 2920.2382, 3057.2971, 3170.3811, 3283.4652, 3382.5336, 3545.5969, 3658.6810, 3745.7130, 3858.7971, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 375.2350, 488.3191, 651.3824, 750.4509, 863.5349, 976.6190, 1113.6779, 1226.7620, 1386.7926, 1485.8610, 1584.9294, 1641.9509, 1805.0142, 1952.0826, 2039.1147, 2202.1780, 2273.2151, 2374.2628, 2537.3261, 2674.3850, 2837.4484, 2974.5073, 3089.5342, 3202.6183, 3303.6660, 3417.7089, 3580.7722, 3709.8148, 3869.8455, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YNYHIQWYFTLAYMLLFEHFVLLAALIFDNLR", {164.0706, 278.1135, 441.1769, 578.2358, 691.3198, 819.3784, 1005.4577, 1168.5211, 1315.5895, 1416.6371, 1529.7212, 1600.7583, 1763.8217, 1894.8621, 2007.9462, 2121.0303, 2268.0987, 2397.1413, 2534.2002, 2681.2686, 2780.3370, 2893.4211, 3006.5051, 3077.5423, 3148.5794, 3261.6634, 3374.7475, 3521.8159, 3636.8429, 3750.8858, 3863.9698, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 402.2459, 517.2729, 664.3413, 777.4254, 890.5094, 961.5465, 1032.5837, 1145.6677, 1258.7518, 1357.8202, 1504.8886, 1641.9475, 1770.9901, 1918.0585, 2031.1426, 2144.2267, 2275.2671, 2438.3305, 2509.3676, 2622.4517, 2723.4993, 2870.5677, 3033.6311, 3219.7104, 3347.7690, 3460.8530, 3597.9119, 3760.9753, 3875.0182, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YEELIETFLFYVSNYDLLDEYLRPESENTFNR", {164.0706, 293.1132, 422.1558, 535.2399, 648.3239, 777.3665, 878.4142, 1025.4826, 1138.5667, 1285.6351, 1448.6984, 1547.7668, 1634.7989, 1748.8418, 1911.9051, 2026.9321, 2140.0161, 2253.1002, 2368.1271, 2497.1697, 2660.2330, 2773.3171, 2929.4182, 3026.4710, 3155.5136, 3242.5456, 3371.5882, 3485.6311, 3586.6788, 3733.7472, 3847.7901, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 289.1619, 436.2303, 537.2780, 651.3209, 780.3635, 867.3955, 996.4381, 1093.4909, 1249.5920, 1362.6761, 1525.7394, 1654.7820, 1769.8089, 1882.8930, 1995.9770, 2111.0040, 2274.0673, 2388.1102, 2475.1423, 2574.2107, 2737.2740, 2884.3424, 2997.4265, 3144.4949, 3245.5426, 3374.5852, 3487.6692, 3600.7533, 3729.7959, 3858.8385, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EQLLFCFVYLLFLISVGYLYTFFTEYYLVPLR", {130.0499, 258.1084, 371.1925, 484.2766, 631.3450, 791.3756, 938.4441, 1037.5125, 1200.5758, 1313.6599, 1426.7439, 1573.8123, 1686.8964, 1799.9805, 1887.0125, 1986.0809, 2043.1024, 2206.1657, 2319.2498, 2482.3131, 2583.3608, 2730.4292, 2877.4976, 2978.5453, 3107.5879, 3270.6512, 3433.7145, 3546.7986, 3645.8670, 3742.9198, 3856.0038, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 385.2558, 484.3242, 597.4083, 760.4716, 923.5349, 1052.5775, 1153.6252, 1300.6936, 1447.7620, 1548.8097, 1711.8730, 1824.9571, 1988.0204, 2045.0419, 2144.1103, 2231.1423, 2344.2264, 2457.3104, 2604.3789, 2717.4629, 2830.5470, 2993.6103, 3092.6787, 3239.7471, 3399.7778, 3546.8462, 3659.9303, 3773.0143, 3901.0729, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"HEHMVLHHDCSTCYEPHDQCSACNPECPVCTR", {138.0662, 267.1088, 404.1677, 535.2082, 634.2766, 747.3607, 884.4196, 1021.4785, 1136.5054, 1296.5361, 1383.5681, 1484.6158, 1644.6464, 1807.7098, 1936.7523, 2033.8051, 2170.8640, 2285.8910, 2413.9495, 2573.9802, 2661.0122, 2732.0493, 2892.0800, 3006.1229, 3103.1757, 3232.2183, 3392.2489, 3489.3017, 3588.3701, 3748.4007, 3849.4484, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 276.1666, 436.1973, 535.2657, 632.3185, 792.3491, 921.3917, 1018.4445, 1132.4874, 1292.5180, 1363.5552, 1450.5872, 1610.6178, 1738.6764, 1853.7033, 1990.7623, 2087.8150, 2216.8576, 2379.9209, 2539.9516, 2640.9993, 2728.0313, 2888.0620, 3003.0889, 3140.1478, 3277.2067, 3390.2908, 3489.3592, 3620.3997, 3757.4586, 3886.5012, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PDFAYGIPCQEVLLFGDVCYYFYNCNQPYSFR", {98.0600, 213.0870, 360.1554, 431.1925, 594.2558, 651.2773, 764.3614, 861.4141, 1021.4448, 1149.5034, 1278.5460, 1377.6144, 1490.6984, 1603.7825, 1750.8509, 1807.8724, 1922.8993, 2021.9677, 2181.9984, 2345.0617, 2508.1250, 2655.1934, 2818.2568, 2932.2997, 3092.3304, 3206.3733, 3334.4319, 3431.4846, 3594.5479, 3681.5800, 3828.6484, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 409.2194, 572.2827, 669.3355, 797.3941, 911.4370, 1071.4676, 1185.5106, 1348.5739, 1495.6423, 1658.7056, 1821.7690, 1981.7996, 2080.8680, 2195.8950, 2252.9164, 2399.9849, 2513.0689, 2626.1530, 2725.2214, 2854.2640, 2982.3226, 3142.3532, 3239.4060, 3352.4900, 3409.5115, 3572.5748, 3643.6119, 3790.6804, 3905.7073, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"CFALHNNEQNASSCDIWNYENCLMLIEFEHLR", {161.0379, 308.1063, 379.1435, 492.2275, 629.2864, 743.3294, 857.3723, 986.4149, 1114.4735, 1228.5164, 1299.5535, 1386.5855, 1473.6176, 1633.6482, 1748.6751, 1861.7592, 2047.8385, 2161.8814, 2324.9448, 2453.9874, 2568.0303, 2728.0609, 2841.1450, 2972.1855, 3085.2696, 3198.3536, 3327.3962, 3474.4646, 3603.5072, 3740.5661, 3853.6502, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 425.2619, 554.3045, 701.3729, 830.4155, 943.4996, 1056.5837, 1187.6241, 1300.7082, 1460.7389, 1574.7818, 1703.8244, 1866.8877, 1980.9306, 2167.0099, 2280.0940, 2395.1210, 2555.1516, 2642.1836, 2729.2157, 2800.2528, 2914.2957, 3042.3543, 3171.3969, 3285.4398, 3399.4827, 3536.5416, 3649.6257, 3720.6628, 3867.7312, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MYYIYYAYPPNEEYTWEEPRPVDNDFLPNEPK", {132.0478, 295.1111, 458.1744, 571.2585, 734.3218, 897.3851, 968.4223, 1131.4856, 1228.5383, 1325.5911, 1439.6340, 1568.6766, 1697.7192, 1860.7826, 1961.8302, 2147.9095, 2276.9521, 2405.9947, 2503.0475, 2659.1486, 2756.2014, 2855.2698, 2970.2967, 3084.3397, 3199.3666, 3346.4350, 3459.5191, 3556.5718, 3670.6148, 3799.6574, 3896.7101, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 244.1656, 373.2082, 487.2511, 584.3039, 697.3879, 844.4563, 959.4833, 1073.5262, 1188.5531, 1287.6216, 1384.6743, 1540.7754, 1637.8282, 1766.8708, 1895.9134, 2081.9927, 2183.0404, 2346.1037, 2475.1463, 2604.1889, 2718.2318, 2815.2846, 2912.3373, 3075.4007, 3146.4378, 3309.5011, 3472.5644, 3585.6485, 3748.7118, 3911.7752, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TENNYYYQSHADYYLGTVHDYYYGSTEDYQYK", {102.0550, 231.0975, 345.1405, 459.1834, 622.2467, 785.3101, 948.3734, 1076.4320, 1163.4640, 1300.5229, 1371.5600, 1486.5870, 1649.6503, 1812.7136, 1925.7977, 1982.8191, 2083.8668, 2182.9352, 2319.9942, 2435.0211, 2598.0844, 2761.1478, 2924.2111, 2981.2325, 3068.2646, 3169.3123, 3298.3548, 3413.3818, 3576.4451, 3704.5037, 3867.5670, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 310.1761, 438.2347, 601.2980, 716.3250, 845.3676, 946.4153, 1033.4473, 1090.4687, 1253.5321, 1416.5954, 1579.6587, 1694.6857, 1831.7446, 1930.8130, 2031.8607, 2088.8821, 2201.9662, 2365.0295, 2528.0929, 2643.1198, 2714.1569, 2851.2158, 2938.2479, 3066.3064, 3229.3698, 3392.4331, 3555.4964, 3669.5394, 3783.5823, 3912.6249, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YEMTAELDMGLNLYNLLYVMFNYIVYAEYCER", {164.0706, 293.1132, 424.1537, 525.2014, 596.2385, 725.2811, 838.3651, 953.3921, 1084.4326, 1141.4540, 1254.5381, 1368.5810, 1481.6651, 1644.7284, 1758.7713, 1871.8554, 1984.9395, 2148.0028, 2247.0712, 2378.1117, 2525.1801, 2639.2230, 2802.2864, 2915.3704, 3014.4388, 3177.5022, 3248.5393, 3377.5819, 3540.6452, 3700.6759, 3829.7184, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 464.1922, 627.2555, 756.2981, 827.3352, 990.3986, 1089.4670, 1202.5510, 1365.6144, 1479.6573, 1626.7257, 1757.7662, 1856.8346, 2019.8979, 2132.9820, 2246.0661, 2360.1090, 2523.1723, 2636.2564, 2750.2993, 2863.3834, 2920.4048, 3051.4453, 3166.4723, 3279.5563, 3408.5989, 3479.6360, 3580.6837, 3711.7242, 3840.7668, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"IFYIYISICIALCILFTLVCCCVAAWFFLQLK", {114.0913, 261.1598, 424.2231, 537.3071, 700.3705, 813.4545, 900.4866, 1013.5706, 1173.6013, 1286.6853, 1357.7225, 1470.8065, 1630.8372, 1743.9212, 1857.0053, 2004.0737, 2105.1214, 2218.2055, 2317.2739, 2477.3045, 2637.3352, 2797.3658, 2896.4342, 2967.4713, 3038.5085, 3224.5878, 3371.6562, 3518.7246, 3631.8087, 3759.8672, 3872.9513, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 388.2554, 501.3395, 648.4079, 795.4763, 981.5557, 1052.5928, 1123.6299, 1222.6983, 1382.7289, 1542.7596, 1702.7902, 1801.8587, 1914.9427, 2015.9904, 2163.0588, 2276.1429, 2389.2269, 2549.2576, 2662.3416, 2733.3788, 2846.4628, 3006.4935, 3119.5775, 3206.6096, 3319.6936, 3482.7570, 3595.8410, 3758.9044, 3905.9728, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"HQQHHPTHHHQSHPHHHQSHQHQAHHHTHHLR", {138.0662, 266.1248, 394.1833, 531.2423, 668.3012, 765.3539, 866.4016, 1003.4605, 1140.5194, 1277.5783, 1405.6369, 1492.6690, 1629.7279, 1726.7806, 1863.8395, 2000.8985, 2137.9574, 2266.0159, 2353.0480, 2490.1069, 2618.1655, 2755.2244, 2883.2829, 2954.3201, 3091.3790, 3228.4379, 3365.4968, 3466.5445, 3603.6034, 3740.6623, 3853.7464, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 425.2619, 562.3208, 663.3685, 800.4274, 937.4863, 1074.5453, 1145.5824, 1273.6409, 1410.6999, 1538.7584, 1675.8173, 1762.8494, 1890.9080, 2027.9669, 2165.0258, 2302.0847, 2399.1375, 2536.1964, 2623.2284, 2751.2870, 2888.3459, 3025.4048, 3162.4637, 3263.5114, 3360.5641, 3497.6231, 3634.6820, 3762.7405, 3890.7991, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LRPGELIWYYPTLNYNWLCEGLSTDMYMVTCR", {114.0913, 270.1925, 367.2452, 424.2667, 553.3093, 666.3933, 779.4774, 965.5567, 1128.6200, 1291.6834, 1388.7361, 1489.7838, 1602.8679, 1716.9108, 1879.9741, 1994.0171, 2180.0964, 2293.1804, 2453.2111, 2582.2537, 2639.2751, 2752.3592, 2839.3912, 2940.4389, 3055.4659, 3186.5063, 3349.5697, 3480.6102, 3579.6786, 3680.7262, 3840.7569, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 335.1496, 436.1973, 535.2657, 666.3062, 829.3695, 960.4100, 1075.4369, 1176.4846, 1263.5166, 1376.6007, 1433.6222, 1562.6648, 1722.6954, 1835.7795, 2021.8588, 2135.9017, 2298.9650, 2413.0080, 2526.0920, 2627.1397, 2724.1925, 2887.2558, 3050.3191, 3236.3984, 3349.4825, 3462.5666, 3591.6092, 3648.6306, 3745.6834, 3901.7845, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"AIPITTAQYIFAYWFLVPQQWDFPTWMWFPLR", {72.0444, 185.1285, 282.1812, 395.2653, 496.3130, 597.3606, 668.3978, 796.4563, 959.5197, 1072.6037, 1219.6721, 1290.7093, 1453.7726, 1639.8519, 1786.9203, 1900.0044, 1999.0728, 2096.1255, 2224.1841, 2352.2427, 2538.3220, 2653.3490, 2800.4174, 2897.4701, 2998.5178, 3184.5971, 3315.6376, 3501.7169, 3648.7853, 3745.8381, 3858.9222, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 385.2558, 532.3242, 718.4035, 849.4440, 1035.5233, 1136.5710, 1233.6237, 1380.6922, 1495.7191, 1681.7984, 1809.8570, 1937.9156, 2034.9683, 2134.0367, 2247.1208, 2394.1892, 2580.2685, 2743.3319, 2814.3690, 2961.4374, 3074.5215, 3237.5848, 3365.6434, 3436.6805, 3537.7282, 3638.7758, 3751.8599, 3848.9127, 3961.9967, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"INCLFLLNLFMSICVPVMLINQYNTQNMWCHR", {114.0913, 228.1343, 388.1649, 501.2490, 648.3174, 761.4015, 874.4855, 988.5284, 1101.6125, 1248.6809, 1379.7214, 1466.7534, 1579.8375, 1739.8682, 1838.9366, 1935.9893, 2035.0577, 2166.0982, 2279.1823, 2392.2664, 2506.3093, 2634.3679, 2797.4312, 2911.4741, 3012.5218, 3140.5804, 3254.6233, 3385.6638, 3571.7431, 3731.7737, 3868.8327, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 312.1779, 472.2085, 658.2878, 789.3283, 903.3712, 1031.4298, 1132.4775, 1246.5204, 1409.5837, 1537.6423, 1651.6853, 1764.7693, 1877.8534, 2008.8939, 2107.9623, 2205.0150, 2304.0835, 2464.1141, 2577.1982, 2664.2302, 2795.2707, 2942.3391, 3055.4232, 3169.4661, 3282.5502, 3395.6342, 3542.7026, 3655.7867, 3815.8173, 3929.8603, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DYYWYQNGGQSHCDWLWVPANADWIQVDLCEK", {116.0342, 279.0975, 442.1609, 628.2402, 791.3035, 919.3621, 1033.4050, 1090.4265, 1147.4480, 1275.5065, 1362.5386, 1499.5975, 1659.6281, 1774.6551, 1960.7344, 2073.8184, 2259.8978, 2358.9662, 2456.0189, 2527.0560, 2641.0990, 2712.1361, 2827.1630, 3013.2423, 3126.3264, 3254.3850, 3353.4534, 3468.4803, 3581.5644, 3741.5951, 3870.6376, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 276.1554, 436.1860, 549.2701, 664.2971, 763.3655, 891.4240, 1004.5081, 1190.5874, 1305.6144, 1376.6515, 1490.6944, 1561.7315, 1658.7843, 1757.8527, 1943.9320, 2057.0161, 2243.0954, 2358.1223, 2518.1530, 2655.2119, 2742.2439, 2870.3025, 2927.3240, 2984.3454, 3098.3884, 3226.4469, 3389.5103, 3575.5896, 3738.6529, 3901.7162, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LCNLIALTLFPIIYNVILYCWHIYINIYTESR", {114.0913, 274.1220, 388.1649, 501.2490, 614.3330, 685.3702, 798.4542, 899.5019, 1012.5860, 1159.6544, 1256.7071, 1369.7912, 1482.8753, 1645.9386, 1759.9815, 1859.0499, 1972.1340, 2085.2181, 2248.2814, 2408.3120, 2594.3914, 2731.4503, 2844.5343, 3007.5977, 3120.6817, 3234.7247, 3347.8087, 3510.8720, 3611.9197, 3740.9623, 3827.9943, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 262.1510, 391.1936, 492.2413, 655.3046, 768.3886, 882.4316, 995.5156, 1158.5790, 1271.6630, 1408.7219, 1594.8013, 1754.8319, 1917.8952, 2030.9793, 2144.0634, 2243.1318, 2357.1747, 2520.2380, 2633.3221, 2746.4062, 2843.4589, 2990.5273, 3103.6114, 3204.6591, 3317.7431, 3388.7803, 3501.8643, 3614.9484, 3728.9913, 3889.0220, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QQHQQLAQHQQHTQQAQQQQHQQQQYHPHMPR", {129.0659, 257.1244, 394.1833, 522.2419, 650.3005, 763.3846, 834.4217, 962.4803, 1099.5392, 1227.5977, 1355.6563, 1492.7152, 1593.7629, 1721.8215, 1849.8801, 1920.9172, 2048.9758, 2177.0343, 2305.0929, 2433.1515, 2570.2104, 2698.2690, 2826.3276, 2954.3861, 3082.4447, 3245.5080, 3382.5670, 3479.6197, 3616.6786, 3747.7191, 3844.7719, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 272.1717, 403.2122, 540.2711, 637.3239, 774.3828, 937.4461, 1065.5047, 1193.5633, 1321.6218, 1449.6804, 1586.7393, 1714.7979, 1842.8565, 1970.9151, 2098.9736, 2170.0108, 2298.0693, 2426.1279, 2527.1756, 2664.2345, 2792.2931, 2920.3517, 3057.4106, 3185.4692, 3256.5063, 3369.5903, 3497.6489, 3625.7075, 3762.7664, 3890.8250, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"APQQEYQLYYQIHGLEHHVVYFYHSDVETCMK", {72.0444, 169.0972, 297.1557, 425.2143, 554.2569, 717.3202, 845.3788, 958.4629, 1121.5262, 1284.5895, 1412.6481, 1525.7322, 1662.7911, 1719.8125, 1832.8966, 1961.9392, 2098.9981, 2236.0570, 2335.1254, 2434.1939, 2597.2572, 2744.3256, 2907.3889, 3044.4478, 3131.4799, 3246.5068, 3345.5752, 3474.6178, 3575.6655, 3735.6961, 3866.7366, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 278.1533, 438.1839, 539.2316, 668.2742, 767.3426, 882.3696, 969.4016, 1106.4605, 1269.5238, 1416.5922, 1579.6556, 1678.7240, 1777.7924, 1914.8513, 2051.9102, 2180.9528, 2294.0369, 2351.0583, 2488.1173, 2601.2013, 2729.2599, 2892.3232, 3055.3866, 3168.4706, 3296.5292, 3459.5925, 3588.6351, 3716.6937, 3844.7523, 3941.8050, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"HVVINMFQMCAVMFDINFAEFNMFYEMLTQFR", {138.0662, 237.1346, 336.2030, 449.2871, 563.3300, 694.3705, 841.4389, 969.4975, 1100.5380, 1260.5686, 1331.6057, 1430.6741, 1561.7146, 1708.7830, 1823.8100, 1936.8941, 2050.9370, 2198.0054, 2269.0425, 2398.0851, 2545.1535, 2659.1964, 2790.2369, 2937.3053, 3100.3687, 3229.4113, 3360.4517, 3473.5358, 3574.5835, 3702.6421, 3849.7105, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 450.2459, 551.2936, 664.3777, 795.4182, 924.4608, 1087.5241, 1234.5925, 1365.6330, 1479.6759, 1626.7443, 1755.7869, 1826.8240, 1973.8925, 2087.9354, 2201.0194, 2316.0464, 2463.1148, 2594.1553, 2693.2237, 2764.2608, 2924.2915, 3055.3319, 3183.3905, 3330.4589, 3461.4994, 3575.5424, 3688.6264, 3787.6948, 3886.7632, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QHHHQQHQQHHQQHQHHNQHGAHHVQNQYHSK", {129.0659, 266.1248, 403.1837, 540.2426, 668.3012, 796.3597, 933.4187, 1061.4772, 1189.5358, 1326.5947, 1463.6536, 1591.7122, 1719.7708, 1856.8297, 1984.8883, 2121.9472, 2259.0061, 2373.0490, 2501.1076, 2638.1665, 2695.1880, 2766.2251, 2903.2840, 3040.3429, 3139.4113, 3267.4699, 3381.5128, 3509.5714, 3672.6347, 3809.6937, 3896.7257, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 234.1448, 371.2037, 534.2671, 662.3257, 776.3686, 904.4272, 1003.4956, 1140.5545, 1277.6134, 1348.6505, 1405.6720, 1542.7309, 1670.7895, 1784.8324, 1921.8913, 2058.9502, 2187.0088, 2324.0677, 2452.1263, 2580.1849, 2717.2438, 2854.3027, 2982.3613, 3110.4198, 3247.4787, 3375.5373, 3503.5959, 3640.6548, 3777.7137, 3914.7726, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FWAFALCSWWAFAAMCCFYLAMFLVTCSTTQR", {148.0757, 334.1550, 405.1921, 552.2605, 623.2976, 736.3817, 896.4124, 983.4444, 1169.5237, 1355.6030, 1426.6401, 1573.7085, 1644.7457, 1715.7828, 1846.8233, 2006.8539, 2166.8845, 2313.9530, 2477.0163, 2590.1004, 2661.1375, 2792.1780, 2939.2464, 3052.3304, 3151.3988, 3252.4465, 3412.4772, 3499.5092, 3600.5569, 3701.6046, 3829.6631, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 404.2252, 505.2729, 592.3049, 752.3356, 853.3832, 952.4517, 1065.5357, 1212.6041, 1343.6446, 1414.6817, 1527.7658, 1690.8291, 1837.8975, 1997.9282, 2157.9588, 2288.9993, 2360.0364, 2431.0735, 2578.1420, 2649.1791, 2835.2584, 3021.3377, 3108.3697, 3268.4004, 3381.4844, 3452.5216, 3599.5900, 3670.6271, 3856.7064, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SFHLMTLLFGFLVLSAYYSWCLDSWWLHWVMK", {88.0393, 235.1077, 372.1666, 485.2507, 616.2912, 717.3389, 830.4229, 943.5070, 1090.5754, 1147.5969, 1294.6653, 1407.7493, 1506.8178, 1619.9018, 1706.9338, 1777.9710, 1941.0343, 2104.0976, 2191.1296, 2377.2090, 2537.2396, 2650.3237, 2765.3506, 2852.3826, 3038.4620, 3224.5413, 3337.6253, 3474.6842, 3660.7636, 3759.8320, 3890.8725, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 278.1533, 377.2217, 563.3010, 700.3599, 813.4440, 999.5233, 1185.6026, 1272.6346, 1387.6616, 1500.7457, 1660.7763, 1846.8556, 1933.8876, 2096.9510, 2260.0143, 2331.0514, 2418.0834, 2531.1675, 2630.2359, 2743.3200, 2890.3884, 2947.4099, 3094.4783, 3207.5623, 3320.6464, 3421.6941, 3552.7346, 3665.8186, 3802.8775, 3949.9460, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DLAIDPEFQYVIDTEHWYYHLETYVLYVILLR", {116.0342, 229.1183, 300.1554, 413.2395, 528.2664, 625.3192, 754.3618, 901.4302, 1029.4888, 1192.5521, 1291.6205, 1404.7046, 1519.7315, 1620.7792, 1749.8218, 1886.8807, 2072.9600, 2236.0233, 2399.0867, 2536.1456, 2649.2296, 2778.2722, 2879.3199, 3042.3832, 3141.4516, 3254.5357, 3417.5990, 3516.6675, 3629.7515, 3742.8356, 3855.9196, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 401.2871, 514.3711, 613.4396, 776.5029, 889.5870, 988.6554, 1151.7187, 1252.7664, 1381.8090, 1494.8930, 1631.9519, 1795.0153, 1958.0786, 2144.1579, 2281.2168, 2410.2594, 2511.3071, 2626.3340, 2739.4181, 2838.4865, 3001.5498, 3129.6084, 3276.6768, 3405.7194, 3502.7722, 3617.7991, 3730.8832, 3801.9203, 3915.0044, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EAEDMDVLETWSAQPCEFFYQEFEIHNQLYNR", {130.0499, 201.0870, 330.1296, 445.1565, 576.1970, 691.2239, 790.2924, 903.3764, 1032.4190, 1133.4667, 1319.5460, 1406.5780, 1477.6152, 1605.6737, 1702.7265, 1862.7571, 1991.7997, 2138.8681, 2285.9366, 2448.9999, 2577.0585, 2706.1011, 2853.1695, 2982.2121, 3095.2961, 3232.3550, 3346.3980, 3474.4566, 3587.5406, 3750.6039, 3864.6469, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 289.1619, 452.2252, 565.3093, 693.3678, 807.4108, 944.4697, 1057.5538, 1186.5963, 1333.6648, 1462.7074, 1590.7659, 1753.8293, 1900.8977, 2047.9661, 2177.0087, 2337.0393, 2434.0921, 2562.1507, 2633.1878, 2720.2198, 2906.2991, 3007.3468, 3136.3894, 3249.4735, 3348.5419, 3463.5688, 3594.6093, 3709.6362, 3838.6788, 3909.7160, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PLQLIHAFSDVQTWSENDLFLCIEEICCIHYR", {98.0600, 211.1441, 339.2027, 452.2867, 565.3708, 702.4297, 773.4668, 920.5352, 1007.5673, 1122.5942, 1221.6626, 1349.7212, 1450.7689, 1636.8482, 1723.8802, 1852.9228, 1966.9658, 2081.9927, 2195.0768, 2342.1452, 2455.2292, 2615.2599, 2728.3440, 2857.3865, 2986.4291, 3099.5132, 3259.5438, 3419.5745, 3532.6586, 3669.7175, 3832.7808, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 475.2412, 588.3253, 748.3559, 908.3866, 1021.4706, 1150.5132, 1279.5558, 1392.6399, 1552.6705, 1665.7546, 1812.8230, 1925.9071, 2040.9340, 2154.9769, 2284.0195, 2371.0516, 2557.1309, 2658.1785, 2786.2371, 2885.3055, 3000.3325, 3087.3645, 3234.4329, 3305.4700, 3442.5289, 3555.6130, 3668.6971, 3796.7557, 3909.8397, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ALVYDIMAPVDYMGIENWSFNWFIQWYTPWYK", {72.0444, 185.1285, 284.1969, 447.2602, 562.2871, 675.3712, 806.4117, 877.4488, 974.5016, 1073.5700, 1188.5969, 1351.6603, 1482.7007, 1539.7222, 1652.8063, 1781.8489, 1895.8918, 2081.9711, 2169.0031, 2316.0715, 2430.1145, 2616.1938, 2763.2622, 2876.3463, 3004.4048, 3190.4841, 3353.5475, 3454.5952, 3551.6479, 3737.7272, 3900.7906, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 310.1761, 496.2554, 593.3082, 694.3559, 857.4192, 1043.4985, 1171.5571, 1284.6412, 1431.7096, 1617.7889, 1731.8318, 1878.9002, 1965.9323, 2152.0116, 2266.0545, 2395.0971, 2508.1812, 2565.2026, 2696.2431, 2859.3064, 2974.3334, 3073.4018, 3170.4546, 3241.4917, 3372.5322, 3485.6162, 3600.6432, 3763.7065, 3862.7749, 3975.8590, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MLENTPIMYSDFEINNFDSYEYSWYWQHGISK", {132.0478, 245.1318, 374.1744, 488.2173, 589.2650, 686.3178, 799.4019, 930.4423, 1093.5057, 1180.5377, 1295.5646, 1442.6331, 1571.6756, 1684.7597, 1798.8026, 1912.8456, 2059.9140, 2174.9409, 2261.9729, 2425.0363, 2554.0789, 2717.1422, 2804.1742, 2990.2535, 3153.3169, 3339.3962, 3467.4548, 3604.5137, 3661.5351, 3774.6192, 3861.6512, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 234.1448, 347.2289, 404.2504, 541.3093, 669.3678, 855.4472, 1018.5105, 1204.5898, 1291.6218, 1454.6852, 1583.7278, 1746.7911, 1833.8231, 1948.8501, 2095.9185, 2209.9614, 2324.0043, 2437.0884, 2566.1310, 2713.1994, 2828.2263, 2915.2584, 3078.3217, 3209.3622, 3322.4462, 3419.4990, 3520.5467, 3634.5896, 3763.6322, 3876.7163, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LYFFLTILTSMMMLTLMFYQNCLTLQQIVLWK", {114.0913, 277.1547, 424.2231, 571.2915, 684.3756, 785.4232, 898.5073, 1011.5914, 1112.6390, 1199.6711, 1330.7116, 1461.7520, 1592.7925, 1705.8766, 1806.9243, 1920.0083, 2051.0488, 2198.1172, 2361.1806, 2489.2391, 2603.2821, 2763.3127, 2876.3968, 2977.4445, 3090.5285, 3218.5871, 3346.6457, 3459.7297, 3558.7982, 3671.8822, 3857.9615, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 333.1921, 446.2762, 545.3446, 658.4287, 786.4872, 914.5458, 1027.6299, 1128.6776, 1241.7616, 1401.7923, 1515.8352, 1643.8938, 1806.9571, 1954.0255, 2085.0660, 2198.1501, 2299.1977, 2412.2818, 2543.3223, 2674.3628, 2805.4033, 2892.4353, 2993.4830, 3106.5670, 3219.6511, 3320.6988, 3433.7828, 3580.8513, 3727.9197, 3890.9830, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DELDLDHEEEVEEDEINLQEECETQEDEEEER", {116.0342, 245.0768, 358.1609, 473.1878, 586.2719, 701.2988, 838.3577, 967.4003, 1096.4429, 1225.4855, 1324.5539, 1453.5965, 1582.6391, 1697.6661, 1826.7087, 1939.7927, 2053.8356, 2166.9197, 2294.9783, 2424.0209, 2553.0635, 2713.0941, 2842.1367, 2943.1844, 3071.2430, 3200.2856, 3315.3125, 3444.3551, 3573.3977, 3702.4403, 3831.4829, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 433.2041, 562.2467, 691.2893, 806.3163, 935.3589, 1063.4174, 1164.4651, 1293.5077, 1453.5384, 1582.5810, 1711.6235, 1839.6821, 1952.7662, 2066.8091, 2179.8932, 2308.9358, 2423.9627, 2553.0053, 2682.0479, 2781.1163, 2910.1589, 3039.2015, 3168.2441, 3305.3030, 3420.3299, 3533.4140, 3648.4410, 3761.5250, 3890.5676, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SIYFGPLLFDHIIYYEEEFVWLCGNFSNDFFR", {88.0393, 201.1234, 364.1867, 511.2551, 568.2766, 665.3293, 778.4134, 891.4975, 1038.5659, 1153.5928, 1290.6517, 1403.7358, 1516.8199, 1679.8832, 1842.9465, 1971.9891, 2101.0317, 2230.0743, 2377.1427, 2476.2111, 2662.2904, 2775.3745, 2935.4052, 2992.4266, 3106.4695, 3253.5380, 3340.5700, 3454.6129, 3569.6399, 3716.7083, 3863.7767, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 469.2558, 584.2827, 698.3257, 785.3577, 932.4261, 1046.4690, 1103.4905, 1263.5211, 1376.6052, 1562.6845, 1661.7529, 1808.8213, 1937.8639, 2066.9065, 2195.9491, 2359.0124, 2522.0758, 2635.1598, 2748.2439, 2885.3028, 3000.3298, 3147.3982, 3260.4822, 3373.5663, 3470.6191, 3527.6405, 3674.7089, 3837.7723, 3950.8563, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TQFHWYCYINRPYDEPYNPSQLVGYSTTIEFK", {102.0550, 230.1135, 377.1819, 514.2409, 700.3202, 863.3835, 1023.4141, 1186.4775, 1299.5615, 1413.6045, 1569.7056, 1666.7583, 1829.8217, 1944.8486, 2073.8912, 2170.9440, 2334.0073, 2448.0502, 2545.1030, 2632.1350, 2760.1936, 2873.2777, 2972.3461, 3029.3675, 3192.4309, 3279.4629, 3380.5106, 3481.5583, 3594.6423, 3723.6849, 3870.7533, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 294.1812, 423.2238, 536.3079, 637.3556, 738.4032, 825.4353, 988.4986, 1045.5201, 1144.5885, 1257.6725, 1385.7311, 1472.7631, 1569.8159, 1683.8588, 1846.9222, 1943.9749, 2073.0175, 2188.0445, 2351.1078, 2448.1605, 2604.2617, 2718.3046, 2831.3887, 2994.4520, 3154.4826, 3317.5460, 3503.6253, 3640.6842, 3787.7526, 3915.8112, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TFSRPYAITQNVWELIPLMWFHYPLIMYLHPR", {102.0550, 249.1234, 336.1554, 492.2565, 589.3093, 752.3726, 823.4097, 936.4938, 1037.5415, 1165.6000, 1279.6430, 1378.7114, 1564.7907, 1693.8333, 1806.9173, 1920.0014, 2017.0542, 2130.1382, 2261.1787, 2447.2580, 2594.3264, 2731.3854, 2894.4487, 2991.5015, 3104.5855, 3217.6696, 3348.7101, 3511.7734, 3624.8575, 3761.9164, 3858.9691, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 272.1717, 409.2306, 522.3147, 685.3780, 816.4185, 929.5026, 1042.5866, 1139.6394, 1302.7027, 1439.7616, 1586.8301, 1772.9094, 1903.9498, 2017.0339, 2114.0867, 2227.1707, 2340.2548, 2469.2974, 2655.3767, 2754.4451, 2868.4881, 2996.5466, 3097.5943, 3210.6784, 3281.7155, 3444.7788, 3541.8316, 3697.9327, 3784.9647, 3932.0331, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"CECNGTEEECHGTSFFYDCQCPSCVDTENWHK", {161.0379, 290.0805, 450.1112, 564.1541, 621.1756, 722.2232, 851.2658, 980.3084, 1109.3510, 1269.3817, 1406.4406, 1463.4620, 1564.5097, 1651.5417, 1798.6102, 1945.6786, 2108.7419, 2223.7688, 2383.7995, 2511.8581, 2671.8887, 2768.9415, 2855.9735, 3016.0042, 3115.0726, 3230.0995, 3331.1472, 3460.1898, 3574.2327, 3760.3120, 3897.3709, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 284.1717, 470.2510, 584.2940, 713.3365, 814.3842, 929.4112, 1028.4796, 1188.5102, 1275.5423, 1372.5950, 1532.6257, 1660.6843, 1820.7149, 1935.7418, 2098.8052, 2245.8736, 2392.9420, 2479.9740, 2581.0217, 2638.0432, 2775.1021, 2935.1327, 3064.1753, 3193.2179, 3322.2605, 3423.3082, 3480.3297, 3594.3726, 3754.4032, 3883.4458, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"HDHHDHHDYDHHEYGSYHDHHHYHTSYAETPK", {138.0662, 253.0931, 390.1520, 527.2110, 642.2379, 779.2968, 916.3557, 1031.3827, 1194.4460, 1309.4729, 1446.5318, 1583.5908, 1712.6334, 1875.6967, 1932.7181, 2019.7502, 2182.8135, 2319.8724, 2434.8994, 2571.9583, 2709.0172, 2846.0761, 3009.1394, 3146.1983, 3247.2460, 3334.2780, 3497.3414, 3568.3785, 3697.4211, 3798.4688, 3895.5215, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 244.1656, 345.2132, 474.2558, 545.2930, 708.3563, 795.3883, 896.4360, 1033.4949, 1196.5582, 1333.6171, 1470.6761, 1607.7350, 1722.7619, 1859.8208, 2022.8841, 2109.9162, 2166.9376, 2330.0010, 2459.0436, 2596.1025, 2733.1614, 2848.1883, 3011.2517, 3126.2786, 3263.3375, 3400.3964, 3515.4234, 3652.4823, 3789.5412, 3904.5681, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VMDDTFPQHQWLEFFHELMEPHVYDAVHEWPK", {100.0757, 231.1162, 346.1431, 461.1701, 562.2177, 709.2862, 806.3389, 934.3975, 1071.4564, 1199.5150, 1385.5943, 1498.6784, 1627.7210, 1774.7894, 1921.8578, 2058.9167, 2187.9593, 2301.0434, 2432.0838, 2561.1264, 2658.1792, 2795.2381, 2894.3065, 3057.3698, 3172.3968, 3243.4339, 3342.5023, 3479.5612, 3608.6038, 3794.6831, 3891.7359, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 244.1656, 430.2449, 559.2875, 696.3464, 795.4148, 866.4519, 981.4789, 1144.5422, 1243.6106, 1380.6695, 1477.7223, 1606.7649, 1737.8054, 1850.8894, 1979.9320, 2116.9909, 2264.0593, 2411.1277, 2540.1703, 2653.2544, 2839.3337, 2967.3923, 3104.4512, 3232.5098, 3329.5626, 3476.6310, 3577.6786, 3692.7056, 3807.7325, 3938.7730, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YCCYERPPPIDITQPKPQCLISQCVERPECVR", {164.0706, 324.1013, 484.1319, 647.1952, 776.2378, 932.3389, 1029.3917, 1126.4445, 1223.4972, 1336.5813, 1451.6082, 1564.6923, 1665.7400, 1793.7986, 1890.8513, 2018.9463, 2115.9990, 2244.0576, 2404.0883, 2517.1723, 2630.2564, 2717.2884, 2845.3470, 3005.3777, 3104.4461, 3233.4887, 3389.5898, 3486.6425, 3615.6851, 3775.7158, 3874.7842, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 274.1874, 434.2180, 563.2606, 660.3134, 816.4145, 945.4571, 1044.5255, 1204.5561, 1332.6147, 1419.6467, 1532.7308, 1645.8149, 1805.8455, 1933.9041, 2030.9569, 2159.0518, 2256.1046, 2384.1632, 2485.2108, 2598.2949, 2713.3219, 2826.4059, 2923.4587, 3020.5114, 3117.5642, 3273.6653, 3402.7079, 3565.7712, 3725.8019, 3885.8325, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FLTIYVQIVGCYIDNLMWHTELMYDGEPYPLIK", {148.0757, 261.1598, 362.2074, 475.2915, 638.3548, 737.4232, 865.4818, 978.5659, 1077.6343, 1134.6558, 1294.6864, 1457.7497, 1570.8338, 1685.8607, 1799.9037, 1912.9877, 2044.0282, 2230.1075, 2367.1664, 2468.2141, 2597.2567, 2710.3408, 2841.3813, 3004.4446, 3119.4715, 3176.4930, 3305.5356, 3402.5884, 3565.6517, 3662.7044, 3775.7885, 3888.8726, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 373.2809, 470.3337, 633.3970, 730.4498, 859.4924, 916.5138, 1031.5408, 1194.6041, 1325.6446, 1438.7287, 1567.7713, 1668.8189, 1805.8778, 1991.9572, 2122.9976, 2236.0817, 2350.1246, 2465.1516, 2578.2356, 2741.2990, 2901.3296, 2958.3511, 3057.4195, 3170.5036, 3298.5621, 3397.6306, 3560.6939, 3673.7779, 3774.8256, 3887.9097, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LSECQVNAFEVLSYVETFYCTSYMLFSIFLILK", {114.0913, 201.1234, 330.1660, 490.1966, 618.2552, 717.3236, 831.3665, 902.4036, 1049.4721, 1178.5147, 1277.5831, 1390.6671, 1477.6992, 1640.7625, 1739.8309, 1868.8735, 1969.9212, 2116.9896, 2280.0529, 2440.0836, 2541.1312, 2628.1633, 2791.2266, 2922.2671, 3035.3511, 3182.4196, 3269.4516, 3382.5357, 3529.6041, 3642.6881, 3755.7722, 3868.8563, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 373.2809, 486.3650, 633.4334, 746.5175, 833.5495, 980.6179, 1093.7020, 1224.7425, 1387.8058, 1474.8378, 1575.8855, 1735.9161, 1898.9795, 2046.0479, 2147.0956, 2276.1382, 2375.2066, 2538.2699, 2625.3019, 2738.3860, 2837.4544, 2966.4970, 3113.5654, 3184.6025, 3298.6455, 3397.7139, 3525.7725, 3685.8031, 3814.8457, 3901.8777, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TPFSMFDLNYSSCNLNTFTVHCFCIMPLTLLFK", {102.0550, 199.1077, 346.1761, 433.2082, 564.2486, 711.3171, 826.3440, 939.4281, 1053.4710, 1216.5343, 1303.5664, 1390.5984, 1550.6290, 1664.6720, 1777.7560, 1891.7989, 1992.8466, 2139.9150, 2240.9627, 2340.0311, 2477.0900, 2637.1207, 2784.1891, 2944.2198, 3057.3038, 3188.3443, 3285.3971, 3398.4811, 3499.5288, 3612.6129, 3725.6969, 3872.7654, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 294.1812, 407.2653, 520.3493, 621.3970, 734.4811, 831.5339, 962.5743, 1075.6584, 1235.6890, 1382.7575, 1542.7881, 1679.8470, 1778.9154, 1879.9631, 2027.0315, 2128.0792, 2242.1221, 2355.2062, 2469.2491, 2629.2798, 2716.3118, 2803.3438, 2966.4072, 3080.4501, 3193.5342, 3308.5611, 3455.6295, 3586.6700, 3673.7020, 3820.7704, 3917.8232, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YLFVMIICPIYFSSLSSYLIFDANYFACVDPER", {164.0706, 277.1547, 424.2231, 523.2915, 654.3320, 767.4160, 880.5001, 1040.5308, 1137.5835, 1250.6676, 1413.7309, 1560.7993, 1647.8314, 1734.8634, 1847.9474, 1934.9795, 2022.0115, 2185.0748, 2298.1589, 2411.2430, 2558.3114, 2673.3383, 2744.3754, 2858.4184, 3021.4817, 3168.5501, 3239.5872, 3399.6179, 3498.6863, 3613.7132, 3710.7660, 3839.8086, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 401.2143, 516.2413, 615.3097, 775.3403, 846.3774, 993.4458, 1156.5092, 1270.5521, 1341.5892, 1456.6162, 1603.6846, 1716.7686, 1829.8527, 1992.9160, 2079.9481, 2166.9801, 2280.0641, 2367.0962, 2454.1282, 2601.1966, 2764.2599, 2877.3440, 2974.3968, 3134.4274, 3247.5115, 3360.5956, 3491.6360, 3590.7044, 3737.7729, 3850.8569, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DRPLIQSAYICPFIVTPLFAVWVFMLYTFDFHK", {116.0342, 272.1353, 369.1881, 482.2722, 595.3562, 723.4148, 810.4468, 881.4839, 1044.5473, 1157.6313, 1317.6620, 1414.7147, 1561.7832, 1674.8672, 1773.9356, 1874.9833, 1972.0361, 2085.1201, 2232.1886, 2303.2257, 2402.2941, 2588.3734, 2687.4418, 2834.5102, 2965.5507, 3078.6348, 3241.6981, 3342.7458, 3489.8142, 3604.8411, 3751.9096, 3888.9685, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 284.1717, 431.2401, 546.2671, 693.3355, 794.3832, 957.4465, 1070.5306, 1201.5710, 1348.6395, 1447.7079, 1633.7872, 1732.8556, 1803.8927, 1950.9611, 2064.0452, 2161.0980, 2262.1456, 2361.2140, 2474.2981, 2621.3665, 2718.4193, 2878.4499, 2991.5340, 3154.5973, 3225.6344, 3312.6665, 3440.7250, 3553.8091, 3666.8932, 3763.9459, 3920.0471, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"HYECLKPLIEQMHVNLQHNYNVALESAFILYVR", {138.0662, 301.1295, 430.1721, 590.2028, 703.2868, 831.3818, 928.4345, 1041.5186, 1154.6027, 1283.6453, 1411.7038, 1542.7443, 1679.8032, 1778.8717, 1892.9146, 2005.9987, 2134.0572, 2271.1161, 2385.1591, 2548.2224, 2662.2653, 2761.3337, 2832.3709, 2945.4549, 3074.4975, 3161.5295, 3232.5667, 3379.6351, 3492.7191, 3605.8032, 3768.8665, 3867.9349, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 274.1874, 437.2507, 550.3348, 663.4188, 810.4872, 881.5244, 968.5564, 1097.5990, 1210.6830, 1281.7201, 1380.7886, 1494.8315, 1657.8948, 1771.9377, 1908.9967, 2037.0552, 2150.1393, 2264.1822, 2363.2506, 2500.3096, 2631.3500, 2759.4086, 2888.4512, 3001.5353, 3114.6193, 3211.6721, 3339.7671, 3452.8511, 3612.8818, 3741.9244, 3904.9877, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NMVVYISQLWIYSNVLLLLQLHWGLLCSFVLFR", {115.0502, 246.0907, 345.1591, 444.2275, 607.2908, 720.3749, 807.4069, 935.4655, 1048.5496, 1234.6289, 1347.7130, 1510.7763, 1597.8083, 1711.8512, 1810.9197, 1924.0037, 2037.0878, 2150.1718, 2263.2559, 2391.3145, 2504.3986, 2641.4575, 2827.5368, 2884.5582, 2997.6423, 3110.7264, 3270.7570, 3357.7890, 3504.8575, 3603.9259, 3717.0099, 3864.0784, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 435.2714, 534.3398, 681.4083, 768.4403, 928.4709, 1041.5550, 1154.6391, 1211.6605, 1397.7398, 1534.7988, 1647.8828, 1775.9414, 1889.0255, 2002.1095, 2115.1936, 2228.2776, 2327.3461, 2441.3890, 2528.4210, 2691.4843, 2804.5684, 2990.6477, 3103.7318, 3231.7904, 3318.8224, 3431.9065, 3594.9698, 3694.0382, 3793.1066, 3924.1471, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QPQPPPAQQPQQQYYPHHHYSIHQQHQHITPQK", {129.0659, 226.1186, 354.1772, 451.2300, 548.2827, 645.3355, 716.3726, 844.4312, 972.4898, 1069.5425, 1197.6011, 1325.6597, 1453.7183, 1616.7816, 1779.8449, 1876.8977, 2013.9566, 2151.0155, 2288.0744, 2451.1377, 2538.1698, 2651.2538, 2788.3127, 2916.3713, 3044.4299, 3181.4888, 3309.5474, 3446.6063, 3559.6904, 3660.7380, 3757.7908, 3885.8494, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 275.1714, 372.2241, 473.2718, 586.3559, 723.4148, 851.4734, 988.5323, 1116.5909, 1244.6494, 1381.7084, 1494.7924, 1581.8244, 1744.8878, 1881.9467, 2019.0056, 2156.0645, 2253.1173, 2416.1806, 2579.2439, 2707.3025, 2835.3611, 2963.4197, 3060.4724, 3188.5310, 3316.5896, 3387.6267, 3484.6795, 3581.7322, 3678.7850, 3806.8436, 3903.8963, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YHESHDHDLSYPIHDHHSFSSPPHDLIIEQNCR", {164.0706, 301.1295, 430.1721, 517.2041, 654.2631, 769.2900, 906.3489, 1021.3758, 1134.4599, 1221.4919, 1384.5553, 1481.6080, 1594.6921, 1731.7510, 1846.7780, 1983.8369, 2120.8958, 2207.9278, 2354.9962, 2442.0282, 2529.0603, 2626.1130, 2723.1658, 2860.2247, 2975.2517, 3088.3357, 3201.4198, 3314.5038, 3443.5464, 3571.6050, 3685.6479, 3845.6786, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 335.1496, 449.1925, 577.2511, 706.2937, 819.3778, 932.4618, 1045.5459, 1160.5728, 1297.6317, 1394.6845, 1491.7373, 1578.7693, 1665.8013, 1812.8697, 1899.9018, 2036.9607, 2174.0196, 2289.0465, 2426.1055, 2539.1895, 2636.2423, 2799.3056, 2886.3376, 2999.4217, 3114.4486, 3251.5076, 3366.5345, 3503.5934, 3590.6254, 3719.6680, 3856.7269, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"CEQDIWDYITDLTHYTEWEMQSDDGVSSEDILK", {161.0379, 290.0805, 418.1391, 533.1660, 646.2501, 832.3294, 947.3564, 1110.4197, 1223.5038, 1324.5514, 1439.5784, 1552.6624, 1653.7101, 1790.7690, 1953.8324, 2054.8800, 2183.9226, 2370.0019, 2499.0445, 2630.0850, 2758.1436, 2845.1756, 2960.2026, 3075.2295, 3132.2510, 3231.3194, 3318.3514, 3405.3834, 3534.4260, 3649.4530, 3762.5370, 3875.6211, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 373.2809, 488.3079, 617.3505, 704.3825, 791.4145, 890.4829, 947.5044, 1062.5313, 1177.5583, 1264.5903, 1392.6489, 1523.6894, 1652.7320, 1838.8113, 1967.8539, 2068.9016, 2231.9649, 2369.0238, 2470.0715, 2583.1555, 2698.1825, 2799.2302, 2912.3142, 3075.3776, 3190.4045, 3376.4838, 3489.5679, 3604.5948, 3732.6534, 3861.6960, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PNELVQLVNMQFDQMMLQLMYNQWSQTLNEPLK", {98.0600, 212.1030, 341.1456, 454.2296, 553.2980, 681.3566, 794.4407, 893.5091, 1007.5520, 1138.5925, 1266.6511, 1413.7195, 1528.7464, 1656.8050, 1787.8455, 1918.8860, 2031.9701, 2160.0286, 2273.1127, 2404.1532, 2567.2165, 2681.2594, 2809.3180, 2995.3973, 3082.4294, 3210.4879, 3311.5356, 3424.6197, 3538.6626, 3667.7052, 3764.7580, 3877.8420, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 357.2496, 486.2922, 600.3352, 713.4192, 814.4669, 942.5255, 1029.5575, 1215.6368, 1343.6954, 1457.7383, 1620.8016, 1751.8421, 1864.9262, 1992.9848, 2106.0688, 2237.1093, 2368.1498, 2496.2084, 2611.2353, 2758.3037, 2886.3623, 3017.4028, 3131.4457, 3230.5141, 3343.5982, 3471.6568, 3570.7252, 3683.8093, 3812.8519, 3926.8948, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SEYYSEEGWQLPDYIEPPYNTGFENIDCFSILK", {88.0393, 217.0819, 380.1452, 543.2086, 630.2406, 759.2832, 888.3258, 945.3472, 1131.4265, 1259.4851, 1372.5692, 1469.6220, 1584.6489, 1747.7122, 1860.7963, 1989.8389, 2086.8916, 2183.9444, 2347.0077, 2461.0507, 2562.0983, 2619.1198, 2766.1882, 2895.2308, 3009.2737, 3122.3578, 3237.3847, 3397.4154, 3544.4838, 3631.5158, 3744.5999, 3857.6840, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 373.2809, 460.3130, 607.3814, 767.4120, 882.4390, 995.5230, 1109.5660, 1238.6086, 1385.6770, 1442.6984, 1543.7461, 1657.7890, 1820.8524, 1917.9051, 2014.9579, 2144.0005, 2257.0845, 2420.1479, 2535.1748, 2632.2276, 2745.3116, 2873.3702, 3059.4495, 3116.4710, 3245.5136, 3374.5562, 3461.5882, 3624.6515, 3787.7149, 3916.7575, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"CEQMTPPFYFYWWLGFGVIYAGITFGVFNTVFR", {161.0379, 290.0805, 418.1391, 549.1796, 650.2273, 747.2800, 844.3328, 991.4012, 1154.4645, 1301.5329, 1464.5963, 1650.6756, 1836.7549, 1949.8390, 2006.8604, 2153.9288, 2210.9503, 2310.0187, 2423.1028, 2586.1661, 2657.2032, 2714.2247, 2827.3088, 2928.3564, 3075.4248, 3132.4463, 3231.5147, 3378.5831, 3492.6261, 3593.6737, 3692.7422, 3839.8106, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 421.2558, 522.3035, 636.3464, 783.4148, 882.4832, 939.5047, 1086.5731, 1187.6208, 1300.7048, 1357.7263, 1428.7634, 1591.8267, 1704.9108, 1803.9792, 1861.0007, 2008.0691, 2065.0906, 2178.1746, 2364.2539, 2550.3332, 2713.3966, 2860.4650, 3023.5283, 3170.5967, 3267.6495, 3364.7023, 3465.7499, 3596.7904, 3724.8490, 3853.8916, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"CHMHFCHSCVGWVLPCDDGPLACEPCTSEFSMR", {161.0379, 298.0968, 429.1373, 566.1962, 713.2646, 873.2953, 1010.3542, 1097.3862, 1257.4169, 1356.4853, 1413.5068, 1599.5861, 1698.6545, 1811.7386, 1908.7913, 2068.8220, 2183.8489, 2298.8759, 2355.8973, 2452.9501, 2566.0341, 2637.0713, 2797.1019, 2926.1445, 3023.1973, 3183.2279, 3284.2756, 3371.3076, 3500.3502, 3647.4186, 3734.4507, 3865.4911, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 306.1594, 393.1915, 540.2599, 669.3025, 756.3345, 857.3822, 1017.4128, 1114.4656, 1243.5082, 1403.5388, 1474.5759, 1587.6600, 1684.7128, 1741.7342, 1856.7612, 1971.7881, 2131.8188, 2228.8715, 2341.9556, 2441.0240, 2627.1033, 2684.1248, 2783.1932, 2943.2239, 3030.2559, 3167.3148, 3327.3454, 3474.4139, 3611.4728, 3742.5133, 3879.5722, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EIIDINNCLNYVIDEIEELYDNYEALSAFDEER", {130.0499, 243.1339, 356.2180, 471.2449, 584.3290, 698.3719, 812.4149, 972.4455, 1085.5296, 1199.5725, 1362.6358, 1461.7042, 1574.7883, 1689.8152, 1818.8578, 1931.9419, 2060.9845, 2190.0271, 2303.1112, 2466.1745, 2581.2014, 2695.2444, 2858.3077, 2987.3503, 3058.3874, 3171.4715, 3258.5035, 3329.5406, 3476.6090, 3591.6360, 3720.6785, 3849.7211, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 433.2041, 548.2311, 695.2995, 766.3366, 853.3686, 966.4527, 1037.4898, 1166.5324, 1329.5957, 1443.6387, 1558.6656, 1721.7289, 1834.8130, 1963.8556, 2092.8982, 2205.9823, 2335.0248, 2450.0518, 2563.1359, 2662.2043, 2825.2676, 2939.3105, 3052.3946, 3212.4252, 3326.4682, 3440.5111, 3553.5952, 3668.6221, 3781.7062, 3894.7902, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"AMCTVDTESILSQPIHGCIQWMFNFYTHEFINR", {72.0444, 203.0849, 363.1155, 464.1632, 563.2316, 678.2586, 779.3062, 908.3488, 995.3809, 1108.4649, 1221.5490, 1308.5810, 1436.6396, 1533.6924, 1646.7764, 1783.8353, 1840.8568, 2000.8874, 2113.9715, 2242.0301, 2428.1094, 2559.1499, 2706.2183, 2820.2612, 2967.3296, 3130.3930, 3231.4406, 3368.4996, 3497.5422, 3644.6106, 3757.6946, 3871.7376, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 289.1619, 402.2459, 549.3144, 678.3570, 815.4159, 916.4635, 1079.5269, 1226.5953, 1340.6382, 1487.7066, 1618.7471, 1804.8264, 1932.8850, 2045.9691, 2205.9997, 2263.0212, 2400.0801, 2513.1642, 2610.2169, 2738.2755, 2825.3075, 2938.3916, 3051.4757, 3138.5077, 3267.5503, 3368.5980, 3483.6249, 3582.6933, 3683.7410, 3843.7716, 3974.8121, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LQIEVFQGMEIFVTAECWYDWKPNVNNDIIQTK", {114.0913, 242.1499, 355.2340, 484.2766, 583.3450, 730.4134, 858.4720, 915.4934, 1046.5339, 1175.5765, 1288.6606, 1435.7290, 1534.7974, 1635.8451, 1706.8822, 1835.9248, 1995.9554, 2182.0348, 2345.0981, 2460.1250, 2646.2043, 2774.2993, 2871.3521, 2985.3950, 3084.4634, 3198.5063, 3312.5493, 3427.5762, 3540.6603, 3653.7443, 3781.8029, 3882.8506, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 248.1605, 376.2191, 489.3031, 602.3872, 717.4141, 831.4571, 945.5000, 1044.5684, 1158.6113, 1255.6641, 1383.7591, 1569.8384, 1684.8653, 1847.9286, 2034.0080, 2194.0386, 2323.0812, 2394.1183, 2495.1660, 2594.2344, 2741.3028, 2854.3869, 2983.4295, 3114.4700, 3171.4914, 3299.5500, 3446.6184, 3545.6868, 3674.7294, 3787.8135, 3915.8721, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YYHDVITVVLSTWQDAVWFDAFNVFFFPSLLIR", {164.0706, 327.1339, 464.1928, 579.2198, 678.2882, 791.3723, 892.4199, 991.4884, 1090.5568, 1203.6408, 1290.6729, 1391.7205, 1577.7999, 1705.8584, 1820.8854, 1891.9225, 1990.9909, 2177.0702, 2324.1386, 2439.1656, 2510.2027, 2657.2711, 2771.3140, 2870.3824, 3017.4509, 3164.5193, 3311.5877, 3408.6405, 3495.6725, 3608.7565, 3721.8406, 3834.9247, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 401.2871, 514.3711, 601.4032, 698.4559, 845.5244, 992.5928, 1139.6612, 1238.7296, 1352.7725, 1499.8409, 1570.8780, 1685.9050, 1832.9734, 2019.0527, 2118.1211, 2189.1582, 2304.1852, 2432.2438, 2618.3231, 2719.3708, 2806.4028, 2919.4868, 3018.5553, 3117.6237, 3218.6714, 3331.7554, 3430.8238, 3545.8508, 3682.9097, 3845.9730, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DAFNLLEGVANLFSHFMLYFFCLWCLHNPLALK", {116.0342, 187.0713, 334.1397, 448.1827, 561.2667, 674.3508, 803.3934, 860.4149, 959.4833, 1030.5204, 1144.5633, 1257.6474, 1404.7158, 1491.7478, 1628.8067, 1775.8751, 1906.9156, 2019.9997, 2183.0630, 2330.1314, 2477.1999, 2637.2305, 2750.3146, 2936.3939, 3096.4245, 3209.5086, 3346.5675, 3460.6104, 3557.6632, 3670.7473, 3741.7844, 3854.8684, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 331.2340, 444.3180, 541.3708, 655.4137, 792.4726, 905.5567, 1065.5874, 1251.6667, 1364.7507, 1524.7814, 1671.8498, 1818.9182, 1981.9815, 2095.0656, 2226.1061, 2373.1745, 2510.2334, 2597.2654, 2744.3339, 2857.4179, 2971.4609, 3042.4980, 3141.5664, 3198.5878, 3327.6304, 3440.7145, 3553.7986, 3667.8415, 3814.9099, 3885.9470, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PEWWYETTPPYTPVLVGIVTPLYQTWFACETQR", {98.0600, 227.1026, 413.1819, 599.2613, 762.3246, 891.3672, 992.4149, 1093.4625, 1190.5153, 1287.5681, 1450.6314, 1551.6791, 1648.7318, 1747.8003, 1860.8843, 1959.9527, 2016.9742, 2130.0583, 2229.1267, 2330.1743, 2427.2271, 2540.3112, 2703.3745, 2831.4331, 2932.4808, 3118.5601, 3265.6285, 3336.6656, 3496.6963, 3625.7388, 3726.7865, 3854.8451, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 404.2252, 533.2678, 693.2984, 764.3356, 911.4040, 1097.4833, 1198.5310, 1326.5895, 1489.6529, 1602.7369, 1699.7897, 1800.8374, 1899.9058, 2012.9899, 2070.0113, 2169.0797, 2282.1638, 2381.2322, 2478.2850, 2579.3327, 2742.3960, 2839.4488, 2936.5015, 3037.5492, 3138.5969, 3267.6395, 3430.7028, 3616.7821, 3802.8614, 3931.9040, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TWVLATQEFCPTFDPDNTYWTETANWFTSGCFR", {102.0550, 288.1343, 387.2027, 500.2867, 571.3239, 672.3715, 800.4301, 929.4727, 1076.5411, 1236.5718, 1333.6245, 1434.6722, 1581.7406, 1696.7676, 1793.8203, 1908.8473, 2022.8902, 2123.9379, 2287.0012, 2473.0805, 2574.1282, 2703.1708, 2804.2185, 2875.2556, 2989.2985, 3175.3778, 3322.4462, 3423.4939, 3510.5260, 3567.5474, 3727.5781, 3874.6465, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 482.2180, 539.2395, 626.2715, 727.3192, 874.3876, 1060.4669, 1174.5098, 1245.5470, 1346.5946, 1475.6372, 1576.6849, 1762.7642, 1925.8275, 2026.8752, 2140.9182, 2255.9451, 2352.9979, 2468.0248, 2615.0932, 2716.1409, 2813.1937, 2973.2243, 3120.2927, 3249.3353, 3377.3939, 3478.4416, 3549.4787, 3662.5627, 3761.6312, 3947.7105, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YWGSVEFWCLDFQVNCHLSFETDSTISLVDLDR", {164.0706, 350.1499, 407.1714, 494.2034, 593.2718, 722.3144, 869.3828, 1055.4621, 1215.4928, 1328.5769, 1443.6038, 1590.6722, 1718.7308, 1817.7992, 1931.8421, 2091.8728, 2228.9317, 2342.0158, 2429.0478, 2576.1162, 2705.1588, 2806.2065, 2921.2334, 3008.2654, 3109.3131, 3222.3972, 3309.4292, 3422.5133, 3521.5817, 3636.6086, 3749.6927, 3864.7196, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 290.1459, 403.2300, 518.2569, 617.3253, 730.4094, 817.4414, 930.5255, 1031.5732, 1118.6052, 1233.6321, 1334.6798, 1463.7224, 1610.7908, 1697.8228, 1810.9069, 1947.9658, 2107.9965, 2222.0394, 2321.1078, 2449.1664, 2596.2348, 2711.2617, 2824.3458, 2984.3764, 3170.4558, 3317.5242, 3446.5668, 3545.6352, 3632.6672, 3689.6887, 3875.7680, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YYQELMFSVLGFMIYIFIQGFSIIWSYSMIDTK", {164.0706, 327.1339, 455.1925, 584.2351, 697.3192, 828.3597, 975.4281, 1062.4601, 1161.5285, 1274.6126, 1331.6340, 1478.7025, 1609.7429, 1722.8270, 1885.8903, 1998.9744, 2146.0428, 2259.1269, 2387.1854, 2444.2069, 2591.2753, 2678.3074, 2791.3914, 2904.4755, 3090.5548, 3177.5868, 3340.6502, 3427.6822, 3558.7227, 3671.8067, 3786.8337, 3887.8814, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 248.1605, 363.1874, 476.2715, 607.3120, 694.3440, 857.4073, 944.4394, 1130.5187, 1243.6027, 1356.6868, 1443.7188, 1590.7872, 1647.8087, 1775.8673, 1888.9513, 2036.0198, 2149.1038, 2312.1672, 2425.2512, 2556.2917, 2703.3601, 2760.3816, 2873.4656, 2972.5341, 3059.5661, 3206.6345, 3337.6750, 3450.7591, 3579.8016, 3707.8602, 3870.9235, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TFDPAFFDYYETAPLDNEIDQDVLLSTEHTWCR", {102.0550, 249.1234, 364.1503, 461.2031, 532.2402, 679.3086, 826.3770, 941.4040, 1104.4673, 1267.5306, 1396.5732, 1497.6209, 1568.6580, 1665.7108, 1778.7948, 1893.8218, 2007.8647, 2136.9073, 2249.9914, 2365.0183, 2493.0769, 2608.1038, 2707.1722, 2820.2563, 2933.3404, 3020.3724, 3121.4201, 3250.4627, 3387.5216, 3488.5693, 3674.6486, 3834.6792, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 335.1496, 521.2289, 622.2766, 759.3355, 888.3781, 989.4258, 1076.4578, 1189.5419, 1302.6259, 1401.6943, 1516.7213, 1644.7799, 1759.8068, 1872.8909, 2001.9335, 2115.9764, 2231.0033, 2344.0874, 2441.1402, 2512.1773, 2613.2250, 2742.2676, 2905.3309, 3068.3942, 3183.4212, 3330.4896, 3477.5580, 3548.5951, 3645.6479, 3760.6748, 3907.7432, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LNQFTLQLSHQPQNQSHHHPHHSNCININHHQK", {114.0913, 228.1343, 356.1928, 503.2613, 604.3089, 717.3930, 845.4516, 958.5356, 1045.5677, 1182.6266, 1310.6852, 1407.7379, 1535.7965, 1649.8394, 1777.8980, 1864.9300, 2001.9889, 2139.0479, 2276.1068, 2373.1595, 2510.2184, 2647.2774, 2734.3094, 2848.3523, 3008.3830, 3121.4670, 3235.5100, 3348.5940, 3462.6369, 3599.6959, 3736.7548, 3864.8133, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 275.1714, 412.2303, 549.2892, 663.3321, 776.4162, 890.4591, 1003.5432, 1163.5738, 1277.6168, 1364.6488, 1501.7077, 1638.7666, 1735.8194, 1872.8783, 2009.9372, 2146.9961, 2234.0281, 2362.0867, 2476.1296, 2604.1882, 2701.2410, 2829.2996, 2966.3585, 3053.3905, 3166.4746, 3294.5332, 3407.6172, 3508.6649, 3655.7333, 3783.7919, 3897.8348, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DNQAQYQMTVMGIFVQHCQMEFCGEVDNCEEDK", {116.0342, 230.0771, 358.1357, 429.1728, 557.2314, 720.2947, 848.3533, 979.3938, 1080.4415, 1179.5099, 1310.5504, 1367.5718, 1480.6559, 1627.7243, 1726.7927, 1854.8513, 1991.9102, 2151.9409, 2279.9995, 2411.0399, 2540.0825, 2687.1509, 2847.1816, 2904.2031, 3033.2457, 3132.3141, 3247.3410, 3361.3839, 3521.4146, 3650.4572, 3779.4998, 3894.5267, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 262.1397, 391.1823, 520.2249, 680.2556, 794.2985, 909.3255, 1008.3939, 1137.4365, 1194.4579, 1354.4886, 1501.5570, 1630.5996, 1761.6401, 1889.6986, 2049.7293, 2186.7882, 2314.8468, 2413.9152, 2560.9836, 2674.0677, 2731.0891, 2862.1296, 2961.1980, 3062.2457, 3193.2862, 3321.3448, 3484.4081, 3612.4667, 3683.5038, 3811.5624, 3925.6053, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LFLEFLQMDAGLYWTQHSCSDELMHNTVFFVNK", {114.0913, 261.1598, 374.2438, 503.2864, 650.3548, 763.4389, 891.4975, 1022.5380, 1137.5649, 1208.6020, 1265.6235, 1378.7075, 1541.7709, 1727.8502, 1828.8979, 1956.9564, 2094.0153, 2181.0474, 2341.0780, 2428.1101, 2543.1370, 2672.1796, 2785.2637, 2916.3041, 3053.3630, 3167.4060, 3268.4537, 3367.5221, 3514.5905, 3661.6589, 3760.7273, 3874.7702, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 261.1557, 360.2241, 507.2926, 654.3610, 753.4294, 854.4771, 968.5200, 1105.5789, 1236.6194, 1349.7035, 1478.7460, 1593.7730, 1680.8050, 1840.8357, 1927.8677, 2064.9266, 2192.9852, 2294.0329, 2480.1122, 2643.1755, 2756.2596, 2813.2810, 2884.3181, 2999.3451, 3130.3856, 3258.4442, 3371.5282, 3518.5966, 3647.6392, 3760.7233, 3907.7917, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ELLEVNEIEGNEENAYLPQEHDQYLEEELEQER", {130.0499, 243.1339, 356.2180, 485.2606, 584.3290, 698.3719, 827.4145, 940.4986, 1069.5412, 1126.5626, 1240.6056, 1369.6482, 1498.6908, 1612.7337, 1683.7708, 1846.8341, 1959.9182, 2056.9710, 2185.0295, 2314.0721, 2451.1310, 2566.1580, 2694.2166, 2857.2799, 2970.3640, 3099.4065, 3228.4491, 3357.4917, 3470.5758, 3599.6184, 3727.6770, 3856.7196, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 432.2201, 561.2627, 674.3468, 803.3894, 932.4320, 1061.4746, 1174.5586, 1337.6220, 1465.6805, 1580.7075, 1717.7664, 1846.8090, 1974.8676, 2071.9203, 2185.0044, 2348.0677, 2419.1048, 2533.1478, 2662.1903, 2791.2329, 2905.2759, 2962.2973, 3091.3399, 3204.4240, 3333.4666, 3447.5095, 3546.5779, 3675.6205, 3788.7046, 3901.7886, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SWCCPEVQNSDLGWFELEEEFLPGCVDTPYHLK", {88.0393, 274.1186, 434.1493, 594.1799, 691.2327, 820.2753, 919.3437, 1047.4023, 1161.4452, 1248.4772, 1363.5042, 1476.5882, 1533.6097, 1719.6890, 1866.7574, 1995.8000, 2108.8841, 2237.9267, 2366.9693, 2496.0119, 2643.0803, 2756.1643, 2853.2171, 2910.2386, 3070.2692, 3169.3376, 3284.3646, 3385.4122, 3482.4650, 3645.5283, 3782.5872, 3895.6713, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 397.2558, 560.3191, 657.3719, 758.4196, 873.4465, 972.5149, 1132.5456, 1189.5670, 1286.6198, 1399.7038, 1546.7723, 1675.8149, 1804.8574, 1933.9000, 2046.9841, 2176.0267, 2323.0951, 2509.1744, 2566.1959, 2679.2800, 2794.3069, 2881.3389, 2995.3819, 3123.4404, 3222.5088, 3351.5514, 3448.6042, 3608.6348, 3768.6655, 3954.7448, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YAVCLVLLPLVLLLFDLLINYFLEYGQDPWFER", {164.0706, 235.1077, 334.1761, 494.2068, 607.2908, 706.3593, 819.4433, 932.5274, 1029.5802, 1142.6642, 1241.7326, 1354.8167, 1467.9008, 1580.9848, 1728.0532, 1843.0802, 1956.1642, 2069.2483, 2182.3324, 2296.3753, 2459.4386, 2606.5070, 2719.5911, 2848.6337, 3011.6970, 3068.7185, 3196.7771, 3311.8040, 3408.8568, 3594.9361, 3742.0045, 3871.0471, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 451.2300, 637.3093, 734.3620, 849.3890, 977.4476, 1034.4690, 1197.5323, 1326.5749, 1439.6590, 1586.7274, 1749.7907, 1863.8337, 1976.9177, 2090.0018, 2203.0859, 2318.1128, 2465.1812, 2578.2653, 2691.3494, 2804.4334, 2903.5018, 3016.5859, 3113.6387, 3226.7227, 3339.8068, 3438.8752, 3551.9593, 3711.9899, 3811.0583, 3882.0954, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"CFITVNSTSEMQFLTDMTENFIETNNWLDYLIK", {161.0379, 308.1063, 421.1904, 522.2381, 621.3065, 735.3494, 822.3815, 923.4291, 1010.4612, 1139.5038, 1270.5442, 1398.6028, 1545.6712, 1658.7553, 1759.8030, 1874.8299, 2005.8704, 2106.9181, 2235.9607, 2350.0036, 2497.0720, 2610.1561, 2739.1987, 2840.2463, 2954.2893, 3068.3322, 3254.4115, 3367.4956, 3482.5225, 3645.5859, 3758.6699, 3871.7540, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 373.2809, 536.3443, 651.3712, 764.4553, 950.5346, 1064.5775, 1178.6204, 1279.6681, 1408.7107, 1521.7948, 1668.8632, 1782.9061, 1911.9487, 2012.9964, 2144.0369, 2259.0638, 2360.1115, 2473.1956, 2620.2640, 2748.3225, 2879.3630, 3008.4056, 3095.4377, 3196.4853, 3283.5174, 3397.5603, 3496.6287, 3597.6764, 3710.7604, 3857.8289, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EIIQDIQENQPINQFNIYTSNALNELFDWLIDR", {130.0499, 243.1339, 356.2180, 484.2766, 599.3035, 712.3876, 840.4462, 969.4888, 1083.5317, 1211.5903, 1308.6430, 1421.7271, 1535.7700, 1663.8286, 1810.8970, 1924.9399, 2038.0240, 2201.0873, 2302.1350, 2389.1670, 2503.2100, 2574.2471, 2687.3311, 2801.3741, 2930.4167, 3043.5007, 3190.5691, 3305.5961, 3491.6754, 3604.7595, 3717.8435, 3832.8705, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 290.1459, 403.2300, 516.3140, 702.3933, 817.4203, 964.4887, 1077.5728, 1206.6154, 1320.6583, 1433.7423, 1504.7795, 1618.8224, 1705.8544, 1806.9021, 1969.9654, 2083.0495, 2197.0924, 2344.1608, 2472.2194, 2586.2623, 2699.3464, 2796.3992, 2924.4577, 3038.5007, 3167.5433, 3295.6018, 3408.6859, 3523.7128, 3651.7714, 3764.8555, 3877.9395, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LFGDWHQDTLYNVMHCNVFDWHPNLFALLGDLR", {114.0913, 261.1598, 318.1812, 433.2082, 619.2875, 756.3464, 884.4050, 999.4319, 1100.4796, 1213.5636, 1376.6270, 1490.6699, 1589.7383, 1720.7788, 1857.8377, 2017.8684, 2131.9113, 2230.9797, 2378.0481, 2493.0751, 2679.1544, 2816.2133, 2913.2661, 3027.3090, 3140.3930, 3287.4615, 3358.4986, 3471.5826, 3584.6667, 3641.6882, 3756.7151, 3869.7992, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 403.2300, 460.2514, 573.3355, 686.4196, 757.4567, 904.5251, 1017.6091, 1131.6521, 1228.7048, 1365.7637, 1551.8431, 1666.8700, 1813.9384, 1913.0068, 2027.0498, 2187.0804, 2324.1393, 2455.1798, 2554.2482, 2668.2911, 2831.3545, 2944.4385, 3045.4862, 3160.5132, 3288.5717, 3425.6306, 3611.7100, 3726.7369, 3783.7584, 3930.8268, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YPKPLSNWSHQDLPLFIHDLQWDFALQEPEVLK", {164.0706, 261.1234, 389.2183, 486.2711, 599.3552, 686.3872, 800.4301, 986.5094, 1073.5415, 1210.6004, 1338.6589, 1453.6859, 1566.7700, 1663.8227, 1776.9068, 1923.9752, 2037.0593, 2174.1182, 2289.1451, 2402.2292, 2530.2878, 2716.3671, 2831.3940, 2978.4624, 3049.4995, 3162.5836, 3290.6422, 3419.6848, 3516.7375, 3645.7801, 3744.8485, 3857.9326, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 359.2653, 488.3079, 585.3606, 714.4032, 842.4618, 955.5459, 1026.5830, 1173.6514, 1288.6783, 1474.7577, 1602.8162, 1715.9003, 1830.9272, 1967.9862, 2081.0702, 2228.1386, 2341.2227, 2438.2755, 2551.3595, 2666.3865, 2794.4450, 2931.5040, 3018.5360, 3204.6153, 3318.6582, 3405.6903, 3518.7743, 3615.8271, 3743.9220, 3840.9748, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LNDTYLFWIFLTIICYVLIFIACSCPTGFLLSK", {114.0913, 228.1343, 343.1612, 444.2089, 607.2722, 720.3563, 867.4247, 1053.5040, 1166.5881, 1313.6565, 1426.7406, 1527.7882, 1640.8723, 1753.9564, 1913.9870, 2077.0503, 2176.1187, 2289.2028, 2402.2869, 2549.3553, 2662.4394, 2733.4765, 2893.5071, 2980.5391, 3140.5698, 3237.6226, 3338.6702, 3395.6917, 3542.7601, 3655.8442, 3768.9282, 3855.9603, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 234.1448, 347.2289, 460.3130, 607.3814, 664.4028, 765.4505, 862.5033, 1022.5339, 1109.5660, 1269.5966, 1340.6337, 1453.7178, 1600.7862, 1713.8703, 1826.9543, 1926.0227, 2089.0861, 2249.1167, 2362.2008, 2475.2848, 2576.3325, 2689.4166, 2836.4850, 2949.5691, 3135.6484, 3282.7168, 3395.8009, 3558.8642, 3659.9119, 3774.9388, 3888.9817, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ELHLSVINAHFEYFVMLLIAILYLSYGAMWCFR", {130.0499, 243.1339, 380.1928, 493.2769, 580.3089, 679.3774, 792.4614, 906.5043, 977.5415, 1114.6004, 1261.6688, 1390.7114, 1553.7747, 1700.8431, 1799.9115, 1930.9520, 2044.0361, 2157.1201, 2270.2042, 2341.2413, 2454.3254, 2567.4095, 2730.4728, 2843.5568, 2930.5889, 3093.6522, 3150.6737, 3221.7108, 3352.7513, 3538.8306, 3698.8612, 3845.9296, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 482.2180, 668.2973, 799.3378, 870.3749, 927.3964, 1090.4597, 1177.4917, 1290.5758, 1453.6391, 1566.7232, 1679.8073, 1750.8444, 1863.9284, 1977.0125, 2090.0966, 2221.1371, 2320.2055, 2467.2739, 2630.3372, 2759.3798, 2906.4482, 3043.5071, 3114.5442, 3228.5872, 3341.6712, 3440.7397, 3527.7717, 3640.8557, 3777.9147, 3890.9987, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DSEVYYIDDFRPNFPCATDDPDCFPNLWMSQAK", {116.0342, 203.0662, 332.1088, 431.1773, 594.2406, 757.3039, 870.3880, 985.4149, 1100.4419, 1247.5103, 1403.6114, 1500.6642, 1614.7071, 1761.7755, 1858.8283, 2018.8589, 2089.8960, 2190.9437, 2305.9706, 2420.9976, 2518.0503, 2633.0773, 2793.1079, 2940.1764, 3037.2291, 3151.2720, 3264.3561, 3450.4354, 3581.4759, 3668.5079, 3796.5665, 3867.6036, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 218.1499, 346.2085, 433.2405, 564.2810, 750.3603, 863.4444, 977.4873, 1074.5401, 1221.6085, 1381.6391, 1496.6661, 1593.7188, 1708.7458, 1823.7727, 1924.8204, 1995.8575, 2155.8882, 2252.9409, 2400.0094, 2514.0523, 2611.1050, 2767.2062, 2914.2746, 3029.3015, 3144.3285, 3257.4125, 3420.4758, 3583.5392, 3682.6076, 3811.6502, 3898.6822, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"IITLESHPLWADTVLPYVILNCIFACFFYLYPK", {114.0913, 227.1754, 328.2231, 441.3071, 570.3497, 657.3818, 794.4407, 891.4934, 1004.5775, 1190.6568, 1261.6939, 1376.7209, 1477.7686, 1576.8370, 1689.9210, 1786.9738, 1950.0371, 2049.1055, 2162.1896, 2275.2737, 2389.3166, 2549.3472, 2662.4313, 2809.4997, 2880.5368, 3040.5675, 3187.6359, 3334.7043, 3497.7676, 3610.8517, 3773.9150, 3870.9678, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 244.1656, 407.2289, 520.3130, 683.3763, 830.4447, 977.5131, 1137.5438, 1208.5809, 1355.6493, 1468.7334, 1628.7640, 1742.8069, 1855.8910, 1968.9751, 2068.0435, 2231.1068, 2328.1596, 2441.2436, 2540.3120, 2641.3597, 2756.3867, 2827.4238, 3013.5031, 3126.5872, 3223.6399, 3360.6988, 3447.7309, 3576.7735, 3689.8575, 3790.9052, 3903.9893, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"AVINQYEAEVLQGDYYTILDEFPYEYGQLCECK", {72.0444, 171.1128, 284.1969, 398.2398, 526.2984, 689.3617, 818.4043, 889.4414, 1018.4840, 1117.5524, 1230.6365, 1358.6951, 1415.7165, 1530.7435, 1693.8068, 1856.8701, 1957.9178, 2071.0019, 2184.0859, 2299.1129, 2428.1555, 2575.2239, 2672.2766, 2835.3400, 2964.3826, 3127.4459, 3184.4674, 3312.5259, 3425.6100, 3585.6406, 3714.6832, 3874.7139, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 307.1435, 436.1860, 596.2167, 709.3008, 837.3593, 894.3808, 1057.4441, 1186.4867, 1349.5500, 1446.6028, 1593.6712, 1722.7138, 1837.7408, 1950.8248, 2063.9089, 2164.9566, 2328.0199, 2491.0832, 2606.1102, 2663.1316, 2791.1902, 2904.2743, 3003.3427, 3132.3853, 3203.4224, 3332.4650, 3495.5283, 3623.5869, 3737.6298, 3850.7139, 3949.7823, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MISATCFLVDLCIWTLCHESGLPFYGTFSFFFR", {132.0478, 245.1318, 332.1639, 403.2010, 504.2486, 664.2793, 811.3477, 924.4318, 1023.5002, 1138.5271, 1251.6112, 1411.6418, 1524.7259, 1710.8052, 1811.8529, 1924.9370, 2084.9676, 2222.0265, 2351.0691, 2438.1011, 2495.1226, 2608.2067, 2705.2594, 2852.3278, 3015.3912, 3072.4126, 3173.4603, 3320.5287, 3407.5608, 3554.6292, 3701.6976, 3848.7660, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 469.2558, 616.3242, 703.3562, 850.4246, 951.4723, 1008.4938, 1171.5571, 1318.6255, 1415.6783, 1528.7623, 1585.7838, 1672.8158, 1801.8584, 1938.9173, 2098.9480, 2212.0321, 2313.0797, 2499.1591, 2612.2431, 2772.2738, 2885.3578, 3000.3848, 3099.4532, 3212.5372, 3359.6057, 3519.6363, 3620.6840, 3691.7211, 3778.7531, 3891.8372, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YQVCSISNLVTCFFFDLAFPCGCEQNLSMIQNR", {164.0706, 292.1292, 391.1976, 551.2282, 638.2603, 751.3443, 838.3764, 952.4193, 1065.5034, 1164.5718, 1265.6194, 1425.6501, 1572.7185, 1719.7869, 1866.8553, 1981.8823, 2094.9663, 2166.0035, 2313.0719, 2410.1246, 2570.1553, 2627.1768, 2787.2074, 2916.2500, 3044.3086, 3158.3515, 3271.4356, 3358.4676, 3489.5081, 3602.5921, 3730.6507, 3844.6936, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 289.1619, 417.2205, 530.3045, 661.3450, 748.3770, 861.4611, 975.5040, 1103.5626, 1232.6052, 1392.6358, 1449.6573, 1609.6880, 1706.7407, 1853.8091, 1924.8462, 2037.9303, 2152.9573, 2300.0257, 2447.0941, 2594.1625, 2754.1931, 2855.2408, 2954.3092, 3067.3933, 3181.4362, 3268.4683, 3381.5523, 3468.5844, 3628.6150, 3727.6834, 3855.7420, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"HDGTYGEPCQTCIYEAHEILEFQPNLDMYNYSK", {138.0662, 253.0931, 310.1146, 411.1623, 574.2256, 631.2471, 760.2897, 857.3424, 1017.3731, 1145.4316, 1246.4793, 1406.5100, 1519.5940, 1682.6574, 1811.7000, 1882.7371, 2019.7960, 2148.8386, 2261.9226, 2375.0067, 2504.0493, 2651.1177, 2779.1763, 2876.2291, 2990.2720, 3103.3560, 3218.3830, 3349.4235, 3512.4868, 3626.5297, 3789.5931, 3876.6251, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 234.1448, 397.2082, 511.2511, 674.3144, 805.3549, 920.3818, 1033.4659, 1147.5088, 1244.5616, 1372.6202, 1519.6886, 1648.7312, 1761.8152, 1874.8993, 2003.9419, 2141.0008, 2212.0379, 2341.0805, 2504.1439, 2617.2279, 2777.2586, 2878.3062, 3006.3648, 3166.3955, 3263.4482, 3392.4908, 3449.5123, 3612.5756, 3713.6233, 3770.6448, 3885.6717, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VFAKPYNCDIFLLQFAHVMILIFQVMQLTTLYK", {100.0757, 247.1441, 318.1812, 446.2762, 543.3289, 706.3923, 820.4352, 980.4658, 1095.4928, 1208.5769, 1355.6453, 1468.7293, 1581.8134, 1709.8720, 1856.9404, 1927.9775, 2065.0364, 2164.1048, 2295.1453, 2408.2294, 2521.3134, 2634.3975, 2781.4659, 2909.5245, 3008.5929, 3139.6334, 3267.6920, 3380.7760, 3481.8237, 3582.8714, 3695.9555, 3859.0188, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 310.1761, 423.2602, 524.3079, 625.3556, 738.4396, 866.4982, 997.5387, 1096.6071, 1224.6657, 1371.7341, 1484.8181, 1597.9022, 1710.9863, 1842.0268, 1941.0952, 2078.1541, 2149.1912, 2296.2596, 2424.3182, 2537.4023, 2650.4863, 2797.5547, 2910.6388, 3025.6657, 3185.6964, 3299.7393, 3462.8026, 3559.8554, 3687.9504, 3758.9875, 3906.0559, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"GNPCEELVQGCHILHETFTQADFWENCFLCSSK", {58.0287, 172.0717, 269.1244, 429.1551, 558.1977, 687.2403, 800.3243, 899.3927, 1027.4513, 1084.4728, 1244.5034, 1381.5623, 1494.6464, 1607.7305, 1744.7894, 1873.8320, 1974.8797, 2121.9481, 2222.9957, 2351.0543, 2422.0914, 2537.1184, 2684.1868, 2870.2661, 2999.3087, 3113.3516, 3273.3823, 3420.4507, 3533.5348, 3693.5654, 3780.5974, 3867.6295, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 234.1448, 321.1769, 481.2075, 594.2916, 741.3600, 901.3906, 1015.4336, 1144.4762, 1330.5555, 1477.6239, 1592.6508, 1663.6879, 1791.7465, 1892.7942, 2039.8626, 2140.9103, 2269.9529, 2407.0118, 2520.0959, 2633.1799, 2770.2388, 2930.2695, 2987.2909, 3115.3495, 3214.4179, 3327.5020, 3456.5446, 3585.5872, 3745.6178, 3842.6706, 3956.7135, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SSLTQIHECEIQPNQVWFLNYNWAPFLNFVGNR", {88.0393, 175.0713, 288.1554, 389.2031, 517.2617, 630.3457, 767.4046, 896.4472, 1056.4779, 1185.5205, 1298.6045, 1426.6631, 1523.7159, 1637.7588, 1765.8174, 1864.8858, 2050.9651, 2198.0335, 2311.1176, 2425.1605, 2588.2238, 2702.2668, 2888.3461, 2959.3832, 3056.4360, 3203.5044, 3316.5884, 3430.6314, 3577.6998, 3676.7682, 3733.7897, 3847.8326, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 289.1619, 346.1833, 445.2518, 592.3202, 706.3631, 819.4472, 966.5156, 1063.5683, 1134.6055, 1320.6848, 1434.7277, 1597.7910, 1711.8340, 1824.9180, 1971.9864, 2158.0657, 2257.1342, 2385.1927, 2499.2357, 2596.2884, 2724.3470, 2837.4311, 2966.4737, 3126.5043, 3255.5469, 3392.6058, 3505.6899, 3633.7485, 3734.7961, 3847.8802, 3934.9122, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"AQYEPVWETTQQVPPNELHYQTYEPCMALNQHK", {72.0444, 200.1030, 363.1663, 492.2089, 589.2617, 688.3301, 874.4094, 1003.4520, 1104.4997, 1205.5473, 1333.6059, 1461.6645, 1560.7329, 1657.7857, 1754.8384, 1868.8814, 1997.9239, 2111.0080, 2248.0669, 2411.1303, 2539.1888, 2640.2365, 2803.2998, 2932.3424, 3029.3952, 3189.4258, 3320.4663, 3391.5034, 3504.5875, 3618.6304, 3746.6890, 3883.7479, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 284.1717, 412.2303, 526.2732, 639.3573, 710.3944, 841.4349, 1001.4655, 1098.5183, 1227.5609, 1390.6242, 1491.6719, 1619.7305, 1782.7938, 1919.8527, 2032.9368, 2161.9794, 2276.0223, 2373.0751, 2470.1278, 2569.1962, 2697.2548, 2825.3134, 2926.3611, 3027.4088, 3156.4513, 3342.5307, 3441.5991, 3538.6518, 3667.6944, 3830.7578, 3958.8163, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"GSPCLEPDCYNQAFTFTFIILVLYLLFIWCPSR", {58.0287, 145.0608, 242.1135, 402.1442, 515.2282, 644.2708, 741.3236, 856.3505, 1016.3812, 1179.4445, 1293.4874, 1421.5460, 1492.5831, 1639.6516, 1740.6992, 1887.7676, 1988.8153, 2135.8837, 2248.9678, 2362.0519, 2475.1359, 2574.2043, 2687.2884, 2850.3517, 2963.4358, 3076.5199, 3223.5883, 3336.6723, 3522.7517, 3682.7823, 3779.8351, 3866.8671, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 262.1510, 359.2037, 519.2344, 705.3137, 818.3978, 965.4662, 1078.5502, 1191.6343, 1354.6976, 1467.7817, 1566.8501, 1679.9342, 1793.0182, 1906.1023, 2053.1707, 2154.2184, 2301.2868, 2402.3345, 2549.4029, 2620.4400, 2748.4986, 2862.5415, 3025.6049, 3185.6355, 3300.6624, 3397.7152, 3526.7578, 3639.8419, 3799.8725, 3896.9253, 3983.9573, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"AGEHHFIQEHQHQFYEYHGVHDPHHETPPSHIR", {72.0444, 129.0659, 258.1084, 395.1674, 532.2263, 679.2947, 792.3787, 920.4373, 1049.4799, 1186.5388, 1314.5974, 1451.6563, 1579.7149, 1726.7833, 1889.8466, 2018.8892, 2181.9526, 2319.0115, 2376.0329, 2475.1014, 2612.1603, 2727.1872, 2824.2400, 2961.2989, 3098.3578, 3227.4004, 3328.4481, 3425.5008, 3522.5536, 3609.5856, 3746.6445, 3859.7286, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 425.2619, 512.2940, 609.3467, 706.3995, 807.4472, 936.4898, 1073.5487, 1210.6076, 1307.6603, 1422.6873, 1559.7462, 1658.8146, 1715.8361, 1852.8950, 2015.9583, 2145.0009, 2308.0642, 2455.1327, 2583.1912, 2720.2501, 2848.3087, 2985.3676, 3114.4102, 3242.4688, 3355.5529, 3502.6213, 3639.6802, 3776.7391, 3905.7817, 3962.8032, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ELSNSQLLNVSFSVWICIHFTVNWVMSYATYHR", {130.0499, 243.1339, 330.1660, 444.2089, 531.2409, 659.2995, 772.3836, 885.4676, 999.5106, 1098.5790, 1185.6110, 1332.6794, 1419.7114, 1518.7798, 1704.8592, 1817.9432, 1977.9739, 2091.0579, 2228.1169, 2375.1853, 2476.2329, 2575.3014, 2689.3443, 2875.4236, 2974.4920, 3105.5325, 3192.5645, 3355.6279, 3426.6650, 3527.7126, 3690.7760, 3827.8349, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 312.1779, 475.2412, 576.2889, 647.3260, 810.3893, 897.4213, 1028.4618, 1127.5302, 1313.6096, 1427.6525, 1526.7209, 1627.7686, 1774.8370, 1911.8959, 2024.9800, 2185.0106, 2298.0947, 2484.1740, 2583.2424, 2670.2744, 2817.3428, 2904.3749, 3003.4433, 3117.4862, 3230.5703, 3343.6543, 3471.7129, 3558.7449, 3672.7879, 3759.8199, 3872.9040, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MINYLLPNICTSLYYLVGSVYTMVTYVFEHQDR", {132.0478, 245.1318, 359.1748, 522.2381, 635.3221, 748.4062, 845.4590, 959.5019, 1072.5860, 1232.6166, 1333.6643, 1420.6963, 1533.7804, 1696.8437, 1859.9070, 1972.9911, 2072.0595, 2129.0810, 2216.1130, 2315.1814, 2478.2448, 2579.2924, 2710.3329, 2809.4013, 2910.4490, 3073.5123, 3172.5808, 3319.6492, 3448.6918, 3585.7507, 3713.8092, 3828.8362, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 290.1459, 418.2045, 555.2634, 684.3060, 831.3744, 930.4428, 1093.5061, 1194.5538, 1293.6222, 1424.6627, 1525.7104, 1688.7737, 1787.8421, 1874.8742, 1931.8956, 2030.9640, 2144.0481, 2307.1114, 2470.1748, 2583.2588, 2670.2909, 2771.3385, 2931.3692, 3044.4532, 3158.4962, 3255.5489, 3368.6330, 3481.7171, 3644.7804, 3758.8233, 3871.9074, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"GNPHNLDHPDYFMEFEDYHTHGYFQATVTSEYR", {58.0287, 172.0717, 269.1244, 406.1833, 520.2263, 633.3103, 748.3373, 885.3962, 982.4490, 1097.4759, 1260.5392, 1407.6076, 1538.6481, 1667.6907, 1814.7591, 1943.8017, 2058.8287, 2221.8920, 2358.9509, 2459.9986, 2597.0575, 2654.0790, 2817.1423, 2964.2107, 3092.2693, 3163.3064, 3264.3541, 3363.4225, 3464.4702, 3551.5022, 3680.5448, 3843.6081, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 467.2249, 554.2569, 655.3046, 754.3730, 855.4207, 926.4578, 1054.5164, 1201.5848, 1364.6481, 1421.6696, 1558.7285, 1659.7762, 1796.8351, 1959.8984, 2074.9253, 2203.9679, 2351.0364, 2480.0789, 2611.1194, 2758.1878, 2921.2512, 3036.2781, 3133.3309, 3270.3898, 3385.4167, 3498.5008, 3612.5437, 3749.6026, 3846.6554, 3960.6983, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TANVVAYLFDMFYFYDEDIISVNWMEQIYENAK", {102.0550, 173.0921, 287.1350, 386.2034, 485.2718, 556.3089, 719.3723, 832.4563, 979.5247, 1094.5517, 1225.5922, 1372.6606, 1535.7239, 1682.7923, 1845.8557, 1960.8826, 2089.9252, 2204.9521, 2318.0362, 2431.1203, 2518.1523, 2617.2207, 2731.2636, 2917.3429, 3048.3834, 3177.4260, 3305.4846, 3418.5687, 3581.6320, 3710.6746, 3824.7175, 3895.7546, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 218.1499, 332.1928, 461.2354, 624.2988, 737.3828, 865.4414, 994.4840, 1125.5245, 1311.6038, 1425.6467, 1524.7151, 1611.7472, 1724.8312, 1837.9153, 1952.9422, 2081.9848, 2197.0118, 2360.0751, 2507.1435, 2670.2068, 2817.2753, 2948.3157, 3063.3427, 3210.4111, 3323.4952, 3486.5585, 3557.5956, 3656.6640, 3755.7324, 3869.7754, 3940.8125, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"HHEFIIADLVYFLLCSASFLTAPDYNVNNWYYK", {138.0662, 275.1251, 404.1677, 551.2361, 664.3202, 777.4042, 848.4413, 963.4683, 1076.5524, 1175.6208, 1338.6841, 1485.7525, 1598.8366, 1711.9206, 1871.9513, 1958.9833, 2030.0204, 2117.0525, 2264.1209, 2377.2049, 2478.2526, 2549.2897, 2646.3425, 2761.3694, 2924.4328, 3038.4757, 3137.5441, 3251.5870, 3365.6300, 3551.7093, 3714.7726, 3877.8359, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 310.1761, 473.2395, 659.3188, 773.3617, 887.4046, 986.4730, 1100.5160, 1263.5793, 1378.6062, 1475.6590, 1546.6961, 1647.7438, 1760.8279, 1907.8963, 1994.9283, 2065.9654, 2152.9974, 2313.0281, 2426.1122, 2539.1962, 2686.2646, 2849.3280, 2948.3964, 3061.4804, 3176.5074, 3247.5445, 3360.6286, 3473.7126, 3620.7810, 3749.8236, 3886.8825, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QQQNLAHVHQCFAQLVEFHTMLNAPQNDYHLHR", {129.0659, 257.1244, 385.1830, 499.2259, 612.3100, 683.3471, 820.4060, 919.4744, 1056.5334, 1184.5919, 1344.6226, 1491.6910, 1562.7281, 1690.7867, 1803.8707, 1902.9392, 2031.9818, 2179.0502, 2316.1091, 2417.1568, 2548.1972, 2661.2813, 2775.3242, 2846.3613, 2943.4141, 3071.4727, 3185.5156, 3300.5426, 3463.6059, 3600.6648, 3713.7489, 3850.8078, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 312.1779, 425.2619, 562.3208, 725.3842, 840.4111, 954.4540, 1082.5126, 1179.5654, 1250.6025, 1364.6454, 1477.7295, 1608.7700, 1709.8176, 1846.8766, 1993.9450, 2122.9876, 2222.0560, 2335.1400, 2463.1986, 2534.2357, 2681.3042, 2841.3348, 2969.3934, 3106.4523, 3205.5207, 3342.5796, 3413.6167, 3526.7008, 3640.7437, 3768.8023, 3896.8609, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"HYLGLHHHPHHAHHHHPHDLHTLTQQLQELHTK", {138.0662, 301.1295, 414.2136, 471.2350, 584.3191, 721.3780, 858.4369, 995.4958, 1092.5486, 1229.6075, 1366.6664, 1437.7035, 1574.7625, 1711.8214, 1848.8803, 1985.9392, 2082.9920, 2220.0509, 2335.0778, 2448.1619, 2585.2208, 2686.2685, 2799.3525, 2900.4002, 3028.4588, 3156.5174, 3269.6014, 3397.6600, 3526.7026, 3639.7867, 3776.8456, 3877.8933, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 248.1605, 385.2194, 498.3035, 627.3461, 755.4046, 868.4887, 996.5473, 1124.6058, 1225.6535, 1338.7376, 1439.7853, 1576.8442, 1689.9282, 1804.9552, 1942.0141, 2039.0669, 2176.1258, 2313.1847, 2450.2436, 2587.3025, 2658.3396, 2795.3985, 2932.4574, 3029.5102, 3166.5691, 3303.6280, 3440.6869, 3553.7710, 3610.7925, 3723.8765, 3886.9399, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LPQFRPLSNKPIQLPISNNPCEPMNCCQYEDDK", {114.0913, 211.1441, 339.2027, 486.2711, 642.3722, 739.4250, 852.5090, 939.5411, 1053.5840, 1181.6790, 1278.7317, 1391.8158, 1519.8744, 1632.9584, 1730.0112, 1843.0953, 1930.1273, 2044.1702, 2158.2131, 2255.2659, 2415.2965, 2544.3391, 2641.3919, 2772.4324, 2886.4753, 3046.5060, 3206.5366, 3334.5952, 3497.6585, 3626.7011, 3741.7281, 3856.7550, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 262.1397, 377.1667, 506.2093, 669.2726, 797.3312, 957.3618, 1117.3925, 1231.4354, 1362.4759, 1459.5287, 1588.5713, 1748.6019, 1845.6547, 1959.6976, 2073.7405, 2160.7726, 2273.8566, 2370.9094, 2483.9934, 2612.0520, 2725.1361, 2822.1888, 2950.2838, 3064.3267, 3151.3588, 3264.4428, 3361.4956, 3517.5967, 3664.6651, 3792.7237, 3889.7765, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YFSAMGIQEYLFYSAILLELPGLWLFHFHILCR", {164.0706, 311.1390, 398.1710, 469.2082, 600.2486, 657.2701, 770.3542, 898.4128, 1027.4553, 1190.5187, 1303.6027, 1450.6712, 1613.7345, 1700.7665, 1771.8036, 1884.8877, 1997.9717, 2111.0558, 2240.0984, 2353.1825, 2450.2352, 2507.2567, 2620.3408, 2806.4201, 2919.5041, 3066.5726, 3203.6315, 3350.6999, 3487.7588, 3600.8429, 3713.9269, 3873.9576, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 335.1496, 448.2337, 561.3177, 698.3766, 845.4451, 982.5040, 1129.5724, 1242.6564, 1428.7358, 1541.8198, 1598.8413, 1695.8940, 1808.9781, 1938.0207, 2051.1048, 2164.1888, 2277.2729, 2348.3100, 2435.3420, 2598.4054, 2745.4738, 2858.5578, 3021.6212, 3150.6638, 3278.7223, 3391.8064, 3448.8279, 3579.8684, 3650.9055, 3737.9375, 3885.0059, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LCYDNSFSILTYILRPFVVYAYTGLLELQWWAK", {114.0913, 274.1220, 437.1853, 552.2123, 666.2552, 753.2872, 900.3556, 987.3877, 1100.4717, 1213.5558, 1314.6035, 1477.6668, 1590.7509, 1703.8349, 1859.9360, 1956.9888, 2104.0572, 2203.1256, 2302.1940, 2465.2574, 2536.2945, 2699.3578, 2800.4055, 2857.4270, 2970.5110, 3083.5951, 3212.6377, 3325.7217, 3453.7803, 3639.8596, 3825.9389, 3896.9761, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 218.1499, 404.2292, 590.3085, 718.3671, 831.4512, 960.4938, 1073.5778, 1186.6619, 1243.6834, 1344.7310, 1507.7944, 1578.8315, 1741.8948, 1840.9632, 1940.0316, 2087.1001, 2184.1528, 2340.2539, 2453.3380, 2566.4221, 2729.4854, 2830.5331, 2943.6171, 3056.7012, 3143.7332, 3290.8016, 3377.8337, 3491.8766, 3606.9035, 3769.9669, 3929.9975, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PQQWQPQPNWQPQPQPNWQPQPAGWQPQPNHLR", {98.0600, 226.1186, 354.1772, 540.2565, 668.3151, 765.3678, 893.4264, 990.4792, 1104.5221, 1290.6014, 1418.6600, 1515.7128, 1643.7714, 1740.8241, 1868.8827, 1965.9355, 2079.9784, 2266.0577, 2394.1163, 2491.1690, 2619.2276, 2716.2804, 2787.3175, 2844.3390, 3030.4183, 3158.4768, 3255.5296, 3383.5882, 3480.6410, 3594.6839, 3731.7428, 3844.8269, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 425.2619, 539.3049, 636.3576, 764.4162, 861.4690, 989.5275, 1175.6069, 1232.6283, 1303.6654, 1400.7182, 1528.7768, 1625.8295, 1753.8881, 1939.9674, 2054.0104, 2151.0631, 2279.1217, 2376.1745, 2504.2330, 2601.2858, 2729.3444, 2915.4237, 3029.4666, 3126.5194, 3254.5780, 3351.6307, 3479.6893, 3665.7686, 3793.8272, 3921.8858, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FATFINDGNIVICILWLLSVFVLDFTVFLCFFR", {148.0757, 219.1128, 320.1605, 467.2289, 580.3130, 694.3559, 809.3828, 866.4043, 980.4472, 1093.5313, 1192.5997, 1305.6838, 1465.7144, 1578.7985, 1691.8825, 1877.9619, 1991.0459, 2104.1300, 2191.1620, 2290.2304, 2437.2988, 2536.3673, 2649.4513, 2764.4783, 2911.5467, 3012.5944, 3111.6628, 3258.7312, 3371.8152, 3531.8459, 3678.9143, 3825.9827, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 469.2558, 629.2864, 742.3705, 889.4389, 988.5073, 1089.5550, 1236.6234, 1351.6504, 1464.7344, 1563.8028, 1710.8712, 1809.9397, 1896.9717, 2010.0558, 2123.1398, 2309.2191, 2422.3032, 2535.3873, 2695.4179, 2808.5020, 2907.5704, 3020.6544, 3134.6974, 3191.7188, 3306.7458, 3420.7887, 3533.8728, 3680.9412, 3781.9889, 3853.0260, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LSGLISFLLFYTFYAHNAWGVCHNIWPCHHDMK", {114.0913, 201.1234, 258.1448, 371.2289, 484.3130, 571.3450, 718.4134, 831.4975, 944.5815, 1091.6499, 1254.7133, 1355.7610, 1502.8294, 1665.8927, 1736.9298, 1873.9887, 1988.0316, 2059.0688, 2245.1481, 2302.1695, 2401.2380, 2561.2686, 2698.3275, 2812.3704, 2925.4545, 3111.5338, 3208.5866, 3368.6172, 3505.6761, 3642.7351, 3757.7620, 3888.8025, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 278.1533, 393.1802, 530.2391, 667.2981, 827.3287, 924.3815, 1110.4608, 1223.5448, 1337.5878, 1474.6467, 1634.6773, 1733.7457, 1790.7672, 1976.8465, 2047.8836, 2161.9266, 2298.9855, 2370.0226, 2533.0859, 2680.1543, 2781.2020, 2944.2653, 3091.3338, 3204.4178, 3317.5019, 3464.5703, 3551.6023, 3664.6864, 3777.7705, 3834.7919, 3921.8239, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NNSSFSEIYIPCVQIDMPYLQFEMQCAIIAHMR", {115.0502, 229.0931, 316.1252, 403.1572, 550.2256, 637.2576, 766.3002, 879.3843, 1042.4476, 1155.5317, 1252.5844, 1412.6151, 1511.6835, 1639.7421, 1752.8261, 1867.8531, 1998.8936, 2095.9463, 2259.0097, 2372.0937, 2500.1523, 2647.2207, 2776.2633, 2907.3038, 3035.3624, 3195.3930, 3266.4301, 3379.5142, 3492.5983, 3563.6354, 3700.6943, 3831.7348, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 306.1594, 443.2183, 514.2555, 627.3395, 740.4236, 811.4607, 971.4914, 1099.5499, 1230.5904, 1359.6330, 1506.7014, 1634.7600, 1747.8441, 1910.9074, 2007.9602, 2139.0006, 2254.0276, 2367.1116, 2495.1702, 2594.2386, 2754.2693, 2851.3221, 2964.4061, 3127.4694, 3240.5535, 3369.5961, 3456.6281, 3603.6965, 3690.7286, 3777.7606, 3891.8035, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FYPDPQWFNEFVEPLLTVYDDGEEFIDDPIELR", {148.0757, 311.1390, 408.1918, 523.2187, 620.2715, 748.3301, 934.4094, 1081.4778, 1195.5207, 1324.5633, 1471.6317, 1570.7001, 1699.7427, 1796.7955, 1909.8796, 2022.9636, 2124.0113, 2223.0797, 2386.1430, 2501.1700, 2616.1969, 2673.2184, 2802.2610, 2931.3036, 3078.3720, 3191.4561, 3306.4830, 3421.5099, 3518.5627, 3631.6468, 3760.6894, 3873.7734, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 417.2456, 530.3297, 627.3824, 742.4094, 857.4363, 970.5204, 1117.5888, 1246.6314, 1375.6740, 1432.6955, 1547.7224, 1662.7493, 1825.8127, 1924.8811, 2025.9288, 2139.0128, 2252.0969, 2349.1497, 2478.1922, 2577.2607, 2724.3291, 2853.3717, 2967.4146, 3114.4830, 3300.5623, 3428.6209, 3525.6737, 3640.7006, 3737.7534, 3900.8167, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SAGFILPGYTFHLLYLCVYFLENVCCMFTLIDK", {88.0393, 159.0764, 216.0979, 363.1663, 476.2504, 589.3344, 686.3872, 743.4087, 906.4720, 1007.5197, 1154.5881, 1291.6470, 1404.7310, 1517.8151, 1680.8784, 1793.9625, 1953.9932, 2053.0616, 2216.1249, 2363.1933, 2476.2774, 2605.3200, 2719.3629, 2818.4313, 2978.4620, 3138.4926, 3269.5331, 3416.6015, 3517.6492, 3630.7332, 3743.8173, 3858.8443, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 262.1397, 375.2238, 488.3079, 589.3556, 736.4240, 867.4645, 1027.4951, 1187.5257, 1286.5942, 1400.6371, 1529.6797, 1642.7637, 1789.8322, 1952.8955, 2051.9639, 2211.9946, 2325.0786, 2488.1419, 2601.2260, 2714.3101, 2851.3690, 2998.4374, 3099.4851, 3262.5484, 3319.5699, 3416.6226, 3529.7067, 3642.7908, 3789.8592, 3846.8806, 3917.9178, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NLYAEYEVIDPTTDYHYHGGWNAFSFSHFHQLR", {115.0502, 228.1343, 391.1976, 462.2347, 591.2773, 754.3406, 883.3832, 982.4516, 1095.5357, 1210.5626, 1307.6154, 1408.6631, 1509.7108, 1624.7377, 1787.8010, 1924.8600, 2087.9233, 2224.9822, 2282.0037, 2339.0251, 2525.1044, 2639.1474, 2710.1845, 2857.2529, 2944.2849, 3091.3533, 3178.3854, 3315.4443, 3462.5127, 3599.5716, 3727.6302, 3840.7142, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 416.2616, 553.3205, 700.3889, 837.4478, 924.4799, 1071.5483, 1158.5803, 1305.6487, 1376.6858, 1490.7288, 1676.8081, 1733.8295, 1790.8510, 1927.9099, 2090.9732, 2228.0322, 2391.0955, 2506.1224, 2607.1701, 2708.2178, 2805.2705, 2920.2975, 3033.3815, 3132.4500, 3261.4926, 3424.5559, 3553.5985, 3624.6356, 3787.6989, 3900.7830, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LLVLIEYCLGMFLALFIVQEFENVCNLDCAMIR", {114.0913, 227.1754, 326.2438, 439.3279, 552.4119, 681.4545, 844.5179, 1004.5485, 1117.6326, 1174.6540, 1305.6945, 1452.7629, 1565.8470, 1636.8841, 1749.9682, 1897.0366, 2010.1207, 2109.1891, 2237.2477, 2366.2902, 2513.3587, 2642.4013, 2756.4442, 2855.5126, 3015.5432, 3129.5862, 3242.6702, 3357.6972, 3517.7278, 3588.7649, 3719.8054, 3832.8895, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 419.2435, 490.2806, 650.3113, 765.3382, 878.4223, 992.4652, 1152.4958, 1251.5643, 1365.6072, 1494.6498, 1641.7182, 1770.7608, 1898.8194, 1997.8878, 2110.9718, 2258.0403, 2371.1243, 2442.1614, 2555.2455, 2702.3139, 2833.3544, 2890.3759, 3003.4599, 3163.4906, 3326.5539, 3455.5965, 3568.6806, 3681.7646, 3780.8330, 3893.9171, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EIHQSWQAHTDCDTGCDPCMYHIYDECLEAAGR", {130.0499, 243.1339, 380.1928, 508.2514, 595.2835, 781.3628, 909.4213, 980.4585, 1117.5174, 1218.5650, 1333.5920, 1493.6226, 1608.6496, 1709.6973, 1766.7187, 1926.7494, 2041.7763, 2138.8291, 2298.8597, 2429.9002, 2592.9635, 2730.0225, 2843.1065, 3006.1698, 3121.1968, 3250.2394, 3410.2700, 3523.3541, 3652.3967, 3723.4338, 3794.4709, 3851.4924, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 232.1404, 303.1775, 374.2146, 503.2572, 616.3413, 776.3719, 905.4145, 1020.4415, 1183.5048, 1296.5889, 1433.6478, 1596.7111, 1727.7516, 1887.7823, 1984.8350, 2099.8620, 2259.8926, 2316.9141, 2417.9617, 2532.9887, 2693.0193, 2808.0463, 2909.0940, 3046.1529, 3117.1900, 3245.2486, 3431.3279, 3518.3599, 3646.4185, 3783.4774, 3896.5615, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MFHSTCNCNDLQLLVTCEVVCGSYSYFDYIGQR", {132.0478, 279.1162, 416.1751, 503.2071, 604.2548, 764.2854, 878.3284, 1038.3590, 1152.4019, 1267.4289, 1380.5130, 1508.5715, 1621.6556, 1734.7397, 1833.8081, 1934.8558, 2094.8864, 2223.9290, 2322.9974, 2422.0658, 2582.0965, 2639.1179, 2726.1500, 2889.2133, 2976.2453, 3139.3086, 3286.3771, 3401.4040, 3564.4673, 3677.5514, 3734.5729, 3862.6314, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 360.1990, 473.2831, 636.3464, 751.3733, 898.4417, 1061.5051, 1148.5371, 1311.6004, 1398.6325, 1455.6539, 1615.6846, 1714.7530, 1813.8214, 1942.8640, 2102.8946, 2203.9423, 2303.0107, 2416.0948, 2529.1789, 2657.2374, 2770.3215, 2885.3484, 2999.3914, 3159.4220, 3273.4649, 3433.4956, 3534.5433, 3621.5753, 3758.6342, 3905.7026, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FEDFDNCLDFGQHYYTVCAQYYDLLTSLISPVK", {148.0757, 277.1183, 392.1452, 539.2136, 654.2406, 768.2835, 928.3142, 1041.3982, 1156.4252, 1303.4936, 1360.5150, 1488.5736, 1625.6325, 1788.6959, 1951.7592, 2052.8069, 2151.8753, 2311.9059, 2382.9430, 2511.0016, 2674.0650, 2837.1283, 2952.1552, 3065.2393, 3178.3234, 3279.3710, 3366.4031, 3479.4871, 3592.5712, 3679.6032, 3776.6560, 3875.7244, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 246.1812, 343.2340, 430.2660, 543.3501, 656.4341, 743.4662, 844.5138, 957.5979, 1070.6820, 1185.7089, 1348.7722, 1511.8356, 1639.8942, 1710.9313, 1870.9619, 1970.0303, 2071.0780, 2234.1413, 2397.2047, 2534.2636, 2662.3222, 2719.3436, 2866.4120, 2981.4390, 3094.5230, 3254.5537, 3368.5966, 3483.6236, 3630.6920, 3745.7189, 3874.7615, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TLDHPIISGLLVFMFVFLVCIIFWMILDQWLTR", {102.0550, 215.1390, 330.1660, 467.2249, 564.2776, 677.3617, 790.4458, 877.4778, 934.4993, 1047.5833, 1160.6674, 1259.7358, 1406.8042, 1537.8447, 1684.9131, 1783.9815, 1931.0499, 2044.1340, 2143.2024, 2303.2331, 2416.3171, 2529.4012, 2676.4696, 2862.5489, 2993.5894, 3106.6735, 3219.7575, 3334.7845, 3462.8431, 3648.9224, 3762.0064, 3863.0541, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 276.1666, 389.2507, 575.3300, 703.3886, 818.4155, 931.4996, 1044.5837, 1175.6241, 1361.7035, 1508.7719, 1621.8559, 1734.9400, 1894.9706, 1994.0391, 2107.1231, 2254.1915, 2353.2600, 2500.3284, 2631.3688, 2778.4373, 2877.5057, 2990.5897, 3103.6738, 3160.6953, 3247.7273, 3360.8114, 3473.8954, 3570.9482, 3708.0071, 3823.0340, 3936.1181, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SLQQLLESLMCWVKPSWNEAFLPMFLENLHDAR", {88.0393, 201.1234, 329.1819, 457.2405, 570.3246, 683.4087, 812.4512, 899.4833, 1012.5673, 1143.6078, 1303.6385, 1489.7178, 1588.7862, 1716.8812, 1813.9339, 1900.9660, 2087.0453, 2201.0882, 2330.1308, 2401.1679, 2548.2363, 2661.3204, 2758.3731, 2889.4136, 3036.4820, 3149.5661, 3278.6087, 3392.6516, 3505.7357, 3642.7946, 3757.8215, 3828.8587, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 246.1561, 361.1830, 498.2419, 611.3260, 725.3689, 854.4115, 967.4956, 1114.5640, 1245.6045, 1342.6572, 1455.7413, 1602.8097, 1673.8468, 1802.8894, 1916.9323, 2103.0117, 2190.0437, 2287.0964, 2415.1914, 2514.2598, 2700.3391, 2860.3698, 2991.4103, 3104.4943, 3191.5264, 3320.5690, 3433.6530, 3546.7371, 3674.7957, 3802.8542, 3915.9383, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LQEINQHETQQEPETLPWLCPFSLPFMELVTLR", {114.0913, 242.1499, 371.1925, 484.2766, 598.3195, 726.3781, 863.4370, 992.4796, 1093.5273, 1221.5858, 1349.6444, 1478.6870, 1575.7398, 1704.7824, 1805.8300, 1918.9141, 2015.9669, 2202.0462, 2315.1303, 2475.1609, 2572.2137, 2719.2821, 2806.3141, 2919.3982, 3016.4509, 3163.5193, 3294.5598, 3423.6024, 3536.6865, 3635.7549, 3736.8026, 3849.8866, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 389.2507, 488.3191, 601.4032, 730.4458, 861.4863, 1008.5547, 1105.6074, 1218.6915, 1305.7235, 1452.7919, 1549.8447, 1709.8753, 1822.9594, 2009.0387, 2106.0915, 2219.1756, 2320.2232, 2449.2658, 2546.3186, 2675.3612, 2803.4198, 2931.4783, 3032.5260, 3161.5686, 3298.6275, 3426.6861, 3540.7290, 3653.8131, 3782.8557, 3910.9143, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FIEFMEEALHLLPYTSLFEPMFSFIIDLNRPDR", {148.0757, 261.1598, 390.2023, 537.2708, 668.3112, 797.3538, 926.3964, 997.4335, 1110.5176, 1247.5765, 1360.6606, 1473.7447, 1570.7974, 1733.8607, 1834.9084, 1921.9404, 2035.0245, 2182.0929, 2311.1355, 2408.1883, 2539.2288, 2686.2972, 2773.3292, 2920.3976, 3033.4817, 3146.5658, 3261.5927, 3374.6768, 3488.7197, 3644.8208, 3741.8736, 3856.9005, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 290.1459, 387.1987, 543.2998, 657.3427, 770.4268, 885.4537, 998.5378, 1111.6218, 1258.6902, 1345.7223, 1492.7907, 1623.8312, 1720.8839, 1849.9265, 1996.9949, 2110.0790, 2197.1110, 2298.1587, 2461.2220, 2558.2748, 2671.3589, 2784.4429, 2921.5018, 3034.5859, 3105.6230, 3234.6656, 3363.7082, 3494.7487, 3641.8171, 3770.8597, 3883.9438, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QQESNAILSLHQHQPLMKPDYDESHFPIWCVLR", {129.0659, 257.1244, 386.1670, 473.1991, 587.2420, 658.2791, 771.3632, 884.4472, 971.4793, 1084.5633, 1221.6222, 1349.6808, 1486.7397, 1614.7983, 1711.8511, 1824.9351, 1955.9756, 2084.0706, 2181.1233, 2296.1503, 2459.2136, 2574.2405, 2703.2831, 2790.3152, 2927.3741, 3074.4425, 3171.4953, 3284.5793, 3470.6586, 3630.6893, 3729.7577, 3842.8418, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 387.2714, 547.3021, 733.3814, 846.4655, 943.5182, 1090.5866, 1227.6455, 1314.6776, 1443.7202, 1558.7471, 1721.8104, 1836.8374, 1933.8901, 2061.9851, 2193.0256, 2306.1097, 2403.1624, 2531.2210, 2668.2799, 2796.3385, 2933.3974, 3046.4815, 3133.5135, 3246.5976, 3359.6816, 3430.7187, 3544.7617, 3631.7937, 3760.8363, 3888.8949, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EVNVWQFVTENVENPDMEHALHGHPYFHHQEEK", {130.0499, 229.1183, 343.1612, 442.2296, 628.3089, 756.3675, 903.4359, 1002.5043, 1103.5520, 1232.5946, 1346.6375, 1445.7060, 1574.7485, 1688.7915, 1785.8442, 1900.8712, 2031.9117, 2160.9543, 2298.0132, 2369.0503, 2482.1344, 2619.1933, 2676.2147, 2813.2736, 2910.3264, 3073.3897, 3220.4581, 3357.5171, 3494.5760, 3622.6345, 3751.6771, 3880.7197, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 276.1554, 405.1980, 533.2566, 670.3155, 807.3744, 954.4428, 1117.5061, 1214.5589, 1351.6178, 1408.6393, 1545.6982, 1658.7822, 1729.8194, 1866.8783, 1995.9209, 2126.9614, 2241.9883, 2339.0411, 2453.0840, 2582.1266, 2681.1950, 2795.2379, 2924.2805, 3025.3282, 3124.3966, 3271.4650, 3399.5236, 3585.6029, 3684.6713, 3798.7143, 3897.7827, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FYNYGQGFNFDCVNIILFVFIETIFTLGIFHQK", {148.0757, 311.1390, 425.1819, 588.2453, 645.2667, 773.3253, 830.3468, 977.4152, 1091.4581, 1238.5265, 1353.5535, 1513.5841, 1612.6525, 1726.6955, 1839.7795, 1952.8636, 2065.9477, 2213.0161, 2312.0845, 2459.1529, 2572.2370, 2701.2796, 2802.3272, 2915.4113, 3062.4797, 3163.5274, 3276.6115, 3333.6329, 3446.7170, 3593.7854, 3730.8443, 3858.9029, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 275.1714, 412.2303, 559.2987, 672.3828, 729.4042, 842.4883, 943.5360, 1090.6044, 1203.6885, 1304.7361, 1433.7787, 1546.8628, 1693.9312, 1792.9996, 1940.0680, 2053.1521, 2166.2362, 2279.3202, 2393.3632, 2492.4316, 2652.4622, 2767.4892, 2914.5576, 3028.6005, 3175.6689, 3232.6904, 3360.7490, 3417.7704, 3580.8337, 3694.8767, 3857.9400, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ACGVCEVWGYSTLIEADWCDCAYHAMENSMHQR", {72.0444, 232.0750, 289.0965, 388.1649, 548.1956, 677.2382, 776.3066, 962.3859, 1019.4073, 1182.4707, 1269.5027, 1370.5504, 1483.6344, 1596.7185, 1725.7611, 1796.7982, 1911.8252, 2097.9045, 2257.9351, 2372.9621, 2532.9927, 2604.0298, 2767.0932, 2904.1521, 2975.1892, 3106.2297, 3235.2723, 3349.3152, 3436.3472, 3567.3877, 3704.4466, 3832.5052, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 440.2364, 571.2769, 658.3090, 772.3519, 901.3945, 1032.4350, 1103.4721, 1240.5310, 1403.5943, 1474.6314, 1634.6621, 1749.6890, 1909.7197, 2095.7990, 2210.8259, 2281.8630, 2410.9056, 2523.9897, 2637.0738, 2738.1214, 2825.1535, 2988.2168, 3045.2383, 3231.3176, 3330.3860, 3459.4286, 3619.4592, 3718.5276, 3775.5491, 3935.5798, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EENDETDGQHQEQEQEEQVQDQEHHDDELESSR", {130.0499, 259.0925, 373.1354, 488.1623, 617.2049, 718.2526, 833.2795, 890.3010, 1018.3596, 1155.4185, 1283.4771, 1412.5197, 1540.5782, 1669.6208, 1797.6794, 1926.7220, 2055.7646, 2183.8232, 2282.8916, 2410.9502, 2525.9771, 2654.0357, 2783.0783, 2920.1372, 3057.1961, 3172.2231, 3287.2500, 3416.2926, 3529.3767, 3658.4192, 3745.4513, 3832.4833, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 262.1510, 349.1830, 478.2256, 591.3097, 720.3523, 835.3792, 950.4061, 1087.4651, 1224.5240, 1353.5666, 1481.6251, 1596.6521, 1724.7107, 1823.7791, 1951.8377, 2080.8802, 2209.9228, 2337.9814, 2467.0240, 2595.0826, 2724.1252, 2852.1838, 2989.2427, 3117.3012, 3174.3227, 3289.3497, 3390.3973, 3519.4399, 3634.4669, 3748.5098, 3877.5524, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VESGFMFLEFQFWLSHGVTLNRPYIPSIFHYTR", {100.0757, 229.1183, 316.1503, 373.1718, 520.2402, 651.2807, 798.3491, 911.4332, 1040.4757, 1187.5442, 1315.6027, 1462.6712, 1648.7505, 1761.8345, 1848.8666, 1985.9255, 2042.9469, 2142.0153, 2243.0630, 2356.1471, 2470.1900, 2626.2911, 2723.3439, 2886.4072, 2999.4913, 3096.5440, 3183.5761, 3296.6601, 3443.7286, 3580.7875, 3743.8508, 3844.8985, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 276.1666, 439.2300, 576.2889, 723.3573, 836.4413, 923.4734, 1020.5261, 1133.6102, 1296.6735, 1393.7263, 1549.8274, 1663.8703, 1776.9544, 1878.0021, 1977.0705, 2034.0920, 2171.1509, 2258.1829, 2371.2670, 2557.3463, 2704.4147, 2832.4733, 2979.5417, 3108.5843, 3221.6683, 3368.7368, 3499.7772, 3646.8456, 3703.8671, 3790.8991, 3919.9417, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DTEFVEYTYTDLNDCLPQLPIELMNEYSNLMHK", {116.0342, 217.0819, 346.1245, 493.1929, 592.2613, 721.3039, 884.3672, 985.4149, 1148.4782, 1249.5259, 1364.5529, 1477.6369, 1591.6799, 1706.7068, 1866.7375, 1979.8215, 2076.8743, 2204.9329, 2318.0169, 2415.0697, 2528.1537, 2657.1963, 2770.2804, 2901.3209, 3015.3638, 3144.4064, 3307.4697, 3394.5018, 3508.5447, 3621.6288, 3752.6692, 3889.7282, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 284.1717, 415.2122, 528.2963, 642.3392, 729.3712, 892.4345, 1021.4771, 1135.5201, 1266.5606, 1379.6446, 1508.6872, 1621.7713, 1718.8240, 1831.9081, 1959.9667, 2057.0194, 2170.1035, 2330.1342, 2445.1611, 2559.2040, 2672.2881, 2787.3150, 2888.3627, 3051.4260, 3152.4737, 3315.5370, 3444.5796, 3543.6481, 3690.7165, 3819.7591, 3920.8067, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"HSAFEHEVEHEHEVIPHSHHHIPAHHHDEEIHK", {138.0662, 225.0982, 296.1353, 443.2037, 572.2463, 709.3052, 838.3478, 937.4163, 1066.4588, 1203.5178, 1332.5604, 1469.6193, 1598.6619, 1697.7303, 1810.8143, 1907.8671, 2044.9260, 2131.9580, 2269.0170, 2406.0759, 2543.1348, 2656.2188, 2753.2716, 2824.3087, 2961.3676, 3098.4265, 3235.4855, 3350.5124, 3479.5550, 3608.5976, 3721.6816, 3858.7406, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 284.1717, 397.2558, 526.2984, 655.3410, 770.3679, 907.4268, 1044.4857, 1181.5446, 1252.5818, 1349.6345, 1462.7186, 1599.7775, 1736.8364, 1873.8953, 1960.9274, 2097.9863, 2195.0390, 2308.1231, 2407.1915, 2536.2341, 2673.2930, 2802.3356, 2939.3945, 3068.4371, 3167.5055, 3296.5481, 3433.6070, 3562.6496, 3709.7180, 3780.7551, 3867.7872, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LCIHNACEMCFMNHGCPVLATTVTNENCVFCER", {114.0913, 274.1220, 387.2061, 524.2650, 638.3079, 709.3450, 869.3757, 998.4182, 1129.4587, 1289.4894, 1436.5578, 1567.5983, 1681.6412, 1818.7001, 1875.7216, 2035.7522, 2132.8050, 2231.8734, 2344.9575, 2415.9946, 2517.0423, 2618.0899, 2717.1584, 2818.2060, 2932.2490, 3061.2916, 3175.3345, 3335.3651, 3434.4335, 3581.5020, 3741.5326, 3870.5752, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 464.1922, 611.2606, 710.3290, 870.3597, 984.4026, 1113.4452, 1227.4881, 1328.5358, 1427.6042, 1528.6519, 1629.6996, 1700.7367, 1813.8207, 1912.8892, 2009.9419, 2169.9726, 2226.9940, 2364.0529, 2478.0959, 2609.1364, 2756.2048, 2916.2354, 3047.2759, 3176.3185, 3336.3491, 3407.3863, 3521.4292, 3658.4881, 3771.5722, 3931.6028, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LEYTTTCILNSNNEFAAFFFIFCQAVIEDDTWK", {114.0913, 243.1339, 406.1973, 507.2449, 608.2926, 709.3403, 869.3709, 982.4550, 1095.5391, 1209.5820, 1296.6140, 1410.6570, 1524.6999, 1653.7425, 1800.8109, 1871.8480, 1942.8851, 2089.9535, 2237.0219, 2384.0904, 2497.1744, 2644.2428, 2804.2735, 2932.3321, 3003.3692, 3102.4376, 3215.5217, 3344.5643, 3459.5912, 3574.6181, 3675.6658, 3861.7451, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 333.1921, 434.2398, 549.2667, 664.2937, 793.3363, 906.4203, 1005.4888, 1076.5259, 1204.5844, 1364.6151, 1511.6835, 1624.7676, 1771.8360, 1918.9044, 2065.9728, 2137.0099, 2208.0470, 2355.1155, 2484.1580, 2598.2010, 2712.2439, 2799.2759, 2913.3189, 3026.4029, 3139.4870, 3299.5176, 3400.5653, 3501.6130, 3602.6607, 3765.7240, 3894.7666, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EMVETSDINKPTDSLWYCMGNNYDNENNISYFR", {130.0499, 261.0904, 360.1588, 489.2014, 590.2490, 677.2811, 792.3080, 905.3921, 1019.4350, 1147.5300, 1244.5827, 1345.6304, 1460.6574, 1547.6894, 1660.7734, 1846.8528, 2009.9161, 2169.9467, 2300.9872, 2358.0087, 2472.0516, 2586.0945, 2749.1579, 2864.1848, 2978.2277, 3107.2703, 3221.3133, 3335.3562, 3448.4402, 3535.4723, 3698.5356, 3845.6040, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 485.2507, 572.2827, 685.3668, 799.4097, 913.4526, 1042.4952, 1156.5382, 1271.5651, 1434.6284, 1548.6714, 1662.7143, 1719.7358, 1850.7762, 2010.8069, 2173.8702, 2359.9495, 2473.0336, 2560.0656, 2675.0926, 2776.1402, 2873.1930, 3001.2880, 3115.3309, 3228.4150, 3343.4419, 3430.4739, 3531.5216, 3660.5642, 3759.6326, 3890.6731, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"INKPTDSLWYCMGNNYDNENNISYFRPACVLFK", {114.0913, 228.1343, 356.2292, 453.2820, 554.3297, 669.3566, 756.3886, 869.4727, 1055.5520, 1218.6154, 1378.6460, 1509.6865, 1566.7079, 1680.7509, 1794.7938, 1957.8571, 2072.8841, 2186.9270, 2315.9696, 2430.0125, 2544.0554, 2657.1395, 2744.1715, 2907.2349, 3054.3033, 3210.4044, 3307.4572, 3378.4943, 3538.5249, 3637.5933, 3750.6774, 3897.7458, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 294.1812, 407.2653, 506.3337, 666.3643, 737.4015, 834.4542, 990.5553, 1137.6237, 1300.6871, 1387.7191, 1500.8032, 1614.8461, 1728.8890, 1857.9316, 1971.9745, 2087.0015, 2250.0648, 2364.1077, 2478.1507, 2535.1721, 2666.2126, 2826.2433, 2989.3066, 3175.3859, 3288.4700, 3375.5020, 3490.5289, 3591.5766, 3688.6294, 3816.7243, 3930.7673, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LVFMTINFVIILLMPGYFYIMVTMDGTYIWCNK", {114.0913, 213.1598, 360.2282, 491.2687, 592.3163, 705.4004, 819.4433, 966.5117, 1065.5802, 1178.6642, 1291.7483, 1404.8323, 1517.9164, 1648.9569, 1746.0097, 1803.0311, 1966.0944, 2113.1629, 2276.2262, 2389.3103, 2520.3507, 2619.4192, 2720.4668, 2851.5073, 2966.5343, 3023.5557, 3124.6034, 3287.6667, 3400.7508, 3586.8301, 3746.8608, 3860.9037, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 261.1557, 421.1864, 607.2657, 720.3498, 883.4131, 984.4608, 1041.4822, 1156.5092, 1287.5497, 1388.5973, 1487.6657, 1618.7062, 1731.7903, 1894.8536, 2041.9220, 2204.9854, 2262.0068, 2359.0596, 2490.1001, 2603.1841, 2716.2682, 2829.3523, 2942.4363, 3041.5048, 3188.5732, 3302.6161, 3415.7002, 3516.7478, 3647.7883, 3794.8567, 3893.9251, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LHQDIMQFIIVPASTHYYEEDQDPVTETFWEQK", {114.0913, 251.1503, 379.2088, 494.2358, 607.3198, 738.3603, 866.4189, 1013.4873, 1126.5714, 1239.6554, 1338.7239, 1435.7766, 1506.8137, 1593.8458, 1694.8934, 1831.9524, 1995.0157, 2158.0790, 2287.1216, 2416.1642, 2531.1911, 2659.2497, 2774.2767, 2871.3294, 2970.3978, 3071.4455, 3200.4881, 3301.5358, 3448.6042, 3634.6835, 3763.7261, 3891.7847, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 275.1714, 404.2140, 590.2933, 737.3617, 838.4094, 967.4520, 1068.4997, 1167.5681, 1264.6208, 1379.6478, 1507.7064, 1622.7333, 1751.7759, 1880.8185, 2043.8818, 2206.9451, 2344.0040, 2445.0517, 2532.0838, 2603.1209, 2700.1736, 2799.2420, 2912.3261, 3025.4102, 3172.4786, 3300.5372, 3431.5777, 3544.6617, 3659.6887, 3787.7472, 3924.8061, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EEEDEEADFEEHEDEDDEEDSAEPYEHDFHLPK", {130.0499, 259.0925, 388.1351, 503.1620, 632.2046, 761.2472, 832.2843, 947.3112, 1094.3797, 1223.4222, 1352.4648, 1489.5238, 1618.5663, 1733.5933, 1862.6359, 1977.6628, 2092.6898, 2221.7324, 2350.7750, 2465.8019, 2552.8339, 2623.8710, 2752.9136, 2849.9664, 3013.0297, 3142.0723, 3279.1312, 3394.1582, 3541.2266, 3678.2855, 3791.3696, 3888.4223, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 244.1656, 357.2496, 494.3085, 641.3770, 756.4039, 893.4628, 1022.5054, 1185.5687, 1282.6215, 1411.6641, 1482.7012, 1569.7332, 1684.7602, 1813.8028, 1942.8454, 2057.8723, 2172.8992, 2301.9418, 2416.9688, 2546.0114, 2683.0703, 2812.1129, 2941.1555, 3088.2239, 3203.2508, 3274.2879, 3403.3305, 3532.3731, 3647.4001, 3776.4427, 3905.4853, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LLESCVDNYVNALNLHIHMMLLHELTCHIQFLK", {114.0913, 227.1754, 356.2180, 443.2500, 603.2807, 702.3491, 817.3760, 931.4190, 1094.4823, 1193.5507, 1307.5936, 1378.6307, 1491.7148, 1605.7577, 1718.8418, 1855.9007, 1968.9848, 2106.0437, 2237.0842, 2368.1247, 2481.2087, 2594.2928, 2731.3517, 2860.3943, 2973.4784, 3074.5260, 3234.5567, 3371.6156, 3484.6997, 3612.7582, 3759.8266, 3872.9107, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 407.2653, 535.3239, 648.4079, 785.4668, 945.4975, 1046.5452, 1159.6292, 1288.6718, 1425.7307, 1538.8148, 1651.8989, 1782.9393, 1913.9798, 2051.0387, 2164.1228, 2301.1817, 2414.2658, 2528.3087, 2641.3928, 2712.4299, 2826.4728, 2925.5412, 3088.6046, 3202.6475, 3317.6744, 3416.7428, 3576.7735, 3663.8055, 3792.8481, 3905.9322, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PQEDPTLNAETLNFTYTHHDLVQWNEPHLEYLR", {98.0600, 226.1186, 355.1612, 470.1882, 567.2409, 668.2886, 781.3727, 895.4156, 966.4527, 1095.4953, 1196.5430, 1309.6270, 1423.6700, 1570.7384, 1671.7861, 1834.8494, 1935.8971, 2072.9560, 2210.0149, 2325.0418, 2438.1259, 2537.1943, 2665.2529, 2851.3322, 2965.3751, 3094.4177, 3191.4705, 3328.5294, 3441.6135, 3570.6561, 3733.7194, 3846.8034, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 451.2663, 580.3089, 693.3930, 830.4519, 927.5047, 1056.5473, 1170.5902, 1356.6695, 1484.7281, 1583.7965, 1696.8806, 1811.9075, 1948.9664, 2086.0253, 2187.0730, 2350.1363, 2451.1840, 2598.2524, 2712.2954, 2825.3794, 2926.4271, 3055.4697, 3126.5068, 3240.5497, 3353.6338, 3454.6815, 3551.7342, 3666.7612, 3795.8038, 3923.8624, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TLTWNYDQNTGTNCFNFEMFLSCFSQSDSESNR", {102.0550, 215.1390, 316.1867, 502.2660, 616.3089, 779.3723, 894.3992, 1022.4578, 1136.5007, 1237.5484, 1294.5699, 1395.6175, 1509.6605, 1669.6911, 1816.7595, 1930.8025, 2077.8709, 2206.9135, 2337.9539, 2485.0224, 2598.1064, 2685.1385, 2845.1691, 2992.2375, 3079.2695, 3207.3281, 3294.3601, 3409.3871, 3496.4191, 3625.4617, 3712.4937, 3826.5367, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 289.1619, 376.1939, 505.2365, 592.2685, 707.2955, 794.3275, 922.3861, 1009.4181, 1156.4865, 1316.5172, 1403.5492, 1516.6333, 1663.7017, 1794.7422, 1923.7848, 2070.8532, 2184.8961, 2331.9645, 2491.9952, 2606.0381, 2707.0858, 2764.1072, 2865.1549, 2979.1978, 3107.2564, 3222.2834, 3385.3467, 3499.3896, 3685.4689, 3786.5166, 3899.6007, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ELDNHAYAIIWWIFGFFAWSFVFSAAFVLLTWR", {130.0499, 243.1339, 358.1609, 472.2038, 609.2627, 680.2998, 843.3632, 914.4003, 1027.4843, 1140.5684, 1326.6477, 1512.7270, 1625.8111, 1772.8795, 1829.9010, 1976.9694, 2124.0378, 2195.0749, 2381.1542, 2468.1863, 2615.2547, 2714.3231, 2861.3915, 2948.4235, 3019.4606, 3090.4977, 3237.5662, 3336.6346, 3449.7186, 3562.8027, 3663.8504, 3849.9297, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 361.1983, 462.2459, 575.3300, 688.4141, 787.4825, 934.5509, 1005.5880, 1076.6251, 1163.6572, 1310.7256, 1409.7940, 1556.8624, 1643.8944, 1829.9737, 1901.0109, 2048.0793, 2195.1477, 2252.1691, 2399.2376, 2512.3216, 2698.4009, 2884.4802, 2997.5643, 3110.6484, 3181.6855, 3344.7488, 3415.7859, 3552.8448, 3666.8878, 3781.9147, 3894.9988, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FINVIVNIFNLLECFFYAFSYGNHTNLSNVFYK", {148.0757, 261.1598, 375.2027, 474.2711, 587.3552, 686.4236, 800.4665, 913.5506, 1060.6190, 1174.6619, 1287.7460, 1400.8300, 1529.8726, 1689.9033, 1836.9717, 1984.0401, 2147.1034, 2218.1405, 2365.2090, 2452.2410, 2615.3043, 2672.3258, 2786.3687, 2923.4276, 3024.4753, 3138.5182, 3251.6023, 3338.6343, 3452.6772, 3551.7457, 3698.8141, 3861.8774, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 310.1761, 457.2445, 556.3130, 670.3559, 757.3879, 870.4720, 984.5149, 1085.5626, 1222.6215, 1336.6644, 1393.6859, 1556.7492, 1643.7812, 1790.8497, 1861.8868, 2024.9501, 2172.0185, 2319.0869, 2479.1176, 2608.1602, 2721.2442, 2834.3283, 2948.3712, 3095.4396, 3208.5237, 3322.5666, 3421.6350, 3534.7191, 3633.7875, 3747.8305, 3860.9145, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YNDVFWFIPTLCVDSAYSSNMHANFTLSHWCHK", {164.0706, 278.1135, 393.1405, 492.2089, 639.2773, 825.3566, 972.4250, 1085.5091, 1182.5619, 1283.6095, 1396.6936, 1556.7242, 1655.7927, 1770.8196, 1857.8516, 1928.8887, 2091.9521, 2178.9841, 2266.0161, 2380.0591, 2511.0995, 2648.1585, 2719.1956, 2833.2385, 2980.3069, 3081.3546, 3194.4387, 3281.4707, 3418.5296, 3604.6089, 3764.6396, 3901.6985, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 284.1717, 444.2024, 630.2817, 767.3406, 854.3726, 967.4567, 1068.5044, 1215.5728, 1329.6157, 1400.6528, 1537.7117, 1668.7522, 1782.7951, 1869.8272, 1956.8592, 2119.9225, 2190.9596, 2277.9917, 2393.0186, 2492.0870, 2652.1177, 2765.2017, 2866.2494, 2963.3022, 3076.3862, 3223.4547, 3409.5340, 3556.6024, 3655.6708, 3770.6977, 3884.7407, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PDCDHYVAYSVLGMYSCCSLLFILLVTFVLMCR", {98.0600, 213.0870, 373.1176, 488.1446, 625.2035, 788.2668, 887.3352, 958.3723, 1121.4357, 1208.4677, 1307.5361, 1420.6202, 1477.6416, 1608.6821, 1771.7455, 1858.7775, 2018.8081, 2178.8388, 2265.8708, 2378.9549, 2492.0389, 2639.1074, 2752.1914, 2865.2755, 2978.3595, 3077.4280, 3178.4756, 3325.5440, 3424.6125, 3537.6965, 3668.7370, 3828.7677, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 335.1496, 466.1901, 579.2741, 678.3426, 825.4110, 926.4587, 1025.5271, 1138.6111, 1251.6952, 1364.7793, 1511.8477, 1624.9317, 1738.0158, 1825.0478, 1985.0785, 2145.1091, 2232.1412, 2395.2045, 2526.2450, 2583.2664, 2696.3505, 2795.4189, 2882.4509, 3045.5143, 3116.5514, 3215.6198, 3378.6831, 3515.7420, 3630.7690, 3790.7996, 3905.8266, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MFDPQCINFFIAMLFENHPLFEQSGFLVSYTNR", {132.0478, 279.1162, 394.1431, 491.1959, 619.2545, 779.2851, 892.3692, 1006.4121, 1153.4805, 1300.5489, 1413.6330, 1484.6701, 1615.7106, 1728.7947, 1875.8631, 2004.9057, 2118.9486, 2256.0075, 2353.0603, 2466.1443, 2613.2127, 2742.2553, 2870.3139, 2957.3459, 3014.3674, 3161.4358, 3274.5199, 3373.5883, 3460.6203, 3623.6837, 3724.7313, 3838.7743, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 289.1619, 390.2096, 553.2729, 640.3049, 739.3733, 852.4574, 999.5258, 1056.5473, 1143.5793, 1271.6379, 1400.6805, 1547.7489, 1660.8329, 1757.8857, 1894.9446, 2008.9876, 2138.0301, 2285.0986, 2398.1826, 2529.2231, 2600.2602, 2713.3443, 2860.4127, 3007.4811, 3121.5240, 3234.6081, 3394.6388, 3522.6973, 3619.7501, 3734.7770, 3881.8455, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MFNGGNQLIFMCFTAFSTVLGLTLYFTFWFFFR", {132.0478, 279.1162, 393.1591, 450.1806, 507.2020, 621.2450, 749.3035, 862.3876, 975.4717, 1122.5401, 1253.5806, 1413.6112, 1560.6796, 1661.7273, 1732.7644, 1879.8328, 1966.8649, 2067.9125, 2166.9810, 2280.0650, 2337.0865, 2450.1705, 2551.2182, 2664.3023, 2827.3656, 2974.4340, 3075.4817, 3222.5501, 3408.6294, 3555.6978, 3702.7663, 3849.8347, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 469.2558, 616.3242, 802.4035, 949.4719, 1050.5196, 1197.5880, 1360.6513, 1473.7354, 1574.7831, 1687.8671, 1744.8886, 1857.9727, 1957.0411, 2058.0888, 2145.1208, 2292.1892, 2363.2263, 2464.2740, 2611.3424, 2771.3731, 2902.4136, 3049.4820, 3162.5660, 3275.6501, 3403.7087, 3517.7516, 3574.7731, 3631.7945, 3745.8375, 3892.9059, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FMSHFDMGAAIGPIEIDYYYCIYSMLIFDMYSR", {148.0757, 279.1162, 366.1482, 503.2071, 650.2755, 765.3025, 896.3430, 953.3644, 1024.4015, 1095.4386, 1208.5227, 1265.5442, 1362.5969, 1475.6810, 1604.7236, 1717.8077, 1832.8346, 1995.8979, 2158.9613, 2322.0246, 2482.0552, 2595.1393, 2758.2026, 2845.2347, 2976.2751, 3089.3592, 3202.4433, 3349.5117, 3464.5386, 3595.5791, 3758.6424, 3845.6745, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 262.1510, 425.2143, 556.2548, 671.2817, 818.3502, 931.4342, 1044.5183, 1175.5588, 1262.5908, 1425.6541, 1538.7382, 1698.7688, 1861.8322, 2024.8955, 2187.9588, 2302.9858, 2416.0698, 2545.1124, 2658.1965, 2755.2492, 2812.2707, 2925.3548, 2996.3919, 3067.4290, 3124.4505, 3255.4910, 3370.5179, 3517.5863, 3654.6452, 3741.6772, 3872.7177, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FHHLQVLGYLGAQELLTQFYSYCSPVCVIHYMK", {148.0757, 285.1346, 422.1935, 535.2776, 663.3362, 762.4046, 875.4886, 932.5101, 1095.5734, 1208.6575, 1265.6790, 1336.7161, 1464.7746, 1593.8172, 1706.9013, 1819.9854, 1921.0330, 2049.0916, 2196.1600, 2359.2234, 2446.2554, 2609.3187, 2769.3494, 2856.3814, 2953.4342, 3052.5026, 3212.5332, 3311.6016, 3424.6857, 3561.7446, 3724.8079, 3855.8484, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 278.1533, 441.2166, 578.2755, 691.3596, 790.4280, 950.4587, 1049.5271, 1146.5798, 1233.6119, 1393.6425, 1556.7058, 1643.7379, 1806.8012, 1953.8696, 2081.9282, 2182.9759, 2296.0599, 2409.1440, 2538.1866, 2666.2452, 2737.2823, 2794.3037, 2907.3878, 3070.4511, 3127.4726, 3240.5567, 3339.6251, 3467.6837, 3580.7677, 3717.8266, 3854.8855, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DSILVLQGPELNYQQMCELFPMCFNINFEDLLK", {116.0342, 203.0662, 316.1503, 429.2344, 528.3028, 641.3869, 769.4454, 826.4669, 923.5197, 1052.5623, 1165.6463, 1279.6892, 1442.7526, 1570.8111, 1698.8697, 1829.9102, 1989.9409, 2118.9835, 2232.0675, 2379.1359, 2476.1887, 2607.2292, 2767.2598, 2914.3282, 3028.3712, 3141.4552, 3255.4982, 3402.5666, 3531.6092, 3646.6361, 3759.7202, 3872.8042, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 373.2809, 488.3079, 617.3505, 764.4189, 878.4618, 991.5459, 1105.5888, 1252.6572, 1412.6879, 1543.7283, 1640.7811, 1787.8495, 1900.9336, 2029.9762, 2190.0068, 2321.0473, 2449.1059, 2577.1645, 2740.2278, 2854.2707, 2967.3548, 3096.3974, 3193.4501, 3250.4716, 3378.5302, 3491.6143, 3590.6827, 3703.7667, 3816.8508, 3903.8828, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SWCDGHNLVNFEDEDVQNVQVAEEFVELPDWMR", {88.0393, 274.1186, 434.1493, 549.1762, 606.1977, 743.2566, 857.2995, 970.3836, 1069.4520, 1183.4949, 1330.5633, 1459.6059, 1574.6329, 1703.6755, 1818.7024, 1917.7708, 2045.8294, 2159.8723, 2258.9407, 2386.9993, 2486.0677, 2557.1048, 2686.1474, 2815.1900, 2962.2584, 3061.3269, 3190.3694, 3303.4535, 3400.5063, 3515.5332, 3701.6125, 3832.6530, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 306.1594, 492.2387, 607.2657, 704.3185, 817.4025, 946.4451, 1045.5135, 1192.5819, 1321.6245, 1450.6671, 1521.7042, 1620.7727, 1748.8312, 1847.8996, 1961.9426, 2090.0012, 2189.0696, 2304.0965, 2433.1391, 2548.1660, 2677.2086, 2824.2771, 2938.3200, 3037.3884, 3150.4725, 3264.5154, 3401.5743, 3458.5958, 3573.6227, 3733.6534, 3919.7327, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EPEMLMYVSYSLDITIPCLNCIQFDVFMVEENK", {130.0499, 227.1026, 356.1452, 487.1857, 600.2698, 731.3103, 894.3736, 993.4420, 1080.4740, 1243.5374, 1330.5694, 1443.6535, 1558.6804, 1671.7645, 1772.8121, 1885.8962, 1982.9490, 2142.9796, 2256.0637, 2370.1066, 2530.1373, 2643.2213, 2771.2799, 2918.3483, 3033.3753, 3132.4437, 3279.5121, 3410.5526, 3509.6210, 3638.6636, 3767.7062, 3881.7491, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 261.1557, 390.1983, 519.2409, 618.3093, 749.3498, 896.4182, 995.4866, 1110.5136, 1257.5820, 1385.6406, 1498.7246, 1658.7553, 1772.7982, 1885.8823, 2045.9129, 2142.9657, 2256.0498, 2357.0974, 2470.1815, 2585.2084, 2698.2925, 2785.3245, 2948.3879, 3035.4199, 3134.4883, 3297.5516, 3428.5921, 3541.6762, 3672.7167, 3801.7593, 3898.8120, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QLGHGNIIYHLPEWYNFTEDCDAIYAWIASCLR", {129.0659, 242.1499, 299.1714, 436.2303, 493.2518, 607.2947, 720.3787, 833.4628, 996.5261, 1133.5851, 1246.6691, 1343.7219, 1472.7645, 1658.8438, 1821.9071, 1935.9500, 2083.0185, 2184.0661, 2313.1087, 2428.1357, 2588.1663, 2703.1933, 2774.2304, 2887.3144, 3050.3778, 3121.4149, 3307.4942, 3420.5783, 3491.6154, 3578.6474, 3738.6781, 3851.7621, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 448.2337, 535.2657, 606.3028, 719.3869, 905.4662, 976.5033, 1139.5666, 1252.6507, 1323.6878, 1438.7147, 1598.7454, 1713.7723, 1842.8149, 1943.8626, 2090.9310, 2204.9740, 2368.0373, 2554.1166, 2683.1592, 2780.2120, 2893.2960, 3030.3549, 3193.4183, 3306.5023, 3419.5864, 3533.6293, 3590.6508, 3727.7097, 3784.7311, 3897.8152, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FLYVFPLFIFLSLNSFLFVHNWLGQILSSNLWK", {148.0757, 261.1598, 424.2231, 523.2915, 670.3599, 767.4127, 880.4967, 1027.5652, 1140.6492, 1287.7176, 1400.8017, 1487.8337, 1600.9178, 1714.9607, 1801.9927, 1949.0612, 2062.1452, 2209.2136, 2308.2820, 2445.3410, 2559.3839, 2745.4632, 2858.5473, 2915.5687, 3043.6273, 3156.7114, 3269.7954, 3356.8275, 3443.8595, 3557.9024, 3670.9865, 3857.0658, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 333.1921, 446.2762, 560.3191, 647.3511, 734.3832, 847.4672, 960.5513, 1088.6099, 1145.6313, 1258.7154, 1444.7947, 1558.8376, 1695.8966, 1794.9650, 1942.0334, 2055.1174, 2202.1859, 2289.2179, 2403.2608, 2516.3449, 2603.3769, 2716.4610, 2863.5294, 2976.6134, 3123.6819, 3236.7659, 3333.8187, 3480.8871, 3579.9555, 3743.0188, 3856.1029, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"IFQLQELINEILMQTSIEYFSTPYTFYFDILVK", {114.0913, 261.1598, 389.2183, 502.3024, 630.3610, 759.4036, 872.4876, 985.5717, 1099.6146, 1228.6572, 1341.7413, 1454.8253, 1585.8658, 1713.9244, 1814.9721, 1902.0041, 2015.0882, 2144.1308, 2307.1941, 2454.2625, 2541.2945, 2642.3422, 2739.3950, 2902.4583, 3003.5060, 3150.5744, 3313.6377, 3460.7061, 3575.7331, 3688.8172, 3801.9012, 3900.9696, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 246.1812, 359.2653, 472.3493, 587.3763, 734.4447, 897.5080, 1044.5764, 1145.6241, 1308.6875, 1405.7402, 1506.7879, 1593.8199, 1740.8883, 1903.9517, 2032.9943, 2146.0783, 2233.1104, 2334.1580, 2462.2166, 2593.2571, 2706.3412, 2819.4252, 2948.4678, 3062.5107, 3175.5948, 3288.6789, 3417.7215, 3545.7800, 3658.8641, 3786.9227, 3933.9911, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SSMPQYGSWNNTVPHHHHLPQHHQMQQQQLHHK", {88.0393, 175.0713, 306.1118, 403.1646, 531.2232, 694.2865, 751.3080, 838.3400, 1024.4193, 1138.4622, 1252.5051, 1353.5528, 1452.6212, 1549.6740, 1686.7329, 1823.7918, 1960.8507, 2097.9097, 2210.9937, 2308.0465, 2436.1051, 2573.1640, 2710.2229, 2838.2815, 2969.3219, 3097.3805, 3225.4391, 3353.4977, 3481.5563, 3594.6403, 3731.6992, 3868.7581, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 284.1717, 421.2306, 534.3147, 662.3733, 790.4318, 918.4904, 1046.5490, 1177.5895, 1305.6481, 1442.7070, 1579.7659, 1707.8245, 1804.8772, 1917.9613, 2055.0202, 2192.0791, 2329.1380, 2466.1969, 2563.2497, 2662.3181, 2763.3658, 2877.4087, 2991.4517, 3177.5310, 3264.5630, 3321.5845, 3484.6478, 3612.7064, 3709.7591, 3840.7996, 3927.8316, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QEQQQQLHHHHSHTAQHHQAQHNHNQQHTSQPR", {129.0659, 258.1084, 386.1670, 514.2256, 642.2842, 770.3428, 883.4268, 1020.4857, 1157.5446, 1294.6036, 1431.6625, 1518.6945, 1655.7534, 1756.8011, 1827.8382, 1955.8968, 2092.9557, 2230.0146, 2358.0732, 2429.1103, 2557.1689, 2694.2278, 2808.2707, 2945.3296, 3059.3726, 3187.4311, 3315.4897, 3452.5486, 3553.5963, 3640.6283, 3768.6869, 3865.7397, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 272.1717, 400.2303, 487.2623, 588.3100, 725.3689, 853.4275, 981.4861, 1095.5290, 1232.5879, 1346.6308, 1483.6897, 1611.7483, 1682.7854, 1810.8440, 1947.9029, 2084.9618, 2213.0204, 2284.0575, 2385.1052, 2522.1641, 2609.1961, 2746.2551, 2883.3140, 3020.3729, 3157.4318, 3270.5159, 3398.5744, 3526.6330, 3654.6916, 3782.7502, 3911.7928, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FGLWYNVWSVFLECTFLILSILLVSVYIIFVNR", {148.0757, 205.0972, 318.1812, 504.2605, 667.3239, 781.3668, 880.4352, 1066.5145, 1153.5465, 1252.6150, 1399.6834, 1512.7674, 1641.8100, 1801.8407, 1902.8884, 2049.9568, 2163.0408, 2276.1249, 2389.2090, 2476.2410, 2589.3251, 2702.4091, 2815.4932, 2914.5616, 3001.5936, 3100.6620, 3263.7254, 3376.8094, 3489.8935, 3636.9619, 3736.0303, 3850.0732, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 289.1619, 388.2303, 535.2987, 648.3828, 761.4668, 924.5302, 1023.5986, 1110.6306, 1209.6990, 1322.7831, 1435.8671, 1548.9512, 1635.9832, 1749.0673, 1862.1514, 1975.2354, 2122.3038, 2223.3515, 2383.3822, 2512.4248, 2625.5088, 2772.5772, 2871.6457, 2958.6777, 3144.7570, 3243.8254, 3357.8683, 3520.9317, 3707.0110, 3820.0950, 3877.1165, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DYYYQSHHHHQQHPNHQHPVITDLSQCHSGNAR", {116.0342, 279.0975, 442.1609, 605.2242, 733.2828, 820.3148, 957.3737, 1094.4326, 1231.4915, 1368.5505, 1496.6090, 1624.6676, 1761.7265, 1858.7793, 1972.8222, 2109.8811, 2237.9397, 2374.9986, 2472.0514, 2571.1198, 2684.2039, 2785.2515, 2900.2785, 3013.3625, 3100.3946, 3228.4532, 3388.4838, 3525.5427, 3612.5747, 3669.5962, 3783.6391, 3854.6762, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 246.1561, 360.1990, 417.2205, 504.2525, 641.3114, 801.3420, 929.4006, 1016.4327, 1129.5167, 1244.5437, 1345.5913, 1458.6754, 1557.7438, 1654.7966, 1791.8555, 1919.9141, 2056.9730, 2171.0159, 2268.0687, 2405.1276, 2533.1862, 2661.2447, 2798.3037, 2935.3626, 3072.4215, 3209.4804, 3296.5124, 3424.5710, 3587.6343, 3750.6976, 3913.7610, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ALPLHHMLEFEEWAMLMEHQVLAELAEFCYISK", {72.0444, 185.1285, 282.1812, 395.2653, 532.3242, 669.3831, 800.4236, 913.5077, 1042.5502, 1189.6187, 1318.6613, 1447.7038, 1633.7832, 1704.8203, 1835.8608, 1948.9448, 2079.9853, 2209.0279, 2346.0868, 2474.1454, 2573.2138, 2686.2979, 2757.3350, 2886.3776, 2999.4616, 3070.4988, 3199.5413, 3346.6098, 3506.6404, 3669.7037, 3782.7878, 3869.8198, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 234.1448, 347.2289, 510.2922, 670.3229, 817.3913, 946.4339, 1017.4710, 1130.5551, 1259.5977, 1330.6348, 1443.7188, 1542.7872, 1670.8458, 1807.9047, 1936.9473, 2067.9878, 2181.0719, 2312.1124, 2383.1495, 2569.2288, 2698.2714, 2827.3140, 2974.3824, 3103.4250, 3216.5090, 3347.5495, 3484.6084, 3621.6674, 3734.7514, 3831.8042, 3944.8882, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"HFLFYCGLTDLTINSICTLTMGAMDYGYAFWYR", {138.0662, 285.1346, 398.2187, 545.2871, 708.3504, 868.3811, 925.4025, 1038.4866, 1139.5343, 1254.5612, 1367.6453, 1468.6929, 1581.7770, 1695.8199, 1782.8520, 1895.9360, 2055.9667, 2157.0144, 2270.0984, 2371.1461, 2502.1866, 2559.2081, 2630.2452, 2761.2856, 2876.3126, 3039.3759, 3096.3974, 3259.4607, 3330.4978, 3477.5662, 3663.6456, 3826.7089, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 524.2616, 671.3300, 742.3671, 905.4305, 962.4519, 1125.5152, 1240.5422, 1371.5827, 1442.6198, 1499.6412, 1630.6817, 1731.7294, 1844.8135, 1945.8612, 2105.8918, 2218.9759, 2306.0079, 2420.0508, 2533.1349, 2634.1826, 2747.2666, 2862.2936, 2963.3412, 3076.4253, 3133.4468, 3293.4774, 3456.5408, 3603.6092, 3716.6932, 3863.7616, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ISKPFNCNPQFQIQLTHVFIILFQVIQLITIYK", {114.0913, 201.1234, 329.2183, 426.2711, 573.3395, 687.3824, 847.4131, 961.4560, 1058.5088, 1186.5674, 1333.6358, 1461.6943, 1574.7784, 1702.8370, 1815.9211, 1916.9687, 2054.0276, 2153.0961, 2300.1645, 2413.2485, 2526.3326, 2639.4167, 2786.4851, 2914.5437, 3013.6121, 3126.6961, 3254.7547, 3367.8388, 3480.9228, 3581.9705, 3695.0546, 3858.1179, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 310.1761, 423.2602, 524.3079, 637.3919, 750.4760, 878.5346, 991.6186, 1090.6871, 1218.7456, 1365.8141, 1478.8981, 1591.9822, 1705.0662, 1852.1347, 1951.2031, 2088.2620, 2189.3097, 2302.3937, 2430.4523, 2543.5364, 2671.5949, 2818.6634, 2946.7219, 3043.7747, 3157.8176, 3317.8483, 3431.8912, 3578.9596, 3676.0124, 3804.1073, 3891.1394, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ENLVEVFNHIAELYCLNNDNVDVCICFYLGAYR", {130.0499, 244.0928, 357.1769, 456.2453, 585.2879, 684.3563, 831.4247, 945.4676, 1082.5265, 1195.6106, 1266.6477, 1395.6903, 1508.7744, 1671.8377, 1831.8683, 1944.9524, 2058.9953, 2173.0383, 2288.0652, 2402.1081, 2501.1766, 2616.2035, 2715.2719, 2875.3026, 2988.3866, 3148.4173, 3295.4857, 3458.5490, 3571.6331, 3628.6545, 3699.6917, 3862.7550, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 409.2194, 466.2409, 579.3249, 742.3883, 889.4567, 1049.4873, 1162.5714, 1322.6020, 1421.6704, 1536.6974, 1635.7658, 1749.8087, 1864.8357, 1978.8786, 2092.9215, 2206.0056, 2366.0362, 2529.0996, 2642.1836, 2771.2262, 2842.2633, 2955.3474, 3092.4063, 3206.4492, 3353.5177, 3452.5861, 3581.6287, 3680.6971, 3793.7811, 3907.8241, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DYYQEAKPYTAVYDLASSMGLYTCNQFWYTLIR", {116.0342, 279.0975, 442.1609, 570.2195, 699.2620, 770.2992, 898.3941, 995.4469, 1158.5102, 1259.5579, 1330.5950, 1429.6634, 1592.7268, 1707.7537, 1820.8378, 1891.8749, 1978.9069, 2065.9389, 2196.9794, 2254.0009, 2367.0849, 2530.1483, 2631.1959, 2791.2266, 2905.2695, 3033.3281, 3180.3965, 3366.4758, 3529.5392, 3630.5868, 3743.6709, 3856.7550, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 401.2871, 502.3348, 665.3981, 851.4774, 998.5458, 1126.6044, 1240.6473, 1400.6780, 1501.7256, 1664.7890, 1777.8730, 1834.8945, 1965.9350, 2052.9670, 2139.9990, 2211.0362, 2324.1202, 2439.1472, 2602.2105, 2701.2789, 2772.3160, 2873.3637, 3036.4270, 3133.4798, 3261.5748, 3332.6119, 3461.6545, 3589.7130, 3752.7764, 3915.8397, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FQQDIDNQEQQVQQNQQLQQLQEQQPQVYALSR", {148.0757, 276.1343, 404.1928, 519.2198, 632.3039, 747.3308, 861.3737, 989.4323, 1118.4749, 1246.5335, 1374.5920, 1473.6605, 1601.7190, 1729.7776, 1843.8205, 1971.8791, 2099.9377, 2213.0218, 2341.0803, 2469.1389, 2582.2230, 2710.2816, 2839.3242, 2967.3827, 3095.4413, 3192.4941, 3320.5527, 3419.6211, 3582.6844, 3653.7215, 3766.8056, 3853.8376, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 262.1510, 375.2350, 446.2722, 609.3355, 708.4039, 836.4625, 933.5152, 1061.5738, 1189.6324, 1318.6750, 1446.7336, 1559.8176, 1687.8762, 1815.9348, 1929.0189, 2057.0774, 2185.1360, 2299.1789, 2427.2375, 2555.2961, 2654.3645, 2782.4231, 2910.4817, 3039.5243, 3167.5828, 3281.6258, 3396.6527, 3509.7368, 3624.7637, 3752.8223, 3880.8809, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MSNEEEMEEDYDLEHEFEQESEAITSPLNFYVR", {132.0478, 219.0798, 333.1227, 462.1653, 591.2079, 720.2505, 851.2910, 980.3336, 1109.3762, 1224.4031, 1387.4664, 1502.4934, 1615.5774, 1744.6200, 1881.6790, 2010.7215, 2157.7900, 2286.8326, 2414.8911, 2543.9337, 2630.9658, 2760.0083, 2831.0455, 2944.1295, 3045.1772, 3132.2092, 3229.2620, 3342.3461, 3456.3890, 3603.4574, 3766.5207, 3865.5891, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 274.1874, 437.2507, 584.3191, 698.3620, 811.4461, 908.4989, 995.5309, 1096.5786, 1209.6626, 1280.6997, 1409.7423, 1496.7744, 1625.8170, 1753.8755, 1882.9181, 2029.9865, 2159.0291, 2296.0881, 2425.1306, 2538.2147, 2653.2417, 2816.3050, 2931.3319, 3060.3745, 3189.4171, 3320.4576, 3449.5002, 3578.5428, 3707.5854, 3821.6283, 3908.6603, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FKPVIELVEFIQLIISIWLFSVMSADFQCWHDK", {148.0757, 276.1707, 373.2234, 472.2918, 585.3759, 714.4185, 827.5026, 926.5710, 1055.6136, 1202.6820, 1315.7660, 1443.8246, 1556.9087, 1669.9927, 1783.0768, 1870.1088, 1983.1929, 2169.2722, 2282.3563, 2429.4247, 2516.4567, 2615.5251, 2746.5656, 2833.5976, 2904.6348, 3019.6617, 3166.7301, 3294.7887, 3454.8193, 3640.8987, 3777.9576, 3892.9845, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 262.1397, 399.1987, 585.2780, 745.3086, 873.3672, 1020.4356, 1135.4626, 1206.4997, 1293.5317, 1424.5722, 1523.6406, 1610.6726, 1757.7410, 1870.8251, 2056.9044, 2169.9885, 2257.0205, 2370.1046, 2483.1886, 2596.2727, 2724.3313, 2837.4153, 2984.4838, 3113.5263, 3212.5948, 3325.6788, 3454.7214, 3567.8055, 3666.8739, 3763.9267, 3892.0216, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"WVEQECEACYEPFHAQTLLASAMLMTMFLLNCR", {187.0866, 286.1550, 415.1976, 543.2562, 672.2988, 832.3294, 961.3720, 1032.4091, 1192.4398, 1355.5031, 1484.5457, 1581.5985, 1728.6669, 1865.7258, 1936.7629, 2064.8215, 2165.8692, 2278.9532, 2392.0373, 2463.0744, 2550.1064, 2621.1435, 2752.1840, 2865.2681, 2996.3086, 3097.3562, 3228.3967, 3375.4651, 3488.5492, 3601.6333, 3715.6762, 3875.7069, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 335.1496, 449.1925, 562.2766, 675.3607, 822.4291, 953.4696, 1054.5172, 1185.5577, 1298.6418, 1429.6823, 1500.7194, 1587.7514, 1658.7885, 1771.8726, 1884.9567, 1986.0043, 2114.0629, 2185.1000, 2322.1589, 2469.2273, 2566.2801, 2695.3227, 2858.3860, 3018.4167, 3089.4538, 3218.4964, 3378.5270, 3507.5696, 3635.6282, 3764.6708, 3863.7392, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EECFCMHGNGSSEMMCVHDVMFLNIQLQSTCMR", {130.0499, 259.0925, 419.1231, 566.1915, 726.2222, 857.2627, 994.3216, 1051.3430, 1165.3860, 1222.4074, 1309.4395, 1396.4715, 1525.5141, 1656.5546, 1787.5950, 1947.6257, 2046.6941, 2183.7530, 2298.7800, 2397.8484, 2528.8889, 2675.9573, 2789.0413, 2903.0843, 3016.1683, 3144.2269, 3257.3110, 3385.3695, 3472.4016, 3573.4493, 3733.4799, 3864.5204, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 306.1594, 466.1901, 567.2378, 654.2698, 782.3284, 895.4124, 1023.4710, 1136.5551, 1250.5980, 1363.6821, 1510.7505, 1641.7910, 1740.8594, 1855.8863, 1992.9452, 2092.0136, 2252.0443, 2383.0848, 2514.1253, 2643.1679, 2730.1999, 2817.2319, 2874.2534, 2988.2963, 3045.3178, 3182.3767, 3313.4172, 3473.4478, 3620.5162, 3780.5469, 3909.5895, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MIIQQFLNRPLSSPFFVWSHWEETMWELLGVAR", {132.0478, 245.1318, 358.2159, 486.2745, 614.3330, 761.4015, 874.4855, 988.5284, 1144.6296, 1241.6823, 1354.7664, 1441.7984, 1528.8304, 1625.8832, 1772.9516, 1920.0200, 2019.0885, 2205.1678, 2292.1998, 2429.2587, 2615.3380, 2744.3806, 2873.4232, 2974.4709, 3105.5114, 3291.5907, 3420.6333, 3533.7173, 3646.8014, 3703.8229, 3802.8913, 3873.9284, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 246.1561, 345.2245, 402.2459, 515.3300, 628.4141, 757.4567, 943.5360, 1074.5765, 1175.6241, 1304.6667, 1433.7093, 1619.7886, 1756.8476, 1843.8796, 2029.9589, 2129.0273, 2276.0957, 2423.1641, 2520.2169, 2607.2489, 2694.2810, 2807.3650, 2904.4178, 3060.5189, 3174.5618, 3287.6459, 3434.7143, 3562.7729, 3690.8315, 3803.9155, 3916.9996, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"THTANYQCYSHKPNLFNISETYIIENLPTCLMR", {102.0550, 239.1139, 340.1615, 411.1987, 525.2416, 688.3049, 816.3635, 976.3941, 1139.4575, 1226.4895, 1363.5484, 1491.6434, 1588.6961, 1702.7391, 1815.8231, 1962.8915, 2076.9345, 2190.0185, 2277.0506, 2406.0932, 2507.1408, 2670.2042, 2783.2882, 2896.3723, 3025.4149, 3139.4578, 3252.5419, 3349.5946, 3450.6423, 3610.6730, 3723.7570, 3854.7975, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 306.1594, 419.2435, 579.2741, 680.3218, 777.3746, 890.4587, 1004.5016, 1133.5442, 1246.6282, 1359.7123, 1522.7756, 1623.8233, 1752.8659, 1839.8979, 1952.9820, 2067.0249, 2214.0933, 2327.1774, 2441.2203, 2538.2731, 2666.3681, 2803.4270, 2890.4590, 3053.5223, 3213.5530, 3341.6116, 3504.6749, 3618.7178, 3689.7549, 3790.8026, 3927.8615, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EDESPMFQVYTHLQMLLHHQLMWIVMQALIGQR", {130.0499, 245.0768, 374.1194, 461.1514, 558.2042, 689.2447, 836.3131, 964.3717, 1063.4401, 1226.5034, 1327.5511, 1464.6100, 1577.6941, 1705.7526, 1836.7931, 1949.8772, 2062.9613, 2200.0202, 2337.0791, 2465.1377, 2578.2217, 2709.2622, 2895.3415, 3008.4256, 3107.4940, 3238.5345, 3366.5931, 3437.6302, 3550.7142, 3663.7983, 3720.8198, 3848.8783, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 360.1990, 473.2831, 586.3671, 657.4042, 785.4628, 916.5033, 1015.5717, 1128.6558, 1314.7351, 1445.7756, 1558.8596, 1686.9182, 1823.9771, 1961.0360, 2074.1201, 2187.2042, 2318.2447, 2446.3032, 2559.3873, 2696.4462, 2797.4939, 2960.5572, 3059.6256, 3187.6842, 3334.7526, 3465.7931, 3562.8459, 3649.8779, 3778.9205, 3893.9474, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"GEFDCNNLLLWLLEQMWTTGCKPLTVIWVDDDR", {58.0287, 187.0713, 334.1397, 449.1667, 609.1973, 723.2403, 837.2832, 950.3673, 1063.4513, 1176.5354, 1362.6147, 1475.6988, 1588.7828, 1717.8254, 1845.8840, 1976.9245, 2163.0038, 2264.0515, 2365.0992, 2422.1206, 2582.1513, 2710.2462, 2807.2990, 2920.3831, 3021.4307, 3120.4991, 3233.5832, 3419.6625, 3518.7309, 3633.7579, 3748.7848, 3863.8118, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 290.1459, 405.1728, 520.1998, 619.2682, 805.3475, 918.4316, 1017.5000, 1118.5477, 1231.6317, 1328.6845, 1456.7795, 1616.8101, 1673.8316, 1774.8792, 1875.9269, 2062.0062, 2193.0467, 2321.1053, 2450.1479, 2563.2320, 2676.3160, 2862.3953, 2975.4794, 3088.5635, 3201.6475, 3315.6905, 3429.7334, 3589.7640, 3704.7910, 3851.8594, 3980.9020, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LDTLWNMLGTNCLCYHITQMVDVAHLNNHYPNR", {114.0913, 229.1183, 330.1660, 443.2500, 629.3293, 743.3723, 874.4128, 987.4968, 1044.5183, 1145.5660, 1259.6089, 1419.6395, 1532.7236, 1692.7542, 1855.8176, 1992.8765, 2105.9606, 2207.0082, 2335.0668, 2466.1073, 2565.1757, 2680.2026, 2779.2711, 2850.3082, 2987.3671, 3100.4512, 3214.4941, 3328.5370, 3465.5959, 3628.6592, 3725.7120, 3839.7549, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 289.1619, 386.2146, 549.2780, 686.3369, 800.3798, 914.4227, 1027.5068, 1164.5657, 1235.6028, 1334.6712, 1449.6982, 1548.7666, 1679.8071, 1807.8657, 1908.9133, 2021.9974, 2159.0563, 2322.1196, 2482.1503, 2595.2344, 2755.2650, 2869.3079, 2970.3556, 3027.3771, 3140.4611, 3271.5016, 3385.5446, 3571.6239, 3684.7079, 3785.7556, 3900.7826, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PRPSPTSMPNQMQELWKPDVEYNPNETLWQMLR", {98.0600, 254.1612, 351.2139, 438.2459, 535.2987, 636.3464, 723.3784, 854.4189, 951.4717, 1065.5146, 1193.5732, 1324.6137, 1452.6722, 1581.7148, 1694.7989, 1880.8782, 2008.9732, 2106.0259, 2221.0529, 2320.1213, 2449.1639, 2612.2272, 2726.2701, 2823.3229, 2937.3658, 3066.4084, 3167.4561, 3280.5402, 3466.6195, 3594.6781, 3725.7185, 3838.8026, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 419.2435, 547.3021, 733.3814, 846.4655, 947.5131, 1076.5557, 1190.5987, 1287.6514, 1401.6943, 1564.7577, 1693.8003, 1792.8687, 1907.8956, 2004.9484, 2133.0434, 2319.1227, 2432.2067, 2561.2493, 2689.3079, 2820.3484, 2948.4070, 3062.4499, 3159.5027, 3290.5431, 3377.5752, 3478.6228, 3575.6756, 3662.7076, 3759.7604, 3915.8615, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"IITPYIVIESDANYFIINEDCLCYHNIPNPCDR", {114.0913, 227.1754, 328.2231, 425.2758, 588.3392, 701.4232, 800.4917, 913.5757, 1042.6183, 1129.6503, 1244.6773, 1315.7144, 1429.7573, 1592.8207, 1739.8891, 1852.9731, 1966.0572, 2080.1001, 2209.1427, 2324.1697, 2484.2003, 2597.2844, 2757.3150, 2920.3783, 3057.4373, 3171.4802, 3284.5643, 3381.6170, 3495.6599, 3592.7127, 3752.7434, 3867.7703, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 290.1459, 450.1765, 547.2293, 661.2722, 758.3250, 871.4091, 985.4520, 1122.5109, 1285.5742, 1445.6049, 1558.6889, 1718.7196, 1833.7465, 1962.7891, 2076.8321, 2189.9161, 2303.0002, 2450.0686, 2613.1319, 2727.1749, 2798.2120, 2913.2389, 3000.2709, 3129.3135, 3242.3976, 3341.4660, 3454.5501, 3617.6134, 3714.6662, 3815.7138, 3928.7979, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"CFLTIFYMVLIPWFVPVNFFDFFTCILGILTSK", {161.0379, 308.1063, 421.1904, 522.2381, 635.3221, 782.3906, 945.4539, 1076.4944, 1175.5628, 1288.6469, 1401.7309, 1498.7837, 1684.8630, 1831.9314, 1930.9998, 2028.0526, 2127.1210, 2241.1639, 2388.2323, 2535.3008, 2650.3277, 2797.3961, 2944.4645, 3045.5122, 3205.5429, 3318.6269, 3431.7110, 3488.7324, 3601.8165, 3714.9006, 3815.9482, 3902.9803, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 234.1448, 335.1925, 448.2766, 561.3606, 618.3821, 731.4662, 844.5502, 1004.5809, 1105.6286, 1252.6970, 1399.7654, 1514.7923, 1661.8607, 1808.9292, 1922.9721, 2022.0405, 2119.0933, 2218.1617, 2365.2301, 2551.3094, 2648.3622, 2761.4462, 2874.5303, 2973.5987, 3104.6392, 3267.7025, 3414.7709, 3527.8550, 3628.9027, 3741.9867, 3889.0552, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PDIKPTLFAIFLNLHYIGLAYCVIYWGQYIFIR", {98.0600, 213.0870, 326.1710, 454.2660, 551.3188, 652.3665, 765.4505, 912.5189, 983.5560, 1096.6401, 1243.7085, 1356.7926, 1470.8355, 1583.9196, 1720.9785, 1884.0418, 1997.1259, 2054.1473, 2167.2314, 2238.2685, 2401.3319, 2561.3625, 2660.4309, 2773.5150, 2936.5783, 3122.6576, 3179.6791, 3307.7377, 3470.8010, 3583.8851, 3730.9535, 3844.0375, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 435.2714, 548.3555, 711.4188, 839.4774, 896.4989, 1082.5782, 1245.6415, 1358.7256, 1457.7940, 1617.8246, 1780.8880, 1851.9251, 1965.0091, 2022.0306, 2135.1147, 2298.1780, 2435.2369, 2548.3210, 2662.3639, 2775.4480, 2922.5164, 3035.6004, 3106.6376, 3253.7060, 3366.7900, 3467.8377, 3564.8905, 3692.9854, 3806.0695, 3921.0964, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VQATQIMVNCHLWFHALCHDLILQLEKPILHDR", {100.0757, 228.1343, 299.1714, 400.2191, 528.2776, 641.3617, 772.4022, 871.4706, 985.5135, 1145.5442, 1282.6031, 1395.6872, 1581.7665, 1728.8349, 1865.8938, 1936.9309, 2050.0150, 2210.0456, 2347.1045, 2462.1315, 2575.2155, 2688.2996, 2801.3837, 2929.4422, 3042.5263, 3171.5689, 3299.6639, 3396.7166, 3509.8007, 3622.8848, 3759.9437, 3874.9706, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 290.1459, 427.2048, 540.2889, 653.3729, 750.4257, 878.5207, 1007.5633, 1120.6473, 1248.7059, 1361.7900, 1474.8740, 1587.9581, 1702.9850, 1840.0439, 2000.0746, 2113.1587, 2184.1958, 2321.2547, 2468.3231, 2654.4024, 2767.4865, 2904.5454, 3064.5760, 3178.6190, 3277.6874, 3408.7279, 3521.8119, 3649.8705, 3750.9182, 3821.9553, 3950.0139, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NDIIVGIFLNLTFFSGFIIFFVFYLYMYINTER", {115.0502, 230.0771, 343.1612, 456.2453, 555.3137, 612.3352, 725.4192, 872.4876, 985.5717, 1099.6146, 1212.6987, 1313.7464, 1460.8148, 1607.8832, 1694.9152, 1751.9367, 1899.0051, 2012.0892, 2125.1732, 2272.2416, 2419.3101, 2518.3785, 2665.4469, 2828.5102, 2941.5943, 3104.6576, 3235.6981, 3398.7614, 3511.8455, 3625.8884, 3726.9361, 3855.9787, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 405.2092, 519.2522, 632.3362, 795.3995, 926.4400, 1089.5034, 1202.5874, 1365.6507, 1512.7192, 1611.7876, 1758.8560, 1905.9244, 2019.0085, 2132.0925, 2279.1609, 2336.1824, 2423.2144, 2570.2829, 2717.3513, 2818.3989, 2931.4830, 3045.5259, 3158.6100, 3305.6784, 3418.7625, 3475.7839, 3574.8524, 3687.9364, 3801.0205, 3916.0474, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ADMEWACIWFFIIVTSITLACYSSHYFPPIDTR", {72.0444, 187.0713, 318.1118, 447.1544, 633.2337, 704.2708, 864.3015, 977.3856, 1163.4649, 1310.5333, 1457.6017, 1570.6858, 1683.7698, 1782.8382, 1883.8859, 1970.9179, 2084.0020, 2185.0497, 2298.1337, 2369.1709, 2529.2015, 2692.2648, 2779.2969, 2866.3289, 3003.3878, 3166.4511, 3313.5195, 3410.5723, 3507.6251, 3620.7091, 3735.7361, 3836.7838, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 276.1666, 391.1936, 504.2776, 601.3304, 698.3832, 845.4516, 1008.5149, 1145.5738, 1232.6058, 1319.6379, 1482.7012, 1642.7319, 1713.7690, 1826.8530, 1927.9007, 2040.9848, 2128.0168, 2229.0645, 2328.1329, 2441.2170, 2554.3010, 2701.3694, 2848.4379, 3034.5172, 3147.6012, 3307.6319, 3378.6690, 3564.7483, 3693.7909, 3824.8314, 3939.8583, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LVGVLLITSLIVILLYECWSCCNWANDPDEEYR", {114.0913, 213.1598, 270.1812, 369.2496, 482.3337, 595.4178, 708.5018, 809.5495, 896.5815, 1009.6656, 1122.7497, 1221.8181, 1334.9021, 1447.9862, 1561.0703, 1724.1336, 1853.1762, 2013.2068, 2199.2861, 2286.3182, 2446.3488, 2606.3795, 2720.4224, 2906.5017, 2977.5388, 3091.5818, 3206.6087, 3303.6615, 3418.6884, 3547.7310, 3676.7736, 3839.8369, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 467.2249, 596.2675, 711.2944, 808.3472, 923.3741, 1037.4170, 1108.4542, 1294.5335, 1408.5764, 1568.6070, 1728.6377, 1815.6697, 2001.7490, 2161.7797, 2290.8223, 2453.8856, 2566.9697, 2680.0537, 2793.1378, 2892.2062, 3005.2903, 3118.3743, 3205.4064, 3306.4540, 3419.5381, 3532.6222, 3645.7062, 3744.7747, 3801.7961, 3900.8645, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NPDSNYNSEYLPWFSAFFSVDETLNPFIWFHLK", {115.0502, 212.1030, 327.1299, 414.1619, 528.2049, 691.2682, 805.3111, 892.3432, 1021.3857, 1184.4491, 1297.5331, 1394.5859, 1580.6652, 1727.7336, 1814.7657, 1885.8028, 2032.8712, 2179.9396, 2266.9716, 2366.0400, 2481.0670, 2610.1096, 2711.1573, 2824.2413, 2938.2842, 3035.3370, 3182.4054, 3295.4895, 3481.5688, 3628.6372, 3765.6961, 3878.7802, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 397.2558, 544.3242, 730.4035, 843.4876, 990.5560, 1087.6087, 1201.6517, 1314.7357, 1415.7834, 1544.8260, 1659.8530, 1758.9214, 1845.9534, 1993.0218, 2140.0902, 2211.1273, 2298.1594, 2445.2278, 2631.3071, 2728.3599, 2841.4439, 3004.5073, 3133.5498, 3220.5819, 3334.6248, 3497.6881, 3611.7311, 3698.7631, 3813.7900, 3910.8428, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LINAWILLVFTLWSHYVISWIMMIINLLIYSNK", {114.0913, 227.1754, 341.2183, 412.2554, 598.3348, 711.4188, 824.5029, 937.5870, 1036.6554, 1183.7238, 1284.7715, 1397.8555, 1583.9348, 1670.9669, 1808.0258, 1971.0891, 2070.1575, 2183.2416, 2270.2736, 2456.3529, 2569.4370, 2700.4775, 2831.5180, 2944.6020, 3057.6861, 3171.7290, 3284.8131, 3397.8971, 3510.9812, 3674.0445, 3761.0766, 3875.1195, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 261.1557, 348.1878, 511.2511, 624.3352, 737.4192, 850.5033, 964.5462, 1077.6303, 1190.7143, 1321.7548, 1452.7953, 1565.8794, 1751.9587, 1838.9907, 1952.0748, 2051.1432, 2214.2065, 2351.2654, 2438.2975, 2624.3768, 2737.4608, 2838.5085, 2985.5769, 3084.6453, 3197.7294, 3310.8135, 3423.8975, 3609.9768, 3681.0140, 3795.0569, 3908.1410, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FLIVLLPVYFTCCTAFIQYGVDQSVMCHQEEIR", {148.0757, 261.1598, 374.2438, 473.3122, 586.3963, 699.4804, 796.5331, 895.6015, 1058.6649, 1205.7333, 1306.7810, 1466.8116, 1626.8423, 1727.8899, 1798.9270, 1945.9955, 2059.0795, 2187.1381, 2350.2014, 2407.2229, 2506.2913, 2621.3183, 2749.3768, 2836.4089, 2935.4773, 3066.5178, 3226.5484, 3363.6073, 3491.6659, 3620.7085, 3749.7511, 3862.8351, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 417.2456, 546.2882, 674.3468, 811.4057, 971.4363, 1102.4768, 1201.5452, 1288.5773, 1416.6358, 1531.6628, 1630.7312, 1687.7527, 1850.8160, 1978.8746, 2091.9586, 2239.0270, 2310.0642, 2411.1118, 2571.1425, 2731.1731, 2832.2208, 2979.2892, 3142.3526, 3241.4210, 3338.4737, 3451.5578, 3564.6419, 3663.7103, 3776.7943, 3889.8784, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MCINLPGFDNYFNEYIFEEDVSFYHTNVTNKPK", {132.0478, 292.0784, 405.1625, 519.2054, 632.2895, 729.3422, 786.3637, 933.4321, 1048.4590, 1162.5020, 1325.5653, 1472.6337, 1586.6766, 1715.7192, 1878.7826, 1991.8666, 2138.9350, 2267.9776, 2397.0202, 2512.0472, 2611.1156, 2698.1476, 2845.2160, 3008.2794, 3145.3383, 3246.3860, 3360.4289, 3459.4973, 3560.5450, 3674.5879, 3802.6829, 3899.7356, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 244.1656, 372.2605, 486.3035, 587.3511, 686.4196, 800.4625, 901.5102, 1038.5691, 1201.6324, 1348.7008, 1435.7328, 1534.8013, 1649.8282, 1778.8708, 1907.9134, 2054.9818, 2168.0659, 2331.1292, 2460.1718, 2574.2147, 2721.2831, 2884.3465, 2998.3894, 3113.4163, 3260.4847, 3317.5062, 3414.5590, 3527.6430, 3641.6860, 3754.7700, 3914.8007, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VNLFPDLEALEEDSMNDYCVGNDMIHDHPCCFR", {100.0757, 214.1186, 327.2027, 474.2711, 571.3239, 686.3508, 799.4349, 928.4775, 999.5146, 1112.5986, 1241.6412, 1370.6838, 1485.7108, 1572.7428, 1703.7833, 1817.8262, 1932.8532, 2095.9165, 2255.9471, 2355.0155, 2412.0370, 2526.0799, 2641.1069, 2772.1474, 2885.2314, 3022.2903, 3137.3173, 3274.3762, 3371.4290, 3531.4596, 3691.4903, 3838.5587, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 482.2180, 642.2487, 739.3014, 876.3603, 991.3873, 1128.4462, 1241.5303, 1372.5707, 1487.5977, 1601.6406, 1658.6621, 1757.7305, 1917.7611, 2080.8245, 2195.8514, 2309.8943, 2440.9348, 2527.9669, 2642.9938, 2772.0364, 2901.0790, 3014.1630, 3085.2002, 3214.2428, 3327.3268, 3442.3538, 3539.4065, 3686.4749, 3799.5590, 3913.6019, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"WQLFVFTLLTYVLMSPVSYFMFTPFDMQETSNK", {187.0866, 315.1452, 428.2292, 575.2976, 674.3661, 821.4345, 922.4822, 1035.5662, 1148.6503, 1249.6980, 1412.7613, 1511.8297, 1624.9138, 1755.9542, 1842.9863, 1940.0390, 2039.1075, 2126.1395, 2289.2028, 2436.2712, 2567.3117, 2714.3801, 2815.4278, 2912.4806, 3059.5490, 3174.5759, 3305.6164, 3433.6750, 3562.7176, 3663.7653, 3750.7973, 3864.8402, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 261.1557, 348.1878, 449.2354, 578.2780, 706.3366, 837.3771, 952.4040, 1099.4725, 1196.5252, 1297.5729, 1444.6413, 1575.6818, 1722.7502, 1885.8135, 1972.8456, 2071.9140, 2168.9667, 2255.9988, 2387.0393, 2500.1233, 2599.1917, 2762.2551, 2863.3027, 2976.3868, 3089.4709, 3190.5185, 3337.5870, 3436.6554, 3583.7238, 3696.8079, 3824.8664, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LQDSTHFLHPHHAPNLHPHQHPHPHPHHPHQYR", {114.0913, 242.1499, 357.1769, 444.2089, 545.2566, 682.3155, 829.3839, 942.4680, 1079.5269, 1176.5796, 1313.6385, 1450.6975, 1521.7346, 1618.7873, 1732.8303, 1845.9143, 1982.9732, 2080.0260, 2217.0849, 2345.1435, 2482.2024, 2579.2552, 2716.3141, 2813.3668, 2950.4258, 3047.4785, 3184.5374, 3321.5963, 3418.6491, 3555.7080, 3683.7666, 3846.8299, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 466.2409, 603.2998, 700.3525, 837.4114, 974.4704, 1071.5231, 1208.5820, 1305.6348, 1442.6937, 1539.7465, 1676.8054, 1804.8640, 1941.9229, 2038.9756, 2176.0346, 2289.1186, 2403.1615, 2500.2143, 2571.2514, 2708.3103, 2845.3692, 2942.4220, 3079.4809, 3192.5650, 3339.6334, 3476.6923, 3577.7400, 3664.7720, 3779.7990, 3907.8575, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NVVLPDTMNWIFVLYSEIMMSCIQTDHPYSEFK", {115.0502, 214.1186, 313.1870, 426.2711, 523.3239, 638.3508, 739.3985, 870.4390, 984.4819, 1170.5612, 1283.6453, 1430.7137, 1529.7821, 1642.8662, 1805.9295, 1892.9615, 2022.0041, 2135.0882, 2266.1287, 2397.1691, 2484.2012, 2644.2318, 2757.3159, 2885.3745, 2986.4221, 3101.4491, 3238.5080, 3335.5608, 3498.6241, 3585.6561, 3714.6987, 3861.7671, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 294.1812, 423.2238, 510.2558, 673.3192, 770.3719, 907.4308, 1022.4578, 1123.5055, 1251.5640, 1364.6481, 1524.6788, 1611.7108, 1742.7513, 1873.7918, 1986.8758, 2115.9184, 2202.9504, 2366.0138, 2479.0978, 2578.1662, 2725.2347, 2838.3187, 3024.3980, 3138.4410, 3269.4814, 3370.5291, 3485.5561, 3582.6088, 3695.6929, 3794.7613, 3893.8297, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DVSICCLHLISATSFYVDLSNWLDCLFPSFNWR", {116.0342, 215.1026, 302.1347, 415.2187, 575.2494, 735.2800, 848.3641, 985.4230, 1098.5071, 1211.5911, 1298.6232, 1369.6603, 1470.7079, 1557.7400, 1704.8084, 1867.8717, 1966.9401, 2081.9671, 2195.0511, 2282.0832, 2396.1261, 2582.2054, 2695.2895, 2810.3164, 2970.3471, 3083.4311, 3230.4995, 3327.5523, 3414.5843, 3561.6527, 3675.6957, 3861.7750, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 361.1983, 475.2412, 622.3096, 709.3416, 806.3944, 953.4628, 1066.5469, 1226.5775, 1341.6045, 1454.6885, 1640.7678, 1754.8108, 1841.8428, 1954.9269, 2069.9538, 2169.0222, 2332.0856, 2479.1540, 2566.1860, 2667.2337, 2738.2708, 2825.3028, 2938.3869, 3051.4709, 3188.5299, 3301.6139, 3461.6446, 3621.6752, 3734.7593, 3821.7913, 3920.8597, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"GENMWTYTWWEPSVLNGFWQHAIEHNQTILDLK", {58.0287, 187.0713, 301.1143, 432.1547, 618.2341, 719.2817, 882.3451, 983.3927, 1169.4721, 1355.5514, 1484.5940, 1581.6467, 1668.6788, 1767.7472, 1880.8312, 1994.8742, 2051.8956, 2198.9640, 2385.0434, 2513.1019, 2650.1608, 2721.1980, 2834.2820, 2963.3246, 3100.3835, 3214.4265, 3342.4850, 3443.5327, 3556.6168, 3669.7008, 3784.7278, 3897.8118, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 375.2238, 488.3079, 601.3919, 702.4396, 830.4982, 944.5411, 1081.6000, 1210.6426, 1323.7267, 1394.7638, 1531.8227, 1659.8813, 1845.9606, 1993.0290, 2050.0505, 2164.0934, 2277.1775, 2376.2459, 2463.2779, 2560.3307, 2689.3733, 2875.4526, 3061.5319, 3162.5796, 3325.6429, 3426.6906, 3612.7699, 3743.8104, 3857.8533, 3986.8959, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DVSICCLHMISATSFYVDFSNWMDCMVSGFMWK", {116.0342, 215.1026, 302.1347, 415.2187, 575.2494, 735.2800, 848.3641, 985.4230, 1116.4635, 1229.5475, 1316.5796, 1387.6167, 1488.6644, 1575.6964, 1722.7648, 1885.8281, 1984.8966, 2099.9235, 2246.9919, 2334.0239, 2448.0669, 2634.1462, 2765.1867, 2880.2136, 3040.2443, 3171.2847, 3270.3532, 3357.3852, 3414.4066, 3561.4751, 3692.5155, 3878.5949, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 333.1921, 464.2326, 611.3010, 668.3225, 755.3545, 854.4229, 985.4634, 1145.4941, 1260.5210, 1391.5615, 1577.6408, 1691.6837, 1778.7158, 1925.7842, 2040.8111, 2139.8795, 2302.9429, 2450.0113, 2537.0433, 2638.0910, 2709.1281, 2796.1601, 2909.2442, 3040.2847, 3177.3436, 3290.4276, 3450.4583, 3610.4889, 3723.5730, 3810.6050, 3909.6734, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SHIALICQPYQHPDEIGTHWHNFALCVLLYIDR", {88.0393, 225.0982, 338.1823, 409.2194, 522.3035, 635.3875, 795.4182, 923.4767, 1020.5295, 1183.5928, 1311.6514, 1448.7103, 1545.7631, 1660.7900, 1789.8326, 1902.9167, 1959.9382, 2060.9858, 2198.0447, 2384.1241, 2521.1830, 2635.2259, 2782.2943, 2853.3314, 2966.4155, 3126.4461, 3225.5146, 3338.5986, 3451.6827, 3614.7460, 3727.8301, 3842.8570, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 290.1459, 403.2300, 566.2933, 679.3774, 792.4614, 891.5298, 1051.5605, 1164.6445, 1235.6817, 1382.7501, 1496.7930, 1633.8519, 1819.9312, 1956.9901, 2058.0378, 2115.0593, 2228.1433, 2357.1859, 2472.2129, 2569.2656, 2706.3246, 2834.3831, 2997.4465, 3094.4992, 3222.5578, 3382.5884, 3495.6725, 3608.7566, 3679.7937, 3792.8778, 3929.9367, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LCENDTVMEEWLQVPDRPYLQTLYANDLYQGVR", {114.0913, 274.1220, 403.1646, 517.2075, 632.2345, 733.2821, 832.3505, 963.3910, 1092.4336, 1221.4762, 1407.5555, 1520.6396, 1648.6982, 1747.7666, 1844.8193, 1959.8463, 2115.9474, 2213.0002, 2376.0635, 2489.1476, 2617.2061, 2718.2538, 2831.3379, 2994.4012, 3065.4383, 3179.4812, 3294.5082, 3407.5923, 3570.6556, 3698.7142, 3755.7356, 3854.8040, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 274.1874, 331.2088, 459.2674, 622.3307, 735.4148, 850.4417, 964.4847, 1035.5218, 1198.5851, 1311.6692, 1412.7169, 1540.7754, 1653.8595, 1816.9228, 1913.9756, 2070.0767, 2185.1036, 2282.1564, 2381.2248, 2509.2834, 2622.3675, 2808.4468, 2937.4894, 3066.5320, 3197.5724, 3296.6409, 3397.6885, 3512.7155, 3626.7584, 3755.8010, 3915.8317, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"AWVYEWWLPPPVELEEIELVFIDLHDLIDSTLK", {72.0444, 258.1237, 357.1921, 520.2554, 649.2980, 835.3774, 1021.4567, 1134.5407, 1231.5935, 1328.6463, 1425.6990, 1524.7674, 1653.8100, 1766.8941, 1895.9367, 2024.9793, 2138.0633, 2267.1059, 2380.1900, 2479.2584, 2626.3268, 2739.4109, 2854.4378, 2967.5219, 3104.5808, 3219.6078, 3332.6918, 3445.7759, 3560.8028, 3647.8349, 3748.8825, 3861.9666, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 361.2445, 448.2766, 563.3035, 676.3876, 789.4716, 904.4986, 1041.5575, 1154.6416, 1269.6685, 1382.7526, 1529.8210, 1628.8894, 1741.9735, 1871.0161, 1984.1001, 2113.1427, 2242.1853, 2355.2694, 2484.3120, 2583.3804, 2680.4331, 2777.4859, 2874.5387, 2987.6227, 3173.7020, 3359.7814, 3488.8240, 3651.8873, 3750.9557, 3937.0350, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EEICNVCYHQSGLIIIICLVHLVHIINACYLEK", {130.0499, 259.0925, 372.1765, 532.2072, 646.2501, 745.3185, 905.3492, 1068.4125, 1205.4714, 1333.5300, 1420.5620, 1477.5835, 1590.6675, 1703.7516, 1816.8357, 1929.9197, 2043.0038, 2203.0344, 2316.1185, 2415.1869, 2552.2458, 2665.3299, 2764.3983, 2901.4572, 3014.5413, 3127.6254, 3241.6683, 3312.7054, 3472.7360, 3635.7994, 3748.8834, 3877.9260, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 276.1554, 389.2395, 552.3028, 712.3334, 783.3706, 897.4135, 1010.4975, 1123.5816, 1260.6405, 1359.7089, 1472.7930, 1609.8519, 1708.9203, 1822.0044, 1982.0350, 2095.1191, 2208.2032, 2321.2872, 2434.3713, 2547.4554, 2604.4768, 2691.5088, 2819.5674, 2956.6263, 3119.6897, 3279.7203, 3378.7887, 3492.8317, 3652.8623, 3765.9464, 3894.9890, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LIVLLICPATILCYIMLVFFIFVYNAQFYSLNR", {114.0913, 227.1754, 326.2438, 439.3279, 552.4119, 665.4960, 825.5267, 922.5794, 993.6165, 1094.6642, 1207.7483, 1320.8323, 1480.8630, 1643.9263, 1757.0104, 1888.0509, 2001.1349, 2100.2033, 2247.2718, 2394.3402, 2507.4242, 2654.4927, 2753.5611, 2916.6244, 3030.6673, 3101.7044, 3229.7630, 3376.8314, 3539.8948, 3626.9268, 3740.0108, 3854.0538, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 289.1619, 402.2459, 489.2780, 652.3413, 799.4097, 927.4683, 998.5054, 1112.5483, 1275.6117, 1374.6801, 1521.7485, 1634.8326, 1781.9010, 1928.9694, 2028.0378, 2141.1219, 2272.1623, 2385.2464, 2548.3097, 2708.3404, 2821.4244, 2934.5085, 3035.5562, 3106.5933, 3203.6461, 3363.6767, 3476.7608, 3589.8448, 3702.9289, 3801.9973, 3915.0814, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EEIDIEPELCQEFLHHEHEIFNDTITNVLDNDK", {130.0499, 259.0925, 372.1765, 487.2035, 600.2875, 729.3301, 826.3829, 955.4255, 1068.5095, 1228.5402, 1356.5988, 1485.6414, 1632.7098, 1745.7938, 1882.8528, 2019.9117, 2148.9543, 2286.0132, 2415.0558, 2528.1398, 2675.2082, 2789.2512, 2904.2781, 3005.3258, 3118.4099, 3219.4575, 3333.5005, 3432.5689, 3545.6529, 3660.6799, 3774.7228, 3889.7498, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 262.1397, 376.1827, 491.2096, 604.2937, 703.3621, 817.4050, 918.4527, 1031.5368, 1132.5844, 1247.6114, 1361.6543, 1508.7227, 1621.8068, 1750.8494, 1887.9083, 2016.9509, 2154.0098, 2291.0687, 2404.1528, 2551.2212, 2680.2638, 2808.3224, 2968.3530, 3081.4371, 3210.4797, 3307.5324, 3436.5750, 3549.6591, 3664.6860, 3777.7701, 3906.8127, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YYNSHWSGPNYSPHFNYQEDQPQNQNHQNISPR", {164.0706, 327.1339, 441.1769, 528.2089, 665.2678, 851.3471, 938.3791, 995.4006, 1092.4534, 1206.4963, 1369.5596, 1456.5917, 1553.6444, 1690.7033, 1837.7717, 1951.8147, 2114.8780, 2242.9366, 2371.9792, 2487.0061, 2615.0647, 2712.1175, 2840.1760, 2954.2190, 3082.2775, 3196.3205, 3333.3794, 3461.4380, 3575.4809, 3688.5649, 3775.5970, 3872.6497, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 272.1717, 359.2037, 472.2878, 586.3307, 714.3893, 851.4482, 965.4912, 1093.5497, 1207.5927, 1335.6512, 1432.7040, 1560.7626, 1675.7895, 1804.8321, 1932.8907, 2095.9540, 2209.9969, 2357.0654, 2494.1243, 2591.1770, 2678.2091, 2841.2724, 2955.3153, 3052.3681, 3109.3895, 3196.4216, 3382.5009, 3519.5598, 3606.5918, 3720.6348, 3883.6981, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LNQVTCLNTFYECPSICQGGICTQEDLCDYDTK", {114.0913, 228.1343, 356.1928, 455.2613, 556.3089, 716.3396, 829.4237, 943.4666, 1044.5143, 1191.5827, 1354.6460, 1483.6886, 1643.7192, 1740.7720, 1827.8040, 1940.8881, 2100.9187, 2228.9773, 2285.9988, 2343.0203, 2456.1043, 2616.1350, 2717.1826, 2845.2412, 2974.2838, 3089.3108, 3202.3948, 3362.4255, 3477.4524, 3640.5157, 3755.5427, 3856.5904, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 248.1605, 363.1874, 526.2508, 641.2777, 801.3083, 914.3924, 1029.4194, 1158.4619, 1286.5205, 1387.5682, 1547.5989, 1660.6829, 1717.7044, 1774.7258, 1902.7844, 2062.8151, 2175.8991, 2262.9312, 2359.9839, 2520.0146, 2649.0572, 2812.1205, 2959.1889, 3060.2366, 3174.2795, 3287.3636, 3447.3942, 3548.4419, 3647.5103, 3775.5689, 3889.6118, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NNSDWDKPGDIGCCQLWDEQIWDILNQQDADER", {115.0502, 229.0931, 316.1252, 431.1521, 617.2314, 732.2584, 860.3533, 957.4061, 1014.4275, 1129.4545, 1242.5386, 1299.5600, 1459.5907, 1619.6213, 1747.6799, 1860.7640, 2046.8433, 2161.8702, 2290.9128, 2418.9714, 2532.0554, 2718.1348, 2833.1617, 2946.2458, 3059.3298, 3173.3728, 3301.4313, 3429.4899, 3544.5169, 3615.5540, 3730.5809, 3859.6235, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 419.1885, 490.2256, 605.2525, 733.3111, 861.3697, 975.4126, 1088.4967, 1201.5808, 1316.6077, 1502.6870, 1615.7711, 1743.8297, 1872.8722, 1987.8992, 2173.9785, 2287.0626, 2415.1211, 2575.1518, 2735.1824, 2792.2039, 2905.2880, 3020.3149, 3077.3364, 3174.3891, 3302.4841, 3417.5110, 3603.5904, 3718.6173, 3805.6493, 3919.6923, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DYAEYNPHTPQEEPLSQEPHQQNEQLLTEQQQR", {116.0342, 279.0975, 350.1347, 479.1773, 642.2406, 756.2835, 853.3363, 990.3952, 1091.4429, 1188.4956, 1316.5542, 1445.5968, 1574.6394, 1671.6922, 1784.7762, 1871.8082, 1999.8668, 2128.9094, 2225.9622, 2363.0211, 2491.0797, 2619.1383, 2733.1812, 2862.2238, 2990.2823, 3103.3664, 3216.4505, 3317.4982, 3446.5407, 3574.5993, 3702.6579, 3830.7165, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 431.2361, 559.2947, 688.3373, 789.3850, 902.4690, 1015.5531, 1143.6117, 1272.6543, 1386.6972, 1514.7558, 1642.8143, 1779.8732, 1876.9260, 2005.9686, 2134.0272, 2221.0592, 2334.1433, 2431.1960, 2560.2386, 2689.2812, 2817.3398, 2914.3926, 3015.4402, 3152.4992, 3249.5519, 3363.5948, 3526.6582, 3655.7008, 3726.7379, 3889.8012, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DSSVDDIHVQDCEEIENFFFHTDAMNFVMEEMR", {116.0342, 203.0662, 290.0983, 389.1667, 504.1936, 619.2206, 732.3046, 869.3636, 968.4320, 1096.4905, 1211.5175, 1371.5481, 1500.5907, 1629.6333, 1742.7174, 1871.7600, 1985.8029, 2132.8713, 2279.9397, 2427.0081, 2564.0671, 2665.1147, 2780.1417, 2851.1788, 2982.2193, 3096.2622, 3243.3306, 3342.3990, 3473.4395, 3602.4821, 3731.5247, 3862.5652, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 306.1594, 435.2020, 564.2446, 695.2851, 794.3535, 941.4219, 1055.4649, 1186.5053, 1257.5425, 1372.5694, 1473.6171, 1610.6760, 1757.7444, 1904.8128, 2051.8812, 2165.9242, 2294.9668, 2408.0508, 2537.0934, 2666.1360, 2826.1667, 2941.1936, 3069.2522, 3168.3206, 3305.3795, 3418.4636, 3533.4905, 3648.5175, 3747.5859, 3834.6179, 3921.6499, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PITIVLLAHFLYTFYLYPLIQCVCLVLAWLYGK", {98.0600, 211.1441, 312.1918, 425.2758, 524.3443, 637.4283, 750.5124, 821.5495, 958.6084, 1105.6768, 1218.7609, 1381.8242, 1482.8719, 1629.9403, 1793.0036, 1906.0877, 2069.1510, 2166.2038, 2279.2879, 2392.3719, 2520.4305, 2680.4612, 2779.5296, 2939.5602, 3052.6443, 3151.7127, 3264.7968, 3335.8339, 3521.9132, 3634.9972, 3798.0606, 3855.0820, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 204.1343, 367.1976, 480.2817, 666.3610, 737.3981, 850.4822, 949.5506, 1062.6346, 1222.6653, 1321.7337, 1481.7643, 1609.8229, 1722.9070, 1835.9910, 1933.0438, 2096.1071, 2209.1912, 2372.2545, 2519.3229, 2620.3706, 2783.4340, 2896.5180, 3043.5864, 3180.6453, 3251.6825, 3364.7665, 3477.8506, 3576.9190, 3690.0031, 3791.0507, 3904.1348, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"AFTYSMGLILAMMNTYAWPHFCTFPDMDYNYLK", {72.0444, 219.1128, 320.1605, 483.2238, 570.2558, 701.2963, 758.3178, 871.4019, 984.4859, 1097.5700, 1168.6071, 1299.6476, 1430.6881, 1544.7310, 1645.7787, 1808.8420, 1879.8791, 2065.9584, 2163.0112, 2300.0701, 2447.1385, 2607.1692, 2708.2168, 2855.2853, 2952.3380, 3067.3650, 3198.4054, 3313.4324, 3476.4957, 3590.5386, 3753.6020, 3866.6860, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 423.2602, 537.3031, 700.3665, 815.3934, 946.4339, 1061.4608, 1158.5136, 1305.5820, 1406.6297, 1566.6603, 1713.7287, 1850.7877, 1947.8404, 2133.9197, 2204.9568, 2368.0202, 2469.0679, 2583.1108, 2714.1513, 2845.1917, 2916.2289, 3029.3129, 3142.3970, 3255.4811, 3312.5025, 3443.5430, 3530.5750, 3693.6384, 3794.6860, 3941.7545, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"GTPLHNFLPYCVAFFLGVWFLLYAPSYYWELQK", {58.0287, 159.0764, 256.1292, 369.2132, 506.2722, 620.3151, 767.3835, 880.4676, 977.5203, 1140.5837, 1300.6143, 1399.6827, 1470.7198, 1617.7882, 1764.8567, 1877.9407, 1934.9622, 2034.0306, 2220.1099, 2367.1783, 2480.2624, 2593.3465, 2756.4098, 2827.4469, 2924.4997, 3011.5317, 3174.5950, 3337.6583, 3523.7377, 3652.7803, 3765.8643, 3893.9229, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 275.1714, 388.2554, 517.2980, 703.3774, 866.4407, 1029.5040, 1116.5360, 1213.5888, 1284.6259, 1447.6892, 1560.7733, 1673.8574, 1820.9258, 2007.0051, 2106.0735, 2163.0950, 2276.1790, 2423.2475, 2570.3159, 2641.3530, 2740.4214, 2900.4520, 3063.5154, 3160.5681, 3273.6522, 3420.7206, 3534.7635, 3671.8225, 3784.9065, 3881.9593, 3983.0070, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PILILIFMHFLYAHYIFPIIQFVILVLSWLYGR", {98.0600, 211.1441, 324.2282, 437.3122, 550.3963, 663.4804, 810.5488, 941.5893, 1078.6482, 1225.7166, 1338.8006, 1501.8640, 1572.9011, 1709.9600, 1873.0233, 1986.1074, 2133.1758, 2230.2286, 2343.3126, 2456.3967, 2584.4553, 2731.5237, 2830.5921, 2943.6762, 3056.7602, 3155.8286, 3268.9127, 3355.9447, 3542.0241, 3655.1081, 3818.1714, 3875.1929, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 232.1404, 395.2037, 508.2878, 694.3671, 781.3991, 894.4832, 993.5516, 1106.6357, 1219.7198, 1318.7882, 1465.8566, 1593.9152, 1706.9992, 1820.0833, 1917.1361, 2064.2045, 2177.2885, 2340.3519, 2477.4108, 2548.4479, 2711.5112, 2824.5953, 2971.6637, 3108.7226, 3239.7631, 3386.8315, 3499.9156, 3612.9996, 3726.0837, 3839.1678, 3952.2518, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ETLFSPQGYHEVAVCVTNLFVLVIVFWYFWQTK", {130.0499, 231.0975, 344.1816, 491.2500, 578.2821, 675.3348, 803.3934, 860.4149, 1023.4782, 1160.5371, 1289.5797, 1388.6481, 1459.6852, 1558.7536, 1718.7843, 1817.8527, 1918.9004, 2032.9433, 2146.0274, 2293.0958, 2392.1642, 2505.2483, 2604.3167, 2717.4007, 2816.4692, 2963.5376, 3149.6169, 3312.6802, 3459.7486, 3645.8279, 3773.8865, 3874.9342, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 248.1605, 376.2191, 562.2984, 709.3668, 872.4301, 1058.5094, 1205.5778, 1304.6463, 1417.7303, 1516.7987, 1629.8828, 1728.9512, 1876.0196, 1989.1037, 2103.1466, 2204.1943, 2303.2627, 2463.2934, 2562.3618, 2633.3989, 2732.4673, 2861.5099, 2998.5688, 3161.6321, 3218.6536, 3346.7122, 3443.7649, 3530.7970, 3677.8654, 3790.9494, 3891.9971, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DEYQDDQEDDEEELHEGNEQQESNGLNNEYIQR", {116.0342, 245.0768, 408.1401, 536.1987, 651.2257, 766.2526, 894.3112, 1023.3538, 1138.3807, 1253.4077, 1382.4503, 1511.4928, 1640.5354, 1753.6195, 1890.6784, 2019.7210, 2076.7425, 2190.7854, 2319.8280, 2447.8866, 2575.9451, 2704.9877, 2792.0198, 2906.0627, 2963.0842, 3076.1682, 3190.2112, 3304.2541, 3433.2967, 3596.3600, 3709.4441, 3837.5026, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 416.2616, 579.3249, 708.3675, 822.4104, 936.4534, 1049.5374, 1106.5589, 1220.6018, 1307.6339, 1436.6764, 1564.7350, 1692.7936, 1821.8362, 1935.8791, 1992.9006, 2121.9432, 2259.0021, 2372.0862, 2501.1287, 2630.1713, 2759.2139, 2874.2409, 2989.2678, 3118.3104, 3246.3690, 3361.3959, 3476.4229, 3604.4815, 3767.5448, 3896.5874, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EENLNSTNVVCPQDTENEYLELDWEMFWSGIVR", {130.0499, 259.0925, 373.1354, 486.2195, 600.2624, 687.2944, 788.3421, 902.3850, 1001.4534, 1100.5218, 1260.5525, 1357.6053, 1485.6638, 1600.6908, 1701.7385, 1830.7810, 1944.8240, 2073.8666, 2236.9299, 2350.0140, 2479.0566, 2592.1406, 2707.1676, 2893.2469, 3022.2895, 3153.3300, 3300.3984, 3486.4777, 3573.5097, 3630.5312, 3743.6152, 3842.6836, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 274.1874, 387.2714, 444.2929, 531.3249, 717.4042, 864.4726, 995.5131, 1124.5557, 1310.6350, 1425.6620, 1538.7460, 1667.7886, 1780.8727, 1943.9360, 2072.9786, 2187.0216, 2316.0641, 2417.1118, 2532.1388, 2660.1973, 2757.2501, 2917.2808, 3016.3492, 3115.4176, 3229.4605, 3330.5082, 3417.5402, 3531.5831, 3644.6672, 3758.7101, 3887.7527, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DICEGGNQCPNSECENYEFNCLEGAFGPQCFCR", {116.0342, 229.1183, 389.1489, 518.1915, 575.2130, 632.2345, 746.2774, 874.3360, 1034.3666, 1131.4194, 1245.4623, 1332.4943, 1461.5369, 1621.5676, 1750.6102, 1864.6531, 2027.7164, 2156.7590, 2303.8274, 2417.8704, 2577.9010, 2690.9851, 2820.0277, 2877.0491, 2948.0862, 3095.1546, 3152.1761, 3249.2289, 3377.2875, 3537.3181, 3684.3865, 3844.4172, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 335.1496, 482.2180, 642.2487, 770.3072, 867.3600, 924.3815, 1071.4499, 1142.4870, 1199.5085, 1328.5511, 1441.6351, 1601.6658, 1715.7087, 1862.7771, 1991.8197, 2154.8830, 2268.9260, 2397.9685, 2557.9992, 2687.0418, 2774.0738, 2888.1167, 2985.1695, 3145.2002, 3273.2587, 3387.3017, 3444.3231, 3501.3446, 3630.3872, 3790.4178, 3903.5019, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DLQQHQMQYQEMEYDQHHQMLTAMDMELAPTAR", {116.0342, 229.1183, 357.1769, 485.2354, 622.2944, 750.3529, 881.3934, 1009.4520, 1172.5153, 1300.5739, 1429.6165, 1560.6570, 1689.6996, 1852.7629, 1967.7898, 2095.8484, 2232.9073, 2369.9662, 2498.0248, 2629.0653, 2742.1494, 2843.1970, 2914.2342, 3045.2746, 3160.3016, 3291.3421, 3420.3847, 3533.4687, 3604.5058, 3701.5586, 3802.6063, 3873.6434, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 246.1561, 347.2037, 444.2565, 515.2936, 628.3777, 757.4203, 888.4608, 1003.4877, 1134.5282, 1205.5653, 1306.6130, 1419.6970, 1550.7375, 1678.7961, 1815.8550, 1952.9139, 2080.9725, 2195.9995, 2359.0628, 2488.1054, 2619.1459, 2748.1885, 2876.2470, 3039.3104, 3167.3689, 3298.4094, 3426.4680, 3563.5269, 3691.5855, 3819.6441, 3932.7281, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"AVLVTHLYFGECLMWSYNSLLFYHLTIHLAVCR", {72.0444, 171.1128, 284.1969, 383.2653, 484.3130, 621.3719, 734.4559, 897.5193, 1044.5877, 1101.6091, 1230.6517, 1390.6824, 1503.7664, 1634.8069, 1820.8862, 1907.9183, 2070.9816, 2185.0245, 2272.0566, 2385.1406, 2498.2247, 2645.2931, 2808.3564, 2945.4153, 3058.4994, 3159.5471, 3272.6311, 3409.6901, 3522.7741, 3593.8112, 3692.8797, 3852.9103, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 335.1496, 434.2180, 505.2551, 618.3392, 755.3981, 868.4822, 969.5298, 1082.6139, 1219.6728, 1382.7362, 1529.8046, 1642.8886, 1755.9727, 1843.0047, 1957.0476, 2120.1110, 2207.1430, 2393.2223, 2524.2628, 2637.3469, 2797.3775, 2926.4201, 2983.4416, 3130.5100, 3293.5733, 3406.6574, 3543.7163, 3644.7640, 3743.8324, 3856.9164, 3955.9849, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LLWIEPVICNFYQNLFLLSPGLLSWDLYEMEAK", {114.0913, 227.1754, 413.2547, 526.3388, 655.3814, 752.4341, 851.5026, 964.5866, 1124.6173, 1238.6602, 1385.7286, 1548.7919, 1676.8505, 1790.8934, 1903.9775, 2051.0459, 2164.1300, 2277.2140, 2364.2461, 2461.2988, 2518.3203, 2631.4044, 2744.4884, 2831.5205, 3017.5998, 3132.6267, 3245.7108, 3408.7741, 3537.8167, 3668.8572, 3797.8998, 3868.9369, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 218.1499, 347.1925, 478.2330, 607.2756, 770.3389, 883.4230, 998.4499, 1184.5292, 1271.5613, 1384.6453, 1497.7294, 1554.7509, 1651.8036, 1738.8357, 1851.9197, 1965.0038, 2112.0722, 2225.1563, 2339.1992, 2467.2578, 2630.3211, 2777.3895, 2891.4324, 3051.4631, 3164.5471, 3263.6156, 3360.6683, 3489.7109, 3602.7950, 3788.8743, 3901.9584, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QFEDTITLNQSGCLNHLACCVNVIMCCFSPEYK", {129.0659, 276.1343, 405.1769, 520.2038, 621.2515, 734.3355, 835.3832, 948.4673, 1062.5102, 1190.5688, 1277.6008, 1334.6223, 1494.6529, 1607.7370, 1721.7799, 1858.8388, 1971.9229, 2042.9600, 2202.9907, 2363.0213, 2462.0897, 2576.1327, 2675.2011, 2788.2851, 2919.3256, 3079.3563, 3239.3869, 3386.4553, 3473.4874, 3570.5401, 3699.5827, 3862.6460, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 310.1761, 439.2187, 536.2715, 623.3035, 770.3719, 930.4026, 1090.4332, 1221.4737, 1334.5578, 1433.6262, 1547.6691, 1646.7375, 1806.7682, 1966.7988, 2037.8359, 2150.9200, 2287.9789, 2402.0218, 2515.1059, 2675.1366, 2732.1580, 2819.1901, 2947.2486, 3061.2916, 3174.3756, 3275.4233, 3388.5074, 3489.5550, 3604.5820, 3733.6246, 3880.6930, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"AQEMCVESSYSETEHPHDEDEDYYEEVDEDDNK", {72.0444, 200.1030, 329.1456, 460.1860, 620.2167, 719.2851, 848.3277, 935.3597, 1022.3918, 1185.4551, 1272.4871, 1401.5297, 1502.5774, 1631.6200, 1768.6789, 1865.7317, 2002.7906, 2117.8175, 2246.8601, 2361.8870, 2490.9296, 2605.9566, 2769.0199, 2932.0832, 3061.1258, 3190.1684, 3289.2368, 3404.2638, 3533.3064, 3648.3333, 3763.3603, 3877.4032, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 261.1557, 376.1827, 491.2096, 620.2522, 735.2792, 834.3476, 963.3902, 1092.4328, 1255.4961, 1418.5594, 1533.5864, 1662.6289, 1777.6559, 1906.6985, 2021.7254, 2158.7843, 2255.8371, 2392.8960, 2521.9386, 2622.9863, 2752.0289, 2839.0609, 3002.1242, 3089.1563, 3176.1883, 3305.2309, 3404.2993, 3564.3299, 3695.3704, 3824.4130, 3952.4716, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TSAVQNNHYAYIFFLHYPLWCIAFISVIAIFMR", {102.0550, 189.0870, 260.1241, 359.1925, 487.2511, 601.2940, 715.3369, 852.3959, 1015.4592, 1086.4963, 1249.5596, 1362.6437, 1509.7121, 1656.7805, 1769.8646, 1906.9235, 2069.9868, 2167.0396, 2280.1237, 2466.2030, 2626.2336, 2739.3177, 2810.3548, 2957.4232, 3070.5073, 3157.5393, 3256.6077, 3369.6918, 3440.7289, 3553.8130, 3700.8814, 3831.9219, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 306.1594, 453.2279, 566.3119, 637.3490, 750.4331, 849.5015, 936.5335, 1049.6176, 1196.6860, 1267.7231, 1380.8072, 1540.8378, 1726.9172, 1840.0012, 1937.0540, 2100.1173, 2237.1762, 2350.2603, 2497.3287, 2644.3971, 2757.4812, 2920.5445, 2991.5816, 3154.6449, 3291.7039, 3405.7468, 3519.7897, 3647.8483, 3746.9167, 3817.9538, 3904.9858, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DDTEYNYNPDYTIYNLCLELIMPIHPNIADPCR", {116.0342, 231.0612, 332.1088, 461.1514, 624.2148, 738.2577, 901.3210, 1015.3639, 1112.4167, 1227.4437, 1390.5070, 1491.5547, 1604.6387, 1767.7021, 1881.7450, 1994.8290, 2154.8597, 2267.9438, 2396.9864, 2510.0704, 2623.1545, 2754.1950, 2851.2477, 2964.3318, 3101.3907, 3198.4435, 3312.4864, 3425.5705, 3496.6076, 3611.6345, 3708.6873, 3868.7179, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 335.1496, 432.2024, 547.2293, 618.2664, 731.3505, 845.3934, 942.4462, 1079.5051, 1192.5892, 1289.6419, 1420.6824, 1533.7665, 1646.8505, 1775.8931, 1888.9772, 2049.0078, 2162.0919, 2276.1348, 2439.1982, 2552.2822, 2653.3299, 2816.3932, 2931.4202, 3028.4729, 3142.5159, 3305.5792, 3419.6221, 3582.6854, 3711.7280, 3812.7757, 3927.8027, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EYHPYQLDTQVETHNLVIQLTPQSNNQPFLDYR", {130.0499, 293.1132, 430.1721, 527.2249, 690.2882, 818.3468, 931.4308, 1046.4578, 1147.5055, 1275.5640, 1374.6325, 1503.6751, 1604.7227, 1741.7816, 1855.8246, 1968.9086, 2067.9770, 2181.0611, 2309.1197, 2422.2038, 2523.2514, 2620.3042, 2748.3628, 2835.3948, 2949.4377, 3063.4807, 3191.5392, 3288.5920, 3435.6604, 3548.7445, 3663.7714, 3826.8347, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 453.2092, 566.2933, 713.3617, 810.4145, 938.4730, 1052.5160, 1166.5589, 1253.5909, 1381.6495, 1478.7023, 1579.7499, 1692.8340, 1820.8926, 1933.9767, 2033.0451, 2146.1291, 2260.1721, 2397.2310, 2498.2786, 2627.3212, 2726.3897, 2854.4482, 2955.4959, 3070.5229, 3183.6069, 3311.6655, 3474.7288, 3571.7816, 3708.8405, 3871.9038, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PIDELDQDLNPNVEPCLSMVHNHHWEFLSQYIK", {98.0600, 211.1441, 326.1710, 455.2136, 568.2977, 683.3246, 811.3832, 926.4102, 1039.4942, 1153.5372, 1250.5899, 1364.6329, 1463.7013, 1592.7439, 1689.7966, 1849.8273, 1962.9113, 2049.9434, 2180.9838, 2280.0523, 2417.1112, 2531.1541, 2668.2130, 2805.2719, 2991.3512, 3120.3938, 3267.4622, 3380.5463, 3467.5783, 3595.6369, 3758.7002, 3871.7843, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 423.2602, 551.3188, 638.3508, 751.4349, 898.5033, 1027.5459, 1213.6252, 1350.6841, 1487.7430, 1601.7859, 1738.8448, 1837.9133, 1968.9537, 2055.9858, 2169.0698, 2329.1005, 2426.1533, 2555.1958, 2654.2643, 2768.3072, 2865.3600, 2979.4029, 3092.4869, 3207.5139, 3335.5725, 3450.5994, 3563.6835, 3692.7261, 3807.7530, 3920.8371, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PMFSHQALQVVDQIHLQQHHQQQNQQQQHQQLK", {98.0600, 229.1005, 376.1689, 463.2010, 600.2599, 728.3185, 799.3556, 912.4396, 1040.4982, 1139.5666, 1238.6350, 1353.6620, 1481.7206, 1594.8046, 1731.8635, 1844.9476, 1973.0062, 2101.0648, 2238.1237, 2375.1826, 2503.2412, 2631.2997, 2759.3583, 2873.4012, 3001.4598, 3129.5184, 3257.5770, 3385.6355, 3522.6945, 3650.7530, 3778.8116, 3891.8957, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 388.2554, 516.3140, 653.3729, 781.4315, 909.4901, 1037.5487, 1165.6072, 1279.6502, 1407.7088, 1535.7673, 1663.8259, 1800.8848, 1937.9437, 2066.0023, 2194.0609, 2307.1449, 2444.2039, 2557.2879, 2685.3465, 2800.3734, 2899.4419, 2998.5103, 3126.5689, 3239.6529, 3310.6900, 3438.7486, 3575.8075, 3662.8395, 3809.9080, 3940.9484, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LLVLDDAVVDSVHLYIIWYMLNFCVFCVPFVIR", {114.0913, 227.1754, 326.2438, 439.3279, 554.3548, 669.3818, 740.4189, 839.4873, 938.5557, 1053.5827, 1140.6147, 1239.6831, 1376.7420, 1489.8261, 1652.8894, 1765.9735, 1879.0575, 2065.1368, 2228.2002, 2359.2407, 2472.3247, 2586.3676, 2733.4361, 2893.4667, 2992.5351, 3139.6035, 3299.6342, 3398.7026, 3495.7554, 3642.8238, 3741.8922, 3854.9763, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 387.2714, 534.3398, 631.3926, 730.4610, 890.4917, 1037.5601, 1136.6285, 1296.6591, 1443.7276, 1557.7705, 1670.8546, 1801.8950, 1964.9584, 2151.0377, 2264.1217, 2377.2058, 2540.2691, 2653.3532, 2790.4121, 2889.4805, 2976.5126, 3091.5395, 3190.6079, 3289.6763, 3360.7134, 3475.7404, 3590.7673, 3703.8514, 3802.9198, 3916.0039, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LFCCYSMLMFLMVWVIVTGAIWGVSWYADAWEK", {114.0913, 261.1598, 421.1904, 581.2211, 744.2844, 831.3164, 962.3569, 1075.4410, 1206.4814, 1353.5499, 1466.6339, 1597.6744, 1696.7428, 1882.8221, 1981.8905, 2094.9746, 2194.0430, 2295.0907, 2352.1122, 2423.1493, 2536.2333, 2722.3127, 2779.3341, 2878.4025, 2965.4346, 3151.5139, 3314.5772, 3385.6143, 3500.6413, 3571.6784, 3757.7577, 3886.8003, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 276.1554, 462.2347, 533.2718, 648.2988, 719.3359, 882.3992, 1068.4785, 1155.5106, 1254.5790, 1311.6004, 1497.6797, 1610.7638, 1681.8009, 1738.8224, 1839.8701, 1938.9385, 2052.0225, 2151.0910, 2337.1703, 2436.2387, 2567.2792, 2680.3632, 2827.4316, 2958.4721, 3071.5562, 3202.5967, 3289.6287, 3452.6920, 3612.7227, 3772.7533, 3919.8217, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ICHASTLVFWQNILSGACLFYTPTHLFAMWPYR", {114.0913, 274.1220, 411.1809, 482.2180, 569.2500, 670.2977, 783.3818, 882.4502, 1029.5186, 1215.5979, 1343.6565, 1457.6994, 1570.7835, 1683.8676, 1770.8996, 1827.9211, 1898.9582, 2058.9888, 2172.0729, 2319.1413, 2482.2046, 2583.2523, 2680.3051, 2781.3527, 2918.4117, 3031.4957, 3178.5641, 3249.6012, 3380.6417, 3566.7210, 3663.7738, 3826.8371, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 435.2350, 621.3144, 752.3548, 823.3920, 970.4604, 1083.5444, 1220.6033, 1321.6510, 1418.7038, 1519.7515, 1682.8148, 1829.8832, 1942.9673, 2102.9979, 2174.0350, 2231.0565, 2318.0885, 2431.1726, 2544.2567, 2658.2996, 2786.3582, 2972.4375, 3119.5059, 3218.5743, 3331.6584, 3432.7060, 3519.7381, 3590.7752, 3727.8341, 3887.8647, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ANLQQSVDVGDEDEFADDIHPHQHQQYHYQQYR", {72.0444, 186.0873, 299.1714, 427.2300, 555.2885, 642.3206, 741.3890, 856.4159, 955.4843, 1012.5058, 1127.5327, 1256.5753, 1371.6023, 1500.6449, 1647.7133, 1718.7504, 1833.7773, 1948.8043, 2061.8884, 2198.9473, 2296.0000, 2433.0589, 2561.1175, 2698.1764, 2826.2350, 2954.2936, 3117.3569, 3254.4158, 3417.4792, 3545.5377, 3673.5963, 3836.6596, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 466.2409, 594.2994, 757.3628, 894.4217, 1057.4850, 1185.5436, 1313.6022, 1450.6611, 1578.7196, 1715.7786, 1812.8313, 1949.8902, 2062.9743, 2178.0012, 2293.0282, 2364.0653, 2511.1337, 2640.1763, 2755.2033, 2884.2458, 2999.2728, 3056.2943, 3155.3627, 3270.3896, 3369.4580, 3456.4901, 3584.5486, 3712.6072, 3825.6913, 3939.7342, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ALFYDICILLGSWFDVYAVDYPLFDLTYLDEIR", {72.0444, 185.1285, 332.1969, 495.2602, 610.2871, 723.3712, 883.4019, 996.4859, 1109.5700, 1222.6540, 1279.6755, 1366.7075, 1552.7868, 1699.8553, 1814.8822, 1913.9506, 2077.0139, 2148.0511, 2247.1195, 2362.1464, 2525.2097, 2622.2625, 2735.3466, 2882.4150, 2997.4419, 3110.5260, 3211.5737, 3374.6370, 3487.7211, 3602.7480, 3731.7906, 3844.8747, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 417.2456, 532.2726, 645.3566, 808.4199, 909.4676, 1022.5517, 1137.5786, 1284.6470, 1397.7311, 1494.7839, 1657.8472, 1772.8741, 1871.9426, 1942.9797, 2106.0430, 2205.1114, 2320.1384, 2467.2068, 2653.2861, 2740.3181, 2797.3396, 2910.4236, 3023.5077, 3136.5918, 3296.6224, 3409.7065, 3524.7334, 3687.7968, 3834.8652, 3947.9492, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PHQLQQHPHPQQQPPHQLQHQHQHHHHLPPPPK", {98.0600, 235.1190, 363.1775, 476.2616, 604.3202, 732.3787, 869.4377, 966.4904, 1103.5493, 1200.6021, 1328.6607, 1456.7193, 1584.7778, 1681.8306, 1778.8834, 1915.9423, 2044.0009, 2157.0849, 2285.1435, 2422.2024, 2550.2610, 2687.3199, 2815.3785, 2952.4374, 3089.4963, 3226.5552, 3363.6141, 3476.6982, 3573.7509, 3670.8037, 3767.8565, 3864.9092, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 244.1656, 341.2183, 438.2711, 535.3239, 648.4079, 785.4668, 922.5257, 1059.5847, 1196.6436, 1324.7021, 1461.7611, 1589.8196, 1726.8786, 1854.9371, 1968.0212, 2096.0798, 2233.1387, 2330.1914, 2427.2442, 2555.3028, 2683.3614, 2811.4199, 2908.4727, 3045.5316, 3142.5844, 3279.6433, 3407.7019, 3535.7604, 3648.8445, 3776.9031, 3913.9620, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EQPADHMQIQQMQEQYQQYTLQQESVPAPPLYR", {130.0499, 258.1084, 355.1612, 426.1983, 541.2253, 678.2842, 809.3247, 937.3832, 1050.4673, 1178.5259, 1306.5845, 1437.6249, 1565.6835, 1694.7261, 1822.7847, 1985.8480, 2113.9066, 2241.9652, 2405.0285, 2506.0762, 2619.1602, 2747.2188, 2875.2774, 3004.3200, 3091.3520, 3190.4204, 3287.4732, 3358.5103, 3455.5631, 3552.6158, 3665.6999, 3828.7632, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 451.2663, 548.3191, 645.3719, 716.4090, 813.4618, 912.5302, 999.5622, 1128.6048, 1256.6634, 1384.7219, 1497.8060, 1598.8537, 1761.9170, 1889.9756, 2018.0342, 2181.0975, 2309.1561, 2438.1987, 2566.2572, 2697.2977, 2825.3563, 2953.4149, 3066.4989, 3194.5575, 3325.5980, 3462.6569, 3577.6839, 3648.7210, 3745.7737, 3873.8323, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DCQVDHDPEQEQEQEQDQEQDEEQDDDGHSKPR", {116.0342, 276.0649, 404.1234, 503.1919, 618.2188, 755.2777, 870.3047, 967.3574, 1096.4000, 1224.4586, 1353.5012, 1481.5598, 1610.6024, 1738.6609, 1867.7035, 1995.7621, 2110.7890, 2238.8476, 2367.8902, 2495.9488, 2610.9757, 2740.0183, 2869.0609, 2997.1195, 3112.1464, 3227.1734, 3342.2003, 3399.2218, 3536.2807, 3623.3127, 3751.4077, 3848.4605, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 272.1717, 400.2667, 487.2987, 624.3576, 681.3791, 796.4060, 911.4330, 1026.4599, 1154.5185, 1283.5611, 1412.6037, 1527.6306, 1655.6892, 1784.7318, 1912.7904, 2027.8173, 2155.8759, 2284.9185, 2412.9771, 2542.0197, 2670.0782, 2799.1208, 2927.1794, 3056.2220, 3153.2748, 3268.3017, 3405.3606, 3520.3876, 3619.4560, 3747.5145, 3907.5452, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"CADGCPTQTSLFHFEVHEDMDYTSLTSNWHFIR", {161.0379, 232.0750, 347.1020, 404.1234, 564.1541, 661.2069, 762.2545, 890.3131, 991.3608, 1078.3928, 1191.4769, 1338.5453, 1475.6042, 1622.6726, 1751.7152, 1850.7836, 1987.8425, 2116.8851, 2231.9121, 2362.9526, 2477.9795, 2641.0428, 2742.0905, 2829.1225, 2942.2066, 3043.2543, 3130.2863, 3244.3292, 3430.4086, 3567.4675, 3714.5359, 3827.6199, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 435.2714, 572.3303, 758.4097, 872.4526, 959.4846, 1060.5323, 1173.6164, 1260.6484, 1361.6961, 1524.7594, 1639.7863, 1770.8268, 1885.8538, 2014.8964, 2151.9553, 2251.0237, 2380.0663, 2527.1347, 2664.1936, 2811.2620, 2924.3461, 3011.3781, 3112.4258, 3240.4844, 3341.5320, 3438.5848, 3598.6155, 3655.6369, 3770.6639, 3841.7010, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LVLVTYAAIFIFIHWFGHLYPFNISSWAECFIR", {114.0913, 213.1598, 326.2438, 425.3122, 526.3599, 689.4232, 760.4604, 831.4975, 944.5815, 1091.6499, 1204.7340, 1351.8024, 1464.8865, 1601.9454, 1788.0247, 1935.0931, 1992.1146, 2129.1735, 2242.2576, 2405.3209, 2502.3737, 2649.4421, 2763.4850, 2876.5691, 2963.6011, 3050.6331, 3236.7124, 3307.7495, 3436.7921, 3596.8228, 3743.8912, 3856.9753, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 435.2714, 595.3021, 724.3447, 795.3818, 981.4611, 1068.4931, 1155.5252, 1268.6092, 1382.6521, 1529.7206, 1626.7733, 1789.8367, 1902.9207, 2039.9796, 2097.0011, 2244.0695, 2430.1488, 2567.2077, 2680.2918, 2827.3602, 2940.4443, 3087.5127, 3200.5968, 3271.6339, 3342.6710, 3505.7343, 3606.7820, 3705.8504, 3818.9345, 3918.0029, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VIQNPPSCVVIIEDDYDEEEEIEQVFYNSNMMR", {100.0757, 213.1598, 341.2183, 455.2613, 552.3140, 649.3668, 736.3988, 896.4295, 995.4979, 1094.5663, 1207.6504, 1320.7344, 1449.7770, 1564.8040, 1679.8309, 1842.8942, 1957.9212, 2086.9638, 2216.0064, 2345.0490, 2474.0915, 2587.1756, 2716.2182, 2844.2768, 2943.3452, 3090.4136, 3253.4769, 3367.5199, 3454.5519, 3568.5948, 3699.6353, 3830.6758, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 306.1594, 437.1999, 551.2428, 638.2749, 752.3178, 915.3811, 1062.4495, 1161.5180, 1289.5765, 1418.6191, 1531.7032, 1660.7458, 1789.7884, 1918.8310, 2047.8736, 2162.9005, 2325.9638, 2440.9908, 2556.0177, 2685.0603, 2798.1444, 2911.2284, 3010.2969, 3109.3653, 3269.3959, 3356.4280, 3453.4807, 3550.5335, 3664.5764, 3792.6350, 3905.7190, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LLQEYSMHPILFHALRPDHLLHFPVHEWSLSLK", {114.0913, 227.1754, 355.2340, 484.2766, 647.3399, 734.3719, 865.4124, 1002.4713, 1099.5241, 1212.6082, 1325.6922, 1472.7606, 1609.8195, 1680.8567, 1793.9407, 1950.0418, 2047.0946, 2162.1215, 2299.1805, 2412.2645, 2525.3486, 2662.4075, 2809.4759, 2906.5287, 3005.5971, 3142.6560, 3271.6986, 3457.7779, 3544.8099, 3657.8940, 3744.9260, 3858.0101, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 347.2289, 460.3130, 547.3450, 733.4243, 862.4669, 999.5258, 1098.5942, 1195.6470, 1342.7154, 1479.7743, 1592.8584, 1705.9424, 1843.0014, 1958.0283, 2055.0811, 2211.1822, 2324.2662, 2395.3033, 2532.3623, 2679.4307, 2792.5147, 2905.5988, 3002.6516, 3139.7105, 3270.7510, 3357.7830, 3520.8463, 3649.8889, 3777.9475, 3891.0316, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MVFDDNVEIFIDKPSNSWYSPDQQIVQWLFLTK", {132.0478, 231.1162, 378.1846, 493.2115, 608.2385, 722.2814, 821.3498, 950.3924, 1063.4765, 1210.5449, 1323.6290, 1438.6559, 1566.7509, 1663.8036, 1750.8357, 1864.8786, 1951.9106, 2137.9899, 2301.0532, 2388.0853, 2485.1380, 2600.1650, 2728.2236, 2856.2821, 2969.3662, 3068.4346, 3196.4932, 3382.5725, 3495.6566, 3642.7250, 3755.8090, 3856.8567, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 248.1605, 361.2445, 508.3130, 621.3970, 807.4763, 935.5349, 1034.6033, 1147.6874, 1275.7460, 1403.8045, 1518.8315, 1615.8843, 1702.9163, 1865.9796, 2052.0589, 2139.0910, 2253.1339, 2340.1659, 2437.2187, 2565.3136, 2680.3406, 2793.4246, 2940.4931, 3053.5771, 3182.6197, 3281.6881, 3395.7311, 3510.7580, 3625.7849, 3772.8534, 3871.9218, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PEDHWLFSCGQFEIELWENVFASYDDLPPAYDK", {98.0600, 227.1026, 342.1296, 479.1885, 665.2678, 778.3519, 925.4203, 1012.4523, 1172.4830, 1229.5044, 1357.5630, 1504.6314, 1633.6740, 1746.7581, 1875.8007, 1988.8847, 2174.9640, 2304.0066, 2418.0496, 2517.1180, 2664.1864, 2735.2235, 2822.2555, 2985.3189, 3100.3458, 3215.3727, 3328.4568, 3425.5096, 3522.5623, 3593.5994, 3756.6628, 3871.6897, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 262.1397, 425.2031, 496.2402, 593.2930, 690.3457, 803.4298, 918.4567, 1033.4837, 1196.5470, 1283.5790, 1354.6161, 1501.6846, 1600.7530, 1714.7959, 1843.8385, 2029.9178, 2143.0019, 2272.0445, 2385.1285, 2514.1711, 2661.2395, 2789.2981, 2846.3196, 3006.3502, 3093.3822, 3240.4507, 3353.5347, 3539.6140, 3676.6729, 3791.6999, 3920.7425, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LQQQLYQQQQLQLQQLQQLQQQHQQSLDLVSSK", {114.0913, 242.1499, 370.2085, 498.2671, 611.3511, 774.4145, 902.4730, 1030.5316, 1158.5902, 1286.6488, 1399.7328, 1527.7914, 1640.8755, 1768.9341, 1896.9926, 2010.0767, 2138.1353, 2266.1939, 2379.2779, 2507.3365, 2635.3951, 2763.4537, 2900.5126, 3028.5711, 3156.6297, 3243.6617, 3356.7458, 3471.7728, 3584.8568, 3683.9252, 3770.9573, 3857.9893, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 234.1448, 321.1769, 420.2453, 533.3293, 648.3563, 761.4403, 848.4724, 976.5310, 1104.5895, 1241.6484, 1369.7070, 1497.7656, 1625.8242, 1738.9082, 1866.9668, 1995.0254, 2108.1095, 2236.1680, 2364.2266, 2477.3107, 2605.3693, 2718.4533, 2846.5119, 2974.5705, 3102.6291, 3230.6876, 3393.7510, 3506.8350, 3634.8936, 3762.9522, 3891.0108, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LNSPPDPATTITVTWTLWDHHTFNTYYLWFNYK", {114.0913, 228.1343, 315.1663, 412.2191, 509.2718, 624.2988, 721.3515, 792.3886, 893.4363, 994.4840, 1107.5681, 1208.6157, 1307.6842, 1408.7318, 1594.8111, 1695.8588, 1808.9429, 1995.0222, 2110.0491, 2247.1081, 2384.1670, 2485.2147, 2632.2831, 2746.3260, 2847.3737, 3010.4370, 3173.5003, 3286.5844, 3472.6637, 3619.7321, 3733.7750, 3896.8384, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 310.1761, 424.2191, 571.2875, 757.3668, 870.4509, 1033.5142, 1196.5775, 1297.6252, 1411.6681, 1558.7365, 1659.7842, 1796.8431, 1933.9020, 2048.9290, 2235.0083, 2348.0924, 2449.1400, 2635.2193, 2736.2670, 2835.3354, 2936.3831, 3049.4672, 3150.5149, 3251.5625, 3322.5996, 3419.6524, 3534.6794, 3631.7321, 3728.7849, 3815.8169, 3929.8598, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ANQDVHHPQYYNGHAPPVTQNCYICQCGHINCR", {72.0444, 186.0873, 314.1459, 429.1728, 528.2413, 665.3002, 802.3591, 899.4118, 1027.4704, 1190.5337, 1353.5971, 1467.6400, 1524.6615, 1661.7204, 1732.7575, 1829.8103, 1926.8630, 2025.9314, 2126.9791, 2255.0377, 2369.0806, 2529.1113, 2692.1746, 2805.2587, 2965.2893, 3093.3479, 3253.3785, 3310.4000, 3447.4589, 3560.5430, 3674.5859, 3834.6165, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 335.1496, 449.1925, 562.2766, 699.3355, 756.3570, 916.3876, 1044.4462, 1204.4768, 1317.5609, 1480.6242, 1640.6549, 1754.6978, 1882.7564, 1983.8041, 2082.8725, 2179.9252, 2276.9780, 2348.0151, 2485.0740, 2542.0955, 2656.1384, 2819.2018, 2982.2651, 3110.3237, 3207.3764, 3344.4353, 3481.4942, 3580.5627, 3695.5896, 3823.6482, 3937.6911, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QNVQNYTCYCCNPVPHSTNYYTQDSIPQTNSHR", {129.0659, 243.1088, 342.1772, 470.2358, 584.2787, 747.3420, 848.3897, 1008.4204, 1171.4837, 1331.5143, 1491.5450, 1605.5879, 1702.6407, 1801.7091, 1898.7619, 2035.8208, 2122.8528, 2223.9005, 2337.9434, 2501.0067, 2664.0701, 2765.1177, 2893.1763, 3008.2033, 3095.2353, 3208.3193, 3305.3721, 3433.4307, 3534.4784, 3648.5213, 3735.5533, 3872.6122, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 312.1779, 399.2099, 513.2528, 614.3005, 742.3591, 839.4118, 952.4959, 1039.5279, 1154.5549, 1282.6135, 1383.6611, 1546.7245, 1709.7878, 1823.8307, 1924.8784, 2011.9104, 2148.9693, 2246.0221, 2345.0905, 2442.1433, 2556.1862, 2716.2169, 2876.2475, 3039.3108, 3199.3415, 3300.3892, 3463.4525, 3577.4954, 3705.5540, 3804.6224, 3918.6653, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LILSECVNQLSEIFYQDCITIMNYLFTELYGQK", {114.0913, 227.1754, 340.2595, 427.2915, 556.3341, 716.3647, 815.4332, 929.4761, 1057.5347, 1170.6187, 1257.6508, 1386.6933, 1499.7774, 1646.8458, 1809.9091, 1937.9677, 2052.9947, 2213.0253, 2326.1094, 2427.1571, 2540.2411, 2671.2816, 2785.3245, 2948.3879, 3061.4719, 3208.5403, 3309.5880, 3438.6306, 3551.7147, 3714.7780, 3771.7995, 3899.8580, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 275.1714, 332.1928, 495.2562, 608.3402, 737.3828, 838.4305, 985.4989, 1098.5830, 1261.6463, 1375.6892, 1506.7297, 1619.8138, 1720.8615, 1833.9455, 1993.9762, 2109.0031, 2237.0617, 2400.1250, 2547.1934, 2660.2775, 2789.3201, 2876.3521, 2989.4362, 3117.4948, 3231.5377, 3330.6061, 3490.6368, 3619.6794, 3706.7114, 3819.7954, 3932.8795, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TSLGQINVFDSAFPAYHYPFYWNWSACGQYYYK", {102.0550, 189.0870, 302.1710, 359.1925, 487.2511, 600.3352, 714.3781, 813.4465, 960.5149, 1075.5419, 1162.5739, 1233.6110, 1380.6794, 1477.7322, 1548.7693, 1711.8326, 1848.8915, 2011.9549, 2109.0076, 2256.0760, 2419.1394, 2605.2187, 2719.2616, 2905.3409, 2992.3729, 3063.4101, 3223.4407, 3280.4622, 3408.5207, 3571.5841, 3734.6474, 3897.7107, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 310.1761, 473.2395, 636.3028, 764.3614, 821.3828, 981.4135, 1052.4506, 1139.4826, 1325.5619, 1439.6049, 1625.6842, 1788.7475, 1935.8159, 2032.8687, 2195.9320, 2332.9909, 2496.0543, 2567.0914, 2664.1441, 2811.2125, 2882.2497, 2969.2817, 3084.3086, 3231.3770, 3330.4455, 3444.4884, 3557.5724, 3685.6310, 3742.6525, 3855.7366, 3942.7686, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YMPNTYVDEEQHFDEPSYSSYMSMTMSQEEVQK", {164.0706, 295.1111, 392.1639, 506.2068, 607.2545, 770.3178, 869.3862, 984.4131, 1113.4557, 1242.4983, 1370.5569, 1507.6158, 1654.6842, 1769.7112, 1898.7538, 1995.8065, 2082.8386, 2245.9019, 2332.9339, 2419.9659, 2583.0293, 2714.0698, 2801.1018, 2932.1423, 3033.1900, 3164.2304, 3251.2625, 3379.3210, 3508.3636, 3637.4062, 3736.4746, 3864.5332, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 275.1714, 374.2398, 503.2824, 632.3250, 760.3836, 847.4156, 978.4561, 1079.5038, 1210.5442, 1297.5763, 1428.6167, 1591.6801, 1678.7121, 1765.7441, 1928.8075, 2015.8395, 2112.8923, 2241.9348, 2356.9618, 2504.0302, 2641.0891, 2769.1477, 2898.1903, 3027.2329, 3142.2598, 3241.3282, 3404.3916, 3505.4392, 3619.4822, 3716.5349, 3847.5754, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EYCCDGIVDPMIGFFALEEDYSTLCEHKPYHLK", {130.0499, 293.1132, 453.1438, 613.1745, 728.2014, 785.2229, 898.3070, 997.3754, 1112.4023, 1209.4551, 1340.4956, 1453.5796, 1510.6011, 1657.6695, 1804.7379, 1875.7750, 1988.8591, 2117.9017, 2246.9443, 2361.9712, 2525.0346, 2612.0666, 2713.1143, 2826.1983, 2986.2290, 3115.2716, 3252.3305, 3380.4255, 3477.4782, 3640.5415, 3777.6005, 3890.6845, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 397.2558, 560.3191, 657.3719, 785.4668, 922.5257, 1051.5683, 1211.5990, 1324.6831, 1425.7307, 1512.7628, 1675.8261, 1790.8530, 1919.8956, 2048.9382, 2162.0223, 2233.0594, 2380.1278, 2527.1962, 2584.2177, 2697.3018, 2828.3422, 2925.3950, 3040.4219, 3139.4904, 3252.5744, 3309.5959, 3424.6228, 3584.6535, 3744.6841, 3907.7475, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QPVVLQNSQIYLIEFLHWLCEAAYFVVIADCLR", {129.0659, 226.1186, 325.1870, 424.2554, 537.3395, 665.3981, 779.4410, 866.4730, 994.5316, 1107.6157, 1270.6790, 1383.7631, 1496.8471, 1625.8897, 1772.9581, 1886.0422, 2023.1011, 2209.1804, 2322.2645, 2482.2951, 2611.3377, 2682.3749, 2753.4120, 2916.4753, 3063.5437, 3162.6121, 3261.6805, 3374.7646, 3445.8017, 3560.8287, 3720.8593, 3833.9434, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 448.2337, 563.2606, 634.2977, 747.3818, 846.4502, 945.5186, 1092.5870, 1255.6504, 1326.6875, 1397.7246, 1526.7672, 1686.7978, 1799.8819, 1985.9612, 2123.0201, 2236.1042, 2383.1726, 2512.2152, 2625.2992, 2738.3833, 2901.4466, 3014.5307, 3142.5893, 3229.6213, 3343.6642, 3471.7228, 3584.8069, 3683.8753, 3782.9437, 3879.9965, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QQSPPPPHHQHQQQQHHHQHQQQQHHHAALPMR", {129.0659, 257.1244, 344.1565, 441.2092, 538.2620, 635.3148, 732.3675, 869.4264, 1006.4853, 1134.5439, 1271.6028, 1399.6614, 1527.7200, 1655.7786, 1783.8371, 1920.8961, 2057.9550, 2195.0139, 2323.0725, 2460.1314, 2588.1899, 2716.2485, 2844.3071, 2972.3657, 3109.4246, 3246.4835, 3383.5424, 3454.5795, 3525.6166, 3638.7007, 3735.7535, 3866.7939, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 306.1594, 403.2122, 516.2963, 587.3334, 658.3705, 795.4294, 932.4883, 1069.5472, 1197.6058, 1325.6644, 1453.7230, 1581.7815, 1718.8405, 1846.8990, 1983.9579, 2121.0169, 2258.0758, 2386.1343, 2514.1929, 2642.2515, 2770.3101, 2907.3690, 3035.4276, 3172.4865, 3309.5454, 3406.5982, 3503.6509, 3600.7037, 3697.7564, 3784.7885, 3912.8470, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TEIIITEELELEENDYIVEPVLEDEDECVLHQR", {102.0550, 231.0975, 344.1816, 457.2657, 570.3497, 671.3974, 800.4400, 929.4826, 1042.5667, 1171.6093, 1284.6933, 1413.7359, 1542.7785, 1656.8214, 1771.8484, 1934.9117, 2047.9958, 2147.0642, 2276.1068, 2373.1595, 2472.2280, 2585.3120, 2714.3546, 2829.3816, 2958.4242, 3073.4511, 3202.4937, 3362.5243, 3461.5928, 3574.6768, 3711.7357, 3839.7943, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 440.2364, 553.3205, 652.3889, 812.4196, 941.4622, 1056.4891, 1185.5317, 1300.5586, 1429.6012, 1542.6853, 1641.7537, 1738.8065, 1867.8491, 1966.9175, 2080.0015, 2243.0649, 2358.0918, 2472.1347, 2601.1773, 2730.2199, 2843.3040, 2972.3466, 3085.4307, 3214.4732, 3343.5158, 3444.5635, 3557.6476, 3670.7316, 3783.8157, 3912.8583, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FQVVMELYEVYLSNNEAPLLNYDETFQNYPVLR", {148.0757, 276.1343, 375.2027, 474.2711, 605.3116, 734.3542, 847.4382, 1010.5016, 1139.5442, 1238.6126, 1401.6759, 1514.7600, 1601.7920, 1715.8349, 1829.8778, 1958.9204, 2029.9576, 2127.0103, 2240.0944, 2353.1784, 2467.2214, 2630.2847, 2745.3116, 2874.3542, 2975.4019, 3122.4703, 3250.5289, 3364.5718, 3527.6352, 3624.6879, 3723.7563, 3836.8404, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 387.2714, 484.3242, 647.3875, 761.4305, 889.4890, 1036.5574, 1137.6051, 1266.6477, 1381.6747, 1544.7380, 1658.7809, 1771.8650, 1884.9490, 1982.0018, 2053.0389, 2182.0815, 2296.1244, 2410.1674, 2497.1994, 2610.2835, 2773.3468, 2872.4152, 3001.4578, 3164.5211, 3277.6052, 3406.6478, 3537.6883, 3636.7567, 3735.8251, 3863.8837, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"AVMIGVCEFHFWEILCNDGDCAIMESVEDYPCR", {72.0444, 171.1128, 302.1533, 415.2374, 472.2588, 571.3272, 731.3579, 860.4005, 1007.4689, 1144.5278, 1291.5962, 1477.6755, 1606.7181, 1719.8022, 1832.8862, 1992.9169, 2106.9598, 2221.9868, 2279.0082, 2394.0352, 2554.0658, 2625.1029, 2738.1870, 2869.2275, 2998.2701, 3085.3021, 3184.3705, 3313.4131, 3428.4401, 3591.5034, 3688.5561, 3848.5868, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 335.1496, 432.2024, 595.2657, 710.2926, 839.3352, 938.4036, 1025.4357, 1154.4783, 1285.5187, 1398.6028, 1469.6399, 1629.6706, 1744.6975, 1801.7190, 1916.7459, 2030.7889, 2190.8195, 2303.9036, 2416.9876, 2546.0302, 2732.1095, 2879.1779, 3016.2369, 3163.3053, 3292.3479, 3452.3785, 3551.4469, 3608.4684, 3721.5525, 3852.5929, 3951.6614, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VLISGITWACYGYSEEMWYVYALSWNICISVFR", {100.0757, 213.1598, 326.2438, 413.2758, 470.2973, 583.3814, 684.4291, 870.5084, 941.5455, 1101.5761, 1264.6395, 1321.6609, 1484.7242, 1571.7563, 1700.7989, 1829.8415, 1960.8819, 2146.9613, 2310.0246, 2409.0930, 2572.1563, 2643.1934, 2756.2775, 2843.3095, 3029.3889, 3143.4318, 3256.5158, 3416.5465, 3529.6306, 3616.6626, 3715.7310, 3862.7994, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 421.2558, 508.2878, 621.3719, 781.4025, 894.4866, 1008.5295, 1194.6088, 1281.6409, 1394.7249, 1465.7620, 1628.8254, 1727.8938, 1890.9571, 2077.0364, 2208.0769, 2337.1195, 2466.1621, 2553.1941, 2716.2574, 2773.2789, 2936.3422, 3096.3729, 3167.4100, 3353.4893, 3454.5370, 3567.6211, 3624.6425, 3711.6745, 3824.7586, 3937.8427, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"CVMAIIHWTSYIDGVFQQAVDWNNLMDYYNQVK", {161.0379, 260.1063, 391.1468, 462.1839, 575.2680, 688.3521, 825.4110, 1011.4903, 1112.5380, 1199.5700, 1362.6333, 1475.7174, 1590.7443, 1647.7658, 1746.8342, 1893.9026, 2021.9612, 2150.0198, 2221.0569, 2320.1253, 2435.1523, 2621.2316, 2735.2745, 2849.3174, 2962.4015, 3093.4420, 3208.4689, 3371.5322, 3534.5956, 3648.6385, 3776.6971, 3875.7655, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 246.1812, 374.2398, 488.2827, 651.3461, 814.4094, 929.4363, 1060.4768, 1173.5609, 1287.6038, 1401.6467, 1587.7260, 1702.7530, 1801.8214, 1872.8585, 2000.9171, 2128.9757, 2276.0441, 2375.1125, 2432.1340, 2547.1609, 2660.2450, 2823.3083, 2910.3403, 3011.3880, 3197.4673, 3334.5262, 3447.6103, 3560.6944, 3631.7315, 3762.7720, 3861.8404, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LPNGYVFSFIAIVILFLWFIIYIALWCTDTCSR", {114.0913, 211.1441, 325.1870, 382.2085, 545.2718, 644.3402, 791.4087, 878.4407, 1025.5091, 1138.5932, 1209.6303, 1322.7143, 1421.7828, 1534.8668, 1647.9509, 1795.0193, 1908.1034, 2094.1827, 2241.2511, 2354.3351, 2467.4192, 2630.4825, 2743.5666, 2814.6037, 2927.6878, 3113.7671, 3273.7977, 3374.8454, 3489.8724, 3590.9200, 3750.9507, 3837.9827, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 262.1510, 422.1816, 523.2293, 638.2563, 739.3039, 899.3346, 1085.4139, 1198.4980, 1269.5351, 1382.6191, 1545.6825, 1658.7665, 1771.8506, 1918.9190, 2104.9983, 2218.0824, 2365.1508, 2478.2349, 2591.3189, 2690.3873, 2803.4714, 2874.5085, 2987.5926, 3134.6610, 3221.6930, 3368.7614, 3467.8298, 3630.8932, 3687.9146, 3801.9576, 3899.0103, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"CLACPQMLQSCDHDEFESGQVFTAQCTCCVLHR", {161.0379, 274.1220, 345.1591, 505.1898, 602.2425, 730.3011, 861.3416, 974.4256, 1102.4842, 1189.5162, 1349.5469, 1464.5738, 1601.6328, 1716.6597, 1845.7023, 1992.7707, 2121.8133, 2208.8453, 2265.8668, 2393.9254, 2492.9938, 2640.0622, 2741.1099, 2812.1470, 2940.2056, 3100.2362, 3201.2839, 3361.3145, 3521.3452, 3620.4136, 3733.4977, 3870.5566, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 312.1779, 425.2619, 524.3303, 684.3610, 844.3916, 945.4393, 1105.4700, 1233.5285, 1304.5657, 1405.6133, 1552.6817, 1651.7502, 1779.8087, 1836.8302, 1923.8622, 2052.9048, 2199.9732, 2329.0158, 2444.0428, 2581.1017, 2696.1286, 2856.1593, 2943.1913, 3071.2499, 3184.3340, 3315.3744, 3443.4330, 3540.4858, 3700.5164, 3771.5535, 3884.6376, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QQLVQHLNETIFVFYIACFGFQTVCLFMEVILK", {129.0659, 257.1244, 370.2085, 469.2769, 597.3355, 734.3944, 847.4785, 961.5214, 1090.5640, 1191.6117, 1304.6957, 1451.7641, 1550.8326, 1697.9010, 1860.9643, 1974.0484, 2045.0855, 2205.1161, 2352.1845, 2409.2060, 2556.2744, 2684.3330, 2785.3807, 2884.4491, 3044.4797, 3157.5638, 3304.6322, 3435.6727, 3564.7153, 3663.7837, 3776.8678, 3889.9518, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 373.2809, 472.3493, 601.3919, 732.4324, 879.5008, 992.5849, 1152.6156, 1251.6840, 1352.7316, 1480.7902, 1627.8586, 1684.8801, 1831.9485, 1991.9792, 2063.0163, 2176.1003, 2339.1637, 2486.2321, 2585.3005, 2732.3689, 2845.4530, 2946.5007, 3075.5432, 3189.5862, 3302.6702, 3439.7291, 3567.7877, 3666.8561, 3779.9402, 3907.9988, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YTEHVNDEHFPTTECILEYGIIGMSWYDCSVIR", {164.0706, 265.1183, 394.1609, 531.2198, 630.2882, 744.3311, 859.3581, 988.4007, 1125.4596, 1272.5280, 1369.5808, 1470.6284, 1571.6761, 1700.7187, 1860.7494, 1973.8334, 2086.9175, 2215.9601, 2379.0234, 2436.0449, 2549.1289, 2662.2130, 2719.2345, 2850.2749, 2937.3070, 3123.3863, 3286.4496, 3401.4766, 3561.5072, 3648.5392, 3747.6076, 3860.6917, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 387.2714, 474.3035, 634.3341, 749.3611, 912.4244, 1098.5037, 1185.5357, 1316.5762, 1373.5977, 1486.6817, 1599.7658, 1656.7873, 1819.8506, 1948.8932, 2061.9772, 2175.0613, 2335.0920, 2464.1346, 2565.1822, 2666.2299, 2763.2827, 2910.3511, 3047.4100, 3176.4526, 3291.4795, 3405.5225, 3504.5909, 3641.6498, 3770.6924, 3871.7401, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TLTVDYLDDEIQQVELLFIDENCYFSIMDDDIK", {102.0550, 215.1390, 316.1867, 415.2551, 530.2821, 693.3454, 806.4294, 921.4564, 1036.4833, 1165.5259, 1278.6100, 1406.6686, 1534.7271, 1633.7956, 1762.8382, 1875.9222, 1989.0063, 2136.0747, 2249.1588, 2364.1857, 2493.2283, 2607.2712, 2767.3019, 2930.3652, 3077.4336, 3164.4656, 3277.5497, 3408.5902, 3523.6171, 3638.6441, 3753.6710, 3866.7551, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 375.2238, 490.2508, 605.2777, 736.3182, 849.4022, 936.4343, 1083.5027, 1246.5660, 1406.5967, 1520.6396, 1649.6822, 1764.7091, 1877.7932, 2024.8616, 2137.9457, 2251.0297, 2380.0723, 2479.1407, 2607.1993, 2735.2579, 2848.3420, 2977.3846, 3092.4115, 3207.4384, 3320.5225, 3483.5858, 3598.6128, 3697.6812, 3798.7289, 3911.8129, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YPGDQFWTVPNDYVMSFAPCMASIYVYSVYYIR", {164.0706, 261.1234, 318.1448, 433.1718, 561.2304, 708.2988, 894.3781, 995.4258, 1094.4942, 1191.5469, 1305.5899, 1420.6168, 1583.6801, 1682.7485, 1813.7890, 1900.8211, 2047.8895, 2118.9266, 2215.9794, 2376.0100, 2507.0505, 2578.0876, 2665.1196, 2778.2037, 2941.2670, 3040.3354, 3203.3988, 3290.4308, 3389.4992, 3552.5625, 3715.6259, 3828.7099, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 451.2663, 614.3297, 713.3981, 800.4301, 963.4934, 1062.5619, 1225.6252, 1338.7093, 1425.7413, 1496.7784, 1627.8189, 1787.8495, 1884.9023, 1955.9394, 2103.0078, 2190.0398, 2321.0803, 2420.1487, 2583.2121, 2698.2390, 2812.2819, 2909.3347, 3008.4031, 3109.4508, 3295.5301, 3442.5985, 3570.6571, 3685.6840, 3742.7055, 3839.7583, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FIVNIGSIYLIYYLFFVILIILGIFLLMLQPWR", {148.0757, 261.1598, 360.2282, 474.2711, 587.3552, 644.3766, 731.4087, 844.4927, 1007.5560, 1120.6401, 1233.7242, 1396.7875, 1559.8508, 1672.9349, 1820.0033, 1967.0717, 2066.1401, 2179.2242, 2292.3083, 2405.3923, 2518.4764, 2631.5605, 2688.5819, 2801.6660, 2948.7344, 3061.8185, 3174.9025, 3305.9430, 3419.0271, 3547.0857, 3644.1384, 3830.2177, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 361.1983, 458.2510, 586.3096, 699.3937, 830.4342, 943.5182, 1056.6023, 1203.6707, 1316.7548, 1373.7762, 1486.8603, 1599.9444, 1713.0284, 1826.1125, 1939.1965, 2038.2650, 2185.3334, 2332.4018, 2445.4859, 2608.5492, 2771.6125, 2884.6966, 2997.7806, 3160.8440, 3273.9280, 3360.9601, 3417.9815, 3531.0656, 3645.1085, 3744.1769, 3857.2610, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VYLLWDIDQLQYCVSYPTVLYVAHLESELVFSR", {100.0757, 263.1390, 376.2231, 489.3071, 675.3865, 790.4134, 903.4975, 1018.5244, 1146.5830, 1259.6671, 1387.7256, 1550.7890, 1710.8196, 1809.8880, 1896.9200, 2059.9834, 2157.0361, 2258.0838, 2357.1522, 2470.2363, 2633.2996, 2732.3680, 2803.4052, 2940.4641, 3053.5481, 3182.5907, 3269.6228, 3398.6653, 3511.7494, 3610.8178, 3757.8862, 3844.9183, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 262.1510, 409.2194, 508.2878, 621.3719, 750.4145, 837.4465, 966.4891, 1079.5732, 1216.6321, 1287.6692, 1386.7376, 1549.8009, 1662.8850, 1761.9534, 1863.0011, 1960.0538, 2123.1172, 2210.1492, 2309.2176, 2469.2483, 2632.3116, 2760.3702, 2873.4542, 3001.5128, 3116.5398, 3229.6238, 3344.6508, 3530.7301, 3643.8141, 3756.8982, 3919.9615, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"IIEVQDMMSDLEENLYQVVSMEEIFDEFFEPDR", {114.0913, 227.1754, 356.2180, 455.2864, 583.3450, 698.3719, 829.4124, 960.4529, 1047.4849, 1162.5119, 1275.5959, 1404.6385, 1533.6811, 1647.7241, 1760.8081, 1923.8714, 2051.9300, 2150.9984, 2250.0668, 2337.0989, 2468.1394, 2597.1820, 2726.2245, 2839.3086, 2986.3770, 3101.4040, 3230.4466, 3377.5150, 3524.5834, 3653.6260, 3750.6787, 3865.7057, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 290.1459, 387.1987, 516.2413, 663.3097, 810.3781, 939.4207, 1054.4476, 1201.5160, 1314.6001, 1443.6427, 1572.6853, 1703.7258, 1790.7578, 1889.8262, 1988.8946, 2116.9532, 2280.0165, 2393.1006, 2507.1435, 2636.1861, 2765.2287, 2878.3128, 2993.3397, 3080.3717, 3211.4122, 3342.4527, 3457.4797, 3585.5382, 3684.6066, 3813.6492, 3926.7333, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SMPFILYSILAQMWFYLTGCGFCCFAGIFHVIR", {88.0393, 219.0798, 316.1326, 463.2010, 576.2850, 689.3691, 852.4324, 939.4645, 1052.5485, 1165.6326, 1236.6697, 1364.7283, 1495.7688, 1681.8481, 1828.9165, 1991.9798, 2105.0639, 2206.1116, 2263.1330, 2423.1637, 2480.1851, 2627.2535, 2787.2842, 2947.3148, 3094.3833, 3165.4204, 3222.4418, 3335.5259, 3482.5943, 3619.6532, 3718.7216, 3831.8057, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 387.2714, 524.3303, 671.3988, 784.4828, 841.5043, 912.5414, 1059.6098, 1219.6405, 1379.6711, 1526.7395, 1583.7610, 1743.7916, 1800.8131, 1901.8608, 2014.9448, 2178.0082, 2325.0766, 2511.1559, 2642.1964, 2770.2550, 2841.2921, 2954.3761, 3067.4602, 3154.4922, 3317.5556, 3430.6396, 3543.7237, 3690.7921, 3787.8449, 3918.8853, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EIQFQYLAFWGAAVVCGLVVPYSICYMQLYTYR", {130.0499, 243.1339, 371.1925, 518.2609, 646.3195, 809.3828, 922.4669, 993.5040, 1140.5724, 1326.6517, 1383.6732, 1454.7103, 1525.7474, 1624.8158, 1723.8843, 1883.9149, 1940.9364, 2054.0204, 2153.0888, 2252.1573, 2349.2100, 2512.2734, 2599.3054, 2712.3894, 2872.4201, 3035.4834, 3166.5239, 3294.5825, 3407.6665, 3570.7299, 3671.7776, 3834.8409, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 439.2300, 602.2933, 715.3774, 843.4359, 974.4764, 1137.5397, 1297.5704, 1410.6545, 1497.6865, 1660.7498, 1757.8026, 1856.8710, 1955.9394, 2069.0235, 2126.0449, 2286.0756, 2385.1440, 2484.2124, 2555.2495, 2626.2866, 2683.3081, 2869.3874, 3016.4558, 3087.4929, 3200.5770, 3363.6403, 3491.6989, 3638.7673, 3766.8259, 3879.9100, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"CSRPEHCAGYYDIHMHANDPNTCGPEGSDCWCR", {161.0379, 248.0700, 404.1711, 501.2238, 630.2664, 767.3253, 927.3560, 998.3931, 1055.4146, 1218.4779, 1381.5412, 1496.5682, 1609.6522, 1746.7111, 1877.7516, 2014.8105, 2085.8476, 2199.8906, 2314.9175, 2411.9703, 2526.0132, 2627.0609, 2787.0915, 2844.1130, 2941.1658, 3070.2084, 3127.2298, 3214.2618, 3329.2888, 3489.3194, 3675.3988, 3835.4294, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 335.1496, 521.2289, 681.2596, 796.2865, 883.3185, 940.3400, 1069.3826, 1166.4354, 1223.4568, 1383.4875, 1484.5351, 1598.5781, 1695.6308, 1810.6578, 1924.7007, 1995.7378, 2132.7967, 2263.8372, 2400.8961, 2513.9802, 2629.0071, 2792.0705, 2955.1338, 3012.1553, 3083.1924, 3243.2230, 3380.2819, 3509.3245, 3606.3773, 3762.4784, 3849.5104, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"HSFVHGVIQSYYYTIMTTPCVFSFFFICAVFLR", {138.0662, 225.0982, 372.1666, 471.2350, 608.2940, 665.3154, 764.3838, 877.4679, 1005.5265, 1092.5585, 1255.6218, 1418.6852, 1581.7485, 1682.7962, 1795.8802, 1926.9207, 2027.9684, 2129.0161, 2226.0688, 2386.0995, 2485.1679, 2632.2363, 2719.2683, 2866.3368, 3013.4052, 3160.4736, 3273.5576, 3433.5883, 3504.6254, 3603.6938, 3750.7622, 3863.8463, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 435.2714, 534.3398, 605.3770, 765.4076, 878.4917, 1025.5601, 1172.6285, 1319.6969, 1406.7289, 1553.7974, 1652.8658, 1812.8964, 1909.9492, 2010.9969, 2112.0445, 2243.0850, 2356.1691, 2457.2168, 2620.2801, 2783.3434, 2946.4068, 3033.4388, 3161.4974, 3274.5814, 3373.6498, 3430.6713, 3567.7302, 3666.7986, 3813.8670, 3900.8991, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MSMLTFFIYLTGLLYNMSEPPEPYTLWHEPIHR", {132.0478, 219.0798, 350.1203, 463.2043, 564.2520, 711.3204, 858.3888, 971.4729, 1134.5362, 1247.6203, 1348.6680, 1405.6894, 1518.7735, 1631.8576, 1794.9209, 1908.9638, 2040.0043, 2127.0363, 2256.0789, 2353.1317, 2450.1845, 2579.2271, 2676.2798, 2839.3431, 2940.3908, 3053.4749, 3239.5542, 3376.6131, 3505.6557, 3602.7085, 3715.7925, 3852.8514, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 312.1779, 425.2619, 522.3147, 651.3573, 788.4162, 974.4955, 1087.5796, 1188.6273, 1351.6906, 1448.7433, 1577.7859, 1674.8387, 1771.8915, 1900.9341, 1987.9661, 2119.0066, 2233.0495, 2396.1128, 2509.1969, 2622.2810, 2679.3024, 2780.3501, 2893.4342, 3056.4975, 3169.5816, 3316.6500, 3463.7184, 3564.7661, 3677.8501, 3808.8906, 3895.9226, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DESLTQQVTQQEDMEYNSLSDDFHEDLCDFEDK", {116.0342, 245.0768, 332.1088, 445.1929, 546.2406, 674.2992, 802.3577, 901.4262, 1002.4738, 1130.5324, 1258.5910, 1387.6336, 1502.6605, 1633.7010, 1762.7436, 1925.8069, 2039.8499, 2126.8819, 2239.9659, 2326.9980, 2442.0249, 2557.0519, 2704.1203, 2841.1792, 2970.2218, 3085.2487, 3198.3328, 3358.3634, 3473.3904, 3620.4588, 3749.5014, 3864.5283, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 262.1397, 391.1823, 538.2508, 653.2777, 813.3083, 926.3924, 1041.4194, 1170.4619, 1307.5209, 1454.5893, 1569.6162, 1684.6432, 1771.6752, 1884.7593, 1971.7913, 2085.8342, 2248.8975, 2377.9401, 2508.9806, 2624.0076, 2753.0501, 2881.1087, 3009.1673, 3110.2150, 3209.2834, 3337.3420, 3465.4006, 3566.4482, 3679.5323, 3766.5643, 3895.6069, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TNTVCEYGDDLNQCLSQGPCTVHQCFEIEQCNK", {102.0550, 216.0979, 317.1456, 416.2140, 576.2446, 705.2872, 868.3505, 925.3720, 1040.3990, 1155.4259, 1268.5100, 1382.5529, 1510.6115, 1670.6421, 1783.7262, 1870.7582, 1998.8168, 2055.8382, 2152.8910, 2312.9217, 2413.9693, 2513.0378, 2650.0967, 2778.1552, 2938.1859, 3085.2543, 3214.2969, 3327.3810, 3456.4236, 3584.4821, 3744.5128, 3858.5557, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 261.1557, 421.1864, 549.2450, 678.2876, 791.3716, 920.4142, 1067.4826, 1227.5133, 1355.5718, 1492.6308, 1591.6992, 1692.7469, 1852.7775, 1949.8303, 2006.8517, 2134.9103, 2221.9423, 2335.0264, 2495.0570, 2623.1156, 2737.1586, 2850.2426, 2965.2696, 3080.2965, 3137.3180, 3300.3813, 3429.4239, 3589.4545, 3688.5230, 3789.5706, 3903.6136, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LCPNTQCLPHINVETECHQGSHNPDCFCQYDGR", {114.0913, 274.1220, 371.1748, 485.2177, 586.2654, 714.3239, 874.3546, 987.4386, 1084.4914, 1221.5503, 1334.6344, 1448.6773, 1547.7457, 1676.7883, 1777.8360, 1906.8786, 2066.9092, 2203.9682, 2332.0267, 2389.0482, 2476.0802, 2613.1391, 2727.1821, 2824.2348, 2939.2618, 3099.2924, 3246.3608, 3406.3915, 3534.4501, 3697.5134, 3812.5403, 3869.5618, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 232.1404, 347.1674, 510.2307, 638.2893, 798.3199, 945.3883, 1105.4190, 1220.4459, 1317.4987, 1431.5416, 1568.6005, 1655.6326, 1712.6540, 1840.7126, 1977.7715, 2137.8022, 2266.8447, 2367.8924, 2496.9350, 2596.0034, 2710.0464, 2823.1304, 2960.1893, 3057.2421, 3170.3262, 3330.3568, 3458.4154, 3559.4631, 3673.5060, 3770.5588, 3930.5894, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FNSFQEYTEAFPSVFFYFQMPMGQEWGKPLVLR", {148.0757, 262.1186, 349.1506, 496.2191, 624.2776, 753.3202, 916.3836, 1017.4312, 1146.4738, 1217.5109, 1364.5794, 1461.6321, 1548.6642, 1647.7326, 1794.8010, 1941.8694, 2104.9327, 2252.0011, 2380.0597, 2511.1002, 2608.1530, 2739.1934, 2796.2149, 2924.2735, 3053.3161, 3239.3954, 3296.4169, 3424.5118, 3521.5646, 3634.6486, 3733.7171, 3846.8011, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 387.2714, 500.3555, 597.4083, 725.5032, 782.5247, 968.6040, 1097.6466, 1225.7052, 1282.7266, 1413.7671, 1510.8199, 1641.8604, 1769.9189, 1916.9874, 2080.0507, 2227.1191, 2374.1875, 2473.2559, 2560.2880, 2657.3407, 2804.4091, 2875.4462, 3004.4888, 3105.5365, 3268.5998, 3397.6424, 3525.7010, 3672.7694, 3759.8015, 3873.8444, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FNRPQPCSIGLTTFFAYLEQLSQLQQFHLMLHR", {148.0757, 262.1186, 418.2197, 515.2725, 643.3311, 740.3838, 900.4145, 987.4465, 1100.5306, 1157.5520, 1270.6361, 1371.6838, 1472.7315, 1619.7999, 1766.8683, 1837.9054, 2000.9687, 2114.0528, 2243.0954, 2371.1540, 2484.2380, 2571.2701, 2699.3286, 2812.4127, 2940.4713, 3068.5299, 3215.5983, 3352.6572, 3465.7412, 3596.7817, 3709.8658, 3846.9247, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 312.1779, 425.2619, 556.3024, 669.3865, 806.4454, 953.5138, 1081.5724, 1209.6310, 1322.7150, 1450.7736, 1537.8056, 1650.8897, 1778.9483, 1907.9909, 2021.0749, 2184.1383, 2255.1754, 2402.2438, 2549.3122, 2650.3599, 2751.4076, 2864.4916, 2921.5131, 3034.5971, 3121.6292, 3281.6598, 3378.7126, 3506.7712, 3603.8239, 3759.9250, 3873.9680, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YNLPYFIMGYTSIYPMFWMSGLFTSLNYMFLSK", {164.0706, 278.1135, 391.1976, 488.2504, 651.3137, 798.3821, 911.4662, 1042.5067, 1099.5281, 1262.5914, 1363.6391, 1450.6712, 1563.7552, 1726.8185, 1823.8713, 1954.9118, 2101.9802, 2288.0595, 2419.1000, 2506.1320, 2563.1535, 2676.2376, 2823.3060, 2924.3537, 3011.3857, 3124.4697, 3238.5127, 3401.5760, 3532.6165, 3679.6849, 3792.7690, 3879.8010, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 234.1448, 347.2289, 494.2973, 625.3378, 788.4011, 902.4441, 1015.5281, 1102.5601, 1203.6078, 1350.6762, 1463.7603, 1520.7818, 1607.8138, 1738.8543, 1924.9336, 2072.0020, 2203.0425, 2300.0953, 2463.1586, 2576.2426, 2663.2747, 2764.3224, 2927.3857, 2984.4071, 3115.4476, 3228.5317, 3375.6001, 3538.6634, 3635.7162, 3748.8003, 3862.8432, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LPRPMHNMQTNVLSLYLVLWFGFFAPAYYWQLK", {114.0913, 211.1441, 367.2452, 464.2980, 595.3385, 732.3974, 846.4403, 977.4808, 1105.5394, 1206.5870, 1320.6300, 1419.6984, 1532.7824, 1619.8145, 1732.8985, 1895.9619, 2009.0459, 2108.1143, 2221.1984, 2407.2777, 2554.3461, 2611.3676, 2758.4360, 2905.5044, 2976.5415, 3073.5943, 3144.6314, 3307.6948, 3470.7581, 3656.8374, 3784.8960, 3897.9800, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 388.2554, 574.3348, 737.3981, 900.4614, 971.4985, 1068.5513, 1139.5884, 1286.6568, 1433.7252, 1490.7467, 1637.8151, 1823.8944, 1936.9785, 2036.0469, 2149.1310, 2312.1943, 2425.2784, 2512.3104, 2625.3945, 2724.4629, 2838.5058, 2939.5535, 3067.6121, 3198.6525, 3312.6955, 3449.7544, 3580.7949, 3677.8476, 3833.9487, 3931.0015, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LFLDLHNHLLVQNQQNGLCFNQLFEHALCMLEK", {114.0913, 261.1598, 374.2438, 489.2708, 602.3548, 739.4137, 853.4567, 990.5156, 1103.5996, 1216.6837, 1315.7521, 1443.8107, 1557.8536, 1685.9122, 1813.9708, 1928.0137, 1985.0352, 2098.1192, 2258.1499, 2405.2183, 2519.2612, 2647.3198, 2760.4039, 2907.4723, 3036.5149, 3173.5738, 3244.6109, 3357.6950, 3517.7256, 3648.7661, 3761.8502, 3890.8928, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 276.1554, 389.2395, 520.2799, 680.3106, 793.3947, 864.4318, 1001.4907, 1130.5333, 1277.6017, 1390.6858, 1518.7443, 1632.7873, 1779.8557, 1939.8863, 2052.9704, 2109.9919, 2224.0348, 2352.0934, 2480.1519, 2594.1949, 2722.2534, 2821.3219, 2934.4059, 3047.4900, 3184.5489, 3298.5918, 3435.6507, 3548.7348, 3663.7617, 3776.8458, 3923.9142, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"HYDWANWTVNIWNAPTLDNTVVMETQCEFDTQK", {138.0662, 301.1295, 416.1565, 602.2358, 673.2729, 787.3158, 973.3951, 1074.4428, 1173.5112, 1287.5541, 1400.6382, 1586.7175, 1700.7605, 1771.7976, 1868.8503, 1969.8980, 2082.9821, 2198.0090, 2312.0519, 2413.0996, 2512.1680, 2611.2364, 2742.2769, 2871.3195, 2972.3672, 3100.4258, 3260.4564, 3389.4990, 3536.5674, 3651.5944, 3752.6421, 3880.7006, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 275.1714, 376.2191, 491.2460, 638.3144, 767.3570, 927.3877, 1055.4462, 1156.4939, 1285.5365, 1416.5770, 1515.6454, 1614.7138, 1715.7615, 1829.8044, 1944.8314, 2057.9154, 2158.9631, 2256.0159, 2327.0530, 2441.0959, 2627.1752, 2740.2593, 2854.3022, 2953.3706, 3054.4183, 3240.4976, 3354.5406, 3425.5777, 3611.6570, 3726.6839, 3889.7473, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"KPIELSPNDALLEDAEELFFENDCHFEQDEWTR", {129.1022, 226.1550, 339.2391, 468.2817, 581.3657, 668.3978, 765.4505, 879.4934, 994.5204, 1065.5575, 1178.6416, 1291.7256, 1420.7682, 1535.7952, 1606.8323, 1735.8749, 1864.9175, 1978.0015, 2125.0699, 2272.1384, 2401.1810, 2515.2239, 2630.2508, 2790.2815, 2927.3404, 3074.4088, 3203.4514, 3331.5100, 3446.5369, 3575.5795, 3761.6588, 3862.7065, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 276.1666, 462.2459, 591.2885, 706.3155, 834.3741, 963.4167, 1110.4851, 1247.5440, 1407.5746, 1522.6016, 1636.6445, 1765.6871, 1912.7555, 2059.8239, 2172.9080, 2301.9506, 2430.9932, 2502.0303, 2617.0572, 2746.0998, 2859.1839, 2972.2679, 3043.3051, 3158.3320, 3272.3749, 3369.4277, 3456.4597, 3569.5438, 3698.5864, 3811.6704, 3908.7232, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"IYMPICLVSSCTVAWGVQYSWDPYYYEEGLMEK", {114.0913, 277.1547, 408.1952, 505.2479, 618.3320, 778.3626, 891.4467, 990.5151, 1077.5471, 1164.5792, 1324.6098, 1425.6575, 1524.7259, 1595.7630, 1781.8423, 1838.8638, 1937.9322, 2065.9908, 2229.0541, 2316.0861, 2502.1655, 2617.1924, 2714.2452, 2877.3085, 3040.3718, 3203.4352, 3332.4777, 3461.5203, 3518.5418, 3631.6259, 3762.6663, 3891.7089, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 276.1554, 407.1959, 520.2799, 577.3014, 706.3440, 835.3866, 998.4499, 1161.5133, 1324.5766, 1421.6293, 1536.6563, 1722.7356, 1809.7676, 1972.8310, 2100.8895, 2199.9580, 2256.9794, 2443.0587, 2514.0958, 2613.1643, 2714.2119, 2874.2426, 2961.2746, 3048.3066, 3147.3751, 3260.4591, 3420.4898, 3533.5738, 3630.6266, 3761.6671, 3924.7304, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EEDNDENDEEDEPEVEIDPVLYYQLPNPWLDDK", {130.0499, 259.0925, 374.1194, 488.1623, 603.1893, 732.2319, 846.2748, 961.3017, 1090.3443, 1219.3869, 1334.4139, 1463.4565, 1560.5092, 1689.5518, 1788.6202, 1917.6628, 2030.7469, 2145.7738, 2242.8266, 2341.8950, 2454.9791, 2618.0424, 2781.1057, 2909.1643, 3022.2484, 3119.3011, 3233.3441, 3330.3968, 3516.4761, 3629.5602, 3744.5871, 3859.6141, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 262.1397, 377.1667, 490.2508, 676.3301, 773.3828, 887.4258, 984.4785, 1097.5626, 1225.6212, 1388.6845, 1551.7478, 1664.8319, 1763.9003, 1860.9531, 1975.9800, 2089.0641, 2218.1067, 2317.1751, 2446.2177, 2543.2704, 2672.3130, 2787.3400, 2916.3826, 3045.4252, 3160.4521, 3274.4950, 3403.5376, 3518.5646, 3632.6075, 3747.6344, 3876.6770, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"IEEPLVELLAELHMINQSDILGFMDFMCYLFCK", {114.0913, 243.1339, 372.1765, 469.2293, 582.3134, 681.3818, 810.4244, 923.5084, 1036.5925, 1107.6296, 1236.6722, 1349.7563, 1486.8152, 1617.8557, 1730.9397, 1844.9826, 1973.0412, 2060.0733, 2175.1002, 2288.1843, 2401.2683, 2458.2898, 2605.3582, 2736.3987, 2851.4256, 2998.4940, 3129.5345, 3289.5652, 3452.6285, 3565.7126, 3712.7810, 3872.8116, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 307.1435, 454.2119, 567.2959, 730.3593, 890.3899, 1021.4304, 1168.4988, 1283.5257, 1414.5662, 1561.6346, 1618.6561, 1731.7402, 1844.8242, 1959.8512, 2046.8832, 2174.9418, 2288.9847, 2402.0688, 2533.1093, 2670.1682, 2783.2522, 2912.2948, 2983.3319, 3096.4160, 3209.5001, 3338.5427, 3437.6111, 3550.6951, 3647.7479, 3776.7905, 3905.8331, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DFQLLYVLYLFSTIIMQFGMNHNISFLGCLQFR", {116.0342, 263.1026, 391.1612, 504.2453, 617.3293, 780.3927, 879.4611, 992.5451, 1155.6085, 1268.6925, 1415.7610, 1502.7930, 1603.8407, 1716.9247, 1830.0088, 1961.0493, 2089.1078, 2236.1763, 2293.1977, 2424.2382, 2538.2811, 2675.3401, 2789.3830, 2902.4670, 2989.4991, 3136.5675, 3249.6515, 3306.6730, 3466.7037, 3579.7877, 3707.8463, 3854.9147, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 450.2459, 563.3300, 723.3607, 780.3821, 893.4662, 1040.5346, 1127.5666, 1240.6507, 1354.6936, 1491.7525, 1605.7955, 1736.8359, 1793.8574, 1940.9258, 2068.9844, 2200.0249, 2313.1089, 2426.1930, 2527.2407, 2614.2727, 2761.3411, 2874.4252, 3037.4885, 3150.5726, 3249.6410, 3412.7043, 3525.7884, 3638.8725, 3766.9310, 3913.9994, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SMYSDDYMYHPFTFPLVTLLGGHLCATYILYWR", {88.0393, 219.0798, 382.1431, 469.1751, 584.2021, 699.2290, 862.2924, 993.3328, 1156.3962, 1293.4551, 1390.5079, 1537.5763, 1638.6239, 1785.6924, 1882.7451, 1995.8292, 2094.8976, 2195.9453, 2309.0293, 2422.1134, 2479.1349, 2536.1563, 2673.2152, 2786.2993, 2946.3300, 3017.3671, 3118.4147, 3281.4781, 3394.5621, 3507.6462, 3670.7095, 3856.7888, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 361.1983, 524.2616, 637.3457, 750.4297, 913.4931, 1014.5407, 1085.5778, 1245.6085, 1358.6926, 1495.7515, 1552.7729, 1609.7944, 1722.8785, 1835.9625, 1937.0102, 2036.0786, 2149.1627, 2246.2154, 2393.2839, 2494.3315, 2641.3999, 2738.4527, 2875.5116, 3038.5750, 3169.6154, 3332.6788, 3447.7057, 3562.7327, 3649.7647, 3812.8280, 3943.8685, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"HLEAFSEQVMTGYYCLPYTQVTIGLLFCLYYIR", {138.0662, 251.1503, 380.1928, 451.2300, 598.2984, 685.3304, 814.3730, 942.4316, 1041.5000, 1172.5405, 1273.5881, 1330.6096, 1493.6729, 1656.7363, 1816.7669, 1929.8510, 2026.9037, 2189.9671, 2291.0148, 2419.0733, 2518.1417, 2619.1894, 2732.2735, 2789.2950, 2902.3790, 3015.4631, 3162.5315, 3322.5621, 3435.6462, 3598.7095, 3761.7729, 3874.8569, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 451.2663, 614.3297, 727.4137, 887.4444, 1034.5128, 1147.5969, 1260.6809, 1317.7024, 1430.7865, 1531.8341, 1630.9025, 1758.9611, 1860.0088, 2023.0721, 2120.1249, 2233.2090, 2393.2396, 2556.3029, 2719.3663, 2776.3877, 2877.4354, 3008.4759, 3107.5443, 3235.6029, 3364.6455, 3451.6775, 3598.7459, 3669.7830, 3798.8256, 3911.9097, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MGFWSYSEIFFLMIAFLLLFVACFFTSFLMLPR", {132.0478, 189.0692, 336.1376, 522.2170, 609.2490, 772.3123, 859.3443, 988.3869, 1101.4710, 1248.5394, 1395.6078, 1508.6919, 1639.7324, 1752.8164, 1823.8535, 1970.9220, 2084.0060, 2197.0901, 2310.1742, 2457.2426, 2556.3110, 2627.3481, 2787.3787, 2934.4472, 3081.5156, 3182.5633, 3269.5953, 3416.6637, 3529.7478, 3660.7882, 3773.8723, 3870.9251, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 272.1717, 385.2558, 516.2963, 629.3803, 776.4487, 863.4808, 964.5284, 1111.5969, 1258.6653, 1418.6959, 1489.7330, 1588.8015, 1735.8699, 1848.9539, 1962.0380, 2075.1221, 2222.1905, 2293.2276, 2406.3117, 2537.3521, 2650.4362, 2797.5046, 2944.5730, 3057.6571, 3186.6997, 3273.7317, 3436.7950, 3523.8271, 3709.9064, 3856.9748, 3913.9963, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SLGEICVLWTLFYMVNWTQFLYIFAHSIPHISK", {88.0393, 201.1234, 258.1448, 387.1874, 500.2715, 660.3021, 759.3706, 872.4546, 1058.5339, 1159.5816, 1272.6657, 1419.7341, 1582.7974, 1713.8379, 1812.9063, 1926.9492, 2113.0286, 2214.0762, 2342.1348, 2489.2032, 2602.2873, 2765.3506, 2878.4347, 3025.5031, 3096.5402, 3233.5991, 3320.6311, 3433.7152, 3530.7680, 3667.8269, 3780.9110, 3867.9430, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 234.1448, 347.2289, 484.2878, 581.3406, 694.4246, 781.4567, 918.5156, 989.5527, 1136.6211, 1249.7052, 1412.7685, 1525.8526, 1672.9210, 1800.9796, 1902.0272, 2088.1065, 2202.1495, 2301.2179, 2432.2584, 2595.3217, 2742.3901, 2855.4742, 2956.5219, 3142.6012, 3255.6852, 3354.7536, 3514.7843, 3627.8684, 3756.9110, 3813.9324, 3927.0165, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ICWLDGNMYVDALWPWHLEEIAEHLQENVLITK", {114.0913, 274.1220, 460.2013, 573.2854, 688.3123, 745.3338, 859.3767, 990.4172, 1153.4805, 1252.5489, 1367.5759, 1438.6130, 1551.6970, 1737.7764, 1834.8291, 2020.9084, 2157.9674, 2271.0514, 2400.0940, 2529.1366, 2642.2207, 2713.2578, 2842.3004, 2979.3593, 3092.4433, 3220.5019, 3349.5445, 3463.5874, 3562.6559, 3675.7399, 3788.8240, 3889.8717, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 248.1605, 361.2445, 474.3286, 573.3970, 687.4400, 816.4825, 944.5411, 1057.6252, 1194.6841, 1323.7267, 1394.7638, 1507.8479, 1636.8905, 1765.9331, 1879.0171, 2016.0760, 2202.1553, 2299.2081, 2485.2874, 2598.3715, 2669.4086, 2784.4355, 2883.5040, 3046.5673, 3177.6078, 3291.6507, 3348.6722, 3463.6991, 3576.7832, 3762.8625, 3922.8931, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DAHCQCQYGGLTNECLQACPQQEQCEDIDLCSK", {116.0342, 187.0713, 324.1302, 484.1609, 612.2195, 772.2501, 900.3087, 1063.3720, 1120.3935, 1177.4150, 1290.4990, 1391.5467, 1505.5896, 1634.6322, 1794.6629, 1907.7469, 2035.8055, 2106.8426, 2266.8733, 2363.9260, 2491.9846, 2620.0432, 2749.0858, 2877.1444, 3037.1750, 3166.2176, 3281.2445, 3394.3286, 3509.3556, 3622.4396, 3782.4703, 3869.5023, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 234.1448, 394.1755, 507.2595, 622.2865, 735.3706, 850.3975, 979.4401, 1139.4707, 1267.5293, 1396.5719, 1524.6305, 1652.6891, 1749.7418, 1909.7725, 1980.8096, 2108.8682, 2221.9522, 2381.9829, 2511.0255, 2625.0684, 2726.1161, 2839.2001, 2896.2216, 2953.2431, 3116.3064, 3244.3650, 3404.3956, 3532.4542, 3692.4849, 3829.5438, 3900.5809, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PPETECRPPETECRPPETECRPPETECRPPETK", {98.0600, 195.1128, 324.1554, 425.2031, 554.2457, 714.2763, 870.3774, 967.4302, 1064.4830, 1193.5255, 1294.5732, 1423.6158, 1583.6465, 1739.7476, 1836.8003, 1933.8531, 2062.8957, 2163.9434, 2292.9860, 2453.0166, 2609.1177, 2706.1705, 2803.2233, 2932.2659, 3033.3135, 3162.3561, 3322.3868, 3478.4879, 3575.5406, 3672.5934, 3801.6360, 3902.6837, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 248.1605, 377.2031, 474.2558, 571.3086, 727.4097, 887.4404, 1016.4830, 1117.5306, 1246.5732, 1343.6260, 1440.6788, 1596.7799, 1756.8105, 1885.8531, 1986.9008, 2115.9434, 2212.9961, 2310.0489, 2466.1500, 2626.1807, 2755.2233, 2856.2709, 2985.3135, 3082.3663, 3179.4191, 3335.5202, 3495.5508, 3624.5934, 3725.6411, 3854.6837, 3951.7364, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YQGEGNLEEWFEDPEAGEEVQELEVDDWYDSFR", {164.0706, 292.1292, 349.1506, 478.1932, 535.2147, 649.2576, 762.3417, 891.3843, 1020.4269, 1206.5062, 1353.5746, 1482.6172, 1597.6441, 1694.6969, 1823.7395, 1894.7766, 1951.7981, 2080.8407, 2209.8833, 2308.9517, 2437.0103, 2566.0528, 2679.1369, 2808.1795, 2907.2479, 3022.2749, 3137.3018, 3323.3811, 3486.4444, 3601.4714, 3688.5034, 3835.5718, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 409.2194, 524.2463, 687.3097, 873.3890, 988.4159, 1103.4429, 1202.5113, 1331.5539, 1444.6379, 1573.6805, 1701.7391, 1800.8075, 1929.8501, 2058.8927, 2115.9142, 2186.9513, 2315.9939, 2413.0466, 2528.0736, 2657.1162, 2804.1846, 2990.2639, 3119.3065, 3248.3491, 3361.4332, 3475.4761, 3532.4975, 3661.5401, 3718.5616, 3846.6202, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ILNYIGFYILAVVCAVIALWQYTCSWFELKPDR", {114.0913, 227.1754, 341.2183, 504.2817, 617.3657, 674.3872, 821.4556, 984.5189, 1097.6030, 1210.6871, 1281.7242, 1380.7926, 1479.8610, 1639.8916, 1710.9288, 1809.9972, 1923.0812, 1994.1184, 2107.2024, 2293.2817, 2421.3403, 2584.4036, 2685.4513, 2845.4820, 2932.5140, 3118.5933, 3265.6617, 3394.7043, 3507.7884, 3635.8833, 3732.9361, 3847.9630, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 290.1459, 387.1987, 515.2936, 628.3777, 757.4203, 904.4887, 1090.5680, 1177.6000, 1337.6307, 1438.6784, 1601.7417, 1729.8003, 1915.8796, 2028.9636, 2100.0008, 2213.0848, 2312.1532, 2383.1904, 2543.2210, 2642.2894, 2741.3578, 2812.3949, 2925.4790, 3038.5631, 3201.6264, 3348.6948, 3405.7163, 3518.8003, 3681.8637, 3795.9066, 3908.9907, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SPMMLSQLSFLAVCVFILILMDFTFHAFWYTFR", {88.0393, 185.0921, 316.1326, 447.1730, 560.2571, 647.2891, 775.3477, 888.4318, 975.4638, 1122.5322, 1235.6163, 1306.6534, 1405.7218, 1565.7525, 1664.8209, 1811.8893, 1924.9733, 2038.0574, 2151.1415, 2264.2255, 2395.2660, 2510.2930, 2657.3614, 2758.4091, 2905.4775, 3042.5364, 3113.5735, 3260.6419, 3446.7212, 3609.7846, 3710.8322, 3857.9006, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 423.2350, 586.2984, 772.3777, 919.4461, 990.4832, 1127.5421, 1274.6105, 1375.6582, 1522.7266, 1637.7536, 1768.7941, 1881.8781, 1994.9622, 2108.0463, 2221.1303, 2368.1987, 2467.2671, 2627.2978, 2726.3662, 2797.4033, 2910.4874, 3057.5558, 3144.5878, 3257.6719, 3385.7305, 3472.7625, 3585.8466, 3716.8870, 3847.9275, 3944.9803, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MAHMVLIAGFVCVFPICLMILTYLWENSIFTWK", {132.0478, 203.0849, 340.1438, 471.1843, 570.2527, 683.3367, 796.4208, 867.4579, 924.4794, 1071.5478, 1170.6162, 1330.6469, 1429.7153, 1576.7837, 1673.8365, 1786.9205, 1946.9512, 2060.0352, 2191.0757, 2304.1598, 2417.2438, 2518.2915, 2681.3549, 2794.4389, 2980.5182, 3109.5608, 3223.6038, 3310.6358, 3423.7198, 3570.7883, 3671.8359, 3857.9153, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 333.1921, 434.2398, 581.3082, 694.3923, 781.4243, 895.4672, 1024.5098, 1210.5891, 1323.6732, 1486.7365, 1587.7842, 1700.8683, 1813.9523, 1944.9928, 2058.0769, 2218.1075, 2331.1916, 2428.2444, 2575.3128, 2674.3812, 2834.4118, 2933.4803, 3080.5487, 3137.5701, 3208.6072, 3321.6913, 3434.7754, 3533.8438, 3664.8843, 3801.9432, 3872.9803, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PWYTDVFVYIDTMITDLNSIESWQPSPFYDMNR", {98.0600, 284.1394, 447.2027, 548.2504, 663.2773, 762.3457, 909.4141, 1008.4825, 1171.5459, 1284.6299, 1399.6569, 1500.7046, 1631.7450, 1744.8291, 1845.8768, 1960.9037, 2073.9878, 2188.0307, 2275.0627, 2388.1468, 2517.1894, 2604.2214, 2790.3007, 2918.3593, 3015.4121, 3102.4441, 3199.4969, 3346.5653, 3509.6286, 3624.6556, 3755.6961, 3869.7390, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 289.1619, 420.2024, 535.2293, 698.2926, 845.3610, 942.4138, 1029.4458, 1126.4986, 1254.5572, 1440.6365, 1527.6685, 1656.7111, 1769.7952, 1856.8272, 1970.8701, 2083.9542, 2198.9811, 2300.0288, 2413.1129, 2544.1534, 2645.2011, 2760.2280, 2873.3121, 3036.3754, 3135.4438, 3282.5122, 3381.5806, 3496.6076, 3597.6552, 3760.7186, 3946.7979, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EDQIEVFLEYFDVLPMGLQSYIYEIEEDAEYMK", {130.0499, 245.0768, 373.1354, 486.2195, 615.2620, 714.3305, 861.3989, 974.4829, 1103.5255, 1266.5889, 1413.6573, 1528.6842, 1627.7526, 1740.8367, 1837.8895, 1968.9299, 2025.9514, 2139.0355, 2267.0940, 2354.1261, 2517.1894, 2630.2735, 2793.3368, 2922.3794, 3035.4635, 3164.5060, 3293.5486, 3408.5756, 3479.6127, 3608.6553, 3771.7186, 3902.7591, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 278.1533, 441.2166, 570.2592, 641.2963, 756.3233, 885.3659, 1014.4085, 1127.4925, 1256.5351, 1419.5984, 1532.6825, 1695.7458, 1782.7779, 1910.8364, 2023.9205, 2080.9420, 2211.9825, 2309.0352, 2422.1193, 2521.1877, 2636.2146, 2783.2830, 2946.3464, 3075.3890, 3188.4730, 3335.5414, 3434.6099, 3563.6525, 3676.7365, 3804.7951, 3919.8220, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SFWLCNAFSFQNELETPEEICPYPNDWEAPSLR", {88.0393, 235.1077, 421.1870, 534.2711, 694.3017, 808.3447, 879.3818, 1026.4502, 1113.4822, 1260.5506, 1388.6092, 1502.6521, 1631.6947, 1744.7788, 1873.8214, 1974.8691, 2071.9218, 2200.9644, 2330.0070, 2443.0911, 2603.1217, 2700.1745, 2863.2378, 2960.2906, 3074.3335, 3189.3605, 3375.4398, 3504.4824, 3575.5195, 3672.5722, 3759.6043, 3872.6883, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 375.2350, 472.2878, 543.3249, 672.3675, 858.4468, 973.4738, 1087.5167, 1184.5695, 1347.6328, 1444.6856, 1604.7162, 1717.8003, 1846.8429, 1975.8855, 2072.9382, 2173.9859, 2303.0285, 2416.1126, 2545.1551, 2659.1981, 2787.2567, 2934.3251, 3021.3571, 3168.4255, 3239.4626, 3353.5055, 3513.5362, 3626.6203, 3812.6996, 3959.7680, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LDCVMFLDEEDQFSFWLNVLFPHELSSLLEVEK", {114.0913, 229.1183, 389.1489, 488.2173, 619.2578, 766.3262, 879.4103, 994.4373, 1123.4798, 1252.5224, 1367.5494, 1495.6080, 1642.6764, 1729.7084, 1876.7768, 2062.8561, 2175.9402, 2289.9831, 2389.0515, 2502.1356, 2649.2040, 2746.2568, 2883.3157, 3012.3583, 3125.4423, 3212.4744, 3299.5064, 3412.5905, 3525.6745, 3654.7171, 3753.7855, 3882.8281, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 276.1554, 375.2238, 504.2664, 617.3505, 730.4345, 817.4666, 904.4986, 1017.5827, 1146.6252, 1283.6842, 1380.7369, 1527.8053, 1640.8894, 1739.9578, 1854.0007, 1967.0848, 2153.1641, 2300.2325, 2387.2646, 2534.3330, 2662.3916, 2777.4185, 2906.4611, 3035.5037, 3150.5306, 3263.6147, 3410.6831, 3541.7236, 3640.7920, 3800.8226, 3915.8496, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"HYAGYFGFIIFLIHFFNVLIPAWMYGLFDFVQR", {138.0662, 301.1295, 372.1666, 429.1881, 592.2514, 739.3198, 796.3413, 943.4097, 1056.4938, 1169.5778, 1316.6463, 1429.7303, 1542.8144, 1679.8733, 1826.9417, 1974.0101, 2088.0531, 2187.1215, 2300.2055, 2413.2896, 2510.3424, 2581.3795, 2767.4588, 2898.4993, 3061.5626, 3118.5841, 3231.6681, 3378.7365, 3493.7635, 3640.8319, 3739.9003, 3867.9589, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 402.2459, 549.3144, 664.3413, 811.4097, 924.4938, 981.5152, 1144.5786, 1275.6191, 1461.6984, 1532.7355, 1629.7882, 1742.8723, 1855.9564, 1955.0248, 2069.0677, 2216.1361, 2363.2045, 2500.2635, 2613.3475, 2726.4316, 2873.5000, 2986.5841, 3099.6681, 3246.7365, 3303.7580, 3450.8264, 3613.8897, 3670.9112, 3741.9483, 3905.0117, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SNQVLLSNEFATENTYPLMTTCDWWSFNFSCLK", {88.0393, 202.0822, 330.1408, 429.2092, 542.2933, 655.3774, 742.4094, 856.4523, 985.4949, 1132.5633, 1203.6004, 1304.6481, 1433.6907, 1547.7336, 1648.7813, 1811.8446, 1908.8974, 2021.9815, 2153.0219, 2254.0696, 2355.1173, 2515.1480, 2630.1749, 2816.2542, 3002.3335, 3089.3656, 3236.4340, 3350.4769, 3497.5453, 3584.5773, 3744.6080, 3857.6920, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 420.2275, 507.2595, 654.3280, 768.3709, 915.4393, 1002.4713, 1188.5506, 1374.6300, 1489.6569, 1649.6875, 1750.7352, 1851.7829, 1982.8234, 2095.9075, 2192.9602, 2356.0235, 2457.0712, 2571.1142, 2700.1567, 2801.2044, 2872.2415, 3019.3100, 3148.3525, 3262.3955, 3349.4275, 3462.5116, 3575.5956, 3674.6640, 3802.7226, 3916.7655, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QDLFGEHMHVLTDLLYIFDCLYDLTYWFAPASK", {129.0659, 244.0928, 357.1769, 504.2453, 561.2667, 690.3093, 827.3682, 958.4087, 1095.4676, 1194.5361, 1307.6201, 1408.6678, 1523.6947, 1636.7788, 1749.8629, 1912.9262, 2026.0103, 2173.0787, 2288.1056, 2448.1363, 2561.2203, 2724.2837, 2839.3106, 2952.3947, 3053.4423, 3216.5057, 3402.5850, 3549.6534, 3620.6905, 3717.7433, 3788.7804, 3875.8124, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 234.1448, 305.1819, 402.2347, 473.2718, 620.3402, 806.4196, 969.4829, 1070.5306, 1183.6146, 1298.6416, 1461.7049, 1574.7890, 1734.8196, 1849.8465, 1996.9150, 2109.9990, 2273.0624, 2386.1464, 2499.2305, 2614.2574, 2715.3051, 2828.3892, 2927.4576, 3064.5165, 3195.5570, 3332.6159, 3461.6585, 3518.6799, 3665.7484, 3778.8324, 3893.8594, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"WACTYFVEDPDPDAYCHLLQMGGQRPCEYVTVR", {187.0866, 258.1237, 418.1544, 519.2020, 682.2654, 829.3338, 928.4022, 1057.4448, 1172.4717, 1269.5245, 1384.5514, 1481.6042, 1596.6311, 1667.6683, 1830.7316, 1990.7622, 2127.8211, 2240.9052, 2353.9893, 2482.0478, 2613.0883, 2670.1098, 2727.1313, 2855.1898, 3011.2909, 3108.3437, 3268.3744, 3397.4170, 3560.4803, 3659.5487, 3760.5964, 3859.6648, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 274.1874, 375.2350, 474.3035, 637.3668, 766.4094, 926.4400, 1023.4928, 1179.5939, 1307.6525, 1364.6739, 1421.6954, 1552.7359, 1680.7945, 1793.8785, 1906.9626, 2044.0215, 2204.0522, 2367.1155, 2438.1526, 2553.1795, 2650.2323, 2765.2593, 2862.3120, 2977.3390, 3106.3816, 3205.4500, 3352.5184, 3515.5817, 3616.6294, 3776.6600, 3847.6971, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FYYYFANFGVDELYYALDHDYNLSGHVNSYNTR", {148.0757, 311.1390, 474.2023, 637.2657, 784.3341, 855.3712, 969.4141, 1116.4825, 1173.5040, 1272.5724, 1387.5994, 1516.6420, 1629.7260, 1792.7894, 1955.8527, 2026.8898, 2139.9739, 2255.0008, 2392.0597, 2507.0867, 2670.1500, 2784.1929, 2897.2770, 2984.3090, 3041.3305, 3178.3894, 3277.4578, 3391.5007, 3478.5328, 3641.5961, 3755.6390, 3856.6867, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 276.1666, 390.2096, 553.2729, 640.3049, 754.3478, 853.4163, 990.4752, 1047.4966, 1134.5287, 1247.6127, 1361.6557, 1524.7190, 1639.7459, 1776.8048, 1891.8318, 2004.9158, 2075.9530, 2239.0163, 2402.0796, 2515.1637, 2644.2063, 2759.2332, 2858.3016, 2915.3231, 3062.3915, 3176.4344, 3247.4715, 3394.5400, 3557.6033, 3720.6666, 3883.7299, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PYLNLLYEPEAPEMNETNYIYPLDTFDLPPLCR", {98.0600, 261.1234, 374.2074, 488.2504, 601.3344, 714.4185, 877.4818, 1006.5244, 1103.5772, 1232.6198, 1303.6569, 1400.7096, 1529.7522, 1660.7927, 1774.8357, 1903.8782, 2004.9259, 2118.9688, 2282.0322, 2395.1162, 2558.1796, 2655.2323, 2768.3164, 2883.3433, 2984.3910, 3131.4594, 3246.4864, 3359.5704, 3456.6232, 3553.6760, 3666.7600, 3826.7907, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 335.1496, 448.2337, 545.2864, 642.3392, 755.4233, 870.4502, 1017.5186, 1118.5663, 1233.5932, 1346.6773, 1443.7301, 1606.7934, 1719.8775, 1882.9408, 1996.9837, 2098.0314, 2227.0740, 2341.1169, 2472.1574, 2601.2000, 2698.2528, 2769.2899, 2898.3325, 2995.3852, 3124.4278, 3287.4911, 3400.5752, 3513.6593, 3627.7022, 3740.7863, 3903.8496, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"AVEENPLYQVTCTFQETMYTPALHSVQHVYHWK", {72.0444, 171.1128, 300.1554, 429.1980, 543.2409, 640.2937, 753.3777, 916.4411, 1044.4997, 1143.5681, 1244.6157, 1404.6464, 1505.6941, 1652.7625, 1780.8211, 1909.8637, 2010.9113, 2141.9518, 2305.0151, 2406.0628, 2503.1156, 2574.1527, 2687.2368, 2824.2957, 2911.3277, 3010.3961, 3138.4547, 3275.5136, 3374.5820, 3537.6454, 3674.7043, 3860.7836, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 333.1921, 470.2510, 633.3144, 732.3828, 869.4417, 997.5003, 1096.5687, 1183.6007, 1320.6596, 1433.7437, 1504.7808, 1601.8336, 1702.8812, 1865.9446, 1996.9850, 2098.0327, 2227.0753, 2355.1339, 2502.2023, 2603.2500, 2763.2806, 2864.3283, 2963.3967, 3091.4553, 3254.5186, 3367.6027, 3464.6555, 3578.6984, 3707.7410, 3836.7836, 3935.8520, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VYDPPECDVAQITLFNSHDIVQYVFFSDCQIGHK", {100.0757, 263.1390, 378.1660, 475.2187, 572.2715, 701.3141, 861.3447, 976.3717, 1075.4401, 1146.4772, 1274.5358, 1387.6198, 1488.6675, 1601.7516, 1748.8200, 1862.8629, 1949.8950, 2086.9539, 2201.9808, 2315.0649, 2414.1333, 2542.1919, 2705.2552, 2804.3236, 2951.3920, 3098.4604, 3185.4925, 3300.5194, 3460.5501, 3588.6086, 3701.6927, 3758.7142, 3895.7731, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 284.1717, 341.1932, 454.2772, 582.3358, 742.3665, 857.3934, 944.4254, 1091.4939, 1238.5623, 1337.6307, 1500.6940, 1628.7526, 1727.8210, 1840.9051, 1955.9320, 2092.9909, 2180.0230, 2294.0659, 2441.1343, 2554.2184, 2655.2660, 2768.3501, 2896.4087, 2967.4458, 3066.5142, 3181.5411, 3341.5718, 3470.6144, 3567.6672, 3664.7199, 3779.7469, 3942.8102, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"HSPSQSQSEAENSNVAQLSHWNILWNNCSFCLFK", {138.0662, 225.0982, 322.1510, 409.1830, 537.2416, 624.2736, 752.3322, 839.3642, 968.4068, 1039.4439, 1168.4865, 1282.5294, 1369.5615, 1483.6044, 1582.6728, 1653.7099, 1781.7685, 1894.8526, 1981.8846, 2118.9435, 2305.0228, 2419.0658, 2532.1498, 2645.2339, 2831.3132, 2945.3561, 3059.3991, 3219.4297, 3306.4617, 3453.5301, 3613.5608, 3726.6449, 3873.7133, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 294.1812, 407.2653, 567.2959, 714.3643, 801.3964, 961.4270, 1075.4699, 1189.5129, 1375.5922, 1488.6763, 1601.7603, 1715.8032, 1901.8826, 2038.9415, 2125.9735, 2239.0576, 2367.1161, 2438.1533, 2537.2217, 2651.2646, 2738.2966, 2852.3396, 2981.3821, 3052.4193, 3181.4619, 3268.4939, 3396.5525, 3483.5845, 3611.6431, 3698.6751, 3795.7279, 3882.7599, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"IFSATTWVYGMYLAFFNLYYLQGILIYDGTSEQR", {114.0913, 261.1598, 348.1918, 419.2289, 520.2766, 621.3243, 807.4036, 906.4720, 1069.5353, 1126.5568, 1257.5973, 1420.6606, 1533.7447, 1604.7818, 1751.8502, 1898.9186, 2012.9615, 2126.0456, 2289.1089, 2452.1722, 2565.2563, 2693.3149, 2750.3363, 2863.4204, 2976.5045, 3089.5885, 3252.6519, 3367.6788, 3424.7003, 3525.7480, 3612.7800, 3741.8226, 3869.8812, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 432.2201, 519.2522, 620.2998, 677.3213, 792.3482, 955.4116, 1068.4956, 1181.5797, 1294.6638, 1351.6852, 1479.7438, 1592.8279, 1755.8912, 1918.9545, 2032.0386, 2146.0815, 2293.1499, 2440.2183, 2511.2555, 2624.3395, 2787.4028, 2918.4433, 2975.4648, 3138.5281, 3237.5965, 3423.6758, 3524.7235, 3625.7712, 3696.8083, 3783.8403, 3930.9088, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QVQQQHYQQQPQQATAIPNQVTETIHQEFKPISK", {129.0659, 228.1343, 356.1928, 484.2514, 612.3100, 749.3689, 912.4322, 1040.4908, 1168.5494, 1296.6080, 1393.6607, 1521.7193, 1649.7779, 1720.8150, 1821.8627, 1892.8998, 2005.9839, 2103.0366, 2217.0796, 2345.1381, 2444.2065, 2545.2542, 2674.2968, 2775.3445, 2888.4286, 3025.4875, 3153.5460, 3282.5886, 3429.6571, 3557.7520, 3654.8048, 3767.8888, 3854.9209, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 234.1448, 347.2289, 444.2817, 572.3766, 719.4450, 848.4876, 976.5462, 1113.6051, 1226.6892, 1327.7369, 1456.7795, 1557.8271, 1656.8955, 1784.9541, 1898.9971, 1996.0498, 2109.1339, 2180.1710, 2281.2187, 2352.2558, 2480.3144, 2608.3729, 2705.4257, 2833.4843, 2961.5429, 3089.6014, 3252.6648, 3389.7237, 3517.7823, 3645.8408, 3773.8994, 3872.9678, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NMQVLSQAASWELHECLQDEQEEGDEDDLDIIER", {115.0502, 246.0907, 374.1493, 473.2177, 586.3017, 673.3338, 801.3924, 872.4295, 943.4666, 1030.4986, 1216.5779, 1345.6205, 1458.7046, 1595.7635, 1724.8061, 1884.8367, 1997.9208, 2125.9794, 2241.0063, 2370.0489, 2498.1075, 2627.1501, 2756.1927, 2813.2141, 2928.2411, 3057.2837, 3172.3106, 3287.3376, 3400.4216, 3515.4486, 3628.5326, 3741.6167, 3870.6593, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 417.2456, 530.3297, 645.3566, 758.4407, 873.4676, 988.4946, 1117.5372, 1232.5641, 1289.5856, 1418.6282, 1547.6708, 1675.7293, 1804.7719, 1919.7989, 2047.8574, 2160.9415, 2320.9722, 2450.0147, 2587.0737, 2700.1577, 2829.2003, 3015.2796, 3102.3117, 3173.3488, 3244.3859, 3372.4445, 3459.4765, 3572.5606, 3671.6290, 3799.6875, 3930.7280, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QEWQQLLEPISGNEGGYEVPLYQKPIQNYLAEWK", {129.0659, 258.1084, 444.1878, 572.2463, 700.3049, 813.3890, 926.4730, 1055.5156, 1152.5684, 1265.6525, 1352.6845, 1409.7060, 1523.7489, 1652.7915, 1709.8129, 1766.8344, 1929.8977, 2058.9403, 2158.0087, 2255.0615, 2368.1456, 2531.2089, 2659.2675, 2787.3624, 2884.4152, 2997.4993, 3125.5578, 3239.6008, 3402.6641, 3515.7482, 3586.7853, 3715.8279, 3901.9072, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 333.1921, 462.2347, 533.2718, 646.3559, 809.4192, 923.4621, 1051.5207, 1164.6048, 1261.6575, 1389.7525, 1517.8111, 1680.8744, 1793.9585, 1891.0112, 1990.0797, 2119.1223, 2282.1856, 2339.2070, 2396.2285, 2525.2711, 2639.3140, 2696.3355, 2783.3675, 2896.4516, 2993.5044, 3122.5469, 3235.6310, 3348.7151, 3476.7736, 3604.8322, 3790.9115, 3919.9541, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QTLFVQSTTHNCLEEFDHNENSTEFLPNIDLSDK", {129.0659, 230.1135, 343.1976, 490.2660, 589.3344, 717.3930, 804.4250, 905.4727, 1006.5204, 1143.5793, 1257.6222, 1417.6529, 1530.7369, 1659.7795, 1788.8221, 1935.8905, 2050.9175, 2187.9764, 2302.0193, 2431.0619, 2545.1048, 2632.1369, 2733.1845, 2862.2271, 3009.2956, 3122.3796, 3219.4324, 3333.4753, 3446.5594, 3561.5863, 3674.6704, 3761.7024, 3876.7294, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 262.1397, 349.1718, 462.2558, 577.2828, 690.3668, 804.4098, 901.4625, 1014.5466, 1161.6150, 1290.6576, 1391.7053, 1478.7373, 1592.7802, 1721.8228, 1835.8658, 1972.9247, 2087.9516, 2235.0200, 2364.0626, 2493.1052, 2606.1893, 2766.2199, 2880.2629, 3017.3218, 3118.3694, 3219.4171, 3306.4492, 3434.5077, 3533.5761, 3680.6446, 3793.7286, 3894.7763, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ASGSSHSSYCDCHCIDCCSDTLELQELLHLHEAK", {72.0444, 159.0764, 216.0979, 303.1299, 390.1619, 527.2209, 614.2529, 701.2849, 864.3482, 1024.3789, 1139.4058, 1299.4365, 1436.4954, 1596.5260, 1709.6101, 1824.6370, 1984.6677, 2144.6983, 2231.7304, 2346.7573, 2447.8050, 2560.8891, 2689.9316, 2803.0157, 2931.0743, 3060.1169, 3173.2009, 3286.2850, 3423.3439, 3536.4280, 3673.4869, 3802.5295, 3873.5666, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 218.1499, 347.1925, 484.2514, 597.3355, 734.3944, 847.4785, 960.5625, 1089.6051, 1217.6637, 1330.7478, 1459.7904, 1572.8744, 1673.9221, 1788.9490, 1875.9811, 2036.0117, 2196.0424, 2311.0693, 2424.1534, 2584.1840, 2721.2429, 2881.2736, 2996.3005, 3156.3312, 3319.3945, 3406.4265, 3493.4586, 3630.5175, 3717.5495, 3804.5815, 3861.6030, 3948.6350, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ANYHQVYLLEITLFSMALIIFLVYFITLNSVMLR", {72.0444, 186.0873, 349.1506, 486.2096, 614.2681, 713.3365, 876.3999, 989.4839, 1102.5680, 1231.6106, 1344.6947, 1445.7423, 1558.8264, 1705.8948, 1792.9268, 1923.9673, 1995.0044, 2108.0885, 2221.1726, 2334.2566, 2481.3251, 2594.4091, 2693.4775, 2856.5409, 3003.6093, 3116.6933, 3217.7410, 3330.8251, 3444.8680, 3531.9000, 3630.9684, 3762.0089, 3875.0930, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 419.2435, 518.3119, 605.3439, 719.3869, 832.4709, 933.5186, 1046.6027, 1193.6711, 1356.7344, 1455.8028, 1568.8869, 1715.9553, 1829.0394, 1942.1234, 2055.2075, 2126.2446, 2257.2851, 2344.3171, 2491.3855, 2604.4696, 2705.5173, 2818.6014, 2947.6439, 3060.7280, 3173.8121, 3336.8754, 3435.9438, 3564.0024, 3701.0613, 3864.1246, 3978.1676, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LFKPTATILFFLGWMSGYHLMMLSWFPLSLVLEK", {114.0913, 261.1598, 389.2547, 486.3075, 587.3552, 658.3923, 759.4400, 872.5240, 985.6081, 1132.6765, 1279.7449, 1392.8290, 1449.8504, 1635.9297, 1766.9702, 1854.0023, 1911.0237, 2074.0871, 2211.1460, 2324.2300, 2455.2705, 2586.3110, 2699.3951, 2786.4271, 2972.5064, 3119.5748, 3216.6276, 3329.7116, 3416.7437, 3529.8277, 3628.8962, 3741.9802, 3871.0228, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 276.1554, 389.2395, 488.3079, 601.3919, 688.4240, 801.5080, 898.5608, 1045.6292, 1231.7085, 1318.7406, 1431.8246, 1562.8651, 1693.9056, 1806.9896, 1944.0486, 2107.1119, 2164.1334, 2251.1654, 2382.2059, 2568.2852, 2625.3066, 2738.3907, 2885.4591, 3032.5275, 3145.6116, 3258.6957, 3359.7433, 3430.7805, 3531.8281, 3628.8809, 3756.9759, 3904.0443, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LFDSEINGTWLHDVIIDHDYPCTHNINSSGQYIK", {114.0913, 261.1598, 376.1867, 463.2187, 592.2613, 705.3454, 819.3883, 876.4098, 977.4575, 1163.5368, 1276.6208, 1413.6797, 1528.7067, 1627.7751, 1740.8592, 1853.9432, 1968.9702, 2106.0291, 2221.0560, 2384.1194, 2481.1721, 2641.2028, 2742.2504, 2879.3094, 2993.3523, 3106.4363, 3220.4793, 3307.5113, 3394.5433, 3451.5648, 3579.6234, 3742.6867, 3855.7708, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 423.2602, 551.3188, 608.3402, 695.3723, 782.4043, 896.4472, 1009.5313, 1123.5742, 1260.6331, 1361.6808, 1521.7115, 1618.7642, 1781.8275, 1896.8545, 2033.9134, 2148.9403, 2262.0244, 2375.1085, 2474.1769, 2589.2038, 2726.2627, 2839.3468, 3025.4261, 3126.4738, 3183.4953, 3297.5382, 3410.6223, 3539.6648, 3626.6969, 3741.7238, 3888.7922, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MPIFTTFFGHSFYAFFVFPPVTCVIHPIVWAVDK", {132.0478, 229.1005, 342.1846, 489.2530, 590.3007, 691.3484, 838.4168, 985.4852, 1042.5067, 1179.5656, 1266.5976, 1413.6660, 1576.7293, 1647.7664, 1794.8349, 1941.9033, 2040.9717, 2188.0401, 2285.0929, 2382.1456, 2481.2140, 2582.2617, 2742.2924, 2841.3608, 2954.4449, 3091.5038, 3188.5565, 3301.6406, 3400.7090, 3586.7883, 3657.8254, 3756.8938, 3871.9208, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 262.1397, 361.2082, 432.2453, 618.3246, 717.3930, 830.4771, 927.5298, 1064.5887, 1177.6728, 1276.7412, 1436.7719, 1537.8195, 1636.8880, 1733.9407, 1830.9935, 1978.0619, 2077.1303, 2224.1987, 2371.2671, 2442.3043, 2605.3676, 2752.4360, 2839.4680, 2976.5269, 3033.5484, 3180.6168, 3327.6852, 3428.7329, 3529.7806, 3676.8490, 3789.9331, 3886.9858, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"GFIWATGQVILSIFLNVMLYLFFGTTIMWPVFFK", {58.0287, 205.0972, 318.1812, 504.2605, 575.2976, 676.3453, 733.3668, 861.4254, 960.4938, 1073.5778, 1186.6619, 1273.6939, 1386.7780, 1533.8464, 1646.9305, 1760.9734, 1860.0418, 1991.0823, 2104.1664, 2267.2297, 2380.3138, 2527.3822, 2674.4506, 2731.4721, 2832.5197, 2933.5674, 3046.6515, 3177.6920, 3363.7713, 3460.8240, 3559.8924, 3706.9609, 3854.0293, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 294.1812, 441.2496, 540.3180, 637.3708, 823.4501, 954.4906, 1067.5747, 1168.6224, 1269.6700, 1326.6915, 1473.7599, 1620.8283, 1733.9124, 1896.9757, 2010.0598, 2141.1003, 2240.1687, 2354.2116, 2467.2957, 2614.3641, 2727.4481, 2814.4802, 2927.5642, 3040.6483, 3139.7167, 3267.7753, 3324.7968, 3425.8444, 3496.8815, 3682.9609, 3796.0449, 3943.1133, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VETAWYYIDWDNSVGNILQDYQATQEASFNQLHK", {100.0757, 229.1183, 330.1660, 401.2031, 587.2824, 750.3457, 913.4090, 1026.4931, 1141.5201, 1327.5994, 1442.6263, 1556.6692, 1643.7013, 1742.7697, 1799.7911, 1913.8341, 2026.9181, 2140.0022, 2268.0608, 2383.0877, 2546.1510, 2674.2096, 2745.2467, 2846.2944, 2974.3530, 3103.3956, 3174.4327, 3261.4647, 3408.5331, 3522.5761, 3650.6346, 3763.7187, 3900.7776, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 284.1717, 397.2558, 525.3144, 639.3573, 786.4257, 873.4577, 944.4948, 1073.5374, 1201.5960, 1302.6437, 1373.6808, 1501.7394, 1664.8027, 1779.8297, 1907.8882, 2020.9723, 2134.0564, 2248.0993, 2305.1208, 2404.1892, 2491.2212, 2605.2641, 2720.2911, 2906.3704, 3021.3973, 3134.4814, 3297.5447, 3460.6080, 3646.6874, 3717.7245, 3818.7721, 3947.8147, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VVYFDQLLPHAYFENLFDMITDAHLTTSCVVVHK", {100.0757, 199.1441, 362.2074, 509.2758, 624.3028, 752.3614, 865.4454, 978.5295, 1075.5823, 1212.6412, 1283.6783, 1446.7416, 1593.8100, 1722.8526, 1836.8955, 1949.9796, 2097.0480, 2212.0750, 2343.1155, 2456.1995, 2557.2472, 2672.2741, 2743.3113, 2880.3702, 2993.4542, 3094.5019, 3195.5496, 3282.5816, 3442.6123, 3541.6807, 3640.7491, 3739.8175, 3876.8764, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 284.1717, 383.2401, 482.3085, 581.3770, 741.4076, 828.4396, 929.4873, 1030.5350, 1143.6191, 1280.6780, 1351.7151, 1466.7420, 1567.7897, 1680.8738, 1811.9143, 1926.9412, 2074.0096, 2187.0937, 2301.1366, 2430.1792, 2577.2476, 2740.3109, 2811.3480, 2948.4070, 3045.4597, 3158.5438, 3271.6279, 3399.6864, 3514.7134, 3661.7818, 3824.8451, 3923.9135, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YLQSPWIDPVFDGYGVTSFTVVVYYTSQFLNLHR", {164.0706, 277.1547, 405.2132, 492.2453, 589.2980, 775.3774, 888.4614, 1003.4884, 1100.5411, 1199.6095, 1346.6780, 1461.7049, 1518.7264, 1681.7897, 1738.8111, 1837.8796, 1938.9272, 2025.9593, 2173.0277, 2274.0754, 2373.1438, 2472.2122, 2571.2806, 2734.3439, 2897.4073, 2998.4549, 3085.4870, 3213.5455, 3360.6140, 3473.6980, 3587.7410, 3700.8250, 3837.8839, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 312.1779, 425.2619, 539.3049, 652.3889, 799.4573, 927.5159, 1014.5479, 1115.5956, 1278.6589, 1441.7223, 1540.7907, 1639.8591, 1738.9275, 1839.9752, 1987.0436, 2074.0756, 2175.1233, 2274.1917, 2331.2132, 2494.2765, 2551.2980, 2666.3249, 2813.3933, 2912.4618, 3009.5145, 3124.5415, 3237.6255, 3423.7048, 3520.7576, 3607.7896, 3735.8482, 3848.9323, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"IEAEECLLGFCSLSTLVADLDVSWLYMFFVVEMK", {114.0913, 243.1339, 314.1710, 443.2136, 572.2562, 732.2869, 845.3709, 958.4550, 1015.4765, 1162.5449, 1322.5755, 1409.6076, 1522.6916, 1609.7237, 1710.7713, 1823.8554, 1922.9238, 1993.9609, 2108.9879, 2222.0719, 2337.0989, 2436.1673, 2523.1993, 2709.2786, 2822.3627, 2985.4260, 3116.4665, 3263.5349, 3410.6033, 3509.6718, 3608.7402, 3737.7828, 3868.8232, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 278.1533, 407.1959, 506.2643, 605.3327, 752.4011, 899.4695, 1030.5100, 1193.5734, 1306.6574, 1492.7367, 1579.7688, 1678.8372, 1793.8641, 1906.9482, 2021.9751, 2093.0122, 2192.0806, 2305.1647, 2406.2124, 2493.2444, 2606.3285, 2693.3605, 2853.3912, 3000.4596, 3057.4810, 3170.5651, 3283.6492, 3443.6798, 3572.7224, 3701.7650, 3772.8021, 3901.8447, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"CPAFPVCLAHCTLILSEGCSCLESCEVDDLSYIR", {161.0379, 258.0907, 329.1278, 476.1962, 573.2490, 672.3174, 832.3480, 945.4321, 1016.4692, 1153.5281, 1313.5588, 1414.6065, 1527.6905, 1640.7746, 1753.8587, 1840.8907, 1969.9333, 2026.9547, 2186.9854, 2274.0174, 2434.0481, 2547.1321, 2676.1747, 2763.2067, 2923.2374, 3052.2800, 3151.3484, 3266.3753, 3381.4023, 3494.4864, 3581.5184, 3744.5817, 3857.6658, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 451.2663, 538.2984, 651.3824, 766.4094, 881.4363, 980.5047, 1109.5473, 1269.5780, 1356.6100, 1485.6526, 1598.7367, 1758.7673, 1845.7993, 2005.8300, 2062.8515, 2191.8940, 2278.9261, 2392.0101, 2505.0942, 2618.1783, 2719.2259, 2879.2566, 3016.3155, 3087.3526, 3200.4367, 3360.4673, 3459.5357, 3556.5885, 3703.6569, 3774.6940, 3871.7468, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LQYQFYLHFYEGLFGTHETAPVINFNLLVGQENK", {114.0913, 242.1499, 405.2132, 533.2718, 680.3402, 843.4036, 956.4876, 1093.5465, 1240.6150, 1403.6783, 1532.7209, 1589.7423, 1702.8264, 1849.8948, 1906.9163, 2007.9640, 2145.0229, 2274.0655, 2375.1131, 2446.1503, 2543.2030, 2642.2714, 2755.3555, 2869.3984, 3016.4668, 3130.5098, 3243.5938, 3356.6779, 3455.7463, 3512.7678, 3640.8264, 3769.8689, 3883.9119, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 261.1557, 390.1983, 518.2569, 575.2784, 674.3468, 787.4308, 900.5149, 1014.5578, 1161.6262, 1275.6692, 1388.7532, 1487.8217, 1584.8744, 1655.9115, 1756.9592, 1886.0018, 2023.0607, 2124.1084, 2181.1299, 2328.1983, 2441.2823, 2498.3038, 2627.3464, 2790.4097, 2937.4781, 3074.5370, 3187.6211, 3350.6844, 3497.7529, 3625.8114, 3788.8748, 3916.9333, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VIYLLFLVDLTPSCYQTLQFDVICCANPLVSSEK", {100.0757, 213.1598, 376.2231, 489.3071, 602.3912, 749.4596, 862.5437, 961.6121, 1076.6390, 1189.7231, 1290.7708, 1387.8236, 1474.8556, 1634.8862, 1797.9496, 1926.0081, 2027.0558, 2140.1399, 2268.1985, 2415.2669, 2530.2938, 2629.3622, 2742.4463, 2902.4769, 3062.5076, 3133.5447, 3247.5876, 3344.6404, 3457.7245, 3556.7929, 3643.8249, 3730.8569, 3859.8995, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 276.1554, 363.1874, 450.2195, 549.2879, 662.3719, 759.4247, 873.4676, 944.5047, 1104.5354, 1264.5660, 1377.6501, 1476.7185, 1591.7455, 1738.8139, 1866.8724, 1979.9565, 2081.0042, 2209.0628, 2372.1261, 2532.1567, 2619.1888, 2716.2415, 2817.2892, 2930.3733, 3045.4002, 3144.4686, 3257.5527, 3404.6211, 3517.7052, 3630.7892, 3793.8526, 3906.9366, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YDGLEVYITYIPYPLAIVMGTLWTACCCVFGPLR", {164.0706, 279.0975, 336.1190, 449.2031, 578.2457, 677.3141, 840.3774, 953.4615, 1054.5092, 1217.5725, 1330.6565, 1427.7093, 1590.7726, 1687.8254, 1800.9095, 1871.9466, 1985.0306, 2084.0991, 2215.1395, 2272.1610, 2373.2087, 2486.2927, 2672.3721, 2773.4197, 2844.4569, 3004.4875, 3164.5182, 3324.5488, 3423.6172, 3570.6856, 3627.7071, 3724.7599, 3837.8439, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 385.2558, 442.2772, 589.3457, 688.4141, 848.4447, 1008.4754, 1168.5060, 1239.5431, 1340.5908, 1526.6701, 1639.7542, 1740.8019, 1797.8233, 1928.8638, 2027.9322, 2141.0163, 2212.0534, 2325.1375, 2422.1902, 2585.2536, 2682.3063, 2795.3904, 2958.4537, 3059.5014, 3172.5855, 3335.6488, 3434.7172, 3563.7598, 3676.8439, 3733.8653, 3848.8923, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LIQSHAAYNFCTISLYSCVLMIIGIYTNQLSFQR", {114.0913, 227.1754, 355.2340, 442.2660, 579.3249, 650.3620, 721.3991, 884.4625, 998.5054, 1145.5738, 1305.6045, 1406.6521, 1519.7362, 1606.7682, 1719.8523, 1882.9156, 1969.9477, 2129.9783, 2229.0467, 2342.1308, 2473.1713, 2586.2553, 2699.3394, 2756.3609, 2869.4449, 3032.5083, 3133.5559, 3247.5989, 3375.6574, 3488.7415, 3575.7735, 3722.8419, 3850.9005, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 450.2459, 537.2780, 650.3620, 778.4206, 892.4635, 993.5112, 1156.5745, 1269.6586, 1326.6801, 1439.7641, 1552.8482, 1683.8887, 1796.9728, 1896.0412, 2056.0718, 2143.1038, 2306.1672, 2419.2512, 2506.2833, 2619.3673, 2720.4150, 2880.4457, 3027.5141, 3141.5570, 3304.6203, 3375.6574, 3446.6946, 3583.7535, 3670.7855, 3798.8441, 3911.9281, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"STENQCLNQVSEDSNDGCHNIGDCLLDPHICFER", {88.0393, 189.0870, 318.1296, 432.1725, 560.2311, 720.2617, 833.3458, 947.3887, 1075.4473, 1174.5157, 1261.5477, 1390.5903, 1505.6173, 1592.6493, 1706.6922, 1821.7192, 1878.7406, 2038.7713, 2175.8302, 2289.8731, 2402.9572, 2459.9787, 2575.0056, 2735.0362, 2848.1203, 2961.2044, 3076.2313, 3173.2841, 3310.3430, 3423.4271, 3583.4577, 3730.5261, 3859.5687, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 451.2300, 611.2606, 724.3447, 861.4036, 958.4563, 1073.4833, 1186.5674, 1299.6514, 1459.6821, 1574.7090, 1631.7305, 1744.8145, 1858.8575, 1995.9164, 2155.9470, 2212.9685, 2327.9954, 2442.0384, 2529.0704, 2644.0973, 2773.1399, 2860.1720, 2959.2404, 3087.2989, 3201.3419, 3314.4259, 3474.4566, 3602.5152, 3716.5581, 3845.6007, 3946.6484, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NPGSGWQCYIDADSDLHDPCHVSCVHYQLENLSK", {115.0502, 212.1030, 269.1244, 356.1565, 413.1779, 599.2572, 727.3158, 887.3465, 1050.4098, 1163.4939, 1278.5208, 1349.5579, 1464.5849, 1551.6169, 1666.6438, 1779.7279, 1916.7868, 2031.8137, 2128.8665, 2288.8972, 2425.9561, 2525.0245, 2612.0565, 2772.0872, 2871.1556, 3008.2145, 3171.2778, 3299.3364, 3412.4205, 3541.4630, 3655.5060, 3768.5900, 3855.6221, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 234.1448, 347.2289, 461.2718, 590.3144, 703.3985, 831.4571, 994.5204, 1131.5793, 1230.6477, 1390.6784, 1477.7104, 1576.7788, 1713.8377, 1873.8684, 1970.9211, 2085.9481, 2223.0070, 2336.0910, 2451.1180, 2538.1500, 2653.1770, 2724.2141, 2839.2410, 2952.3251, 3115.3884, 3275.4191, 3403.4776, 3589.5570, 3646.5784, 3733.6104, 3790.6319, 3887.6847, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LMYPCGVSMLTVSLCMLIFSPDQLLSIDLYMEIR", {114.0913, 245.1318, 408.1952, 505.2479, 665.2786, 722.3000, 821.3684, 908.4005, 1039.4410, 1152.5250, 1253.5727, 1352.6411, 1439.6731, 1552.7572, 1712.7879, 1843.8283, 1956.9124, 2069.9965, 2217.0649, 2304.0969, 2401.1497, 2516.1766, 2644.2352, 2757.3193, 2870.4033, 2957.4354, 3070.5194, 3185.5464, 3298.6304, 3461.6937, 3592.7342, 3721.7768, 3834.8609, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 417.2456, 548.2861, 711.3494, 824.4335, 939.4604, 1052.5445, 1139.5765, 1252.6606, 1365.7447, 1493.8032, 1608.8302, 1705.8829, 1792.9150, 1939.9834, 2053.0674, 2166.1515, 2297.1920, 2457.2226, 2570.3067, 2657.3387, 2756.4071, 2857.4548, 2970.5389, 3101.5794, 3188.6114, 3287.6798, 3344.7013, 3504.7319, 3601.7847, 3764.8480, 3895.8885, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LYEMFCHFITLHTNYSLGLAFVQNLDIGFHSLIK", {114.0913, 277.1547, 406.1973, 537.2377, 684.3062, 844.3368, 981.3957, 1128.4641, 1241.5482, 1342.5959, 1455.6799, 1592.7389, 1693.7865, 1807.8295, 1970.8928, 2057.9248, 2171.0089, 2228.0303, 2341.1144, 2412.1515, 2559.2199, 2658.2883, 2786.3469, 2900.3899, 3013.4739, 3128.5009, 3241.5849, 3298.6064, 3445.6748, 3582.7337, 3669.7657, 3782.8498, 3895.9339, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 373.2809, 460.3130, 597.3719, 744.4403, 801.4618, 914.5458, 1029.5728, 1142.6568, 1256.6997, 1384.7583, 1483.8267, 1630.8952, 1701.9323, 1815.0163, 1872.0378, 1985.1219, 2072.1539, 2235.2172, 2349.2601, 2450.3078, 2587.3667, 2700.4508, 2801.4985, 2914.5825, 3061.6510, 3198.7099, 3358.7405, 3505.8089, 3636.8494, 3765.8920, 3928.9553, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VLIATITFYILFTLAHCYAVISCMLLCGLIPLYR", {100.0757, 213.1598, 326.2438, 397.2809, 498.3286, 611.4127, 712.4604, 859.5288, 1022.5921, 1135.6762, 1248.7602, 1395.8286, 1496.8763, 1609.9604, 1680.9975, 1818.0564, 1978.0871, 2141.1504, 2212.1875, 2311.2559, 2424.3400, 2511.3720, 2671.4027, 2802.4431, 2915.5272, 3028.6113, 3188.6419, 3245.6634, 3358.7474, 3471.8315, 3568.8843, 3681.9683, 3845.0317, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 451.2663, 548.3191, 661.4032, 774.4872, 831.5087, 991.5393, 1104.6234, 1217.7075, 1348.7480, 1508.7786, 1595.8106, 1708.8947, 1807.9631, 1879.0002, 2042.0636, 2202.0942, 2339.1531, 2410.1902, 2523.2743, 2624.3220, 2771.3904, 2884.4745, 2997.5585, 3160.6218, 3307.6903, 3408.7379, 3521.8220, 3622.8697, 3693.9068, 3806.9909, 3920.0749, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"HSLVYSYMTLNDITISQPDSDNTYSEVFTYNLFR", {138.0662, 225.0982, 338.1823, 437.2507, 600.3140, 687.3461, 850.4094, 981.4499, 1082.4975, 1195.5816, 1309.6245, 1424.6515, 1537.7355, 1638.7832, 1751.8673, 1838.8993, 1966.9579, 2064.0107, 2179.0376, 2266.0696, 2381.0966, 2495.1395, 2596.1872, 2759.2505, 2846.2825, 2975.3251, 3074.3935, 3221.4620, 3322.5096, 3485.5730, 3599.6159, 3712.7000, 3859.7684, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 435.2714, 549.3144, 712.3777, 813.4254, 960.4938, 1059.5622, 1188.6048, 1275.6368, 1438.7001, 1539.7478, 1653.7907, 1768.8177, 1855.8497, 1970.8767, 2067.9294, 2195.9880, 2283.0200, 2396.1041, 2497.1518, 2610.2358, 2725.2628, 2839.3057, 2952.3898, 3053.4375, 3184.4779, 3347.5413, 3434.5733, 3597.6366, 3696.7050, 3809.7891, 3896.8211, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QQDGEMTMEVGEEQEQYEEEVIVVDDEEHHSDAR", {129.0659, 257.1244, 372.1514, 429.1728, 558.2154, 689.2559, 790.3036, 921.3441, 1050.3867, 1149.4551, 1206.4766, 1335.5191, 1464.5617, 1592.6203, 1721.6629, 1849.7215, 2012.7848, 2141.8274, 2270.8700, 2399.9126, 2498.9810, 2612.0651, 2711.1335, 2810.2019, 2925.2288, 3040.2558, 3169.2984, 3298.3410, 3435.3999, 3572.4588, 3659.4908, 3774.5178, 3845.5549, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 246.1561, 361.1830, 448.2150, 585.2739, 722.3329, 851.3755, 980.4180, 1095.4450, 1210.4719, 1309.5403, 1408.6088, 1521.6928, 1620.7612, 1749.8038, 1878.8464, 2007.8890, 2170.9523, 2299.0109, 2428.0535, 2556.1121, 2685.1547, 2814.1973, 2871.2187, 2970.2872, 3099.3298, 3230.3702, 3331.4179, 3462.4584, 3591.5010, 3648.5225, 3763.5494, 3891.6080, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NEEMMDEHDVHEEVMEEEDVEDNIAEEVAAQLEK", {115.0502, 244.0928, 373.1354, 504.1759, 635.2164, 750.2433, 879.2859, 1016.3448, 1131.3718, 1230.4402, 1367.4991, 1496.5417, 1625.5843, 1724.6527, 1855.6932, 1984.7358, 2113.7783, 2242.8209, 2357.8479, 2456.9163, 2585.9589, 2700.9858, 2815.0288, 2928.1128, 2999.1499, 3128.1925, 3257.2351, 3356.3035, 3427.3407, 3498.3778, 3626.4363, 3739.5204, 3868.5630, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 276.1554, 389.2395, 517.2980, 588.3352, 659.3723, 758.4407, 887.4833, 1016.5259, 1087.5630, 1200.6470, 1314.6900, 1429.7169, 1558.7595, 1657.8279, 1772.8549, 1901.8975, 2030.9401, 2159.9826, 2291.0231, 2390.0915, 2519.1341, 2648.1767, 2785.2356, 2884.3041, 2999.3310, 3136.3899, 3265.4325, 3380.4594, 3511.4999, 3642.5404, 3771.5830, 3900.6256, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TSDGLFLGSTEYCQEVSYIEMNPDGELWQHQQQR", {102.0550, 189.0870, 304.1139, 361.1354, 474.2195, 621.2879, 734.3719, 791.3934, 878.4254, 979.4731, 1108.5157, 1271.5790, 1431.6097, 1559.6683, 1688.7108, 1787.7793, 1874.8113, 2037.8746, 2150.9587, 2280.0013, 2411.0418, 2525.0847, 2622.1374, 2737.1644, 2794.1859, 2923.2284, 3036.3125, 3222.3918, 3350.4504, 3487.5093, 3615.5679, 3743.6265, 3871.6850, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 431.2361, 559.2947, 696.3536, 824.4122, 1010.4915, 1123.5756, 1252.6181, 1309.6396, 1424.6666, 1521.7193, 1635.7622, 1766.8027, 1895.8453, 2008.9294, 2171.9927, 2259.0247, 2358.0932, 2487.1357, 2615.1943, 2775.2250, 2938.2883, 3067.3309, 3168.3786, 3255.4106, 3312.4321, 3425.5161, 3572.5845, 3685.6686, 3742.6901, 3857.7170, 3944.7490, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LYAEYDKPQAEDGWWEQPDLKPAPLDAWLQTVNR", {114.0913, 277.1547, 348.1918, 477.2344, 640.2977, 755.3246, 883.4196, 980.4724, 1108.5310, 1179.5681, 1308.6107, 1423.6376, 1480.6591, 1666.7384, 1852.8177, 1981.8603, 2109.9189, 2206.9716, 2321.9986, 2435.0826, 2563.1776, 2660.2304, 2731.2675, 2828.3202, 2941.4043, 3056.4312, 3127.4684, 3313.5477, 3426.6317, 3554.6903, 3655.7380, 3754.8064, 3868.8493, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 289.1619, 388.2303, 489.2780, 617.3365, 730.4206, 916.4999, 987.5370, 1102.5640, 1215.6480, 1312.7008, 1383.7379, 1480.7907, 1608.8857, 1721.9697, 1836.9967, 1934.0494, 2062.1080, 2191.1506, 2377.2299, 2563.3092, 2620.3307, 2735.3576, 2864.4002, 2935.4373, 3063.4959, 3160.5487, 3288.6436, 3403.6706, 3566.7339, 3695.7765, 3766.8136, 3929.8769, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LHYILYDLVYFSNPAVYHFSIALDSCCDLGDDTK", {114.0913, 251.1503, 414.2136, 527.2976, 640.3817, 803.4450, 918.4720, 1031.5560, 1130.6245, 1293.6878, 1440.7562, 1527.7882, 1641.8312, 1738.8839, 1809.9210, 1908.9894, 2072.0528, 2209.1117, 2356.1801, 2443.2121, 2556.2962, 2627.3333, 2740.4174, 2855.4443, 2942.4763, 3102.5070, 3262.5376, 3377.5646, 3490.6486, 3547.6701, 3662.6971, 3777.7240, 3878.7717, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 248.1605, 363.1874, 478.2144, 535.2358, 648.3199, 763.3468, 923.3775, 1083.4081, 1170.4402, 1285.4671, 1398.5512, 1469.5883, 1582.6724, 1669.7044, 1816.7728, 1953.8317, 2116.8950, 2215.9634, 2287.0006, 2384.0533, 2498.0963, 2585.1283, 2732.1967, 2895.2600, 2994.3284, 3107.4125, 3222.4394, 3385.5028, 3498.5868, 3611.6709, 3774.7342, 3911.7931, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"IAPDFWSVVTLWFYTAPFLSLGILWFSTTCDFSK", {114.0913, 185.1285, 282.1812, 397.2082, 544.2766, 730.3559, 817.3879, 916.4563, 1015.5247, 1116.5724, 1229.6565, 1415.7358, 1562.8042, 1725.8675, 1826.9152, 1897.9523, 1995.0051, 2142.0735, 2255.1576, 2342.1896, 2455.2737, 2512.2951, 2625.3792, 2738.4633, 2924.5426, 3071.6110, 3158.6430, 3259.6907, 3360.7384, 3520.7690, 3635.7960, 3782.8644, 3869.8964, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 234.1448, 381.2132, 496.2402, 656.2708, 757.3185, 858.3662, 945.3982, 1092.4666, 1278.5460, 1391.6300, 1504.7141, 1561.7355, 1674.8196, 1761.8516, 1874.9357, 2022.0041, 2119.0569, 2190.0940, 2291.1417, 2454.2050, 2601.2734, 2787.3527, 2900.4368, 3001.4845, 3100.5529, 3199.6213, 3286.6533, 3472.7326, 3619.8011, 3734.8280, 3831.8808, 3902.9179, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SYMQHADAFADPYQHGYAQQHQQSAQHHHAPYER", {88.0393, 251.1026, 382.1431, 510.2017, 647.2606, 718.2977, 833.3247, 904.3618, 1051.4302, 1122.4673, 1237.4942, 1334.5470, 1497.6103, 1625.6689, 1762.7278, 1819.7493, 1982.8126, 2053.8497, 2181.9083, 2309.9669, 2447.0258, 2575.0844, 2703.1430, 2790.1750, 2861.2121, 2989.2707, 3126.3296, 3263.3885, 3400.4474, 3471.4845, 3568.5373, 3731.6006, 3860.6432, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 467.2249, 564.2776, 635.3148, 772.3737, 909.4326, 1046.4915, 1174.5501, 1245.5872, 1332.6192, 1460.6778, 1588.7364, 1725.7953, 1853.8539, 1981.9124, 2052.9495, 2216.0129, 2273.0343, 2410.0932, 2538.1518, 2701.2152, 2798.2679, 2913.2949, 2984.3320, 3131.4004, 3202.4375, 3317.4644, 3388.5016, 3525.5605, 3653.6190, 3784.6595, 3947.7229, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"IIEVETNPEEGGFWHDCPEDINWGAGGWHYDFNR", {114.0913, 227.1754, 356.2180, 455.2864, 584.3290, 685.3767, 799.4196, 896.4724, 1025.5150, 1154.5576, 1211.5790, 1268.6005, 1415.6689, 1601.7482, 1738.8071, 1853.8341, 2013.8647, 2110.9175, 2239.9601, 2354.9870, 2468.0711, 2582.1140, 2768.1933, 2825.2148, 2896.2519, 2953.2734, 3010.2948, 3196.3741, 3333.4331, 3496.4964, 3611.5233, 3758.5917, 3872.6347, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 289.1619, 436.2303, 551.2572, 714.3206, 851.3795, 1037.4588, 1094.4803, 1151.5017, 1222.5388, 1279.5603, 1465.6396, 1579.6825, 1692.7666, 1807.7935, 1936.8361, 2033.8889, 2193.9195, 2308.9465, 2446.0054, 2632.0847, 2779.1531, 2836.1746, 2893.1961, 3022.2387, 3151.2812, 3248.3340, 3362.3769, 3463.4246, 3592.4672, 3691.5356, 3820.5782, 3933.6623, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QIPHQHVAPMQFPIEPELPPSYFDMPPPCGFEMR", {129.0659, 242.1499, 339.2027, 476.2616, 604.3202, 741.3791, 840.4475, 911.4846, 1008.5374, 1139.5779, 1267.6364, 1414.7049, 1511.7576, 1624.8417, 1753.8843, 1850.9370, 1979.9796, 2093.0637, 2190.1165, 2287.1692, 2374.2012, 2537.2646, 2684.3330, 2799.3599, 2930.4004, 3027.4532, 3124.5059, 3221.5587, 3381.5894, 3438.6108, 3585.6792, 3714.7218, 3845.7623, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 306.1594, 435.2020, 582.2704, 639.2919, 799.3226, 896.3753, 993.4281, 1090.4808, 1221.5213, 1336.5483, 1483.6167, 1646.6800, 1733.7120, 1830.7648, 1927.8176, 2040.9016, 2169.9442, 2266.9970, 2396.0396, 2509.1237, 2606.1764, 2753.2448, 2881.3034, 3012.3439, 3109.3967, 3180.4338, 3279.5022, 3416.5611, 3544.6197, 3681.6786, 3778.7313, 3891.8154, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"HEPVLEHETINILLESELFQELIYKPAMDVLSQK", {138.0662, 267.1088, 364.1615, 463.2300, 576.3140, 705.3566, 842.4155, 971.4581, 1072.5058, 1185.5899, 1299.6328, 1412.7169, 1525.8009, 1638.8850, 1767.9276, 1854.9596, 1984.0022, 2097.0863, 2244.1547, 2372.2133, 2501.2558, 2614.3399, 2727.4240, 2890.4873, 3018.5823, 3115.6350, 3186.6721, 3317.7126, 3432.7396, 3531.8080, 3644.8920, 3731.9241, 3859.9827, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 275.1714, 362.2034, 475.2875, 574.3559, 689.3828, 820.4233, 891.4604, 988.5132, 1116.6082, 1279.6715, 1392.7555, 1505.8396, 1634.8822, 1762.9408, 1910.0092, 2023.0933, 2152.1359, 2239.1679, 2368.2105, 2481.2945, 2594.3786, 2707.4627, 2821.5056, 2934.5897, 3035.6373, 3164.6799, 3301.7388, 3430.7814, 3543.8655, 3642.9339, 3739.9867, 3869.0293, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SPIGHHIIWYDESSNVGCCQLWSEYYSLAGTQNR", {88.0393, 185.0921, 298.1761, 355.1976, 492.2565, 629.3154, 742.3995, 855.4835, 1041.5629, 1204.6262, 1319.6531, 1448.6957, 1535.7278, 1622.7598, 1736.8027, 1835.8711, 1892.8926, 2052.9232, 2212.9539, 2341.0125, 2454.0965, 2640.1758, 2727.2079, 2856.2505, 3019.3138, 3182.3771, 3269.4091, 3382.4932, 3453.5303, 3510.5518, 3611.5995, 3739.6580, 3853.7010, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 289.1619, 417.2205, 518.2681, 575.2896, 646.3267, 759.4108, 846.4428, 1009.5061, 1172.5695, 1301.6121, 1388.6441, 1574.7234, 1687.8075, 1815.8660, 1975.8967, 2135.9273, 2192.9488, 2292.0172, 2406.0601, 2493.0922, 2580.1242, 2709.1668, 2824.1937, 2987.2571, 3173.3364, 3286.4204, 3399.5045, 3536.5634, 3673.6223, 3730.6438, 3843.7279, 3940.7806, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QDDDYYDDYVFDDNQHHGHHDSLLSEDNTGNGHR", {129.0659, 244.0928, 359.1197, 474.1467, 637.2100, 800.2733, 915.3003, 1030.3272, 1193.3906, 1292.4590, 1439.5274, 1554.5543, 1669.5813, 1783.6242, 1911.6828, 2048.7417, 2185.8006, 2242.8221, 2379.8810, 2516.9399, 2631.9668, 2718.9989, 2832.0829, 2945.1670, 3032.1990, 3161.2416, 3276.2685, 3390.3115, 3491.3592, 3548.3806, 3662.4235, 3719.4450, 3856.5039, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 312.1779, 369.1993, 483.2423, 540.2637, 641.3114, 755.3543, 870.3813, 999.4239, 1086.4559, 1199.5400, 1312.6240, 1399.6560, 1514.6830, 1651.7419, 1788.8008, 1845.8223, 1982.8812, 2119.9401, 2247.9987, 2362.0416, 2477.0685, 2592.0955, 2739.1639, 2838.2323, 3001.2956, 3116.3226, 3231.3495, 3394.4129, 3557.4762, 3672.5031, 3787.5301, 3902.5570, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QFEPLIETYFNIENTFLPGFQISEYMEPPMAPTK", {129.0659, 276.1343, 405.1769, 502.2296, 615.3137, 728.3978, 857.4403, 958.4880, 1121.5514, 1268.6198, 1382.6627, 1495.7468, 1624.7894, 1738.8323, 1839.8800, 1986.9484, 2100.0324, 2197.0852, 2254.1067, 2401.1751, 2529.2337, 2642.3177, 2729.3497, 2858.3923, 3021.4557, 3152.4962, 3281.5387, 3378.5915, 3475.6443, 3606.6848, 3677.7219, 3774.7746, 3875.8223, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 248.1605, 345.2132, 416.2504, 547.2908, 644.3436, 741.3964, 870.4390, 1001.4795, 1164.5428, 1293.5854, 1380.6174, 1493.7015, 1621.7600, 1768.8285, 1825.8499, 1922.9027, 2035.9867, 2183.0552, 2284.1028, 2398.1458, 2527.1884, 2640.2724, 2754.3154, 2901.3838, 3064.4471, 3165.4948, 3294.5374, 3407.6214, 3520.7055, 3617.7583, 3746.8009, 3893.8693, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"WADGGGDDQDYGEPDQQWEELEQQTLLFYHTVIK", {187.0866, 258.1237, 373.1506, 430.1721, 487.1936, 544.2150, 659.2420, 774.2689, 902.3275, 1017.3544, 1180.4178, 1237.4392, 1366.4818, 1463.5346, 1578.5615, 1706.6201, 1834.6787, 2020.7580, 2149.8006, 2278.8432, 2391.9273, 2520.9698, 2649.0284, 2777.0870, 2878.1347, 2991.2187, 3104.3028, 3251.3712, 3414.4346, 3551.4935, 3652.5411, 3751.6096, 3864.6936, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 359.2653, 460.3130, 597.3719, 760.4352, 907.5036, 1020.5877, 1133.6717, 1234.7194, 1362.7780, 1490.8366, 1619.8792, 1732.9632, 1862.0058, 1991.0484, 2177.1277, 2305.1863, 2433.2449, 2548.2718, 2645.3246, 2774.3672, 2831.3887, 2994.4520, 3109.4789, 3237.5375, 3352.5644, 3467.5914, 3524.6129, 3581.6343, 3638.6558, 3753.6827, 3824.7198, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LGYHPLVFNAPAIQTSQYYYQFAQDYDSQAHFSR", {114.0913, 171.1128, 334.1761, 471.2350, 568.2878, 681.3719, 780.4403, 927.5087, 1041.5516, 1112.5887, 1209.6415, 1280.6786, 1393.7627, 1521.8213, 1622.8689, 1709.9010, 1837.9595, 2001.0229, 2164.0862, 2327.1495, 2455.2081, 2602.2765, 2673.3136, 2801.3722, 2916.3992, 3079.4625, 3194.4894, 3281.5215, 3409.5800, 3480.6171, 3617.6761, 3764.7445, 3851.7765, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 262.1510, 409.2194, 546.2783, 617.3154, 745.3740, 832.4060, 947.4330, 1110.4963, 1225.5232, 1353.5818, 1424.6189, 1571.6873, 1699.7459, 1862.8093, 2025.8726, 2188.9359, 2316.9945, 2404.0265, 2505.0742, 2633.1328, 2746.2168, 2817.2539, 2914.3067, 2985.3438, 3099.3868, 3246.4552, 3345.5236, 3458.6076, 3555.6604, 3692.7193, 3855.7827, 3912.8041, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PDGCRPDFESNCDYCMLATTVQICCLVGLLLLTK", {98.0600, 213.0870, 270.1084, 430.1391, 586.2402, 683.2930, 798.3199, 945.3883, 1074.4309, 1161.4629, 1275.5059, 1435.5365, 1550.5635, 1713.6268, 1873.6574, 2004.6979, 2117.7820, 2188.8191, 2289.8668, 2390.9145, 2489.9829, 2618.0415, 2731.1255, 2891.1562, 3051.1868, 3164.2709, 3263.3393, 3320.3608, 3433.4448, 3546.5289, 3659.6130, 3772.6970, 3873.7447, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 248.1605, 361.2445, 474.3286, 587.4127, 700.4967, 757.5182, 856.5866, 969.6707, 1129.7013, 1289.7320, 1402.8160, 1530.8746, 1629.9430, 1730.9907, 1832.0384, 1903.0755, 2016.1596, 2147.2001, 2307.2307, 2470.2940, 2585.3210, 2745.3516, 2859.3945, 2946.4266, 3075.4692, 3222.5376, 3337.5645, 3434.6173, 3590.7184, 3750.7491, 3807.7705, 3922.7975, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DNMHQPPASGHVCFLGCDGYAHNYATASYMWHYR", {116.0342, 230.0771, 361.1176, 498.1765, 626.2351, 723.2879, 820.3406, 891.3778, 978.4098, 1035.4313, 1172.4902, 1271.5586, 1431.5892, 1578.6576, 1691.7417, 1748.7632, 1908.7938, 2023.8208, 2080.8422, 2243.9056, 2314.9427, 2452.0016, 2566.0445, 2729.1078, 2800.1450, 2901.1926, 2972.2297, 3059.2618, 3222.3251, 3353.3656, 3539.4449, 3676.5038, 3839.5671, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 475.2412, 661.3205, 792.3610, 955.4243, 1042.4563, 1113.4935, 1214.5411, 1285.5783, 1448.6416, 1562.6845, 1699.7434, 1770.7805, 1933.8439, 1990.8653, 2105.8923, 2265.9229, 2322.9444, 2436.0284, 2583.0969, 2743.1275, 2842.1959, 2979.2548, 3036.2763, 3123.3083, 3194.3454, 3291.3982, 3388.4510, 3516.5095, 3653.5685, 3784.6089, 3898.6519, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TAHTCLGCCDCFLGASPTLLIECVNCFCAQELVK", {102.0550, 173.0921, 310.1510, 411.1987, 571.2293, 684.3134, 741.3348, 901.3655, 1061.3961, 1176.4231, 1336.4537, 1483.5221, 1596.6062, 1653.6277, 1724.6648, 1811.6968, 1908.7496, 2009.7973, 2122.8813, 2235.9654, 2349.0494, 2478.0920, 2638.1227, 2737.1911, 2851.2340, 3011.2647, 3158.3331, 3318.3637, 3389.4009, 3517.4594, 3646.5020, 3759.5861, 3858.6545, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 246.1812, 359.2653, 488.3079, 616.3665, 687.4036, 847.4342, 994.5026, 1154.5333, 1268.5762, 1367.6446, 1527.6753, 1656.7179, 1769.8019, 1882.8860, 1995.9701, 2097.0177, 2194.0705, 2281.1025, 2352.1396, 2409.1611, 2522.2452, 2669.3136, 2829.3442, 2944.3712, 3104.4018, 3264.4325, 3321.4539, 3434.5380, 3594.5686, 3695.6163, 3832.6752, 3903.7123, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FQEDDVVLSCDVYSGVEHLAHLIQVLNTQHNNWR", {148.0757, 276.1343, 405.1769, 520.2038, 635.2307, 734.2992, 833.3676, 946.4516, 1033.4837, 1193.5143, 1308.5413, 1407.6097, 1570.6730, 1657.7050, 1714.7265, 1813.7949, 1942.8375, 2079.8964, 2192.9805, 2264.0176, 2401.0765, 2514.1606, 2627.2446, 2755.3032, 2854.3716, 2967.4557, 3081.4986, 3182.5463, 3310.6049, 3447.6638, 3561.7067, 3675.7496, 3861.8289, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 361.1983, 475.2412, 589.2841, 726.3430, 854.4016, 955.4493, 1069.4922, 1182.5763, 1281.6447, 1409.7033, 1522.7873, 1635.8714, 1772.9303, 1843.9674, 1957.0515, 2094.1104, 2223.1530, 2322.2214, 2379.2429, 2466.2749, 2629.3382, 2728.4066, 2843.4336, 3003.4642, 3090.4963, 3203.5803, 3302.6487, 3401.7172, 3516.7441, 3631.7710, 3760.8136, 3888.8722, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ATSNLDYLGLLSYIFGNLVYSPPTTPYEEYWYFK", {72.0444, 173.0921, 260.1241, 374.1670, 487.2511, 602.2780, 765.3414, 878.4254, 935.4469, 1048.5310, 1161.6150, 1248.6470, 1411.7104, 1524.7944, 1671.8629, 1728.8843, 1842.9272, 1956.0113, 2055.0797, 2218.1430, 2305.1751, 2402.2278, 2499.2806, 2600.3283, 2701.3760, 2798.4287, 2961.4921, 3090.5346, 3219.5772, 3382.6406, 3568.7199, 3731.7832, 3878.8516, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 294.1812, 457.2445, 643.3239, 806.3872, 935.4298, 1064.4724, 1227.5357, 1324.5885, 1425.6361, 1526.6838, 1623.7366, 1720.7894, 1807.8214, 1970.8847, 2069.9531, 2183.0372, 2297.0801, 2354.1016, 2501.1700, 2614.2541, 2777.3174, 2864.3494, 2977.4335, 3090.5175, 3147.5390, 3260.6231, 3423.6864, 3538.7133, 3651.7974, 3765.8403, 3852.8724, 3953.9200, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NEVNFVHLELTNSSGNTLDWVTLTCNSTCVVYYR", {115.0502, 244.0928, 343.1612, 457.2041, 604.2726, 703.3410, 840.3999, 953.4839, 1082.5265, 1195.6106, 1296.6583, 1410.7012, 1497.7332, 1584.7653, 1641.7867, 1755.8297, 1856.8773, 1969.9614, 2084.9883, 2271.0677, 2370.1361, 2471.1837, 2584.2678, 2685.3155, 2845.3461, 2959.3891, 3046.4211, 3147.4688, 3307.4994, 3406.5678, 3505.6362, 3668.6996, 3831.7629, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 501.2456, 600.3140, 699.3824, 859.4131, 960.4608, 1047.4928, 1161.5357, 1321.5664, 1422.6140, 1535.6981, 1636.7458, 1735.8142, 1921.8935, 2036.9205, 2150.0045, 2251.0522, 2365.0951, 2422.1166, 2509.1486, 2596.1807, 2710.2236, 2811.2713, 2924.3553, 3053.3979, 3166.4820, 3303.5409, 3402.6093, 3549.6777, 3663.7206, 3762.7891, 3891.8317, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QYAYIQYMVCEAFRPSSDELTWSIVIGTDLLSIR", {129.0659, 292.1292, 363.1663, 526.2296, 639.3137, 767.3723, 930.4356, 1061.4761, 1160.5445, 1320.5751, 1449.6177, 1520.6548, 1667.7233, 1823.8244, 1920.8771, 2007.9092, 2094.9412, 2209.9681, 2339.0107, 2452.0948, 2553.1425, 2739.2218, 2826.2538, 2939.3379, 3038.4063, 3151.4904, 3208.5118, 3309.5595, 3424.5864, 3537.6705, 3650.7546, 3737.7866, 3850.8707, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 375.2350, 488.3191, 601.4032, 716.4301, 817.4778, 874.4993, 987.5833, 1086.6517, 1199.7358, 1286.7678, 1472.8471, 1573.8948, 1686.9789, 1816.0215, 1931.0484, 2018.0804, 2105.1125, 2202.1652, 2358.2664, 2505.3348, 2576.3719, 2705.4145, 2865.4451, 2964.5135, 3095.5540, 3258.6173, 3386.6759, 3499.7600, 3662.8233, 3733.8604, 3896.9238, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"IAILQYESPAYATTQTLKPQFAMRPLYQPYMFVR", {114.0913, 185.1285, 298.2125, 411.2966, 539.3552, 702.4185, 831.4611, 918.4931, 1015.5459, 1086.5830, 1249.6463, 1320.6834, 1421.7311, 1522.7788, 1650.8374, 1751.8850, 1864.9691, 1993.0641, 2090.1168, 2218.1754, 2365.2438, 2436.2809, 2567.3214, 2723.4225, 2820.4753, 2933.5594, 3096.6227, 3224.6813, 3321.7340, 3484.7974, 3615.8378, 3762.9063, 3861.9747, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 274.1874, 421.2558, 552.2963, 715.3596, 812.4124, 940.4709, 1103.5343, 1216.6183, 1313.6711, 1469.7722, 1600.8127, 1671.8498, 1818.9182, 1946.9768, 2044.0296, 2172.1245, 2285.2086, 2386.2563, 2514.3148, 2615.3625, 2716.4102, 2787.4473, 2950.5106, 3021.5478, 3118.6005, 3205.6325, 3334.6751, 3497.7385, 3625.7970, 3738.8811, 3851.9652, 3923.0023, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SMYIHHSNSDPANYLTQLIPIVLQELDQQQMVFR", {88.0393, 219.0798, 382.1431, 495.2272, 632.2861, 769.3450, 856.3770, 970.4200, 1057.4520, 1172.4789, 1269.5317, 1340.5688, 1454.6117, 1617.6751, 1730.7591, 1831.8068, 1959.8654, 2072.9495, 2186.0335, 2283.0863, 2396.1703, 2495.2388, 2608.3228, 2736.3814, 2865.4240, 2978.5081, 3093.5350, 3221.5936, 3349.6522, 3477.7107, 3608.7512, 3707.8196, 3854.8880, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 421.2558, 552.2963, 680.3548, 808.4134, 936.4720, 1051.4989, 1164.5830, 1293.6256, 1421.6842, 1534.7682, 1633.8367, 1746.9207, 1843.9735, 1957.0575, 2070.1416, 2198.2002, 2299.2479, 2412.3319, 2575.3953, 2689.4382, 2760.4753, 2857.5281, 2972.5550, 3059.5870, 3173.6300, 3260.6620, 3397.7209, 3534.7798, 3647.8639, 3810.9272, 3941.9677, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SMHPEYDLDVAEDIDDMEQEDVEDEAEEQVNELK", {88.0393, 219.0798, 356.1387, 453.1915, 582.2341, 745.2974, 860.3243, 973.4084, 1088.4353, 1187.5038, 1258.5409, 1387.5835, 1502.6104, 1615.6945, 1730.7214, 1845.7484, 1976.7888, 2105.8314, 2233.8900, 2362.9326, 2477.9595, 2577.0280, 2706.0705, 2821.0975, 2950.1401, 3021.1772, 3150.2198, 3279.2624, 3407.3210, 3506.3894, 3620.4323, 3749.4749, 3862.5590, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 389.2395, 503.2824, 602.3508, 730.4094, 859.4520, 988.4946, 1059.5317, 1188.5743, 1303.6012, 1432.6438, 1531.7122, 1646.7392, 1775.7818, 1903.8403, 2032.8829, 2163.9234, 2278.9504, 2393.9773, 2507.0614, 2622.0883, 2751.1309, 2822.1680, 2921.2364, 3036.2634, 3149.3474, 3264.3744, 3427.4377, 3556.4803, 3653.5331, 3790.5920, 3921.6325, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DYFIEEDPDPESLEEEFDDVDYSILSQMSDDLLK", {116.0342, 279.0975, 426.1660, 539.2500, 668.2926, 797.3352, 912.3622, 1009.4149, 1124.4419, 1221.4946, 1350.5372, 1437.5692, 1550.6533, 1679.6959, 1808.7385, 1937.7811, 2084.8495, 2199.8764, 2314.9034, 2413.9718, 2528.9987, 2692.0621, 2779.0941, 2892.1782, 3005.2622, 3092.2943, 3220.3528, 3351.3933, 3438.4254, 3553.4523, 3668.4792, 3781.5633, 3894.6474, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 373.2809, 488.3079, 603.3348, 690.3668, 821.4073, 949.4659, 1036.4979, 1149.5820, 1262.6661, 1349.6981, 1512.7614, 1627.7884, 1726.8568, 1841.8837, 1956.9107, 2103.9791, 2233.0217, 2362.0643, 2491.1069, 2604.1909, 2691.2230, 2820.2655, 2917.3183, 3032.3453, 3129.3980, 3244.4250, 3373.4676, 3502.5101, 3615.5942, 3762.6626, 3925.7260, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ASGCDMSDPTTYETYYSDYATEESVDHLEHPLYR", {72.0444, 159.0764, 216.0979, 376.1285, 491.1555, 622.1960, 709.2280, 824.2549, 921.3077, 1022.3554, 1123.4031, 1286.4664, 1415.5090, 1516.5567, 1679.6200, 1842.6833, 1929.7153, 2044.7423, 2207.8056, 2278.8427, 2379.8904, 2508.9330, 2637.9756, 2725.0076, 2824.0760, 2939.1030, 3076.1619, 3189.2459, 3318.2885, 3455.3475, 3552.4002, 3665.4843, 3828.5476, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 451.2663, 548.3191, 685.3780, 814.4206, 927.5047, 1064.5636, 1179.5905, 1278.6589, 1365.6910, 1494.7336, 1623.7762, 1724.8238, 1795.8610, 1958.9243, 2073.9512, 2160.9833, 2324.0466, 2487.1099, 2588.1576, 2717.2002, 2880.2635, 2981.3112, 3082.3589, 3179.4116, 3294.4386, 3381.4706, 3512.5111, 3627.5380, 3787.5687, 3844.5901, 3931.6222, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DGSYYESPVVNEDWIIQETPYLPMENLAELQSCR", {116.0342, 173.0557, 260.0877, 423.1510, 586.2144, 715.2570, 802.2890, 899.3418, 998.4102, 1097.4786, 1211.5215, 1340.5641, 1455.5910, 1641.6704, 1754.7544, 1867.8385, 1995.8971, 2124.9397, 2225.9873, 2323.0401, 2486.1034, 2599.1875, 2696.2403, 2827.2807, 2956.3233, 3070.3663, 3183.4503, 3254.4874, 3383.5300, 3496.6141, 3624.6727, 3711.7047, 3871.7354, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 335.1496, 422.1816, 550.2402, 663.3243, 792.3669, 863.4040, 976.4880, 1090.5310, 1219.5736, 1350.6140, 1447.6668, 1560.7509, 1723.8142, 1820.8670, 1921.9146, 2050.9572, 2179.0158, 2292.0999, 2405.1839, 2591.2633, 2706.2902, 2835.3328, 2949.3757, 3048.4441, 3147.5125, 3244.5653, 3331.5973, 3460.6399, 3623.7033, 3786.7666, 3873.7986, 3930.8201, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"HAKPYNPNELSRPLQGGSECFPNDCAQTHDEYNR", {138.0662, 209.1033, 337.1983, 434.2510, 597.3144, 711.3573, 808.4100, 922.4530, 1051.4956, 1164.5796, 1251.6117, 1407.7128, 1504.7655, 1617.8496, 1745.9082, 1802.9296, 1859.9511, 1946.9831, 2076.0257, 2236.0564, 2383.1248, 2480.1776, 2594.2205, 2709.2474, 2869.2781, 2940.3152, 3068.3738, 3169.4214, 3306.4804, 3421.5073, 3550.5499, 3713.6132, 3827.6561, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 289.1619, 452.2252, 581.2678, 696.2947, 833.3537, 934.4013, 1062.4599, 1133.4970, 1293.5277, 1408.5546, 1522.5975, 1619.6503, 1766.7187, 1926.7494, 2055.7920, 2142.8240, 2199.8455, 2256.8669, 2384.9255, 2498.0096, 2595.0623, 2751.1634, 2838.1955, 2951.2795, 3080.3221, 3194.3651, 3291.4178, 3405.4607, 3568.5241, 3665.5768, 3793.6718, 3864.7089, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"HMQPWINMMSNNWLTMDFEADSPFLVAEQVQSTK", {138.0662, 269.1067, 397.1653, 494.2180, 680.2973, 793.3814, 907.4243, 1038.4648, 1169.5053, 1256.5373, 1370.5802, 1484.6232, 1670.7025, 1783.7865, 1884.8342, 2015.8747, 2130.9017, 2277.9701, 2407.0127, 2478.0498, 2593.0767, 2680.1087, 2777.1615, 2924.2299, 3037.3140, 3136.3824, 3207.4195, 3336.4621, 3464.5207, 3563.5891, 3691.6477, 3778.6797, 3879.7274, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 248.1605, 335.1925, 463.2511, 562.3195, 690.3781, 819.4207, 890.4578, 989.5262, 1102.6103, 1249.6787, 1346.7314, 1433.7635, 1548.7904, 1619.8275, 1748.8701, 1895.9385, 2010.9655, 2142.0060, 2243.0536, 2356.1377, 2542.2170, 2656.2599, 2770.3029, 2857.3349, 2988.3754, 3119.4159, 3233.4588, 3346.5429, 3532.6222, 3629.6749, 3757.7335, 3888.7740, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VSPGLQQWLFYLALGIQLPASWIMNLYTTLEMFR", {100.0757, 187.1077, 284.1605, 341.1819, 454.2660, 582.3246, 710.3832, 896.4625, 1009.5465, 1156.6150, 1319.6783, 1432.7623, 1503.7995, 1616.8835, 1673.9050, 1786.9891, 1915.0476, 2028.1317, 2125.1845, 2196.2216, 2283.2536, 2469.3329, 2582.4170, 2713.4575, 2827.5004, 2940.5845, 3103.6478, 3204.6955, 3305.7431, 3418.8272, 3547.8698, 3678.9103, 3825.9787, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 453.2279, 582.2704, 695.3545, 796.4022, 897.4499, 1060.5132, 1173.5973, 1287.6402, 1418.6807, 1531.7647, 1717.8440, 1804.8761, 1875.9132, 1972.9660, 2086.0500, 2214.1086, 2327.1927, 2384.2141, 2497.2982, 2568.3353, 2681.4194, 2844.4827, 2991.5511, 3104.6352, 3290.7145, 3418.7731, 3546.8316, 3659.9157, 3716.9372, 3813.9899, 3901.0220, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ALPTFVHYSYEFDTINQMHWVGTFGLTVNNWLGR", {72.0444, 185.1285, 282.1812, 383.2289, 530.2973, 629.3657, 766.4246, 929.4880, 1016.5200, 1179.5833, 1308.6259, 1455.6943, 1570.7213, 1671.7690, 1784.8530, 1898.8959, 2026.9545, 2157.9950, 2295.0539, 2481.1332, 2580.2016, 2637.2231, 2738.2708, 2885.3392, 2942.3607, 3055.4447, 3156.4924, 3255.5608, 3369.6037, 3483.6467, 3669.7260, 3782.8101, 3839.8315, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 232.1404, 345.2245, 531.3038, 645.3467, 759.3896, 858.4581, 959.5057, 1072.5898, 1129.6113, 1276.6797, 1377.7274, 1434.7488, 1533.8172, 1719.8966, 1856.9555, 1987.9959, 2116.0545, 2230.0975, 2343.1815, 2444.2292, 2559.2561, 2706.3246, 2835.3671, 2998.4305, 3085.4625, 3248.5258, 3385.5847, 3484.6532, 3631.7216, 3732.7692, 3829.8220, 3942.9061, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YVSNWILIQTPDFVTTVTNLITQDYNQYDSPNMK", {164.0706, 263.1390, 350.1710, 464.2140, 650.2933, 763.3774, 876.4614, 989.5455, 1117.6041, 1218.6517, 1315.7045, 1430.7314, 1577.7999, 1676.8683, 1777.9159, 1878.9636, 1978.0320, 2079.0797, 2193.1226, 2306.2067, 2419.2908, 2520.3385, 2648.3970, 2763.4240, 2926.4873, 3040.5302, 3168.5888, 3331.6521, 3446.6791, 3533.7111, 3630.7639, 3744.8068, 3875.8473, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 278.1533, 392.1962, 489.2490, 576.2810, 691.3080, 854.3713, 982.4299, 1096.4728, 1259.5361, 1374.5631, 1502.6216, 1603.6693, 1716.7534, 1829.8374, 1943.8804, 2044.9280, 2143.9965, 2245.0441, 2346.0918, 2445.1602, 2592.2286, 2707.2556, 2804.3084, 2905.3560, 3033.4146, 3146.4987, 3259.5827, 3372.6668, 3558.7461, 3672.7890, 3759.8211, 3858.8895, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"WGQLDHLFEETRPLQFWIAGAMLALGITQFWNLK", {187.0866, 244.1081, 372.1666, 485.2507, 600.2776, 737.3365, 850.4206, 997.4890, 1126.5316, 1255.5742, 1356.6219, 1512.7230, 1609.7758, 1722.8598, 1850.9184, 1997.9868, 2184.0661, 2297.1502, 2368.1873, 2425.2088, 2496.2459, 2627.2864, 2740.3704, 2811.4076, 2924.4916, 2981.5131, 3094.5971, 3195.6448, 3323.7034, 3470.7718, 3656.8511, 3770.8941, 3883.9781, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 374.2398, 560.3191, 707.3875, 835.4461, 936.4938, 1049.5778, 1106.5993, 1219.6834, 1290.7205, 1403.8045, 1534.8450, 1605.8821, 1662.9036, 1733.9407, 1847.0248, 2033.1041, 2180.1725, 2308.2311, 2421.3152, 2518.3679, 2674.4690, 2775.5167, 2904.5593, 3033.6019, 3180.6703, 3293.7544, 3430.8133, 3545.8402, 3658.9243, 3786.9829, 3844.0043, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PPQSLCACLVNLISISGACCAWYQICNWLGLSFR", {98.0600, 195.1128, 323.1714, 410.2034, 523.2875, 683.3181, 754.3552, 914.3859, 1027.4699, 1126.5384, 1240.5813, 1353.6654, 1466.7494, 1553.7814, 1666.8655, 1753.8975, 1810.9190, 1881.9561, 2041.9868, 2202.0174, 2273.0545, 2459.1338, 2622.1972, 2750.2557, 2863.3398, 3023.3705, 3137.4134, 3323.4927, 3436.5768, 3493.5982, 3606.6823, 3693.7143, 3840.7827, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 409.2194, 522.3035, 579.3249, 692.4090, 878.4883, 992.5312, 1152.5619, 1265.6459, 1393.7045, 1556.7678, 1742.8472, 1813.8843, 1973.9149, 2133.9456, 2204.9827, 2262.0041, 2349.0362, 2462.1202, 2549.1523, 2662.2363, 2775.3204, 2889.3633, 2988.4317, 3101.5158, 3261.5464, 3332.5836, 3492.6142, 3605.6983, 3692.7303, 3820.7889, 3917.8416, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NWSQHDFVIIEYLHELVLLSEIIAPMEEQLTTVK", {115.0502, 301.1295, 388.1615, 516.2201, 653.2790, 768.3060, 915.3744, 1014.4428, 1127.5269, 1240.6109, 1369.6535, 1532.7169, 1645.8009, 1782.8598, 1911.9024, 2024.9865, 2124.0549, 2237.1390, 2350.2230, 2437.2551, 2566.2977, 2679.3817, 2792.4658, 2863.5029, 2960.5557, 3091.5961, 3220.6387, 3349.6813, 3477.7399, 3590.8240, 3691.8716, 3792.9193, 3891.9877, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 246.1812, 347.2289, 448.2766, 561.3606, 689.4192, 818.4618, 947.5044, 1078.5449, 1175.5977, 1246.6348, 1359.7188, 1472.8029, 1601.8455, 1688.8775, 1801.9616, 1915.0456, 2014.1141, 2127.1981, 2256.2407, 2393.2996, 2506.3837, 2669.4470, 2798.4896, 2911.5737, 3024.6577, 3123.7262, 3270.7946, 3385.8215, 3522.8804, 3650.9390, 3737.9710, 3924.0503, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FLHAPLNLLQSVIDMLLHSIEQQQQPQELQDLYK", {148.0757, 261.1598, 398.2187, 469.2558, 566.3085, 679.3926, 793.4355, 906.5196, 1019.6037, 1147.6622, 1234.6943, 1333.7627, 1446.8467, 1561.8737, 1692.9142, 1805.9982, 1919.0823, 2056.1412, 2143.1732, 2256.2573, 2385.2999, 2513.3585, 2641.4171, 2769.4756, 2897.5342, 2994.5870, 3122.6456, 3251.6881, 3364.7722, 3492.8308, 3607.8577, 3720.9418, 3884.0051, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 310.1761, 423.2602, 538.2871, 666.3457, 779.4298, 908.4724, 1036.5310, 1133.5837, 1261.6423, 1389.7009, 1517.7594, 1645.8180, 1774.8606, 1887.9447, 1974.9767, 2112.0356, 2225.1197, 2338.2038, 2469.2442, 2584.2712, 2697.3552, 2796.4237, 2883.4557, 3011.5143, 3124.5983, 3237.6824, 3351.7253, 3464.8094, 3561.8621, 3632.8993, 3769.9582, 3883.0422, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LINNNWCDGHCIVAFPECNFGSVLPLLLEFYSGR", {114.0913, 227.1754, 341.2183, 455.2613, 569.3042, 755.3835, 915.4141, 1030.4411, 1087.4626, 1224.5215, 1384.5521, 1497.6362, 1596.7046, 1667.7417, 1814.8101, 1911.8629, 2040.9055, 2200.9361, 2314.9791, 2462.0475, 2519.0689, 2606.1010, 2705.1694, 2818.2534, 2915.3062, 3028.3903, 3141.4743, 3254.5584, 3383.6010, 3530.6694, 3693.7327, 3780.7648, 3837.7862, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 232.1404, 319.1724, 482.2358, 629.3042, 758.3468, 871.4308, 984.5149, 1097.5990, 1194.6517, 1307.7358, 1406.8042, 1493.8362, 1550.8577, 1697.9261, 1811.9690, 1971.9997, 2101.0423, 2198.0951, 2345.1635, 2416.2006, 2515.2690, 2628.3531, 2788.3837, 2925.4426, 2982.4641, 3097.4910, 3257.5217, 3443.6010, 3557.6439, 3671.6868, 3785.7298, 3898.8138, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LNIYWNLSFQYMPDINPLDTISYYLISSHVAVPK", {114.0913, 228.1343, 341.2183, 504.2817, 690.3610, 804.4039, 917.4880, 1004.5200, 1151.5884, 1279.6470, 1442.7103, 1573.7508, 1670.8036, 1785.8305, 1898.9146, 2012.9575, 2110.0103, 2223.0943, 2338.1213, 2439.1689, 2552.2530, 2639.2850, 2802.3484, 2965.4117, 3078.4958, 3191.5798, 3278.6119, 3365.6439, 3502.7028, 3601.7712, 3672.8083, 3771.8767, 3868.9295, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 244.1656, 343.2340, 414.2711, 513.3395, 650.3984, 737.4305, 824.4625, 937.5465, 1050.6306, 1213.6939, 1376.7573, 1463.7893, 1576.8734, 1677.9210, 1792.9480, 1906.0320, 2003.0848, 2117.1277, 2230.2118, 2345.2387, 2442.2915, 2573.3320, 2736.3953, 2864.4539, 3011.5223, 3098.5543, 3211.6384, 3325.6813, 3511.7606, 3674.8240, 3787.9080, 3901.9510, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YEVLYSLEPQVDQFQEADGFAIQNLINPFYAQQK", {164.0706, 293.1132, 392.1816, 505.2657, 668.3290, 755.3610, 868.4451, 997.4877, 1094.5405, 1222.5990, 1321.6674, 1436.6944, 1564.7530, 1711.8214, 1839.8800, 1968.9226, 2039.9597, 2154.9866, 2212.0081, 2359.0765, 2430.1136, 2543.1977, 2671.2562, 2785.2992, 2898.3832, 3011.4673, 3125.5102, 3222.5630, 3369.6314, 3532.6947, 3603.7318, 3731.7904, 3859.8490, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 275.1714, 403.2300, 474.2671, 637.3304, 784.3988, 881.4516, 995.4945, 1108.5786, 1221.6626, 1335.7056, 1463.7641, 1576.8482, 1647.8853, 1794.9537, 1851.9752, 1967.0021, 2038.0393, 2167.0818, 2295.1404, 2442.2088, 2570.2674, 2685.2944, 2784.3628, 2912.4213, 3009.4741, 3138.5167, 3251.6008, 3338.6328, 3501.6961, 3614.7802, 3713.8486, 3842.8912, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ISCFYPTSYCRPLTDLYAAYTSSHTGLTCEQLHK", {114.0913, 201.1234, 361.1540, 508.2224, 671.2858, 768.3385, 869.3862, 956.4182, 1119.4816, 1279.5122, 1435.6133, 1532.6661, 1645.7501, 1746.7978, 1861.8248, 1974.9088, 2137.9722, 2209.0093, 2280.0464, 2443.1097, 2544.1574, 2631.1894, 2718.2215, 2855.2804, 2956.3280, 3013.3495, 3126.4336, 3227.4812, 3387.5119, 3516.5545, 3644.6131, 3757.6971, 3894.7560, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 284.1717, 397.2558, 525.3144, 654.3570, 814.3876, 915.4353, 1028.5193, 1085.5408, 1186.5885, 1323.6474, 1410.6794, 1497.7115, 1598.7591, 1761.8225, 1832.8596, 1903.8967, 2066.9600, 2180.0441, 2295.0710, 2396.1187, 2509.2028, 2606.2555, 2762.3566, 2922.3873, 3085.4506, 3172.4826, 3273.5303, 3370.5831, 3533.6464, 3680.7148, 3840.7455, 3927.7775, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NTNNIETMYGNVIEHLDQVYAEETSMLEAFVCQR", {115.0502, 216.0979, 330.1408, 444.1837, 557.2678, 686.3104, 787.3581, 918.3986, 1081.4619, 1138.4834, 1252.5263, 1351.5947, 1464.6788, 1593.7213, 1730.7803, 1843.8643, 1958.8913, 2086.9498, 2186.0183, 2349.0816, 2420.1187, 2549.1613, 2678.2039, 2779.2516, 2866.2836, 2997.3241, 3110.4081, 3239.4507, 3310.4879, 3457.5563, 3556.6247, 3716.6553, 3844.7139, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 463.2082, 562.2766, 709.3450, 780.3821, 909.4247, 1022.5088, 1153.5493, 1240.5813, 1341.6290, 1470.6716, 1599.7142, 1670.7513, 1833.8146, 1932.8830, 2060.9416, 2175.9685, 2289.0526, 2426.1115, 2555.1541, 2668.2382, 2767.3066, 2881.3495, 2938.3710, 3101.4343, 3232.4748, 3333.5225, 3462.5651, 3575.6491, 3689.6920, 3803.7350, 3904.7827, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MSFLHPSLGGHCCFINEEIIAALPLCNYCDVFTR", {132.0478, 219.0798, 366.1482, 479.2323, 616.2912, 713.3439, 800.3760, 913.4600, 970.4815, 1027.5030, 1164.5619, 1324.5925, 1484.6232, 1631.6916, 1744.7757, 1858.8186, 1987.8612, 2116.9038, 2229.9878, 2343.0719, 2414.1090, 2485.1461, 2598.2302, 2695.2829, 2808.3670, 2968.3977, 3082.4406, 3245.5039, 3405.5346, 3520.5615, 3619.6299, 3766.6983, 3867.7460, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 276.1666, 423.2350, 522.3035, 637.3304, 797.3611, 960.4244, 1074.4673, 1234.4980, 1347.5820, 1444.6348, 1557.7188, 1628.7560, 1699.7931, 1812.8771, 1925.9612, 2055.0038, 2184.0464, 2298.0893, 2411.1734, 2558.2418, 2718.2724, 2878.3031, 3015.3620, 3072.3835, 3129.4049, 3242.4890, 3329.5210, 3426.5738, 3563.6327, 3676.7168, 3823.7852, 3910.8172, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"GFVCVYYQTCDSPHPYYGFEEPCDFSPGNSTDTK", {58.0287, 205.0972, 304.1656, 464.1962, 563.2646, 726.3280, 889.3913, 1017.4499, 1118.4975, 1278.5282, 1393.5551, 1480.5872, 1577.6399, 1714.6988, 1811.7516, 1974.8149, 2137.8783, 2194.8997, 2341.9681, 2471.0107, 2600.0533, 2697.1061, 2857.1367, 2972.1637, 3119.2321, 3206.2641, 3303.3169, 3360.3383, 3474.3813, 3561.4133, 3662.4610, 3777.4879, 3878.5356, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 248.1605, 363.1874, 464.2351, 551.2671, 665.3101, 722.3315, 819.3843, 906.4163, 1053.4847, 1168.5117, 1328.5423, 1425.5951, 1554.6377, 1683.6803, 1830.7487, 1887.7701, 2050.8335, 2213.8968, 2310.9496, 2448.0085, 2545.0612, 2632.0933, 2747.1202, 2907.1509, 3008.1985, 3136.2571, 3299.3205, 3462.3838, 3561.4522, 3721.4828, 3820.5513, 3967.6197, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FLELIIFVVINTHLVHNLWSPFVPDLVKPFVLER", {148.0757, 261.1598, 390.2023, 503.2864, 616.3705, 729.4545, 876.5230, 975.5914, 1074.6598, 1187.7438, 1301.7868, 1402.8345, 1539.8934, 1652.9774, 1752.0458, 1889.1048, 2003.1477, 2116.2317, 2302.3111, 2389.3431, 2486.3958, 2633.4643, 2732.5327, 2829.5854, 2944.6124, 3057.6964, 3156.7649, 3284.8598, 3381.9126, 3528.9810, 3628.0494, 3741.1335, 3870.1761, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 417.2456, 516.3140, 663.3824, 760.4352, 888.5302, 987.5986, 1100.6826, 1215.7096, 1312.7623, 1411.8308, 1558.8992, 1655.9519, 1742.9840, 1929.0633, 2042.1473, 2156.1903, 2293.2492, 2392.3176, 2505.4017, 2642.4606, 2743.5083, 2857.5512, 2970.6352, 3069.7037, 3168.7721, 3315.8405, 3428.9246, 3542.0086, 3655.0927, 3784.1353, 3897.2193, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NTCSSILWGIIAWRPIIDSCLMDNTPHIVNIIFR", {115.0502, 216.0979, 376.1285, 463.1606, 550.1926, 663.2767, 776.3607, 962.4400, 1019.4615, 1132.5456, 1245.6296, 1316.6667, 1502.7460, 1658.8472, 1755.8999, 1868.9840, 1982.0681, 2097.0950, 2184.1270, 2344.1577, 2457.2417, 2588.2822, 2703.3092, 2817.3521, 2918.3998, 3015.4525, 3152.5114, 3265.5955, 3364.6639, 3478.7068, 3591.7909, 3704.8750, 3851.9434, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 435.2714, 548.3555, 662.3984, 761.4668, 874.5509, 1011.6098, 1108.6626, 1209.7103, 1323.7532, 1438.7801, 1569.8206, 1682.9047, 1842.9353, 1929.9674, 2044.9943, 2158.0784, 2271.1624, 2368.2152, 2524.3163, 2710.3956, 2781.4327, 2894.5168, 3007.6009, 3064.6223, 3250.7016, 3363.7857, 3476.8698, 3563.9018, 3650.9338, 3810.9645, 3912.0121, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YFFCQLITICTAFMAHLSFVVDNLMVPNVGLPYR", {164.0706, 311.1390, 458.2074, 618.2381, 746.2967, 859.3807, 972.4648, 1073.5125, 1186.5965, 1346.6272, 1447.6749, 1518.7120, 1665.7804, 1796.8209, 1867.8580, 2004.9169, 2118.0010, 2205.0330, 2352.1014, 2451.1698, 2550.2382, 2665.2652, 2779.3081, 2892.3922, 3023.4326, 3122.5011, 3219.5538, 3333.5968, 3432.6652, 3489.6866, 3602.7707, 3699.8235, 3862.8868, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 435.2350, 548.3191, 605.3406, 704.4090, 818.4519, 915.5047, 1014.5731, 1145.6136, 1258.6976, 1372.7406, 1487.7675, 1586.8359, 1685.9043, 1832.9728, 1920.0048, 2033.0888, 2170.1478, 2241.1849, 2372.2254, 2519.2938, 2590.3309, 2691.3786, 2851.4092, 2964.4933, 3065.5410, 3178.6250, 3291.7091, 3419.7677, 3579.7983, 3726.8667, 3873.9351, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NQCEEETAYNNANGGCGTYVFEDCLGEASNYFWR", {115.0502, 243.1088, 403.1394, 532.1820, 661.2246, 790.2672, 891.3149, 962.3520, 1125.4153, 1239.4583, 1353.5012, 1424.5383, 1538.5812, 1595.6027, 1652.6242, 1812.6548, 1869.6763, 1970.7239, 2133.7873, 2232.8557, 2379.9241, 2508.9667, 2623.9936, 2784.0243, 2897.1083, 2954.1298, 3083.1724, 3154.2095, 3241.2415, 3355.2845, 3518.3478, 3665.4162, 3851.4955, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 361.1983, 508.2667, 671.3300, 785.3729, 872.4050, 943.4421, 1072.4847, 1129.5061, 1242.5902, 1402.6208, 1517.6478, 1646.6904, 1793.7588, 1892.8272, 2055.8905, 2156.9382, 2213.9597, 2373.9903, 2431.0118, 2488.0333, 2602.0762, 2673.1133, 2787.1562, 2901.1992, 3064.2625, 3135.2996, 3236.3473, 3365.3899, 3494.4325, 3623.4751, 3783.5057, 3911.5643, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LFQMSIHYQLPVFGEGMYDTYGDEDFEDEEAVDR", {114.0913, 261.1598, 389.2183, 520.2588, 607.2908, 720.3749, 857.4338, 1020.4971, 1148.5557, 1261.6398, 1358.6926, 1457.7610, 1604.8294, 1661.8508, 1790.8934, 1847.9149, 1978.9554, 2142.0187, 2257.0457, 2358.0933, 2521.1567, 2578.1781, 2693.2051, 2822.2477, 2937.2746, 3084.3430, 3213.3856, 3328.4126, 3457.4552, 3586.4977, 3657.5349, 3756.6033, 3871.6302, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 290.1459, 389.2143, 460.2514, 589.2940, 718.3366, 833.3636, 962.4061, 1109.4746, 1224.5015, 1353.5441, 1468.5710, 1525.5925, 1688.6558, 1789.7035, 1904.7305, 2067.7938, 2198.8343, 2255.8557, 2384.8983, 2441.9198, 2588.9882, 2688.0566, 2785.1094, 2898.1934, 3026.2520, 3189.3153, 3326.3743, 3439.4583, 3526.4904, 3657.5308, 3785.5894, 3932.6578, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VNFTMFVLMLLFSILVQLVHLFTQLIHMGSCFVK", {100.0757, 214.1186, 361.1870, 462.2347, 593.2752, 740.3436, 839.4120, 952.4961, 1083.5366, 1196.6206, 1309.7047, 1456.7731, 1543.8051, 1656.8892, 1769.9733, 1869.0417, 1997.1003, 2110.1843, 2209.2527, 2346.3117, 2459.3957, 2606.4641, 2707.5118, 2835.5704, 2948.6544, 3061.7385, 3198.7974, 3329.8379, 3386.8594, 3473.8914, 3633.9221, 3780.9905, 3880.0589, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 246.1812, 393.2496, 553.2803, 640.3123, 697.3338, 828.3743, 965.4332, 1078.5172, 1191.6013, 1319.6599, 1420.7076, 1567.7760, 1680.8600, 1817.9189, 1916.9874, 2030.0714, 2158.1300, 2257.1984, 2370.2825, 2483.3665, 2570.3986, 2717.4670, 2830.5510, 2943.6351, 3074.6756, 3187.7597, 3286.8281, 3433.8965, 3564.9370, 3665.9847, 3813.0531, 3927.0960, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PTNEQVHHHTHQTGSQQNTRPPYTPQNYNYNAER", {98.0600, 199.1077, 313.1506, 442.1932, 570.2518, 669.3202, 806.3791, 943.4381, 1080.4970, 1181.5446, 1318.6036, 1446.6621, 1547.7098, 1604.7313, 1691.7633, 1819.8219, 1947.8805, 2061.9234, 2162.9711, 2319.0722, 2416.1249, 2513.1777, 2676.2410, 2777.2887, 2874.3415, 3002.4001, 3116.4430, 3279.5063, 3393.5492, 3556.6126, 3670.6555, 3741.6926, 3870.7352, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 375.1987, 489.2416, 652.3049, 766.3478, 929.4112, 1043.4541, 1171.5127, 1268.5654, 1369.6131, 1532.6764, 1629.7292, 1726.7820, 1882.8831, 1983.9308, 2097.9737, 2226.0323, 2354.0908, 2441.1229, 2498.1443, 2599.1920, 2727.2506, 2864.3095, 2965.3572, 3102.4161, 3239.4750, 3376.5339, 3475.6023, 3603.6609, 3732.7035, 3846.7464, 3947.7941, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TTIVPVQCYPCETVSEACTNCISLHNCPELTVTR", {102.0550, 203.1026, 316.1867, 415.2551, 512.3079, 611.3763, 739.4349, 899.4655, 1062.5288, 1159.5816, 1319.6123, 1448.6548, 1549.7025, 1648.7709, 1735.8030, 1864.8456, 1935.8827, 2095.9133, 2196.9610, 2311.0039, 2471.0346, 2584.1186, 2671.1507, 2784.2347, 2921.2936, 3035.3366, 3195.3672, 3292.4200, 3421.4626, 3534.5466, 3635.5943, 3734.6627, 3835.7104, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 276.1666, 375.2350, 476.2827, 589.3668, 718.4094, 815.4621, 975.4928, 1089.5357, 1226.5946, 1339.6787, 1426.7107, 1539.7948, 1699.8254, 1813.8684, 1914.9160, 2074.9467, 2145.9838, 2275.0264, 2362.0584, 2461.1268, 2562.1745, 2691.2171, 2851.2478, 2948.3005, 3111.3639, 3271.3945, 3399.4531, 3498.5215, 3595.5743, 3694.6427, 3807.7267, 3908.7744, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SNERPDDMSCPEVHAFACFVSRPCYGAQQVDNCK", {88.0393, 202.0822, 331.1248, 487.2259, 584.2787, 699.3056, 814.3326, 945.3731, 1032.4051, 1192.4357, 1289.4885, 1418.5311, 1517.5995, 1654.6584, 1725.6955, 1872.7640, 1943.8011, 2103.8317, 2250.9001, 2349.9685, 2437.0006, 2593.1017, 2690.1545, 2850.1851, 3013.2484, 3070.2699, 3141.3070, 3269.3656, 3397.4242, 3496.4926, 3611.5195, 3725.5624, 3885.5931, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 307.1435, 421.1864, 536.2133, 635.2817, 763.3403, 891.3989, 962.4360, 1019.4575, 1182.5208, 1342.5514, 1439.6042, 1595.7053, 1682.7374, 1781.8058, 1928.8742, 2088.9048, 2159.9419, 2307.0104, 2378.0475, 2515.1064, 2614.1748, 2743.2174, 2840.2702, 3000.3008, 3087.3328, 3218.3733, 3333.4003, 3448.4272, 3545.4800, 3701.5811, 3830.6237, 3944.6666, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QLPHHQPHQLSHQLPNHHHEPSLQMMEPMAQPAR", {129.0659, 242.1499, 339.2027, 476.2616, 613.3205, 741.3791, 838.4318, 975.4908, 1103.5493, 1216.6334, 1303.6654, 1440.7243, 1568.7829, 1681.8670, 1778.9197, 1892.9627, 2030.0216, 2167.0805, 2304.1394, 2433.1820, 2530.2348, 2617.2668, 2730.3509, 2858.4094, 2989.4499, 3120.4904, 3249.5330, 3346.5858, 3477.6262, 3548.6634, 3676.7219, 3773.7747, 3844.8118, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 246.1561, 343.2088, 471.2674, 542.3045, 673.3450, 770.3978, 899.4404, 1030.4808, 1161.5213, 1289.5799, 1402.6640, 1489.6960, 1586.7488, 1715.7914, 1852.8503, 1989.9092, 2126.9681, 2241.0110, 2338.0638, 2451.1479, 2579.2064, 2716.2653, 2803.2974, 2916.3814, 3044.4400, 3181.4989, 3278.5517, 3406.6103, 3543.6692, 3680.7281, 3777.7809, 3890.8649, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MPGMGMNNFCDPAPQFQQQPQQQGQLQQQPQMFR", {132.0478, 229.1005, 286.1220, 417.1625, 474.1839, 605.2244, 719.2673, 833.3103, 980.3787, 1140.4093, 1255.4363, 1352.4890, 1423.5262, 1520.5789, 1648.6375, 1795.7059, 1923.7645, 2051.8231, 2179.8816, 2276.9344, 2404.9930, 2533.0516, 2661.1101, 2718.1316, 2846.1902, 2959.2742, 3087.3328, 3215.3914, 3343.4500, 3440.5027, 3568.5613, 3699.6018, 3846.6702, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 453.2279, 581.2864, 678.3392, 806.3978, 934.4563, 1062.5149, 1175.5990, 1303.6576, 1360.6790, 1488.7376, 1616.7962, 1744.8548, 1841.9075, 1969.9661, 2098.0247, 2226.0833, 2373.1517, 2501.2103, 2598.2630, 2669.3001, 2766.3529, 2881.3798, 3041.4105, 3188.4789, 3302.5218, 3416.5648, 3547.6052, 3604.6267, 3735.6672, 3792.6886, 3889.7414, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"IPRPSDHQTFNVWNAHEVYVAHEGLEFLQEVLDK", {114.0913, 211.1441, 367.2452, 464.2980, 551.3300, 666.3570, 803.4159, 931.4744, 1032.5221, 1179.5905, 1293.6335, 1392.7019, 1578.7812, 1692.8241, 1763.8612, 1900.9201, 2029.9627, 2129.0311, 2292.0945, 2391.1629, 2462.2000, 2599.2589, 2728.3015, 2785.3230, 2898.4070, 3027.4496, 3174.5180, 3287.6021, 3415.6607, 3544.7033, 3643.7717, 3756.8558, 3871.8827, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 262.1397, 375.2238, 474.2922, 603.3348, 731.3934, 844.4775, 991.5459, 1120.5885, 1233.6725, 1290.6940, 1419.7366, 1556.7955, 1627.8326, 1726.9010, 1889.9644, 1989.0328, 2118.0754, 2255.1343, 2326.1714, 2440.2143, 2626.2936, 2725.3620, 2839.4050, 2986.4734, 3087.5211, 3215.5796, 3352.6386, 3467.6655, 3554.6975, 3651.7503, 3807.8514, 3904.9042, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NYENFDIWPVHEIYVSGEDLNYIYGATEAQARPK", {115.0502, 278.1135, 407.1561, 521.1991, 668.2675, 783.2944, 896.3785, 1082.4578, 1179.5106, 1278.5790, 1415.6379, 1544.6805, 1657.7645, 1820.8279, 1919.8963, 2006.9283, 2063.9498, 2192.9924, 2308.0193, 2421.1034, 2535.1463, 2698.2096, 2811.2937, 2974.3570, 3031.3785, 3102.4156, 3203.4633, 3332.5059, 3403.5430, 3531.6016, 3602.6387, 3758.7398, 3855.7925, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 244.1656, 400.2667, 471.3038, 599.3624, 670.3995, 799.4421, 900.4898, 971.5269, 1028.5483, 1191.6117, 1304.6957, 1467.7591, 1581.8020, 1694.8860, 1809.9130, 1938.9556, 1995.9770, 2083.0091, 2182.0775, 2345.1408, 2458.2249, 2587.2675, 2724.3264, 2823.3948, 2920.4476, 3106.5269, 3219.6109, 3334.6379, 3481.7063, 3595.7492, 3724.7918, 3887.8551, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YLAFVLMCSLLFIFHLYIGNACDATEGYPVQQLR", {164.0706, 277.1547, 348.1918, 495.2602, 594.3286, 707.4127, 838.4532, 998.4838, 1085.5158, 1198.5999, 1311.6840, 1458.7524, 1571.8364, 1718.9049, 1855.9638, 1969.0478, 2132.1112, 2245.1952, 2302.2167, 2416.2596, 2487.2967, 2647.3274, 2762.3543, 2833.3914, 2934.4391, 3063.4817, 3120.5032, 3283.5665, 3380.6193, 3479.6877, 3607.7463, 3735.8048, 3848.8889, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 416.2616, 544.3202, 643.3886, 740.4413, 903.5047, 960.5261, 1089.5687, 1190.6164, 1261.6535, 1376.6805, 1536.7111, 1607.7482, 1721.7912, 1778.8126, 1891.8967, 2054.9600, 2168.0441, 2305.1030, 2452.1714, 2565.2555, 2712.3239, 2825.4079, 2938.4920, 3025.5240, 3185.5547, 3316.5952, 3429.6792, 3528.7477, 3675.8161, 3746.8532, 3859.9372, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"GADFHHKPFTFMSVGIYSFIFNEALFNLLEFIQK", {58.0287, 129.0659, 244.0928, 391.1612, 528.2201, 665.2790, 793.3740, 890.4268, 1037.4952, 1138.5429, 1285.6113, 1416.6518, 1503.6838, 1602.7522, 1659.7737, 1772.8577, 1935.9211, 2022.9531, 2170.0215, 2283.1056, 2430.1740, 2544.2169, 2673.2595, 2744.2966, 2857.3807, 3004.4491, 3118.4920, 3231.5761, 3344.6601, 3473.7027, 3620.7711, 3733.8552, 3861.9138, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 275.1714, 388.2554, 535.3239, 664.3665, 777.4505, 890.5346, 1004.5775, 1151.6459, 1264.7300, 1335.7671, 1464.8097, 1578.8526, 1725.9210, 1839.0051, 1986.0735, 2073.1055, 2236.1689, 2349.2529, 2406.2744, 2505.3428, 2592.3748, 2723.4153, 2870.4837, 2971.5314, 3118.5998, 3215.6526, 3343.7476, 3480.8065, 3617.8654, 3764.9338, 3879.9607, 3950.9979, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ASLVFIMVIIDQSNEEFPVQWHDLTADMVFVECR", {72.0444, 159.0764, 272.1605, 371.2289, 518.2973, 631.3814, 762.4219, 861.4903, 974.5743, 1087.6584, 1202.6853, 1330.7439, 1417.7760, 1531.8189, 1660.8615, 1789.9041, 1936.9725, 2034.0252, 2133.0937, 2261.1522, 2447.2315, 2584.2905, 2699.3174, 2812.4015, 2913.4491, 2984.4863, 3099.5132, 3230.5537, 3329.6221, 3476.6905, 3575.7589, 3704.8015, 3864.8322, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 335.1496, 464.1922, 563.2606, 710.3290, 809.3974, 940.4379, 1055.4649, 1126.5020, 1227.5497, 1340.6337, 1455.6607, 1592.7196, 1778.7989, 1906.8575, 2005.9259, 2102.9786, 2250.0471, 2379.0897, 2508.1322, 2622.1752, 2709.2072, 2837.2658, 2952.2927, 3065.3768, 3178.4608, 3277.5293, 3408.5697, 3521.6538, 3668.7222, 3767.7906, 3880.8747, 3967.9067, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VTVTPTEQSWYWSVVVLVISTIIALIVVVLWFWR", {100.0757, 201.1234, 300.1918, 401.2395, 498.2922, 599.3399, 728.3825, 856.4411, 943.4731, 1129.5524, 1292.6157, 1478.6951, 1565.7271, 1664.7955, 1763.8639, 1862.9323, 1976.0164, 2075.0848, 2188.1689, 2275.2009, 2376.2486, 2489.3326, 2602.4167, 2673.4538, 2786.5379, 2899.6219, 2998.6904, 3097.7588, 3196.8272, 3309.9113, 3495.9906, 3643.0590, 3829.1383, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 361.1983, 508.2667, 694.3460, 807.4301, 906.4985, 1005.5669, 1104.6353, 1217.7194, 1330.8034, 1401.8405, 1514.9246, 1628.0087, 1729.0563, 1816.0884, 1929.1724, 2028.2409, 2141.3249, 2240.3933, 2339.4617, 2438.5302, 2525.5622, 2711.6415, 2874.7048, 3060.7841, 3147.8162, 3275.8747, 3404.9173, 3505.9650, 3603.0178, 3704.0655, 3803.1339, 3904.1816, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NSYELFRPESLESPNYSIKPIDVLEFCAGLNYIK", {115.0502, 202.0822, 365.1456, 494.1882, 607.2722, 754.3406, 910.4417, 1007.4945, 1136.5371, 1223.5691, 1336.6532, 1465.6958, 1552.7278, 1649.7806, 1763.8235, 1926.8868, 2013.9189, 2127.0029, 2255.0979, 2352.1507, 2465.2347, 2580.2617, 2679.3301, 2792.4141, 2921.4567, 3068.5251, 3228.5558, 3299.5929, 3356.6144, 3469.6984, 3583.7414, 3746.8047, 3859.8888, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 423.2602, 537.3031, 650.3872, 707.4087, 778.4458, 938.4764, 1085.5448, 1214.5874, 1327.6715, 1426.7399, 1541.7668, 1654.8509, 1751.9037, 1879.9986, 1993.0827, 2080.1147, 2243.1781, 2357.2210, 2454.2737, 2541.3058, 2670.3484, 2783.4324, 2870.4645, 2999.5071, 3096.5598, 3252.6609, 3399.7293, 3512.8134, 3641.8560, 3804.9193, 3891.9514, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"CYAFYACTIIVLASLAYILWSWSLVTVFTANLDR", {161.0379, 324.1013, 395.1384, 542.2068, 705.2701, 776.3072, 936.3379, 1037.3856, 1150.4696, 1263.5537, 1362.6221, 1475.7062, 1546.7433, 1633.7753, 1746.8594, 1817.8965, 1980.9598, 2094.0439, 2207.1279, 2393.2072, 2480.2393, 2666.3186, 2753.3506, 2866.4347, 2965.5031, 3066.5508, 3165.6192, 3312.6876, 3413.7353, 3484.7724, 3598.8153, 3711.8994, 3826.9263, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 290.1459, 403.2300, 517.2729, 588.3100, 689.3577, 836.4261, 935.4945, 1036.5422, 1135.6106, 1248.6947, 1335.7267, 1521.8060, 1608.8380, 1794.9173, 1908.0014, 2021.0855, 2184.1488, 2255.1859, 2368.2700, 2455.3020, 2526.3391, 2639.4232, 2738.4916, 2851.5757, 2964.6597, 3065.7074, 3225.7381, 3296.7752, 3459.8385, 3606.9069, 3677.9440, 3841.0074, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ISPYYQTYSIYGAFLGILGGITVDQWHHHYDCTR", {114.0913, 201.1234, 298.1761, 461.2395, 624.3028, 752.3614, 853.4090, 1016.4724, 1103.5044, 1216.5885, 1379.6518, 1436.6733, 1507.7104, 1654.7788, 1767.8629, 1824.8843, 1937.9684, 2051.0524, 2108.0739, 2165.0954, 2278.1794, 2379.2271, 2478.2955, 2593.3225, 2721.3810, 2907.4604, 3044.5193, 3181.5782, 3318.6371, 3481.7004, 3596.7274, 3756.7580, 3857.8057, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 276.1666, 436.1973, 551.2242, 714.2876, 851.3465, 988.4054, 1125.4643, 1311.5436, 1439.6022, 1554.6291, 1653.6975, 1754.7452, 1867.8293, 1924.8507, 1981.8722, 2094.9563, 2208.0403, 2265.0618, 2378.1459, 2525.2143, 2596.2514, 2653.2729, 2816.3362, 2929.4202, 3016.4523, 3179.5156, 3280.5633, 3408.6219, 3571.6852, 3734.7485, 3831.8013, 3918.8333, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LVNYHNRPQQALQNLEDQVEDESEEPASHIFFNK", {114.0913, 213.1598, 327.2027, 490.2660, 627.3249, 741.3678, 897.4690, 994.5217, 1122.5803, 1250.6389, 1321.6760, 1434.7601, 1562.8186, 1676.8616, 1789.9456, 1918.9882, 2034.0152, 2162.0737, 2261.1422, 2390.1847, 2505.2117, 2634.2543, 2721.2863, 2850.3289, 2979.3715, 3076.4243, 3147.4614, 3234.4934, 3371.5523, 3484.6364, 3631.7048, 3778.7732, 3892.8161, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 261.1557, 408.2241, 555.2926, 668.3766, 805.4355, 892.4676, 963.5047, 1060.5574, 1189.6000, 1318.6426, 1405.6747, 1534.7172, 1649.7442, 1778.7868, 1877.8552, 2005.9138, 2120.9407, 2249.9833, 2363.0674, 2477.1103, 2605.1689, 2718.2529, 2789.2901, 2917.3486, 3045.4072, 3142.4600, 3298.5611, 3412.6040, 3549.6629, 3712.7263, 3826.7692, 3925.8376, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"AISQMAEQLHGLESMVECEEHVVPQLMHVFSCYR", {72.0444, 185.1285, 272.1605, 400.2191, 531.2595, 602.2967, 731.3393, 859.3978, 972.4819, 1109.5408, 1166.5623, 1279.6463, 1408.6889, 1495.7210, 1626.7614, 1725.8299, 1854.8724, 2014.9031, 2143.9457, 2272.9883, 2410.0472, 2509.1156, 2608.1840, 2705.2368, 2833.2954, 2946.3794, 3077.4199, 3214.4788, 3313.5472, 3460.6157, 3547.6477, 3707.6783, 3870.7417, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 498.2129, 585.2450, 732.3134, 831.3818, 968.4407, 1099.4812, 1212.5652, 1340.6238, 1437.6766, 1536.7450, 1635.8134, 1772.8723, 1901.9149, 2030.9575, 2190.9882, 2320.0308, 2419.0992, 2550.1397, 2637.1717, 2766.2143, 2879.2983, 2936.3198, 3073.3787, 3186.4628, 3314.5214, 3443.5639, 3514.6011, 3645.6415, 3773.7001, 3860.7322, 3973.8162, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PNDPSCEQEYLDLNLPDALQTYYPNWVYGGAVCR", {98.0600, 212.1030, 327.1299, 424.1827, 511.2147, 671.2454, 800.2879, 928.3465, 1057.3891, 1220.4524, 1333.5365, 1448.5635, 1561.6475, 1675.6904, 1788.7745, 1885.8273, 2000.8542, 2071.8913, 2184.9754, 2313.0340, 2414.0816, 2577.1450, 2740.2083, 2837.2611, 2951.3040, 3137.3833, 3236.4517, 3399.5151, 3456.5365, 3513.5580, 3584.5951, 3683.6635, 3843.6942, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 335.1496, 434.2180, 505.2551, 562.2766, 619.2981, 782.3614, 881.4298, 1067.5091, 1181.5520, 1278.6048, 1441.6681, 1604.7315, 1705.7791, 1833.8377, 1946.9218, 2017.9589, 2132.9858, 2230.0386, 2343.1227, 2457.1656, 2570.2497, 2685.2766, 2798.3607, 2961.4240, 3090.4666, 3218.5252, 3347.5678, 3507.5984, 3594.6304, 3691.6832, 3806.7101, 3920.7531, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"CMLQAYEDQSLIQTQQMPELFNELLGQLEAVHAR", {161.0379, 292.0784, 405.1625, 533.2211, 604.2582, 767.3215, 896.3641, 1011.3910, 1139.4496, 1226.4816, 1339.5657, 1452.6498, 1580.7083, 1681.7560, 1809.8146, 1937.8732, 2068.9137, 2165.9664, 2295.0090, 2408.0931, 2555.1615, 2669.2044, 2798.2470, 2911.3311, 3024.4151, 3081.4366, 3209.4952, 3322.5792, 3451.6218, 3522.6590, 3621.7274, 3758.7863, 3829.8234, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 246.1561, 383.2150, 482.2834, 553.3205, 682.3631, 795.4472, 923.5057, 980.5272, 1093.6113, 1206.6953, 1335.7379, 1449.7809, 1596.8493, 1709.9333, 1838.9759, 1936.0287, 2067.0692, 2195.1277, 2323.1863, 2424.2340, 2552.2926, 2665.3766, 2778.4607, 2865.4927, 2993.5513, 3108.5783, 3237.6209, 3400.6842, 3471.7213, 3599.7799, 3712.8639, 3843.9044, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"GMVCSEYQVTADPMHPYLSPNVWDSENYQTETHK", {58.0287, 189.0692, 288.1376, 448.1683, 535.2003, 664.2429, 827.3062, 955.3648, 1054.4332, 1155.4809, 1226.5180, 1341.5450, 1438.5977, 1569.6382, 1706.6971, 1803.7499, 1966.8132, 2079.8973, 2166.9293, 2263.9821, 2378.0250, 2477.0934, 2663.1727, 2778.1997, 2865.2317, 2994.2743, 3108.3172, 3271.3805, 3399.4391, 3500.4868, 3629.5294, 3730.5771, 3867.6360, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 284.1717, 385.2194, 514.2620, 615.3097, 743.3682, 906.4316, 1020.4745, 1149.5171, 1236.5491, 1351.5761, 1537.6554, 1636.7238, 1750.7667, 1847.8195, 1934.8515, 2047.9356, 2210.9989, 2308.0517, 2445.1106, 2576.1511, 2673.2038, 2788.2308, 2859.2679, 2960.3156, 3059.3840, 3187.4426, 3350.5059, 3479.5485, 3566.5805, 3726.6112, 3825.6796, 3956.7201, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DMLEDDSPPGQEGESSHFQDETPEESSQEQWCYK", {116.0342, 247.0747, 360.1588, 489.2014, 604.2283, 719.2552, 806.2873, 903.3400, 1000.3928, 1057.4143, 1185.4728, 1314.5154, 1371.5369, 1500.5795, 1587.6115, 1674.6436, 1811.7025, 1958.7709, 2086.8295, 2201.8564, 2330.8990, 2431.9467, 2528.9994, 2658.0420, 2787.0846, 2874.1166, 2961.1487, 3089.2073, 3218.2498, 3346.3084, 3532.3877, 3692.4184, 3855.4817, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 310.1761, 470.2068, 656.2861, 784.3447, 913.3873, 1041.4458, 1128.4779, 1215.5099, 1344.5525, 1473.5951, 1570.6478, 1671.6955, 1800.7381, 1915.7651, 2043.8236, 2190.8921, 2327.9510, 2414.9830, 2502.0150, 2631.0576, 2688.0791, 2817.1217, 2945.1803, 3002.2017, 3099.2545, 3196.3072, 3283.3393, 3398.3662, 3513.3932, 3642.4358, 3755.5198, 3886.5603, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"IYHDAIALYQNYCGMTIGLLNMLMSLVMSWDTFR", {114.0913, 277.1547, 414.2136, 529.2405, 600.2776, 713.3617, 784.3988, 897.4829, 1060.5462, 1188.6048, 1302.6477, 1465.7110, 1625.7417, 1682.7632, 1813.8036, 1914.8513, 2027.9354, 2084.9568, 2198.0409, 2311.1250, 2425.1679, 2556.2084, 2669.2924, 2800.3329, 2887.3650, 3000.4490, 3099.5174, 3230.5579, 3317.5900, 3503.6693, 3618.6962, 3719.7439, 3866.8123, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 423.2350, 538.2620, 724.3413, 811.3733, 942.4138, 1041.4822, 1154.5663, 1241.5983, 1372.6388, 1485.7229, 1616.7634, 1730.8063, 1843.8903, 1956.9744, 2013.9959, 2127.0799, 2228.1276, 2359.1681, 2416.1896, 2576.2202, 2739.2835, 2853.3265, 2981.3850, 3144.4484, 3257.5324, 3328.5696, 3441.6536, 3512.6907, 3627.7177, 3764.7766, 3927.8399, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"WLEKPVDLPTPFVFWIVAEACPPTTLSGQYTFYK", {187.0866, 300.1707, 429.2132, 557.3082, 654.3610, 753.4294, 868.4563, 981.5404, 1078.5932, 1179.6408, 1276.6936, 1423.7620, 1522.8304, 1669.8988, 1855.9782, 1969.0622, 2068.1306, 2139.1677, 2268.2103, 2339.2475, 2499.2781, 2596.3309, 2693.3836, 2794.4313, 2895.4790, 3008.5631, 3095.5951, 3152.6165, 3280.6751, 3443.7384, 3544.7861, 3691.8545, 3854.9179, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 310.1761, 457.2445, 558.2922, 721.3556, 849.4141, 906.4356, 993.4676, 1106.5517, 1207.5994, 1308.6470, 1405.6998, 1502.7526, 1662.7832, 1733.8203, 1862.8629, 1933.9000, 2032.9685, 2146.0525, 2332.1318, 2479.2002, 2578.2687, 2725.3371, 2822.3898, 2923.4375, 3020.4903, 3133.5743, 3248.6013, 3347.6697, 3444.7225, 3572.8174, 3701.8600, 3814.9441, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EDLVMSFCYGGINHNELKPLTNAQIQIDQLMMER", {130.0499, 245.0768, 358.1609, 457.2293, 588.2698, 675.3018, 822.3702, 982.4009, 1145.4642, 1202.4857, 1259.5071, 1372.5912, 1486.6341, 1623.6930, 1737.7360, 1866.7785, 1979.8626, 2107.9576, 2205.0103, 2318.0944, 2419.1421, 2533.1850, 2604.2221, 2732.2807, 2845.3648, 2973.4233, 3086.5074, 3201.5343, 3329.5929, 3442.6770, 3573.7175, 3704.7580, 3833.8006, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 435.2020, 566.2425, 679.3266, 807.3852, 922.4121, 1035.4962, 1163.5547, 1276.6388, 1404.6974, 1475.7345, 1589.7774, 1690.8251, 1803.9092, 1900.9619, 2029.0569, 2142.1410, 2271.1836, 2385.2265, 2522.2854, 2636.3283, 2749.4124, 2806.4338, 2863.4553, 3026.5186, 3186.5493, 3333.6177, 3420.6497, 3551.6902, 3650.7586, 3763.8427, 3878.8696, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MQQHQQLHQQLQQQIPQMMTPAPAHSHHEVISQK", {132.0478, 260.1063, 388.1649, 525.2238, 653.2824, 781.3410, 894.4250, 1031.4840, 1159.5425, 1287.6011, 1400.6852, 1528.7438, 1656.8023, 1784.8609, 1897.9450, 1994.9977, 2123.0563, 2254.0968, 2385.1373, 2486.1850, 2583.2377, 2654.2748, 2751.3276, 2822.3647, 2959.4236, 3046.4557, 3183.5146, 3320.5735, 3449.6161, 3548.6845, 3661.7686, 3748.8006, 3876.8592, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 275.1714, 362.2034, 475.2875, 574.3559, 703.3985, 840.4574, 977.5163, 1064.5483, 1201.6072, 1272.6444, 1369.6971, 1440.7342, 1537.7870, 1638.8347, 1769.8752, 1900.9156, 2028.9742, 2126.0270, 2239.1111, 2367.1696, 2495.2282, 2623.2868, 2736.3709, 2864.4294, 2992.4880, 3129.5469, 3242.6310, 3370.6896, 3498.7481, 3635.8070, 3763.8656, 3891.9242, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SDFNCHMVIDEVSYIWGESGWHNYTTTVVQVNNK", {88.0393, 203.0662, 350.1347, 464.1776, 624.2082, 761.2671, 892.3076, 991.3760, 1104.4601, 1219.4871, 1348.5296, 1447.5981, 1534.6301, 1697.6934, 1810.7775, 1996.8568, 2053.8783, 2182.9209, 2269.9529, 2326.9743, 2513.0537, 2650.1126, 2764.1555, 2927.2188, 3028.2665, 3129.3142, 3230.3619, 3329.4303, 3428.4987, 3556.5573, 3655.6257, 3769.6686, 3883.7115, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 261.1557, 375.1987, 474.2671, 602.3257, 701.3941, 800.4625, 901.5102, 1002.5578, 1103.6055, 1266.6688, 1380.7118, 1517.7707, 1703.8500, 1760.8715, 1847.9035, 1976.9461, 2033.9675, 2220.0469, 2333.1309, 2496.1942, 2583.2263, 2682.2947, 2811.3373, 2926.3642, 3039.4483, 3138.5167, 3269.5572, 3406.6161, 3566.6468, 3680.6897, 3827.7581, 3942.7850, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LEMFGYVFLCVIFYATLTAFVQFVILLLIFFSGR", {114.0913, 243.1339, 374.1744, 521.2428, 578.2643, 741.3276, 840.3960, 987.4645, 1100.5485, 1260.5792, 1359.6476, 1472.7316, 1619.8001, 1782.8634, 1853.9005, 1954.9482, 2068.0322, 2169.0799, 2240.1170, 2387.1854, 2486.2539, 2614.3124, 2761.3809, 2860.4493, 2973.5333, 3086.6174, 3199.7015, 3312.7855, 3425.8696, 3572.9380, 3720.0064, 3807.0384, 3864.0599, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 232.1404, 319.1724, 466.2409, 613.3093, 726.3933, 839.4774, 952.5615, 1065.6455, 1178.7296, 1277.7980, 1424.8664, 1552.9250, 1651.9934, 1799.0618, 1870.0989, 1971.1466, 2084.2307, 2185.2784, 2256.3155, 2419.3788, 2566.4472, 2679.5313, 2778.5997, 2938.6303, 3051.7144, 3198.7828, 3297.8512, 3460.9146, 3517.9360, 3665.0044, 3796.0449, 3925.0875, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MLELDEYDNLNGLYHTSGINTGVYYFEQSNLCFK", {132.0478, 245.1318, 374.1744, 487.2585, 602.2854, 731.3280, 894.3913, 1009.4183, 1123.4612, 1236.5453, 1350.5882, 1407.6097, 1520.6937, 1683.7571, 1820.8160, 1921.8637, 2008.8957, 2065.9171, 2179.0012, 2293.0441, 2394.0918, 2451.1133, 2550.1817, 2713.2450, 2876.3084, 3023.3768, 3152.4194, 3280.4779, 3367.5100, 3481.5529, 3594.6370, 3754.6676, 3901.7360, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 294.1812, 454.2119, 567.2959, 681.3389, 768.3709, 896.4295, 1025.4721, 1172.5405, 1335.6038, 1498.6671, 1597.7355, 1654.7570, 1755.8047, 1869.8476, 1982.9317, 2039.9531, 2126.9852, 2228.0328, 2365.0918, 2528.1551, 2641.2392, 2698.2606, 2812.3035, 2925.3876, 3039.4305, 3154.4575, 3317.5208, 3446.5634, 3561.5903, 3674.6744, 3803.7170, 3916.8011, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"AFGENLWLDNWWNMTVLNGFWQHALEHAVVIAVR", {72.0444, 219.1128, 276.1343, 405.1769, 519.2198, 632.3039, 818.3832, 931.4672, 1046.4942, 1160.5371, 1346.6164, 1532.6957, 1646.7387, 1777.7791, 1878.8268, 1977.8952, 2090.9793, 2205.0222, 2262.0437, 2409.1121, 2595.1914, 2723.2500, 2860.3089, 2931.3460, 3044.4301, 3173.4727, 3310.5316, 3381.5687, 3480.6371, 3579.7055, 3692.7896, 3763.8267, 3862.8951, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 274.1874, 345.2245, 458.3085, 557.3770, 656.4454, 727.4825, 864.5414, 993.5840, 1106.6681, 1177.7052, 1314.7641, 1442.8227, 1628.9020, 1775.9704, 1832.9918, 1947.0348, 2060.1188, 2159.1873, 2260.2349, 2391.2754, 2505.3183, 2691.3977, 2877.4770, 2991.5199, 3106.5468, 3219.6309, 3405.7102, 3518.7943, 3632.8372, 3761.8798, 3818.9013, 3965.9697, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EGFDIASQQDYLILHFNAIFIFFSHALATWVFSR", {130.0499, 187.0713, 334.1397, 449.1667, 562.2508, 633.2879, 720.3199, 848.3785, 976.4371, 1091.4640, 1254.5273, 1367.6114, 1480.6955, 1593.7795, 1730.8384, 1877.9068, 1991.9498, 2062.9869, 2176.0709, 2323.1394, 2436.2234, 2583.2918, 2730.3603, 2817.3923, 2954.4512, 3025.4883, 3138.5724, 3209.6095, 3310.6572, 3496.7365, 3595.8049, 3742.8733, 3829.9053, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 262.1510, 409.2194, 508.2878, 694.3671, 795.4148, 866.4519, 979.5360, 1050.5731, 1187.6320, 1274.6640, 1421.7324, 1568.8009, 1681.8849, 1828.9533, 1942.0374, 2013.0745, 2127.1174, 2274.1859, 2411.2448, 2524.3288, 2637.4129, 2750.4970, 2913.5603, 3028.5872, 3156.6458, 3284.7044, 3371.7364, 3442.7735, 3555.8576, 3670.8845, 3817.9530, 3874.9744, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VSLNLMGDLYYFFCWSYALIVTSLTMSLNEYGHK", {100.0757, 187.1077, 300.1918, 414.2347, 527.3188, 658.3593, 715.3807, 830.4077, 943.4917, 1106.5551, 1269.6184, 1416.6868, 1563.7552, 1723.7859, 1909.8652, 1996.8972, 2159.9605, 2230.9976, 2344.0817, 2457.1658, 2556.2342, 2657.2819, 2744.3139, 2857.3980, 2958.4456, 3089.4861, 3176.5182, 3289.6022, 3403.6451, 3532.6877, 3695.7511, 3752.7725, 3889.8314, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 284.1717, 341.1932, 504.2565, 633.2991, 747.3420, 860.4261, 947.4581, 1078.4986, 1179.5463, 1292.6303, 1379.6624, 1480.7101, 1579.7785, 1692.8625, 1805.9466, 1876.9837, 2040.0470, 2127.0791, 2313.1584, 2473.1890, 2620.2574, 2767.3259, 2930.3892, 3093.4525, 3206.5366, 3321.5635, 3378.5850, 3509.6255, 3622.7095, 3736.7525, 3849.8365, 3936.8686, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SCHCEECAVTSESNPDETDPVLEWEDDDSDSNQR", {88.0393, 248.0700, 385.1289, 545.1595, 674.2021, 803.2447, 963.2753, 1034.3125, 1133.3809, 1234.4286, 1321.4606, 1450.5032, 1537.5352, 1651.5781, 1748.6309, 1863.6578, 1992.7004, 2093.7481, 2208.7751, 2305.8278, 2404.8962, 2517.9803, 2647.0229, 2833.1022, 2962.1448, 3077.1717, 3192.1987, 3307.2256, 3394.2577, 3509.2846, 3596.3166, 3710.3596, 3838.4181, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 417.2205, 504.2525, 619.2794, 706.3115, 821.3384, 936.3653, 1051.3923, 1180.4349, 1366.5142, 1495.5568, 1608.6408, 1707.7093, 1804.7620, 1919.7890, 2020.8366, 2149.8792, 2264.9062, 2361.9589, 2476.0019, 2563.0339, 2692.0765, 2779.1085, 2880.1562, 2979.2246, 3050.2617, 3210.2924, 3339.3350, 3468.3776, 3628.4082, 3765.4671, 3925.4978, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FFHPNSIYVPAGYQCPSINQLGQIPEYESTDYCK", {148.0757, 295.1441, 432.2030, 529.2558, 643.2987, 730.3307, 843.4148, 1006.4781, 1105.5465, 1202.5993, 1273.6364, 1330.6579, 1493.7212, 1621.7798, 1781.8104, 1878.8632, 1965.8952, 2078.9793, 2193.0222, 2321.0808, 2434.1649, 2491.1863, 2619.2449, 2732.3290, 2829.3817, 2958.4243, 3121.4877, 3250.5302, 3337.5623, 3438.6100, 3553.6369, 3716.7002, 3876.7309, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 307.1435, 470.2068, 585.2337, 686.2814, 773.3134, 902.3560, 1065.4194, 1194.4619, 1291.5147, 1404.5988, 1532.6574, 1589.6788, 1702.7629, 1830.8215, 1944.8644, 2057.9484, 2144.9805, 2242.0332, 2402.0639, 2530.1225, 2693.1858, 2750.2073, 2821.2444, 2918.2971, 3017.3656, 3180.4289, 3293.5129, 3380.5450, 3494.5879, 3591.6407, 3728.6996, 3875.7680, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SNAMWFALIRPDTYQEQVVSYVLNAVHHLFMTLK", {88.0393, 202.0822, 273.1193, 404.1598, 590.2391, 737.3076, 808.3447, 921.4287, 1034.5128, 1190.6139, 1287.6667, 1402.6936, 1503.7413, 1666.8046, 1794.8632, 1923.9058, 2051.9644, 2151.0328, 2250.1012, 2337.1332, 2500.1966, 2599.2650, 2712.3490, 2826.3920, 2897.4291, 2996.4975, 3133.5564, 3270.6153, 3383.6994, 3530.7678, 3661.8083, 3762.8560, 3875.9400, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 361.2445, 492.2850, 639.3534, 752.4375, 889.4964, 1026.5553, 1125.6237, 1196.6609, 1310.7038, 1423.7879, 1522.8563, 1685.9196, 1772.9516, 1872.0200, 1971.0885, 2099.1470, 2228.1896, 2356.2482, 2519.3115, 2620.3592, 2735.3861, 2832.4389, 2988.5400, 3101.6241, 3214.7082, 3285.7453, 3432.8137, 3618.8930, 3749.9335, 3820.9706, 3935.0135, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QLYIQELEVNELSENEEESSEIAENNEFVSMLYK", {129.0659, 242.1499, 405.2132, 518.2973, 646.3559, 775.3985, 888.4825, 1017.5251, 1116.5936, 1230.6365, 1359.6791, 1472.7631, 1559.7952, 1688.8378, 1802.8807, 1931.9233, 2060.9659, 2190.0085, 2277.0405, 2364.0725, 2493.1151, 2606.1992, 2677.2363, 2806.2789, 2920.3218, 3034.3647, 3163.4073, 3310.4757, 3409.5442, 3496.5762, 3627.6167, 3740.7007, 3903.7641, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 310.1761, 423.2602, 554.3007, 641.3327, 740.4011, 887.4695, 1016.5121, 1130.5551, 1244.5980, 1373.6406, 1444.6777, 1557.7618, 1686.8043, 1773.8364, 1860.8684, 1989.9110, 2118.9536, 2247.9962, 2362.0391, 2491.0817, 2578.1137, 2691.1978, 2820.2404, 2934.2833, 3033.3517, 3162.3943, 3275.4784, 3404.5210, 3532.5796, 3645.6636, 3808.7270, 3921.8110, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EIFEVDDHQEEAAEEVEDHDETMENENEDDDDGK", {130.0499, 243.1339, 390.2023, 519.2449, 618.3134, 733.3403, 848.3672, 985.4262, 1113.4847, 1242.5273, 1371.5699, 1442.6070, 1513.6441, 1642.6867, 1771.7293, 1870.7977, 1999.8403, 2114.8673, 2251.9262, 2366.9531, 2495.9957, 2597.0434, 2728.0839, 2857.1265, 2971.1694, 3100.2120, 3214.2549, 3343.2975, 3458.3245, 3573.3514, 3688.3784, 3803.4053, 3860.4268, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 204.1343, 319.1612, 434.1882, 549.2151, 664.2420, 793.2846, 907.3276, 1036.3702, 1150.4131, 1279.4557, 1410.4962, 1511.5438, 1640.5864, 1755.6134, 1892.6723, 2007.6992, 2136.7418, 2235.8102, 2364.8528, 2493.8954, 2564.9325, 2635.9696, 2765.0122, 2894.0548, 3022.1134, 3159.1723, 3274.1993, 3389.2262, 3488.2946, 3617.3372, 3764.4056, 3877.4897, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"IEINFGVHVDLADLVDCLQPFPQHELCDDNHFSR", {114.0913, 243.1339, 356.2180, 470.2609, 617.3293, 674.3508, 773.4192, 910.4781, 1009.5465, 1124.5735, 1237.6575, 1308.6947, 1423.7216, 1536.8057, 1635.8741, 1750.9010, 1910.9317, 2024.0157, 2152.0743, 2249.1271, 2396.1955, 2493.2483, 2621.3068, 2758.3657, 2887.4083, 3000.4924, 3160.5231, 3275.5500, 3390.5769, 3504.6199, 3641.6788, 3788.7472, 3875.7792, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 262.1510, 409.2194, 546.2783, 660.3212, 775.3482, 890.3751, 1050.4058, 1163.4898, 1292.5324, 1429.5913, 1557.6499, 1654.7027, 1801.7711, 1898.8239, 2026.8824, 2139.9665, 2299.9971, 2415.0241, 2514.0925, 2627.1766, 2742.2035, 2813.2406, 2926.3247, 3041.3516, 3140.4200, 3277.4790, 3376.5474, 3433.5688, 3580.6372, 3694.6802, 3807.7642, 3936.8068, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SQFKPLDQYPEITSCQNEHEENLMADTEQDLVTK", {88.0393, 216.0979, 363.1663, 491.2613, 588.3140, 701.3981, 816.4250, 944.4836, 1107.5469, 1204.5997, 1333.6423, 1446.7264, 1547.7740, 1634.8061, 1794.8367, 1922.8953, 2036.9382, 2165.9808, 2303.0397, 2432.0823, 2561.1249, 2675.1678, 2788.2519, 2919.2924, 2990.3295, 3105.3564, 3206.4041, 3335.4467, 3463.5053, 3578.5322, 3691.6163, 3790.6847, 3891.7324, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 248.1605, 347.2289, 460.3130, 575.3399, 703.3985, 832.4411, 933.4888, 1048.5157, 1119.5528, 1250.5933, 1363.6774, 1477.7203, 1606.7629, 1735.8055, 1872.8644, 2001.9070, 2115.9499, 2244.0085, 2404.0391, 2491.0712, 2592.1188, 2705.2029, 2834.2455, 2931.2983, 3094.3616, 3222.4202, 3337.4471, 3450.5312, 3547.5839, 3675.6789, 3822.7473, 3950.8059, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EVQYQCCPDYNWSVTYLGTCFISLACAPAAIIPR", {130.0499, 229.1183, 357.1769, 520.2402, 648.2988, 808.3294, 968.3601, 1065.4128, 1180.4398, 1343.5031, 1457.5460, 1643.6253, 1730.6574, 1829.7258, 1930.7735, 2093.8368, 2206.9209, 2263.9423, 2364.9900, 2525.0206, 2672.0891, 2785.1731, 2872.2052, 2985.2892, 3056.3263, 3216.3570, 3287.3941, 3384.4469, 3455.4840, 3526.5211, 3639.6051, 3752.6892, 3849.7420, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 272.1717, 385.2558, 498.3398, 569.3770, 640.4141, 737.4668, 808.5039, 968.5346, 1039.5717, 1152.6558, 1239.6878, 1352.7719, 1499.8403, 1659.8709, 1760.9186, 1817.9401, 1931.0241, 2094.0875, 2195.1351, 2294.2036, 2381.2356, 2567.3149, 2681.3578, 2844.4212, 2959.4481, 3056.5009, 3216.5315, 3376.5622, 3504.6207, 3667.6841, 3795.7426, 3894.8111, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QCNDAECTLIHEIGYDRPYAMPFYPTSIVQPQSK", {129.0659, 289.0965, 403.1394, 518.1664, 589.2035, 718.2461, 878.2767, 979.3244, 1092.4085, 1205.4925, 1342.5514, 1471.5940, 1584.6781, 1641.6996, 1804.7629, 1919.7898, 2075.8910, 2172.9437, 2336.0070, 2407.0442, 2538.0846, 2635.1374, 2782.2058, 2945.2691, 3042.3219, 3143.3696, 3230.4016, 3343.4857, 3442.5541, 3570.6127, 3667.6654, 3795.7240, 3882.7560, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 234.1448, 362.2034, 459.2562, 587.3148, 686.3832, 799.4672, 886.4993, 987.5469, 1084.5997, 1247.6630, 1394.7314, 1491.7842, 1622.8247, 1693.8618, 1856.9251, 1953.9779, 2110.0790, 2225.1060, 2388.1693, 2445.1907, 2558.2748, 2687.3174, 2824.3763, 2937.4604, 3050.5444, 3151.5921, 3311.6228, 3440.6654, 3511.7025, 3626.7294, 3740.7723, 3900.8030, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EELWLWQQEALLEDEASISSVSAKPEAFYEAPWR", {130.0499, 259.0925, 372.1765, 558.2558, 671.3399, 857.4192, 985.4778, 1113.5364, 1242.5790, 1313.6161, 1426.7001, 1539.7842, 1668.8268, 1783.8537, 1912.8963, 1983.9334, 2070.9655, 2184.0495, 2271.0816, 2358.1136, 2457.1820, 2544.2140, 2615.2512, 2743.3461, 2840.3989, 2969.4415, 3040.4786, 3187.5470, 3350.6103, 3479.6529, 3550.6900, 3647.7428, 3833.8221, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 361.1983, 458.2510, 529.2881, 658.3307, 821.3941, 968.4625, 1039.4996, 1168.5422, 1265.5949, 1393.6899, 1464.7270, 1551.7591, 1650.8275, 1737.8595, 1824.8915, 1937.9756, 2025.0076, 2096.0447, 2225.0873, 2340.1143, 2469.1569, 2582.2409, 2695.3250, 2766.3621, 2895.4047, 3023.4633, 3151.5219, 3337.6012, 3450.6852, 3636.7645, 3749.8486, 3878.8912, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NWLVIDNNYIQPVFIESEHHLADVLVLNQDSILR", {115.0502, 301.1295, 414.2136, 513.2820, 626.3661, 741.3930, 855.4359, 969.4789, 1132.5422, 1245.6262, 1373.6848, 1470.7376, 1569.8060, 1716.8744, 1829.9585, 1959.0011, 2046.0331, 2175.0757, 2312.1346, 2449.1935, 2562.2776, 2633.3147, 2748.3416, 2847.4101, 2960.4941, 3059.5625, 3172.6466, 3286.6895, 3414.7481, 3529.7750, 3616.8071, 3729.8911, 3842.9752, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 401.2871, 488.3191, 603.3461, 731.4046, 845.4476, 958.5316, 1057.6000, 1170.6841, 1269.7525, 1384.7795, 1455.8166, 1568.9006, 1705.9595, 1843.0185, 1972.0611, 2059.0931, 2188.1357, 2301.2197, 2448.2882, 2547.3566, 2644.4093, 2772.4679, 2885.5520, 3048.6153, 3162.6582, 3276.7012, 3391.7281, 3504.8122, 3603.8806, 3716.9646, 3903.0440, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YTIHQIERPTRPSDQGCDLLGPHGEEHVHVYDTR", {164.0706, 265.1183, 378.2023, 515.2613, 643.3198, 756.4039, 885.4465, 1041.5476, 1138.6004, 1239.6480, 1395.7492, 1492.8019, 1579.8340, 1694.8609, 1822.9195, 1879.9409, 2039.9716, 2154.9985, 2268.0826, 2381.1667, 2438.1881, 2535.2409, 2672.2998, 2729.3213, 2858.3639, 2987.4064, 3124.4654, 3223.5338, 3360.5927, 3459.6611, 3622.7244, 3737.7514, 3838.7990, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 276.1666, 391.1936, 554.2569, 653.3253, 790.3842, 889.4526, 1026.5116, 1155.5541, 1284.5967, 1341.6182, 1478.6771, 1575.7299, 1632.7513, 1745.8354, 1858.9195, 1973.9464, 2133.9771, 2190.9985, 2319.0571, 2434.0840, 2521.1161, 2618.1688, 2774.2700, 2875.3176, 2972.3704, 3128.4715, 3257.5141, 3370.5982, 3498.6567, 3635.7157, 3748.7997, 3849.8474, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DVFTHVGFDVSAEPSACCIPLECVVTYYGYFLCR", {116.0342, 215.1026, 362.1710, 463.2187, 600.2776, 699.3461, 756.3675, 903.4359, 1018.4629, 1117.5313, 1204.5633, 1275.6004, 1404.6430, 1501.6958, 1588.7278, 1659.7649, 1819.7956, 1979.8262, 2092.9103, 2189.9631, 2303.0471, 2432.0897, 2592.1204, 2691.1888, 2790.2572, 2891.3049, 3054.3682, 3217.4315, 3274.4530, 3437.5163, 3584.5847, 3697.6688, 3857.6994, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 335.1496, 448.2337, 595.3021, 758.3654, 815.3869, 978.4502, 1141.5135, 1242.5612, 1341.6296, 1440.6980, 1600.7287, 1729.7713, 1842.8553, 1939.9081, 2052.9922, 2213.0228, 2373.0535, 2444.0906, 2531.1226, 2628.1754, 2757.2180, 2828.2551, 2915.2871, 3014.3555, 3129.3825, 3276.4509, 3333.4723, 3432.5408, 3569.5997, 3670.6473, 3817.7158, 3916.7842, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NFQTGTPCQNWYGTANVAACYYYGYCTVGDSVYR", {115.0502, 262.1186, 390.1772, 491.2249, 548.2463, 649.2940, 746.3468, 906.3774, 1034.4360, 1148.4789, 1334.5582, 1497.6216, 1554.6430, 1655.6907, 1726.7278, 1840.7708, 1939.8392, 2010.8763, 2081.9134, 2241.9440, 2405.0074, 2568.0707, 2731.1340, 2788.1555, 2951.2188, 3111.2495, 3212.2972, 3311.3656, 3368.3870, 3483.4140, 3570.4460, 3669.5144, 3832.5777, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 437.2507, 524.2827, 639.3097, 696.3311, 795.3995, 896.4472, 1056.4779, 1219.5412, 1276.5627, 1439.6260, 1602.6893, 1765.7526, 1925.7833, 1996.8204, 2067.8575, 2166.9259, 2280.9689, 2352.0060, 2453.0537, 2510.0751, 2673.1385, 2859.2178, 2973.2607, 3101.3193, 3261.3499, 3358.4027, 3459.4504, 3516.4718, 3617.5195, 3745.5781, 3892.6465, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VQSNYATIHFICEPSDQICTINVPVLDESVQQWK", {100.0757, 228.1343, 315.1663, 429.2092, 592.2726, 663.3097, 764.3573, 877.4414, 1014.5003, 1161.5687, 1274.6528, 1434.6834, 1563.7260, 1660.7788, 1747.8108, 1862.8378, 1990.8964, 2103.9804, 2264.0111, 2365.0587, 2478.1428, 2592.1857, 2691.2541, 2788.3069, 2887.3753, 3000.4594, 3115.4863, 3244.5289, 3331.5610, 3430.6294, 3558.6879, 3686.7465, 3872.8258, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 333.1921, 461.2507, 589.3093, 688.3777, 775.4097, 904.4523, 1019.4793, 1132.5633, 1231.6317, 1328.6845, 1427.7529, 1541.7958, 1654.8799, 1755.9276, 1915.9582, 2029.0423, 2157.1009, 2272.1278, 2359.1598, 2456.2126, 2585.2552, 2745.2858, 2858.3699, 3005.4383, 3142.4972, 3255.5813, 3356.6290, 3427.6661, 3590.7294, 3704.7723, 3791.8044, 3919.8630, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EDISNTDTMCNCTCSDNGQELLCTCECVNDSSLK", {130.0499, 245.0768, 358.1609, 445.1929, 559.2358, 660.2835, 775.3105, 876.3581, 1007.3986, 1167.4293, 1281.4722, 1441.5028, 1542.5505, 1702.5812, 1789.6132, 1904.6401, 2018.6831, 2075.7045, 2203.7631, 2332.8057, 2445.8898, 2558.9738, 2719.0045, 2820.0522, 2980.0828, 3109.1254, 3269.1560, 3368.2245, 3482.2674, 3597.2943, 3684.3264, 3771.3584, 3884.4425, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 347.2289, 434.2609, 549.2879, 663.3308, 762.3992, 922.4299, 1051.4725, 1211.5031, 1312.5508, 1472.5814, 1585.6655, 1698.7496, 1827.7921, 1955.8507, 2012.8722, 2126.9151, 2241.9421, 2328.9741, 2489.0047, 2590.0524, 2750.0831, 2864.1260, 3024.1566, 3155.1971, 3256.2448, 3371.2717, 3472.3194, 3586.3624, 3673.3944, 3786.4784, 3901.5054, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DFLVTLAVSALFISIFENTDLIISVFNYYHHIHR", {116.0342, 263.1026, 376.1867, 475.2551, 576.3028, 689.3869, 760.4240, 859.4924, 946.5244, 1017.5615, 1130.6456, 1277.7140, 1390.7981, 1477.8301, 1590.9142, 1737.9826, 1867.0252, 1981.0681, 2082.1158, 2197.1427, 2310.2268, 2423.3108, 2536.3949, 2623.4269, 2722.4953, 2869.5638, 2983.6067, 3146.6700, 3309.7333, 3446.7923, 3583.8512, 3696.9352, 3833.9941, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 312.1779, 425.2619, 562.3208, 699.3798, 862.4431, 1025.5064, 1139.5493, 1286.6178, 1385.6862, 1472.7182, 1585.8023, 1698.8863, 1811.9704, 1926.9973, 2028.0450, 2142.0879, 2271.1305, 2418.1989, 2531.2830, 2618.3150, 2731.3991, 2878.4675, 2991.5516, 3062.5887, 3149.6207, 3248.6891, 3319.7262, 3432.8103, 3533.8580, 3632.9264, 3746.0105, 3893.0789, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PAVAFLETDIGLHHTHTLCMESFGFYNHIFLLNR", {98.0600, 169.0972, 268.1656, 339.2027, 486.2711, 599.3552, 728.3978, 829.4454, 944.4724, 1057.5564, 1114.5779, 1227.6620, 1364.7209, 1501.7798, 1602.8275, 1739.8864, 1840.9341, 1954.0181, 2114.0488, 2245.0893, 2374.1318, 2461.1639, 2608.2323, 2665.2538, 2812.3222, 2975.3855, 3089.4284, 3226.4873, 3339.5714, 3486.6398, 3599.7239, 3712.8079, 3826.8509, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 289.1619, 402.2459, 515.3300, 662.3984, 775.4825, 912.5414, 1026.5843, 1189.6477, 1336.7161, 1393.7375, 1540.8059, 1627.8380, 1756.8806, 1887.9211, 2047.9517, 2161.0358, 2262.0834, 2399.1424, 2500.1900, 2637.2489, 2774.3079, 2887.3919, 2944.4134, 3057.4974, 3172.5244, 3273.5721, 3402.6147, 3515.6987, 3662.7671, 3733.8043, 3832.8727, 3903.9098, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ENIGYFQDSDDDDFDFFGDESDSFDLDFDSDESR", {130.0499, 244.0928, 357.1769, 414.1983, 577.2617, 724.3301, 852.3886, 967.4156, 1054.4476, 1169.4746, 1284.5015, 1399.5284, 1514.5554, 1661.6238, 1776.6507, 1923.7192, 2070.7876, 2127.8090, 2242.8360, 2371.8786, 2458.9106, 2573.9375, 2660.9696, 2808.0380, 2923.0649, 3036.1490, 3151.1759, 3298.2444, 3413.2713, 3500.3033, 3615.3303, 3744.3729, 3831.4049, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 262.1510, 391.1936, 506.2205, 593.2525, 708.2795, 855.3479, 970.3748, 1083.4589, 1198.4859, 1345.5543, 1432.5863, 1547.6132, 1634.6453, 1763.6879, 1878.7148, 1935.7363, 2082.8047, 2229.8731, 2344.9000, 2491.9685, 2606.9954, 2722.0223, 2837.0493, 2952.0762, 3039.1083, 3154.1352, 3282.1938, 3429.2622, 3592.3255, 3649.3470, 3762.4310, 3876.4740, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ATQLCFLGEMENWDIDQMPSDQHNSAVISWINQK", {72.0444, 173.0921, 301.1506, 414.2347, 574.2654, 721.3338, 834.4178, 891.4393, 1020.4819, 1151.5224, 1280.5650, 1394.6079, 1580.6872, 1695.7142, 1808.7982, 1923.8252, 2051.8837, 2182.9242, 2279.9770, 2367.0090, 2482.0360, 2610.0945, 2747.1534, 2861.1964, 2948.2284, 3019.2655, 3118.3339, 3231.4180, 3318.4500, 3504.5293, 3617.6134, 3731.6563, 3859.7149, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 275.1714, 389.2143, 502.2984, 688.3777, 775.4097, 888.4938, 987.5622, 1058.5993, 1145.6313, 1259.6743, 1396.7332, 1524.7918, 1639.8187, 1726.8507, 1823.9035, 1954.9440, 2083.0025, 2198.0295, 2311.1136, 2426.1405, 2612.2198, 2726.2627, 2855.3053, 2986.3458, 3115.3884, 3172.4099, 3285.4939, 3432.5624, 3592.5930, 3705.6771, 3833.7356, 3934.7833, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QCLNAACHGDILLNWLAQCVINALFWDEQELSGR", {129.0659, 289.0965, 402.1806, 516.2235, 587.2606, 658.2977, 818.3284, 955.3873, 1012.4087, 1127.4357, 1240.5198, 1353.6038, 1466.6879, 1580.7308, 1766.8101, 1879.8942, 1950.9313, 2078.9899, 2239.0205, 2338.0889, 2451.1730, 2565.2159, 2636.2530, 2749.3371, 2896.4055, 3082.4848, 3197.5118, 3326.5544, 3454.6129, 3583.6555, 3696.7396, 3783.7716, 3840.7931, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 232.1404, 319.1724, 432.2565, 561.2991, 689.3577, 818.4003, 933.4272, 1119.5065, 1266.5749, 1379.6590, 1450.6961, 1564.7390, 1677.8231, 1776.8915, 1936.9222, 2064.9808, 2136.0179, 2249.1019, 2435.1812, 2549.2242, 2662.3082, 2775.3923, 2888.4764, 3003.5033, 3060.5248, 3197.5837, 3357.6143, 3428.6514, 3499.6886, 3613.7315, 3726.8155, 3886.8462, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"IWVLPEGCLLVHNLNALPDLDYLYSYYQSVIPLR", {114.0913, 300.1707, 399.2391, 512.3231, 609.3759, 738.4185, 795.4400, 955.4706, 1068.5547, 1181.6387, 1280.7071, 1417.7661, 1531.8090, 1644.8930, 1758.9360, 1829.9731, 1943.0572, 2040.1099, 2155.1369, 2268.2209, 2383.2479, 2546.3112, 2659.3953, 2822.4586, 2909.4906, 3072.5539, 3235.6173, 3363.6758, 3450.7079, 3549.7763, 3662.8604, 3759.9131, 3872.9972, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 385.2558, 498.3398, 597.4083, 684.4403, 812.4989, 975.5622, 1138.6255, 1225.6575, 1388.7209, 1501.8049, 1664.8683, 1779.8952, 1892.9793, 2008.0062, 2105.0590, 2218.1430, 2289.1802, 2403.2231, 2516.3072, 2630.3501, 2767.4090, 2866.4774, 2979.5615, 3092.6455, 3252.6762, 3309.6976, 3438.7402, 3535.7930, 3648.8771, 3747.9455, 3934.0248, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"CDDICCPILCCGLWCGFLAILFGSLYAIMGPETR", {161.0379, 276.0649, 391.0918, 504.1759, 664.2065, 824.2372, 921.2899, 1034.3740, 1147.4581, 1307.4887, 1467.5194, 1524.5408, 1637.6249, 1823.7042, 1983.7349, 2040.7563, 2187.8247, 2300.9088, 2371.9459, 2485.0300, 2598.1140, 2745.1824, 2802.2039, 2889.2359, 3002.3200, 3165.3833, 3236.4204, 3349.5045, 3480.5450, 3537.5665, 3634.6192, 3763.6618, 3864.7095, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 276.1666, 405.2092, 502.2620, 559.2835, 690.3239, 803.4080, 874.4451, 1037.5084, 1150.5925, 1237.6245, 1294.6460, 1441.7144, 1554.7985, 1667.8825, 1738.9197, 1852.0037, 1999.0721, 2056.0936, 2216.1242, 2402.2036, 2515.2876, 2572.3091, 2732.3397, 2892.3704, 3005.4544, 3118.5385, 3215.5913, 3375.6219, 3535.6526, 3648.7366, 3763.7636, 3878.7905, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NGAQEELQAIEEPEFCQQLVDHIIEESNDITHER", {115.0502, 172.0717, 243.1088, 371.1674, 500.2100, 629.2525, 742.3366, 870.3952, 941.4323, 1054.5164, 1183.5590, 1312.6016, 1409.6543, 1538.6969, 1685.7653, 1845.7960, 1973.8545, 2101.9131, 2214.9972, 2314.0656, 2429.0925, 2566.1515, 2679.2355, 2792.3196, 2921.3622, 3050.4048, 3137.4368, 3251.4797, 3366.5067, 3479.5907, 3580.6384, 3717.6973, 3846.7399, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 441.2205, 542.2681, 655.3522, 770.3791, 884.4221, 971.4541, 1100.4967, 1229.5393, 1342.6233, 1455.7074, 1592.7663, 1707.7933, 1806.8617, 1919.9457, 2048.0043, 2176.0629, 2336.0935, 2483.1620, 2612.2046, 2709.2573, 2838.2999, 2967.3425, 3080.4266, 3151.4637, 3279.5223, 3392.6063, 3521.6489, 3650.6915, 3778.7501, 3849.7872, 3906.8087, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"GENLWLHTWWEMTVLNGFWQHAIEHGVTLAISQK", {58.0287, 187.0713, 301.1143, 414.1983, 600.2776, 713.3617, 850.4206, 951.4683, 1137.5476, 1323.6269, 1452.6695, 1583.7100, 1684.7577, 1783.8261, 1896.9102, 2010.9531, 2067.9745, 2215.0430, 2401.1223, 2529.1808, 2666.2398, 2737.2769, 2850.3609, 2979.4035, 3116.4624, 3173.4839, 3272.5523, 3373.6000, 3486.6841, 3557.7212, 3670.8052, 3757.8373, 3885.8958, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 275.1714, 362.2034, 475.2875, 546.3246, 659.4087, 760.4563, 859.5247, 916.5462, 1053.6051, 1182.6477, 1295.7318, 1366.7689, 1503.8278, 1631.8864, 1817.9657, 1965.0341, 2022.0556, 2136.0985, 2249.1826, 2348.2510, 2449.2987, 2580.3391, 2709.3817, 2895.4610, 3081.5404, 3182.5880, 3319.6469, 3432.7310, 3618.8103, 3731.8944, 3845.9373, 3974.9799, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QLMGLVASFISYTLFFTLGCCPLYNLSCVQELLR", {129.0659, 242.1499, 373.1904, 430.2119, 543.2959, 642.3643, 713.4015, 800.4335, 947.5019, 1060.5860, 1147.6180, 1310.6813, 1411.7290, 1524.8131, 1671.8815, 1818.9499, 1919.9976, 2033.0816, 2090.1031, 2250.1337, 2410.1644, 2507.2172, 2620.3012, 2783.3646, 2897.4075, 3010.4915, 3097.5236, 3257.5542, 3356.6226, 3484.6812, 3613.7238, 3726.8079, 3839.8919, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 401.2871, 530.3297, 658.3883, 757.4567, 917.4873, 1004.5193, 1117.6034, 1231.6463, 1394.7097, 1507.7937, 1604.8465, 1764.8771, 1924.9078, 1981.9293, 2095.0133, 2196.0610, 2343.1294, 2490.1978, 2603.2819, 2704.3296, 2867.3929, 2954.4249, 3067.5090, 3214.5774, 3301.6094, 3372.6465, 3471.7150, 3584.7990, 3641.8205, 3772.8610, 3885.9450, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YTAQGSYSNNRPSNQMVYNNQTYYPSGDVQDEWR", {164.0706, 265.1183, 336.1554, 464.2140, 521.2354, 608.2675, 771.3308, 858.3628, 972.4058, 1086.4487, 1242.5498, 1339.6026, 1426.6346, 1540.6775, 1668.7361, 1799.7766, 1898.8450, 2061.9083, 2175.9512, 2289.9942, 2418.0527, 2519.1004, 2682.1638, 2845.2271, 2942.2798, 3029.3119, 3086.3333, 3201.3603, 3300.4287, 3428.4873, 3543.5142, 3672.5568, 3858.6361, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 361.1983, 490.2409, 605.2678, 733.3264, 832.3948, 947.4217, 1004.4432, 1091.4752, 1188.5280, 1351.5913, 1514.6546, 1615.7023, 1743.7609, 1857.8038, 1971.8468, 2134.9101, 2233.9785, 2365.0190, 2493.0776, 2607.1205, 2694.1525, 2791.2053, 2947.3064, 3061.3493, 3175.3923, 3262.4243, 3425.4876, 3512.5196, 3569.5411, 3697.5997, 3768.6368, 3869.6845, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"CCCCYDEQEEEEANVVEHSPEVSAVSPAPACPCR", {161.0379, 321.0686, 481.0992, 641.1299, 804.1932, 919.2201, 1048.2627, 1176.3213, 1305.3639, 1434.4065, 1563.4491, 1692.4917, 1763.5288, 1877.5717, 1976.6401, 2075.7086, 2204.7511, 2341.8101, 2428.8421, 2525.8949, 2654.9374, 2754.0059, 2841.0379, 2912.0750, 3011.1434, 3098.1754, 3195.2282, 3266.2653, 3363.3181, 3434.3552, 3594.3858, 3691.4386, 3851.4693, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 335.1496, 432.2024, 592.2330, 663.2701, 760.3229, 831.3600, 928.4128, 1015.4448, 1114.5132, 1185.5503, 1272.5824, 1371.6508, 1500.6934, 1597.7461, 1684.7782, 1821.8371, 1950.8797, 2049.9481, 2149.0165, 2263.0594, 2334.0965, 2463.1391, 2592.1817, 2721.2243, 2850.2669, 2978.3255, 3107.3681, 3222.3950, 3385.4583, 3545.4890, 3705.5196, 3865.5503, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"GDHSMQGQDVGIAEGCYDCYEAFMADFCHLCYPK", {58.0287, 173.0557, 310.1146, 397.1466, 528.1871, 656.2457, 713.2671, 841.3257, 956.3527, 1055.4211, 1112.4425, 1225.5266, 1296.5637, 1425.6063, 1482.6278, 1642.6584, 1805.7218, 1920.7487, 2080.7794, 2243.8427, 2372.8853, 2443.9224, 2590.9908, 2722.0313, 2793.0684, 2908.0953, 3055.1638, 3215.1944, 3352.2533, 3465.3374, 3625.3680, 3788.4314, 3885.4841, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 244.1656, 407.2289, 567.2595, 680.3436, 817.4025, 977.4332, 1124.5016, 1239.5285, 1310.5656, 1441.6061, 1588.6745, 1659.7117, 1788.7542, 1951.8176, 2111.8482, 2226.8752, 2389.9385, 2549.9691, 2606.9906, 2736.0332, 2807.0703, 2920.1544, 2977.1758, 3076.2443, 3191.2712, 3319.3298, 3376.3512, 3504.4098, 3635.4503, 3722.4823, 3859.5412, 3974.5682, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LLLEQISHVLFFVVSIATNLAIYYLHYVVLQNCR", {114.0913, 227.1754, 340.2595, 469.3021, 597.3606, 710.4447, 797.4767, 934.5356, 1033.6041, 1146.6881, 1293.7565, 1440.8249, 1539.8934, 1638.9618, 1725.9938, 1839.0779, 1910.1150, 2011.1627, 2125.2056, 2238.2897, 2309.3268, 2422.4108, 2585.4742, 2748.5375, 2861.6216, 2998.6805, 3161.7438, 3260.8122, 3359.8806, 3472.9647, 3601.0233, 3715.0662, 3875.0968, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 335.1496, 449.1925, 577.2511, 690.3352, 789.4036, 888.4720, 1051.5353, 1188.5942, 1301.6783, 1464.7416, 1627.8050, 1740.8890, 1811.9261, 1925.0102, 2039.0531, 2140.1008, 2211.1379, 2324.2220, 2411.2540, 2510.3224, 2609.3908, 2756.4593, 2903.5277, 3016.6117, 3115.6801, 3252.7391, 3339.7711, 3452.8552, 3580.9137, 3709.9563, 3823.0404, 3936.1245, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"CICLLFGVVHLGLISLFWISIQPLSAEESQHCMR", {161.0379, 274.1220, 434.1526, 547.2367, 660.3208, 807.3892, 864.4106, 963.4791, 1062.5475, 1199.6064, 1312.6904, 1369.7119, 1482.7960, 1595.8800, 1682.9121, 1795.9961, 1943.0645, 2129.1439, 2242.2279, 2329.2600, 2442.3440, 2570.4026, 2667.4554, 2780.5394, 2867.5714, 2938.6086, 3067.6512, 3196.6937, 3283.7258, 3411.7844, 3548.8433, 3708.8739, 3839.9144, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 306.1594, 466.1901, 603.2490, 731.3076, 818.3396, 947.3822, 1076.4248, 1147.4619, 1234.4939, 1347.5780, 1444.6308, 1572.6893, 1685.7734, 1772.8054, 1885.8895, 2071.9688, 2219.0372, 2332.1213, 2419.1533, 2532.2374, 2645.3214, 2702.3429, 2815.4270, 2952.4859, 3051.5543, 3150.6227, 3207.6442, 3354.7126, 3467.7967, 3580.8807, 3740.9114, 3853.9954, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ETYYVFFLGLFDFFVAHSDDSETNYLESANSYAR", {130.0499, 231.0975, 394.1609, 557.2242, 656.2926, 803.3610, 950.4294, 1063.5135, 1120.5350, 1233.6190, 1380.6875, 1495.7144, 1642.7828, 1789.8512, 1888.9196, 1959.9568, 2097.0157, 2184.0477, 2299.0746, 2414.1016, 2501.1336, 2630.1762, 2731.2239, 2845.2668, 3008.3301, 3121.4142, 3250.4568, 3337.4888, 3408.5259, 3522.5689, 3609.6009, 3772.6642, 3843.7013, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 246.1561, 409.2194, 496.2514, 610.2944, 681.3315, 768.3635, 897.4061, 1010.4901, 1173.5535, 1287.5964, 1388.6441, 1517.6867, 1604.7187, 1719.7456, 1834.7726, 1921.8046, 2058.8635, 2129.9006, 2228.9691, 2376.0375, 2523.1059, 2638.1328, 2785.2012, 2898.2853, 2955.3068, 3068.3908, 3215.4593, 3362.5277, 3461.5961, 3624.6594, 3787.7227, 3888.7704, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"CTETESVWLCALTYSPDSECSSDDASTCSYCVQR", {161.0379, 262.0856, 391.1282, 492.1759, 621.2185, 708.2505, 807.3189, 993.3982, 1106.4823, 1266.5129, 1337.5500, 1450.6341, 1551.6818, 1714.7451, 1801.7771, 1898.8299, 2013.8569, 2100.8889, 2229.9315, 2389.9621, 2476.9942, 2564.0262, 2679.0531, 2794.0801, 2865.1172, 2952.1492, 3053.1969, 3213.2275, 3300.2596, 3463.3229, 3623.3535, 3722.4220, 3850.4805, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 402.2459, 562.2766, 725.3399, 812.3719, 972.4026, 1073.4503, 1160.4823, 1231.5194, 1346.5464, 1461.5733, 1548.6053, 1635.6374, 1795.6680, 1924.7106, 2011.7426, 2126.7696, 2223.8223, 2310.8544, 2473.9177, 2574.9654, 2688.0494, 2759.0866, 2919.1172, 3032.2013, 3218.2806, 3317.3490, 3404.3810, 3533.4236, 3634.4713, 3763.5139, 3864.5616, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SDATNCGNSNCRPCYAPNEDCYDSEEFVSESCGR", {88.0393, 203.0662, 274.1034, 375.1510, 489.1940, 649.2246, 706.2461, 820.2890, 907.3210, 1021.3640, 1181.3946, 1337.4957, 1434.5485, 1594.5791, 1757.6425, 1828.6796, 1925.7323, 2039.7753, 2168.8179, 2283.8448, 2443.8755, 2606.9388, 2721.9657, 2808.9978, 2938.0403, 3067.0829, 3214.1514, 3313.2198, 3400.2518, 3529.2944, 3616.3264, 3776.3571, 3833.3785, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 232.1404, 392.1711, 479.2031, 608.2457, 695.2777, 794.3461, 941.4145, 1070.4571, 1199.4997, 1286.5318, 1401.5587, 1564.6220, 1724.6527, 1839.6796, 1968.7222, 2082.7651, 2179.8179, 2250.8550, 2413.9183, 2573.9490, 2671.0018, 2827.1029, 2987.1335, 3101.1764, 3188.2085, 3302.2514, 3359.2729, 3519.3035, 3633.3464, 3734.3941, 3805.4312, 3920.4582, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LEIDFVCNDDSQADCVVCDLLNEQSNLFNCGHSR", {114.0913, 243.1339, 356.2180, 471.2449, 618.3134, 717.3818, 877.4124, 991.4553, 1106.4823, 1221.5092, 1308.5413, 1436.5998, 1507.6370, 1622.6639, 1782.6945, 1881.7630, 1980.8314, 2140.8620, 2255.8890, 2368.9730, 2482.0571, 2596.1000, 2725.1426, 2853.2012, 2940.2332, 3054.2761, 3167.3602, 3314.4286, 3428.4715, 3588.5022, 3645.5237, 3782.5826, 3869.6146, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 262.1510, 399.2099, 456.2314, 616.2620, 730.3049, 877.3733, 990.4574, 1104.5003, 1191.5324, 1319.5909, 1448.6335, 1562.6765, 1675.7605, 1788.8446, 1903.8715, 2063.9022, 2162.9706, 2262.0390, 2422.0697, 2537.0966, 2608.1337, 2736.1923, 2823.2243, 2938.2513, 3053.2782, 3167.3211, 3327.3518, 3426.4202, 3573.4886, 3688.5156, 3801.5996, 3930.6422, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EAVQELHWFMFYIIFSDIIGAMTAFFLFVLIPPK", {130.0499, 201.0870, 300.1554, 428.2140, 557.2566, 670.3406, 807.3995, 993.4789, 1140.5473, 1271.5878, 1418.6562, 1581.7195, 1694.8036, 1807.8876, 1954.9560, 2041.9881, 2157.0150, 2270.0991, 2383.1831, 2440.2046, 2511.2417, 2642.2822, 2743.3299, 2814.3670, 2961.4354, 3108.5038, 3221.5879, 3368.6563, 3467.7247, 3580.8088, 3693.8928, 3790.9456, 3887.9984, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 244.1656, 341.2183, 454.3024, 567.3865, 666.4549, 813.5233, 926.6074, 1073.6758, 1220.7442, 1291.7813, 1392.8290, 1523.8695, 1594.9066, 1651.9280, 1765.0121, 1878.0962, 1993.1231, 2080.1551, 2227.2235, 2340.3076, 2453.3917, 2616.4550, 2763.5234, 2894.5639, 3041.6323, 3227.7116, 3364.7705, 3477.8546, 3606.8972, 3734.9558, 3834.0242, 3905.0613, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MYTPIQMLLLWYGFIHTCHVVLLSLFPLSSFIAK", {132.0478, 295.1111, 396.1588, 493.2115, 606.2956, 734.3542, 865.3947, 978.4787, 1091.5628, 1204.6469, 1390.7262, 1553.7895, 1610.8110, 1757.8794, 1870.9634, 2008.0223, 2109.0700, 2269.1007, 2406.1596, 2505.2280, 2604.2964, 2717.3805, 2830.4645, 2917.4966, 3030.5806, 3177.6490, 3274.7018, 3387.7859, 3474.8179, 3561.8499, 3708.9183, 3822.0024, 3893.0395, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 218.1499, 331.2340, 478.3024, 565.3344, 652.3665, 765.4505, 862.5033, 1009.5717, 1122.6558, 1209.6878, 1322.7719, 1435.8559, 1534.9243, 1633.9927, 1771.0517, 1931.0823, 2032.1300, 2169.1889, 2282.2730, 2429.3414, 2486.3628, 2649.4262, 2835.5055, 2948.5895, 3061.6736, 3174.7577, 3305.7982, 3433.8567, 3546.9408, 3643.9936, 3745.0412, 3908.1046, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DWAQQDTTGWILYVLNGIFFVVATMAFVIQWQSR", {116.0342, 302.1135, 373.1506, 501.2092, 629.2678, 744.2947, 845.3424, 946.3901, 1003.4116, 1189.4909, 1302.5749, 1415.6590, 1578.7223, 1677.7907, 1790.8748, 1904.9177, 1961.9392, 2075.0233, 2222.0917, 2369.1601, 2468.2285, 2567.2969, 2638.3340, 2739.3817, 2870.4222, 2941.4593, 3088.5277, 3187.5961, 3300.6802, 3428.7388, 3614.8181, 3742.8767, 3829.9087, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 262.1510, 390.2096, 576.2889, 704.3474, 817.4315, 916.4999, 1063.5683, 1134.6055, 1265.6459, 1366.6936, 1437.7307, 1536.7991, 1635.8676, 1782.9360, 1930.0044, 2043.0885, 2100.1099, 2214.1528, 2327.2369, 2426.3053, 2589.3686, 2702.4527, 2815.5368, 3001.6161, 3058.6376, 3159.6852, 3260.7329, 3375.7599, 3503.8184, 3631.8770, 3702.9141, 3888.9934, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DLHMVAGQEYGMLIFDTHPMEADFPLFHPRPYLK", {116.0342, 229.1183, 366.1772, 497.2177, 596.2861, 667.3232, 724.3447, 852.4032, 981.4458, 1144.5092, 1201.5306, 1332.5711, 1445.6552, 1558.7392, 1705.8077, 1820.8346, 1921.8823, 2058.9412, 2155.9940, 2287.0344, 2416.0770, 2487.1142, 2602.1411, 2749.2095, 2846.2623, 2959.3463, 3106.4147, 3243.4737, 3340.5264, 3496.6275, 3593.6803, 3756.7436, 3869.8277, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 423.2602, 520.3130, 676.4141, 773.4668, 910.5257, 1057.5942, 1170.6782, 1267.7310, 1414.7994, 1529.8263, 1600.8635, 1729.9061, 1860.9465, 1957.9993, 2095.0582, 2196.1059, 2311.1328, 2458.2012, 2571.2853, 2684.3694, 2815.4099, 2872.4313, 3035.4947, 3164.5372, 3292.5958, 3349.6173, 3420.6544, 3519.7228, 3650.7633, 3787.8222, 3900.9063, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YSHLGFEVPLLAWTVYVLFLVTFLMYFAFGYVAR", {164.0706, 251.1026, 388.1615, 501.2456, 558.2671, 705.3355, 834.3781, 933.4465, 1030.4993, 1143.5833, 1256.6674, 1327.7045, 1513.7838, 1614.8315, 1713.8999, 1876.9632, 1976.0316, 2089.1157, 2236.1841, 2349.2682, 2448.3366, 2549.3843, 2696.4527, 2809.5368, 2940.5772, 3103.6406, 3250.7090, 3321.7461, 3468.8145, 3525.8360, 3688.8993, 3787.9677, 3859.0048, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 246.1561, 345.2245, 508.2878, 565.3093, 712.3777, 783.4148, 930.4832, 1093.5465, 1224.5870, 1337.6711, 1484.7395, 1585.7872, 1684.8556, 1797.9397, 1945.0081, 2058.0921, 2157.1606, 2320.2239, 2419.2923, 2520.3400, 2706.4193, 2777.4564, 2890.5405, 3003.6245, 3100.6773, 3199.7457, 3328.7883, 3475.8567, 3532.8782, 3645.9622, 3783.0212, 3870.0532, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YLGIVALFPYTPHIDCCMVGCDTQIIYDPFSPNK", {164.0706, 277.1547, 334.1761, 447.2602, 546.3286, 617.3657, 730.4498, 877.5182, 974.5710, 1137.6343, 1238.6820, 1335.7347, 1472.7936, 1585.8777, 1700.9047, 1860.9353, 2020.9660, 2152.0064, 2251.0749, 2308.0963, 2468.1270, 2583.1539, 2684.2016, 2812.2602, 2925.3442, 3038.4283, 3201.4916, 3316.5186, 3413.5713, 3560.6397, 3647.6718, 3744.7245, 3858.7675, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 261.1557, 358.2085, 445.2405, 592.3089, 689.3617, 804.3886, 967.4520, 1080.5360, 1193.6201, 1321.6787, 1422.7264, 1537.7533, 1697.7839, 1754.8054, 1853.8738, 1984.9143, 2144.9450, 2304.9756, 2420.0026, 2533.0866, 2670.1455, 2767.1983, 2868.2460, 3031.3093, 3128.3621, 3275.4305, 3388.5145, 3459.5517, 3558.6201, 3671.7041, 3728.7256, 3841.8097, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"WYFPDASDSSMIGFLPIQCCVLFIFLTIATWLVK", {187.0866, 350.1499, 497.2183, 594.2711, 709.2980, 780.3352, 867.3672, 982.3941, 1069.4262, 1156.4582, 1287.4987, 1400.5827, 1457.6042, 1604.6726, 1717.7567, 1814.8094, 1927.8935, 2055.9521, 2215.9827, 2376.0134, 2475.0818, 2588.1659, 2735.2343, 2848.3183, 2995.3867, 3108.4708, 3209.5185, 3322.6026, 3393.6397, 3494.6873, 3680.7667, 3793.8507, 3892.9191, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 246.1812, 359.2653, 545.3446, 646.3923, 717.4294, 830.5135, 931.5611, 1044.6452, 1191.7136, 1304.7977, 1451.8661, 1564.9501, 1664.0186, 1824.0492, 1984.0799, 2112.1384, 2225.2225, 2322.2753, 2435.3593, 2582.4277, 2639.4492, 2752.5333, 2883.5738, 2970.6058, 3057.6378, 3172.6648, 3259.6968, 3330.7339, 3445.7608, 3542.8136, 3689.8820, 3852.9453, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LDVGIYDHVWMSTELHCVETPSGNWEIVLPMYTR", {114.0913, 229.1183, 328.1867, 385.2082, 498.2922, 661.3556, 776.3825, 913.4414, 1012.5098, 1198.5891, 1329.6296, 1416.6616, 1517.7093, 1646.7519, 1759.8360, 1896.8949, 2056.9255, 2155.9940, 2285.0366, 2386.0842, 2483.1370, 2570.1690, 2627.1905, 2741.2334, 2927.3127, 3056.3553, 3169.4394, 3268.5078, 3381.5919, 3478.6446, 3609.6851, 3772.7484, 3873.7961, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 276.1666, 439.2300, 570.2704, 667.3232, 780.4073, 879.4757, 992.5597, 1121.6023, 1307.6817, 1421.7246, 1478.7460, 1565.7781, 1662.8308, 1763.8785, 1892.9211, 1991.9895, 2152.0202, 2289.0791, 2402.1631, 2531.2057, 2632.2534, 2719.2854, 2850.3259, 3036.4052, 3135.4737, 3272.5326, 3387.5595, 3550.6228, 3663.7069, 3720.7284, 3819.7968, 3934.8237, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ASNYDNVHFIQYTDWLPFAIDNSEYSFLTAFGEK", {72.0444, 159.0764, 273.1193, 436.1827, 551.2096, 665.2525, 764.3210, 901.3799, 1048.4483, 1161.5323, 1289.5909, 1452.6543, 1553.7019, 1668.7289, 1854.8082, 1967.8923, 2064.9450, 2212.0134, 2283.0505, 2396.1346, 2511.1616, 2625.2045, 2712.2365, 2841.2791, 3004.3424, 3091.3745, 3238.4429, 3351.5269, 3452.5746, 3523.6117, 3670.6801, 3727.7016, 3856.7442, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 276.1554, 333.1769, 480.2453, 551.2824, 652.3301, 765.4141, 912.4825, 999.5146, 1162.5779, 1291.6205, 1378.6525, 1492.6955, 1607.7224, 1720.8065, 1791.8436, 1938.9120, 2035.9648, 2149.0488, 2335.1281, 2450.1551, 2551.2027, 2714.2661, 2842.3247, 2955.4087, 3102.4771, 3239.5360, 3338.6045, 3452.6474, 3567.6743, 3730.7377, 3844.7806, 3931.8126, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DFEDQNTLLPFYEDVELSQNIYGSSQFTQTLEHK", {116.0342, 263.1026, 392.1452, 507.1722, 635.2307, 749.2737, 850.3214, 963.4054, 1076.4895, 1173.5422, 1320.6107, 1483.6740, 1612.7166, 1727.7435, 1826.8119, 1955.8545, 2068.9386, 2155.9706, 2284.0292, 2398.0721, 2511.1562, 2674.2195, 2731.2410, 2818.2730, 2905.3050, 3033.3636, 3180.4320, 3281.4797, 3409.5383, 3510.5860, 3623.6700, 3752.7126, 3889.7715, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 284.1717, 413.2143, 526.2984, 627.3461, 755.4046, 856.4523, 1003.5207, 1131.5793, 1218.6113, 1305.6434, 1362.6648, 1525.7281, 1638.8122, 1752.8551, 1880.9137, 1967.9457, 2081.0298, 2210.0724, 2309.1408, 2424.1678, 2553.2104, 2716.2737, 2863.3421, 2960.3949, 3073.4789, 3186.5630, 3287.6107, 3401.6536, 3529.7122, 3644.7391, 3773.7817, 3920.8501, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NPSHTSFSMMWMFYGAALGVVMLLIVCFYLLEFR", {115.0502, 212.1030, 299.1350, 436.1939, 537.2416, 624.2736, 771.3420, 858.3741, 989.4145, 1120.4550, 1306.5343, 1437.5748, 1584.6432, 1747.7066, 1804.7280, 1875.7651, 1946.8023, 2059.8863, 2116.9078, 2215.9762, 2315.0446, 2446.0851, 2559.1692, 2672.2532, 2785.3373, 2884.4057, 3044.4364, 3191.5048, 3354.5681, 3467.6522, 3580.7362, 3709.7788, 3856.8472, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 451.2300, 564.3140, 677.3981, 840.4614, 987.5298, 1147.5605, 1246.6289, 1359.7130, 1472.7970, 1585.8811, 1716.9216, 1815.9900, 1915.0584, 1972.0799, 2085.1639, 2156.2010, 2227.2382, 2284.2596, 2447.3229, 2594.3914, 2725.4318, 2911.5112, 3042.5516, 3173.5921, 3260.6242, 3407.6926, 3494.7246, 3595.7723, 3732.8312, 3819.8632, 3916.9160, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"STDVQITCNYLECFILMLQIDTGDITVDTTNMFR", {88.0393, 189.0870, 304.1139, 403.1823, 531.2409, 644.3250, 745.3727, 905.4033, 1019.4462, 1182.5096, 1295.5936, 1424.6362, 1584.6669, 1731.7353, 1844.8193, 1957.9034, 2088.9439, 2202.0280, 2330.0865, 2443.1706, 2558.1975, 2659.2452, 2716.2667, 2831.2936, 2944.3777, 3045.4254, 3144.4938, 3259.5207, 3360.5684, 3461.6161, 3575.6590, 3706.6995, 3853.7679, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 453.2279, 567.2708, 668.3185, 769.3661, 884.3931, 983.4615, 1084.5092, 1197.5932, 1312.6202, 1369.6416, 1470.6893, 1585.7163, 1698.8003, 1826.8589, 1939.9430, 2070.9835, 2184.0675, 2297.1516, 2444.2200, 2604.2506, 2733.2932, 2846.3773, 3009.4406, 3123.4836, 3283.5142, 3384.5619, 3497.6459, 3625.7045, 3724.7729, 3839.7999, 3940.8476, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FQNTISVQNSIFENSYESGYLDACMTTYYTVPFK", {148.0757, 276.1343, 390.1772, 491.2249, 604.3089, 691.3410, 790.4094, 918.4680, 1032.5109, 1119.5429, 1232.6270, 1379.6954, 1508.7380, 1622.7809, 1709.8129, 1872.8763, 2001.9189, 2088.9509, 2145.9724, 2309.0357, 2422.1197, 2537.1467, 2608.1838, 2768.2145, 2899.2549, 3000.3026, 3101.3503, 3264.4136, 3427.4770, 3528.5246, 3627.5930, 3724.6458, 3871.7142, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 294.1812, 391.2340, 490.3024, 591.3501, 754.4134, 917.4767, 1018.5244, 1119.5721, 1250.6126, 1410.6432, 1481.6803, 1596.7073, 1709.7913, 1872.8547, 1929.8761, 2016.9082, 2145.9508, 2309.0141, 2396.0461, 2510.0890, 2639.1316, 2786.2000, 2899.2841, 2986.3161, 3100.3591, 3228.4176, 3327.4861, 3414.5181, 3527.6022, 3628.6498, 3742.6928, 3870.7513, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MHVFAWLSPNGYHLYYHMMDYCLYGALAGSLIVR", {132.0478, 269.1067, 368.1751, 515.2435, 586.2806, 772.3599, 885.4440, 972.4760, 1069.5288, 1183.5717, 1240.5932, 1403.6565, 1540.7154, 1653.7995, 1816.8628, 1979.9261, 2116.9850, 2248.0255, 2379.0660, 2494.0930, 2657.1563, 2817.1869, 2930.2710, 3093.3343, 3150.3558, 3221.3929, 3334.4770, 3405.5141, 3462.5355, 3549.5676, 3662.6516, 3775.7357, 3874.8041, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 274.1874, 387.2714, 500.3555, 587.3875, 644.4090, 715.4461, 828.5302, 899.5673, 956.5887, 1119.6521, 1232.7361, 1392.7668, 1555.8301, 1670.8571, 1801.8975, 1932.9380, 2069.9969, 2233.0603, 2396.1236, 2509.2077, 2646.2666, 2809.3299, 2866.3514, 2980.3943, 3077.4471, 3164.4791, 3277.5631, 3463.6425, 3534.6796, 3681.7480, 3780.8164, 3917.8753, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ISEFVEFLQMQCSLAMSFIPLCQLVGAPEWYLVK", {114.0913, 201.1234, 330.1660, 477.2344, 576.3028, 705.3454, 852.4138, 965.4979, 1093.5564, 1224.5969, 1352.6555, 1512.6861, 1599.7182, 1712.8022, 1783.8394, 1914.8798, 2001.9119, 2148.9803, 2262.0643, 2359.1171, 2472.2012, 2632.2318, 2760.2904, 2873.3745, 2972.4429, 3029.4643, 3100.5015, 3197.5542, 3326.5968, 3512.6761, 3675.7395, 3788.8235, 3887.8919, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 246.1812, 359.2653, 522.3286, 708.4079, 837.4505, 934.5033, 1005.5404, 1062.5619, 1161.6303, 1274.7143, 1402.7729, 1562.8036, 1675.8876, 1772.9404, 1886.0245, 2033.0929, 2120.1249, 2251.1654, 2322.2025, 2435.2866, 2522.3186, 2682.3492, 2810.4078, 2941.4483, 3069.5069, 3182.5909, 3329.6594, 3458.7019, 3557.7704, 3704.8388, 3833.8814, 3920.9134, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"GEYLDGSIMILTINWLISFVAIMVMLCIVIHEYR", {58.0287, 187.0713, 350.1347, 463.2187, 578.2457, 635.2671, 722.2992, 835.3832, 966.4237, 1079.5078, 1192.5918, 1293.6395, 1406.7236, 1520.7665, 1706.8458, 1819.9299, 1933.0139, 2020.0460, 2167.1144, 2266.1828, 2337.2199, 2450.3040, 2581.3445, 2680.4129, 2811.4534, 2924.5374, 3084.5681, 3197.6521, 3296.7206, 3409.8046, 3546.8635, 3675.9061, 3838.9695, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 467.2249, 604.2838, 717.3678, 816.4363, 929.5203, 1089.5510, 1202.6350, 1333.6755, 1432.7439, 1563.7844, 1676.8685, 1747.9056, 1846.9740, 1994.0424, 2081.0745, 2194.1585, 2307.2426, 2493.3219, 2607.3648, 2720.4489, 2821.4966, 2934.5806, 3047.6647, 3178.7052, 3291.7892, 3378.8213, 3435.8427, 3550.8697, 3663.9537, 3827.0171, 3956.0597, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QMWDISLTATIILLLLTMFMYDGMNQLTYTYFGK", {129.0659, 260.1063, 446.1857, 561.2126, 674.2967, 761.3287, 874.4128, 975.4604, 1046.4975, 1147.5452, 1260.6293, 1373.7134, 1486.7974, 1599.8815, 1712.9655, 1826.0496, 1927.0973, 2058.1378, 2205.2062, 2336.2467, 2499.3100, 2614.3369, 2671.3584, 2802.3989, 2916.4418, 3044.5004, 3157.5845, 3258.6321, 3421.6955, 3522.7431, 3685.8065, 3832.8749, 3889.8963, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 204.1343, 351.2027, 514.2660, 615.3137, 778.3770, 879.4247, 992.5088, 1120.5673, 1234.6103, 1365.6507, 1422.6722, 1537.6992, 1700.7625, 1831.8030, 1978.8714, 2109.9119, 2210.9595, 2324.0436, 2437.1277, 2550.2117, 2663.2958, 2776.3799, 2889.4639, 2990.5116, 3061.5487, 3162.5964, 3275.6805, 3362.7125, 3475.7966, 3590.8235, 3776.9028, 3907.9433, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"IDGSFTDLDNNQYDGFNTWTYNWFRPDARPDAPK", {114.0913, 229.1183, 286.1397, 373.1718, 520.2402, 621.2879, 736.3148, 849.3989, 964.4258, 1078.4687, 1192.5117, 1320.5703, 1483.6336, 1598.6605, 1655.6820, 1802.7504, 1916.7933, 2017.8410, 2203.9203, 2304.9680, 2468.0313, 2582.0743, 2768.1536, 2915.2220, 3071.3231, 3168.3759, 3283.4028, 3354.4399, 3510.5410, 3607.5938, 3722.6207, 3793.6578, 3890.7106, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 244.1656, 315.2027, 430.2296, 527.2824, 683.3835, 754.4206, 869.4476, 966.5003, 1122.6014, 1269.6698, 1455.7492, 1569.7921, 1732.8554, 1833.9031, 2019.9824, 2121.0301, 2235.0730, 2382.1414, 2439.1629, 2554.1898, 2717.2532, 2845.3117, 2959.3547, 3073.3976, 3188.4245, 3301.5086, 3416.5355, 3517.5832, 3664.6516, 3751.6837, 3808.7051, 3923.7321, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FNQNCKPCFYTIFDLDVANHYSISDELTNLGAPR", {148.0757, 262.1186, 390.1772, 504.2201, 664.2508, 792.3457, 889.3985, 1049.4291, 1196.4976, 1359.5609, 1460.6086, 1573.6926, 1720.7610, 1835.7880, 1948.8721, 2063.8990, 2162.9674, 2234.0045, 2348.0475, 2485.1064, 2648.1697, 2735.2017, 2848.2858, 2935.3178, 3050.3448, 3179.3873, 3292.4714, 3393.5191, 3507.5620, 3620.6461, 3677.6675, 3748.7047, 3845.7574, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 272.1717, 343.2088, 400.2303, 513.3144, 627.3573, 728.4050, 841.4890, 970.5316, 1085.5586, 1172.5906, 1285.6747, 1372.7067, 1535.7700, 1672.8289, 1786.8719, 1857.9090, 1956.9774, 2072.0043, 2185.0884, 2300.1153, 2447.1837, 2560.2678, 2661.3155, 2824.3788, 2971.4472, 3131.4779, 3228.5306, 3356.6256, 3516.6563, 3630.6992, 3758.7578, 3872.8007, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"IESVEDSAEDDEDASNYIINYEPEECSSMCECSK", {114.0913, 243.1339, 330.1660, 429.2344, 558.2770, 673.3039, 760.3359, 831.3731, 960.4156, 1075.4426, 1190.4695, 1319.5121, 1434.5391, 1505.5762, 1592.6082, 1706.6511, 1869.7145, 1982.7985, 2095.8826, 2209.9255, 2372.9889, 2502.0314, 2599.0842, 2728.1268, 2857.1694, 3017.2000, 3104.2321, 3191.2641, 3322.3046, 3482.3352, 3611.3778, 3771.4085, 3858.4405, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 234.1448, 394.1755, 523.2181, 683.2487, 814.2892, 901.3212, 988.3533, 1148.3839, 1277.4265, 1406.4691, 1503.5219, 1632.5645, 1795.6278, 1909.6707, 2022.7548, 2135.8388, 2298.9022, 2412.9451, 2499.9771, 2571.0142, 2686.0412, 2815.0838, 2930.1107, 3045.1377, 3174.1803, 3245.2174, 3332.2494, 3447.2763, 3576.3189, 3675.3873, 3762.4194, 3891.4620, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QHHYNTSSNSQQHQQQAQHQQQQLPASYTPVLLR", {129.0659, 266.1248, 403.1837, 566.2470, 680.2899, 781.3376, 868.3696, 955.4017, 1069.4446, 1156.4766, 1284.5352, 1412.5938, 1549.6527, 1677.7113, 1805.7698, 1933.8284, 2004.8655, 2132.9241, 2269.9830, 2398.0416, 2526.1002, 2654.1588, 2782.2173, 2895.3014, 2992.3542, 3063.3913, 3150.4233, 3313.4866, 3414.5343, 3511.5871, 3610.6555, 3723.7396, 3836.8236, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 401.2871, 500.3555, 597.4083, 698.4559, 861.5193, 948.5513, 1019.5884, 1116.6412, 1229.7252, 1357.7838, 1485.8424, 1613.9010, 1741.9595, 1879.0185, 2007.0770, 2078.1141, 2206.1727, 2334.2313, 2462.2899, 2599.3488, 2727.4074, 2855.4659, 2942.4980, 3056.5409, 3143.5729, 3230.6050, 3331.6526, 3445.6956, 3608.7589, 3745.8178, 3882.8767, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"CFNVALCELQICNSSFADIHSDDIFNIGYLNIVR", {161.0379, 308.1063, 422.1493, 521.2177, 592.2548, 705.3389, 865.3695, 994.4121, 1107.4962, 1235.5547, 1348.6388, 1508.6695, 1622.7124, 1709.7444, 1796.7764, 1943.8449, 2014.8820, 2129.9089, 2242.9930, 2380.0519, 2467.0839, 2582.1109, 2697.1378, 2810.2219, 2957.2903, 3071.3332, 3184.4173, 3241.4387, 3404.5021, 3517.5861, 3631.6291, 3744.7131, 3843.7815, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 274.1874, 387.2714, 501.3144, 614.3984, 777.4618, 834.4832, 947.5673, 1061.6102, 1208.6786, 1321.7627, 1436.7896, 1551.8166, 1638.8486, 1775.9075, 1888.9916, 2004.0185, 2075.0556, 2222.1240, 2309.1561, 2396.1881, 2510.2310, 2670.2617, 2783.3457, 2911.4043, 3024.4884, 3153.5310, 3313.5616, 3426.6457, 3497.6828, 3596.7512, 3710.7941, 3857.8626, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"STLDSDFVQQYYPFCCVGVTAALPWMLVNFADCR", {88.0393, 189.0870, 302.1710, 417.1980, 504.2300, 619.2570, 766.3254, 865.3938, 993.4524, 1121.5109, 1284.5743, 1447.6376, 1544.6904, 1691.7588, 1851.7894, 2011.8201, 2110.8885, 2167.9100, 2266.9784, 2368.0260, 2439.0632, 2510.1003, 2623.1843, 2720.2371, 2906.3164, 3037.3569, 3150.4410, 3249.5094, 3363.5523, 3510.6207, 3581.6578, 3696.6848, 3856.7154, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 335.1496, 450.1765, 521.2137, 668.2821, 782.3250, 881.3934, 994.4775, 1125.5180, 1311.5973, 1408.6500, 1521.7341, 1592.7712, 1663.8083, 1764.8560, 1863.9244, 1920.9459, 2020.0143, 2180.0449, 2340.0756, 2487.1440, 2584.1968, 2747.2601, 2910.3234, 3038.3820, 3166.4406, 3265.5090, 3412.5774, 3527.6044, 3614.6364, 3729.6633, 3842.7474, 3943.7951, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FGWDYYAILIFNVVTMLFGVFTLVNPALWKPVFK", {148.0757, 205.0972, 391.1765, 506.2034, 669.2667, 832.3301, 903.3672, 1016.4512, 1129.5353, 1242.6194, 1389.6878, 1503.7307, 1602.7991, 1701.8675, 1802.9152, 1933.9557, 2047.0398, 2194.1082, 2251.1296, 2350.1981, 2497.2665, 2598.3142, 2711.3982, 2810.4666, 2924.5096, 3021.5623, 3092.5994, 3205.6835, 3391.7628, 3519.8578, 3616.9105, 3715.9790, 3863.0474, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 294.1812, 393.2496, 490.3024, 618.3974, 804.4767, 917.5607, 988.5978, 1085.6506, 1199.6935, 1298.7620, 1411.8460, 1512.8937, 1659.9621, 1759.0305, 1816.0520, 1963.1204, 2076.2045, 2207.2450, 2308.2926, 2407.3610, 2506.4295, 2620.4724, 2767.5408, 2880.6249, 2993.7089, 3106.7930, 3177.8301, 3340.8934, 3503.9568, 3618.9837, 3805.0630, 3862.0845, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FFDYHQDYHGGLGYNMLQLMESGYLNFGTMDSIR", {148.0757, 295.1441, 410.1710, 573.2344, 710.2933, 838.3519, 953.3788, 1116.4421, 1253.5010, 1310.5225, 1367.5440, 1480.6280, 1537.6495, 1700.7128, 1814.7558, 1945.7962, 2058.8803, 2186.9389, 2300.0230, 2431.0634, 2560.1060, 2647.1381, 2704.1595, 2867.2228, 2980.3069, 3094.3498, 3241.4183, 3298.4397, 3399.4874, 3530.5279, 3645.5548, 3732.5869, 3845.6709, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 375.2350, 490.2620, 621.3025, 722.3502, 779.3716, 926.4400, 1040.4830, 1153.5670, 1316.6303, 1373.6518, 1460.6838, 1589.7264, 1720.7669, 1833.8510, 1961.9096, 2074.9936, 2206.0341, 2320.0770, 2483.1404, 2540.1618, 2653.2459, 2710.2674, 2767.2888, 2904.3477, 3067.4111, 3182.4380, 3310.4966, 3447.5555, 3610.6188, 3725.6458, 3872.7142, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TYNNKPNLQGCPPEGCYFSWPQQNICMALEGMGR", {102.0550, 265.1183, 379.1612, 493.2041, 621.2991, 718.3519, 832.3948, 945.4789, 1073.5374, 1130.5589, 1290.5895, 1387.6423, 1484.6951, 1613.7377, 1670.7591, 1830.7898, 1993.8531, 2140.9215, 2227.9536, 2414.0329, 2511.0856, 2639.1442, 2767.2028, 2881.2457, 2994.3298, 3154.3604, 3285.4009, 3356.4380, 3469.5221, 3598.5647, 3655.5861, 3786.6266, 3843.6481, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 232.1404, 363.1809, 420.2024, 549.2450, 662.3290, 733.3661, 864.4066, 1024.4373, 1137.5213, 1251.5643, 1379.6228, 1507.6814, 1604.7342, 1790.8135, 1877.8455, 2024.9139, 2187.9773, 2348.0079, 2405.0294, 2534.0720, 2631.1247, 2728.1775, 2888.2081, 2945.2296, 3073.2882, 3186.3722, 3300.4152, 3397.4679, 3525.5629, 3639.6058, 3753.6488, 3916.7121, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YGVTSCVTFAFFFAHYFTWTYPTDDYTPPLTVPK", {164.0706, 221.0921, 320.1605, 421.2082, 508.2402, 668.2708, 767.3393, 868.3869, 1015.4553, 1086.4925, 1233.5609, 1380.6293, 1527.6977, 1598.7348, 1735.7937, 1898.8571, 2045.9255, 2146.9731, 2333.0525, 2434.1001, 2597.1635, 2694.2162, 2795.2639, 2910.2909, 3025.3178, 3188.3811, 3289.4288, 3386.4816, 3483.5343, 3596.6184, 3697.6661, 3796.7345, 3893.7873, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 244.1656, 343.2340, 444.2817, 557.3657, 654.4185, 751.4713, 852.5189, 1015.5823, 1130.6092, 1245.6361, 1346.6838, 1443.7366, 1606.7999, 1707.8476, 1893.9269, 1994.9746, 2142.0430, 2305.1063, 2442.1652, 2513.2024, 2660.2708, 2807.3392, 2954.4076, 3025.4447, 3172.5131, 3273.5608, 3372.6292, 3532.6599, 3619.6919, 3720.7396, 3819.8080, 3876.8294, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NIIALTCNALYFDTLLDDFVIYDNYEVTAYLMGR", {115.0502, 228.1343, 341.2183, 412.2554, 525.3395, 626.3872, 786.4178, 900.4608, 971.4979, 1084.5819, 1247.6453, 1394.7137, 1509.7406, 1610.7883, 1723.8724, 1836.9564, 1951.9834, 2067.0103, 2214.0787, 2313.1471, 2426.2312, 2589.2945, 2704.3215, 2818.3644, 2981.4277, 3110.4703, 3209.5387, 3310.5864, 3381.6235, 3544.6869, 3657.7709, 3788.8114, 3845.8329, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 232.1404, 363.1809, 476.2650, 639.3283, 710.3654, 811.4131, 910.4815, 1039.5241, 1202.5874, 1316.6303, 1431.6573, 1594.7206, 1707.8047, 1806.8731, 1953.9415, 2068.9685, 2183.9954, 2297.0795, 2410.1635, 2511.2112, 2626.2381, 2773.3066, 2936.3699, 3049.4540, 3120.4911, 3234.5340, 3394.5646, 3495.6123, 3608.6964, 3679.7335, 3792.8176, 3905.9016, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"GLHPEQPEQELESFDDFDGFSHLPEYLAEVQEER", {58.0287, 171.1128, 308.1717, 405.2245, 534.2671, 662.3257, 759.3784, 888.4210, 1016.4796, 1145.5222, 1258.6062, 1387.6488, 1474.6809, 1621.7493, 1736.7762, 1851.8032, 1998.8716, 2113.8985, 2170.9200, 2317.9884, 2405.0204, 2542.0793, 2655.1634, 2752.2162, 2881.2588, 3044.3221, 3157.4062, 3228.4433, 3357.4859, 3456.5543, 3584.6129, 3713.6554, 3842.6980, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 433.2041, 561.2627, 660.3311, 789.3737, 860.4108, 973.4949, 1136.5582, 1265.6008, 1362.6536, 1475.7377, 1612.7966, 1699.8286, 1846.8970, 1903.9185, 2018.9454, 2166.0138, 2281.0408, 2396.0677, 2543.1361, 2630.1682, 2759.2107, 2872.2948, 3001.3374, 3129.3960, 3258.4386, 3355.4913, 3483.5499, 3612.5925, 3709.6453, 3846.7042, 3959.7882, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PSFSPQLIVYVTFHLISLLWLARPVIILLIQHFR", {98.0600, 185.0921, 332.1605, 419.1925, 516.2453, 644.3039, 757.3879, 870.4720, 969.5404, 1132.6037, 1231.6721, 1332.7198, 1479.7882, 1616.8471, 1729.9312, 1843.0153, 1930.0473, 2043.1314, 2156.2154, 2342.2947, 2455.3788, 2526.4159, 2682.5170, 2779.5698, 2878.6382, 2991.7223, 3104.8063, 3217.8904, 3330.9745, 3444.0585, 3572.1171, 3709.1760, 3856.2444, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 459.2463, 587.3049, 700.3889, 813.4730, 926.5570, 1039.6411, 1152.7252, 1251.7936, 1348.8464, 1504.9475, 1575.9846, 1689.0686, 1875.1480, 1988.2320, 2101.3161, 2188.3481, 2301.4322, 2414.5162, 2551.5752, 2698.6436, 2799.6912, 2898.7597, 3061.8230, 3160.8914, 3273.9755, 3387.0595, 3515.1181, 3612.1709, 3699.2029, 3846.2713, 3933.3033, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QKPPPPTFSEDSDDLHDEYLADDELYETVFEEQK", {129.0659, 257.1608, 354.2136, 451.2663, 548.3191, 645.3719, 746.4196, 893.4880, 980.5200, 1109.5626, 1224.5895, 1311.6216, 1426.6485, 1541.6754, 1654.7595, 1791.8184, 1906.8454, 2035.8880, 2198.9513, 2312.0353, 2383.0725, 2498.0994, 2613.1263, 2742.1689, 2855.2530, 3018.3163, 3147.3589, 3248.4066, 3347.4750, 3494.5434, 3623.5860, 3752.6286, 3880.6872, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 275.1714, 404.2140, 533.2566, 680.3250, 779.3934, 880.4411, 1009.4837, 1172.5470, 1285.6311, 1414.6737, 1529.7006, 1644.7275, 1715.7647, 1828.8487, 1991.9120, 2120.9546, 2235.9816, 2373.0405, 2486.1246, 2601.1515, 2716.1784, 2803.2105, 2918.2374, 3047.2800, 3134.3120, 3281.3805, 3382.4281, 3479.4809, 3576.5337, 3673.5864, 3770.6392, 3898.7341, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"HQYQPIAINTSNDQALEECISHCGFPVYMEPEHK", {138.0662, 266.1248, 429.1881, 557.2467, 654.2994, 767.3835, 838.4206, 951.5047, 1065.5476, 1166.5953, 1253.6273, 1367.6702, 1482.6972, 1610.7558, 1681.7929, 1794.8769, 1923.9195, 2052.9621, 2212.9928, 2326.0768, 2413.1089, 2550.1678, 2710.1984, 2767.2199, 2914.2883, 3011.3411, 3110.4095, 3273.4728, 3404.5133, 3533.5559, 3630.6087, 3759.6512, 3896.7102, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 284.1717, 413.2143, 510.2671, 639.3097, 770.3502, 933.4135, 1032.4819, 1129.5347, 1276.6031, 1333.6245, 1493.6552, 1630.7141, 1717.7461, 1830.8302, 1990.8608, 2119.9034, 2248.9460, 2362.0301, 2433.0672, 2561.1258, 2676.1527, 2790.1956, 2877.2277, 2978.2754, 3092.3183, 3205.4023, 3276.4395, 3389.5235, 3486.5763, 3614.6349, 3777.6982, 3905.7568, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EVHFTYLNVGADAMPEIWQEPNQVMMHTEFFATK", {130.0499, 229.1183, 366.1772, 513.2456, 614.2933, 777.3566, 890.4407, 1004.4836, 1103.5520, 1160.5735, 1231.6106, 1346.6375, 1417.6747, 1548.7151, 1645.7679, 1774.8105, 1887.8946, 2073.9739, 2202.0325, 2331.0750, 2428.1278, 2542.1707, 2670.2293, 2769.2977, 2900.3382, 3031.3787, 3168.4376, 3269.4853, 3398.5279, 3545.5963, 3692.6647, 3763.7018, 3864.7495, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 248.1605, 319.1976, 466.2660, 613.3344, 742.3770, 843.4247, 980.4836, 1111.5241, 1242.5646, 1341.6330, 1469.6916, 1583.7345, 1680.7873, 1809.8299, 1937.8884, 2123.9677, 2237.0518, 2366.0944, 2463.1472, 2594.1876, 2665.2248, 2780.2517, 2851.2888, 2908.3103, 3007.3787, 3121.4216, 3234.5057, 3397.5690, 3498.6167, 3645.6851, 3782.7440, 3881.8124, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QVFTEGAEYAALEEENLNHSYNLFQNIWPNLRPK", {129.0659, 228.1343, 375.2027, 476.2504, 605.2930, 662.3144, 733.3515, 862.3941, 1025.4575, 1096.4946, 1167.5317, 1280.6157, 1409.6583, 1538.7009, 1667.7435, 1781.7865, 1894.8705, 2008.9134, 2145.9724, 2233.0044, 2396.0677, 2510.1106, 2623.1947, 2770.2631, 2898.3217, 3012.3646, 3125.4487, 3311.5280, 3408.5808, 3522.6237, 3635.7078, 3791.8089, 3888.8616, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 244.1656, 400.2667, 513.3507, 627.3937, 724.4464, 910.5257, 1023.6098, 1137.6527, 1265.7113, 1412.7797, 1525.8638, 1639.9067, 1802.9701, 1890.0021, 2027.0610, 2141.1039, 2254.1880, 2368.2309, 2497.2735, 2626.3161, 2755.3587, 2868.4428, 2939.4799, 3010.5170, 3173.5803, 3302.6229, 3373.6600, 3430.6815, 3559.7241, 3660.7718, 3807.8402, 3906.9086, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ASTVESSYQTYQQYQPHFNHIADTMIDKPNMTEK", {72.0444, 159.0764, 260.1241, 359.1925, 488.2351, 575.2671, 662.2992, 825.3625, 953.4211, 1054.4687, 1217.5321, 1345.5907, 1473.6492, 1636.7126, 1764.7711, 1861.8239, 1998.8828, 2145.9512, 2259.9942, 2397.0531, 2510.1371, 2581.1742, 2696.2012, 2797.2489, 2928.2893, 3041.3734, 3156.4004, 3284.4953, 3381.5481, 3495.5910, 3626.6315, 3727.6792, 3856.7218, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 276.1554, 377.2031, 508.2436, 622.2865, 719.3393, 847.4342, 962.4612, 1075.5452, 1206.5857, 1307.6334, 1422.6603, 1493.6974, 1606.7815, 1743.8404, 1857.8833, 2004.9518, 2142.0107, 2239.0634, 2367.1220, 2530.1853, 2658.2439, 2786.3025, 2949.3658, 3050.4135, 3178.4721, 3341.5354, 3428.5674, 3515.5995, 3644.6421, 3743.7105, 3844.7582, 3931.7902, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SEMIHQCNSICYQAVIRPDEITETHTNSNTNSER", {88.0393, 217.0819, 348.1224, 461.2064, 598.2654, 726.3239, 886.3546, 1000.3975, 1087.4295, 1200.5136, 1360.5443, 1523.6076, 1651.6662, 1722.7033, 1821.7717, 1934.8558, 2090.9569, 2188.0096, 2303.0366, 2432.0792, 2545.1632, 2646.2109, 2775.2535, 2876.3012, 3013.3601, 3114.4078, 3228.4507, 3315.4827, 3429.5257, 3530.5733, 3644.6163, 3731.6483, 3860.6909, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 391.1936, 505.2365, 606.2842, 720.3271, 807.3591, 921.4021, 1022.4497, 1159.5087, 1260.5563, 1389.5989, 1490.6466, 1603.7307, 1732.7733, 1847.8002, 1944.8530, 2100.9541, 2214.0381, 2313.1066, 2384.1437, 2512.2022, 2675.2656, 2835.2962, 2948.3803, 3035.4123, 3149.4552, 3309.4859, 3437.5445, 3574.6034, 3687.6874, 3818.7279, 3947.7705, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EELFFPTGVYEEESDSDDYYNIDDIAACPDDEHK", {130.0499, 259.0925, 372.1765, 519.2449, 666.3134, 763.3661, 864.4138, 921.4353, 1020.5037, 1183.5670, 1312.6096, 1441.6522, 1570.6948, 1657.7268, 1772.7538, 1859.7858, 1974.8127, 2089.8397, 2252.9030, 2415.9663, 2530.0093, 2643.0933, 2758.1203, 2873.1472, 2986.2313, 3057.2684, 3128.3055, 3288.3361, 3385.3889, 3500.4159, 3615.4428, 3744.4854, 3881.5443, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 284.1717, 413.2143, 528.2413, 643.2682, 740.3210, 900.3516, 971.3887, 1042.4258, 1155.5099, 1270.5368, 1385.5638, 1498.6478, 1612.6908, 1775.7541, 1938.8174, 2053.8444, 2168.8713, 2255.9033, 2370.9303, 2457.9623, 2587.0049, 2716.0475, 2845.0901, 3008.1534, 3107.2218, 3164.2433, 3265.2910, 3362.3437, 3509.4122, 3656.4806, 3769.5646, 3898.6072, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LEGCEENDLDDDDLDDDLDEPEDYDFEAADEHDK", {114.0913, 243.1339, 300.1554, 460.1860, 589.2286, 718.2712, 832.3142, 947.3411, 1060.4252, 1175.4521, 1290.4791, 1405.5060, 1520.5329, 1633.6170, 1748.6439, 1863.6709, 1978.6978, 2091.7819, 2206.8088, 2335.8514, 2432.9042, 2561.9468, 2676.9737, 2840.0371, 2955.0640, 3102.1324, 3231.1750, 3302.2121, 3373.2492, 3488.2762, 3617.3188, 3754.3777, 3869.4046, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 262.1397, 399.1987, 528.2413, 643.2682, 714.3053, 785.3424, 914.3850, 1061.4534, 1176.4804, 1339.5437, 1454.5706, 1583.6132, 1680.6660, 1809.7086, 1924.7355, 2037.8196, 2152.8465, 2267.8735, 2382.9004, 2495.9845, 2611.0114, 2726.0384, 2841.0653, 2956.0923, 3069.1763, 3184.2033, 3298.2462, 3427.2888, 3556.3314, 3716.3620, 3773.3835, 3902.4261, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LEGKPCLEFVLFVFADSEFVDQLDIIYPHGMVQR", {114.0913, 243.1339, 300.1554, 428.2504, 525.3031, 685.3338, 798.4178, 927.4604, 1074.5288, 1173.5973, 1286.6813, 1433.7497, 1532.8181, 1679.8866, 1750.9237, 1865.9506, 1952.9826, 2082.0252, 2229.0937, 2328.1621, 2443.1890, 2571.2476, 2684.3317, 2799.3586, 2912.4427, 3025.5267, 3188.5901, 3285.6428, 3422.7017, 3479.7232, 3610.7637, 3709.8321, 3837.8907, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 402.2459, 533.2864, 590.3079, 727.3668, 824.4196, 987.4829, 1100.5670, 1213.6510, 1328.6780, 1441.7620, 1569.8206, 1684.8476, 1783.9160, 1930.9844, 2060.0270, 2147.0590, 2262.0859, 2333.1231, 2480.1915, 2579.2599, 2726.3283, 2839.4124, 2938.4808, 3085.5492, 3214.5918, 3327.6758, 3487.7065, 3584.7593, 3712.8542, 3769.8757, 3898.9183, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NNYYETFWMVFFGTVSIVFLLFMVGLMILTGIDK", {115.0502, 229.0931, 392.1565, 555.2198, 684.2624, 785.3101, 932.3785, 1118.4578, 1249.4983, 1348.5667, 1495.6351, 1642.7035, 1699.7250, 1800.7727, 1899.8411, 1986.8731, 2099.9572, 2199.0256, 2346.0940, 2459.1781, 2572.2621, 2719.3305, 2850.3710, 2949.4394, 3006.4609, 3119.5450, 3250.5854, 3363.6695, 3476.7536, 3577.8012, 3634.8227, 3747.9068, 3862.9337, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 262.1397, 375.2238, 432.2453, 533.2930, 646.3770, 759.4611, 890.5016, 1003.5856, 1060.6071, 1159.6755, 1290.7160, 1437.7844, 1550.8685, 1663.9525, 1811.0209, 1910.0894, 2023.1734, 2110.2055, 2209.2739, 2310.3215, 2367.3430, 2514.4114, 2661.4798, 2760.5483, 2891.5887, 3077.6681, 3224.7365, 3325.7841, 3454.8267, 3617.8901, 3780.9534, 3894.9963, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YENITENFYSGNQPEMYDNNDSNSDDNCISELEK", {164.0706, 293.1132, 407.1561, 520.2402, 621.2879, 750.3305, 864.3734, 1011.4418, 1174.5051, 1261.5372, 1318.5586, 1432.6016, 1560.6601, 1657.7129, 1786.7555, 1917.7960, 2080.8593, 2195.8862, 2309.9292, 2423.9721, 2538.9990, 2626.0311, 2740.0740, 2827.1060, 2942.1330, 3057.1599, 3171.2028, 3331.2335, 3444.3176, 3531.3496, 3660.3922, 3773.4762, 3902.5188, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 276.1554, 389.2395, 518.2821, 605.3141, 718.3981, 878.4288, 992.4717, 1107.4987, 1222.5256, 1309.5576, 1423.6006, 1510.6326, 1625.6595, 1739.7025, 1853.7454, 1968.7723, 2131.8357, 2262.8761, 2391.9187, 2488.9715, 2617.0301, 2731.0730, 2788.0945, 2875.1265, 3038.1898, 3185.2582, 3299.3012, 3428.3438, 3529.3914, 3642.4755, 3756.5184, 3885.5610, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TIVSMMQIILACLESLFIMGFFLFAWLNPTTTFR", {102.0550, 215.1390, 314.2074, 401.2395, 532.2799, 663.3204, 791.3790, 904.4631, 1017.5471, 1130.6312, 1201.6683, 1361.6990, 1474.7830, 1603.8256, 1690.8576, 1803.9417, 1951.0101, 2064.0942, 2195.1347, 2252.1561, 2399.2246, 2546.2930, 2659.3770, 2806.4454, 2877.4826, 3063.5619, 3176.6459, 3290.6889, 3387.7416, 3488.7893, 3589.8370, 3690.8847, 3837.9531, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 423.2350, 524.2827, 625.3304, 722.3832, 836.4261, 949.5102, 1135.5895, 1206.6266, 1353.6950, 1466.7791, 1613.8475, 1760.9159, 1817.9374, 1948.9778, 2062.0619, 2209.1303, 2322.2144, 2409.2464, 2538.2890, 2651.3731, 2811.4037, 2882.4408, 2995.5249, 3108.6090, 3221.6930, 3349.7516, 3480.7921, 3611.8326, 3698.8646, 3797.9330, 3911.0171, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MGVHDEFHDHAVNCCLLGMLGITIHTLCVWISLR", {132.0478, 189.0692, 288.1376, 425.1966, 540.2235, 669.2661, 816.3345, 953.3934, 1068.4204, 1205.4793, 1276.5164, 1375.5848, 1489.6277, 1649.6584, 1809.6890, 1922.7731, 2035.8571, 2092.8786, 2223.9191, 2337.0032, 2394.0246, 2507.1087, 2608.1564, 2721.2404, 2858.2993, 2959.3470, 3072.4311, 3232.4617, 3331.5301, 3517.6095, 3630.6935, 3717.7256, 3830.8096, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 375.2350, 488.3191, 674.3984, 773.4668, 933.4975, 1046.5815, 1147.6292, 1284.6881, 1397.7722, 1498.8199, 1611.9039, 1668.9254, 1782.0095, 1913.0500, 1970.0714, 2083.1555, 2196.2395, 2356.2702, 2516.3008, 2630.3438, 2729.4122, 2800.4493, 2937.5082, 3052.5352, 3189.5941, 3336.6625, 3465.7051, 3580.7320, 3717.7909, 3816.8593, 3873.8808, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DVVPYNGVDNLGDQGHFCNTYEWTRPVISEYCGR", {116.0342, 215.1026, 314.1710, 411.2238, 574.2871, 688.3301, 745.3515, 844.4199, 959.4469, 1073.4898, 1186.5739, 1243.5953, 1358.6223, 1486.6809, 1543.7023, 1680.7612, 1827.8297, 1987.8603, 2101.9032, 2202.9509, 2366.0142, 2495.0568, 2681.1361, 2782.1838, 2938.2849, 3035.3377, 3134.4061, 3247.4902, 3334.5222, 3463.5648, 3626.6281, 3786.6588, 3843.6802, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 232.1404, 392.1711, 555.2344, 684.2770, 771.3090, 884.3931, 983.4615, 1080.5143, 1236.6154, 1337.6630, 1523.7424, 1652.7850, 1815.8483, 1916.8960, 2030.9389, 2190.9695, 2338.0379, 2475.0969, 2532.1183, 2660.1769, 2775.2038, 2832.2253, 2945.3094, 3059.3523, 3174.3792, 3273.4477, 3330.4691, 3444.5120, 3607.5754, 3704.6281, 3803.6966, 3902.7650, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"WYGPTPMLNHPYEECFEDSCAQPPLPFILTTSSK", {187.0866, 350.1499, 407.1714, 504.2241, 605.2718, 702.3246, 833.3651, 946.4491, 1060.4921, 1197.5510, 1294.6037, 1457.6671, 1586.7097, 1715.7523, 1875.7829, 2022.8513, 2151.8939, 2266.9209, 2353.9529, 2513.9835, 2585.0206, 2713.0792, 2810.1320, 2907.1847, 3020.2688, 3117.3216, 3264.3900, 3377.4741, 3490.5581, 3591.6058, 3692.6535, 3779.6855, 3866.7175, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 234.1448, 321.1769, 422.2245, 523.2722, 636.3563, 749.4403, 896.5088, 993.5615, 1106.6456, 1203.6984, 1300.7511, 1428.8097, 1499.8468, 1659.8775, 1746.9095, 1861.9364, 1990.9790, 2138.0474, 2298.0781, 2427.1207, 2556.1633, 2719.2266, 2816.2794, 2953.3383, 3067.3812, 3180.4653, 3311.5057, 3408.5585, 3509.6062, 3606.6590, 3663.6804, 3826.7437, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DNVLSAGCYFNGFWMLMIMWPYEHVETEQGGVIR", {116.0342, 230.0771, 329.1456, 442.2296, 529.2617, 600.2988, 657.3202, 817.3509, 980.4142, 1127.4826, 1241.5255, 1298.5470, 1445.6154, 1631.6947, 1762.7352, 1875.8193, 2006.8598, 2119.9438, 2250.9843, 2437.0636, 2534.1164, 2697.1797, 2826.2223, 2963.2812, 3062.3496, 3191.3922, 3292.4399, 3421.4825, 3549.5411, 3606.5626, 3663.5840, 3762.6524, 3875.7365, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 387.2714, 444.2929, 501.3144, 629.3729, 758.4155, 859.4632, 988.5058, 1087.5742, 1224.6331, 1353.6757, 1516.7390, 1613.7918, 1799.8711, 1930.9116, 2043.9957, 2175.0362, 2288.1202, 2419.1607, 2605.2400, 2752.3084, 2809.3299, 2923.3728, 3070.4412, 3233.5046, 3393.5352, 3450.5567, 3521.5938, 3608.6258, 3721.7099, 3820.7783, 3934.8212, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YSCIPLPHGFHMLDILLELIQNANEEQHSLSLDR", {164.0706, 251.1026, 411.1333, 524.2173, 621.2701, 734.3542, 831.4069, 968.4658, 1025.4873, 1172.5557, 1309.6146, 1440.6551, 1553.7392, 1668.7661, 1781.8502, 1894.9343, 2008.0183, 2137.0609, 2250.1450, 2363.2290, 2491.2876, 2605.3305, 2676.3677, 2790.4106, 2919.4532, 3048.4958, 3176.5544, 3313.6133, 3400.6453, 3513.7294, 3600.7614, 3713.8455, 3828.8724, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 290.1459, 403.2300, 490.2620, 603.3461, 690.3781, 827.4370, 955.4956, 1084.5382, 1213.5808, 1327.6237, 1398.6608, 1512.7037, 1640.7623, 1753.8464, 1866.9304, 1995.9730, 2109.0571, 2222.1412, 2335.2252, 2450.2522, 2563.3362, 2694.3767, 2831.4356, 2978.5040, 3035.5255, 3172.5844, 3269.6372, 3382.7212, 3479.7740, 3592.8581, 3752.8887, 3839.9207, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FQLLQHQQTQHQQQLQQQHQQQTSNGSSSINSNR", {148.0757, 276.1343, 389.2183, 502.3024, 630.3610, 767.4199, 895.4785, 1023.5370, 1124.5847, 1252.6433, 1389.7022, 1517.7608, 1645.8194, 1773.8779, 1886.9620, 2015.0206, 2143.0792, 2271.1377, 2408.1966, 2536.2552, 2664.3138, 2792.3724, 2893.4201, 2980.4521, 3094.4950, 3151.5165, 3238.5485, 3325.5805, 3412.6126, 3525.6966, 3639.7396, 3726.7716, 3840.8145, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 289.1619, 376.1939, 490.2368, 603.3209, 690.3529, 777.3850, 864.4170, 921.4384, 1035.4814, 1122.5134, 1223.5611, 1351.6197, 1479.6782, 1607.7368, 1744.7957, 1872.8543, 2000.9129, 2128.9715, 2242.0555, 2370.1141, 2498.1727, 2626.2313, 2763.2902, 2891.3487, 2992.3964, 3120.4550, 3248.5136, 3385.5725, 3513.6311, 3626.7151, 3739.7992, 3867.8578, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NMQQQQHHQQQPHHPPPHNHQALSAWGQGMSYSR", {115.0502, 246.0907, 374.1493, 502.2078, 630.2664, 758.3250, 895.3839, 1032.4428, 1160.5014, 1288.5600, 1416.6186, 1513.6713, 1650.7302, 1787.7891, 1884.8419, 1981.8947, 2078.9474, 2216.0063, 2330.0493, 2467.1082, 2595.1668, 2666.2039, 2779.2879, 2866.3200, 2937.3571, 3123.4364, 3180.4579, 3308.5164, 3365.5379, 3496.5784, 3583.6104, 3746.6737, 3833.7058, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 262.1510, 425.2143, 512.2463, 643.2868, 700.3083, 828.3669, 885.3883, 1071.4676, 1142.5048, 1229.5368, 1342.6208, 1413.6580, 1541.7165, 1678.7754, 1792.8184, 1929.8773, 2026.9301, 2123.9828, 2221.0356, 2358.0945, 2495.1534, 2592.2062, 2720.2647, 2848.3233, 2976.3819, 3113.4408, 3250.4997, 3378.5583, 3506.6169, 3634.6755, 3762.7340, 3893.7745, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LPLLYSSIFFTVQYTRPGLFDNTTFTCMGYTINK", {114.0913, 211.1441, 324.2282, 437.3122, 600.3756, 687.4076, 774.4396, 887.5237, 1034.5921, 1181.6605, 1282.7082, 1381.7766, 1509.8352, 1672.8985, 1773.9462, 1930.0473, 2027.1001, 2084.1215, 2197.2056, 2344.2740, 2459.3009, 2573.3439, 2674.3916, 2775.4392, 2922.5076, 3023.5553, 3183.5860, 3314.6265, 3371.6479, 3534.7112, 3635.7589, 3748.8430, 3862.8859, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 261.1557, 374.2398, 475.2875, 638.3508, 695.3723, 826.4128, 986.4434, 1087.4911, 1234.5595, 1335.6072, 1436.6548, 1550.6978, 1665.7247, 1812.7931, 1925.8772, 1982.8987, 2079.9514, 2236.0525, 2337.1002, 2500.1635, 2628.2221, 2727.2905, 2828.3382, 2975.4066, 3122.4750, 3235.5591, 3322.5911, 3409.6232, 3572.6865, 3685.7706, 3798.8546, 3895.9074, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"IFNNSAHLENLAENGEFEPLELIDNHQLYLCDLK", {114.0913, 261.1598, 375.2027, 489.2456, 576.2776, 647.3148, 784.3737, 897.4577, 1026.5003, 1140.5432, 1253.6273, 1324.6644, 1453.7070, 1567.7499, 1624.7714, 1753.8140, 1900.8824, 2029.9250, 2126.9778, 2240.0618, 2369.1044, 2482.1885, 2595.2726, 2710.2995, 2824.3424, 2961.4013, 3089.4599, 3202.5440, 3365.6073, 3478.6914, 3638.7220, 3753.7490, 3866.8330, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 375.2238, 535.2545, 648.3385, 811.4019, 924.4859, 1052.5445, 1189.6034, 1303.6463, 1418.6733, 1531.7573, 1644.8414, 1773.8840, 1886.9681, 1984.0208, 2113.0634, 2260.1318, 2389.1744, 2446.1959, 2560.2388, 2689.2814, 2760.3185, 2873.4026, 2987.4455, 3116.4881, 3229.5722, 3366.6311, 3437.6682, 3524.7002, 3638.7432, 3752.7861, 3899.8545, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SWFIEAHEVLLDSFWAFATPVPPTYVAHTPMCYR", {88.0393, 274.1186, 421.1870, 534.2711, 663.3137, 734.3508, 871.4097, 1000.4523, 1099.5207, 1212.6048, 1325.6888, 1440.7158, 1527.7478, 1674.8162, 1860.8955, 1931.9327, 2079.0011, 2150.0382, 2251.0859, 2348.1386, 2447.2070, 2544.2598, 2641.3126, 2742.3603, 2905.4236, 3004.4920, 3075.5291, 3212.5880, 3313.6357, 3410.6885, 3541.7289, 3701.7596, 3864.8229, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 498.2129, 629.2534, 726.3062, 827.3539, 964.4128, 1035.4499, 1134.5183, 1297.5816, 1398.6293, 1495.6821, 1592.7348, 1691.8032, 1788.8560, 1889.9037, 1960.9408, 2108.0092, 2179.0463, 2365.1256, 2512.1941, 2599.2261, 2714.2530, 2827.3371, 2940.4212, 3039.4896, 3168.5322, 3305.5911, 3376.6282, 3505.6708, 3618.7548, 3765.8233, 3951.9026, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DQDWLWQASSFLDIPQLEDDANTNWASVIPHDFK", {116.0342, 244.0928, 359.1197, 545.1991, 658.2831, 844.3624, 972.4210, 1043.4581, 1130.4901, 1217.5222, 1364.5906, 1477.6747, 1592.7016, 1705.7857, 1802.8384, 1930.8970, 2043.9811, 2173.0237, 2288.0506, 2403.0775, 2474.1147, 2588.1576, 2689.2053, 2803.2482, 2989.3275, 3060.3646, 3147.3967, 3246.4651, 3359.5491, 3456.6019, 3593.6608, 3708.6877, 3855.7562, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 294.1812, 409.2082, 546.2671, 643.3198, 756.4039, 855.4723, 942.5043, 1013.5415, 1199.6208, 1313.6637, 1414.7114, 1528.7543, 1599.7914, 1714.8184, 1829.8453, 1958.8879, 2071.9720, 2200.0305, 2297.0833, 2410.1674, 2525.1943, 2638.2784, 2785.3468, 2872.3788, 2959.4108, 3030.4480, 3158.5065, 3344.5858, 3457.6699, 3643.7492, 3758.7762, 3886.8347, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VQQPQLDCIISSMTTLIEDIFTCAENPQITVFYR", {100.0757, 228.1343, 356.1928, 453.2456, 581.3042, 694.3883, 809.4152, 969.4458, 1082.5299, 1195.6140, 1282.6460, 1369.6780, 1500.7185, 1601.7662, 1702.8139, 1815.8979, 1928.9820, 2058.0246, 2173.0515, 2286.1356, 2433.2040, 2534.2517, 2694.2823, 2765.3195, 2894.3620, 3008.4050, 3105.4577, 3233.5163, 3346.6004, 3447.6481, 3546.7165, 3693.7849, 3856.8482, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 485.2507, 584.3191, 685.3668, 798.4509, 926.5094, 1023.5622, 1137.6051, 1266.6477, 1337.6848, 1497.7155, 1598.7632, 1745.8316, 1858.9156, 1973.9426, 2102.9852, 2216.0692, 2329.1533, 2430.2010, 2531.2487, 2662.2891, 2749.3212, 2836.3532, 2949.4373, 3062.5213, 3222.5520, 3337.5789, 3450.6630, 3578.7216, 3675.7743, 3803.8329, 3931.8915, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SANVSALEQMFQEDDEDDEDDDEEDEDEEEVEDR", {88.0393, 159.0764, 273.1193, 372.1878, 459.2198, 530.2569, 643.3410, 772.3836, 900.4421, 1031.4826, 1178.5510, 1306.6096, 1435.6522, 1550.6791, 1665.7061, 1794.7487, 1909.7756, 2024.8026, 2153.8452, 2268.8721, 2383.8991, 2498.9260, 2627.9686, 2757.0112, 2872.0381, 3001.0807, 3116.1077, 3245.1503, 3374.1928, 3503.2354, 3602.3039, 3731.3464, 3846.3734, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 290.1459, 419.1885, 518.2569, 647.2995, 776.3421, 905.3847, 1020.4116, 1149.4542, 1264.4812, 1393.5238, 1522.5663, 1637.5933, 1752.6202, 1867.6472, 1996.6898, 2111.7167, 2226.7437, 2355.7862, 2470.8132, 2585.8401, 2714.8827, 2842.9413, 2990.0097, 3121.0502, 3249.1088, 3378.1514, 3491.2354, 3562.2726, 3649.3046, 3748.3730, 3862.4159, 3933.4530, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VILDDTDDDEDDEYDEDQENNADEFLLEMDPSQR", {100.0757, 213.1598, 326.2438, 441.2708, 556.2977, 657.3454, 772.3723, 887.3993, 1002.4262, 1131.4688, 1246.4957, 1361.5227, 1490.5653, 1653.6286, 1768.6556, 1897.6981, 2012.7251, 2140.7837, 2269.8263, 2383.8692, 2497.9121, 2568.9492, 2683.9762, 2813.0188, 2960.0872, 3073.1712, 3186.2553, 3315.2979, 3446.3384, 3561.3653, 3658.4181, 3745.4501, 3873.5087, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 390.2096, 487.2623, 602.2893, 733.3297, 862.3723, 975.4564, 1088.5405, 1235.6089, 1364.6515, 1479.6784, 1550.7155, 1664.7585, 1778.8014, 1907.8440, 2035.9026, 2150.9295, 2279.9721, 2394.9990, 2558.0624, 2687.1050, 2802.1319, 2917.1588, 3046.2014, 3161.2284, 3276.2553, 3391.2823, 3492.3299, 3607.3569, 3722.3838, 3835.4679, 3948.5520, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YAPPIAYWTKPAGFHLYNISYLDMDETHWAFSSK", {164.0706, 235.1077, 332.1605, 429.2132, 542.2973, 613.3344, 776.3978, 962.4771, 1063.5247, 1191.6197, 1288.6725, 1359.7096, 1416.7310, 1563.7995, 1700.8584, 1813.9424, 1977.0058, 2091.0487, 2204.1328, 2291.1648, 2454.2281, 2567.3122, 2682.3391, 2813.3796, 2928.4066, 3057.4491, 3158.4968, 3295.5557, 3481.6350, 3552.6722, 3699.7406, 3786.7726, 3873.8046, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 234.1448, 321.1769, 468.2453, 539.2824, 725.3617, 862.4206, 963.4683, 1092.5109, 1207.5378, 1338.5783, 1453.6053, 1566.6893, 1729.7526, 1816.7847, 1929.8687, 2043.9117, 2206.9750, 2320.0591, 2457.1180, 2604.1864, 2661.2079, 2732.2450, 2829.2977, 2957.3927, 3058.4404, 3244.5197, 3407.5830, 3478.6201, 3591.7042, 3688.7570, 3785.8097, 3856.8468, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VFLLQNIYGLIMLLYFGLYTLCATHLPVEEFSTK", {100.0757, 247.1441, 360.2282, 473.3122, 601.3708, 715.4137, 828.4978, 991.5611, 1048.5826, 1161.6667, 1274.7507, 1405.7912, 1518.8753, 1631.9593, 1795.0227, 1942.0911, 1999.1125, 2112.1966, 2275.2599, 2376.3076, 2489.3917, 2649.4223, 2720.4594, 2821.5071, 2958.5660, 3071.6501, 3168.7029, 3267.7713, 3396.8139, 3525.8565, 3672.9249, 3759.9569, 3861.0046, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 248.1605, 335.1925, 482.2609, 611.3035, 740.3461, 839.4145, 936.4673, 1049.5514, 1186.6103, 1287.6579, 1358.6951, 1518.7257, 1631.8098, 1732.8574, 1895.9208, 2009.0048, 2066.0263, 2213.0947, 2376.1580, 2489.2421, 2602.3262, 2733.3667, 2846.4507, 2959.5348, 3016.5563, 3179.6196, 3292.7036, 3406.7466, 3534.8051, 3647.8892, 3760.9733, 3908.0417, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MPPVILEEMFQSVETPNDNIMIDLYEVILDNIFK", {132.0478, 229.1005, 326.1533, 425.2217, 538.3058, 651.3898, 780.4324, 909.4750, 1040.5155, 1187.5839, 1315.6425, 1402.6745, 1501.7429, 1630.7855, 1731.8332, 1828.8860, 1942.9289, 2057.9558, 2171.9988, 2285.0828, 2416.1233, 2529.2074, 2644.2343, 2757.3184, 2920.3817, 3049.4243, 3148.4927, 3261.5768, 3374.6609, 3489.6878, 3603.7307, 3716.8148, 3863.8832, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 294.1812, 407.2653, 521.3082, 636.3352, 749.4192, 862.5033, 961.5717, 1090.6143, 1253.6776, 1366.7617, 1481.7886, 1594.8727, 1725.9132, 1838.9972, 1953.0402, 2068.0671, 2182.1100, 2279.1628, 2380.2105, 2509.2531, 2608.3215, 2695.3535, 2823.4121, 2970.4805, 3101.5210, 3230.5636, 3359.6062, 3472.6902, 3585.7743, 3684.8427, 3781.8955, 3878.9482, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NEVVESEIEETLNDLFSCWRPAPGMAPVYYTMMK", {115.0502, 244.0928, 343.1612, 442.2296, 571.2722, 658.3042, 787.3468, 900.4309, 1029.4735, 1158.5161, 1259.5638, 1372.6478, 1486.6908, 1601.7177, 1714.8018, 1861.8702, 1948.9022, 2108.9329, 2295.0122, 2451.1133, 2548.1660, 2619.2032, 2716.2559, 2773.2774, 2904.3179, 2975.3550, 3072.4077, 3171.4762, 3334.5395, 3497.6028, 3598.6505, 3729.6910, 3860.7315, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 278.1533, 409.1938, 510.2415, 673.3048, 836.3681, 935.4365, 1032.4893, 1103.5264, 1234.5669, 1291.5883, 1388.6411, 1459.6782, 1556.7310, 1712.8321, 1898.9114, 2058.9421, 2145.9741, 2293.0425, 2406.1266, 2521.1535, 2635.1964, 2748.2805, 2849.3282, 2978.3708, 3107.4134, 3220.4974, 3349.5400, 3436.5721, 3565.6146, 3664.6831, 3763.7515, 3892.7941, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SLHHQNQQSIPTSQELHGHCDLLHQLPQQQQNLR", {88.0393, 201.1234, 338.1823, 475.2412, 603.2998, 717.3427, 845.4013, 973.4599, 1060.4919, 1173.5759, 1270.6287, 1371.6764, 1458.7084, 1586.7670, 1715.8096, 1828.8937, 1965.9526, 2022.9740, 2160.0329, 2320.0636, 2435.0905, 2548.1746, 2661.2587, 2798.3176, 2926.3761, 3039.4602, 3136.5130, 3264.5716, 3392.6301, 3520.6887, 3648.7473, 3762.7902, 3875.8743, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 402.2459, 530.3045, 658.3631, 786.4217, 914.4803, 1011.5330, 1124.6171, 1252.6757, 1389.7346, 1502.8186, 1615.9027, 1730.9296, 1890.9603, 2028.0192, 2085.0407, 2222.0996, 2335.1836, 2464.2262, 2592.2848, 2679.3168, 2780.3645, 2877.4173, 2990.5013, 3077.5334, 3205.5920, 3333.6505, 3447.6935, 3575.7520, 3712.8109, 3849.8699, 3962.9539, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YVAYTLYGPYLFWPWKPALLQIASNYGEVLEQVR", {164.0706, 263.1390, 334.1761, 497.2395, 598.2871, 711.3712, 874.4345, 931.4560, 1028.5088, 1191.5721, 1304.6562, 1451.7246, 1637.8039, 1734.8566, 1920.9360, 2049.0309, 2146.0837, 2217.1208, 2330.2049, 2443.2889, 2571.3475, 2684.4316, 2755.4687, 2842.5007, 2956.5436, 3119.6070, 3176.6284, 3305.6710, 3404.7394, 3517.8235, 3646.8661, 3774.9247, 3873.9931, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 274.1874, 402.2459, 531.2885, 644.3726, 743.4410, 872.4836, 929.5051, 1092.5684, 1206.6113, 1293.6434, 1364.6805, 1477.7645, 1605.8231, 1718.9072, 1831.9912, 1903.0284, 2000.0811, 2128.1761, 2314.2554, 2411.3082, 2597.3875, 2744.4559, 2857.5399, 3020.6033, 3117.6560, 3174.6775, 3337.7408, 3450.8249, 3551.8726, 3714.9359, 3785.9730, 3885.0414, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LYVTSPCDIPAMVQSICNLLYIMFNACVTPSWDK", {114.0913, 277.1547, 376.2231, 477.2708, 564.3028, 661.3556, 821.3862, 936.4131, 1049.4972, 1146.5500, 1217.5871, 1348.6276, 1447.6960, 1575.7546, 1662.7866, 1775.8707, 1935.9013, 2049.9442, 2163.0283, 2276.1124, 2439.1757, 2552.2598, 2683.3002, 2830.3687, 2944.4116, 3015.4487, 3175.4793, 3274.5478, 3375.5954, 3472.6482, 3559.6802, 3745.7595, 3860.7865, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 262.1397, 448.2191, 535.2511, 632.3039, 733.3515, 832.4199, 992.4506, 1063.4877, 1177.5306, 1324.5990, 1455.6395, 1568.7236, 1731.7869, 1844.8710, 1957.9551, 2071.9980, 2232.0286, 2345.1127, 2432.1447, 2560.2033, 2659.2717, 2790.3122, 2861.3493, 2958.4021, 3071.4861, 3186.5131, 3346.5437, 3443.5965, 3530.6285, 3631.6762, 3730.7446, 3893.8079, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"CLSSSIIEFGAFFFLLCQALLDDATFESYYLEDK", {161.0379, 274.1220, 361.1540, 448.1860, 535.2181, 648.3021, 761.3862, 890.4288, 1037.4972, 1094.5187, 1165.5558, 1312.6242, 1459.6926, 1606.7610, 1719.8451, 1832.9292, 1992.9598, 2121.0184, 2192.0555, 2305.1396, 2418.2236, 2533.2506, 2648.2775, 2719.3146, 2820.3623, 2967.4307, 3096.4733, 3183.5053, 3346.5687, 3509.6320, 3622.7161, 3751.7587, 3866.7856, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 262.1397, 391.1823, 504.2664, 667.3297, 830.3931, 917.4251, 1046.4677, 1193.5361, 1294.5838, 1365.6209, 1480.6478, 1595.6748, 1708.7588, 1821.8429, 1892.8800, 2020.9386, 2180.9692, 2294.0533, 2407.1374, 2554.2058, 2701.2742, 2848.3426, 2919.3797, 2976.4012, 3123.4696, 3252.5122, 3365.5963, 3478.6803, 3565.7124, 3652.7444, 3739.7764, 3852.8605, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MELEISADQSLELQEQIHIVGEESCSQILDYMIR", {132.0478, 261.0904, 374.1744, 503.2170, 616.3011, 703.3331, 774.3702, 889.3972, 1017.4557, 1104.4878, 1217.5718, 1346.6144, 1459.6985, 1587.7571, 1716.7997, 1844.8582, 1957.9423, 2095.0012, 2208.0853, 2307.1537, 2364.1752, 2493.2177, 2622.2603, 2709.2924, 2869.3230, 2956.3550, 3084.4136, 3197.4977, 3310.5818, 3425.6087, 3588.6720, 3719.7125, 3832.7966, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 419.2435, 582.3068, 697.3338, 810.4178, 923.5019, 1051.5605, 1138.5925, 1298.6232, 1385.6552, 1514.6978, 1643.7404, 1700.7618, 1799.8302, 1912.9143, 2049.9732, 2163.0573, 2291.1159, 2420.1585, 2548.2170, 2661.3011, 2790.3437, 2903.4278, 2990.4598, 3118.5184, 3233.5453, 3304.5824, 3391.6144, 3504.6985, 3633.7411, 3746.8252, 3875.8678, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EWPEFTISADPVIEWTEPSILVMEFQSGIPYIFR", {130.0499, 316.1292, 413.1819, 542.2245, 689.2930, 790.3406, 903.4247, 990.4567, 1061.4938, 1176.5208, 1273.5735, 1372.6420, 1485.7260, 1614.7686, 1800.8479, 1901.8956, 2030.9382, 2127.9910, 2215.0230, 2328.1071, 2441.1911, 2540.2595, 2671.3000, 2800.3426, 2947.4110, 3075.4696, 3162.5016, 3219.5231, 3332.6072, 3429.6599, 3592.7233, 3705.8073, 3852.8757, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 435.2714, 598.3348, 695.3875, 808.4716, 865.4931, 952.5251, 1080.5837, 1227.6521, 1356.6947, 1487.7351, 1586.8036, 1699.8876, 1812.9717, 1900.0037, 1997.0565, 2126.0991, 2227.1468, 2413.2261, 2542.2687, 2655.3527, 2754.4211, 2851.4739, 2966.5008, 3037.5380, 3124.5700, 3237.6541, 3338.7017, 3485.7701, 3614.8127, 3711.8655, 3897.9448, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"GVDWYHSQVYTYPFPLTYQCWPSGESGQGSLLYK", {58.0287, 157.0972, 272.1241, 458.2034, 621.2667, 758.3257, 845.3577, 973.4163, 1072.4847, 1235.5480, 1336.5957, 1499.6590, 1596.7118, 1743.7802, 1840.8329, 1953.9170, 2054.9647, 2218.0280, 2346.0866, 2506.1172, 2692.1966, 2789.2493, 2876.2814, 2933.3028, 3062.3454, 3149.3774, 3206.3989, 3334.4575, 3391.4789, 3478.5110, 3591.5950, 3704.6791, 3867.7424, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 310.1761, 423.2602, 536.3443, 623.3763, 680.3978, 808.4563, 865.4778, 952.5098, 1081.5524, 1138.5739, 1225.6059, 1322.6587, 1508.7380, 1668.7686, 1796.8272, 1959.8905, 2060.9382, 2174.0223, 2271.0750, 2418.1435, 2515.1962, 2678.2596, 2779.3072, 2942.3706, 3041.4390, 3169.4976, 3256.5296, 3393.5885, 3556.6518, 3742.7311, 3857.7581, 3956.8265, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LWGGNDILWYVLDDEIIEALGDILCQLYDFHGQR", {114.0913, 300.1707, 357.1921, 414.2136, 528.2565, 643.2835, 756.3675, 869.4516, 1055.5309, 1218.5942, 1317.6626, 1430.7467, 1545.7736, 1660.8006, 1789.8432, 1902.9272, 2016.0113, 2145.0539, 2216.0910, 2329.1751, 2386.1965, 2501.2235, 2614.3075, 2727.3916, 2887.4223, 3015.4808, 3128.5649, 3291.6282, 3406.6552, 3553.7236, 3690.7825, 3747.8040, 3875.8625, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 360.1990, 497.2579, 644.3263, 759.3533, 922.4166, 1035.5007, 1163.5592, 1323.5899, 1436.6739, 1549.7580, 1664.7850, 1721.8064, 1834.8905, 1905.9276, 2034.9702, 2148.0543, 2261.1383, 2390.1809, 2505.2079, 2620.2348, 2733.3189, 2832.3873, 2995.4506, 3181.5299, 3294.6140, 3407.6980, 3522.7250, 3636.7679, 3693.7894, 3750.8108, 3936.8902, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SLHSIYGTLFGIPQYFTSCFNLAFSWLVYAVFFK", {88.0393, 201.1234, 338.1823, 425.2143, 538.2984, 701.3617, 758.3832, 859.4308, 972.5149, 1119.5833, 1176.6048, 1289.6888, 1386.7416, 1514.8002, 1677.8635, 1824.9319, 1925.9796, 2013.0116, 2173.0423, 2320.1107, 2434.1536, 2547.2377, 2618.2748, 2765.3432, 2852.3753, 3038.4546, 3151.5386, 3250.6070, 3413.6704, 3484.7075, 3583.7759, 3730.8443, 3877.9127, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 294.1812, 441.2496, 540.3180, 611.3552, 774.4185, 873.4869, 986.5710, 1172.6503, 1259.6823, 1406.7507, 1477.7878, 1590.8719, 1704.9148, 1851.9832, 2012.0139, 2099.0459, 2200.0936, 2347.1620, 2510.2253, 2638.2839, 2735.3367, 2848.4207, 2905.4422, 3052.5106, 3165.5947, 3266.6424, 3323.6638, 3486.7272, 3599.8112, 3686.8432, 3823.9022, 3936.9862, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FIDINVAPCEDIIMIGHQDAFQMSEESYPYHSTR", {148.0757, 261.1598, 376.1867, 489.2708, 603.3137, 702.3821, 773.4192, 870.4720, 1030.5026, 1159.5452, 1274.5722, 1387.6562, 1500.7403, 1631.7808, 1744.8648, 1801.8863, 1938.9452, 2067.0038, 2182.0307, 2253.0679, 2400.1363, 2528.1948, 2659.2353, 2746.2674, 2875.3099, 3004.3525, 3091.3846, 3254.4479, 3351.5007, 3514.5640, 3651.6229, 3738.6549, 3839.7026, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 276.1666, 363.1987, 500.2576, 663.3209, 760.3737, 923.4370, 1010.4690, 1139.5116, 1268.5542, 1355.5862, 1486.6267, 1614.6853, 1761.7537, 1832.7908, 1947.8178, 2075.8763, 2212.9353, 2269.9567, 2383.0408, 2514.0813, 2627.1653, 2740.2494, 2855.2763, 2984.3189, 3144.3496, 3241.4023, 3312.4395, 3411.5079, 3525.5508, 3638.6349, 3753.6618, 3866.7459, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EFQLNYLYGPDSHMLYPWWPTANPVLLTGHYVAK", {130.0499, 277.1183, 405.1769, 518.2609, 632.3039, 795.3672, 908.4512, 1071.5146, 1128.5360, 1225.5888, 1340.6157, 1427.6478, 1564.7067, 1695.7472, 1808.8312, 1971.8946, 2068.9473, 2255.0266, 2441.1060, 2538.1587, 2639.2064, 2710.2435, 2824.2864, 2921.3392, 3020.4076, 3133.4917, 3246.5757, 3347.6234, 3404.6449, 3541.7038, 3704.7671, 3803.8355, 3874.8727, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 218.1499, 317.2183, 480.2817, 617.3406, 674.3620, 775.4097, 888.4938, 1001.5778, 1100.6463, 1197.6990, 1311.7419, 1382.7791, 1483.8267, 1580.8795, 1766.9588, 1953.0381, 2050.0909, 2213.1542, 2326.2383, 2457.2788, 2594.3377, 2681.3697, 2796.3967, 2893.4494, 2950.4709, 3113.5342, 3226.6183, 3389.6816, 3503.7245, 3616.8086, 3744.8672, 3891.9356, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"IPDCGYYYAFMIIGTFCTFSMILLFGVGAMLLCR", {114.0913, 211.1441, 326.1710, 486.2017, 543.2232, 706.2865, 869.3498, 1032.4131, 1103.4503, 1250.5187, 1381.5592, 1494.6432, 1607.7273, 1664.7487, 1765.7964, 1912.8648, 2072.8955, 2173.9432, 2321.0116, 2408.0436, 2539.0841, 2652.1682, 2765.2522, 2878.3363, 3025.4047, 3082.4262, 3181.4946, 3238.5160, 3309.5532, 3440.5936, 3553.6777, 3666.7618, 3826.7924, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 335.1496, 448.2337, 561.3177, 692.3582, 763.3953, 820.4168, 919.4852, 976.5067, 1123.5751, 1236.6591, 1349.7432, 1462.8273, 1593.8678, 1680.8998, 1827.9682, 1929.0159, 2089.0465, 2236.1149, 2337.1626, 2394.1841, 2507.2681, 2620.3522, 2751.3927, 2898.4611, 2969.4982, 3132.5616, 3295.6249, 3458.6882, 3515.7097, 3675.7403, 3790.7673, 3887.8200, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"APTQDAQLWFSVWSITVIMISPLFYDIVYYGVER", {72.0444, 169.0972, 270.1448, 398.2034, 513.2304, 584.2675, 712.3260, 825.4101, 1011.4894, 1158.5578, 1245.5899, 1344.6583, 1530.7376, 1617.7696, 1730.8537, 1831.9014, 1930.9698, 2044.0538, 2175.0943, 2288.1784, 2375.2104, 2472.2632, 2585.3472, 2732.4157, 2895.4790, 3010.5059, 3123.5900, 3222.6584, 3385.7217, 3548.7851, 3605.8065, 3704.8749, 3833.9175, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 403.2300, 460.2514, 623.3148, 786.3781, 885.4465, 998.5306, 1113.5575, 1276.6208, 1423.6892, 1536.7733, 1633.8261, 1720.8581, 1833.9422, 1964.9826, 2078.0667, 2177.1351, 2278.1828, 2391.2669, 2478.2989, 2664.3782, 2763.4466, 2850.4787, 2997.5471, 3183.6264, 3296.7104, 3424.7690, 3495.8061, 3610.8331, 3738.8917, 3839.9393, 3936.9921, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PHTHHPHHHQTMPLMQDMFYQDIEKPDIDAAAPK", {98.0600, 235.1190, 336.1666, 473.2255, 610.2845, 707.3372, 844.3961, 981.4550, 1118.5140, 1246.5725, 1347.6202, 1478.6607, 1575.7135, 1688.7975, 1819.8380, 1947.8966, 2062.9235, 2193.9640, 2341.0324, 2504.0958, 2632.1543, 2747.1813, 2860.2653, 2989.3079, 3117.4029, 3214.4557, 3329.4826, 3442.5667, 3557.5936, 3628.6307, 3699.6678, 3770.7050, 3867.7577, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 244.1656, 315.2027, 386.2398, 457.2769, 572.3039, 685.3879, 800.4149, 897.4676, 1025.5626, 1154.6052, 1267.6892, 1382.7162, 1510.7748, 1673.8381, 1820.9065, 1951.9470, 2066.9739, 2195.0325, 2326.0730, 2439.1571, 2536.2098, 2667.2503, 2768.2980, 2896.3566, 3033.4155, 3170.4744, 3307.5333, 3404.5861, 3541.6450, 3678.7039, 3779.7516, 3916.8105, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EQYEPHCGLLFLTWSIAASTTDHGEFMFTDVEER", {130.0499, 258.1084, 421.1718, 550.2144, 647.2671, 784.3260, 944.3567, 1001.3782, 1114.4622, 1227.5463, 1374.6147, 1487.6988, 1588.7464, 1774.8258, 1861.8578, 1974.9418, 2045.9790, 2117.0161, 2204.0481, 2305.0958, 2406.1435, 2521.1704, 2658.2293, 2715.2508, 2844.2934, 2991.3618, 3122.4023, 3269.4707, 3370.5184, 3485.5453, 3584.6137, 3713.6563, 3842.6989, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 433.2041, 532.2726, 647.2995, 748.3472, 895.4156, 1026.4561, 1173.5245, 1302.5671, 1359.5885, 1496.6475, 1611.6744, 1712.7221, 1813.7698, 1900.8018, 1971.8389, 2042.8760, 2155.9601, 2242.9921, 2429.0714, 2530.1191, 2643.2032, 2790.2716, 2903.3556, 3016.4397, 3073.4612, 3233.4918, 3370.5507, 3467.6035, 3596.6461, 3759.7094, 3887.7680, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NLIFDLIPWNLDFLGSCVEQTSIAFYDCMGLMLK", {115.0502, 228.1343, 341.2183, 488.2867, 603.3137, 716.3978, 829.4818, 926.5346, 1112.6139, 1226.6568, 1339.7409, 1454.7678, 1601.8362, 1714.9203, 1771.9418, 1858.9738, 2019.0044, 2118.0729, 2247.1155, 2375.1740, 2476.2217, 2563.2537, 2676.3378, 2747.3749, 2894.4433, 3057.5067, 3172.5336, 3332.5643, 3463.6047, 3520.6262, 3633.7103, 3764.7507, 3877.8348, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 391.2374, 504.3214, 561.3429, 692.3834, 852.4140, 967.4410, 1130.5043, 1277.5727, 1348.6098, 1461.6939, 1548.7259, 1649.7736, 1777.8322, 1906.8748, 2005.9432, 2165.9738, 2253.0058, 2310.0273, 2423.1114, 2570.1798, 2685.2067, 2798.2908, 2912.3337, 3098.4130, 3195.4658, 3308.5499, 3421.6339, 3536.6609, 3683.7293, 3796.8133, 3909.8974, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YAYLVPNVASNLHSLIICFLTLKPHVYCDPCFAK", {164.0706, 235.1077, 398.1710, 511.2551, 610.3235, 707.3763, 821.4192, 920.4876, 991.5247, 1078.5568, 1192.5997, 1305.6838, 1442.7427, 1529.7747, 1642.8588, 1755.9428, 1869.0269, 2029.0575, 2176.1260, 2289.2100, 2390.2577, 2503.3418, 2631.4367, 2728.4895, 2865.5484, 2964.6168, 3127.6801, 3287.7108, 3402.7377, 3499.7905, 3659.8212, 3806.8896, 3877.9267, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 218.1499, 365.2183, 525.2490, 622.3017, 737.3287, 897.3593, 1060.4227, 1159.4911, 1296.5500, 1393.6028, 1521.6977, 1634.7818, 1735.8295, 1848.9135, 1995.9819, 2156.0126, 2269.0967, 2382.1807, 2495.2648, 2582.2968, 2719.3557, 2832.4398, 2946.4827, 3033.5147, 3104.5519, 3203.6203, 3317.6632, 3414.7160, 3513.7844, 3626.8684, 3789.9318, 3860.9689, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"AFVIGVMFAQIFVGTICQICMTFIAEPCEETVYR", {72.0444, 219.1128, 318.1812, 431.2653, 488.2867, 587.3552, 718.3956, 865.4641, 936.5012, 1064.5597, 1177.6438, 1324.7122, 1423.7806, 1480.8021, 1581.8498, 1694.9338, 1854.9645, 1983.0231, 2096.1071, 2256.1378, 2387.1783, 2488.2259, 2635.2944, 2748.3784, 2819.4155, 2948.4581, 3045.5109, 3205.5415, 3334.5841, 3463.6267, 3564.6744, 3663.7428, 3826.8062, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 437.2507, 538.2984, 667.3410, 796.3836, 956.4142, 1053.4670, 1182.5096, 1253.5467, 1366.6307, 1513.6992, 1614.7468, 1745.7873, 1905.8180, 2018.9020, 2146.9606, 2306.9913, 2420.0753, 2521.1230, 2578.1445, 2677.2129, 2824.2813, 2937.3654, 3065.4239, 3136.4610, 3283.5295, 3414.5699, 3513.6384, 3570.6598, 3683.7439, 3782.8123, 3929.8807, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"AAEEDFELESDEEEDSYEEYIQGDDFEGFNMEVK", {72.0444, 143.0815, 272.1241, 401.1667, 516.1936, 663.2620, 792.3046, 905.3887, 1034.4313, 1121.4633, 1236.4903, 1365.5329, 1494.5755, 1623.6180, 1738.6450, 1825.6770, 1988.7403, 2117.7829, 2246.8255, 2409.8889, 2522.9729, 2651.0315, 2708.0530, 2823.0799, 2938.1069, 3085.1753, 3214.2179, 3271.2393, 3418.3077, 3532.3507, 3663.3912, 3792.4337, 3891.5022, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 246.1812, 375.2238, 506.2643, 620.3072, 767.3756, 824.3971, 953.4397, 1100.5081, 1215.5351, 1330.5620, 1387.5835, 1515.6420, 1628.7261, 1791.7894, 1920.8320, 2049.8746, 2212.9379, 2299.9700, 2414.9969, 2544.0395, 2673.0821, 2802.1247, 2917.1516, 3004.1837, 3133.2263, 3246.3103, 3375.3529, 3522.4213, 3637.4483, 3766.4909, 3895.5335, 3966.5706, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QDQEVPPSYVCNSPECEVLAELLQNLYADEIYVR", {129.0659, 244.0928, 372.1514, 501.1940, 600.2624, 697.3151, 794.3679, 881.3999, 1044.4633, 1143.5317, 1303.5623, 1417.6053, 1504.6373, 1601.6900, 1730.7326, 1890.7633, 2019.8059, 2118.8743, 2231.9584, 2302.9955, 2432.0381, 2545.1221, 2658.2062, 2786.2648, 2900.3077, 3013.3918, 3176.4551, 3247.4922, 3362.5192, 3491.5617, 3604.6458, 3767.7091, 3866.7776, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 274.1874, 437.2507, 550.3348, 679.3774, 794.4043, 865.4414, 1028.5047, 1141.5888, 1255.6317, 1383.6903, 1496.7744, 1609.8584, 1738.9010, 1809.9381, 1923.0222, 2022.0906, 2151.1332, 2311.1639, 2440.2065, 2537.2592, 2624.2912, 2738.3342, 2898.3648, 2997.4332, 3160.4966, 3247.5286, 3344.5814, 3441.6341, 3540.7025, 3669.7451, 3797.8037, 3912.8306, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FHNWPCVAVAPFDIHYVPLQTTEILSVLLQESHR", {148.0757, 285.1346, 399.1775, 585.2568, 682.3096, 842.3403, 941.4087, 1012.4458, 1111.5142, 1182.5513, 1279.6041, 1426.6725, 1541.6994, 1654.7835, 1791.8424, 1954.9057, 2053.9741, 2151.0269, 2264.1110, 2392.1696, 2493.2172, 2594.2649, 2723.3075, 2836.3916, 2949.4756, 3036.5077, 3135.5761, 3248.6601, 3361.7442, 3489.8028, 3618.8454, 3705.8774, 3842.9363, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 312.1779, 399.2099, 528.2525, 656.3111, 769.3951, 882.4792, 981.5476, 1068.5796, 1181.6637, 1294.7478, 1423.7904, 1524.8380, 1625.8857, 1753.9443, 1867.0284, 1964.0811, 2063.1495, 2226.2129, 2363.2718, 2476.3558, 2591.3828, 2738.4512, 2835.5040, 2906.5411, 3005.6095, 3076.6466, 3175.7150, 3335.7457, 3432.7984, 3618.8777, 3732.9207, 3869.9796, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"HSFDNLSYAVLYTSMPLSEEFSTWVYDPISEHPR", {138.0662, 225.0982, 372.1666, 487.1936, 601.2365, 714.3206, 801.3526, 964.4159, 1035.4530, 1134.5215, 1247.6055, 1410.6688, 1511.7165, 1598.7485, 1729.7890, 1826.8418, 1939.9259, 2026.9579, 2156.0005, 2285.0431, 2432.1115, 2519.1435, 2620.1912, 2806.2705, 2905.3389, 3068.4023, 3183.4292, 3280.4820, 3393.5660, 3480.5981, 3609.6406, 3746.6996, 3843.7523, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 272.1717, 409.2306, 538.2732, 625.3052, 738.3893, 835.4421, 950.4690, 1113.5323, 1212.6008, 1398.6801, 1499.7278, 1586.7598, 1733.8282, 1862.8708, 1991.9134, 2078.9454, 2192.0295, 2289.0822, 2420.1227, 2507.1548, 2608.2024, 2771.2658, 2884.3498, 2983.4182, 3054.4554, 3217.5187, 3304.5507, 3417.6348, 3531.6777, 3646.7046, 3793.7731, 3880.8051, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YLPSMCEMDYMDAENTMNSALQHESLDPLVQSHR", {164.0706, 277.1547, 374.2074, 461.2395, 592.2799, 752.3106, 881.3532, 1012.3937, 1127.4206, 1290.4839, 1421.5244, 1536.5514, 1607.5885, 1736.6311, 1850.6740, 1951.7217, 2082.7622, 2196.8051, 2283.8371, 2354.8742, 2467.9583, 2596.0169, 2733.0758, 2862.1184, 2949.1504, 3062.2345, 3177.2614, 3274.3142, 3387.3982, 3486.4667, 3614.5252, 3701.5573, 3838.6162, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 312.1779, 399.2099, 527.2685, 626.3369, 739.4209, 836.4737, 951.5007, 1064.5847, 1151.6167, 1280.6593, 1417.7183, 1545.7768, 1658.8609, 1729.8980, 1816.9300, 1930.9730, 2062.0134, 2163.0611, 2277.1041, 2406.1466, 2477.1838, 2592.2107, 2723.2512, 2886.3145, 3001.3415, 3132.3819, 3261.4245, 3421.4552, 3552.4957, 3639.5277, 3736.5805, 3849.6645, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YPEFWSNDEISLDELDLLHLEISYFISKPTDGVR", {164.0706, 261.1234, 390.1660, 537.2344, 723.3137, 810.3457, 924.3886, 1039.4156, 1168.4582, 1281.5422, 1368.5743, 1481.6583, 1596.6853, 1725.7279, 1838.8119, 1953.8389, 2066.9229, 2180.0070, 2317.0659, 2430.1500, 2559.1926, 2672.2766, 2759.3087, 2922.3720, 3069.4404, 3182.5245, 3269.5565, 3397.6515, 3494.7042, 3595.7519, 3710.7789, 3767.8003, 3866.8687, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 274.1874, 331.2088, 446.2358, 547.2835, 644.3362, 772.4312, 859.4632, 972.5473, 1119.6157, 1282.6790, 1369.7110, 1482.7951, 1611.8377, 1724.9218, 1861.9807, 1975.0647, 2088.1488, 2203.1757, 2316.2598, 2445.3024, 2560.3293, 2673.4134, 2760.4454, 2873.5295, 3002.5721, 3117.5990, 3231.6420, 3318.6740, 3504.7533, 3651.8217, 3780.8643, 3877.9171, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LMANVDCYNPDLTDEPLLPPSFFEFFSPEQNETK", {114.0913, 245.1318, 316.1689, 430.2119, 529.2803, 644.3072, 804.3379, 967.4012, 1081.4441, 1178.4969, 1293.5238, 1406.6079, 1507.6556, 1622.6825, 1751.7251, 1848.7779, 1961.8619, 2074.9460, 2171.9988, 2269.0515, 2356.0836, 2503.1520, 2650.2204, 2779.2630, 2926.3314, 3073.3998, 3160.4318, 3257.4846, 3386.5272, 3514.5858, 3628.6287, 3757.6713, 3858.7190, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 248.1605, 377.2031, 491.2460, 619.3046, 748.3472, 845.3999, 932.4320, 1079.5004, 1226.5688, 1355.6114, 1502.6798, 1649.7482, 1736.7802, 1833.8330, 1930.8858, 2043.9698, 2157.0539, 2254.1067, 2383.1493, 2498.1762, 2599.2239, 2712.3079, 2827.3349, 2924.3876, 3038.4306, 3201.4939, 3361.5246, 3476.5515, 3575.6199, 3689.6628, 3760.7000, 3891.7404, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FYIYEVSELGYPQLQGINEINEYGIFAAIYHINK", {148.0757, 311.1390, 424.2231, 587.2864, 716.3290, 815.3974, 902.4294, 1031.4720, 1144.5561, 1201.5776, 1364.6409, 1461.6937, 1589.7522, 1702.8363, 1830.8949, 1887.9163, 2001.0004, 2115.0433, 2244.0859, 2357.1700, 2471.2129, 2600.2555, 2763.3188, 2820.3403, 2933.4244, 3080.4928, 3151.5299, 3222.5670, 3335.6511, 3498.7144, 3635.7733, 3748.8574, 3862.9003, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 261.1557, 374.2398, 511.2987, 674.3620, 787.4461, 858.4832, 929.5203, 1076.5887, 1189.6728, 1246.6943, 1409.7576, 1538.8002, 1652.8431, 1765.9272, 1894.9698, 2009.0127, 2122.0968, 2179.1182, 2307.1768, 2420.2609, 2548.3195, 2645.3722, 2808.4355, 2865.4570, 2978.5411, 3107.5837, 3194.6157, 3293.6841, 3422.7267, 3585.7900, 3698.8741, 3861.9374, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EEPVVITGDVEFLVHGFLQTVEVLQQFQEMDEYR", {130.0499, 259.0925, 356.1452, 455.2136, 554.2821, 667.3661, 768.4138, 825.4353, 940.4622, 1039.5306, 1168.5732, 1315.6416, 1428.7257, 1527.7941, 1664.8530, 1721.8745, 1868.9429, 1982.0270, 2110.0855, 2211.1332, 2310.2016, 2439.2442, 2538.3126, 2651.3967, 2779.4553, 2907.5139, 3054.5823, 3182.6408, 3311.6834, 3442.7239, 3557.7509, 3686.7935, 3849.8568, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 467.2249, 582.2518, 713.2923, 842.3349, 970.3935, 1117.4619, 1245.5205, 1373.5790, 1486.6631, 1585.7315, 1714.7741, 1813.8425, 1914.8902, 2042.9488, 2156.0328, 2303.1013, 2360.1227, 2497.1816, 2596.2500, 2709.3341, 2856.4025, 2985.4451, 3084.5135, 3199.5405, 3256.5619, 3357.6096, 3470.6937, 3569.7621, 3668.8305, 3765.8833, 3894.9259, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LEQAEMWQEAVDMDVWESTGDEQPVYWGNEGHVR", {114.0913, 243.1339, 371.1925, 442.2296, 571.2722, 702.3127, 888.3920, 1016.4506, 1145.4932, 1216.5303, 1315.5987, 1430.6257, 1561.6661, 1676.6931, 1775.7615, 1961.8408, 2090.8834, 2177.9154, 2278.9631, 2335.9846, 2451.0115, 2580.0541, 2708.1127, 2805.1655, 2904.2339, 3067.2972, 3253.3765, 3310.3980, 3424.4409, 3553.4835, 3610.5050, 3747.5639, 3846.6323, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 274.1874, 411.2463, 468.2677, 597.3103, 711.3533, 768.3747, 954.4540, 1117.5174, 1216.5858, 1313.6385, 1441.6971, 1570.7397, 1685.7667, 1742.7881, 1843.8358, 1930.8678, 2059.9104, 2245.9897, 2345.0581, 2460.0851, 2591.1256, 2706.1525, 2805.2209, 2876.2580, 3005.3006, 3133.3592, 3319.4385, 3450.4790, 3579.5216, 3650.5587, 3778.6173, 3907.6599, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SCMYILYATICGICGECYTGCSGEEAEAYFENLR", {88.0393, 248.0700, 379.1104, 542.1738, 655.2578, 768.3419, 931.4052, 1002.4423, 1103.4900, 1216.5741, 1376.6047, 1433.6262, 1546.7103, 1706.7409, 1763.7624, 1892.8050, 2052.8356, 2215.8989, 2316.9466, 2373.9681, 2533.9987, 2621.0308, 2678.0522, 2807.0948, 2936.1374, 3007.1745, 3136.2171, 3207.2542, 3370.3176, 3517.3860, 3646.4286, 3760.4715, 3873.5556, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 402.2459, 531.2885, 678.3570, 841.4203, 912.4574, 1041.5000, 1112.5371, 1241.5797, 1370.6223, 1427.6438, 1514.6758, 1674.7064, 1731.7279, 1832.7756, 1995.8389, 2155.8695, 2284.9121, 2341.9336, 2501.9643, 2615.0483, 2672.0698, 2832.1004, 2945.1845, 3046.2322, 3117.2693, 3280.3326, 3393.4167, 3506.5007, 3669.5641, 3800.6046, 3960.6352, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ELVEVLEGQTINENSVCYQYTYDMIEIAVQQGNR", {130.0499, 243.1339, 342.2023, 471.2449, 570.3134, 683.3974, 812.4400, 869.4615, 997.5201, 1098.5677, 1211.6518, 1325.6947, 1454.7373, 1568.7802, 1655.8123, 1754.8807, 1914.9113, 2077.9747, 2206.0332, 2369.0966, 2470.1442, 2633.2076, 2748.2345, 2879.2750, 2992.3591, 3121.4017, 3234.4857, 3305.5228, 3404.5913, 3532.6498, 3660.7084, 3717.7299, 3831.7728, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 289.1619, 346.1833, 474.2419, 602.3005, 701.3689, 772.4060, 885.4901, 1014.5327, 1127.6167, 1258.6572, 1373.6842, 1536.7475, 1637.7952, 1800.8585, 1928.9171, 2091.9804, 2252.0111, 2351.0795, 2438.1115, 2552.1544, 2681.1970, 2795.2400, 2908.3240, 3009.3717, 3137.4303, 3194.4517, 3323.4943, 3436.5784, 3535.6468, 3664.6894, 3763.7578, 3876.8419, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PDCDYYTAYCVLGVYVCGMYLLVLGISFTFLTQK", {98.0600, 213.0870, 373.1176, 488.1446, 651.2079, 814.2712, 915.3189, 986.3560, 1149.4194, 1309.4500, 1408.5184, 1521.6025, 1578.6239, 1677.6924, 1840.7557, 1939.8241, 2099.8547, 2156.8762, 2287.9167, 2450.9800, 2564.0641, 2677.1482, 2776.2166, 2889.3006, 2946.3221, 3059.4062, 3146.4382, 3293.5066, 3394.5543, 3541.6227, 3654.7068, 3755.7544, 3883.8130, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 275.1714, 376.2191, 489.3031, 636.3715, 737.4192, 884.4876, 971.5197, 1084.6037, 1141.6252, 1254.7093, 1353.7777, 1466.8617, 1579.9458, 1743.0091, 1874.0496, 1931.0711, 2091.1017, 2190.1701, 2353.2335, 2452.3019, 2509.3233, 2622.4074, 2721.4758, 2881.5065, 3044.5698, 3115.6069, 3216.6546, 3379.7179, 3542.7812, 3657.8082, 3817.8388, 3932.8658, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PYLVGIINCLLQACWGFVLYFACFLISGVFINVR", {98.0600, 261.1234, 374.2074, 473.2758, 530.2973, 643.3814, 756.4654, 870.5084, 1030.5390, 1143.6231, 1256.7071, 1384.7657, 1455.8028, 1615.8335, 1801.9128, 1858.9343, 2006.0027, 2105.0711, 2218.1552, 2381.2185, 2528.2869, 2599.3240, 2759.3547, 2906.4231, 3019.5071, 3132.5912, 3219.6232, 3276.6447, 3375.7131, 3522.7815, 3635.8656, 3749.9085, 3848.9769, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 274.1874, 388.2303, 501.3144, 648.3828, 747.4512, 804.4726, 891.5047, 1004.5887, 1117.6728, 1264.7412, 1424.7719, 1495.8090, 1642.8774, 1805.9407, 1919.0248, 2018.0932, 2165.1616, 2222.1831, 2408.2624, 2568.2930, 2639.3302, 2767.3887, 2880.4728, 2993.5569, 3153.5875, 3267.6304, 3380.7145, 3493.7986, 3550.8200, 3649.8884, 3762.9725, 3926.0358, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ELVLSDVSTNTMCGLWWNGLINIVTYIGMFWCLK", {130.0499, 243.1339, 342.2023, 455.2864, 542.3184, 657.3454, 756.4138, 843.4458, 944.4935, 1058.5364, 1159.5841, 1290.6246, 1450.6552, 1507.6767, 1620.7608, 1806.8401, 1992.9194, 2106.9623, 2163.9838, 2277.0679, 2390.1519, 2504.1948, 2617.2789, 2716.3473, 2817.3950, 2980.4583, 3093.5424, 3150.5639, 3281.6043, 3428.6728, 3614.7521, 3774.7827, 3887.8668, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 420.2275, 606.3068, 753.3752, 884.4157, 941.4372, 1054.5213, 1217.5846, 1318.6323, 1417.7007, 1530.7847, 1644.8277, 1757.9117, 1870.9958, 1928.0173, 2042.0602, 2228.1395, 2414.2188, 2527.3029, 2584.3243, 2744.3550, 2875.3955, 2976.4432, 3090.4861, 3191.5338, 3278.5658, 3377.6342, 3492.6611, 3579.6932, 3692.7772, 3791.8457, 3904.9297, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EEMLFEENMDAENEEDEVDDEQETNAETAVFIER", {130.0499, 259.0925, 390.1329, 503.2170, 650.2854, 779.3280, 908.3706, 1022.4135, 1153.4540, 1268.4810, 1339.5181, 1468.5607, 1582.6036, 1711.6462, 1840.6888, 1955.7157, 2084.7583, 2183.8267, 2298.8537, 2413.8806, 2542.9232, 2670.9818, 2800.0244, 2901.0721, 3015.1150, 3086.1521, 3215.1947, 3316.2424, 3387.2795, 3486.3479, 3633.4163, 3746.5004, 3875.5430, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 417.2456, 564.3140, 663.3824, 734.4196, 835.4672, 964.5098, 1035.5469, 1149.5899, 1250.6375, 1379.6801, 1507.7387, 1636.7813, 1751.8082, 1866.8352, 1965.9036, 2094.9462, 2209.9731, 2339.0157, 2468.0583, 2582.1013, 2711.1438, 2782.1810, 2897.2079, 3028.2484, 3142.2913, 3271.3339, 3400.3765, 3547.4449, 3660.5290, 3791.5695, 3920.6121, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NCSVGHMTLCNISCTLTEQDHPGGIQYIMDFNYK", {115.0502, 275.0809, 362.1129, 461.1813, 518.2028, 655.2617, 786.3022, 887.3498, 1000.4339, 1160.4645, 1274.5075, 1387.5915, 1474.6236, 1634.6542, 1735.7019, 1848.7860, 1949.8336, 2078.8762, 2206.9348, 2321.9617, 2459.0207, 2556.0734, 2613.0949, 2670.1164, 2783.2004, 2911.2590, 3074.3223, 3187.4064, 3318.4469, 3433.4738, 3580.5422, 3694.5852, 3857.6485, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 310.1761, 424.2191, 571.2875, 686.3144, 817.3549, 930.4390, 1093.5023, 1221.5609, 1334.6449, 1391.6664, 1448.6879, 1545.7406, 1682.7995, 1797.8265, 1925.8851, 2054.9277, 2155.9753, 2269.0594, 2370.1071, 2530.1377, 2617.1698, 2730.2538, 2844.2967, 3004.3274, 3117.4115, 3218.4591, 3349.4996, 3486.5585, 3543.5800, 3642.6484, 3729.6804, 3889.7111, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YLLPNVASNLPLVFVVLWAYIDDSINYNFFVWIK", {164.0706, 277.1547, 390.2387, 487.2915, 601.3344, 700.4028, 771.4400, 858.4720, 972.5149, 1085.5990, 1182.6517, 1295.7358, 1394.8042, 1541.8726, 1640.9410, 1740.0095, 1853.0935, 2039.1728, 2110.2099, 2273.2733, 2386.3573, 2501.3843, 2616.4112, 2703.4433, 2816.5273, 2930.5702, 3093.6336, 3207.6765, 3354.7449, 3501.8133, 3600.8817, 3786.9611, 3900.0451, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 446.2762, 545.3446, 692.4130, 839.4814, 953.5244, 1116.5877, 1230.6306, 1343.7147, 1430.7467, 1545.7736, 1660.8006, 1773.8846, 1936.9480, 2007.9851, 2194.0644, 2307.1485, 2406.2169, 2505.2853, 2652.3537, 2751.4221, 2864.5062, 2961.5590, 3074.6430, 3188.6859, 3275.7180, 3346.7551, 3445.8235, 3559.8664, 3656.9192, 3770.0033, 3883.0873, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LHFDSIAELFEEEGWASLYCSLANFDQLHGDIYR", {114.0913, 251.1503, 398.2187, 513.2456, 600.2776, 713.3617, 784.3988, 913.4414, 1026.5255, 1173.5939, 1302.6365, 1431.6791, 1560.7217, 1617.7431, 1803.8224, 1874.8596, 1961.8916, 2074.9756, 2238.0390, 2398.0696, 2485.1017, 2598.1857, 2669.2228, 2783.2658, 2930.3342, 3045.3611, 3173.4197, 3286.5038, 3423.5627, 3480.5841, 3595.6111, 3708.6951, 3871.7585, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 451.2663, 566.2933, 623.3148, 760.3737, 873.4577, 1001.5163, 1116.5432, 1263.6117, 1377.6546, 1448.6917, 1561.7758, 1648.8078, 1808.8384, 1971.9018, 2084.9858, 2172.0179, 2243.0550, 2429.1343, 2486.1558, 2615.1983, 2744.2409, 2873.2835, 3020.3519, 3133.4360, 3262.4786, 3333.5157, 3446.5998, 3533.6318, 3648.6588, 3795.7272, 3932.7861, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LLFYILDYAVSTVKPLQLDVFYTEIPEPSEDEYK", {114.0913, 227.1754, 374.2438, 537.3071, 650.3912, 763.4753, 878.5022, 1041.5655, 1112.6027, 1211.6711, 1298.7031, 1399.7508, 1498.8192, 1626.9142, 1723.9669, 1837.0510, 1965.1096, 2078.1936, 2193.2206, 2292.2890, 2439.3574, 2602.4207, 2703.4684, 2832.5110, 2945.5951, 3042.6478, 3171.6904, 3268.7432, 3355.7752, 3484.8178, 3599.8447, 3728.8873, 3891.9507, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 310.1761, 439.2187, 554.2457, 683.2883, 770.3203, 867.3731, 996.4156, 1093.4684, 1206.5525, 1335.5951, 1436.6427, 1599.7061, 1746.7745, 1845.8429, 1960.8698, 2073.9539, 2202.0125, 2315.0966, 2412.1493, 2540.2443, 2639.3127, 2740.3604, 2827.3924, 2926.4608, 2997.4979, 3160.5613, 3275.5882, 3388.6723, 3501.7563, 3664.8197, 3811.8881, 3924.9721, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MLMYISYMLDFALPAVYCGQYDLLMCDEFGGSEK", {132.0478, 245.1318, 376.1723, 539.2356, 652.3197, 739.3517, 902.4151, 1033.4555, 1146.5396, 1261.5666, 1408.6350, 1479.6721, 1592.7561, 1689.8089, 1760.8460, 1859.9144, 2022.9778, 2183.0084, 2240.0299, 2368.0885, 2531.1518, 2646.1787, 2759.2628, 2872.3469, 3003.3873, 3163.4180, 3278.4449, 3407.4875, 3554.5559, 3611.5774, 3668.5989, 3755.6309, 3884.6735, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 276.1554, 363.1874, 420.2089, 477.2304, 624.2988, 753.3414, 868.3683, 1028.3990, 1159.4394, 1272.5235, 1385.6076, 1500.6345, 1663.6978, 1791.7564, 1848.7779, 2008.8085, 2171.8719, 2270.9403, 2341.9774, 2439.0301, 2552.1142, 2623.1513, 2770.2197, 2885.2467, 2998.3307, 3129.3712, 3292.4346, 3379.4666, 3492.5507, 3655.6140, 3786.6545, 3899.7385, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DVQVSTNFFYHLDVAPSSWSCFQFDILTMDLPEK", {116.0342, 215.1026, 343.1612, 442.2296, 529.2617, 630.3093, 744.3523, 891.4207, 1038.4891, 1201.5524, 1338.6113, 1451.6954, 1566.7223, 1665.7907, 1736.8279, 1833.8806, 1920.9127, 2007.9447, 2194.0240, 2281.0560, 2441.0867, 2588.1551, 2716.2137, 2863.2821, 2978.3090, 3091.3931, 3204.4771, 3305.5248, 3436.5653, 3551.5923, 3664.6763, 3761.7291, 3890.7717, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 276.1554, 373.2082, 486.2922, 601.3192, 732.3597, 833.4073, 946.4914, 1059.5755, 1174.6024, 1321.6708, 1449.7294, 1596.7978, 1756.8285, 1843.8605, 2029.9398, 2116.9718, 2204.0039, 2301.0566, 2372.0937, 2471.1621, 2586.1891, 2699.2732, 2836.3321, 2999.3954, 3146.4638, 3293.5322, 3407.5751, 3508.6228, 3595.6549, 3694.7233, 3822.7818, 3921.8503, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DQLSTSFFYHLDIAPSNWVSFQFDIFIANTPHEK", {116.0342, 244.0928, 357.1769, 444.2089, 545.2566, 632.2886, 779.3570, 926.4254, 1089.4888, 1226.5477, 1339.6317, 1454.6587, 1567.7427, 1638.7798, 1735.8326, 1822.8646, 1936.9076, 2122.9869, 2222.0553, 2309.0873, 2456.1557, 2584.2143, 2731.2827, 2846.3097, 2959.3937, 3106.4622, 3219.5462, 3290.5833, 3404.6263, 3505.6739, 3602.7267, 3739.7856, 3868.8282, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 276.1554, 413.2143, 510.2671, 611.3148, 725.3577, 796.3948, 909.4789, 1056.5473, 1169.6313, 1284.6583, 1431.7267, 1559.7853, 1706.8537, 1793.8857, 1892.9541, 2079.0334, 2193.0764, 2280.1084, 2377.1612, 2448.1983, 2561.2823, 2676.3093, 2789.3933, 2926.4523, 3089.5156, 3236.5840, 3383.6524, 3470.6844, 3571.7321, 3658.7641, 3771.8482, 3899.9068, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MHKPSGLWMLPCIVLGVIIAWYCYSFNYQGASMR", {132.0478, 269.1067, 397.2016, 494.2544, 581.2864, 638.3079, 751.3920, 937.4713, 1068.5118, 1181.5958, 1278.6486, 1438.6792, 1551.7633, 1650.8317, 1763.9158, 1820.9372, 1920.0056, 2033.0897, 2146.1738, 2217.2109, 2403.2902, 2566.3535, 2726.3842, 2889.4475, 2976.4795, 3123.5480, 3237.5909, 3400.6542, 3528.7128, 3585.7342, 3656.7714, 3743.8034, 3874.8439, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 306.1594, 393.1915, 464.2286, 521.2500, 649.3086, 812.3719, 926.4149, 1073.4833, 1160.5153, 1323.5786, 1483.6093, 1646.6726, 1832.7519, 1903.7891, 2016.8731, 2129.9572, 2229.0256, 2286.0471, 2399.1311, 2498.1995, 2611.2836, 2771.3142, 2868.3670, 2981.4511, 3112.4916, 3298.5709, 3411.6549, 3468.6764, 3555.7084, 3652.7612, 3780.8562, 3917.9151, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SVTFAAIYALQECEDQCTAAYDLIETYEYDEVLR", {88.0393, 187.1077, 288.1554, 435.2238, 506.2609, 577.2980, 690.3821, 853.4454, 924.4825, 1037.5666, 1165.6252, 1294.6678, 1454.6984, 1583.7410, 1698.7680, 1826.8265, 1986.8572, 2087.9049, 2158.9420, 2229.9791, 2393.0424, 2508.0694, 2621.1534, 2734.2375, 2863.2801, 2964.3278, 3127.3911, 3256.4337, 3419.4970, 3534.5240, 3663.5666, 3762.6350, 3875.7190, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 387.2714, 516.3140, 631.3410, 794.4043, 923.4469, 1086.5102, 1187.5579, 1316.6005, 1429.6846, 1542.7686, 1657.7956, 1820.8589, 1891.8960, 1962.9331, 2063.9808, 2224.0114, 2352.0700, 2467.0970, 2596.1396, 2756.1702, 2885.2128, 3013.2714, 3126.3554, 3197.3926, 3360.4559, 3473.5399, 3544.5771, 3615.6142, 3762.6826, 3863.7303, 3962.7987, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QVLLQQEESQTLNIDAFLLTTEWSQPPTGLFYCR", {129.0659, 228.1343, 341.2183, 454.3024, 582.3610, 710.4196, 839.4621, 968.5047, 1055.5368, 1183.5953, 1284.6430, 1397.7271, 1511.7700, 1624.8541, 1739.8810, 1810.9181, 1957.9865, 2071.0706, 2184.1547, 2285.2024, 2386.2500, 2515.2926, 2701.3719, 2788.4040, 2916.4625, 3013.5153, 3110.5681, 3211.6158, 3268.6372, 3381.7213, 3528.7897, 3691.8530, 3851.8837, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 335.1496, 498.2129, 645.2813, 758.3654, 815.3869, 916.4345, 1013.4873, 1110.5401, 1238.5987, 1325.6307, 1511.7100, 1640.7526, 1741.8003, 1842.8479, 1955.9320, 2069.0161, 2216.0845, 2287.1216, 2402.1485, 2515.2326, 2629.2755, 2742.3596, 2843.4073, 2971.4659, 3058.4979, 3187.5405, 3316.5831, 3444.6416, 3572.7002, 3685.7843, 3798.8684, 3897.9368, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"AGVNYFDDEPDSHQGYFSHYLQYPSQPPPEWMAR", {72.0444, 129.0659, 228.1343, 342.1772, 505.2405, 652.3089, 767.3359, 882.3628, 1011.4054, 1108.4582, 1223.4851, 1310.5172, 1447.5761, 1575.6346, 1632.6561, 1795.7194, 1942.7878, 2029.8199, 2166.8788, 2329.9421, 2443.0262, 2571.0848, 2734.1481, 2831.2009, 2918.2329, 3046.2915, 3143.3442, 3240.3970, 3337.4497, 3466.4923, 3652.5717, 3783.6121, 3854.6493, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 246.1561, 377.1966, 563.2759, 692.3185, 789.3712, 886.4240, 983.4767, 1111.5353, 1198.5674, 1295.6201, 1458.6834, 1586.7420, 1699.8261, 1862.8894, 1999.9483, 2086.9804, 2234.0488, 2397.1121, 2454.1336, 2582.1921, 2719.2511, 2806.2831, 2921.3100, 3018.3628, 3147.4054, 3262.4323, 3377.4593, 3524.5277, 3687.5910, 3801.6339, 3900.7024, 3957.7238, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"IDFTLFILQVYSNDPAAITWECDMGDDYDQNGFR", {114.0913, 229.1183, 376.1867, 477.2344, 590.3184, 737.3869, 850.4709, 963.5550, 1091.6136, 1190.6820, 1353.7453, 1440.7773, 1554.8203, 1669.8472, 1766.9000, 1837.9371, 1908.9742, 2022.0583, 2123.1059, 2309.1852, 2438.2278, 2598.2585, 2713.2854, 2844.3259, 2901.3474, 3016.3743, 3131.4013, 3294.4646, 3409.4915, 3537.5501, 3651.5930, 3708.6145, 3855.6829, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 379.2088, 493.2518, 621.3103, 736.3373, 899.4006, 1014.4275, 1129.4545, 1186.4760, 1317.5164, 1432.5434, 1592.5740, 1721.6166, 1907.6959, 2008.7436, 2121.8277, 2192.8648, 2263.9019, 2360.9547, 2475.9816, 2590.0245, 2677.0566, 2840.1199, 2939.1883, 3067.2469, 3180.3310, 3293.4150, 3440.4834, 3553.5675, 3654.6152, 3801.6836, 3916.7105, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"WQDFWHGGMMVTLVTNEGMDFCCSDFIVGLLPLK", {187.0866, 315.1452, 430.1721, 577.2405, 763.3198, 900.3787, 957.4002, 1014.4217, 1145.4622, 1276.5026, 1375.5711, 1476.6187, 1589.7028, 1688.7712, 1789.8189, 1903.8618, 2032.9044, 2089.9259, 2220.9664, 2335.9933, 2483.0617, 2643.0924, 2803.1230, 2890.1550, 3005.1820, 3152.2504, 3265.3345, 3364.4029, 3421.4243, 3534.5084, 3647.5925, 3744.6452, 3857.7293, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 357.2496, 470.3337, 583.4178, 640.4392, 739.5076, 852.5917, 999.6601, 1114.6871, 1201.7191, 1361.7497, 1521.7804, 1668.8488, 1783.8757, 1914.9162, 1971.9377, 2100.9803, 2215.0232, 2316.0709, 2415.1393, 2528.2234, 2629.2710, 2728.3395, 2859.3799, 2990.4204, 3047.4419, 3104.4634, 3241.5223, 3427.6016, 3574.6700, 3689.6969, 3817.7555, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"HLLFCCFLTSLVLVAGLSNMDNWMHEVTQDLISR", {138.0662, 251.1503, 364.2343, 511.3027, 671.3334, 831.3640, 978.4324, 1091.5165, 1192.5642, 1279.5962, 1392.6803, 1491.7487, 1604.8328, 1703.9012, 1774.9383, 1831.9597, 1945.0438, 2032.0758, 2146.1188, 2277.1593, 2392.1862, 2506.2291, 2692.3084, 2823.3489, 2960.4078, 3089.4504, 3188.5188, 3289.5665, 3417.6251, 3532.6520, 3645.7361, 3758.8202, 3845.8522, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 262.1510, 375.2350, 488.3191, 603.3461, 731.4046, 832.4523, 931.5207, 1060.5633, 1197.6222, 1328.6627, 1514.7420, 1628.7850, 1743.8119, 1874.8524, 1988.8953, 2075.9273, 2189.0114, 2246.0329, 2317.0700, 2416.1384, 2529.2225, 2628.2909, 2741.3749, 2828.4070, 2929.4546, 3042.5387, 3189.6071, 3349.6378, 3509.6684, 3656.7368, 3769.8209, 3882.9050, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"IYNSIYTEWNVQGVSTDFLDQDLLSLQSSMEQFR", {114.0913, 277.1547, 391.1976, 478.2296, 591.3137, 754.3770, 855.4247, 984.4673, 1170.5466, 1284.5895, 1383.6579, 1511.7165, 1568.7380, 1667.8064, 1754.8384, 1855.8861, 1970.9130, 2117.9815, 2231.0655, 2346.0925, 2474.1510, 2589.1780, 2702.2621, 2815.3461, 2902.3781, 3015.4622, 3143.5208, 3230.5528, 3317.5848, 3448.6253, 3577.6679, 3705.7265, 3852.7949, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 450.2459, 579.2885, 710.3290, 797.3610, 884.3931, 1012.4517, 1125.5357, 1212.5677, 1325.6518, 1438.7359, 1553.7628, 1681.8214, 1796.8483, 1909.9324, 2057.0008, 2172.0278, 2273.0754, 2360.1075, 2459.1759, 2516.1973, 2644.2559, 2743.3243, 2857.3673, 3043.4466, 3172.4892, 3273.5368, 3436.6002, 3549.6842, 3636.7163, 3750.7592, 3913.8225, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MDDEYETMFHQQLADVAEDICAIELAEQADICLR", {132.0478, 247.0747, 362.1016, 491.1442, 654.2076, 783.2502, 884.2978, 1015.3383, 1162.4067, 1299.4657, 1427.5242, 1555.5828, 1668.6669, 1739.7040, 1854.7309, 1953.7993, 2024.8365, 2153.8790, 2268.9060, 2381.9901, 2542.0207, 2613.0578, 2726.1419, 2855.1845, 2968.2685, 3039.3057, 3168.3482, 3296.4068, 3367.4439, 3482.4709, 3595.5549, 3755.5856, 3868.6697, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 448.2337, 561.3177, 676.3447, 747.3818, 875.4404, 1004.4830, 1075.5201, 1188.6041, 1317.6467, 1430.7308, 1501.7679, 1661.7986, 1774.8826, 1889.9096, 2018.9522, 2089.9893, 2189.0577, 2304.0846, 2375.1217, 2488.2058, 2616.2644, 2744.3230, 2881.3819, 3028.4503, 3159.4908, 3260.5384, 3389.5810, 3552.6444, 3681.6870, 3796.7139, 3911.7408, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PQWLPTSLFSNALGCYGQICVFVVWCMALPWGVR", {98.0600, 226.1186, 412.1979, 525.2820, 622.3348, 723.3824, 810.4145, 923.4985, 1070.5669, 1157.5990, 1271.6419, 1342.6790, 1455.7631, 1512.7845, 1672.8152, 1835.8785, 1892.9000, 2020.9586, 2134.0426, 2294.0733, 2393.1417, 2540.2101, 2639.2785, 2738.3469, 2924.4262, 3084.4569, 3215.4974, 3286.5345, 3399.6186, 3496.6713, 3682.7506, 3739.7721, 3838.8405, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 274.1874, 331.2088, 517.2881, 614.3409, 727.4250, 798.4621, 929.5026, 1089.5332, 1275.6125, 1374.6809, 1473.7494, 1620.8178, 1719.8862, 1879.9168, 1993.0009, 2121.0595, 2178.0809, 2341.1443, 2501.1749, 2558.1964, 2671.2804, 2742.3176, 2856.3605, 2943.3925, 3090.4609, 3203.5450, 3290.5770, 3391.6247, 3488.6775, 3601.7615, 3787.8408, 3915.8994, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DEEEEDEEEDGEEESDEEEDEEESEEAGDEQEPK", {116.0342, 245.0768, 374.1194, 503.1620, 632.2046, 747.2315, 876.2741, 1005.3167, 1134.3593, 1249.3863, 1306.4077, 1435.4503, 1564.4929, 1693.5355, 1780.5675, 1895.5945, 2024.6371, 2153.6797, 2282.7223, 2397.7492, 2526.7918, 2655.8344, 2784.8770, 2871.9090, 3000.9516, 3129.9942, 3201.0313, 3258.0528, 3373.0797, 3502.1223, 3630.1809, 3759.2235, 3856.2762, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 244.1656, 373.2082, 501.2667, 630.3093, 745.3363, 802.3577, 873.3949, 1002.4374, 1131.4800, 1218.5121, 1347.5547, 1476.5973, 1605.6398, 1720.6668, 1849.7094, 1978.7520, 2107.7946, 2222.8215, 2309.8535, 2438.8961, 2567.9387, 2696.9813, 2754.0028, 2869.0297, 2998.0723, 3127.1149, 3256.1575, 3371.1844, 3500.2270, 3629.2696, 3758.3122, 3887.3548, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LNETEPFDDFIANVNIMDQSLCFQLVESVLFEDR", {114.0913, 228.1343, 357.1769, 458.2245, 587.2671, 684.3199, 831.3883, 946.4153, 1061.4422, 1208.5106, 1321.5947, 1392.6318, 1506.6747, 1605.7431, 1719.7861, 1832.8701, 1963.9106, 2078.9375, 2206.9961, 2294.0282, 2407.1122, 2567.1429, 2714.2113, 2842.2699, 2955.3539, 3054.4223, 3183.4649, 3270.4970, 3369.5654, 3482.6494, 3629.7179, 3758.7604, 3873.7874, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 290.1459, 419.1885, 566.2569, 679.3410, 778.4094, 865.4414, 994.4840, 1093.5524, 1206.6365, 1334.6951, 1481.7635, 1641.7941, 1754.8782, 1841.9102, 1969.9688, 2084.9957, 2216.0362, 2329.1203, 2443.1632, 2542.2316, 2656.2746, 2727.3117, 2840.3957, 2987.4641, 3102.4911, 3217.5180, 3364.5864, 3461.6392, 3590.6818, 3691.7295, 3820.7721, 3934.8150, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YGSQQMSHSHNLLHNNSNFHYHNSLPPQQQSHHK", {164.0706, 221.0921, 308.1241, 436.1827, 564.2413, 695.2817, 782.3138, 919.3727, 1006.4047, 1143.4636, 1257.5065, 1370.5906, 1483.6747, 1620.7336, 1734.7765, 1848.8194, 1935.8515, 2049.8944, 2196.9628, 2334.0217, 2497.0851, 2634.1440, 2748.1869, 2835.2189, 2948.3030, 3045.3557, 3142.4085, 3270.4671, 3398.5257, 3526.5842, 3613.6163, 3750.6752, 3887.7341, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 284.1717, 421.2306, 508.2627, 636.3212, 764.3798, 892.4384, 989.4912, 1086.5439, 1199.6280, 1286.6600, 1400.7029, 1537.7618, 1700.8252, 1837.8841, 1984.9525, 2098.9954, 2186.0275, 2300.0704, 2414.1133, 2551.1722, 2664.2563, 2777.3404, 2891.3833, 3028.4422, 3115.4742, 3252.5331, 3339.5652, 3470.6056, 3598.6642, 3726.7228, 3813.7548, 3870.7763, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QGAEEFDSSTIAEYWMLAIYTFTLPLHLVFPYIR", {129.0659, 186.0873, 257.1244, 386.1670, 515.2096, 662.2780, 777.3050, 864.3370, 951.3690, 1052.4167, 1165.5008, 1236.5379, 1365.5805, 1528.6438, 1714.7231, 1845.7636, 1958.8477, 2029.8848, 2142.9688, 2306.0322, 2407.0799, 2554.1483, 2655.1959, 2768.2800, 2865.3328, 2978.4168, 3115.4758, 3228.5598, 3327.6282, 3474.6966, 3571.7494, 3734.8127, 3847.8968, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 451.2663, 548.3191, 695.3875, 794.4559, 907.5400, 1044.5989, 1157.6830, 1254.7357, 1367.8198, 1468.8675, 1615.9359, 1716.9836, 1880.0469, 1993.1310, 2064.1681, 2177.2521, 2308.2926, 2494.3719, 2657.4353, 2786.4779, 2857.5150, 2970.5990, 3071.6467, 3158.6787, 3245.7108, 3360.7377, 3507.8061, 3636.8487, 3765.8913, 3836.9284, 3893.9499, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YAFPLEYGELFLVGTCGSYVVGLSILIYIYFFWK", {164.0706, 235.1077, 382.1761, 479.2289, 592.3130, 721.3556, 884.4189, 941.4403, 1070.4829, 1183.5670, 1330.6354, 1443.7195, 1542.7879, 1599.8094, 1700.8570, 1860.8877, 1917.9091, 2004.9412, 2168.0045, 2267.0729, 2366.1413, 2423.1628, 2536.2469, 2623.2789, 2736.3630, 2849.4470, 2962.5311, 3125.5944, 3238.6785, 3401.7418, 3548.8102, 3695.8786, 3881.9579, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 333.1921, 480.2605, 627.3289, 790.3923, 903.4763, 1066.5397, 1179.6237, 1292.7078, 1405.7919, 1492.8239, 1605.9080, 1662.9294, 1761.9978, 1861.0662, 2024.1296, 2111.1616, 2168.1831, 2328.2137, 2429.2614, 2486.2829, 2585.3513, 2698.4353, 2845.5037, 2958.5878, 3087.6304, 3144.6519, 3307.7152, 3436.7578, 3549.8419, 3646.8946, 3793.9630, 3865.0001, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NLVDVFEVEFDQDQYWAGGTISLDPELNYLMYVK", {115.0502, 228.1343, 327.2027, 442.2296, 541.2980, 688.3665, 817.4090, 916.4775, 1045.5201, 1192.5885, 1307.6154, 1435.6740, 1550.7009, 1678.7595, 1841.8228, 2027.9021, 2098.9393, 2155.9607, 2212.9822, 2314.0299, 2427.1139, 2514.1460, 2627.2300, 2742.2570, 2839.3097, 2968.3523, 3081.4364, 3195.4793, 3358.5426, 3471.6267, 3602.6672, 3765.7305, 3864.7989, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 246.1812, 409.2445, 540.2850, 653.3691, 816.4324, 930.4754, 1043.5594, 1172.6020, 1269.6548, 1384.6817, 1497.7658, 1584.7978, 1697.8819, 1798.9296, 1855.9510, 1912.9725, 1984.0096, 2170.0889, 2333.1522, 2461.2108, 2576.2378, 2704.2963, 2819.3233, 2966.3917, 3095.4343, 3194.5027, 3323.5453, 3470.6137, 3569.6821, 3684.7091, 3783.7775, 3896.8615, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ADLMGPLWSNMLFILPFFPNDYLLLLPLLVSLWR", {72.0444, 187.0713, 300.1554, 431.1959, 488.2173, 585.2701, 698.3542, 884.4335, 971.4655, 1085.5084, 1216.5489, 1329.6330, 1476.7014, 1589.7855, 1702.8695, 1799.9223, 1946.9907, 2094.0591, 2191.1119, 2305.1548, 2420.1818, 2583.2451, 2696.3292, 2809.4132, 2922.4973, 3035.5813, 3132.6341, 3245.7182, 3358.8022, 3457.8706, 3544.9027, 3657.9867, 3844.0661, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 361.1983, 474.2823, 561.3144, 660.3828, 773.4668, 886.5509, 983.6037, 1096.6877, 1209.7718, 1322.8559, 1435.9399, 1599.0032, 1714.0302, 1828.0731, 1925.1259, 2072.1943, 2219.2627, 2316.3155, 2429.3995, 2542.4836, 2689.5520, 2802.6361, 2933.6766, 3047.7195, 3134.7515, 3320.8308, 3433.9149, 3530.9677, 3587.9891, 3719.0296, 3832.1137, 3947.1406, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YQTPCFLFRPSGLHTYIENTVSVHANAFTQFVEK", {164.0706, 292.1292, 393.1769, 490.2296, 650.2603, 797.3287, 910.4128, 1057.4812, 1213.5823, 1310.6350, 1397.6671, 1454.6885, 1567.7726, 1704.8315, 1805.8792, 1968.9425, 2082.0266, 2211.0692, 2325.1121, 2426.1598, 2525.2282, 2612.2602, 2711.3286, 2848.3875, 2919.4247, 3033.4676, 3104.5047, 3251.5731, 3352.6208, 3480.6794, 3627.7478, 3726.8162, 3855.8588, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 276.1554, 375.2238, 522.2922, 650.3508, 751.3985, 898.4669, 969.5040, 1083.5469, 1154.5841, 1291.6430, 1390.7114, 1477.7434, 1576.8118, 1677.8595, 1791.9024, 1920.9450, 2034.0291, 2197.0924, 2298.1401, 2435.1990, 2548.2831, 2605.3045, 2692.3366, 2789.3893, 2945.4904, 3092.5588, 3205.6429, 3352.7113, 3512.7420, 3609.7947, 3710.8424, 3838.9010, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SFYMDMCQNLQCVNSNPPLELSLNSFSEYTASEK", {88.0393, 235.1077, 398.1710, 529.2115, 644.2385, 775.2790, 935.3096, 1063.3682, 1177.4111, 1290.4952, 1418.5538, 1578.5844, 1677.6528, 1791.6957, 1878.7278, 1992.7707, 2089.8235, 2186.8762, 2299.9603, 2429.0029, 2542.0869, 2629.1190, 2742.2030, 2856.2460, 2943.2780, 3090.3464, 3177.3784, 3306.4210, 3469.4844, 3570.5320, 3641.5692, 3728.6012, 3857.6438, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 276.1554, 363.1874, 434.2245, 535.2722, 698.3355, 827.3781, 914.4102, 1061.4786, 1148.5106, 1262.5535, 1375.6376, 1462.6696, 1575.7537, 1704.7963, 1817.8804, 1914.9331, 2011.9859, 2126.0288, 2213.0608, 2327.1038, 2426.1722, 2586.2028, 2714.2614, 2827.3455, 2941.3884, 3069.4470, 3229.4776, 3360.5181, 3475.5450, 3606.5855, 3769.6489, 3916.7173, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TITTNEFGYNIQNILNFYYWAGGVQSDNVLLWDR", {102.0550, 215.1390, 316.1867, 417.2344, 531.2773, 660.3199, 807.3883, 864.4098, 1027.4731, 1141.5160, 1254.6001, 1382.6587, 1496.7016, 1609.7857, 1722.8697, 1836.9127, 1983.9811, 2147.0444, 2310.1077, 2496.1870, 2567.2242, 2624.2456, 2681.2671, 2780.3355, 2908.3941, 2995.4261, 3110.4530, 3224.4960, 3323.5644, 3436.6484, 3549.7325, 3735.8118, 3850.8388, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 290.1459, 476.2252, 589.3093, 702.3933, 801.4618, 915.5047, 1030.5316, 1117.5636, 1245.6222, 1344.6906, 1401.7121, 1458.7336, 1529.7707, 1715.8500, 1878.9133, 2041.9767, 2189.0451, 2303.0880, 2416.1721, 2529.2561, 2643.2990, 2771.3576, 2884.4417, 2998.4846, 3161.5479, 3218.5694, 3365.6378, 3494.6804, 3608.7233, 3709.7710, 3810.8187, 3923.9028, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NYVSLICEEIMWAYCVNSNDPLHYGPHGDVSTNR", {115.0502, 278.1135, 377.1819, 464.2140, 577.2980, 690.3821, 850.4128, 979.4553, 1108.4979, 1221.5820, 1352.6225, 1538.7018, 1609.7389, 1772.8022, 1932.8329, 2031.9013, 2145.9442, 2232.9763, 2347.0192, 2462.0461, 2559.0989, 2672.1830, 2809.2419, 2972.3052, 3029.3267, 3126.3794, 3263.4383, 3320.4598, 3435.4867, 3534.5552, 3621.5872, 3722.6349, 3836.6778, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 289.1619, 390.2096, 477.2416, 576.3100, 691.3369, 748.3584, 885.4173, 982.4701, 1039.4915, 1202.5549, 1339.6138, 1452.6979, 1549.7506, 1664.7776, 1778.8205, 1865.8525, 1979.8954, 2078.9639, 2238.9945, 2402.0578, 2473.0949, 2659.1743, 2790.2147, 2903.2988, 3032.3414, 3161.3840, 3321.4146, 3434.4987, 3547.5828, 3634.6148, 3733.6832, 3896.7465, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LLPCFVLPFLATVYIPLTETIWLLAMTVILWLCK", {114.0913, 227.1754, 324.2282, 484.2588, 631.3272, 730.3956, 843.4797, 940.5325, 1087.6009, 1200.6850, 1271.7221, 1372.7697, 1471.8382, 1634.9015, 1747.9855, 1845.0383, 1958.1224, 2059.1701, 2188.2126, 2289.2603, 2402.3444, 2588.4237, 2701.5078, 2814.5918, 2885.6289, 3016.6694, 3117.7171, 3216.7855, 3329.8696, 3442.9537, 3629.0330, 3742.1170, 3902.1477, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 307.1435, 420.2275, 606.3068, 719.3909, 832.4750, 931.5434, 1032.5911, 1163.6315, 1234.6686, 1347.7527, 1460.8368, 1646.9161, 1760.0002, 1861.0478, 1990.0904, 2091.1381, 2204.2222, 2301.2749, 2414.3590, 2577.4223, 2676.4907, 2777.5384, 2848.5755, 2961.6596, 3108.7280, 3205.7808, 3318.8648, 3417.9333, 3565.0017, 3725.0323, 3822.0851, 3935.1691, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EHDYGQDPILDGEYTEYVDYVEEIIGDEEVQENK", {130.0499, 267.1088, 382.1357, 545.1991, 602.2205, 730.2791, 845.3060, 942.3588, 1055.4429, 1168.5269, 1283.5539, 1340.5753, 1469.6179, 1632.6813, 1733.7289, 1862.7715, 2025.8349, 2124.9033, 2239.9302, 2402.9935, 2502.0620, 2631.1046, 2760.1471, 2873.2312, 2986.3153, 3043.3367, 3158.3637, 3287.4063, 3416.4489, 3515.5173, 3643.5759, 3772.6184, 3886.6614, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 261.1557, 390.1983, 518.2569, 617.3253, 746.3679, 875.4105, 990.4374, 1047.4589, 1160.5430, 1273.6270, 1402.6696, 1531.7122, 1630.7806, 1793.8440, 1908.8709, 2007.9393, 2171.0027, 2300.0452, 2401.0929, 2564.1563, 2693.1988, 2750.2203, 2865.2473, 2978.3313, 3091.4154, 3188.4681, 3303.4951, 3431.5537, 3488.5751, 3651.6385, 3766.6654, 3903.7243, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LGYIWGMTALITIPVLHHIVTLCSLFPCFLLCVR", {114.0913, 171.1128, 334.1761, 447.2602, 633.3395, 690.3610, 821.4015, 922.4491, 993.4863, 1106.5703, 1219.6544, 1320.7021, 1433.7861, 1530.8389, 1629.9073, 1742.9914, 1880.0503, 2017.1092, 2130.1933, 2229.2617, 2330.3093, 2443.3934, 2603.4241, 2690.4561, 2803.5401, 2950.6086, 3047.6613, 3207.6920, 3354.7604, 3467.8445, 3580.9285, 3740.9592, 3840.0276, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 274.1874, 434.2180, 547.3021, 660.3861, 807.4546, 967.4852, 1064.5380, 1211.6064, 1324.6904, 1411.7225, 1571.7531, 1684.8372, 1785.8849, 1884.9533, 1998.0373, 2135.0963, 2272.1552, 2385.2392, 2484.3076, 2581.3604, 2694.4445, 2795.4922, 2908.5762, 3021.6603, 3092.6974, 3193.7451, 3324.7856, 3381.8070, 3567.8863, 3680.9704, 3844.0337, 3901.0552, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VYLYSWNDFYISIAPLLVLGMSWFLESLTVVIIR", {100.0757, 263.1390, 376.2231, 539.2864, 626.3184, 812.3978, 926.4407, 1041.4676, 1188.5360, 1351.5994, 1464.6834, 1551.7155, 1664.7995, 1735.8366, 1832.8894, 1945.9735, 2059.0575, 2158.1259, 2271.2100, 2328.2315, 2459.2720, 2546.3040, 2732.3833, 2879.4517, 2992.5358, 3121.5784, 3208.6104, 3321.6945, 3422.7421, 3521.8106, 3620.8790, 3733.9630, 3847.0471, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 401.2871, 500.3555, 599.4239, 700.4716, 813.5557, 900.5877, 1029.6303, 1142.7143, 1289.7828, 1475.8621, 1562.8941, 1693.9346, 1750.9560, 1864.0401, 1963.1085, 2076.1926, 2189.2766, 2286.3294, 2357.3665, 2470.4506, 2557.4826, 2670.5667, 2833.6300, 2980.6984, 3095.7254, 3209.7683, 3395.8476, 3482.8796, 3645.9430, 3759.0270, 3922.0904, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"INSWIGFVCVEAVQPMESIVSEIDNPYYMINQYK", {114.0913, 228.1343, 315.1663, 501.2456, 614.3297, 671.3511, 818.4196, 917.4880, 1077.5186, 1176.5870, 1305.6296, 1376.6667, 1475.7351, 1603.7937, 1700.8465, 1831.8870, 1960.9296, 2047.9616, 2161.0457, 2260.1141, 2347.1461, 2476.1887, 2589.2728, 2704.2997, 2818.3426, 2915.3954, 3078.4587, 3241.5221, 3372.5625, 3485.6466, 3599.6895, 3727.7481, 3890.8114, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 310.1761, 438.2347, 552.2776, 665.3617, 796.4022, 959.4655, 1122.5288, 1219.5816, 1333.6245, 1448.6515, 1561.7355, 1690.7781, 1777.8102, 1876.8786, 1989.9626, 2076.9947, 2206.0373, 2337.0777, 2434.1305, 2562.1891, 2661.2575, 2732.2946, 2861.3372, 2960.4056, 3120.4363, 3219.5047, 3366.5731, 3423.5946, 3536.6786, 3722.7579, 3809.7900, 3923.8329, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"HPYPHHGHPHHHHTHYPFATHASQHVPCPPPKPR", {138.0662, 235.1190, 398.1823, 495.2350, 632.2940, 769.3529, 826.3743, 963.4332, 1060.4860, 1197.5449, 1334.6038, 1471.6627, 1608.7217, 1709.7693, 1846.8282, 2009.8916, 2106.9443, 2254.0128, 2325.0499, 2426.0975, 2563.1565, 2634.1936, 2721.2256, 2849.2842, 2986.3431, 3085.4115, 3182.4643, 3342.4949, 3439.5477, 3536.6004, 3633.6532, 3761.7482, 3858.8009, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 272.1717, 400.2667, 497.3194, 594.3722, 691.4250, 851.4556, 948.5084, 1047.5768, 1184.6357, 1312.6943, 1399.7263, 1470.7634, 1607.8223, 1708.8700, 1779.9071, 1926.9755, 2024.0283, 2187.0916, 2324.1506, 2425.1982, 2562.2571, 2699.3161, 2836.3750, 2973.4339, 3070.4866, 3207.5456, 3264.5670, 3401.6259, 3538.6848, 3635.7376, 3798.8009, 3895.8537, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FTFVQGAPCHVTLQSGYVSPCVYYESNSHYSPWR", {148.0757, 249.1234, 396.1918, 495.2602, 623.3188, 680.3402, 751.3774, 848.4301, 1008.4608, 1145.5197, 1244.5881, 1345.6358, 1458.7198, 1586.7784, 1673.8104, 1730.8319, 1893.8952, 1992.9636, 2079.9957, 2177.0484, 2337.0791, 2436.1475, 2599.2108, 2762.2742, 2891.3167, 2978.3488, 3092.3917, 3179.4237, 3316.4826, 3479.5460, 3566.5780, 3663.6308, 3849.7101, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 361.1983, 458.2510, 545.2831, 708.3464, 845.4053, 932.4373, 1046.4803, 1133.5123, 1262.5549, 1425.6182, 1588.6815, 1687.7499, 1847.7806, 1944.8334, 2031.8654, 2130.9338, 2293.9971, 2351.0186, 2438.0506, 2566.1092, 2679.1933, 2780.2409, 2879.3094, 3016.3683, 3176.3989, 3273.4517, 3344.4888, 3401.5103, 3529.5688, 3628.6372, 3775.7057, 3876.7533, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"KPAMNIPIGSIESHFYLAVHLQLFDWDEHILEIK", {129.1022, 226.1550, 297.1921, 428.2326, 542.2755, 655.3596, 752.4124, 865.4964, 922.5179, 1009.5499, 1122.6340, 1251.6766, 1338.7086, 1475.7675, 1622.8359, 1785.8993, 1898.9833, 1970.0204, 2069.0888, 2206.1478, 2319.2318, 2447.2904, 2560.3745, 2707.4429, 2822.4698, 3008.5491, 3123.5761, 3252.6187, 3389.6776, 3502.7616, 3615.8457, 3744.8883, 3857.9724, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 389.2395, 502.3235, 615.4076, 752.4665, 881.5091, 996.5360, 1182.6154, 1297.6423, 1444.7107, 1557.7948, 1685.8533, 1798.9374, 1935.9963, 2035.0647, 2106.1019, 2219.1859, 2382.2492, 2529.3177, 2666.3766, 2753.4086, 2882.4512, 2995.5353, 3082.5673, 3139.5887, 3252.6728, 3349.7256, 3462.8096, 3576.8526, 3707.8931, 3778.9302, 3875.9829, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ITTEENINITEADEKPNRPSEKPYQSTEPEKPYR", {114.0913, 215.1390, 316.1867, 445.2293, 574.2719, 688.3148, 801.3989, 915.4418, 1028.5259, 1129.5735, 1258.6161, 1329.6533, 1444.6802, 1573.7228, 1701.8178, 1798.8705, 1912.9134, 2069.0146, 2166.0673, 2253.0993, 2382.1419, 2510.2369, 2607.2897, 2770.3530, 2898.4116, 2985.4436, 3086.4913, 3215.5339, 3312.5866, 3441.6292, 3569.7242, 3666.7770, 3829.8403, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 435.2350, 563.3300, 692.3726, 789.4254, 918.4680, 1019.5156, 1106.5477, 1234.6062, 1397.6696, 1494.7223, 1622.8173, 1751.8599, 1838.8919, 1935.9447, 2092.0458, 2206.0887, 2303.1415, 2431.2364, 2560.2790, 2675.3060, 2746.3431, 2875.3857, 2976.4334, 3089.5174, 3203.5604, 3316.6444, 3430.6874, 3559.7299, 3688.7725, 3789.8202, 3890.8679, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TLLQLLSETFGDEEYELVDPMLQHYFRPADVAQR", {102.0550, 215.1390, 328.2231, 456.2817, 569.3657, 682.4498, 769.4818, 898.5244, 999.5721, 1146.6405, 1203.6620, 1318.6889, 1447.7315, 1576.7741, 1739.8374, 1868.8800, 1981.9641, 2081.0325, 2196.0594, 2293.1122, 2424.1527, 2537.2368, 2665.2953, 2802.3542, 2965.4176, 3112.4860, 3268.5871, 3365.6399, 3436.6770, 3551.7039, 3650.7723, 3721.8094, 3849.8680, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 374.2146, 473.2831, 588.3100, 659.3471, 756.3999, 912.5010, 1059.5694, 1222.6327, 1359.6916, 1487.7502, 1600.8343, 1731.8748, 1828.9275, 1943.9545, 2043.0229, 2156.1070, 2285.1495, 2448.2129, 2577.2555, 2706.2981, 2821.3250, 2878.3465, 3025.4149, 3126.4626, 3255.5052, 3342.5372, 3455.6212, 3568.7053, 3696.7639, 3809.8480, 3922.9320, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FDDTTLDDWHTSIISSCYELLTSAGVEEAVCYFR", {148.0757, 263.1026, 378.1296, 479.1773, 580.2249, 693.3090, 808.3359, 923.3629, 1109.4422, 1246.5011, 1347.5488, 1434.5808, 1547.6649, 1660.7489, 1747.7810, 1834.8130, 1994.8436, 2157.9070, 2286.9496, 2400.0336, 2513.1177, 2614.1654, 2701.1974, 2772.2345, 2829.2560, 2928.3244, 3057.3670, 3186.4096, 3257.4467, 3356.5151, 3516.5458, 3679.6091, 3826.6775, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 485.2507, 645.2813, 744.3498, 815.3869, 944.4295, 1073.4721, 1172.5405, 1229.5619, 1300.5990, 1387.6311, 1488.6788, 1601.7628, 1714.8469, 1843.8895, 2006.9528, 2166.9835, 2254.0155, 2341.0475, 2454.1316, 2567.2156, 2654.2477, 2755.2953, 2892.3543, 3078.4336, 3193.4605, 3308.4875, 3421.5715, 3522.6192, 3623.6669, 3738.6938, 3853.7208, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NLNYGLITLFWTLLYSILSIWLIASIMSLFFISR", {115.0502, 228.1343, 342.1772, 505.2405, 562.2620, 675.3461, 788.4301, 889.4778, 1002.5619, 1149.6303, 1335.7096, 1436.7573, 1549.8413, 1662.9254, 1825.9887, 1913.0207, 2026.1048, 2139.1889, 2226.2209, 2339.3050, 2525.3843, 2638.4683, 2751.5524, 2822.5895, 2909.6216, 3022.7056, 3153.7461, 3240.7781, 3353.8622, 3500.9306, 3647.9990, 3761.0831, 3848.1151, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 262.1510, 375.2350, 522.3035, 669.3719, 782.4559, 869.4880, 1000.5284, 1113.6125, 1200.6445, 1271.6817, 1384.7657, 1497.8498, 1683.9291, 1797.0132, 1884.0452, 1997.1293, 2110.2133, 2197.2453, 2360.3087, 2473.3927, 2586.4768, 2687.5245, 2873.6038, 3020.6722, 3133.7563, 3234.8040, 3347.8880, 3460.9721, 3517.9935, 3681.0569, 3795.0998, 3908.1839, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ASAFLANMHLSFYVCSVMENHLNIYEKPFFQPIK", {72.0444, 159.0764, 230.1135, 377.1819, 490.2660, 561.3031, 675.3461, 806.3865, 943.4454, 1056.5295, 1143.5615, 1290.6300, 1453.6933, 1552.7617, 1712.7923, 1799.8244, 1898.8928, 2029.9333, 2158.9759, 2273.0188, 2410.0777, 2523.1618, 2637.2047, 2750.2888, 2913.3521, 3042.3947, 3170.4896, 3267.5424, 3414.6108, 3561.6792, 3689.7378, 3786.7906, 3899.8746, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 357.2496, 485.3082, 632.3766, 779.4450, 876.4978, 1004.5928, 1133.6354, 1296.6987, 1409.7828, 1523.8257, 1636.9097, 1773.9687, 1888.0116, 2017.0542, 2148.0947, 2247.1631, 2334.1951, 2494.2257, 2593.2942, 2756.3575, 2903.4259, 2990.4579, 3103.5420, 3240.6009, 3371.6414, 3485.6843, 3556.7214, 3669.8055, 3816.8739, 3887.9110, 3974.9431, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FDFDMLEDDASNGSVLDLYLVCYLLAWFLCGFAR", {148.0757, 263.1026, 410.1710, 525.1980, 656.2385, 769.3225, 898.3651, 1013.3921, 1128.4190, 1199.4561, 1286.4882, 1400.5311, 1457.5526, 1544.5846, 1643.6530, 1756.7371, 1871.7640, 1984.8481, 2147.9114, 2260.9955, 2360.0639, 2520.0945, 2683.1578, 2796.2419, 2909.3260, 2980.3631, 3166.4424, 3313.5108, 3426.5949, 3586.6255, 3643.6470, 3790.7154, 3861.7525, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 246.1561, 393.2245, 450.2459, 610.2766, 723.3607, 870.4291, 1056.5084, 1127.5455, 1240.6296, 1353.7136, 1516.7770, 1676.8076, 1775.8760, 1888.9601, 2052.0234, 2165.1075, 2280.1344, 2393.2185, 2492.2869, 2579.3189, 2636.3404, 2750.3833, 2837.4153, 2908.4525, 3023.4794, 3138.5063, 3267.5489, 3380.6330, 3511.6735, 3626.7004, 3773.7688, 3888.7958, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PYFNESIPLAACDYFLLLSDLVIQFSDVSFEFQR", {98.0600, 261.1234, 408.1918, 522.2347, 651.2773, 738.3093, 851.3934, 948.4462, 1061.5302, 1132.5673, 1203.6045, 1363.6351, 1478.6620, 1641.7254, 1788.7938, 1901.8778, 2014.9619, 2128.0460, 2215.0780, 2330.1049, 2443.1890, 2542.2574, 2655.3415, 2783.4001, 2930.4685, 3017.5005, 3132.5275, 3231.5959, 3318.6279, 3465.6963, 3594.7389, 3741.8073, 3869.8659, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 450.2459, 579.2885, 726.3570, 813.3890, 912.4574, 1027.4843, 1114.5164, 1261.5848, 1389.6434, 1502.7274, 1601.7958, 1714.8799, 1829.9068, 1916.9389, 2030.0229, 2143.1070, 2256.1911, 2403.2595, 2566.3228, 2681.3497, 2841.3804, 2912.4175, 2983.4546, 3096.5387, 3193.5915, 3306.6755, 3393.7075, 3522.7501, 3636.7931, 3783.8615, 3946.9248, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DYHVPYIVPLDLPEVEARPCTSYISFDVPYITDR", {116.0342, 279.0975, 416.1565, 515.2249, 612.2776, 775.3410, 888.4250, 987.4934, 1084.5462, 1197.6303, 1312.6572, 1425.7413, 1522.7940, 1651.8366, 1750.9051, 1879.9476, 1950.9848, 2107.0859, 2204.1386, 2364.1693, 2465.2170, 2552.2490, 2715.3123, 2828.3964, 2915.4284, 3062.4968, 3177.5238, 3276.5922, 3373.6449, 3536.7083, 3649.7923, 3750.8400, 3865.8670, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 290.1459, 391.1936, 504.2776, 667.3410, 764.3937, 863.4621, 978.4891, 1125.5575, 1212.5895, 1325.6736, 1488.7369, 1575.7690, 1676.8166, 1836.8473, 1933.9000, 2090.0012, 2161.0383, 2290.0809, 2389.1493, 2518.1919, 2615.2446, 2728.3287, 2843.3556, 2956.4397, 3053.4925, 3152.5609, 3265.6449, 3428.7083, 3525.7610, 3624.8294, 3761.8884, 3924.9517, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NQTFYENLAPPFCALSHMPWSHPTHQIINSLFDK", {115.0502, 243.1088, 344.1565, 491.2249, 654.2882, 783.3308, 897.3737, 1010.4578, 1081.4949, 1178.5477, 1275.6004, 1422.6688, 1582.6995, 1653.7366, 1766.8207, 1853.8527, 1990.9116, 2121.9521, 2219.0049, 2405.0842, 2492.1162, 2629.1751, 2726.2279, 2827.2756, 2964.3345, 3092.3930, 3205.4771, 3318.5612, 3432.6041, 3519.6361, 3632.7202, 3779.7886, 3894.8155, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 262.1397, 409.2082, 522.2922, 609.3243, 723.3672, 836.4512, 949.5353, 1077.5939, 1214.6528, 1315.7005, 1412.7532, 1549.8122, 1636.8442, 1822.9235, 1919.9763, 2051.0167, 2188.0757, 2275.1077, 2388.1917, 2459.2289, 2619.2595, 2766.3279, 2863.3807, 2960.4335, 3031.4706, 3144.5546, 3258.5976, 3387.6401, 3550.7035, 3697.7719, 3798.8196, 3926.8781, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"HFHYILWLHSFDELGELSHEPNTFVGDNLQIIGR", {138.0662, 285.1346, 422.1935, 585.2568, 698.3409, 811.4250, 997.5043, 1110.5883, 1247.6473, 1334.6793, 1481.7477, 1596.7746, 1725.8172, 1838.9013, 1895.9228, 2024.9654, 2138.0494, 2225.0815, 2362.1404, 2491.1830, 2588.2357, 2702.2786, 2803.3263, 2950.3947, 3049.4632, 3106.4846, 3221.5116, 3335.5545, 3448.6386, 3576.6971, 3689.7812, 3802.8653, 3859.8867, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 232.1404, 345.2245, 458.3085, 586.3671, 699.4512, 813.4941, 928.5211, 985.5425, 1084.6109, 1231.6793, 1332.7270, 1446.7700, 1543.8227, 1672.8653, 1809.9242, 1896.9563, 2010.0403, 2139.0829, 2196.1044, 2309.1884, 2438.2310, 2553.2580, 2700.3264, 2787.3584, 2924.4173, 3037.5014, 3223.5807, 3336.6648, 3449.7488, 3612.8122, 3749.8711, 3896.9395, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NNEHHQLQVLEYHPVADHTDVHFVSQLQEPTMQK", {115.0502, 229.0931, 358.1357, 495.1946, 632.2535, 760.3121, 873.3962, 1001.4548, 1100.5232, 1213.6072, 1342.6498, 1505.7132, 1642.7721, 1739.8248, 1838.8933, 1909.9304, 2024.9573, 2162.0162, 2263.0639, 2378.0908, 2477.1593, 2614.2182, 2761.2866, 2860.3550, 2947.3870, 3075.4456, 3188.5297, 3316.5882, 3445.6308, 3542.6836, 3643.7313, 3774.7718, 3902.8303, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 275.1714, 406.2119, 507.2595, 604.3123, 733.3549, 861.4135, 974.4975, 1102.5561, 1189.5881, 1288.6566, 1435.7250, 1572.7839, 1671.8523, 1786.8792, 1887.9269, 2024.9858, 2140.0128, 2211.0499, 2310.1183, 2407.1711, 2544.2300, 2707.2933, 2836.3359, 2949.4200, 3048.4884, 3176.5470, 3289.6310, 3417.6896, 3554.7485, 3691.8074, 3820.8500, 3934.8929, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DMPDYVLVFADPFQLYHRPLQQQEGQLGATDYIR", {116.0342, 247.0747, 344.1275, 459.1544, 622.2177, 721.2862, 834.3702, 933.4386, 1080.5070, 1151.5442, 1266.5711, 1363.6239, 1510.6923, 1638.7509, 1751.8349, 1914.8983, 2051.9572, 2208.0583, 2305.1110, 2418.1951, 2546.2537, 2674.3123, 2802.3708, 2931.4134, 2988.4349, 3116.4935, 3229.5775, 3286.5990, 3357.6361, 3458.6838, 3573.7107, 3736.7741, 3849.8581, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 451.2663, 566.2933, 667.3410, 738.3781, 795.3995, 908.4836, 1036.5422, 1093.5636, 1222.6062, 1350.6648, 1478.7234, 1606.7820, 1719.8660, 1816.9188, 1973.0199, 2110.0788, 2273.1422, 2386.2262, 2514.2848, 2661.3532, 2758.4060, 2873.4329, 2944.4700, 3091.5384, 3190.6069, 3303.6909, 3402.7593, 3565.8227, 3680.8496, 3777.9024, 3908.9429, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LDATTGIHFILNMGIVIHFLFHCHFLWYGPNDAR", {114.0913, 229.1183, 300.1554, 401.2031, 502.2508, 559.2722, 672.3563, 809.4152, 956.4836, 1069.5677, 1182.6517, 1296.6947, 1427.7351, 1484.7566, 1597.8407, 1696.9091, 1809.9932, 1947.0521, 2094.1205, 2207.2045, 2354.2730, 2491.3319, 2651.3625, 2788.4214, 2935.4898, 3048.5739, 3234.6532, 3397.7165, 3454.7380, 3551.7908, 3665.8337, 3780.8606, 3851.8978, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 246.1561, 361.1830, 475.2259, 572.2787, 629.3002, 792.3635, 978.4428, 1091.5269, 1238.5953, 1375.6542, 1535.6848, 1672.7438, 1819.8122, 1932.8962, 2079.9646, 2217.0236, 2330.1076, 2429.1760, 2542.2601, 2599.2816, 2730.3221, 2844.3650, 2957.4490, 3070.5331, 3217.6015, 3354.6604, 3467.7445, 3524.7660, 3625.8136, 3726.8613, 3797.8984, 3912.9254, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YSNNDENMMVFDDINIIEQKPELESGNDDFNNDR", {164.0706, 251.1026, 365.1456, 479.1885, 594.2154, 723.2580, 837.3010, 968.3414, 1099.3819, 1198.4503, 1345.5187, 1460.5457, 1575.5726, 1688.6567, 1802.6996, 1915.7837, 2028.8678, 2157.9103, 2285.9689, 2414.0639, 2511.1167, 2640.1592, 2753.2433, 2882.2859, 2969.3179, 3026.3394, 3140.3823, 3255.4093, 3370.4362, 3517.5046, 3631.5476, 3745.5905, 3860.6174, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 290.1459, 404.1888, 518.2318, 665.3002, 780.3271, 895.3541, 1009.3970, 1066.4184, 1153.4505, 1282.4931, 1395.5771, 1524.6197, 1621.6725, 1749.7674, 1877.8260, 2006.8686, 2119.9527, 2233.0367, 2347.0797, 2460.1637, 2575.1907, 2690.2176, 2837.2860, 2936.3545, 3067.3949, 3198.4354, 3312.4783, 3441.5209, 3556.5479, 3670.5908, 3784.6337, 3871.6658, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ILQYSHNMMAILLNLLVVINIVSYTGFMLMGWFR", {114.0913, 227.1754, 355.2340, 518.2973, 605.3293, 742.3883, 856.4312, 987.4717, 1118.5121, 1189.5493, 1302.6333, 1415.7174, 1528.8015, 1642.8444, 1755.9284, 1869.0125, 1968.0809, 2067.1493, 2180.2334, 2294.2763, 2407.3604, 2506.4288, 2593.4608, 2756.5242, 2857.5718, 2914.5933, 3061.6617, 3192.7022, 3305.7863, 3436.8268, 3493.8482, 3679.9275, 3826.9959, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 508.2667, 565.2881, 696.3286, 809.4127, 940.4532, 1087.5216, 1144.5431, 1245.5907, 1408.6541, 1495.6861, 1594.7545, 1707.8386, 1821.8815, 1934.9656, 2034.0340, 2133.1024, 2246.1865, 2359.2705, 2473.3134, 2586.3975, 2699.4816, 2812.5656, 2883.6027, 3014.6432, 3145.6837, 3259.7266, 3396.7856, 3483.8176, 3646.8809, 3774.9395, 3888.0236, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"HEDTGNDHHDHDNDLENHEVKPHPTPTAHELEER", {138.0662, 267.1088, 382.1357, 483.1834, 540.2049, 654.2478, 769.2747, 906.3336, 1043.3926, 1158.4195, 1295.4784, 1410.5054, 1524.5483, 1639.5752, 1752.6593, 1881.7019, 1995.7448, 2132.8037, 2261.8463, 2360.9147, 2489.0097, 2586.0625, 2723.1214, 2820.1741, 2921.2218, 3018.2746, 3119.3223, 3190.3594, 3327.4183, 3456.4609, 3569.5449, 3698.5875, 3827.6301, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 433.2041, 546.2882, 675.3308, 812.3897, 883.4268, 984.4745, 1081.5273, 1182.5749, 1279.6277, 1416.6866, 1513.7394, 1641.8343, 1740.9028, 1869.9454, 2007.0043, 2121.0472, 2250.0898, 2363.1738, 2478.2008, 2592.2437, 2707.2707, 2844.3296, 2959.3565, 3096.4154, 3233.4743, 3348.5013, 3462.5442, 3519.5657, 3620.6134, 3735.6403, 3864.6829, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PTLPLSTTPQETHTWQYMEYPSFGCDLHENSIQK", {98.0600, 199.1077, 312.1918, 409.2445, 522.3286, 609.3606, 710.4083, 811.4560, 908.5088, 1036.5673, 1165.6099, 1266.6576, 1403.7165, 1504.7642, 1690.8435, 1818.9021, 1981.9654, 2113.0059, 2242.0485, 2405.1118, 2502.1646, 2589.1966, 2736.2650, 2793.2865, 2953.3171, 3068.3441, 3181.4282, 3318.4871, 3447.5297, 3561.5726, 3648.6046, 3761.6887, 3889.7473, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 275.1714, 388.2554, 475.2875, 589.3304, 718.3730, 855.4319, 968.5160, 1083.5429, 1243.5736, 1300.5950, 1447.6634, 1534.6955, 1631.7482, 1794.8116, 1923.8542, 2054.8946, 2217.9580, 2346.0165, 2532.0959, 2633.1435, 2770.2024, 2871.2501, 3000.2927, 3128.3513, 3225.4041, 3326.4517, 3427.4994, 3514.5314, 3627.6155, 3724.6683, 3837.7523, 3938.8000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ECSQSEWQSWYLLGTTPDLELSMADCDTNFTLVK", {130.0499, 290.0805, 377.1125, 505.1711, 592.2032, 721.2457, 907.3251, 1035.3836, 1122.4157, 1308.4950, 1471.5583, 1584.6424, 1697.7264, 1754.7479, 1855.7956, 1956.8433, 2053.8960, 2168.9230, 2282.0070, 2411.0496, 2524.1337, 2611.1657, 2742.2062, 2813.2433, 2928.2703, 3088.3009, 3203.3278, 3304.3755, 3418.4185, 3565.4869, 3666.5345, 3779.6186, 3878.6870, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 246.1812, 359.2653, 460.3130, 607.3814, 721.4243, 822.4720, 937.4989, 1097.5296, 1212.5565, 1283.5936, 1414.6341, 1501.6661, 1614.7502, 1743.7928, 1856.8769, 1971.9038, 2068.9566, 2170.0042, 2271.0519, 2328.0734, 2441.1575, 2554.2415, 2717.3048, 2903.3842, 2990.4162, 3118.4748, 3304.5541, 3433.5967, 3520.6287, 3648.6873, 3735.7193, 3895.7500, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FGVPCPSCQFGPSLNTCTALEDCPDYLLCENMDR", {148.0757, 205.0972, 304.1656, 401.2183, 561.2490, 658.3017, 745.3338, 905.3644, 1033.4230, 1180.4914, 1237.5129, 1334.5656, 1421.5977, 1534.6817, 1648.7247, 1749.7723, 1909.8030, 2010.8507, 2081.8878, 2194.9718, 2324.0144, 2439.0414, 2599.0720, 2696.1248, 2811.1517, 2974.2151, 3087.2991, 3200.3832, 3360.4138, 3489.4564, 3603.4994, 3734.5398, 3849.5668, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 290.1459, 421.1864, 535.2293, 664.2719, 824.3025, 937.3866, 1050.4707, 1213.5340, 1328.5609, 1425.6137, 1585.6444, 1700.6713, 1829.7139, 1942.7980, 2013.8351, 2114.8828, 2274.9134, 2375.9611, 2490.0040, 2603.0881, 2690.1201, 2787.1729, 2844.1943, 2991.2627, 3119.3213, 3279.3520, 3366.3840, 3463.4368, 3623.4674, 3720.5202, 3819.5886, 3876.6101, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SATILVAIDNNVDPDSVYQEHPIMQQINYQQYYR", {88.0393, 159.0764, 260.1241, 373.2082, 486.2922, 585.3606, 656.3978, 769.4818, 884.5088, 998.5517, 1112.5946, 1211.6630, 1326.6900, 1423.7427, 1538.7697, 1625.8017, 1724.8701, 1887.9334, 2015.9920, 2145.0346, 2282.0935, 2379.1463, 2492.2304, 2623.2708, 2751.3294, 2879.3880, 2992.4721, 3106.5150, 3269.5783, 3397.6369, 3525.6955, 3688.7588, 3851.8221, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 501.2456, 629.3042, 757.3628, 920.4261, 1034.4690, 1147.5531, 1275.6117, 1403.6702, 1534.7107, 1647.7948, 1744.8476, 1881.9065, 2010.9491, 2139.0076, 2302.0710, 2401.1394, 2488.1714, 2603.1983, 2700.2511, 2815.2781, 2914.3465, 3028.3894, 3142.4323, 3257.4593, 3370.5433, 3441.5804, 3540.6489, 3653.7329, 3766.8170, 3867.8647, 3938.9018, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"HEENCLGSGNNIQLTYNDMASYEFLGYYPNFMEK", {138.0662, 267.1088, 396.1514, 510.1943, 670.2250, 783.3090, 840.3305, 927.3625, 984.3840, 1098.4269, 1212.4698, 1325.5539, 1453.6125, 1566.6965, 1667.7442, 1830.8075, 1944.8505, 2059.8774, 2190.9179, 2261.9550, 2348.9870, 2512.0504, 2641.0930, 2788.1614, 2901.2454, 2958.2669, 3121.3302, 3284.3936, 3381.4463, 3495.4892, 3642.5577, 3773.5981, 3902.6407, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 276.1554, 407.1959, 554.2643, 668.3072, 765.3600, 928.4233, 1091.4866, 1148.5081, 1261.5922, 1408.6606, 1537.7032, 1700.7665, 1787.7985, 1858.8357, 1989.8761, 2104.9031, 2218.9460, 2382.0093, 2483.0570, 2596.1411, 2724.1997, 2837.2837, 2951.3266, 3065.3696, 3122.3910, 3209.4231, 3266.4445, 3379.5286, 3539.5592, 3653.6022, 3782.6448, 3911.6874, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PAQSLVSCEDVSLVWSIENACSEQEMFNLQFIFK", {98.0600, 169.0972, 297.1557, 384.1878, 497.2718, 596.3402, 683.3723, 843.4029, 972.4455, 1087.4725, 1186.5409, 1273.5729, 1386.6570, 1485.7254, 1671.8047, 1758.8367, 1871.9208, 2000.9634, 2115.0063, 2186.0434, 2346.0741, 2433.1061, 2562.1487, 2690.2073, 2819.2499, 2950.2903, 3097.3588, 3211.4017, 3324.4857, 3452.5443, 3599.6127, 3712.6968, 3859.7652, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 294.1812, 407.2653, 554.3337, 682.3923, 795.4763, 909.5193, 1056.5877, 1187.6282, 1316.6708, 1444.7293, 1573.7719, 1660.8040, 1820.8346, 1891.8717, 2005.9146, 2134.9572, 2248.0413, 2335.0733, 2521.1526, 2620.2211, 2733.3051, 2820.3372, 2919.4056, 3034.4325, 3163.4751, 3323.5057, 3410.5378, 3509.6062, 3622.6903, 3709.7223, 3837.7809, 3908.8180, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SAMTAYFLGFTVGNMLEIPLIYWPNQLMSYLIFR", {88.0393, 159.0764, 290.1169, 391.1646, 462.2017, 625.2650, 772.3334, 885.4175, 942.4390, 1089.5074, 1190.5551, 1289.6235, 1346.6449, 1460.6879, 1591.7283, 1704.8124, 1833.8550, 1946.9391, 2043.9918, 2157.0759, 2270.1600, 2433.2233, 2619.3026, 2716.3554, 2830.3983, 2958.4569, 3071.5409, 3202.5814, 3289.6134, 3452.6768, 3565.7608, 3678.8449, 3825.9133, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 435.2714, 548.3555, 711.4188, 798.4509, 929.4913, 1042.5754, 1170.6340, 1284.6769, 1381.7297, 1567.8090, 1730.8723, 1843.9564, 1957.0404, 2054.0932, 2167.1773, 2296.2199, 2409.3039, 2540.3444, 2654.3873, 2711.4088, 2810.4772, 2911.5249, 3058.5933, 3115.6148, 3228.6988, 3375.7672, 3538.8306, 3609.8677, 3710.9154, 3841.9559, 3912.9930, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ENENDEAQEDDEEEEQEYDSTNSEPQTVDPLYDK", {130.0499, 244.0928, 373.1354, 487.1783, 602.2053, 731.2479, 802.2850, 930.3435, 1059.3861, 1174.4131, 1289.4400, 1418.4826, 1547.5252, 1676.5678, 1805.6104, 1933.6690, 2062.7116, 2225.7749, 2340.8018, 2427.8339, 2528.8815, 2642.9245, 2729.9565, 2858.9991, 2956.0519, 3084.1104, 3185.1581, 3284.2265, 3399.2535, 3496.3062, 3609.3903, 3772.4536, 3887.4806, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 262.1397, 425.2031, 538.2871, 635.3399, 750.3668, 849.4353, 950.4829, 1078.5415, 1175.5943, 1304.6369, 1391.6689, 1505.7118, 1606.7595, 1693.7915, 1808.8185, 1971.8818, 2100.9244, 2228.9830, 2358.0256, 2487.0682, 2616.1108, 2745.1534, 2860.1803, 2975.2072, 3104.2498, 3232.3084, 3303.3455, 3432.3881, 3547.4151, 3661.4580, 3790.5006, 3904.5435, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"AYVTCIVILFIPYSFAIMYSADIYSDCVLLNDER", {72.0444, 235.1077, 334.1761, 435.2238, 595.2545, 708.3385, 807.4069, 920.4910, 1033.5751, 1180.6435, 1293.7275, 1390.7803, 1553.8436, 1640.8757, 1787.9441, 1858.9812, 1972.0653, 2103.1057, 2266.1691, 2353.2011, 2424.2382, 2539.2652, 2652.3492, 2815.4125, 2902.4446, 3017.4715, 3177.5022, 3276.5706, 3389.6546, 3502.7387, 3616.7816, 3731.8086, 3860.8512, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 419.1885, 533.2314, 646.3155, 759.3995, 858.4680, 1018.4986, 1133.5255, 1220.5576, 1383.6209, 1496.7050, 1611.7319, 1682.7690, 1769.8011, 1932.8644, 2063.9049, 2176.9889, 2248.0260, 2395.0945, 2482.1265, 2645.1898, 2742.2426, 2855.3266, 3002.3951, 3115.4791, 3228.5632, 3327.6316, 3440.7157, 3600.7463, 3701.7940, 3800.8624, 3963.9257, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PIISEMHQSQTGTHHSDDEFEMSEEDDFSIHLER", {98.0600, 211.1441, 324.2282, 411.2602, 540.3028, 671.3433, 808.4022, 936.4608, 1023.4928, 1151.5514, 1252.5990, 1309.6205, 1410.6682, 1547.7271, 1684.7860, 1771.8180, 1886.8450, 2001.8719, 2130.9145, 2277.9829, 2407.0255, 2538.0660, 2625.0980, 2754.1406, 2883.1832, 2998.2102, 3113.2371, 3260.3055, 3347.3376, 3460.4216, 3597.4805, 3710.5646, 3839.6072, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 417.2456, 554.3045, 667.3886, 754.4206, 901.4890, 1016.5160, 1131.5429, 1260.5855, 1389.6281, 1476.6601, 1607.7006, 1736.7432, 1883.8116, 2012.8542, 2127.8812, 2242.9081, 2329.9401, 2466.9990, 2604.0580, 2705.1056, 2762.1271, 2863.1748, 2991.2333, 3078.2654, 3206.3240, 3343.3829, 3474.4234, 3603.4659, 3690.4980, 3803.5820, 3916.6661, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TSVLGLLYIPFFLLSFNTFFWAAFFPASFYVPQR", {102.0550, 189.0870, 288.1554, 401.2395, 458.2609, 571.3450, 684.4291, 847.4924, 960.5764, 1057.6292, 1204.6976, 1351.7660, 1464.8501, 1577.9342, 1664.9662, 1812.0346, 1926.0775, 2027.1252, 2174.1936, 2321.2620, 2507.3414, 2578.3785, 2649.4156, 2796.4840, 2943.5524, 3040.6052, 3111.6423, 3198.6743, 3345.7427, 3508.8061, 3607.8745, 3704.9272, 3832.9858, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 400.2303, 499.2987, 662.3620, 809.4305, 896.4625, 967.4996, 1064.5524, 1211.6208, 1358.6892, 1429.7263, 1500.7634, 1686.8427, 1833.9111, 1980.9796, 2082.0272, 2196.0702, 2343.1386, 2430.1706, 2543.2547, 2656.3387, 2803.4071, 2950.4756, 3047.5283, 3160.6124, 3323.6757, 3436.7598, 3549.8438, 3606.8653, 3719.9494, 3819.0178, 3906.0498, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YQELQLSPQTLFAVALSFYSWWLQSDFAQPGLFR", {164.0706, 292.1292, 421.1718, 534.2558, 662.3144, 775.3985, 862.4305, 959.4833, 1087.5419, 1188.5895, 1301.6736, 1448.7420, 1519.7791, 1618.8475, 1689.8846, 1802.9687, 1890.0007, 2037.0692, 2200.1325, 2287.1645, 2473.2438, 2659.3231, 2772.4072, 2900.4658, 2987.4978, 3102.5248, 3249.5932, 3320.6303, 3448.6889, 3545.7416, 3602.7631, 3715.8471, 3862.9156, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 435.2714, 492.2929, 589.3457, 717.4042, 788.4413, 935.5098, 1050.5367, 1137.5687, 1265.6273, 1378.7114, 1564.7907, 1750.8700, 1837.9020, 2000.9654, 2148.0338, 2235.0658, 2348.1499, 2419.1870, 2518.2554, 2589.2925, 2736.3609, 2849.4450, 2950.4927, 3078.5512, 3175.6040, 3262.6360, 3375.7201, 3503.7787, 3616.8627, 3745.9053, 3873.9639, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ESMLSILMQLVDHLNEDEHMTTLYNLISQLEDEK", {130.0499, 217.0819, 348.1224, 461.2064, 548.2385, 661.3225, 774.4066, 905.4471, 1033.5057, 1146.5897, 1245.6581, 1360.6851, 1497.7440, 1610.8281, 1724.8710, 1853.9136, 1968.9405, 2097.9831, 2235.0420, 2366.0825, 2467.1302, 2568.1779, 2681.2619, 2844.3253, 2958.3682, 3071.4523, 3184.5363, 3271.5683, 3399.6269, 3512.7110, 3641.7536, 3756.7805, 3885.8231, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 276.1554, 391.1823, 520.2249, 633.3090, 761.3676, 848.3996, 961.4837, 1074.5677, 1188.6107, 1351.6740, 1464.7581, 1565.8057, 1666.8534, 1797.8939, 1934.9528, 2063.9954, 2179.0223, 2308.0649, 2422.1079, 2535.1919, 2672.2508, 2787.2778, 2886.3462, 2999.4303, 3127.4888, 3258.5293, 3371.6134, 3484.6974, 3571.7295, 3684.8135, 3815.8540, 3902.8861, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"GDFMTFLSHQHEDVVDMLIAFNTLHNCSCVSHTR", {58.0287, 173.0557, 320.1241, 451.1646, 552.2123, 699.2807, 812.3647, 899.3968, 1036.4557, 1164.5143, 1301.5732, 1430.6158, 1545.6427, 1644.7111, 1743.7795, 1858.8065, 1989.8470, 2102.9310, 2216.0151, 2287.0522, 2434.1206, 2548.1635, 2649.2112, 2762.2953, 2899.3542, 3013.3971, 3173.4278, 3260.4598, 3420.4905, 3519.5589, 3606.5909, 3743.6498, 3844.6975, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 276.1666, 413.2255, 500.2576, 599.3260, 759.3566, 846.3887, 1006.4193, 1120.4622, 1257.5211, 1370.6052, 1471.6529, 1585.6958, 1732.7642, 1803.8013, 1916.8854, 2029.9695, 2161.0100, 2276.0369, 2375.1053, 2474.1737, 2589.2007, 2718.2433, 2855.3022, 2983.3608, 3120.4197, 3207.4517, 3320.5358, 3467.6042, 3568.6519, 3699.6923, 3846.7608, 3961.7877, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"IYLYLYYVEYFSPPIYTSIVEAMPFAIGMVVLLK", {114.0913, 277.1547, 390.2387, 553.3021, 666.3861, 829.4495, 992.5128, 1091.5812, 1220.6238, 1383.6871, 1530.7555, 1617.7876, 1714.8403, 1811.8931, 1924.9772, 2088.0405, 2189.0882, 2276.1202, 2389.2043, 2488.2727, 2617.3153, 2688.3524, 2819.3929, 2916.4456, 3063.5140, 3134.5511, 3247.6352, 3304.6567, 3435.6972, 3534.7656, 3633.8340, 3746.9181, 3860.0021, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 373.2809, 472.3493, 571.4178, 702.4582, 759.4797, 872.5638, 943.6009, 1090.6693, 1187.7221, 1318.7625, 1389.7997, 1518.8423, 1617.9107, 1730.9947, 1818.0268, 1919.0744, 2082.1378, 2195.2218, 2292.2746, 2389.3274, 2476.3594, 2623.4278, 2786.4911, 2915.5337, 3014.6021, 3177.6655, 3340.7288, 3453.8129, 3616.8762, 3729.9603, 3893.0236, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"WTLIVSTVVFLALVVCGHIMPDTMQEYTLHCETR", {187.0866, 288.1343, 401.2183, 514.3024, 613.3708, 700.4028, 801.4505, 900.5189, 999.5873, 1146.6558, 1259.7398, 1330.7769, 1443.8610, 1542.9294, 1641.9978, 1802.0285, 1859.0499, 1996.1089, 2109.1929, 2240.2334, 2337.2862, 2452.3131, 2553.3608, 2684.4013, 2812.4598, 2941.5024, 3104.5658, 3205.6134, 3318.6975, 3455.7564, 3615.7871, 3744.8297, 3845.8773, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 276.1666, 405.2092, 565.2399, 702.2988, 815.3828, 916.4305, 1079.4939, 1208.5364, 1336.5950, 1467.6355, 1568.6832, 1683.7101, 1780.7629, 1911.8034, 2024.8874, 2161.9464, 2218.9678, 2378.9985, 2478.0669, 2577.1353, 2690.2194, 2761.2565, 2874.3405, 3021.4090, 3120.4774, 3219.5458, 3320.5935, 3407.6255, 3506.6939, 3619.7780, 3732.8620, 3833.9097, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FTAVQFLCLYANGVHDFNMASNVWTYNESECANR", {148.0757, 249.1234, 320.1605, 419.2289, 547.2875, 694.3559, 807.4400, 967.4706, 1080.5547, 1243.6180, 1314.6551, 1428.6980, 1485.7195, 1584.7879, 1721.8468, 1836.8738, 1983.9422, 2097.9851, 2229.0256, 2300.0627, 2387.0947, 2501.1377, 2600.2061, 2786.2854, 2887.3331, 3050.3964, 3164.4393, 3293.4819, 3380.5139, 3509.5565, 3669.5872, 3740.6243, 3854.6672, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 289.1619, 360.1990, 520.2296, 649.2722, 736.3043, 865.3469, 979.3898, 1142.4531, 1243.5008, 1429.5801, 1528.6485, 1642.6914, 1729.7235, 1800.7606, 1931.8011, 2045.8440, 2192.9124, 2307.9394, 2444.9983, 2544.0667, 2601.0881, 2715.1311, 2786.1682, 2949.2315, 3062.3156, 3222.3462, 3335.4303, 3482.4987, 3610.5573, 3709.6257, 3780.6628, 3881.7105, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NGIVVTALFFPICSVDGVYMCDWMSEIWEGCLVR", {115.0502, 172.0717, 285.1557, 384.2241, 483.2926, 584.3402, 655.3774, 768.4614, 915.5298, 1062.5982, 1159.6510, 1272.7351, 1432.7657, 1519.7977, 1618.8662, 1733.8931, 1790.9146, 1889.9830, 2053.0463, 2184.0868, 2344.1174, 2459.1444, 2645.2237, 2776.2642, 2863.2962, 2992.3388, 3105.4229, 3291.5022, 3420.5448, 3477.5662, 3637.5969, 3750.6810, 3849.7494, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 274.1874, 387.2714, 547.3021, 604.3235, 733.3661, 919.4454, 1032.5295, 1161.5721, 1248.6041, 1379.6446, 1565.7239, 1680.7509, 1840.7815, 1971.8220, 2134.8853, 2233.9538, 2290.9752, 2406.0022, 2505.0706, 2592.1026, 2752.1332, 2865.2173, 2962.2701, 3109.3385, 3256.4069, 3369.4910, 3440.5281, 3541.5758, 3640.6442, 3739.7126, 3852.7967, 3909.8181, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QINDQFGHVWQLEIATTYVLFLVFLSWMFLGASR", {129.0659, 242.1499, 356.1928, 471.2198, 599.2784, 746.3468, 803.3682, 940.4272, 1039.4956, 1225.5749, 1353.6335, 1466.7175, 1595.7601, 1708.8442, 1779.8813, 1880.9290, 1981.9767, 2145.0400, 2244.1084, 2357.1925, 2504.2609, 2617.3449, 2716.4134, 2863.4818, 2976.5658, 3063.5979, 3249.6772, 3380.7177, 3527.7861, 3640.8701, 3697.8916, 3768.9287, 3855.9607, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 262.1510, 333.1881, 390.2096, 503.2936, 650.3620, 781.4025, 967.4818, 1054.5139, 1167.5979, 1314.6663, 1413.7348, 1526.8188, 1673.8872, 1786.9713, 1886.0397, 2049.1030, 2150.1507, 2251.1984, 2322.2355, 2435.3196, 2564.3622, 2677.4462, 2805.5048, 2991.5841, 3090.6525, 3227.7114, 3284.7329, 3431.8013, 3559.8599, 3674.8868, 3788.9298, 3902.0138, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FNFTLCWWLTTTITIVLFIYITVGDDGYLVVQGR", {148.0757, 262.1186, 409.1870, 510.2347, 623.3188, 783.3494, 969.4287, 1155.5080, 1268.5921, 1369.6398, 1470.6875, 1571.7351, 1684.8192, 1785.8669, 1898.9510, 1998.0194, 2111.1034, 2258.1718, 2371.2559, 2534.3192, 2647.4033, 2748.4510, 2847.5194, 2904.5409, 3019.5678, 3134.5947, 3191.6162, 3354.6795, 3467.7636, 3566.8320, 3665.9004, 3793.9590, 3850.9805, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 232.1404, 360.1990, 459.2674, 558.3358, 671.4199, 834.4832, 891.5047, 1006.5316, 1121.5586, 1178.5800, 1277.6484, 1378.6961, 1491.7802, 1654.8435, 1767.9276, 1914.9960, 2028.0801, 2127.1485, 2240.2325, 2341.2802, 2454.3643, 2555.4120, 2656.4596, 2757.5073, 2870.5914, 3056.6707, 3242.7500, 3402.7806, 3515.8647, 3616.9124, 3763.9808, 3878.0237, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LMVLFSFFGIVFQLVFMGMTVFGLWSHLSYFNVK", {114.0913, 245.1318, 344.2002, 457.2843, 604.3527, 691.3847, 838.4532, 985.5216, 1042.5430, 1155.6271, 1254.6955, 1401.7639, 1529.8225, 1642.9066, 1741.9750, 1889.0434, 2020.0839, 2077.1053, 2208.1458, 2309.1935, 2408.2619, 2555.3303, 2612.3518, 2725.4359, 2911.5152, 2998.5472, 3135.6061, 3248.6902, 3335.7222, 3498.7855, 3645.8540, 3759.8969, 3858.9653, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 246.1812, 360.2241, 507.2926, 670.3559, 757.3879, 870.4720, 1007.5309, 1094.5629, 1280.6422, 1393.7263, 1450.7478, 1597.8162, 1696.8846, 1797.9323, 1928.9728, 1985.9942, 2117.0347, 2264.1031, 2363.1715, 2476.2556, 2604.3142, 2751.3826, 2850.4510, 2963.5351, 3020.5565, 3167.6249, 3314.6934, 3401.7254, 3548.7938, 3661.8779, 3760.9463, 3891.9868, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MVPMGVDVLMNECMPSMMVELLVEWSHLFTDPER", {132.0478, 231.1162, 328.1689, 459.2094, 516.2309, 615.2993, 730.3262, 829.3947, 942.4787, 1073.5192, 1187.5621, 1316.6047, 1476.6354, 1607.6759, 1704.7286, 1791.7607, 1922.8011, 2053.8416, 2152.9100, 2281.9526, 2395.0367, 2508.1208, 2607.1892, 2736.2318, 2922.3111, 3009.3431, 3146.4020, 3259.4861, 3406.5545, 3507.6022, 3622.6291, 3719.6819, 3848.7245, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 401.2143, 516.2413, 617.2889, 764.3573, 877.4414, 1014.5003, 1101.5323, 1287.6117, 1416.6543, 1515.7227, 1628.8067, 1741.8908, 1870.9334, 1970.0018, 2101.0423, 2232.0828, 2319.1148, 2416.1676, 2547.2081, 2707.2387, 2836.2813, 2950.3242, 3081.3647, 3194.4488, 3293.5172, 3408.5441, 3507.6125, 3564.6340, 3695.6745, 3792.7273, 3891.7957, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DVFFLNILNFIIHGVIGFTSLVCLFIIFVNLFTR", {116.0342, 215.1026, 362.1710, 509.2395, 622.3235, 736.3665, 849.4505, 962.5346, 1076.5775, 1223.6459, 1336.7300, 1449.8141, 1586.8730, 1643.8944, 1742.9628, 1856.0469, 1913.0684, 2060.1368, 2161.1845, 2248.2165, 2361.3006, 2460.3690, 2620.3996, 2733.4837, 2880.5521, 2993.6362, 3106.7202, 3253.7886, 3352.8570, 3466.9000, 3579.9840, 3727.0525, 3828.1001, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 276.1666, 423.2350, 536.3191, 650.3620, 749.4305, 896.4989, 1009.5829, 1122.6670, 1269.7354, 1382.8195, 1542.8501, 1641.9185, 1755.0026, 1842.0346, 1943.0823, 2090.1507, 2147.1722, 2260.2562, 2359.3247, 2416.3461, 2553.4050, 2666.4891, 2779.5732, 2926.6416, 3040.6845, 3153.7686, 3266.8526, 3380.8956, 3493.9796, 3641.0480, 3788.1165, 3887.1849, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ATWNAALLSTIVYYFICSLSFVAWCVFNVLSCLR", {72.0444, 173.0921, 359.1714, 473.2143, 544.2514, 615.2885, 728.3726, 841.4567, 928.4887, 1029.5364, 1142.6204, 1241.6888, 1404.7522, 1567.8155, 1714.8839, 1827.9680, 1987.9986, 2075.0307, 2188.1147, 2275.1468, 2422.2152, 2521.2836, 2592.3207, 2778.4000, 2938.4307, 3037.4991, 3184.5675, 3298.6104, 3397.6788, 3510.7629, 3597.7949, 3757.8256, 3870.9096, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 448.2337, 535.2657, 648.3498, 747.4182, 861.4611, 1008.5295, 1107.5979, 1267.6286, 1453.7079, 1524.7450, 1623.8134, 1770.8818, 1857.9139, 1970.9979, 2058.0300, 2218.0606, 2331.1447, 2478.2131, 2641.2764, 2804.3397, 2903.4081, 3016.4922, 3117.5399, 3204.5719, 3317.6560, 3430.7400, 3501.7772, 3572.8143, 3686.8572, 3872.9365, 3973.9842, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"HCNDVFASLPSVQVTYTDNASYEFLGYYPNFLER", {138.0662, 298.0968, 412.1398, 527.1667, 626.2351, 773.3035, 844.3406, 931.3727, 1044.4567, 1141.5095, 1228.5415, 1327.6099, 1455.6685, 1554.7369, 1655.7846, 1818.8479, 1919.8956, 2034.9226, 2148.9655, 2220.0026, 2307.0346, 2470.0980, 2599.1406, 2746.2090, 2859.2930, 2916.3145, 3079.3778, 3242.4412, 3339.4939, 3453.5368, 3600.6053, 3713.6893, 3842.7319, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 417.2456, 564.3140, 678.3570, 775.4097, 938.4730, 1101.5364, 1158.5578, 1271.6419, 1418.7103, 1547.7529, 1710.8162, 1797.8483, 1868.8854, 1982.9283, 2097.9552, 2199.0029, 2362.0663, 2463.1139, 2562.1823, 2690.2409, 2789.3093, 2876.3414, 2973.3941, 3086.4782, 3173.5102, 3244.5473, 3391.6158, 3490.6842, 3605.7111, 3719.7540, 3879.7847, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"CVAQAPLALFQPPCHFLDESHFMAVDGFDIFHYR", {161.0379, 260.1063, 331.1435, 459.2020, 530.2391, 627.2919, 740.3760, 811.4131, 924.4971, 1071.5656, 1199.6241, 1296.6769, 1393.7297, 1553.7603, 1690.8192, 1837.8876, 1950.9717, 2065.9987, 2195.0412, 2282.0733, 2419.1322, 2566.2006, 2697.2411, 2768.2782, 2867.3466, 2982.3736, 3039.3950, 3186.4634, 3301.4904, 3414.5744, 3561.6429, 3698.7018, 3861.7651, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 475.2412, 622.3096, 735.3937, 850.4206, 997.4890, 1054.5105, 1169.5374, 1268.6058, 1339.6430, 1470.6834, 1617.7519, 1754.8108, 1841.8428, 1970.8854, 2085.9123, 2198.9964, 2346.0648, 2483.1237, 2643.1544, 2740.2071, 2837.2599, 2965.3185, 3112.3869, 3225.4710, 3296.5081, 3409.5921, 3506.6449, 3577.6820, 3705.7406, 3776.7777, 3875.8461, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FDPMLENVQNILVNYVGSVIADFYCPILYRPINK", {148.0757, 263.1026, 360.1554, 491.1959, 604.2799, 733.3225, 847.3655, 946.4339, 1074.4925, 1188.5354, 1301.6194, 1414.7035, 1513.7719, 1627.8149, 1790.8782, 1889.9466, 1946.9681, 2034.0001, 2133.0685, 2246.1526, 2317.1897, 2432.2166, 2579.2850, 2742.3484, 2902.3790, 2999.4318, 3112.5158, 3225.5999, 3388.6632, 3544.7643, 3641.8171, 3754.9012, 3868.9441, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 261.1557, 374.2398, 471.2926, 627.3937, 790.4570, 903.5411, 1016.6251, 1113.6779, 1273.7085, 1436.7719, 1583.8403, 1698.8672, 1769.9043, 1882.9884, 1982.0568, 2069.0888, 2126.1103, 2225.1787, 2388.2421, 2502.2850, 2601.3534, 2714.4375, 2827.5215, 2941.5644, 3069.6230, 3168.6914, 3282.7344, 3411.7770, 3524.8610, 3655.9015, 3752.9543, 3867.9812, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NVEYVIHGHEFGTTLFLLIFCVIAVLLMYYSIQK", {115.0502, 214.1186, 343.1612, 506.2245, 605.2930, 718.3770, 855.4359, 912.4574, 1049.5163, 1178.5589, 1325.6273, 1382.6488, 1483.6965, 1584.7441, 1697.8282, 1844.8966, 1957.9807, 2071.0647, 2184.1488, 2331.2172, 2491.2479, 2590.3163, 2703.4003, 2774.4375, 2873.5059, 2986.5899, 3099.6740, 3230.7145, 3393.7778, 3556.8411, 3643.8732, 3756.9572, 3885.0158, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 275.1714, 388.2554, 475.2875, 638.3508, 801.4141, 932.4546, 1045.5387, 1158.6227, 1257.6912, 1328.7283, 1441.8123, 1540.8807, 1700.9114, 1847.9798, 1961.0639, 2074.1479, 2187.2320, 2334.3004, 2447.3845, 2548.4322, 2649.4798, 2706.5013, 2853.5697, 2982.6123, 3119.6712, 3176.6927, 3313.7516, 3426.8357, 3525.9041, 3688.9674, 3818.0100, 3917.0784, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FHYIGQLLEPYTSCNTATDQVPCHILEINDSNTR", {148.0757, 285.1346, 448.1979, 561.2820, 618.3035, 746.3620, 859.4461, 972.5302, 1101.5728, 1198.6255, 1361.6888, 1462.7365, 1549.7686, 1709.7992, 1823.8421, 1924.8898, 1995.9269, 2096.9746, 2212.0015, 2340.0601, 2439.1285, 2536.1813, 2696.2120, 2833.2709, 2946.3549, 3059.4390, 3188.4816, 3301.5656, 3415.6086, 3530.6355, 3617.6675, 3731.7105, 3832.7582, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 276.1666, 390.2096, 477.2416, 592.2685, 706.3115, 819.3955, 948.4381, 1061.5222, 1174.6062, 1311.6652, 1471.6958, 1568.7486, 1667.8170, 1795.8756, 1910.9025, 2011.9502, 2082.9873, 2184.0350, 2298.0779, 2458.1085, 2545.1406, 2646.1883, 2809.2516, 2906.3043, 3035.3469, 3148.4310, 3261.5151, 3389.5736, 3446.5951, 3559.6792, 3722.7425, 3859.8014, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EQDPTQPMTAAEHDLIYLEDIAIDCIYHLHEQAR", {130.0499, 258.1084, 373.1354, 470.1882, 571.2358, 699.2944, 796.3472, 927.3877, 1028.4353, 1099.4725, 1170.5096, 1299.5522, 1436.6111, 1551.6380, 1664.7221, 1777.8061, 1940.8695, 2053.9535, 2182.9961, 2298.0231, 2411.1071, 2482.1442, 2595.2283, 2710.2553, 2870.2859, 2983.3700, 3146.4333, 3283.4922, 3396.5763, 3533.6352, 3662.6778, 3790.7364, 3861.7735, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 246.1561, 374.2146, 503.2572, 640.3161, 753.4002, 890.4591, 1053.5225, 1166.6065, 1326.6372, 1441.6641, 1554.7482, 1625.7853, 1738.8694, 1853.8963, 1982.9389, 2096.0230, 2259.0863, 2372.1703, 2485.2544, 2600.2814, 2737.3403, 2866.3829, 2937.4200, 3008.4571, 3109.5048, 3240.5452, 3337.5980, 3465.6566, 3566.7043, 3663.7570, 3778.7840, 3906.8426, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VQEIHDTMEMNAPSTLWDLVEEEDDIDGDYNIYK", {100.0757, 228.1343, 357.1769, 470.2609, 607.3198, 722.3468, 823.3945, 954.4349, 1083.4775, 1214.5180, 1328.5609, 1399.5981, 1496.6508, 1583.6829, 1684.7305, 1797.8146, 1983.8939, 2098.9209, 2212.0049, 2311.0733, 2440.1159, 2569.1585, 2698.2011, 2813.2281, 2928.2550, 3041.3391, 3156.3660, 3213.3875, 3328.4144, 3491.4777, 3605.5207, 3718.6047, 3881.6681, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 310.1761, 423.2602, 537.3031, 700.3665, 815.3934, 872.4149, 987.4418, 1100.5259, 1215.5528, 1330.5798, 1459.6223, 1588.6649, 1717.7075, 1816.7759, 1929.8600, 2044.8870, 2230.9663, 2344.0503, 2445.0980, 2532.1300, 2629.1828, 2700.2199, 2814.2628, 2945.3033, 3074.3459, 3205.3864, 3306.4341, 3421.4610, 3558.5199, 3671.6040, 3800.6466, 3928.7052, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"CDTGVYGSDCECTSLDWSSQCSSHNPCHDPCQAR", {161.0379, 276.0649, 377.1125, 434.1340, 533.2024, 696.2658, 753.2872, 840.3192, 955.3462, 1115.3768, 1244.4194, 1404.4501, 1505.4978, 1592.5298, 1705.6138, 1820.6408, 2006.7201, 2093.7521, 2180.7842, 2308.8427, 2468.8734, 2555.9054, 2642.9374, 2779.9964, 2894.0393, 2991.0920, 3151.1227, 3288.1816, 3403.2086, 3500.2613, 3660.2920, 3788.3505, 3859.3877, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 246.1561, 374.2146, 534.2453, 631.2981, 746.3250, 883.3839, 1043.4146, 1140.4673, 1254.5103, 1391.5692, 1478.6012, 1565.6332, 1725.6639, 1853.7224, 1940.7545, 2027.7865, 2213.8658, 2328.8928, 2441.9768, 2529.0089, 2630.0565, 2790.0872, 2919.1298, 3079.1604, 3194.1874, 3281.2194, 3338.2409, 3501.3042, 3600.3726, 3657.3941, 3758.4417, 3873.4687, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TIVICGVLLFSIHQNWFAFDINFGCWHIAIELGR", {102.0550, 215.1390, 314.2074, 427.2915, 587.3221, 644.3436, 743.4120, 856.4961, 969.5802, 1116.6486, 1203.6806, 1316.7647, 1453.8236, 1581.8821, 1695.9251, 1882.0044, 2029.0728, 2100.1099, 2247.1783, 2362.2053, 2475.2893, 2589.3323, 2736.4007, 2793.4221, 2953.4528, 3139.5321, 3276.5910, 3389.6751, 3460.7122, 3573.7963, 3702.8388, 3815.9229, 3872.9444, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 232.1404, 345.2245, 474.2671, 587.3511, 658.3883, 771.4723, 908.5312, 1094.6105, 1254.6412, 1311.6627, 1458.7311, 1572.7740, 1685.8581, 1800.8850, 1947.9534, 2018.9905, 2166.0589, 2352.1383, 2466.1812, 2594.2398, 2731.2987, 2844.3827, 2931.4148, 3078.4832, 3191.5672, 3304.6513, 3403.7197, 3460.7412, 3620.7718, 3733.8559, 3832.9243, 3946.0084, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"CVHEECADYEYQCGIGSYDAPCSCNLGSGFDQCK", {161.0379, 260.1063, 397.1653, 526.2078, 655.2504, 815.2811, 886.3182, 1001.3451, 1164.4085, 1293.4511, 1456.5144, 1584.5730, 1744.6036, 1801.6251, 1914.7091, 1971.7306, 2058.7626, 2221.8260, 2336.8529, 2407.8900, 2504.9428, 2664.9734, 2752.0055, 2912.0361, 3026.0790, 3139.1631, 3196.1846, 3283.2166, 3340.2381, 3487.3065, 3602.3334, 3730.3920, 3890.4226, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 307.1435, 435.2020, 550.2290, 697.2974, 754.3189, 841.3509, 898.3723, 1011.4564, 1125.4993, 1285.5300, 1372.5620, 1532.5927, 1629.6454, 1700.6825, 1815.7095, 1978.7728, 2065.8048, 2122.8263, 2235.9104, 2292.9318, 2452.9625, 2581.0211, 2744.0844, 2873.1270, 3036.1903, 3151.2172, 3222.2544, 3382.2850, 3511.3276, 3640.3702, 3777.4291, 3876.4975, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LDTCNAGLLCPNESCDNINQECHIGEWGPVCECK", {114.0913, 229.1183, 330.1660, 490.1966, 604.2395, 675.2767, 732.2981, 845.3822, 958.4662, 1118.4969, 1215.5497, 1329.5926, 1458.6352, 1545.6672, 1705.6979, 1820.7248, 1934.7677, 2047.8518, 2161.8947, 2289.9533, 2418.9959, 2579.0265, 2716.0854, 2829.1695, 2886.1910, 3015.2336, 3201.3129, 3258.3343, 3355.3871, 3454.4555, 3614.4862, 3743.5288, 3903.5594, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 307.1435, 436.1860, 596.2167, 695.2851, 792.3379, 849.3593, 1035.4386, 1164.4812, 1221.5027, 1334.5868, 1471.6457, 1631.6763, 1760.7189, 1888.7775, 2002.8204, 2115.9045, 2229.9474, 2344.9744, 2505.0050, 2592.0370, 2721.0796, 2835.1226, 2932.1753, 3092.2060, 3205.2900, 3318.3741, 3375.3956, 3446.4327, 3560.4756, 3720.5063, 3821.5539, 3936.5809, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QFIPPENDVCPSYGYDYGLLPEQKPEECGMLEFK", {129.0659, 276.1343, 389.2183, 486.2711, 583.3239, 712.3665, 826.4094, 941.4363, 1040.5047, 1200.5354, 1297.5881, 1384.6202, 1547.6835, 1604.7050, 1767.7683, 1882.7952, 2045.8586, 2102.8800, 2215.9641, 2329.0482, 2426.1009, 2555.1435, 2683.2021, 2811.2971, 2908.3498, 3037.3924, 3166.4350, 3326.4657, 3383.4871, 3514.5276, 3627.6117, 3756.6543, 3903.7227, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 294.1812, 423.2238, 536.3079, 667.3484, 724.3698, 884.4005, 1013.4431, 1142.4857, 1239.5384, 1367.6334, 1495.6920, 1624.7346, 1721.7873, 1834.8714, 1947.9554, 2004.9769, 2168.0402, 2283.0672, 2446.1305, 2503.1520, 2666.2153, 2753.2473, 2850.3001, 3010.3307, 3109.3992, 3224.4261, 3338.4690, 3467.5116, 3564.5644, 3661.6172, 3774.7012, 3921.7696, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"HFSGNTNQCETTTLDCQSSSCENIDECTPPQEFK", {138.0662, 285.1346, 372.1666, 429.1881, 543.2310, 644.2787, 758.3216, 886.3802, 1046.4109, 1175.4534, 1276.5011, 1377.5488, 1478.5965, 1591.6805, 1706.7075, 1866.7381, 1994.7967, 2081.8287, 2168.8608, 2255.8928, 2415.9234, 2544.9660, 2659.0090, 2772.0930, 2887.1200, 3016.1626, 3176.1932, 3277.2409, 3374.2937, 3471.3464, 3599.4050, 3728.4476, 3875.5160, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 294.1812, 423.2238, 551.2824, 648.3352, 745.3879, 846.4356, 1006.4662, 1135.5088, 1250.5358, 1363.6198, 1477.6628, 1606.7054, 1766.7360, 1853.7680, 1940.8001, 2027.8321, 2155.8907, 2315.9213, 2430.9483, 2544.0323, 2645.0800, 2746.1277, 2847.1754, 2976.2180, 3136.2486, 3264.3072, 3378.3501, 3479.3978, 3593.4407, 3650.4622, 3737.4942, 3884.5626, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VQNIFVVIYCILDTNALLAYWSSILVEVIIHHDR", {100.0757, 228.1343, 342.1772, 455.2613, 602.3297, 701.3981, 800.4665, 913.5506, 1076.6139, 1236.6445, 1349.7286, 1462.8127, 1577.8396, 1678.8873, 1792.9302, 1863.9673, 1977.0514, 2090.1355, 2161.1726, 2324.2359, 2510.3152, 2597.3472, 2684.3793, 2797.4633, 2910.5474, 3009.6158, 3138.6584, 3237.7268, 3350.8109, 3463.8950, 3600.9539, 3738.0128, 3853.0397, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 290.1459, 427.2048, 564.2637, 677.3478, 790.4318, 889.5003, 1018.5429, 1117.6113, 1230.6953, 1343.7794, 1430.8114, 1517.8435, 1703.9228, 1866.9861, 1938.0232, 2051.1073, 2164.1913, 2235.2285, 2349.2714, 2450.3191, 2565.3460, 2678.4301, 2791.5141, 2951.5448, 3114.6081, 3227.6922, 3326.7606, 3425.8290, 3572.8974, 3685.9815, 3800.0244, 3928.0830, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QGAYYFEFGVDNASDLFIYCALFDFLLMTSCLPR", {129.0659, 186.0873, 257.1244, 420.1878, 583.2511, 730.3195, 859.3621, 1006.4305, 1063.4520, 1162.5204, 1277.5473, 1391.5903, 1462.6274, 1549.6594, 1664.6863, 1777.7704, 1924.8388, 2037.9229, 2200.9862, 2361.0169, 2432.0540, 2545.1380, 2692.2065, 2807.2334, 2954.3018, 3067.3859, 3180.4699, 3311.5104, 3412.5581, 3499.5901, 3659.6208, 3772.7048, 3869.7576, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 272.1717, 385.2558, 545.2864, 632.3185, 733.3661, 864.4066, 977.4907, 1090.5747, 1237.6432, 1352.6701, 1499.7385, 1612.8226, 1683.8597, 1843.8903, 2006.9537, 2120.0377, 2267.1062, 2380.1902, 2495.2172, 2582.2492, 2653.2863, 2767.3292, 2882.3562, 2981.4246, 3038.4460, 3185.5145, 3314.5571, 3461.6255, 3624.6888, 3787.7521, 3858.7892, 3915.8107, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FLNELEQSVQCEEDEPLNYDLATYVIEALESIIK", {148.0757, 261.1598, 375.2027, 504.2453, 617.3293, 746.3719, 874.4305, 961.4625, 1060.5310, 1188.5895, 1348.6202, 1477.6628, 1606.7054, 1721.7323, 1850.7749, 1947.8277, 2060.9117, 2174.9547, 2338.0180, 2453.0449, 2566.1290, 2637.1661, 2738.2138, 2901.2771, 3000.3455, 3113.4296, 3242.4722, 3313.5093, 3426.5934, 3555.6360, 3642.6680, 3755.7520, 3868.8361, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 373.2809, 460.3130, 589.3556, 702.4396, 773.4767, 902.5193, 1015.6034, 1114.6718, 1277.7351, 1378.7828, 1449.8199, 1562.9040, 1677.9309, 1840.9943, 1955.0372, 2068.1213, 2165.1740, 2294.2166, 2409.2436, 2538.2861, 2667.3287, 2827.3594, 2955.4180, 3054.4864, 3141.5184, 3269.5770, 3398.6196, 3511.7036, 3640.7462, 3754.7892, 3867.8732, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MQIGQGCSVSCGTWDEVEWHPCEEIICTEQTPPK", {132.0478, 260.1063, 373.1904, 430.2119, 558.2704, 615.2919, 775.3226, 862.3546, 961.4230, 1048.4550, 1208.4857, 1265.5071, 1366.5548, 1552.6341, 1667.6611, 1796.7037, 1895.7721, 2024.8147, 2210.8940, 2347.9529, 2445.0057, 2605.0363, 2734.0789, 2863.1215, 2976.2056, 3089.2896, 3249.3203, 3350.3680, 3479.4105, 3607.4691, 3708.5168, 3805.5696, 3902.6223, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 244.1656, 341.2183, 442.2660, 570.3246, 699.3672, 800.4149, 960.4455, 1073.5296, 1186.6136, 1315.6562, 1444.6988, 1604.7295, 1701.7822, 1838.8411, 2024.9205, 2153.9631, 2253.0315, 2382.0741, 2497.1010, 2683.1803, 2784.2280, 2841.2495, 3001.2801, 3088.3121, 3187.3805, 3274.4126, 3434.4432, 3491.4647, 3619.5233, 3676.5447, 3789.6288, 3917.6874, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"GQGCSVSCGTWDEVEWHPCEEIICTEQTPPKPTR", {58.0287, 186.0873, 243.1088, 403.1394, 490.1715, 589.2399, 676.2719, 836.3025, 893.3240, 994.3717, 1180.4510, 1295.4779, 1424.5205, 1523.5890, 1652.6315, 1838.7109, 1975.7698, 2072.8225, 2232.8532, 2361.8958, 2490.9384, 2604.0224, 2717.1065, 2877.1371, 2978.1848, 3107.2274, 3235.2860, 3336.3337, 3433.3864, 3530.4392, 3658.5342, 3755.5869, 3856.6346, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 276.1666, 373.2194, 501.3144, 598.3671, 695.4199, 796.4676, 924.5261, 1053.5687, 1154.6164, 1314.6471, 1427.7311, 1540.8152, 1669.8578, 1798.9004, 1958.9310, 2055.9838, 2193.0427, 2379.1220, 2508.1646, 2607.2330, 2736.2756, 2851.3026, 3037.3819, 3138.4295, 3195.4510, 3355.4817, 3442.5137, 3541.5821, 3628.6141, 3788.6448, 3845.6662, 3973.7248, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LFGMMICSETFSISGSWALVLLIITNFVYIFCDR", {114.0913, 261.1598, 318.1812, 449.2217, 580.2622, 693.3463, 853.3769, 940.4089, 1069.4515, 1170.4992, 1317.5676, 1404.5996, 1517.6837, 1604.7157, 1661.7372, 1748.7692, 1934.8485, 2005.8857, 2118.9697, 2218.0381, 2331.1222, 2444.2063, 2557.2903, 2670.3744, 2771.4221, 2885.4650, 3032.5334, 3131.6018, 3294.6652, 3407.7492, 3554.8176, 3714.8483, 3829.8752, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 290.1459, 450.1765, 597.2450, 710.3290, 873.3924, 972.4608, 1119.5292, 1233.5721, 1334.6198, 1447.7038, 1560.7879, 1673.8720, 1786.9560, 1886.0245, 1999.1085, 2070.1456, 2256.2249, 2343.2570, 2400.2784, 2487.3105, 2600.3945, 2687.4266, 2834.4950, 2935.5427, 3064.5852, 3151.6173, 3311.6479, 3424.7320, 3555.7725, 3686.8130, 3743.8344, 3890.9028, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QFYYIGGQIINPMGFLCSIVCVFLVVIEHYGLHR", {129.0659, 276.1343, 439.1976, 602.2609, 715.3450, 772.3665, 829.3879, 957.4465, 1070.5306, 1183.6146, 1297.6575, 1394.7103, 1525.7508, 1582.7723, 1729.8407, 1842.9247, 2002.9554, 2089.9874, 2203.0715, 2302.1399, 2462.1705, 2561.2390, 2708.3074, 2821.3914, 2920.4598, 3019.5283, 3132.6123, 3261.6549, 3398.7138, 3561.7772, 3618.7986, 3731.8827, 3868.9416, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 312.1779, 425.2619, 482.2834, 645.3467, 782.4056, 911.4482, 1024.5323, 1123.6007, 1222.6691, 1335.7532, 1482.8216, 1581.8900, 1741.9207, 1840.9891, 1954.0731, 2041.1052, 2201.1358, 2314.2199, 2461.2883, 2518.3098, 2649.3502, 2746.4030, 2860.4459, 2973.5300, 3086.6141, 3214.6726, 3271.6941, 3328.7156, 3441.7996, 3604.8630, 3767.9263, 3914.9947, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DTLLSVTELNTEWAMDHCPCHQSQLEVAQQLLTR", {116.0342, 217.0819, 330.1660, 443.2500, 530.2821, 629.3505, 730.3981, 859.4407, 972.5248, 1086.5677, 1187.6154, 1316.6580, 1502.7373, 1573.7744, 1704.8149, 1819.8419, 1956.9008, 2116.9314, 2213.9842, 2374.0148, 2511.0737, 2639.1323, 2726.1643, 2854.2229, 2967.3070, 3096.3496, 3195.4180, 3266.4551, 3394.5137, 3522.5723, 3635.6563, 3748.7404, 3849.7881, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 276.1666, 389.2507, 502.3348, 630.3933, 758.4519, 829.4890, 928.5574, 1057.6000, 1170.6841, 1298.7427, 1385.7747, 1513.8333, 1650.8922, 1810.9228, 1907.9756, 2068.0063, 2205.0652, 2320.0921, 2451.1326, 2522.1697, 2708.2490, 2837.2916, 2938.3393, 3052.3822, 3165.4663, 3294.5089, 3395.5566, 3494.6250, 3581.6570, 3694.7411, 3807.8251, 3908.8728, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TEFVNEEAVQEVEQGACAMDLEQIFYPEMTQEEK", {102.0550, 231.0975, 378.1660, 477.2344, 591.2773, 720.3199, 849.3625, 920.3996, 1019.4680, 1147.5266, 1276.5692, 1375.6376, 1504.6802, 1632.7388, 1689.7602, 1760.7974, 1920.8280, 1991.8651, 2122.9056, 2237.9325, 2351.0166, 2480.0592, 2608.1178, 2721.2018, 2868.2703, 3031.3336, 3128.3863, 3257.4289, 3388.4694, 3489.5171, 3617.5757, 3746.6183, 3875.6609, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 276.1554, 405.1980, 533.2566, 634.3042, 765.3447, 894.3873, 991.4401, 1154.5034, 1301.5718, 1414.6559, 1542.7145, 1671.7571, 1784.8411, 1899.8681, 2030.9086, 2101.9457, 2261.9763, 2333.0134, 2390.0349, 2518.0935, 2647.1361, 2746.2045, 2875.2471, 3003.3057, 3102.3741, 3173.4112, 3302.4538, 3431.4964, 3545.5393, 3644.6077, 3791.6761, 3920.7187, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LDMSFSLHCGVVLAVIMLLTCFFFCALLDPVWTR", {114.0913, 229.1183, 360.1588, 447.1908, 594.2592, 681.2912, 794.3753, 931.4342, 1091.4649, 1148.4863, 1247.5547, 1346.6232, 1459.7072, 1530.7443, 1629.8127, 1742.8968, 1873.9373, 1987.0214, 2100.1054, 2201.1531, 2361.1838, 2508.2522, 2655.3206, 2802.3890, 2962.4196, 3033.4568, 3146.5408, 3259.6249, 3374.6518, 3471.7046, 3570.7730, 3756.8523, 3857.9000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 276.1666, 462.2459, 561.3144, 658.3671, 773.3941, 886.4781, 999.5622, 1070.5993, 1230.6300, 1377.6984, 1524.7668, 1671.8352, 1831.8658, 1932.9135, 2045.9976, 2159.0817, 2290.1221, 2403.2062, 2502.2746, 2573.3117, 2686.3958, 2785.4642, 2884.5326, 2941.5541, 3101.5847, 3238.6436, 3351.7277, 3438.7597, 3585.8282, 3672.8602, 3803.9007, 3918.9276, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QAEEYSISEMSFSCKPDDFPFIHLSGQCSLILHR", {129.0659, 200.1030, 329.1456, 458.1882, 621.2515, 708.2835, 821.3676, 908.3996, 1037.4422, 1168.4827, 1255.5147, 1402.5831, 1489.6152, 1649.6458, 1777.7408, 1874.7935, 1989.8205, 2104.8474, 2251.9158, 2348.9686, 2496.0370, 2609.1211, 2746.1800, 2859.2640, 2946.2961, 3003.3175, 3131.3761, 3291.4068, 3378.4388, 3491.5229, 3604.6069, 3717.6910, 3854.7499, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 312.1779, 425.2619, 538.3460, 651.4301, 738.4621, 898.4927, 1026.5513, 1083.5728, 1170.6048, 1283.6889, 1420.7478, 1533.8318, 1680.9003, 1777.9530, 1925.0214, 2040.0484, 2155.0753, 2252.1281, 2380.2230, 2540.2537, 2627.2857, 2774.3541, 2861.3862, 2992.4267, 3121.4692, 3208.5013, 3321.5853, 3408.6174, 3571.6807, 3700.7233, 3829.7659, 3900.8030, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MIPFAVIPIMSTVYLPLAETVWFIAMVLLLYMCR", {132.0478, 245.1318, 342.1846, 489.2530, 560.2901, 659.3585, 772.4426, 869.4954, 982.5794, 1113.6199, 1200.6519, 1301.6996, 1400.7680, 1563.8314, 1676.9154, 1773.9682, 1887.0522, 1958.0894, 2087.1320, 2188.1796, 2287.2480, 2473.3274, 2620.3958, 2733.4798, 2804.5170, 2935.5574, 3034.6259, 3147.7099, 3260.7940, 3373.8780, 3536.9414, 3667.9819, 3828.0125, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 335.1496, 466.1901, 629.2534, 742.3375, 855.4215, 968.5056, 1067.5740, 1198.6145, 1269.6516, 1382.7357, 1529.8041, 1715.8834, 1814.9518, 1915.9995, 2045.0421, 2116.0792, 2229.1633, 2326.2160, 2439.3001, 2602.3634, 2701.4318, 2802.4795, 2889.5116, 3020.5520, 3133.6361, 3230.6889, 3343.7729, 3442.8413, 3513.8785, 3660.9469, 3757.9996, 3871.0837, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YEGPHVWSGTVIENEESEENDQFSLEQYLNNDSR", {164.0706, 293.1132, 350.1347, 447.1874, 584.2463, 683.3148, 869.3941, 956.4261, 1013.4476, 1114.4952, 1213.5636, 1326.6477, 1455.6903, 1569.7332, 1698.7758, 1827.8184, 1914.8504, 2043.8930, 2172.9356, 2286.9786, 2402.0055, 2530.0641, 2677.1325, 2764.1645, 2877.2486, 3006.2912, 3134.3498, 3297.4131, 3410.4972, 3524.5401, 3638.5830, 3753.6100, 3840.6420, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 262.1510, 377.1779, 491.2209, 605.2638, 718.3478, 881.4112, 1009.4697, 1138.5123, 1251.5964, 1338.6284, 1485.6968, 1613.7554, 1728.7824, 1842.8253, 1971.8679, 2100.9105, 2187.9425, 2316.9851, 2446.0277, 2560.0706, 2689.1132, 2802.1973, 2901.2657, 3002.3134, 3059.3348, 3146.3669, 3332.4462, 3431.5146, 3568.5735, 3665.6263, 3722.6477, 3851.6903, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"WFDASLFLVVFVFSTIFSDSFWGCFMYILIAAGR", {187.0866, 334.1550, 449.1819, 520.2191, 607.2511, 720.3352, 867.4036, 980.4876, 1079.5560, 1178.6245, 1325.6929, 1424.7613, 1571.8297, 1658.8617, 1759.9094, 1872.9935, 2020.0619, 2107.0939, 2222.1209, 2309.1529, 2456.2213, 2642.3006, 2699.3221, 2859.3527, 3006.4211, 3137.4616, 3300.5250, 3413.6090, 3526.6931, 3639.7771, 3710.8143, 3781.8514, 3838.8728, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 232.1404, 303.1775, 374.2146, 487.2987, 600.3828, 713.4668, 876.5302, 1007.5706, 1154.6391, 1314.6697, 1371.6912, 1557.7705, 1704.8389, 1791.8709, 1906.8979, 1993.9299, 2140.9983, 2254.0824, 2355.1301, 2442.1621, 2589.2305, 2688.2989, 2835.3673, 2934.4357, 3033.5042, 3146.5882, 3293.6566, 3406.7407, 3493.7727, 3564.8098, 3679.8368, 3826.9052, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"GWNWHNCQDISTENGFCMVQDLWIPGNSNGFINK", {58.0287, 244.1081, 358.1510, 544.2303, 681.2892, 795.3321, 955.3628, 1083.4214, 1198.4483, 1311.5324, 1398.5644, 1499.6121, 1628.6547, 1742.6976, 1799.7191, 1946.7875, 2106.8181, 2237.8586, 2336.9270, 2464.9856, 2580.0125, 2693.0966, 2879.1759, 2992.2600, 3089.3127, 3146.3342, 3260.3771, 3347.4092, 3461.4521, 3518.4736, 3665.5420, 3778.6260, 3892.6690, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 261.1557, 374.2398, 521.3082, 578.3297, 692.3726, 779.4046, 893.4476, 950.4690, 1047.5218, 1160.6058, 1346.6852, 1459.7692, 1574.7962, 1702.8547, 1801.9232, 1932.9636, 2092.9943, 2240.0627, 2297.0842, 2411.1271, 2540.1697, 2641.2174, 2728.2494, 2841.3335, 2956.3604, 3084.4190, 3244.4496, 3358.4926, 3495.5515, 3681.6308, 3795.6737, 3981.7530, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MAIISSVMVIILLILQCLTWTVPNGEDEHWEQDR", {132.0478, 203.0849, 316.1689, 429.2530, 516.2850, 603.3171, 702.3855, 833.4260, 932.4944, 1045.5784, 1158.6625, 1271.7466, 1384.8306, 1497.9147, 1610.9988, 1739.0573, 1899.0880, 2012.1720, 2113.2197, 2299.2990, 2400.3467, 2499.4151, 2596.4679, 2710.5108, 2767.5323, 2896.5749, 3011.6018, 3140.6444, 3277.7033, 3463.7826, 3592.8252, 3720.8838, 3835.9108, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 290.1459, 418.2045, 547.2471, 733.3264, 870.3853, 999.4279, 1114.4548, 1243.4974, 1300.5189, 1414.5618, 1511.6146, 1610.6830, 1711.7307, 1897.8100, 1998.8577, 2111.9417, 2271.9724, 2400.0309, 2513.1150, 2626.1991, 2739.2831, 2852.3672, 2965.4513, 3078.5353, 3177.6037, 3308.6442, 3407.7126, 3494.7447, 3581.7767, 3694.8608, 3807.9448, 3878.9819, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LDFNSQSDEEADEEEEGYEEDQEQSEEDDQANHK", {114.0913, 229.1183, 376.1867, 490.2296, 577.2617, 705.3202, 792.3523, 907.3792, 1036.4218, 1165.4644, 1236.5015, 1351.5284, 1480.5710, 1609.6136, 1738.6562, 1867.6988, 1924.7203, 2087.7836, 2216.8262, 2345.8688, 2460.8957, 2588.9543, 2717.9969, 2846.0555, 2933.0875, 3062.1301, 3191.1727, 3306.1996, 3421.2266, 3549.2852, 3620.3223, 3734.3652, 3871.4241, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 284.1717, 398.2146, 469.2518, 597.3103, 712.3373, 827.3642, 956.4068, 1085.4494, 1172.4814, 1300.5400, 1429.5826, 1557.6412, 1672.6681, 1801.7107, 1930.7533, 2093.8166, 2150.8381, 2279.8807, 2408.9233, 2537.9659, 2667.0085, 2782.0354, 2853.0725, 2982.1151, 3111.1577, 3226.1847, 3313.2167, 3441.2753, 3528.3073, 3642.3502, 3789.4186, 3904.4456, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"AAFVAIMEKPEVFNYYLNLNHNEPMSPLQFQLPR", {72.0444, 143.0815, 290.1499, 389.2183, 460.2554, 573.3395, 704.3800, 833.4226, 961.5176, 1058.5703, 1187.6129, 1286.6813, 1433.7497, 1547.7927, 1710.8560, 1873.9193, 1987.0034, 2101.0463, 2214.1304, 2328.1733, 2465.2322, 2579.2751, 2708.3177, 2805.3705, 2936.4110, 3023.4430, 3120.4958, 3233.5798, 3361.6384, 3508.7068, 3636.7654, 3749.8495, 3846.9022, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 272.1717, 385.2558, 513.3144, 660.3828, 788.4413, 901.5254, 998.5782, 1085.6102, 1216.6507, 1313.7035, 1442.7460, 1556.7890, 1693.8479, 1807.8908, 1920.9749, 2035.0178, 2148.1019, 2311.1652, 2474.2285, 2588.2715, 2735.3399, 2834.4083, 2963.4509, 3060.5036, 3188.5986, 3317.6412, 3448.6817, 3561.7657, 3632.8029, 3731.8713, 3878.9397, 3949.9768, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NSNTNHAMQELYVTWLQCLTFAHFLSSMHLVSTK", {115.0502, 202.0822, 316.1252, 417.1728, 531.2158, 668.2747, 739.3118, 870.3523, 998.4109, 1127.4534, 1240.5375, 1403.6008, 1502.6693, 1603.7169, 1789.7962, 1902.8803, 2030.9389, 2190.9695, 2304.0536, 2405.1013, 2552.1697, 2623.2068, 2760.2657, 2907.3341, 3020.4182, 3107.4502, 3194.4823, 3325.5227, 3462.5816, 3575.6657, 3674.7341, 3761.7662, 3862.8138, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 248.1605, 335.1925, 434.2609, 547.3450, 684.4039, 815.4444, 902.4764, 989.5084, 1102.5925, 1249.6609, 1386.7198, 1457.7569, 1604.8254, 1705.8730, 1818.9571, 1978.9878, 2107.0463, 2220.1304, 2406.2097, 2507.2574, 2606.3258, 2769.3891, 2882.4732, 3011.5158, 3139.5744, 3270.6148, 3341.6520, 3478.7109, 3592.7538, 3693.8015, 3807.8444, 3894.8764, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LDFILSLCAPYFTMFVVYNVLVSLVAFMCLVELR", {114.0913, 229.1183, 376.1867, 489.2708, 602.3548, 689.3869, 802.4709, 962.5016, 1033.5387, 1130.5914, 1293.6548, 1440.7232, 1541.7709, 1672.8113, 1819.8798, 1918.9482, 2018.0166, 2181.0799, 2295.1228, 2394.1913, 2507.2753, 2606.3437, 2693.3758, 2806.4598, 2905.5282, 2976.5654, 3123.6338, 3254.6743, 3414.7049, 3527.7890, 3626.8574, 3755.9000, 3868.9840, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 417.2456, 516.3140, 629.3981, 789.4287, 920.4692, 1067.5376, 1138.5747, 1237.6432, 1350.7272, 1437.7593, 1536.8277, 1649.9117, 1748.9801, 1863.0231, 2026.0864, 2125.1548, 2224.2232, 2371.2916, 2502.3321, 2603.3798, 2750.4482, 2913.5116, 3010.5643, 3081.6014, 3241.6321, 3354.7161, 3441.7482, 3554.8322, 3667.9163, 3814.9847, 3930.0117, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SGTYMLMFYFVGTLYVKPMEPNDEMIQYLLTAVR", {88.0393, 145.0608, 246.1084, 409.1718, 540.2123, 653.2963, 784.3368, 931.4052, 1094.4686, 1241.5370, 1340.6054, 1397.6268, 1498.6745, 1611.7586, 1774.8219, 1873.8903, 2001.9853, 2099.0381, 2230.0785, 2359.1211, 2456.1739, 2570.2168, 2685.2438, 2814.2864, 2945.3268, 3058.4109, 3186.4695, 3349.5328, 3462.6169, 3575.7009, 3676.7486, 3747.7857, 3846.8541, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 274.1874, 345.2245, 446.2722, 559.3562, 672.4403, 835.5036, 963.5622, 1076.6463, 1207.6867, 1336.7293, 1451.7563, 1565.7992, 1662.8520, 1791.8946, 1922.9350, 2019.9878, 2148.0828, 2247.1512, 2410.2145, 2523.2986, 2624.3463, 2681.3677, 2780.4361, 2927.5046, 3090.5679, 3237.6363, 3368.6768, 3481.7608, 3612.8013, 3775.8647, 3876.9123, 3933.9338, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YLPPPPQQHQLRPVPLHEYGQQYGSCDQCCGATR", {164.0706, 277.1547, 374.2074, 471.2602, 568.3130, 665.3657, 793.4243, 921.4829, 1058.5418, 1186.6004, 1299.6844, 1455.7855, 1552.8383, 1651.9067, 1748.9595, 1862.0435, 1999.1025, 2128.1451, 2291.2084, 2348.2298, 2476.2884, 2604.3470, 2767.4103, 2824.4318, 2911.4638, 3071.4945, 3186.5214, 3314.5800, 3474.6106, 3634.6413, 3691.6628, 3762.6999, 3863.7475, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 276.1666, 347.2037, 404.2252, 564.2559, 724.2865, 852.3451, 967.3720, 1127.4027, 1214.4347, 1271.4562, 1434.5195, 1562.5781, 1690.6367, 1747.6581, 1910.7214, 2039.7640, 2176.8229, 2289.9070, 2386.9598, 2486.0282, 2583.0810, 2739.1821, 2852.2661, 2980.3247, 3117.3836, 3245.4422, 3373.5008, 3470.5535, 3567.6063, 3664.6591, 3761.7118, 3874.7959, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EVLCAGMSGYVAQLFCCELSDTNYNQQVPEDYNK", {130.0499, 229.1183, 342.2023, 502.2330, 573.2701, 630.2916, 761.3321, 848.3641, 905.3856, 1068.4489, 1167.5173, 1238.5544, 1366.6130, 1479.6970, 1626.7655, 1786.7961, 1946.8268, 2075.8694, 2188.9534, 2275.9854, 2391.0124, 2492.0601, 2606.1030, 2769.1663, 2883.2092, 3011.2678, 3139.3264, 3238.3948, 3335.4476, 3464.4902, 3579.5171, 3742.5804, 3856.6234, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 261.1557, 424.2191, 539.2460, 668.2886, 765.3414, 864.4098, 992.4684, 1120.5269, 1234.5699, 1397.6332, 1511.6761, 1612.7238, 1727.7507, 1814.7828, 1927.8668, 2056.9094, 2216.9401, 2376.9707, 2524.0391, 2637.1232, 2765.1818, 2836.2189, 2935.2873, 3098.3506, 3155.3721, 3242.4041, 3373.4446, 3430.4661, 3501.5032, 3661.5338, 3774.6179, 3873.6863, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PAETIAPYCSTIIFYSHFPLWCIAFILVVVIMMK", {98.0600, 169.0972, 298.1397, 399.1874, 512.2715, 583.3086, 680.3614, 843.4247, 1003.4553, 1090.4874, 1191.5351, 1304.6191, 1417.7032, 1564.7716, 1727.8349, 1814.8670, 1951.9259, 2098.9943, 2196.0470, 2309.1311, 2495.2104, 2655.2411, 2768.3251, 2839.3622, 2986.4307, 3099.5147, 3212.5988, 3311.6672, 3410.7356, 3509.8040, 3622.8881, 3753.9286, 3884.9691, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 278.1533, 409.1938, 522.2778, 621.3463, 720.4147, 819.4831, 932.5671, 1045.6512, 1192.7196, 1263.7567, 1376.8408, 1536.8714, 1722.9508, 1836.0348, 1933.0876, 2080.1560, 2217.2149, 2304.2469, 2467.3103, 2614.3787, 2727.4627, 2840.5468, 2941.5945, 3028.6265, 3188.6572, 3351.7205, 3448.7733, 3519.8104, 3632.8944, 3733.9421, 3862.9847, 3934.0218, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LNPDYNPQFEASEEELAYYYINFQSNFISSNGNK", {114.0913, 228.1343, 325.1870, 440.2140, 603.2773, 717.3202, 814.3730, 942.4316, 1089.5000, 1218.5426, 1289.5797, 1376.6117, 1505.6543, 1634.6969, 1763.7395, 1876.8236, 1947.8607, 2110.9240, 2273.9873, 2437.0507, 2550.1347, 2664.1777, 2811.2461, 2939.3046, 3026.3367, 3140.3796, 3287.4480, 3400.5321, 3487.5641, 3574.5961, 3688.6391, 3745.6605, 3859.7035, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 261.1557, 318.1772, 432.2201, 519.2522, 606.2842, 719.3682, 866.4367, 980.4796, 1067.5116, 1195.5702, 1342.6386, 1456.6815, 1569.7656, 1732.8289, 1895.8923, 2058.9556, 2129.9927, 2243.0768, 2372.1194, 2501.1619, 2630.2045, 2717.2366, 2788.2737, 2917.3163, 3064.3847, 3192.4433, 3289.4960, 3403.5390, 3566.6023, 3681.6292, 3778.6820, 3892.7249, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QWHLVVLNTHVTQLTLNQPPKPFVAQFYSHPESR", {129.0659, 315.1452, 452.2041, 565.2881, 664.3566, 763.4250, 876.5090, 990.5520, 1091.5996, 1228.6586, 1327.7270, 1428.7746, 1556.8332, 1669.9173, 1770.9650, 1884.0490, 1998.0920, 2126.1505, 2223.2033, 2320.2561, 2448.3510, 2545.4038, 2692.4722, 2791.5406, 2862.5777, 2990.6363, 3137.7047, 3300.7681, 3387.8001, 3524.8590, 3621.9118, 3750.9543, 3837.9864, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 262.1510, 391.1936, 488.2463, 625.3052, 712.3373, 875.4006, 1022.4690, 1150.5276, 1221.5647, 1320.6331, 1467.7015, 1564.7543, 1692.8493, 1789.9020, 1886.9548, 2015.0134, 2129.0563, 2242.1404, 2343.1880, 2456.2721, 2584.3307, 2685.3784, 2784.4468, 2921.5057, 3022.5534, 3136.5963, 3249.6804, 3348.7488, 3447.8172, 3560.9012, 3697.9602, 3884.0395, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DSGYTSFEGDLFFDVFYIQGIVNVFNLAECVFFR", {116.0342, 203.0662, 260.0877, 423.1510, 524.1987, 611.2307, 758.2992, 887.3418, 944.3632, 1059.3902, 1172.4742, 1319.5426, 1466.6111, 1581.6380, 1680.7064, 1827.7748, 1990.8382, 2103.9222, 2231.9808, 2289.0023, 2402.0863, 2501.1547, 2615.1977, 2714.2661, 2861.3345, 2975.3774, 3088.4615, 3159.4986, 3288.5412, 3448.5718, 3547.6403, 3694.7087, 3841.7771, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 469.2558, 568.3242, 728.3548, 857.3974, 928.4345, 1041.5186, 1155.5615, 1302.6300, 1401.6984, 1515.7413, 1614.8097, 1727.8938, 1784.9152, 1912.9738, 2026.0579, 2189.1212, 2336.1896, 2435.2580, 2550.2850, 2697.3534, 2844.4218, 2957.5059, 3072.5328, 3129.5543, 3258.5969, 3405.6653, 3492.6973, 3593.7450, 3756.8083, 3813.8298, 3900.8618, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LIHACHTALELMPAMCDQLVQNQFHLLILEQGDR", {114.0913, 227.1754, 364.2343, 435.2714, 595.3021, 732.3610, 833.4087, 904.4458, 1017.5298, 1146.5724, 1259.6565, 1390.6970, 1487.7498, 1558.7869, 1689.8274, 1849.8580, 1964.8849, 2092.9435, 2206.0276, 2305.0960, 2433.1546, 2547.1975, 2675.2561, 2822.3245, 2959.3834, 3072.4675, 3185.5515, 3298.6356, 3411.7197, 3540.7623, 3668.8208, 3725.8423, 3840.8692, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 290.1459, 347.1674, 475.2259, 604.2685, 717.3526, 830.4367, 943.5207, 1056.6048, 1193.6637, 1340.7321, 1468.7907, 1582.8336, 1710.8922, 1809.9606, 1923.0447, 2051.1032, 2166.1302, 2326.1608, 2457.2013, 2528.2384, 2625.2912, 2756.3317, 2869.4158, 2998.4583, 3111.5424, 3182.5795, 3283.6272, 3420.6861, 3580.7168, 3651.7539, 3788.8128, 3901.8969, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"HVIEEHIVNFCMATLTMGSMIYVSCFWTTANSER", {138.0662, 237.1346, 350.2187, 479.2613, 608.3039, 745.3628, 858.4468, 957.5152, 1071.5582, 1218.6266, 1378.6572, 1509.6977, 1580.7348, 1681.7825, 1794.8666, 1895.9143, 2026.9547, 2083.9762, 2171.0082, 2302.0487, 2415.1328, 2578.1961, 2677.2645, 2764.2965, 2924.3272, 3071.3956, 3257.4749, 3358.5226, 3459.5703, 3530.6074, 3644.6503, 3731.6824, 3860.7249, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 391.1936, 505.2365, 576.2736, 677.3213, 778.3690, 964.4483, 1111.5167, 1271.5473, 1358.5794, 1457.6478, 1620.7111, 1733.7952, 1864.8357, 1951.8677, 2008.8892, 2139.9296, 2240.9773, 2354.0614, 2455.1091, 2526.1462, 2657.1867, 2817.2173, 2964.2857, 3078.3287, 3177.3971, 3290.4811, 3427.5400, 3556.5826, 3685.6252, 3798.7093, 3897.7777, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"GDHSMQGQDVGIVEGCYDCYEAFMTDFCALCYPK", {58.0287, 173.0557, 310.1146, 397.1466, 528.1871, 656.2457, 713.2671, 841.3257, 956.3527, 1055.4211, 1112.4425, 1225.5266, 1324.5950, 1453.6376, 1510.6591, 1670.6897, 1833.7531, 1948.7800, 2108.8107, 2271.8740, 2400.9166, 2471.9537, 2619.0221, 2750.0626, 2851.1103, 2966.1372, 3113.2056, 3273.2363, 3344.2734, 3457.3574, 3617.3881, 3780.4514, 3877.5042, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 244.1656, 407.2289, 567.2595, 680.3436, 751.3807, 911.4114, 1058.4798, 1173.5067, 1274.5544, 1405.5949, 1552.6633, 1623.7004, 1752.7430, 1915.8063, 2075.8370, 2190.8639, 2353.9273, 2513.9579, 2570.9794, 2700.0220, 2799.0904, 2912.1744, 2969.1959, 3068.2643, 3183.2913, 3311.3498, 3368.3713, 3496.4299, 3627.4704, 3714.5024, 3851.5613, 3966.5883, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FNDHHPPPVITPLNHQLAECLISDFVLYPRPIHK", {148.0757, 262.1186, 377.1456, 514.2045, 651.2634, 748.3161, 845.3689, 942.4217, 1041.4901, 1154.5742, 1255.6218, 1352.6746, 1465.7587, 1579.8016, 1716.8605, 1844.9191, 1958.0031, 2029.0403, 2158.0828, 2318.1135, 2431.1976, 2544.2816, 2631.3137, 2746.3406, 2893.4090, 2992.4774, 3105.5615, 3268.6248, 3365.6776, 3521.7787, 3618.8315, 3731.9155, 3868.9744, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 284.1717, 397.2558, 494.3085, 650.4097, 747.4624, 910.5257, 1023.6098, 1122.6782, 1269.7466, 1384.7736, 1471.8056, 1584.8897, 1697.9737, 1858.0044, 1987.0470, 2058.0841, 2171.1682, 2299.2267, 2436.2856, 2550.3286, 2663.4126, 2760.4654, 2861.5131, 2974.5971, 3073.6656, 3170.7183, 3267.7711, 3364.8239, 3501.8828, 3638.9417, 3753.9686, 3868.0115, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QAPADSPGNHLTHAFPNVLFCPLCVFWVCHDCNR", {129.0659, 200.1030, 297.1557, 368.1928, 483.2198, 570.2518, 667.3046, 724.3260, 838.3690, 975.4279, 1088.5119, 1189.5596, 1326.6185, 1397.6557, 1544.7241, 1641.7768, 1755.8198, 1854.8882, 1967.9722, 2115.0406, 2275.0713, 2372.1241, 2485.2081, 2645.2388, 2744.3072, 2891.3756, 3077.4549, 3176.5233, 3336.5540, 3473.6129, 3588.6398, 3748.6705, 3862.7134, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 289.1619, 449.1925, 564.2195, 701.2784, 861.3090, 960.3774, 1146.4568, 1293.5252, 1392.5936, 1552.6242, 1665.7083, 1762.7611, 1922.7917, 2069.8601, 2182.9442, 2282.0126, 2396.0555, 2493.1083, 2640.1767, 2711.2138, 2848.2727, 2949.3204, 3062.4045, 3199.4634, 3313.5063, 3370.5278, 3467.5805, 3554.6126, 3669.6395, 3740.6766, 3837.7294, 3908.7665, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"IDSCTFNANCTTNDTCFMSNQGSCNILSYNCNSR", {114.0913, 229.1183, 316.1503, 476.1810, 577.2286, 724.2971, 838.3400, 909.3771, 1023.4200, 1183.4507, 1284.4983, 1385.5460, 1499.5890, 1614.6159, 1715.6636, 1875.6942, 2022.7626, 2153.8031, 2240.8352, 2354.8781, 2482.9367, 2539.9581, 2626.9901, 2787.0208, 2901.0637, 3014.1478, 3127.2319, 3214.2639, 3377.3272, 3491.3701, 3651.4008, 3765.4437, 3852.4757, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 262.1510, 376.1939, 536.2246, 650.2675, 813.3308, 900.3628, 1013.4469, 1126.5310, 1240.5739, 1400.6045, 1487.6366, 1544.6580, 1672.7166, 1786.7595, 1873.7916, 2004.8321, 2151.9005, 2311.9311, 2412.9788, 2528.0057, 2642.0487, 2743.0963, 2844.1440, 3004.1747, 3118.2176, 3189.2547, 3303.2976, 3450.3661, 3551.4137, 3711.4444, 3798.4764, 3913.5034, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EMAMISVQFYDDTSVGFWEPSDLFQHPFVIHLAR", {130.0499, 261.0904, 332.1275, 463.1680, 576.2520, 663.2840, 762.3525, 890.4110, 1037.4795, 1200.5428, 1315.5697, 1430.5967, 1531.6443, 1618.6764, 1717.7448, 1774.7662, 1921.8347, 2107.9140, 2236.9566, 2334.0093, 2421.0414, 2536.0683, 2649.1524, 2796.2208, 2924.2794, 3061.3383, 3158.3910, 3305.4595, 3404.5279, 3517.6119, 3654.6708, 3767.7549, 3838.7920, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 246.1561, 359.2401, 496.2990, 609.3831, 708.4515, 855.5199, 952.5727, 1089.6316, 1217.6902, 1364.7586, 1477.8427, 1592.8696, 1679.9016, 1776.9544, 1905.9970, 2092.0763, 2239.1447, 2296.1662, 2395.2346, 2482.2666, 2583.3143, 2698.3412, 2813.3682, 2976.4315, 3123.4999, 3251.5585, 3350.6269, 3437.6590, 3550.7430, 3681.7835, 3752.8206, 3883.8611, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ALFALFLFAWGLQFYLHHPGLCQEISWDGPNISR", {72.0444, 185.1285, 332.1969, 403.2340, 516.3180, 663.3865, 776.4705, 923.5389, 994.5761, 1180.6554, 1237.6768, 1350.7609, 1478.8195, 1625.8879, 1788.9512, 1902.0353, 2039.0942, 2176.1531, 2273.2059, 2330.2273, 2443.3114, 2603.3420, 2731.4006, 2860.4432, 2973.5273, 3060.5593, 3246.6386, 3361.6656, 3418.6870, 3515.7398, 3629.7827, 3742.8668, 3829.8988, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 262.1510, 375.2350, 489.2780, 586.3307, 643.3522, 758.3791, 944.4585, 1031.4905, 1144.5745, 1273.6171, 1401.6757, 1561.7064, 1674.7904, 1731.8119, 1828.8647, 1965.9236, 2102.9825, 2216.0665, 2379.1299, 2526.1983, 2654.2569, 2767.3409, 2824.3624, 3010.4417, 3081.4788, 3228.5472, 3341.6313, 3488.6997, 3601.7838, 3672.8209, 3819.8893, 3932.9734, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EIDLLTMEHPQNLGEAMSYFHVFSDFCIFGVQTR", {130.0499, 243.1339, 358.1609, 471.2449, 584.3290, 685.3767, 816.4172, 945.4598, 1082.5187, 1179.5714, 1307.6300, 1421.6729, 1534.7570, 1591.7785, 1720.8211, 1791.8582, 1922.8987, 2009.9307, 2172.9940, 2320.0624, 2457.1213, 2556.1898, 2703.2582, 2790.2902, 2905.3171, 3052.3856, 3212.4162, 3325.5003, 3472.5687, 3529.5901, 3628.6586, 3756.7171, 3857.7648, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 276.1666, 404.2252, 503.2936, 560.3151, 707.3835, 820.4676, 980.4982, 1127.5666, 1242.5936, 1329.6256, 1476.6940, 1575.7624, 1712.8213, 1859.8898, 2022.9531, 2109.9851, 2241.0256, 2312.0627, 2441.1053, 2498.1268, 2611.2108, 2725.2538, 2853.3123, 2950.3651, 3087.4240, 3216.4666, 3347.5071, 3448.5548, 3561.6388, 3674.7229, 3789.7498, 3902.8339, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YSCDDDDFDLLGPVEMWFNGDEFYHVGAEVLVEK", {164.0706, 251.1026, 411.1333, 526.1602, 641.1872, 756.2141, 871.2411, 1018.3095, 1133.3364, 1246.4205, 1359.5045, 1416.5260, 1513.5788, 1612.6472, 1741.6898, 1872.7303, 2058.8096, 2205.8780, 2319.9209, 2376.9424, 2491.9693, 2621.0119, 2768.0803, 2931.1437, 3068.2026, 3167.2710, 3224.2924, 3295.3296, 3424.3722, 3523.4406, 3636.5246, 3735.5930, 3864.6356, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 276.1554, 375.2238, 488.3079, 587.3763, 716.4189, 787.4560, 844.4775, 943.5459, 1080.6048, 1243.6681, 1390.7365, 1519.7791, 1634.8061, 1691.8275, 1805.8705, 1952.9389, 2139.0182, 2270.0587, 2399.1013, 2498.1697, 2595.2224, 2652.2439, 2765.3280, 2878.4120, 2993.4390, 3140.5074, 3255.5343, 3370.5613, 3485.5882, 3600.6152, 3760.6458, 3847.6778, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VTLFTSPLNLFLESTFLNFSGHVNYADFCLFFIR", {100.0757, 201.1234, 314.2074, 461.2758, 562.3235, 649.3556, 746.4083, 859.4924, 973.5353, 1086.6194, 1233.6878, 1346.7719, 1475.8144, 1562.8465, 1663.8942, 1810.9626, 1924.0466, 2038.0896, 2185.1580, 2272.1900, 2329.2115, 2466.2704, 2565.3388, 2679.3817, 2842.4450, 2913.4822, 3028.5091, 3175.5775, 3335.6082, 3448.6922, 3595.7606, 3742.8291, 3855.9131, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 435.2714, 582.3398, 695.4239, 855.4546, 1002.5230, 1117.5499, 1188.5870, 1351.6504, 1465.6933, 1564.7617, 1701.8206, 1758.8421, 1845.8741, 1992.9425, 2106.9854, 2220.0695, 2367.1379, 2468.1856, 2555.2176, 2684.2602, 2797.3443, 2944.4127, 3057.4968, 3171.5397, 3284.6238, 3381.6765, 3468.7085, 3569.7562, 3716.8246, 3829.9087, 3930.9564, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FETQNTTQAQEHSLPFSHFNSNEALPFSHYTQLR", {148.0757, 277.1183, 378.1660, 506.2245, 620.2675, 721.3151, 822.3628, 950.4214, 1021.4585, 1149.5171, 1278.5597, 1415.6186, 1502.6506, 1615.7347, 1712.7875, 1859.8559, 1946.8879, 2083.9468, 2231.0152, 2345.0581, 2432.0902, 2546.1331, 2675.1757, 2746.2128, 2859.2969, 2956.3496, 3103.4181, 3190.4501, 3327.5090, 3490.5723, 3591.6200, 3719.6786, 3832.7626, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 416.2616, 517.3093, 680.3726, 817.4315, 904.4635, 1051.5320, 1148.5847, 1261.6688, 1332.7059, 1461.7485, 1575.7914, 1662.8234, 1776.8664, 1923.9348, 2060.9937, 2148.0257, 2295.0941, 2392.1469, 2505.2310, 2592.2630, 2729.3219, 2858.3645, 2986.4231, 3057.4602, 3185.5188, 3286.5665, 3387.6141, 3501.6571, 3629.7156, 3730.7633, 3859.8059, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MTASPLFFNKPQDTGPEETHETSNQLEYNEYYIK", {132.0478, 233.0954, 304.1326, 391.1646, 488.2173, 601.3014, 748.3698, 895.4382, 1009.4812, 1137.5761, 1234.6289, 1362.6875, 1477.7144, 1578.7621, 1635.7836, 1732.8363, 1861.8789, 1990.9215, 2091.9692, 2229.0281, 2358.0707, 2459.1184, 2546.1504, 2660.1933, 2788.2519, 2901.3360, 3030.3786, 3193.4419, 3307.4848, 3436.5274, 3599.5907, 3762.6541, 3875.7381, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 423.2602, 586.3235, 715.3661, 829.4090, 992.4724, 1121.5150, 1234.5990, 1362.6576, 1476.7005, 1563.7326, 1664.7802, 1793.8228, 1930.8817, 2031.9294, 2160.9720, 2290.0146, 2387.0674, 2444.0888, 2545.1365, 2660.1635, 2788.2220, 2885.2748, 3013.3698, 3127.4127, 3274.4811, 3421.5495, 3534.6336, 3631.6864, 3718.7184, 3789.7555, 3890.8032, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VQEYFGNPQISPTTQQLDMYYDEQESYISYSPVK", {100.0757, 228.1343, 357.1769, 520.2402, 667.3086, 724.3301, 838.3730, 935.4258, 1063.4843, 1176.5684, 1263.6004, 1360.6532, 1461.7009, 1562.7485, 1690.8071, 1818.8657, 1931.9498, 2046.9767, 2178.0172, 2341.0805, 2504.1439, 2619.1708, 2748.2134, 2876.2720, 3005.3146, 3092.3466, 3255.4099, 3368.4940, 3455.5260, 3618.5893, 3705.6214, 3802.6741, 3901.7425, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 246.1812, 343.2340, 430.2660, 593.3293, 680.3614, 793.4454, 956.5088, 1043.5408, 1172.5834, 1300.6420, 1429.6846, 1544.7115, 1707.7748, 1870.8382, 2001.8786, 2116.9056, 2229.9896, 2358.0482, 2486.1068, 2587.1545, 2688.2022, 2785.2549, 2872.2869, 2985.3710, 3113.4296, 3210.4824, 3324.5253, 3381.5467, 3528.6152, 3691.6785, 3820.7211, 3948.7797, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"IVLLPNCIAYFCHCFIIAQGVSICGYINQIANYK", {114.0913, 213.1598, 326.2438, 439.3279, 536.3806, 650.4236, 810.4542, 923.5383, 994.5754, 1157.6387, 1304.7071, 1464.7378, 1601.7967, 1761.8274, 1908.8958, 2021.9798, 2135.0639, 2206.1010, 2334.1596, 2391.1810, 2490.2495, 2577.2815, 2690.3656, 2850.3962, 2907.4177, 3070.4810, 3183.5651, 3297.6080, 3425.6666, 3538.7506, 3609.7877, 3723.8307, 3886.8940, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 310.1761, 424.2191, 495.2562, 608.3402, 736.3988, 850.4417, 963.5258, 1126.5891, 1183.6106, 1343.6412, 1456.7253, 1543.7573, 1642.8258, 1699.8472, 1827.9058, 1898.9429, 2012.0270, 2125.1110, 2272.1795, 2432.2101, 2569.2690, 2729.2997, 2876.3681, 3039.4314, 3110.4685, 3223.5526, 3383.5832, 3497.6262, 3594.6789, 3707.7630, 3820.8470, 3919.9155, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PYLSHLCPLVHPVCAHQLYHLVMLVLSYSSITMR", {98.0600, 261.1234, 374.2074, 461.2395, 598.2984, 711.3824, 871.4131, 968.4658, 1081.5499, 1180.6183, 1317.6772, 1414.7300, 1513.7984, 1673.8291, 1744.8662, 1881.9251, 2009.9837, 2123.0677, 2286.1311, 2423.1900, 2536.2740, 2635.3425, 2766.3829, 2879.4670, 2978.5354, 3091.6195, 3178.6515, 3341.7148, 3428.7469, 3515.7789, 3628.8630, 3729.9106, 3860.9511, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 306.1594, 407.2071, 520.2912, 607.3232, 694.3552, 857.4186, 944.4506, 1057.5347, 1156.6031, 1269.6871, 1400.7276, 1499.7960, 1612.8801, 1749.9390, 1913.0023, 2026.0864, 2154.1450, 2291.2039, 2362.2410, 2522.2717, 2621.3401, 2718.3928, 2855.4517, 2954.5202, 3067.6042, 3164.6570, 3324.6876, 3437.7717, 3574.8306, 3661.8626, 3774.9467, 3938.0100, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SLPYEQNILLDYSQQLDALVSSVNYLLVEFNHWK", {88.0393, 201.1234, 298.1761, 461.2395, 590.2821, 718.3406, 832.3836, 945.4676, 1058.5517, 1171.6358, 1286.6627, 1449.7260, 1536.7581, 1664.8166, 1792.8752, 1905.9593, 2020.9862, 2092.0233, 2205.1074, 2304.1758, 2391.2078, 2478.2399, 2577.3083, 2691.3512, 2854.4145, 2967.4986, 3080.5827, 3179.6511, 3308.6937, 3455.7621, 3569.8050, 3706.8639, 3892.9432, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 333.1921, 470.2510, 584.2940, 731.3624, 860.4050, 959.4734, 1072.5574, 1185.6415, 1348.7048, 1462.7478, 1561.8162, 1648.8482, 1735.8802, 1834.9486, 1948.0327, 2019.0698, 2134.0968, 2247.1808, 2375.2394, 2503.2980, 2590.3300, 2753.3933, 2868.4203, 2981.5044, 3094.5884, 3207.6725, 3321.7154, 3449.7740, 3578.8166, 3741.8799, 3838.9327, 3952.0167, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"GHQRPQPPIVPAGQQQYFQPPQQQYQHHSLPTQR", {58.0287, 195.0877, 323.1462, 479.2473, 576.3001, 704.3587, 801.4114, 898.4642, 1011.5483, 1110.6167, 1207.6695, 1278.7066, 1335.7280, 1463.7866, 1591.8452, 1719.9038, 1882.9671, 2030.0355, 2158.0941, 2255.1468, 2352.1996, 2480.2582, 2608.3168, 2736.3753, 2899.4387, 3027.4972, 3164.5562, 3301.6151, 3388.6471, 3501.7312, 3598.7839, 3699.8316, 3827.8902, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 404.2252, 501.2780, 614.3620, 701.3941, 838.4530, 975.5119, 1103.5705, 1266.6338, 1394.6924, 1522.7509, 1650.8095, 1747.8623, 1844.9151, 1972.9736, 2120.0420, 2283.1054, 2411.1640, 2539.2225, 2667.2811, 2724.3026, 2795.3397, 2892.3924, 2991.4609, 3104.5449, 3201.5977, 3298.6505, 3426.7090, 3523.7618, 3679.8629, 3807.9215, 3944.9804, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SQSNQQQALHQLFLDQQQQPHPPIQNQPFSSYQR", {88.0393, 216.0979, 303.1299, 417.1728, 545.2314, 673.2900, 801.3486, 872.3857, 985.4697, 1122.5287, 1250.5872, 1363.6713, 1510.7397, 1623.8238, 1738.8507, 1866.9093, 1994.9679, 2123.0265, 2251.0850, 2348.1378, 2485.1967, 2582.2495, 2679.3022, 2792.3863, 2920.4449, 3034.4878, 3162.5464, 3259.5991, 3406.6676, 3493.6996, 3580.7316, 3743.7949, 3871.8535, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 466.2409, 553.2729, 640.3049, 787.3733, 884.4261, 1012.4847, 1126.5276, 1254.5862, 1367.6702, 1464.7230, 1561.7758, 1698.8347, 1795.8874, 1923.9460, 2052.0046, 2180.0632, 2308.1218, 2423.1487, 2536.2328, 2683.3012, 2796.3852, 2924.4438, 3061.5027, 3174.5868, 3245.6239, 3373.6825, 3501.7411, 3629.7996, 3743.8426, 3830.8746, 3958.9332, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TWSEESNPPSDVFNIVQEYDSGIHQHHYGSIFHR", {102.0550, 288.1343, 375.1663, 504.2089, 633.2515, 720.2835, 834.3264, 931.3792, 1028.4320, 1115.4640, 1230.4909, 1329.5594, 1476.6278, 1590.6707, 1703.7548, 1802.8232, 1930.8817, 2059.9243, 2222.9877, 2338.0146, 2425.0466, 2482.0681, 2595.1522, 2732.2111, 2860.2697, 2997.3286, 3134.3875, 3297.4508, 3354.4723, 3441.5043, 3554.5884, 3701.6568, 3838.7157, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 312.1779, 459.2463, 572.3303, 659.3624, 716.3838, 879.4472, 1016.5061, 1153.5650, 1281.6236, 1418.6825, 1531.7665, 1588.7880, 1675.8200, 1790.8470, 1953.9103, 2082.9529, 2211.0115, 2310.0799, 2423.1640, 2537.2069, 2684.2753, 2783.3437, 2898.3707, 2985.4027, 3082.4554, 3179.5082, 3293.5511, 3380.5832, 3509.6258, 3638.6683, 3725.7004, 3911.7797, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TPFHDMEGECNLDEEEFDEYEDILIISSDPPTPK", {102.0550, 199.1077, 346.1761, 483.2350, 598.2620, 729.3025, 858.3451, 915.3665, 1044.4091, 1204.4398, 1318.4827, 1431.5668, 1546.5937, 1675.6363, 1804.6789, 1933.7215, 2080.7899, 2195.8168, 2324.8594, 2487.9228, 2616.9654, 2731.9923, 2845.0764, 2958.1604, 3071.2445, 3184.3286, 3271.3606, 3358.3926, 3473.4196, 3570.4723, 3667.5251, 3768.5728, 3865.6255, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 244.1656, 345.2132, 442.2660, 539.3188, 654.3457, 741.3777, 828.4098, 941.4938, 1054.5779, 1167.6620, 1280.7460, 1395.7730, 1524.8156, 1687.8789, 1816.9215, 1931.9484, 2079.0168, 2208.0594, 2337.1020, 2466.1446, 2581.1716, 2694.2556, 2808.2986, 2968.3292, 3097.3718, 3154.3933, 3283.4359, 3414.4763, 3529.5033, 3666.5622, 3813.6306, 3910.6834, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DNTTTEITPLNYQEVCINEEPLDDIVDEEVIEEK", {116.0342, 230.0771, 331.1248, 432.1725, 533.2202, 662.2628, 775.3468, 876.3945, 973.4473, 1086.5313, 1200.5743, 1363.6376, 1491.6962, 1620.7388, 1719.8072, 1879.8378, 1992.9219, 2106.9648, 2236.0074, 2365.0500, 2462.1028, 2575.1868, 2690.2138, 2805.2407, 2918.3248, 3017.3932, 3132.4201, 3261.4627, 3390.5053, 3489.5737, 3602.6578, 3731.7004, 3860.7430, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 276.1554, 405.1980, 518.2821, 617.3505, 746.3931, 875.4357, 990.4626, 1089.5310, 1202.6151, 1317.6420, 1432.6690, 1545.7530, 1642.8058, 1771.8484, 1900.8910, 2014.9339, 2128.0180, 2288.0486, 2387.1170, 2516.1596, 2644.2182, 2807.2815, 2921.3245, 3034.4085, 3131.4613, 3232.5090, 3345.5930, 3474.6356, 3575.6833, 3676.7310, 3777.7787, 3891.8216, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SFQPSEDHLDCCFDHMTDVSNLECDEDLAPPTSR", {88.0393, 235.1077, 363.1663, 460.2191, 547.2511, 676.2937, 791.3206, 928.3795, 1041.4636, 1156.4905, 1316.5212, 1476.5518, 1623.6203, 1738.6472, 1875.7061, 2006.7466, 2107.7943, 2222.8212, 2321.8896, 2408.9217, 2522.9646, 2636.0486, 2765.0912, 2925.1219, 3040.1488, 3169.1914, 3284.2184, 3397.3024, 3468.3395, 3565.3923, 3662.4451, 3763.4928, 3850.5248, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 262.1510, 363.1987, 460.2514, 557.3042, 628.3413, 741.4254, 856.4523, 985.4949, 1100.5218, 1260.5525, 1389.5951, 1502.6791, 1616.7221, 1703.7541, 1802.8225, 1917.8495, 2018.8971, 2149.9376, 2286.9965, 2402.0235, 2549.0919, 2709.1225, 2869.1532, 2984.1801, 3097.2642, 3234.3231, 3349.3501, 3478.3926, 3565.4247, 3662.4774, 3790.5360, 3937.6044, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LLLFHESEDYGLMFCTDLLEVTPSGYEQLSTFLR", {114.0913, 227.1754, 340.2595, 487.3279, 624.3868, 753.4294, 840.4614, 969.5040, 1084.5310, 1247.5943, 1304.6157, 1417.6998, 1548.7403, 1695.8087, 1855.8394, 1956.8870, 2071.9140, 2184.9980, 2298.0821, 2427.1247, 2526.1931, 2627.2408, 2724.2936, 2811.3256, 2868.3470, 3031.4104, 3160.4530, 3288.5115, 3401.5956, 3488.6276, 3589.6753, 3736.7437, 3849.8278, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 435.2714, 536.3191, 623.3511, 736.4352, 864.4938, 993.5364, 1156.5997, 1213.6212, 1300.6532, 1397.7060, 1498.7536, 1597.8220, 1726.8646, 1839.9487, 1953.0328, 2068.0597, 2169.1074, 2329.1380, 2476.2065, 2607.2469, 2720.3310, 2777.3525, 2940.4158, 3055.4427, 3184.4853, 3271.5174, 3400.5600, 3537.6189, 3684.6873, 3797.7713, 3910.8554, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"HQQQQHQQHQQHAQHHAHQQQAQSLAHHQAALHK", {138.0662, 266.1248, 394.1833, 522.2419, 650.3005, 787.3594, 915.4180, 1043.4766, 1180.5355, 1308.5941, 1436.6526, 1573.7115, 1644.7487, 1772.8072, 1909.8661, 2046.9251, 2117.9622, 2255.0211, 2383.0797, 2511.1382, 2639.1968, 2710.2339, 2838.2925, 2925.3245, 3038.4086, 3109.4457, 3246.5046, 3383.5635, 3511.6221, 3582.6592, 3653.6963, 3766.7804, 3903.8393, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 284.1717, 397.2558, 468.2929, 539.3300, 667.3886, 804.4475, 941.5064, 1012.5435, 1125.6276, 1212.6596, 1340.7182, 1411.7553, 1539.8139, 1667.8725, 1795.9310, 1932.9900, 2004.0271, 2141.0860, 2278.1449, 2406.2035, 2477.2406, 2614.2995, 2742.3581, 2870.4166, 3007.4756, 3135.5341, 3263.5927, 3400.6516, 3528.7102, 3656.7688, 3784.8274, 3912.8859, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VFDYLMINMEDNDCLQSQEGIETELDPMSLPLER", {100.0757, 247.1441, 362.1710, 525.2344, 638.3184, 769.3589, 882.4430, 996.4859, 1127.5264, 1256.5690, 1371.5959, 1485.6389, 1600.6658, 1760.6965, 1873.7805, 2001.8391, 2088.8711, 2216.9297, 2345.9723, 2402.9938, 2516.0778, 2645.1204, 2746.1681, 2875.2107, 2988.2948, 3103.3217, 3200.3745, 3331.4149, 3418.4470, 3531.5310, 3628.5838, 3741.6679, 3870.7105, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 417.2456, 514.2984, 627.3824, 714.4145, 845.4550, 942.5077, 1057.5347, 1170.6187, 1299.6613, 1400.7090, 1529.7516, 1642.8357, 1699.8571, 1828.8997, 1956.9583, 2043.9903, 2172.0489, 2285.1330, 2445.1636, 2560.1905, 2674.2335, 2789.2604, 2918.3030, 3049.3435, 3163.3864, 3276.4705, 3407.5110, 3520.5950, 3683.6584, 3798.6853, 3945.7537, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SQEGIETELDPMSLPLERPNQFVENPEDICEEQK", {88.0393, 216.0979, 345.1405, 402.1619, 515.2460, 644.2886, 745.3363, 874.3789, 987.4629, 1102.4899, 1199.5426, 1330.5831, 1417.6152, 1530.6992, 1627.7520, 1740.8360, 1869.8786, 2025.9797, 2123.0325, 2237.0754, 2365.1340, 2512.2024, 2611.2708, 2740.3134, 2854.3564, 2951.4091, 3080.4517, 3195.4787, 3308.5627, 3468.5934, 3597.6360, 3726.6786, 3854.7371, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 275.1714, 404.2140, 533.2566, 693.2872, 806.3713, 921.3982, 1050.4408, 1147.4936, 1261.5365, 1390.5791, 1489.6475, 1636.7159, 1764.7745, 1878.8174, 1975.8702, 2131.9713, 2261.0139, 2374.0980, 2471.1507, 2584.2348, 2671.2668, 2802.3073, 2899.3601, 3014.3870, 3127.4711, 3256.5137, 3357.5613, 3486.6039, 3599.6880, 3656.7095, 3785.7521, 3913.8106, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ECIPSWTLNAMYLSSITDQTLIYPNSWNAIDYIK", {130.0499, 290.0805, 403.1646, 500.2173, 587.2494, 773.3287, 874.3764, 987.4604, 1101.5034, 1172.5405, 1303.5810, 1466.6443, 1579.7283, 1666.7604, 1753.7924, 1866.8765, 1967.9241, 2082.9511, 2211.0097, 2312.0573, 2425.1414, 2538.2255, 2701.2888, 2798.3416, 2912.3845, 2999.4165, 3185.4958, 3299.5388, 3370.5759, 3483.6599, 3598.6869, 3761.7502, 3874.8343, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 423.2602, 538.2871, 651.3712, 722.4083, 836.4512, 1022.5306, 1109.5626, 1223.6055, 1320.6583, 1483.7216, 1596.8057, 1709.8897, 1810.9374, 1938.9960, 2054.0229, 2155.0706, 2268.1547, 2355.1867, 2442.2187, 2555.3028, 2718.3661, 2849.4066, 2920.4437, 3034.4867, 3147.5707, 3248.6184, 3434.6977, 3521.7297, 3618.7825, 3731.8666, 3891.8972, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ILLWHETCHGTYPLLLMHQLLSLMHPYAPSHSLK", {114.0913, 227.1754, 340.2595, 526.3388, 663.3977, 792.4403, 893.4880, 1053.5186, 1190.5775, 1247.5990, 1348.6467, 1511.7100, 1608.7628, 1721.8468, 1834.9309, 1948.0150, 2079.0554, 2216.1143, 2344.1729, 2457.2570, 2570.3411, 2657.3731, 2770.4571, 2901.4976, 3038.5565, 3135.6093, 3298.6726, 3369.7097, 3466.7625, 3553.7945, 3690.8535, 3777.8855, 3890.9695, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 347.2289, 484.2878, 571.3198, 668.3726, 739.4097, 902.4730, 999.5258, 1136.5847, 1267.6252, 1380.7093, 1467.7413, 1580.8254, 1693.9094, 1821.9680, 1959.0269, 2090.0674, 2203.1515, 2316.2355, 2429.3196, 2526.3724, 2689.4357, 2790.4834, 2847.5048, 2984.5637, 3144.5944, 3245.6421, 3374.6847, 3511.7436, 3697.8229, 3810.9069, 3923.9910, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PCELEYTSPNNIPNIISEYFSELELSQSLEHAQR", {98.0600, 258.0907, 387.1333, 500.2173, 629.2599, 792.3233, 893.3709, 980.4030, 1077.4557, 1191.4987, 1305.5416, 1418.6257, 1515.6784, 1629.7213, 1742.8054, 1855.8895, 1942.9215, 2071.9641, 2235.0274, 2382.0958, 2469.1279, 2598.1705, 2711.2545, 2840.2971, 2953.3812, 3040.4132, 3168.4718, 3255.5038, 3368.5879, 3497.6305, 3634.6894, 3705.7265, 3833.7851, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 374.2146, 511.2736, 640.3161, 753.4002, 840.4322, 968.4908, 1055.5228, 1168.6069, 1297.6495, 1410.7336, 1539.7762, 1626.8082, 1773.8766, 1936.9399, 2065.9825, 2153.0146, 2266.0986, 2379.1827, 2493.2256, 2590.2784, 2703.3624, 2817.4054, 2931.4483, 3028.5011, 3115.5331, 3216.5808, 3379.6441, 3508.6867, 3621.7707, 3750.8133, 3910.8440, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DGEFSEICSCKPQHNQTSCVANFGCIGICPDECR", {116.0342, 173.0557, 302.0983, 449.1667, 536.1987, 665.2413, 778.3254, 938.3560, 1025.3881, 1185.4187, 1313.5137, 1410.5664, 1538.6250, 1675.6839, 1789.7268, 1917.7854, 2018.8331, 2105.8651, 2265.8958, 2364.9642, 2436.0013, 2550.0442, 2697.1126, 2754.1341, 2914.1648, 3027.2488, 3084.2703, 3197.3544, 3357.3850, 3454.4378, 3569.4647, 3698.5073, 3858.5379, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 335.1496, 464.1922, 579.2191, 676.2719, 836.3025, 949.3866, 1006.4081, 1119.4921, 1279.5228, 1336.5443, 1483.6127, 1597.6556, 1668.6927, 1767.7611, 1927.7918, 2014.8238, 2115.8715, 2243.9301, 2357.9730, 2495.0319, 2623.0905, 2720.1432, 2848.2382, 3008.2688, 3095.3009, 3255.3315, 3368.4156, 3497.4582, 3584.4902, 3731.5586, 3860.6012, 3917.6227, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VDCPHQCLQNICAETVGCDSDDTCEISTQTTVCK", {100.0757, 215.1026, 375.1333, 472.1860, 609.2450, 737.3035, 897.3342, 1010.4182, 1138.4768, 1252.5198, 1365.6038, 1525.6345, 1596.6716, 1725.7142, 1826.7619, 1925.8303, 1982.8517, 2142.8824, 2257.9093, 2344.9413, 2459.9683, 2574.9952, 2676.0429, 2836.0736, 2965.1162, 3078.2002, 3165.2322, 3266.2799, 3394.3385, 3495.3862, 3596.4339, 3695.5023, 3855.5329, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 307.1435, 406.2119, 507.2595, 608.3072, 736.3658, 837.4135, 924.4455, 1037.5296, 1166.5722, 1326.6028, 1427.6505, 1542.6774, 1657.7044, 1744.7364, 1859.7633, 2019.7940, 2076.8155, 2175.8839, 2276.9316, 2405.9741, 2477.0113, 2637.0419, 2750.1260, 2864.1689, 2992.2275, 3105.3115, 3265.3422, 3393.4008, 3530.4597, 3627.5124, 3787.5431, 3902.5700, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"IFLPNNCPDTCQGYQGCQLTEPCESDTSCPIQEK", {114.0913, 261.1598, 374.2438, 471.2966, 585.3395, 699.3824, 859.4131, 956.4658, 1071.4928, 1172.5405, 1332.5711, 1460.6297, 1517.6512, 1680.7145, 1808.7731, 1865.7945, 2025.8252, 2153.8838, 2266.9678, 2368.0155, 2497.0581, 2594.1109, 2754.1415, 2883.1841, 2970.2161, 3085.2431, 3186.2907, 3273.3228, 3433.3534, 3530.4062, 3643.4903, 3771.5488, 3900.5914, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 276.1554, 404.2140, 517.2980, 614.3508, 774.3815, 861.4135, 962.4612, 1077.4881, 1164.5201, 1293.5627, 1453.5934, 1550.6461, 1679.6887, 1780.7364, 1893.8205, 2021.8790, 2181.9097, 2238.9312, 2366.9897, 2530.0531, 2587.0745, 2715.1331, 2875.1638, 2976.2114, 3091.2384, 3188.2911, 3348.3218, 3462.3647, 3576.4076, 3673.4604, 3786.5445, 3933.6129, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"CQNEICEANNTCDFNSSCLINVDVQECAVKPDPK", {161.0379, 289.0965, 403.1394, 532.1820, 645.2661, 805.2967, 934.3393, 1005.3764, 1119.4194, 1233.4623, 1334.5100, 1494.5406, 1609.5676, 1756.6360, 1870.6789, 1957.7109, 2044.7430, 2204.7736, 2317.8577, 2430.9417, 2544.9847, 2644.0531, 2759.0800, 2858.1484, 2986.2070, 3115.2496, 3275.2803, 3346.3174, 3445.3858, 3573.4808, 3670.5335, 3785.5605, 3882.6132, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 244.1656, 359.1925, 456.2453, 584.3402, 683.4087, 754.4458, 914.4764, 1043.5190, 1171.5776, 1270.6460, 1385.6729, 1484.7414, 1598.7843, 1711.8683, 1824.9524, 1984.9831, 2072.0151, 2159.0471, 2273.0900, 2420.1585, 2535.1854, 2695.2160, 2796.2637, 2910.3067, 3024.3496, 3095.3867, 3224.4293, 3384.4599, 3497.5440, 3626.5866, 3740.6295, 3868.6881, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QLNPEQLTDDQLNPEQLNPEQLNPEQLNPEQLFK", {129.0659, 242.1499, 356.1928, 453.2456, 582.2882, 710.3468, 823.4308, 924.4785, 1039.5055, 1154.5324, 1282.5910, 1395.6751, 1509.7180, 1606.7707, 1735.8133, 1863.8719, 1976.9560, 2090.9989, 2188.0517, 2317.0943, 2445.1528, 2558.2369, 2672.2798, 2769.3326, 2898.3752, 3026.4338, 3139.5178, 3253.5608, 3350.6135, 3479.6561, 3607.7147, 3720.7988, 3867.8672, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 294.1812, 407.2653, 535.3239, 664.3665, 761.4192, 875.4621, 988.5462, 1116.6048, 1245.6474, 1342.7001, 1456.7431, 1569.8271, 1697.8857, 1826.9283, 1923.9811, 2038.0240, 2151.1081, 2279.1666, 2408.2092, 2505.2620, 2619.3049, 2732.3890, 2860.4476, 2975.4745, 3090.5015, 3191.5491, 3304.6332, 3432.6918, 3561.7344, 3658.7871, 3772.8301, 3885.9141, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QSTHQPASTYSHSTYQSRPQSYSQPQHLLPYLER", {129.0659, 216.0979, 317.1456, 454.2045, 582.2631, 679.3158, 750.3529, 837.3850, 938.4326, 1101.4960, 1188.5280, 1325.5869, 1412.6189, 1513.6666, 1676.7299, 1804.7885, 1891.8205, 2047.9217, 2144.9744, 2273.0330, 2360.0650, 2523.1284, 2610.1604, 2738.2190, 2835.2717, 2963.3303, 3100.3892, 3213.4733, 3326.5573, 3423.6101, 3586.6734, 3699.7575, 3828.8001, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 417.2456, 580.3089, 677.3617, 790.4458, 903.5298, 1040.5887, 1168.6473, 1265.7001, 1393.7587, 1480.7907, 1643.8540, 1730.8860, 1858.9446, 1955.9974, 2112.0985, 2199.1305, 2327.1891, 2490.2524, 2591.3001, 2678.3321, 2815.3911, 2902.4231, 3065.4864, 3166.5341, 3253.5661, 3324.6032, 3421.6560, 3549.7146, 3686.7735, 3787.8212, 3874.8532, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EPLLENLLPFLVQHFCSCWETGSLTQLDHVLLAR", {130.0499, 227.1026, 340.1867, 453.2708, 582.3134, 696.3563, 809.4403, 922.5244, 1019.5772, 1166.6456, 1279.7297, 1378.7981, 1506.8566, 1643.9156, 1790.9840, 1951.0146, 2038.0466, 2198.0773, 2384.1566, 2513.1992, 2614.2469, 2671.2683, 2758.3004, 2871.3844, 2972.4321, 3100.4907, 3213.5748, 3328.6017, 3465.6606, 3564.7290, 3677.8131, 3790.8972, 3861.9343, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 246.1561, 359.2401, 472.3242, 571.3926, 708.4515, 823.4785, 936.5625, 1064.6211, 1165.6688, 1278.7528, 1365.7849, 1422.8063, 1523.8540, 1652.8966, 1838.9759, 1999.0066, 2086.0386, 2246.0692, 2393.1377, 2530.1966, 2658.2552, 2757.3236, 2870.4076, 3017.4760, 3114.5288, 3227.6129, 3340.6969, 3454.7399, 3583.7825, 3696.8665, 3809.9506, 3907.0033, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"AYDQQGHGHHQQVPQGQGDNQCFDAYQIFNQYNR", {72.0444, 235.1077, 350.1347, 478.1932, 606.2518, 663.2733, 800.3322, 857.3537, 994.4126, 1131.4715, 1259.5301, 1387.5886, 1486.6570, 1583.7098, 1711.7684, 1768.7899, 1896.8484, 1953.8699, 2068.8968, 2182.9398, 2310.9983, 2471.0290, 2618.0974, 2733.1243, 2804.1615, 2967.2248, 3095.2834, 3208.3674, 3355.4358, 3469.4788, 3597.5374, 3760.6007, 3874.6436, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 289.1619, 452.2252, 580.2838, 694.3267, 841.3951, 954.4792, 1082.5378, 1245.6011, 1316.6382, 1431.6652, 1578.7336, 1738.7642, 1866.8228, 1980.8657, 2095.8927, 2152.9141, 2280.9727, 2337.9942, 2466.0527, 2563.1055, 2662.1739, 2790.2325, 2918.2911, 3055.3500, 3192.4089, 3249.4304, 3386.4893, 3443.5107, 3571.5693, 3699.6279, 3814.6548, 3977.7182, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PIQQIFQNQWGQSPDAQWTPYFAMPAMPQQPQDK", {98.0600, 211.1441, 339.2027, 467.2613, 580.3453, 727.4137, 855.4723, 969.5152, 1097.5738, 1283.6531, 1340.6746, 1468.7332, 1555.7652, 1652.8180, 1767.8449, 1838.8820, 1966.9406, 2153.0199, 2254.0676, 2351.1204, 2514.1837, 2661.2521, 2732.2892, 2863.3297, 2960.3825, 3031.4196, 3162.4601, 3259.5128, 3387.5714, 3515.6300, 3612.6827, 3740.7413, 3855.7683, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 262.1397, 390.1983, 487.2511, 615.3097, 743.3682, 840.4210, 971.4615, 1042.4986, 1139.5514, 1270.5919, 1341.6290, 1488.6974, 1651.7607, 1748.8135, 1849.8612, 2035.9405, 2163.9990, 2235.0362, 2350.0631, 2447.1159, 2534.1479, 2662.2065, 2719.2279, 2905.3072, 3033.3658, 3147.4088, 3275.4673, 3422.5357, 3535.6198, 3663.6784, 3791.7370, 3904.8210, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PPCSCSFTDVGDICVGGNMCRPGLQCEDYQFECK", {98.0600, 195.1128, 355.1435, 442.1755, 602.2061, 689.2382, 836.3066, 937.3543, 1052.3812, 1151.4496, 1208.4711, 1323.4980, 1436.5821, 1596.6127, 1695.6811, 1752.7026, 1809.7241, 1923.7670, 2054.8075, 2214.8381, 2370.9392, 2467.9920, 2525.0135, 2638.0975, 2766.1561, 2926.1868, 3055.2294, 3170.2563, 3333.3196, 3461.3782, 3608.4466, 3737.4892, 3897.5199, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 307.1435, 436.1860, 583.2545, 711.3130, 874.3764, 989.4033, 1118.4459, 1278.4766, 1406.5351, 1519.6192, 1576.6407, 1673.6934, 1829.7945, 1989.8252, 2120.8657, 2234.9086, 2291.9301, 2348.9515, 2448.0199, 2608.0506, 2721.1346, 2836.1616, 2893.1831, 2992.2515, 3107.2784, 3208.3261, 3355.3945, 3442.4265, 3602.4572, 3689.4892, 3849.5199, 3946.5726, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"CITIVCEELFESDGDYYITSGMESIDVYGVYYPR", {161.0379, 274.1220, 375.1697, 488.2537, 587.3221, 747.3528, 876.3954, 1005.4380, 1118.5220, 1265.5905, 1394.6331, 1481.6651, 1596.6920, 1653.7135, 1768.7404, 1931.8038, 2094.8671, 2207.9512, 2308.9988, 2396.0309, 2453.0523, 2584.0928, 2713.1354, 2800.1674, 2913.2515, 3028.2784, 3127.3468, 3290.4102, 3347.4316, 3446.5001, 3609.5634, 3772.6267, 3869.6795, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 272.1717, 435.2350, 598.2984, 697.3668, 754.3883, 917.4516, 1016.5200, 1131.5469, 1244.6310, 1331.6630, 1460.7056, 1591.7461, 1648.7676, 1735.7996, 1836.8473, 1949.9313, 2112.9947, 2276.0580, 2391.0849, 2448.1064, 2563.1333, 2650.1654, 2779.2080, 2926.2764, 3039.3604, 3168.4030, 3297.4456, 3457.4763, 3556.5447, 3669.6288, 3770.6764, 3883.7605, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LQQRPHWNEFLGLAEFIMPLFFSLLTMTVNVANR", {114.0913, 242.1499, 370.2085, 526.3096, 623.3624, 760.4213, 946.5006, 1060.5435, 1189.5861, 1336.6545, 1449.7386, 1506.7601, 1619.8441, 1690.8812, 1819.9238, 1966.9922, 2080.0763, 2211.1168, 2308.1696, 2421.2536, 2568.3220, 2715.3904, 2802.4225, 2915.5065, 3028.5906, 3129.6383, 3260.6788, 3361.7264, 3460.7949, 3574.8378, 3673.9062, 3744.9433, 3858.9862, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 289.1619, 360.1990, 459.2674, 573.3103, 672.3787, 773.4264, 904.4669, 1005.5146, 1118.5987, 1231.6827, 1318.7147, 1465.7832, 1612.8516, 1725.9356, 1822.9884, 1954.0289, 2067.1130, 2214.1814, 2343.2240, 2414.2611, 2527.3451, 2584.3666, 2697.4507, 2844.5191, 2973.5617, 3087.6046, 3273.6839, 3410.7428, 3507.7956, 3663.8967, 3791.9553, 3920.0139, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TYYVFFLGLYDFFVSHGESHAETDYMEEANSISR", {102.0550, 265.1183, 428.1816, 527.2500, 674.3184, 821.3869, 934.4709, 991.4924, 1104.5764, 1267.6398, 1382.6667, 1529.7351, 1676.8035, 1775.8720, 1862.9040, 1999.9629, 2056.9844, 2186.0270, 2273.0590, 2410.1179, 2481.1550, 2610.1976, 2711.2453, 2826.2722, 2989.3356, 3120.3760, 3249.4186, 3378.4612, 3449.4983, 3563.5413, 3650.5733, 3763.6574, 3850.6894, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 262.1510, 375.2350, 462.2671, 576.3100, 647.3471, 776.3897, 905.4323, 1036.4728, 1199.5361, 1314.5631, 1415.6107, 1544.6533, 1615.6904, 1752.7494, 1839.7814, 1968.8240, 2025.8454, 2162.9044, 2249.9364, 2349.0048, 2496.0732, 2643.1416, 2758.1686, 2921.2319, 3034.3160, 3091.3374, 3204.4215, 3351.4899, 3498.5583, 3597.6267, 3760.6901, 3923.7534, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LYVLTANLNLGCFWGLGHMLQLYWQVLSSWFIAK", {114.0913, 277.1547, 376.2231, 489.3071, 590.3548, 661.3919, 775.4349, 888.5189, 1002.5619, 1115.6459, 1172.6674, 1332.6980, 1479.7664, 1665.8458, 1722.8672, 1835.9513, 1892.9728, 2030.0317, 2161.0721, 2274.1562, 2402.2148, 2515.2989, 2678.3622, 2864.4415, 2992.5001, 3091.5685, 3204.6526, 3291.6846, 3378.7166, 3564.7959, 3711.8643, 3824.9484, 3895.9855, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 218.1499, 331.2340, 478.3024, 664.3817, 751.4137, 838.4458, 951.5298, 1050.5982, 1178.6568, 1364.7361, 1527.7995, 1640.8835, 1768.9421, 1882.0262, 2013.0667, 2150.1256, 2207.1470, 2320.2311, 2377.2526, 2563.3319, 2710.4003, 2870.4309, 2927.4524, 3040.5365, 3154.5794, 3267.6635, 3381.7064, 3452.7435, 3553.7912, 3666.8752, 3765.9436, 3929.0070, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YWEIFLNPDEKPEVNAELHIPQAESLHFEAQLPK", {164.0706, 350.1499, 479.1925, 592.2766, 739.3450, 852.4291, 966.4720, 1063.5247, 1178.5517, 1307.5943, 1435.6892, 1532.7420, 1661.7846, 1760.8530, 1874.8959, 1945.9331, 2074.9756, 2188.0597, 2325.1186, 2438.2027, 2535.2555, 2663.3140, 2734.3511, 2863.3937, 2950.4258, 3063.5098, 3200.5687, 3347.6372, 3476.6797, 3547.7169, 3675.7754, 3788.8595, 3885.9123, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 244.1656, 357.2496, 485.3082, 556.3453, 685.3879, 832.4563, 969.5152, 1082.5993, 1169.6313, 1298.6739, 1369.7110, 1497.7696, 1594.8224, 1707.9064, 1844.9654, 1958.0494, 2087.0920, 2158.1291, 2272.1721, 2371.2405, 2500.2831, 2597.3358, 2725.4308, 2854.4734, 2969.5003, 3066.5531, 3180.5960, 3293.6801, 3440.7485, 3553.8326, 3682.8752, 3868.9545, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LPVDEEDDNMEDADDDHDNYNMTSDEEAYSQEHK", {114.0913, 211.1441, 310.2125, 425.2395, 554.2821, 683.3246, 798.3516, 913.3785, 1027.4215, 1158.4619, 1287.5045, 1402.5315, 1473.5686, 1588.5955, 1703.6225, 1818.6494, 1955.7083, 2070.7353, 2184.7782, 2347.8415, 2461.8845, 2592.9249, 2693.9726, 2781.0047, 2896.0316, 3025.0742, 3154.1168, 3225.1539, 3388.2172, 3475.2493, 3603.3078, 3732.3504, 3869.4093, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 284.1717, 413.2143, 541.2729, 628.3049, 791.3682, 862.4054, 991.4480, 1120.4905, 1235.5175, 1322.5495, 1423.5972, 1554.6377, 1668.6806, 1831.7439, 1945.7869, 2060.8138, 2197.8727, 2312.8997, 2427.9266, 2542.9535, 2613.9907, 2729.0176, 2858.0602, 2989.1007, 3103.1436, 3218.1706, 3333.1975, 3462.2401, 3591.2827, 3706.3096, 3805.3780, 3902.4308, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DEEEETYDYDLSDVVSSEAISELEEDEQSALWER", {116.0342, 245.0768, 374.1194, 503.1620, 632.2046, 733.2523, 896.3156, 1011.3425, 1174.4059, 1289.4328, 1402.5169, 1489.5489, 1604.5758, 1703.6443, 1802.7127, 1889.7447, 1976.7767, 2105.8193, 2176.8564, 2289.9405, 2376.9725, 2506.0151, 2619.0992, 2748.1418, 2877.1844, 2992.2113, 3121.2539, 3249.3125, 3336.3445, 3407.3816, 3520.4657, 3706.5450, 3835.5876, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 490.2409, 603.3249, 674.3620, 761.3941, 889.4526, 1018.4952, 1133.5222, 1262.5648, 1391.6074, 1504.6914, 1633.7340, 1720.7661, 1833.8501, 1904.8872, 2033.9298, 2120.9618, 2207.9939, 2307.0623, 2406.1307, 2521.1576, 2608.1897, 2721.2737, 2836.3007, 2999.3640, 3114.3910, 3277.4543, 3378.5020, 3507.5446, 3636.5871, 3765.6297, 3894.6723, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ESQLPYVATEPQCNIHCGDDPEQYAYAQDSDWLK", {130.0499, 217.0819, 345.1405, 458.2245, 555.2773, 718.3406, 817.4090, 888.4462, 989.4938, 1118.5364, 1215.5892, 1343.6478, 1503.6784, 1617.7213, 1730.8054, 1867.8643, 2027.8950, 2084.9164, 2199.9434, 2314.9703, 2412.0231, 2541.0657, 2669.1243, 2832.1876, 2903.2247, 3066.2880, 3137.3251, 3265.3837, 3380.4107, 3467.4427, 3582.4696, 3768.5489, 3881.6330, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 446.2762, 561.3031, 648.3352, 763.3621, 891.4207, 962.4578, 1125.5211, 1196.5582, 1359.6216, 1487.6801, 1616.7227, 1713.7755, 1828.8024, 1943.8294, 2000.8508, 2160.8815, 2297.9404, 2411.0245, 2525.0674, 2685.0980, 2813.1566, 2910.2094, 3039.2520, 3140.2997, 3211.3368, 3310.4052, 3473.4685, 3570.5213, 3683.6053, 3811.6639, 3898.6959, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NYLWTGILLMCNLLIPISFVTSIFLGNSDFYQQR", {115.0502, 278.1135, 391.1976, 577.2769, 678.3246, 735.3461, 848.4301, 961.5142, 1074.5982, 1205.6387, 1365.6694, 1479.7123, 1592.7964, 1705.8804, 1818.9645, 1916.0173, 2029.1013, 2116.1334, 2263.2018, 2362.2702, 2463.3179, 2550.3499, 2663.4340, 2810.5024, 2923.5864, 2980.6079, 3094.6508, 3181.6828, 3296.7098, 3443.7782, 3606.8415, 3734.9001, 3862.9587, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 431.2361, 594.2994, 741.3678, 856.3948, 943.4268, 1057.4697, 1114.4912, 1227.5753, 1374.6437, 1487.7278, 1574.7598, 1675.8075, 1774.8759, 1921.9443, 2008.9763, 2122.0604, 2219.1131, 2332.1972, 2445.2813, 2558.3653, 2672.4083, 2832.4389, 2963.4794, 3076.5635, 3189.6475, 3302.7316, 3359.7531, 3460.8007, 3646.8800, 3759.9641, 3923.0274, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EVDSVEFTLHYLEETHNVGLLEIFFSHPIPIEQR", {130.0499, 229.1183, 344.1452, 431.1773, 530.2457, 659.2883, 806.3567, 907.4044, 1020.4884, 1157.5473, 1320.6107, 1433.6947, 1562.7373, 1691.7799, 1792.8276, 1929.8865, 2043.9294, 2142.9978, 2200.0193, 2313.1034, 2426.1874, 2555.2300, 2668.3141, 2815.3825, 2962.4509, 3049.4829, 3186.5419, 3283.5946, 3396.6787, 3493.7315, 3606.8155, 3735.8581, 3863.9167, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 432.2201, 545.3042, 642.3570, 755.4410, 852.4938, 989.5527, 1076.5847, 1223.6531, 1370.7215, 1483.8056, 1612.8482, 1725.9323, 1839.0163, 1896.0378, 1995.1062, 2109.1491, 2246.2080, 2347.2557, 2476.2983, 2605.3409, 2718.4250, 2881.4883, 3018.5472, 3131.6313, 3232.6790, 3379.7474, 3508.7900, 3607.8584, 3694.8904, 3809.9174, 3908.9858, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NTIPDISSCGVPTQSNCQLLQSNWYFEPPCDLLR", {115.0502, 216.0979, 329.1819, 426.2347, 541.2617, 654.3457, 741.3777, 828.4098, 988.4404, 1045.4619, 1144.5303, 1241.5831, 1342.6307, 1470.6893, 1557.7213, 1671.7643, 1831.7949, 1959.8535, 2072.9376, 2186.0216, 2314.0802, 2401.1122, 2515.1552, 2701.2345, 2864.2978, 3011.3662, 3140.4088, 3237.4616, 3334.5143, 3494.5450, 3609.5719, 3722.6560, 3835.7401, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 401.2871, 516.3140, 676.3447, 773.3974, 870.4502, 999.4928, 1146.5612, 1309.6245, 1495.7038, 1609.7468, 1696.7788, 1824.8374, 1937.9214, 2051.0055, 2179.0641, 2339.0947, 2453.1377, 2540.1697, 2668.2283, 2769.2759, 2866.3287, 2965.3971, 3022.4186, 3182.4492, 3269.4813, 3356.5133, 3469.5974, 3584.6243, 3681.6771, 3794.7611, 3895.8088, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LTVEELDDDDEDLPQEELEIIEQLEDDGDDFDPR", {114.0913, 215.1390, 314.2074, 443.2500, 572.2926, 685.3767, 800.4036, 915.4306, 1030.4575, 1145.4845, 1274.5270, 1389.5540, 1502.6381, 1599.6908, 1727.7494, 1856.7920, 1985.8346, 2098.9186, 2227.9612, 2341.0453, 2454.1294, 2583.1720, 2711.2305, 2824.3146, 2953.3572, 3068.3841, 3183.4111, 3240.4325, 3355.4595, 3470.4864, 3617.5548, 3732.5818, 3829.6346, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 272.1717, 387.1987, 534.2671, 649.2940, 764.3210, 821.3424, 936.3694, 1051.3963, 1180.4389, 1293.5230, 1421.5815, 1550.6241, 1663.7082, 1776.7923, 1905.8349, 2018.9189, 2147.9615, 2277.0041, 2405.0627, 2502.1154, 2615.1995, 2730.2265, 2859.2691, 2974.2960, 3089.3229, 3204.3499, 3319.3768, 3432.4609, 3561.5035, 3690.5461, 3789.6145, 3890.6622, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LQVIIDLIFVVDTMSDCILWFTPVSQQLEPFSQR", {114.0913, 242.1499, 341.2183, 454.3024, 567.3865, 682.4134, 795.4975, 908.5815, 1055.6499, 1154.7184, 1253.7868, 1368.8137, 1469.8614, 1600.9019, 1687.9339, 1802.9609, 1962.9915, 2076.0756, 2189.1596, 2375.2389, 2522.3074, 2623.3550, 2720.4078, 2819.4762, 2906.5082, 3034.5668, 3162.6254, 3275.7095, 3404.7521, 3501.8048, 3648.8732, 3735.9053, 3863.9638, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 390.2096, 537.2780, 634.3307, 763.3733, 876.4574, 1004.5160, 1132.5745, 1219.6066, 1318.6750, 1415.7278, 1516.7754, 1663.8438, 1849.9232, 1963.0072, 2076.0913, 2236.1219, 2351.1489, 2438.1809, 2569.2214, 2670.2691, 2785.2960, 2884.3644, 2983.4328, 3130.5013, 3243.5853, 3356.6694, 3471.6963, 3584.7804, 3697.8645, 3796.9329, 3924.9914, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VNYLTLFLSDYVSSSSFLTHFQFLFMIGMFVINK", {100.0757, 214.1186, 377.1819, 490.2660, 591.3137, 704.3978, 851.4662, 964.5502, 1051.5823, 1166.6092, 1329.6725, 1428.7409, 1515.7730, 1602.8050, 1689.8370, 1776.8691, 1923.9375, 2037.0215, 2138.0692, 2275.1281, 2422.1965, 2550.2551, 2697.3235, 2810.4076, 2957.4760, 3088.5165, 3201.6006, 3258.6220, 3389.6625, 3536.7309, 3635.7993, 3748.8834, 3862.9263, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 261.1557, 374.2398, 473.3082, 620.3766, 751.4171, 808.4386, 921.5226, 1052.5631, 1199.6315, 1312.7156, 1459.7840, 1587.8426, 1734.9110, 1871.9699, 1973.0176, 2086.1017, 2233.1701, 2320.2021, 2407.2341, 2494.2662, 2581.2982, 2680.3666, 2843.4299, 2958.4569, 3045.4889, 3158.5730, 3305.6414, 3418.7254, 3519.7731, 3632.8572, 3795.9205, 3909.9634, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"CYFSDGSSWCTGGHTCPNVNCQTRPMQNCDPGNR", {161.0379, 324.1013, 471.1697, 558.2017, 673.2286, 730.2501, 817.2821, 904.3142, 1090.3935, 1250.4241, 1351.4718, 1408.4933, 1465.5147, 1602.5736, 1703.6213, 1863.6520, 1960.7047, 2074.7477, 2173.8161, 2287.8590, 2447.8896, 2575.9482, 2676.9959, 2833.0970, 2930.1498, 3061.1903, 3189.2488, 3303.2918, 3463.3224, 3578.3494, 3675.4021, 3732.4236, 3846.4665, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 289.1619, 346.1833, 443.2361, 558.2631, 718.2937, 832.3366, 960.3952, 1091.4357, 1188.4885, 1344.5896, 1445.6372, 1573.6958, 1733.7265, 1847.7694, 1946.8378, 2060.8807, 2157.9335, 2317.9641, 2419.0118, 2556.0707, 2613.0922, 2670.1137, 2771.1613, 2931.1920, 3117.2713, 3204.3033, 3291.3354, 3348.3568, 3463.3838, 3550.4158, 3697.4842, 3860.5475, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PNCADIEECHPGAFGSCCQCEYEEMGSNSYCVGK", {98.0600, 212.1030, 372.1336, 443.1707, 558.1977, 671.2817, 800.3243, 929.3669, 1089.3976, 1226.4565, 1323.5092, 1380.5307, 1451.5678, 1598.6362, 1655.6577, 1742.6897, 1902.7204, 2062.7510, 2190.8096, 2350.8403, 2479.8828, 2642.9462, 2771.9888, 2901.0314, 3032.0718, 3089.0933, 3176.1253, 3290.1683, 3377.2003, 3540.2636, 3700.2943, 3799.3627, 3856.3841, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 204.1343, 303.2027, 463.2333, 626.2967, 713.3287, 827.3716, 914.4036, 971.4251, 1102.4656, 1231.5082, 1360.5508, 1523.6141, 1652.6567, 1812.6873, 1940.7459, 2100.7766, 2260.8072, 2347.8393, 2404.8607, 2551.9291, 2622.9662, 2679.9877, 2777.0405, 2914.0994, 3074.1300, 3203.1726, 3332.2152, 3445.2993, 3560.3262, 3631.3633, 3791.3940, 3905.4369, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FSLILILYTYGHIPYHPSTAASCMFDNTCNYSVR", {148.0757, 235.1077, 348.1918, 461.2758, 574.3599, 687.4440, 800.5280, 963.5914, 1064.6390, 1227.7024, 1284.7238, 1421.7828, 1534.8668, 1631.9196, 1794.9829, 1932.0418, 2029.0946, 2116.1266, 2217.1743, 2288.2114, 2359.2485, 2446.2805, 2606.3112, 2737.3517, 2884.4201, 2999.4470, 3113.4900, 3214.5376, 3374.5683, 3488.6112, 3651.6745, 3738.7066, 3837.7750, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 274.1874, 361.2194, 524.2827, 638.3257, 798.3563, 899.4040, 1013.4469, 1128.4738, 1275.5423, 1406.5827, 1566.6134, 1653.6454, 1724.6825, 1795.7197, 1896.7673, 1983.7994, 2080.8521, 2217.9110, 2380.9744, 2478.0271, 2591.1112, 2728.1701, 2785.1916, 2948.2549, 3049.3026, 3212.3659, 3325.4500, 3438.5340, 3551.6181, 3664.7022, 3777.7862, 3864.8183, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"IDIDQFAVGLWAVVLCYHQFLQLLLEGEDLMELR", {114.0913, 229.1183, 342.2023, 457.2293, 585.2879, 732.3563, 803.3934, 902.4618, 959.4833, 1072.5673, 1258.6467, 1329.6838, 1428.7522, 1527.8206, 1640.9047, 1800.9353, 1963.9986, 2101.0575, 2229.1161, 2376.1845, 2489.2686, 2617.3272, 2730.4112, 2843.4953, 2956.5794, 3085.6220, 3142.6434, 3271.6860, 3386.7130, 3499.7970, 3630.8375, 3759.8801, 3872.9642, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 417.2456, 548.2861, 661.3702, 776.3971, 905.4397, 962.4612, 1091.5038, 1204.5878, 1317.6719, 1430.7559, 1558.8145, 1671.8986, 1818.9670, 1947.0256, 2084.0845, 2247.1478, 2407.1785, 2520.2625, 2619.3309, 2718.3994, 2789.4365, 2975.5158, 3088.5998, 3145.6213, 3244.6897, 3315.7268, 3462.7953, 3590.8538, 3705.8808, 3818.9648, 3933.9918, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DNEESEEDVDAMLLPPDDNICAMVSYNYWVDPIR", {116.0342, 230.0771, 359.1197, 488.1623, 575.1944, 704.2370, 833.2795, 948.3065, 1047.3749, 1162.4018, 1233.4390, 1364.4794, 1477.5635, 1590.6476, 1687.7003, 1784.7531, 1899.7800, 2014.8070, 2128.8499, 2241.9340, 2401.9646, 2473.0017, 2604.0422, 2703.1106, 2790.1427, 2953.2060, 3067.2489, 3230.3123, 3416.3916, 3515.4600, 3630.4869, 3727.5397, 3840.6238, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 385.2558, 500.2827, 599.3511, 785.4305, 948.4938, 1062.5367, 1225.6000, 1312.6321, 1411.7005, 1542.7410, 1613.7781, 1773.8087, 1886.8928, 2000.9357, 2115.9627, 2230.9896, 2328.0424, 2425.0951, 2538.1792, 2651.2633, 2782.3037, 2853.3409, 2968.3678, 3067.4362, 3182.4632, 3311.5057, 3440.5483, 3527.5804, 3656.6230, 3785.6656, 3899.7085, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SAFSHMMTAYVTEMDFYVGLMPDLGLYQCMLDFR", {88.0393, 159.0764, 306.1448, 393.1769, 530.2358, 661.2763, 792.3167, 893.3644, 964.4015, 1127.4649, 1226.5333, 1327.5810, 1456.6235, 1587.6640, 1702.6910, 1849.7594, 2012.8227, 2111.8911, 2168.9126, 2281.9967, 2413.0371, 2510.0899, 2625.1169, 2738.2009, 2795.2224, 2908.3064, 3071.3698, 3199.4284, 3359.4590, 3490.4995, 3603.5835, 3718.6105, 3865.6789, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 437.2143, 550.2984, 681.3389, 841.3695, 969.4281, 1132.4914, 1245.5755, 1302.5969, 1415.6810, 1530.7079, 1627.7607, 1758.8012, 1871.8853, 1928.9067, 2027.9751, 2191.0385, 2338.1069, 2453.1338, 2584.1743, 2713.2169, 2814.2646, 2913.3330, 3076.3963, 3147.4334, 3248.4811, 3379.5216, 3510.5621, 3647.6210, 3734.6530, 3881.7214, 3952.7586, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"CFCFLIAVCLGQFSATFASIIEYTNEWPHKPAPR", {161.0379, 308.1063, 468.1370, 615.2054, 728.2895, 841.3735, 912.4106, 1011.4791, 1171.5097, 1284.5938, 1341.6152, 1469.6738, 1616.7422, 1703.7743, 1774.8114, 1875.8590, 2022.9275, 2093.9646, 2180.9966, 2294.0807, 2407.1647, 2536.2073, 2699.2707, 2800.3183, 2914.3613, 3043.4039, 3229.4832, 3326.5359, 3463.5948, 3591.6898, 3688.7426, 3759.7797, 3856.8324, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 272.1717, 343.2088, 440.2616, 568.3566, 705.4155, 802.4682, 988.5475, 1117.5901, 1231.6331, 1332.6807, 1495.7441, 1624.7867, 1737.8707, 1850.9548, 1937.9868, 2009.0239, 2156.0924, 2257.1400, 2328.1771, 2415.2092, 2562.2776, 2690.3362, 2747.3576, 2860.4417, 3020.4723, 3119.5408, 3190.5779, 3303.6619, 3416.7460, 3563.8144, 3723.8451, 3870.9135, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"IAELWLLLVFLFTFPVHLAYAQWNTWDPTSVSEK", {114.0913, 185.1285, 314.1710, 427.2551, 613.3344, 726.4185, 839.5026, 952.5866, 1051.6550, 1198.7234, 1311.8075, 1458.8759, 1559.9236, 1706.9920, 1804.0448, 1903.1132, 2040.1721, 2153.2562, 2224.2933, 2387.3566, 2458.3937, 2586.4523, 2772.5316, 2886.5745, 2987.6222, 3173.7015, 3288.7285, 3385.7812, 3486.8289, 3573.8609, 3672.9294, 3759.9614, 3889.0040, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 276.1554, 363.1874, 462.2558, 549.2879, 650.3355, 747.3883, 862.4153, 1048.4946, 1149.5422, 1263.5852, 1449.6645, 1577.7231, 1648.7602, 1811.8235, 1882.8606, 1995.9447, 2133.0036, 2232.0720, 2329.1248, 2476.1932, 2577.2409, 2724.3093, 2837.3933, 2984.4618, 3083.5302, 3196.6142, 3309.6983, 3422.7824, 3608.8617, 3721.9457, 3850.9883, 3922.0254, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"HLLESNPMVLLYWVLWLSNNAAFSAFLNMHLTIR", {138.0662, 251.1503, 364.2343, 493.2769, 580.3089, 694.3519, 791.4046, 922.4451, 1021.5135, 1134.5976, 1247.6817, 1410.7450, 1596.8243, 1695.8927, 1808.9768, 1995.0561, 2108.1402, 2195.1722, 2309.2151, 2423.2580, 2494.2951, 2565.3323, 2712.4007, 2799.4327, 2870.4698, 3017.5382, 3130.6223, 3244.6652, 3375.7057, 3512.7646, 3625.8487, 3726.8964, 3839.9804, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 389.2507, 502.3348, 639.3937, 770.4342, 884.4771, 997.5611, 1144.6296, 1215.6667, 1302.6987, 1449.7671, 1520.8042, 1591.8413, 1705.8843, 1819.9272, 1906.9592, 2020.0433, 2206.1226, 2319.2067, 2418.2751, 2604.3544, 2767.4177, 2880.5018, 2993.5859, 3092.6543, 3223.6948, 3320.7475, 3434.7904, 3521.8225, 3650.8651, 3763.9491, 3877.0332, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PQIQSLSSISNMIHNYYQNSLANFQETWTVDMNR", {98.0600, 226.1186, 339.2027, 467.2613, 554.2933, 667.3774, 754.4094, 841.4414, 954.5255, 1041.5575, 1155.6004, 1286.6409, 1399.7250, 1536.7839, 1650.8268, 1813.8901, 1976.9535, 2105.0121, 2219.0550, 2306.0870, 2419.1711, 2490.2082, 2604.2511, 2751.3195, 2879.3781, 3008.4207, 3109.4684, 3295.5477, 3396.5954, 3495.6638, 3610.6907, 3741.7312, 3855.7741, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 289.1619, 420.2024, 535.2293, 634.2977, 735.3454, 921.4247, 1022.4724, 1151.5150, 1279.5736, 1426.6420, 1540.6849, 1611.7220, 1724.8061, 1811.8381, 1925.8810, 2053.9396, 2217.0029, 2380.0663, 2494.1092, 2631.1681, 2744.2522, 2875.2927, 2989.3356, 3076.3676, 3189.4517, 3276.4837, 3363.5157, 3476.5998, 3563.6318, 3691.6904, 3804.7745, 3932.8330, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LDDSSFHMMYPPSAYVLLNDNTGCYYTPQYAMNK", {114.0913, 229.1183, 344.1452, 431.1773, 518.2093, 665.2777, 802.3366, 933.3771, 1064.4176, 1227.4809, 1324.5337, 1421.5864, 1508.6185, 1579.6556, 1742.7189, 1841.7873, 1954.8714, 2067.9554, 2181.9984, 2297.0253, 2411.0682, 2512.1159, 2569.1374, 2729.1680, 2892.2314, 3055.2947, 3156.3424, 3253.3951, 3381.4537, 3544.5170, 3615.5542, 3746.5946, 3860.6376, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 261.1557, 392.1962, 463.2333, 626.2967, 754.3552, 851.4080, 952.4557, 1115.5190, 1278.5823, 1438.6130, 1495.6344, 1596.6821, 1710.7251, 1825.7520, 1939.7949, 2052.8790, 2165.9631, 2265.0315, 2428.0948, 2499.1319, 2586.1639, 2683.2167, 2780.2695, 2943.3328, 3074.3733, 3205.4138, 3342.4727, 3489.5411, 3576.5731, 3663.6051, 3778.6321, 3893.6590, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LENYLSQLHSWMEHNAVEQMLGNVDAIYEIVENR", {114.0913, 243.1339, 357.1769, 520.2402, 633.3243, 720.3563, 848.4149, 961.4989, 1098.5578, 1185.5899, 1371.6692, 1502.7097, 1631.7523, 1768.8112, 1882.8541, 1953.8912, 2052.9596, 2182.0022, 2310.0608, 2441.1013, 2554.1853, 2611.2068, 2725.2497, 2824.3181, 2939.3451, 3010.3822, 3123.4663, 3286.5296, 3415.5722, 3528.6563, 3627.7247, 3756.7673, 3870.8102, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 289.1619, 418.2045, 517.2729, 630.3570, 759.3995, 922.4629, 1035.5469, 1106.5841, 1221.6110, 1320.6794, 1434.7223, 1491.7438, 1604.8279, 1735.8683, 1863.9269, 1992.9695, 2092.0379, 2163.0750, 2277.1180, 2414.1769, 2543.2195, 2674.2600, 2860.3393, 2947.3713, 3084.4302, 3197.5143, 3325.5729, 3412.6049, 3525.6890, 3688.7523, 3802.7952, 3931.8378, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NHKPPCSCIPAHNVVHCLANFGCTGPCPDICHQR", {115.0502, 252.1091, 380.2041, 477.2568, 574.3096, 734.3403, 821.3723, 981.4029, 1094.4870, 1191.5398, 1262.5769, 1399.6358, 1513.6787, 1612.7471, 1711.8155, 1848.8745, 2008.9051, 2121.9892, 2193.0263, 2307.0692, 2454.1376, 2511.1591, 2671.1897, 2772.2374, 2829.2589, 2926.3116, 3086.3423, 3183.3951, 3298.4220, 3411.5061, 3571.5367, 3708.5956, 3836.6542, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 440.2364, 600.2671, 713.3512, 828.3781, 925.4309, 1085.4615, 1182.5143, 1239.5357, 1340.5834, 1500.6141, 1557.6355, 1704.7039, 1818.7469, 1889.7840, 2002.8680, 2162.8987, 2299.9576, 2399.0260, 2498.0944, 2612.1374, 2749.1963, 2820.2334, 2917.2862, 3030.3702, 3190.4009, 3277.4329, 3437.4635, 3534.5163, 3631.5691, 3759.6640, 3896.7229, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PEIIQQCGVFPNGTFRPLCTCFPNHNVVSCQANR", {98.0600, 227.1026, 340.1867, 453.2708, 581.3293, 709.3879, 869.4186, 926.4400, 1025.5084, 1172.5769, 1269.6296, 1383.6725, 1440.6940, 1541.7417, 1688.8101, 1844.9112, 1941.9640, 2055.0480, 2215.0787, 2316.1264, 2476.1570, 2623.2254, 2720.2782, 2834.3211, 2971.3800, 3085.4230, 3184.4914, 3283.5598, 3370.5918, 3530.6225, 3658.6810, 3729.7182, 3843.7611, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 289.1619, 360.1990, 488.2576, 648.2882, 735.3202, 834.3887, 933.4571, 1047.5000, 1184.5589, 1298.6018, 1395.6546, 1542.7230, 1702.7537, 1803.8013, 1963.8320, 2076.9161, 2173.9688, 2330.0699, 2477.1383, 2578.1860, 2635.2075, 2749.2504, 2846.3032, 2993.3716, 3092.4400, 3149.4615, 3309.4921, 3437.5507, 3565.6093, 3678.6933, 3791.7774, 3920.8200, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LLTNLNLMMYECLTFTMAECFGSDYNDPHASSLR", {114.0913, 227.1754, 328.2231, 442.2660, 555.3501, 669.3930, 782.4771, 913.5176, 1044.5580, 1207.6214, 1336.6640, 1496.6946, 1609.7787, 1710.8263, 1857.8948, 1958.9424, 2089.9829, 2161.0200, 2290.0626, 2450.0933, 2597.1617, 2654.1832, 2741.2152, 2856.2421, 3019.3055, 3133.3484, 3248.3753, 3345.4281, 3482.4870, 3553.5241, 3640.5561, 3727.5882, 3840.6722, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 375.2350, 462.2671, 533.3042, 670.3631, 767.4159, 882.4428, 996.4857, 1159.5491, 1274.5760, 1361.6080, 1418.6295, 1565.6979, 1725.7286, 1854.7712, 1925.8083, 2056.8488, 2157.8964, 2304.9648, 2406.0125, 2519.0966, 2679.1272, 2808.1698, 2971.2332, 3102.2736, 3233.3141, 3346.3982, 3460.4411, 3573.5252, 3687.5681, 3788.6158, 3901.6999, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DDLLSDQEGEEALEDYLEDIDTQLEDDWPPNHQR", {116.0342, 231.0612, 344.1452, 457.2293, 544.2613, 659.2883, 787.3468, 916.3894, 973.4109, 1102.4535, 1231.4961, 1302.5332, 1415.6173, 1544.6599, 1659.6868, 1822.7501, 1935.8342, 2064.8768, 2179.9037, 2292.9878, 2408.0147, 2509.0624, 2637.1210, 2750.2051, 2879.2476, 2994.2746, 3109.3015, 3295.3808, 3392.4336, 3489.4864, 3603.5293, 3740.5882, 3868.6468, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 440.2364, 554.2794, 651.3321, 748.3849, 934.4642, 1049.4912, 1164.5181, 1293.5607, 1406.6448, 1534.7033, 1635.7510, 1750.7780, 1863.8620, 1978.8890, 2107.9316, 2221.0156, 2384.0789, 2499.1059, 2628.1485, 2741.2325, 2812.2697, 2941.3123, 3070.3548, 3127.3763, 3256.4189, 3384.4775, 3499.5044, 3586.5365, 3699.6205, 3812.7046, 3927.7315, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QYGDHCICFNPAVCHGNSCGSDCIPDCEHHSNDK", {129.0659, 292.1292, 349.1506, 464.1776, 601.2365, 761.2671, 874.3512, 1034.3819, 1181.4503, 1295.4932, 1392.5460, 1463.5831, 1562.6515, 1722.6821, 1859.7411, 1916.7625, 2030.8054, 2117.8375, 2277.8681, 2334.8896, 2421.9216, 2536.9486, 2696.9792, 2810.0633, 2907.1160, 3022.1430, 3182.1736, 3311.2162, 3448.2751, 3585.3340, 3672.3661, 3786.4090, 3901.4359, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 262.1397, 376.1827, 463.2147, 600.2736, 737.3325, 866.3751, 1026.4058, 1141.4327, 1238.4855, 1351.5695, 1511.6002, 1626.6271, 1713.6592, 1770.6806, 1930.7113, 2017.7433, 2131.7862, 2188.8077, 2325.8666, 2485.8973, 2584.9657, 2656.0028, 2753.0555, 2867.0985, 3014.1669, 3174.1975, 3287.2816, 3447.3122, 3584.3712, 3699.3981, 3756.4196, 3919.4829, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ILPLYEEPYGLDLACLCDDYSEAYLGCDFLVLSR", {114.0913, 227.1754, 324.2282, 437.3122, 600.3756, 729.4182, 858.4607, 955.5135, 1118.5768, 1175.5983, 1288.6824, 1403.7093, 1516.7934, 1587.8305, 1747.8611, 1860.9452, 2020.9758, 2136.0028, 2251.0297, 2414.0931, 2501.1251, 2630.1677, 2701.2048, 2864.2681, 2977.3522, 3034.3737, 3194.4043, 3309.4312, 3456.4997, 3569.5837, 3668.6521, 3781.7362, 3868.7682, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 262.1510, 375.2350, 474.3035, 587.3875, 734.4559, 849.4829, 1009.5135, 1066.5350, 1179.6191, 1342.6824, 1413.7195, 1542.7621, 1629.7941, 1792.8574, 1907.8844, 2022.9113, 2182.9420, 2296.0260, 2456.0567, 2527.0938, 2640.1779, 2755.2048, 2868.2889, 2925.3103, 3088.3737, 3185.4264, 3314.4690, 3443.5116, 3606.5750, 3719.6590, 3816.7118, 3929.7958, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MLSYCILMVIMPIGYTLVLIILNYAYDAMSTPYR", {132.0478, 245.1318, 332.1639, 495.2272, 655.2578, 768.3419, 881.4260, 1012.4664, 1111.5349, 1224.6189, 1355.6594, 1452.7122, 1565.7962, 1622.8177, 1785.8810, 1886.9287, 2000.0128, 2099.0812, 2212.1652, 2325.2493, 2438.3334, 2551.4174, 2665.4604, 2828.5237, 2899.5608, 3062.6241, 3177.6511, 3248.6882, 3379.7287, 3466.7607, 3567.8084, 3664.8611, 3827.9245, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 435.2350, 536.2827, 623.3148, 754.3552, 825.3924, 940.4193, 1103.4826, 1174.5197, 1337.5831, 1451.6260, 1564.7101, 1677.7941, 1790.8782, 1903.9622, 2003.0307, 2116.1147, 2217.1624, 2380.2257, 2437.2472, 2550.3313, 2647.3840, 2778.4245, 2891.5086, 2990.5770, 3121.6175, 3234.7015, 3347.7856, 3507.8162, 3670.8796, 3757.9116, 3870.9957, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FNDLWDLQGYHETALVGTNLFVLVIILWYFAQSK", {148.0757, 262.1186, 377.1456, 490.2296, 676.3089, 791.3359, 904.4199, 1032.4785, 1089.5000, 1252.5633, 1389.6222, 1518.6648, 1619.7125, 1690.7496, 1803.8337, 1902.9021, 1959.9236, 2060.9712, 2175.0142, 2288.0982, 2435.1666, 2534.2351, 2647.3191, 2746.3875, 2859.4716, 2972.5557, 3085.6397, 3271.7190, 3434.7824, 3581.8508, 3652.8879, 3780.9465, 3867.9785, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 234.1448, 362.2034, 433.2405, 580.3089, 743.3723, 929.4516, 1042.5356, 1155.6197, 1268.7038, 1367.7722, 1480.8562, 1579.9247, 1726.9931, 1840.0771, 1954.1201, 2055.1677, 2112.1892, 2211.2576, 2324.3417, 2395.3788, 2496.4265, 2625.4691, 2762.5280, 2925.5913, 2982.6128, 3110.6714, 3223.7554, 3338.7824, 3524.8617, 3637.9457, 3752.9727, 3867.0156, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"GSIACAVFVPAYFYIMVSWNRPDFWCTDGGFILR", {58.0287, 145.0608, 258.1448, 329.1819, 489.2126, 560.2497, 659.3181, 806.3865, 905.4550, 1002.5077, 1073.5448, 1236.6082, 1383.6766, 1546.7399, 1659.8240, 1790.8644, 1889.9329, 1976.9649, 2163.0442, 2277.0871, 2433.1882, 2530.2410, 2645.2679, 2792.3364, 2978.4157, 3138.4463, 3239.4940, 3354.5209, 3411.5424, 3468.5639, 3615.6323, 3728.7164, 3841.8004, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 401.2871, 548.3555, 605.3770, 662.3984, 777.4254, 878.4730, 1038.5037, 1224.5830, 1371.6514, 1486.6784, 1583.7311, 1739.8322, 1853.8752, 2039.9545, 2126.9865, 2226.0549, 2357.0954, 2470.1795, 2633.2428, 2780.3112, 2943.3745, 3014.4117, 3111.4644, 3210.5328, 3357.6012, 3456.6697, 3527.7068, 3687.7374, 3758.7745, 3871.8586, 3958.8906, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ISHGECSLTVDVFSESQLLEDFVNTLNSQYNNWR", {114.0913, 201.1234, 338.1823, 395.2037, 524.2463, 684.2770, 771.3090, 884.3931, 985.4408, 1084.5092, 1199.5361, 1298.6045, 1445.6729, 1532.7050, 1661.7476, 1748.7796, 1876.8382, 1989.9222, 2103.0063, 2232.0489, 2347.0758, 2494.1442, 2593.2127, 2707.2556, 2808.3033, 2921.3873, 3035.4303, 3122.4623, 3250.5209, 3413.5842, 3527.6271, 3641.6700, 3827.7494, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 361.1983, 475.2412, 589.2841, 752.3474, 880.4060, 967.4381, 1081.4810, 1194.5650, 1295.6127, 1409.6557, 1508.7241, 1655.7925, 1770.8194, 1899.8620, 2012.9461, 2126.0301, 2254.0887, 2341.1208, 2470.1633, 2557.1954, 2704.2638, 2803.3322, 2918.3591, 3017.4276, 3118.4752, 3231.5593, 3318.5913, 3478.6220, 3607.6646, 3664.6860, 3801.7449, 3888.7770, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"IWNERPCNATLYVMTCQAHLMAYPLCTSSAMGMK", {114.0913, 300.1707, 414.2136, 543.2562, 699.3573, 796.4100, 956.4407, 1070.4836, 1141.5207, 1242.5684, 1355.6525, 1518.7158, 1617.7842, 1748.8247, 1849.8724, 2009.9030, 2137.9616, 2208.9987, 2346.0576, 2459.1417, 2590.1822, 2661.2193, 2824.2826, 2921.3354, 3034.4195, 3194.4501, 3295.4978, 3382.5298, 3469.5618, 3540.5990, 3671.6394, 3728.6609, 3859.7014, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 278.1533, 335.1748, 466.2152, 537.2524, 624.2844, 711.3164, 812.3641, 972.3947, 1085.4788, 1182.5316, 1345.5949, 1416.6320, 1547.6725, 1660.7566, 1797.8155, 1868.8526, 1996.9112, 2156.9418, 2257.9895, 2389.0300, 2488.0984, 2651.1617, 2764.2458, 2865.2935, 2936.3306, 3050.3735, 3210.4041, 3307.4569, 3463.5580, 3592.6006, 3706.6435, 3892.7229, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NIDFNNFNPPASCNFSALSCELIILLFGFCIIYK", {115.0502, 228.1343, 343.1612, 490.2296, 604.2726, 718.3155, 865.3839, 979.4268, 1076.4796, 1173.5323, 1244.5695, 1331.6015, 1491.6321, 1605.6751, 1752.7435, 1839.7755, 1910.8126, 2023.8967, 2110.9287, 2270.9594, 2400.0020, 2513.0860, 2626.1701, 2739.2541, 2852.3382, 2965.4223, 3112.4907, 3169.5122, 3316.5806, 3476.6112, 3589.6953, 3702.7793, 3865.8427, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 310.1761, 423.2602, 536.3443, 696.3749, 843.4433, 900.4648, 1047.5332, 1160.6173, 1273.7013, 1386.7854, 1499.8695, 1612.9535, 1741.9961, 1902.0268, 1989.0588, 2102.1429, 2173.1800, 2260.2120, 2407.2804, 2521.3233, 2681.3540, 2768.3860, 2839.4231, 2936.4759, 3033.5287, 3147.5716, 3294.6400, 3408.6829, 3522.7259, 3669.7943, 3784.8212, 3897.9053, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MYLYLGEVLMWFFNTLTFFHFLTILAICSGVGSR", {132.0478, 295.1111, 408.1952, 571.2585, 684.3425, 741.3640, 870.4066, 969.4750, 1082.5591, 1213.5996, 1399.6789, 1546.7473, 1693.8157, 1807.8586, 1908.9063, 2021.9904, 2123.0381, 2270.1065, 2417.1749, 2554.2338, 2701.3022, 2814.3863, 2915.4340, 3028.5180, 3141.6021, 3212.6392, 3325.7233, 3485.7539, 3572.7859, 3629.8074, 3728.8758, 3785.8973, 3872.9293, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 262.1510, 319.1724, 418.2409, 475.2623, 562.2944, 722.3250, 835.4091, 906.4462, 1019.5302, 1132.6143, 1233.6620, 1346.7460, 1493.8145, 1630.8734, 1777.9418, 1925.0102, 2026.0579, 2139.1419, 2240.1896, 2354.2325, 2501.3010, 2648.3694, 2834.4487, 2965.4892, 3078.5732, 3177.6417, 3306.6842, 3363.7057, 3476.7898, 3639.8531, 3752.9372, 3916.0005, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MQEVEIYEEEDPHNEPEDEVGASEVTDTEYLEQK", {132.0478, 260.1063, 389.1489, 488.2173, 617.2599, 730.3440, 893.4073, 1022.4499, 1151.4925, 1280.5351, 1395.5621, 1492.6148, 1629.6737, 1743.7167, 1872.7593, 1969.8120, 2098.8546, 2213.8816, 2342.9241, 2441.9926, 2499.0140, 2570.0511, 2657.0832, 2786.1258, 2885.1942, 2986.2418, 3101.2688, 3202.3165, 3331.3591, 3494.4224, 3607.5065, 3736.5490, 3864.6076, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 275.1714, 404.2140, 517.2980, 680.3614, 809.4040, 910.4516, 1025.4786, 1126.5263, 1225.5947, 1354.6373, 1441.6693, 1512.7064, 1569.7279, 1668.7963, 1797.8389, 1912.8658, 2041.9084, 2138.9612, 2268.0038, 2382.0467, 2519.1056, 2616.1584, 2731.1853, 2860.2279, 2989.2705, 3118.3131, 3281.3764, 3394.4605, 3523.5031, 3622.5715, 3751.6141, 3879.6727, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"WLVSYVLAKPIYHELQDASCPFDPHQANFTLVNR", {187.0866, 300.1707, 399.2391, 486.2711, 649.3344, 748.4028, 861.4869, 932.5240, 1060.6190, 1157.6717, 1270.7558, 1433.8191, 1570.8780, 1699.9206, 1813.0047, 1941.0633, 2056.0902, 2127.1273, 2214.1594, 2374.1900, 2471.2428, 2618.3112, 2733.3381, 2830.3909, 2967.4498, 3095.5084, 3166.5455, 3280.5884, 3427.6568, 3528.7045, 3641.7886, 3740.8570, 3854.8999, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 289.1619, 388.2303, 501.3144, 602.3620, 749.4305, 863.4734, 934.5105, 1062.5691, 1199.6280, 1296.6807, 1411.7077, 1558.7761, 1655.8289, 1815.8595, 1902.8915, 1973.9287, 2088.9556, 2217.0142, 2330.0982, 2459.1408, 2596.1997, 2759.2631, 2872.3471, 2969.3999, 3097.4949, 3168.5320, 3281.6160, 3380.6845, 3543.7478, 3630.7798, 3729.8482, 3842.9323, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QLVPVDGKPNLNLFWNSYQEGNCLDVVYPFFDIK", {129.0659, 242.1499, 341.2183, 438.2711, 537.3395, 652.3665, 709.3879, 837.4829, 934.5356, 1048.5786, 1161.6626, 1275.7056, 1388.7896, 1535.8580, 1721.9374, 1835.9803, 1923.0123, 2086.0756, 2214.1342, 2343.1768, 2400.1983, 2514.2412, 2674.2718, 2787.3559, 2902.3829, 3001.4513, 3100.5197, 3263.5830, 3360.6358, 3507.7042, 3654.7726, 3769.7995, 3882.8836, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 375.2238, 522.2922, 669.3606, 766.4134, 929.4767, 1028.5451, 1127.6136, 1242.6405, 1355.7246, 1515.7552, 1629.7981, 1686.8196, 1815.8622, 1943.9208, 2106.9841, 2194.0161, 2308.0591, 2494.1384, 2641.2068, 2754.2909, 2868.3338, 2981.4178, 3095.4608, 3192.5135, 3320.6085, 3377.6300, 3492.6569, 3591.7253, 3688.7781, 3787.8465, 3900.9306, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DACDLGLNMLDVACACNELEPCDCDDENNNHSDR", {116.0342, 187.0713, 347.1020, 462.1289, 575.2130, 632.2345, 745.3185, 859.3614, 990.4019, 1103.4860, 1218.5129, 1317.5813, 1388.6185, 1548.6491, 1619.6862, 1779.7169, 1893.7598, 2022.8024, 2135.8865, 2264.9291, 2361.9818, 2522.0125, 2637.0394, 2797.0701, 2912.0970, 3027.1239, 3156.1665, 3270.2095, 3384.2524, 3498.2953, 3635.3542, 3722.3863, 3837.4132, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 290.1459, 377.1779, 514.2368, 628.2798, 742.3227, 856.3656, 985.4082, 1100.4352, 1215.4621, 1375.4927, 1490.5197, 1650.5503, 1747.6031, 1876.6457, 1989.7298, 2118.7724, 2232.8153, 2392.8459, 2463.8830, 2623.9137, 2694.9508, 2794.0192, 2909.0462, 3022.1302, 3153.1707, 3267.2136, 3380.2977, 3437.3192, 3550.4032, 3665.4302, 3825.4608, 3896.4979, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DECNYLEFICAWNPLFLLHTLGAGHMGILIDTNR", {116.0342, 245.0768, 405.1075, 519.1504, 682.2137, 795.2978, 924.3404, 1071.4088, 1184.4929, 1344.5235, 1415.5606, 1601.6399, 1715.6829, 1812.7356, 1925.8197, 2072.8881, 2185.9722, 2299.0562, 2436.1151, 2537.1628, 2650.2469, 2707.2683, 2778.3055, 2835.3269, 2972.3858, 3103.4263, 3160.4478, 3273.5318, 3386.6159, 3499.7000, 3614.7269, 3715.7746, 3829.8175, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 289.1619, 390.2096, 505.2365, 618.3206, 731.4046, 844.4887, 901.5102, 1032.5506, 1169.6096, 1226.6310, 1297.6681, 1354.6896, 1467.7737, 1568.8213, 1705.8802, 1818.9643, 1932.0484, 2079.1168, 2192.2009, 2289.2536, 2403.2965, 2589.3759, 2660.4130, 2820.4436, 2933.5277, 3080.5961, 3209.6387, 3322.7228, 3485.7861, 3599.8290, 3759.8597, 3888.9023, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NTACPDHVDCPHQCLQNICAETVGCDSDDTCEVK", {115.0502, 216.0979, 287.1350, 447.1656, 544.2184, 659.2454, 796.3043, 895.3727, 1010.3996, 1170.4303, 1267.4830, 1404.5419, 1532.6005, 1692.6312, 1805.7152, 1933.7738, 2047.8167, 2160.9008, 2320.9315, 2391.9686, 2521.0112, 2622.0588, 2721.1273, 2778.1487, 2938.1794, 3053.2063, 3140.2383, 3255.2653, 3370.2922, 3471.3399, 3631.3705, 3760.4131, 3859.4816, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 246.1812, 375.2238, 535.2545, 636.3021, 751.3291, 866.3560, 953.3881, 1068.4150, 1228.4456, 1285.4671, 1384.5355, 1485.5832, 1614.6258, 1685.6629, 1845.6936, 1958.7776, 2072.8205, 2200.8791, 2313.9632, 2473.9938, 2602.0524, 2739.1113, 2836.1641, 2996.1947, 3111.2217, 3210.2901, 3347.3490, 3462.3760, 3559.4287, 3719.4594, 3790.4965, 3891.5442, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"HHYMSNHMGMGIDQCSPQQPQQHQHQVVHPTLGR", {138.0662, 275.1251, 438.1884, 569.2289, 656.2609, 770.3039, 907.3628, 1038.4033, 1095.4247, 1226.4652, 1283.4867, 1396.5707, 1511.5977, 1639.6563, 1799.6869, 1886.7189, 1983.7717, 2111.8303, 2239.8889, 2336.9416, 2465.0002, 2593.0588, 2730.1177, 2858.1763, 2995.2352, 3123.2938, 3222.3622, 3321.4306, 3458.4895, 3555.5423, 3656.5899, 3769.6740, 3826.6955, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 232.1404, 345.2245, 446.2722, 543.3249, 680.3838, 779.4522, 878.5207, 1006.5792, 1143.6382, 1271.6967, 1408.7556, 1536.8142, 1664.8728, 1761.9256, 1889.9841, 2018.0427, 2115.0955, 2202.1275, 2362.1582, 2490.2167, 2605.2437, 2718.3277, 2775.3492, 2906.3897, 2963.4112, 3094.4516, 3231.5105, 3345.5535, 3432.5855, 3563.6260, 3726.6893, 3863.7482, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FWQITPTPNGEAQCNFTFPDNKPVTTDMPHEIIR", {148.0757, 334.1550, 462.2136, 575.2976, 676.3453, 773.3981, 874.4458, 971.4985, 1085.5415, 1142.5629, 1271.6055, 1342.6426, 1470.7012, 1630.7319, 1744.7748, 1891.8432, 1992.8909, 2139.9593, 2237.0121, 2352.0390, 2466.0819, 2594.1769, 2691.2296, 2790.2981, 2891.3457, 2992.3934, 3107.4204, 3238.4608, 3335.5136, 3472.5725, 3601.6151, 3714.6992, 3827.7832, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 401.2871, 530.3297, 667.3886, 764.4413, 895.4818, 1010.5088, 1111.5565, 1212.6041, 1311.6725, 1408.7253, 1536.8203, 1650.8632, 1765.8901, 1862.9429, 2010.0113, 2111.0590, 2258.1274, 2372.1703, 2532.2010, 2660.2596, 2731.2967, 2860.3393, 2917.3607, 3031.4037, 3128.4564, 3229.5041, 3326.5569, 3427.6046, 3540.6886, 3668.7472, 3854.8265, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FLACGTPDLPICWQIANLLFLESWSEELLIVQDR", {148.0757, 261.1598, 332.1969, 492.2275, 549.2490, 650.2967, 747.3494, 862.3764, 975.4604, 1072.5132, 1185.5973, 1345.6279, 1531.7072, 1659.7658, 1772.8499, 1843.8870, 1957.9299, 2071.0140, 2184.0980, 2331.1664, 2444.2505, 2573.2931, 2660.3251, 2846.4044, 2933.4365, 3062.4791, 3191.5217, 3304.6057, 3417.6898, 3530.7738, 3629.8423, 3757.9008, 3872.9278, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 290.1459, 418.2045, 517.2729, 630.3570, 743.4410, 856.5251, 985.5677, 1114.6103, 1201.6423, 1387.7216, 1474.7536, 1603.7962, 1716.8803, 1863.9487, 1977.0328, 2090.1168, 2204.1598, 2275.1969, 2388.2809, 2516.3395, 2702.4188, 2862.4495, 2975.5335, 3072.5863, 3185.6704, 3300.6973, 3397.7501, 3498.7978, 3555.8192, 3715.8499, 3786.8870, 3899.9710, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ELDINFDELDIETTDSCTDEDYLITPPQMELLSK", {130.0499, 243.1339, 358.1609, 471.2449, 585.2879, 732.3563, 847.3832, 976.4258, 1089.5099, 1204.5368, 1317.6209, 1446.6635, 1547.7112, 1648.7588, 1763.7858, 1850.8178, 2010.8485, 2111.8961, 2226.9231, 2355.9657, 2470.9926, 2634.0559, 2747.1400, 2860.2241, 2961.2718, 3058.3245, 3155.3773, 3283.4359, 3414.4763, 3543.5189, 3656.6030, 3769.6871, 3856.7191, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 234.1448, 347.2289, 460.3130, 589.3556, 720.3960, 848.4546, 945.5074, 1042.5601, 1143.6078, 1256.6919, 1369.7760, 1532.8393, 1647.8662, 1776.9088, 1891.9358, 1992.9834, 2153.0141, 2240.0461, 2355.0731, 2456.1207, 2557.1684, 2686.2110, 2799.2951, 2914.3220, 3027.4061, 3156.4487, 3271.4756, 3418.5440, 3532.5870, 3645.6710, 3760.6980, 3873.7820, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TYIILVSFLCLMVFIISLVLPDVIMSYVLNYPMK", {102.0550, 265.1183, 378.2023, 491.2864, 604.3705, 703.4389, 790.4709, 937.5393, 1050.6234, 1210.6540, 1323.7381, 1454.7786, 1553.8470, 1700.9154, 1813.9995, 1927.0835, 2014.1156, 2127.1996, 2226.2681, 2339.3521, 2436.4049, 2551.4318, 2650.5002, 2763.5843, 2894.6248, 2981.6568, 3144.7201, 3243.7886, 3356.8726, 3470.9156, 3633.9789, 3731.0316, 3862.0721, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 278.1533, 375.2061, 538.2694, 652.3123, 765.3964, 864.4648, 1027.5281, 1114.5601, 1245.6006, 1358.6847, 1457.7531, 1572.7800, 1669.8328, 1782.9169, 1881.9853, 1995.0694, 2082.1014, 2195.1854, 2308.2695, 2455.3379, 2554.4063, 2685.4468, 2798.5309, 2958.5615, 3071.6456, 3218.7140, 3305.7460, 3404.8145, 3517.8985, 3630.9826, 3744.0666, 3907.1300, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SYLFNSENEAAYHTSTIELVELDELQILMFIFQK", {88.0393, 251.1026, 364.1867, 511.2551, 625.2980, 712.3301, 841.3727, 955.4156, 1084.4582, 1155.4953, 1226.5324, 1389.5957, 1526.6546, 1627.7023, 1714.7344, 1815.7820, 1928.8661, 2057.9087, 2170.9928, 2270.0612, 2399.1038, 2512.1878, 2627.2148, 2756.2574, 2869.3414, 2997.4000, 3110.4841, 3223.5681, 3354.6086, 3501.6770, 3614.7611, 3761.8295, 3889.8881, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 275.1714, 422.2398, 535.3239, 682.3923, 813.4328, 926.5168, 1039.6009, 1167.6595, 1280.7435, 1409.7861, 1524.8131, 1637.8971, 1766.9397, 1866.0081, 1979.0922, 2108.1348, 2221.2189, 2322.2665, 2409.2986, 2510.3462, 2647.4052, 2810.4685, 2881.5056, 2952.5427, 3081.5853, 3195.6282, 3324.6708, 3411.7029, 3525.7458, 3672.8142, 3785.8983, 3948.9616, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EPESPPNTFFSQLYAEYMTTLMISAFCLITFILR", {130.0499, 227.1026, 356.1452, 443.1773, 540.2300, 637.2828, 751.3257, 852.3734, 999.4418, 1146.5102, 1233.5422, 1361.6008, 1474.6849, 1637.7482, 1708.7853, 1837.8279, 2000.8913, 2131.9317, 2232.9794, 2334.0271, 2447.1112, 2578.1516, 2691.2357, 2778.2677, 2849.3048, 2996.3733, 3156.4039, 3269.4880, 3382.5720, 3483.6197, 3630.6881, 3743.7722, 3856.8563, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 401.2871, 548.3555, 649.4032, 762.4872, 875.5713, 1035.6019, 1182.6704, 1253.7075, 1340.7395, 1453.8236, 1584.8641, 1697.9481, 1798.9958, 1900.0435, 2031.0840, 2194.1473, 2323.1899, 2394.2270, 2557.2903, 2670.3744, 2798.4330, 2885.4650, 3032.5334, 3179.6018, 3280.6495, 3394.6924, 3491.7452, 3588.7980, 3675.8300, 3804.8726, 3901.9253, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TEDDEDDAEEEEDDEQSCSGCCCSSNQCSCLSAR", {102.0550, 231.0975, 346.1245, 461.1514, 590.1940, 705.2210, 820.2479, 891.2850, 1020.3276, 1149.3702, 1278.4128, 1407.4554, 1522.4823, 1637.5093, 1766.5519, 1894.6105, 1981.6425, 2141.6731, 2228.7052, 2285.7266, 2445.7573, 2605.7879, 2765.8186, 2852.8506, 2939.8826, 3053.9256, 3181.9841, 3342.0148, 3429.0468, 3589.0775, 3702.1615, 3789.1936, 3860.2307, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 246.1561, 333.1881, 446.2722, 606.3028, 693.3348, 853.3655, 981.4241, 1095.4670, 1182.4990, 1269.5310, 1429.5617, 1589.5923, 1749.6230, 1806.6445, 1893.6765, 2053.7071, 2140.7392, 2268.7977, 2397.8403, 2512.8673, 2627.8942, 2756.9368, 2885.9794, 3015.0220, 3144.0646, 3215.1017, 3330.1286, 3445.1556, 3574.1982, 3689.2251, 3804.2521, 3933.2947, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"KPDIPPGWMFSQLYSTYMTTTIVSFFCVLMSILK", {129.1022, 226.1550, 341.1819, 454.2660, 551.3188, 648.3715, 705.3930, 891.4723, 1022.5128, 1169.5812, 1256.6132, 1384.6718, 1497.7559, 1660.8192, 1747.8512, 1848.8989, 2011.9622, 2143.0027, 2244.0504, 2345.0981, 2446.1458, 2559.2298, 2658.2982, 2745.3303, 2892.3987, 3039.4671, 3199.4978, 3298.5662, 3411.6502, 3542.6907, 3629.7227, 3742.8068, 3855.8909, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 373.2809, 460.3130, 591.3534, 704.4375, 803.5059, 963.5366, 1110.6050, 1257.6734, 1344.7054, 1443.7738, 1556.8579, 1657.9056, 1758.9533, 1860.0009, 1991.0414, 2154.1048, 2255.1524, 2342.1845, 2505.2478, 2618.3319, 2746.3904, 2833.4225, 2980.4909, 3111.5314, 3297.6107, 3354.6321, 3451.6849, 3548.7377, 3661.8217, 3776.8487, 3873.9014, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SDTSCLQSLTNGACIQEFTMNWGYIESCTEKPQR", {88.0393, 203.0662, 304.1139, 391.1460, 551.1766, 664.2607, 792.3192, 879.3513, 992.4353, 1093.4830, 1207.5259, 1264.5474, 1335.5845, 1495.6152, 1608.6992, 1736.7578, 1865.8004, 2012.8688, 2113.9165, 2244.9570, 2358.9999, 2545.0792, 2602.1007, 2765.1640, 2878.2481, 3007.2907, 3094.3227, 3254.3533, 3355.4010, 3484.4436, 3612.5386, 3709.5913, 3837.6499, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 400.2303, 528.3253, 657.3678, 758.4155, 918.4462, 1005.4782, 1134.5208, 1247.6049, 1410.6682, 1467.6897, 1653.7690, 1767.8119, 1898.8524, 1999.9001, 2146.9685, 2276.0111, 2404.0696, 2517.1537, 2677.1844, 2748.2215, 2805.2429, 2919.2859, 3020.3335, 3133.4176, 3220.4496, 3348.5082, 3461.5923, 3621.6229, 3708.6549, 3809.7026, 3924.7296, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VYTIQANPGVYNLNLPFLSQVELDVGWLFWQYTK", {100.0757, 263.1390, 364.1867, 477.2708, 605.3293, 676.3665, 790.4094, 887.4621, 944.4836, 1043.5520, 1206.6154, 1320.6583, 1433.7423, 1547.7853, 1660.8693, 1757.9221, 1904.9905, 2018.0746, 2105.1066, 2233.1652, 2332.2336, 2461.2762, 2574.3603, 2689.3872, 2788.4556, 2845.4771, 3031.5564, 3144.6405, 3291.7089, 3477.7882, 3605.8468, 3768.9101, 3869.9578, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 248.1605, 411.2238, 539.2824, 725.3617, 872.4301, 985.5142, 1171.5935, 1228.6150, 1327.6834, 1442.7103, 1555.7944, 1684.8370, 1783.9054, 1911.9640, 1998.9960, 2112.0801, 2259.1485, 2356.2012, 2469.2853, 2583.3282, 2696.4123, 2810.4552, 2973.5185, 3072.5870, 3129.6084, 3226.6612, 3340.7041, 3411.7412, 3539.7998, 3652.8839, 3753.9315, 3916.9949, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"HNGFEDTGGCLHYILTFLFFFIALSMGYVMHLIR", {138.0662, 252.1091, 309.1306, 456.1990, 585.2416, 700.2685, 801.3162, 858.3377, 915.3591, 1075.3898, 1188.4738, 1325.5328, 1488.5961, 1601.6802, 1714.7642, 1815.8119, 1962.8803, 2075.9644, 2223.0328, 2370.1012, 2517.1696, 2630.2537, 2701.2908, 2814.3749, 2901.4069, 3032.4474, 3089.4688, 3252.5322, 3351.6006, 3482.6411, 3619.7000, 3732.7840, 3845.8681, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 401.2871, 538.3460, 669.3865, 768.4549, 931.5182, 988.5397, 1119.5802, 1206.6122, 1319.6963, 1390.7334, 1503.8174, 1650.8859, 1797.9543, 1945.0227, 2058.1067, 2205.1752, 2306.2228, 2419.3069, 2532.3910, 2695.4543, 2832.5132, 2945.5973, 3105.6279, 3162.6494, 3219.6708, 3320.7185, 3435.7455, 3564.7881, 3711.8565, 3768.8779, 3882.9209, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LYNMQIAIFTVTVLILFWPMWTLFVNGGNNLTQR", {114.0913, 277.1547, 391.1976, 522.2381, 650.2967, 763.3807, 834.4178, 947.5019, 1094.5703, 1195.6180, 1294.6864, 1395.7341, 1494.8025, 1607.8866, 1720.9706, 1834.0547, 1981.1231, 2167.2024, 2264.2552, 2395.2957, 2581.3750, 2682.4227, 2795.5067, 2942.5751, 3041.6436, 3155.6865, 3212.7079, 3269.7294, 3383.7723, 3497.8153, 3610.8993, 3711.9470, 3840.0056, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 404.2252, 517.3093, 631.3522, 745.3951, 802.4166, 859.4381, 973.4810, 1072.5494, 1219.6178, 1332.7019, 1433.7496, 1619.8289, 1750.8694, 1847.9221, 2034.0014, 2181.0698, 2294.1539, 2407.2380, 2520.3220, 2619.3904, 2720.4381, 2819.5065, 2920.5542, 3067.6226, 3180.7067, 3251.7438, 3364.8279, 3492.8865, 3623.9269, 3737.9699, 3901.0332, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ELMCMGFAYVDVSEDYHEEYMEPAMFEPTGIVSK", {130.0499, 243.1339, 374.1744, 534.2051, 665.2456, 722.2670, 869.3354, 940.3725, 1103.4359, 1202.5043, 1317.5312, 1416.5996, 1503.6317, 1632.6743, 1747.7012, 1910.7645, 2047.8234, 2176.8660, 2305.9086, 2468.9720, 2600.0124, 2729.0550, 2826.1078, 2897.1449, 3028.1854, 3175.2538, 3304.2964, 3401.3492, 3502.3969, 3559.4183, 3672.5024, 3771.5708, 3858.6028, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 234.1448, 333.2132, 446.2973, 503.3188, 604.3665, 701.4192, 830.4618, 977.5302, 1108.5707, 1179.6078, 1276.6606, 1405.7032, 1536.7437, 1699.8070, 1828.8496, 1957.8922, 2094.9511, 2258.0144, 2373.0414, 2502.0840, 2589.1160, 2688.1844, 2803.2113, 2902.2798, 3065.3431, 3136.3802, 3283.4486, 3340.4701, 3471.5106, 3631.5412, 3762.5817, 3875.6658, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"AMEELEAHAGQCEHLTIHQLYHVSSSSDYIPEYR", {72.0444, 203.0849, 332.1275, 461.1701, 574.2541, 703.2967, 774.3338, 911.3927, 982.4299, 1039.4513, 1167.5099, 1327.5405, 1456.5831, 1593.6421, 1706.7261, 1807.7738, 1920.8579, 2057.9168, 2185.9753, 2299.0594, 2462.1227, 2599.1817, 2698.2501, 2785.2821, 2872.3141, 2959.3462, 3046.3782, 3161.4051, 3324.4685, 3437.5525, 3534.6053, 3663.6479, 3826.7112, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 467.2249, 564.2776, 677.3617, 840.4250, 955.4520, 1042.4840, 1129.5160, 1216.5481, 1303.5801, 1402.6485, 1539.7074, 1702.7707, 1815.8548, 1943.9134, 2080.9723, 2194.0564, 2295.1040, 2408.1881, 2545.2470, 2674.2896, 2834.3203, 2962.3788, 3019.4003, 3090.4374, 3227.4963, 3298.5334, 3427.5760, 3540.6601, 3669.7027, 3798.7453, 3929.7858, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EEEIQEEEDYMEDATTVDDEDDSSESDLHQELTK", {130.0499, 259.0925, 388.1351, 501.2191, 629.2777, 758.3203, 887.3629, 1016.4055, 1131.4324, 1294.4957, 1425.5362, 1554.5788, 1669.6058, 1740.6429, 1841.6906, 1942.7382, 2041.8067, 2156.8336, 2271.8605, 2400.9031, 2515.9301, 2630.9570, 2717.9890, 2805.0211, 2934.0637, 3021.0957, 3136.1226, 3249.2067, 3386.2656, 3514.3242, 3643.3668, 3756.4509, 3857.4985, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 248.1605, 361.2445, 490.2871, 618.3457, 755.4046, 868.4887, 983.5156, 1070.5477, 1199.5903, 1286.6223, 1373.6543, 1488.6813, 1603.7082, 1732.7508, 1847.7777, 1962.8047, 2061.8731, 2162.9208, 2263.9685, 2335.0056, 2450.0325, 2579.0751, 2710.1156, 2873.1789, 2988.2059, 3117.2485, 3246.2910, 3375.3336, 3503.3922, 3616.4763, 3745.5189, 3874.5615, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VAPNATGVYFWVVFVVLFCTLAYYWNVLLMVLLK", {100.0757, 171.1128, 268.1656, 382.2085, 453.2456, 554.2933, 611.3148, 710.3832, 873.4465, 1020.5149, 1206.5942, 1305.6626, 1404.7310, 1551.7995, 1650.8679, 1749.9363, 1863.0204, 2010.0888, 2170.1194, 2271.1671, 2384.2512, 2455.2883, 2618.3516, 2781.4149, 2967.4942, 3081.5372, 3180.6056, 3293.6896, 3406.7737, 3537.8142, 3636.8826, 3749.9667, 3863.0507, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 373.2809, 472.3493, 603.3898, 716.4739, 829.5580, 928.6264, 1042.6693, 1228.7486, 1391.8119, 1554.8753, 1625.9124, 1738.9964, 1840.0441, 2000.0748, 2147.1432, 2260.2273, 2359.2957, 2458.3641, 2605.4325, 2704.5009, 2803.5693, 2989.6486, 3136.7170, 3299.7804, 3398.8488, 3455.8703, 3556.9179, 3627.9550, 3741.9980, 3839.0507, 3910.0879, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EPLAPPAVPPPLPHHHEHHDHHDHHDHHDHHDHK", {130.0499, 227.1026, 340.1867, 411.2238, 508.2766, 605.3293, 676.3665, 775.4349, 872.4876, 969.5404, 1066.5932, 1179.6772, 1276.7300, 1413.7889, 1550.8478, 1687.9067, 1816.9493, 1954.0082, 2091.0671, 2206.0941, 2343.1530, 2480.2119, 2595.2388, 2732.2978, 2869.3567, 2984.3836, 3121.4425, 3258.5014, 3373.5284, 3510.5873, 3647.6462, 3762.6731, 3899.7321, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 284.1717, 399.1987, 536.2576, 673.3165, 788.3434, 925.4023, 1062.4612, 1177.4882, 1314.5471, 1451.6060, 1566.6330, 1703.6919, 1840.7508, 1955.7777, 2092.8366, 2229.8956, 2358.9381, 2495.9971, 2633.0560, 2770.1149, 2867.1676, 2980.2517, 3077.3045, 3174.3572, 3271.4100, 3370.4784, 3441.5155, 3538.5683, 3635.6211, 3706.6582, 3819.7422, 3916.7950, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PSTMINNIVRPELDILVARPIYHNDDAQYFFVDK", {98.0600, 185.0921, 286.1397, 417.1802, 530.2643, 644.3072, 758.3502, 871.4342, 970.5026, 1126.6037, 1223.6565, 1352.6991, 1465.7832, 1580.8101, 1693.8942, 1806.9782, 1906.0466, 1977.0838, 2133.1849, 2230.2376, 2343.3217, 2506.3850, 2643.4439, 2757.4869, 2872.5138, 2987.5408, 3058.5779, 3186.6364, 3349.6998, 3496.7682, 3643.8366, 3742.9050, 3857.9320, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 262.1397, 361.2082, 508.2766, 655.3450, 818.4083, 946.4669, 1017.5040, 1132.5310, 1247.5579, 1361.6008, 1498.6597, 1661.7231, 1774.8071, 1871.8599, 2027.9610, 2098.9981, 2198.0665, 2311.1506, 2424.2347, 2539.2616, 2652.3457, 2781.3883, 2878.4410, 3034.5421, 3133.6105, 3246.6946, 3360.7375, 3474.7805, 3587.8645, 3718.9050, 3819.9527, 3906.9847, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DQGVVQIITFAGYTLAIWYICCLFMGLVLFPCIR", {116.0342, 244.0928, 301.1143, 400.1827, 499.2511, 627.3097, 740.3937, 853.4778, 954.5255, 1101.5939, 1172.6310, 1229.6525, 1392.7158, 1493.7635, 1606.8475, 1677.8846, 1790.9687, 1977.0480, 2140.1114, 2253.1954, 2413.2261, 2573.2567, 2686.3408, 2833.4092, 2964.4497, 3021.4711, 3134.5552, 3233.6236, 3346.7077, 3493.7761, 3590.8289, 3750.8595, 3863.9436, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 448.2337, 545.2864, 692.3548, 805.4389, 904.5073, 1017.5914, 1074.6128, 1205.6533, 1352.7217, 1465.8058, 1625.8365, 1785.8671, 1898.9512, 2062.0145, 2248.0938, 2361.1779, 2432.2150, 2545.2991, 2646.3467, 2809.4101, 2866.4315, 2937.4686, 3084.5371, 3185.5847, 3298.6688, 3411.7529, 3539.8114, 3638.8799, 3737.9483, 3794.9697, 3923.0283, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MMFIAHPLQVHATQQVEELFLEYTYNSTDVNVSR", {132.0478, 263.0882, 410.1567, 523.2407, 594.2778, 731.3367, 828.3895, 941.4736, 1069.5322, 1168.6006, 1305.6595, 1376.6966, 1477.7443, 1605.8029, 1733.8614, 1832.9298, 1961.9724, 2091.0150, 2204.0991, 2351.1675, 2464.2516, 2593.2942, 2756.3575, 2857.4052, 3020.4685, 3134.5114, 3221.5435, 3322.5911, 3437.6181, 3536.6865, 3650.7294, 3749.7978, 3836.8299, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 262.1510, 361.2194, 475.2623, 574.3307, 689.3577, 790.4054, 877.4374, 991.4803, 1154.5436, 1255.5913, 1418.6546, 1547.6972, 1660.7813, 1807.8497, 1920.9338, 2049.9764, 2179.0190, 2278.0874, 2406.1460, 2534.2045, 2635.2522, 2706.2893, 2843.3482, 2942.4167, 3070.4752, 3183.5593, 3280.6121, 3417.6710, 3488.7081, 3601.7922, 3748.8606, 3879.9011, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LEPPVEIAVCDDDEEHEFEEPKPEVQPCQDVEPK", {114.0913, 243.1339, 340.1867, 437.2395, 536.3079, 665.3505, 778.4345, 849.4716, 948.5401, 1108.5707, 1223.5977, 1338.6246, 1453.6515, 1582.6941, 1711.7367, 1848.7956, 1977.8382, 2124.9066, 2253.9492, 2382.9918, 2480.0446, 2608.1396, 2705.1923, 2834.2349, 2933.3033, 3061.3619, 3158.4147, 3318.4453, 3446.5039, 3561.5308, 3660.5993, 3789.6418, 3886.6946, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 244.1656, 373.2082, 472.2766, 587.3035, 715.3621, 875.3927, 972.4455, 1100.5041, 1199.5725, 1328.6151, 1425.6679, 1553.7628, 1650.8156, 1779.8582, 1908.9008, 2055.9692, 2185.0118, 2322.0707, 2451.1133, 2580.1559, 2695.1828, 2810.2098, 2925.2367, 3085.2674, 3184.3358, 3255.3729, 3368.4569, 3497.4995, 3596.5680, 3693.6207, 3790.6735, 3919.7161, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YQPLNTACIQLFFLDMDAMSNCFNAQIYTMAQGK", {164.0706, 292.1292, 389.1819, 502.2660, 616.3089, 717.3566, 788.3937, 948.4244, 1061.5084, 1189.5670, 1302.6511, 1449.7195, 1596.7879, 1709.8720, 1824.8989, 1955.9394, 2070.9663, 2142.0035, 2273.0439, 2360.0760, 2474.1189, 2634.1495, 2781.2180, 2895.2609, 2966.2980, 3094.3566, 3207.4406, 3370.5040, 3471.5517, 3602.5921, 3673.6293, 3801.6878, 3858.7093, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 204.1343, 332.1928, 403.2300, 534.2704, 635.3181, 798.3815, 911.4655, 1039.5241, 1110.5612, 1224.6041, 1371.6725, 1531.7032, 1645.7461, 1732.7782, 1863.8186, 1934.8558, 2049.8827, 2180.9232, 2295.9501, 2409.0342, 2556.1026, 2703.1710, 2816.2551, 2944.3137, 3057.3977, 3217.4284, 3288.4655, 3389.5132, 3503.5561, 3616.6402, 3713.6929, 3841.7515, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TVCCSEEGPCFADSDIDDCFIAFIGNMCEGECEK", {102.0550, 201.1234, 361.1540, 521.1847, 608.2167, 737.2593, 866.3019, 923.3233, 1020.3761, 1180.4068, 1327.4752, 1398.5123, 1513.5392, 1600.5713, 1715.5982, 1828.6823, 1943.7092, 2058.7361, 2218.7668, 2365.8352, 2478.9193, 2549.9564, 2697.0248, 2810.1089, 2867.1303, 2981.1733, 3112.2137, 3272.2444, 3401.2870, 3458.3084, 3587.3510, 3747.3817, 3876.4243, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 276.1554, 436.1860, 565.2286, 622.2501, 751.2927, 911.3233, 1042.3638, 1156.4068, 1213.4282, 1326.5123, 1473.5807, 1544.6178, 1657.7019, 1804.7703, 1964.8009, 2079.8279, 2194.8548, 2307.9389, 2422.9658, 2509.9979, 2625.0248, 2696.0619, 2843.1303, 3003.1610, 3100.2137, 3157.2352, 3286.2778, 3415.3204, 3502.3524, 3662.3831, 3822.4137, 3921.4821, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LMGCCESFTLTNAILWDQLCGLPALSLVLQYEMR", {114.0913, 245.1318, 302.1533, 462.1839, 622.2146, 751.2572, 838.2892, 985.3576, 1086.4053, 1199.4894, 1300.5370, 1414.5800, 1485.6171, 1598.7011, 1711.7852, 1897.8645, 2012.8915, 2140.9500, 2254.0341, 2414.0648, 2471.0862, 2584.1703, 2681.2230, 2752.2602, 2865.3442, 2952.3763, 3065.4603, 3164.5287, 3277.6128, 3405.6714, 3568.7347, 3697.7773, 3828.8178, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 306.1594, 435.2020, 598.2654, 726.3239, 839.4080, 938.4764, 1051.5605, 1138.5925, 1251.6766, 1322.7137, 1419.7664, 1532.8505, 1589.8720, 1749.9026, 1862.9867, 1991.0453, 2106.0722, 2292.1515, 2405.2356, 2518.3197, 2589.3568, 2703.3997, 2804.4474, 2917.5314, 3018.5791, 3165.6475, 3252.6796, 3381.7221, 3541.7528, 3701.7834, 3758.8049, 3889.8454, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EVQQEQLEGSSDQDGDDDHFSNDDEQYSMCSYQR", {130.0499, 229.1183, 357.1769, 485.2354, 614.2780, 742.3366, 855.4207, 984.4633, 1041.4847, 1128.5168, 1215.5488, 1330.5757, 1458.6343, 1573.6613, 1630.6827, 1745.7097, 1860.7366, 1975.7635, 2112.8225, 2259.8909, 2346.9229, 2460.9658, 2575.9928, 2691.0197, 2820.0623, 2948.1209, 3111.1842, 3198.2162, 3329.2567, 3489.2874, 3576.3194, 3739.3827, 3867.4413, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 466.2409, 553.2729, 713.3035, 844.3440, 931.3760, 1094.4394, 1222.4980, 1351.5405, 1466.5675, 1581.5944, 1695.6374, 1782.6694, 1929.7378, 2066.7967, 2181.8237, 2296.8506, 2411.8775, 2468.8990, 2583.9260, 2711.9845, 2827.0115, 2914.0435, 3001.0755, 3058.0970, 3187.1396, 3300.2236, 3428.2822, 3557.3248, 3685.3834, 3813.4420, 3912.5104, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VPDWIGFVCAELVNPMEAIVNEIESPYYMINQYK", {100.0757, 197.1285, 312.1554, 498.2347, 611.3188, 668.3402, 815.4087, 914.4771, 1074.5077, 1145.5448, 1274.5874, 1387.6715, 1486.7399, 1600.7828, 1697.8356, 1828.8761, 1957.9187, 2028.9558, 2142.0398, 2241.1083, 2355.1512, 2484.1938, 2597.2778, 2726.3204, 2813.3525, 2910.4052, 3073.4686, 3236.5319, 3367.5724, 3480.6564, 3594.6994, 3722.7579, 3885.8213, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 310.1761, 438.2347, 552.2776, 665.3617, 796.4022, 959.4655, 1122.5288, 1219.5816, 1306.6136, 1435.6562, 1548.7403, 1677.7829, 1791.8258, 1890.8942, 2003.9783, 2075.0154, 2204.0580, 2335.0985, 2432.1512, 2546.1942, 2645.2626, 2758.3467, 2887.3892, 2958.4264, 3118.4570, 3217.5254, 3364.5938, 3421.6153, 3534.6994, 3720.7787, 3835.8056, 3932.8584, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NEFPYYPDIAQYPLWVSYSQVDLWSPMELGSANK", {115.0502, 244.0928, 391.1612, 488.2140, 651.2773, 814.3406, 911.3934, 1026.4203, 1139.5044, 1210.5415, 1338.6001, 1501.6634, 1598.7162, 1711.8003, 1897.8796, 1996.9480, 2083.9800, 2247.0433, 2334.0754, 2462.1339, 2561.2024, 2676.2293, 2789.3134, 2975.3927, 3062.4247, 3159.4775, 3290.5180, 3419.5605, 3532.6446, 3589.6661, 3676.6981, 3747.7352, 3861.7781, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 261.1557, 332.1928, 419.2249, 476.2463, 589.3304, 718.3730, 849.4135, 946.4662, 1033.4983, 1219.5776, 1332.6616, 1447.6886, 1546.7570, 1674.8156, 1761.8476, 1924.9109, 2011.9430, 2111.0114, 2297.0907, 2410.1748, 2507.2275, 2670.2909, 2798.3494, 2869.3865, 2982.4706, 3097.4976, 3194.5503, 3357.6136, 3520.6770, 3617.7297, 3764.7981, 3893.8407, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FLPNEELNAYTVYSSITEYIPYYFNFDGSIEALK", {148.0757, 261.1598, 358.2125, 472.2554, 601.2980, 730.3406, 843.4247, 957.4676, 1028.5047, 1191.5681, 1292.6157, 1391.6842, 1554.7475, 1641.7795, 1728.8115, 1841.8956, 1942.9433, 2071.9859, 2235.0492, 2348.1333, 2445.1860, 2608.2494, 2771.3127, 2918.3811, 3032.4240, 3179.4924, 3294.5194, 3351.5409, 3438.5729, 3551.6569, 3680.6995, 3751.7367, 3864.8207, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 331.2340, 460.2766, 573.3606, 660.3927, 717.4141, 832.4411, 979.5095, 1093.5524, 1240.6208, 1403.6842, 1566.7475, 1663.8003, 1776.8843, 1939.9476, 2068.9902, 2170.0379, 2283.1220, 2370.1540, 2457.1860, 2620.2494, 2719.3178, 2820.3655, 2983.4288, 3054.4659, 3168.5088, 3281.5929, 3410.6355, 3539.6781, 3653.7210, 3750.7738, 3863.8578, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MQILFFIFVATSEPYLYCLSGYGLIIEYLNLIVK", {132.0478, 260.1063, 373.1904, 486.2745, 633.3429, 780.4113, 893.4954, 1040.5638, 1139.6322, 1210.6693, 1311.7170, 1398.7490, 1527.7916, 1624.8444, 1787.9077, 1900.9918, 2064.0551, 2224.0857, 2337.1698, 2424.2018, 2481.2233, 2644.2866, 2701.3081, 2814.3921, 2927.4762, 3040.5603, 3169.6029, 3332.6662, 3445.7503, 3559.7932, 3672.8773, 3785.9613, 3885.0297, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 246.1812, 359.2653, 472.3493, 586.3923, 699.4763, 862.5397, 991.5823, 1104.6663, 1217.7504, 1330.8345, 1387.8559, 1550.9192, 1607.9407, 1694.9727, 1808.0568, 1968.0874, 2131.1508, 2244.2348, 2407.2982, 2504.3509, 2633.3935, 2720.4256, 2821.4732, 2892.5103, 2991.5788, 3138.6472, 3251.7312, 3398.7997, 3545.8681, 3658.9521, 3772.0362, 3900.0948, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ENDLMEDAEELVQLYHLWATELGMVQEFTEESLK", {130.0499, 244.0928, 359.1197, 472.2038, 603.2443, 732.2869, 847.3138, 918.3509, 1047.3935, 1176.4361, 1289.5202, 1388.5886, 1516.6472, 1629.7312, 1792.7946, 1929.8535, 2042.9375, 2229.0169, 2300.0540, 2401.1017, 2530.1442, 2643.2283, 2700.2498, 2831.2903, 2930.3587, 3058.4173, 3187.4598, 3334.5283, 3435.5759, 3564.6185, 3693.6611, 3780.6932, 3893.7772, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 347.2289, 476.2715, 605.3141, 706.3618, 853.4302, 982.4728, 1110.5313, 1209.5998, 1340.6402, 1397.6617, 1510.7458, 1639.7884, 1740.8360, 1811.8732, 1997.9525, 2111.0365, 2248.0954, 2411.1588, 2524.2428, 2652.3014, 2751.3698, 2864.4539, 2993.4965, 3122.5391, 3193.5762, 3308.6031, 3437.6457, 3568.6862, 3681.7703, 3796.7972, 3910.8402, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NQTEEMMVSEGGHMAWTVCNEHEFQQQLLSTESR", {115.0502, 243.1088, 344.1565, 473.1991, 602.2416, 733.2821, 864.3226, 963.3910, 1050.4231, 1179.4657, 1236.4871, 1293.5086, 1430.5675, 1561.6080, 1632.6451, 1818.7244, 1919.7721, 2018.8405, 2178.8711, 2292.9141, 2421.9567, 2559.0156, 2688.0582, 2835.1266, 2963.1852, 3091.2437, 3219.3023, 3332.3864, 3445.4704, 3532.5025, 3633.5501, 3762.5927, 3849.6248, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 262.1510, 391.1936, 492.2413, 579.2733, 692.3573, 805.4414, 933.5000, 1061.5586, 1189.6171, 1336.6856, 1465.7281, 1602.7871, 1731.8297, 1845.8726, 2005.9032, 2104.9716, 2206.0193, 2392.0986, 2463.1357, 2594.1762, 2731.2351, 2788.2566, 2845.2781, 2974.3207, 3061.3527, 3160.4211, 3291.4616, 3422.5021, 3551.5447, 3680.5873, 3781.6349, 3909.6935, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QPNAPGLSQQICDIDDETPWYSSYIHNLILEFMK", {129.0659, 226.1186, 340.1615, 411.1987, 508.2514, 565.2729, 678.3570, 765.3890, 893.4476, 1021.5061, 1134.5902, 1294.6208, 1409.6478, 1522.7319, 1637.7588, 1752.7857, 1881.8283, 1982.8760, 2079.9288, 2266.0081, 2429.0714, 2516.1034, 2603.1355, 2766.1988, 2879.2829, 3016.3418, 3130.3847, 3243.4688, 3356.5528, 3469.6369, 3598.6795, 3745.7479, 3876.7884, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 278.1533, 425.2217, 554.2643, 667.3484, 780.4324, 893.5165, 1007.5594, 1144.6183, 1257.7024, 1420.7657, 1507.7977, 1594.8298, 1757.8931, 1943.9724, 2041.0252, 2142.0729, 2271.1155, 2386.1424, 2501.1693, 2614.2534, 2729.2803, 2889.3110, 3002.3951, 3130.4536, 3258.5122, 3345.5442, 3458.6283, 3515.6498, 3612.7025, 3683.7396, 3797.7826, 3894.8353, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LLLFNAIILLVPMAMLVALCIHWPYWSSIAEFIR", {114.0913, 227.1754, 340.2595, 487.3279, 601.3708, 672.4079, 785.4920, 898.5761, 1011.6601, 1124.7442, 1223.8126, 1320.8654, 1451.9058, 1522.9430, 1653.9834, 1767.0675, 1866.1359, 1937.1730, 2050.2571, 2210.2877, 2323.3718, 2460.4307, 2646.5100, 2743.5628, 2906.6261, 3092.7054, 3179.7375, 3266.7695, 3379.8536, 3450.8907, 3579.9333, 3727.0017, 3840.0857, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 435.2714, 564.3140, 635.3511, 748.4352, 835.4672, 922.4993, 1108.5786, 1271.6419, 1368.6947, 1554.7740, 1691.8329, 1804.9170, 1964.9476, 2078.0317, 2149.0688, 2248.1372, 2361.2213, 2492.2617, 2563.2989, 2694.3393, 2791.3921, 2890.4605, 3003.5446, 3116.6286, 3229.7127, 3342.7968, 3413.8339, 3527.8768, 3674.9452, 3788.0293, 3901.1134, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LQQYGCGNGNQMQNDMFALTEEPNLQNHQHLEEK", {114.0913, 242.1499, 370.2085, 533.2718, 590.2933, 750.3239, 807.3454, 921.3883, 978.4098, 1092.4527, 1220.5113, 1351.5518, 1479.6104, 1593.6533, 1708.6802, 1839.7207, 1986.7891, 2057.8262, 2170.9103, 2271.9580, 2401.0006, 2530.0432, 2627.0959, 2741.1389, 2854.2229, 2982.2815, 3096.3244, 3233.3833, 3361.4419, 3498.5008, 3611.5849, 3740.6275, 3869.6701, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 276.1554, 405.1980, 518.2821, 655.3410, 783.3995, 920.4585, 1034.5014, 1162.5600, 1275.6440, 1389.6870, 1486.7397, 1615.7823, 1744.8249, 1845.8726, 1958.9566, 2029.9938, 2177.0622, 2308.1027, 2423.1296, 2537.1725, 2665.2311, 2796.2716, 2924.3302, 3038.3731, 3095.3946, 3209.4375, 3266.4590, 3426.4896, 3483.5111, 3646.5744, 3774.6330, 3902.6915, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"CPQMVAFAVYTMLLFQTCISLALVVILYDEDCHK", {161.0379, 258.0907, 386.1493, 517.1898, 616.2582, 687.2953, 834.3637, 905.4008, 1004.4692, 1167.5325, 1268.5802, 1399.6207, 1512.7048, 1625.7888, 1772.8573, 1900.9158, 2001.9635, 2161.9942, 2275.0782, 2362.1103, 2475.1943, 2546.2314, 2659.3155, 2758.3839, 2857.4523, 2970.5364, 3083.6204, 3246.6838, 3361.7107, 3490.7533, 3605.7803, 3765.8109, 3902.8698, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 284.1717, 444.2024, 559.2293, 688.2719, 803.2988, 966.3622, 1079.4462, 1192.5303, 1291.5987, 1390.6671, 1503.7512, 1574.7883, 1687.8724, 1774.9044, 1887.9885, 2048.0191, 2149.0668, 2277.1254, 2424.1938, 2537.2778, 2650.3619, 2781.4024, 2882.4501, 3045.5134, 3144.5818, 3215.6189, 3362.6873, 3433.7245, 3532.7929, 3663.8334, 3791.8919, 3888.9447, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PFDEPIDDYNQANNLPETQSEYESDEEINLDNTR", {98.0600, 245.1285, 360.1554, 489.1980, 586.2508, 699.3348, 814.3618, 929.3887, 1092.4520, 1206.4950, 1334.5535, 1405.5907, 1519.6336, 1633.6765, 1746.7606, 1843.8133, 1972.8559, 2073.9036, 2201.9622, 2288.9942, 2418.0368, 2581.1001, 2710.1427, 2797.1748, 2912.2017, 3041.2443, 3170.2869, 3283.3709, 3397.4139, 3510.4979, 3625.5249, 3739.5678, 3840.6155, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 276.1666, 390.2096, 505.2365, 618.3206, 732.3635, 845.4476, 974.4901, 1103.5327, 1218.5597, 1305.5917, 1434.6343, 1597.6976, 1726.7402, 1813.7723, 1941.8308, 2042.8785, 2171.9211, 2268.9739, 2382.0579, 2496.1009, 2610.1438, 2681.1809, 2809.2395, 2923.2824, 3086.3457, 3201.3727, 3316.3996, 3429.4837, 3526.5365, 3655.5790, 3770.6060, 3917.6744, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DCHMLQQQLVELRPADGLTNFVLDITNWHSPFPR", {116.0342, 276.0649, 413.1238, 544.1643, 657.2483, 785.3069, 913.3655, 1041.4241, 1154.5081, 1253.5765, 1382.6191, 1495.7032, 1651.8043, 1748.8571, 1819.8942, 1934.9211, 1991.9426, 2105.0267, 2206.0743, 2320.1173, 2467.1857, 2566.2541, 2679.3382, 2794.3651, 2907.4492, 3008.4968, 3122.5398, 3308.6191, 3445.6780, 3532.7100, 3629.7628, 3776.8312, 3873.8840, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 272.1717, 419.2401, 516.2929, 603.3249, 740.3838, 926.4631, 1040.5061, 1141.5538, 1254.6378, 1369.6648, 1482.7488, 1581.8172, 1728.8857, 1842.9286, 1943.9763, 2057.0603, 2114.0818, 2229.1087, 2300.1458, 2397.1986, 2553.2997, 2666.3838, 2795.4264, 2894.4948, 3007.5789, 3135.6374, 3263.6960, 3391.7546, 3504.8386, 3635.8791, 3772.9380, 3932.9687, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PARPQSHRPSNIIIVPLSVIYVWVAQFTWFVAYR", {98.0600, 169.0972, 325.1983, 422.2510, 550.3096, 637.3416, 774.4005, 930.5017, 1027.5544, 1114.5865, 1228.6294, 1341.7134, 1454.7975, 1567.8816, 1666.9500, 1764.0027, 1877.0868, 1964.1188, 2063.1873, 2176.2713, 2339.3346, 2438.4031, 2624.4824, 2723.5508, 2794.5879, 2922.6465, 3069.7149, 3170.7626, 3356.8419, 3503.9103, 3602.9787, 3674.0158, 3837.0792, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 409.2194, 508.2878, 655.3562, 841.4355, 942.4832, 1089.5516, 1217.6102, 1288.6473, 1387.7157, 1573.7950, 1672.8635, 1835.9268, 1949.0109, 2048.0793, 2135.1113, 2248.1954, 2345.2481, 2444.3165, 2557.4006, 2670.4847, 2783.5687, 2897.6117, 2984.6437, 3081.6964, 3237.7976, 3374.8565, 3461.8885, 3589.9471, 3686.9998, 3843.1010, 3914.1381, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"CFVLLCFLANVMIMNLTDFEETPWSGGCFFGGLR", {161.0379, 308.1063, 407.1748, 520.2588, 633.3429, 793.3735, 940.4419, 1053.5260, 1124.5631, 1238.6060, 1337.6745, 1468.7149, 1581.7990, 1712.8395, 1826.8824, 1939.9665, 2041.0142, 2156.0411, 2303.1095, 2432.1521, 2561.1947, 2662.2424, 2759.2952, 2945.3745, 3032.4065, 3089.4280, 3146.4494, 3306.4801, 3453.5485, 3600.6169, 3657.6384, 3714.6598, 3827.7439, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 345.2245, 402.2459, 549.3144, 696.3828, 856.4134, 913.4349, 970.4563, 1057.4884, 1243.5677, 1340.6205, 1441.6681, 1570.7107, 1699.7533, 1846.8217, 1961.8487, 2062.8964, 2175.9804, 2290.0233, 2421.0638, 2534.1479, 2665.1884, 2764.2568, 2878.2997, 2949.3368, 3062.4209, 3209.4893, 3369.5200, 3482.6040, 3595.6881, 3694.7565, 3841.8249, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PSETQNNGDSAIEYPQCQQLTANFFNDTYCLEHR", {98.0600, 185.0921, 314.1347, 415.1823, 543.2409, 657.2838, 771.3268, 828.3482, 943.3752, 1030.4072, 1101.4443, 1214.5284, 1343.5710, 1506.6343, 1603.6871, 1731.7456, 1891.7763, 2019.8349, 2147.8935, 2260.9775, 2362.0252, 2433.0623, 2547.1052, 2694.1737, 2841.2421, 2955.2850, 3070.3119, 3171.3596, 3334.4229, 3494.4536, 3607.5377, 3736.5802, 3873.6392, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 312.1779, 441.2205, 554.3045, 714.3352, 877.3985, 978.4462, 1093.4731, 1207.5160, 1354.5845, 1501.6529, 1615.6958, 1686.7329, 1787.7806, 1900.8647, 2028.9232, 2156.9818, 2317.0125, 2445.0710, 2542.1238, 2705.1871, 2834.2297, 2947.3138, 3018.3509, 3105.3829, 3220.4099, 3277.4313, 3391.4743, 3505.5172, 3633.5758, 3734.6234, 3863.6660, 3950.6981, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LQQLYEISPQTPTDLFQQLQDVTQYMTNQPRPAK", {114.0913, 242.1499, 370.2085, 483.2926, 646.3559, 775.3985, 888.4825, 975.5146, 1072.5673, 1200.6259, 1301.6736, 1398.7264, 1499.7740, 1614.8010, 1727.8850, 1874.9535, 2003.0120, 2131.0706, 2244.1547, 2372.2133, 2487.2402, 2586.3086, 2687.3563, 2815.4149, 2978.4782, 3109.5187, 3210.5664, 3324.6093, 3452.6679, 3549.7206, 3705.8217, 3802.8745, 3873.9116, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 218.1499, 315.2027, 471.3038, 568.3566, 696.4151, 810.4581, 911.5057, 1042.5462, 1205.6096, 1333.6681, 1434.7158, 1533.7842, 1648.8112, 1776.8697, 1889.9538, 2018.0124, 2146.0710, 2293.1394, 2406.2234, 2521.2504, 2622.2981, 2719.3508, 2820.3985, 2948.4571, 3045.5098, 3132.5419, 3245.6259, 3374.6685, 3537.7319, 3650.8159, 3778.8745, 3906.9331, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ICVNNVDVQCCNLTENFYSGSDCSVSTWDGSQCK", {114.0913, 274.1220, 373.1904, 487.2333, 601.2763, 700.3447, 815.3716, 914.4400, 1042.4986, 1202.5293, 1362.5599, 1476.6028, 1589.6869, 1690.7346, 1819.7772, 1933.8201, 2080.8885, 2243.9518, 2330.9839, 2388.0053, 2475.0374, 2590.0643, 2750.0949, 2837.1270, 2936.1954, 3023.2274, 3124.2751, 3310.3544, 3425.3814, 3482.4028, 3569.4348, 3697.4934, 3857.5241, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 307.1435, 435.2020, 522.2341, 579.2555, 694.2825, 880.3618, 981.4095, 1068.4415, 1167.5099, 1254.5419, 1414.5726, 1529.5995, 1616.6315, 1673.6530, 1760.6850, 1923.7484, 2070.8168, 2184.8597, 2313.9023, 2414.9500, 2528.0340, 2642.0770, 2802.1076, 2962.1383, 3090.1968, 3189.2653, 3304.2922, 3403.3606, 3517.4035, 3631.4465, 3730.5149, 3890.5455, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YTCPYIFSLLIILSMISSMGELLPDFIYAPFPYR", {164.0706, 265.1183, 425.1489, 522.2017, 685.2650, 798.3491, 945.4175, 1032.4495, 1145.5336, 1258.6177, 1371.7017, 1484.7858, 1597.8699, 1684.9019, 1815.9424, 1929.0264, 2016.0585, 2103.0905, 2234.1310, 2291.1524, 2420.1950, 2533.2791, 2646.3632, 2743.4159, 2858.4429, 3005.5113, 3118.5953, 3281.6587, 3352.6958, 3449.7485, 3596.8170, 3693.8697, 3856.9331, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 435.2350, 582.3035, 679.3562, 750.3933, 913.4567, 1026.5407, 1173.6091, 1288.6361, 1385.6888, 1498.7729, 1611.8570, 1740.8996, 1797.9210, 1928.9615, 2015.9935, 2103.0256, 2216.1096, 2347.1501, 2434.1822, 2547.2662, 2660.3503, 2773.4343, 2886.5184, 2999.6025, 3086.6345, 3233.7029, 3346.7870, 3509.8503, 3606.9031, 3766.9337, 3867.9814, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NLEDSCIIDVLQGVPLLLFEESEMVEQFNHQTFK", {115.0502, 228.1343, 357.1769, 472.2038, 559.2358, 719.2665, 832.3505, 945.4346, 1060.4616, 1159.5300, 1272.6140, 1400.6726, 1457.6941, 1556.7625, 1653.8152, 1766.8993, 1879.9834, 1993.0674, 2140.1359, 2269.1784, 2398.2210, 2485.2531, 2614.2957, 2745.3361, 2844.4046, 2973.4472, 3101.5057, 3248.5741, 3362.6171, 3499.6760, 3627.7346, 3728.7822, 3875.8507, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 294.1812, 395.2289, 523.2875, 660.3464, 774.3893, 921.4577, 1049.5163, 1178.5589, 1277.6273, 1408.6678, 1537.7104, 1624.7424, 1753.7850, 1882.8276, 2029.8960, 2142.9801, 2256.0641, 2369.1482, 2466.2010, 2565.2694, 2622.2909, 2750.3494, 2863.4335, 2962.5019, 3077.5289, 3190.6129, 3303.6970, 3463.7276, 3550.7597, 3665.7866, 3794.8292, 3907.9133, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LLEQPLCEELLDEEDETTSAFGPLYGYNDYADYR", {114.0913, 227.1754, 356.2180, 484.2766, 581.3293, 694.4134, 854.4441, 983.4866, 1112.5292, 1225.6133, 1338.6974, 1453.7243, 1582.7669, 1711.8095, 1826.8364, 1955.8790, 2056.9267, 2157.9744, 2245.0064, 2316.0435, 2463.1119, 2520.1334, 2617.1862, 2730.2702, 2893.3336, 2950.3550, 3113.4184, 3227.4613, 3342.4882, 3505.5516, 3576.5887, 3691.6156, 3854.6789, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 453.2092, 524.2463, 687.3097, 802.3366, 916.3795, 1079.4429, 1136.4643, 1299.5277, 1412.6117, 1509.6645, 1566.6859, 1713.7544, 1784.7915, 1871.8235, 1972.8712, 2073.9189, 2202.9615, 2317.9884, 2447.0310, 2576.0736, 2691.1005, 2804.1846, 2917.2687, 3046.3112, 3175.3538, 3335.3845, 3448.4686, 3545.5213, 3673.5799, 3802.6225, 3915.7066, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PFIHQQQGPYTQDWQSCGSQQSSAIDCCCGCTEK", {98.0600, 245.1285, 358.2125, 495.2714, 623.3300, 751.3886, 879.4472, 936.4686, 1033.5214, 1196.5847, 1297.6324, 1425.6910, 1540.7179, 1726.7972, 1854.8558, 1941.8878, 2101.9185, 2158.9399, 2245.9720, 2374.0306, 2502.0891, 2589.1212, 2676.1532, 2747.1903, 2860.2744, 2975.3013, 3135.3320, 3295.3626, 3455.3933, 3512.4147, 3672.4454, 3773.4930, 3902.5356, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 276.1554, 377.2031, 537.2337, 594.2552, 754.2858, 914.3165, 1074.3471, 1189.3741, 1302.4581, 1373.4953, 1460.5273, 1547.5593, 1675.6179, 1803.6765, 1890.7085, 1947.7300, 2107.7606, 2194.7926, 2322.8512, 2508.9305, 2623.9575, 2752.0160, 2853.0637, 3016.1271, 3113.1798, 3170.2013, 3298.2599, 3426.3184, 3554.3770, 3691.4359, 3804.5200, 3951.5884, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"IMPIVFFICFSVEFVPIENVIKPSMSCFASEEIR", {114.0913, 245.1318, 342.1846, 455.2687, 554.3371, 701.4055, 848.4739, 961.5580, 1121.5886, 1268.6570, 1355.6890, 1454.7575, 1583.8001, 1730.8685, 1829.9369, 1926.9896, 2040.0737, 2169.1163, 2283.1592, 2382.2276, 2495.3117, 2623.4067, 2720.4594, 2807.4915, 2938.5320, 3025.5640, 3185.5946, 3332.6630, 3403.7002, 3490.7322, 3619.7748, 3748.8174, 3861.9014, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 417.2456, 546.2882, 633.3202, 704.3573, 851.4258, 1011.4564, 1098.4884, 1229.5289, 1316.5609, 1413.6137, 1541.7087, 1654.7927, 1753.8612, 1867.9041, 1996.9467, 2110.0307, 2207.0835, 2306.1519, 2453.2203, 2582.2629, 2681.3313, 2768.3634, 2915.4318, 3075.4624, 3188.5465, 3335.6149, 3482.6833, 3581.7517, 3694.8358, 3791.8886, 3922.9290, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DSFTILQGIVSYCEECLMSGLEPEELTMEVDFCK", {116.0342, 203.0662, 350.1347, 451.1823, 564.2664, 677.3505, 805.4090, 862.4305, 975.5146, 1074.5830, 1161.6150, 1324.6783, 1484.7090, 1613.7516, 1742.7942, 1902.8248, 2015.9089, 2146.9494, 2233.9814, 2291.0029, 2404.0869, 2533.1295, 2630.1823, 2759.2249, 2888.2675, 3001.3515, 3102.3992, 3233.4397, 3362.4823, 3461.5507, 3576.5777, 3723.6461, 3883.6767, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 307.1435, 454.2119, 569.2388, 668.3072, 797.3498, 928.3903, 1029.4380, 1142.5220, 1271.5646, 1400.6072, 1497.6600, 1626.7026, 1739.7867, 1796.8081, 1883.8401, 2014.8806, 2127.9647, 2287.9953, 2417.0379, 2546.0805, 2706.1112, 2869.1745, 2956.2065, 3055.2749, 3168.3590, 3225.3805, 3353.4391, 3466.5231, 3579.6072, 3680.6549, 3827.7233, 3914.7553, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QVLYEQNSFTDLFPLLMPLMPACTQVFQQNEATK", {129.0659, 228.1343, 341.2183, 504.2817, 633.3243, 761.3828, 875.4258, 962.4578, 1109.5262, 1210.5739, 1325.6008, 1438.6849, 1585.7533, 1682.8061, 1795.8901, 1908.9742, 2040.0147, 2137.0674, 2250.1515, 2381.1920, 2478.2448, 2549.2819, 2709.3125, 2810.3602, 2938.4188, 3037.4872, 3184.5556, 3312.6142, 3440.6728, 3554.7157, 3683.7583, 3754.7954, 3855.8431, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 248.1605, 319.1976, 448.2402, 562.2831, 690.3417, 818.4003, 965.4687, 1064.5371, 1192.5957, 1293.6434, 1453.6740, 1524.7111, 1621.7639, 1752.8044, 1865.8884, 1962.9412, 2093.9817, 2207.0657, 2320.1498, 2417.2026, 2564.2710, 2677.3550, 2792.3820, 2893.4297, 3040.4981, 3127.5301, 3241.5730, 3369.6316, 3498.6742, 3661.7375, 3774.8216, 3873.8900, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MSQSGWCSDEFSSHWNIIPIDDEIDSDPEYSRPK", {132.0478, 219.0798, 347.1384, 434.1704, 491.1919, 677.2712, 837.3018, 924.3338, 1039.3608, 1168.4034, 1315.4718, 1402.5038, 1489.5359, 1626.5948, 1812.6741, 1926.7170, 2039.8011, 2152.8851, 2249.9379, 2363.0220, 2478.0489, 2593.0759, 2722.1184, 2835.2025, 2950.2295, 3037.2615, 3152.2884, 3249.3412, 3378.3838, 3541.4471, 3628.4791, 3784.5802, 3881.6330, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 244.1656, 400.2667, 487.2987, 650.3620, 779.4046, 876.4574, 991.4843, 1078.5164, 1193.5433, 1306.6274, 1435.6700, 1550.6969, 1665.7239, 1778.8079, 1875.8607, 1988.9447, 2102.0288, 2216.0717, 2402.1510, 2539.2100, 2626.2420, 2713.2740, 2860.3424, 2989.3850, 3104.4120, 3191.4440, 3351.4746, 3537.5540, 3594.5754, 3681.6074, 3809.6660, 3896.6981, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FLLPLCESVFQASYDDPCVQLFDQLLQDIVADLR", {148.0757, 261.1598, 374.2438, 471.2966, 584.3806, 744.4113, 873.4539, 960.4859, 1059.5543, 1206.6227, 1334.6813, 1405.7184, 1492.7505, 1655.8138, 1770.8407, 1885.8677, 1982.9204, 2142.9511, 2242.0195, 2370.0781, 2483.1621, 2630.2306, 2745.2575, 2873.3161, 2986.4001, 3099.4842, 3227.5428, 3342.5697, 3455.6538, 3554.7222, 3625.7593, 3740.7863, 3853.8703, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 403.2300, 474.2671, 573.3355, 686.4196, 801.4465, 929.5051, 1042.5891, 1155.6732, 1283.7318, 1398.7587, 1545.8271, 1658.9112, 1786.9698, 1886.0382, 2046.0688, 2143.1216, 2258.1485, 2373.1755, 2536.2388, 2623.2708, 2694.3080, 2822.3665, 2969.4350, 3068.5034, 3155.5354, 3284.5780, 3444.6086, 3557.6927, 3654.7455, 3767.8295, 3880.9136, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TCIALTLTYDFQHIVMNLYVTEEWDVDPDGIPLK", {102.0550, 262.0856, 375.1697, 446.2068, 559.2908, 660.3385, 773.4226, 874.4703, 1037.5336, 1152.5605, 1299.6290, 1427.6875, 1564.7464, 1677.8305, 1776.8989, 1907.9394, 2021.9823, 2135.0664, 2298.1297, 2397.1981, 2498.2458, 2627.2884, 2756.3310, 2942.4103, 3057.4373, 3156.5057, 3271.5326, 3368.5854, 3483.6123, 3540.6338, 3653.7179, 3750.7706, 3863.8547, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 357.2496, 470.3337, 527.3552, 642.3821, 739.4349, 854.4618, 953.5302, 1068.5572, 1254.6365, 1383.6791, 1512.7217, 1613.7693, 1712.8378, 1875.9011, 1988.9852, 2103.0281, 2234.0686, 2333.1370, 2446.2210, 2583.2800, 2711.3385, 2858.4069, 2973.4339, 3136.4972, 3237.5449, 3350.6290, 3451.6766, 3564.7607, 3635.7978, 3748.8819, 3908.9125, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"AGIVDSFHTLWIAFPYDKPHTENSWIGEFVFSYK", {72.0444, 129.0659, 242.1499, 341.2183, 456.2453, 543.2773, 690.3457, 827.4046, 928.4523, 1041.5364, 1227.6157, 1340.6997, 1411.7369, 1558.8053, 1655.8580, 1818.9214, 1933.9483, 2062.0433, 2159.0960, 2296.1550, 2397.2026, 2526.2452, 2640.2882, 2727.3202, 2913.3995, 3026.4836, 3083.5050, 3212.5476, 3359.6160, 3458.6844, 3605.7529, 3692.7849, 3855.8482, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 310.1761, 397.2082, 544.2766, 643.3450, 790.4134, 919.4560, 976.4775, 1089.5615, 1275.6408, 1362.6729, 1476.7158, 1605.7584, 1706.8061, 1843.8650, 1940.9177, 2069.0127, 2184.0396, 2347.1030, 2444.1557, 2591.2242, 2662.2613, 2775.3453, 2961.4246, 3074.5087, 3175.5564, 3312.6153, 3459.6837, 3546.7157, 3661.7427, 3760.8111, 3873.8952, 3930.9166, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VDSQILQAYLEMNSLDDITLLTQMVSCVNYFELR", {100.0757, 215.1026, 302.1347, 430.1932, 543.2773, 656.3614, 784.4199, 855.4571, 1018.5204, 1131.6045, 1260.6470, 1391.6875, 1505.7305, 1592.7625, 1705.8465, 1820.8735, 1935.9004, 2048.9845, 2150.0322, 2263.1162, 2376.2003, 2477.2480, 2605.3066, 2736.3470, 2835.4155, 2922.4475, 3082.4781, 3181.5466, 3295.5895, 3458.6528, 3605.7212, 3734.7638, 3847.8479, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 417.2456, 564.3140, 727.3774, 841.4203, 940.4887, 1100.5193, 1187.5514, 1286.6198, 1417.6603, 1545.7188, 1646.7665, 1759.8506, 1872.9347, 1973.9823, 2087.0664, 2202.0933, 2317.1203, 2430.2043, 2517.2364, 2631.2793, 2762.3198, 2891.3624, 3004.4464, 3167.5098, 3238.5469, 3366.6055, 3479.6895, 3592.7736, 3720.8322, 3807.8642, 3922.8911, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ASLCNHVVFVVPKPCCEMDLEIEGDEGFDLYLMR", {72.0444, 159.0764, 272.1605, 432.1911, 546.2341, 683.2930, 782.3614, 881.4298, 1028.4982, 1127.5666, 1226.6350, 1323.6878, 1451.7828, 1548.8355, 1708.8662, 1868.8968, 1997.9394, 2128.9799, 2244.0068, 2357.0909, 2486.1335, 2599.2176, 2728.2602, 2785.2816, 2900.3086, 3029.3512, 3086.3726, 3233.4410, 3348.4680, 3461.5520, 3624.6154, 3737.6994, 3868.7399, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 306.1594, 419.2435, 582.3068, 695.3909, 810.4178, 957.4863, 1014.5077, 1143.5503, 1258.5773, 1315.5987, 1444.6413, 1557.7254, 1686.7680, 1799.8520, 1914.8790, 2045.9195, 2174.9620, 2334.9927, 2495.0233, 2592.0761, 2720.1711, 2817.2238, 2916.2923, 3015.3607, 3162.4291, 3261.4975, 3360.5659, 3497.6248, 3611.6677, 3771.6984, 3884.7825, 3971.8145, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QQNMDDVQDQTFNQPFGTDLDFMLPDGEMEEDEK", {129.0659, 257.1244, 371.1674, 502.2078, 617.2348, 732.2617, 831.3301, 959.3887, 1074.4157, 1202.4742, 1303.5219, 1450.5903, 1564.6333, 1692.6918, 1789.7446, 1936.8130, 1993.8345, 2094.8822, 2209.9091, 2322.9932, 2438.0201, 2585.0885, 2716.1290, 2829.2131, 2926.2658, 3041.2928, 3098.3142, 3227.3568, 3358.3973, 3487.4399, 3616.4825, 3731.5094, 3860.5520, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 276.1554, 391.1823, 520.2249, 649.2675, 780.3080, 909.3506, 966.3721, 1081.3990, 1178.4518, 1291.5358, 1422.5763, 1569.6447, 1684.6717, 1797.7557, 1912.7827, 2013.8304, 2070.8518, 2217.9202, 2314.9730, 2443.0316, 2557.0745, 2704.1429, 2805.1906, 2933.2492, 3048.2761, 3176.3347, 3275.4031, 3390.4301, 3505.4570, 3636.4975, 3750.5404, 3878.5990, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"HLGSPCFQQQLEGAFFCHYYANCNNSDAFFEGSK", {138.0662, 251.1503, 308.1717, 395.2037, 492.2565, 652.2872, 799.3556, 927.4141, 1055.4727, 1183.5313, 1296.6154, 1425.6580, 1482.6794, 1553.7165, 1700.7850, 1847.8534, 2007.8840, 2144.9429, 2308.0063, 2471.0696, 2542.1067, 2656.1496, 2816.1803, 2930.2232, 3044.2661, 3131.2982, 3246.3251, 3317.3622, 3464.4306, 3611.4990, 3740.5416, 3797.5631, 3884.5951, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 234.1448, 291.1663, 420.2089, 567.2773, 714.3457, 785.3828, 900.4098, 987.4418, 1101.4847, 1215.5277, 1375.5583, 1489.6012, 1560.6383, 1723.7017, 1886.7650, 2023.8239, 2183.8546, 2330.9230, 2477.9914, 2549.0285, 2606.0500, 2735.0926, 2848.1766, 2976.2352, 3104.2938, 3232.3524, 3379.4208, 3539.4514, 3636.5042, 3723.5362, 3780.5577, 3893.6417, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TSWHLVTNNDNDCINPDADQNLLFSIFLFINILK", {102.0550, 189.0870, 375.1663, 512.2252, 625.3093, 724.3777, 825.4254, 939.4683, 1053.5112, 1168.5382, 1282.5811, 1397.6080, 1557.6387, 1670.7227, 1784.7657, 1881.8184, 1996.8454, 2067.8825, 2182.9094, 2310.9680, 2425.0109, 2538.0950, 2651.1791, 2798.2475, 2885.2795, 2998.3636, 3145.4320, 3258.5161, 3405.5845, 3518.6685, 3632.7115, 3745.7955, 3858.8796, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 373.2809, 487.3239, 600.4079, 747.4763, 860.5604, 1007.6288, 1120.7129, 1207.7449, 1354.8133, 1467.8974, 1580.9815, 1695.0244, 1823.0830, 1938.1099, 2009.1470, 2124.1740, 2221.2267, 2335.2696, 2448.3537, 2608.3844, 2723.4113, 2837.4542, 2952.4812, 3066.5241, 3180.5670, 3281.6147, 3380.6831, 3493.7672, 3630.8261, 3816.9054, 3903.9374, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"WMDRPYGLVDTISPTTYLVIGDHMSIVCCFSDEK", {187.0866, 318.1271, 433.1540, 589.2551, 686.3079, 849.3712, 906.3927, 1019.4767, 1118.5452, 1233.5721, 1334.6198, 1447.7038, 1534.7359, 1631.7886, 1732.8363, 1833.8840, 1996.9473, 2110.0314, 2209.0998, 2322.1839, 2379.2053, 2494.2323, 2631.2912, 2762.3317, 2849.3637, 2962.4478, 3061.5162, 3221.5468, 3381.5775, 3528.6459, 3615.6779, 3730.7049, 3859.7475, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 276.1554, 391.1823, 478.2144, 625.2828, 785.3134, 945.3441, 1044.4125, 1157.4966, 1244.5286, 1375.5691, 1512.6280, 1627.6549, 1684.6764, 1797.7605, 1896.8289, 2009.9129, 2172.9763, 2274.0239, 2375.0716, 2472.1244, 2559.1564, 2672.2405, 2773.2882, 2888.3151, 2987.3835, 3100.4676, 3157.4890, 3320.5524, 3417.6051, 3573.7062, 3688.7332, 3819.7737, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LALENILTESLEQILVEMEMYLENLQTTTLYQLK", {114.0913, 185.1285, 298.2125, 427.2551, 541.2980, 654.3821, 767.4662, 868.5138, 997.5564, 1084.5885, 1197.6725, 1326.7151, 1454.7737, 1567.8578, 1680.9418, 1780.0102, 1909.0528, 2040.0933, 2169.1359, 2300.1764, 2463.2397, 2576.3238, 2705.3664, 2819.4093, 2932.4934, 3060.5520, 3161.5996, 3262.6473, 3363.6950, 3476.7791, 3639.8424, 3767.9010, 3880.9850, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 388.2554, 551.3188, 664.4028, 765.4505, 866.4982, 967.5459, 1095.6045, 1208.6885, 1322.7314, 1451.7740, 1564.8581, 1727.9214, 1858.9619, 1988.0045, 2119.0450, 2248.0876, 2347.1560, 2460.2401, 2573.3241, 2701.3827, 2830.4253, 2943.5094, 3030.5414, 3159.5840, 3260.6317, 3373.7157, 3486.7998, 3600.8427, 3729.8853, 3842.9694, 3914.0065, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TTAYFNDTISMDCNSCNSYSDNSDQDFSLIYDEK", {102.0550, 203.1026, 274.1397, 437.2031, 584.2715, 698.3144, 813.3414, 914.3890, 1027.4731, 1114.5051, 1245.5456, 1360.5726, 1520.6032, 1634.6461, 1721.6782, 1881.7088, 1995.7517, 2082.7838, 2245.8471, 2332.8791, 2447.9061, 2561.9490, 2648.9810, 2764.0080, 2892.0665, 3007.0935, 3154.1619, 3241.1939, 3354.2780, 3467.3621, 3630.4254, 3745.4523, 3874.4949, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 276.1554, 391.1823, 554.2457, 667.3297, 780.4138, 867.4458, 1014.5142, 1129.5412, 1257.5998, 1372.6267, 1459.6587, 1573.7017, 1688.7286, 1775.7606, 1938.8240, 2025.8560, 2139.8989, 2299.9296, 2386.9616, 2501.0045, 2661.0352, 2776.0621, 2907.1026, 2994.1346, 3107.2187, 3208.2664, 3323.2933, 3437.3362, 3584.4047, 3747.4680, 3818.5051, 3919.5528, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EYEANLNLNNYDYCLLEEHELLVNSNNSVTSPTR", {130.0499, 293.1132, 422.1558, 493.1929, 607.2358, 720.3199, 834.3628, 947.4469, 1061.4898, 1175.5327, 1338.5961, 1453.6230, 1616.6863, 1776.7170, 1889.8011, 2002.8851, 2131.9277, 2260.9703, 2398.0292, 2527.0718, 2640.1559, 2753.2399, 2852.3084, 2966.3513, 3053.3833, 3167.4262, 3281.4692, 3368.5012, 3467.5696, 3568.6173, 3655.6493, 3752.7021, 3853.7498, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 276.1666, 373.2194, 460.2514, 561.2991, 660.3675, 747.3995, 861.4425, 975.4854, 1062.5174, 1176.5604, 1275.6288, 1388.7128, 1501.7969, 1630.8395, 1767.8984, 1896.9410, 2025.9836, 2139.0677, 2252.1517, 2412.1824, 2575.2457, 2690.2726, 2853.3360, 2967.3789, 3081.4218, 3194.5059, 3308.5488, 3421.6329, 3535.6758, 3606.7129, 3735.7555, 3898.8188, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FLWVSLVDNAHAHLHVAVCFEVSADHNYHICSTR", {148.0757, 261.1598, 447.2391, 546.3075, 633.3395, 746.4236, 845.4920, 960.5189, 1074.5619, 1145.5990, 1282.6579, 1353.6950, 1490.7539, 1603.8380, 1740.8969, 1839.9653, 1911.0024, 2010.0708, 2170.1015, 2317.1699, 2446.2125, 2545.2809, 2632.3129, 2703.3500, 2818.3770, 2955.4359, 3069.4788, 3232.5422, 3369.6011, 3482.6851, 3642.7158, 3729.7478, 3830.7955, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 276.1666, 363.1987, 523.2293, 636.3134, 773.3723, 936.4356, 1050.4785, 1187.5375, 1302.5644, 1373.6015, 1460.6335, 1559.7020, 1688.7445, 1835.8130, 1995.8436, 2094.9120, 2165.9491, 2265.0175, 2402.0765, 2515.1605, 2652.2194, 2723.2565, 2860.3155, 2931.3526, 3045.3955, 3160.4224, 3259.4909, 3372.5749, 3459.6070, 3558.6754, 3744.7547, 3857.8387, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DYVSGAVEGPCIHCLIESYSYFNTQCMVCTINSK", {116.0342, 279.0975, 378.1660, 465.1980, 522.2195, 593.2566, 692.3250, 821.3676, 878.3890, 975.4418, 1135.4725, 1248.5565, 1385.6154, 1545.6461, 1658.7301, 1771.8142, 1900.8568, 1987.8888, 2150.9522, 2237.9842, 2401.0475, 2548.1159, 2662.1589, 2763.2065, 2891.2651, 3051.2958, 3182.3362, 3281.4047, 3441.4353, 3542.4830, 3655.5670, 3769.6100, 3856.6420, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 234.1448, 348.1878, 461.2718, 562.3195, 722.3502, 821.4186, 952.4590, 1112.4897, 1240.5483, 1341.5960, 1455.6389, 1602.7073, 1765.7706, 1852.8027, 2015.8660, 2102.8980, 2231.9406, 2345.0247, 2458.1087, 2618.1394, 2755.1983, 2868.2824, 3028.3130, 3125.3658, 3182.3872, 3311.4298, 3410.4982, 3481.5354, 3538.5568, 3625.5888, 3724.6573, 3887.7206, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"IYLAIIATALYLPIYLACAIINQLLCFTLYFAYK", {114.0913, 277.1547, 390.2387, 461.2758, 574.3599, 687.4440, 758.4811, 859.5288, 930.5659, 1043.6499, 1206.7133, 1319.7973, 1416.8501, 1529.9342, 1692.9975, 1806.0816, 1877.1187, 2037.1493, 2108.1864, 2221.2705, 2334.3546, 2448.3975, 2576.4561, 2689.5401, 2802.6242, 2962.6548, 3109.7233, 3210.7709, 3323.8550, 3486.9183, 3633.9867, 3705.0239, 3868.0872, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 310.1761, 381.2132, 528.2817, 691.3450, 804.4291, 905.4767, 1052.5451, 1212.5758, 1325.6599, 1438.7439, 1566.8025, 1680.8454, 1793.9295, 1907.0136, 1978.0507, 2138.0813, 2209.1184, 2322.2025, 2485.2658, 2598.3499, 2695.4027, 2808.4867, 2971.5500, 3084.6341, 3155.6712, 3256.7189, 3327.7560, 3440.8401, 3553.9241, 3624.9613, 3738.0453, 3901.1086, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TVWPNSPLAPQLFFDYESFTESYCVLSECAQSMK", {102.0550, 201.1234, 387.2027, 484.2554, 598.2984, 685.3304, 782.3832, 895.4672, 966.5043, 1063.5571, 1191.6157, 1304.6997, 1451.7682, 1598.8366, 1713.8635, 1876.9268, 2005.9694, 2093.0015, 2240.0699, 2341.1176, 2470.1602, 2557.1922, 2720.2555, 2880.2862, 2979.3546, 3092.4386, 3179.4707, 3308.5133, 3468.5439, 3539.5810, 3667.6396, 3754.6716, 3885.7121, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 278.1533, 365.1853, 493.2439, 564.2810, 724.3117, 853.3543, 940.3863, 1053.4703, 1152.5388, 1312.5694, 1475.6327, 1562.6648, 1691.7074, 1792.7550, 1939.8234, 2026.8555, 2155.8981, 2318.9614, 2433.9883, 2581.0568, 2728.1252, 2841.2092, 2969.2678, 3066.3206, 3137.3577, 3250.4418, 3347.4945, 3434.5265, 3548.5695, 3645.6222, 3831.7015, 3930.7700, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FIWWFQMWGSADRPYAYISGPVVDAVDDEDNLHK", {148.0757, 261.1598, 447.2391, 633.3184, 780.3868, 908.4454, 1039.4859, 1225.5652, 1282.5866, 1369.6187, 1440.6558, 1555.6827, 1711.7838, 1808.8366, 1971.8999, 2042.9370, 2206.0004, 2319.0844, 2406.1165, 2463.1379, 2560.1907, 2659.2591, 2758.3275, 2873.3545, 2944.3916, 3043.4600, 3158.4869, 3273.5139, 3402.5565, 3517.5834, 3631.6263, 3744.7104, 3881.7693, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 284.1717, 397.2558, 511.2987, 626.3257, 755.3682, 870.3952, 985.4221, 1084.4905, 1155.5277, 1270.5546, 1369.6230, 1468.6914, 1565.7442, 1622.7657, 1709.7977, 1822.8817, 1985.9451, 2056.9822, 2220.0455, 2317.0983, 2473.1994, 2588.2263, 2659.2635, 2746.2955, 2803.3169, 2989.3963, 3120.4367, 3248.4953, 3395.5637, 3581.6430, 3767.7224, 3880.8064, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SVWSPHFYLVASIPDDAEDTLCETDYVFVIMTER", {88.0393, 187.1077, 373.1870, 460.2191, 557.2718, 694.3307, 841.3991, 1004.4625, 1117.5465, 1216.6150, 1287.6521, 1374.6841, 1487.7682, 1584.8209, 1699.8479, 1814.8748, 1885.9119, 2014.9545, 2129.9815, 2231.0291, 2344.1132, 2504.1439, 2633.1864, 2734.2341, 2849.2611, 3012.3244, 3111.3928, 3258.4612, 3357.5296, 3470.6137, 3601.6542, 3702.7019, 3831.7445, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 405.2092, 536.2497, 649.3338, 748.4022, 895.4706, 994.5390, 1157.6023, 1272.6293, 1373.6770, 1502.7196, 1662.7502, 1775.8343, 1876.8819, 1991.9089, 2120.9515, 2191.9886, 2307.0155, 2422.0425, 2519.0952, 2632.1793, 2719.2113, 2790.2485, 2889.3169, 3002.4009, 3165.4643, 3312.5327, 3449.5916, 3546.6444, 3633.6764, 3819.7557, 3918.8241, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"GCLINDVFTFWALYVGYGYTLQAGEPYAYFLHEK", {58.0287, 218.0594, 331.1435, 444.2275, 558.2704, 673.2974, 772.3658, 919.4342, 1020.4819, 1167.5503, 1353.6296, 1424.6667, 1537.7508, 1700.8141, 1799.8825, 1856.9040, 2019.9673, 2076.9888, 2240.0521, 2341.0998, 2454.1839, 2582.2424, 2653.2796, 2710.3010, 2839.3436, 2936.3964, 3099.4597, 3170.4968, 3333.5602, 3480.6286, 3593.7126, 3730.7715, 3859.8141, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 276.1554, 413.2143, 526.2984, 673.3668, 836.4301, 907.4672, 1070.5306, 1167.5833, 1296.6259, 1353.6474, 1424.6845, 1552.7431, 1665.8271, 1766.8748, 1929.9381, 1986.9596, 2150.0229, 2207.0444, 2306.1128, 2469.1761, 2582.2602, 2653.2973, 2839.3766, 2986.4450, 3087.4927, 3234.5611, 3333.6296, 3448.6565, 3562.6994, 3675.7835, 3788.8675, 3948.8982, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LSLLDGGPMYEMVLYLNDNDQFAYQLNILWESNR", {114.0913, 201.1234, 314.2074, 427.2915, 542.3184, 599.3399, 656.3614, 753.4141, 884.4546, 1047.5179, 1176.5605, 1307.6010, 1406.6694, 1519.7535, 1682.8168, 1795.9009, 1909.9438, 2024.9708, 2139.0137, 2254.0406, 2382.0992, 2529.1676, 2600.2047, 2763.2681, 2891.3266, 3004.4107, 3118.4536, 3231.5377, 3344.6218, 3530.7011, 3659.7437, 3746.7757, 3860.8186, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 289.1619, 376.1939, 505.2365, 691.3158, 804.3999, 917.4839, 1031.5269, 1144.6109, 1272.6695, 1435.7328, 1506.7700, 1653.8384, 1781.8969, 1896.9239, 2010.9668, 2125.9938, 2240.0367, 2353.1208, 2516.1841, 2629.2681, 2728.3366, 2859.3770, 2988.4196, 3151.4830, 3282.5234, 3379.5762, 3436.5977, 3493.6191, 3608.6461, 3721.7301, 3834.8142, 3921.8462, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"CAAFSLPYEGWYVYGDYNTMPCLAVYEHDPSDTR", {161.0379, 232.0750, 303.1122, 450.1806, 537.2126, 650.2967, 747.3494, 910.4128, 1039.4553, 1096.4768, 1282.5561, 1445.6194, 1544.6879, 1707.7512, 1764.7727, 1879.7996, 2042.8629, 2156.9059, 2257.9535, 2388.9940, 2486.0468, 2646.0774, 2759.1615, 2830.1986, 2929.2670, 3092.3304, 3221.3729, 3358.4319, 3473.4588, 3570.5116, 3657.5436, 3772.5705, 3873.6182, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 276.1666, 391.1936, 478.2256, 575.2784, 690.3053, 827.3642, 956.4068, 1119.4701, 1218.5386, 1289.5757, 1402.6597, 1562.6904, 1659.7431, 1790.7836, 1891.8313, 2005.8742, 2168.9376, 2283.9645, 2340.9860, 2504.0493, 2603.1177, 2766.1810, 2952.2604, 3009.2818, 3138.3244, 3301.3877, 3398.4405, 3511.5246, 3598.5566, 3745.6250, 3816.6621, 3887.6992, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QQHEPHLTMNYMFFNLTTATLDFGGFIITDVEER", {129.0659, 257.1244, 394.1833, 523.2259, 620.2787, 757.3376, 870.4217, 971.4694, 1102.5098, 1216.5528, 1379.6161, 1510.6566, 1657.7250, 1804.7934, 1918.8363, 2031.9204, 2132.9681, 2234.0158, 2305.0529, 2406.1005, 2519.1846, 2634.2116, 2781.2800, 2838.3014, 2895.3229, 3042.3913, 3155.4754, 3268.5594, 3369.6071, 3484.6341, 3583.7025, 3712.7451, 3841.7877, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 433.2041, 532.2726, 647.2995, 748.3472, 861.4312, 974.5153, 1121.5837, 1178.6052, 1235.6266, 1382.6951, 1497.7220, 1610.8061, 1711.8537, 1782.8909, 1883.9385, 1984.9862, 2098.0703, 2212.1132, 2359.1816, 2506.2500, 2637.2905, 2800.3538, 2914.3968, 3045.4373, 3146.4849, 3259.5690, 3396.6279, 3493.6807, 3622.7233, 3759.7822, 3887.8408, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LSALMWFANEEDCFLLFVSSVINMAQCYGVQPNR", {114.0913, 201.1234, 272.1605, 385.2445, 516.2850, 702.3643, 849.4328, 920.4699, 1034.5128, 1163.5554, 1292.5980, 1407.6249, 1567.6556, 1714.7240, 1827.8081, 1940.8921, 2087.9605, 2187.0289, 2274.0610, 2361.0930, 2460.1614, 2573.2455, 2687.2884, 2818.3289, 2889.3660, 3017.4246, 3177.4552, 3340.5186, 3397.5400, 3496.6084, 3624.6670, 3721.7198, 3835.7627, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 289.1619, 386.2146, 514.2732, 613.3416, 670.3631, 833.4264, 993.4571, 1121.5157, 1192.5528, 1323.5933, 1437.6362, 1550.7202, 1649.7887, 1736.8207, 1823.8527, 1922.9211, 2069.9895, 2183.0736, 2296.1577, 2443.2261, 2603.2567, 2718.2837, 2847.3263, 2976.3689, 3090.4118, 3161.4489, 3308.5173, 3494.5966, 3625.6371, 3738.7212, 3809.7583, 3896.7903, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"HHQQLHQSDHELQGTSTNLTEEQTSHLIHPHLIR", {138.0662, 275.1251, 403.1837, 531.2423, 644.3263, 781.3852, 909.4438, 996.4758, 1111.5028, 1248.5617, 1377.6043, 1490.6883, 1618.7469, 1675.7684, 1776.8161, 1863.8481, 1964.8958, 2078.9387, 2192.0228, 2293.0704, 2422.1130, 2551.1556, 2679.2142, 2780.2619, 2867.2939, 3004.3528, 3117.4369, 3230.5210, 3367.5799, 3464.6326, 3601.6915, 3714.7756, 3827.8597, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 401.2871, 538.3460, 635.3988, 772.4577, 885.5417, 998.6258, 1135.6847, 1222.7167, 1323.7644, 1451.8230, 1580.8656, 1709.9082, 1810.9559, 1924.0399, 2038.0828, 2139.1305, 2226.1626, 2327.2102, 2384.2317, 2512.2903, 2625.3743, 2754.4169, 2891.4758, 3006.5028, 3093.5348, 3221.5934, 3358.6523, 3471.7364, 3599.7949, 3727.8535, 3864.9124, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DYFDNPSFGADVEIDQPLWFSLDNTCQPYHSIPK", {116.0342, 279.0975, 426.1660, 541.1929, 655.2358, 752.2886, 839.3206, 986.3890, 1043.4105, 1114.4476, 1229.4746, 1328.5430, 1457.5856, 1570.6696, 1685.6966, 1813.7552, 1910.8079, 2023.8920, 2209.9713, 2357.0397, 2444.0717, 2557.1558, 2672.1827, 2786.2257, 2887.2733, 3047.3040, 3175.3626, 3272.4153, 3435.4787, 3572.5376, 3659.5696, 3772.6537, 3869.7064, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 244.1656, 357.2496, 444.2817, 581.3406, 744.4039, 841.4567, 969.5152, 1129.5459, 1230.5936, 1344.6365, 1459.6634, 1572.7475, 1659.7795, 1806.8479, 1992.9273, 2106.0113, 2203.0641, 2331.1227, 2446.1496, 2559.2337, 2688.2763, 2787.3447, 2902.3716, 2973.4087, 3030.4302, 3177.4986, 3264.5306, 3361.5834, 3475.6263, 3590.6533, 3737.7217, 3900.7850, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PSTDQHWCSESNCFMCANPSLPVNTSLDVMEWVK", {98.0600, 185.0921, 286.1397, 401.1667, 529.2253, 666.2842, 852.3635, 1012.3941, 1099.4262, 1228.4688, 1315.5008, 1429.5437, 1589.5744, 1736.6428, 1867.6833, 2027.7139, 2098.7510, 2212.7940, 2309.8467, 2396.8787, 2509.9628, 2607.0156, 2706.0840, 2820.1269, 2921.1746, 3008.2066, 3121.2907, 3236.3176, 3335.3860, 3466.4265, 3595.4691, 3781.5484, 3880.6168, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 246.1812, 432.2605, 561.3031, 692.3436, 791.4120, 906.4390, 1019.5230, 1106.5551, 1207.6027, 1321.6457, 1420.7141, 1517.7668, 1630.8509, 1717.8829, 1814.9357, 1928.9786, 2000.0157, 2160.0464, 2291.0869, 2438.1553, 2598.1859, 2712.2289, 2799.2609, 2928.3035, 3015.3355, 3175.3662, 3361.4455, 3498.5044, 3626.5630, 3741.5899, 3842.6376, 3929.6696, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LPTLESLAVDYLLNQYEELLFHPDSNWQDILAQR", {114.0913, 211.1441, 312.1918, 425.2758, 554.3184, 641.3505, 754.4345, 825.4716, 924.5401, 1039.5670, 1202.6303, 1315.7144, 1428.7985, 1542.8414, 1670.9000, 1833.9633, 1963.0059, 2092.0485, 2205.1325, 2318.2166, 2465.2850, 2602.3439, 2699.3967, 2814.4236, 2901.4557, 3015.4986, 3201.5779, 3329.6365, 3444.6634, 3557.7475, 3670.8316, 3741.8687, 3869.9272, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 374.2146, 487.2987, 600.3828, 715.4097, 843.4683, 1029.5476, 1143.5905, 1230.6226, 1345.6495, 1442.7023, 1579.7612, 1726.8296, 1839.9137, 1952.9977, 2082.0403, 2211.0829, 2374.1462, 2502.2048, 2616.2477, 2729.3318, 2842.4159, 3005.4792, 3120.5061, 3219.5746, 3290.6117, 3403.6957, 3490.7278, 3619.7704, 3732.8544, 3833.9021, 3930.9549, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QQLQRPEVQHSYQDQEQQPVTVVDVDVHEEAAER", {129.0659, 257.1244, 370.2085, 498.2671, 654.3682, 751.4209, 880.4635, 979.5320, 1107.5905, 1244.6494, 1331.6815, 1494.7448, 1622.8034, 1737.8303, 1865.8889, 1994.9315, 2122.9901, 2251.0486, 2348.1014, 2447.1698, 2548.2175, 2647.2859, 2746.3543, 2861.3813, 2960.4497, 3075.4766, 3174.5450, 3311.6040, 3440.6466, 3569.6891, 3640.7263, 3711.7634, 3840.8060, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 375.1987, 446.2358, 575.2784, 704.3210, 841.3799, 940.4483, 1055.4752, 1154.5436, 1269.5706, 1368.6390, 1467.7074, 1568.7551, 1667.8235, 1764.8763, 1892.9348, 2020.9934, 2150.0360, 2278.0946, 2393.1215, 2521.1801, 2684.2434, 2771.2755, 2908.3344, 3036.3930, 3135.4614, 3264.5040, 3361.5567, 3517.6578, 3645.7164, 3758.8005, 3886.8591, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QVQIEAEEEDDEEEDLDEEEDDEDDTDSSCDQLK", {129.0659, 228.1343, 356.1928, 469.2769, 598.3195, 669.3566, 798.3992, 927.4418, 1056.4844, 1171.5113, 1286.5383, 1415.5809, 1544.6235, 1673.6661, 1788.6930, 1901.7771, 2016.8040, 2145.8466, 2274.8892, 2403.9318, 2518.9587, 2633.9857, 2763.0283, 2878.0552, 2993.0822, 3094.1298, 3209.1568, 3296.1888, 3383.2208, 3543.2515, 3658.2784, 3786.3370, 3899.4211, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 388.2554, 503.2824, 663.3130, 750.3451, 837.3771, 952.4040, 1053.4517, 1168.4787, 1283.5056, 1412.5482, 1527.5751, 1642.6021, 1771.6447, 1900.6873, 2029.7299, 2144.7568, 2257.8409, 2372.8678, 2501.9104, 2630.9530, 2759.9956, 2875.0225, 2990.0495, 3119.0921, 3248.1347, 3377.1773, 3448.2144, 3577.2570, 3690.3410, 3818.3996, 3917.4680, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"AIWFEEAELDYVYINLTHNAVLALYDQGEMNFAR", {72.0444, 185.1285, 371.2078, 518.2762, 647.3188, 776.3614, 847.3985, 976.4411, 1089.5251, 1204.5521, 1367.6154, 1466.6838, 1629.7472, 1742.8312, 1856.8741, 1969.9582, 2071.0059, 2208.0648, 2322.1077, 2393.1448, 2492.2133, 2605.2973, 2676.3344, 2789.4185, 2952.4818, 3067.5088, 3195.5673, 3252.5888, 3381.6314, 3512.6719, 3626.7148, 3773.7832, 3844.8203, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 246.1561, 393.2245, 507.2674, 638.3079, 767.3505, 824.3719, 952.4305, 1067.4575, 1230.5208, 1343.6049, 1414.6420, 1527.7260, 1626.7945, 1697.8316, 1811.8745, 1948.9334, 2049.9811, 2163.0651, 2277.1081, 2390.1921, 2553.2555, 2652.3239, 2815.3872, 2930.4142, 3043.4982, 3172.5408, 3243.5779, 3372.6205, 3501.6631, 3648.7315, 3834.8108, 3947.8949, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QLFTVVAAMASEDYVMYSWFEHQTLSLLFEMDGR", {129.0659, 242.1499, 389.2183, 490.2660, 589.3344, 688.4028, 759.4400, 830.4771, 961.5176, 1032.5547, 1119.5867, 1248.6293, 1363.6562, 1526.7196, 1625.7880, 1756.8285, 1919.8918, 2006.9238, 2193.0031, 2340.0715, 2469.1141, 2606.1730, 2734.2316, 2835.2793, 2948.3634, 3035.3954, 3148.4795, 3261.5635, 3408.6319, 3537.6745, 3668.7150, 3783.7420, 3840.7634, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 232.1404, 347.1674, 478.2078, 607.2504, 754.3189, 867.4029, 980.4870, 1067.5190, 1180.6031, 1281.6507, 1409.7093, 1546.7682, 1675.8108, 1822.8792, 2008.9586, 2095.9906, 2259.0539, 2390.0944, 2489.1628, 2652.2261, 2767.2531, 2896.2957, 2983.3277, 3054.3648, 3185.4053, 3256.4424, 3327.4795, 3426.5479, 3525.6164, 3626.6640, 3773.7325, 3886.8165, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TFSLIFFSFVTAIVWESISSVVHFYWGGDSPYWK", {102.0550, 249.1234, 336.1554, 449.2395, 562.3235, 709.3919, 856.4604, 943.4924, 1090.5608, 1189.6292, 1290.6769, 1361.7140, 1474.7981, 1573.8665, 1759.9458, 1888.9884, 1976.0204, 2089.1045, 2176.1365, 2263.1685, 2362.2369, 2461.3054, 2598.3643, 2745.4327, 2908.4960, 3094.5753, 3151.5968, 3208.6183, 3323.6452, 3410.6772, 3507.7300, 3670.7933, 3856.8726, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 333.1921, 496.2554, 593.3082, 680.3402, 795.3672, 852.3886, 909.4101, 1095.4894, 1258.5528, 1405.6212, 1542.6801, 1641.7485, 1740.8169, 1827.8489, 1914.8810, 2027.9650, 2114.9971, 2244.0396, 2430.1190, 2529.1874, 2642.2714, 2713.3086, 2814.3562, 2913.4246, 3060.4931, 3147.5251, 3294.5935, 3441.6619, 3554.7460, 3667.8300, 3754.8621, 3901.9305, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FITTWVVYFSCVLSINLDFVYQLIGFLSPFILAK", {148.0757, 261.1598, 362.2074, 463.2551, 649.3344, 748.4028, 847.4713, 1010.5346, 1157.6030, 1244.6350, 1404.6657, 1503.7341, 1616.8181, 1703.8502, 1816.9342, 1930.9772, 2044.0612, 2159.0882, 2306.1566, 2405.2250, 2568.2883, 2696.3469, 2809.4310, 2922.5150, 2979.5365, 3126.6049, 3239.6890, 3326.7210, 3423.7738, 3570.8422, 3683.9263, 3797.0103, 3868.0474, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 218.1499, 331.2340, 444.3180, 591.3865, 688.4392, 775.4713, 888.5553, 1035.6237, 1092.6452, 1205.7293, 1318.8133, 1446.8719, 1609.9352, 1709.0036, 1856.0721, 1971.0990, 2084.1831, 2198.2260, 2311.3101, 2398.3421, 2511.4261, 2610.4946, 2770.5252, 2857.5572, 3004.6257, 3167.6890, 3266.7574, 3365.8258, 3551.9051, 3652.9528, 3754.0005, 3867.0845, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NTLLPLESYSHEAPPTNQYWEISSNLQIPYIVQR", {115.0502, 216.0979, 329.1819, 442.2660, 539.3188, 652.4028, 781.4454, 868.4775, 1031.5408, 1118.5728, 1255.6317, 1384.6743, 1455.7114, 1552.7642, 1649.8170, 1750.8646, 1864.9076, 1992.9661, 2156.0295, 2342.1088, 2471.1514, 2584.2354, 2671.2675, 2758.2995, 2872.3424, 2985.4265, 3113.4851, 3226.5691, 3323.6219, 3486.6852, 3599.7693, 3698.8377, 3826.8963, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 402.2459, 515.3300, 678.3933, 775.4461, 888.5302, 1016.5887, 1129.6728, 1243.7157, 1330.7478, 1417.7798, 1530.8639, 1659.9064, 1845.9858, 2009.0491, 2137.1077, 2251.1506, 2352.1983, 2449.2510, 2546.3038, 2617.3409, 2746.3835, 2883.4424, 2970.4744, 3133.5378, 3220.5698, 3349.6124, 3462.6965, 3559.7492, 3672.8333, 3785.9174, 3886.9650, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"IQHRPEDFPIVYFSTPEGPLHESLMLNNQSIYTK", {114.0913, 242.1499, 379.2088, 535.3099, 632.3627, 761.4053, 876.4322, 1023.5007, 1120.5534, 1233.6375, 1332.7059, 1495.7692, 1642.8376, 1729.8697, 1830.9173, 1927.9701, 2057.0127, 2114.0342, 2211.0869, 2324.1710, 2461.2299, 2590.2725, 2677.3045, 2790.3886, 2921.4291, 3034.5131, 3148.5561, 3262.5990, 3390.6576, 3477.6896, 3590.7737, 3753.8370, 3854.8847, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 248.1605, 411.2238, 524.3079, 611.3399, 739.3985, 853.4414, 967.4843, 1080.5684, 1211.6089, 1324.6929, 1411.7250, 1540.7676, 1677.8265, 1790.9105, 1887.9633, 1944.9848, 2074.0274, 2171.0801, 2272.1278, 2359.1598, 2506.2283, 2669.2916, 2768.3600, 2881.4441, 2978.4968, 3125.5652, 3240.5922, 3369.6348, 3466.6875, 3622.7886, 3759.8476, 3887.9061, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QNHDPFPIISACVGLIMAPHIECHTYTTCYAYDK", {129.0659, 243.1088, 380.1677, 495.1946, 592.2474, 739.3158, 836.3686, 949.4526, 1062.5367, 1149.5687, 1220.6058, 1380.6365, 1479.7049, 1536.7264, 1649.8104, 1762.8945, 1893.9350, 1964.9721, 2062.0249, 2199.0838, 2312.1678, 2441.2104, 2601.2411, 2738.3000, 2839.3477, 3002.4110, 3103.4587, 3204.5064, 3364.5370, 3527.6003, 3598.6374, 3761.7008, 3876.7277, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 262.1397, 425.2031, 496.2402, 659.3035, 819.3342, 920.3818, 1021.4295, 1184.4929, 1285.5405, 1422.5994, 1582.6301, 1711.6727, 1824.7567, 1961.8157, 2058.8684, 2129.9055, 2260.9460, 2374.0301, 2487.1142, 2544.1356, 2643.2040, 2803.2347, 2874.2718, 2961.3038, 3074.3879, 3187.4719, 3284.5247, 3431.5931, 3528.6459, 3643.6728, 3780.7317, 3894.7747, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YQPQNQQYPCPQGAIPQCQGQCQVHYNDVAAQIK", {164.0706, 292.1292, 389.1819, 517.2405, 631.2835, 759.3420, 887.4006, 1050.4639, 1147.5167, 1307.5473, 1404.6001, 1532.6587, 1589.6802, 1660.7173, 1773.8013, 1870.8541, 1998.9127, 2158.9433, 2287.0019, 2344.0234, 2472.0819, 2632.1126, 2760.1712, 2859.2396, 2996.2985, 3159.3618, 3273.4047, 3388.4317, 3487.5001, 3558.5372, 3629.5743, 3757.6329, 3870.7170, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 388.2554, 459.2926, 530.3297, 629.3981, 744.4250, 858.4680, 1021.5313, 1158.5902, 1257.6586, 1385.7172, 1545.7478, 1673.8064, 1730.8279, 1858.8865, 2018.9171, 2146.9757, 2244.0284, 2357.1125, 2428.1496, 2485.1711, 2613.2297, 2710.2824, 2870.3131, 2967.3658, 3130.4292, 3258.4877, 3386.5463, 3500.5893, 3628.6478, 3725.7006, 3853.7592, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"GHMYGFPSNIQTQLMIDLLPQQLDIDNHDLHLHR", {58.0287, 195.0877, 326.1281, 489.1915, 546.2129, 693.2813, 790.3341, 877.3661, 991.4091, 1104.4931, 1232.5517, 1333.5994, 1461.6580, 1574.7420, 1705.7825, 1818.8666, 1933.8935, 2046.9776, 2160.0616, 2257.1144, 2385.1730, 2513.2316, 2626.3156, 2741.3426, 2854.4266, 2969.4536, 3083.4965, 3220.5554, 3335.5824, 3448.6664, 3585.7253, 3698.8094, 3835.8683, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 312.1779, 425.2619, 562.3208, 675.4049, 790.4318, 927.4908, 1041.5337, 1156.5606, 1269.6447, 1384.6716, 1497.7557, 1625.8143, 1753.8729, 1850.9256, 1964.0097, 2077.0937, 2192.1207, 2305.2048, 2436.2452, 2549.3293, 2677.3879, 2778.4356, 2906.4941, 3019.5782, 3133.6211, 3220.6532, 3317.7059, 3464.7743, 3521.7958, 3684.8591, 3815.8996, 3952.9585, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"CESDIPCQQACSPAIQCLEGTYEPPCLCQFGIPK", {161.0379, 290.0805, 377.1125, 492.1395, 605.2236, 702.2763, 862.3070, 990.3655, 1118.4241, 1189.4612, 1349.4919, 1436.5239, 1533.5767, 1604.6138, 1717.6979, 1845.7564, 2005.7871, 2118.8711, 2247.9137, 2304.9352, 2405.9829, 2569.0462, 2698.0888, 2795.1416, 2892.1943, 3052.2250, 3165.3090, 3325.3397, 3453.3983, 3600.4667, 3657.4881, 3770.5722, 3867.6250, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 244.1656, 357.2496, 414.2711, 561.3395, 689.3981, 849.4287, 962.5128, 1122.5434, 1219.5962, 1316.6490, 1445.6916, 1608.7549, 1709.8026, 1766.8240, 1895.8666, 2008.9507, 2168.9813, 2297.0399, 2410.1240, 2481.1611, 2578.2139, 2665.2459, 2825.2765, 2896.3137, 3024.3722, 3152.4308, 3312.4615, 3409.5142, 3522.5983, 3637.6252, 3724.6573, 3853.6999, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"GIGCSYTYDFTSFQEHQPAMYPVVMFFMQMPMGK", {58.0287, 171.1128, 228.1343, 388.1649, 475.1969, 638.2603, 739.3080, 902.3713, 1017.3982, 1164.4666, 1265.5143, 1352.5463, 1499.6148, 1627.6733, 1756.7159, 1893.7748, 2021.8334, 2118.8862, 2189.9233, 2320.9638, 2484.0271, 2581.0799, 2680.1483, 2779.2167, 2910.2572, 3057.3256, 3204.3940, 3335.4345, 3463.4931, 3594.5336, 3691.5863, 3822.6268, 3879.6483, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 204.1343, 335.1748, 432.2275, 563.2680, 691.3266, 822.3671, 969.4355, 1116.5039, 1247.5444, 1346.6128, 1445.6812, 1542.7340, 1705.7973, 1836.8378, 1907.8749, 2004.9277, 2132.9862, 2270.0451, 2399.0877, 2527.1463, 2674.2147, 2761.2468, 2862.2944, 3009.3629, 3124.3898, 3287.4531, 3388.5008, 3551.5641, 3638.5962, 3798.6268, 3855.6483, 3968.7323, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YMHALMYWFQFFINDIADVNGQLMNGIIEISEPK", {164.0706, 295.1111, 432.1700, 503.2071, 616.2912, 747.3317, 910.3950, 1096.4743, 1243.5427, 1371.6013, 1518.6697, 1665.7381, 1778.8222, 1892.8651, 2007.8921, 2120.9761, 2192.0132, 2307.0402, 2406.1086, 2520.1515, 2577.1730, 2705.2316, 2818.3156, 2949.3561, 3063.3990, 3120.4205, 3233.5046, 3346.5886, 3475.6312, 3588.7153, 3675.7473, 3804.7899, 3901.8427, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 244.1656, 373.2082, 460.2402, 573.3243, 702.3668, 815.4509, 928.5350, 985.5564, 1099.5994, 1230.6399, 1343.7239, 1471.7825, 1528.8040, 1642.8469, 1741.9153, 1856.9422, 1927.9794, 2041.0634, 2156.0904, 2270.1333, 2383.2174, 2530.2858, 2677.3542, 2805.4128, 2952.4812, 3138.5605, 3301.6238, 3432.6643, 3545.7484, 3616.7855, 3753.8444, 3884.8849, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YGIGNYYILQPDYGMEIQHFWSFQPIEGLGHSLR", {164.0706, 221.0921, 334.1761, 391.1976, 505.2405, 668.3039, 831.3672, 944.4512, 1057.5353, 1185.5939, 1282.6467, 1397.6736, 1560.7369, 1617.7584, 1748.7989, 1877.8415, 1990.9255, 2118.9841, 2256.0430, 2403.1114, 2589.1907, 2676.2228, 2823.2912, 2951.3498, 3048.4025, 3161.4866, 3290.5292, 3347.5506, 3460.6347, 3517.6562, 3654.7151, 3741.7471, 3854.8312, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 375.2350, 512.2940, 569.3154, 682.3995, 739.4209, 868.4635, 981.5476, 1078.6004, 1206.6589, 1353.7274, 1440.7594, 1626.8387, 1773.9071, 1910.9660, 2039.0246, 2152.1087, 2281.1513, 2412.1917, 2469.2132, 2632.2765, 2747.3035, 2844.3562, 2972.4148, 3085.4989, 3198.5830, 3361.6463, 3524.7096, 3638.7525, 3695.7740, 3808.8581, 3865.8795, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"HSLATQQTNDLLCYHCLITLAELQSVVYDPPFHR", {138.0662, 225.0982, 338.1823, 409.2194, 510.2671, 638.3257, 766.3842, 867.4319, 981.4748, 1096.5018, 1209.5858, 1322.6699, 1482.7006, 1645.7639, 1782.8228, 1942.8534, 2055.9375, 2169.0216, 2270.0692, 2383.1533, 2454.1904, 2583.2330, 2696.3171, 2824.3757, 2911.4077, 3010.4761, 3109.5445, 3272.6078, 3387.6348, 3484.6876, 3581.7403, 3728.8087, 3865.8676, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 312.1779, 459.2463, 556.2990, 653.3518, 768.3787, 931.4421, 1030.5105, 1129.5789, 1216.6109, 1344.6695, 1457.7536, 1586.7962, 1657.8333, 1770.9173, 1871.9650, 1985.0491, 2098.1332, 2258.1638, 2395.2227, 2558.2860, 2718.3167, 2831.4008, 2944.4848, 3059.5118, 3173.5547, 3274.6024, 3402.6609, 3530.7195, 3631.7672, 3702.8043, 3815.8884, 3902.9204, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ITVPFYFAALATGFTIYQNTEIFQIYCEDKPVTR", {114.0913, 215.1390, 314.2074, 411.2602, 558.3286, 721.3919, 868.4604, 939.4975, 1010.5346, 1123.6186, 1194.6558, 1295.7034, 1352.7249, 1499.7933, 1600.8410, 1713.9251, 1876.9884, 2005.0470, 2119.0899, 2220.1376, 2349.1802, 2462.2642, 2609.3326, 2737.3912, 2850.4753, 3013.5386, 3173.5693, 3302.6119, 3417.6388, 3545.7338, 3642.7865, 3741.8549, 3842.9026, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 276.1666, 375.2350, 472.2878, 600.3828, 715.4097, 844.4523, 1004.4830, 1167.5463, 1280.6303, 1408.6889, 1555.7573, 1668.8414, 1797.8840, 1898.9317, 2012.9746, 2141.0332, 2304.0965, 2417.1806, 2518.2283, 2665.2967, 2722.3181, 2823.3658, 2894.4029, 3007.4870, 3078.5241, 3149.5612, 3296.6296, 3459.6930, 3606.7614, 3703.8141, 3802.8825, 3903.9302, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FNETDVSPCEDIIMIGHEDAFQMSEESYPYHSTR", {148.0757, 262.1186, 391.1612, 492.2089, 607.2358, 706.3042, 793.3363, 890.3890, 1050.4197, 1179.4623, 1294.4892, 1407.5733, 1520.6574, 1651.6978, 1764.7819, 1821.8034, 1958.8623, 2087.9049, 2202.9318, 2273.9689, 2421.0373, 2549.0959, 2680.1364, 2767.1684, 2896.2110, 3025.2536, 3112.2856, 3275.3490, 3372.4017, 3535.4651, 3672.5240, 3759.5560, 3860.6037, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 276.1666, 363.1987, 500.2576, 663.3209, 760.3737, 923.4370, 1010.4690, 1139.5116, 1268.5542, 1355.5862, 1486.6267, 1614.6853, 1761.7537, 1832.7908, 1947.8178, 2076.8604, 2213.9193, 2270.9407, 2384.0248, 2515.0653, 2628.1493, 2741.2334, 2856.2604, 2985.3029, 3145.3336, 3242.3864, 3329.4184, 3428.4868, 3543.5137, 3644.5614, 3773.6040, 3887.6469, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FLLYEMATAWNLPATDADDIFFNTFYTVHNHLNK", {148.0757, 261.1598, 374.2438, 537.3071, 666.3497, 797.3902, 868.4273, 969.4750, 1040.5121, 1226.5914, 1340.6344, 1453.7184, 1550.7712, 1621.8083, 1722.8560, 1837.8829, 1908.9200, 2023.9470, 2138.9739, 2252.0580, 2399.1264, 2546.1948, 2660.2378, 2761.2854, 2908.3538, 3071.4172, 3172.4649, 3271.5333, 3408.5922, 3522.6351, 3659.6940, 3772.7781, 3886.8210, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 261.1557, 374.2398, 511.2987, 625.3416, 762.4005, 861.4690, 962.5166, 1125.5800, 1272.6484, 1373.6961, 1487.7390, 1634.8074, 1781.8758, 1894.9599, 2009.9868, 2125.0138, 2196.0509, 2311.0778, 2412.1255, 2483.1626, 2580.2154, 2693.2994, 2807.3424, 2993.4217, 3064.4588, 3165.5065, 3236.5436, 3367.5841, 3496.6267, 3659.6900, 3772.7741, 3885.8581, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"GMHQEMNHPLDLPEVEARPCTSYISFDVPYITDR", {58.0287, 189.0692, 326.1281, 454.1867, 583.2293, 714.2698, 828.3127, 965.3716, 1062.4244, 1175.5085, 1290.5354, 1403.6195, 1500.6722, 1629.7148, 1728.7832, 1857.8258, 1928.8629, 2084.9641, 2182.0168, 2342.0475, 2443.0951, 2530.1272, 2693.1905, 2806.2746, 2893.3066, 3040.3750, 3155.4020, 3254.4704, 3351.5231, 3514.5865, 3627.6705, 3728.7182, 3843.7451, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 290.1459, 391.1936, 504.2776, 667.3410, 764.3937, 863.4621, 978.4891, 1125.5575, 1212.5895, 1325.6736, 1488.7369, 1575.7690, 1676.8166, 1836.8473, 1933.9000, 2090.0012, 2161.0383, 2290.0809, 2389.1493, 2518.1919, 2615.2446, 2728.3287, 2843.3556, 2956.4397, 3053.4925, 3190.5514, 3304.5943, 3435.6348, 3564.6774, 3692.7360, 3829.7949, 3960.8354, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NFMENSALSTVYIFLVLMGGLFILFLIYSYWFSK", {115.0502, 262.1186, 393.1591, 522.2017, 636.2446, 723.2767, 794.3138, 907.3978, 994.4299, 1095.4775, 1194.5460, 1357.6093, 1470.6933, 1617.7618, 1730.8458, 1829.9142, 1942.9983, 2074.0388, 2131.0602, 2188.0817, 2301.1658, 2448.2342, 2561.3183, 2674.4023, 2821.4707, 2934.5548, 3047.6389, 3210.7022, 3297.7342, 3460.7975, 3646.8769, 3793.9453, 3880.9773, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 234.1448, 381.2132, 567.2926, 730.3559, 817.3879, 980.4512, 1093.5353, 1206.6194, 1353.6878, 1466.7719, 1579.8559, 1726.9243, 1840.0084, 1897.0299, 1954.0513, 2085.0918, 2198.1759, 2297.2443, 2410.3283, 2557.3968, 2670.4808, 2833.5442, 2932.6126, 3033.6602, 3120.6923, 3233.7763, 3304.8135, 3391.8455, 3505.8884, 3634.9310, 3765.9715, 3913.0399, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QATVTNILNFVIAFVTFACYVGLALWWILQEYER", {129.0659, 200.1030, 301.1506, 400.2191, 501.2667, 615.3097, 728.3937, 841.4778, 955.5207, 1102.5891, 1201.6575, 1314.7416, 1385.7787, 1532.8471, 1631.9156, 1732.9632, 1880.0316, 1951.0688, 2111.0994, 2274.1627, 2373.2312, 2430.2526, 2543.3367, 2614.3738, 2727.4579, 2913.5372, 3099.6165, 3212.7005, 3325.7846, 3453.8432, 3582.8858, 3745.9491, 3874.9917, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 467.2249, 596.2675, 724.3260, 837.4101, 950.4942, 1136.5735, 1322.6528, 1435.7369, 1506.7740, 1619.8580, 1676.8795, 1775.9479, 1939.0112, 2099.0419, 2170.0790, 2317.1474, 2418.1951, 2517.2635, 2664.3319, 2735.3690, 2848.4531, 2947.5215, 3094.5899, 3208.6329, 3321.7169, 3434.8010, 3548.8439, 3649.8916, 3748.9600, 3850.0077, 3921.0448, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"GDTNGEEHELEVWFNLPEETQSYIAYILYPPTHK", {58.0287, 173.0557, 274.1034, 388.1463, 445.1678, 574.2103, 703.2529, 840.3119, 969.3544, 1082.4385, 1211.4811, 1310.5495, 1496.6288, 1643.6972, 1757.7402, 1870.8242, 1967.8770, 2096.9196, 2225.9622, 2327.0099, 2455.0684, 2542.1005, 2705.1638, 2818.2479, 2889.2850, 3052.3483, 3165.4324, 3278.5164, 3441.5798, 3538.6325, 3635.6853, 3736.7330, 3873.7919, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 284.1717, 385.2194, 482.2722, 579.3249, 742.3883, 855.4723, 968.5564, 1131.6197, 1202.6568, 1315.7409, 1478.8042, 1565.8362, 1693.8948, 1794.9425, 1923.9851, 2053.0277, 2150.0804, 2263.1645, 2377.2074, 2524.2759, 2710.3552, 2809.4236, 2938.4662, 3051.5502, 3180.5928, 3317.6517, 3446.6943, 3575.7369, 3632.7584, 3746.8013, 3847.8490, 3962.8759, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QVQVQQQQLPQQQQPIHIMQAQQLQQQQTQAPIR", {129.0659, 228.1343, 356.1928, 455.2613, 583.3198, 711.3784, 839.4370, 967.4956, 1080.5796, 1177.6324, 1305.6910, 1433.7496, 1561.8081, 1689.8667, 1786.9195, 1900.0035, 2037.0624, 2150.1465, 2281.1870, 2409.2456, 2480.2827, 2608.3413, 2736.3998, 2849.4839, 2977.5425, 3105.6011, 3233.6596, 3361.7182, 3462.7659, 3590.8245, 3661.8616, 3758.9144, 3871.9984, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 385.2558, 456.2929, 584.3515, 685.3991, 813.4577, 941.5163, 1069.5749, 1197.6335, 1310.7175, 1438.7761, 1566.8347, 1637.8718, 1765.9304, 1896.9709, 2010.0549, 2147.1138, 2260.1979, 2357.2507, 2485.3092, 2613.3678, 2741.4264, 2869.4850, 2966.5377, 3079.6218, 3207.6804, 3335.7390, 3463.7975, 3591.8561, 3690.9245, 3818.9831, 3918.0515, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"HEDDTHDVDVGEDECCDSVNILEESPNEELIEMK", {138.0662, 267.1088, 382.1357, 497.1627, 598.2103, 735.2693, 850.2962, 949.3646, 1064.3916, 1163.4600, 1220.4814, 1349.5240, 1464.5510, 1593.5936, 1753.6242, 1913.6549, 2028.6818, 2115.7138, 2214.7822, 2328.8252, 2441.9092, 2554.9933, 2684.0359, 2813.0785, 2900.1105, 2997.1633, 3111.2062, 3240.2488, 3369.2914, 3482.3755, 3595.4595, 3724.5021, 3855.5426, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 278.1533, 407.1959, 520.2799, 633.3640, 762.4066, 891.4492, 1005.4921, 1102.5449, 1189.5769, 1318.6195, 1447.6621, 1560.7462, 1673.8302, 1787.8732, 1886.9416, 1973.9736, 2089.0005, 2249.0312, 2409.0618, 2538.1044, 2653.1314, 2782.1740, 2839.1954, 2938.2638, 3053.2908, 3152.3592, 3267.3861, 3404.4451, 3505.4927, 3620.5197, 3735.5466, 3864.5892, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NVGEMSEFHVMSNFFQQNYAFTLLDYIPHMDGVK", {115.0502, 214.1186, 271.1401, 400.1827, 531.2232, 618.2552, 747.2978, 894.3662, 1031.4251, 1130.4935, 1261.5340, 1348.5660, 1462.6090, 1609.6774, 1756.7458, 1884.8044, 2012.8629, 2126.9059, 2289.9692, 2361.0063, 2508.0747, 2609.1224, 2722.2065, 2835.2905, 2950.3175, 3113.3808, 3226.4649, 3323.5176, 3460.5765, 3591.6170, 3706.6440, 3763.6654, 3862.7339, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 246.1812, 303.2027, 418.2296, 549.2701, 686.3290, 783.3818, 896.4658, 1059.5292, 1174.5561, 1287.6402, 1400.7242, 1501.7719, 1648.8403, 1719.8775, 1882.9408, 1996.9837, 2125.0423, 2253.1009, 2400.1693, 2547.2377, 2661.2806, 2748.3127, 2879.3531, 2978.4215, 3115.4805, 3262.5489, 3391.5915, 3478.6235, 3609.6640, 3738.7066, 3795.7280, 3894.7965, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ESYWPVHGEETASSISLTWISNTYGDCNCNDQER", {130.0499, 217.0819, 380.1452, 566.2245, 663.2773, 762.3457, 899.4046, 956.4261, 1085.4687, 1214.5113, 1315.5590, 1386.5961, 1473.6281, 1560.6601, 1673.7442, 1760.7762, 1873.8603, 1974.9080, 2160.9873, 2274.0713, 2361.1034, 2475.1463, 2576.1940, 2739.2573, 2796.2788, 2911.3057, 3071.3364, 3185.3793, 3345.4099, 3459.4529, 3574.4798, 3702.5384, 3831.5810, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 432.2201, 547.2471, 661.2900, 821.3206, 935.3636, 1095.3942, 1210.4212, 1267.4426, 1430.5060, 1531.5536, 1645.5966, 1732.6286, 1845.7127, 2031.7920, 2132.8396, 2245.9237, 2332.9557, 2446.0398, 2533.0718, 2620.1039, 2691.1410, 2792.1886, 2921.2312, 3050.2738, 3107.2953, 3244.3542, 3343.4226, 3440.4754, 3626.5547, 3789.6180, 3876.6501, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YIAVTIYLTFLSILVWVNEQLAEHMYQDAPSQNR", {164.0706, 277.1547, 348.1918, 447.2602, 548.3079, 661.3919, 824.4553, 937.5393, 1038.5870, 1185.6554, 1298.7395, 1385.7715, 1498.8556, 1611.9396, 1711.0081, 1897.0874, 1996.1558, 2110.1987, 2239.2413, 2367.2999, 2480.3839, 2551.4211, 2680.4637, 2817.5226, 2948.5631, 3111.6264, 3239.6850, 3354.7119, 3425.7490, 3522.8018, 3609.8338, 3737.8924, 3851.9353, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 289.1619, 417.2205, 504.2525, 601.3052, 672.3424, 787.3693, 915.4279, 1078.4912, 1209.5317, 1346.5906, 1475.6332, 1546.6703, 1659.7544, 1787.8130, 1916.8556, 2030.8985, 2129.9669, 2316.0462, 2415.1146, 2528.1987, 2641.2827, 2728.3148, 2841.3988, 2988.4673, 3089.5149, 3202.5990, 3365.6623, 3478.7464, 3579.7941, 3678.8625, 3749.8996, 3862.9837, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QPNSADDYQYLFNTTWCDGHSLTLLEQEGVEFTR", {129.0659, 226.1186, 340.1615, 427.1936, 498.2307, 613.2576, 728.2846, 891.3479, 1019.4065, 1182.4698, 1295.5539, 1442.6223, 1556.6652, 1657.7129, 1758.7606, 1944.8399, 2104.8705, 2219.8975, 2276.9189, 2413.9779, 2501.0099, 2614.0939, 2715.1416, 2828.2257, 2941.3098, 3070.3523, 3198.4109, 3327.4535, 3384.4750, 3483.5434, 3612.5860, 3759.6544, 3860.7021, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 276.1666, 423.2350, 552.2776, 651.3461, 708.3675, 837.4101, 965.4687, 1094.5113, 1207.5953, 1320.6794, 1421.7271, 1534.8111, 1621.8432, 1758.9021, 1815.9236, 1930.9505, 2090.9811, 2277.0605, 2378.1081, 2479.1558, 2593.1987, 2740.2672, 2853.3512, 3016.4145, 3144.4731, 3307.5365, 3422.5634, 3537.5903, 3608.6275, 3695.6595, 3809.7024, 3906.7552, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FEYPIHGSIPDIAVPWMEDMEEQTFPEGEEMMLK", {148.0757, 277.1183, 440.1816, 537.2344, 650.3184, 787.3774, 844.3988, 931.4308, 1044.5149, 1141.5677, 1256.5946, 1369.6787, 1440.7158, 1539.7842, 1636.8370, 1822.9163, 1953.9568, 2082.9994, 2198.0263, 2329.0668, 2458.1094, 2587.1520, 2715.2106, 2816.2582, 2963.3266, 3060.3794, 3189.4220, 3246.4435, 3375.4861, 3504.5287, 3635.5691, 3766.6096, 3879.6937, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 391.2374, 522.2778, 651.3204, 780.3630, 837.3845, 966.4271, 1063.4798, 1210.5483, 1311.5959, 1439.6545, 1568.6971, 1697.7397, 1828.7802, 1943.8071, 2072.8497, 2203.8902, 2389.9695, 2487.0223, 2586.0907, 2657.1278, 2770.2119, 2885.2388, 2982.2916, 3095.3756, 3182.4077, 3239.4291, 3376.4880, 3489.5721, 3586.6249, 3749.6882, 3878.7308, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SLEIHDSSGNDPEQEQEVDQDQDLEQCESEQEMR", {88.0393, 201.1234, 330.1660, 443.2500, 580.3089, 695.3359, 782.3679, 869.3999, 926.4214, 1040.4643, 1155.4913, 1252.5440, 1381.5866, 1509.6452, 1638.6878, 1766.7464, 1895.7890, 1994.8574, 2109.8843, 2237.9429, 2352.9698, 2481.0284, 2596.0554, 2709.1394, 2838.1820, 2966.2406, 3126.2713, 3255.3138, 3342.3459, 3471.3885, 3599.4470, 3728.4896, 3859.5301, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 306.1594, 435.2020, 563.2606, 692.3032, 779.3352, 908.3778, 1068.4085, 1196.4670, 1325.5096, 1438.5937, 1553.6206, 1681.6792, 1796.7062, 1924.7647, 2039.7917, 2138.8601, 2267.9027, 2395.9613, 2525.0039, 2653.0624, 2782.1050, 2879.1578, 2994.1847, 3108.2277, 3165.2491, 3252.2812, 3339.3132, 3454.3401, 3591.3990, 3704.4831, 3833.5257, 3946.6098, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PDHGLCVFADLNVTCGVMVEYFHVATMDNLCQYR", {98.0600, 213.0870, 350.1459, 407.1674, 520.2514, 680.2821, 779.3505, 926.4189, 997.4560, 1112.4830, 1225.5670, 1339.6099, 1438.6784, 1539.7260, 1699.7567, 1756.7782, 1855.8466, 1986.8871, 2085.9555, 2214.9981, 2378.0614, 2525.1298, 2662.1887, 2761.2571, 2832.2942, 2933.3419, 3064.3824, 3179.4093, 3293.4523, 3406.5363, 3566.5670, 3694.6256, 3857.6889, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 466.2409, 626.2715, 739.3556, 853.3985, 968.4254, 1099.4659, 1200.5136, 1271.5507, 1370.6191, 1507.6780, 1654.7465, 1817.8098, 1946.8524, 2045.9208, 2176.9613, 2276.0297, 2333.0512, 2493.0818, 2594.1295, 2693.1979, 2807.2408, 2920.3249, 3035.3518, 3106.3889, 3253.4574, 3352.5258, 3512.5564, 3625.6405, 3682.6619, 3819.7209, 3934.7478, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PINGYQGNYFFSPFYLQYQAALENFNFPLNFPPK", {98.0600, 211.1441, 325.1870, 382.2085, 545.2718, 673.3304, 730.3519, 844.3948, 1007.4581, 1154.5265, 1301.5949, 1388.6270, 1485.6797, 1632.7482, 1795.8115, 1908.8955, 2036.9541, 2200.0175, 2328.0760, 2399.1131, 2470.1503, 2583.2343, 2712.2769, 2826.3198, 2973.3883, 3087.4312, 3234.4996, 3331.5524, 3444.6364, 3558.6794, 3705.7478, 3802.8005, 3899.8533, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 244.1656, 341.2183, 488.2867, 602.3297, 715.4137, 812.4665, 959.5349, 1073.5778, 1220.6463, 1334.6892, 1463.7318, 1576.8158, 1647.8530, 1718.8901, 1846.9486, 2010.0120, 2138.0706, 2251.1546, 2414.2179, 2561.2864, 2658.3391, 2745.3712, 2892.4396, 3039.5080, 3202.5713, 3316.6142, 3373.6357, 3501.6943, 3664.7576, 3721.7791, 3835.8220, 3948.9061, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FHFVPQLFQPYFENVGLVHVYLNAYSEMSSDPNK", {148.0757, 285.1346, 432.2030, 531.2714, 628.3242, 756.3828, 869.4668, 1016.5352, 1144.5938, 1241.6466, 1404.7099, 1551.7783, 1680.8209, 1794.8639, 1893.9323, 1950.9537, 2064.0378, 2163.1062, 2300.1651, 2399.2335, 2562.2969, 2675.3809, 2789.4239, 2860.4610, 3023.5243, 3110.5563, 3239.5989, 3370.6394, 3457.6714, 3544.7035, 3659.7304, 3756.7832, 3870.8261, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 261.1557, 358.2085, 473.2354, 560.2675, 647.2995, 778.3400, 907.3826, 994.4146, 1157.4779, 1228.5150, 1342.5580, 1455.6420, 1618.7054, 1717.7738, 1854.8327, 1953.9011, 2066.9852, 2124.0066, 2223.0750, 2337.1180, 2466.1606, 2613.2290, 2776.2923, 2873.3451, 3001.4037, 3148.4721, 3261.5561, 3389.6147, 3486.6675, 3585.7359, 3732.8043, 3869.8632, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NLEVIHNLYNNLNGWVQSLYVFHPFILESDIATR", {115.0502, 228.1343, 357.1769, 456.2453, 569.3293, 706.3883, 820.4312, 933.5152, 1096.5786, 1210.6215, 1324.6644, 1437.7485, 1551.7914, 1608.8129, 1794.8922, 1893.9606, 2022.0192, 2109.0512, 2222.1353, 2385.1986, 2484.2670, 2631.3354, 2768.3943, 2865.4471, 3012.5155, 3125.5996, 3238.6837, 3367.7262, 3454.7583, 3569.7852, 3682.8693, 3753.9064, 3854.9541, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 276.1666, 347.2037, 460.2878, 575.3148, 662.3468, 791.3894, 904.4734, 1017.5575, 1164.6259, 1261.6787, 1398.7376, 1545.8060, 1644.8744, 1807.9377, 1921.0218, 2008.0538, 2136.1124, 2235.1808, 2421.2601, 2478.2816, 2592.3245, 2705.4086, 2819.4515, 2933.4945, 3096.5578, 3209.6418, 3323.6848, 3460.7437, 3573.8278, 3672.8962, 3801.9388, 3915.0228, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SACTQLLQFHATYIEPSSEGDFQQWFIQFPSQLK", {88.0393, 159.0764, 319.1071, 420.1547, 548.2133, 661.2974, 774.3815, 902.4400, 1049.5084, 1186.5674, 1257.6045, 1358.6521, 1521.7155, 1634.7995, 1763.8421, 1860.8949, 1947.9269, 2034.9590, 2164.0015, 2221.0230, 2336.0500, 2483.1184, 2611.1769, 2739.2355, 2925.3148, 3072.3832, 3185.4673, 3313.5259, 3460.5943, 3557.6471, 3644.6791, 3772.7377, 3885.8217, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 388.2554, 475.2875, 572.3402, 719.4087, 847.4672, 960.5513, 1107.6197, 1293.6990, 1421.7576, 1549.8162, 1696.8846, 1811.9115, 1868.9330, 1997.9756, 2085.0076, 2172.0396, 2269.0924, 2398.1350, 2511.2191, 2674.2824, 2775.3301, 2846.3672, 2983.4261, 3130.4945, 3258.5531, 3371.6372, 3484.7212, 3612.7798, 3713.8275, 3873.8581, 3944.8952, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TNNVMPHQFCHGGNLCFSTNYAESCPLMQIETEK", {102.0550, 216.0979, 330.1408, 429.2092, 560.2497, 657.3025, 794.3614, 922.4200, 1069.4884, 1229.5190, 1366.5779, 1423.5994, 1480.6209, 1594.6638, 1707.7479, 1867.7785, 2014.8469, 2101.8789, 2202.9266, 2316.9696, 2480.0329, 2551.0700, 2680.1126, 2767.1446, 2927.1753, 3024.2280, 3137.3121, 3268.3526, 3396.4112, 3509.4952, 3638.5378, 3739.5855, 3868.6281, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 276.1554, 377.2031, 506.2457, 619.3297, 747.3883, 878.4288, 991.5129, 1088.5656, 1248.5963, 1335.6283, 1464.6709, 1535.7080, 1698.7713, 1812.8143, 1913.8619, 2000.8940, 2147.9624, 2307.9930, 2421.0771, 2535.1200, 2592.1415, 2649.1630, 2786.2219, 2946.2525, 3093.3209, 3221.3795, 3358.4384, 3455.4912, 3586.5317, 3685.6001, 3799.6430, 3913.6859, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DNVFEGNNNFDELLIGYYHMVELTAFQTIHESLR", {116.0342, 230.0771, 329.1456, 476.2140, 605.2566, 662.2780, 776.3210, 890.3639, 1004.4068, 1151.4752, 1266.5022, 1395.5448, 1508.6288, 1621.7129, 1734.7970, 1791.8184, 1954.8817, 2117.9451, 2255.0040, 2386.0445, 2485.1129, 2614.1555, 2727.2395, 2828.2872, 2899.3243, 3046.3928, 3174.4513, 3275.4990, 3388.5831, 3525.6420, 3654.6846, 3741.7166, 3854.8007, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 375.2350, 504.2776, 641.3365, 754.4206, 855.4683, 983.5269, 1130.5953, 1201.6324, 1302.6801, 1415.7641, 1544.8067, 1643.8751, 1774.9156, 1911.9745, 2075.0379, 2238.1012, 2295.1227, 2408.2067, 2521.2908, 2634.3749, 2763.4174, 2878.4444, 3025.5128, 3139.5557, 3253.5987, 3367.6416, 3424.6631, 3553.7056, 3700.7741, 3799.8425, 3913.8854, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NWLITNQMSIGHPMSQMMPMVCHAHTEPIHLINR", {115.0502, 301.1295, 414.2136, 527.2976, 628.3453, 742.3883, 870.4468, 1001.4873, 1088.5193, 1201.6034, 1258.6249, 1395.6838, 1492.7365, 1623.7770, 1710.8091, 1838.8676, 1969.9081, 2100.9486, 2198.0014, 2329.0419, 2428.1103, 2588.1409, 2725.1998, 2796.2369, 2933.2959, 3034.3435, 3163.3861, 3260.4389, 3373.5230, 3510.5819, 3623.6659, 3736.7500, 3850.7929, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 289.1619, 402.2459, 515.3300, 652.3889, 765.4730, 862.5257, 991.5683, 1092.6160, 1229.6749, 1300.7120, 1437.7710, 1597.8016, 1696.8700, 1827.9105, 1924.9633, 2056.0038, 2187.0442, 2315.1028, 2402.1348, 2533.1753, 2630.2281, 2767.2870, 2824.3085, 2937.3925, 3024.4246, 3155.4650, 3283.5236, 3397.5665, 3498.6142, 3611.6983, 3724.7824, 3910.8617, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VEYGFDLEDTTLMIIDDDITLIAETEIEPYPYFR", {100.0757, 229.1183, 392.1816, 449.2031, 596.2715, 711.2984, 824.3825, 953.4251, 1068.4520, 1169.4997, 1270.5474, 1383.6315, 1514.6719, 1627.7560, 1740.8401, 1855.8670, 1970.8940, 2085.9209, 2199.0050, 2300.0526, 2413.1367, 2526.2208, 2597.2579, 2726.3005, 2827.3482, 2956.3907, 3069.4748, 3198.5174, 3295.5702, 3458.6335, 3555.6863, 3718.7496, 3865.8180, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 485.2507, 582.3035, 745.3668, 842.4196, 971.4621, 1084.5462, 1213.5888, 1314.6365, 1443.6791, 1514.7162, 1627.8003, 1740.8843, 1841.9320, 1955.0161, 2070.0430, 2185.0699, 2300.0969, 2413.1810, 2526.2650, 2657.3055, 2770.3896, 2871.4372, 2972.4849, 3087.5119, 3216.5545, 3329.6385, 3444.6655, 3591.7339, 3648.7553, 3811.8187, 3940.8613, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LEMYFLPLGGFILFLCYPVLFAGGGNQYCIYPFR", {114.0913, 243.1339, 374.1744, 537.2377, 684.3062, 797.3902, 894.4430, 1007.5271, 1064.5485, 1121.5700, 1268.6384, 1381.7225, 1494.8065, 1641.8749, 1754.9590, 1914.9896, 2078.0530, 2175.1057, 2274.1742, 2387.2582, 2534.3266, 2605.3637, 2662.3852, 2719.4067, 2776.4281, 2890.4711, 3018.5296, 3181.5930, 3341.6236, 3454.7077, 3617.7710, 3714.8238, 3861.8922, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 419.2401, 582.3035, 695.3875, 855.4182, 1018.4815, 1146.5401, 1260.5830, 1317.6045, 1374.6259, 1431.6474, 1502.6845, 1649.7529, 1762.8370, 1861.9054, 1958.9582, 2122.0215, 2282.0521, 2395.1362, 2542.2046, 2655.2887, 2768.3727, 2915.4412, 2972.4626, 3029.4841, 3142.5682, 3239.6209, 3352.7050, 3499.7734, 3662.8367, 3793.8772, 3922.9198, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ELFSEYEEIIQSDDDTDEEDEEGSENEDEDDESK", {130.0499, 243.1339, 390.2023, 477.2344, 606.2770, 769.3403, 898.3829, 1027.4255, 1140.5095, 1253.5936, 1381.6522, 1468.6842, 1583.7112, 1698.7381, 1813.7650, 1914.8127, 2029.8397, 2158.8823, 2287.9249, 2402.9518, 2531.9944, 2661.0370, 2718.0584, 2805.0905, 2934.1331, 3048.1760, 3177.2186, 3292.2455, 3421.2881, 3536.3151, 3651.3420, 3780.3846, 3867.4166, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 234.1448, 363.1874, 478.2144, 593.2413, 722.2839, 837.3108, 966.3534, 1080.3964, 1209.4390, 1296.4710, 1353.4925, 1482.5350, 1611.5776, 1726.6046, 1855.6472, 1984.6898, 2099.7167, 2200.7644, 2315.7913, 2430.8183, 2545.8452, 2632.8772, 2760.9358, 2874.0199, 2987.1040, 3116.1465, 3245.1891, 3408.2525, 3537.2951, 3624.3271, 3771.3955, 3884.4796, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NYLVQAPTPHLFMQEPTCHEEEDEIGAQETPYLK", {115.0502, 278.1135, 391.1976, 490.2660, 618.3246, 689.3617, 786.4145, 887.4621, 984.5149, 1121.5738, 1234.6579, 1381.7263, 1512.7668, 1640.8254, 1769.8680, 1866.9207, 1967.9684, 2127.9990, 2265.0580, 2394.1005, 2523.1431, 2652.1857, 2767.2127, 2896.2553, 3009.3393, 3066.3608, 3137.3979, 3265.4565, 3394.4991, 3495.5468, 3592.5995, 3755.6629, 3868.7469, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 423.2602, 520.3130, 621.3606, 750.4032, 878.4618, 949.4989, 1006.5204, 1119.6045, 1248.6470, 1363.6740, 1492.7166, 1621.7592, 1750.8018, 1887.8607, 2047.8913, 2148.9390, 2245.9918, 2375.0344, 2503.0929, 2634.1334, 2781.2018, 2894.2859, 3031.3448, 3128.3976, 3229.4453, 3326.4980, 3397.5351, 3525.5937, 3624.6621, 3737.7462, 3900.8095, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FGELNSIYFILICQMVQYIFLFLIVGGYVAILER", {148.0757, 205.0972, 334.1397, 447.2238, 561.2667, 648.2988, 761.3828, 924.4462, 1071.5146, 1184.5986, 1297.6827, 1410.7668, 1570.7974, 1698.8560, 1829.8965, 1928.9649, 2057.0235, 2220.0868, 2333.1709, 2480.2393, 2593.3233, 2740.3918, 2853.4758, 2966.5599, 3065.6283, 3122.6498, 3179.6712, 3342.7346, 3441.8030, 3512.8401, 3625.9241, 3739.0082, 3868.0508, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 417.2456, 530.3297, 601.3668, 700.4352, 863.4985, 920.5200, 977.5415, 1076.6099, 1189.6939, 1302.7780, 1449.8464, 1562.9305, 1709.9989, 1823.0830, 1986.1463, 2114.2049, 2213.2733, 2344.3138, 2472.3723, 2632.4030, 2745.4870, 2858.5711, 2971.6552, 3118.7236, 3281.7869, 3394.8710, 3481.9030, 3595.9459, 3709.0300, 3838.0726, 3895.0941, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LLIQQICAFLVVVQGLFLYSFGYQLLYIPITTLR", {114.0913, 227.1754, 340.2595, 468.3180, 596.3766, 709.4607, 869.4913, 940.5284, 1087.5969, 1200.6809, 1299.7493, 1398.8178, 1497.8862, 1625.9447, 1682.9662, 1796.0503, 1943.1187, 2056.2028, 2219.2661, 2306.2981, 2453.3665, 2510.3880, 2673.4513, 2801.5099, 2914.5940, 3027.6780, 3190.7414, 3303.8254, 3400.8782, 3513.9622, 3615.0099, 3716.0576, 3829.1417, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 389.2507, 490.2984, 603.3824, 700.4352, 813.5193, 976.5826, 1089.6667, 1202.7507, 1330.8093, 1493.8726, 1550.8941, 1697.9625, 1784.9945, 1948.0579, 2061.1419, 2208.2103, 2321.2944, 2378.3159, 2506.3744, 2605.4429, 2704.5113, 2803.5797, 2916.6638, 3063.7322, 3134.7693, 3294.7999, 3407.8840, 3535.9426, 3664.0011, 3777.0852, 3890.1693, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TSDSFLVVYTGLISWGFLDNFHTFLYHLQMHSQK", {102.0550, 189.0870, 304.1139, 391.1460, 538.2144, 651.2984, 750.3668, 849.4353, 1012.4986, 1113.5463, 1170.5677, 1283.6518, 1396.7359, 1483.7679, 1669.8472, 1726.8687, 1873.9371, 1987.0211, 2102.0481, 2216.0910, 2363.1594, 2500.2183, 2601.2660, 2748.3344, 2861.4185, 3024.4818, 3161.5407, 3274.6248, 3402.6834, 3533.7239, 3670.7828, 3757.8148, 3885.8734, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 275.1714, 362.2034, 499.2623, 630.3028, 758.3614, 871.4454, 1008.5044, 1171.5677, 1284.6518, 1431.7202, 1532.7678, 1669.8268, 1816.8952, 1930.9381, 2045.9650, 2159.0491, 2306.1175, 2363.1390, 2549.2183, 2636.2503, 2749.3344, 2862.4185, 2919.4399, 3020.4876, 3183.5509, 3282.6193, 3381.6878, 3494.7718, 3641.8402, 3728.8723, 3843.8992, 3930.9312, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NFANIWCDVVYFVFYVIGCLTIIVLLNNGFNGYK", {115.0502, 262.1186, 333.1557, 447.1987, 560.2827, 746.3620, 906.3927, 1021.4196, 1120.4880, 1219.5565, 1382.6198, 1529.6882, 1628.7566, 1775.8250, 1938.8884, 2037.9568, 2151.0408, 2208.0623, 2368.0929, 2481.1770, 2582.2247, 2695.3088, 2808.3928, 2907.4612, 3020.5453, 3133.6294, 3247.6723, 3361.7152, 3418.7367, 3565.8051, 3679.8480, 3736.8695, 3899.9328, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 310.1761, 367.1976, 481.2405, 628.3089, 685.3304, 799.3733, 913.4163, 1026.5003, 1139.5844, 1238.6528, 1351.7369, 1464.8209, 1565.8686, 1678.9527, 1838.9833, 1896.0048, 2009.0888, 2108.1573, 2271.2206, 2418.2890, 2517.3574, 2664.4258, 2827.4892, 2926.5576, 3025.6260, 3140.6529, 3300.6836, 3486.7629, 3599.8470, 3713.8899, 3784.9270, 3931.9954, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"CFGLFFGDAGVFCVVTIYGHWHVLIYTIPYLPLR", {161.0379, 308.1063, 365.1278, 478.2119, 625.2803, 772.3487, 829.3702, 944.3971, 1015.4342, 1072.4557, 1171.5241, 1318.5925, 1478.6232, 1577.6916, 1676.7600, 1777.8077, 1890.8917, 2053.9551, 2110.9765, 2248.0354, 2434.1147, 2571.1737, 2670.2421, 2783.3261, 2896.4102, 3059.4735, 3160.5212, 3273.6053, 3370.6580, 3533.7214, 3646.8054, 3743.8582, 3856.9423, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 385.2558, 498.3398, 661.4032, 758.4559, 871.5400, 972.5877, 1135.6510, 1248.7351, 1361.8191, 1460.8875, 1597.9465, 1784.0258, 1921.0847, 1978.1062, 2141.1695, 2254.2535, 2355.3012, 2454.3696, 2553.4380, 2713.4687, 2860.5371, 2959.6055, 3016.6270, 3087.6641, 3202.6910, 3259.7125, 3406.7809, 3553.8493, 3666.9334, 3723.9549, 3871.0233, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QLLLEPPFEALHIVYNIPFSVPLIVMNYTFSFVR", {129.0659, 242.1499, 355.2340, 468.3180, 597.3606, 694.4134, 791.4662, 938.5346, 1067.5772, 1138.6143, 1251.6984, 1388.7573, 1501.8413, 1600.9097, 1763.9731, 1878.0160, 1991.1001, 2088.1528, 2235.2212, 2322.2533, 2421.3217, 2518.3744, 2631.4585, 2744.5426, 2843.6110, 2974.6515, 3088.6944, 3251.7577, 3352.8054, 3499.8738, 3586.9058, 3733.9743, 3833.0427, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 274.1874, 421.2558, 508.2878, 655.3562, 756.4039, 919.4672, 1033.5102, 1164.5506, 1263.6191, 1376.7031, 1489.7872, 1586.8399, 1685.9084, 1772.9404, 1920.0088, 2017.0616, 2130.1456, 2244.1886, 2407.2519, 2506.3203, 2619.4044, 2756.4633, 2869.5473, 2940.5845, 3069.6270, 3216.6955, 3313.7482, 3410.8010, 3539.8436, 3652.9276, 3766.0117, 3879.0958, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LCLVVAPFCDSVYNQLLQFSIGVIQYANAIYYNR", {114.0913, 274.1220, 387.2061, 486.2745, 585.3429, 656.3800, 753.4328, 900.5012, 1060.5318, 1175.5588, 1262.5908, 1361.6592, 1524.7225, 1638.7655, 1766.8240, 1879.9081, 1992.9922, 2121.0507, 2268.1192, 2355.1512, 2468.2353, 2525.2567, 2624.3251, 2737.4092, 2865.4678, 3028.5311, 3099.5682, 3213.6111, 3284.6483, 3397.7323, 3560.7956, 3723.8590, 3837.9019, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 289.1619, 452.2252, 615.2885, 728.3726, 799.4097, 913.4526, 984.4898, 1147.5531, 1275.6117, 1388.6957, 1487.7641, 1544.7856, 1657.8697, 1744.9017, 1891.9701, 2020.0287, 2133.1128, 2246.1968, 2374.2554, 2488.2983, 2651.3616, 2750.4301, 2837.4621, 2952.4890, 3112.5197, 3259.5881, 3356.6409, 3427.6780, 3526.7464, 3625.8148, 3738.8989, 3898.9295, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YYSQDCDWLDNDEHFQILVLEYTVITGAVSLVLK", {164.0706, 327.1339, 414.1660, 542.2245, 657.2515, 817.2821, 932.3091, 1118.3884, 1231.4725, 1346.4994, 1460.5423, 1575.5693, 1704.6119, 1841.6708, 1988.7392, 2116.7978, 2229.8818, 2342.9659, 2442.0343, 2555.1184, 2684.1610, 2847.2243, 2948.2720, 3047.3404, 3160.4244, 3261.4721, 3318.4936, 3389.5307, 3488.5991, 3575.6311, 3688.7152, 3787.7836, 3900.8677, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 359.2653, 472.3493, 559.3814, 658.4498, 729.4869, 786.5084, 887.5560, 1000.6401, 1099.7085, 1200.7562, 1363.8195, 1492.8621, 1605.9462, 1705.0146, 1818.0987, 1931.1827, 2059.2413, 2206.3097, 2343.3686, 2472.4112, 2587.4382, 2701.4811, 2816.5080, 2929.5921, 3115.6714, 3230.6984, 3390.7290, 3505.7560, 3633.8145, 3720.8466, 3883.9099, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DQAPTYFLMDFCIFHGFTVNFDTTFTAIEPSETR", {116.0342, 244.0928, 315.1299, 412.1827, 513.2304, 676.2937, 823.3621, 936.4462, 1067.4866, 1182.5136, 1329.5820, 1489.6126, 1602.6967, 1749.7651, 1886.8240, 1943.8455, 2090.9139, 2191.9616, 2291.0300, 2405.0729, 2552.1414, 2667.1683, 2768.2160, 2869.2637, 3016.3321, 3117.3797, 3188.4169, 3301.5009, 3430.5435, 3527.5963, 3614.6283, 3743.6709, 3844.7186, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 276.1666, 405.2092, 492.2413, 589.2940, 718.3366, 831.4207, 902.4578, 1003.5055, 1150.5739, 1251.6216, 1352.6692, 1467.6962, 1614.7646, 1728.8075, 1827.8759, 1928.9236, 2075.9920, 2133.0135, 2270.0724, 2417.1408, 2530.2249, 2690.2555, 2837.3239, 2952.3509, 3083.3914, 3196.4754, 3343.5438, 3506.6072, 3607.6549, 3704.7076, 3775.7447, 3903.8033, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"CYCHQDCGTLNAPVPSWNEIQVGQYSCTGNDVCR", {161.0379, 324.1013, 484.1319, 621.1908, 749.2494, 864.2763, 1024.3070, 1081.3284, 1182.3761, 1295.4602, 1409.5031, 1480.5402, 1577.5930, 1676.6614, 1773.7142, 1860.7462, 2046.8255, 2160.8684, 2289.9110, 2402.9951, 2531.0537, 2630.1221, 2687.1436, 2815.2021, 2978.2655, 3065.2975, 3225.3281, 3326.3758, 3383.3973, 3497.4402, 3612.4671, 3711.5356, 3871.5662, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 335.1496, 434.2180, 549.2450, 663.2879, 720.3093, 821.3570, 981.3877, 1068.4197, 1231.4830, 1359.5416, 1416.5631, 1515.6315, 1643.6901, 1756.7741, 1885.8167, 1999.8597, 2185.9390, 2272.9710, 2370.0238, 2469.0922, 2566.1449, 2637.1820, 2751.2250, 2864.3090, 2965.3567, 3022.3782, 3182.4088, 3297.4358, 3425.4944, 3562.5533, 3722.5839, 3885.6472, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VVNTVGQYMNVMQWHMYAGSPHQVDLQLEYLDSR", {100.0757, 199.1441, 313.1870, 414.2347, 513.3031, 570.3246, 698.3832, 861.4465, 992.4870, 1106.5299, 1205.5983, 1336.6388, 1464.6974, 1650.7767, 1787.8356, 1918.8761, 2081.9394, 2152.9765, 2209.9980, 2297.0300, 2394.0828, 2531.1417, 2659.2003, 2758.2687, 2873.2956, 2986.3797, 3114.4383, 3227.5223, 3356.5649, 3519.6283, 3632.7123, 3747.7393, 3834.7713, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 262.1510, 377.1779, 490.2620, 653.3253, 782.3679, 895.4520, 1023.5106, 1136.5946, 1251.6216, 1350.6900, 1478.7485, 1615.8075, 1712.8602, 1799.8923, 1856.9137, 1927.9508, 2091.0142, 2222.0546, 2359.1136, 2545.1929, 2673.2514, 2804.2919, 2903.3603, 3017.4033, 3148.4438, 3311.5071, 3439.5657, 3496.5871, 3595.6555, 3696.7032, 3810.7461, 3909.8146, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ELFYCTETGGPNPFEKPLFSPDRPQLEFEFGEHK", {130.0499, 243.1339, 390.2023, 553.2657, 713.2963, 814.3440, 943.3866, 1044.4343, 1101.4557, 1158.4772, 1255.5300, 1369.5729, 1466.6257, 1613.6941, 1742.7367, 1870.8316, 1967.8844, 2080.9685, 2228.0369, 2315.0689, 2412.1217, 2527.1486, 2683.2497, 2780.3025, 2908.3611, 3021.4451, 3150.4877, 3297.5561, 3426.5987, 3573.6671, 3630.6886, 3759.7312, 3896.7901, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 284.1717, 413.2143, 470.2358, 617.3042, 746.3468, 893.4152, 1022.4578, 1135.5419, 1263.6004, 1360.6532, 1516.7543, 1631.7812, 1728.8340, 1815.8660, 1962.9345, 2076.0185, 2173.0713, 2301.1662, 2430.2088, 2577.2773, 2674.3300, 2788.3729, 2885.4257, 2942.4472, 2999.4686, 3100.5163, 3229.5589, 3330.6066, 3490.6372, 3653.7006, 3800.7690, 3913.8530, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"CKPIHCYDGQWGTLCIIEGTESCTSHGFSDDRPR", {161.0379, 289.1329, 386.1857, 499.2697, 636.3286, 796.3593, 959.4226, 1074.4495, 1131.4710, 1259.5296, 1445.6089, 1502.6304, 1603.6780, 1716.7621, 1876.7928, 1989.8768, 2102.9609, 2232.0035, 2289.0249, 2390.0726, 2519.1152, 2606.1472, 2766.1779, 2867.2256, 2954.2576, 3091.3165, 3148.3380, 3295.4064, 3382.4384, 3497.4654, 3612.4923, 3768.5934, 3865.6462, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 272.1717, 428.2728, 543.2998, 658.3267, 745.3587, 892.4272, 949.4486, 1086.5075, 1173.5396, 1274.5872, 1434.6179, 1521.6499, 1650.6925, 1751.7402, 1808.7617, 1937.8042, 2050.8883, 2163.9724, 2324.0030, 2437.0871, 2538.1348, 2595.1562, 2781.2355, 2909.2941, 2966.3156, 3081.3425, 3244.4059, 3404.4365, 3541.4954, 3654.5795, 3751.6322, 3879.7272, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ASTAEHNIWFSVWSLMVILISPLYTQFVFYGINR", {72.0444, 159.0764, 260.1241, 331.1612, 460.2038, 597.2627, 711.3056, 824.3897, 1010.4690, 1157.5374, 1244.5695, 1343.6379, 1529.7172, 1616.7492, 1729.8333, 1860.8738, 1959.9422, 2073.0262, 2186.1103, 2299.1944, 2386.2264, 2483.2792, 2596.3632, 2759.4266, 2860.4742, 2988.5328, 3135.6012, 3234.6696, 3381.7381, 3544.8014, 3601.8228, 3714.9069, 3828.9498, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 289.1619, 402.2459, 459.2674, 622.3307, 769.3991, 868.4676, 1015.5360, 1143.5946, 1244.6422, 1407.7056, 1520.7896, 1617.8424, 1704.8744, 1817.9585, 1931.0425, 2044.1266, 2143.1950, 2274.2355, 2387.3196, 2474.3516, 2660.4309, 2759.4993, 2846.5314, 2993.5998, 3179.6791, 3292.7631, 3406.8061, 3543.8650, 3672.9076, 3743.9447, 3844.9924, 3932.0244, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EEASLIHPYPQDGYTMIEWLLVGYSWVDSQSDYK", {130.0499, 259.0925, 330.1296, 417.1616, 530.2457, 643.3297, 780.3886, 877.4414, 1040.5047, 1137.5575, 1265.6161, 1380.6430, 1437.6645, 1600.7278, 1701.7755, 1832.8160, 1945.9000, 2074.9426, 2261.0219, 2374.1060, 2487.1901, 2586.2585, 2643.2800, 2806.3433, 2893.3753, 3079.4546, 3178.5230, 3293.5500, 3380.5820, 3508.6406, 3595.6726, 3710.6996, 3873.7629, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 310.1761, 425.2031, 512.2351, 640.2937, 727.3257, 842.3527, 941.4211, 1127.5004, 1214.5324, 1377.5957, 1434.6172, 1533.6856, 1646.7697, 1759.8537, 1945.9331, 2074.9756, 2188.0597, 2319.1002, 2420.1479, 2583.2112, 2640.2327, 2755.2596, 2883.3182, 2980.3710, 3143.4343, 3240.4870, 3377.5460, 3490.6300, 3603.7141, 3690.7461, 3761.7832, 3890.8258, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"CCPTHDINNALCNFTINSWPACVMFDPLNAQDTK", {161.0379, 321.0686, 418.1213, 519.1690, 656.2279, 771.2549, 884.3389, 998.3819, 1112.4248, 1183.4619, 1296.5460, 1456.5766, 1570.6195, 1717.6880, 1818.7356, 1931.8197, 2045.8626, 2132.8947, 2318.9740, 2416.0267, 2487.0638, 2647.0945, 2746.1629, 2877.2034, 3024.2718, 3139.2988, 3236.3515, 3349.4356, 3463.4785, 3534.5156, 3662.5742, 3777.6011, 3878.6488, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 248.1605, 363.1874, 491.2460, 562.2831, 676.3260, 789.4101, 886.4629, 1001.4898, 1148.5582, 1279.5987, 1378.6671, 1538.6978, 1609.7349, 1706.7877, 1892.8670, 1979.8990, 2093.9419, 2207.0260, 2308.0737, 2455.1421, 2569.1850, 2729.2157, 2842.2997, 2913.3368, 3027.3798, 3141.4227, 3254.5068, 3369.5337, 3506.5926, 3607.6403, 3704.6930, 3864.7237, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"CLLCLTDEGPPYLHQQMMDDNVHGTNYSWAENAK", {161.0379, 274.1220, 387.2061, 547.2367, 660.3208, 761.3684, 876.3954, 1005.4380, 1062.4594, 1159.5122, 1256.5650, 1419.6283, 1532.7124, 1669.7713, 1797.8299, 1925.8884, 2056.9289, 2187.9694, 2302.9963, 2418.0233, 2532.0662, 2631.1346, 2768.1935, 2825.2150, 2926.2627, 3040.3056, 3203.3689, 3290.4010, 3476.4803, 3547.5174, 3676.5600, 3790.6029, 3861.6400, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 218.1499, 332.1928, 461.2354, 532.2726, 718.3519, 805.3839, 968.4472, 1082.4901, 1183.5378, 1240.5593, 1377.6182, 1476.6866, 1590.7295, 1705.7565, 1820.7834, 1951.8239, 2082.8644, 2210.9230, 2338.9816, 2476.0405, 2589.1245, 2752.1879, 2849.2406, 2946.2934, 3003.3149, 3132.3574, 3247.3844, 3348.4321, 3461.5161, 3621.5468, 3734.6308, 3847.7149, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FQDFMTGYIDELVDYMENVTPDLQGCPPEVCFSK", {148.0757, 276.1343, 391.1612, 538.2296, 669.2701, 770.3178, 827.3393, 990.4026, 1103.4866, 1218.5136, 1347.5562, 1460.6402, 1559.7087, 1674.7356, 1837.7989, 1968.8394, 2097.8820, 2211.9249, 2310.9933, 2412.0410, 2509.0938, 2624.1207, 2737.2048, 2865.2634, 2922.2848, 3082.3155, 3179.3683, 3276.4210, 3405.4636, 3504.5320, 3664.5627, 3811.6311, 3898.6631, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 234.1448, 381.2132, 541.2439, 640.3123, 769.3549, 866.4077, 963.4604, 1123.4911, 1180.5125, 1308.5711, 1421.6552, 1536.6821, 1633.7349, 1734.7826, 1833.8510, 1947.8939, 2076.9365, 2207.9770, 2371.0403, 2486.0673, 2585.1357, 2698.2197, 2827.2623, 2942.2893, 3055.3733, 3218.4367, 3275.4581, 3376.5058, 3507.5463, 3654.6147, 3769.6417, 3897.7002, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SPNHLSTNLMIIAFSLVYCTDTNTFIDPNLQCYR", {88.0393, 185.0921, 299.1350, 436.1939, 549.2780, 636.3100, 737.3577, 851.4006, 964.4847, 1095.5252, 1208.6092, 1321.6933, 1392.7304, 1539.7988, 1626.8308, 1739.9149, 1838.9833, 2002.0466, 2162.0773, 2263.1250, 2378.1519, 2479.1996, 2593.2425, 2694.2902, 2841.3586, 2954.4427, 3069.4696, 3166.5224, 3280.5653, 3393.6494, 3521.7080, 3681.7386, 3844.8019, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 498.2129, 626.2715, 739.3556, 853.3985, 950.4513, 1065.4782, 1178.5623, 1325.6307, 1426.6784, 1540.7213, 1641.7690, 1756.7959, 1857.8436, 2017.8742, 2180.9376, 2280.0060, 2393.0900, 2480.1221, 2627.1905, 2698.2276, 2811.3117, 2924.3957, 3055.4362, 3168.5203, 3282.5632, 3383.6109, 3470.6429, 3583.7270, 3720.7859, 3834.8288, 3931.8816, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DIEVGCGPTYHEILNLEPYELDMDIEQIPDLPQR", {116.0342, 229.1183, 358.1609, 457.2293, 514.2508, 674.2814, 731.3029, 828.3556, 929.4033, 1092.4666, 1229.5255, 1358.5681, 1471.6522, 1584.7363, 1698.7792, 1811.8633, 1940.9059, 2037.9586, 2201.0219, 2330.0645, 2443.1486, 2558.1755, 2689.2160, 2804.2430, 2917.3270, 3046.3696, 3174.4282, 3287.5123, 3384.5650, 3499.5920, 3612.6760, 3709.7288, 3837.7874, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 400.2303, 513.3144, 628.3413, 725.3941, 838.4781, 966.5367, 1095.5793, 1208.6634, 1323.6903, 1454.7308, 1569.7577, 1682.8418, 1811.8844, 1974.9477, 2072.0005, 2201.0431, 2314.1271, 2428.1701, 2541.2541, 2654.3382, 2783.3808, 2920.4397, 3083.5030, 3184.5507, 3281.6035, 3338.6249, 3498.6556, 3555.6770, 3654.7455, 3783.7881, 3896.8721, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VSNETLLTEEDLHVIWDSDNLVNVNDELCYQLAR", {100.0757, 187.1077, 301.1506, 430.1932, 531.2409, 644.3250, 757.4090, 858.4567, 987.4993, 1116.5419, 1231.5689, 1344.6529, 1481.7118, 1580.7802, 1693.8643, 1879.9436, 1994.9706, 2082.0026, 2197.0295, 2311.0725, 2424.1565, 2523.2249, 2637.2679, 2736.3363, 2850.3792, 2965.4062, 3094.4487, 3207.5328, 3367.5635, 3530.6268, 3658.6854, 3771.7694, 3842.8065, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 246.1561, 359.2401, 487.2987, 650.3620, 810.3927, 923.4767, 1052.5193, 1167.5463, 1281.5892, 1380.6576, 1494.7006, 1593.7690, 1706.8530, 1820.8960, 1935.9229, 2022.9549, 2137.9819, 2324.0612, 2437.1453, 2536.2137, 2673.2726, 2786.3566, 2901.3836, 3030.4262, 3159.4688, 3260.5164, 3373.6005, 3486.6846, 3587.7323, 3716.7748, 3830.8178, 3917.8498, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MNGSLDYSYAWAIYFDALMTGIGNNYMQQYFEIK", {132.0478, 246.0907, 303.1122, 390.1442, 503.2282, 618.2552, 781.3185, 868.3505, 1031.4139, 1102.4510, 1288.5303, 1359.5674, 1472.6515, 1635.7148, 1782.7832, 1897.8102, 1968.8473, 2081.9313, 2212.9718, 2314.0195, 2371.0410, 2484.1250, 2541.1465, 2655.1894, 2769.2324, 2932.2957, 3063.3362, 3191.3947, 3319.4533, 3482.5166, 3629.5851, 3758.6277, 3871.7117, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 389.2395, 536.3079, 699.3712, 827.4298, 955.4884, 1086.5288, 1249.5922, 1363.6351, 1477.6780, 1534.6995, 1647.7836, 1704.8050, 1805.8527, 1936.8932, 2049.9772, 2121.0144, 2236.0413, 2383.1097, 2546.1730, 2659.2571, 2730.2942, 2916.3735, 2987.4106, 3150.4740, 3237.5060, 3400.5693, 3515.5963, 3628.6803, 3715.7124, 3772.7338, 3886.7768, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ILPLNFGPPHWSHSTSNWNEYVNIIYDTNHVIVK", {114.0913, 227.1754, 324.2282, 437.3122, 551.3552, 698.4236, 755.4450, 852.4978, 949.5506, 1086.6095, 1272.6888, 1359.7208, 1496.7797, 1583.8118, 1684.8594, 1771.8915, 1885.9344, 2072.0137, 2186.0566, 2315.0992, 2478.1626, 2577.2310, 2691.2739, 2804.3580, 2917.4420, 3080.5054, 3195.5323, 3296.5800, 3410.6229, 3547.6818, 3646.7502, 3759.8343, 3858.9027, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 246.1812, 359.2653, 458.3337, 595.3926, 709.4355, 810.4832, 925.5102, 1088.5735, 1201.6575, 1314.7416, 1428.7845, 1527.8530, 1690.9163, 1819.9589, 1934.0018, 2120.0811, 2234.1240, 2321.1561, 2422.2038, 2509.2358, 2646.2947, 2733.3267, 2919.4060, 3056.4649, 3153.5177, 3250.5705, 3307.5919, 3454.6604, 3568.7033, 3681.7873, 3778.8401, 3891.9242, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NNFIELLFFVLHHNSPASLLFWPTSFAELLHLMK", {115.0502, 229.0931, 376.1615, 489.2456, 618.2882, 731.3723, 844.4563, 991.5247, 1138.5932, 1237.6616, 1350.7456, 1487.8045, 1624.8635, 1738.9064, 1825.9384, 1922.9912, 1994.0283, 2081.0603, 2194.1444, 2307.2285, 2454.2969, 2640.3762, 2737.4289, 2838.4766, 2925.5086, 3072.5771, 3143.6142, 3272.6568, 3385.7408, 3498.8249, 3635.8838, 3748.9679, 3880.0084, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 278.1533, 391.2374, 528.2963, 641.3803, 754.4644, 883.5070, 954.5441, 1101.6125, 1188.6445, 1289.6922, 1386.7450, 1572.8243, 1719.8927, 1832.9768, 1946.0608, 2033.0929, 2104.1300, 2201.1827, 2288.2148, 2402.2577, 2539.3166, 2676.3755, 2789.4596, 2888.5280, 3035.5964, 3182.6648, 3295.7489, 3408.8330, 3537.8756, 3650.9596, 3798.0280, 3912.0710, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TLSACETTLVYVASICVYQTVVNCLLYFLMLPFK", {102.0550, 215.1390, 302.1710, 373.2082, 533.2388, 662.2814, 763.3291, 864.3768, 977.4608, 1076.5292, 1239.5926, 1338.6610, 1409.6981, 1496.7301, 1609.8142, 1769.8448, 1868.9132, 2031.9766, 2160.0352, 2261.0828, 2360.1512, 2459.2197, 2573.2626, 2733.2932, 2846.3773, 2959.4614, 3122.5247, 3269.5931, 3382.6772, 3513.7177, 3626.8017, 3723.8545, 3870.9229, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 294.1812, 391.2340, 504.3180, 635.3585, 748.4426, 895.5110, 1058.5743, 1171.6584, 1284.7425, 1444.7731, 1558.8160, 1657.8845, 1756.9529, 1858.0005, 1986.0591, 2149.1225, 2248.1909, 2408.2215, 2521.3056, 2608.3376, 2679.3747, 2778.4431, 2941.5065, 3040.5749, 3153.6589, 3254.7066, 3355.7543, 3484.7969, 3644.8275, 3715.8647, 3802.8967, 3915.9807, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QQSLWDEDASDMDYDPVETDLGLPQMHIMQRPMK", {129.0659, 257.1244, 344.1565, 457.2405, 643.3198, 758.3468, 887.3894, 1002.4163, 1073.4534, 1160.4855, 1275.5124, 1406.5529, 1521.5798, 1684.6432, 1799.6701, 1896.7229, 1995.7913, 2124.8339, 2225.8816, 2340.9085, 2453.9926, 2511.0140, 2624.0981, 2721.1508, 2849.2094, 2980.2499, 3117.3088, 3230.3929, 3361.4334, 3489.4919, 3645.5931, 3742.6458, 3873.6863, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 278.1533, 375.2061, 531.3072, 659.3657, 790.4062, 903.4903, 1040.5492, 1171.5897, 1299.6483, 1396.7010, 1509.7851, 1566.8066, 1679.8906, 1794.9176, 1895.9652, 2025.0078, 2124.0762, 2221.1290, 2336.1560, 2499.2193, 2614.2462, 2745.2867, 2860.3137, 2947.3457, 3018.3828, 3133.4097, 3262.4523, 3377.4793, 3563.5586, 3676.6427, 3763.6747, 3891.7333, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LISLANMQDISPLTHCQYFLQILENTLLPQPLER", {114.0913, 227.1754, 314.2074, 427.2915, 498.3286, 612.3715, 743.4120, 871.4706, 986.4975, 1099.5816, 1186.6136, 1283.6664, 1396.7505, 1497.7981, 1634.8571, 1794.8877, 1922.9463, 2086.0096, 2233.0780, 2346.1621, 2474.2207, 2587.3047, 2700.3888, 2829.4314, 2943.4743, 3044.5220, 3157.6061, 3270.6901, 3367.7429, 3495.8015, 3592.8542, 3705.9383, 3834.9809, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 417.2456, 514.2984, 642.3570, 739.4097, 852.4938, 965.5778, 1066.6255, 1180.6684, 1309.7110, 1422.7951, 1535.8792, 1663.9377, 1777.0218, 1924.0902, 2087.1536, 2215.2121, 2375.2428, 2512.3017, 2613.3494, 2726.4334, 2823.4862, 2910.5182, 3023.6023, 3138.6292, 3266.6878, 3397.7283, 3511.7712, 3582.8083, 3695.8924, 3782.9244, 3896.0085, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PEISQSNSQLYYENLFESFDQDDSHHLDTNSNMK", {98.0600, 227.1026, 340.1867, 427.2187, 555.2773, 642.3093, 756.3523, 843.3843, 971.4429, 1084.5269, 1247.5903, 1410.6536, 1539.6962, 1653.7391, 1766.8232, 1913.8916, 2042.9342, 2129.9662, 2277.0346, 2392.0616, 2520.1201, 2635.1471, 2750.1740, 2837.2061, 2974.2650, 3111.3239, 3224.4079, 3339.4349, 3440.4826, 3554.5255, 3641.5575, 3755.6004, 3886.6409, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 278.1533, 392.1962, 479.2282, 593.2712, 694.3189, 809.3458, 922.4299, 1059.4888, 1196.5477, 1283.5797, 1398.6067, 1513.6336, 1641.6922, 1756.7191, 1903.7875, 1990.8196, 2119.8622, 2266.9306, 2380.0146, 2494.0576, 2623.1002, 2786.1635, 2949.2268, 3062.3109, 3190.3694, 3277.4015, 3391.4444, 3478.4764, 3606.5350, 3693.5670, 3806.6511, 3935.6937, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LLTLDYIVLYFSEWSPSLMLSVVPAFITFLTSWR", {114.0913, 227.1754, 328.2231, 441.3071, 556.3341, 719.3974, 832.4815, 931.5499, 1044.6340, 1207.6973, 1354.7657, 1441.7977, 1570.8403, 1756.9196, 1843.9517, 1941.0044, 2028.0365, 2141.1205, 2272.1610, 2385.2451, 2472.2771, 2571.3455, 2670.4139, 2767.4667, 2838.5038, 2985.5722, 3098.6563, 3199.7040, 3346.7724, 3459.8564, 3560.9041, 3647.9361, 3834.0155, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 361.1983, 448.2303, 549.2780, 662.3620, 809.4305, 910.4781, 1023.5622, 1170.6306, 1241.6677, 1338.7205, 1437.7889, 1536.8573, 1623.8893, 1736.9734, 1868.0139, 1981.0980, 2068.1300, 2165.1827, 2252.2148, 2438.2941, 2567.3367, 2654.3687, 2801.4371, 2964.5005, 3077.5845, 3176.6529, 3289.7370, 3452.8003, 3567.8273, 3680.9113, 3781.9590, 3895.0431, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VFCDMPVCDQSIQASLAYVFSYDSYQSSILHHLK", {100.0757, 247.1441, 407.1748, 522.2017, 653.2422, 750.2949, 849.3634, 1009.3940, 1124.4209, 1252.4795, 1339.5116, 1452.5956, 1580.6542, 1651.6913, 1738.7233, 1851.8074, 1922.8445, 2085.9078, 2184.9763, 2332.0447, 2419.0767, 2582.1400, 2697.1670, 2784.1990, 2947.2623, 3075.3209, 3162.3529, 3249.3850, 3362.4690, 3475.5531, 3612.6120, 3749.6709, 3862.7550, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 397.2558, 534.3147, 647.3988, 760.4828, 847.5148, 934.5469, 1062.6055, 1225.6688, 1312.7008, 1427.7278, 1590.7911, 1677.8231, 1824.8915, 1923.9599, 2087.0233, 2158.0604, 2271.1444, 2358.1765, 2429.2136, 2557.2722, 2670.3562, 2757.3883, 2885.4468, 3000.4738, 3160.5044, 3259.5728, 3356.6256, 3487.6661, 3602.6930, 3762.7237, 3909.7921, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FDEAMEYNDYNNLIPPNSDNLNFELQQVDAEENK", {148.0757, 263.1026, 392.1452, 463.1823, 594.2228, 723.2654, 886.3287, 1000.3717, 1115.3986, 1278.4619, 1392.5049, 1506.5478, 1619.6319, 1732.7159, 1829.7687, 1926.8215, 2040.8644, 2127.8964, 2242.9234, 2356.9663, 2470.0503, 2584.0933, 2731.1617, 2860.2043, 2973.2883, 3101.3469, 3229.4055, 3328.4739, 3443.5009, 3514.5380, 3643.5806, 3772.6232, 3886.6661, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 261.1557, 390.1983, 519.2409, 590.2780, 705.3050, 804.3734, 932.4320, 1060.4905, 1173.5746, 1302.6172, 1449.6856, 1563.7285, 1676.8126, 1790.8555, 1905.8825, 1992.9145, 2106.9574, 2204.0102, 2301.0630, 2414.1470, 2527.2311, 2641.2740, 2755.3169, 2918.3803, 3033.4072, 3147.4501, 3310.5135, 3439.5561, 3570.5965, 3641.6337, 3770.6763, 3885.7032, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"AIAYPEQTECPWPNECLTIFDCVAHEMELVTTAK", {72.0444, 185.1285, 256.1656, 419.2289, 516.2817, 645.3243, 773.3828, 874.4305, 1003.4731, 1163.5038, 1260.5565, 1446.6358, 1543.6886, 1657.7315, 1786.7741, 1946.8048, 2059.8888, 2160.9365, 2274.0206, 2421.0890, 2536.1159, 2696.1466, 2795.2150, 2866.2521, 3003.3110, 3132.3536, 3263.3941, 3392.4367, 3505.5207, 3604.5892, 3705.6368, 3806.6845, 3877.7216, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 218.1499, 319.1976, 420.2453, 519.3137, 632.3978, 761.4403, 892.4808, 1021.5234, 1158.5823, 1229.6194, 1328.6879, 1488.7185, 1603.7455, 1750.8139, 1863.8979, 1964.9456, 2078.0297, 2238.0603, 2367.1029, 2481.1458, 2578.1986, 2764.2779, 2861.3307, 3021.3613, 3150.4039, 3251.4516, 3379.5102, 3508.5528, 3605.6055, 3768.6689, 3839.7060, 3952.7900, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FDLNPPAPFGPCLEFDGDILDQQLLEELYTQCLR", {148.0757, 263.1026, 376.1867, 490.2296, 587.2824, 684.3352, 755.3723, 852.4250, 999.4934, 1056.5149, 1153.5677, 1313.5983, 1426.6824, 1555.7250, 1702.7934, 1817.8203, 1874.8418, 1989.8687, 2102.9528, 2216.0369, 2331.0638, 2459.1224, 2587.1810, 2700.2650, 2813.3491, 2942.3917, 3071.4343, 3184.5183, 3347.5817, 3448.6294, 3576.6879, 3736.7186, 3849.8026, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 448.2337, 576.2922, 677.3399, 840.4032, 953.4873, 1082.5299, 1211.5725, 1324.6566, 1437.7406, 1565.7992, 1693.8578, 1808.8847, 1921.9688, 2035.0529, 2150.0798, 2207.1013, 2322.1282, 2469.1966, 2598.2392, 2711.3233, 2871.3539, 2968.4067, 3025.4282, 3172.4966, 3269.5493, 3340.5864, 3437.6392, 3534.6920, 3648.7349, 3761.8190, 3876.8459, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DIHACNPTYMHQDQMENLIGNLTTEVDNMEVELK", {116.0342, 229.1183, 366.1772, 437.2143, 597.2450, 711.2879, 808.3406, 909.3883, 1072.4517, 1203.4921, 1340.5511, 1468.6096, 1583.6366, 1711.6952, 1842.7356, 1971.7782, 2085.8212, 2198.9052, 2311.9893, 2369.0107, 2483.0537, 2596.1377, 2697.1854, 2798.2331, 2927.2757, 3026.3441, 3141.3710, 3255.4140, 3386.4545, 3515.4971, 3614.5655, 3743.6081, 3856.6921, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 389.2395, 488.3079, 617.3505, 748.3910, 862.4339, 977.4608, 1076.5292, 1205.5718, 1306.6195, 1407.6672, 1520.7513, 1634.7942, 1691.8156, 1804.8997, 1917.9838, 2032.0267, 2161.0693, 2292.1098, 2420.1684, 2535.1953, 2663.2539, 2800.3128, 2931.3533, 3094.4166, 3195.4643, 3292.5170, 3406.5600, 3566.5906, 3637.6277, 3774.6866, 3887.7707, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VNEPVNFTVDVNQMWLTESVNNIDTVYTVPFIWK", {100.0757, 214.1186, 343.1612, 440.2140, 539.2824, 653.3253, 800.3937, 901.4414, 1000.5098, 1115.5368, 1214.6052, 1328.6481, 1456.7067, 1587.7472, 1773.8265, 1886.9105, 1987.9582, 2117.0008, 2204.0328, 2303.1013, 2417.1442, 2531.1871, 2644.2712, 2759.2981, 2860.3458, 2959.4142, 3122.4775, 3223.5252, 3322.5936, 3419.6464, 3566.7148, 3679.7989, 3865.8782, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 333.1921, 446.2762, 593.3446, 690.3974, 789.4658, 890.5135, 1053.5768, 1152.6452, 1253.6929, 1368.7198, 1481.8039, 1595.8468, 1709.8897, 1808.9581, 1895.9902, 2025.0328, 2126.0804, 2239.1645, 2425.2438, 2556.2843, 2684.3429, 2798.3858, 2897.4542, 3012.4812, 3111.5496, 3212.5973, 3359.6657, 3473.7086, 3572.7770, 3669.8298, 3798.8724, 3912.9153, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"IFFSLSVGLFSFGLFWWVEESFPDMFTFLEPTAK", {114.0913, 261.1598, 408.2282, 495.2602, 608.3443, 695.3763, 794.4447, 851.4662, 964.5502, 1111.6186, 1198.6507, 1345.7191, 1402.7406, 1515.8246, 1662.8930, 1848.9723, 2035.0517, 2134.1201, 2263.1627, 2392.2053, 2479.2373, 2626.3057, 2723.3585, 2838.3854, 2969.4259, 3116.4943, 3217.5420, 3364.6104, 3477.6945, 3606.7371, 3703.7898, 3804.8375, 3875.8746, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 218.1499, 319.1976, 416.2504, 545.2930, 658.3770, 805.4454, 906.4931, 1053.5615, 1184.6020, 1299.6290, 1396.6817, 1543.7501, 1630.7822, 1759.8248, 1888.8673, 1987.9358, 2174.0151, 2360.0944, 2507.1628, 2620.2469, 2677.2683, 2824.3367, 2911.3688, 3058.4372, 3171.5212, 3228.5427, 3327.6111, 3414.6432, 3527.7272, 3614.7592, 3761.8277, 3908.8961, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NYMDDVEGDDEEEVNDELSELDLQEELSLMHVHK", {115.0502, 278.1135, 409.1540, 524.1810, 639.2079, 738.2763, 867.3189, 924.3404, 1039.3673, 1154.3943, 1283.4369, 1412.4794, 1541.5220, 1640.5905, 1754.6334, 1869.6603, 1998.7029, 2111.7870, 2198.8190, 2327.8616, 2440.9457, 2555.9726, 2669.0567, 2797.1153, 2926.1578, 3055.2004, 3168.2845, 3255.3165, 3368.4006, 3499.4411, 3636.5000, 3735.5684, 3872.6273, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 284.1717, 383.2401, 520.2990, 651.3395, 764.4236, 851.4556, 964.5397, 1093.5823, 1222.6249, 1350.6834, 1463.7675, 1578.7945, 1691.8785, 1820.9211, 1907.9531, 2021.0372, 2150.0798, 2265.1067, 2379.1497, 2478.2181, 2607.2607, 2736.3033, 2865.3459, 2980.3728, 3095.3997, 3152.4212, 3281.4638, 3380.5322, 3495.5592, 3610.5861, 3741.6266, 3904.6899, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PLSVSYNNNQIDAIETNQIITYIWSLYPNLQTFR", {98.0600, 211.1441, 298.1761, 397.2445, 484.2766, 647.3399, 761.3828, 875.4258, 989.4687, 1117.5273, 1230.6113, 1345.6383, 1416.6754, 1529.7594, 1658.8020, 1759.8497, 1873.8926, 2001.9512, 2115.0353, 2228.1194, 2329.1670, 2492.2304, 2605.3144, 2791.3937, 2878.4258, 2991.5098, 3154.5732, 3251.6259, 3365.6688, 3478.7529, 3606.8115, 3707.8592, 3854.9276, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 423.2350, 551.2936, 664.3777, 778.4206, 875.4734, 1038.5367, 1151.6208, 1238.6528, 1424.7321, 1537.8162, 1700.8795, 1801.9272, 1915.0112, 2028.0953, 2156.1539, 2270.1968, 2371.2445, 2500.2871, 2613.3712, 2684.4083, 2799.4352, 2912.5193, 3040.5778, 3154.6208, 3268.6637, 3382.7066, 3545.7700, 3632.8020, 3731.8704, 3818.9024, 3931.9865, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MMELDYNWEEELQEAEALPMASQRPMFLAALDTR", {132.0478, 263.0882, 392.1308, 505.2149, 620.2418, 783.3052, 897.3481, 1083.4274, 1212.4700, 1341.5126, 1470.5552, 1583.6393, 1711.6978, 1840.7404, 1911.7775, 2040.8201, 2111.8572, 2224.9413, 2321.9941, 2453.0346, 2524.0717, 2611.1037, 2739.1623, 2895.2634, 2992.3162, 3123.3566, 3270.4251, 3383.5091, 3454.5462, 3525.5833, 3638.6674, 3753.6944, 3854.7420, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 276.1666, 391.1936, 504.2776, 575.3148, 646.3519, 759.4359, 906.5043, 1037.5448, 1134.5976, 1290.6987, 1418.7573, 1505.7893, 1576.8264, 1707.8669, 1804.9197, 1918.0037, 1989.0408, 2118.0834, 2189.1206, 2318.1631, 2446.2217, 2559.3058, 2688.3484, 2817.3910, 2946.4336, 3132.5129, 3246.5558, 3409.6191, 3524.6461, 3637.7301, 3766.7727, 3897.8132, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SQVQQPIDGFPHMEDFNHQLCNVYDEHLDGLNNK", {88.0393, 216.0979, 315.1663, 443.2249, 571.2835, 668.3362, 781.4203, 896.4472, 953.4687, 1100.5371, 1197.5899, 1334.6488, 1465.6893, 1594.7319, 1709.7588, 1856.8272, 1970.8701, 2107.9291, 2235.9876, 2349.0717, 2509.1023, 2623.1453, 2722.2137, 2885.2770, 3000.3040, 3129.3465, 3266.4055, 3379.4895, 3494.5165, 3551.5379, 3664.6220, 3778.6649, 3892.7078, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 261.1557, 375.1987, 488.2827, 545.3042, 660.3311, 773.4152, 910.4741, 1039.5167, 1154.5436, 1317.6070, 1416.6754, 1530.7183, 1690.7490, 1803.8330, 1931.8916, 2068.9505, 2182.9934, 2330.0619, 2445.0888, 2574.1314, 2705.1719, 2842.2308, 2939.2836, 3086.3520, 3143.3734, 3258.4004, 3371.4844, 3468.5372, 3596.5958, 3724.6544, 3823.7228, 3951.7813, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"GTIEENEVMPLFLQVFEPSYPHTITELVETVFYR", {58.0287, 159.0764, 272.1605, 401.2031, 530.2457, 644.2886, 773.3312, 872.3996, 1003.4401, 1100.4929, 1213.5769, 1360.6453, 1473.7294, 1601.7880, 1700.8564, 1847.9248, 1976.9674, 2074.0202, 2161.0522, 2324.1155, 2421.1683, 2558.2272, 2659.2749, 2772.3589, 2873.4066, 3002.4492, 3115.5333, 3214.6017, 3343.6443, 3444.6920, 3543.7604, 3690.8288, 3853.8921, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 485.2507, 584.3191, 685.3668, 814.4094, 913.4778, 1026.5619, 1155.6045, 1256.6521, 1369.7362, 1470.7839, 1607.8428, 1704.8955, 1867.9589, 1954.9909, 2052.0437, 2181.0863, 2328.1547, 2427.2231, 2555.2817, 2668.3657, 2815.4341, 2928.5182, 3025.5710, 3156.6115, 3255.6799, 3384.7225, 3498.7654, 3627.8080, 3756.8506, 3869.9346, 3970.9823, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EKPVMTQLDEPPCWMLDTETLLPMDDDIPIYPAR", {130.0499, 258.1448, 355.1976, 454.2660, 585.3065, 686.3542, 814.4128, 927.4968, 1042.5238, 1171.5664, 1268.6191, 1365.6719, 1525.7025, 1711.7818, 1842.8223, 1955.9064, 2070.9333, 2171.9810, 2301.0236, 2402.0713, 2515.1553, 2628.2394, 2725.2922, 2856.3327, 2971.3596, 3086.3865, 3201.4135, 3314.4976, 3411.5503, 3524.6344, 3687.6977, 3784.7505, 3855.7876, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 246.1561, 343.2088, 506.2722, 619.3562, 716.4090, 829.4931, 944.5200, 1059.5469, 1174.5739, 1305.6144, 1402.6671, 1515.7512, 1628.8353, 1729.8829, 1858.9255, 1959.9732, 2075.0001, 2188.0842, 2319.1247, 2505.2040, 2665.2347, 2762.2874, 2859.3402, 2988.3828, 3103.4097, 3216.4938, 3344.5524, 3445.6000, 3576.6405, 3675.7089, 3772.7617, 3900.8567, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"WMYDEQEPASSITFPHWEYNAIAPINVFVYDGPR", {187.0866, 318.1271, 481.1904, 596.2173, 725.2599, 853.3185, 982.3611, 1079.4139, 1150.4510, 1237.4830, 1324.5150, 1437.5991, 1538.6468, 1685.7152, 1782.7680, 1919.8269, 2105.9062, 2234.9488, 2398.0121, 2512.0550, 2583.0922, 2696.1762, 2767.2133, 2864.2661, 2977.3502, 3091.3931, 3190.4615, 3337.5299, 3436.5983, 3599.6617, 3714.6886, 3771.7101, 3868.7628, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 272.1717, 329.1932, 444.2201, 607.2835, 706.3519, 853.4203, 952.4887, 1066.5316, 1179.6157, 1276.6684, 1347.7056, 1460.7896, 1531.8267, 1645.8697, 1808.9330, 1937.9756, 2124.0549, 2261.1138, 2358.1666, 2505.2350, 2606.2827, 2719.3667, 2806.3988, 2893.4308, 2964.4679, 3061.5207, 3190.5633, 3318.6218, 3447.6644, 3562.6914, 3725.7547, 3856.7952, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YLLDPNAPSQLFLMSVNLFCTLLFENYIAMSIFR", {164.0706, 277.1547, 390.2387, 505.2657, 602.3184, 716.3614, 787.3985, 884.4512, 971.4833, 1099.5419, 1212.6259, 1359.6943, 1472.7784, 1603.8189, 1690.8509, 1789.9193, 1903.9622, 2017.0463, 2164.1147, 2324.1454, 2425.1931, 2538.2771, 2651.3612, 2798.4296, 2927.4722, 3041.5151, 3204.5784, 3317.6625, 3388.6996, 3519.7401, 3606.7721, 3719.8562, 3866.9246, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 435.2714, 522.3035, 653.3439, 724.3811, 837.4651, 1000.5284, 1114.5714, 1243.6140, 1390.6824, 1503.7664, 1616.8505, 1717.8982, 1877.9288, 2024.9973, 2138.0813, 2252.1242, 2351.1927, 2438.2247, 2569.2652, 2682.3492, 2829.4176, 2942.5017, 3070.5603, 3157.5923, 3254.6451, 3325.6822, 3439.7251, 3536.7779, 3651.8048, 3764.8889, 3877.9730, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"AVVFLYEVDNEPTPTEGITTLTLTSWYFSYIYQR", {72.0444, 171.1128, 270.1812, 417.2496, 530.3337, 693.3970, 822.4396, 921.5080, 1036.5350, 1150.5779, 1279.6205, 1376.6733, 1477.7209, 1574.7737, 1675.8214, 1804.8640, 1861.8854, 1974.9695, 2076.0172, 2177.0649, 2290.1489, 2391.1966, 2504.2807, 2605.3283, 2692.3604, 2878.4397, 3041.5030, 3188.5714, 3275.6035, 3438.6668, 3551.7508, 3714.8142, 3842.8728, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 466.2409, 579.3249, 742.3883, 829.4203, 976.4887, 1139.5520, 1325.6313, 1412.6634, 1513.7110, 1626.7951, 1727.8428, 1840.9268, 1941.9745, 2043.0222, 2156.1063, 2213.1277, 2342.1703, 2443.2180, 2540.2708, 2641.3184, 2738.3712, 2867.4138, 2981.4567, 3096.4837, 3195.5521, 3324.5947, 3487.6580, 3600.7421, 3747.8105, 3846.8789, 3945.9473, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NYVWSDSSFGIEYSIAFYMCANWHILVLIALVVK", {115.0502, 278.1135, 377.1819, 563.2613, 650.2933, 765.3202, 852.3523, 939.3843, 1086.4527, 1143.4742, 1256.5582, 1385.6008, 1548.6642, 1635.6962, 1748.7802, 1819.8174, 1966.8858, 2129.9491, 2260.9896, 2421.0202, 2492.0573, 2606.1003, 2792.1796, 2929.2385, 3042.3226, 3155.4066, 3254.4750, 3367.5591, 3480.6432, 3551.6803, 3664.7643, 3763.8328, 3862.9012, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 246.1812, 345.2496, 458.3337, 529.3708, 642.4549, 755.5389, 854.6074, 967.6914, 1080.7755, 1217.8344, 1403.9137, 1517.9566, 1588.9937, 1749.0244, 1880.0649, 2043.1282, 2190.1966, 2261.2337, 2374.3178, 2461.3498, 2624.4132, 2753.4557, 2866.5398, 2923.5613, 3070.6297, 3157.6617, 3244.6937, 3359.7207, 3446.7527, 3632.8320, 3731.9004, 3894.9638, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LLNLIVDGEFQELCCLLQPIWPLWYSPPIGAVHK", {114.0913, 227.1754, 341.2183, 454.3024, 567.3865, 666.4549, 781.4818, 838.5033, 967.5459, 1114.6143, 1242.6729, 1371.7155, 1484.7995, 1644.8302, 1804.8608, 1917.9449, 2031.0289, 2159.0875, 2256.1403, 2369.2244, 2555.3037, 2652.3564, 2765.4405, 2951.5198, 3114.5831, 3201.6152, 3298.6679, 3395.7207, 3508.8048, 3565.8262, 3636.8633, 3735.9317, 3872.9907, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 284.1717, 383.2401, 454.2772, 511.2987, 624.3828, 721.4355, 818.4883, 905.5203, 1068.5837, 1254.6630, 1367.7470, 1464.7998, 1650.8791, 1763.9632, 1861.0159, 1989.0745, 2102.1586, 2215.2426, 2375.2733, 2535.3039, 2648.3880, 2777.4306, 2905.4892, 3052.5576, 3181.6002, 3238.6216, 3353.6486, 3452.7170, 3565.8011, 3678.8851, 3792.9281, 3906.0121, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ISWIRPFMSLWVSQALQTDIHCLQSTAVLMQDTR", {114.0913, 201.1234, 387.2027, 500.2867, 656.3879, 753.4406, 900.5090, 1031.5495, 1118.5815, 1231.6656, 1417.7449, 1516.8133, 1603.8454, 1731.9039, 1802.9411, 1916.0251, 2044.0837, 2145.1314, 2260.1583, 2373.2424, 2510.3013, 2670.3319, 2783.4160, 2911.4746, 2998.5066, 3099.5543, 3170.5914, 3269.6598, 3382.7439, 3513.7844, 3641.8429, 3756.8699, 3857.9176, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 276.1666, 391.1936, 519.2522, 650.2926, 763.3767, 862.4451, 933.4822, 1034.5299, 1121.5619, 1249.6205, 1362.7046, 1522.7352, 1659.7941, 1772.8782, 1887.9051, 1988.9528, 2117.0114, 2230.0955, 2301.1326, 2429.1912, 2516.2232, 2615.2916, 2801.3709, 2914.4550, 3001.4870, 3132.5275, 3279.5959, 3376.6487, 3532.7498, 3645.8338, 3831.9132, 3918.9452, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EHEICEICFGSLLNVVFFPLWCIIFVGMVIGLTK", {130.0499, 267.1088, 396.1514, 509.2354, 669.2661, 798.3087, 911.3927, 1071.4234, 1218.4918, 1275.5133, 1362.5453, 1475.6294, 1588.7134, 1702.7564, 1801.8248, 1900.8932, 2047.9616, 2195.0300, 2292.0828, 2405.1668, 2591.2462, 2751.2768, 2864.3609, 2977.4449, 3124.5133, 3223.5818, 3280.6032, 3411.6437, 3510.7121, 3623.7962, 3680.8176, 3793.9017, 3894.9494, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 248.1605, 361.2445, 418.2660, 531.3501, 630.4185, 761.4590, 818.4804, 917.5489, 1064.6173, 1177.7013, 1290.7854, 1450.8160, 1636.8954, 1749.9794, 1847.0322, 1994.1006, 2141.1690, 2240.2374, 2339.3058, 2453.3488, 2566.4328, 2679.5169, 2766.5489, 2823.5704, 2970.6388, 3130.6694, 3243.7535, 3372.7961, 3532.8268, 3645.9108, 3774.9534, 3912.0123, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TLDGGDDLIMNLPQGDPFVLTQEICWMYEEDTEGK", {102.0550, 215.1390, 330.1660, 387.1874, 444.2089, 559.2358, 674.2628, 787.3468, 900.4309, 1031.4714, 1145.5143, 1258.5984, 1355.6511, 1483.7097, 1540.7312, 1655.7581, 1752.8109, 1899.8793, 1998.9477, 2112.0318, 2213.0795, 2341.1380, 2470.1806, 2583.2647, 2743.2953, 2929.3747, 3060.4151, 3223.4785, 3352.5211, 3481.5637, 3596.5906, 3697.6383, 3826.6809, 3883.7023, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 204.1343, 333.1769, 434.2245, 549.2515, 678.2941, 807.3367, 970.4000, 1101.4405, 1287.5198, 1447.5504, 1560.6345, 1689.6771, 1817.7357, 1918.7834, 2031.8674, 2130.9358, 2278.0042, 2375.0570, 2490.0840, 2547.1054, 2675.1640, 2772.2168, 2885.3008, 2999.3438, 3130.3842, 3243.4683, 3356.5524, 3471.5793, 3586.6063, 3643.6277, 3700.6492, 3815.6761, 3928.7602, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"GPINGVMWILWETNNDPPVDLDVMMLTHYHEPDAK", {58.0287, 155.0815, 268.1656, 382.2085, 439.2300, 538.2984, 669.3389, 855.4182, 968.5022, 1081.5863, 1267.6656, 1396.7082, 1497.7559, 1611.7988, 1725.8417, 1840.8687, 1937.9214, 2034.9742, 2134.0426, 2249.0696, 2362.1536, 2477.1806, 2576.2490, 2707.2895, 2838.3300, 2951.4140, 3052.4617, 3189.5206, 3352.5839, 3489.6429, 3618.6854, 3715.7382, 3830.7652, 3901.8023, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 218.1499, 333.1769, 430.2296, 559.2722, 696.3311, 859.3945, 996.4534, 1097.5010, 1210.5851, 1341.6256, 1472.6661, 1571.7345, 1686.7614, 1799.8455, 1914.8724, 2013.9409, 2110.9936, 2208.0464, 2323.0733, 2437.1163, 2551.1592, 2652.2069, 2781.2495, 2967.3288, 3080.4128, 3193.4969, 3379.5762, 3510.6167, 3609.6851, 3666.7066, 3780.7495, 3893.8336, 3990.8863, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SSIQSGTSLQAYLGNGTQYGQYGVWQSWPPYWLYK", {88.0393, 175.0713, 288.1554, 416.2140, 503.2460, 560.2675, 661.3151, 748.3472, 861.4312, 989.4898, 1060.5269, 1223.5903, 1336.6743, 1393.6958, 1507.7387, 1564.7602, 1665.8079, 1793.8664, 1956.9298, 2013.9512, 2142.0098, 2305.0731, 2362.0946, 2461.1630, 2647.2423, 2775.3009, 2862.3329, 3048.4122, 3145.4650, 3242.5178, 3405.5811, 3591.6604, 3704.7445, 3867.8078, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 310.1761, 423.2602, 609.3395, 772.4028, 869.4556, 966.5084, 1152.5877, 1239.6197, 1367.6783, 1553.7576, 1652.8260, 1709.8475, 1872.9108, 2000.9694, 2057.9908, 2221.0542, 2349.1128, 2450.1604, 2507.1819, 2621.2248, 2678.2463, 2791.3303, 2954.3937, 3025.4308, 3153.4894, 3266.5734, 3353.6055, 3454.6531, 3511.6746, 3598.7066, 3726.7652, 3839.8493, 3926.8813, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SCLNDEIQLSSVLNDPCDLVSLGSQMRPDNWSTTR", {88.0393, 248.0700, 361.1540, 475.1969, 590.2239, 719.2665, 832.3505, 960.4091, 1073.4932, 1160.5252, 1247.5572, 1346.6257, 1459.7097, 1573.7526, 1688.7796, 1785.8324, 1945.8630, 2060.8899, 2173.9740, 2273.0424, 2360.0745, 2473.1585, 2530.1800, 2617.2120, 2745.2706, 2876.3111, 3032.4122, 3129.4649, 3244.4919, 3358.5348, 3544.6141, 3631.6462, 3732.6938, 3833.7415, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 276.1666, 377.2143, 464.2463, 650.3257, 764.3686, 879.3955, 976.4483, 1132.5494, 1263.5899, 1391.6485, 1478.6805, 1535.7020, 1648.7860, 1735.8180, 1834.8865, 1947.9705, 2062.9975, 2223.0281, 2320.0809, 2435.1078, 2549.1507, 2662.2348, 2761.3032, 2848.3353, 2935.3673, 3048.4513, 3176.5099, 3289.5940, 3418.6366, 3533.6635, 3647.7065, 3760.7905, 3920.8212, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TITFALLFINIPFLFNFVVIVCNGVSAVRPCTLQR", {102.0550, 215.1390, 316.1867, 463.2551, 534.2922, 647.3763, 760.4604, 907.5288, 1020.6128, 1134.6558, 1247.7398, 1344.7926, 1491.8610, 1604.9451, 1752.0135, 1866.0564, 2013.1248, 2112.1932, 2211.2616, 2324.3457, 2423.4141, 2583.4448, 2697.4877, 2754.5092, 2853.5776, 2940.6096, 3011.6467, 3110.7151, 3266.8162, 3363.8690, 3523.8997, 3624.9473, 3738.0314, 3866.0900, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 416.2616, 517.3093, 677.3399, 774.3927, 930.4938, 1029.5622, 1100.5993, 1187.6314, 1286.6998, 1343.7212, 1457.7642, 1617.7948, 1716.8632, 1829.9473, 1929.0157, 2028.0841, 2175.1525, 2289.1955, 2436.2639, 2549.3479, 2696.4163, 2793.4691, 2906.5532, 3020.5961, 3133.6802, 3280.7486, 3393.8326, 3506.9167, 3577.9538, 3725.0222, 3826.0699, 3939.1540, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PIGEVERPYFAEFMGEPPLCCEAIKPDNPDYAAVR", {98.0600, 211.1441, 268.1656, 397.2082, 496.2766, 625.3192, 781.4203, 878.4730, 1041.5364, 1188.6048, 1259.6419, 1388.6845, 1535.7529, 1666.7934, 1723.8149, 1852.8574, 1949.9102, 2046.9630, 2160.0470, 2320.0777, 2480.1083, 2609.1509, 2680.1880, 2793.2721, 2921.3671, 3018.4198, 3133.4468, 3247.4897, 3344.5425, 3459.5694, 3622.6327, 3693.6699, 3764.7070, 3863.7754, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 274.1874, 345.2245, 416.2616, 579.3249, 694.3519, 791.4046, 905.4476, 1020.4745, 1117.5273, 1245.6222, 1358.7063, 1429.7434, 1558.7860, 1718.8166, 1878.8473, 1991.9314, 2088.9841, 2186.0369, 2315.0795, 2372.1009, 2503.1414, 2650.2098, 2779.2524, 2850.2895, 2997.3580, 3160.4213, 3257.4741, 3413.5752, 3542.6178, 3641.6862, 3770.7288, 3827.7502, 3940.8343, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YPDLYSDGFQNDMETESTKPPANGGDFPYFNDLTR", {164.0706, 261.1234, 376.1503, 489.2344, 652.2977, 739.3297, 854.3567, 911.3781, 1058.4466, 1186.5051, 1300.5481, 1415.5750, 1546.6155, 1675.6581, 1776.7058, 1905.7484, 1992.7804, 2093.8281, 2221.9230, 2318.9758, 2416.0285, 2487.0657, 2601.1086, 2658.1301, 2715.1515, 2830.1785, 2977.2469, 3074.2996, 3237.3630, 3384.4314, 3498.4743, 3613.5013, 3726.5853, 3827.6330, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 276.1666, 389.2507, 504.2776, 618.3206, 765.3890, 928.4523, 1025.5051, 1172.5735, 1287.6004, 1344.6219, 1401.6434, 1515.6863, 1586.7234, 1683.7762, 1780.8289, 1908.9239, 2009.9716, 2097.0036, 2226.0462, 2327.0939, 2456.1365, 2587.1769, 2702.2039, 2816.2468, 2944.3054, 3091.3738, 3148.3953, 3263.4222, 3350.4542, 3513.5176, 3626.6016, 3741.6286, 3838.6813, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TLIGEENFFDCLEAYTLTHGGMEQEAQELSEQVAR", {102.0550, 215.1390, 328.2231, 385.2445, 514.2871, 643.3297, 757.3727, 904.4411, 1051.5095, 1166.5364, 1326.5671, 1439.6511, 1568.6937, 1639.7309, 1802.7942, 1903.8419, 2016.9259, 2117.9736, 2255.0325, 2312.0540, 2369.0754, 2500.1159, 2629.1585, 2757.2171, 2886.2597, 2957.2968, 3085.3554, 3214.3980, 3327.4820, 3414.5141, 3543.5567, 3671.6152, 3770.6836, 3841.7208, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 246.1561, 345.2245, 473.2831, 602.3257, 689.3577, 802.4417, 931.4843, 1059.5429, 1130.5800, 1259.6226, 1387.6812, 1516.7238, 1647.7643, 1704.7857, 1761.8072, 1898.8661, 1999.9138, 2112.9979, 2214.0455, 2377.1089, 2448.1460, 2577.1886, 2690.2726, 2850.3033, 2965.3302, 3112.3986, 3259.4671, 3373.5100, 3502.5526, 3631.5952, 3688.6166, 3801.7007, 3914.7848, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DSDTGCPPCEEEAIESIHEDDVSLQSESSETFEER", {116.0342, 203.0662, 318.0932, 419.1409, 476.1623, 636.1930, 733.2457, 830.2985, 990.3292, 1119.3718, 1248.4143, 1377.4569, 1448.4941, 1561.5781, 1690.6207, 1777.6527, 1890.7368, 2027.7957, 2156.8383, 2271.8652, 2386.8922, 2485.9606, 2572.9926, 2686.0767, 2814.1353, 2901.1673, 3030.2099, 3117.2419, 3204.2740, 3333.3165, 3434.3642, 3581.4326, 3710.4752, 3839.5178, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 433.2041, 580.2726, 681.3202, 810.3628, 897.3949, 984.4269, 1113.4695, 1200.5015, 1328.5601, 1441.6441, 1528.6762, 1627.7446, 1742.7715, 1857.7985, 1986.8411, 2123.9000, 2236.9840, 2324.0161, 2453.0587, 2566.1427, 2637.1798, 2766.2224, 2895.2650, 3024.3076, 3184.3383, 3281.3910, 3378.4438, 3538.4744, 3595.4959, 3696.5436, 3811.5705, 3898.6026, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LNWFKPLDQHSIPLVEGFVHWQVVPSCPPTTLSGK", {114.0913, 228.1343, 414.2136, 561.2820, 689.3770, 786.4297, 899.5138, 1014.5407, 1142.5993, 1279.6582, 1366.6902, 1479.7743, 1576.8271, 1689.9111, 1788.9796, 1918.0221, 1975.0436, 2122.1120, 2221.1804, 2358.2393, 2544.3187, 2672.3772, 2771.4457, 2870.5141, 2967.5668, 3054.5989, 3214.6295, 3311.6823, 3408.7350, 3509.7827, 3610.8304, 3723.9145, 3810.9465, 3867.9679, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 204.1343, 291.1663, 404.2504, 505.2980, 606.3457, 703.3985, 800.4512, 960.4819, 1047.5139, 1144.5667, 1243.6351, 1342.7035, 1470.7621, 1656.8414, 1793.9003, 1892.9687, 2040.0371, 2097.0586, 2226.1012, 2325.1696, 2438.2537, 2535.3064, 2648.3905, 2735.4225, 2872.4814, 3000.5400, 3115.5670, 3228.6510, 3325.7038, 3453.7988, 3600.8672, 3786.9465, 3900.9894, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SNIYINGGLNSLHLTLGFYIIILTLWIVLTLCTTR", {88.0393, 202.0822, 315.1663, 478.2296, 591.3137, 705.3566, 762.3781, 819.3995, 932.4836, 1046.5265, 1133.5586, 1246.6426, 1383.7015, 1496.7856, 1597.8333, 1710.9173, 1767.9388, 1915.0072, 2078.0706, 2191.1546, 2304.2387, 2417.3227, 2530.4068, 2631.4545, 2744.5386, 2930.6179, 3043.7019, 3142.7703, 3255.8544, 3356.9021, 3469.9861, 3630.0168, 3731.0645, 3832.1122, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 276.1666, 377.2143, 537.2450, 650.3290, 751.3767, 864.4608, 963.5292, 1076.6132, 1262.6926, 1375.7766, 1476.8243, 1589.9084, 1702.9924, 1816.0765, 1929.1606, 2092.2239, 2239.2923, 2296.3138, 2409.3978, 2510.4455, 2623.5296, 2760.5885, 2873.6725, 2960.7046, 3074.7475, 3187.8316, 3244.8530, 3301.8745, 3415.9174, 3529.0015, 3692.0648, 3805.1489, 3919.1918, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"GILNGYEVFIDFDTYSPVLGTQFIEEAMTTSFYHK", {58.0287, 171.1128, 284.1969, 398.2398, 455.2613, 618.3246, 747.3672, 846.4356, 993.5040, 1106.5881, 1221.6150, 1368.6834, 1483.7104, 1584.7581, 1747.8214, 1834.8534, 1931.9062, 2030.9746, 2144.0587, 2201.0801, 2302.1278, 2430.1864, 2577.2548, 2690.3388, 2819.3814, 2948.4240, 3019.4611, 3150.5016, 3251.5493, 3352.5970, 3439.6290, 3586.6974, 3749.7608, 3886.8197, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 284.1717, 447.2350, 594.3035, 681.3355, 782.3832, 883.4308, 1014.4713, 1085.5084, 1214.5510, 1343.5936, 1456.6777, 1603.7461, 1731.8047, 1832.8524, 1889.8738, 2002.9579, 2102.0263, 2199.0791, 2286.1111, 2449.1744, 2550.2221, 2665.2490, 2812.3175, 2927.3444, 3040.4285, 3187.4969, 3286.5653, 3415.6079, 3578.6712, 3635.6927, 3749.7356, 3862.8197, 3975.9037, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"CAACVIDQCDANCFEGHCETLEGTPYFGMATSCGR", {161.0379, 232.0750, 303.1122, 463.1428, 562.2112, 675.2953, 790.3222, 918.3808, 1078.4114, 1193.4384, 1264.4755, 1378.5184, 1538.5491, 1685.6175, 1814.6601, 1871.6816, 2008.7405, 2168.7711, 2297.8137, 2398.8614, 2511.9454, 2640.9880, 2698.0095, 2799.0572, 2896.1099, 3059.1733, 3206.2417, 3263.2632, 3394.3036, 3465.3408, 3566.3884, 3653.4205, 3813.4511, 3870.4726, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 232.1404, 392.1711, 479.2031, 580.2508, 651.2879, 782.3284, 839.3498, 986.4182, 1149.4816, 1246.5343, 1347.5820, 1404.6035, 1533.6461, 1646.7301, 1747.7778, 1876.8204, 2036.8511, 2173.9100, 2230.9314, 2359.9740, 2507.0424, 2667.0731, 2781.1160, 2852.1531, 2967.1801, 3127.2107, 3255.2693, 3370.2962, 3483.3803, 3582.4487, 3742.4794, 3813.5165, 3884.5536, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EWYSPIDHESHSSDQFDLSEFDVTEMLPAVHAVPK", {130.0499, 316.1292, 479.1925, 566.2245, 663.2773, 776.3614, 891.3883, 1028.4472, 1157.4898, 1244.5218, 1381.5808, 1468.6128, 1555.6448, 1670.6718, 1798.7303, 1945.7987, 2060.8257, 2173.9098, 2260.9418, 2389.9844, 2537.0528, 2652.0797, 2751.1481, 2852.1958, 2981.2384, 3112.2789, 3225.3630, 3322.4157, 3393.4528, 3492.5213, 3629.5802, 3700.6173, 3799.6857, 3896.7385, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 244.1656, 343.2340, 414.2711, 551.3300, 650.3984, 721.4355, 818.4883, 931.5724, 1062.6128, 1191.6554, 1292.7031, 1391.7715, 1506.7985, 1653.8669, 1782.9095, 1869.9415, 1983.0256, 2098.0525, 2245.1209, 2373.1795, 2488.2065, 2575.2385, 2662.2705, 2799.3294, 2886.3615, 3015.4040, 3152.4630, 3267.4899, 3380.5740, 3477.6267, 3564.6588, 3727.7221, 3913.8014, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SLSGSCVLFTITHFLYPVSTAVDLCNNFSLMLLYR", {88.0393, 201.1234, 288.1554, 345.1769, 432.2089, 592.2395, 691.3080, 804.3920, 951.4604, 1052.5081, 1165.5922, 1266.6399, 1403.6988, 1550.7672, 1663.8512, 1826.9146, 1923.9673, 2023.0357, 2110.0678, 2211.1155, 2282.1526, 2381.2210, 2496.2479, 2609.3320, 2769.3626, 2883.4056, 2997.4485, 3144.5169, 3231.5489, 3344.6330, 3475.6735, 3588.7575, 3701.8416, 3864.9049, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 451.2663, 564.3504, 695.3909, 808.4750, 895.5070, 1042.5754, 1156.6183, 1270.6613, 1430.6919, 1543.7760, 1658.8029, 1757.8713, 1828.9084, 1929.9561, 2016.9881, 2116.0566, 2213.1093, 2376.1727, 2489.2567, 2636.3251, 2773.3840, 2874.4317, 2987.5158, 3088.5635, 3235.6319, 3348.7159, 3447.7844, 3607.8150, 3694.8470, 3751.8685, 3838.9005, 3951.9846, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NTISLTFQNDDVLCVEEIESAYYVDNLLVSHALVK", {115.0502, 216.0979, 329.1819, 416.2140, 529.2980, 630.3457, 777.4141, 905.4727, 1019.5156, 1134.5426, 1249.5695, 1348.6379, 1461.7220, 1621.7526, 1720.8211, 1849.8637, 1978.9062, 2091.9903, 2221.0329, 2308.0649, 2379.1020, 2542.1654, 2705.2287, 2804.2971, 2919.3241, 3033.3670, 3146.4511, 3259.5351, 3358.6035, 3445.6356, 3582.6945, 3653.7316, 3766.8157, 3865.8841, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 246.1812, 359.2653, 430.3024, 567.3613, 654.3933, 753.4618, 866.5458, 979.6299, 1093.6728, 1208.6997, 1307.7682, 1470.8315, 1633.8948, 1704.9319, 1791.9640, 1921.0066, 2034.0906, 2163.1332, 2292.1758, 2391.2442, 2551.2749, 2664.3589, 2763.4273, 2878.4543, 2993.4812, 3107.5242, 3235.5827, 3382.6512, 3483.6988, 3596.7829, 3683.8149, 3796.8990, 3897.9467, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DDLTHPSHSALVLPNNIGWSPPHLYHPYNSYIEAR", {116.0342, 231.0612, 344.1452, 445.1929, 582.2518, 679.3046, 766.3366, 903.3955, 990.4275, 1061.4647, 1174.5487, 1273.6171, 1386.7012, 1483.7540, 1597.7969, 1711.8398, 1824.9239, 1881.9454, 2068.0247, 2155.0567, 2252.1095, 2349.1622, 2486.2211, 2599.3052, 2762.3685, 2899.4274, 2996.4802, 3159.5435, 3273.5865, 3360.6185, 3523.6818, 3636.7659, 3765.8085, 3836.8456, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 246.1561, 375.1987, 488.2827, 651.3461, 738.3781, 852.4210, 1015.4843, 1112.5371, 1249.5960, 1412.6593, 1525.7434, 1662.8023, 1759.8551, 1856.9078, 1943.9399, 2130.0192, 2187.0406, 2300.1247, 2414.1676, 2528.2106, 2625.2633, 2738.3474, 2837.4158, 2950.4999, 3021.5370, 3108.5690, 3245.6279, 3332.6600, 3429.7127, 3566.7716, 3667.8193, 3780.9034, 3895.9303, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"AEILHQQQPYLNDAVPQQSNPNNPDDEPNSITWSR", {72.0444, 201.0870, 314.1710, 427.2551, 564.3140, 692.3726, 820.4312, 948.4898, 1045.5425, 1208.6058, 1321.6899, 1435.7328, 1550.7598, 1621.7969, 1720.8653, 1817.9181, 1945.9767, 2074.0352, 2161.0673, 2275.1102, 2372.1629, 2486.2059, 2600.2488, 2697.3016, 2812.3285, 2927.3555, 3056.3980, 3153.4508, 3267.4937, 3354.5258, 3467.6098, 3568.6575, 3754.7368, 3841.7689, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 262.1510, 448.2303, 549.2780, 662.3620, 749.3941, 863.4370, 960.4898, 1089.5323, 1204.5593, 1319.5862, 1416.6390, 1530.6819, 1644.7249, 1741.7776, 1855.8205, 1942.8526, 2070.9112, 2198.9697, 2296.0225, 2395.0909, 2466.1280, 2581.1550, 2695.1979, 2808.2820, 2971.3453, 3068.3980, 3196.4566, 3324.5152, 3452.5738, 3589.6327, 3702.7168, 3815.8008, 3944.8434, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ALVVQFLCPHQQTGVENSAWCSLTGYDQDTVPTYK", {72.0444, 185.1285, 284.1969, 383.2653, 511.3239, 658.3923, 771.4763, 931.5070, 1028.5598, 1165.6187, 1293.6772, 1421.7358, 1522.7835, 1579.8050, 1678.8734, 1807.9160, 1921.9589, 2008.9909, 2080.0280, 2266.1073, 2426.1380, 2513.1700, 2626.2541, 2727.3018, 2784.3232, 2947.3866, 3062.4135, 3190.4721, 3305.4990, 3406.5467, 3505.6151, 3602.6679, 3703.7156, 3866.7789, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 310.1761, 411.2238, 508.2766, 607.3450, 708.3927, 823.4196, 951.4782, 1066.5051, 1229.5685, 1286.5899, 1387.6376, 1500.7217, 1587.7537, 1747.7843, 1933.8637, 2004.9008, 2091.9328, 2205.9757, 2335.0183, 2434.0867, 2491.1082, 2592.1559, 2720.2145, 2848.2730, 2985.3319, 3082.3847, 3242.4154, 3355.4994, 3502.5678, 3630.6264, 3729.6948, 3828.7632, 3941.8473, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"GCPPANPLLQQMHPVAYDQCVIDPVDTYDPSVHQR", {58.0287, 218.0594, 315.1122, 412.1649, 483.2020, 597.2450, 694.2977, 807.3818, 920.4658, 1048.5244, 1176.5830, 1307.6235, 1444.6824, 1541.7352, 1640.8036, 1711.8407, 1874.9040, 1989.9310, 2117.9895, 2278.0202, 2377.0886, 2490.1727, 2605.1996, 2702.2524, 2801.3208, 2916.3477, 3017.3954, 3180.4587, 3295.4857, 3392.5384, 3479.5705, 3578.6389, 3715.6978, 3843.7564, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 440.2364, 539.3049, 626.3369, 723.3896, 838.4166, 1001.4799, 1102.5276, 1217.5545, 1316.6230, 1413.6757, 1528.7027, 1641.7867, 1740.8551, 1900.8858, 2028.9444, 2143.9713, 2307.0346, 2378.0718, 2477.1402, 2574.1929, 2711.2518, 2842.2923, 2970.3509, 3098.4095, 3211.4935, 3324.5776, 3421.6304, 3535.6733, 3606.7104, 3703.7632, 3800.8159, 3960.8466, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QDDDYHTELQDADILQEDLPESSLEVHVTSQDSTK", {129.0659, 244.0928, 359.1197, 474.1467, 637.2100, 774.2689, 875.3166, 1004.3592, 1117.4433, 1245.5018, 1360.5288, 1431.5659, 1546.5928, 1659.6769, 1772.7610, 1900.8195, 2029.8621, 2144.8891, 2257.9731, 2355.0259, 2484.0685, 2571.1005, 2658.1326, 2771.2166, 2900.2592, 2999.3276, 3136.3865, 3235.4550, 3336.5026, 3423.5347, 3551.5932, 3666.6202, 3753.6522, 3854.6999, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 248.1605, 335.1925, 450.2195, 578.2780, 665.3101, 766.3577, 865.4262, 1002.4851, 1101.5535, 1230.5961, 1343.6801, 1430.7122, 1517.7442, 1646.7868, 1743.8395, 1856.9236, 1971.9506, 2100.9931, 2229.0517, 2342.1358, 2455.2199, 2570.2468, 2641.2839, 2756.3109, 2884.3694, 2997.4535, 3126.4961, 3227.5438, 3364.6027, 3527.6660, 3642.6930, 3757.7199, 3872.7468, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DSTYIIYTNELSQTDNLVGMLTVVLEDVALLTEWR", {116.0342, 203.0662, 304.1139, 467.1773, 580.2613, 693.3454, 856.4087, 957.4564, 1071.4993, 1200.5419, 1313.6260, 1400.6580, 1528.7166, 1629.7643, 1744.7912, 1858.8341, 1971.9182, 2070.9866, 2128.0081, 2259.0486, 2372.1326, 2473.1803, 2572.2487, 2671.3171, 2784.4012, 2913.4438, 3028.4707, 3127.5391, 3198.5763, 3311.6603, 3424.7444, 3525.7921, 3654.8347, 3840.9140, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 361.1983, 490.2409, 591.2885, 704.3726, 817.4567, 888.4938, 987.5622, 1102.5891, 1231.6317, 1344.7158, 1443.7842, 1542.8526, 1643.9003, 1756.9844, 1888.0248, 1945.0463, 2044.1147, 2157.1988, 2271.2417, 2386.2687, 2487.3163, 2615.3749, 2702.4069, 2815.4910, 2944.5336, 3058.5765, 3159.6242, 3322.6875, 3435.7716, 3548.8557, 3711.9190, 3812.9667, 3899.9987, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TTLAMQYNAVNLIVSSLQLIETFIALWVDNFTNEK", {102.0550, 203.1026, 316.1867, 387.2238, 518.2643, 646.3229, 809.3862, 923.4291, 994.4662, 1093.5347, 1207.5776, 1320.6616, 1433.7457, 1532.8141, 1619.8462, 1706.8782, 1819.9622, 1948.0208, 2061.1049, 2174.1890, 2303.2315, 2404.2792, 2551.3476, 2664.4317, 2735.4688, 2848.5529, 3034.6322, 3133.7006, 3248.7276, 3362.7705, 3509.8389, 3610.8866, 3724.9295, 3853.9721, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 276.1554, 390.1983, 491.2460, 638.3144, 752.3573, 867.3843, 966.4527, 1152.5320, 1265.6161, 1336.6532, 1449.7373, 1596.8057, 1697.8533, 1826.8959, 1939.9800, 2053.0641, 2181.1226, 2294.2067, 2381.2387, 2468.2708, 2567.3392, 2680.4232, 2793.5073, 2907.5502, 3006.6187, 3077.6558, 3191.6987, 3354.7620, 3482.8206, 3613.8611, 3684.8982, 3797.9823, 3899.0299, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SFHTTSLQEMIAFAIEEGVVLLFTVAVDHYGQYYR", {88.0393, 235.1077, 372.1666, 473.2143, 574.2620, 661.2940, 774.3781, 902.4367, 1031.4793, 1162.5197, 1275.6038, 1346.6409, 1493.7093, 1564.7464, 1677.8305, 1806.8731, 1935.9157, 1992.9372, 2092.0056, 2191.0740, 2304.1580, 2417.2421, 2564.3105, 2665.3582, 2764.4266, 2835.4637, 2934.5321, 3049.5591, 3186.6180, 3349.6813, 3406.7028, 3534.7614, 3697.8247, 3860.8880, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 501.2456, 629.3042, 686.3257, 849.3890, 986.4479, 1101.4748, 1200.5432, 1271.5804, 1370.6488, 1471.6965, 1618.7649, 1731.8489, 1844.9330, 1944.0014, 2043.0698, 2100.0913, 2229.1339, 2358.1765, 2471.2605, 2542.2977, 2689.3661, 2760.4032, 2873.4872, 3004.5277, 3133.5703, 3261.6289, 3374.7130, 3461.7450, 3562.7927, 3663.8403, 3800.8993, 3947.9677, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NNVLIDCGGLQEEIWDFAATVSDLDEVDCHIAHLR", {115.0502, 229.0931, 328.1615, 441.2456, 554.3297, 669.3566, 829.3873, 886.4087, 943.4302, 1056.5143, 1184.5728, 1313.6154, 1442.6580, 1555.7421, 1741.8214, 1856.8483, 2003.9168, 2074.9539, 2145.9910, 2247.0387, 2346.1071, 2433.1391, 2548.1660, 2661.2501, 2776.2771, 2905.3196, 3004.3881, 3119.4150, 3279.4457, 3416.5046, 3529.5886, 3600.6257, 3737.6847, 3850.7687, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 425.2619, 496.2990, 609.3831, 746.4420, 906.4727, 1021.4996, 1120.5680, 1249.6106, 1364.6376, 1477.7216, 1592.7486, 1679.7806, 1778.8490, 1879.8967, 1950.9338, 2021.9709, 2169.0393, 2284.0663, 2470.1456, 2583.2296, 2712.2722, 2841.3148, 2969.3734, 3082.4575, 3139.4789, 3196.5004, 3356.5311, 3471.5580, 3584.6421, 3697.7261, 3796.7945, 3910.8375, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FTSVNHYHAVLLYPMTFLTSYMIGATWSFVIVSLK", {148.0757, 249.1234, 336.1554, 435.2238, 549.2667, 686.3257, 849.3890, 986.4479, 1057.4850, 1156.5534, 1269.6375, 1382.7215, 1545.7849, 1642.8376, 1773.8781, 1874.9258, 2021.9942, 2135.0783, 2236.1260, 2323.1580, 2486.2213, 2617.2618, 2730.3459, 2787.3673, 2858.4044, 2959.4521, 3145.5314, 3232.5635, 3379.6319, 3478.7003, 3591.7844, 3690.8528, 3777.8848, 3890.9689, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 347.2289, 446.2973, 559.3814, 658.4498, 805.5182, 892.5502, 1078.6295, 1179.6772, 1250.7143, 1307.7358, 1420.8199, 1551.8603, 1714.9237, 1801.9557, 1903.0034, 2016.0874, 2163.1559, 2264.2035, 2395.2440, 2492.2968, 2655.3601, 2768.4442, 2881.5282, 2980.5967, 3051.6338, 3188.6927, 3351.7560, 3488.8149, 3602.8579, 3701.9263, 3788.9583, 3890.0060, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"GNAIAIIPVLCVNFMLLFFYNMFCAAELILVTDQK", {58.0287, 172.0717, 243.1088, 356.1928, 427.2300, 540.3140, 653.3981, 750.4509, 849.5193, 962.6033, 1122.6340, 1221.7024, 1335.7453, 1482.8137, 1613.8542, 1726.9383, 1840.0223, 1987.0908, 2134.1592, 2297.2225, 2411.2654, 2542.3059, 2689.3743, 2849.4050, 2920.4421, 2991.4792, 3120.5218, 3233.6059, 3346.6899, 3459.7740, 3558.8424, 3659.8901, 3774.9170, 3902.9756, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 275.1714, 390.1983, 491.2460, 590.3144, 703.3985, 816.4825, 929.5666, 1058.6092, 1129.6463, 1200.6834, 1360.7141, 1507.7825, 1638.8230, 1752.8659, 1915.9292, 2062.9976, 2210.0661, 2323.1501, 2436.2342, 2567.2747, 2714.3431, 2828.3860, 2927.4544, 3087.4851, 3200.5691, 3299.6376, 3396.6903, 3509.7744, 3622.8584, 3693.8956, 3806.9796, 3878.0167, 3992.0597, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FYLGLLSQLIDFVLYENMIGETAVFVGEAVLIFFR", {148.0757, 311.1390, 424.2231, 481.2445, 594.3286, 707.4127, 794.4447, 922.5033, 1035.5873, 1148.6714, 1263.6984, 1410.7668, 1509.8352, 1622.9192, 1785.9826, 1915.0252, 2029.0681, 2160.1086, 2273.1926, 2330.2141, 2459.2567, 2560.3044, 2631.3415, 2730.4099, 2877.4783, 2976.5467, 3033.5682, 3162.6108, 3233.6479, 3332.7163, 3445.8004, 3558.8844, 3705.9529, 3853.0213, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 469.2558, 582.3398, 695.4239, 794.4923, 865.5294, 994.5720, 1051.5935, 1150.6619, 1297.7303, 1396.7987, 1467.8358, 1568.8835, 1697.9261, 1754.9476, 1868.0316, 1999.0721, 2113.1151, 2242.1577, 2405.2210, 2518.3050, 2617.3735, 2764.4419, 2879.4688, 2992.5529, 3105.6369, 3233.6955, 3320.7276, 3433.8116, 3546.8957, 3603.9171, 3717.0012, 3880.0645, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"IPEIVSEDLSINIEMSSEHNQAEFYEGFTDLLNLK", {114.0913, 211.1441, 340.1867, 453.2708, 552.3392, 639.3712, 768.4138, 883.4407, 996.5248, 1083.5568, 1196.6409, 1310.6838, 1423.7679, 1552.8105, 1683.8510, 1770.8830, 1857.9150, 1986.9576, 2124.0165, 2238.0595, 2366.1180, 2437.1551, 2566.1977, 2713.2662, 2876.3295, 3005.3721, 3062.3935, 3209.4620, 3310.5096, 3425.5366, 3538.6206, 3651.7047, 3765.7476, 3878.8317, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 374.2398, 487.3239, 600.4079, 715.4349, 816.4825, 963.5510, 1020.5724, 1149.6150, 1312.6783, 1459.7468, 1588.7894, 1659.8265, 1787.8850, 1901.9280, 2038.9869, 2168.0295, 2255.0615, 2342.0935, 2473.1340, 2602.1766, 2715.2607, 2829.3036, 2942.3877, 3029.4197, 3142.5038, 3257.5307, 3386.5733, 3473.6053, 3572.6737, 3685.7578, 3814.8004, 3911.8532, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"HPHPHSGPQPHPHEQGSLEQVDHHSHLLHLQEVPR", {138.0662, 235.1190, 372.1779, 469.2306, 606.2895, 693.3216, 750.3430, 847.3958, 975.4544, 1072.5071, 1209.5660, 1306.6188, 1443.6777, 1572.7203, 1700.7789, 1757.8004, 1844.8324, 1957.9165, 2086.9590, 2215.0176, 2314.0860, 2429.1130, 2566.1719, 2703.2308, 2790.2628, 2927.3217, 3040.4058, 3153.4899, 3290.5488, 3403.6328, 3531.6914, 3660.7340, 3759.8024, 3856.8552, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 272.1717, 371.2401, 500.2827, 628.3413, 741.4254, 878.4843, 991.5683, 1104.6524, 1241.7113, 1328.7433, 1465.8023, 1602.8612, 1717.8881, 1816.9565, 1945.0151, 2074.0577, 2187.1418, 2274.1738, 2331.1953, 2459.2538, 2588.2964, 2725.3553, 2822.4081, 2959.4670, 3056.5198, 3184.5784, 3281.6311, 3338.6526, 3425.6846, 3562.7435, 3659.7963, 3796.8552, 3893.9080, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LYELNANNLENLLEQSSNLIQICLSHLESQALSIK", {114.0913, 277.1547, 406.1973, 519.2813, 633.3243, 704.3614, 818.4043, 932.4472, 1045.5313, 1174.5739, 1288.6168, 1401.7009, 1514.7849, 1643.8275, 1771.8861, 1858.9181, 1945.9502, 2059.9931, 2173.0772, 2286.1612, 2414.2198, 2527.3039, 2687.3345, 2800.4186, 2887.4506, 3024.5095, 3137.5936, 3266.6362, 3353.6682, 3481.7268, 3552.7639, 3665.8480, 3752.8800, 3865.9640, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 347.2289, 460.3130, 531.3501, 659.4087, 746.4407, 875.4833, 988.5673, 1125.6262, 1212.6583, 1325.7423, 1485.7730, 1598.8571, 1726.9156, 1839.9997, 1953.0838, 2067.1267, 2154.1587, 2241.1907, 2369.2493, 2498.2919, 2611.3760, 2724.4600, 2838.5030, 2967.5456, 3080.6296, 3194.6726, 3308.7155, 3379.7526, 3493.7955, 3606.8796, 3735.9222, 3898.9855, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YQPLDLDATELDELLSTHLVELFSSFNALLHNAYK", {164.0706, 292.1292, 389.1819, 502.2660, 617.2930, 730.3770, 845.4040, 916.4411, 1017.4888, 1146.5313, 1259.6154, 1374.6424, 1503.6849, 1616.7690, 1729.8531, 1816.8851, 1917.9328, 2054.9917, 2168.0758, 2267.1442, 2396.1868, 2509.2708, 2656.3392, 2743.3713, 2830.4033, 2977.4717, 3091.5146, 3162.5518, 3275.6358, 3388.7199, 3525.7788, 3639.8217, 3710.8588, 3873.9222, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 310.1761, 381.2132, 495.2562, 632.3151, 745.3991, 858.4832, 929.5203, 1043.5633, 1190.6317, 1277.6637, 1364.6957, 1511.7641, 1624.8482, 1753.8908, 1852.9592, 1966.0433, 2103.1022, 2204.1499, 2291.1819, 2404.2660, 2517.3500, 2646.3926, 2761.4196, 2874.5036, 3003.5462, 3104.5939, 3175.6310, 3290.6580, 3403.7420, 3518.7690, 3631.8530, 3728.9058, 3856.9644, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ESETEMPEGADNPQDYFENLQPYLTNVATTPQLLR", {130.0499, 217.0819, 346.1245, 447.1722, 576.2148, 707.2552, 804.3080, 933.3506, 990.3721, 1061.4092, 1176.4361, 1290.4791, 1387.5318, 1515.5904, 1630.6173, 1793.6807, 1940.7491, 2069.7917, 2183.8346, 2296.9187, 2424.9772, 2522.0300, 2685.0933, 2798.1774, 2899.2251, 3013.2680, 3112.3364, 3183.3735, 3284.4212, 3385.4689, 3482.5217, 3610.5802, 3723.6643, 3836.7484, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 401.2871, 529.3457, 626.3984, 727.4461, 828.4938, 899.5309, 998.5993, 1112.6422, 1213.6899, 1326.7740, 1489.8373, 1586.8901, 1714.9486, 1828.0327, 1942.0756, 2071.1182, 2218.1866, 2381.2500, 2496.2769, 2624.3355, 2721.3883, 2835.4312, 2950.4581, 3021.4952, 3078.5167, 3207.5593, 3304.6121, 3435.6525, 3564.6951, 3665.7428, 3794.7854, 3881.8174, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TQEELLGQVNELWYHDIAGEPDLLEVMSQEVASIR", {102.0550, 230.1135, 359.1561, 488.1987, 601.2828, 714.3668, 771.3883, 899.4469, 998.5153, 1112.5582, 1241.6008, 1354.6849, 1540.7642, 1703.8275, 1840.8864, 1955.9134, 2068.9974, 2140.0346, 2197.0560, 2326.0986, 2423.1514, 2538.1783, 2651.2624, 2764.3465, 2893.3890, 2992.4575, 3123.4979, 3210.5300, 3338.5886, 3467.6311, 3566.6996, 3637.7367, 3724.7687, 3837.8528, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 375.2350, 446.2722, 545.3406, 674.3832, 802.4417, 889.4738, 1020.5143, 1119.5827, 1248.6253, 1361.7093, 1474.7934, 1589.8203, 1686.8731, 1815.9157, 1872.9372, 1943.9743, 2057.0583, 2172.0853, 2309.1442, 2472.2075, 2658.2868, 2771.3709, 2900.4135, 3014.4564, 3113.5248, 3241.5834, 3298.6049, 3411.6889, 3524.7730, 3653.8156, 3782.8582, 3910.9168, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"GGTLTLHLPLQAYIQFYPAHYNTSLMQLQQLATDR", {58.0287, 115.0502, 216.0979, 329.1819, 430.2296, 543.3137, 680.3726, 793.4567, 890.5094, 1003.5935, 1131.6521, 1202.6892, 1365.7525, 1478.8366, 1606.8952, 1753.9636, 1917.0269, 2014.0797, 2085.1168, 2222.1757, 2385.2390, 2499.2819, 2600.3296, 2687.3616, 2800.4457, 2931.4862, 3059.5448, 3172.6288, 3300.6874, 3428.7460, 3541.8301, 3612.8672, 3713.9149, 3828.9418, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 290.1459, 391.1936, 462.2307, 575.3148, 703.3733, 831.4319, 944.5160, 1072.5745, 1203.6150, 1316.6991, 1403.7311, 1504.7788, 1618.8217, 1781.8851, 1918.9440, 1989.9811, 2087.0338, 2250.0972, 2397.1656, 2525.2242, 2638.3082, 2801.3716, 2872.4087, 3000.4673, 3113.5513, 3210.6041, 3323.6881, 3460.7471, 3573.8311, 3674.8788, 3787.9629, 3889.0105, 3946.0320, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LIPDLGTFNNLLCICILENINVLAETNLHLTPMIK", {114.0913, 227.1754, 324.2282, 439.2551, 552.3392, 609.3606, 710.4083, 857.4767, 971.5197, 1085.5626, 1198.6467, 1311.7307, 1471.7614, 1584.8454, 1744.8761, 1857.9601, 1971.0442, 2100.0868, 2214.1297, 2327.2138, 2441.2567, 2540.3251, 2653.4092, 2724.4463, 2853.4889, 2954.5366, 3068.5795, 3181.6636, 3318.7225, 3431.8065, 3532.8542, 3629.9070, 3760.9475, 3874.0315, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 391.2374, 488.2901, 589.3378, 702.4219, 839.4808, 952.5648, 1066.6078, 1167.6554, 1296.6980, 1367.7351, 1480.8192, 1579.8876, 1693.9306, 1807.0146, 1921.0575, 2050.1001, 2163.1842, 2276.2683, 2436.2989, 2549.3830, 2709.4136, 2822.4977, 2935.5818, 3049.6247, 3163.6676, 3310.7360, 3411.7837, 3468.8052, 3581.8892, 3696.9162, 3793.9689, 3907.0530, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FHCEFTEAYSAAFQVLTNSVVIFIDASEANELFDK", {148.0757, 285.1346, 445.1653, 574.2078, 721.2763, 822.3239, 951.3665, 1022.4036, 1185.4670, 1272.4990, 1343.5361, 1414.5732, 1561.6416, 1689.7002, 1788.7686, 1901.8527, 2002.9004, 2116.9433, 2203.9753, 2303.0437, 2402.1122, 2515.1962, 2662.2646, 2775.3487, 2890.3756, 2961.4128, 3048.4448, 3177.4874, 3248.5245, 3362.5674, 3491.6100, 3604.6941, 3751.7625, 3866.7894, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 262.1397, 409.2082, 522.2922, 651.3348, 765.3777, 836.4149, 965.4575, 1052.4895, 1123.5266, 1238.5535, 1351.6376, 1498.7060, 1611.7901, 1710.8585, 1809.9269, 1896.9589, 2011.0019, 2112.0495, 2225.1336, 2324.2020, 2452.2606, 2599.3290, 2670.3661, 2741.4032, 2828.4353, 2991.4986, 3062.5357, 3191.5783, 3292.6260, 3439.6944, 3568.7370, 3728.7676, 3865.8265, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EANGIAYWICALWHAILIFTAMLLILVAAGYESYR", {130.0499, 201.0870, 315.1299, 372.1514, 485.2354, 556.2726, 719.3359, 905.4152, 1018.4993, 1178.5299, 1249.5670, 1362.6511, 1548.7304, 1685.7893, 1756.8264, 1869.9105, 1982.9946, 2096.0786, 2243.1470, 2344.1947, 2415.2318, 2546.2723, 2659.3564, 2772.4404, 2885.5245, 2998.6086, 3097.6770, 3168.7141, 3239.7512, 3296.7727, 3459.8360, 3588.8786, 3675.9106, 3838.9739, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 425.2143, 554.2569, 717.3202, 774.3417, 845.3788, 916.4159, 1015.4843, 1128.5684, 1241.6525, 1354.7365, 1467.8206, 1598.8611, 1669.8982, 1770.9459, 1918.0143, 2031.0983, 2144.1824, 2257.2665, 2328.3036, 2465.3625, 2651.4418, 2764.5259, 2835.5630, 2995.5936, 3108.6777, 3294.7570, 3457.8203, 3528.8575, 3641.9415, 3698.9630, 3813.0059, 3884.0430, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"GTEDYGYIDDGFIYEWLHGLVPADAWTHEANFGVR", {58.0287, 159.0764, 288.1190, 403.1460, 566.2093, 623.2307, 786.2941, 899.3781, 1014.4051, 1129.4320, 1186.4535, 1333.5219, 1446.6060, 1609.6693, 1738.7119, 1924.7912, 2037.8753, 2174.9342, 2231.9556, 2345.0397, 2444.1081, 2541.1609, 2612.1980, 2727.2249, 2798.2621, 2984.3414, 3085.3890, 3222.4480, 3351.4906, 3422.5277, 3536.5706, 3683.6390, 3740.6605, 3839.7289, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 274.1874, 331.2088, 478.2772, 592.3202, 663.3573, 792.3999, 929.4588, 1030.5065, 1216.5858, 1287.6229, 1402.6498, 1473.6870, 1570.7397, 1669.8081, 1782.8922, 1839.9137, 1976.9726, 2090.0566, 2276.1359, 2405.1785, 2568.2419, 2681.3259, 2828.3943, 2885.4158, 3000.4428, 3115.4697, 3228.5538, 3391.6171, 3448.6386, 3611.7019, 3726.7288, 3855.7714, 3956.8191, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ETRPEYITETYSEISSLSSARPLWNETSDMTDQGR", {130.0499, 231.0975, 387.1987, 484.2514, 613.2940, 776.3573, 889.4414, 990.4891, 1119.5317, 1220.5794, 1383.6427, 1470.6747, 1599.7173, 1712.8014, 1799.8334, 1886.8654, 1999.9495, 2086.9815, 2174.0136, 2245.0507, 2401.1518, 2498.2045, 2611.2886, 2797.3679, 2911.4108, 3040.4534, 3141.5011, 3228.5331, 3343.5601, 3474.6006, 3575.6483, 3690.6752, 3818.7338, 3875.7552, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 232.1404, 360.1990, 475.2259, 576.2736, 707.3141, 822.3410, 909.3731, 1010.4207, 1139.4633, 1253.5063, 1439.5856, 1552.6696, 1649.7224, 1805.8235, 1876.8606, 1963.8927, 2050.9247, 2164.0088, 2251.0408, 2338.0728, 2451.1569, 2580.1995, 2667.2315, 2830.2948, 2931.3425, 3060.3851, 3161.4328, 3274.5168, 3437.5802, 3566.6228, 3663.6755, 3819.7766, 3920.8243, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VVVDLTLDLPLFSGCVIFLALAVTWILFSFLFQYK", {100.0757, 199.1441, 298.2125, 413.2395, 526.3235, 627.3712, 740.4553, 855.4822, 968.5663, 1065.6190, 1178.7031, 1325.7715, 1412.8035, 1469.8250, 1629.8557, 1728.9241, 1842.0081, 1989.0765, 2102.1606, 2173.1977, 2286.2818, 2357.3189, 2456.3873, 2557.4350, 2743.5143, 2856.5984, 2969.6824, 3116.7509, 3203.7829, 3350.8513, 3463.9354, 3611.0038, 3739.0624, 3902.1257, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 310.1761, 438.2347, 585.3031, 698.3872, 845.4556, 932.4876, 1079.5560, 1192.6401, 1305.7242, 1491.8035, 1592.8512, 1691.9196, 1762.9567, 1876.0408, 1947.0779, 2060.1619, 2207.2303, 2320.3144, 2419.3828, 2579.4135, 2636.4349, 2723.4670, 2870.5354, 2983.6194, 3080.6722, 3193.7563, 3308.7832, 3421.8673, 3522.9150, 3635.9990, 3751.0260, 3850.0944, 3949.1628, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PTLVEVQSIVFLHECNGHHLYHLPSGPSVTLDIFR", {98.0600, 199.1077, 312.1918, 411.2602, 540.3028, 639.3712, 767.4298, 854.4618, 967.5459, 1066.6143, 1213.6827, 1326.7668, 1463.8257, 1592.8683, 1752.8989, 1866.9418, 1923.9633, 2061.0222, 2198.0811, 2311.1652, 2474.2285, 2611.2874, 2724.3715, 2821.4243, 2908.4563, 2965.4778, 3062.5305, 3149.5626, 3248.6310, 3349.6786, 3462.7627, 3577.7897, 3690.8737, 3837.9421, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 435.2714, 550.2984, 663.3824, 764.4301, 863.4985, 950.5306, 1047.5833, 1104.6048, 1191.6368, 1288.6896, 1401.7736, 1538.8326, 1701.8959, 1814.9799, 1952.0389, 2089.0978, 2146.1192, 2260.1622, 2420.1928, 2549.2354, 2686.2943, 2799.3784, 2946.4468, 3045.5152, 3158.5993, 3245.6313, 3373.6899, 3472.7583, 3601.8009, 3700.8693, 3813.9534, 3915.0010, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FSSIDSFSPQHLESDYSHSLECIPETAVIPMSDYK", {148.0757, 235.1077, 322.1397, 435.2238, 550.2508, 637.2828, 784.3512, 871.3832, 968.4360, 1096.4946, 1233.5535, 1346.6375, 1475.6801, 1562.7122, 1677.7391, 1840.8024, 1927.8345, 2064.8934, 2151.9254, 2265.0095, 2394.0521, 2554.0827, 2667.1668, 2764.2195, 2893.2621, 2994.3098, 3065.3469, 3164.4153, 3277.4994, 3374.5522, 3505.5926, 3592.6247, 3707.6516, 3870.7150, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 310.1761, 425.2031, 512.2351, 643.2756, 740.3284, 853.4124, 952.4808, 1023.5179, 1124.5656, 1253.6082, 1350.6610, 1463.7450, 1623.7757, 1752.8183, 1865.9023, 1952.9344, 2089.9933, 2177.0253, 2340.0886, 2455.1156, 2542.1476, 2671.1902, 2784.2743, 2921.3332, 3049.3918, 3146.4445, 3233.4766, 3380.5450, 3467.5770, 3582.6039, 3695.6880, 3782.7200, 3869.7521, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NVTFVYYILTYVLFLTSGIINVLVISQENTLVGYR", {115.0502, 214.1186, 315.1663, 462.2347, 561.3031, 724.3665, 887.4298, 1000.5138, 1113.5979, 1214.6456, 1377.7089, 1476.7773, 1589.8614, 1736.9298, 1850.0139, 1951.0616, 2038.0936, 2095.1150, 2208.1991, 2321.2832, 2435.3261, 2534.3945, 2647.4786, 2746.5470, 2859.6311, 2946.6631, 3074.7217, 3203.7643, 3317.8072, 3418.8549, 3531.9389, 3631.0073, 3688.0288, 3851.0921, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 395.2037, 494.2722, 607.3562, 708.4039, 822.4468, 951.4894, 1079.5480, 1166.5800, 1279.6641, 1378.7325, 1491.8166, 1590.8850, 1704.9279, 1818.0120, 1931.0960, 1988.1175, 2075.1495, 2176.1972, 2289.2813, 2436.3497, 2549.4338, 2648.5022, 2811.5655, 2912.6132, 3025.6972, 3138.7813, 3301.8446, 3464.9080, 3563.9764, 3711.0448, 3812.0925, 3911.1609, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"STALDLAQNCESLQLEEYIAETVPCNSNVDLELDR", {88.0393, 189.0870, 260.1241, 373.2082, 488.2351, 601.3192, 672.3563, 800.4149, 914.4578, 1074.4884, 1203.5310, 1290.5631, 1403.6471, 1531.7057, 1644.7898, 1773.8324, 1902.8749, 2065.9383, 2179.0223, 2250.0595, 2379.1020, 2480.1497, 2579.2181, 2676.2709, 2836.3016, 2950.3445, 3037.3765, 3151.4194, 3250.4879, 3365.5148, 3478.5989, 3607.6415, 3720.7255, 3835.7525, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 290.1459, 403.2300, 532.2726, 645.3566, 760.3836, 859.4520, 973.4949, 1060.5269, 1174.5699, 1334.6005, 1431.6533, 1530.7217, 1631.7694, 1760.8120, 1831.8491, 1944.9331, 2107.9965, 2237.0391, 2366.0816, 2479.1657, 2607.2243, 2720.3084, 2807.3404, 2936.3830, 3096.4136, 3210.4566, 3338.5151, 3409.5522, 3522.6363, 3637.6632, 3750.7473, 3821.7844, 3922.8321, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SEFINSLDYLATWAQNIVDLCVTGSSEDINPHYIK", {88.0393, 217.0819, 364.1503, 477.2344, 591.2773, 678.3093, 791.3934, 906.4203, 1069.4837, 1182.5677, 1253.6048, 1354.6525, 1540.7318, 1611.7690, 1739.8275, 1853.8705, 1966.9545, 2066.0229, 2181.0499, 2294.1339, 2454.1646, 2553.2330, 2654.2807, 2711.3021, 2798.3342, 2885.3662, 3014.4088, 3129.4357, 3242.5198, 3356.5627, 3453.6155, 3590.6744, 3753.7377, 3866.8218, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 423.2602, 560.3191, 657.3719, 771.4148, 884.4989, 999.5258, 1128.5684, 1215.6004, 1302.6325, 1359.6539, 1460.7016, 1559.7700, 1719.8007, 1832.8847, 1947.9117, 2046.9801, 2160.0641, 2274.1071, 2402.1657, 2473.2028, 2659.2821, 2760.3298, 2831.3669, 2944.4509, 3107.5143, 3222.5412, 3335.6253, 3422.6573, 3536.7002, 3649.7843, 3796.8527, 3925.8953, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NYDNVAEFWYNCLPPGVLQLLGNVFLSIGYSSTLR", {115.0502, 278.1135, 393.1405, 507.1834, 606.2518, 677.2889, 806.3315, 953.3999, 1139.4793, 1302.5426, 1416.5855, 1576.6162, 1689.7002, 1786.7530, 1883.8057, 1940.8272, 2039.8956, 2152.9797, 2281.0383, 2394.1223, 2507.2064, 2564.2279, 2678.2708, 2777.3392, 2924.4076, 3037.4917, 3124.5237, 3237.6078, 3294.6292, 3457.6926, 3544.7246, 3631.7566, 3732.8043, 3845.8884, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 389.2507, 476.2827, 563.3148, 726.3781, 783.3995, 896.4836, 983.5156, 1096.5997, 1243.6681, 1342.7365, 1456.7795, 1513.8009, 1626.8850, 1739.9690, 1868.0276, 1981.1117, 2080.1801, 2137.2016, 2234.2543, 2331.3071, 2444.3912, 2604.4218, 2718.4647, 2881.5281, 3067.6074, 3214.6758, 3343.7184, 3414.7555, 3513.8239, 3627.8668, 3742.8938, 3905.9571, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QEVPEYFLAAVFVNLTIGGMILCSGHYGYTELLWR", {129.0659, 258.1084, 357.1769, 454.2296, 583.2722, 746.3355, 893.4040, 1006.4880, 1077.5251, 1148.5623, 1247.6307, 1394.6991, 1493.7675, 1607.8104, 1720.8945, 1821.9422, 1935.0262, 1992.0477, 2049.0692, 2180.1096, 2293.1937, 2406.2778, 2566.3084, 2653.3404, 2710.3619, 2847.4208, 3010.4841, 3067.5056, 3230.5689, 3331.6166, 3460.6592, 3573.7433, 3686.8273, 3872.9067, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 361.1983, 474.2823, 587.3664, 716.4090, 817.4567, 980.5200, 1037.5415, 1200.6048, 1337.6637, 1394.6852, 1481.7172, 1641.7478, 1754.8319, 1867.9160, 1998.9565, 2055.9779, 2112.9994, 2226.0834, 2327.1311, 2440.2152, 2554.2581, 2653.3265, 2800.3949, 2899.4634, 2970.5005, 3041.5376, 3154.6216, 3301.6901, 3464.7534, 3593.7960, 3690.8487, 3789.9172, 3918.9598, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"IQVHDVWVYIILALQSVLLVLMVVSYSTLACSNER", {114.0913, 242.1499, 341.2183, 478.2772, 593.3042, 692.3726, 878.4519, 977.5203, 1140.5837, 1253.6677, 1366.7518, 1479.8358, 1550.8730, 1663.9570, 1792.0156, 1879.0476, 1978.1160, 2091.2001, 2204.2842, 2303.3526, 2416.4367, 2547.4771, 2646.5456, 2745.6140, 2832.6460, 2995.7093, 3082.7414, 3183.7890, 3296.8731, 3367.9102, 3527.9409, 3614.9729, 3729.0158, 3858.0584, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 418.2045, 505.2365, 665.2671, 736.3043, 849.3883, 950.4360, 1037.4680, 1200.5314, 1287.5634, 1386.6318, 1485.7002, 1616.7407, 1729.8248, 1828.8932, 1941.9772, 2055.0613, 2154.1297, 2241.1618, 2369.2203, 2482.3044, 2553.3415, 2666.4256, 2779.5096, 2892.5937, 3055.6570, 3154.7254, 3340.8048, 3439.8732, 3554.9001, 3691.9590, 3791.0274, 3919.0860, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EFQASAGINAYLTPNDQYMLCVCQGTHADEVTQLR", {130.0499, 277.1183, 405.1769, 476.2140, 563.2460, 634.2831, 691.3046, 804.3886, 918.4316, 989.4687, 1152.5320, 1265.6161, 1366.6638, 1463.7165, 1577.7594, 1692.7864, 1820.8450, 1983.9083, 2114.9488, 2228.0328, 2388.0635, 2487.1319, 2647.1626, 2775.2211, 2832.2426, 2933.2903, 3070.3492, 3141.3863, 3256.4132, 3385.4558, 3484.5243, 3585.5719, 3713.6305, 3826.7146, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 416.2616, 517.3093, 616.3777, 745.4203, 860.4472, 931.4843, 1068.5432, 1169.5909, 1226.6124, 1354.6710, 1514.7016, 1613.7700, 1773.8007, 1886.8847, 2017.9252, 2180.9886, 2309.0471, 2424.0741, 2538.1170, 2635.1698, 2736.2174, 2849.3015, 3012.3648, 3083.4020, 3197.4449, 3310.5289, 3367.5504, 3438.5875, 3525.6196, 3596.6567, 3724.7152, 3871.7837, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QAHEPLQSCGVNDHTDPDLYCSHVLTEDLDLVLTK", {129.0659, 200.1030, 337.1619, 466.2045, 563.2572, 676.3413, 804.3999, 891.4319, 1051.4626, 1108.4840, 1207.5524, 1321.5954, 1436.6223, 1573.6812, 1674.7289, 1789.7558, 1886.8086, 2001.8355, 2114.9196, 2277.9829, 2438.0136, 2525.0456, 2662.1045, 2761.1729, 2874.2570, 2975.3047, 3104.3473, 3219.3742, 3332.4583, 3447.4852, 3560.5693, 3659.6377, 3772.7218, 3873.7694, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 248.1605, 361.2445, 460.3130, 573.3970, 688.4240, 801.5080, 916.5350, 1045.5776, 1146.6252, 1259.7093, 1358.7777, 1495.8366, 1582.8687, 1742.8993, 1905.9626, 2019.0467, 2134.0736, 2231.1264, 2346.1534, 2447.2010, 2584.2599, 2699.2869, 2813.3298, 2912.3982, 2969.4197, 3129.4503, 3216.4824, 3344.5409, 3457.6250, 3554.6778, 3683.7204, 3820.7793, 3891.8164, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VVIAFGIFTLVNPAFIVNFTMSLLWYIAIGLCWSR", {100.0757, 199.1441, 312.2282, 383.2653, 530.3337, 587.3552, 700.4392, 847.5076, 948.5553, 1061.6394, 1160.7078, 1274.7507, 1371.8035, 1442.8406, 1589.9090, 1702.9931, 1802.0615, 1916.1044, 2063.1728, 2164.2205, 2295.2610, 2382.2930, 2495.3771, 2608.4612, 2794.5405, 2957.6038, 3070.6879, 3141.7250, 3254.8090, 3311.8305, 3424.9146, 3584.9452, 3771.0245, 3858.0566, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 262.1510, 448.2303, 608.2609, 721.3450, 778.3665, 891.4505, 962.4876, 1075.5717, 1238.6350, 1424.7144, 1537.7984, 1650.8825, 1737.9145, 1868.9550, 1970.0027, 2117.0711, 2231.1140, 2330.1824, 2443.2665, 2590.3349, 2661.3720, 2758.4248, 2872.4677, 2971.5361, 3084.6202, 3185.6679, 3332.7363, 3445.8203, 3502.8418, 3649.9102, 3720.9473, 3834.0314, 3933.0998, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NYAYLPSMTIGVTSILLYCVGAFVFNHWIGACLVR", {115.0502, 278.1135, 349.1506, 512.2140, 625.2980, 722.3508, 809.3828, 940.4233, 1041.4710, 1154.5551, 1211.5765, 1310.6449, 1411.6926, 1498.7246, 1611.8087, 1724.8928, 1837.9768, 2001.0402, 2161.0708, 2260.1392, 2317.1607, 2388.1978, 2535.2662, 2634.3346, 2781.4030, 2895.4460, 3032.5049, 3218.5842, 3331.6683, 3388.6897, 3459.7268, 3619.7575, 3732.8416, 3831.9100, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 274.1874, 387.2714, 547.3021, 618.3392, 675.3607, 788.4447, 974.5240, 1111.5829, 1225.6259, 1372.6943, 1471.7627, 1618.8311, 1689.8682, 1746.8897, 1845.9581, 2005.9888, 2169.0521, 2282.1361, 2395.2202, 2508.3043, 2595.3363, 2696.3840, 2795.4524, 2852.4739, 2965.5579, 3066.6056, 3197.6461, 3284.6781, 3381.7309, 3494.8149, 3657.8783, 3728.9154, 3891.9787, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EFIEISQFIFAGGIIYFTVLLIIGVNSFMFATFHR", {130.0499, 277.1183, 390.2023, 519.2449, 632.3290, 719.3610, 847.4196, 994.4880, 1107.5721, 1254.6405, 1325.6776, 1382.6991, 1439.7205, 1552.8046, 1665.8887, 1828.9520, 1976.0204, 2077.0681, 2176.1365, 2289.2206, 2402.3046, 2515.3887, 2628.4728, 2685.4942, 2784.5626, 2898.6056, 2985.6376, 3132.7060, 3263.7465, 3410.8149, 3481.8520, 3582.8997, 3729.9681, 3867.0270, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 312.1779, 459.2463, 560.2940, 631.3311, 778.3995, 909.4400, 1056.5084, 1143.5404, 1257.5833, 1356.6518, 1413.6732, 1526.7573, 1639.8413, 1752.9254, 1866.0095, 1965.0779, 2066.1256, 2213.1940, 2376.2573, 2489.3414, 2602.4254, 2659.4469, 2716.4684, 2787.5055, 2934.5739, 3047.6580, 3194.7264, 3322.7849, 3409.8170, 3522.9010, 3651.9436, 3765.0277, 3912.0961, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"CANLVYQWHTWAVASTICCVLSSVIALPYLLSLAR", {161.0379, 232.0750, 346.1180, 459.2020, 558.2704, 721.3338, 849.3924, 1035.4717, 1172.5306, 1273.5783, 1459.6576, 1530.6947, 1629.7631, 1700.8002, 1787.8322, 1888.8799, 2001.9640, 2161.9946, 2322.0253, 2421.0937, 2534.1778, 2621.2098, 2708.2418, 2807.3102, 2920.3943, 2991.4314, 3104.5155, 3201.5682, 3364.6316, 3477.7156, 3590.7997, 3677.8317, 3790.9158, 3861.9529, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 246.1561, 359.2401, 446.2722, 559.3562, 672.4403, 835.5036, 932.5564, 1045.6404, 1116.6776, 1229.7616, 1328.8300, 1415.8621, 1502.8941, 1615.9782, 1715.0466, 1875.0772, 2035.1079, 2148.1919, 2249.2396, 2336.2716, 2407.3088, 2506.3772, 2577.4143, 2763.4936, 2864.5413, 3001.6002, 3187.6795, 3315.7381, 3478.8014, 3577.8698, 3690.9539, 3804.9968, 3876.0339, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"CCQFWNQYLSMAGPSNLEEEWTAELANALNSAVTK", {161.0379, 321.0686, 449.1272, 596.1956, 782.2749, 896.3178, 1024.3764, 1187.4397, 1300.5238, 1387.5558, 1518.5963, 1589.6334, 1646.6549, 1743.7076, 1830.7397, 1944.7826, 2057.8666, 2186.9092, 2315.9518, 2444.9944, 2631.0737, 2732.1214, 2803.1585, 2932.2011, 3045.2852, 3116.3223, 3230.3652, 3301.4023, 3414.4864, 3528.5293, 3615.5614, 3686.5985, 3785.6669, 3886.7146, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 248.1605, 347.2289, 418.2660, 505.2980, 619.3410, 732.4250, 803.4621, 917.5051, 988.5422, 1101.6262, 1230.6688, 1301.7060, 1402.7536, 1588.8329, 1717.8755, 1846.9181, 1975.9607, 2089.0448, 2203.0877, 2290.1197, 2387.1725, 2444.1940, 2515.2311, 2646.2716, 2733.3036, 2846.3877, 3009.4510, 3137.5096, 3251.5525, 3437.6318, 3584.7002, 3712.7588, 3872.7895, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DMDEDLEDDEALMEEEVVPQQHEVPTAEPAVIVQR", {116.0342, 247.0747, 362.1016, 491.1442, 606.1712, 719.2552, 848.2978, 963.3248, 1078.3517, 1207.3943, 1278.4314, 1391.5155, 1522.5560, 1651.5986, 1780.6412, 1909.6838, 2008.7522, 2107.8206, 2204.8734, 2332.9319, 2460.9905, 2598.0494, 2727.0920, 2826.1604, 2923.2132, 3024.2609, 3095.2980, 3224.3406, 3321.3933, 3392.4305, 3491.4989, 3604.5829, 3703.6513, 3831.7099, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 402.2459, 515.3300, 614.3984, 685.4355, 782.4883, 911.5309, 982.5680, 1083.6157, 1180.6684, 1279.7369, 1408.7795, 1545.8384, 1673.8969, 1801.9555, 1899.0083, 1998.0767, 2097.1451, 2226.1877, 2355.2303, 2484.2729, 2615.3134, 2728.3974, 2799.4346, 2928.4771, 3043.5041, 3158.5310, 3287.5736, 3400.6577, 3515.6846, 3644.7272, 3759.7542, 3890.7947, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DAWSHVLNYNINEAPQLNVCPALCVLVSLLGLCLR", {116.0342, 187.0713, 373.1506, 460.1827, 597.2416, 696.3100, 809.3941, 923.4370, 1086.5003, 1200.5432, 1313.6273, 1427.6702, 1556.7128, 1627.7499, 1724.8027, 1852.8613, 1965.9454, 2079.9883, 2179.0567, 2339.0873, 2436.1401, 2507.1772, 2620.2613, 2780.2919, 2879.3603, 2992.4444, 3091.5128, 3178.5449, 3291.6289, 3404.7130, 3461.7344, 3574.8185, 3734.8492, 3847.9332, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 448.2337, 561.3177, 618.3392, 731.4233, 844.5073, 931.5393, 1030.6078, 1143.6918, 1242.7602, 1402.7909, 1515.8750, 1586.9121, 1683.9648, 1843.9955, 1943.0639, 2057.1068, 2170.1909, 2298.2495, 2395.3022, 2466.3393, 2595.3819, 2709.4249, 2822.5089, 2936.5519, 3099.6152, 3213.6581, 3326.7422, 3425.8106, 3562.8695, 3649.9015, 3835.9808, 3907.0180, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QQQLDDLEHEDHIVLSDYFRPTAQSAGEETAAYQK", {129.0659, 257.1244, 385.1830, 498.2671, 613.2940, 728.3210, 841.4050, 970.4476, 1107.5065, 1236.5491, 1351.5761, 1488.6350, 1601.7190, 1700.7875, 1813.8715, 1900.9035, 2015.9305, 2178.9938, 2326.0622, 2482.1633, 2579.2161, 2680.2638, 2751.3009, 2879.3595, 2966.3915, 3037.4286, 3094.4501, 3223.4927, 3352.5353, 3453.5829, 3524.6201, 3595.6572, 3758.7205, 3886.7791, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 275.1714, 438.2347, 509.2718, 580.3089, 681.3566, 810.3992, 939.4418, 996.4633, 1067.5004, 1154.5324, 1282.5910, 1353.6281, 1454.6758, 1551.7285, 1707.8297, 1854.8981, 2017.9614, 2132.9883, 2220.0204, 2333.1044, 2432.1728, 2545.2569, 2682.3158, 2797.3428, 2926.3854, 3063.4443, 3192.4869, 3305.5709, 3420.5979, 3535.6248, 3648.7089, 3776.7675, 3904.8260, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QVDCLKPFSQLQQLSVAGLLALGLTMQLWMTSCMR", {129.0659, 228.1343, 343.1612, 503.1919, 616.2759, 744.3709, 841.4237, 988.4921, 1075.5241, 1203.5827, 1316.6667, 1444.7253, 1572.7839, 1685.8680, 1772.9000, 1871.9684, 1943.0055, 2000.0270, 2113.1110, 2226.1951, 2297.2322, 2410.3163, 2467.3377, 2580.4218, 2681.4695, 2812.5100, 2940.5685, 3053.6526, 3239.7319, 3370.7724, 3471.8201, 3558.8521, 3718.8828, 3849.9232, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 306.1594, 466.1901, 553.2221, 654.2698, 785.3103, 971.3896, 1084.4737, 1212.5322, 1343.5727, 1444.6204, 1557.7045, 1614.7259, 1727.8100, 1798.8471, 1911.9312, 2025.0152, 2082.0367, 2153.0738, 2252.1422, 2339.1742, 2452.2583, 2580.3169, 2708.3755, 2821.4595, 2949.5181, 3036.5501, 3183.6186, 3280.6713, 3408.7663, 3521.8503, 3681.8810, 3796.9079, 3895.9763, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NYCDSLDLEEISPCSSAMAEMGLLSIQQCNSLMLR", {115.0502, 278.1135, 438.1442, 553.1711, 640.2032, 753.2872, 868.3142, 981.3982, 1110.4408, 1239.4834, 1352.5675, 1439.5995, 1536.6523, 1696.6829, 1783.7149, 1870.7470, 1941.7841, 2072.8246, 2143.8617, 2272.9043, 2403.9448, 2460.9662, 2574.0503, 2687.1344, 2774.1664, 2887.2504, 3015.3090, 3143.3676, 3303.3982, 3417.4412, 3504.4732, 3617.5573, 3748.5978, 3861.6818, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 419.2435, 532.3276, 619.3596, 733.4025, 893.4332, 1021.4917, 1149.5503, 1262.6344, 1349.6664, 1462.7505, 1575.8345, 1632.8560, 1763.8965, 1892.9391, 1963.9762, 2095.0167, 2166.0538, 2253.0858, 2340.1179, 2500.1485, 2597.2013, 2684.2333, 2797.3174, 2926.3600, 3055.4025, 3168.4866, 3283.5136, 3396.5976, 3483.6296, 3598.6566, 3758.6872, 3921.7506, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ALNEDNVCMTASLDLACLQPQTALFNLITTCNLQR", {72.0444, 185.1285, 299.1714, 428.2140, 543.2409, 657.2838, 756.3523, 916.3829, 1047.4234, 1148.4711, 1219.5082, 1306.5402, 1419.6243, 1534.6512, 1647.7353, 1718.7724, 1878.8030, 1991.8871, 2119.9457, 2216.9985, 2345.0570, 2446.1047, 2517.1418, 2630.2259, 2777.2943, 2891.3372, 3004.4213, 3117.5054, 3218.5530, 3319.6007, 3479.6314, 3593.6743, 3706.7584, 3834.8169, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 416.2616, 530.3045, 690.3352, 791.3828, 892.4305, 1005.5146, 1118.5987, 1232.6416, 1379.7100, 1492.7941, 1563.8312, 1664.8789, 1792.9374, 1889.9902, 2018.0488, 2131.1328, 2291.1635, 2362.2006, 2475.2847, 2590.3116, 2703.3957, 2790.4277, 2861.4648, 2962.5125, 3093.5530, 3253.5836, 3352.6520, 3466.6950, 3581.7219, 3710.7645, 3824.8074, 3937.8915, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FDIHDFPLNVSSLNLYLQETGQAIWSNFVSNGLLR", {148.0757, 263.1026, 376.1867, 513.2456, 628.2726, 775.3410, 872.3937, 985.4778, 1099.5207, 1198.5891, 1285.6212, 1372.6532, 1485.7373, 1599.7802, 1712.8642, 1875.9276, 1989.0116, 2117.0702, 2246.1128, 2347.1605, 2404.1820, 2532.2405, 2603.2776, 2716.3617, 2902.4410, 2989.4731, 3103.5160, 3250.5844, 3349.6528, 3436.6848, 3550.7278, 3607.7492, 3720.8333, 3833.9174, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 401.2871, 458.3085, 572.3515, 659.3835, 758.4519, 905.5203, 1019.5633, 1106.5953, 1292.6746, 1405.7587, 1476.7958, 1604.8544, 1661.8758, 1762.9235, 1891.9661, 2020.0247, 2133.1087, 2296.1721, 2409.2561, 2523.2990, 2636.3831, 2723.4151, 2810.4472, 2909.5156, 3023.5585, 3136.6426, 3233.6953, 3380.7638, 3495.7907, 3632.8496, 3745.9337, 3860.9606, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SDADADEQQLQQQVEEISHVEPHLENDSLPFVHEK", {88.0393, 203.0662, 274.1034, 389.1303, 460.1674, 575.1944, 704.2370, 832.2955, 960.3541, 1073.4382, 1201.4968, 1329.5553, 1457.6139, 1556.6823, 1685.7249, 1814.7675, 1927.8516, 2014.8836, 2151.9425, 2251.0109, 2380.0535, 2477.1063, 2614.1652, 2727.2493, 2856.2919, 2970.3348, 3085.3617, 3172.3938, 3285.4778, 3382.5306, 3529.5990, 3628.6674, 3765.7263, 3894.7689, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 276.1554, 413.2143, 512.2827, 659.3511, 756.4039, 869.4880, 956.5200, 1071.5469, 1185.5899, 1314.6325, 1427.7165, 1564.7754, 1661.8282, 1790.8708, 1889.9392, 2026.9981, 2114.0301, 2227.1142, 2356.1568, 2485.1994, 2584.2678, 2712.3264, 2840.3850, 2968.4435, 3081.5276, 3209.5862, 3337.6448, 3466.6874, 3581.7143, 3652.7514, 3767.7784, 3838.8155, 3953.8424, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"HDLLPTPTQPTELNQTNNLPQNDLENVPFQYPQGK", {138.0662, 253.0931, 366.1772, 479.2613, 576.3140, 677.3617, 774.4145, 875.4621, 1003.5207, 1100.5735, 1201.6212, 1330.6638, 1443.7478, 1557.7907, 1685.8493, 1786.8970, 1900.9399, 2014.9829, 2128.0669, 2225.1197, 2353.1783, 2467.2212, 2582.2481, 2695.3322, 2824.3748, 2938.4177, 3037.4861, 3134.5389, 3281.6073, 3409.6659, 3572.7292, 3669.7820, 3797.8406, 3854.8620, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 204.1343, 332.1928, 429.2456, 592.3089, 720.3675, 867.4359, 964.4887, 1063.5571, 1177.6000, 1306.6426, 1419.7267, 1534.7536, 1648.7966, 1776.8551, 1873.9079, 1986.9920, 2101.0349, 2215.0778, 2316.1255, 2444.1841, 2558.2270, 2671.3111, 2800.3537, 2901.4013, 2998.4541, 3126.5127, 3227.5604, 3324.6131, 3425.6608, 3522.7136, 3635.7976, 3748.8817, 3863.9086, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VTEYQQYGTNGCCSFALQLADMPYGQAANNEDWAK", {100.0757, 201.1234, 330.1660, 493.2293, 621.2879, 749.3464, 912.4098, 969.4312, 1070.4789, 1184.5218, 1241.5433, 1401.5740, 1561.6046, 1648.6366, 1795.7050, 1866.7422, 1979.8262, 2107.8848, 2220.9689, 2292.0060, 2407.0329, 2538.0734, 2635.1262, 2798.1895, 2855.2110, 2983.2695, 3054.3067, 3125.3438, 3239.3867, 3353.4296, 3482.4722, 3597.4992, 3783.5785, 3854.6156, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 218.1499, 404.2292, 519.2562, 648.2988, 762.3417, 876.3846, 947.4217, 1018.4588, 1146.5174, 1203.5389, 1366.6022, 1463.6550, 1594.6955, 1709.7224, 1780.7595, 1893.8436, 2021.9022, 2134.9862, 2206.0233, 2353.0918, 2440.1238, 2600.1544, 2760.1851, 2817.2065, 2931.2495, 3032.2972, 3089.3186, 3252.3819, 3380.4405, 3508.4991, 3671.5624, 3800.6050, 3901.6527, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LDYNIVDHFSTAIFVIYVCAAAYYTAMLGIDVFQK", {114.0913, 229.1183, 392.1816, 506.2245, 619.3086, 718.3770, 833.4040, 970.4629, 1117.5313, 1204.5633, 1305.6110, 1376.6481, 1489.7322, 1636.8006, 1735.8690, 1848.9531, 2012.0164, 2111.0848, 2271.1155, 2342.1526, 2413.1897, 2484.2268, 2647.2901, 2810.3535, 2911.4011, 2982.4382, 3113.4787, 3226.5628, 3283.5843, 3396.6683, 3511.6953, 3610.7637, 3757.8321, 3885.8907, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 275.1714, 422.2398, 521.3082, 636.3352, 749.4192, 806.4407, 919.5247, 1050.5652, 1121.6023, 1222.6500, 1385.7134, 1548.7767, 1619.8138, 1690.8509, 1761.8880, 1921.9187, 2020.9871, 2184.0504, 2297.1345, 2396.2029, 2543.2713, 2656.3554, 2727.3925, 2828.4402, 2915.4722, 3062.5406, 3199.5995, 3314.6265, 3413.6949, 3526.7789, 3640.8219, 3803.8852, 3918.9121, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QLMPLVMDLGQIVEYDGVHCQFNLENEVVTGNDLK", {129.0659, 242.1499, 373.1904, 470.2432, 583.3272, 682.3956, 813.4361, 928.4631, 1041.5471, 1098.5686, 1226.6272, 1339.7112, 1438.7797, 1567.8222, 1730.8856, 1845.9125, 1902.9340, 2002.0024, 2139.0613, 2299.0920, 2427.1505, 2574.2189, 2688.2619, 2801.3459, 2930.3885, 3044.4315, 3173.4741, 3272.5425, 3371.6109, 3472.6586, 3529.6800, 3643.7230, 3758.7499, 3871.8340, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 375.2238, 489.2667, 546.2882, 647.3359, 746.4043, 845.4727, 974.5153, 1088.5582, 1217.6008, 1330.6849, 1444.7278, 1591.7962, 1719.8548, 1879.8855, 2016.9444, 2116.0128, 2173.0342, 2288.0612, 2451.1245, 2580.1671, 2679.2355, 2792.3196, 2920.3782, 2977.3996, 3090.4837, 3205.5106, 3336.5511, 3435.6195, 3548.7036, 3645.7564, 3776.7968, 3889.8809, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SHLLAHLDILNAYDWSHAAHLVKPLANPYSQLYLR", {88.0393, 225.0982, 338.1823, 451.2663, 522.3035, 659.3624, 772.4464, 887.4734, 1000.5574, 1113.6415, 1227.6844, 1298.7215, 1461.7849, 1576.8118, 1762.8911, 1849.9232, 1986.9821, 2058.0192, 2129.0563, 2266.1152, 2379.1993, 2478.2677, 2606.3627, 2703.4154, 2816.4995, 2887.5366, 3001.5795, 3098.6323, 3261.6956, 3348.7276, 3476.7862, 3589.8703, 3752.9336, 3866.0177, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 451.2663, 564.3504, 692.4090, 779.4410, 942.5043, 1039.5571, 1153.6000, 1224.6371, 1337.7212, 1434.7740, 1562.8689, 1661.9374, 1775.0214, 1912.0803, 1983.1174, 2054.1546, 2191.2135, 2278.2455, 2464.3248, 2579.3518, 2742.4151, 2813.4522, 2927.4951, 3040.5792, 3153.6633, 3268.6902, 3381.7743, 3518.8332, 3589.8703, 3702.9543, 3816.0384, 3953.0973, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EATDLLEEQLNADLSAFDYHPAPKPVEQHEPFEIR", {130.0499, 201.0870, 302.1347, 417.1616, 530.2457, 643.3297, 772.3723, 901.4149, 1029.4735, 1142.5576, 1256.6005, 1327.6376, 1442.6645, 1555.7486, 1642.7806, 1713.8178, 1860.8862, 1975.9131, 2138.9764, 2276.0353, 2373.0881, 2444.1252, 2541.1780, 2669.2730, 2766.3257, 2865.3941, 2994.4367, 3122.4953, 3259.5542, 3388.5968, 3485.6496, 3632.7180, 3761.7606, 3874.8446, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 417.2456, 564.3140, 661.3668, 790.4094, 927.4683, 1055.5269, 1184.5695, 1283.6379, 1380.6906, 1508.7856, 1605.8384, 1676.8755, 1773.9282, 1910.9872, 2074.0505, 2189.0774, 2336.1458, 2407.1830, 2494.2150, 2607.2990, 2722.3260, 2793.3631, 2907.4060, 3020.4901, 3148.5487, 3277.5913, 3406.6339, 3519.7179, 3632.8020, 3747.8289, 3848.8766, 3919.9137, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LTCIPHQDFTLWASFNLRPFLGGSTDNSCTLVNPK", {114.0913, 215.1390, 375.1697, 488.2537, 585.3065, 722.3654, 850.4240, 965.4509, 1112.5193, 1213.5670, 1326.6511, 1512.7304, 1583.7675, 1670.7995, 1817.8680, 1931.9109, 2044.9949, 2201.0961, 2298.1488, 2445.2172, 2558.3013, 2615.3228, 2672.3442, 2759.3763, 2860.4239, 2975.4509, 3089.4938, 3176.5258, 3336.5565, 3437.6042, 3550.6882, 3649.7566, 3763.7996, 3860.8523, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 244.1656, 358.2085, 457.2769, 570.3610, 671.4087, 831.4393, 918.4713, 1032.5143, 1147.5412, 1248.5889, 1335.6209, 1392.6424, 1449.6638, 1562.7479, 1709.8163, 1806.8691, 1962.9702, 2076.0543, 2190.0972, 2337.1656, 2424.1976, 2495.2347, 2681.3140, 2794.3981, 2895.4458, 3042.5142, 3157.5411, 3285.5997, 3422.6586, 3519.7114, 3632.7955, 3792.8261, 3893.8738, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TSSVLTIMAAEDMELALQFFYNAAFWLLCFLLATK", {102.0550, 189.0870, 276.1190, 375.1874, 488.2715, 589.3192, 702.4032, 833.4437, 904.4808, 975.5179, 1104.5605, 1219.5875, 1350.6280, 1479.6706, 1592.7546, 1663.7917, 1776.8758, 1904.9344, 2052.0028, 2199.0712, 2362.1345, 2476.1775, 2547.2146, 2618.2517, 2765.3201, 2951.3994, 3064.4835, 3177.5675, 3337.5982, 3484.6666, 3597.7507, 3710.8347, 3781.8718, 3882.9195, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 248.1605, 319.1976, 432.2817, 545.3657, 692.4341, 852.4648, 965.5489, 1078.6329, 1264.7122, 1411.7806, 1482.8178, 1553.8549, 1667.8978, 1830.9611, 1978.0295, 2125.0980, 2253.1565, 2366.2406, 2437.2777, 2550.3618, 2679.4044, 2810.4449, 2925.4718, 3054.5144, 3125.5515, 3196.5886, 3327.6291, 3440.7132, 3541.7608, 3654.8449, 3753.9133, 3840.9453, 3927.9774, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"WPVPGFGISFFIIFICISSIPLWGFNDMSAPDNEK", {187.0866, 284.1394, 383.2078, 480.2605, 537.2820, 684.3504, 741.3719, 854.4559, 941.4880, 1088.5564, 1235.6248, 1348.7089, 1461.7929, 1608.8613, 1721.9454, 1881.9760, 1995.0601, 2082.0921, 2169.1242, 2282.2082, 2379.2610, 2492.3451, 2678.4244, 2735.4458, 2882.5143, 2996.5572, 3111.5841, 3242.6246, 3329.6566, 3400.6937, 3497.7465, 3612.7735, 3726.8164, 3855.8590, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 276.1554, 390.1983, 505.2253, 602.2780, 673.3151, 760.3472, 891.3877, 1006.4146, 1120.4575, 1267.5259, 1324.5474, 1510.6267, 1623.7108, 1720.7635, 1833.8476, 1920.8796, 2007.9117, 2120.9957, 2281.0264, 2394.1104, 2541.1789, 2654.2629, 2767.3470, 2914.4154, 3061.4838, 3148.5158, 3261.5999, 3318.6214, 3465.6898, 3522.7112, 3619.7640, 3718.8324, 3815.8852, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VSTIGLNFYVPVFMFCVIPYASMMGYIIEWMASGR", {100.0757, 187.1077, 288.1554, 401.2395, 458.2609, 571.3450, 685.3879, 832.4563, 995.5197, 1094.5881, 1191.6408, 1290.7093, 1437.7777, 1568.8181, 1715.8866, 1875.9172, 1974.9856, 2088.0697, 2185.1225, 2348.1858, 2419.2229, 2506.2549, 2637.2954, 2768.3359, 2825.3574, 2988.4207, 3101.5048, 3214.5888, 3343.6314, 3529.7107, 3660.7512, 3731.7883, 3818.8203, 3875.8418, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 232.1404, 319.1724, 390.2096, 521.2500, 707.3294, 836.3719, 949.4560, 1062.5401, 1225.6034, 1282.6249, 1413.6654, 1544.7058, 1631.7379, 1702.7750, 1865.8383, 1962.8911, 2075.9751, 2175.0436, 2335.0742, 2482.1426, 2613.1831, 2760.2515, 2859.3199, 2956.3727, 3055.4411, 3218.5044, 3365.5728, 3479.6158, 3592.6998, 3649.7213, 3762.8054, 3863.8530, 3950.8851, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"AYCCSSPLAGHEEQLYDQPGEIGCCGFLSHVPQMK", {72.0444, 235.1077, 395.1384, 555.1690, 642.2010, 729.2331, 826.2858, 939.3699, 1010.4070, 1067.4285, 1204.4874, 1333.5300, 1462.5726, 1590.6312, 1703.7152, 1866.7785, 1981.8055, 2109.8641, 2206.9168, 2263.9383, 2392.9809, 2506.0650, 2563.0864, 2723.1171, 2883.1477, 2940.1692, 3087.2376, 3200.3217, 3287.3537, 3424.4126, 3523.4810, 3620.5338, 3748.5923, 3879.6328, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 278.1533, 406.2119, 503.2646, 602.3330, 739.3920, 826.4240, 939.5080, 1086.5765, 1143.5979, 1303.6286, 1463.6592, 1520.6807, 1633.7648, 1762.8073, 1819.8288, 1916.8816, 2044.9401, 2159.9671, 2323.0304, 2436.1145, 2564.1731, 2693.2157, 2822.2582, 2959.3172, 3016.3386, 3087.3757, 3200.4598, 3297.5126, 3384.5446, 3471.5766, 3631.6073, 3791.6379, 3954.7012, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"AHGVTPVPVPLDAQTSWYNGLAHEIDWDCSSLYFR", {72.0444, 209.1033, 266.1248, 365.1932, 466.2409, 563.2936, 662.3620, 759.4148, 858.4832, 955.5360, 1068.6200, 1183.6470, 1254.6841, 1382.7427, 1483.7904, 1570.8224, 1756.9017, 1919.9650, 2034.0080, 2091.0294, 2204.1135, 2275.1506, 2412.2095, 2541.2521, 2654.3362, 2769.3631, 2955.4424, 3070.4694, 3230.5000, 3317.5320, 3404.5641, 3517.6481, 3680.7115, 3827.7799, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 485.2507, 598.3348, 685.3668, 772.3988, 932.4295, 1047.4564, 1233.5357, 1348.5627, 1461.6467, 1590.6893, 1727.7482, 1798.7853, 1911.8694, 1968.8909, 2082.9338, 2245.9971, 2432.0764, 2519.1085, 2620.1561, 2748.2147, 2819.2518, 2934.2788, 3047.3628, 3144.4156, 3243.4840, 3340.5368, 3439.6052, 3536.6580, 3637.7056, 3736.7741, 3793.7955, 3930.8544, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SVAEVANGQHHLDMLTQHHNELPETEEQENLSVFR", {88.0393, 187.1077, 258.1448, 387.1874, 486.2558, 557.2930, 671.3359, 728.3573, 856.4159, 993.4748, 1130.5337, 1243.6178, 1358.6448, 1489.6852, 1602.7693, 1703.8170, 1831.8756, 1968.9345, 2105.9934, 2220.0363, 2349.0789, 2462.1630, 2559.2157, 2688.2583, 2789.3060, 2918.3486, 3047.3912, 3175.4498, 3304.4924, 3418.5353, 3531.6194, 3618.6514, 3717.7198, 3864.7882, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 421.2558, 508.2878, 621.3719, 735.4148, 864.4574, 992.5160, 1121.5586, 1250.6012, 1351.6488, 1480.6914, 1577.7442, 1690.8283, 1819.8708, 1933.9138, 2070.9727, 2208.0316, 2336.0902, 2437.1379, 2550.2219, 2681.2624, 2796.2893, 2909.3734, 3046.4323, 3183.4912, 3311.5498, 3368.5713, 3482.6142, 3553.6513, 3652.7197, 3781.7623, 3852.7994, 3951.8679, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ANAWSPYVYDAYTLPEYGILGYVTIFLLFIPAVFR", {72.0444, 186.0873, 257.1244, 443.2037, 530.2358, 627.2885, 790.3519, 889.4203, 1052.4836, 1167.5106, 1238.5477, 1401.6110, 1502.6587, 1615.7427, 1712.7955, 1841.8381, 2004.9014, 2061.9229, 2175.0069, 2288.0910, 2345.1125, 2508.1758, 2607.2442, 2708.2919, 2821.3760, 2968.4444, 3081.5284, 3194.6125, 3341.6809, 3454.7650, 3551.8177, 3622.8549, 3721.9233, 3868.9917, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 421.2558, 492.2929, 589.3457, 702.4297, 849.4981, 962.5822, 1075.6663, 1222.7347, 1335.8187, 1436.8664, 1535.9348, 1698.9982, 1756.0196, 1869.1037, 1982.1878, 2039.2092, 2202.2725, 2331.3151, 2428.3679, 2541.4520, 2642.4996, 2805.5630, 2876.6001, 2991.6270, 3154.6904, 3253.7588, 3416.8221, 3513.8749, 3600.9069, 3786.9862, 3858.0233, 3972.0662, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SSYISSLDIVVDIMDCCLEYTQMDVPSSDTAIYIK", {88.0393, 175.0713, 338.1347, 451.2187, 538.2508, 625.2828, 738.3668, 853.3938, 966.4779, 1065.5463, 1164.6147, 1279.6416, 1392.7257, 1523.7662, 1638.7931, 1798.8238, 1958.8544, 2071.9385, 2200.9811, 2364.0444, 2465.0921, 2593.1507, 2724.1911, 2839.2181, 2938.2865, 3035.3393, 3122.3713, 3209.4033, 3324.4303, 3425.4779, 3496.5151, 3609.5991, 3772.6624, 3885.7465, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 423.2602, 536.3443, 607.3814, 708.4291, 823.4560, 910.4880, 997.5201, 1094.5728, 1193.6412, 1308.6682, 1439.7087, 1567.7672, 1668.8149, 1831.8782, 1960.9208, 2074.0049, 2234.0355, 2394.0662, 2509.0931, 2640.1336, 2753.2177, 2868.2446, 2967.3130, 3066.3815, 3179.4655, 3294.4925, 3407.5765, 3494.6086, 3581.6406, 3694.7247, 3857.7880, 3944.8200, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VPGCLYAQNGIFAELFDYAEYIADIQSRPVETINK", {100.0757, 197.1285, 254.1499, 414.1806, 527.2646, 690.3280, 761.3651, 889.4237, 1003.4666, 1060.4880, 1173.5721, 1320.6405, 1391.6776, 1520.7202, 1633.8043, 1780.8727, 1895.8996, 2058.9630, 2130.0001, 2259.0427, 2422.1060, 2535.1901, 2606.2272, 2721.2541, 2834.3382, 2962.3968, 3049.4288, 3205.5299, 3302.5827, 3401.6511, 3530.6937, 3631.7414, 3744.8254, 3858.8684, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 261.1557, 374.2398, 475.2875, 604.3301, 703.3985, 800.4512, 956.5524, 1043.5844, 1171.6430, 1284.7270, 1399.7540, 1470.7911, 1583.8751, 1746.9385, 1875.9811, 1947.0182, 2110.0815, 2225.1085, 2372.1769, 2485.2609, 2614.3035, 2685.3406, 2832.4091, 2945.4931, 3002.5146, 3116.5575, 3244.6161, 3315.6532, 3478.7165, 3591.8006, 3751.8312, 3808.8527, 3905.9055, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DDAQNDDADMEQLMSDLETDSIEDMTSCFTLPQSR", {116.0342, 231.0612, 302.0983, 430.1569, 544.1998, 659.2267, 774.2537, 845.2908, 960.3177, 1091.3582, 1220.4008, 1348.4594, 1461.5434, 1592.5839, 1679.6160, 1794.6429, 1907.7270, 2036.7696, 2137.8172, 2252.8442, 2339.8762, 2452.9603, 2582.0029, 2697.0298, 2828.0703, 2929.1180, 3016.1500, 3176.1806, 3323.2491, 3424.2967, 3537.3808, 3634.4336, 3762.4921, 3849.5242, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 262.1510, 390.2096, 487.2623, 600.3464, 701.3941, 848.4625, 1008.4931, 1095.5252, 1196.5728, 1327.6133, 1442.6403, 1571.6829, 1684.7669, 1771.7989, 1886.8259, 1987.8736, 2116.9162, 2230.0002, 2345.0272, 2432.0592, 2563.0997, 2676.1837, 2804.2423, 2933.2849, 3064.3254, 3179.3523, 3250.3895, 3365.4164, 3480.4433, 3594.4863, 3722.5448, 3793.5820, 3908.6089, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"THYAELMGNTAHLQQVYANHADIYETLSHQSPNQR", {102.0550, 239.1139, 402.1772, 473.2143, 602.2569, 715.3410, 846.3815, 903.4029, 1017.4458, 1118.4935, 1189.5306, 1326.5895, 1439.6736, 1567.7322, 1695.7908, 1794.8592, 1957.9225, 2028.9596, 2143.0025, 2280.0615, 2351.0986, 2466.1255, 2579.2096, 2742.2729, 2871.3155, 2972.3632, 3085.4472, 3172.4793, 3309.5382, 3437.5968, 3524.6288, 3621.6816, 3735.7245, 3863.7831, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 417.2205, 514.2732, 601.3052, 729.3638, 866.4227, 953.4548, 1066.5388, 1167.5865, 1296.6291, 1459.6924, 1572.7765, 1687.8034, 1758.8406, 1895.8995, 2009.9424, 2080.9795, 2244.0428, 2343.1112, 2471.1698, 2599.2284, 2712.3125, 2849.3714, 2920.4085, 3021.4562, 3135.4991, 3192.5206, 3323.5610, 3436.6451, 3565.6877, 3636.7248, 3799.7881, 3936.8471, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VALVSLALINLFLHWLGIMLTATHVHLGFCCTFEK", {100.0757, 171.1128, 284.1969, 383.2653, 470.2973, 583.3814, 654.4185, 767.5026, 880.5866, 994.6295, 1107.7136, 1254.7820, 1367.8661, 1504.9250, 1691.0043, 1804.0884, 1861.1098, 1974.1939, 2105.2344, 2218.3185, 2319.3661, 2390.4032, 2491.4509, 2628.5098, 2727.5782, 2864.6372, 2977.7212, 3034.7427, 3181.8111, 3341.8417, 3501.8724, 3602.9201, 3749.9885, 3879.0311, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 276.1554, 423.2238, 524.2715, 684.3021, 844.3328, 991.4012, 1048.4227, 1161.5067, 1298.5656, 1397.6341, 1534.6930, 1635.7406, 1706.7778, 1807.8254, 1920.9095, 2051.9500, 2165.0340, 2222.0555, 2335.1396, 2521.2189, 2658.2778, 2771.3619, 2918.4303, 3031.5143, 3145.5573, 3258.6413, 3371.7254, 3442.7625, 3555.8466, 3642.8786, 3741.9470, 3855.0311, 3926.0682, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MTNLEGVCAQTLDIELLHNHFSQMISFFVDEGYGK", {132.0478, 233.0954, 347.1384, 460.2224, 589.2650, 646.2865, 745.3549, 905.3856, 976.4227, 1104.4812, 1205.5289, 1318.6130, 1433.6399, 1546.7240, 1675.7666, 1788.8506, 1901.9347, 2038.9936, 2153.0366, 2290.0955, 2437.1639, 2524.1959, 2652.2545, 2783.2950, 2896.3790, 2983.4111, 3130.4795, 3277.5479, 3376.6163, 3491.6432, 3620.6858, 3677.7073, 3840.7706, 3897.7921, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 204.1343, 367.1976, 424.2191, 553.2617, 668.2886, 767.3570, 914.4254, 1061.4938, 1148.5259, 1261.6099, 1392.6504, 1520.7090, 1607.7410, 1754.8094, 1891.8683, 2005.9113, 2142.9702, 2256.0543, 2369.1383, 2498.1809, 2611.2650, 2726.2919, 2839.3760, 2940.4237, 3068.4822, 3139.5193, 3299.5500, 3398.6184, 3455.6399, 3584.6825, 3697.7665, 3811.8095, 3912.8571, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TIAAFLEEEDEGDFPPQGVLMEYLLVGYAWWDVSK", {102.0550, 215.1390, 286.1761, 357.2132, 504.2817, 617.3657, 746.4083, 875.4509, 1004.4935, 1119.5204, 1248.5630, 1305.5845, 1420.6114, 1567.6799, 1664.7326, 1761.7854, 1889.8440, 1946.8654, 2045.9338, 2159.0179, 2290.0584, 2419.1010, 2582.1643, 2695.2484, 2808.3324, 2907.4009, 2964.4223, 3127.4856, 3198.5228, 3384.6021, 3570.6814, 3685.7083, 3784.7767, 3871.8088, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 234.1448, 333.2132, 448.2402, 634.3195, 820.3988, 891.4359, 1054.4993, 1111.5207, 1210.5891, 1323.6732, 1436.7573, 1599.8206, 1728.8632, 1859.9037, 1972.9877, 2072.0561, 2129.0776, 2257.1362, 2354.1890, 2451.2417, 2598.3101, 2713.3371, 2770.3585, 2899.4011, 3014.4281, 3143.4707, 3272.5133, 3401.5559, 3514.6399, 3661.7083, 3732.7454, 3803.7826, 3916.8666, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YHILDKPATIEPGNFVSPENMDNWLMVDATVTQFK", {164.0706, 301.1295, 414.2136, 527.2976, 642.3246, 770.4196, 867.4723, 938.5094, 1039.5571, 1152.6412, 1281.6838, 1378.7365, 1435.7580, 1549.8009, 1696.8693, 1795.9377, 1882.9698, 1980.0225, 2109.0651, 2223.1081, 2354.1485, 2469.1755, 2583.2184, 2769.2977, 2882.3818, 3013.4223, 3112.4907, 3227.5176, 3298.5547, 3399.6024, 3498.6708, 3599.7185, 3727.7771, 3874.8455, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 294.1812, 422.2398, 523.2875, 622.3559, 723.4036, 794.4407, 909.4676, 1008.5360, 1139.5765, 1252.6606, 1438.7399, 1552.7828, 1667.8098, 1798.8503, 1912.8932, 2041.9358, 2138.9885, 2226.0206, 2325.0890, 2472.1574, 2586.2003, 2643.2218, 2740.2746, 2869.3171, 2982.4012, 3083.4489, 3154.4860, 3251.5388, 3379.6337, 3494.6607, 3607.7447, 3720.8288, 3857.8877, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TQQQQELAAQLLEANPMAEFHQLLQFESGTENIYK", {102.0550, 230.1135, 358.1721, 486.2307, 614.2893, 743.3319, 856.4159, 927.4530, 998.4901, 1126.5487, 1239.6328, 1352.7169, 1481.7594, 1552.7966, 1666.8395, 1763.8923, 1894.9327, 1965.9699, 2095.0124, 2242.0809, 2379.1398, 2507.1983, 2620.2824, 2733.3665, 2861.4251, 3008.4935, 3137.5361, 3224.5681, 3281.5896, 3382.6372, 3511.6798, 3625.7228, 3738.8068, 3901.8701, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 310.1761, 423.2602, 537.3031, 666.3457, 767.3934, 824.4149, 911.4469, 1040.4895, 1187.5579, 1315.6165, 1428.7005, 1541.7846, 1669.8432, 1806.9021, 1953.9705, 2083.0131, 2154.0502, 2285.0907, 2382.1435, 2496.1864, 2567.2235, 2696.2661, 2809.3502, 2922.4342, 3050.4928, 3121.5299, 3192.5670, 3305.6511, 3434.6937, 3562.7523, 3690.8108, 3818.8694, 3946.9280, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DNATMENEVVDSPEVDPPVFESQLDEITTQQLCFK", {116.0342, 230.0771, 301.1143, 402.1619, 533.2024, 662.2450, 776.2879, 905.3305, 1004.3990, 1103.4674, 1218.4943, 1305.5263, 1402.5791, 1531.6217, 1630.6901, 1745.7171, 1842.7698, 1939.8226, 2038.8910, 2185.9594, 2315.0020, 2402.0340, 2530.0926, 2643.1767, 2758.2036, 2887.2462, 3000.3303, 3101.3779, 3202.4256, 3330.4842, 3458.5428, 3571.6268, 3731.6575, 3878.7259, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 294.1812, 454.2119, 567.2959, 695.3545, 823.4131, 924.4608, 1025.5084, 1138.5925, 1267.6351, 1382.6620, 1495.7461, 1623.8047, 1710.8367, 1839.8793, 1986.9477, 2086.0161, 2183.0689, 2280.1217, 2395.1486, 2494.2170, 2623.2596, 2720.3124, 2807.3444, 2922.3713, 3021.4398, 3120.5082, 3249.5508, 3363.5937, 3492.6363, 3623.6768, 3724.7245, 3795.7616, 3909.8045, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PLSEAFHDWVYSPMTAHDNSSVIPMNSITTMNRPR", {98.0600, 211.1441, 298.1761, 427.2187, 498.2558, 645.3243, 782.3832, 897.4101, 1083.4894, 1182.5578, 1345.6212, 1432.6532, 1529.7060, 1660.7464, 1761.7941, 1832.8312, 1969.8901, 2084.9171, 2198.9600, 2285.9920, 2373.0241, 2472.0925, 2585.1766, 2682.2293, 2813.2698, 2927.3127, 3014.3448, 3127.4288, 3228.4765, 3329.5242, 3460.5647, 3574.6076, 3730.7087, 3827.7615, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 272.1717, 428.2728, 542.3158, 673.3562, 774.4039, 875.4516, 988.5357, 1075.5677, 1189.6106, 1320.6511, 1417.7039, 1530.7879, 1629.8563, 1716.8884, 1803.9204, 1917.9633, 2032.9903, 2170.0492, 2241.0863, 2342.1340, 2473.1745, 2570.2272, 2657.2593, 2820.3226, 2919.3910, 3105.4703, 3220.4972, 3357.5562, 3504.6246, 3575.6617, 3704.7043, 3791.7363, 3904.8204, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"WLLQFVTVCYGPVFAFSAYLILSVFSGLLVNLFVK", {187.0866, 300.1707, 413.2547, 541.3133, 688.3817, 787.4501, 888.4978, 987.5662, 1147.5969, 1310.6602, 1367.6817, 1464.7344, 1563.8028, 1710.8712, 1781.9084, 1928.9768, 2016.0088, 2087.0459, 2250.1092, 2363.1933, 2476.2774, 2589.3614, 2676.3935, 2775.4619, 2922.5303, 3009.5623, 3066.5838, 3179.6679, 3292.7519, 3391.8203, 3505.8633, 3618.9473, 3766.0157, 3865.0841, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 246.1812, 393.2496, 506.3337, 620.3766, 719.4450, 832.5291, 945.6132, 1002.6346, 1089.6667, 1236.7351, 1335.8035, 1422.8355, 1535.9196, 1649.0036, 1762.0877, 1925.1510, 1996.1881, 2083.2202, 2230.2886, 2301.3257, 2448.3941, 2547.4625, 2644.5153, 2701.5368, 2864.6001, 3024.6307, 3123.6992, 3224.7468, 3323.8152, 3470.8837, 3598.9422, 3712.0263, 3825.1104, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"YDENVPSCETVFIVTSVATTDFEIHFDELLNTLSK", {164.0706, 279.0975, 408.1401, 522.1831, 621.2515, 718.3042, 805.3363, 965.3669, 1094.4095, 1195.4572, 1294.5256, 1441.5940, 1554.6781, 1653.7465, 1754.7942, 1841.8262, 1940.8946, 2011.9317, 2112.9794, 2214.0271, 2329.0540, 2476.1224, 2605.1650, 2718.2491, 2855.3080, 3002.3764, 3117.4034, 3246.4460, 3359.5300, 3472.6141, 3586.6570, 3687.7047, 3800.7888, 3887.8208, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 234.1448, 347.2289, 448.2766, 562.3195, 675.4036, 788.4876, 917.5302, 1032.5572, 1179.6256, 1316.6845, 1429.7686, 1558.8111, 1705.8796, 1820.9065, 1921.9542, 2023.0019, 2094.0390, 2193.1074, 2280.1394, 2381.1871, 2480.2555, 2593.3396, 2740.4080, 2839.4764, 2940.5241, 3069.5667, 3229.5973, 3316.6294, 3413.6821, 3512.7505, 3626.7935, 3755.8361, 3870.8630, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EPITYFQLFGVFSNEHYLSFATGNLTTSPYTYDSK", {130.0499, 227.1026, 340.1867, 441.2344, 604.2977, 751.3661, 879.4247, 992.5088, 1139.5772, 1196.5986, 1295.6671, 1442.7355, 1529.7675, 1643.8104, 1772.8530, 1909.9119, 2072.9753, 2186.0593, 2273.0913, 2420.1598, 2491.1969, 2592.2446, 2649.2660, 2763.3089, 2876.3930, 2977.4407, 3078.4884, 3165.5204, 3262.5732, 3425.6365, 3526.6842, 3689.7475, 3804.7744, 3891.8065, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 234.1448, 349.1718, 512.2351, 613.2828, 776.3461, 873.3989, 960.4309, 1061.4786, 1162.5263, 1275.6103, 1389.6533, 1446.6747, 1547.7224, 1618.7595, 1765.8279, 1852.8600, 1965.9440, 2129.0073, 2266.0663, 2395.1088, 2509.1518, 2596.1838, 2743.2522, 2842.3206, 2899.3421, 3046.4105, 3159.4946, 3287.5532, 3434.6216, 3597.6849, 3698.7326, 3811.8166, 3908.8694, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SGHDLHDLHHPSGGYLHQLQQPEYQDKPSSSYDLK", {88.0393, 145.0608, 282.1197, 397.1466, 510.2307, 647.2896, 762.3165, 875.4006, 1012.4595, 1149.5184, 1246.5712, 1333.6032, 1390.6247, 1447.6462, 1610.7095, 1723.7935, 1860.8525, 1988.9110, 2101.9951, 2230.0537, 2358.1123, 2455.1650, 2584.2076, 2747.2709, 2875.3295, 2990.3565, 3118.4514, 3215.5042, 3302.5362, 3389.5682, 3476.6003, 3639.6636, 3754.6905, 3867.7746, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 375.2238, 538.2871, 625.3192, 712.3512, 799.3832, 896.4360, 1024.5310, 1139.5579, 1267.6165, 1430.6798, 1559.7224, 1656.7752, 1784.8337, 1912.8923, 2025.9764, 2154.0350, 2291.0939, 2404.1779, 2567.2413, 2624.2627, 2681.2842, 2768.3162, 2865.3690, 3002.4279, 3139.4868, 3252.5709, 3367.5978, 3504.6567, 3617.7408, 3732.7677, 3869.8266, 3926.8481, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DTRPLIQAIFPSKPIDENDCLIHVAYEGVATPHYK", {116.0342, 217.0819, 373.1830, 470.2358, 583.3198, 696.4039, 824.4625, 895.4996, 1008.5837, 1155.6521, 1252.7048, 1339.7369, 1467.8318, 1564.8846, 1677.9687, 1792.9956, 1922.0382, 2036.0811, 2151.1081, 2311.1387, 2424.2228, 2537.3068, 2674.3657, 2773.4342, 2844.4713, 3007.5346, 3136.5772, 3193.5987, 3292.6671, 3363.7042, 3464.7519, 3561.8046, 3698.8635, 3861.9269, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 310.1761, 447.2350, 544.2878, 645.3355, 716.3726, 815.4410, 872.4625, 1001.5051, 1164.5684, 1235.6055, 1334.6739, 1471.7328, 1584.8169, 1697.9010, 1857.9316, 1972.9586, 2087.0015, 2216.0441, 2331.0710, 2444.1551, 2541.2079, 2669.3028, 2756.3348, 2853.3876, 3000.4560, 3113.5401, 3184.5772, 3312.6358, 3425.7198, 3538.8039, 3635.8567, 3791.9578, 3893.0055, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SGDEDLQNCIDPIELLPISEPMFEMVGLNEEAEDR", {88.0393, 145.0608, 260.0877, 389.1303, 504.1572, 617.2413, 745.2999, 859.3428, 1019.3735, 1132.4575, 1247.4845, 1344.5372, 1457.6213, 1586.6639, 1699.7480, 1812.8320, 1909.8848, 2022.9688, 2110.0009, 2239.0435, 2336.0962, 2467.1367, 2614.2051, 2743.2477, 2874.2882, 2973.3566, 3030.3781, 3143.4622, 3257.5051, 3386.5477, 3515.5903, 3586.6274, 3715.6700, 3830.6969, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 290.1459, 419.1885, 490.2256, 619.2682, 748.3108, 862.3537, 975.4378, 1032.4592, 1131.5277, 1262.5681, 1391.6107, 1538.6791, 1669.7196, 1766.7724, 1895.8150, 1982.8470, 2095.9311, 2192.9838, 2306.0679, 2419.1520, 2548.1946, 2661.2786, 2758.3314, 2873.3583, 2986.4424, 3146.4731, 3260.5160, 3388.5746, 3501.6586, 3616.6856, 3745.7282, 3860.7551, 3917.7766, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QNPMNSYHAAGPDGYGLLIDHLWPPVVCETNMLHR", {129.0659, 243.1088, 340.1615, 471.2020, 585.2450, 672.2770, 835.3403, 972.3992, 1043.4363, 1114.4735, 1171.4949, 1268.5477, 1383.5746, 1440.5961, 1603.6594, 1660.6809, 1773.7649, 1886.8490, 1999.9331, 2114.9600, 2252.0189, 2365.1030, 2551.1823, 2648.2351, 2745.2878, 2844.3562, 2943.4247, 3103.4553, 3232.4979, 3333.5456, 3447.5885, 3578.6290, 3691.7131, 3828.7720, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 312.1779, 425.2619, 556.3024, 670.3453, 771.3930, 900.4356, 1060.4663, 1159.5347, 1258.6031, 1355.6559, 1452.7086, 1638.7879, 1751.8720, 1888.9309, 2003.9578, 2117.0419, 2230.1260, 2343.2100, 2400.2315, 2563.2948, 2620.3163, 2735.3432, 2832.3960, 2889.4175, 2960.4546, 3031.4917, 3168.5506, 3331.6139, 3418.6460, 3532.6889, 3663.7294, 3760.7821, 3874.8251, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SLLHSSYDVTNATNALTQWSQNVNQLIQQNLVEER", {88.0393, 201.1234, 314.2074, 451.2663, 538.2984, 625.3304, 788.3937, 903.4207, 1002.4891, 1103.5368, 1217.5797, 1288.6168, 1389.6645, 1503.7074, 1574.7445, 1687.8286, 1788.8763, 1916.9348, 2103.0142, 2190.0462, 2318.1048, 2432.1477, 2531.2161, 2645.2590, 2773.3176, 2886.4017, 2999.4857, 3127.5443, 3255.6029, 3369.6458, 3482.7299, 3581.7983, 3710.8409, 3839.8835, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 433.2041, 532.2726, 645.3566, 759.3995, 887.4581, 1015.5167, 1128.6008, 1241.6848, 1369.7434, 1483.7863, 1582.8547, 1696.8977, 1824.9563, 1911.9883, 2098.0676, 2226.1262, 2327.1738, 2440.2579, 2511.2950, 2625.3380, 2726.3856, 2797.4227, 2911.4657, 3012.5134, 3111.5818, 3226.6087, 3389.6720, 3476.7041, 3563.7361, 3700.7950, 3813.8791, 3926.9631, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DDVTTVELDYPAGQALEENTYYCWLDLAAVNNQPR", {116.0342, 231.0612, 330.1296, 431.1773, 532.2249, 631.2933, 760.3359, 873.4200, 988.4469, 1151.5103, 1248.5630, 1319.6002, 1376.6216, 1504.6802, 1575.7173, 1688.8014, 1817.8440, 1946.8866, 2060.9295, 2161.9772, 2325.0405, 2488.1038, 2648.1345, 2834.2138, 2947.2978, 3062.3248, 3175.4089, 3246.4460, 3317.4831, 3416.5515, 3530.5944, 3644.6374, 3772.6959, 3869.7487, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 272.1717, 400.2303, 514.2732, 628.3161, 727.3846, 798.4217, 869.4588, 982.5429, 1097.5698, 1210.6539, 1396.7332, 1556.7638, 1719.8272, 1882.8905, 1983.9382, 2097.9811, 2227.0237, 2356.0663, 2469.1503, 2540.1874, 2668.2460, 2725.2675, 2796.3046, 2893.3574, 3056.4207, 3171.4476, 3284.5317, 3413.5743, 3512.6427, 3613.6904, 3714.7381, 3813.8065, 3928.8334, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"WPGTPVTVIGYCAQHVAVTCNQGDCYVLPNEPWGR", {187.0866, 284.1394, 341.1608, 442.2085, 539.2613, 638.3297, 739.3774, 838.4458, 951.5298, 1008.5513, 1171.6146, 1331.6453, 1402.6824, 1530.7410, 1667.7999, 1766.8683, 1837.9054, 1936.9738, 2038.0215, 2198.0521, 2312.0951, 2440.1536, 2497.1751, 2612.2021, 2772.2327, 2935.2960, 3034.3644, 3147.4485, 3244.5013, 3358.5442, 3487.5868, 3584.6396, 3770.7189, 3827.7403, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 232.1404, 418.2197, 515.2725, 644.3151, 758.3580, 855.4108, 968.4948, 1067.5633, 1230.6266, 1390.6572, 1505.6842, 1562.7056, 1690.7642, 1804.8071, 1964.8378, 2065.8855, 2164.9539, 2235.9910, 2335.0594, 2472.1183, 2600.1769, 2671.2140, 2831.2447, 2994.3080, 3051.3295, 3164.4135, 3263.4819, 3364.5296, 3463.5980, 3560.6508, 3661.6985, 3718.7199, 3815.7727, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LSIHVLSYISLILANHGEGENHGSIFFFWDLPNIR", {114.0913, 201.1234, 314.2074, 451.2663, 550.3348, 663.4188, 750.4509, 913.5142, 1026.5982, 1113.6303, 1226.7143, 1339.7984, 1452.8825, 1523.9196, 1637.9625, 1775.0214, 1832.0429, 1961.0855, 2018.1069, 2147.1495, 2261.1925, 2398.2514, 2455.2728, 2542.3049, 2655.3889, 2802.4573, 2949.5258, 3096.5942, 3282.6735, 3397.7004, 3510.7845, 3607.8373, 3721.8802, 3834.9642, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 402.2459, 499.2987, 612.3828, 727.4097, 913.4890, 1060.5574, 1207.6259, 1354.6943, 1467.7783, 1554.8104, 1611.8318, 1748.8907, 1862.9337, 1991.9763, 2048.9977, 2178.0403, 2235.0618, 2372.1207, 2486.1636, 2557.2007, 2670.2848, 2783.3689, 2896.4529, 2983.4850, 3096.5690, 3259.6323, 3346.6644, 3459.7484, 3558.8169, 3695.8758, 3808.9598, 3895.9919, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DLIQSEIETICASSYTLLLPNDETQAVFPCEEACK", {116.0342, 229.1183, 342.2023, 470.2609, 557.2930, 686.3355, 799.4196, 928.4622, 1029.5099, 1142.5939, 1302.6246, 1373.6617, 1460.6937, 1547.7258, 1710.7891, 1811.8368, 1924.9208, 2038.0049, 2151.0890, 2248.1417, 2362.1847, 2477.2116, 2606.2542, 2707.3019, 2835.3604, 2906.3976, 3005.4660, 3152.5344, 3249.5872, 3409.6178, 3538.6604, 3667.7030, 3738.7401, 3898.7708, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 307.1435, 378.1806, 507.2232, 636.2658, 796.2964, 893.3492, 1040.4176, 1139.4860, 1210.5231, 1338.5817, 1439.6294, 1568.6720, 1683.6989, 1797.7418, 1894.7946, 2007.8787, 2120.9627, 2234.0468, 2335.0945, 2498.1578, 2585.1898, 2672.2218, 2743.2590, 2903.2896, 3016.3737, 3117.4214, 3246.4639, 3359.5480, 3488.5906, 3575.6226, 3703.6812, 3816.7653, 3929.8493, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LEWEGNLVYSSIDGGTEDQLQLDLQFGDYTWSGFK", {114.0913, 243.1339, 429.2132, 558.2558, 615.2773, 729.3202, 842.4043, 941.4727, 1104.5360, 1191.5681, 1278.6001, 1391.6842, 1506.7111, 1563.7326, 1620.7540, 1721.8017, 1850.8443, 1965.8712, 2093.9298, 2207.0139, 2335.0725, 2448.1565, 2563.1835, 2676.2675, 2804.3261, 2951.3945, 3008.4160, 3123.4429, 3286.5063, 3387.5539, 3573.6333, 3660.6653, 3717.6867, 3864.7552, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 294.1812, 351.2027, 438.2347, 624.3140, 725.3617, 888.4250, 1003.4520, 1060.4734, 1207.5419, 1335.6004, 1448.6845, 1563.7114, 1676.7955, 1804.8541, 1917.9381, 2045.9967, 2161.0237, 2290.0663, 2391.1139, 2448.1354, 2505.1569, 2620.1838, 2733.2679, 2820.2999, 2907.3319, 3070.3953, 3169.4637, 3282.5477, 3396.5907, 3453.6121, 3582.6547, 3768.7340, 3897.7766, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"AQELSILQLGFIATISFFAIPSWCLFDTFVLLAMR", {72.0444, 200.1030, 329.1456, 442.2296, 529.2617, 642.3457, 755.4298, 883.4884, 996.5724, 1053.5939, 1200.6623, 1313.7464, 1384.7835, 1485.8312, 1598.9152, 1685.9472, 1833.0157, 1980.0841, 2051.1212, 2164.2053, 2261.2580, 2348.2900, 2534.3694, 2694.4000, 2807.4841, 2954.5525, 3069.5794, 3170.6271, 3317.6955, 3416.7639, 3529.8480, 3642.9321, 3713.9692, 3845.0097, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 306.1594, 377.1966, 490.2806, 603.3647, 702.4331, 849.5015, 950.5492, 1065.5761, 1212.6445, 1325.7286, 1485.7593, 1671.8386, 1758.8706, 1855.9234, 1969.0074, 2040.0445, 2187.1130, 2334.1814, 2421.2134, 2534.2975, 2635.3451, 2706.3823, 2819.4663, 2966.5347, 3023.5562, 3136.6403, 3264.6988, 3377.7829, 3490.8670, 3577.8990, 3690.9831, 3820.0256, 3948.0842, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DNCIPTAQESVWAAVFDTNENITLTVFEEIIENLK", {116.0342, 230.0771, 390.1078, 503.1919, 600.2446, 701.2923, 772.3294, 900.3880, 1029.4306, 1116.4626, 1215.5310, 1401.6103, 1472.6475, 1543.6846, 1642.7530, 1789.8214, 1904.8483, 2005.8960, 2119.9389, 2248.9815, 2363.0245, 2476.1085, 2577.1562, 2690.2403, 2791.2880, 2890.3564, 3037.4248, 3166.4674, 3295.5100, 3408.5940, 3521.6781, 3650.7207, 3764.7636, 3877.8477, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 374.2398, 503.2824, 616.3665, 729.4505, 858.4931, 987.5357, 1134.6041, 1233.6725, 1334.7202, 1447.8043, 1548.8520, 1661.9360, 1775.9789, 1905.0215, 2019.0645, 2120.1121, 2235.1391, 2382.2075, 2481.2759, 2552.3130, 2623.3501, 2809.4295, 2908.4979, 2995.5299, 3124.5725, 3252.6311, 3323.6682, 3424.7159, 3521.7686, 3634.8527, 3794.8833, 3908.9263, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DMNMTIIEYQDLGQLEFNEVGFTGSFEGSNIEFSR", {116.0342, 247.0747, 361.1176, 492.1581, 593.2058, 706.2899, 819.3739, 948.4165, 1111.4798, 1239.5384, 1354.5654, 1467.6494, 1524.6709, 1652.7295, 1765.8135, 1894.8561, 2041.9245, 2155.9675, 2285.0101, 2384.0785, 2441.0999, 2588.1684, 2689.2160, 2746.2375, 2833.2695, 2980.3379, 3109.3805, 3166.4020, 3253.4340, 3367.4770, 3480.5610, 3609.6036, 3756.6720, 3843.7041, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 262.1510, 409.2194, 538.2620, 651.3461, 765.3890, 852.4210, 909.4425, 1038.4851, 1185.5535, 1272.5855, 1329.6070, 1430.6546, 1577.7231, 1634.7445, 1733.8129, 1862.8555, 1976.8985, 2123.9669, 2253.0095, 2366.0935, 2494.1521, 2551.1736, 2664.2576, 2779.2846, 2907.3432, 3070.4065, 3199.4491, 3312.5331, 3425.6172, 3526.6649, 3657.7054, 3771.7483, 3902.7888, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"GYSDSIHHAVDMPVGYDQVFELPLMCCWSEAGDLK", {58.0287, 221.0921, 308.1241, 423.1510, 510.1831, 623.2671, 760.3260, 897.3850, 968.4221, 1067.4905, 1182.5174, 1313.5579, 1410.6107, 1509.6791, 1566.7006, 1729.7639, 1844.7908, 1972.8494, 2071.9178, 2218.9862, 2348.0288, 2461.1129, 2558.1657, 2671.2497, 2802.2902, 2962.3208, 3122.3515, 3308.4308, 3395.4628, 3524.5054, 3595.5425, 3652.5640, 3767.5910, 3880.6750, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 375.2238, 432.2453, 503.2824, 632.3250, 719.3570, 905.4363, 1065.4670, 1225.4976, 1356.5381, 1469.6222, 1566.6749, 1679.7590, 1808.8016, 1955.8700, 2054.9384, 2182.9970, 2298.0239, 2461.0873, 2518.1087, 2617.1771, 2714.2299, 2845.2704, 2960.2973, 3059.3658, 3130.4029, 3267.4618, 3404.5207, 3517.6048, 3604.6368, 3719.6637, 3806.6958, 3969.7591, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"MTIDDGHVCFDCNNQDLVDLTTVYPAGLVVEDVWK", {132.0478, 233.0954, 346.1795, 461.2064, 576.2334, 633.2549, 770.3138, 869.3822, 1029.4128, 1176.4812, 1291.5082, 1451.5388, 1565.5818, 1679.6247, 1807.6833, 1922.7102, 2035.7943, 2134.8627, 2249.8896, 2362.9737, 2464.0214, 2565.0691, 2664.1375, 2827.2008, 2924.2536, 2995.2907, 3052.3121, 3165.3962, 3264.4646, 3363.5330, 3492.5756, 3607.6026, 3706.6710, 3892.7503, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 333.1921, 432.2605, 547.2875, 676.3301, 775.3985, 874.4669, 987.5510, 1044.5724, 1115.6095, 1212.6623, 1375.7256, 1474.7940, 1575.8417, 1676.8894, 1789.9735, 1905.0004, 2004.0688, 2117.1529, 2232.1798, 2360.2384, 2474.2813, 2588.3243, 2748.3549, 2863.3819, 3010.4503, 3170.4809, 3269.5493, 3406.6082, 3463.6297, 3578.6566, 3693.6836, 3806.7677, 3907.8153, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NMVIFACGRPVIQDISVIDGYEGFTDSLEEQYVLK", {115.0502, 246.0907, 345.1591, 458.2432, 605.3116, 676.3487, 836.3793, 893.4008, 1049.5019, 1146.5547, 1245.6231, 1358.7072, 1486.7657, 1601.7927, 1714.8767, 1801.9088, 1900.9772, 2014.0613, 2129.0882, 2186.1097, 2349.1730, 2478.2156, 2535.2370, 2682.3055, 2783.3531, 2898.3801, 2985.4121, 3098.4962, 3227.5388, 3356.5814, 3484.6399, 3647.7033, 3746.7717, 3859.8557, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 359.2653, 522.3286, 650.3872, 779.4298, 908.4724, 1021.5564, 1108.5885, 1223.6154, 1324.6631, 1471.7315, 1528.7530, 1657.7956, 1820.8589, 1877.8804, 1992.9073, 2105.9914, 2205.0598, 2292.0918, 2405.1759, 2520.2028, 2648.2614, 2761.3454, 2860.4139, 2957.4666, 3113.5677, 3170.5892, 3330.6199, 3401.6570, 3548.7254, 3661.8094, 3760.8779, 3891.9183, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VLSQVFPEAYQPLGIDPLWETAVWTHGLQTILPYR", {100.0757, 213.1598, 300.1918, 428.2504, 527.3188, 674.3872, 771.4400, 900.4825, 971.5197, 1134.5830, 1262.6416, 1359.6943, 1472.7784, 1529.7999, 1642.8839, 1757.9109, 1854.9636, 1968.0477, 2154.1270, 2283.1696, 2384.2173, 2455.2544, 2554.3228, 2740.4021, 2841.4498, 2978.5087, 3035.5302, 3148.6142, 3276.6728, 3377.7205, 3490.8046, 3603.8886, 3700.9414, 3864.0047, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 338.1823, 435.2350, 548.3191, 661.4032, 762.4509, 890.5094, 1003.5935, 1060.6150, 1197.6739, 1298.7215, 1484.8009, 1583.8693, 1654.9064, 1755.9541, 1884.9967, 2071.0760, 2184.1600, 2281.2128, 2396.2397, 2509.3238, 2566.3453, 2679.4293, 2776.4821, 2904.5407, 3067.6040, 3138.6411, 3267.6837, 3364.7365, 3511.8049, 3610.8733, 3738.9319, 3825.9639, 3939.0480, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"GYGYGDGYGEGSHESACILQISCILLQFVIWHQLR", {58.0287, 221.0921, 278.1135, 441.1769, 498.1983, 613.2253, 670.2467, 833.3101, 890.3315, 1019.3741, 1076.3956, 1163.4276, 1300.4865, 1429.5291, 1516.5611, 1587.5983, 1747.6289, 1860.7130, 1973.7970, 2101.8556, 2214.9397, 2301.9717, 2462.0024, 2575.0864, 2688.1705, 2801.2545, 2929.3131, 3076.3815, 3175.4499, 3288.5340, 3474.6133, 3611.6722, 3739.7308, 3852.8149, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 416.2616, 553.3205, 739.3998, 852.4839, 951.5523, 1098.6207, 1226.6793, 1339.7634, 1452.8474, 1565.9315, 1725.9621, 1812.9942, 1926.0782, 2054.1368, 2167.2209, 2280.3049, 2440.3356, 2511.3727, 2598.4047, 2727.4473, 2864.5062, 2951.5383, 3008.5597, 3137.6023, 3194.6238, 3357.6871, 3414.7086, 3529.7355, 3586.7570, 3749.8203, 3806.8418, 3969.9051, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NQAEFSEYSAELVFDPNNFQQSIVNGQYSASLQHR", {115.0502, 243.1088, 314.1459, 443.1885, 590.2569, 677.2889, 806.3315, 969.3949, 1056.4269, 1127.4640, 1256.5066, 1369.5907, 1468.6591, 1615.7275, 1730.7544, 1827.8072, 1941.8501, 2055.8930, 2202.9615, 2331.0200, 2459.0786, 2546.1106, 2659.1947, 2758.2631, 2872.3060, 2929.3275, 3057.3861, 3220.4494, 3307.4814, 3378.5186, 3465.5506, 3578.6346, 3706.6932, 3843.7521, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 312.1779, 440.2364, 553.3205, 640.3525, 711.3896, 798.4217, 961.4850, 1089.5436, 1146.5650, 1260.6080, 1359.6764, 1472.7605, 1559.7925, 1687.8511, 1815.9096, 1962.9780, 2077.0210, 2191.0639, 2288.1167, 2403.1436, 2550.2120, 2649.2804, 2762.3645, 2891.4071, 2962.4442, 3049.4762, 3212.5396, 3341.5822, 3428.6142, 3575.6826, 3704.7252, 3775.7623, 3903.8209, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TLLLRPLVAVVTSLMIVLWHVASAFCVFIVWYSSR", {102.0550, 215.1390, 328.2231, 441.3071, 597.4083, 694.4610, 807.5451, 906.6135, 977.6506, 1076.7190, 1175.7874, 1276.8351, 1363.8671, 1476.9512, 1607.9917, 1721.0758, 1820.1442, 1933.2282, 2119.3076, 2256.3665, 2355.4349, 2426.4720, 2513.5040, 2584.5411, 2731.6095, 2891.6402, 2990.7086, 3137.7770, 3250.8611, 3349.9295, 3536.0088, 3699.0721, 3786.1042, 3873.1362, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 262.1510, 349.1830, 512.2463, 698.3257, 797.3941, 910.4781, 1057.5465, 1156.6150, 1316.6456, 1463.7140, 1534.7511, 1621.7832, 1692.8203, 1791.8887, 1928.9476, 2115.0269, 2228.1110, 2327.1794, 2440.2635, 2571.3039, 2684.3880, 2771.4200, 2872.4677, 2971.5361, 3070.6045, 3141.6417, 3240.7101, 3353.7941, 3450.8469, 3606.9480, 3720.0321, 3833.1161, 3946.2002, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VDIGLIAFYFSGHETCFFFSCIALGCIIGFTVEQK", {100.0757, 215.1026, 328.1867, 385.2082, 498.2922, 611.3763, 682.4134, 829.4818, 992.5451, 1139.6136, 1226.6456, 1283.6671, 1420.7260, 1549.7686, 1650.8162, 1810.8469, 1957.9153, 2104.9837, 2252.0521, 2339.0842, 2499.1148, 2612.1989, 2683.2360, 2796.3200, 2853.3415, 3013.3722, 3126.4562, 3239.5403, 3296.5617, 3443.6302, 3544.6778, 3643.7463, 3772.7888, 3900.8474, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 275.1714, 404.2140, 503.2824, 604.3301, 751.3985, 808.4199, 921.5040, 1034.5881, 1194.6187, 1251.6402, 1364.7242, 1435.7614, 1548.8454, 1708.8761, 1795.9081, 1942.9765, 2090.0449, 2237.1133, 2397.1440, 2498.1917, 2627.2343, 2764.2932, 2821.3146, 2908.3467, 3055.4151, 3218.4784, 3365.5468, 3436.5839, 3549.6680, 3662.7521, 3719.7735, 3832.8576, 3947.8845, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LQVEEDDSSSLEIITDEIDDEEEEVEDKPLSALER", {114.0913, 242.1499, 341.2183, 470.2609, 599.3035, 714.3305, 829.3574, 916.3894, 1003.4215, 1090.4535, 1203.5376, 1332.5801, 1445.6642, 1558.7483, 1659.7960, 1774.8229, 1903.8655, 2016.9496, 2131.9765, 2247.0034, 2376.0460, 2505.0886, 2634.1312, 2763.1738, 2862.2422, 2991.2848, 3106.3118, 3234.4067, 3331.4595, 3444.5436, 3531.5756, 3602.6127, 3715.6968, 3844.7394, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 417.2456, 488.2827, 575.3148, 688.3988, 785.4516, 913.5465, 1028.5735, 1157.6161, 1256.6845, 1385.7271, 1514.7697, 1643.8123, 1772.8549, 1887.8818, 2002.9088, 2115.9928, 2245.0354, 2360.0624, 2461.1100, 2574.1941, 2687.2782, 2816.3208, 2929.4048, 3016.4368, 3103.4689, 3190.5009, 3305.5278, 3420.5548, 3549.5974, 3678.6400, 3777.7084, 3905.7670, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ISGLLFAWIWPLDLLFHSMVAMVVAEVCWPIIGLK", {114.0913, 201.1234, 258.1448, 371.2289, 484.3130, 631.3814, 702.4185, 888.4978, 1001.5819, 1187.6612, 1284.7139, 1397.7980, 1512.8249, 1625.9090, 1738.9931, 1886.0615, 2023.1204, 2110.1524, 2241.1929, 2340.2613, 2411.2984, 2542.3389, 2641.4073, 2740.4758, 2811.5129, 2940.5555, 3039.6239, 3199.6545, 3385.7338, 3482.7866, 3595.8707, 3708.9547, 3765.9762, 3879.0603, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 317.2183, 430.3024, 543.3865, 640.4392, 826.5185, 986.5492, 1085.6176, 1214.6602, 1285.6973, 1384.7657, 1483.8341, 1614.8746, 1685.9117, 1784.9801, 1916.0206, 2003.0527, 2140.1116, 2287.1800, 2400.2640, 2513.3481, 2628.3751, 2741.4591, 2838.5119, 3024.5912, 3137.6753, 3323.7546, 3394.7917, 3541.8601, 3654.9442, 3768.0282, 3825.0497, 3912.0817, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QFYGTVAPHEELHFLFAQPISCVVSGLWACALMIR", {129.0659, 276.1343, 439.1976, 496.2191, 597.2667, 696.3352, 767.3723, 864.4250, 1001.4839, 1130.5265, 1259.5691, 1372.6532, 1509.7121, 1656.7805, 1769.8646, 1916.9330, 1987.9701, 2116.0287, 2213.0815, 2326.1655, 2413.1975, 2573.2282, 2672.2966, 2771.3650, 2858.3970, 2915.4185, 3028.5026, 3214.5819, 3285.6190, 3445.6497, 3516.6868, 3629.7708, 3760.8113, 3873.8954, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 419.2435, 532.3276, 603.3647, 763.3953, 834.4324, 1020.5118, 1133.5958, 1190.6173, 1277.6493, 1376.7177, 1475.7861, 1635.8168, 1722.8488, 1835.9329, 1932.9856, 2061.0442, 2132.0813, 2279.1497, 2392.2338, 2539.3022, 2676.3611, 2789.4452, 2918.4878, 3047.5304, 3184.5893, 3281.6421, 3352.6792, 3451.7476, 3552.7953, 3609.8167, 3772.8801, 3919.9485, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LNLTEEQIELQMHWENVVSNEIDVIGANPYNLSAK", {114.0913, 228.1343, 341.2183, 442.2660, 571.3086, 700.3512, 828.4098, 941.4938, 1070.5364, 1183.6205, 1311.6791, 1442.7196, 1579.7785, 1765.8578, 1894.9004, 2008.9433, 2108.0117, 2207.0801, 2294.1122, 2408.1551, 2537.1977, 2650.2817, 2765.3087, 2864.3771, 2977.4612, 3034.4826, 3105.5197, 3219.5627, 3316.6154, 3479.6788, 3593.7217, 3706.8058, 3793.8378, 3864.8749, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 218.1499, 305.1819, 418.2660, 532.3089, 695.3723, 792.4250, 906.4680, 977.5051, 1034.5265, 1147.6106, 1246.6790, 1361.7060, 1474.7900, 1603.8326, 1717.8755, 1804.9076, 1903.9760, 2003.0444, 2117.0873, 2246.1299, 2432.2092, 2569.2681, 2700.3086, 2828.3672, 2941.4513, 3070.4939, 3183.5779, 3311.6365, 3440.6791, 3569.7217, 3670.7694, 3783.8534, 3897.8964, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ISVNMDMCCAGIFFGVSQAVITNILLFILMLFFLK", {114.0913, 201.1234, 300.1918, 414.2347, 545.2752, 660.3021, 791.3426, 951.3733, 1111.4039, 1182.4410, 1239.4625, 1352.5466, 1499.6150, 1646.6834, 1703.7049, 1802.7733, 1889.8053, 2017.8639, 2088.9010, 2187.9694, 2301.0535, 2402.1011, 2516.1441, 2629.2281, 2742.3122, 2855.3963, 3002.4647, 3115.5487, 3228.6328, 3359.6733, 3472.7574, 3619.8258, 3766.8942, 3879.9782, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 260.1969, 407.2653, 554.3337, 667.4178, 798.4582, 911.5423, 1024.6264, 1171.6948, 1284.7789, 1397.8629, 1510.9470, 1624.9899, 1726.0376, 1839.1216, 1938.1901, 2009.2272, 2137.2858, 2224.3178, 2323.3862, 2380.4077, 2527.4761, 2674.5445, 2787.6286, 2844.6500, 2915.6871, 3075.7178, 3235.7484, 3366.7889, 3481.8159, 3612.8563, 3726.8993, 3825.9677, 3912.9997, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SYSHCDSSACSSFNSQSDAACWVLHQAAEEDEEVR", {88.0393, 251.1026, 338.1347, 475.1936, 635.2242, 750.2512, 837.2832, 924.3152, 995.3523, 1155.3830, 1242.4150, 1329.4470, 1476.5155, 1590.5584, 1677.5904, 1805.6490, 1892.6810, 2007.7080, 2078.7451, 2149.7822, 2309.8128, 2495.8921, 2594.9606, 2708.0446, 2845.1035, 2973.1621, 3044.1992, 3115.2363, 3244.2789, 3373.3215, 3488.3485, 3617.3911, 3746.4337, 3845.5021, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 274.1874, 403.2300, 532.2726, 647.2995, 776.3421, 905.3847, 976.4218, 1047.4589, 1175.5175, 1312.5764, 1425.6605, 1524.7289, 1710.8082, 1870.8388, 1941.8760, 2012.9131, 2127.9400, 2214.9720, 2343.0306, 2430.0626, 2544.1056, 2691.1740, 2778.2060, 2865.2380, 3025.2687, 3096.3058, 3183.3378, 3270.3699, 3385.3968, 3545.4275, 3682.4864, 3769.5184, 3932.5817, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DCVDVIQLINHNASLSLSGINVQIYNNLFEEALQR", {116.0342, 276.0649, 375.1333, 490.1602, 589.2286, 702.3127, 830.3713, 943.4553, 1056.5394, 1170.5823, 1307.6412, 1421.6842, 1492.7213, 1579.7533, 1692.8374, 1779.8694, 1892.9535, 1979.9855, 2037.0070, 2150.0910, 2264.1340, 2363.2024, 2491.2609, 2604.3450, 2767.4083, 2881.4513, 2995.4942, 3108.5783, 3255.6467, 3384.6893, 3513.7319, 3584.7690, 3697.8530, 3825.9116, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 303.1775, 416.2616, 487.2987, 616.3413, 745.3839, 892.4523, 1005.5364, 1119.5793, 1233.6222, 1396.6856, 1509.7696, 1637.8282, 1736.8966, 1850.9395, 1964.0236, 2021.0451, 2108.0771, 2221.1612, 2308.1932, 2421.2773, 2508.3093, 2579.3464, 2693.3893, 2830.4482, 2944.4912, 3057.5752, 3170.6593, 3298.7179, 3411.8019, 3510.8703, 3625.8973, 3724.9657, 3884.9963, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LTSIFLVNDNPQLEYDLEGLLEWDTDNILVLIGPR", {114.0913, 215.1390, 302.1710, 415.2551, 562.3235, 675.4076, 774.4760, 888.5189, 1003.5459, 1117.5888, 1214.6416, 1342.7001, 1455.7842, 1584.8268, 1747.8901, 1862.9171, 1976.0011, 2105.0437, 2162.0652, 2275.1493, 2388.2333, 2517.2759, 2703.3552, 2818.3822, 2919.4298, 3034.4568, 3148.4997, 3261.5838, 3374.6678, 3473.7363, 3586.8203, 3699.9044, 3756.9259, 3853.9786, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 272.1717, 329.1932, 442.2772, 555.3613, 654.4297, 767.5138, 880.5978, 994.6408, 1109.6677, 1210.7154, 1325.7423, 1511.8217, 1640.8642, 1753.9483, 1867.0324, 1924.0538, 2053.0964, 2166.1805, 2281.2074, 2444.2708, 2573.3134, 2686.3974, 2814.4560, 2911.5088, 3025.5517, 3140.5786, 3254.6216, 3353.6900, 3466.7740, 3613.8425, 3726.9265, 3813.9585, 3915.0062, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"APEEEEIHNNDLEQLGDINTTSELILSESQLENFR", {72.0444, 169.0972, 298.1397, 427.1823, 556.2249, 685.2675, 798.3516, 935.4105, 1049.4534, 1163.4964, 1278.5233, 1391.6074, 1520.6500, 1648.7085, 1761.7926, 1818.8141, 1933.8410, 2046.9251, 2160.9680, 2262.0157, 2363.0634, 2450.0954, 2579.1380, 2692.2220, 2805.3061, 2918.3902, 3005.4222, 3134.4648, 3221.4968, 3349.5554, 3462.6395, 3591.6821, 3705.7250, 3852.7934, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 322.1874, 436.2303, 565.2729, 678.3570, 806.4155, 893.4476, 1022.4901, 1109.5222, 1222.6062, 1335.6903, 1448.7744, 1577.8170, 1664.8490, 1765.8967, 1866.9443, 1980.9873, 2094.0713, 2209.0983, 2266.1197, 2379.2038, 2507.2624, 2636.3050, 2749.3890, 2864.4160, 2978.4589, 3092.5018, 3229.5608, 3342.6448, 3471.6874, 3600.7300, 3729.7726, 3858.8152, 3955.8680, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QVPLEEEEPMPQPEPILEDEENPEAGQIINDNENK", {129.0659, 228.1343, 325.1870, 438.2711, 567.3137, 696.3563, 825.3989, 954.4415, 1051.4942, 1182.5347, 1279.5875, 1407.6461, 1504.6988, 1633.7414, 1730.7942, 1843.8782, 1956.9623, 2086.0049, 2201.0318, 2330.0744, 2459.1170, 2573.1600, 2670.2127, 2799.2553, 2870.2924, 2927.3139, 3055.3725, 3168.4565, 3281.5406, 3395.5835, 3510.6105, 3624.6534, 3753.6960, 3867.7389, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 261.1557, 390.1983, 504.2413, 619.2682, 733.3111, 846.3952, 959.4793, 1087.5378, 1144.5593, 1215.5964, 1344.6390, 1441.6918, 1555.7347, 1684.7773, 1813.8199, 1928.8468, 2057.8894, 2170.9735, 2284.0575, 2381.1103, 2510.1529, 2607.2057, 2735.2642, 2832.3170, 2963.3575, 3060.4103, 3189.4528, 3318.4954, 3447.5380, 3576.5806, 3689.6647, 3786.7175, 3885.7859, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VQEAQEVQEAQEVAQEVHEVHEVPEEPEEPEVETK", {100.0757, 228.1343, 357.1769, 428.2140, 556.2726, 685.3151, 784.3836, 912.4421, 1041.4847, 1112.5218, 1240.5804, 1369.6230, 1468.6914, 1539.7285, 1667.7871, 1796.8297, 1895.8981, 2032.9570, 2161.9996, 2261.0680, 2398.1270, 2527.1696, 2626.2380, 2723.2907, 2852.3333, 2981.3759, 3078.4287, 3207.4713, 3336.5139, 3433.5666, 3562.6092, 3661.6776, 3790.7202, 3891.7679, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 248.1605, 377.2031, 476.2715, 605.3141, 702.3668, 831.4094, 960.4520, 1057.5048, 1186.5474, 1315.5900, 1412.6427, 1511.7112, 1640.7538, 1777.8127, 1876.8811, 2005.9237, 2142.9826, 2242.0510, 2371.0936, 2499.1522, 2570.1893, 2669.2577, 2798.3003, 2926.3589, 2997.3960, 3126.4386, 3254.4972, 3353.5656, 3482.6082, 3610.6667, 3681.7039, 3810.7464, 3938.8050, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PLVNQEAALCIAPVYDVSYEYDGYVYITHAPGCTR", {98.0600, 211.1441, 310.2125, 424.2554, 552.3140, 681.3566, 752.3937, 823.4308, 936.5149, 1096.5456, 1209.6296, 1280.6667, 1377.7195, 1476.7879, 1639.8512, 1754.8782, 1853.9466, 1940.9786, 2104.0420, 2233.0845, 2396.1479, 2511.1748, 2568.1963, 2731.2596, 2830.3280, 2993.3914, 3106.4754, 3207.5231, 3344.5820, 3415.6191, 3512.6719, 3569.6934, 3729.7240, 3830.7717, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 276.1666, 436.1973, 493.2187, 590.2715, 661.3086, 798.3675, 899.4152, 1012.4993, 1175.5626, 1274.6310, 1437.6943, 1494.7158, 1609.7428, 1772.8061, 1901.8487, 2064.9120, 2151.9440, 2251.0124, 2366.0394, 2529.1027, 2628.1711, 2725.2239, 2796.2610, 2909.3451, 3069.3757, 3182.4598, 3253.4969, 3324.5340, 3453.5766, 3581.6352, 3695.6781, 3794.7465, 3907.8306, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"NCTAIDFAMTTPANLMLCGSAIVLTWLCLTWRPAR", {115.0502, 275.0809, 376.1285, 447.1656, 560.2497, 675.2767, 822.3451, 893.3822, 1024.4227, 1125.4703, 1226.5180, 1323.5708, 1394.6079, 1508.6508, 1621.7349, 1752.7754, 1865.8594, 2025.8901, 2082.9116, 2169.9436, 2240.9807, 2354.0648, 2453.1332, 2566.2172, 2667.2649, 2853.3442, 2966.4283, 3126.4589, 3239.5430, 3340.5907, 3526.6700, 3682.7711, 3779.8239, 3850.8610, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 246.1561, 343.2088, 499.3099, 685.3893, 786.4369, 899.5210, 1059.5516, 1172.6357, 1358.7150, 1459.7627, 1572.8468, 1671.9152, 1784.9992, 1856.0364, 1943.0684, 2000.0898, 2160.1205, 2273.2046, 2404.2450, 2517.3291, 2631.3720, 2702.4092, 2799.4619, 2900.5096, 3001.5573, 3132.5978, 3203.6349, 3350.7033, 3465.7302, 3578.8143, 3649.8514, 3750.8991, 3910.9297, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"VHDYQNLLMSLQLVSIQLDSENFGYAINWGLPGYK", {100.0757, 237.1346, 352.1615, 515.2249, 643.2835, 757.3264, 870.4104, 983.4945, 1114.5350, 1201.5670, 1314.6511, 1442.7097, 1555.7937, 1654.8621, 1741.8942, 1854.9782, 1983.0368, 2096.1209, 2211.1478, 2298.1798, 2427.2224, 2541.2654, 2688.3338, 2745.3552, 2908.4186, 2979.4557, 3092.5397, 3206.5827, 3392.6620, 3449.6835, 3562.7675, 3659.8203, 3716.8417, 3879.9051, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 310.1761, 367.1976, 464.2504, 577.3344, 634.3559, 820.4352, 934.4781, 1047.5622, 1118.5993, 1281.6626, 1338.6841, 1485.7525, 1599.7954, 1728.8380, 1815.8701, 1930.8970, 2043.9811, 2172.0396, 2285.1237, 2372.1557, 2471.2242, 2584.3082, 2712.3668, 2825.4509, 2912.4829, 3043.5234, 3156.6074, 3269.6915, 3383.7344, 3511.7930, 3674.8563, 3789.8833, 3926.9422, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SIFGANEFLQLLDQGQQVVEYTANQIETVSENHMR", {88.0393, 201.1234, 348.1918, 405.2132, 476.2504, 590.2933, 719.3359, 866.4043, 979.4884, 1107.5469, 1220.6310, 1333.7151, 1448.7420, 1576.8006, 1633.8220, 1761.8806, 1889.9392, 1989.0076, 2088.0760, 2217.1186, 2380.1820, 2481.2296, 2552.2667, 2666.3097, 2794.3683, 2907.4523, 3036.4949, 3137.5426, 3236.6110, 3323.6430, 3452.6856, 3566.7285, 3703.7875, 3834.8279, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 306.1594, 443.2183, 557.2613, 686.3039, 773.3359, 872.4043, 973.4520, 1102.4946, 1215.5786, 1343.6372, 1457.6802, 1528.7173, 1629.7649, 1792.8283, 1921.8709, 2020.9393, 2120.0077, 2248.0663, 2376.1248, 2433.1463, 2561.2049, 2676.2318, 2789.3159, 2902.4000, 3030.4585, 3143.5426, 3290.6110, 3419.6536, 3533.6965, 3604.7337, 3661.7551, 3808.8235, 3921.9076, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"LSEDALYFHPFSLMIPSDYQCLSVNFLGNPSCSPK", {114.0913, 201.1234, 330.1660, 445.1929, 516.2300, 629.3141, 792.3774, 939.4458, 1076.5047, 1173.5575, 1320.6259, 1407.6579, 1520.7420, 1651.7825, 1764.8666, 1861.9193, 1948.9513, 2063.9783, 2227.0416, 2355.1002, 2515.1308, 2628.2149, 2715.2469, 2814.3154, 2928.3583, 3075.4267, 3188.5108, 3245.5322, 3359.5751, 3456.6279, 3543.6599, 3703.6906, 3790.7226, 3887.7754, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 244.1656, 331.1976, 491.2282, 578.2603, 675.3130, 789.3560, 846.3774, 959.4615, 1106.5299, 1220.5728, 1319.6412, 1406.6733, 1519.7573, 1679.7880, 1807.8466, 1970.9099, 2085.9368, 2172.9689, 2270.0216, 2383.1057, 2514.1462, 2627.2302, 2714.2623, 2861.3307, 2958.3834, 3095.4424, 3242.5108, 3405.5741, 3518.6582, 3589.6953, 3704.7222, 3833.7648, 3920.7968, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"QAYGYTSSPPPHEPPPPLFESWNIPEVPYQLYNSK", {129.0659, 200.1030, 363.1663, 420.1878, 583.2511, 684.2988, 771.3308, 858.3628, 955.4156, 1052.4684, 1149.5211, 1286.5800, 1415.6226, 1512.6754, 1609.7281, 1706.7809, 1803.8337, 1916.9177, 2063.9862, 2193.0287, 2280.0608, 2466.1401, 2580.1830, 2693.2671, 2790.3198, 2919.3624, 3018.4309, 3115.4836, 3278.5469, 3406.6055, 3519.6896, 3682.7529, 3796.7958, 3883.8279, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 234.1448, 348.1878, 511.2511, 624.3352, 752.3937, 915.4571, 1012.5098, 1111.5782, 1240.6208, 1337.6736, 1450.7577, 1564.8006, 1750.8799, 1837.9119, 1966.9545, 2114.0229, 2227.1070, 2324.1598, 2421.2125, 2518.2653, 2615.3181, 2744.3606, 2881.4196, 2978.4723, 3075.5251, 3172.5778, 3259.6099, 3346.6419, 3447.6896, 3610.7529, 3667.7744, 3830.8377, 3901.8748, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DEYLSFAQTMFEYAVTEHNTYGIEGIVLAGQLYLR", {116.0342, 245.0768, 408.1401, 521.2242, 608.2562, 755.3246, 826.3618, 954.4203, 1055.4680, 1186.5085, 1333.5769, 1462.6195, 1625.6828, 1696.7200, 1795.7884, 1896.8360, 2025.8786, 2162.9375, 2276.9805, 2378.0282, 2541.0915, 2598.1129, 2711.1970, 2840.2396, 2897.2611, 3010.3451, 3109.4135, 3222.4976, 3293.5347, 3350.5562, 3478.6148, 3591.6988, 3754.7622, 3867.8462, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 288.2030, 451.2663, 564.3504, 692.4090, 749.4305, 820.4676, 933.5516, 1032.6200, 1145.7041, 1202.7256, 1331.7682, 1444.8522, 1501.8737, 1664.9370, 1765.9847, 1880.0276, 2017.0865, 2146.1291, 2247.1768, 2346.2452, 2417.2823, 2580.3457, 2709.3883, 2856.4567, 2987.4972, 3088.5448, 3216.6034, 3287.6405, 3434.7089, 3521.7410, 3634.8250, 3797.8884, 3926.9310, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"DQEIQSNIDEDYDTNYAPQNEYSPPKPTAPLELPR", {116.0342, 244.0928, 373.1354, 486.2195, 614.2780, 701.3101, 815.3530, 928.4371, 1043.4640, 1172.5066, 1287.5335, 1450.5969, 1565.6238, 1666.6715, 1780.7144, 1943.7777, 2014.8149, 2111.8676, 2239.9262, 2353.9691, 2483.0117, 2646.0750, 2733.1071, 2830.1598, 2927.2126, 3055.3076, 3152.3603, 3253.4080, 3324.4451, 3421.4979, 3534.5819, 3663.6245, 3776.7086, 3873.7614, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 272.1717, 385.2558, 514.2984, 627.3824, 724.4352, 795.4723, 896.5200, 993.5728, 1121.6677, 1218.7205, 1315.7732, 1402.8053, 1565.8686, 1694.9112, 1808.9541, 1937.0127, 2034.0655, 2105.1026, 2268.1659, 2382.2088, 2483.2565, 2598.2835, 2761.3468, 2876.3737, 3005.4163, 3120.4433, 3233.5273, 3347.5703, 3434.6023, 3562.6609, 3675.7449, 3804.7875, 3932.8461, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"AVEITLSNKPILSFTEDFLVSNLLNNTHYEASCFK", {72.0444, 171.1128, 300.1554, 413.2395, 514.2871, 627.3712, 714.4032, 828.4462, 956.5411, 1053.5939, 1166.6780, 1279.7620, 1366.7940, 1513.8625, 1614.9101, 1743.9527, 1858.9797, 2006.0481, 2119.1321, 2218.2006, 2305.2326, 2419.2755, 2532.3596, 2645.4436, 2759.4866, 2873.5295, 2974.5772, 3111.6361, 3274.6994, 3403.7420, 3474.7791, 3561.8112, 3721.8418, 3868.9102, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 294.1812, 454.2119, 541.2439, 612.2810, 741.3236, 904.3869, 1041.4458, 1142.4935, 1256.5364, 1370.5794, 1483.6634, 1596.7475, 1710.7904, 1797.8225, 1896.8909, 2009.9749, 2157.0434, 2272.0703, 2401.1129, 2502.1606, 2649.2290, 2736.2610, 2849.3451, 2962.4291, 3059.4819, 3187.5769, 3301.6198, 3388.6518, 3501.7359, 3602.7836, 3715.8676, 3844.9102, 3943.9786, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"TTEWLYPENSVIAPHHSILLLDIAVDVSDEYTIHK", {102.0550, 203.1026, 332.1452, 518.2245, 631.3086, 794.3719, 891.4247, 1020.4673, 1134.5102, 1221.5422, 1320.6107, 1433.6947, 1504.7318, 1601.7846, 1738.8435, 1875.9024, 1962.9345, 2076.0185, 2189.1026, 2302.1866, 2415.2707, 2530.2977, 2643.3817, 2714.4188, 2813.4872, 2928.5142, 3027.5826, 3114.6146, 3229.6416, 3358.6842, 3521.7475, 3622.7952, 3735.8792, 3872.9381, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 284.1717, 397.2558, 498.3035, 661.3668, 790.4094, 905.4363, 992.4684, 1091.5368, 1206.5637, 1305.6321, 1376.6692, 1489.7533, 1604.7802, 1717.8643, 1830.9484, 1944.0324, 2057.1165, 2144.1485, 2281.2074, 2418.2664, 2515.3191, 2586.3562, 2699.4403, 2798.5087, 2885.5407, 2999.5837, 3128.6263, 3225.6790, 3388.7423, 3501.8264, 3687.9057, 3816.9483, 3917.9960, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"EVPVGHLDYIAVQYGQLAEDSQNQDFLCSNGFEDR", {130.0499, 229.1183, 326.1710, 425.2395, 482.2609, 619.3198, 732.4039, 847.4308, 1010.4942, 1123.5782, 1194.6154, 1293.6838, 1421.7423, 1584.8057, 1641.8271, 1769.8857, 1882.9698, 1954.0069, 2083.0495, 2198.0764, 2285.1085, 2413.1670, 2527.2100, 2655.2685, 2770.2955, 2917.3639, 3030.4480, 3190.4786, 3277.5106, 3391.5536, 3448.5750, 3595.6434, 3724.6860, 3839.7130, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 290.1459, 419.1885, 566.2569, 623.2784, 737.3213, 824.3533, 984.3840, 1097.4680, 1244.5364, 1359.5634, 1487.6220, 1601.6649, 1729.7235, 1816.7555, 1931.7824, 2060.8250, 2131.8622, 2244.9462, 2373.0048, 2430.0263, 2593.0896, 2721.1482, 2820.2166, 2891.2537, 3004.3378, 3167.4011, 3282.4280, 3395.5121, 3532.5710, 3589.5925, 3688.6609, 3785.7136, 3884.7821, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"SWGGDIPANLVPCTIQPAQHWHQLVSSDQPQPMCR", {88.0393, 274.1186, 331.1401, 388.1615, 503.1885, 616.2726, 713.3253, 784.3624, 898.4054, 1011.4894, 1110.5578, 1207.6106, 1367.6412, 1468.6889, 1581.7730, 1709.8316, 1806.8843, 1877.9214, 2005.9800, 2143.0389, 2329.1182, 2466.1772, 2594.2357, 2707.3198, 2806.3882, 2893.4202, 2980.4523, 3095.4792, 3223.5378, 3320.5906, 3448.6491, 3545.7019, 3676.7424, 3836.7730, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 335.1496, 466.1901, 563.2428, 691.3014, 788.3542, 916.4128, 1031.4397, 1118.4717, 1205.5038, 1304.5722, 1417.6562, 1545.7148, 1682.7737, 1868.8530, 2005.9120, 2133.9705, 2205.0077, 2302.0604, 2430.1190, 2543.2031, 2644.2507, 2804.2814, 2901.3341, 3000.4026, 3113.4866, 3227.5296, 3298.5667, 3395.6194, 3508.7035, 3623.7304, 3680.7519, 3737.7734, 3923.8527, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"PELNHYDESTEQISDTAASSEQSYTESYNQDSIER", {98.0600, 227.1026, 340.1867, 454.2296, 591.2885, 754.3519, 869.3788, 998.4214, 1085.4534, 1186.5011, 1315.5437, 1443.6023, 1556.6863, 1643.7184, 1758.7453, 1859.7930, 1930.8301, 2001.8672, 2088.8992, 2175.9313, 2304.9739, 2433.0324, 2520.0645, 2683.1278, 2784.1755, 2913.2181, 3000.2501, 3163.3134, 3277.3564, 3405.4149, 3520.4419, 3607.4739, 3720.5580, 3849.6006, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {175.1190, 304.1615, 417.2456, 504.2776, 619.3046, 747.3632, 861.4061, 1024.4694, 1111.5014, 1240.5440, 1341.5917, 1504.6550, 1591.6871, 1719.7456, 1848.7882, 1935.8203, 2022.8523, 2093.8894, 2164.9265, 2265.9742, 2381.0011, 2468.0332, 2581.1172, 2709.1758, 2838.2184, 2939.2661, 3026.2981, 3155.3407, 3270.3677, 3433.4310, 3570.4899, 3684.5328, 3797.6169, 3926.6595, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"ALLEATQLFSQLAEQQVNVEGQYMFEIISNLDEFK", {72.0444, 185.1285, 298.2125, 427.2551, 498.2922, 599.3399, 727.3985, 840.4825, 987.5510, 1074.5830, 1202.6416, 1315.7256, 1386.7627, 1515.8053, 1643.8639, 1771.9225, 1870.9909, 1985.0338, 2084.1022, 2213.1448, 2270.1663, 2398.2249, 2561.2882, 2692.3287, 2839.3971, 2968.4397, 3081.5238, 3194.6078, 3281.6399, 3395.6828, 3508.7668, 3623.7938, 3752.8364, 3899.9048, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}, {147.1128, 294.1812, 423.2238, 538.2508, 651.3348, 765.3777, 852.4098, 965.4938, 1078.5779, 1207.6205, 1354.6889, 1485.7294, 1648.7927, 1776.8513, 1833.8728, 1962.9154, 2061.9838, 2176.0267, 2275.0951, 2403.1537, 2531.2123, 2660.2549, 2731.2920, 2844.3760, 2972.4346, 3059.4666, 3206.5351, 3319.6191, 3447.6777, 3548.7254, 3619.7625, 3748.8051, 3861.8891, 3974.9732, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000, 99999.0000}},
   {"FPAVEHTTLFYSGSADESVFYGMQTNPMNSYHSCR", {148.0757, 245.1285, 316.1656, 415.2340, 544.2766, 681.3355, 782.3832, 883.4308, 996.5149, 1143.5833, 1306.6467, 1393.6787, 1450.7001, 1537.7322, 1608.7693, 1723.7962, 1852.8388, 1939.8708, 2038.9393, 2186.0077, 2349.0710, 2406.0925, 2537.1330