/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef CFG_GPIO_H
#define CFG_GPIO_H

#include <soc/gpio.h>

/* Pad configuration was generated automatically using intelp2m utility */
static const struct pad_config gpio_table[] = {

	/* ------- GPIO Community 0 ------- */

	/* ------- GPIO Group GPP_B ------- */
	PAD_CFG_NF(GPP_B0, NONE, DEEP, NF1),	/* CORE_VID0 */
	PAD_CFG_NF(GPP_B1, NONE, DEEP, NF1),	/* CORE_VID1 */
	PAD_CFG_NF(GPP_B2, NONE, DEEP, NF1),	/* VRALERT# */
	PAD_NC(GPP_B3, NONE),	/* GPIO */
	PAD_NC(GPP_B4, NONE),	/* GPIO */
	PAD_NC(GPP_B5, NONE),	/* GPIO */
	PAD_NC(GPP_B6, NONE),	/* GPIO */
	PAD_NC(GPP_B7, NONE),	/* GPIO */
	PAD_NC(GPP_B8, NONE),	/* GPIO */
	PAD_NC(GPP_B9, NONE),	/* GPIO */
	PAD_NC(GPP_B10, NONE),	/* GPIO */
	//PAD_CFG_NF(GPP_B11, NONE, RSMRST, NF1),	/* PMCALERT# */
	PAD_CFG_NF(GPP_B12, NONE, DEEP, NF1),	/* SLP_S0# */
	PAD_CFG_NF(GPP_B13, NONE, DEEP, NF1),	/* PLTRST# */
	PAD_CFG_GPO(GPP_B14, 0, PLTRST),	/* GPIO */
	PAD_NC(GPP_B15, NONE),	/* GPIO */
	PAD_NC(GPP_B16, NONE),	/* GPIO */
	PAD_NC(GPP_B17, NONE),	/* GPIO */
	PAD_CFG_GPO(GPP_B18, 0, PLTRST),	/* GPIO */
	PAD_NC(GPP_B19, NONE),	/* GPIO */
	PAD_NC(GPP_B20, NONE),	/* GPIO */
	PAD_NC(GPP_B21, NONE),	/* GPIO */
	PAD_NC(GPP_B22, NONE),	/* GPIO */
	PAD_CFG_GPO(GPP_B23, 1, PLTRST),	/* GPIO */
	PAD_CFG_NF(GPP_B24, NONE, DEEP, NF1),	/* GSPI0_CLK_LOOPBK */
	PAD_CFG_NF(GPP_B25, NONE, DEEP, NF1),	/* GSPI1_CLK_LOOPBK */

	/* ------- GPIO Group GPP_T ------- */
	PAD_NC(GPP_T0, NONE),	/* GPIO */
	PAD_NC(GPP_T1, NONE),	/* GPIO */
	PAD_CFG_NF(GPP_T2, DN_20K, DEEP, NF2),	/* FUSA_DIAGTEST_EN */
	PAD_CFG_NF(GPP_T3, DN_20K, DEEP, NF2),	/* FUSA_DIAGTEST_MODE */
	PAD_NC(GPP_T4, NONE),	/* GPIO */
	PAD_NC(GPP_T5, NONE),	/* GPIO */
	PAD_NC(GPP_T6, NONE),	/* GPIO */
	PAD_NC(GPP_T7, NONE),	/* GPIO */
	PAD_NC(GPP_T8, NONE),	/* GPIO */
	PAD_NC(GPP_T9, NONE),	/* GPIO */
	PAD_NC(GPP_T10, NONE),	/* GPIO */
	PAD_NC(GPP_T11, NONE),	/* GPIO */
	PAD_NC(GPP_T12, NONE),	/* GPIO */
	PAD_NC(GPP_T13, NONE),	/* GPIO */
	PAD_NC(GPP_T14, NONE),	/* GPIO */
	PAD_NC(GPP_T15, NONE),	/* GPIO */

	/* ------- GPIO Group GPP_A ------- */
	PAD_CFG_NF(GPP_A0, UP_20K, DEEP, NF1),	/* ESPI_IO0 */
	PAD_CFG_NF(GPP_A1, UP_20K, DEEP, NF1),	/* ESPI_IO1 */
	PAD_CFG_NF(GPP_A2, UP_20K, DEEP, NF1),	/* ESPI_IO2 */
	PAD_CFG_NF(GPP_A3, UP_20K, DEEP, NF1),	/* ESPI_IO3 */
	PAD_CFG_NF(GPP_A4, UP_20K, DEEP, NF1),	/* ESPI_CS0# */
	PAD_CFG_NF(GPP_A5, UP_20K, DEEP, NF1),	/* ESPI_ALERT0# */
	PAD_CFG_NF(GPP_A6, UP_20K, DEEP, NF1),	/* ESPI_ALERT1# */
	PAD_CFG_GPO(GPP_A7, 1, PLTRST),	/* GPIO */
	PAD_NC(GPP_A8, NONE),	/* GPIO */
	PAD_CFG_NF(GPP_A9, DN_20K, DEEP, NF1),	/* ESPI_CLK */
	PAD_CFG_NF(GPP_A10, NONE, DEEP, NF1),	/* ESPI_RESET# */
	PAD_NC(GPP_A11, NONE),	/* GPIO */
	PAD_NC(GPP_A12, NONE),	/* GPIO */
	PAD_CFG_GPO(GPP_A13, 1, DEEP),	/* GPIO */
	PAD_NC(GPP_A14, NONE),	/* GPIO */
	PAD_NC(GPP_A15, NONE),	/* GPIO */
	PAD_NC(GPP_A16, NONE),	/* GPIO */
	PAD_CFG_GPO(GPP_A17, 1, PLTRST),	/* GPIO */
	PAD_CFG_NF(GPP_A18, NONE, DEEP, NF1),	/* DDSP_HPDB */
	PAD_CFG_NF(GPP_A19, NONE, DEEP, NF1),	/* DDSP_HPD1 */
	PAD_NC(GPP_A20, NONE),	/* GPIO */
	PAD_CFG_GPO(GPP_A21, 1, PLTRST),	/* GPIO */
	PAD_NC(GPP_A22, NONE),	/* GPIO */
	PAD_CFG_NF(GPP_A23, UP_20K, DEEP, NF1),	/* ESPI_CS1# */
	PAD_CFG_NF(GPP_ESPI_CLK_LOOPBK, NONE, DEEP, NF1),	/* GPP_ESPI_CLK_LOOPBK */

	/* ------- GPIO Community 1 ------- */

	/* ------- GPIO Group GPP_S ------- */
	PAD_NC(GPP_S0, NONE),	/* GPIO */
	PAD_NC(GPP_S1, NONE),	/* GPIO */
	PAD_NC(GPP_S2, NONE),	/* GPIO */
	PAD_NC(GPP_S3, NONE),	/* GPIO */
	PAD_NC(GPP_S4, NONE),	/* GPIO */
	PAD_NC(GPP_S5, NONE),	/* GPIO */
	PAD_NC(GPP_S6, NONE),	/* GPIO */
	PAD_NC(GPP_S7, NONE),	/* GPIO */

	/* ------- GPIO Group GPP_I ------- */
	PAD_NC(GPP_I0, NONE),	/* GPIO */
	PAD_NC(GPP_I1, NONE),	/* GPIO */
	PAD_NC(GPP_I2, NONE),	/* GPIO */
	PAD_NC(GPP_I3, NONE),	/* GPIO */
	PAD_NC(GPP_I4, NONE),	/* GPIO */
	PAD_NC(GPP_I5, NONE),	/* GPIO */
	PAD_NC(GPP_I6, NONE),	/* GPIO */
	PAD_CFG_NF(GPP_I7, NONE, DEEP, NF1),	/* EMMC_CMD */
	PAD_CFG_NF(GPP_I8, NONE, DEEP, NF1),	/* EMMC_DATA0 */
	PAD_CFG_NF(GPP_I9, NONE, DEEP, NF1),	/* EMMC_DATA1 */
	PAD_CFG_NF(GPP_I10, NONE, DEEP, NF1),	/* EMMC_DATA2 */
	PAD_CFG_NF(GPP_I11, NONE, DEEP, NF1),	/* EMMC_DATA3 */
	PAD_CFG_NF(GPP_I12, NONE, DEEP, NF1),	/* EMMC_DATA4 */
	PAD_CFG_NF(GPP_I13, NONE, DEEP, NF1),	/* EMMC_DATA5 */
	PAD_CFG_NF(GPP_I14, NONE, DEEP, NF1),	/* EMMC_DATA6 */
	PAD_CFG_NF(GPP_I15, NONE, DEEP, NF1),	/* EMMC_DATA7 */
	PAD_CFG_NF(GPP_I16, NONE, DEEP, NF1),	/* EMMC_RCLK */
	PAD_CFG_NF(GPP_I17, NONE, DEEP, NF1),	/* EMMC_CLK */
	PAD_CFG_NF(GPP_I18, NONE, DEEP, NF1),	/* EMMC_RESET# */
	PAD_NC(GPP_I19, NONE),	/* GPIO */

	/* ------- GPIO Group GPP_H ------- */
	PAD_CFG_GPO(GPP_H0, 1, PLTRST),	/* GPIO */
	PAD_CFG_GPO(GPP_H1, 0, DEEP),	/* GPIO */
	PAD_CFG_GPO(GPP_H2, 1, RSMRST),	/* GPIO */
	PAD_NC(GPP_H3, NONE),	/* GPIO */
	PAD_NC(GPP_H4, NONE),	/* GPIO */
	PAD_NC(GPP_H5, NONE),	/* GPIO */
	PAD_NC(GPP_H6, NONE),	/* GPIO */
	PAD_NC(GPP_H7, NONE),	/* GPIO */
	PAD_NC(GPP_H8, NONE),	/* GPIO */
	PAD_NC(GPP_H9, NONE),	/* GPIO */
	PAD_NC(GPP_H10, NONE),	/* GPIO */
	PAD_CFG_NF(GPP_H11, NONE, DEEP, NF2),	/* UART0_TXD */
	PAD_NC(GPP_H12, NONE),	/* GPIO */
	PAD_NC(GPP_H13, NONE),	/* GPIO */
	PAD_NC(GPP_H14, NONE),	/* GPIO */
	PAD_CFG_NF(GPP_H15, NONE, DEEP, NF1),	/* DDPB_CTRLCLK */
	PAD_NC(GPP_H16, NONE),	/* GPIO */
	PAD_CFG_NF(GPP_H17, NONE, DEEP, NF1),	/* DDPB_CTRLDATA */
	PAD_CFG_NF(GPP_H18, NONE, DEEP, NF1),	/* PROC_C10_GATE# */
	PAD_CFG_NF(GPP_H19, NONE, DEEP, NF1),	/* SRCCLKREQ4# */
	PAD_NC(GPP_H20, NONE),	/* GPIO */
	PAD_NC(GPP_H21, NONE),	/* GPIO */
	PAD_NC(GPP_H22, NONE),	/* GPIO */
	PAD_NC(GPP_H23, NONE),	/* GPIO */

	/* ------- GPIO Group GPP_D ------- */
	PAD_NC(GPP_D0, NONE),	/* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D1, NONE, PLTRST, OFF, ACPI),	/* GPIO */
	PAD_NC(GPP_D2, NONE),	/* GPIO */
	PAD_NC(GPP_D3, NONE),	/* GPIO */
	PAD_NC(GPP_D4, NONE),	/* GPIO */
	PAD_CFG_NF(GPP_D5, NONE, DEEP, NF1),	/* SRCCLKREQ0# */
	PAD_CFG_NF(GPP_D6, NONE, DEEP, NF1),	/* SRCCLKREQ1# */
	PAD_CFG_NF(GPP_D7, NONE, DEEP, NF1),	/* SRCCLKREQ2# */
	PAD_CFG_NF(GPP_D8, NONE, DEEP, NF1),	/* SRCCLKREQ3# */
	PAD_CFG_NF(GPP_D9, NATIVE, DEEP, NF5),	/* BSSB_LS2_RX */
	PAD_CFG_NF(GPP_D10, NATIVE, DEEP, NF5),	/* BSSB_LS2_TX */
	PAD_CFG_NF(GPP_D11, NATIVE, DEEP, NF5),	/* BSSB_LS3_RX */
	PAD_CFG_NF(GPP_D12, NATIVE, DEEP, NF5),	/* BSSB_LS3_TX */
	PAD_NC(GPP_D13, NONE),	/* GPIO */
	PAD_NC(GPP_D14, NONE),	/* GPIO */
	PAD_NC(GPP_D15, NONE),	/* GPIO */
	PAD_CFG_GPO(GPP_D16, 1, PLTRST),	/* GPIO */
	PAD_NC(GPP_D17, NONE),	/* GPIO */
	PAD_NC(GPP_D18, NONE),	/* GPIO */
	PAD_NC(GPP_D19, NONE),	/* GPIO */
	PAD_CFG_NF(GPP_GSPI2_CLK_LOOPBK, NONE, DEEP, NF1),	/* GPP_GSPI2_CLK_LOOPBK */

	/* ------- GPIO Group vGPIO ------- */

	/* ------- GPIO Community 2 ------- */

	/* ------- GPIO Group GPP_GPD ------- */
	PAD_CFG_NF(GPD0, UP_20K, PWROK, NF1),	/* BATLOW# */
	PAD_CFG_NF(GPD1, NATIVE, PWROK, NF1),	/* ACPRESENT */
	PAD_CFG_NF(GPD2, NATIVE, PWROK, NF1),	/* LAN_WAKE# */
	PAD_CFG_NF(GPD3, UP_20K, PWROK, NF1),	/* PWRBTN# */
	PAD_CFG_NF(GPD4, NONE, PWROK, NF1),	/* SLP_S3# */
	PAD_CFG_NF(GPD5, NONE, PWROK, NF1),	/* SLP_S4# */
	PAD_CFG_NF(GPD6, NONE, PWROK, NF1),	/* SLP_A# */
	PAD_CFG_GPO(GPD7, 0, PWROK),	/* GPIO */
	PAD_CFG_NF(GPD8, NONE, PWROK, NF1),	/* SUSCLK */
	PAD_CFG_NF(GPD9, NONE, PWROK, NF1),	/* SLP_WLAN# */
	PAD_CFG_NF(GPD10, NONE, PWROK, NF1),	/* SLP_S5# */
	PAD_CFG_GPO(GPD11, 0, PWROK),	/* GPIO */
	PAD_CFG_NF(GPD_INPUT3VSEL, NONE, PWROK, NF1),	/* GPD_INPUT3VSEL */
	PAD_CFG_NF(GPD_SLP_LANB, NONE, PWROK, NF1),	/* GPD_SLP_LANB */
	PAD_CFG_NF(GPD_SLP_SUSB, NONE, PWROK, NF1),	/* GPD_SLP_SUSB */
	PAD_CFG_NF(GPD_WAKEB, NONE, PWROK, NF1),	/* GPD_WAKEB */
	PAD_CFG_NF(GPD_DRAM_RESETB, NONE, PWROK, NF1),	/* GPD_DRAM_RESETB */

	/* ------- GPIO Group PCIe vGPIO ------- */

	/* ------- GPIO Community 4 ------- */

	/* ------- GPIO Group GPP_C ------- */
	PAD_CFG_NF(GPP_C0, NONE, DEEP, NF1),	/* SMBCLK */
	PAD_CFG_NF(GPP_C1, NONE, DEEP, NF1),	/* SMBDATA */
	PAD_CFG_GPO(GPP_C2, 0, DEEP),	/* GPIO */
	PAD_CFG_NF(GPP_C3, NONE, DEEP, NF1),	/* SML0CLK */
	PAD_CFG_NF(GPP_C4, NONE, DEEP, NF1),	/* SML0DATA */
	PAD_CFG_GPO(GPP_C5, 0, DEEP),	/* GPIO */
	PAD_CFG_NF(GPP_C6, NONE, RSMRST, NF1),	/* SML1CLK */
	PAD_CFG_NF(GPP_C7, NONE, RSMRST, NF1),	/* SML1DATA */
	PAD_NC(GPP_C8, NONE),	/* GPIO */
	PAD_NC(GPP_C9, NONE),	/* GPIO */
	PAD_NC(GPP_C10, NONE),	/* GPIO */
	PAD_NC(GPP_C11, NONE),	/* GPIO */
	PAD_NC(GPP_C12, NONE),	/* GPIO */
	PAD_NC(GPP_C13, NONE),	/* GPIO */
	PAD_NC(GPP_C14, NONE),	/* GPIO */
	PAD_NC(GPP_C15, NONE),	/* GPIO */
	PAD_NC(GPP_C16, NONE),	/* GPIO */
	PAD_NC(GPP_C17, NONE),	/* GPIO */
	PAD_NC(GPP_C18, NONE),	/* GPIO */
	PAD_NC(GPP_C19, NONE),	/* GPIO */
	PAD_NC(GPP_C20, NONE),	/* GPIO */
	PAD_NC(GPP_C21, NONE),	/* GPIO */
	PAD_NC(GPP_C22, NONE),	/* GPIO */
	PAD_NC(GPP_C23, NONE),	/* GPIO */

	/* ------- GPIO Group GPP_F ------- */
	PAD_CFG_NF(GPP_F0, NONE, DEEP, NF1),	/* CNV_BRI_DT */
	PAD_CFG_NF(GPP_F1, UP_20K, DEEP, NF1),	/* CNV_BRI_RSP */
	PAD_CFG_NF(GPP_F2, NONE, DEEP, NF1),	/* CNV_RGI_DT */
	PAD_CFG_NF(GPP_F3, UP_20K, DEEP, NF1),	/* CNV_RGI_RSP */
	PAD_CFG_NF(GPP_F4, NONE, DEEP, NF1),	/* CNV_RF_RESET# */
	PAD_CFG_NF(GPP_F5, NONE, DEEP, NF2),	/* MODEM_CLKREQ */
	PAD_NC(GPP_F6, NONE),	/* GPIO */
	PAD_CFG_GPO(GPP_F7, 0, DEEP),	/* GPIO */
	PAD_NC(GPP_F8, NONE),	/* GPIO */
	PAD_CFG_NF(GPP_F9, NONE, DEEP, NF1),	/* BOOTMPC */
	PAD_CFG_GPO(GPP_F10, 1, PLTRST),	/* GPIO */
	PAD_NC(GPP_F11, NONE),	/* GPIO */
	PAD_NC(GPP_F12, NONE),	/* GPIO */
	PAD_NC(GPP_F13, NONE),	/* GPIO */
	PAD_NC(GPP_F14, NONE),	/* GPIO */
	PAD_NC(GPP_F15, NONE),	/* GPIO */
	PAD_NC(GPP_F16, NONE),	/* GPIO */
	PAD_NC(GPP_F17, NONE),	/* GPIO */
	PAD_NC(GPP_F18, NONE),	/* GPIO */
	PAD_NC(GPP_F19, NONE),	/* GPIO */
	PAD_CFG_NF(GPP_F20, NONE, DEEP, NF1),	/* Reserved */
	PAD_CFG_NF(GPP_F21, NONE, DEEP, NF1),	/* Reserved */
	PAD_NC(GPP_F22, NONE),	/* GPIO */
	PAD_NC(GPP_F23, NONE),	/* GPIO */
	PAD_NC(GPP_F_CLK_LOOPBK, NONE),	/* GPIO */

	/* ------- GPIO Group GPP_HVCMOS ------- */
	PAD_CFG_NF(GPP_L_BKLTEN, NONE, DEEP, NF1),	/* n/a */
	PAD_CFG_NF(GPP_L_BKLTCTL, NONE, DEEP, NF1),	/* n/a */
	PAD_CFG_NF(GPP_L_VDDEN, NONE, DEEP, NF1),	/* n/a */
	PAD_CFG_NF(GPP_SYS_PWROK, NONE, DEEP, NF1),	/* n/a */
	PAD_CFG_NF(GPP_SYS_RESETB, NONE, DEEP, NF1),	/* n/a */
	PAD_CFG_NF(GPP_MLK_RSTB, NONE, DEEP, NF1),	/* n/a */

	/* ------- GPIO Group GPP_E ------- */
	PAD_NC(GPP_E0, NONE),	/* GPIO */
	PAD_NC(GPP_E1, NONE),	/* GPIO */
	PAD_NC(GPP_E2, NONE),	/* GPIO */
	PAD_CFG_GPO(GPP_E3, 1, DEEP),	/* GPIO */
	PAD_NC(GPP_E4, NONE),	/* GPIO */
	PAD_NC(GPP_E5, NONE),	/* GPIO */
	PAD_CFG_GPO(GPP_E6, 0, DEEP),	/* GPIO */
	PAD_NC(GPP_E7, NONE),	/* GPIO */
	PAD_NC(GPP_E8, NONE),	/* GPIO */
	PAD_NC(GPP_E9, NONE),	/* GPIO */
	PAD_NC(GPP_E10, NONE),	/* GPIO */
	PAD_NC(GPP_E11, NONE),	/* GPIO */
	PAD_NC(GPP_E12, NONE),	/* GPIO */
	PAD_NC(GPP_E13, NONE),	/* GPIO */
	PAD_CFG_NF(GPP_E14, NONE, DEEP, NF1),	/* DDSP_HPDA */
	PAD_CFG_GPO(GPP_E15, 1, PLTRST),	/* GPIO */
	PAD_CFG_GPO(GPP_E16, 0, PLTRST),	/* GPIO */
	PAD_NC(GPP_E17, NONE),	/* GPIO */
	PAD_CFG_NF(GPP_E18, NATIVE, DEEP, NF5),	/* BSSB_LS0_RX */
	PAD_CFG_NF(GPP_E19, NATIVE, DEEP, NF5),	/* BSSB_LS0_TX */
	PAD_CFG_GPO(GPP_E20, 1, PLTRST),	/* GPIO */
	PAD_CFG_GPO(GPP_E21, 0, PLTRST),	/* GPIO */
	PAD_CFG_NF(GPP_E22, DN_20K, DEEP, NF1),	/* DDPA_CTRLCLK */
	PAD_CFG_NF(GPP_E23, NONE, DEEP, NF1),	/* DDPA_CTRLDATA */
	PAD_NC(GPP_E_CLK_LOOPBK, NONE),	/* GPIO */

	/* ------- GPIO Community 5 ------- */

	/* ------- GPIO Group GPP_R ------- */
	PAD_CFG_NF(GPP_R0, NONE, DEEP, NF1),	/* HDA_BCLK */
	PAD_CFG_NF(GPP_R1, NATIVE, DEEP, NF1),	/* HDA_SYNC */
	PAD_CFG_NF(GPP_R2, NATIVE, DEEP, NF1),	/* HDA_SDO */
	PAD_CFG_NF(GPP_R3, NATIVE, DEEP, NF1),	/* HDA_SDI0 */
	PAD_CFG_NF(GPP_R4, NONE, DEEP, NF1),	/* HDA_RST# */
	PAD_NC(GPP_R5, NONE),	/* GPIO */
	PAD_NC(GPP_R6, NONE),	/* GPIO */
	PAD_NC(GPP_R7, NONE),	/* GPIO */
};

#endif /* CFG_GPIO_H */
