/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef CFG_GPIO_H
#define CFG_GPIO_H

#include <gpio.h>

/* Pad configuration was generated automatically using intelp2m utility */
static const struct pad_config gpio_table[] = {
	/* ------- GPIO Community 0 ------- */
	/* ------- GPIO Group GPP_A ------- */
	PAD_CFG_NF(GPP_A0, NONE, RSMRST, NF3), /* ESPI_ALERT1# */
	PAD_CFG_NF(GPP_A1, NONE, RSMRST, NF1), /* LAD0 */
	PAD_CFG_NF(GPP_A2, NONE, RSMRST, NF1), /* LAD1 */
	PAD_CFG_NF(GPP_A3, NONE, RSMRST, NF1), /* LAD2 */
	PAD_CFG_NF(GPP_A4, NONE, RSMRST, NF1), /* LAD3 */
	PAD_CFG_NF(GPP_A5, NONE, RSMRST, NF1), /* LFRAME# */
	PAD_CFG_NF(GPP_A6, NONE, RSMRST, NF1), /* SERIRQ */
	PAD_CFG_NF(GPP_A7, NONE, RSMRST, NF1), /* PIRQA# */
	PAD_CFG_NF(GPP_A8, NONE, RSMRST, NF1), /* CLKRUN# */
	PAD_CFG_NF(GPP_A9, NONE, RSMRST, NF1), /* CLKOUT_LPC0 */
	PAD_NC(GPP_A10, NONE), /* GPIO */
	PAD_CFG_NF(GPP_A11, NONE, RSMRST, NF1), /* PME# */
	PAD_CFG_GPI_SCI(GPP_A12, NONE, RSMRST, OFF, NONE), /* GPIO */
	PAD_CFG_NF(GPP_A13, NONE, RSMRST, NF1), /* SUSWARN#/SUSPWRDNACK */
	PAD_NC(GPP_A14, NONE), /* GPIO */
	PAD_CFG_NF(GPP_A15, NONE, RSMRST, NF1), /* SUS_ACK# */
	PAD_NC(GPP_A16, NONE), /* GPIO */
	PAD_NC(GPP_A17, NONE), /* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_A18, NONE, RSMRST, OFF, ACPI), /* GPIO */
	/* GPP_A19 - RESERVED */
	PAD_NC(GPP_A20, NONE), /* GPIO */
	PAD_NC(GPP_A21, NONE), /* GPIO */
	PAD_NC(GPP_A22, NONE), /* GPIO */
	PAD_NC(GPP_A23, NONE), /* GPIO */

	/* ------- GPIO Group GPP_B ------- */
	PAD_NC(GPP_B0, NONE), /* GPIO */
	PAD_NC(GPP_B1, NONE), /* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B2, NONE, RSMRST, OFF, ACPI), /* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B3, NONE, RSMRST, OFF, ACPI), /* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B4, NONE, RSMRST, OFF, ACPI), /* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B5, NONE, RSMRST, OFF, ACPI), /* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B6, NONE, RSMRST, OFF, ACPI), /* GPIO */
	PAD_NC(GPP_B7, NONE), /* GPIO */
	PAD_NC(GPP_B8, NONE), /* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B9, NONE, RSMRST, OFF, ACPI), /* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B10, NONE, RSMRST, OFF, ACPI), /* GPIO */
	/* GPP_B11 - RESERVED */
	PAD_CFG_NF(GPP_B12, NONE, RSMRST, NF1), /* GLB_RST_WARN_N# */
	PAD_CFG_NF(GPP_B13, NONE, RSMRST, NF1), /* PLTRST# */
	PAD_CFG_NF(GPP_B14, NONE, RSMRST, NF1), /* SPKR */
	PAD_CFG_GPI_TRIG_OWN(GPP_B15, NONE, RSMRST, OFF, ACPI), /* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B16, NONE, RSMRST, OFF, ACPI), /* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B17, NONE, RSMRST, OFF, ACPI), /* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B18, NONE, RSMRST, OFF, ACPI), /* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B19, NONE, RSMRST, OFF, ACPI), /* GPIO */
	PAD_CFG_GPO(GPP_B20, 1, RSMRST), /* GPIO */
	PAD_NC(GPP_B21, NONE), /* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_B22, NONE, RSMRST, OFF, ACPI), /* GPIO */
	PAD_CFG_NF(GPP_B23, NONE, RSMRST, NF2), /* PCHHOT# */

	/* ------- GPIO Group GPP_F ------- */
	PAD_NC(GPP_F0, NONE), /* GPIO */
	PAD_NC(GPP_F1, NONE), /* GPIO */
	PAD_NC(GPP_F2, NONE), /* GPIO */
	PAD_NC(GPP_F3, NONE), /* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_F4, NONE, RSMRST, OFF, ACPI), /* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_F5, NONE, RSMRST, OFF, ACPI), /* GPIO */
	PAD_CFG_GPO(GPP_F6, 0, RSMRST), /* GPIO */
	PAD_CFG_GPO(GPP_F7, 0, RSMRST), /* GPIO */
	PAD_CFG_GPO(GPP_F8, 0, RSMRST), /* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_F9, NONE, RSMRST, OFF, ACPI), /* GPIO */
	PAD_NC(GPP_F10, NONE), /* GPIO */
	PAD_NC(GPP_F11, NONE), /* GPIO */
	PAD_NC(GPP_F12, NONE), /* GPIO */
	PAD_NC(GPP_F13, NONE), /* GPIO */
	PAD_NC(GPP_F14, NONE), /* GPIO */
	PAD_NC(GPP_F15, NONE), /* GPIO */
	PAD_NC(GPP_F16, NONE), /* GPIO */
	PAD_NC(GPP_F17, NONE), /* GPIO */
	PAD_NC(GPP_F18, NONE), /* GPIO */
	PAD_NC(GPP_F19, NONE), /* GPIO */
	PAD_NC(GPP_F20, NONE), /* GPIO */
	PAD_NC(GPP_F21, NONE), /* GPIO */
	PAD_NC(GPP_F22, NONE), /* GPIO */
	PAD_NC(GPP_F23, NONE), /* GPIO */

	/* ------- GPIO Community 1 ------- */
	/* ------- GPIO Group GPP_C ------- */
	/* GPP_C0 - RESERVED */
	/* GPP_C1 - RESERVED */
	PAD_CFG_GPI_TRIG_OWN(GPP_C2, NONE, RSMRST, LEVEL, ACPI), /* GPIO */
	/* GPP_C3 - RESERVED */
	/* GPP_C4 - RESERVED */
	PAD_CFG_NF(GPP_C5, NONE, RSMRST, NF1), /* SML0ALERT# */
	/* GPP_C6 - RESERVED */
	/* GPP_C7 - RESERVED */
	PAD_CFG_GPI_TRIG_OWN(GPP_C8, NONE, RSMRST, OFF, ACPI), /* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_C9, NONE, RSMRST, OFF, ACPI), /* GPIO */
	PAD_NC(GPP_C10, NONE), /* GPIO */
	PAD_NC(GPP_C11, NONE), /* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_C12, NONE, RSMRST, OFF, ACPI), /* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_C13, NONE, RSMRST, OFF, ACPI), /* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_C14, NONE, RSMRST, OFF, ACPI), /* GPIO */
	PAD_NC(GPP_C15, NONE), /* GPIO */
	PAD_NC(GPP_C16, NONE), /* GPIO */
	PAD_NC(GPP_C17, NONE), /* GPIO */
	PAD_NC(GPP_C18, NONE), /* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_C19, NONE, RSMRST, OFF, ACPI), /* GPIO */
	/* GPP_C20 - RESERVED */
	PAD_CFG_GPI_TRIG_OWN(GPP_C21, NONE, RSMRST, OFF, ACPI), /* GPIO */
	PAD_CFG_GPI_SMI(GPP_C22, NONE, RSMRST, LEVEL, INVERT), /* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_C23, NONE, RSMRST, OFF, ACPI), /* GPIO */

	/* ------- GPIO Group GPP_D ------- */
	PAD_CFG_GPI_NMI(GPP_D0, NONE, RSMRST, LEVEL, NONE), /* GPIO */
	PAD_NC(GPP_D1, NONE), /* GPIO */
	PAD_NC(GPP_D2, NONE), /* GPIO */
	PAD_NC(GPP_D3, NONE), /* GPIO */
	PAD_CFG_GPO(GPP_D4, 1, RSMRST), /* GPIO */
	PAD_NC(GPP_D5, NONE), /* GPIO */
	PAD_NC(GPP_D6, NONE), /* GPIO */
	PAD_NC(GPP_D7, NONE), /* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_D8, NONE, RSMRST, OFF, ACPI), /* GPIO */
	PAD_NC(GPP_D9, NONE), /* GPIO */
	PAD_NC(GPP_D10, NONE), /* GPIO */
	PAD_NC(GPP_D11, NONE), /* GPIO */
	PAD_NC(GPP_D12, NONE), /* GPIO */
	PAD_NC(GPP_D13, NONE), /* GPIO */
	PAD_NC(GPP_D14, NONE), /* GPIO */
	PAD_NC(GPP_D15, NONE), /* GPIO */
	PAD_CFG_GPO(GPP_D16, 0, RSMRST), /* GPIO */
	PAD_CFG_GPO(GPP_D17, 0, RSMRST), /* GPIO */
	PAD_NC(GPP_D18, NONE), /* GPIO */
	PAD_CFG_GPO(GPP_D19, 0, RSMRST), /* GPIO */
	PAD_NC(GPP_D20, NONE), /* GPIO */
	PAD_NC(GPP_D21, NONE), /* GPIO */
	PAD_NC(GPP_D22, NONE), /* GPIO */
	PAD_NC(GPP_D23, NONE), /* GPIO */

	/* ------- GPIO Group GPP_E ------- */
	PAD_NC(GPP_E0, NONE), /* GPIO */
	PAD_NC(GPP_E1, NONE), /* GPIO */
	PAD_NC(GPP_E2, NONE), /* GPIO */
	PAD_CFG_NF(GPP_E3, NONE, RSMRST, NF1), /* CPU_GP0 */
	PAD_NC(GPP_E4, NONE), /* GPIO */
	PAD_NC(GPP_E5, NONE), /* GPIO */
	PAD_NC(GPP_E6, NONE), /* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_E7, NONE, RSMRST, OFF, ACPI), /* GPIO */
	PAD_NC(GPP_E8, NONE), /* GPIO */
	PAD_CFG_NF(GPP_E9, NONE, RSMRST, NF1), /* USB_OC0# */
	PAD_NC(GPP_E10, NONE), /* GPIO */
	PAD_NC(GPP_E11, NONE), /* GPIO */
	PAD_NC(GPP_E12, NONE), /* GPIO */

	/* ------- GPIO Community 2 ------- */
	/* -------- GPIO Group GPD -------- */
	/* GPD0 - RESERVED */
	PAD_CFG_NF(GPD1, NONE, RSMRST, NF1), /* ACPRESENT */
	PAD_NC(GPD2, NONE), /* GPIO */
	PAD_CFG_NF(GPD3, NONE, RSMRST, NF1), /* PWRBTN# */
	PAD_CFG_NF(GPD4, NONE, RSMRST, NF1), /* SLP_S3# */
	PAD_CFG_NF(GPD5, NONE, RSMRST, NF1), /* SLP_S4# */
	PAD_NC(GPD6, NONE), /* GPIO */
	PAD_NC(GPD7, NONE), /* GPIO */
	PAD_NC(GPD8, NONE), /* GPIO */
	PAD_NC(GPD9, NONE), /* GPIO */
	PAD_NC(GPD10, NONE), /* GPIO */
	PAD_NC(GPD11, NONE), /* GPIO */

	/* ------- GPIO Community 3 ------- */
	/* ------- GPIO Group GPP_I ------- */
	PAD_NC(GPP_I0, NONE), /* GPIO */
	PAD_NC(GPP_I1, NONE), /* GPIO */
	PAD_NC(GPP_I2, NONE), /* GPIO */
	PAD_NC(GPP_I3, NONE), /* GPIO */
	PAD_NC(GPP_I4, NONE), /* GPIO */
	PAD_NC(GPP_I5, NONE), /* GPIO */
	PAD_NC(GPP_I6, NONE), /* GPIO */
	PAD_NC(GPP_I7, NONE), /* GPIO */
	PAD_CFG_NF(GPP_I8, NONE, RSMRST, NF2), /* PCI_DIS */
	PAD_CFG_NF(GPP_I9, NONE, RSMRST, NF2), /* LAN_DIS */
	PAD_NC(GPP_I10, NONE), /* GPIO */

	/* ------- GPIO Community 4 ------- */
	/* ------- GPIO Group GPP_J ------- */
	PAD_NC(GPP_J0, NONE), /* GPIO */
	PAD_NC(GPP_J1, NONE), /* GPIO */
	PAD_NC(GPP_J2, NONE), /* GPIO */
	PAD_NC(GPP_J3, NONE), /* GPIO */
	PAD_NC(GPP_J4, NONE), /* GPIO */
	PAD_NC(GPP_J5, NONE), /* GPIO */
	PAD_NC(GPP_J6, NONE), /* GPIO */
	PAD_NC(GPP_J7, NONE), /* GPIO */
	PAD_NC(GPP_J8, NONE), /* GPIO */
	PAD_NC(GPP_J9, NONE), /* GPIO */
	PAD_NC(GPP_J10, NONE), /* GPIO */
	PAD_NC(GPP_J11, NONE), /* GPIO */
	PAD_NC(GPP_J12, NONE), /* GPIO */
	PAD_NC(GPP_J13, NONE), /* GPIO */
	PAD_NC(GPP_J14, NONE), /* GPIO */
	PAD_NC(GPP_J15, NONE), /* GPIO */
	PAD_NC(GPP_J16, NONE), /* GPIO */
	PAD_NC(GPP_J17, NONE), /* GPIO */
	PAD_NC(GPP_J18, NONE), /* GPIO */
	PAD_NC(GPP_J19, NONE), /* GPIO */
	PAD_NC(GPP_J20, NONE), /* GPIO */
	PAD_NC(GPP_J21, NONE), /* GPIO */
	PAD_NC(GPP_J22, NONE), /* GPIO */
	PAD_NC(GPP_J23, NONE), /* GPIO */

	/* ------- GPIO Group GPP_K ------- */
	PAD_NC(GPP_K0, NONE), /* GPIO */
	PAD_NC(GPP_K1, NONE), /* GPIO */
	PAD_NC(GPP_K2, NONE), /* GPIO */
	PAD_NC(GPP_K3, NONE), /* GPIO */
	PAD_NC(GPP_K4, NONE), /* GPIO */
	PAD_NC(GPP_K5, NONE), /* GPIO */
	PAD_NC(GPP_K6, NONE), /* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_K7, NONE, RSMRST, OFF, ACPI), /* GPIO */
	PAD_CFG_NF(GPP_K8, NONE, RSMRST, NF1), /* LAN_NCSI_ARB_IN */
	PAD_CFG_NF(GPP_K9, NONE, RSMRST, NF1), /* LAN_NCSI_ARB_OUT */
	PAD_CFG_NF(GPP_K10, NONE, RSMRST, NF1), /* PE_RST# */

	/* ------- GPIO Community 5 ------- */
	/* ------- GPIO Group GPP_G ------- */
	PAD_NC(GPP_G0, NONE), /* GPIO */
	PAD_NC(GPP_G1, NONE), /* GPIO */
	PAD_NC(GPP_G2, NONE), /* GPIO */
	PAD_NC(GPP_G3, NONE), /* GPIO */
	PAD_NC(GPP_G4, NONE), /* GPIO */
	PAD_NC(GPP_G5, NONE), /* GPIO */
	PAD_NC(GPP_G6, NONE), /* GPIO */
	PAD_NC(GPP_G7, NONE), /* GPIO */
	PAD_NC(GPP_G8, NONE), /* GPIO */
	PAD_NC(GPP_G9, NONE), /* GPIO */
	PAD_NC(GPP_G10, NONE), /* GPIO */
	PAD_NC(GPP_G11, NONE), /* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_G12, NONE, RSMRST, OFF, ACPI), /* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_G13, NONE, RSMRST, OFF, ACPI), /* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_G14, NONE, RSMRST, OFF, ACPI), /* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_G15, NONE, RSMRST, OFF, ACPI), /* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_G16, NONE, RSMRST, OFF, ACPI), /* GPIO */
	PAD_CFG_NF(GPP_G17, NONE, RSMRST, NF1), /* ADR_COMPLETE */
	PAD_CFG_NF(GPP_G18, NONE, RSMRST, NF1), /* NMI# */
	PAD_CFG_NF(GPP_G19, NONE, RSMRST, NF1), /* SMI# */
	/* GPP_G20 - RESERVED */
	PAD_CFG_GPI_TRIG_OWN(GPP_G21, NONE, RSMRST, OFF, ACPI), /* GPIO */
	PAD_NC(GPP_G22, NONE), /* GPIO */
	PAD_NC(GPP_G23, NONE), /* GPIO */

	/* ------- GPIO Group GPP_H ------- */
	PAD_NC(GPP_H0, NONE), /* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_H1, NONE, RSMRST, OFF, ACPI), /* GPIO */
	PAD_NC(GPP_H2, NONE), /* GPIO */
	PAD_NC(GPP_H3, NONE), /* GPIO */
	PAD_NC(GPP_H4, NONE), /* GPIO */
	PAD_NC(GPP_H5, NONE), /* GPIO */
	PAD_NC(GPP_H6, NONE), /* GPIO */
	PAD_NC(GPP_H7, NONE), /* GPIO */
	PAD_NC(GPP_H8, NONE), /* GPIO */
	PAD_NC(GPP_H9, NONE), /* GPIO */
	/* GPP_H10 - RESERVED */
	/* GPP_H11 - RESERVED */
	PAD_CFG_GPI_TRIG_OWN(GPP_H12, NONE, RSMRST, OFF, ACPI), /* GPIO */
	/* GPP_H13 - RESERVED */
	/* GPP_H14 - RESERVED */
	PAD_CFG_GPI_TRIG_OWN(GPP_H15, NONE, RSMRST, OFF, ACPI), /* GPIO */
	/* GPP_H16 - RESERVED */
	/* GPP_H17 - RESERVED */
	PAD_CFG_GPI_TRIG_OWN(GPP_H18, NONE, RSMRST, OFF, ACPI), /* GPIO */
	PAD_CFG_GPI_TRIG_OWN(GPP_H19, NONE, RSMRST, OFF, ACPI), /* GPIO */
	PAD_CFG_NF(GPP_H20, NONE, RSMRST, NF2), /* SSATAXPCIE2 */
	PAD_CFG_GPI_TRIG_OWN(GPP_H21, NONE, RSMRST, OFF, ACPI), /* GPIO */
	PAD_NC(GPP_H22, NONE), /* GPIO */
	PAD_NC(GPP_H23, NONE), /* GPIO */

	/* ------- GPIO Group GPP_L ------- */
	/* GPP_L0 - RESERVED */
	PAD_CFG_NF(GPP_L1, NONE, DEEP, NF1), /* CSME_INTR_OUT */
	PAD_CFG_NF(GPP_L2, NONE, RSMRST, NF1), /* TESTCH0_D0 */
	PAD_CFG_NF(GPP_L3, NONE, RSMRST, NF1), /* TESTCH0_D1 */
	PAD_CFG_NF(GPP_L4, NONE, RSMRST, NF1), /* TESTCH0_D2 */
	PAD_CFG_NF(GPP_L5, NONE, RSMRST, NF1), /* TESTCH0_D3 */
	PAD_CFG_NF(GPP_L6, NONE, RSMRST, NF1), /* TESTCH0_D4 */
	PAD_CFG_NF(GPP_L7, NONE, RSMRST, NF1), /* TESTCH0_D5 */
	PAD_CFG_NF(GPP_L8, NONE, RSMRST, NF1), /* TESTCH0_D6 */
	PAD_CFG_NF(GPP_L9, NONE, RSMRST, NF1), /* TESTCH0_D7 */
	PAD_CFG_NF(GPP_L10, NONE, RSMRST, NF1), /* TESTCH0_CLK */
	PAD_NC(GPP_L11, NONE), /* GPIO */
	PAD_NC(GPP_L12, NONE), /* GPIO */
	PAD_NC(GPP_L13, NONE), /* GPIO */
	PAD_NC(GPP_L14, NONE), /* GPIO */
	PAD_NC(GPP_L15, NONE), /* GPIO */
	PAD_NC(GPP_L16, NONE), /* GPIO */
	PAD_NC(GPP_L17, NONE), /* GPIO */
	PAD_NC(GPP_L18, NONE), /* GPIO */
	PAD_NC(GPP_L19, NONE), /* GPIO */
};

/* Early pad configuration in bootblock */
static const struct pad_config early_gpio_table[] = {
	/* ------- GPIO Community 0 ------- */
	/* ------- GPIO Group GPP_A ------- */
	PAD_CFG_NF(GPP_A0, NONE, RSMRST, NF3), /* ESPI_ALERT1# */
	PAD_CFG_NF(GPP_A1, NONE, RSMRST, NF1), /* LAD0 */
	PAD_CFG_NF(GPP_A2, NONE, RSMRST, NF1), /* LAD1 */
	PAD_CFG_NF(GPP_A3, NONE, RSMRST, NF1), /* LAD2 */
	PAD_CFG_NF(GPP_A4, NONE, RSMRST, NF1), /* LAD3 */
	PAD_CFG_NF(GPP_A5, NONE, RSMRST, NF1), /* LFRAME# */
	PAD_CFG_NF(GPP_A6, NONE, RSMRST, NF1), /* SERIRQ */
	PAD_CFG_NF(GPP_A8, NONE, RSMRST, NF1), /* CLKRUN# */
	PAD_CFG_NF(GPP_A9, NONE, RSMRST, NF1), /* CLKOUT_LPC0 */
	PAD_NC(GPP_A10, NONE), /* GPIO */
	PAD_CFG_NF(GPP_A13, NONE, RSMRST, NF1), /* SUSWARN#/SUSPWRDNACK */
	PAD_NC(GPP_A14, NONE), /* GPIO */
	PAD_CFG_NF(GPP_A15, NONE, RSMRST, NF1), /* SUS_ACK# */
};

#endif /* CFG_GPIO_H */
