@echo off
rem A batchfile to install Cream on Windows. (We assume this runs at
rem the root of the Cream file structure.)

rem rem make sure command extensions are on
rem     cmd /x

rem expand this file's path
	set FNAME=%0
	if not "%OS%"=="Windows_NT" goto NoWinNT
rem set FNAME to ???
	for %%A in (%FNAME%) do set NEW=%%~$PATH:A
	if not "%NEW%"=="" set FNAME=%NEW%
	set NEW=
	:NoWinNT

rem find VIMRUNTIME path (using dir /x format)
:FINDVRT
	set PROGRAMS=C:\PROGRA~1

	set VRT=%PROGRAMS%\vim\vim73
	if exist %VRT%\CON goto FINDVRTYES
	set VRT=%PROGRAMS%\vim\vim72
	if exist %VRT%\CON goto FINDVRTYES
	set VRT=%PROGRAMS%\vim\vim71
	if exist %VRT%\CON goto FINDVRTYES
	set VRT=%PROGRAMS%\vim\vim70
	if exist %VRT%\CON goto FINDVRTYES
rem WinXP-64 uses "Program Files (x86)
	set PROGRAMS=C:\PROGRA~2
	set VRT=%PROGRAMS%\vim\vim73
	if exist %VRT%\CON goto FINDVRTYES
	set VRT=%PROGRAMS%\vim\vim72
	if exist %VRT%\CON goto FINDVRTYES
	set VRT=%PROGRAMS%\vim\vim71
	if exist %VRT%\CON goto FINDVRTYES
	set VRT=%PROGRAMS%\vim\vim70
	if exist %VRT%\CON goto FINDVRTYES
echo  %FNAME% could not find a Vim installation, unable to continue.
	goto QUIT
	:FINDVRTYES

:VERIFY
	echo  Cream will be installed in "%VRT%".
	echo  (Press Ctrl+C to stop now, or any other key to continue.)
	echo.
	pause >nul

:DIRS
rem directories
	echo Verifying and creating directories...
	echo  %VRT%\cream
	if not exist %VRT%\cream\CON mkdir %VRT%\cream
	echo  %VRT%\cream\addons
	if not exist %VRT%\cream\addons\CON mkdir %VRT%\cream\addons
	echo  %VRT%\cream\bitmaps
	if not exist %VRT%\cream\bitmaps\CON mkdir %VRT%\cream\bitmaps
	echo  %VRT%\cream\docs
	if not exist %VRT%\cream\docs\CON mkdir %VRT%\cream\docs
	echo  %VRT%\cream\docs-html
	if not exist %VRT%\cream\docs-html\CON mkdir %VRT%\cream\docs-html
	echo  %VRT%\cream\filetypes
	if not exist %VRT%\cream\filetypes\CON mkdir %VRT%\cream\filetypes
	echo  %VRT%\cream\help
	if not exist %VRT%\cream\help\CON mkdir %VRT%\cream\help
	echo  %VRT%\cream\lang
	if not exist %VRT%\cream\lang\CON mkdir %VRT%\cream\lang
	rem echo  %VRT%\cream\spelldicts
	rem if not exist %VRT%\cream\spelldicts\CON mkdir %VRT%\cream\spelldicts

:INSTALL
rem runtime files
	echo.
	echo Installing/upgrading runtime files...
	echo  %VRT%\cream\creamrc
	xcopy /D /Y creamrc %VRT%\cream\
	echo  %VRT%\cream\*.vim
	xcopy /D /Y *.vim %VRT%\cream\
rem echo  %VRT%\cream\cream.png
rem xcopy /D /Y cream.png %VRT%\cream\
rem echo  %VRT%\cream\cream.svg
rem xcopy /D /Y cream.svg %VRT%\cream\
	echo  %VRT%\cream\cream.ico
	xcopy /D /Y cream.ico %VRT%\cream\
	echo  %VRT%\cream\addons\*.vim
	xcopy /D /Y .\addons\*.vim %VRT%\cream\addons\
rem echo  %VRT%\cream\bitmaps\*.xpm
rem xcopy /D /Y .\bitmaps\*.xpm %VRT%\cream\bitmaps\
	echo  %VRT%\cream\bitmaps\*.bmp
	xcopy /D /Y .\bitmaps\*.bmp %VRT%\cream\bitmaps\
	echo  %VRT%\cream\docs\*.txt
	xcopy /D /Y .\docs\*.txt %VRT%\cream\docs\
	echo  %VRT%\cream\docs-html\*.html
	xcopy /D /Y .\docs-html\*.html %VRT%\cream\docs-html\
	echo  %VRT%\cream\docs-html\css.php
	xcopy /D /Y .\docs-html\css.php %VRT%\cream\docs-html\
	echo  %VRT%\cream\docs-html\favicon.ico
	xcopy /D /Y .\docs-html\favicon.ico %VRT%\cream\docs-html\
	echo  %VRT%\cream\docs-html\*.png
	xcopy /D /Y .\docs-html\*.png %VRT%\cream\docs-html\
	echo  %VRT%\cream\docs-html\*.gif
	xcopy /D /Y .\docs-html\*.gif %VRT%\cream\docs-html\
	echo  %VRT%\cream\filetypes\*.vim
	xcopy /D /Y .\filetypes\*.vim %VRT%\cream\filetypes\
	echo  %VRT%\cream\help\*.txt
	xcopy /D /Y .\help\*.txt %VRT%\cream\help\
	echo  %VRT%\cream\lang\*.vim
	xcopy /D /Y .\lang\*.vim %VRT%\cream\lang\
rem echo  %VRT%\cream\spelldicts\cream-spell-dict.vim
rem xcopy /D /Y .\spelldicts\cream-spell-dict.vim %VRT%\cream\spelldicts\
rem echo  %VRT%\cream\spelldicts\cream-spell-dict-eng-s*.vim
rem xcopy /D /Y .\spelldicts\cream-spell-dict-eng-s*.vim %VRT%\cream\spelldicts\

:INSTALLCOMMAND
rem command
	echo Cream command installation...

rem discover path (most favored should be LAST)
	for %%A in (C:\Windows C:\Windows\Command C:\Windows\System32 C:\Windows\System) do if exist %%A\CON set ONPATH=%%A
	if "%ONPATH%"=="" echo  Unable to find location on PATH for cream.bat, you can copy it
	if "%ONPATH%"=="" echo  manually if you wish to call Cream from the Command Prompt.
	if "%ONPATH%"=="" goto CmdInstDone

rem OPTION 1
rem     if "%OS%"=="Windows_NT" goto CmdAskNT
rem :CmdAsk95
rem rem WinNT doesn't have "choice"
rem     choice /C:ny /N Copy cream.bat on PATH to %ONPATH% [y/n] ?
rem     if errorlevel 2 goto CmdInst
rem     goto CmdInstDone
rem :CmdAskNT
rem     set /P CH=Copy cream.bat on PATH to %ONPATH% [y/n] ?
rem     if /I "%CH%"=="Y" goto CmdInst
rem     goto CmdInstDone

rem OPTION 2
rem WinNT doesn't have "choice"
	if not "%OS%"=="Windows_NT" choice /C:ny /N Copy cream.bat on PATH to %ONPATH% [y/n] ?
	if not "%OS%"=="Windows_NT" if errorlevel 2 goto CmdInst
	if "%OS%"=="Windows_NT" set /P CH=Copy cream.bat on PATH to %ONPATH% [y/n] ?
	if "%OS%"=="Windows_NT" if "%CH%"=="y" goto CmdInst
	if "%OS%"=="Windows_NT" if "%CH%"=="Y" goto CmdInst
	goto CmdInstDone

:CmdInst
	echo Copying %ONPATH%\cream.bat...
	xcopy /Y cream.bat %ONPATH%

:CmdInstDone

rem rem menu entry
rem     echo Menu entry...
rem     echo   \usr\share\applications\cream.desktop
rem     xcopy /D /Y cream.desktop \usr\share\applications\

rem rem icons
rem     echo Icons...
rem     echo   \usr\share\icons...
rem     xcopy /D /Y cream.svg \usr\share\icons\
rem     xcopy /D /Y cream.png \usr\share\icons\

:UPGRADES
	echo Previous version cleanup...
rem 0.40
	if exist %VRT%\cream\EasyHtml.vim del %VRT%\cream\EasyHtml.vim
rem 0.38
	if exist %VRT%\cream\spelldicts\CON del /Q /S %VRT%\cream\spelldicts\*.*
	if exist %VRT%\cream\spelldicts\CON rmdir %VRT%\cream\spelldicts
	if exist %VRT%\cream\help\opsplorer.txt del %VRT%\cream\help\opsplorer.txt
rem 0.37
	if exist %VRT%\cream\cream-explorer.vim del %VRT%\cream\cream-explorer.vim
	if exist %VRT%\cream\opsplorer.vim del %VRT%\cream\opsplorer.vim
rem 0.36
	if exist %VRT%\cream\cream-window-buffer.vim del %VRT%\cream\cream-window-buffer.vim
	if exist %VRT%\cream\docs-html\contribute.html del %VRT%\cream\docs-html\contribute.html
	if exist %VRT%\cream\docs-html\favicon.png del %VRT%\cream\docs-html\favicon.png
	if exist %VRT%\cream\docs-html\license.html del %VRT%\cream\docs-html\license.html
	if exist %VRT%\cream\docs-html\links.html del %VRT%\cream\docs-html\links.html
	if exist %VRT%\cream\docs-html\maillists.html del %VRT%\cream\docs-html\maillists.html
	if exist %VRT%\cream\docs-html\main.css del %VRT%\cream\docs-html\main.css
	if exist %VRT%\cream\docs-html\screenshot4.png del %VRT%\cream\docs-html\screenshot4.png
	if exist %VRT%\cream\docs-html\screenshot4-thumb.png del %VRT%\cream\docs-html\screenshot4-thumb.png
	if exist %VRT%\cream\docs-html\screenshot-popup.png del %VRT%\cream\docs-html\screenshot-popup.png
	if exist %VRT%\cream\docs-html\screenshots1-closeup.html del %VRT%\cream\docs-html\screenshots1-closeup.html
	if exist %VRT%\cream\docs-html\screenshots2-closeup.html del %VRT%\cream\docs-html\screenshots2-closeup.html
	if exist %VRT%\cream\docs-html\screenshots3-closeup.html del %VRT%\cream\docs-html\screenshots3-closeup.html
	if exist %VRT%\cream\docs-html\screenshots4-closeup.html del %VRT%\cream\docs-html\screenshots4-closeup.html
	if exist %VRT%\cream\docs-html\screenshots.html del %VRT%\cream\docs-html\screenshots.html
	if exist %VRT%\cream\docs-html\spellcheck.html del %VRT%\cream\docs-html\spellcheck.html
	if exist %VRT%\cream\docs-html\statusline-closeup.html del %VRT%\cream\docs-html\statusline-closeup.html

rem 0.34
	if exist %VRT%\cream\docs-html\screenshots5-closeup.html del %VRT%\cream\docs-html\screenshots5-closeup.html
	if exist %VRT%\cream\docs-html\screenshots6-closeup.html del %VRT%\cream\docs-html\screenshots6-closeup.html
	if exist %VRT%\cream\docs-html\screenshots7-closeup.html del %VRT%\cream\docs-html\screenshots7-closeup.html
	if exist %VRT%\cream\docs-html\screenshots8-closeup.html del %VRT%\cream\docs-html\screenshots8-closeup.html
	if exist %VRT%\cream\docs-html\screenshot5.png del %VRT%\cream\docs-html\screenshot5.png
	if exist %VRT%\cream\docs-html\screenshot6.png del %VRT%\cream\docs-html\screenshot6.png
	if exist %VRT%\cream\docs-html\screenshot7.png del %VRT%\cream\docs-html\screenshot7.png
	if exist %VRT%\cream\docs-html\screenshot8.png del %VRT%\cream\docs-html\screenshot8.png
	if exist %VRT%\cream\docs-html\screenshot5-thumb.png del %VRT%\cream\docs-html\screenshot5-thumb.png
	if exist %VRT%\cream\docs-html\screenshot6-thumb.png del %VRT%\cream\docs-html\screenshot6-thumb.png
	if exist %VRT%\cream\docs-html\screenshot7-thumb.png del %VRT%\cream\docs-html\screenshot7-thumb.png
	if exist %VRT%\cream\docs-html\screenshot8-thumb.png del %VRT%\cream\docs-html\screenshot8-thumb.png
	if exist %VRT%\cream\docs-html\maillist.html del %VRT%\cream\docs-html\maillist.html
	if exist %VRT%\cream\docs-html\otherfiles.html del %VRT%\cream\docs-html\otherfiles.html
rem 0.33
	rem Not applicable
rem 0.31
	if exist %VRT%\cream\docs-html\love.html del %VRT%\cream\docs-html\love.html
	if exist %VRT%\cream\docs-html\hate.html del %VRT%\cream\docs-html\hate.html
	if exist %VRT%\cream\docs-html\background.html del %VRT%\cream\docs-html\background.html
	if exist %VRT%\cream\docs-html\goals.html del %VRT%\cream\docs-html\goals.html
	if exist %VRT%\cream\docs-html\screenshot-arabic1.png del %VRT%\cream\docs-html\screenshot-arabic1.png
	if exist %VRT%\cream\docs-html\devel.html del %VRT%\cream\docs-html\devel.html
	if exist %VRT%\cream\docs-html\creamlogo.png del %VRT%\cream\docs-html\creamlogo.png
rem 0.30
	if exist %VRT%\cream\cream-filetype-c.vim del %VRT%\cream\cream-filetype-c.vim
	if exist %VRT%\cream\cream-filetype-html.vim del %VRT%\cream\cream-filetype-html.vim
	if exist %VRT%\cream\cream-filetype-txt.vim del %VRT%\cream\cream-filetype-txt.vim
	if exist %VRT%\cream\cream-filetype-vim.vim del %VRT%\cream\cream-filetype-vim.vim
rem earlier
	if exist %VRT%\cream\docs-html\todo.html del %VRT%\cream\docs-html\todo.html
	if exist %VRT%\cream\docs-html\changelog.html del %VRT%\cream\docs-html\changelog.html
	if exist %VRT%\cream\docs-html\bugs.html del %VRT%\cream\docs-html\bugs.html
	if exist %VRT%\cream\docs\SPELLDICTS.txt del %VRT%\cream\docs\SPELLDICTS.txt
	if exist %VRT%\cream\docs\SPELLTEST-ENG.txt del %VRT%\cream\docs\SPELLTEST-ENG.txt
	if exist %VRT%\cream\docs\FILELIST.txt del %VRT%\cream\docs\FILELIST.txt
	if exist %VRT%\cream\docs\BUGS.txt del %VRT%\cream\docs\BUGS.txt
    rem Note: This is one char different from 0.36 file!
	if exist %VRT%\cream\docs-html\downloads.html del %VRT%\cream\docs-html\downloads.html

	if exist %VRT%\cream\cream-filetype-c.vim del %VRT%\cream\cream-filetype-*.vim >nul

:QUIT
	echo Finished.
	echo.

	set VRT=
	set PROGRAMS=
	set FNAME=
	set ONPATH=
	set CH=

:END

