/***************************************************************************
 *     Copyright (c) 1999-2009, Broadcom Corporation
 *
 **********************************************************************
 * This file is part of the crystalhd device driver.
 *
 * This driver is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This driver is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this driver.  If not, see <http://www.gnu.org/licenses/>.
 **********************************************************************
 *
 * $brcm_Workfile: bchp_common.h $
 * $brcm_Revision: Hydra_Software_Devel/1 $
 * $brcm_Date: 7/17/09 7:58p $
 *
 * Module Description:
 *                     DO NOT EDIT THIS FILE DIRECTLY
 *
 * This module was generated magically with RDB from a source description
 * file. You must edit the source file for changes to be made to this file.
 *
 *
 * Date:           Generated on         Fri Jul 17 19:41:59 2009
 *                 MD5 Checksum         2914699efc3fb3edefca5cb4f4f38b34
 *
 * Compiled with:  RDB Utility          combo_header.pl
 *                 RDB Parser           3.0
 *                 unknown              unknown
 *                 Perl Interpreter     5.008008
 *                 Operating System     linux
 *
 * Revision History:
 *
 * $brcm_Log: /magnum/basemodules/chp/70015/rdb/a0/bchp_common.h $
 * 
 * Hydra_Software_Devel/1   7/17/09 7:58p albertl
 * PR56880: Initial revision.
 *
 ***************************************************************************/

#ifndef BCHP_COMMON_H__
#define BCHP_COMMON_H__

/***************************************************************************
 *BCM70015_A0
 ***************************************************************************/
#define BCHP_PHYSICAL_OFFSET                               0x10000000
#define BCHP_REGISTER_START                                0x00070000 /* CLK is first */
#define BCHP_REGISTER_END                                  0x01801250 /* DDR23_PHY_BYTE_LANE_0 is last */
#define BCHP_REGISTER_SIZE                                 0x005e4494 /* Number of registers */

/****************************************************************************
 * Core instance register start address.
 ***************************************************************************/
#define BCHP_CLK_REG_START                                 0x00070000
#define BCHP_CLK_REG_END                                   0x00070304
#define BCHP_CLK_GR_REG_START                              0x00072000
#define BCHP_CLK_GR_REG_END                                0x0007200c
#define BCHP_ARMCR4_BRIDGE_REG_START                       0x000e0000
#define BCHP_ARMCR4_BRIDGE_REG_END                         0x000e0098
#define BCHP_ARMCR4_BRIDGE_AXI_SLAVE_REG_START             0x000e1000
#define BCHP_ARMCR4_BRIDGE_AXI_SLAVE_REG_END               0x000e1004
#define BCHP_TRB_TOP_REG_START                             0x000f0000
#define BCHP_TRB_TOP_REG_END                               0x000f0008
#define BCHP_WRAP_MISC_GR_BRIDGE_REG_START                 0x000f1000
#define BCHP_WRAP_MISC_GR_BRIDGE_REG_END                   0x000f100c
#define BCHP_WRAP_MISC_INTR2_REG_START                     0x000f2000
#define BCHP_WRAP_MISC_INTR2_REG_END                       0x000f202c
#define BCHP_ARM_UART_REG_START                            0x000f3000
#define BCHP_ARM_UART_REG_END                              0x000f3008
#define BCHP_SHARF_TOP_REG_START                           0x000f4000
#define BCHP_SHARF_TOP_REG_END                             0x000f4094
#define BCHP_SHARF_MEM_DMA0_REG_START                      0x000f4100
#define BCHP_SHARF_MEM_DMA0_REG_END                        0x000f411c
#define BCHP_MEM_DMA_REG_START                             0x000f5000
#define BCHP_MEM_DMA_REG_END                               0x000f5024
#define BCHP_SCRUB_CTRL_REG_START                          0x000f6000
#define BCHP_SCRUB_CTRL_REG_END                            0x000f6078
#define BCHP_MEM_DMA_SECURE_REG_START                      0x000fc000
#define BCHP_MEM_DMA_SECURE_REG_END                        0x000fc00c
#define BCHP_MMSCRAM_REG_START                             0x000fd000
#define BCHP_MMSCRAM_REG_END                               0x000feffc
#define BCHP_TRIPLE_SEC_REG_START                          0x000ff000
#define BCHP_TRIPLE_SEC_REG_END                            0x000ff4fc
#define BCHP_WRAP_MISC_SECURE_INTR2_REG_START              0x000ff500
#define BCHP_WRAP_MISC_SECURE_INTR2_REG_END                0x000ff52c
#define BCHP_XPT_BUS_IF_REG_START                          0x00200000
#define BCHP_XPT_BUS_IF_REG_END                            0x00200074
#define BCHP_XPT_XMEMIF_REG_START                          0x00202000
#define BCHP_XPT_XMEMIF_REG_END                            0x00202064
#define BCHP_XPT_FE_REG_START                              0x00208000
#define BCHP_XPT_FE_REG_END                                0x00208dfc
#define BCHP_XPT_PB0_REG_START                             0x0020b000
#define BCHP_XPT_PB0_REG_END                               0x0020b048
#define BCHP_XPT_PB1_REG_START                             0x0020b080
#define BCHP_XPT_PB1_REG_END                               0x0020b0c8
#define BCHP_XPT_PB2_REG_START                             0x0020b100
#define BCHP_XPT_PB2_REG_END                               0x0020b148
#define BCHP_XPT_RAVE_REG_START                            0x00210000
#define BCHP_XPT_RAVE_REG_END                              0x0021a50c
#define BCHP_XPT_XPU_REG_START                             0x00220000
#define BCHP_XPT_XPU_REG_END                               0x002227fc
#define BCHP_XPT_PCROFFSET_REG_START                       0x00227000
#define BCHP_XPT_PCROFFSET_REG_END                         0x00227ffc
#define BCHP_XPT_GR_REG_START                              0x00230000
#define BCHP_XPT_GR_REG_END                                0x0023000c
#define BCHP_SUN_GISB_ARB_REG_START                        0x00400000
#define BCHP_SUN_GISB_ARB_REG_END                          0x004000d8
#define BCHP_SUN_RGR_REG_START                             0x00400800
#define BCHP_SUN_RGR_REG_END                               0x00400810
#define BCHP_SUN_RG_REG_START                              0x00401000
#define BCHP_SUN_RG_REG_END                                0x0040100c
#define BCHP_SUN_L2_REG_START                              0x00401800
#define BCHP_SUN_L2_REG_END                                0x0040182c
#define BCHP_PM_L2_REG_START                               0x00401c00
#define BCHP_PM_L2_REG_END                                 0x00401c2c
#define BCHP_SUN_TOP_CTRL_REG_START                        0x00404000
#define BCHP_SUN_TOP_CTRL_REG_END                          0x00404608
#define BCHP_GIO_REG_START                                 0x00406000
#define BCHP_GIO_REG_END                                   0x0040601c
#define BCHP_IRQ0_REG_START                                0x00406080
#define BCHP_IRQ0_REG_END                                  0x00406084
#define BCHP_TIMER_REG_START                               0x004060c0
#define BCHP_TIMER_REG_END                                 0x004060fc
#define BCHP_IRQ1_REG_START                                0x00406788
#define BCHP_IRQ1_REG_END                                  0x0040678c
#define BCHP_WAKEUP_CTRL2_REG_START                        0x00406c00
#define BCHP_WAKEUP_CTRL2_REG_END                          0x00406c14
#define BCHP_PRI_CLIENT_REGS_REG_START                     0x0040c000
#define BCHP_PRI_CLIENT_REGS_REG_END                       0x0040c27c
#define BCHP_PRI_CRIT_L2_REGS_1_REG_START                  0x0040c400
#define BCHP_PRI_CRIT_L2_REGS_1_REG_END                    0x0040c42c
#define BCHP_PRI_CRIT_L2_REGS_2_REG_START                  0x0040c440
#define BCHP_PRI_CRIT_L2_REGS_2_REG_END                    0x0040c46c
#define BCHP_PRI_CRIT_L2_REGS_3_REG_START                  0x0040c480
#define BCHP_PRI_CRIT_L2_REGS_3_REG_END                    0x0040c4ac
#define BCHP_PRI_RTS_L2_REGS_1_REG_START                   0x0040c4c0
#define BCHP_PRI_RTS_L2_REGS_1_REG_END                     0x0040c4ec
#define BCHP_PRI_RTS_L2_REGS_2_REG_START                   0x0040c500
#define BCHP_PRI_RTS_L2_REGS_2_REG_END                     0x0040c52c
#define BCHP_PRI_RTS_L2_REGS_3_REG_START                   0x0040c540
#define BCHP_PRI_RTS_L2_REGS_3_REG_END                     0x0040c56c
#define BCHP_PRI_ARB_TRACE_REGS_REG_START                  0x0040c600
#define BCHP_PRI_ARB_TRACE_REGS_REG_END                    0x0040c7ec
#define BCHP_PRI_ARB_MSA_REGS_REG_START                    0x0040c800
#define BCHP_PRI_ARB_MSA_REGS_REG_END                      0x0040ca0c
#define BCHP_PRI_ARB_CONTROL_REGS_REG_START                0x0040cb00
#define BCHP_PRI_ARB_CONTROL_REGS_REG_END                  0x0040cb30
#define BCHP_PRI_ARB_ARCH_REGS_REG_START                   0x0040cc00
#define BCHP_PRI_ARB_ARCH_REGS_REG_END                     0x0040cdac
#define BCHP_PRI_ARB_MIPS_L2_REGS_REG_START                0x0040ce00
#define BCHP_PRI_ARB_MIPS_L2_REGS_REG_END                  0x0040ce2c
#define BCHP_PRI_ARB_ARC_L1_REGS_REG_START                 0x0040cf00
#define BCHP_PRI_ARB_ARC_L1_REGS_REG_END                   0x0040cf1c
#define BCHP_SENTINEL_REG_START                            0x00410000
#define BCHP_SENTINEL_REG_END                              0x00413ffc
#define BCHP_SUN_GISB_ARB_SEC_REG_START                    0x00460000
#define BCHP_SUN_GISB_ARB_SEC_REG_END                      0x00460064
#define BCHP_PRI_ARB_WRCH_REGS_REG_START                   0x00461000
#define BCHP_PRI_ARB_WRCH_REGS_REG_END                     0x004610fc
#define BCHP_PRI_ARB_STARCH_REGS_REG_START                 0x00461200
#define BCHP_PRI_ARB_STARCH_REGS_REG_END                   0x004613c0
#define BCHP_PRI_ARB_SARCH_REGS_REG_START                  0x00461400
#define BCHP_PRI_ARB_SARCH_REGS_REG_END                    0x0046159c
#define BCHP_PCIE_CFG_REG_START                            0x00500000
#define BCHP_PCIE_CFG_REG_END                              0x0050018c
#define BCHP_PCIE_TL_REG_START                             0x00500400
#define BCHP_PCIE_TL_REG_END                               0x0050046c
#define BCHP_PCIE_DLL_REG_START                            0x00500500
#define BCHP_PCIE_DLL_REG_END                              0x00500554
#define BCHP_PCIE_PHY_REG_START                            0x00500600
#define BCHP_PCIE_PHY_REG_END                              0x0050063c
#define BCHP_INTR_REG_START                                0x00500700
#define BCHP_INTR_REG_END                                  0x00500734
#define BCHP_L1_INTR_REG_START                             0x00500740
#define BCHP_L1_INTR_REG_END                               0x0050075c
#define BCHP_MDIO_REG_START                                0x00500760
#define BCHP_MDIO_REG_END                                  0x00500768
#define BCHP_TGT_RGR_BRIDGE_REG_START                      0x00500780
#define BCHP_TGT_RGR_BRIDGE_REG_END                        0x00500790
#define BCHP_I2C_REG_START                                 0x00501000
#define BCHP_I2C_REG_END                                   0x00501054
#define BCHP_I2C_GR_BRIDGE_REG_START                       0x005013e0
#define BCHP_I2C_GR_BRIDGE_REG_END                         0x005013ec
#define BCHP_MISC1_REG_START                               0x00502000
#define BCHP_MISC1_REG_END                                 0x005020d0
#define BCHP_MISC2_REG_START                               0x00502100
#define BCHP_MISC2_REG_END                                 0x00502120
#define BCHP_MISC3_REG_START                               0x00502200
#define BCHP_MISC3_REG_END                                 0x0050222c
#define BCHP_MISC_PERST_REG_START                          0x00502280
#define BCHP_MISC_PERST_REG_END                            0x0050229c
#define BCHP_MISC_GR_BRIDGE_REG_START                      0x005023e0
#define BCHP_MISC_GR_BRIDGE_REG_END                        0x005023ec
#define BCHP_CCE_RGR_BRIDGE_REG_START                      0x005033e0
#define BCHP_CCE_RGR_BRIDGE_REG_END                        0x005033f0
#define BCHP_BOP_AES_REG_START                             0x00510000
#define BCHP_BOP_AES_REG_END                               0x00510034
#define BCHP_BOP_GR_BRIDGE_REG_START                       0x00511000
#define BCHP_BOP_GR_BRIDGE_REG_END                         0x0051100c
#define BCHP_MFD_REG_START                                 0x00540000
#define BCHP_MFD_REG_END                                   0x005400fc
#define BCHP_DNR_REG_START                                 0x00540400
#define BCHP_DNR_REG_END                                   0x005404a0
#define BCHP_SCL_HD_REG_START                              0x00540800
#define BCHP_SCL_HD_REG_END                                0x00540bfc
#define BCHP_CSC_REG_START                                 0x00541000
#define BCHP_CSC_REG_END                                   0x0054103c
#define BCHP_BVNT_INTR2_REG_START                          0x00541200
#define BCHP_BVNT_INTR2_REG_END                            0x0054122c
#define BCHP_TMISC_REG_START                               0x00541400
#define BCHP_TMISC_REG_END                                 0x0054143c
#define BCHP_BVNT_GR_BRIDGE_REG_START                      0x00541800
#define BCHP_BVNT_GR_BRIDGE_REG_END                        0x0054180c
#define BCHP_DECODE_MAIN_0_REG_START                       0x00800100
#define BCHP_DECODE_MAIN_0_REG_END                         0x008001fc
#define BCHP_DECODE_MCOM_0_REG_START                       0x00800300
#define BCHP_DECODE_MCOM_0_REG_END                         0x0080031c
#define BCHP_DECODE_SPRE_0_REG_START                       0x00800320
#define BCHP_DECODE_SPRE_0_REG_END                         0x0080033c
#define BCHP_DECODE_WPRD_0_REG_START                       0x00800340
#define BCHP_DECODE_WPRD_0_REG_END                         0x0080035c
#define BCHP_DECODE_DQNT_0_REG_START                       0x00800400
#define BCHP_DECODE_DQNT_0_REG_END                         0x0080045c
#define BCHP_DECODE_DQNT_8X8_0_REG_START                   0x00800500
#define BCHP_DECODE_DQNT_8X8_0_REG_END                     0x0080057c
#define BCHP_DECODE_XFRM_0_REG_START                       0x00800700
#define BCHP_DECODE_XFRM_0_REG_END                         0x0080071c
#define BCHP_DECODE_DBLK_0_REG_START                       0x00800720
#define BCHP_DECODE_DBLK_0_REG_END                         0x0080073c
#define BCHP_DECODE_MB_0_REG_START                         0x00800740
#define BCHP_DECODE_MB_0_REG_END                           0x0080075c
#define BCHP_REG_CABAC2BINS_0_REG_START                    0x00800b00
#define BCHP_REG_CABAC2BINS_0_REG_END                      0x00800bfc
#define BCHP_DECODE_SINT_0_REG_START                       0x00800c00
#define BCHP_DECODE_SINT_0_REG_END                         0x00800dfc
#define BCHP_DECODE_RVC_0_REG_START                        0x00800e00
#define BCHP_DECODE_RVC_0_REG_END                          0x00800efc
#define BCHP_DECODE_CPUREGS_0_REG_START                    0x00800f00
#define BCHP_DECODE_CPUREGS_0_REG_END                      0x00800f7c
#define BCHP_DECODE_CPUREGS2_0_REG_START                   0x00800f80
#define BCHP_DECODE_CPUREGS2_0_REG_END                     0x00800ffc
#define BCHP_DECODE_CPUDMA_0_REG_START                     0x00801800
#define BCHP_DECODE_CPUDMA_0_REG_END                       0x008018fc
#define BCHP_DECODE_DMAMEM_0_REG_START                     0x00801a00
#define BCHP_DECODE_DMAMEM_0_REG_END                       0x008021fc
#define BCHP_REG_CABAC2BINS2_0_REG_START                   0x00802400
#define BCHP_REG_CABAC2BINS2_0_REG_END                     0x008027fc
#define BCHP_DECODE_WPTBL_0_REG_START                      0x00803000
#define BCHP_DECODE_WPTBL_0_REG_END                        0x008031fc
#define BCHP_DECODE_SINT_OLOOP_0_REG_START                 0x0080cc00
#define BCHP_DECODE_SINT_OLOOP_0_REG_END                   0x0080ccfc
#define BCHP_DECODE_IND_SDRAM_REGS_0_REG_START             0x00841000
#define BCHP_DECODE_IND_SDRAM_REGS_0_REG_END               0x0084107c
#define BCHP_DECODE_CPUCORE_0_REG_START                    0x00844000
#define BCHP_DECODE_CPUCORE_0_REG_END                      0x00844ffc
#define BCHP_DECODE_CPUAUX_0_REG_START                     0x00845000
#define BCHP_DECODE_CPUAUX_0_REG_END                       0x00845ffc
#define BCHP_DECODE_CPUIMEM_0_REG_START                    0x00846000
#define BCHP_DECODE_CPUIMEM_0_REG_END                      0x00847ffc
#define BCHP_DECODE_CPUDMEM_0_REG_START                    0x00848000
#define BCHP_DECODE_CPUDMEM_0_REG_END                      0x0084fffc
#define BCHP_DECODE_IND_SDRAM_REGS2_0_REG_START            0x00851000
#define BCHP_DECODE_IND_SDRAM_REGS2_0_REG_END              0x0085107c
#define BCHP_DECODE_CPUDMA2_0_REG_START                    0x00851800
#define BCHP_DECODE_CPUDMA2_0_REG_END                      0x008518fc
#define BCHP_DECODE_DMAMEM2_0_REG_START                    0x00851a00
#define BCHP_DECODE_DMAMEM2_0_REG_END                      0x008521fc
#define BCHP_DECODE_CPUCORE2_0_REG_START                   0x00854000
#define BCHP_DECODE_CPUCORE2_0_REG_END                     0x00854ffc
#define BCHP_DECODE_CPUAUX2_0_REG_START                    0x00855000
#define BCHP_DECODE_CPUAUX2_0_REG_END                      0x00855ffc
#define BCHP_DECODE_CPUIMEM2_0_REG_START                   0x00856000
#define BCHP_DECODE_CPUIMEM2_0_REG_END                     0x00857ffc
#define BCHP_DECODE_CPUDMEM2_0_REG_START                   0x00858000
#define BCHP_DECODE_CPUDMEM2_0_REG_END                     0x0085fffc
#define BCHP_DECODE_IP_SHIM_0_REG_START                    0x00860000
#define BCHP_DECODE_IP_SHIM_0_REG_END                      0x0086007c
#define BCHP_AVD_BLOCK_AVG_REGS_0_REG_START                0x00861000
#define BCHP_AVD_BLOCK_AVG_REGS_0_REG_END                  0x0086103c
#define BCHP_AVD_CACHE_0_REG_START                         0x00862000
#define BCHP_AVD_CACHE_0_REG_END                           0x0086203c
#define BCHP_AVD_INTR2_0_REG_START                         0x00900000
#define BCHP_AVD_INTR2_0_REG_END                           0x0090002c
#define BCHP_AVD_GR_0_REG_START                            0x00900400
#define BCHP_AVD_GR_0_REG_END                              0x0090040c
#define BCHP_VICH_0_REG_START                              0x00b00000
#define BCHP_VICH_0_REG_END                                0x00b0004c
#define BCHP_DDR23_CTL_REGS_0_REG_START                    0x01800000
#define BCHP_DDR23_CTL_REGS_0_REG_END                      0x018001fc
#define BCHP_DDR23_PHY_CONTROL_REGS_REG_START              0x01801000
#define BCHP_DDR23_PHY_CONTROL_REGS_REG_END                0x01801044
#define BCHP_DDR23_PHY_BYTE_LANE_1_REG_START               0x01801100
#define BCHP_DDR23_PHY_BYTE_LANE_1_REG_END                 0x0180114c
#define BCHP_DDR23_PHY_BYTE_LANE_0_REG_START               0x01801200
#define BCHP_DDR23_PHY_BYTE_LANE_0_REG_END                 0x0180124c


/***************************************************************************
 *BVN_MFD
 ***************************************************************************/
/***************************************************************************
 *DRAM_DATA_STRUCTURE - DRAM Data Structure
 ***************************************************************************/
/* BVN_MFD :: DRAM_DATA_STRUCTURE :: DRAM_DATA_STRUCTURE [31:00] */
#define BCHP_BVN_MFD_DRAM_DATA_STRUCTURE_DRAM_DATA_STRUCTURE_MASK  0xffffffff
#define BCHP_BVN_MFD_DRAM_DATA_STRUCTURE_DRAM_DATA_STRUCTURE_SHIFT 0

/***************************************************************************
 *MEM_DMA
 ***************************************************************************/
/***************************************************************************
 *DESC_WORD0 - MEM DMA Descriptor Word 0
 ***************************************************************************/
/* MEM_DMA :: DESC_WORD0 :: READ_ADDR [31:00] */
#define BCHP_MEM_DMA_DESC_WORD0_READ_ADDR_MASK                     0xffffffff
#define BCHP_MEM_DMA_DESC_WORD0_READ_ADDR_SHIFT                    0

/***************************************************************************
 *DESC_WORD1 - MEM DMA Descriptor Word 1
 ***************************************************************************/
/* MEM_DMA :: DESC_WORD1 :: WRITE_ADDR [31:00] */
#define BCHP_MEM_DMA_DESC_WORD1_WRITE_ADDR_MASK                    0xffffffff
#define BCHP_MEM_DMA_DESC_WORD1_WRITE_ADDR_SHIFT                   0

/***************************************************************************
 *DESC_WORD2 - MEM DMA Descriptor Word 2
 ***************************************************************************/
/* MEM_DMA :: DESC_WORD2 :: INTR_ENABLE [31:31] */
#define BCHP_MEM_DMA_DESC_WORD2_INTR_ENABLE_MASK                   0x80000000
#define BCHP_MEM_DMA_DESC_WORD2_INTR_ENABLE_SHIFT                  31

/* MEM_DMA :: DESC_WORD2 :: LAST [30:30] */
#define BCHP_MEM_DMA_DESC_WORD2_LAST_MASK                          0x40000000
#define BCHP_MEM_DMA_DESC_WORD2_LAST_SHIFT                         30

/* MEM_DMA :: DESC_WORD2 :: AUTO_APPEND [29:29] */
#define BCHP_MEM_DMA_DESC_WORD2_AUTO_APPEND_MASK                   0x20000000
#define BCHP_MEM_DMA_DESC_WORD2_AUTO_APPEND_SHIFT                  29

/* MEM_DMA :: DESC_WORD2 :: reserved0 [28:25] */
#define BCHP_MEM_DMA_DESC_WORD2_reserved0_MASK                     0x1e000000
#define BCHP_MEM_DMA_DESC_WORD2_reserved0_SHIFT                    25

/* MEM_DMA :: DESC_WORD2 :: TRANSFER_SIZE [24:00] */
#define BCHP_MEM_DMA_DESC_WORD2_TRANSFER_SIZE_MASK                 0x01ffffff
#define BCHP_MEM_DMA_DESC_WORD2_TRANSFER_SIZE_SHIFT                0

/***************************************************************************
 *DESC_WORD3 - MEM DMA Descriptor Word 3
 ***************************************************************************/
/* MEM_DMA :: DESC_WORD3 :: NEXT_DESC_ADDR [31:05] */
#define BCHP_MEM_DMA_DESC_WORD3_NEXT_DESC_ADDR_MASK                0xffffffe0
#define BCHP_MEM_DMA_DESC_WORD3_NEXT_DESC_ADDR_SHIFT               5

/* MEM_DMA :: DESC_WORD3 :: reserved0 [04:03] */
#define BCHP_MEM_DMA_DESC_WORD3_reserved0_MASK                     0x00000018
#define BCHP_MEM_DMA_DESC_WORD3_reserved0_SHIFT                    3

/* MEM_DMA :: DESC_WORD3 :: READ_ENDIAN_MODE [02:02] */
#define BCHP_MEM_DMA_DESC_WORD3_READ_ENDIAN_MODE_MASK              0x00000004
#define BCHP_MEM_DMA_DESC_WORD3_READ_ENDIAN_MODE_SHIFT             2
#define BCHP_MEM_DMA_DESC_WORD3_READ_ENDIAN_MODE_BIG_ENDIAN        0
#define BCHP_MEM_DMA_DESC_WORD3_READ_ENDIAN_MODE_LITTLE_ENDIAN     1

/* MEM_DMA :: DESC_WORD3 :: WRITE_ENDIAN_XLATE_MODE [01:00] */
#define BCHP_MEM_DMA_DESC_WORD3_WRITE_ENDIAN_XLATE_MODE_MASK       0x00000003
#define BCHP_MEM_DMA_DESC_WORD3_WRITE_ENDIAN_XLATE_MODE_SHIFT      0
#define BCHP_MEM_DMA_DESC_WORD3_WRITE_ENDIAN_XLATE_MODE_WORD_ALIGNED 0
#define BCHP_MEM_DMA_DESC_WORD3_WRITE_ENDIAN_XLATE_MODE_HALF_WORD_ALIGNED 1
#define BCHP_MEM_DMA_DESC_WORD3_WRITE_ENDIAN_XLATE_MODE_BYTE_ALIGNED 2
#define BCHP_MEM_DMA_DESC_WORD3_WRITE_ENDIAN_XLATE_MODE_reserved   3

/***************************************************************************
 *DESC_WORD4 - MEM DMA Descriptor Word 4
 ***************************************************************************/
/* MEM_DMA :: DESC_WORD4 :: reserved0 [31:16] */
#define BCHP_MEM_DMA_DESC_WORD4_reserved0_MASK                     0xffff0000
#define BCHP_MEM_DMA_DESC_WORD4_reserved0_SHIFT                    16

/* MEM_DMA :: DESC_WORD4 :: SCRAM_CTRL_RSV [15:14] */
#define BCHP_MEM_DMA_DESC_WORD4_SCRAM_CTRL_RSV_MASK                0x0000c000
#define BCHP_MEM_DMA_DESC_WORD4_SCRAM_CTRL_RSV_SHIFT               14

/* MEM_DMA :: DESC_WORD4 :: SG_SCRAM_END [13:13] */
#define BCHP_MEM_DMA_DESC_WORD4_SG_SCRAM_END_MASK                  0x00002000
#define BCHP_MEM_DMA_DESC_WORD4_SG_SCRAM_END_SHIFT                 13

/* MEM_DMA :: DESC_WORD4 :: SG_SCRAM_START [12:12] */
#define BCHP_MEM_DMA_DESC_WORD4_SG_SCRAM_START_MASK                0x00001000
#define BCHP_MEM_DMA_DESC_WORD4_SG_SCRAM_START_SHIFT               12

/* MEM_DMA :: DESC_WORD4 :: SG_ENABLE [11:11] */
#define BCHP_MEM_DMA_DESC_WORD4_SG_ENABLE_MASK                     0x00000800
#define BCHP_MEM_DMA_DESC_WORD4_SG_ENABLE_SHIFT                    11

/* MEM_DMA :: DESC_WORD4 :: ENC_DEC_INIT [10:10] */
#define BCHP_MEM_DMA_DESC_WORD4_ENC_DEC_INIT_MASK                  0x00000400
#define BCHP_MEM_DMA_DESC_WORD4_ENC_DEC_INIT_SHIFT                 10

/* MEM_DMA :: DESC_WORD4 :: MODE_SEL [09:08] */
#define BCHP_MEM_DMA_DESC_WORD4_MODE_SEL_MASK                      0x00000300
#define BCHP_MEM_DMA_DESC_WORD4_MODE_SEL_SHIFT                     8

/* MEM_DMA :: DESC_WORD4 :: KEY_SELECT [07:00] */
#define BCHP_MEM_DMA_DESC_WORD4_KEY_SELECT_MASK                    0x000000ff
#define BCHP_MEM_DMA_DESC_WORD4_KEY_SELECT_SHIFT                   0

/***************************************************************************
 *DESC_WORD5 - MEM DMA Descriptor Word 5
 ***************************************************************************/
/* MEM_DMA :: DESC_WORD5 :: reserved0 [31:00] */
#define BCHP_MEM_DMA_DESC_WORD5_reserved0_MASK                     0xffffffff
#define BCHP_MEM_DMA_DESC_WORD5_reserved0_SHIFT                    0

/***************************************************************************
 *DESC_WORD6 - MEM DMA Descriptor Word 6
 ***************************************************************************/
/* MEM_DMA :: DESC_WORD6 :: reserved0 [31:00] */
#define BCHP_MEM_DMA_DESC_WORD6_reserved0_MASK                     0xffffffff
#define BCHP_MEM_DMA_DESC_WORD6_reserved0_SHIFT                    0

/***************************************************************************
 *DESC_WORD7 - MEM DMA Descriptor Word 7
 ***************************************************************************/
/* MEM_DMA :: DESC_WORD7 :: reserved0 [31:00] */
#define BCHP_MEM_DMA_DESC_WORD7_reserved0_MASK                     0xffffffff
#define BCHP_MEM_DMA_DESC_WORD7_reserved0_SHIFT                    0

/***************************************************************************
 *SHARF_MEM_DMA
 ***************************************************************************/
/***************************************************************************
 *DESC_WORD0 - SHARF DMA Descriptor Word 0
 ***************************************************************************/
/* SHARF_MEM_DMA :: DESC_WORD0 :: READ_ADDR [31:00] */
#define BCHP_SHARF_MEM_DMA_DESC_WORD0_READ_ADDR_MASK               0xffffffff
#define BCHP_SHARF_MEM_DMA_DESC_WORD0_READ_ADDR_SHIFT              0

/***************************************************************************
 *DESC_WORD1 - SHARF DMA Descriptor Word 1
 ***************************************************************************/
/* SHARF_MEM_DMA :: DESC_WORD1 :: WRITE_ADDR [31:00] */
#define BCHP_SHARF_MEM_DMA_DESC_WORD1_WRITE_ADDR_MASK              0xffffffff
#define BCHP_SHARF_MEM_DMA_DESC_WORD1_WRITE_ADDR_SHIFT             0

/***************************************************************************
 *DESC_WORD2 - SHARF DMA Descriptor Word 2
 ***************************************************************************/
/* SHARF_MEM_DMA :: DESC_WORD2 :: INTR_ENABLE [31:31] */
#define BCHP_SHARF_MEM_DMA_DESC_WORD2_INTR_ENABLE_MASK             0x80000000
#define BCHP_SHARF_MEM_DMA_DESC_WORD2_INTR_ENABLE_SHIFT            31

/* SHARF_MEM_DMA :: DESC_WORD2 :: LAST [30:30] */
#define BCHP_SHARF_MEM_DMA_DESC_WORD2_LAST_MASK                    0x40000000
#define BCHP_SHARF_MEM_DMA_DESC_WORD2_LAST_SHIFT                   30

/* SHARF_MEM_DMA :: DESC_WORD2 :: reserved0 [29:27] */
#define BCHP_SHARF_MEM_DMA_DESC_WORD2_reserved0_MASK               0x38000000
#define BCHP_SHARF_MEM_DMA_DESC_WORD2_reserved0_SHIFT              27

/* SHARF_MEM_DMA :: DESC_WORD2 :: TRANSFER_SIZE [26:00] */
#define BCHP_SHARF_MEM_DMA_DESC_WORD2_TRANSFER_SIZE_MASK           0x07ffffff
#define BCHP_SHARF_MEM_DMA_DESC_WORD2_TRANSFER_SIZE_SHIFT          0

/***************************************************************************
 *DESC_WORD3 - SHARF DMA Descriptor Word 3
 ***************************************************************************/
/* SHARF_MEM_DMA :: DESC_WORD3 :: NEXT_DESC_ADDR [31:05] */
#define BCHP_SHARF_MEM_DMA_DESC_WORD3_NEXT_DESC_ADDR_MASK          0xffffffe0
#define BCHP_SHARF_MEM_DMA_DESC_WORD3_NEXT_DESC_ADDR_SHIFT         5

/* SHARF_MEM_DMA :: DESC_WORD3 :: reserved0 [04:03] */
#define BCHP_SHARF_MEM_DMA_DESC_WORD3_reserved0_MASK               0x00000018
#define BCHP_SHARF_MEM_DMA_DESC_WORD3_reserved0_SHIFT              3

/* SHARF_MEM_DMA :: DESC_WORD3 :: READ_ENDIAN_MODE [02:02] */
#define BCHP_SHARF_MEM_DMA_DESC_WORD3_READ_ENDIAN_MODE_MASK        0x00000004
#define BCHP_SHARF_MEM_DMA_DESC_WORD3_READ_ENDIAN_MODE_SHIFT       2
#define BCHP_SHARF_MEM_DMA_DESC_WORD3_READ_ENDIAN_MODE_BIG_ENDIAN  0
#define BCHP_SHARF_MEM_DMA_DESC_WORD3_READ_ENDIAN_MODE_LITTLE_ENDIAN 1

/* SHARF_MEM_DMA :: DESC_WORD3 :: WRITE_ENDIAN_XLATE_MODE [01:00] */
#define BCHP_SHARF_MEM_DMA_DESC_WORD3_WRITE_ENDIAN_XLATE_MODE_MASK 0x00000003
#define BCHP_SHARF_MEM_DMA_DESC_WORD3_WRITE_ENDIAN_XLATE_MODE_SHIFT 0
#define BCHP_SHARF_MEM_DMA_DESC_WORD3_WRITE_ENDIAN_XLATE_MODE_WORD_ALIGNED 0
#define BCHP_SHARF_MEM_DMA_DESC_WORD3_WRITE_ENDIAN_XLATE_MODE_HALF_WORD_ALIGNED 1
#define BCHP_SHARF_MEM_DMA_DESC_WORD3_WRITE_ENDIAN_XLATE_MODE_BYTE_ALIGNED 2
#define BCHP_SHARF_MEM_DMA_DESC_WORD3_WRITE_ENDIAN_XLATE_MODE_reserved 3

/***************************************************************************
 *DESC_WORD4 - SHARF DMA Descriptor Word 4
 ***************************************************************************/
/* SHARF_MEM_DMA :: DESC_WORD4 :: reserved0 [31:20] */
#define BCHP_SHARF_MEM_DMA_DESC_WORD4_reserved0_MASK               0xfff00000
#define BCHP_SHARF_MEM_DMA_DESC_WORD4_reserved0_SHIFT              20

/* SHARF_MEM_DMA :: DESC_WORD4 :: KEY_UNWRAP_MODE [19:18] */
#define BCHP_SHARF_MEM_DMA_DESC_WORD4_KEY_UNWRAP_MODE_MASK         0x000c0000
#define BCHP_SHARF_MEM_DMA_DESC_WORD4_KEY_UNWRAP_MODE_SHIFT        18

/* SHARF_MEM_DMA :: DESC_WORD4 :: CONTEXT_NUM [17:16] */
#define BCHP_SHARF_MEM_DMA_DESC_WORD4_CONTEXT_NUM_MASK             0x00030000
#define BCHP_SHARF_MEM_DMA_DESC_WORD4_CONTEXT_NUM_SHIFT            16

/* SHARF_MEM_DMA :: DESC_WORD4 :: SECURE_FAIL_INTR_ENABLE [15:15] */
#define BCHP_SHARF_MEM_DMA_DESC_WORD4_SECURE_FAIL_INTR_ENABLE_MASK 0x00008000
#define BCHP_SHARF_MEM_DMA_DESC_WORD4_SECURE_FAIL_INTR_ENABLE_SHIFT 15

/* SHARF_MEM_DMA :: DESC_WORD4 :: FAIL_INTR_ENABLE [14:14] */
#define BCHP_SHARF_MEM_DMA_DESC_WORD4_FAIL_INTR_ENABLE_MASK        0x00004000
#define BCHP_SHARF_MEM_DMA_DESC_WORD4_FAIL_INTR_ENABLE_SHIFT       14

/* SHARF_MEM_DMA :: DESC_WORD4 :: SG_SCRAM_END [13:13] */
#define BCHP_SHARF_MEM_DMA_DESC_WORD4_SG_SCRAM_END_MASK            0x00002000
#define BCHP_SHARF_MEM_DMA_DESC_WORD4_SG_SCRAM_END_SHIFT           13

/* SHARF_MEM_DMA :: DESC_WORD4 :: SG_SCRAM_START [12:12] */
#define BCHP_SHARF_MEM_DMA_DESC_WORD4_SG_SCRAM_START_MASK          0x00001000
#define BCHP_SHARF_MEM_DMA_DESC_WORD4_SG_SCRAM_START_SHIFT         12

/* SHARF_MEM_DMA :: DESC_WORD4 :: SG_ENABLE [11:11] */
#define BCHP_SHARF_MEM_DMA_DESC_WORD4_SG_ENABLE_MASK               0x00000800
#define BCHP_SHARF_MEM_DMA_DESC_WORD4_SG_ENABLE_SHIFT              11

/* SHARF_MEM_DMA :: DESC_WORD4 :: CMP_8_LSBYTES [10:10] */
#define BCHP_SHARF_MEM_DMA_DESC_WORD4_CMP_8_LSBYTES_MASK           0x00000400
#define BCHP_SHARF_MEM_DMA_DESC_WORD4_CMP_8_LSBYTES_SHIFT          10

/* SHARF_MEM_DMA :: DESC_WORD4 :: reserved1 [09:08] */
#define BCHP_SHARF_MEM_DMA_DESC_WORD4_reserved1_MASK               0x00000300
#define BCHP_SHARF_MEM_DMA_DESC_WORD4_reserved1_SHIFT              8

/* SHARF_MEM_DMA :: DESC_WORD4 :: MODE_SEL [07:04] */
#define BCHP_SHARF_MEM_DMA_DESC_WORD4_MODE_SEL_MASK                0x000000f0
#define BCHP_SHARF_MEM_DMA_DESC_WORD4_MODE_SEL_SHIFT               4

/* SHARF_MEM_DMA :: DESC_WORD4 :: USE_BSP_KEY [03:03] */
#define BCHP_SHARF_MEM_DMA_DESC_WORD4_USE_BSP_KEY_MASK             0x00000008
#define BCHP_SHARF_MEM_DMA_DESC_WORD4_USE_BSP_KEY_SHIFT            3

/* SHARF_MEM_DMA :: DESC_WORD4 :: reserved2 [02:02] */
#define BCHP_SHARF_MEM_DMA_DESC_WORD4_reserved2_MASK               0x00000004
#define BCHP_SHARF_MEM_DMA_DESC_WORD4_reserved2_SHIFT              2

/* SHARF_MEM_DMA :: DESC_WORD4 :: DIGEST_PRESENT [01:01] */
#define BCHP_SHARF_MEM_DMA_DESC_WORD4_DIGEST_PRESENT_MASK          0x00000002
#define BCHP_SHARF_MEM_DMA_DESC_WORD4_DIGEST_PRESENT_SHIFT         1

/* SHARF_MEM_DMA :: DESC_WORD4 :: KEY_PRESENT [00:00] */
#define BCHP_SHARF_MEM_DMA_DESC_WORD4_KEY_PRESENT_MASK             0x00000001
#define BCHP_SHARF_MEM_DMA_DESC_WORD4_KEY_PRESENT_SHIFT            0

/***************************************************************************
 *DESC_WORD5 - SHARF DMA Descriptor Word 5
 ***************************************************************************/
/* SHARF_MEM_DMA :: DESC_WORD5 :: INDEX [31:00] */
#define BCHP_SHARF_MEM_DMA_DESC_WORD5_INDEX_MASK                   0xffffffff
#define BCHP_SHARF_MEM_DMA_DESC_WORD5_INDEX_SHIFT                  0

/***************************************************************************
 *DESC_WORD6 - SHARF DMA Descriptor Word 6
 ***************************************************************************/
/* SHARF_MEM_DMA :: DESC_WORD6 :: reserved0 [31:00] */
#define BCHP_SHARF_MEM_DMA_DESC_WORD6_reserved0_MASK               0xffffffff
#define BCHP_SHARF_MEM_DMA_DESC_WORD6_reserved0_SHIFT              0

/***************************************************************************
 *DESC_WORD7 - SHARF DMA Descriptor Word 7
 ***************************************************************************/
/* SHARF_MEM_DMA :: DESC_WORD7 :: reserved0 [31:00] */
#define BCHP_SHARF_MEM_DMA_DESC_WORD7_reserved0_MASK               0xffffffff
#define BCHP_SHARF_MEM_DMA_DESC_WORD7_reserved0_SHIFT              0

/***************************************************************************
 *XPT_PB
 ***************************************************************************/
/***************************************************************************
 *DESCRIPTOR_ABSTRACT - Playback Linked-List Descriptor Abstract
 ***************************************************************************/
/* XPT_PB :: DESCRIPTOR_ABSTRACT :: DESCRIPTOR_FORMAT [31:00] */
#define BCHP_XPT_PB_DESCRIPTOR_ABSTRACT_DESCRIPTOR_FORMAT_MASK     0xffffffff
#define BCHP_XPT_PB_DESCRIPTOR_ABSTRACT_DESCRIPTOR_FORMAT_SHIFT    0

/***************************************************************************
 *DESC_0 - Playback Linked-List Descriptor Word 0
 ***************************************************************************/
/* XPT_PB :: DESC_0 :: PB_BUFFER_START_ADDR [31:00] */
#define BCHP_XPT_PB_DESC_0_PB_BUFFER_START_ADDR_MASK               0xffffffff
#define BCHP_XPT_PB_DESC_0_PB_BUFFER_START_ADDR_SHIFT              0

/***************************************************************************
 *DESC_1 - Playback Linked-List Descriptor Word 1
 ***************************************************************************/
/* XPT_PB :: DESC_1 :: PB_BUFFER_LENGTH [31:00] */
#define BCHP_XPT_PB_DESC_1_PB_BUFFER_LENGTH_MASK                   0xffffffff
#define BCHP_XPT_PB_DESC_1_PB_BUFFER_LENGTH_SHIFT                  0

/***************************************************************************
 *DESC_2 - Playback Linked-List Descriptor Word 2
 ***************************************************************************/
/* XPT_PB :: DESC_2 :: PB_INTERRUPT_ENABLE [31:31] */
#define BCHP_XPT_PB_DESC_2_PB_INTERRUPT_ENABLE_MASK                0x80000000
#define BCHP_XPT_PB_DESC_2_PB_INTERRUPT_ENABLE_SHIFT               31

/* XPT_PB :: DESC_2 :: PB_FORCE_RESYNC [30:30] */
#define BCHP_XPT_PB_DESC_2_PB_FORCE_RESYNC_MASK                    0x40000000
#define BCHP_XPT_PB_DESC_2_PB_FORCE_RESYNC_SHIFT                   30

/* XPT_PB :: DESC_2 :: reserved0 [29:28] */
#define BCHP_XPT_PB_DESC_2_reserved0_MASK                          0x30000000
#define BCHP_XPT_PB_DESC_2_reserved0_SHIFT                         28

/* XPT_PB :: DESC_2 :: PB_DESC_TAG_ID [27:24] */
#define BCHP_XPT_PB_DESC_2_PB_DESC_TAG_ID_MASK                     0x0f000000
#define BCHP_XPT_PB_DESC_2_PB_DESC_TAG_ID_SHIFT                    24

/* XPT_PB :: DESC_2 :: reserved1 [23:00] */
#define BCHP_XPT_PB_DESC_2_reserved1_MASK                          0x00ffffff
#define BCHP_XPT_PB_DESC_2_reserved1_SHIFT                         0

/***************************************************************************
 *DESC_3 - Playback Linked-List Descriptor Word 3
 ***************************************************************************/
/* XPT_PB :: DESC_3 :: PB_NEXT_DESC_ADDR [31:04] */
#define BCHP_XPT_PB_DESC_3_PB_NEXT_DESC_ADDR_MASK                  0xfffffff0
#define BCHP_XPT_PB_DESC_3_PB_NEXT_DESC_ADDR_SHIFT                 4

/* XPT_PB :: DESC_3 :: reserved0 [03:01] */
#define BCHP_XPT_PB_DESC_3_reserved0_MASK                          0x0000000e
#define BCHP_XPT_PB_DESC_3_reserved0_SHIFT                         1

/* XPT_PB :: DESC_3 :: PB_LAST_DESC_IND [00:00] */
#define BCHP_XPT_PB_DESC_3_PB_LAST_DESC_IND_MASK                   0x00000001
#define BCHP_XPT_PB_DESC_3_PB_LAST_DESC_IND_SHIFT                  0

/***************************************************************************
 *XPT_RAVE
 ***************************************************************************/
/***************************************************************************
 *NOTEA_CONTEXT_SETUP_EXAMPLES - Context Setup Examples
 ***************************************************************************/
/* XPT_RAVE :: NOTEA_CONTEXT_SETUP_EXAMPLES :: CONTEXT_EXAMPLES [31:00] */
#define BCHP_XPT_RAVE_NOTEA_CONTEXT_SETUP_EXAMPLES_CONTEXT_EXAMPLES_MASK 0xffffffff
#define BCHP_XPT_RAVE_NOTEA_CONTEXT_SETUP_EXAMPLES_CONTEXT_EXAMPLES_SHIFT 0

/***************************************************************************
 *NOTEB_STREAM_TYPE_SETUP - Stream Type Setup
 ***************************************************************************/
/* XPT_RAVE :: NOTEB_STREAM_TYPE_SETUP :: STREAM_TYPE_SETUP [31:00] */
#define BCHP_XPT_RAVE_NOTEB_STREAM_TYPE_SETUP_STREAM_TYPE_SETUP_MASK 0xffffffff
#define BCHP_XPT_RAVE_NOTEB_STREAM_TYPE_SETUP_STREAM_TYPE_SETUP_SHIFT 0

/***************************************************************************
 *NOTEC_PES_LAYER_SELECTION - PES Layer Selection
 ***************************************************************************/
/* XPT_RAVE :: NOTEC_PES_LAYER_SELECTION :: PES_LAYER_SELECTION [31:00] */
#define BCHP_XPT_RAVE_NOTEC_PES_LAYER_SELECTION_PES_LAYER_SELECTION_MASK 0xffffffff
#define BCHP_XPT_RAVE_NOTEC_PES_LAYER_SELECTION_PES_LAYER_SELECTION_SHIFT 0

/***************************************************************************
 *NOTED_ES_FORMAT_SELECTION_GENERAL - ES Format Selection - general
 ***************************************************************************/
/* XPT_RAVE :: NOTED_ES_FORMAT_SELECTION_GENERAL :: GENERAL_ES_FORMAT_SELECTION [31:00] */
#define BCHP_XPT_RAVE_NOTED_ES_FORMAT_SELECTION_GENERAL_GENERAL_ES_FORMAT_SELECTION_MASK 0xffffffff
#define BCHP_XPT_RAVE_NOTED_ES_FORMAT_SELECTION_GENERAL_GENERAL_ES_FORMAT_SELECTION_SHIFT 0

/***************************************************************************
 *NOTEE_MPEG2_VIDEO_ES_SETUP - ES Setup - MPEG2 Video
 ***************************************************************************/
/* XPT_RAVE :: NOTEE_MPEG2_VIDEO_ES_SETUP :: MPEG2_VIDEO_ES_FORMAT [31:00] */
#define BCHP_XPT_RAVE_NOTEE_MPEG2_VIDEO_ES_SETUP_MPEG2_VIDEO_ES_FORMAT_MASK 0xffffffff
#define BCHP_XPT_RAVE_NOTEE_MPEG2_VIDEO_ES_SETUP_MPEG2_VIDEO_ES_FORMAT_SHIFT 0

/***************************************************************************
 *NOTEF_AVC_VC1_VIDEO_ES_SETUP - ES Setup - AVC and VC1 Video
 ***************************************************************************/
/* XPT_RAVE :: NOTEF_AVC_VC1_VIDEO_ES_SETUP :: AVC_VC1_VIDEO_ES_FORMAT [31:00] */
#define BCHP_XPT_RAVE_NOTEF_AVC_VC1_VIDEO_ES_SETUP_AVC_VC1_VIDEO_ES_FORMAT_MASK 0xffffffff
#define BCHP_XPT_RAVE_NOTEF_AVC_VC1_VIDEO_ES_SETUP_AVC_VC1_VIDEO_ES_FORMAT_SHIFT 0

/***************************************************************************
 *NOTEG_MPEG_AUDIO_ES_SETUP - ES Setup - MPEG Audio
 ***************************************************************************/
/* XPT_RAVE :: NOTEG_MPEG_AUDIO_ES_SETUP :: AUDIO_MPEG_ES_FORMAT [31:00] */
#define BCHP_XPT_RAVE_NOTEG_MPEG_AUDIO_ES_SETUP_AUDIO_MPEG_ES_FORMAT_MASK 0xffffffff
#define BCHP_XPT_RAVE_NOTEG_MPEG_AUDIO_ES_SETUP_AUDIO_MPEG_ES_FORMAT_SHIFT 0

/***************************************************************************
 *NOTEH_AAC_AUDIO_ES_SETUP - ES Setup - AAC Audio
 ***************************************************************************/
/* XPT_RAVE :: NOTEH_AAC_AUDIO_ES_SETUP :: AUDIO_AAC_ES_FORMAT [31:00] */
#define BCHP_XPT_RAVE_NOTEH_AAC_AUDIO_ES_SETUP_AUDIO_AAC_ES_FORMAT_MASK 0xffffffff
#define BCHP_XPT_RAVE_NOTEH_AAC_AUDIO_ES_SETUP_AUDIO_AAC_ES_FORMAT_SHIFT 0

/***************************************************************************
 *NOTEH_AC3_AUDIO_ES_SETUP - ES Setup - AC3 Audio
 ***************************************************************************/
/* XPT_RAVE :: NOTEH_AC3_AUDIO_ES_SETUP :: AUDIO_AC3_ES_FORMAT [31:00] */
#define BCHP_XPT_RAVE_NOTEH_AC3_AUDIO_ES_SETUP_AUDIO_AC3_ES_FORMAT_MASK 0xffffffff
#define BCHP_XPT_RAVE_NOTEH_AC3_AUDIO_ES_SETUP_AUDIO_AC3_ES_FORMAT_SHIFT 0

/***************************************************************************
 *NOTEH_DVD_AC3_AUDIO_ES_SETUP - ES Setup - DVD_AC3 Audio
 ***************************************************************************/
/* XPT_RAVE :: NOTEH_DVD_AC3_AUDIO_ES_SETUP :: DVD_AUDIO_AC3_ES_FORMAT [31:00] */
#define BCHP_XPT_RAVE_NOTEH_DVD_AC3_AUDIO_ES_SETUP_DVD_AUDIO_AC3_ES_FORMAT_MASK 0xffffffff
#define BCHP_XPT_RAVE_NOTEH_DVD_AC3_AUDIO_ES_SETUP_DVD_AUDIO_AC3_ES_FORMAT_SHIFT 0

/***************************************************************************
 *NOTEI_DVD_LPCM_AUDIO_ES_SETUP - ES Setup - DVD_LPCM Audio
 ***************************************************************************/
/* XPT_RAVE :: NOTEI_DVD_LPCM_AUDIO_ES_SETUP :: DVD_AUDIO_LPCM_ES_FORMAT [31:00] */
#define BCHP_XPT_RAVE_NOTEI_DVD_LPCM_AUDIO_ES_SETUP_DVD_AUDIO_LPCM_ES_FORMAT_MASK 0xffffffff
#define BCHP_XPT_RAVE_NOTEI_DVD_LPCM_AUDIO_ES_SETUP_DVD_AUDIO_LPCM_ES_FORMAT_SHIFT 0

/***************************************************************************
 *NOTEJ_ENHANCED_AC3_AUDIO_ES_SETUP - ES Setup - AC3 Audio
 ***************************************************************************/
/* XPT_RAVE :: NOTEJ_ENHANCED_AC3_AUDIO_ES_SETUP :: AUDIO_ENHANCED_AC3_ES_FORMAT [31:00] */
#define BCHP_XPT_RAVE_NOTEJ_ENHANCED_AC3_AUDIO_ES_SETUP_AUDIO_ENHANCED_AC3_ES_FORMAT_MASK 0xffffffff
#define BCHP_XPT_RAVE_NOTEJ_ENHANCED_AC3_AUDIO_ES_SETUP_AUDIO_ENHANCED_AC3_ES_FORMAT_SHIFT 0

/***************************************************************************
 *NOTEK_AAC_HE_AUDIO_ES_SETUP - ES Setup - AAC HE Audio
 ***************************************************************************/
/* XPT_RAVE :: NOTEK_AAC_HE_AUDIO_ES_SETUP :: AUDIO_AAC_HE_ES_FORMAT [31:00] */
#define BCHP_XPT_RAVE_NOTEK_AAC_HE_AUDIO_ES_SETUP_AUDIO_AAC_HE_ES_FORMAT_MASK 0xffffffff
#define BCHP_XPT_RAVE_NOTEK_AAC_HE_AUDIO_ES_SETUP_AUDIO_AAC_HE_ES_FORMAT_SHIFT 0

#endif /* #ifndef BCHP_COMMON_H__ */

/* End of File */
