// Cyphesis Online RPG Server and AI Engine
// Copyright (C) 2009 Alistair Riddoch
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software Foundation,
// Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

// $Id: b175c492b634db2a24e6eb26ceabd6758f6bd318 $

#ifndef TESTS_PROPERTY_COVERAGE_H
#define TESTS_PROPERTY_COVERAGE_H

#include <Atlas/Message/Element.h>

class PropertyBase;
class Entity;
class BaseWorld;
class Character;

class PropertyCoverage {
  protected:
    PropertyBase * const m_prop;
    Entity * const m_tlve;
    BaseWorld * const m_wrld;
    Entity * m_ent;

    Atlas::Message::ListType m_testData;
  public:

    explicit PropertyCoverage(PropertyBase * pb);

    ~PropertyCoverage();

    void basicCoverage();

    Character * createCharacterEntity();

    void testDataAppend(const Atlas::Message::Element &);

    Entity * tlve() { return m_tlve; }
};

#endif // TESTS_PROPERTY_COVERAGE_H
