// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

//---------------------------------------------------------------------
// <autogenerated>
//
//  Generated by message compiler for wpf (mcwpf.exe)
//
// 
//
//  To update this file run "EventTraceCodeGen.cmd /managed"
//
// </autogenerated>
//---------------------------------------------------------------------
#if !SILVERLIGHTXAML

using System;
using MS.Internal.WindowsBase;

#if SYSTEM_XAML
using System.Xaml;

namespace MS.Internal.Xaml
#else
namespace MS.Utility
#endif
{
    static internal partial class EventTrace
    {

        internal enum Level : byte
        {
            LogAlways = 0,
            Critical = 1,
            Error = 2,
            Warning = 3,
            Info = 4,
            Verbose = 5,
            PERF = 16,
            PERF_LOW = 17,
            PERF_MED = 18,
            PERF_HIGH = 19,
        }
        
        [Flags]
        internal enum Keyword
        {
            KeywordGeneral = 0x1,
            KeywordPerf = 0x2,
            KeywordText = 0x4,
            KeywordInput = 0x8,
            KeywordAnnotation = 0x10,
            KeywordXamlBaml = 0x20,
            KeywordXPS = 0x40,
            KeywordAnimation = 0x80,
            KeywordLayout = 0x100,
            KeywordHosting = 0x400,
            KeywordHeapMeter = 0x800,
            KeywordGraphics = 0x1000,
            KeywordDispatcher = 0x2000,
        }
        
        internal enum Event : ushort
        {
            WClientParseBamlBegin = 4001,
            WClientParseBamlEnd = 4002,
            WClientParseXmlBegin = 4003,
            WClientParseXmlEnd = 4004,
            WClientParseFefCrInstBegin = 4005,
            WClientParseFefCrInstEnd = 4006,
            WClientParseInstVisTreeBegin = 4007,
            WClientParseInstVisTreeEnd = 4008,
            WClientParseRdrCrInstBegin = 4009,
            WClientParseRdrCrInstEnd = 4010,
            WClientParseRdrCrInFTypBegin = 4011,
            WClientParseRdrCrInFTypEnd = 4012,
            WClientResourceFindBegin = 4013,
            WClientResourceFindEnd = 4014,
            WClientResourceCacheValue = 4015,
            WClientResourceCacheNull = 4016,
            WClientResourceCacheMiss = 4017,
            WClientResourceStock = 4018,
            WClientResourceBamlAssembly = 4019,
            WClientParseXamlBegin = 4020,
            WClientParseXamlBamlInfo = 4021,
            WClientParseXamlEnd = 4022,
        }
        
        internal static Guid GetGuidForEvent(Event arg)
        {
            switch(arg)
            {
                case Event.WClientParseBamlBegin:
                case Event.WClientParseBamlEnd:
                    // 8a1e3af5-3a6d-4582-86d1-5901471ebbde
                    return new Guid(0x8A1E3AF5, 0x3A6D, 0x4582, 0x86, 0xD1, 0x59, 0x1, 0x47, 0x1E, 0xBB, 0xDE);
                case Event.WClientParseXmlBegin:
                case Event.WClientParseXmlEnd:
                    // bf86e5bf-3fb4-442f-a34a-b207a3b19c3b
                    return new Guid(0xBF86E5BF, 0x3FB4, 0x442F, 0xA3, 0x4A, 0xB2, 0x7, 0xA3, 0xB1, 0x9C, 0x3B);
                case Event.WClientParseFefCrInstBegin:
                case Event.WClientParseFefCrInstEnd:
                    // f7555161-6c1a-4a12-828d-8492a7699a49
                    return new Guid(0xF7555161, 0x6C1A, 0x4A12, 0x82, 0x8D, 0x84, 0x92, 0xA7, 0x69, 0x9A, 0x49);
                case Event.WClientParseInstVisTreeBegin:
                case Event.WClientParseInstVisTreeEnd:
                    // a8c3b9c0-562b-4509-becb-a08e481a7273
                    return new Guid(0xA8C3B9C0, 0x562B, 0x4509, 0xBE, 0xCB, 0xA0, 0x8E, 0x48, 0x1A, 0x72, 0x73);
                case Event.WClientParseRdrCrInstBegin:
                case Event.WClientParseRdrCrInstEnd:
                    // 8ba8f51c-0775-4adf-9eed-b1654ca088f5
                    return new Guid(0x8BA8F51C, 0x775, 0x4ADF, 0x9E, 0xED, 0xB1, 0x65, 0x4C, 0xA0, 0x88, 0xF5);
                case Event.WClientParseRdrCrInFTypBegin:
                case Event.WClientParseRdrCrInFTypEnd:
                    // 0da15d58-c3a7-40de-9113-72db0c4a9351
                    return new Guid(0xDA15D58, 0xC3A7, 0x40DE, 0x91, 0x13, 0x72, 0xDB, 0xC, 0x4A, 0x93, 0x51);
                case Event.WClientResourceFindBegin:
                case Event.WClientResourceFindEnd:
                    // 228d90d5-7e19-4480-9e56-3af2e90f8da6
                    return new Guid(0x228D90D5, 0x7E19, 0x4480, 0x9E, 0x56, 0x3A, 0xF2, 0xE9, 0xF, 0x8D, 0xA6);
                case Event.WClientResourceCacheValue:
                    // 3b253e2d-72a5-489e-8c65-56c1e6c859b5
                    return new Guid(0x3B253E2D, 0x72A5, 0x489E, 0x8C, 0x65, 0x56, 0xC1, 0xE6, 0xC8, 0x59, 0xB5);
                case Event.WClientResourceCacheNull:
                    // 7866a65b-2f38-43b6-abd2-df433bbca073
                    return new Guid(0x7866A65B, 0x2F38, 0x43B6, 0xAB, 0xD2, 0xDF, 0x43, 0x3B, 0xBC, 0xA0, 0x73);
                case Event.WClientResourceCacheMiss:
                    // 0420755f-d416-4f15-939f-3e2cd3fcea23
                    return new Guid(0x420755F, 0xD416, 0x4F15, 0x93, 0x9F, 0x3E, 0x2C, 0xD3, 0xFC, 0xEA, 0x23);
                case Event.WClientResourceStock:
                    // 06f0fee4-72dd-4802-bd3d-0985139fa91a
                    return new Guid(0x6F0FEE4, 0x72DD, 0x4802, 0xBD, 0x3D, 0x9, 0x85, 0x13, 0x9F, 0xA9, 0x1A);
                case Event.WClientResourceBamlAssembly:
                    // 19df4373-6680-4a04-8c77-d2f6809ca703
                    return new Guid(0x19DF4373, 0x6680, 0x4A04, 0x8C, 0x77, 0xD2, 0xF6, 0x80, 0x9C, 0xA7, 0x3);
                case Event.WClientParseXamlBegin:
                    // 3164257a-c9be-4c36-9d8f-09b18ac880a6
                    return new Guid(0x3164257A, 0xC9BE, 0x4C36, 0x9D, 0x8F, 0x9, 0xB1, 0x8A, 0xC8, 0x80, 0xA6);
                case Event.WClientParseXamlBamlInfo:
                    // 00c117d0-8234-4efa-ace3-73ba1c655f28
                    return new Guid(0xC117D0, 0x8234, 0x4EFA, 0xAC, 0xE3, 0x73, 0xBA, 0x1C, 0x65, 0x5F, 0x28);
                case Event.WClientParseXamlEnd:
                    // 3164257a-c9be-4c36-9d8f-09b18ac880a6
                    return new Guid(0x3164257A, 0xC9BE, 0x4C36, 0x9D, 0x8F, 0x9, 0xB1, 0x8A, 0xC8, 0x80, 0xA6);
                default: throw new ArgumentException(SR.InvalidEvent,"arg");
            }
        }
        
        internal static ushort GetTaskForEvent(Event arg)
        {
            switch(arg)
            {
                case Event.WClientParseBamlBegin:
                case Event.WClientParseBamlEnd:
                    return 41;
                case Event.WClientParseXmlBegin:
                case Event.WClientParseXmlEnd:
                    return 43;
                case Event.WClientParseFefCrInstBegin:
                case Event.WClientParseFefCrInstEnd:
                    return 44;
                case Event.WClientParseInstVisTreeBegin:
                case Event.WClientParseInstVisTreeEnd:
                    return 45;
                case Event.WClientParseRdrCrInstBegin:
                case Event.WClientParseRdrCrInstEnd:
                    return 46;
                case Event.WClientParseRdrCrInFTypBegin:
                case Event.WClientParseRdrCrInFTypEnd:
                    return 47;
                case Event.WClientResourceFindBegin:
                case Event.WClientResourceFindEnd:
                    return 86;
                case Event.WClientResourceCacheValue:
                    return 87;
                case Event.WClientResourceCacheNull:
                    return 88;
                case Event.WClientResourceCacheMiss:
                    return 89;
                case Event.WClientResourceStock:
                    return 90;
                case Event.WClientResourceBamlAssembly:
                    return 91;
                case Event.WClientParseXamlBegin:
                    return 42;
                case Event.WClientParseXamlBamlInfo:
                    return 144;
                case Event.WClientParseXamlEnd:
                    return 42;
                default: throw new ArgumentException(SR.InvalidEvent,"arg");
            }
        }
        
        internal static byte GetOpcodeForEvent(Event arg)
        {
            switch(arg)
            {
                case Event.WClientResourceCacheValue:
                case Event.WClientResourceCacheNull:
                case Event.WClientResourceCacheMiss:
                case Event.WClientResourceStock:
                case Event.WClientResourceBamlAssembly:
                case Event.WClientParseXamlBamlInfo:
                    return 0;
                case Event.WClientParseBamlBegin:
                case Event.WClientParseXmlBegin:
                case Event.WClientParseFefCrInstBegin:
                case Event.WClientParseInstVisTreeBegin:
                case Event.WClientParseRdrCrInstBegin:
                case Event.WClientParseRdrCrInFTypBegin:
                case Event.WClientResourceFindBegin:
                case Event.WClientParseXamlBegin:
                    return 1;
                case Event.WClientParseBamlEnd:
                case Event.WClientParseXmlEnd:
                case Event.WClientParseFefCrInstEnd:
                case Event.WClientParseInstVisTreeEnd:
                case Event.WClientParseRdrCrInstEnd:
                case Event.WClientParseRdrCrInFTypEnd:
                case Event.WClientResourceFindEnd:
                case Event.WClientParseXamlEnd:
                    return 2;
                default: throw new ArgumentException(SR.InvalidEvent,"arg");
            }
        }
        
        internal static byte GetVersionForEvent(Event arg)
        {
            switch(arg)
            {
                case Event.WClientParseXamlBegin:
                case Event.WClientParseXamlBamlInfo:
                case Event.WClientParseXamlEnd:
                    return 0;
                case Event.WClientParseBamlBegin:
                case Event.WClientParseBamlEnd:
                case Event.WClientParseXmlBegin:
                case Event.WClientParseXmlEnd:
                case Event.WClientParseFefCrInstBegin:
                case Event.WClientParseFefCrInstEnd:
                case Event.WClientParseInstVisTreeBegin:
                case Event.WClientParseInstVisTreeEnd:
                case Event.WClientParseRdrCrInstBegin:
                case Event.WClientParseRdrCrInstEnd:
                case Event.WClientParseRdrCrInFTypBegin:
                case Event.WClientParseRdrCrInFTypEnd:
                case Event.WClientResourceFindBegin:
                case Event.WClientResourceFindEnd:
                case Event.WClientResourceCacheValue:
                case Event.WClientResourceCacheNull:
                case Event.WClientResourceCacheMiss:
                case Event.WClientResourceStock:
                case Event.WClientResourceBamlAssembly:
                    return 2;
                default: throw new ArgumentException(SR.InvalidEvent,"arg");
            }
        }
    }
}

#endif
