/******************************************
 *
 * $GAMGI/src/phys/gamgi_phys_symmetry.c
 *
 * Copyright (C) 2004 Carlos Pereira
 *
 * Distributed under the terms of the GNU
 * General Public License: $GAMGI/LICENSE
 *
 */

#include "gamgi_engine.h"
#include "gamgi_phys.h"

char *gamgi_phys_symmetry_systems[GAMGI_PHYS_CELL_SYSTEMS * 4] = {
"a", "Triclinic / Anorthic",                "P",          "1 - 2",
"m", "Monoclinic",                          "P, C",       "3 - 15",
"o", "Orthorhombic",                        "P, C, I, F", "16 - 74",
"t", "Tetragonal",                          "P, I",       "75 - 142",
"h", "Hexagonal / Trigonal / Rhombohedral", "P, R",       "143 - 194",
"c", "Cubic",                               "P, I, F",    "195 - 230"
};

char *gamgi_phys_symmetry_lattices[GAMGI_PHYS_CELL_LATTICES * 4] = {
"P", "Primitive",       "a, m, o, t, h, c", "149",
"I", "Body Centered",   "o, t, c",          "38",
"F", "Face Centered",   "o, c",             "16",
"C", "C-Base Centered", "m, o",             "20",
"R", "Rhombohedral",    "h",                 "7"
};

char *gamgi_phys_symmetry_groups[GAMGI_PHYS_CELL_GROUPS * 4] = {

/******************
 * 1-2: Triclinic *
 ******************/

"P1",         "C1 / 1",   "a", "P",
"P-1",        "Ci / 1",   "a", "P",

/********************
 * 3-10: Monoclinic *
 ********************/

"P2",         "C2 / 1",   "m", "P",
"P2_1",       "C2 / 2",   "m", "P",
"C2",         "C2 / 3",   "m", "C",
"Pm",         "Cs / 1",   "m", "P",
"Pc",         "Cs / 2",   "m", "P",
"Cm",         "Cs / 3",   "m", "C",
"Cc",         "Cs / 4",   "m", "C",
"P2/m",       "C2h / 1",  "m", "P",

/*********************
 * 10-15: Monoclinic *
 *********************/

"P2_1/m",     "C2h / 2",  "m", "P",
"C2/m",       "C2h / 3",  "m", "C",
"P2/c",       "C2h / 4",  "m", "P",
"P2_1/c",     "C2h / 5",  "m", "P",
"C2/c",       "C2h / 6",  "m", "C",

/***********************
 * 16-20: Orthorhombic *
 ***********************/

"P222",       "D2 / 1",   "o", "P",
"P222_1",     "D2 / 2",   "o", "P",
"P2_12_12",   "D2 / 3",   "o", "P",
"P2_12_12_1", "D2 / 4",   "o", "P",
"C222_1",     "D2 / 5",   "o", "C",

/***********************
 * 21-30: Orthorhombic *
 ***********************/

"C222",       "D2 / 6",   "o", "C",
"F222",       "D2 / 7",   "o", "F",
"I222",       "D2 / 8",   "o", "I",
"I2_12_12_1", "D2 / 9",   "o", "I",
"Pmm2",       "C2v / 1",  "o", "P",
"Pmc2_1",     "C2v / 2",  "o", "P",
"Pcc2",       "C2v / 3",  "o", "P",
"Pma2",       "C2v / 4",  "o", "P",
"Pca2_1",     "C2v / 5",  "o", "P",
"Pnc2",       "C2v / 6",  "o", "P",

/***********************
 * 31-40: Orthorhombic *
 ***********************/

"Pmn2_1",     "C2v / 7",  "o", "P",
"Pba2",       "C2v / 8",  "o", "P",
"Pna2_1",     "C2v / 9",  "o", "P",
"Pnn2",       "C2v / 10", "o", "P",
"Cmm2",       "C2v / 11", "o", "C",
"Cmc2_1",     "C2v / 12", "o", "C",
"Ccc2",       "C2v / 13", "o", "C",
"Cm2m",       "C2v / 14", "o", "C",
"Cm2e",       "C2v / 15", "o", "C",
"Cc2m",       "C2v / 16", "o", "C",

/***********************
 * 41-50: Orthorhombic *
 ***********************/

"Cc2e",       "C2v / 17", "o", "C",
"Fmm2",       "C2v / 18", "o", "F",
"Fdd2",       "C2v / 19", "o", "F",
"Imm2",       "C2v / 20", "o", "I",
"Iba2",       "C2v / 21", "o", "I",
"Ima2",       "C2v / 22", "o", "I",
"Pmmm",       "D2h / 1",  "o", "P",
"Pnnn",       "D2h / 2",  "o", "P",
"Pccm",       "D2h / 3",  "o", "P",
"Pban",       "D2h / 4",  "o", "P",

/***********************
 * 51-60: Orthorhombic *
 ***********************/

"Pmma",       "D2h / 5",  "o", "P",
"Pnna",       "D2h / 6",  "o", "P",
"Pmna",       "D2h / 7",  "o", "P",
"Pcca",       "D2h / 8",  "o", "P",
"Pbam",       "D2h / 9",  "o", "P",
"Pccn",       "D2h / 10", "o", "P",
"Pbcm",       "D2h / 11", "o", "P",
"Pnnm",       "D2h / 12", "o", "P",
"Pmmn",       "D2h / 13", "o", "P",
"Pbcn",       "D2h / 14", "o", "P",

/***********************
 * 61-70: Orthorhombic *
 ***********************/

"Pbca",       "D2h / 15", "o", "P",
"Pnma",       "D2h / 16", "o", "P",
"Cmcm",       "D2h / 17", "o", "C",
"Cmce",       "D2h / 18", "o", "C",
"Cmmm",       "D2h / 19", "o", "C",
"Cccm",       "D2h / 20", "o", "C",
"Cmme",       "D2h / 21", "o", "C",
"Ccce",       "D2h / 22", "o", "C",
"Fmmm",       "D2h / 23", "o", "F",
"Fddd",       "D2h / 24", "o", "F",
 
/***********************
 * 71-74: Orthorhombic *
 ***********************/

"Immm",       "D2h / 25", "o", "I",
"Ibam",       "D2h / 26", "o", "I",
"Ibca",       "D2h / 27", "o", "I",
"Imma",       "D2h / 28", "o", "I",

/*********************
 * 75-80: Tetragonal *
 *********************/

"P4",         "C4 / 1",   "t", "P",
"P4_1",       "C4 / 2",   "t", "P",
"P4_2",       "C4 / 3",   "t", "P",
"P4_3",       "C4 / 4",   "t", "P",
"I4",         "C4 / 5",   "t", "I",
"I4_1",       "C4 / 6",   "t", "I",

/*********************
 * 81-90: Tetragonal *
 *********************/

"P-4",        "S4 / 1",   "t", "P",
"I-4",        "S4 / 2",   "t", "I",
"P4/m",       "C4h / 1",  "t", "P",
"P4_2/m",     "C4h / 2",  "t", "P",
"P4/n",       "C4h / 3",  "t", "P",
"P4_2/n",     "C4h / 4",  "t", "P",
"I4/m",       "C4h / 5",  "t", "I",
"I4_1/a",     "C4h / 6",  "t", "I",
"P422",       "D4 / 1",   "t", "P",
"P42_12",     "D4 / 2",   "t", "P",

/**********************
 * 91-100: Tetragonal *
 **********************/

"P4_122",     "D4 / 3",   "t", "P",
"P4_12_12",   "D4 / 4",   "t", "P",
"P4_222",     "D4 / 5",   "t", "P",
"P4_22_12",   "D4 / 6",   "t", "P",
"P4_322",     "D4 / 7",   "t", "P",
"P4_32_12",   "D4 / 8",   "t", "P",
"I422",       "D4 / 9",   "t", "I",
"I4_122",     "D4 / 10",  "t", "I",
"P4mm",       "C4v / 1",  "t", "P",
"P4bm",       "C4v / 2",  "t", "P",

/***********************
 * 101-110: Tetragonal *
 ***********************/

"P4_2cm",     "C4v / 3",  "t", "P",
"P4_2nm",     "C4v / 4",  "t", "P",
"P4cc",       "C4v / 5",  "t", "P",
"P4nc",       "C4v / 6",  "t", "P",
"P4_2mc",     "C4v / 7",  "t", "P",
"P4_2bc",     "C4v / 8",  "t", "P",
"I4mm",       "C4v / 9",  "t", "I",
"I4cm",       "C4v / 10", "t", "I",
"I4_1md",     "C4v / 11", "t", "I",
"I4_1cd",     "C4v / 12", "t", "I",

/***********************
 * 111-120: Tetragonal *
 ***********************/

"P-42m",      "D2d / 1",  "t", "P",
"P-42c",      "D2d / 2",  "t", "P",
"P-42_1m",    "D2d / 3",  "t", "P",
"P-42_1c",    "D2d / 4",  "t", "P",
"P-4m2",      "D2d / 5",  "t", "P",
"P-4c2",      "D2d / 6",  "t", "P",
"P-4b2",      "D2d / 7",  "t", "P",
"P-4n2",      "D2d / 8",  "t", "P",
"I-4m2",      "D2d / 9",  "t", "I",
"I-4c2",      "D2d / 10", "t", "I",

/***********************
 * 121-130: Tetragonal *
 ***********************/

"I-42m",      "D2d / 11", "t", "I",
"I-42d",      "D2d / 12", "t", "I",
"P4/mmm",     "D4h / 1",  "t", "P",
"P4/mcc",     "D4h / 2",  "t", "P",
"P4/nbm",     "D4h / 3",  "t", "P",
"P4/nnc",     "D4h / 4",  "t", "P",
"P4/mbm",     "D4h / 5",  "t", "P",
"P4/mnc",     "D4h / 6",  "t", "P",
"P4/nmm",     "D4h / 7",  "t", "P",
"P4/ncc",     "D4h / 8",  "t", "P",

/***********************
 * 131-140: Tetragonal *
 ***********************/

"P4_2/mmc",   "D4h / 9",  "t", "P",
"P4_2/mcm",   "D4h / 10", "t", "P",
"P4_2/nbc",   "D4h / 11", "t", "P",
"P4_2/nnm",   "D4h / 12", "t", "P",
"P4_2/mbc",   "D4h / 13", "t", "P",
"P4_2/mnm",   "D4h / 14", "t", "P",
"P4_2/nmc",   "D4h / 15", "t", "P",
"P4_2/ncm",   "D4h / 16", "t", "P",
"I4/mmm",     "D4h / 17", "t", "I",
"I4/mcm",     "D4h / 18", "t", "I",

/***********************
 * 141-142: Tetragonal *
 ***********************/

"I4_1/amd",   "D4h / 19", "t", "I",
"I4_1/acd",   "D4h / 20", "t", "I",

/*********************
 * 143-150: Trigonal *
 *********************/

"P3",         "C3 / 1",   "h", "P",
"P3_1",       "C3 / 2",   "h", "P",
"P3_2",       "C3 / 3",   "h", "P",
"R3",         "C3 / 4",   "h", "R",
"P-3",        "C3i / 1",  "h", "P",
"R-3",        "C3i / 2",  "h", "R",
"P312",       "D3 / 1",   "h", "P",
"P321",       "D3 / 2",   "h", "P",

/*********************
 * 151-160: Trigonal *
 *********************/

"P3_112",     "D3 / 3",   "h", "P",
"P3_121",     "D3 / 4",   "h", "P",
"P3_212",     "D3 / 5",   "h", "P",
"P3_221",     "D3 / 6",   "h", "P",
"R32",        "D3 / 7",   "h", "R",
"P3m1",       "C3v / 1",  "h", "P",
"P31m",       "C3v / 2",  "h", "P",
"P3c1",       "C3v / 3",  "h", "P",
"P31c",       "C3v / 4",  "h", "P",
"R3m",        "C3v / 5",  "h", "R",

/*********************
 * 161-167: Trigonal *
 *********************/

"R3c",        "C3v / 6",  "h", "R",
"P-31m",      "D3d / 1",  "h", "P",
"P-31c",      "D3d / 2",  "h", "P",
"P-3m1",      "D3d / 3",  "h", "P",
"P-3c1",      "D3d / 4",  "h", "P",
"R-3m",       "D3d / 5",  "h", "R",
"R-3c",       "D3d / 6",  "h", "R",

/**********************
 * 168-170: Hexagonal *
 **********************/

"P6",         "C6 / 1",   "h", "P",
"P6(1)",      "C6 / 2",   "h", "P",
"P6(5)",      "C6 / 3",   "h", "P",

/**********************
 * 171-180: Hexagonal *
 **********************/

"P6_2",       "C6 / 4",   "h", "P",
"P6_4",       "C6 / 5",   "h", "P",
"P6_3",       "C6 / 6",   "h", "P",
"P-6",        "C3h / 1",  "h", "P",
"P6/m",       "C6h / 1",  "h", "P",
"P6_3/m",     "C6h / 2",  "h", "P",
"P622",       "D6 / 1",   "h", "P",
"P6_122",     "D6 / 2",   "h", "P",
"P6_522",     "D6 / 3",   "h", "P",
"P6_222",     "D6 / 4",   "h", "P",

/**********************
 * 181-190: Hexagonal *
 **********************/

"P6_422",     "D6 / 5",   "h", "P",
"P6_322",     "D6 / 6",   "h", "P",
"P6mm",       "C6v / 1",  "h", "P",
"P6cc",       "C6v / 2",  "h", "P",
"P6_3cm",     "C6v / 3",  "h", "P",
"P6_3mc",     "C6v / 4",  "h", "P",
"P-6m2",      "D3h / 1",  "h", "P",
"P-6c2",      "D3h / 2",  "h", "P",
"P-62m",      "D3h / 3",  "h", "P",
"P-62c",      "D3h / 4",  "h", "P",

/**********************
 * 191-194: Hexagonal *
 **********************/

"P6/mmm",     "D6h / 1",  "h", "P",
"P6/mcc",     "D6h / 2",  "h", "P",
"P6_3/mcm",   "D6h / 3",  "h", "P",
"P6_3/mmc",   "D6h / 4",  "h", "P",

/******************
 * 195-200: Cubic *
 ******************/

"P23",        "T / 1",    "c", "P",
"F23",        "T / 2",    "c", "F",
"I23",        "T / 3",    "c", "I",
"P2_13",      "T / 4",    "c", "P",
"I2_13",      "T / 5",    "c", "I",
"Pm-3",       "Th / 1",   "c", "P",

/******************
 * 201-210: Cubic *
 ******************/

"Pn-3",       "Th / 2",   "c", "P",
"Fm-3",       "Th / 3",   "c", "F",
"Fd-3",       "Th / 4",   "c", "F",
"Im-3",       "Th / 5",   "c", "I",
"Pa-3",       "Th / 6",   "c", "P",
"Ia-3",       "Th / 7",   "c", "I",
"P432",       "O / 1",    "c", "P",
"P4_232",     "O / 2",    "c", "P",
"F432",       "O / 3",    "c", "F",
"F4_132",     "O / 4",    "c", "F",

/******************
 * 211-220: Cubic *
 ******************/

"I432",       "O / 5",    "c", "I",
"P4_332",     "O / 6",    "c", "P",
"P4_132",     "O / 7",    "c", "P",
"I4_132",     "O / 8",    "c", "I",
"P-43m",      "Td / 1",   "c", "P",
"F-43m",      "Td / 2",   "c", "F",
"I-43m",      "Td / 3",   "c", "I",
"P-43n",      "Td / 4",   "c", "P",
"F-43c",      "Td / 5",   "c", "F",
"I-43d",      "Td / 6",   "c", "I",

/******************
 * 221-230: Cubic *
 ******************/

"Pm-3m",      "Oh / 1",   "c", "P",
"Pn-3n",      "Oh / 2",   "c", "P",
"Pm-3n",      "Oh / 3",   "c", "P",
"Pn-3m",      "Oh / 4",   "c", "P",
"Fm-3m",      "Oh / 5",   "c", "F",
"Fm-3c",      "Oh / 6",   "c", "F",
"Fd-3m",      "Oh / 7",   "c", "F",
"Fd-3c",      "Oh / 8",   "c", "F",
"Im-3m",      "Oh / 9",   "c", "I",
"Ia-3d",      "Oh / 10",  "c", "I"
};

/***********************************************************
 * Wyckoff coordinates were obtained in electronic         *
 * format using Altwyk, a CGI program available at:        *
 *          http://ylp.icpet.nrc.ca/altwyk/                *
 *                                                         *
 * Coordinates were then checked against the International *
 * Tables for Crystallography - Volume A - Space Group     *
 * Symmetry, Ed. Hahn Th., Kluwer (2002).                  *
 *                                                         *
 * Perl scrips were used to convert positions to C array   *
 * formats and to automatically build the driver arrays.   *
 ***********************************************************/

/***********************************************************
 * Space groups 48, 50, 59, 68, 70 (orthorhombic), 85,     *
 * 86, 88, 125, 126, 129, 130, 133, 134, 137, 138, 141,    *
 * 142 (tetragonal), 201, 203, 222, 224, 227, 228 (cubic): *
 * There are two standard origins, denoted O1 or O2,       *
 * the chosen origin is O2, at the inversion centre.       *
 *                                                         *
 * Unique axis b was used for all monoclinic space groups. *
 * Space groups 5, 7, 8, 9, 12, 13, 14, 15 (monoclinic):   *
 * Positions were constructed using Cell Choice 1.         *
 *                                                         *
 * Space groups 38, 39, 40, 41 (orthorhombic): groups      *
 * Amm2, Aem2, Ama2 and Aea2 changed to Cm2m, Cm2e, Cc2m   *
 * and Cc2e, using the axes permutation abc->bca, as shown *
 * in the International Tables for Crystallography, so     *
 * all base-centered lattices are described as C lattices. *
 ***********************************************************/

/*********************
 * Wyckoff positions *
 *********************/

const char *gamgi_phys_symmetry_wyckoff_1 [1] = {
"x,y,z", 
};

const char *gamgi_phys_symmetry_wyckoff_2 [10] = {
"x,y,z", "-x,-y,-z", 

"1/2,1/2,1/2", 

"0,1/2,1/2", 

"1/2,0,1/2", 

"1/2,1/2,0", 

"1/2,0,0", 

"0,1/2,0", 

"0,0,1/2", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_3 [6] = {
"x,y,z", "-x,y,-z", 

"1/2,y,1/2", 

"1/2,y,0", 

"0,y,1/2", 

"0,y,0", 
};

const char *gamgi_phys_symmetry_wyckoff_4 [2] = {
"x,y,z", "-x,y+1/2,-z", 
};

const char *gamgi_phys_symmetry_wyckoff_5 [4] = {
"x,y,z", "-x,y,-z", 

"0,y,1/2", 

"0,y,0", 
};

const char *gamgi_phys_symmetry_wyckoff_6 [4] = {
"x,y,z", "x,-y,z", 

"x,1/2,z", 

"x,0,z", 
};

const char *gamgi_phys_symmetry_wyckoff_7 [2] = {
"x,y,z", "x,-y,z+1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_8 [3] = {
"x,y,z", "x,-y,z", 

"x,0,z", 
};

const char *gamgi_phys_symmetry_wyckoff_9 [2] = {
"x,y,z", "x,-y,z+1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_10 [24] = {
"x,y,z", "-x,y,-z", "-x,-y,-z", "x,-y,z", 

"x,1/2,z", "-x,1/2,-z", 

"x,0,z", "-x,0,-z", 

"1/2,y,1/2", "1/2,-y,1/2", 

"0,y,1/2", "0,-y,1/2", 

"1/2,y,0", "1/2,-y,0", 

"0,y,0", "0,-y,0", 

"1/2,1/2,1/2", 

"1/2,0,1/2", 

"0,1/2,1/2", 

"1/2,1/2,0", 

"1/2,0,0", 

"0,0,1/2", 

"0,1/2,0", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_11 [14] = {
"x,y,z", "-x,y+1/2,-z", "-x,-y,-z", "x,-y+1/2,z", 

"x,1/4,z", "-x,3/4,-z", 

"1/2,0,1/2", "1/2,1/2,1/2", 

"0,0,1/2", "0,1/2,1/2", 

"1/2,0,0", "1/2,1/2,0", 

"0,0,0", "0,1/2,0", 
};

const char *gamgi_phys_symmetry_wyckoff_12 [18] = {
"x,y,z", "-x,y,-z", "-x,-y,-z", "x,-y,z", 

"x,0,z", "-x,0,-z", 

"0,y,1/2", "0,-y,1/2", 

"0,y,0", "0,-y,0", 

"1/4,1/4,1/2", "3/4,1/4,1/2", 

"1/4,1/4,0", "3/4,1/4,0", 

"0,1/2,1/2", 

"0,0,1/2", 

"0,1/2,0", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_13 [16] = {
"x,y,z", "-x,y,-z+1/2", "-x,-y,-z", "x,-y,z+1/2", 

"1/2,y,1/4", "1/2,-y,3/4", 

"0,y,1/4", "0,-y,3/4", 

"1/2,0,0", "1/2,0,1/2", 

"0,1/2,0", "0,1/2,1/2", 

"1/2,1/2,0", "1/2,1/2,1/2", 

"0,0,0", "0,0,1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_14 [12] = {
"x,y,z", "-x,y+1/2,-z+1/2", "-x,-y,-z", "x,-y+1/2,z+1/2", 

"1/2,0,1/2", "1/2,1/2,0", 

"0,0,1/2", "0,1/2,0", 

"1/2,0,0", "1/2,1/2,1/2", 

"0,0,0", "0,1/2,1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_15 [14] = {
"x,y,z", "-x,y,-z+1/2", "-x,-y,-z", "x,-y,z+1/2", 

"0,y,1/4", "0,-y,3/4", 

"1/4,1/4,1/2", "3/4,1/4,0", 

"1/4,1/4,0", "3/4,1/4,1/2", 

"0,1/2,0", "0,1/2,1/2", 

"0,0,0", "0,0,1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_16 [36] = {
"x,y,z", "-x,-y,z", "-x,y,-z", "x,-y,-z", 

"1/2,1/2,z", "1/2,1/2,-z", 

"0,1/2,z", "0,1/2,-z", 

"1/2,0,z", "1/2,0,-z", 

"0,0,z", "0,0,-z", 

"1/2,y,1/2", "1/2,-y,1/2", 

"1/2,y,0", "1/2,-y,0", 

"0,y,1/2", "0,-y,1/2", 

"0,y,0", "0,-y,0", 

"x,1/2,1/2", "-x,1/2,1/2", 

"x,1/2,0", "-x,1/2,0", 

"x,0,1/2", "-x,0,1/2", 

"x,0,0", "-x,0,0", 

"1/2,1/2,1/2", 

"0,1/2,1/2", 

"1/2,0,1/2", 

"1/2,1/2,0", 

"0,0,1/2", 

"0,1/2,0", 

"1/2,0,0", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_17 [12] = {
"x,y,z", "-x,-y,z+1/2", "-x,y,-z+1/2", "x,-y,-z", 

"1/2,y,1/4", "1/2,-y,3/4", 

"0,y,1/4", "0,-y,3/4", 

"x,1/2,0", "-x,1/2,1/2", 

"x,0,0", "-x,0,1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_18 [8] = {
"x,y,z", "-x,-y,z", "-x+1/2,y+1/2,-z", "x+1/2,-y+1/2,-z", 

"0,1/2,z", "1/2,0,-z", 

"0,0,z", "1/2,1/2,-z", 
};

const char *gamgi_phys_symmetry_wyckoff_19 [4] = {
"x,y,z", "-x+1/2,-y,z+1/2", "-x,y+1/2,-z+1/2", "x+1/2,-y+1/2,-z", 
};

const char *gamgi_phys_symmetry_wyckoff_20 [8] = {
"x,y,z", "-x,-y,z+1/2", "-x,y,-z+1/2", "x,-y,-z", 

"0,y,1/4", "0,-y,3/4", 

"x,0,0", "-x,0,1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_21 [22] = {
"x,y,z", "-x,-y,z", "-x,y,-z", "x,-y,-z", 

"1/4,1/4,z", "3/4,1/4,-z", 

"0,1/2,z", "0,1/2,-z", 

"0,0,z", "0,0,-z", 

"0,y,1/2", "0,-y,1/2", 

"0,y,0", "0,-y,0", 

"x,0,1/2", "-x,0,1/2", 

"x,0,0", "-x,0,0", 

"0,0,1/2", 

"1/2,0,1/2", 

"0,1/2,0", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_22 [20] = {
"x,y,z", "-x,-y,z", "-x,y,-z", "x,-y,-z", 

"x,1/4,1/4", "-x,3/4,1/4", 

"1/4,y,1/4", "3/4,-y,1/4", 

"1/4,1/4,z", "3/4,1/4,-z", 

"0,0,z", "0,0,-z", 

"0,y,0", "0,-y,0", 

"x,0,0", "-x,0,0", 

"1/4,1/4,3/4", 

"1/4,1/4,1/4", 

"0,0,1/2", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_23 [20] = {
"x,y,z", "-x,-y,z", "-x,y,-z", "x,-y,-z", 

"0,1/2,z", "0,1/2,-z", 

"0,0,z", "0,0,-z", 

"1/2,y,0", "1/2,-y,0", 

"0,y,0", "0,-y,0", 

"x,0,1/2", "-x,0,1/2", 

"x,0,0", "-x,0,0", 

"0,1/2,0", 

"0,0,1/2", 

"1/2,0,0", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_24 [10] = {
"x,y,z", "-x+1/2,-y,z+1/2", "-x,y+1/2,-z+1/2", "x+1/2,-y+1/2,-z", 

"0,1/4,z", "0,3/4,-z+1/2", 

"1/4,y,0", "1/4,-y,1/2", 

"x,0,1/4", "-x+1/2,0,3/4", 
};

const char *gamgi_phys_symmetry_wyckoff_25 [16] = {
"x,y,z", "-x,-y,z", "x,-y,z", "-x,y,z", 

"1/2,y,z", "1/2,-y,z", 

"0,y,z", "0,-y,z", 

"x,1/2,z", "-x,1/2,z", 

"x,0,z", "-x,0,z", 

"1/2,1/2,z", 

"1/2,0,z", 

"0,1/2,z", 

"0,0,z", 
};

const char *gamgi_phys_symmetry_wyckoff_26 [8] = {
"x,y,z", "-x,-y,z+1/2", "x,-y,z+1/2", "-x,y,z", 

"1/2,y,z", "1/2,-y,z+1/2", 

"0,y,z", "0,-y,z+1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_27 [12] = {
"x,y,z", "-x,-y,z", "x,-y,z+1/2", "-x,y,z+1/2", 

"1/2,1/2,z", "1/2,1/2,z+1/2", 

"1/2,0,z", "1/2,0,z+1/2", 

"0,1/2,z", "0,1/2,z+1/2", 

"0,0,z", "0,0,z+1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_28 [10] = {
"x,y,z", "-x,-y,z", "x+1/2,-y,z", "-x+1/2,y,z", 

"1/4,y,z", "3/4,-y,z", 

"0,1/2,z", "1/2,1/2,z", 

"0,0,z", "1/2,0,z", 
};

const char *gamgi_phys_symmetry_wyckoff_29 [4] = {
"x,y,z", "-x,-y,z+1/2", "x+1/2,-y,z", "-x+1/2,y,z+1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_30 [8] = {
"x,y,z", "-x,-y,z", "x,-y+1/2,z+1/2", "-x,y+1/2,z+1/2", 

"1/2,0,z", "1/2,1/2,z+1/2", 

"0,0,z", "0,1/2,z+1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_31 [6] = {
"x,y,z", "-x+1/2,-y,z+1/2", "x+1/2,-y,z+1/2", "-x,y,z", 

"0,y,z", "1/2,-y,z+1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_32 [8] = {
"x,y,z", "-x,-y,z", "x+1/2,-y+1/2,z", "-x+1/2,y+1/2,z", 

"0,1/2,z", "1/2,0,z", 

"0,0,z", "1/2,1/2,z", 
};

const char *gamgi_phys_symmetry_wyckoff_33 [4] = {
"x,y,z", "-x,-y,z+1/2", "x+1/2,-y+1/2,z", "-x+1/2,y+1/2,z+1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_34 [8] = {
"x,y,z", "-x,-y,z", "x+1/2,-y+1/2,z+1/2", "-x+1/2,y+1/2,z+1/2", 

"0,1/2,z", "1/2,0,z+1/2", 

"0,0,z", "1/2,1/2,z+1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_35 [12] = {
"x,y,z", "-x,-y,z", "x,-y,z", "-x,y,z", 

"0,y,z", "0,-y,z", 

"x,0,z", "-x,0,z", 

"1/4,1/4,z", "1/4,3/4,z", 

"0,1/2,z", 

"0,0,z", 
};

const char *gamgi_phys_symmetry_wyckoff_36 [6] = {
"x,y,z", "-x,-y,z+1/2", "x,-y,z+1/2", "-x,y,z", 

"0,y,z", "0,-y,z+1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_37 [10] = {
"x,y,z", "-x,-y,z", "x,-y,z+1/2", "-x,y,z+1/2", 

"1/4,1/4,z", "1/4,3/4,z+1/2", 

"0,1/2,z", "0,1/2,z+1/2", 

"0,0,z", "0,0,z+1/2", 
};

/*************************************************************
 * groups 38-41: Amm2, Aem2, Ama2 and Aea2 changed to Cm2m,  *
 * Cm2e, Cc2m and Cc2e, using the axes permutation abc->bca, *
 * as shown in the International Tables for Crystallography, *
 * so all base-centered lattices are described as C lattices *
 *************************************************************/

const char *gamgi_phys_symmetry_wyckoff_38 [12] = {
"x,y,z", "-x,y,-z", "-x,y,z", "x,y,-z",

"x,y,1/2", "-x,y,1/2",

"x,y,0", "-x,y,0",

"0,y,z", "0,y,-z",

"0,y,1/2",

"0,y,0",
};

const char *gamgi_phys_symmetry_wyckoff_39 [10] = {
"x,y,z", "-x,y,-z", "-x+1/2,y,z", "x+1/2,y,-z",

"1/4,y,z", "3/4,y,-z",

"0,y,1/2", "1/2,y,1/2",

"0,y,0", "1/2,y,0",
};

const char *gamgi_phys_symmetry_wyckoff_40 [8] = {
"x,y,z", "-x,y,-z", "-x,y,z+1/2", "x,y,-z+1/2", 

"x,y,1/4", "-x,y,3/4", 

"0,y,0", "0,y,1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_41 [6] = { 
"x,y,z", "-x,y,-z", "-x+1/2,y,z+1/2", "x+1/2,y,-z+1/2",    
 
"0,y,0", "1/2,y,1/2", 
}; 

const char *gamgi_phys_symmetry_wyckoff_42 [11] = {
"x,y,z", "-x,-y,z", "x,-y,z", "-x,y,z", 

"x,0,z", "-x,0,z", 

"0,y,z", "0,-y,z", 

"1/4,1/4,z", "1/4,3/4,z", 

"0,0,z", 
};

const char *gamgi_phys_symmetry_wyckoff_43 [6] = {
"x,y,z", "-x,-y,z", "x+1/4,-y+1/4,z+1/4", "-x+1/4,y+1/4,z+1/4", 

"0,0,z", "1/4,1/4,z+1/4", 
};

const char *gamgi_phys_symmetry_wyckoff_44 [10] = {
"x,y,z", "-x,-y,z", "x,-y,z", "-x,y,z", 

"0,y,z", "0,-y,z", 

"x,0,z", "-x,0,z", 

"0,1/2,z", 

"0,0,z", 
};

const char *gamgi_phys_symmetry_wyckoff_45 [8] = {
"x,y,z", "-x,-y,z", "x+1/2,-y+1/2,z", "-x+1/2,y+1/2,z", 

"0,1/2,z", "1/2,0,z", 

"0,0,z", "1/2,1/2,z", 
};

const char *gamgi_phys_symmetry_wyckoff_46 [8] = {
"x,y,z", "-x,-y,z", "x+1/2,-y,z", "-x+1/2,y,z", 

"1/4,y,z", "3/4,-y,z", 

"0,0,z", "1/2,0,z", 
};

const char *gamgi_phys_symmetry_wyckoff_47 [64] = {
"x,y,z", "-x,-y,z", "-x,y,-z", "x,-y,-z", 
"-x,-y,-z", "x,y,-z", "x,-y,z", "-x,y,z", 

"x,y,1/2", "-x,-y,1/2", "-x,y,1/2", "x,-y,1/2", 

"x,y,0", "-x,-y,0", "-x,y,0", "x,-y,0", 

"x,1/2,z", "-x,1/2,z", "-x,1/2,-z", "x,1/2,-z", 

"x,0,z", "-x,0,z", "-x,0,-z", "x,0,-z", 

"1/2,y,z", "1/2,-y,z", "1/2,y,-z", "1/2,-y,-z", 

"0,y,z", "0,-y,z", "0,y,-z", "0,-y,-z", 

"1/2,1/2,z", "1/2,1/2,-z", 

"1/2,0,z", "1/2,0,-z", 

"0,1/2,z", "0,1/2,-z", 

"0,0,z", "0,0,-z", 

"1/2,y,1/2", "1/2,-y,1/2", 

"1/2,y,0", "1/2,-y,0", 

"0,y,1/2", "0,-y,1/2", 

"0,y,0", "0,-y,0", 

"x,1/2,1/2", "-x,1/2,1/2", 

"x,1/2,0", "-x,1/2,0", 

"x,0,1/2", "-x,0,1/2", 

"x,0,0", "-x,0,0", 

"1/2,1/2,1/2", 

"0,1/2,1/2", 

"1/2,1/2,0", 

"0,1/2,0", 

"1/2,0,1/2", 

"0,0,1/2", 

"1/2,0,0", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_48 [48] = {
"x,y,z", "-x+1/2,-y+1/2,z", "-x+1/2,y,-z+1/2", "x,-y+1/2,-z+1/2", 
"-x,-y,-z", "x+1/2,y+1/2,-z", "x+1/2,-y,z+1/2", "-x,y+1/2,z+1/2", 

"1/4,3/4,z", "1/4,3/4,-z+1/2", "3/4,1/4,-z", "3/4,1/4,z+1/2", 

"1/4,1/4,z", "1/4,1/4,-z+1/2", "3/4,3/4,-z", "3/4,3/4,z+1/2", 

"3/4,y,1/4", "3/4,-y+1/2,1/4", "1/4,-y,3/4", "1/4,y+1/2,3/4", 

"1/4,y,1/4", "1/4,-y+1/2,1/4", "3/4,-y,3/4", "3/4,y+1/2,3/4", 

"x,1/4,3/4", "-x+1/2,1/4,3/4", "-x,3/4,1/4", "x+1/2,3/4,1/4", 

"x,1/4,1/4", "-x+1/2,1/4,1/4", "-x,3/4,3/4", "x+1/2,3/4,3/4", 

"0,0,0", "1/2,1/2,0", "1/2,0,1/2", "0,1/2,1/2", 

"1/2,1/2,1/2", "0,0,1/2", "0,1/2,0", "1/2,0,0", 

"1/4,3/4,1/4", "3/4,1/4,3/4", 

"1/4,1/4,3/4", "3/4,3/4,1/4", 

"3/4,1/4,1/4", "1/4,3/4,3/4", 

"1/4,1/4,1/4", "3/4,3/4,3/4", 
};

const char *gamgi_phys_symmetry_wyckoff_49 [60] = {
"x,y,z", "-x,-y,z", "-x,y,-z+1/2", "x,-y,-z+1/2", 
"-x,-y,-z", "x,y,-z", "x,-y,z+1/2", "-x,y,z+1/2", 

"x,y,0", "-x,-y,0", "-x,y,1/2", "x,-y,1/2", 

"1/2,0,z", "1/2,0,-z+1/2", "1/2,0,-z", "1/2,0,z+1/2", 

"0,1/2,z", "0,1/2,-z+1/2", "0,1/2,-z", "0,1/2,z+1/2", 

"1/2,1/2,z", "1/2,1/2,-z+1/2", "1/2,1/2,-z", "1/2,1/2,z+1/2", 

"0,0,z", "0,0,-z+1/2", "0,0,-z", "0,0,z+1/2", 

"1/2,y,1/4", "1/2,-y,1/4", "1/2,-y,3/4", "1/2,y,3/4", 

"0,y,1/4", "0,-y,1/4", "0,-y,3/4", "0,y,3/4", 

"x,1/2,1/4", "-x,1/2,1/4", "-x,1/2,3/4", "x,1/2,3/4", 

"x,0,1/4", "-x,0,1/4", "-x,0,3/4", "x,0,3/4", 

"1/2,1/2,1/4", "1/2,1/2,3/4", 

"0,1/2,1/4", "0,1/2,3/4", 

"1/2,0,1/4", "1/2,0,3/4", 

"0,0,1/4", "0,0,3/4", 

"1/2,0,0", "1/2,0,1/2", 

"0,1/2,0", "0,1/2,1/2", 

"1/2,1/2,0", "1/2,1/2,1/2", 

"0,0,0", "0,0,1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_50 [48] = {
"x,y,z", "-x+1/2,-y+1/2,z", "-x+1/2,y,-z", "x,-y+1/2,-z", 
"-x,-y,-z", "x+1/2,y+1/2,-z", "x+1/2,-y,z", "-x,y+1/2,z", 

"1/4,3/4,z", "1/4,3/4,-z", "3/4,1/4,-z", "3/4,1/4,z", 

"1/4,1/4,z", "1/4,1/4,-z", "3/4,3/4,-z", "3/4,3/4,z", 

"1/4,y,1/2", "1/4,-y+1/2,1/2", "3/4,-y,1/2", "3/4,y+1/2,1/2", 

"1/4,y,0", "1/4,-y+1/2,0", "3/4,-y,0", "3/4,y+1/2,0", 

"x,1/4,1/2", "-x+1/2,1/4,1/2", "-x,3/4,1/2", "x+1/2,3/4,1/2", 

"x,1/4,0", "-x+1/2,1/4,0", "-x,3/4,0", "x+1/2,3/4,0", 

"0,0,1/2", "1/2,1/2,1/2", "1/2,0,1/2", "0,1/2,1/2", 

"0,0,0", "1/2,1/2,0", "1/2,0,0", "0,1/2,0", 

"1/4,1/4,1/2", "3/4,3/4,1/2", 

"3/4,1/4,1/2", "1/4,3/4,1/2", 

"3/4,1/4,0", "1/4,3/4,0", 

"1/4,1/4,0", "3/4,3/4,0", 
};

const char *gamgi_phys_symmetry_wyckoff_51 [40] = {
"x,y,z", "-x+1/2,-y,z", "-x,y,-z", "x+1/2,-y,-z", 
"-x,-y,-z", "x+1/2,y,-z", "x,-y,z", "-x+1/2,y,z", 

"1/4,y,z", "1/4,-y,z", "3/4,y,-z", "3/4,-y,-z", 

"x,1/2,z", "-x+1/2,1/2,z", "-x,1/2,-z", "x+1/2,1/2,-z", 

"x,0,z", "-x+1/2,0,z", "-x,0,-z", "x+1/2,0,-z", 

"0,y,1/2", "1/2,-y,1/2", "0,-y,1/2", "1/2,y,1/2", 

"0,y,0", "1/2,-y,0", "0,-y,0", "1/2,y,0", 

"1/4,1/2,z", "3/4,1/2,-z", 

"1/4,0,z", "3/4,0,-z", 

"0,1/2,1/2", "1/2,1/2,1/2", 

"0,0,1/2", "1/2,0,1/2", 

"0,1/2,0", "1/2,1/2,0", 

"0,0,0", "1/2,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_52 [24] = {
"x,y,z", "-x+1/2,-y,z", "-x+1/2,y+1/2,-z+1/2", "x,-y+1/2,-z+1/2", 
"-x,-y,-z", "x+1/2,y,-z", "x+1/2,-y+1/2,z+1/2", "-x,y+1/2,z+1/2", 

"x,1/4,1/4", "-x+1/2,3/4,1/4", "-x,3/4,3/4", "x+1/2,1/4,3/4", 

"1/4,0,z", "1/4,1/2,-z+1/2", "3/4,0,-z", "3/4,1/2,z+1/2", 

"0,0,1/2", "1/2,0,1/2", "1/2,1/2,0", "0,1/2,0", 

"0,0,0", "1/2,0,0", "1/2,1/2,1/2", "0,1/2,1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_53 [32] = {
"x,y,z", "-x+1/2,-y,z+1/2", "-x+1/2,y,-z+1/2", "x,-y,-z", 
"-x,-y,-z", "x+1/2,y,-z+1/2", "x+1/2,-y,z+1/2", "-x,y,z", 

"0,y,z", "1/2,-y,z+1/2", "1/2,y,-z+1/2", "0,-y,-z", 

"1/4,y,1/4", "1/4,-y,3/4", "3/4,-y,3/4", "3/4,y,1/4", 

"x,1/2,0", "-x+1/2,1/2,1/2", "-x,1/2,0", "x+1/2,1/2,1/2", 

"x,0,0", "-x+1/2,0,1/2", "-x,0,0", "x+1/2,0,1/2", 

"0,1/2,0", "1/2,1/2,1/2", 

"1/2,1/2,0", "0,1/2,1/2", 

"1/2,0,0", "0,0,1/2", 

"0,0,0", "1/2,0,1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_54 [28] = {
"x,y,z", "-x+1/2,-y,z", "-x,y,-z+1/2", "x+1/2,-y,-z+1/2", 
"-x,-y,-z", "x+1/2,y,-z", "x,-y,z+1/2", "-x+1/2,y,z+1/2", 

"1/4,1/2,z", "3/4,1/2,-z+1/2", "3/4,1/2,-z", "1/4,1/2,z+1/2", 

"1/4,0,z", "3/4,0,-z+1/2", "3/4,0,-z", "1/4,0,z+1/2", 

"0,y,1/4", "1/2,-y,1/4", "0,-y,3/4", "1/2,y,3/4", 

"0,1/2,0", "1/2,1/2,0", "0,1/2,1/2", "1/2,1/2,1/2", 

"0,0,0", "1/2,0,0", "0,0,1/2", "1/2,0,1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_55 [32] = {
"x,y,z", "-x,-y,z", "-x+1/2,y+1/2,-z", "x+1/2,-y+1/2,-z", 
"-x,-y,-z", "x,y,-z", "x+1/2,-y+1/2,z", "-x+1/2,y+1/2,z", 

"x,y,1/2", "-x,-y,1/2", "-x+1/2,y+1/2,1/2", "x+1/2,-y+1/2,1/2", 

"x,y,0", "-x,-y,0", "-x+1/2,y+1/2,0", "x+1/2,-y+1/2,0", 

"0,1/2,z", "1/2,0,-z", "0,1/2,-z", "1/2,0,z", 

"0,0,z", "1/2,1/2,-z", "0,0,-z", "1/2,1/2,z", 

"0,1/2,1/2", "1/2,0,1/2", 

"0,1/2,0", "1/2,0,0", 

"0,0,1/2", "1/2,1/2,1/2", 

"0,0,0", "1/2,1/2,0", 
};

const char *gamgi_phys_symmetry_wyckoff_56 [24] = {
"x,y,z", "-x+1/2,-y+1/2,z", "-x,y+1/2,-z+1/2", "x+1/2,-y,-z+1/2", 
"-x,-y,-z", "x+1/2,y+1/2,-z", "x,-y+1/2,z+1/2", "-x+1/2,y,z+1/2", 

"1/4,3/4,z", "3/4,1/4,-z+1/2", "3/4,1/4,-z", "1/4,3/4,z+1/2", 

"1/4,1/4,z", "3/4,3/4,-z+1/2", "3/4,3/4,-z", "1/4,1/4,z+1/2", 

"0,0,1/2", "1/2,1/2,1/2", "0,1/2,0", "1/2,0,0", 

"0,0,0", "1/2,1/2,0", "0,1/2,1/2", "1/2,0,1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_57 [24] = {
"x,y,z", "-x,-y,z+1/2", "-x,y+1/2,-z+1/2", "x,-y+1/2,-z", 
"-x,-y,-z", "x,y,-z+1/2", "x,-y+1/2,z+1/2", "-x,y+1/2,z", 

"x,y,1/4", "-x,-y,3/4", "-x,y+1/2,1/4", "x,-y+1/2,3/4", 

"x,1/4,0", "-x,3/4,1/2", "-x,3/4,0", "x,1/4,1/2", 

"1/2,0,0", "1/2,0,1/2", "1/2,1/2,1/2", "1/2,1/2,0", 

"0,0,0", "0,0,1/2", "0,1/2,1/2", "0,1/2,0", 
};

const char *gamgi_phys_symmetry_wyckoff_58 [28] = {
"x,y,z", "-x,-y,z", "-x+1/2,y+1/2,-z+1/2", "x+1/2,-y+1/2,-z+1/2", 
"-x,-y,-z", "x,y,-z", "x+1/2,-y+1/2,z+1/2", "-x+1/2,y+1/2,z+1/2", 

"x,y,0", "-x,-y,0", "-x+1/2,y+1/2,1/2", "x+1/2,-y+1/2,1/2", 

"0,1/2,z", "1/2,0,-z+1/2", "0,1/2,-z", "1/2,0,z+1/2", 

"0,0,z", "1/2,1/2,-z+1/2", "0,0,-z", "1/2,1/2,z+1/2", 

"0,1/2,1/2", "1/2,0,0", 

"0,1/2,0", "1/2,0,1/2", 

"0,0,1/2", "1/2,1/2,0", 

"0,0,0", "1/2,1/2,1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_59 [28] = {
"x,y,z", "-x+1/2,-y+1/2,z", "-x,y+1/2,-z", "x+1/2,-y,-z", 
"-x,-y,-z", "x+1/2,y+1/2,-z", "x,-y+1/2,z", "-x+1/2,y,z", 

"x,1/4,z", "-x+1/2,1/4,z", "-x,3/4,-z", "x+1/2,3/4,-z", 

"1/4,y,z", "1/4,-y+1/2,z", "3/4,y+1/2,-z", "3/4,-y,-z", 

"0,0,1/2", "1/2,1/2,1/2", "0,1/2,1/2", "1/2,0,1/2", 

"0,0,0", "1/2,1/2,0", "0,1/2,0", "1/2,0,0", 

"1/4,3/4,z", "3/4,1/4,-z", 

"1/4,1/4,z", "3/4,3/4,-z", 
};

const char *gamgi_phys_symmetry_wyckoff_60 [20] = {
"x,y,z", "-x+1/2,-y+1/2,z+1/2", "-x,y,-z+1/2", "x+1/2,-y+1/2,-z", 
"-x,-y,-z", "x+1/2,y+1/2,-z+1/2", "x,-y,z+1/2", "-x+1/2,y+1/2,z", 

"0,y,1/4", "1/2,-y+1/2,3/4", "0,-y,3/4", "1/2,y+1/2,1/4", 

"0,1/2,0", "1/2,0,1/2", "0,1/2,1/2", "1/2,0,0", 

"0,0,0", "1/2,1/2,1/2", "0,0,1/2", "1/2,1/2,0", 
};

const char *gamgi_phys_symmetry_wyckoff_61 [16] = {
"x,y,z", "-x+1/2,-y,z+1/2", "-x,y+1/2,-z+1/2", "x+1/2,-y+1/2,-z", 
"-x,-y,-z", "x+1/2,y,-z+1/2", "x,-y+1/2,z+1/2", "-x+1/2,y+1/2,z", 

"0,0,1/2", "1/2,0,0", "0,1/2,0", "1/2,1/2,1/2", 

"0,0,0", "1/2,0,1/2", "0,1/2,1/2", "1/2,1/2,0", 
};

const char *gamgi_phys_symmetry_wyckoff_62 [20] = {
"x,y,z", "-x+1/2,-y,z+1/2", "-x,y+1/2,-z", "x+1/2,-y+1/2,-z+1/2", 
"-x,-y,-z", "x+1/2,y,-z+1/2", "x,-y+1/2,z", "-x+1/2,y+1/2,z+1/2", 

"x,1/4,z", "-x+1/2,3/4,z+1/2", "-x,3/4,-z", "x+1/2,1/4,-z+1/2", 

"0,0,1/2", "1/2,0,0", "0,1/2,1/2", "1/2,1/2,0", 

"0,0,0", "1/2,0,1/2", "0,1/2,0", "1/2,1/2,1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_63 [30] = {
"x,y,z", "-x,-y,z+1/2", "-x,y,-z+1/2", "x,-y,-z", 
"-x,-y,-z", "x,y,-z+1/2", "x,-y,z+1/2", "-x,y,z", 

"x,y,1/4", "-x,-y,3/4", "-x,y,1/4", "x,-y,3/4", 

"0,y,z", "0,-y,z+1/2", "0,y,-z+1/2", "0,-y,-z", 

"x,0,0", "-x,0,1/2", "-x,0,0", "x,0,1/2", 

"1/4,1/4,0", "3/4,3/4,1/2", "3/4,1/4,1/2", "1/4,3/4,0", 

"0,y,1/4", "0,-y,3/4", 

"0,1/2,0", "0,1/2,1/2", 

"0,0,0", "0,0,1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_64 [28] = {
"x,y,z", "-x,-y+1/2,z+1/2", "-x,y+1/2,-z+1/2", "x,-y,-z", 
"-x,-y,-z", "x,y+1/2,-z+1/2", "x,-y+1/2,z+1/2", "-x,y,z", 

"0,y,z", "0,-y+1/2,z+1/2", "0,y+1/2,-z+1/2", "0,-y,-z", 

"1/4,y,1/4", "3/4,-y+1/2,3/4", "3/4,-y,3/4", "1/4,y+1/2,1/4", 

"x,0,0", "-x,1/2,1/2", "-x,0,0", "x,1/2,1/2", 

"1/4,1/4,0", "3/4,1/4,1/2", "3/4,3/4,1/2", "1/4,3/4,0", 

"1/2,0,0", "1/2,1/2,1/2", 

"0,0,0", "0,1/2,1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_65 [48] = {
"x,y,z", "-x,-y,z", "-x,y,-z", "x,-y,-z", 
"-x,-y,-z", "x,y,-z", "x,-y,z", "-x,y,z", 

"x,y,1/2", "-x,-y,1/2", "-x,y,1/2", "x,-y,1/2", 

"x,y,0", "-x,-y,0", "-x,y,0", "x,-y,0", 

"x,0,z", "-x,0,z", "-x,0,-z", "x,0,-z", 

"0,y,z", "0,-y,z", "0,y,-z", "0,-y,-z", 

"1/4,1/4,z", "3/4,1/4,-z", "3/4,3/4,-z", "1/4,3/4,z", 

"0,1/2,z", "0,1/2,-z", 

"0,0,z", "0,0,-z", 

"0,y,1/2", "0,-y,1/2", 

"0,y,0", "0,-y,0", 

"x,0,1/2", "-x,0,1/2", 

"x,0,0", "-x,0,0", 

"1/4,1/4,1/2", "3/4,1/4,1/2", 

"1/4,1/4,0", "3/4,1/4,0", 

"0,0,1/2", 

"1/2,0,1/2", 

"1/2,0,0", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_66 [44] = {
"x,y,z", "-x,-y,z", "-x,y,-z+1/2", "x,-y,-z+1/2", 
"-x,-y,-z", "x,y,-z", "x,-y,z+1/2", "-x,y,z+1/2", 

"x,y,0", "-x,-y,0", "-x,y,1/2", "x,-y,1/2", 

"1/4,1/4,z", "3/4,1/4,-z+1/2", "3/4,3/4,-z", "1/4,3/4,z+1/2", 

"0,1/2,z", "0,1/2,-z+1/2", "0,1/2,-z", "0,1/2,z+1/2", 

"0,0,z", "0,0,-z+1/2", "0,0,-z", "0,0,z+1/2", 

"0,y,1/4", "0,-y,1/4", "0,-y,3/4", "0,y,3/4", 

"x,0,1/4", "-x,0,1/4", "-x,0,3/4", "x,0,3/4", 

"1/4,3/4,0", "3/4,3/4,1/2", 

"1/4,1/4,0", "3/4,1/4,1/2", 

"0,1/2,0", "0,1/2,1/2", 

"0,0,0", "0,0,1/2", 

"0,1/2,1/4", "0,1/2,3/4", 

"0,0,1/4", "0,0,3/4", 
};

const char *gamgi_phys_symmetry_wyckoff_67 [50] = {
"x,y,z", "-x,-y+1/2,z", "-x,y+1/2,-z", "x,-y,-z", 
"-x,-y,-z", "x,y+1/2,-z", "x,-y+1/2,z", "-x,y,z", 

"x,1/4,z", "-x,1/4,z", "-x,3/4,-z", "x,3/4,-z", 

"0,y,z", "0,-y+1/2,z", "0,y+1/2,-z", "0,-y,-z", 

"1/4,0,z", "3/4,1/2,-z", "3/4,0,-z", "1/4,1/2,z", 

"1/4,y,1/2", "3/4,-y+1/2,1/2", "3/4,-y,1/2", "1/4,y+1/2,1/2", 

"1/4,y,0", "3/4,-y+1/2,0", "3/4,-y,0", "1/4,y+1/2,0", 

"x,0,1/2", "-x,1/2,1/2", "-x,0,1/2", "x,1/2,1/2", 

"x,0,0", "-x,1/2,0", "-x,0,0", "x,1/2,0", 

"0,1/4,z", "0,3/4,-z", 

"1/4,1/4,1/2", "3/4,1/4,1/2", 

"1/4,1/4,0", "3/4,1/4,0", 

"0,0,1/2", "0,1/2,1/2", 

"0,0,0", "0,1/2,0", 

"1/4,0,1/2", "3/4,0,1/2", 

"1/4,0,0", "3/4,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_68 [36] = {
"x,y,z", "-x+1/2,-y,z", "-x,y,-z+1/2", "x+1/2,-y,-z+1/2", 
"-x,-y,-z", "x+1/2,y,-z", "x,-y,z+1/2", "-x+1/2,y,z+1/2", 

"1/4,0,z", "3/4,0,-z+1/2", "3/4,0,-z", "1/4,0,z+1/2", 

"0,1/4,z", "0,1/4,-z+1/2", "0,3/4,-z", "0,3/4,z+1/2", 

"0,y,1/4", "1/2,-y,1/4", "0,-y,3/4", "1/2,y,3/4", 

"x,1/4,1/4", "-x+1/2,3/4,1/4", "-x,3/4,3/4", "x+1/2,1/4,3/4", 

"0,0,0", "1/2,0,0", "0,0,1/2", "1/2,0,1/2", 

"1/4,3/4,0", "1/4,1/4,0", "3/4,3/4,1/2", "3/4,1/4,1/2", 

"0,1/4,3/4", "0,3/4,1/4", 

"0,1/4,1/4", "0,3/4,3/4", 
};

const char *gamgi_phys_symmetry_wyckoff_69 [48] = {
"x,y,z", "-x,-y,z", "-x,y,-z", "x,-y,-z", 
"-x,-y,-z", "x,y,-z", "x,-y,z", "-x,y,z", 

"x,y,0", "-x,-y,0", "-x,y,0", "x,-y,0", 

"x,0,z", "-x,0,z", "-x,0,-z", "x,0,-z", 

"0,y,z", "0,-y,z", "0,y,-z", "0,-y,-z", 

"x,1/4,1/4", "-x,3/4,1/4", "-x,3/4,3/4", "x,1/4,3/4", 

"1/4,y,1/4", "3/4,-y,1/4", "3/4,-y,3/4", "1/4,y,3/4", 

"1/4,1/4,z", "3/4,1/4,-z", "3/4,3/4,-z", "1/4,3/4,z", 

"0,0,z", "0,0,-z", 

"0,y,0", "0,-y,0", 

"x,0,0", "-x,0,0", 

"1/4,1/4,1/4", "3/4,3/4,3/4", 

"1/4,1/4,0", "3/4,1/4,0", 

"1/4,0,1/4", "3/4,0,1/4", 

"0,1/4,1/4", "0,3/4,1/4", 

"0,0,1/2", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_70 [32] = {
"x,y,z", "-x+3/4,-y+3/4,z", "-x+3/4,y,-z+3/4", "x,-y+3/4,-z+3/4", 
"-x,-y,-z", "x+1/4,y+1/4,-z", "x+1/4,-y,z+1/4", "-x,y+1/4,z+1/4", 

"1/8,1/8,z", "5/8,1/8,-z+3/4", "7/8,7/8,-z", "3/8,7/8,z+1/4", 

"1/8,y,1/8", "5/8,-y+3/4,1/8", "7/8,-y,7/8", "3/8,y+1/4,7/8", 

"x,1/8,1/8", "-x+3/4,5/8,1/8", "-x,7/8,7/8", "x+1/4,3/8,7/8", 

"1/2,1/2,1/2", "1/4,1/4,1/2", "1/4,1/2,1/4", "1/2,1/4,1/4", 

"0,0,0", "3/4,3/4,0", "3/4,0,3/4", "0,3/4,3/4", 

"1/8,1/8,5/8", "7/8,7/8,3/8", 

"1/8,1/8,1/8", "7/8,7/8,7/8", 
};

const char *gamgi_phys_symmetry_wyckoff_71 [40] = {
"x,y,z", "-x,-y,z", "-x,y,-z", "x,-y,-z", 
"-x,-y,-z", "x,y,-z", "x,-y,z", "-x,y,z", 

"x,y,0", "-x,-y,0", "-x,y,0", "x,-y,0", 

"x,0,z", "-x,0,z", "-x,0,-z", "x,0,-z", 

"0,y,z", "0,-y,z", "0,y,-z", "0,-y,-z", 

"1/4,1/4,1/4", "3/4,3/4,1/4", "3/4,1/4,3/4", "1/4,3/4,3/4", 

"1/2,0,z", "1/2,0,-z", 

"0,0,z", "0,0,-z", 

"0,y,1/2", "0,-y,1/2", 

"0,y,0", "0,-y,0", 

"x,1/2,0", "-x,1/2,0", 

"x,0,0", "-x,0,0", 

"1/2,0,1/2", 

"1/2,1/2,0", 

"0,1/2,1/2", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_72 [40] = {
"x,y,z", "-x,-y,z", "-x+1/2,y+1/2,-z", "x+1/2,-y+1/2,-z", 
"-x,-y,-z", "x,y,-z", "x+1/2,-y+1/2,z", "-x+1/2,y+1/2,z", 

"x,y,0", "-x,-y,0", "-x+1/2,y+1/2,0", "x+1/2,-y+1/2,0", 

"0,1/2,z", "1/2,0,-z", "0,1/2,-z", "1/2,0,z", 

"0,0,z", "1/2,1/2,-z", "0,0,-z", "1/2,1/2,z", 

"0,y,1/4", "0,-y,1/4", "0,-y,3/4", "0,y,3/4", 

"x,0,1/4", "-x,0,1/4", "-x,0,3/4", "x,0,3/4", 

"1/4,1/4,1/4", "3/4,3/4,1/4", "1/4,3/4,3/4", "3/4,1/4,3/4", 

"1/2,0,0", "0,1/2,0", 

"0,0,0", "1/2,1/2,0", 

"1/2,0,1/4", "1/2,0,3/4", 

"0,0,1/4", "0,0,3/4", 
};

const char *gamgi_phys_symmetry_wyckoff_73 [28] = {
"x,y,z", "-x+1/2,-y,z+1/2", "-x,y+1/2,-z+1/2", "x+1/2,-y+1/2,-z", 
"-x,-y,-z", "x+1/2,y,-z+1/2", "x,-y+1/2,z+1/2", "-x+1/2,y+1/2,z", 

"0,1/4,z", "0,3/4,-z+1/2", "0,3/4,-z", "0,1/4,z+1/2", 

"1/4,y,0", "1/4,-y,1/2", "3/4,-y,0", "3/4,y,1/2", 

"x,0,1/4", "-x+1/2,0,3/4", "-x,0,3/4", "x+1/2,0,1/4", 

"1/4,1/4,1/4", "1/4,3/4,3/4", "3/4,3/4,1/4", "3/4,1/4,3/4", 

"0,0,0", "1/2,0,1/2", "0,1/2,1/2", "1/2,1/2,0", 
};

const char *gamgi_phys_symmetry_wyckoff_74 [34] = {
"x,y,z", "-x,-y+1/2,z", "-x,y+1/2,-z", "x,-y,-z", 
"-x,-y,-z", "x,y+1/2,-z", "x,-y+1/2,z", "-x,y,z", 

"x,1/4,z", "-x,1/4,z", "-x,3/4,-z", "x,3/4,-z", 

"0,y,z", "0,-y+1/2,z", "0,y+1/2,-z", "0,-y,-z", 

"1/4,y,1/4", "3/4,-y+1/2,1/4", "3/4,-y,3/4", "1/4,y+1/2,3/4", 

"x,0,0", "-x,1/2,0", "-x,0,0", "x,1/2,0", 

"0,1/4,z", "0,3/4,-z", 

"1/4,1/4,3/4", "3/4,1/4,3/4", 

"1/4,1/4,1/4", "3/4,1/4,1/4", 

"0,0,1/2", "0,1/2,1/2", 

"0,0,0", "0,1/2,0", 
};

const char *gamgi_phys_symmetry_wyckoff_75 [8] = {
"x,y,z", "-x,-y,z", "-y,x,z", "y,-x,z", 

"0,1/2,z", "1/2,0,z", 

"1/2,1/2,z", 

"0,0,z", 
};

const char *gamgi_phys_symmetry_wyckoff_76 [4] = {
"x,y,z", "-x,-y,z+1/2", "-y,x,z+1/4", "y,-x,z+3/4",
};

const char *gamgi_phys_symmetry_wyckoff_77 [10] = {
"x,y,z", "-x,-y,z", "-y,x,z+1/2", "y,-x,z+1/2", 

"0,1/2,z", "1/2,0,z+1/2", 

"1/2,1/2,z", "1/2,1/2,z+1/2", 

"0,0,z", "0,0,z+1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_78 [4] = {
"x,y,z", "-x,-y,z+1/2", "-y,x,z+3/4", "y,-x,z+1/4", 
};

const char *gamgi_phys_symmetry_wyckoff_79 [7] = {
"x,y,z", "-x,-y,z", "-y,x,z", "y,-x,z", 

"0,1/2,z", "1/2,0,z", 

"0,0,z", 
};

const char *gamgi_phys_symmetry_wyckoff_80 [6] = {
"x,y,z", "-x+1/2,-y+1/2,z+1/2", "-y,x+1/2,z+1/4", "y+1/2,-x,z+3/4", 

"0,0,z", "0,1/2,z+1/4", 
};

const char *gamgi_phys_symmetry_wyckoff_81 [14] = {
"x,y,z", "-x,-y,z", "y,-x,-z", "-y,x,-z", 

"0,1/2,z", "1/2,0,-z", 

"1/2,1/2,z", "1/2,1/2,-z", 

"0,0,z", "0,0,-z", 

"1/2,1/2,1/2", 

"1/2,1/2,0", 

"0,0,1/2", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_82 [12] = {
"x,y,z", "-x,-y,z", "y,-x,-z", "-y,x,-z", 

"0,1/2,z", "1/2,0,-z", 

"0,0,z", "0,0,-z", 

"0,1/2,3/4", 

"0,1/2,1/4", 

"0,0,1/2", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_83 [32] = {
"x,y,z", "-x,-y,z", "-y,x,z", "y,-x,z", 
"-x,-y,-z", "x,y,-z", "y,-x,-z", "-y,x,-z", 

"x,y,1/2", "-x,-y,1/2", "-y,x,1/2", "y,-x,1/2", 

"x,y,0", "-x,-y,0", "-y,x,0", "y,-x,0", 

"0,1/2,z", "1/2,0,z", "0,1/2,-z", "1/2,0,-z", 

"1/2,1/2,z", "1/2,1/2,-z", 

"0,0,z", "0,0,-z", 

"0,1/2,1/2", "1/2,0,1/2", 

"0,1/2,0", "1/2,0,0", 

"1/2,1/2,1/2", 

"1/2,1/2,0", 

"0,0,1/2", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_84 [36] = {
"x,y,z", "-x,-y,z", "-y,x,z+1/2", "y,-x,z+1/2", 
"-x,-y,-z", "x,y,-z", "y,-x,-z+1/2", "-y,x,-z+1/2", 

"x,y,0", "-x,-y,0", "-y,x,1/2", "y,-x,1/2", 

"0,1/2,z", "1/2,0,z+1/2", "0,1/2,-z", "1/2,0,-z+1/2", 

"1/2,1/2,z", "1/2,1/2,z+1/2", "1/2,1/2,-z", "1/2,1/2,-z+1/2", 

"0,0,z", "0,0,z+1/2", "0,0,-z", "0,0,-z+1/2", 

"1/2,1/2,1/4", "1/2,1/2,3/4", 

"0,0,1/4", "0,0,3/4", 

"0,1/2,1/2", "1/2,0,0", 

"0,1/2,0", "1/2,0,1/2", 

"1/2,1/2,0", "1/2,1/2,1/2", 

"0,0,0", "0,0,1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_85 [26] = {
"x,y,z", "-x+1/2,-y+1/2,z", "-y+1/2,x,z", "y,-x+1/2,z", 
"-x,-y,-z", "x+1/2,y+1/2,-z", "y+1/2,-x,-z", "-y,x+1/2,-z", 

"1/4,3/4,z", "3/4,1/4,z", "3/4,1/4,-z", "1/4,3/4,-z", 

"0,0,1/2", "1/2,1/2,1/2", "1/2,0,1/2", "0,1/2,1/2", 

"0,0,0", "1/2,1/2,0", "1/2,0,0", "0,1/2,0", 

"1/4,1/4,z", "3/4,3/4,-z", 

"1/4,3/4,1/2", "3/4,1/4,1/2", 

"1/4,3/4,0", "3/4,1/4,0", 
};

const char *gamgi_phys_symmetry_wyckoff_86 [28] = {
"x,y,z", "-x+1/2,-y+1/2,z", "-y,x+1/2,z+1/2", "y+1/2,-x,z+1/2", 
"-x,-y,-z", "x+1/2,y+1/2,-z", "y,-x+1/2,-z+1/2", "-y+1/2,x,-z+1/2", 

"1/4,1/4,z", "3/4,3/4,z+1/2", "3/4,3/4,-z", "1/4,1/4,-z+1/2", 

"3/4,1/4,z", "3/4,1/4,z+1/2", "1/4,3/4,-z", "1/4,3/4,-z+1/2", 

"0,0,1/2", "1/2,1/2,1/2", "0,1/2,0", "1/2,0,0", 

"0,0,0", "1/2,1/2,0", "0,1/2,1/2", "1/2,0,1/2", 

"1/4,1/4,3/4", "3/4,3/4,1/4", 

"1/4,1/4,1/4", "3/4,3/4,3/4", 
};

const char *gamgi_phys_symmetry_wyckoff_87 [28] = {
"x,y,z", "-x,-y,z", "-y,x,z", "y,-x,z", 
"-x,-y,-z", "x,y,-z", "y,-x,-z", "-y,x,-z", 

"x,y,0", "-x,-y,0", "-y,x,0", "y,-x,0", 

"0,1/2,z", "1/2,0,z", "0,1/2,-z", "1/2,0,-z", 

"1/4,1/4,1/4", "3/4,3/4,1/4", "3/4,1/4,1/4", "1/4,3/4,1/4", 

"0,0,z", "0,0,-z", 

"0,1/2,1/4", "1/2,0,1/4", 

"0,1/2,0", "1/2,0,0", 

"0,0,1/2", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_88 [24] = {
"x,y,z", "-x+1/2,-y,z+1/2", "-y+3/4,x+1/4,z+1/4", "y+3/4,-x+3/4,z+3/4", 
"-x,-y,-z", "x+1/2,y,-z+1/2", "y+1/4,-x+3/4,-z+3/4", "-y+1/4,x+1/4,-z+1/4", 

"0,1/4,z", "1/2,1/4,z+1/4", "0,3/4,-z", "1/2,3/4,-z+3/4", 

"0,0,1/2", "1/2,0,0", "3/4,1/4,3/4", "3/4,3/4,1/4", 

"0,0,0", "1/2,0,1/2", "3/4,1/4,1/4", "3/4,3/4,3/4", 

"0,1/4,5/8", "1/2,1/4,7/8", 

"0,1/4,1/8", "1/2,1/4,3/8", 
};

const char *gamgi_phys_symmetry_wyckoff_89 [48] = {
"x,y,z", "-x,-y,z", "-y,x,z", "y,-x,z", 
"-x,y,-z", "x,-y,-z", "y,x,-z", "-y,-x,-z", 

"x,1/2,0", "-x,1/2,0", "1/2,x,0", "1/2,-x,0", 

"x,0,1/2", "-x,0,1/2", "0,x,1/2", "0,-x,1/2", 

"x,1/2,1/2", "-x,1/2,1/2", "1/2,x,1/2", "1/2,-x,1/2", 

"x,0,0", "-x,0,0", "0,x,0", "0,-x,0", 

"x,x,1/2", "-x,-x,1/2", "-x,x,1/2", "x,-x,1/2", 

"x,x,0", "-x,-x,0", "-x,x,0", "x,-x,0", 

"0,1/2,z", "1/2,0,z", "0,1/2,-z", "1/2,0,-z", 

"1/2,1/2,z", "1/2,1/2,-z", 

"0,0,z", "0,0,-z", 

"1/2,0,1/2", "0,1/2,1/2", 

"1/2,0,0", "0,1/2,0", 

"1/2,1/2,1/2", 

"1/2,1/2,0", 

"0,0,1/2", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_90 [26] = {
"x,y,z", "-x,-y,z", "-y+1/2,x+1/2,z", "y+1/2,-x+1/2,z", 
"-x+1/2,y+1/2,-z", "x+1/2,-y+1/2,-z", "y,x,-z", "-y,-x,-z", 

"x,x,1/2", "-x,-x,1/2", "-x+1/2,x+1/2,1/2", "x+1/2,-x+1/2,1/2", 

"x,x,0", "-x,-x,0", "-x+1/2,x+1/2,0", "x+1/2,-x+1/2,0", 

"0,0,z", "1/2,1/2,z", "1/2,1/2,-z", "0,0,-z", 

"0,1/2,z", "1/2,0,-z", 

"0,0,1/2", "1/2,1/2,1/2", 

"0,0,0", "1/2,1/2,0", 
};

const char *gamgi_phys_symmetry_wyckoff_91 [20] = {
"x,y,z", "-x,-y,z+1/2", "-y,x,z+1/4", "y,-x,z+3/4", 
"-x,y,-z", "x,-y,-z+1/2", "y,x,-z+3/4", "-y,-x,-z+1/4", 

"x,x,3/8", "-x,-x,7/8", "-x,x,5/8", "x,-x,1/8", 

"1/2,y,0", "1/2,-y,1/2", "-y,1/2,1/4", "y,1/2,3/4", 

"0,y,0", "0,-y,1/2", "-y,0,1/4", "y,0,3/4", 
};

const char *gamgi_phys_symmetry_wyckoff_92 [12] = {
"x,y,z", "-x,-y,z+1/2", "-y+1/2,x+1/2,z+1/4", "y+1/2,-x+1/2,z+3/4", 
"-x+1/2,y+1/2,-z+1/4", "x+1/2,-y+1/2,-z+3/4", "y,x,-z", "-y,-x,-z+1/2", 

"x,x,0", "-x,-x,1/2", "-x+1/2,x+1/2,1/4", "x+1/2,-x+1/2,3/4", 
};

const char *gamgi_phys_symmetry_wyckoff_93 [56] = {
"x,y,z", "-x,-y,z", "-y,x,z+1/2", "y,-x,z+1/2", 
"-x,y,-z", "x,-y,-z", "y,x,-z+1/2", "-y,-x,-z+1/2", 

"x,x,3/4", "-x,-x,3/4", "-x,x,1/4", "x,-x,1/4", 

"x,x,1/4", "-x,-x,1/4", "-x,x,3/4", "x,-x,3/4", 

"x,1/2,0", "-x,1/2,0", "1/2,x,1/2", "1/2,-x,1/2", 

"x,0,1/2", "-x,0,1/2", "0,x,0", "0,-x,0", 

"x,1/2,1/2", "-x,1/2,1/2", "1/2,x,0", "1/2,-x,0", 

"x,0,0", "-x,0,0", "0,x,1/2", "0,-x,1/2", 

"0,1/2,z", "1/2,0,z+1/2", "0,1/2,-z", "1/2,0,-z+1/2", 

"1/2,1/2,z", "1/2,1/2,z+1/2", "1/2,1/2,-z", "1/2,1/2,-z+1/2", 

"0,0,z", "0,0,z+1/2", "0,0,-z", "0,0,-z+1/2", 

"1/2,1/2,1/4", "1/2,1/2,3/4", 

"0,0,1/4", "0,0,3/4", 

"0,1/2,1/2", "1/2,0,0", 

"0,1/2,0", "1/2,0,1/2", 

"1/2,1/2,0", "1/2,1/2,1/2", 

"0,0,0", "0,0,1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_94 [28] = {
"x,y,z", "-x,-y,z", "-y+1/2,x+1/2,z+1/2", "y+1/2,-x+1/2,z+1/2", 
"-x+1/2,y+1/2,-z+1/2", "x+1/2,-y+1/2,-z+1/2", "y,x,-z", "-y,-x,-z", 

"x,x,1/2", "-x,-x,1/2", "-x+1/2,x+1/2,0", "x+1/2,-x+1/2,0", 

"x,x,0", "-x,-x,0", "-x+1/2,x+1/2,1/2", "x+1/2,-x+1/2,1/2", 

"0,1/2,z", "0,1/2,z+1/2", "1/2,0,-z+1/2", "1/2,0,-z", 

"0,0,z", "1/2,1/2,z+1/2", "1/2,1/2,-z+1/2", "0,0,-z", 

"0,0,1/2", "1/2,1/2,0", 

"0,0,0", "1/2,1/2,1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_95 [20] = {
"x,y,z", "-x,-y,z+1/2", "-y,x,z+3/4", "y,-x,z+1/4", 
"-x,y,-z", "x,-y,-z+1/2", "y,x,-z+1/4", "-y,-x,-z+3/4", 

"x,x,5/8", "-x,-x,1/8", "-x,x,3/8", "x,-x,7/8", 

"1/2,y,0", "1/2,-y,1/2", "-y,1/2,3/4", "y,1/2,1/4", 

"0,y,0", "0,-y,1/2", "-y,0,3/4", "y,0,1/4", 
};

const char *gamgi_phys_symmetry_wyckoff_96 [12] = {
"x,y,z", "-x,-y,z+1/2", "-y+1/2,x+1/2,z+3/4", "y+1/2,-x+1/2,z+1/4", 
"-x+1/2,y+1/2,-z+3/4", "x+1/2,-y+1/2,-z+1/4", "y,x,-z", "-y,-x,-z+1/2", 

"x,x,0", "-x,-x,1/2", "-x+1/2,x+1/2,3/4", "x+1/2,-x+1/2,1/4", 
};

const char *gamgi_phys_symmetry_wyckoff_97 [36] = {
"x,y,z", "-x,-y,z", "-y,x,z", "y,-x,z", 
"-x,y,-z", "x,-y,-z", "y,x,-z", "-y,-x,-z", 

"x,x+1/2,1/4", "-x,-x+1/2,1/4", "-x+1/2,x,1/4", "x+1/2,-x,1/4", 

"x,0,1/2", "-x,0,1/2", "0,x,1/2", "0,-x,1/2", 

"x,0,0", "-x,0,0", "0,x,0", "0,-x,0", 

"x,x,0", "-x,-x,0", "-x,x,0", "x,-x,0", 

"0,1/2,z", "1/2,0,z", "0,1/2,-z", "1/2,0,-z", 

"0,0,z", "0,0,-z", 

"0,1/2,1/4", "1/2,0,1/4", 

"0,1/2,0", "1/2,0,0", 

"0,0,1/2", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_98 [28] = {
"x,y,z", "-x+1/2,-y+1/2,z+1/2", "-y,x+1/2,z+1/4", "y+1/2,-x,z+3/4", 
"-x+1/2,y,-z+3/4", "x,-y+1/2,-z+1/4", "y+1/2,x+1/2,-z+1/2", "-y,-x,-z", 

"x,1/4,1/8", "-x+1/2,1/4,5/8", "3/4,x+1/2,3/8", "3/4,-x,7/8", 

"-x,x,0", "x+1/2,-x+1/2,1/2", "-x,-x+1/2,1/4", "x+1/2,x,3/4", 

"x,x,0", "-x+1/2,-x+1/2,1/2", "-x,x+1/2,1/4", "x+1/2,-x,3/4", 

"0,0,z", "0,1/2,z+1/4", "1/2,0,-z+3/4", "1/2,1/2,-z+1/2", 

"0,0,1/2", "0,1/2,3/4", 

"0,0,0", "0,1/2,1/4", 
};

const char *gamgi_phys_symmetry_wyckoff_99 [24] = {
"x,y,z", "-x,-y,z", "-y,x,z", "y,-x,z", 
"x,-y,z", "-x,y,z", "-y,-x,z", "y,x,z", 

"x,1/2,z", "-x,1/2,z", "1/2,x,z", "1/2,-x,z", 

"x,0,z", "-x,0,z", "0,x,z", "0,-x,z", 

"x,x,z", "-x,-x,z", "-x,x,z", "x,-x,z", 

"1/2,0,z", "0,1/2,z", 

"1/2,1/2,z", 

"0,0,z", 
};

const char *gamgi_phys_symmetry_wyckoff_100 [16] = {
"x,y,z", "-x,-y,z", "-y,x,z", "y,-x,z", 
"x+1/2,-y+1/2,z", "-x+1/2,y+1/2,z", "-y+1/2,-x+1/2,z", "y+1/2,x+1/2,z", 

"x,x+1/2,z", "-x,-x+1/2,z", "-x+1/2,x,z", "x+1/2,-x,z", 

"1/2,0,z", "0,1/2,z", 

"0,0,z", "1/2,1/2,z", 
};

const char *gamgi_phys_symmetry_wyckoff_101 [20] = {
"x,y,z", "-x,-y,z", "-y,x,z+1/2", "y,-x,z+1/2", 
"x,-y,z+1/2", "-x,y,z+1/2", "-y,-x,z", "y,x,z", 

"x,x,z", "-x,-x,z", "-x,x,z+1/2", "x,-x,z+1/2", 

"0,1/2,z", "1/2,0,z+1/2", "0,1/2,z+1/2", "1/2,0,z", 

"1/2,1/2,z", "1/2,1/2,z+1/2", 

"0,0,z", "0,0,z+1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_102 [18] = {
"x,y,z", "-x,-y,z", "-y+1/2,x+1/2,z+1/2", "y+1/2,-x+1/2,z+1/2", 
"x+1/2,-y+1/2,z+1/2", "-x+1/2,y+1/2,z+1/2", "-y,-x,z", "y,x,z", 

"x,x,z", "-x,-x,z", "-x+1/2,x+1/2,z+1/2", "x+1/2,-x+1/2,z+1/2", 

"0,1/2,z", "0,1/2,z+1/2", "1/2,0,z+1/2", "1/2,0,z", 

"0,0,z", "1/2,1/2,z+1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_103 [16] = {
"x,y,z", "-x,-y,z", "-y,x,z", "y,-x,z", 
"x,-y,z+1/2", "-x,y,z+1/2", "-y,-x,z+1/2", "y,x,z+1/2", 

"0,1/2,z", "1/2,0,z", "0,1/2,z+1/2", "1/2,0,z+1/2", 

"1/2,1/2,z", "1/2,1/2,z+1/2", 

"0,0,z", "0,0,z+1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_104 [14] = {
"x,y,z", "-x,-y,z", "-y,x,z", "y,-x,z", 
"x+1/2,-y+1/2,z+1/2", "-x+1/2,y+1/2,z+1/2", "-y+1/2,-x+1/2,z+1/2", "y+1/2,x+1/2,z+1/2", 

"0,1/2,z", "1/2,0,z", "1/2,0,z+1/2", "0,1/2,z+1/2", 

"0,0,z", "1/2,1/2,z+1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_105 [22] = {
"x,y,z", "-x,-y,z", "-y,x,z+1/2", "y,-x,z+1/2", 
"x,-y,z", "-x,y,z", "-y,-x,z+1/2", "y,x,z+1/2", 

"x,1/2,z", "-x,1/2,z", "1/2,x,z+1/2", "1/2,-x,z+1/2", 

"x,0,z", "-x,0,z", "0,x,z+1/2", "0,-x,z+1/2", 

"0,1/2,z", "1/2,0,z+1/2", 

"1/2,1/2,z", "1/2,1/2,z+1/2", 

"0,0,z", "0,0,z+1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_106 [16] = {
"x,y,z", "-x,-y,z", "-y,x,z+1/2", "y,-x,z+1/2", 
"x+1/2,-y+1/2,z", "-x+1/2,y+1/2,z", "-y+1/2,-x+1/2,z+1/2", "y+1/2,x+1/2,z+1/2", 

"0,1/2,z", "1/2,0,z+1/2", "1/2,0,z", "0,1/2,z+1/2", 

"0,0,z", "0,0,z+1/2", "1/2,1/2,z", "1/2,1/2,z+1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_107 [19] = {
"x,y,z", "-x,-y,z", "-y,x,z", "y,-x,z", 
"x,-y,z", "-x,y,z", "-y,-x,z", "y,x,z", 

"x,0,z", "-x,0,z", "0,x,z", "0,-x,z", 

"x,x,z", "-x,-x,z", "-x,x,z", "x,-x,z", 

"0,1/2,z", "1/2,0,z", 

"0,0,z", 
};

const char *gamgi_phys_symmetry_wyckoff_108 [16] = {
"x,y,z", "-x,-y,z", "-y,x,z", "y,-x,z", 
"x,-y,z+1/2", "-x,y,z+1/2", "-y,-x,z+1/2", "y,x,z+1/2", 

"x,x+1/2,z", "-x,-x+1/2,z", "-x+1/2,x,z", "x+1/2,-x,z", 

"1/2,0,z", "0,1/2,z", 

"0,0,z", "0,0,z+1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_109 [14] = {
"x,y,z", "-x+1/2,-y+1/2,z+1/2", "-y,x+1/2,z+1/4", "y+1/2,-x,z+3/4", 
"x,-y,z", "-x+1/2,y+1/2,z+1/2", "-y,-x+1/2,z+1/4", "y+1/2,x,z+3/4", 

"0,y,z", "1/2,-y+1/2,z+1/2", "-y,1/2,z+1/4", "y+1/2,0,z+3/4", 

"0,0,z", "0,1/2,z+1/4", 
};

const char *gamgi_phys_symmetry_wyckoff_110 [12] = {
"x,y,z", "-x+1/2,-y+1/2,z+1/2", "-y,x+1/2,z+1/4", "y+1/2,-x,z+3/4", 
"x,-y,z+1/2", "-x+1/2,y+1/2,z", "-y,-x+1/2,z+3/4", "y+1/2,x,z+1/4", 

"0,0,z", "0,1/2,z+1/4", "0,0,z+1/2", "0,1/2,z+3/4", 
};

const char *gamgi_phys_symmetry_wyckoff_111 [44] = {
"x,y,z", "-x,-y,z", "y,-x,-z", "-y,x,-z", 
"-x,y,-z", "x,-y,-z", "-y,-x,z", "y,x,z", 

"x,x,z", "-x,-x,z", "x,-x,-z", "-x,x,-z", 

"0,1/2,z", "1/2,0,-z", "0,1/2,-z", "1/2,0,z", 

"x,1/2,0", "-x,1/2,0", "1/2,-x,0", "1/2,x,0", 

"x,0,1/2", "-x,0,1/2", "0,-x,1/2", "0,x,1/2", 

"x,1/2,1/2", "-x,1/2,1/2", "1/2,-x,1/2", "1/2,x,1/2", 

"x,0,0", "-x,0,0", "0,-x,0", "0,x,0", 

"1/2,1/2,z", "1/2,1/2,-z", 

"0,0,z", "0,0,-z", 

"1/2,0,1/2", "0,1/2,1/2", 

"1/2,0,0", "0,1/2,0", 

"1/2,1/2,0", 

"0,0,1/2", 

"1/2,1/2,1/2", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_112 [48] = {
"x,y,z", "-x,-y,z", "y,-x,-z", "-y,x,-z", 
"-x,y,-z+1/2", "x,-y,-z+1/2", "-y,-x,z+1/2", "y,x,z+1/2", 

"0,1/2,z", "1/2,0,-z", "0,1/2,-z+1/2", "1/2,0,z+1/2", 

"1/2,1/2,z", "1/2,1/2,-z", "1/2,1/2,-z+1/2", "1/2,1/2,z+1/2", 

"0,0,z", "0,0,-z", "0,0,-z+1/2", "0,0,z+1/2", 

"0,y,1/4", "0,-y,1/4", "y,0,3/4", "-y,0,3/4", 

"x,1/2,1/4", "-x,1/2,1/4", "1/2,-x,3/4", "1/2,x,3/4", 

"1/2,y,1/4", "1/2,-y,1/4", "y,1/2,3/4", "-y,1/2,3/4", 

"x,0,1/4", "-x,0,1/4", "0,-x,3/4", "0,x,3/4", 

"1/2,1/2,0", "1/2,1/2,1/2", 

"0,0,0", "0,0,1/2", 

"0,1/2,1/4", "1/2,0,3/4", 

"1/2,1/2,1/4", "1/2,1/2,3/4", 

"1/2,0,1/4", "0,1/2,3/4", 

"0,0,1/4", "0,0,3/4", 
};

const char *gamgi_phys_symmetry_wyckoff_113 [22] = {
"x,y,z", "-x,-y,z", "y,-x,-z", "-y,x,-z", 
"-x+1/2,y+1/2,-z", "x+1/2,-y+1/2,-z", "-y+1/2,-x+1/2,z", "y+1/2,x+1/2,z", 

"x,x+1/2,z", "-x,-x+1/2,z", "x+1/2,-x,-z", "-x+1/2,x,-z", 

"0,0,z", "0,0,-z", "1/2,1/2,-z", "1/2,1/2,z", 

"0,1/2,z", "1/2,0,-z", 

"0,0,1/2", "1/2,1/2,1/2", 

"0,0,0", "1/2,1/2,0", 
};

const char *gamgi_phys_symmetry_wyckoff_114 [20] = {
"x,y,z", "-x,-y,z", "y,-x,-z", "-y,x,-z", 
"-x+1/2,y+1/2,-z+1/2", "x+1/2,-y+1/2,-z+1/2", "-y+1/2,-x+1/2,z+1/2", "y+1/2,x+1/2,z+1/2", 

"0,1/2,z", "1/2,0,-z", "1/2,0,-z+1/2", "0,1/2,z+1/2", 

"0,0,z", "0,0,-z", "1/2,1/2,-z+1/2", "1/2,1/2,z+1/2", 

"0,0,1/2", "1/2,1/2,0", 

"0,0,0", "1/2,1/2,1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_115 [34] = {
"x,y,z", "-x,-y,z", "y,-x,-z", "-y,x,-z", 
"x,-y,z", "-x,y,z", "y,x,-z", "-y,-x,-z", 

"x,1/2,z", "-x,1/2,z", "1/2,-x,-z", "1/2,x,-z", 

"x,0,z", "-x,0,z", "0,-x,-z", "0,x,-z", 

"x,x,1/2", "-x,-x,1/2", "x,-x,1/2", "-x,x,1/2", 

"x,x,0", "-x,-x,0", "x,-x,0", "-x,x,0", 

"0,1/2,z", "1/2,0,-z", 

"1/2,1/2,z", "1/2,1/2,-z", 

"0,0,z", "0,0,-z", 

"0,0,1/2", 

"1/2,1/2,1/2", 

"1/2,1/2,0", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_116 [36] = {
"x,y,z", "-x,-y,z", "y,-x,-z", "-y,x,-z", 
"x,-y,z+1/2", "-x,y,z+1/2", "y,x,-z+1/2", "-y,-x,-z+1/2", 

"0,1/2,z", "1/2,0,-z", "0,1/2,z+1/2", "1/2,0,-z+1/2", 

"1/2,1/2,z", "1/2,1/2,-z", "1/2,1/2,z+1/2", "1/2,1/2,-z+1/2", 

"0,0,z", "0,0,-z", "0,0,z+1/2", "0,0,-z+1/2", 

"x,x,3/4", "-x,-x,3/4", "x,-x,1/4", "-x,x,1/4", 

"x,x,1/4", "-x,-x,1/4", "x,-x,3/4", "-x,x,3/4", 

"1/2,1/2,0", "1/2,1/2,1/2", 

"0,0,0", "0,0,1/2", 

"1/2,1/2,1/4", "1/2,1/2,3/4", 

"0,0,1/4", "0,0,3/4", 
};

const char *gamgi_phys_symmetry_wyckoff_117 [32] = {
"x,y,z", "-x,-y,z", "y,-x,-z", "-y,x,-z", 
"x+1/2,-y+1/2,z", "-x+1/2,y+1/2,z", "y+1/2,x+1/2,-z", "-y+1/2,-x+1/2,-z", 

"x,x+1/2,1/2", "-x,-x+1/2,1/2", "x+1/2,-x,1/2", "-x+1/2,x,1/2", 

"x,x+1/2,0", "-x,-x+1/2,0", "x+1/2,-x,0", "-x+1/2,x,0", 

"0,1/2,z", "1/2,0,-z", "1/2,0,z", "0,1/2,-z", 

"0,0,z", "0,0,-z", "1/2,1/2,z", "1/2,1/2,-z", 

"0,1/2,1/2", "1/2,0,1/2", 

"0,1/2,0", "1/2,0,0", 

"0,0,1/2", "1/2,1/2,1/2", 

"0,0,0", "1/2,1/2,0", 
};

const char *gamgi_phys_symmetry_wyckoff_118 [32] = {
"x,y,z", "-x,-y,z", "y,-x,-z", "-y,x,-z", 
"x+1/2,-y+1/2,z+1/2", "-x+1/2,y+1/2,z+1/2", "y+1/2,x+1/2,-z+1/2", "-y+1/2,-x+1/2,-z+1/2", 

"0,1/2,z", "1/2,0,-z", "1/2,0,z+1/2", "0,1/2,-z+1/2", 

"x,x+1/2,1/4", "-x,-x+1/2,1/4", "x+1/2,-x,3/4", "-x+1/2,x,3/4", 

"x,-x+1/2,1/4", "-x,x+1/2,1/4", "-x+1/2,-x,3/4", "x+1/2,x,3/4", 

"0,0,z", "0,0,-z", "1/2,1/2,z+1/2", "1/2,1/2,-z+1/2", 

"0,1/2,3/4", "1/2,0,1/4", 

"0,1/2,1/4", "1/2,0,3/4", 

"0,0,1/2", "1/2,1/2,0", 

"0,0,0", "1/2,1/2,1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_119 [28] = {
"x,y,z", "-x,-y,z", "y,-x,-z", "-y,x,-z", 
"x,-y,z", "-x,y,z", "y,x,-z", "-y,-x,-z", 

"x,0,z", "-x,0,z", "0,-x,-z", "0,x,-z", 

"x,x+1/2,1/4", "-x,-x+1/2,1/4", "x+1/2,-x,3/4", "-x+1/2,x,3/4", 

"x,x,0", "-x,-x,0", "x,-x,0", "-x,x,0", 

"0,1/2,z", "1/2,0,-z", 

"0,0,z", "0,0,-z", 

"0,1/2,3/4", 

"0,1/2,1/4", 

"0,0,1/2", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_120 [32] = {
"x,y,z", "-x,-y,z", "y,-x,-z", "-y,x,-z", 
"x,-y,z+1/2", "-x,y,z+1/2", "y,x,-z+1/2", "-y,-x,-z+1/2", 

"x,x+1/2,0", "-x,-x+1/2,0", "x+1/2,-x,0", "-x+1/2,x,0", 

"0,1/2,z", "1/2,0,-z", "0,1/2,z+1/2", "1/2,0,-z+1/2", 

"0,0,z", "0,0,-z", "0,0,z+1/2", "0,0,-z+1/2", 

"x,x,1/4", "-x,-x,1/4", "x,-x,3/4", "-x,x,3/4", 

"0,1/2,0", "1/2,0,0", 

"0,1/2,1/4", "0,1/2,3/4", 

"0,0,0", "0,0,1/2", 

"0,0,1/4", "0,0,3/4", 
};

const char *gamgi_phys_symmetry_wyckoff_121 [32] = {
"x,y,z", "-x,-y,z", "y,-x,-z", "-y,x,-z", 
"-x,y,-z", "x,-y,-z", "-y,-x,z", "y,x,z", 

"x,x,z", "-x,-x,z", "x,-x,-z", "-x,x,-z", 

"0,1/2,z", "1/2,0,-z", "0,1/2,-z", "1/2,0,z", 

"x,0,1/2", "-x,0,1/2", "0,-x,1/2", "0,x,1/2", 

"x,0,0", "-x,0,0", "0,-x,0", "0,x,0", 

"0,0,z", "0,0,-z", 

"0,1/2,1/4", "0,1/2,3/4", 

"0,1/2,0", "1/2,0,0", 

"0,0,1/2", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_122 [20] = {
"x,y,z", "-x,-y,z", "y,-x,-z", "-y,x,-z", 
"-x+1/2,y,-z+3/4", "x+1/2,-y,-z+3/4", "-y+1/2,-x,z+3/4", "y+1/2,x,z+3/4", 

"x,1/4,1/8", "-x,3/4,1/8", "1/4,-x,7/8", "3/4,x,7/8", 

"0,0,z", "0,0,-z", "1/2,0,-z+3/4", "1/2,0,z+3/4", 

"0,0,1/2", "1/2,0,1/4", 

"0,0,0", "1/2,0,3/4", 
};

const char *gamgi_phys_symmetry_wyckoff_123 [96] = {
"x,y,z", "-x,-y,z", "-y,x,z", "y,-x,z", 
"-x,y,-z", "x,-y,-z", "y,x,-z", "-y,-x,-z", 
"-x,-y,-z", "x,y,-z", "y,-x,-z", "-y,x,-z", 
"x,-y,z", "-x,y,z", "-y,-x,z", "y,x,z", 

"x,1/2,z", "-x,1/2,z", "1/2,x,z", "1/2,-x,z", 
"-x,1/2,-z", "x,1/2,-z", "1/2,x,-z", "1/2,-x,-z", 

"x,0,z", "-x,0,z", "0,x,z", "0,-x,z", 
"-x,0,-z", "x,0,-z", "0,x,-z", "0,-x,-z", 

"x,x,z", "-x,-x,z", "-x,x,z", "x,-x,z", 
"-x,x,-z", "x,-x,-z", "x,x,-z", "-x,-x,-z", 

"x,y,1/2", "-x,-y,1/2", "-y,x,1/2", "y,-x,1/2", 
"-x,y,1/2", "x,-y,1/2", "y,x,1/2", "-y,-x,1/2", 

"x,y,0", "-x,-y,0", "-y,x,0", "y,-x,0", 
"-x,y,0", "x,-y,0", "y,x,0", "-y,-x,0", 

"x,1/2,1/2", "-x,1/2,1/2", "1/2,x,1/2", "1/2,-x,1/2", 

"x,1/2,0", "-x,1/2,0", "1/2,x,0", "1/2,-x,0", 

"x,0,1/2", "-x,0,1/2", "0,x,1/2", "0,-x,1/2", 

"x,0,0", "-x,0,0", "0,x,0", "0,-x,0", 

"x,x,1/2", "-x,-x,1/2", "-x,x,1/2", "x,-x,1/2", 

"x,x,0", "-x,-x,0", "-x,x,0", "x,-x,0", 

"0,1/2,z", "1/2,0,z", "0,1/2,-z", "1/2,0,-z", 

"1/2,1/2,z", "1/2,1/2,-z", 

"0,0,z", "0,0,-z", 

"0,1/2,0", "1/2,0,0", 

"0,1/2,1/2", "1/2,0,1/2", 

"1/2,1/2,1/2", 

"1/2,1/2,0", 

"0,0,1/2", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_124 [80] = {
"x,y,z", "-x,-y,z", "-y,x,z", "y,-x,z", 
"-x,y,-z+1/2", "x,-y,-z+1/2", "y,x,-z+1/2", "-y,-x,-z+1/2", 
"-x,-y,-z", "x,y,-z", "y,-x,-z", "-y,x,-z", 
"x,-y,z+1/2", "-x,y,z+1/2", "-y,-x,z+1/2", "y,x,z+1/2", 

"x,y,0", "-x,-y,0", "-y,x,0", "y,-x,0", 
"-x,y,1/2", "x,-y,1/2", "y,x,1/2", "-y,-x,1/2", 

"x,1/2,1/4", "-x,1/2,1/4", "1/2,x,1/4", "1/2,-x,1/4", 
"-x,1/2,3/4", "x,1/2,3/4", "1/2,-x,3/4", "1/2,x,3/4", 

"x,0,1/4", "-x,0,1/4", "0,x,1/4", "0,-x,1/4", 
"-x,0,3/4", "x,0,3/4", "0,-x,3/4", "0,x,3/4", 

"x,x,1/4", "-x,-x,1/4", "-x,x,1/4", "x,-x,1/4", 
"-x,-x,3/4", "x,x,3/4", "x,-x,3/4", "-x,x,3/4", 

"0,1/2,z", "1/2,0,z", "0,1/2,-z+1/2", "1/2,0,-z+1/2", 
"0,1/2,-z", "1/2,0,-z", "0,1/2,z+1/2", "1/2,0,z+1/2", 

"1/2,1/2,z", "1/2,1/2,-z+1/2", "1/2,1/2,-z", "1/2,1/2,z+1/2", 

"0,0,z", "0,0,-z+1/2", "0,0,-z", "0,0,z+1/2", 

"0,1/2,1/4", "1/2,0,1/4", "0,1/2,3/4", "1/2,0,3/4", 

"0,1/2,0", "1/2,0,0", "0,1/2,1/2", "1/2,0,1/2", 

"1/2,1/2,0", "1/2,1/2,1/2", 

"1/2,1/2,1/4", "1/2,1/2,3/4", 

"0,0,0", "0,0,1/2", 

"0,0,1/4", "0,0,3/4", 
};

const char *gamgi_phys_symmetry_wyckoff_125 [80] = {
"x,y,z", "-x+1/2,-y+1/2,z", "-y+1/2,x,z", "y,-x+1/2,z", 
"-x+1/2,y,-z", "x,-y+1/2,-z", "y,x,-z", "-y+1/2,-x+1/2,-z", 
"-x,-y,-z", "x+1/2,y+1/2,-z", "y+1/2,-x,-z", "-y,x+1/2,-z", 
"x+1/2,-y,z", "-x,y+1/2,z", "-y,-x,z", "y+1/2,x+1/2,z", 

"x,-x,z", "-x+1/2,x+1/2,z", "x+1/2,x,z", "-x,-x+1/2,z", 
"-x+1/2,-x,-z", "x,x+1/2,-z", "-x,x,-z", "x+1/2,-x+1/2,-z", 

"x,1/4,1/2", "-x+1/2,1/4,1/2", "1/4,x,1/2", "1/4,-x+1/2,1/2", 
"-x,3/4,1/2", "x+1/2,3/4,1/2", "3/4,-x,1/2", "3/4,x+1/2,1/2", 

"x,1/4,0", "-x+1/2,1/4,0", "1/4,x,0", "1/4,-x+1/2,0", 
"-x,3/4,0", "x+1/2,3/4,0", "3/4,-x,0", "3/4,x+1/2,0", 

"x,x,1/2", "-x+1/2,-x+1/2,1/2", "-x+1/2,x,1/2", "x,-x+1/2,1/2", 
"-x,-x,1/2", "x+1/2,x+1/2,1/2", "x+1/2,-x,1/2", "-x,x+1/2,1/2", 

"x,x,0", "-x+1/2,-x+1/2,0", "-x+1/2,x,0", "x,-x+1/2,0", 
"-x,-x,0", "x+1/2,x+1/2,0", "x+1/2,-x,0", "-x,x+1/2,0", 

"3/4,1/4,z", "1/4,3/4,z", "3/4,1/4,-z", "1/4,3/4,-z", 

"1/4,1/4,z", "1/4,1/4,-z", "3/4,3/4,-z", "3/4,3/4,z", 

"0,0,1/2", "1/2,1/2,1/2", "1/2,0,1/2", "0,1/2,1/2", 

"0,0,0", "1/2,1/2,0", "1/2,0,0", "0,1/2,0", 

"3/4,1/4,1/2", "1/4,3/4,1/2", 

"3/4,1/4,0", "1/4,3/4,0", 

"1/4,1/4,1/2", "3/4,3/4,1/2", 

"1/4,1/4,0", "3/4,3/4,0", 
};

const char *gamgi_phys_symmetry_wyckoff_126 [72] = {
"x,y,z", "-x+1/2,-y+1/2,z", "-y+1/2,x,z", "y,-x+1/2,z", 
"-x+1/2,y,-z+1/2", "x,-y+1/2,-z+1/2", "y,x,-z+1/2", "-y+1/2,-x+1/2,-z+1/2", 
"-x,-y,-z", "x+1/2,y+1/2,-z", "y+1/2,-x,-z", "-y,x+1/2,-z", 
"x+1/2,-y,z+1/2", "-x,y+1/2,z+1/2", "-y,-x,z+1/2", "y+1/2,x+1/2,z+1/2", 

"x,3/4,1/4", "-x+1/2,3/4,1/4", "3/4,x,1/4", "3/4,-x+1/2,1/4", 
"-x,1/4,3/4", "x+1/2,1/4,3/4", "1/4,-x,3/4", "1/4,x+1/2,3/4", 

"x,1/4,1/4", "-x+1/2,1/4,1/4", "1/4,x,1/4", "1/4,-x+1/2,1/4", 
"-x,3/4,3/4", "x+1/2,3/4,3/4", "3/4,-x,3/4", "3/4,x+1/2,3/4", 

"x,x,1/4", "-x+1/2,-x+1/2,1/4", "-x+1/2,x,1/4", "x,-x+1/2,1/4", 
"-x,-x,3/4", "x+1/2,x+1/2,3/4", "x+1/2,-x,3/4", "-x,x+1/2,3/4", 

"1/4,3/4,z", "3/4,1/4,z", "1/4,3/4,-z+1/2", "3/4,1/4,-z+1/2", 
"3/4,1/4,-z", "1/4,3/4,-z", "3/4,1/4,z+1/2", "1/4,3/4,z+1/2", 

"0,0,0", "1/2,1/2,0", "1/2,0,0", "0,1/2,0", 
"1/2,0,1/2", "0,1/2,1/2", "0,0,1/2", "1/2,1/2,1/2", 

"1/4,1/4,z", "1/4,1/4,-z+1/2", "3/4,3/4,-z", "3/4,3/4,z+1/2", 

"1/4,3/4,0", "3/4,1/4,0", "1/4,3/4,1/2", "3/4,1/4,1/2", 

"1/4,3/4,3/4", "3/4,1/4,3/4", "3/4,1/4,1/4", "1/4,3/4,1/4", 

"1/4,1/4,3/4", "3/4,3/4,1/4", 

"1/4,1/4,1/4", "3/4,3/4,3/4", 
};

const char *gamgi_phys_symmetry_wyckoff_127 [64] = {
"x,y,z", "-x,-y,z", "-y,x,z", "y,-x,z", 
"-x+1/2,y+1/2,-z", "x+1/2,-y+1/2,-z", "y+1/2,x+1/2,-z", "-y+1/2,-x+1/2,-z", 
"-x,-y,-z", "x,y,-z", "y,-x,-z", "-y,x,-z", 
"x+1/2,-y+1/2,z", "-x+1/2,y+1/2,z", "-y+1/2,-x+1/2,z", "y+1/2,x+1/2,z", 

"x,x+1/2,z", "-x,-x+1/2,z", "-x+1/2,x,z", "x+1/2,-x,z", 
"-x+1/2,x,-z", "x+1/2,-x,-z", "x,x+1/2,-z", "-x,-x+1/2,-z", 

"x,y,1/2", "-x,-y,1/2", "-y,x,1/2", "y,-x,1/2", 
"-x+1/2,y+1/2,1/2", "x+1/2,-y+1/2,1/2", "y+1/2,x+1/2,1/2", "-y+1/2,-x+1/2,1/2", 

"x,y,0", "-x,-y,0", "-y,x,0", "y,-x,0", 
"-x+1/2,y+1/2,0", "x+1/2,-y+1/2,0", "y+1/2,x+1/2,0", "-y+1/2,-x+1/2,0", 

"x,x+1/2,1/2", "-x,-x+1/2,1/2", "-x+1/2,x,1/2", "x+1/2,-x,1/2", 

"x,x+1/2,0", "-x,-x+1/2,0", "-x+1/2,x,0", "x+1/2,-x,0", 

"0,1/2,z", "1/2,0,z", "1/2,0,-z", "0,1/2,-z", 

"0,0,z", "1/2,1/2,-z", "0,0,-z", "1/2,1/2,z", 

"0,1/2,0", "1/2,0,0", 

"0,1/2,1/2", "1/2,0,1/2", 

"0,0,1/2", "1/2,1/2,1/2", 

"0,0,0", "1/2,1/2,0", 
};

const char *gamgi_phys_symmetry_wyckoff_128 [56] = {
"x,y,z", "-x,-y,z", "-y,x,z", "y,-x,z", 
"-x+1/2,y+1/2,-z+1/2", "x+1/2,-y+1/2,-z+1/2", "y+1/2,x+1/2,-z+1/2", "-y+1/2,-x+1/2,-z+1/2", 
"-x,-y,-z", "x,y,-z", "y,-x,-z", "-y,x,-z", 
"x+1/2,-y+1/2,z+1/2", "-x+1/2,y+1/2,z+1/2", "-y+1/2,-x+1/2,z+1/2", "y+1/2,x+1/2,z+1/2", 

"x,y,0", "-x,-y,0", "-y,x,0", "y,-x,0", 
"-x+1/2,y+1/2,1/2", "x+1/2,-y+1/2,1/2", "y+1/2,x+1/2,1/2", "-y+1/2,-x+1/2,1/2", 

"x,x+1/2,1/4", "-x,-x+1/2,1/4", "-x+1/2,x,1/4", "x+1/2,-x,1/4", 
"-x,-x+1/2,3/4", "x,x+1/2,3/4", "x+1/2,-x,3/4", "-x+1/2,x,3/4", 

"0,1/2,z", "1/2,0,z", "1/2,0,-z+1/2", "0,1/2,-z+1/2", 
"0,1/2,-z", "1/2,0,-z", "1/2,0,z+1/2", "0,1/2,z+1/2", 

"0,0,z", "1/2,1/2,-z+1/2", "0,0,-z", "1/2,1/2,z+1/2", 

"0,1/2,1/4", "1/2,0,1/4", "0,1/2,3/4", "1/2,0,3/4", 

"0,1/2,0", "1/2,0,0", "1/2,0,1/2", "0,1/2,1/2", 

"0,0,1/2", "1/2,1/2,0", 

"0,0,0", "1/2,1/2,1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_129 [66] = {
"x,y,z", "-x+1/2,-y+1/2,z", "-y+1/2,x,z", "y,-x+1/2,z", 
"-x,y+1/2,-z", "x+1/2,-y,-z", "y+1/2,x+1/2,-z", "-y,-x,-z", 
"-x,-y,-z", "x+1/2,y+1/2,-z", "y+1/2,-x,-z", "-y,x+1/2,-z", 
"x,-y+1/2,z", "-x+1/2,y,z", "-y+1/2,-x+1/2,z", "y,x,z", 

"x,x,z", "-x+1/2,-x+1/2,z", "-x+1/2,x,z", "x,-x+1/2,z", 
"-x,x+1/2,-z", "x+1/2,-x,-z", "x+1/2,x+1/2,-z", "-x,-x,-z", 

"1/4,y,z", "1/4,-y+1/2,z", "-y+1/2,1/4,z", "y,1/4,z", 
"3/4,y+1/2,-z", "3/4,-y,-z", "y+1/2,3/4,-z", "-y,3/4,-z", 

"x,-x,1/2", "-x+1/2,x+1/2,1/2", "x+1/2,x,1/2", "-x,-x+1/2,1/2", 
"-x,x,1/2", "x+1/2,-x+1/2,1/2", "-x+1/2,-x,1/2", "x,x+1/2,1/2", 

"x,-x,0", "-x+1/2,x+1/2,0", "x+1/2,x,0", "-x,-x+1/2,0", 
"-x,x,0", "x+1/2,-x+1/2,0", "-x+1/2,-x,0", "x,x+1/2,0", 

"3/4,1/4,z", "1/4,3/4,z", "1/4,3/4,-z", "3/4,1/4,-z", 

"0,0,1/2", "1/2,1/2,1/2", "1/2,0,1/2", "0,1/2,1/2", 

"0,0,0", "1/2,1/2,0", "1/2,0,0", "0,1/2,0", 

"1/4,1/4,z", "3/4,3/4,-z", 

"3/4,1/4,1/2", "1/4,3/4,1/2", 

"3/4,1/4,0", "1/4,3/4,0", 
};

const char *gamgi_phys_symmetry_wyckoff_130 [52] = {
"x,y,z", "-x+1/2,-y+1/2,z", "-y+1/2,x,z", "y,-x+1/2,z", 
"-x,y+1/2,-z+1/2", "x+1/2,-y,-z+1/2", "y+1/2,x+1/2,-z+1/2", "-y,-x,-z+1/2", 
"-x,-y,-z", "x+1/2,y+1/2,-z", "y+1/2,-x,-z", "-y,x+1/2,-z", 
"x,-y+1/2,z+1/2", "-x+1/2,y,z+1/2", "-y+1/2,-x+1/2,z+1/2", "y,x,z+1/2", 

"x,-x,1/4", "-x+1/2,x+1/2,1/4", "x+1/2,x,1/4", "-x,-x+1/2,1/4", 
"-x,x,3/4", "x+1/2,-x+1/2,3/4", "-x+1/2,-x,3/4", "x,x+1/2,3/4", 

"3/4,1/4,z", "1/4,3/4,z", "1/4,3/4,-z+1/2", "3/4,1/4,-z+1/2", 
"1/4,3/4,-z", "3/4,1/4,-z", "3/4,1/4,z+1/2", "1/4,3/4,z+1/2", 

"0,0,0", "1/2,1/2,0", "1/2,0,0", "0,1/2,0", 
"0,1/2,1/2", "1/2,0,1/2", "1/2,1/2,1/2", "0,0,1/2", 

"1/4,1/4,z", "3/4,3/4,-z+1/2", "3/4,3/4,-z", "1/4,1/4,z+1/2", 

"3/4,1/4,0", "1/4,3/4,0", "1/4,3/4,1/2", "3/4,1/4,1/2", 

"3/4,1/4,1/4", "1/4,3/4,1/4", "1/4,3/4,3/4", "3/4,1/4,3/4", 
};

const char *gamgi_phys_symmetry_wyckoff_131 [88] = {
"x,y,z", "-x,-y,z", "-y,x,z+1/2", "y,-x,z+1/2", 
"-x,y,-z", "x,-y,-z", "y,x,-z+1/2", "-y,-x,-z+1/2", 
"-x,-y,-z", "x,y,-z", "y,-x,-z+1/2", "-y,x,-z+1/2", 
"x,-y,z", "-x,y,z", "-y,-x,z+1/2", "y,x,z+1/2", 

"x,y,0", "-x,-y,0", "-y,x,1/2", "y,-x,1/2", 
"-x,y,0", "x,-y,0", "y,x,1/2", "-y,-x,1/2", 

"1/2,y,z", "1/2,-y,z", "-y,1/2,z+1/2", "y,1/2,z+1/2", 
"1/2,y,-z", "1/2,-y,-z", "y,1/2,-z+1/2", "-y,1/2,-z+1/2", 

"0,y,z", "0,-y,z", "-y,0,z+1/2", "y,0,z+1/2", 
"0,y,-z", "0,-y,-z", "y,0,-z+1/2", "-y,0,-z+1/2", 

"x,x,1/4", "-x,-x,1/4", "-x,x,3/4", "x,-x,3/4", 
"-x,-x,3/4", "x,x,3/4", "x,-x,1/4", "-x,x,1/4", 

"x,1/2,0", "-x,1/2,0", "1/2,x,1/2", "1/2,-x,1/2", 

"x,0,1/2", "-x,0,1/2", "0,x,0", "0,-x,0", 

"x,1/2,1/2", "-x,1/2,1/2", "1/2,x,0", "1/2,-x,0", 

"x,0,0", "-x,0,0", "0,x,1/2", "0,-x,1/2", 

"0,1/2,z", "1/2,0,z+1/2", "0,1/2,-z", "1/2,0,-z+1/2", 

"1/2,1/2,z", "1/2,1/2,z+1/2", "1/2,1/2,-z", "1/2,1/2,-z+1/2", 

"0,0,z", "0,0,z+1/2", "0,0,-z", "0,0,-z+1/2", 

"1/2,1/2,1/4", "1/2,1/2,3/4", 

"0,0,1/4", "0,0,3/4", 

"0,1/2,1/2", "1/2,0,0", 

"0,1/2,0", "1/2,0,1/2", 

"1/2,1/2,0", "1/2,1/2,1/2", 

"0,0,0", "0,0,1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_132 [88] = {
"x,y,z", "-x,-y,z", "-y,x,z+1/2", "y,-x,z+1/2", 
"-x,y,-z+1/2", "x,-y,-z+1/2", "y,x,-z", "-y,-x,-z", 
"-x,-y,-z", "x,y,-z", "y,-x,-z+1/2", "-y,x,-z+1/2", 
"x,-y,z+1/2", "-x,y,z+1/2", "-y,-x,z", "y,x,z", 

"x,x,z", "-x,-x,z", "-x,x,z+1/2", "x,-x,z+1/2", 
"-x,x,-z+1/2", "x,-x,-z+1/2", "x,x,-z", "-x,-x,-z", 

"x,y,0", "-x,-y,0", "-y,x,1/2", "y,-x,1/2", 
"-x,y,1/2", "x,-y,1/2", "y,x,0", "-y,-x,0", 

"x,1/2,1/4", "-x,1/2,1/4", "1/2,x,3/4", "1/2,-x,3/4", 
"-x,1/2,3/4", "x,1/2,3/4", "1/2,-x,1/4", "1/2,x,1/4", 

"x,0,1/4", "-x,0,1/4", "0,x,3/4", "0,-x,3/4", 
"-x,0,3/4", "x,0,3/4", "0,-x,1/4", "0,x,1/4", 

"0,1/2,z", "1/2,0,z+1/2", "0,1/2,-z+1/2", "1/2,0,-z", 
"0,1/2,-z", "1/2,0,-z+1/2", "0,1/2,z+1/2", "1/2,0,z", 

"x,x,1/2", "-x,-x,1/2", "-x,x,0", "x,-x,0", 

"x,x,0", "-x,-x,0", "-x,x,1/2", "x,-x,1/2", 

"1/2,1/2,z", "1/2,1/2,z+1/2", "1/2,1/2,-z+1/2", "1/2,1/2,-z", 

"0,0,z", "0,0,z+1/2", "0,0,-z+1/2", "0,0,-z", 

"0,1/2,0", "1/2,0,1/2", "0,1/2,1/2", "1/2,0,0", 

"0,1/2,1/4", "1/2,0,3/4", "0,1/2,3/4", "1/2,0,1/4", 

"1/2,1/2,1/4", "1/2,1/2,3/4", 

"1/2,1/2,0", "1/2,1/2,1/2", 

"0,0,1/4", "0,0,3/4", 

"0,0,0", "0,0,1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_133 [80] = {
"x,y,z", "-x+1/2,-y+1/2,z", "-y+1/2,x,z+1/2", "y,-x+1/2,z+1/2", 
"-x+1/2,y,-z", "x,-y+1/2,-z", "y,x,-z+1/2", "-y+1/2,-x+1/2,-z+1/2", 
"-x,-y,-z", "x+1/2,y+1/2,-z", "y+1/2,-x,-z+1/2", "-y,x+1/2,-z+1/2", 
"x+1/2,-y,z", "-x,y+1/2,z", "-y,-x,z+1/2", "y+1/2,x+1/2,z+1/2", 

"x,x,1/4", "-x+1/2,-x+1/2,1/4", "-x+1/2,x,3/4", "x,-x+1/2,3/4", 
"-x,-x,3/4", "x+1/2,x+1/2,3/4", "x+1/2,-x,1/4", "-x,x+1/2,1/4", 

"x,1/4,1/2", "-x+1/2,1/4,1/2", "1/4,x,0", "1/4,-x+1/2,0", 
"-x,3/4,1/2", "x+1/2,3/4,1/2", "3/4,-x,0", "3/4,x+1/2,0", 

"x,1/4,0", "-x+1/2,1/4,0", "1/4,x,1/2", "1/4,-x+1/2,1/2", 
"-x,3/4,0", "x+1/2,3/4,0", "3/4,-x,1/2", "3/4,x+1/2,1/2", 

"3/4,1/4,z", "1/4,3/4,z+1/2", "3/4,1/4,-z", "1/4,3/4,-z+1/2", 
"1/4,3/4,-z", "3/4,1/4,-z+1/2", "1/4,3/4,z", "3/4,1/4,z+1/2", 

"1/4,1/4,z", "1/4,1/4,z+1/2", "1/4,1/4,-z", "1/4,1/4,-z+1/2", 
"3/4,3/4,-z", "3/4,3/4,-z+1/2", "3/4,3/4,z", "3/4,3/4,z+1/2", 

"0,0,0", "1/2,1/2,0", "1/2,0,1/2", "0,1/2,1/2", 
"1/2,0,0", "0,1/2,0", "0,0,1/2", "1/2,1/2,1/2", 

"3/4,1/4,3/4", "1/4,3/4,1/4", "3/4,1/4,1/4", "1/4,3/4,3/4", 

"1/4,1/4,1/4", "1/4,1/4,3/4", "3/4,3/4,3/4", "3/4,3/4,1/4", 

"3/4,1/4,0", "1/4,3/4,1/2", "1/4,3/4,0", "3/4,1/4,1/2", 

"1/4,1/4,0", "1/4,1/4,1/2", "3/4,3/4,0", "3/4,3/4,1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_134 [88] = {
"x,y,z", "-x+1/2,-y+1/2,z", "-y+1/2,x,z+1/2", "y,-x+1/2,z+1/2", 
"-x+1/2,y,-z+1/2", "x,-y+1/2,-z+1/2", "y,x,-z", "-y+1/2,-x+1/2,-z", 
"-x,-y,-z", "x+1/2,y+1/2,-z", "y+1/2,-x,-z+1/2", "-y,x+1/2,-z+1/2", 
"x+1/2,-y,z+1/2", "-x,y+1/2,z+1/2", "-y,-x,z", "y+1/2,x+1/2,z", 

"x,-x,z", "-x+1/2,x+1/2,z", "x+1/2,x,z+1/2", "-x,-x+1/2,z+1/2", 
"-x+1/2,-x,-z+1/2", "x,x+1/2,-z+1/2", "-x,x,-z", "x+1/2,-x+1/2,-z", 

"x,x,1/2", "-x+1/2,-x+1/2,1/2", "-x+1/2,x,0", "x,-x+1/2,0", 
"-x,-x,1/2", "x+1/2,x+1/2,1/2", "x+1/2,-x,0", "-x,x+1/2,0", 

"x,x,0", "-x+1/2,-x+1/2,0", "-x+1/2,x,1/2", "x,-x+1/2,1/2", 
"-x,-x,0", "x+1/2,x+1/2,0", "x+1/2,-x,1/2", "-x,x+1/2,1/2", 

"x,1/4,1/4", "-x+1/2,1/4,1/4", "1/4,x,3/4", "1/4,-x+1/2,3/4", 
"-x,3/4,3/4", "x+1/2,3/4,3/4", "3/4,-x,1/4", "3/4,x+1/2,1/4", 

"x,1/4,3/4", "-x+1/2,1/4,3/4", "1/4,x,1/4", "1/4,-x+1/2,1/4", 
"-x,3/4,1/4", "x+1/2,3/4,1/4", "3/4,-x,3/4", "3/4,x+1/2,3/4", 

"1/4,1/4,z", "1/4,1/4,z+1/2", "1/4,1/4,-z+1/2", "1/4,1/4,-z", 
"3/4,3/4,-z", "3/4,3/4,-z+1/2", "3/4,3/4,z+1/2", "3/4,3/4,z", 

"3/4,1/4,z", "1/4,3/4,z+1/2", "3/4,1/4,-z+1/2", "1/4,3/4,-z", 

"0,0,0", "1/2,1/2,0", "1/2,0,1/2", "0,1/2,1/2", 

"0,0,1/2", "1/2,1/2,1/2", "1/2,0,0", "0,1/2,0", 

"1/4,1/4,0", "1/4,1/4,1/2", "3/4,3/4,0", "3/4,3/4,1/2", 

"1/4,1/4,1/4", "1/4,1/4,3/4", "3/4,3/4,3/4", "3/4,3/4,1/4", 

"3/4,1/4,1/4", "1/4,3/4,3/4", 

"1/4,3/4,1/4", "3/4,1/4,3/4", 
};

const char *gamgi_phys_symmetry_wyckoff_135 [64] = {
"x,y,z", "-x,-y,z", "-y,x,z+1/2", "y,-x,z+1/2", 
"-x+1/2,y+1/2,-z", "x+1/2,-y+1/2,-z", "y+1/2,x+1/2,-z+1/2", "-y+1/2,-x+1/2,-z+1/2", 
"-x,-y,-z", "x,y,-z", "y,-x,-z+1/2", "-y,x,-z+1/2", 
"x+1/2,-y+1/2,z", "-x+1/2,y+1/2,z", "-y+1/2,-x+1/2,z+1/2", "y+1/2,x+1/2,z+1/2", 

"x,y,0", "-x,-y,0", "-y,x,1/2", "y,-x,1/2", 
"-x+1/2,y+1/2,0", "x+1/2,-y+1/2,0", "y+1/2,x+1/2,1/2", "-y+1/2,-x+1/2,1/2", 

"x,x+1/2,1/4", "-x,-x+1/2,1/4", "-x+1/2,x,3/4", "x+1/2,-x,3/4", 
"-x,-x+1/2,3/4", "x,x+1/2,3/4", "x+1/2,-x,1/4", "-x+1/2,x,1/4", 

"0,1/2,z", "1/2,0,z+1/2", "1/2,0,-z", "0,1/2,-z+1/2", 
"0,1/2,-z", "1/2,0,-z+1/2", "1/2,0,z", "0,1/2,z+1/2", 

"0,0,z", "0,0,z+1/2", "1/2,1/2,-z", "1/2,1/2,-z+1/2", 
"0,0,-z", "0,0,-z+1/2", "1/2,1/2,z", "1/2,1/2,z+1/2", 

"0,1/2,1/4", "1/2,0,3/4", "0,1/2,3/4", "1/2,0,1/4", 

"0,1/2,0", "1/2,0,1/2", "1/2,0,0", "0,1/2,1/2", 

"0,0,1/4", "0,0,3/4", "1/2,1/2,3/4", "1/2,1/2,1/4", 

"0,0,0", "0,0,1/2", "1/2,1/2,0", "1/2,1/2,1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_136 [64] = {
"x,y,z", "-x,-y,z", "-y+1/2,x+1/2,z+1/2", "y+1/2,-x+1/2,z+1/2", 
"-x+1/2,y+1/2,-z+1/2", "x+1/2,-y+1/2,-z+1/2", "y,x,-z", "-y,-x,-z", 
"-x,-y,-z", "x,y,-z", "y+1/2,-x+1/2,-z+1/2", "-y+1/2,x+1/2,-z+1/2", 
"x+1/2,-y+1/2,z+1/2", "-x+1/2,y+1/2,z+1/2", "-y,-x,z", "y,x,z", 

"x,x,z", "-x,-x,z", "-x+1/2,x+1/2,z+1/2", "x+1/2,-x+1/2,z+1/2", 
"-x+1/2,x+1/2,-z+1/2", "x+1/2,-x+1/2,-z+1/2", "x,x,-z", "-x,-x,-z", 

"x,y,0", "-x,-y,0", "-y+1/2,x+1/2,1/2", "y+1/2,-x+1/2,1/2", 
"-x+1/2,y+1/2,1/2", "x+1/2,-y+1/2,1/2", "y,x,0", "-y,-x,0", 

"0,1/2,z", "0,1/2,z+1/2", "1/2,0,-z+1/2", "1/2,0,-z", 
"0,1/2,-z", "0,1/2,-z+1/2", "1/2,0,z+1/2", "1/2,0,z", 

"x,-x,0", "-x,x,0", "x+1/2,x+1/2,1/2", "-x+1/2,-x+1/2,1/2", 

"x,x,0", "-x,-x,0", "-x+1/2,x+1/2,1/2", "x+1/2,-x+1/2,1/2", 

"0,0,z", "1/2,1/2,z+1/2", "1/2,1/2,-z+1/2", "0,0,-z", 

"0,1/2,1/4", "0,1/2,3/4", "1/2,0,1/4", "1/2,0,3/4", 

"0,1/2,0", "0,1/2,1/2", "1/2,0,1/2", "1/2,0,0", 

"0,0,1/2", "1/2,1/2,0", 

"0,0,0", "1/2,1/2,1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_137 [52] = {
"x,y,z", "-x+1/2,-y+1/2,z", "-y+1/2,x,z+1/2", "y,-x+1/2,z+1/2", 
"-x,y+1/2,-z", "x+1/2,-y,-z", "y+1/2,x+1/2,-z+1/2", "-y,-x,-z+1/2", 
"-x,-y,-z", "x+1/2,y+1/2,-z", "y+1/2,-x,-z+1/2", "-y,x+1/2,-z+1/2", 
"x,-y+1/2,z", "-x+1/2,y,z", "-y+1/2,-x+1/2,z+1/2", "y,x,z+1/2", 

"1/4,y,z", "1/4,-y+1/2,z", "-y+1/2,1/4,z+1/2", "y,1/4,z+1/2", 
"3/4,y+1/2,-z", "3/4,-y,-z", "y+1/2,3/4,-z+1/2", "-y,3/4,-z+1/2", 

"x,-x,1/4", "-x+1/2,x+1/2,1/4", "x+1/2,x,3/4", "-x,-x+1/2,3/4", 
"-x,x,3/4", "x+1/2,-x+1/2,3/4", "-x+1/2,-x,1/4", "x,x+1/2,1/4", 

"0,0,0", "1/2,1/2,0", "1/2,0,1/2", "0,1/2,1/2", 
"0,1/2,0", "1/2,0,0", "1/2,1/2,1/2", "0,0,1/2", 

"1/4,1/4,z", "1/4,1/4,z+1/2", "3/4,3/4,-z", "3/4,3/4,-z+1/2", 

"3/4,1/4,z", "1/4,3/4,z+1/2", "1/4,3/4,-z", "3/4,1/4,-z+1/2", 

"3/4,1/4,1/4", "1/4,3/4,3/4", 

"3/4,1/4,3/4", "1/4,3/4,1/4", 
};

const char *gamgi_phys_symmetry_wyckoff_138 [68] = {
"x,y,z", "-x+1/2,-y+1/2,z", "-y+1/2,x,z+1/2", "y,-x+1/2,z+1/2", 
"-x,y+1/2,-z+1/2", "x+1/2,-y,-z+1/2", "y+1/2,x+1/2,-z", "-y,-x,-z", 
"-x,-y,-z", "x+1/2,y+1/2,-z", "y+1/2,-x,-z+1/2", "-y,x+1/2,-z+1/2", 
"x,-y+1/2,z+1/2", "-x+1/2,y,z+1/2", "-y+1/2,-x+1/2,z", "y,x,z", 

"x,x,z", "-x+1/2,-x+1/2,z", "-x+1/2,x,z+1/2", "x,-x+1/2,z+1/2", 
"-x,x+1/2,-z+1/2", "x+1/2,-x,-z+1/2", "x+1/2,x+1/2,-z", "-x,-x,-z", 

"x,-x,0", "-x+1/2,x+1/2,0", "x+1/2,x,1/2", "-x,-x+1/2,1/2", 
"-x,x,0", "x+1/2,-x+1/2,0", "-x+1/2,-x,1/2", "x,x+1/2,1/2", 

"x,-x,1/2", "-x+1/2,x+1/2,1/2", "x+1/2,x,0", "-x,-x+1/2,0", 
"-x,x,1/2", "x+1/2,-x+1/2,1/2", "-x+1/2,-x,0", "x,x+1/2,0", 

"3/4,1/4,z", "1/4,3/4,z+1/2", "1/4,3/4,-z+1/2", "3/4,1/4,-z", 
"1/4,3/4,-z", "3/4,1/4,-z+1/2", "3/4,1/4,z+1/2", "1/4,3/4,z", 

"1/4,1/4,z", "1/4,1/4,z+1/2", "3/4,3/4,-z+1/2", "3/4,3/4,-z", 

"0,0,0", "1/2,1/2,0", "1/2,0,1/2", "0,1/2,1/2", 

"0,0,1/2", "1/2,1/2,1/2", "1/2,0,0", "0,1/2,0", 

"3/4,1/4,3/4", "1/4,3/4,1/4", "1/4,3/4,3/4", "3/4,1/4,1/4", 

"3/4,1/4,0", "1/4,3/4,1/2", "1/4,3/4,0", "3/4,1/4,1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_139 [76] = {
"x,y,z", "-x,-y,z", "-y,x,z", "y,-x,z", 
"-x,y,-z", "x,-y,-z", "y,x,-z", "-y,-x,-z", 
"-x,-y,-z", "x,y,-z", "y,-x,-z", "-y,x,-z", 
"x,-y,z", "-x,y,z", "-y,-x,z", "y,x,z", 

"0,y,z", "0,-y,z", "-y,0,z", "y,0,z", 
"0,y,-z", "0,-y,-z", "y,0,-z", "-y,0,-z", 

"x,x,z", "-x,-x,z", "-x,x,z", "x,-x,z", 
"-x,x,-z", "x,-x,-z", "x,x,-z", "-x,-x,-z", 

"x,y,0", "-x,-y,0", "-y,x,0", "y,-x,0", 
"-x,y,0", "x,-y,0", "y,x,0", "-y,-x,0", 

"x,x+1/2,1/4", "-x,-x+1/2,1/4", "-x+1/2,x,1/4", "x+1/2,-x,1/4", 
"-x,-x+1/2,3/4", "x,x+1/2,3/4", "x+1/2,-x,3/4", "-x+1/2,x,3/4", 

"x,1/2,0", "-x,1/2,0", "1/2,x,0", "1/2,-x,0", 

"x,0,0", "-x,0,0", "0,x,0", "0,-x,0", 

"x,x,0", "-x,-x,0", "-x,x,0", "x,-x,0", 

"0,1/2,z", "1/2,0,z", "0,1/2,-z", "1/2,0,-z", 

"1/4,1/4,1/4", "3/4,3/4,1/4", "3/4,1/4,1/4", "1/4,3/4,1/4", 

"0,0,z", "0,0,-z", 

"0,1/2,1/4", "1/2,0,1/4", 

"0,1/2,0", "1/2,0,0", 

"0,0,1/2", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_140 [72] = {
"x,y,z", "-x,-y,z", "-y,x,z", "y,-x,z", 
"-x,y,-z+1/2", "x,-y,-z+1/2", "y,x,-z+1/2", "-y,-x,-z+1/2", 
"-x,-y,-z", "x,y,-z", "y,-x,-z", "-y,x,-z", 
"x,-y,z+1/2", "-x,y,z+1/2", "-y,-x,z+1/2", "y,x,z+1/2", 

"x,x+1/2,z", "-x,-x+1/2,z", "-x+1/2,x,z", "x+1/2,-x,z", 
"-x,x+1/2,-z+1/2", "x,-x+1/2,-z+1/2", "x+1/2,x,-z+1/2", "-x+1/2,-x,-z+1/2", 

"x,y,0", "-x,-y,0", "-y,x,0", "y,-x,0", 
"-x,y,1/2", "x,-y,1/2", "y,x,1/2", "-y,-x,1/2", 

"x,0,1/4", "-x,0,1/4", "0,x,1/4", "0,-x,1/4", 
"-x,0,3/4", "x,0,3/4", "0,-x,3/4", "0,x,3/4", 

"x,x,1/4", "-x,-x,1/4", "-x,x,1/4", "x,-x,1/4", 
"-x,-x,3/4", "x,x,3/4", "x,-x,3/4", "-x,x,3/4", 

"x,x+1/2,0", "-x,-x+1/2,0", "-x+1/2,x,0", "x+1/2,-x,0", 

"0,1/2,z", "1/2,0,z", "0,1/2,-z+1/2", "1/2,0,-z+1/2", 

"0,0,z", "0,0,-z+1/2", "0,0,-z", "0,0,z+1/2", 

"1/4,1/4,1/4", "3/4,3/4,1/4", "3/4,1/4,1/4", "1/4,3/4,1/4", 

"0,1/2,0", "1/2,0,0", 

"0,0,0", "0,0,1/2", 

"0,1/2,1/4", "1/2,0,1/4", 

"0,0,1/4", "0,0,3/4", 
};

const char *gamgi_phys_symmetry_wyckoff_141 [56] = {
"x,y,z", "-x+1/2,-y,z+1/2", "-y+1/4,x+3/4,z+1/4", "y+1/4,-x+1/4,z+3/4", 
"-x+1/2,y,-z+1/2", "x,-y,-z", "y+1/4,x+3/4,-z+1/4", "-y+1/4,-x+1/4,-z+3/4", 
"-x,-y,-z", "x+1/2,y,-z+1/2", "y+3/4,-x+1/4,-z+3/4", "-y+3/4,x+3/4,-z+1/4", 
"x+1/2,-y,z+1/2", "-x,y,z", "-y+3/4,-x+1/4,z+3/4", "y+3/4,x+3/4,z+1/4", 

"0,y,z", "1/2,-y,z+1/2", "-y+1/4,3/4,z+1/4", "y+1/4,1/4,z+3/4", 
"1/2,y,-z+1/2", "0,-y,-z", "y+1/4,3/4,-z+1/4", "-y+1/4,1/4,-z+3/4", 

"x,x+1/4,7/8", "-x+1/2,-x+3/4,3/8", "-x,x+3/4,1/8", "x+1/2,-x+1/4,5/8", 
"-x,-x+3/4,1/8", "x+1/2,x+1/4,5/8", "x,-x+1/4,7/8", "-x+1/2,x+3/4,3/8", 

"x,0,0", "-x+1/2,0,1/2", "1/4,x+3/4,1/4", "1/4,-x+1/4,3/4", 
"-x,0,0", "x+1/2,0,1/2", "3/4,-x+1/4,3/4", "3/4,x+3/4,1/4", 

"0,1/4,z", "0,3/4,z+1/4", "1/2,1/4,-z+1/2", "1/2,3/4,-z+1/4", 

"0,0,1/2", "1/2,0,0", "1/4,3/4,3/4", "1/4,1/4,1/4", 

"0,0,0", "1/2,0,1/2", "1/4,3/4,1/4", "1/4,1/4,3/4", 

"0,1/4,3/8", "0,3/4,5/8", 

"0,3/4,1/8", "1/2,3/4,3/8", 
};

const char *gamgi_phys_symmetry_wyckoff_142 [56] = {
"x,y,z", "-x+1/2,-y,z+1/2", "-y+1/4,x+3/4,z+1/4", "y+1/4,-x+1/4,z+3/4", 
"-x+1/2,y,-z", "x,-y,-z+1/2", "y+1/4,x+3/4,-z+3/4", "-y+1/4,-x+1/4,-z+1/4", 
"-x,-y,-z", "x+1/2,y,-z+1/2", "y+3/4,-x+1/4,-z+3/4", "-y+3/4,x+3/4,-z+1/4", 
"x+1/2,-y,z", "-x,y,z+1/2", "-y+3/4,-x+1/4,z+1/4", "y+3/4,x+3/4,z+3/4", 

"x,x+1/4,1/8", "-x+1/2,-x+3/4,5/8", "-x,x+3/4,3/8", "x+1/2,-x+1/4,7/8", 
"-x,-x+3/4,7/8", "x+1/2,x+1/4,3/8", "x,-x+1/4,5/8", "-x+1/2,x+3/4,1/8", 

"x,0,1/4", "-x+1/2,0,3/4", "1/4,x+3/4,1/2", "1/4,-x+1/4,0", 
"-x,0,3/4", "x+1/2,0,1/4", "3/4,-x+1/4,1/2", "3/4,x+3/4,0", 

"0,1/4,z", "0,3/4,z+1/4", "1/2,1/4,-z", "1/2,3/4,-z+3/4", 
"0,3/4,-z", "0,1/4,-z+3/4", "1/2,3/4,z", "1/2,1/4,z+1/4", 

"0,0,0", "1/2,0,1/2", "1/4,3/4,1/4", "1/4,1/4,3/4", 
"1/2,0,0", "0,0,1/2", "1/4,3/4,3/4", "1/4,1/4,1/4", 

"0,1/4,1/8", "0,3/4,3/8", "0,3/4,7/8", "0,1/4,5/8", 

"0,1/4,3/8", "0,3/4,5/8", "1/2,1/4,5/8", "1/2,3/4,3/8", 
};

const char *gamgi_phys_symmetry_wyckoff_143 [6] = {
"x,y,z", "-y,x-y,z", "-x+y,-x,z", 

"2/3,1/3,z", 

"1/3,2/3,z", 

"0,0,z", 
};

const char *gamgi_phys_symmetry_wyckoff_144 [3] = {
"x,y,z", "-y,x-y,z+1/3", "-x+y,-x,z+2/3", 
};

const char *gamgi_phys_symmetry_wyckoff_145 [3] = {
"x,y,z", "-y,x-y,z+2/3", "-x+y,-x,z+1/3", 
};

const char *gamgi_phys_symmetry_wyckoff_146 [4] = {
"x,y,z", "-y,x-y,z", "-x+y,-x,z", 

"0,0,z", 
};

const char *gamgi_phys_symmetry_wyckoff_147 [18] = {
"x,y,z", "-y,x-y,z", "-x+y,-x,z", 
"-x,-y,-z", "y,-x+y,-z", "x-y,x,-z", 

"1/2,0,1/2", "0,1/2,1/2", "1/2,1/2,1/2", 

"1/2,0,0", "0,1/2,0", "1/2,1/2,0", 

"1/3,2/3,z", "2/3,1/3,-z", 

"0,0,z", "0,0,-z", 

"0,0,1/2", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_148 [16] = {
"x,y,z", "-y,x-y,z", "-x+y,-x,z", 
"-x,-y,-z", "y,-x+y,-z", "x-y,x,-z", 

"1/2,0,0", "0,1/2,0", "1/2,1/2,0", 

"1/2,0,1/2", "0,1/2,1/2", "1/2,1/2,1/2", 

"0,0,z", "0,0,-z", 

"0,0,1/2", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_149 [24] = {
"x,y,z", "-y,x-y,z", "-x+y,-x,z", 
"-y,-x,-z", "-x+y,y,-z", "x,x-y,-z", 

"x,-x,1/2", "x,2x,1/2", "-2x,-x,1/2", 

"x,-x,0", "x,2x,0", "-2x,-x,0", 

"2/3,1/3,z", "2/3,1/3,-z", 

"1/3,2/3,z", "1/3,2/3,-z", 

"0,0,z", "0,0,-z", 

"2/3,1/3,1/2", 

"2/3,1/3,0", 

"1/3,2/3,1/2", 

"1/3,2/3,0", 

"0,0,1/2", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_150 [18] = {
"x,y,z", "-y,x-y,z", "-x+y,-x,z", 
"y,x,-z", "x-y,-y,-z", "-x,-x+y,-z", 

"x,0,1/2", "0,x,1/2", "-x,-x,1/2", 

"x,0,0", "0,x,0", "-x,-x,0", 

"1/3,2/3,z", "2/3,1/3,-z", 

"0,0,z", "0,0,-z", 

"0,0,1/2", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_151 [12] = {
"x,y,z", "-y,x-y,z+1/3", "-x+y,-x,z+2/3", 
"-y,-x,-z+2/3", "-x+y,y,-z+1/3", "x,x-y,-z", 

"x,-x,5/6", "x,2x,1/6", "-2x,-x,1/2", 

"x,-x,1/3", "x,2x,2/3", "-2x,-x,0", 
};

const char *gamgi_phys_symmetry_wyckoff_152 [12] = {
"x,y,z", "-y,x-y,z+1/3", "-x+y,-x,z+2/3", 
"y,x,-z", "x-y,-y,-z+2/3", "-x,-x+y,-z+1/3", 

"x,0,5/6", "0,x,1/6", "-x,-x,1/2", 

"x,0,1/3", "0,x,2/3", "-x,-x,0", 
};

const char *gamgi_phys_symmetry_wyckoff_153 [12] = {
"x,y,z", "-y,x-y,z+2/3", "-x+y,-x,z+1/3", 
"-y,-x,-z+1/3", "-x+y,y,-z+2/3", "x,x-y,-z", 

"x,-x,1/6", "x,2x,5/6", "-2x,-x,1/2", 

"x,-x,2/3", "x,2x,1/3", "-2x,-x,0", 
};

const char *gamgi_phys_symmetry_wyckoff_154 [12] = {
"x,y,z", "-y,x-y,z+2/3", "-x+y,-x,z+1/3", 
"y,x,-z", "x-y,-y,-z+1/3", "-x,-x+y,-z+2/3", 

"x,0,1/6", "0,x,5/6", "-x,-x,1/2", 

"x,0,2/3", "0,x,1/3", "-x,-x,0", 
};

const char *gamgi_phys_symmetry_wyckoff_155 [16] = {
"x,y,z", "-y,x-y,z", "-x+y,-x,z", 
"y,x,-z", "x-y,-y,-z", "-x,-x+y,-z", 

"x,0,1/2", "0,x,1/2", "-x,-x,1/2", 

"x,0,0", "0,x,0", "-x,-x,0", 

"0,0,z", "0,0,-z", 

"0,0,1/2", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_156 [12] = {
"x,y,z", "-y,x-y,z", "-x+y,-x,z", 
"-y,-x,z", "-x+y,y,z", "x,x-y,z", 

"x,-x,z", "x,2x,z", "-2x,-x,z", 

"2/3,1/3,z", 

"1/3,2/3,z", 

"0,0,z", 
};

const char *gamgi_phys_symmetry_wyckoff_157 [12] = {
"x,y,z", "-y,x-y,z", "-x+y,-x,z", 
"y,x,z", "x-y,-y,z", "-x,-x+y,z", 

"x,0,z", "0,x,z", "-x,-x,z", 

"1/3,2/3,z", "2/3,1/3,z", 

"0,0,z", 
};

const char *gamgi_phys_symmetry_wyckoff_158 [12] = {
"x,y,z", "-y,x-y,z", "-x+y,-x,z", 
"-y,-x,z+1/2", "-x+y,y,z+1/2", "x,x-y,z+1/2", 

"2/3,1/3,z", "2/3,1/3,z+1/2", 

"1/3,2/3,z", "1/3,2/3,z+1/2", 

"0,0,z", "0,0,z+1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_159 [10] = {
"x,y,z", "-y,x-y,z", "-x+y,-x,z", 
"y,x,z+1/2", "x-y,-y,z+1/2", "-x,-x+y,z+1/2", 

"1/3,2/3,z", "2/3,1/3,z+1/2", 

"0,0,z", "0,0,z+1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_160 [10] = {
"x,y,z", "-y,x-y,z", "-x+y,-x,z", 
"-y,-x,z", "-x+y,y,z", "x,x-y,z", 

"x,-x,z", "x,2x,z", "-2x,-x,z", 

"0,0,z", 
};

const char *gamgi_phys_symmetry_wyckoff_161 [8] = {
"x,y,z", "-y,x-y,z", "-x+y,-x,z", 
"-y,-x,z+1/2", "-x+y,y,z+1/2", "x,x-y,z+1/2", 

"0,0,z", "0,0,z+1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_162 [48] = {
"x,y,z", "-y,x-y,z", "-x+y,-x,z", 
"-y,-x,-z", "-x+y,y,-z", "x,x-y,-z", 
"-x,-y,-z", "y,-x+y,-z", "x-y,x,-z", 
"y,x,z", "x-y,-y,z", "-x,-x+y,z", 

"x,0,z", "0,x,z", "-x,-x,z", "0,-x,-z", "-x,0,-z", "x,x,-z", 

"x,-x,1/2", "x,2x,1/2", "-2x,-x,1/2", "-x,x,1/2", "-x,-2x,1/2", "2x,x,1/2", 

"x,-x,0", "x,2x,0", "-2x,-x,0", "-x,x,0", "-x,-2x,0", "2x,x,0", 

"1/3,2/3,z", "1/3,2/3,-z", "2/3,1/3,-z", "2/3,1/3,z", 

"1/2,0,1/2", "0,1/2,1/2", "1/2,1/2,1/2", 

"1/2,0,0", "0,1/2,0", "1/2,1/2,0", 

"0,0,z", "0,0,-z", 

"1/3,2/3,1/2", "2/3,1/3,1/2", 

"1/3,2/3,0", "2/3,1/3,0", 

"0,0,1/2", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_163 [40] = {
"x,y,z", "-y,x-y,z", "-x+y,-x,z", 
"-y,-x,-z+1/2", "-x+y,y,-z+1/2", "x,x-y,-z+1/2", 
"-x,-y,-z", "y,-x+y,-z", "x-y,x,-z", 
"y,x,z+1/2", "x-y,-y,z+1/2", "-x,-x+y,z+1/2", 

"x,-x,1/4", "x,2x,1/4", "-2x,-x,1/4", "-x,x,3/4", "-x,-2x,3/4", "2x,x,3/4", 

"1/2,0,0", "0,1/2,0", "1/2,1/2,0", "0,1/2,1/2", "1/2,0,1/2", "1/2,1/2,1/2", 

"1/3,2/3,z", "1/3,2/3,-z+1/2", "2/3,1/3,-z", "2/3,1/3,z+1/2", 

"0,0,z", "0,0,-z+1/2", "0,0,-z", "0,0,z+1/2", 

"2/3,1/3,1/4", "1/3,2/3,3/4", 

"1/3,2/3,1/4", "2/3,1/3,3/4", 

"0,0,0", "0,0,1/2", 

"0,0,1/4", "0,0,3/4", 
};

const char *gamgi_phys_symmetry_wyckoff_164 [42] = {
"x,y,z", "-y,x-y,z", "-x+y,-x,z", 
"y,x,-z", "x-y,-y,-z", "-x,-x+y,-z", 
"-x,-y,-z", "y,-x+y,-z", "x-y,x,-z", 
"-y,-x,z", "-x+y,y,z", "x,x-y,z", 

"x,-x,z", "x,2x,z", "-2x,-x,z", "-x,x,-z", "2x,x,-z", "-x,-2x,-z", 

"x,0,1/2", "0,x,1/2", "-x,-x,1/2", "-x,0,1/2", "0,-x,1/2", "x,x,1/2", 

"x,0,0", "0,x,0", "-x,-x,0", "-x,0,0", "0,-x,0", "x,x,0", 

"1/2,0,1/2", "0,1/2,1/2", "1/2,1/2,1/2", 

"1/2,0,0", "0,1/2,0", "1/2,1/2,0", 

"1/3,2/3,z", "2/3,1/3,-z", 

"0,0,z", "0,0,-z", 

"0,0,1/2", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_165 [36] = {
"x,y,z", "-y,x-y,z", "-x+y,-x,z", 
"y,x,-z+1/2", "x-y,-y,-z+1/2", "-x,-x+y,-z+1/2", 
"-x,-y,-z", "y,-x+y,-z", "x-y,x,-z", 
"-y,-x,z+1/2", "-x+y,y,z+1/2", "x,x-y,z+1/2", 

"x,0,1/4", "0,x,1/4", "-x,-x,1/4", "-x,0,3/4", "0,-x,3/4", "x,x,3/4", 

"1/2,0,0", "0,1/2,0", "1/2,1/2,0", "0,1/2,1/2", "1/2,0,1/2", "1/2,1/2,1/2", 

"1/3,2/3,z", "2/3,1/3,-z+1/2", "2/3,1/3,-z", "1/3,2/3,z+1/2", 

"0,0,z", "0,0,-z+1/2", "0,0,-z", "0,0,z+1/2", 

"0,0,0", "0,0,1/2", 

"0,0,1/4", "0,0,3/4", 
};

const char *gamgi_phys_symmetry_wyckoff_166 [40] = {
"x,y,z", "-y,x-y,z", "-x+y,-x,z", 
"y,x,-z", "x-y,-y,-z", "-x,-x+y,-z", 
"-x,-y,-z", "y,-x+y,-z", "x-y,x,-z", 
"-y,-x,z", "-x+y,y,z", "x,x-y,z", 

"x,-x,z", "x,2x,z", "-2x,-x,z", "-x,x,-z", "2x,x,-z", "-x,-2x,-z", 

"x,0,1/2", "0,x,1/2", "-x,-x,1/2", "-x,0,1/2", "0,-x,1/2", "x,x,1/2", 

"x,0,0", "0,x,0", "-x,-x,0", "-x,0,0", "0,-x,0", "x,x,0", 

"1/2,0,0", "0,1/2,0", "1/2,1/2,0", 

"1/2,0,1/2", "0,1/2,1/2", "1/2,1/2,1/2", 

"0,0,z", "0,0,-z", 

"0,0,1/2", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_167 [32] = {
"x,y,z", "-y,x-y,z", "-x+y,-x,z", 
"y,x,-z+1/2", "x-y,-y,-z+1/2", "-x,-x+y,-z+1/2", 
"-x,-y,-z", "y,-x+y,-z", "x-y,x,-z", 
"-y,-x,z+1/2", "-x+y,y,z+1/2", "x,x-y,z+1/2", 

"x,0,1/4", "0,x,1/4", "-x,-x,1/4", "-x,0,3/4", "0,-x,3/4", "x,x,3/4", 

"1/2,0,0", "0,1/2,0", "1/2,1/2,0", "0,1/2,1/2", "1/2,0,1/2", "1/2,1/2,1/2", 

"0,0,z", "0,0,-z+1/2", "0,0,-z", "0,0,z+1/2", 

"0,0,0", "0,0,1/2", 

"0,0,1/4", "0,0,3/4", 
};

const char *gamgi_phys_symmetry_wyckoff_168 [12] = {
"x,y,z", "-y,x-y,z", "-x+y,-x,z", 
"-x,-y,z", "y,-x+y,z", "x-y,x,z", 

"1/2,0,z", "0,1/2,z", "1/2,1/2,z", 

"1/3,2/3,z", "2/3,1/3,z", 

"0,0,z", 
};

const char *gamgi_phys_symmetry_wyckoff_169 [6] = {
"x,y,z", "-y,x-y,z+1/3", "-x+y,-x,z+2/3", 
"-x,-y,z+1/2", "y,-x+y,z+5/6", "x-y,x,z+1/6", 
};

const char *gamgi_phys_symmetry_wyckoff_170 [6] = {
"x,y,z", "-y,x-y,z+2/3", "-x+y,-x,z+1/3", 
"-x,-y,z+1/2", "y,-x+y,z+1/6", "x-y,x,z+5/6",
};

const char *gamgi_phys_symmetry_wyckoff_171 [12] = {
"x,y,z", "-y,x-y,z+2/3", "-x+y,-x,z+1/3", 
"-x,-y,z", "y,-x+y,z+2/3", "x-y,x,z+1/3", 

"1/2,1/2,z", "1/2,0,z+2/3", "0,1/2,z+1/3", 

"0,0,z", "0,0,z+2/3", "0,0,z+1/3", 
};

const char *gamgi_phys_symmetry_wyckoff_172 [12] = {
"x,y,z", "-y,x-y,z+1/3", "-x+y,-x,z+2/3", 
"-x,-y,z", "y,-x+y,z+1/3", "x-y,x,z+2/3", 

"1/2,1/2,z", "1/2,0,z+1/3", "0,1/2,z+2/3", 

"0,0,z", "0,0,z+1/3", "0,0,z+2/3", 
};

const char *gamgi_phys_symmetry_wyckoff_173 [10] = {
"x,y,z", "-y,x-y,z", "-x+y,-x,z", 
"-x,-y,z+1/2", "y,-x+y,z+1/2", "x-y,x,z+1/2", 

"1/3,2/3,z", "2/3,1/3,z+1/2", 

"0,0,z", "0,0,z+1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_174 [24] = {
"x,y,z", "-y,x-y,z", "-x+y,-x,z", 
"x,y,-z", "-y,x-y,-z", "-x+y,-x,-z", 

"x,y,1/2", "-y,x-y,1/2", "-x+y,-x,1/2", 

"x,y,0", "-y,x-y,0", "-x+y,-x,0", 

"2/3,1/3,z", "2/3,1/3,-z", 

"1/3,2/3,z", "1/3,2/3,-z", 

"0,0,z", "0,0,-z", 

"2/3,1/3,1/2", 

"2/3,1/3,0", 

"1/3,2/3,1/2", 

"1/3,2/3,0", 

"0,0,1/2", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_175 [48] = {
"x,y,z", "-y,x-y,z", "-x+y,-x,z", 
"-x,-y,z", "y,-x+y,z", "x-y,x,z", 
"-x,-y,-z", "y,-x+y,-z", "x-y,x,-z", 
"x,y,-z", "-y,x-y,-z", "-x+y,-x,-z", 

"x,y,1/2", "-y,x-y,1/2", "-x+y,-x,1/2", "-x,-y,1/2", "y,-x+y,1/2", "x-y,x,1/2", 

"x,y,0", "-y,x-y,0", "-x+y,-x,0", "-x,-y,0", "y,-x+y,0", "x-y,x,0", 

"1/2,0,z", "0,1/2,z", "1/2,1/2,z", "1/2,0,-z", "0,1/2,-z", "1/2,1/2,-z", 

"1/3,2/3,z", "2/3,1/3,z", "2/3,1/3,-z", "1/3,2/3,-z", 

"1/2,0,1/2", "0,1/2,1/2", "1/2,1/2,1/2", 

"1/2,0,0", "0,1/2,0", "1/2,1/2,0", 

"0,0,z", "0,0,-z", 

"1/3,2/3,1/2", "2/3,1/3,1/2", 

"1/3,2/3,0", "2/3,1/3,0", 

"0,0,1/2", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_176 [40] = {
"x,y,z", "-y,x-y,z", "-x+y,-x,z", 
"-x,-y,z+1/2", "y,-x+y,z+1/2", "x-y,x,z+1/2", 
"-x,-y,-z", "y,-x+y,-z", "x-y,x,-z", 
"x,y,-z+1/2", "-y,x-y,-z+1/2", "-x+y,-x,-z+1/2", 

"x,y,1/4", "-y,x-y,1/4", "-x+y,-x,1/4", "-x,-y,3/4", "y,-x+y,3/4", "x-y,x,3/4", 

"1/2,0,0", "0,1/2,0", "1/2,1/2,0", "1/2,0,1/2", "0,1/2,1/2", "1/2,1/2,1/2", 

"1/3,2/3,z", "2/3,1/3,z+1/2", "2/3,1/3,-z", "1/3,2/3,-z+1/2", 

"0,0,z", "0,0,z+1/2", "0,0,-z", "0,0,-z+1/2", 

"2/3,1/3,1/4", "1/3,2/3,3/4", 

"1/3,2/3,1/4", "2/3,1/3,3/4", 

"0,0,0", "0,0,1/2", 

"0,0,1/4", "0,0,3/4", 
};

const char *gamgi_phys_symmetry_wyckoff_177 [60] = {
"x,y,z", "-y,x-y,z", "-x+y,-x,z", 
"-x,-y,z", "y,-x+y,z", "x-y,x,z", 
"y,x,-z", "x-y,-y,-z", "-x,-x+y,-z", 
"-y,-x,-z", "-x+y,y,-z", "x,x-y,-z", 

"x,-x,1/2", "x,2x,1/2", "-2x,-x,1/2", "-x,x,1/2", "-x,-2x,1/2", "2x,x,1/2", 

"x,-x,0", "x,2x,0", "-2x,-x,0", "-x,x,0", "-x,-2x,0", "2x,x,0", 

"x,0,1/2", "0,x,1/2", "-x,-x,1/2", "-x,0,1/2", "0,-x,1/2", "x,x,1/2", 

"x,0,0", "0,x,0", "-x,-x,0", "-x,0,0", "0,-x,0", "x,x,0", 

"1/2,0,z", "0,1/2,z", "1/2,1/2,z", "0,1/2,-z", "1/2,0,-z", "1/2,1/2,-z", 

"1/3,2/3,z", "2/3,1/3,z", "2/3,1/3,-z", "1/3,2/3,-z", 

"1/2,0,1/2", "0,1/2,1/2", "1/2,1/2,1/2", 

"1/2,0,0", "0,1/2,0", "1/2,1/2,0", 

"0,0,z", "0,0,-z", 

"1/3,2/3,1/2", "2/3,1/3,1/2", 

"1/3,2/3,0", "2/3,1/3,0", 

"0,0,1/2", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_178 [24] = {
"x,y,z", "-y,x-y,z+1/3", "-x+y,-x,z+2/3", 
"-x,-y,z+1/2", "y,-x+y,z+5/6", "x-y,x,z+1/6", 
"y,x,-z+1/3", "x-y,-y,-z", "-x,-x+y,-z+2/3", 
"-y,-x,-z+5/6", "-x+y,y,-z+1/2", "x,x-y,-z+1/6", 

"x,2x,1/4", "-2x,-x,7/12", "x,-x,11/12", "-x,-2x,3/4", "2x,x,1/12", "-x,x,5/12", 

"x,0,0", "0,x,1/3", "-x,-x,2/3", "-x,0,1/2", "0,-x,5/6", "x,x,1/6", 
};

const char *gamgi_phys_symmetry_wyckoff_179 [24] = {
"x,y,z", "-y,x-y,z+2/3", "-x+y,-x,z+1/3", 
"-x,-y,z+1/2", "y,-x+y,z+1/6", "x-y,x,z+5/6", 
"y,x,-z+2/3", "x-y,-y,-z", "-x,-x+y,-z+1/3", 
"-y,-x,-z+1/6", "-x+y,y,-z+1/2", "x,x-y,-z+5/6", 

"x,2x,3/4", "-2x,-x,5/12", "x,-x,1/12", "-x,-2x,1/4", "2x,x,11/12", "-x,x,7/12", 

"x,0,0", "0,x,2/3", "-x,-x,1/3", "-x,0,1/2", "0,-x,1/6", "x,x,5/6", 
};

const char *gamgi_phys_symmetry_wyckoff_180 [60] = {
"x,y,z", "-y,x-y,z+2/3", "-x+y,-x,z+1/3", 
"-x,-y,z", "y,-x+y,z+2/3", "x-y,x,z+1/3", 
"y,x,-z+2/3", "x-y,-y,-z", "-x,-x+y,-z+1/3", 
"-y,-x,-z+2/3", "-x+y,y,-z", "x,x-y,-z+1/3", 

"x,2x,1/2", "-2x,-x,1/6", "x,-x,5/6", "-x,-2x,1/2", "2x,x,1/6", "-x,x,5/6", 

"x,2x,0", "-2x,-x,2/3", "x,-x,1/3", "-x,-2x,0", "2x,x,2/3", "-x,x,1/3", 

"x,0,1/2", "0,x,1/6", "-x,-x,5/6", "-x,0,1/2", "0,-x,1/6", "x,x,5/6", 

"x,0,0", "0,x,2/3", "-x,-x,1/3", "-x,0,0", "0,-x,2/3", "x,x,1/3", 

"1/2,0,z", "0,1/2,z+2/3", "1/2,1/2,z+1/3", "0,1/2,-z+2/3", "1/2,0,-z", "1/2,1/2,-z+1/3", 

"0,0,z", "0,0,z+2/3", "0,0,z+1/3", "0,0,-z+2/3", "0,0,-z", "0,0,-z+1/3", 

"1/2,0,1/2", "0,1/2,1/6", "1/2,1/2,5/6", 

"1/2,0,0", "0,1/2,2/3", "1/2,1/2,1/3", 

"0,0,1/2", "0,0,1/6", "0,0,5/6", 

"0,0,0", "0,0,2/3", "0,0,1/3", 
};

const char *gamgi_phys_symmetry_wyckoff_181 [60] = {
"x,y,z", "-y,x-y,z+1/3", "-x+y,-x,z+2/3", 
"-x,-y,z", "y,-x+y,z+1/3", "x-y,x,z+2/3", 
"y,x,-z+1/3", "x-y,-y,-z", "-x,-x+y,-z+2/3", 
"-y,-x,-z+1/3", "-x+y,y,-z", "x,x-y,-z+2/3", 

"x,2x,1/2", "-2x,-x,5/6", "x,-x,1/6", "-x,-2x,1/2", "2x,x,5/6", "-x,x,1/6", 

"x,2x,0", "-2x,-x,1/3", "x,-x,2/3", "-x,-2x,0", "2x,x,1/3", "-x,x,2/3", 

"x,0,1/2", "0,x,5/6", "-x,-x,1/6", "-x,0,1/2", "0,-x,5/6", "x,x,1/6", 

"x,0,0", "0,x,1/3", "-x,-x,2/3", "-x,0,0", "0,-x,1/3", "x,x,2/3", 

"1/2,0,z", "0,1/2,z+1/3", "1/2,1/2,z+2/3", "0,1/2,-z+1/3", "1/2,0,-z", "1/2,1/2,-z+2/3", 

"0,0,z", "0,0,z+1/3", "0,0,z+2/3", "0,0,-z+1/3", "0,0,-z", "0,0,-z+2/3", 

"1/2,0,1/2", "0,1/2,5/6", "1/2,1/2,1/6", 

"1/2,0,0", "0,1/2,1/3", "1/2,1/2,2/3", 

"0,0,1/2", "0,0,5/6", "0,0,1/6", 

"0,0,0", "0,0,1/3", "0,0,2/3", 
};

const char *gamgi_phys_symmetry_wyckoff_182 [40] = {
"x,y,z", "-y,x-y,z", "-x+y,-x,z", 
"-x,-y,z+1/2", "y,-x+y,z+1/2", "x-y,x,z+1/2", 
"y,x,-z", "x-y,-y,-z", "-x,-x+y,-z", 
"-y,-x,-z+1/2", "-x+y,y,-z+1/2", "x,x-y,-z+1/2", 

"x,2x,1/4", "-2x,-x,1/4", "x,-x,1/4", "-x,-2x,3/4", "2x,x,3/4", "-x,x,3/4", 

"x,0,0", "0,x,0", "-x,-x,0", "-x,0,1/2", "0,-x,1/2", "x,x,1/2", 

"1/3,2/3,z", "2/3,1/3,z+1/2", "2/3,1/3,-z", "1/3,2/3,-z+1/2", 

"0,0,z", "0,0,z+1/2", "0,0,-z", "0,0,-z+1/2", 

"1/3,2/3,3/4", "2/3,1/3,1/4", 

"1/3,2/3,1/4", "2/3,1/3,3/4", 

"0,0,1/4", "0,0,3/4", 

"0,0,0", "0,0,1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_183 [30] = {
"x,y,z", "-y,x-y,z", "-x+y,-x,z", 
"-x,-y,z", "y,-x+y,z", "x-y,x,z", 
"-y,-x,z", "-x+y,y,z", "x,x-y,z", 
"y,x,z", "x-y,-y,z", "-x,-x+y,z", 

"x,-x,z", "x,2x,z", "-2x,-x,z", "-x,x,z", "-x,-2x,z", "2x,x,z", 

"x,0,z", "0,x,z", "-x,-x,z", "-x,0,z", "0,-x,z", "x,x,z", 

"1/2,0,z", "0,1/2,z", "1/2,1/2,z", 

"1/3,2/3,z", "2/3,1/3,z", 

"0,0,z", 
};

const char *gamgi_phys_symmetry_wyckoff_184 [24] = {
"x,y,z", "-y,x-y,z", "-x+y,-x,z", 
"-x,-y,z", "y,-x+y,z", "x-y,x,z", 
"-y,-x,z+1/2", "-x+y,y,z+1/2", "x,x-y,z+1/2", 
"y,x,z+1/2", "x-y,-y,z+1/2", "-x,-x+y,z+1/2", 

"1/2,0,z", "0,1/2,z", "1/2,1/2,z", "0,1/2,z+1/2", "1/2,0,z+1/2", "1/2,1/2,z+1/2", 

"1/3,2/3,z", "2/3,1/3,z", "1/3,2/3,z+1/2", "2/3,1/3,z+1/2", 

"0,0,z", "0,0,z+1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_185 [24] = {
"x,y,z", "-y,x-y,z", "-x+y,-x,z", 
"-x,-y,z+1/2", "y,-x+y,z+1/2", "x-y,x,z+1/2", 
"-y,-x,z+1/2", "-x+y,y,z+1/2", "x,x-y,z+1/2", 
"y,x,z", "x-y,-y,z", "-x,-x+y,z", 

"x,0,z", "0,x,z", "-x,-x,z", "-x,0,z+1/2", "0,-x,z+1/2", "x,x,z+1/2", 

"1/3,2/3,z", "2/3,1/3,z+1/2", "1/3,2/3,z+1/2", "2/3,1/3,z", 

"0,0,z", "0,0,z+1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_186 [22] = {
"x,y,z", "-y,x-y,z", "-x+y,-x,z", 
"-x,-y,z+1/2", "y,-x+y,z+1/2", "x-y,x,z+1/2", 
"-y,-x,z", "-x+y,y,z", "x,x-y,z", 
"y,x,z+1/2", "x-y,-y,z+1/2", "-x,-x+y,z+1/2", 

"x,-x,z", "x,2x,z", "-2x,-x,z", "-x,x,z+1/2", "-x,-2x,z+1/2", "2x,x,z+1/2", 

"1/3,2/3,z", "2/3,1/3,z+1/2", 

"0,0,z", "0,0,z+1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_187 [48] = {
"x,y,z", "-y,x-y,z", "-x+y,-x,z", 
"x,y,-z", "-y,x-y,-z", "-x+y,-x,-z", 
"-y,-x,z", "-x+y,y,z", "x,x-y,z", 
"-y,-x,-z", "-x+y,y,-z", "x,x-y,-z", 

"x,-x,z", "x,2x,z", "-2x,-x,z", "x,-x,-z", "x,2x,-z", "-2x,-x,-z", 

"x,y,1/2", "-y,x-y,1/2", "-x+y,-x,1/2", "-y,-x,1/2", "-x+y,y,1/2", "x,x-y,1/2", 

"x,y,0", "-y,x-y,0", "-x+y,-x,0", "-y,-x,0", "-x+y,y,0", "x,x-y,0", 

"x,-x,1/2", "x,2x,1/2", "-2x,-x,1/2", 

"x,-x,0", "x,2x,0", "-2x,-x,0", 

"2/3,1/3,z", "2/3,1/3,-z", 

"1/3,2/3,z", "1/3,2/3,-z", 

"0,0,z", "0,0,-z", 

"2/3,1/3,1/2", 

"2/3,1/3,0", 

"1/3,2/3,1/2", 

"1/3,2/3,0", 

"0,0,1/2", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_188 [48] = {
"x,y,z", "-y,x-y,z", "-x+y,-x,z", 
"x,y,-z+1/2", "-y,x-y,-z+1/2", "-x+y,-x,-z+1/2", 
"-y,-x,z+1/2", "-x+y,y,z+1/2", "x,x-y,z+1/2", 
"-y,-x,-z", "-x+y,y,-z", "x,x-y,-z", 

"x,y,1/4", "-y,x-y,1/4", "-x+y,-x,1/4", "-y,-x,3/4", "-x+y,y,3/4", "x,x-y,3/4", 

"x,-x,0", "x,2x,0", "-2x,-x,0", "x,-x,1/2", "x,2x,1/2", "-2x,-x,1/2", 

"2/3,1/3,z", "2/3,1/3,-z+1/2", "2/3,1/3,z+1/2", "2/3,1/3,-z", 

"1/3,2/3,z", "1/3,2/3,-z+1/2", "1/3,2/3,z+1/2", "1/3,2/3,-z", 

"0,0,z", "0,0,-z+1/2", "0,0,z+1/2", "0,0,-z", 

"2/3,1/3,1/4", "2/3,1/3,3/4", 

"2/3,1/3,0", "2/3,1/3,1/2", 

"1/3,2/3,1/4", "1/3,2/3,3/4", 

"1/3,2/3,0", "1/3,2/3,1/2", 

"0,0,1/4", "0,0,3/4", 

"0,0,0", "0,0,1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_189 [48] = {
"x,y,z", "-y,x-y,z", "-x+y,-x,z", 
"x,y,-z", "-y,x-y,-z", "-x+y,-x,-z", 
"y,x,-z", "x-y,-y,-z", "-x,-x+y,-z", 
"y,x,z", "x-y,-y,z", "-x,-x+y,z", 

"x,y,1/2", "-y,x-y,1/2", "-x+y,-x,1/2", "y,x,1/2", "x-y,-y,1/2", "-x,-x+y,1/2", 

"x,y,0", "-y,x-y,0", "-x+y,-x,0", "y,x,0", "x-y,-y,0", "-x,-x+y,0", 

"x,0,z", "0,x,z", "-x,-x,z", "x,0,-z", "0,x,-z", "-x,-x,-z", 

"1/3,2/3,z", "1/3,2/3,-z", "2/3,1/3,-z", "2/3,1/3,z", 

"x,0,1/2", "0,x,1/2", "-x,-x,1/2", 

"x,0,0", "0,x,0", "-x,-x,0", 

"0,0,z", "0,0,-z", 

"1/3,2/3,1/2", "2/3,1/3,1/2", 

"1/3,2/3,0", "2/3,1/3,0", 

"0,0,1/2", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_190 [40] = {
"x,y,z", "-y,x-y,z", "-x+y,-x,z", 
"x,y,-z+1/2", "-y,x-y,-z+1/2", "-x+y,-x,-z+1/2", 
"y,x,-z", "x-y,-y,-z", "-x,-x+y,-z", 
"y,x,z+1/2", "x-y,-y,z+1/2", "-x,-x+y,z+1/2", 

"x,y,1/4", "-y,x-y,1/4", "-x+y,-x,1/4", "y,x,3/4", "x-y,-y,3/4", "-x,-x+y,3/4", 

"x,0,0", "0,x,0", "-x,-x,0", "x,0,1/2", "0,x,1/2", "-x,-x,1/2", 

"1/3,2/3,z", "1/3,2/3,-z+1/2", "2/3,1/3,-z", "2/3,1/3,z+1/2", 

"0,0,z", "0,0,-z+1/2", "0,0,-z", "0,0,z+1/2", 

"2/3,1/3,1/4", "1/3,2/3,3/4", 

"1/3,2/3,1/4", "2/3,1/3,3/4", 

"0,0,1/4", "0,0,3/4", 

"0,0,0", "0,0,1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_191 [120] = {
"x,y,z", "-y,x-y,z", "-x+y,-x,z", 
"-x,-y,z", "y,-x+y,z", "x-y,x,z", 
"y,x,-z", "x-y,-y,-z", "-x,-x+y,-z", 
"-y,-x,-z", "-x+y,y,-z", "x,x-y,-z", 
"-x,-y,-z", "y,-x+y,-z", "x-y,x,-z", 
"x,y,-z", "-y,x-y,-z", "-x+y,-x,-z", 
"-y,-x,z", "-x+y,y,z", "x,x-y,z", 
"y,x,z", "x-y,-y,z", "-x,-x+y,z", 

"x,y,1/2", "-y,x-y,1/2", "-x+y,-x,1/2", "-x,-y,1/2", "y,-x+y,1/2", "x-y,x,1/2", 
"y,x,1/2", "x-y,-y,1/2", "-x,-x+y,1/2", "-y,-x,1/2", "-x+y,y,1/2", "x,x-y,1/2", 

"x,y,0", "-y,x-y,0", "-x+y,-x,0", "-x,-y,0", "y,-x+y,0", "x-y,x,0", 
"y,x,0", "x-y,-y,0", "-x,-x+y,0", "-y,-x,0", "-x+y,y,0", "x,x-y,0", 

"x,2x,z", "-2x,-x,z", "x,-x,z", "-x,-2x,z", "2x,x,z", "-x,x,z", 
"2x,x,-z", "-x,-2x,-z", "-x,x,-z", "-2x,-x,-z", "x,2x,-z", "x,-x,-z", 

"x,0,z", "0,x,z", "-x,-x,z", "-x,0,z", "0,-x,z", "x,x,z", 
"0,x,-z", "x,0,-z", "-x,-x,-z", "0,-x,-z", "-x,0,-z", "x,x,-z", 

"x,2x,1/2", "-2x,-x,1/2", "x,-x,1/2", "-x,-2x,1/2", "2x,x,1/2", "-x,x,1/2", 

"x,2x,0", "-2x,-x,0", "x,-x,0", "-x,-2x,0", "2x,x,0", "-x,x,0", 

"x,0,1/2", "0,x,1/2", "-x,-x,1/2", "-x,0,1/2", "0,-x,1/2", "x,x,1/2", 

"x,0,0", "0,x,0", "-x,-x,0", "-x,0,0", "0,-x,0", "x,x,0", 

"1/2,0,z", "0,1/2,z", "1/2,1/2,z", "0,1/2,-z", "1/2,0,-z", "1/2,1/2,-z", 

"1/3,2/3,z", "2/3,1/3,z", "2/3,1/3,-z", "1/3,2/3,-z", 

"1/2,0,1/2", "0,1/2,1/2", "1/2,1/2,1/2", 

"1/2,0,0", "0,1/2,0", "1/2,1/2,0", 

"0,0,z", "0,0,-z", 

"1/3,2/3,1/2", "2/3,1/3,1/2", 

"1/3,2/3,0", "2/3,1/3,0", 

"0,0,1/2", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_192 [108] = {
"x,y,z", "-y,x-y,z", "-x+y,-x,z", 
"-x,-y,z", "y,-x+y,z", "x-y,x,z", 
"y,x,-z+1/2", "x-y,-y,-z+1/2", "-x,-x+y,-z+1/2", 
"-y,-x,-z+1/2", "-x+y,y,-z+1/2", "x,x-y,-z+1/2", 
"-x,-y,-z", "y,-x+y,-z", "x-y,x,-z", 
"x,y,-z", "-y,x-y,-z", "-x+y,-x,-z", 
"-y,-x,z+1/2", "-x+y,y,z+1/2", "x,x-y,z+1/2", 
"y,x,z+1/2", "x-y,-y,z+1/2", "-x,-x+y,z+1/2", 

"x,y,0", "-y,x-y,0", "-x+y,-x,0", "-x,-y,0", "y,-x+y,0", "x-y,x,0", 
"y,x,1/2", "x-y,-y,1/2", "-x,-x+y,1/2", "-y,-x,1/2", "-x+y,y,1/2", "x,x-y,1/2", 

"x,2x,1/4", "-2x,-x,1/4", "x,-x,1/4", "-x,-2x,1/4", "2x,x,1/4", "-x,x,1/4", 
"-x,-2x,3/4", "2x,x,3/4", "-x,x,3/4", "x,2x,3/4", "-2x,-x,3/4", "x,-x,3/4", 

"x,0,1/4", "0,x,1/4", "-x,-x,1/4", "-x,0,1/4", "0,-x,1/4", "x,x,1/4", 
"-x,0,3/4", "0,-x,3/4", "x,x,3/4", "x,0,3/4", "0,x,3/4", "-x,-x,3/4", 

"1/2,0,z", "0,1/2,z", "1/2,1/2,z", "0,1/2,-z+1/2", "1/2,0,-z+1/2", "1/2,1/2,-z+1/2", 
"1/2,0,-z", "0,1/2,-z", "1/2,1/2,-z", "0,1/2,z+1/2", "1/2,0,z+1/2", "1/2,1/2,z+1/2", 

"1/3,2/3,z", "2/3,1/3,z", "2/3,1/3,-z+1/2", "1/3,2/3,-z+1/2", 
"2/3,1/3,-z", "1/3,2/3,-z", "1/3,2/3,z+1/2", "2/3,1/3,z+1/2", 

"1/2,0,0", "0,1/2,0", "1/2,1/2,0", "0,1/2,1/2", "1/2,0,1/2", "1/2,1/2,1/2", 

"1/2,0,1/4", "0,1/2,1/4", "1/2,1/2,1/4", "1/2,0,3/4", "0,1/2,3/4", "1/2,1/2,3/4", 

"0,0,z", "0,0,-z+1/2", "0,0,-z", "0,0,z+1/2", 

"1/3,2/3,0", "2/3,1/3,0", "2/3,1/3,1/2", "1/3,2/3,1/2", 

"1/3,2/3,1/4", "2/3,1/3,1/4", "2/3,1/3,3/4", "1/3,2/3,3/4", 

"0,0,0", "0,0,1/2", 

"0,0,1/4", "0,0,3/4", 
};

const char *gamgi_phys_symmetry_wyckoff_193 [96] = {
"x,y,z", "-y,x-y,z", "-x+y,-x,z", 
"-x,-y,z+1/2", "y,-x+y,z+1/2", "x-y,x,z+1/2", 
"y,x,-z+1/2", "x-y,-y,-z+1/2", "-x,-x+y,-z+1/2", 
"-y,-x,-z", "-x+y,y,-z", "x,x-y,-z", 
"-x,-y,-z", "y,-x+y,-z", "x-y,x,-z", 
"x,y,-z+1/2", "-y,x-y,-z+1/2", "-x+y,-x,-z+1/2", 
"-y,-x,z+1/2", "-x+y,y,z+1/2", "x,x-y,z+1/2", 
"y,x,z", "x-y,-y,z", "-x,-x+y,z", 

"x,0,z", "0,x,z", "-x,-x,z", "-x,0,z+1/2", 
"0,-x,z+1/2", "x,x,z+1/2", "0,x,-z+1/2", "x,0,-z+1/2", 
"-x,-x,-z+1/2", "0,-x,-z", "-x,0,-z", "x,x,-z", 

"x,y,1/4", "-y,x-y,1/4", "-x+y,-x,1/4", "-x,-y,3/4", "y,-x+y,3/4", "x-y,x,3/4", 
"y,x,1/4", "x-y,-y,1/4", "-x,-x+y,1/4", "-y,-x,3/4", "-x+y,y,3/4", "x,x-y,3/4", 

"x,2x,0", "-2x,-x,0", "x,-x,0", "-x,-2x,1/2", "2x,x,1/2", "-x,x,1/2", 
"-x,-2x,0", "2x,x,0", "-x,x,0", "x,2x,1/2", "-2x,-x,1/2", "x,-x,1/2", 

"1/3,2/3,z", "2/3,1/3,z+1/2", "2/3,1/3,-z+1/2", "1/3,2/3,-z", 
"2/3,1/3,-z", "1/3,2/3,-z+1/2", "1/3,2/3,z+1/2", "2/3,1/3,z", 

"x,0,1/4", "0,x,1/4", "-x,-x,1/4", "-x,0,3/4", "0,-x,3/4", "x,x,3/4", 

"1/2,0,0", "0,1/2,0", "1/2,1/2,0", "1/2,0,1/2", "0,1/2,1/2", "1/2,1/2,1/2", 

"0,0,z", "0,0,z+1/2", "0,0,-z+1/2", "0,0,-z", 

"1/3,2/3,0", "2/3,1/3,1/2", "2/3,1/3,0", "1/3,2/3,1/2", 

"1/3,2/3,1/4", "2/3,1/3,3/4", "2/3,1/3,1/4", "1/3,2/3,3/4", 

"0,0,0", "0,0,1/2", 

"0,0,1/4", "0,0,3/4", 
};

const char *gamgi_phys_symmetry_wyckoff_194 [88] = {
"x,y,z", "-y,x-y,z", "-x+y,-x,z", 
"-x,-y,z+1/2", "y,-x+y,z+1/2", "x-y,x,z+1/2", 
"y,x,-z", "x-y,-y,-z", "-x,-x+y,-z", 
"-y,-x,-z+1/2", "-x+y,y,-z+1/2", "x,x-y,-z+1/2", 
"-x,-y,-z", "y,-x+y,-z", "x-y,x,-z", 
"x,y,-z+1/2", "-y,x-y,-z+1/2", "-x+y,-x,-z+1/2", 
"-y,-x,z", "-x+y,y,z", "x,x-y,z", 
"y,x,z+1/2", "x-y,-y,z+1/2", "-x,-x+y,z+1/2", 

"x,2x,z", "-2x,-x,z", "x,-x,z", "-x,-2x,z+1/2", 
"2x,x,z+1/2", "-x,x,z+1/2", "2x,x,-z", "-x,-2x,-z", 
"-x,x,-z", "-2x,-x,-z+1/2", "x,2x,-z+1/2", "x,-x,-z+1/2", 

"x,y,1/4", "-y,x-y,1/4", "-x+y,-x,1/4", "-x,-y,3/4", "y,-x+y,3/4", "x-y,x,3/4", 
"y,x,3/4", "x-y,-y,3/4", "-x,-x+y,3/4", "-y,-x,1/4", "-x+y,y,1/4", "x,x-y,1/4", 

"x,0,0", "0,x,0", "-x,-x,0", "-x,0,1/2", "0,-x,1/2", "x,x,1/2", 
"-x,0,0", "0,-x,0", "x,x,0", "x,0,1/2", "0,x,1/2", "-x,-x,1/2", 

"x,2x,1/4", "-2x,-x,1/4", "x,-x,1/4", "-x,-2x,3/4", "2x,x,3/4", "-x,x,3/4", 

"1/2,0,0", "0,1/2,0", "1/2,1/2,0", "1/2,0,1/2", "0,1/2,1/2", "1/2,1/2,1/2", 

"1/3,2/3,z", "2/3,1/3,z+1/2", "2/3,1/3,-z", "1/3,2/3,-z+1/2", 

"0,0,z", "0,0,z+1/2", "0,0,-z", "0,0,-z+1/2", 

"1/3,2/3,3/4", "2/3,1/3,1/4", 

"1/3,2/3,1/4", "2/3,1/3,3/4", 

"0,0,1/4", "0,0,3/4", 

"0,0,0", "0,0,1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_195 [48] = {
"x,y,z", "-x,-y,z", "-x,y,-z", "x,-y,-z", 
"z,x,y", "z,-x,-y", "-z,-x,y", "-z,x,-y", 
"y,z,x", "-y,z,-x", "y,-z,-x", "-y,-z,x", 

"x,1/2,1/2", "-x,1/2,1/2", "1/2,x,1/2", "1/2,-x,1/2", "1/2,1/2,x", "1/2,1/2,-x", 

"x,1/2,0", "-x,1/2,0", "0,x,1/2", "0,-x,1/2", "1/2,0,x", "1/2,0,-x", 

"x,0,1/2", "-x,0,1/2", "1/2,x,0", "1/2,-x,0", "0,1/2,x", "0,1/2,-x", 

"x,0,0", "-x,0,0", "0,x,0", "0,-x,0", "0,0,x", "0,0,-x", 

"x,x,x", "-x,-x,x", "-x,x,-x", "x,-x,-x", 

"1/2,0,0", "0,1/2,0", "0,0,1/2", 

"0,1/2,1/2", "1/2,0,1/2", "1/2,1/2,0", 

"1/2,1/2,1/2", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_196 [32] = {
"x,y,z", "-x,-y,z", "-x,y,-z", "x,-y,-z", 
"z,x,y", "z,-x,-y", "-z,-x,y", "-z,x,-y", 
"y,z,x", "-y,z,-x", "y,-z,-x", "-y,-z,x", 

"x,1/4,1/4", "-x,3/4,1/4", "1/4,x,1/4", "1/4,-x,3/4", "1/4,1/4,x", "3/4,1/4,-x", 

"x,0,0", "-x,0,0", "0,x,0", "0,-x,0", "0,0,x", "0,0,-x", 

"x,x,x", "-x,-x,x", "-x,x,-x", "x,-x,-x", 

"3/4,3/4,3/4", 

"1/4,1/4,1/4", 

"1/2,1/2,1/2", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_197 [32] = {
"x,y,z", "-x,-y,z", "-x,y,-z", "x,-y,-z", 
"z,x,y", "z,-x,-y", "-z,-x,y", "-z,x,-y", 
"y,z,x", "-y,z,-x", "y,-z,-x", "-y,-z,x", 

"x,1/2,0", "-x,1/2,0", "0,x,1/2", "0,-x,1/2", "1/2,0,x", "1/2,0,-x", 

"x,0,0", "-x,0,0", "0,x,0", "0,-x,0", "0,0,x", "0,0,-x", 

"x,x,x", "-x,-x,x", "-x,x,-x", "x,-x,-x", 

"0,1/2,1/2", "1/2,0,1/2", "1/2,1/2,0", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_198 [16] = {
"x,y,z", "-x+1/2,-y,z+1/2", "-x,y+1/2,-z+1/2", "x+1/2,-y+1/2,-z", 
"z,x,y", "z+1/2,-x+1/2,-y", "-z+1/2,-x,y+1/2", "-z,x+1/2,-y+1/2", 
"y,z,x", "-y,z+1/2,-x+1/2", "y+1/2,-z+1/2,-x", "-y+1/2,-z,x+1/2", 

"x,x,x", "-x+1/2,-x,x+1/2", "-x,x+1/2,-x+1/2", "x+1/2,-x+1/2,-x", 
};

const char *gamgi_phys_symmetry_wyckoff_199 [22] = {
"x,y,z", "-x+1/2,-y,z+1/2", "-x,y+1/2,-z+1/2", "x+1/2,-y+1/2,-z", 
"z,x,y", "z+1/2,-x+1/2,-y", "-z+1/2,-x,y+1/2", "-z,x+1/2,-y+1/2", 
"y,z,x", "-y,z+1/2,-x+1/2", "y+1/2,-z+1/2,-x", "-y+1/2,-z,x+1/2", 

"x,0,1/4", "-x+1/2,0,3/4", "1/4,x,0", "3/4,-x+1/2,0", "0,1/4,x", "0,3/4,-x+1/2", 

"x,x,x", "-x+1/2,-x,x+1/2", "-x,x+1/2,-x+1/2", "x+1/2,-x+1/2,-x", 
};

const char *gamgi_phys_symmetry_wyckoff_200 [88] = {
"x,y,z", "-x,-y,z", "-x,y,-z", "x,-y,-z", 
"z,x,y", "z,-x,-y", "-z,-x,y", "-z,x,-y", 
"y,z,x", "-y,z,-x", "y,-z,-x", "-y,-z,x", 
"-x,-y,-z", "x,y,-z", "x,-y,z", "-x,y,z", 
"-z,-x,-y", "-z,x,y", "z,x,-y", "z,-x,y", 
"-y,-z,-x", "y,-z,x", "-y,z,x", "y,z,-x", 

"1/2,y,z", "1/2,-y,z", "1/2,y,-z", "1/2,-y,-z", "z,1/2,y", "z,1/2,-y", 
"-z,1/2,y", "-z,1/2,-y", "y,z,1/2", "-y,z,1/2", "y,-z,1/2", "-y,-z,1/2", 

"0,y,z", "0,-y,z", "0,y,-z", "0,-y,-z", "z,0,y", "z,0,-y", 
"-z,0,y", "-z,0,-y", "y,z,0", "-y,z,0", "y,-z,0", "-y,-z,0", 

"x,x,x", "-x,-x,x", "-x,x,-x", "x,-x,-x", 
"-x,-x,-x", "x,x,-x", "x,-x,x", "-x,x,x", 

"x,1/2,1/2", "-x,1/2,1/2", "1/2,x,1/2", "1/2,-x,1/2", "1/2,1/2,x", "1/2,1/2,-x", 

"x,1/2,0", "-x,1/2,0", "0,x,1/2", "0,-x,1/2", "1/2,0,x", "1/2,0,-x", 

"x,0,1/2", "-x,0,1/2", "1/2,x,0", "1/2,-x,0", "0,1/2,x", "0,1/2,-x", 

"x,0,0", "-x,0,0", "0,x,0", "0,-x,0", "0,0,x", "0,0,-x", 

"1/2,0,0", "0,1/2,0", "0,0,1/2", 

"0,1/2,1/2", "1/2,0,1/2", "1/2,1/2,0", 

"1/2,1/2,1/2", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_201 [72] = {
"x,y,z", "-x+1/2,-y+1/2,z", "-x+1/2,y,-z+1/2", "x,-y+1/2,-z+1/2", 
"z,x,y", "z,-x+1/2,-y+1/2", "-z+1/2,-x+1/2,y", "-z+1/2,x,-y+1/2", 
"y,z,x", "-y+1/2,z,-x+1/2", "y,-z+1/2,-x+1/2", "-y+1/2,-z+1/2,x", 
"-x,-y,-z", "x+1/2,y+1/2,-z", "x+1/2,-y,z+1/2", "-x,y+1/2,z+1/2", 
"-z,-x,-y", "-z,x+1/2,y+1/2", "z+1/2,x+1/2,-y", "z+1/2,-x,y+1/2", 
"-y,-z,-x", "y+1/2,-z,x+1/2", "-y,z+1/2,x+1/2", "y+1/2,z+1/2,-x", 

"x,3/4,1/4", "-x+1/2,3/4,1/4", "1/4,x,3/4", "1/4,-x+1/2,3/4", "3/4,1/4,x", "3/4,1/4,-x+1/2",
"-x,1/4,3/4", "x+1/2,1/4,3/4", "3/4,-x,1/4", "3/4,x+1/2,1/4", "1/4,3/4,-x", "1/4,3/4,x+1/2", 

"x,1/4,1/4", "-x+1/2,1/4,1/4", "1/4,x,1/4", "1/4,-x+1/2,1/4", "1/4,1/4,x", "1/4,1/4,-x+1/2", 
"-x,3/4,3/4", "x+1/2,3/4,3/4", "3/4,-x,3/4", "3/4,x+1/2,3/4", "3/4,3/4,-x", "3/4,3/4,x+1/2", 

"x,x,x", "-x+1/2,-x+1/2,x", "-x+1/2,x,-x+1/2", "x,-x+1/2,-x+1/2", 
"-x,-x,-x", "x+1/2,x+1/2,-x", "x+1/2,-x,x+1/2", "-x,x+1/2,x+1/2", 

"1/4,3/4,3/4", "3/4,1/4,3/4", "3/4,3/4,1/4", "3/4,1/4,1/4", "1/4,3/4,1/4", "1/4,1/4,3/4", 

"1/2,1/2,1/2", "0,0,1/2", "0,1/2,0", "1/2,0,0", 

"0,0,0", "1/2,1/2,0", "1/2,0,1/2", "0,1/2,1/2", 

"1/4,1/4,1/4", "3/4,3/4,3/4", 
};

const char *gamgi_phys_symmetry_wyckoff_202 [72] = {
"x,y,z", "-x,-y,z", "-x,y,-z", "x,-y,-z", 
"z,x,y", "z,-x,-y", "-z,-x,y", "-z,x,-y", 
"y,z,x", "-y,z,-x", "y,-z,-x", "-y,-z,x", 
"-x,-y,-z", "x,y,-z", "x,-y,z", "-x,y,z", 
"-z,-x,-y", "-z,x,y", "z,x,-y", "z,-x,y", 
"-y,-z,-x", "y,-z,x", "-y,z,x", "y,z,-x", 

"0,y,z", "0,-y,z", "0,y,-z", "0,-y,-z", "z,0,y", "z,0,-y", 
"-z,0,y", "-z,0,-y", "y,z,0", "-y,z,0", "y,-z,0", "-y,-z,0", 

"x,1/4,1/4", "-x,3/4,1/4", "1/4,x,1/4", "1/4,-x,3/4", "1/4,1/4,x", "3/4,1/4,-x", 
"-x,3/4,3/4", "x,1/4,3/4", "3/4,-x,3/4", "3/4,x,1/4", "3/4,3/4,-x", "1/4,3/4,x", 

"x,x,x", "-x,-x,x", "-x,x,-x", "x,-x,-x", 
"-x,-x,-x", "x,x,-x", "x,-x,x", "-x,x,x", 

"x,0,0", "-x,0,0", "0,x,0", "0,-x,0", "0,0,x", "0,0,-x", 

"0,1/4,1/4", "0,3/4,1/4", "1/4,0,1/4", "1/4,0,3/4", "1/4,1/4,0", "3/4,1/4,0", 

"1/4,1/4,1/4", "3/4,3/4,3/4", 

"1/2,1/2,1/2", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_203 [56] = {
"x,y,z", "-x+3/4,-y+3/4,z", "-x+3/4,y,-z+3/4", "x,-y+3/4,-z+3/4", 
"z,x,y", "z,-x+3/4,-y+3/4", "-z+3/4,-x+3/4,y", "-z+3/4,x,-y+3/4", 
"y,z,x", "-y+3/4,z,-x+3/4", "y,-z+3/4,-x+3/4", "-y+3/4,-z+3/4,x", 
"-x,-y,-z", "x+1/4,y+1/4,-z", "x+1/4,-y,z+1/4", "-x,y+1/4,z+1/4", 
"-z,-x,-y", "-z,x+1/4,y+1/4", "z+1/4,x+1/4,-y", "z+1/4,-x,y+1/4", 
"-y,-z,-x", "y+1/4,-z,x+1/4", "-y,z+1/4,x+1/4", "y+1/4,z+1/4,-x", 

"x,1/8,1/8", "-x+3/4,5/8,1/8", "1/8,x,1/8", "1/8,-x+3/4,5/8", "1/8,1/8,x", "5/8,1/8,-x+3/4", 
"-x,7/8,7/8", "x+1/4,3/8,7/8", "7/8,-x,7/8", "7/8,x+1/4,3/8", "7/8,7/8,-x", "3/8,7/8,x+1/4", 

"x,x,x", "-x+3/4,-x+3/4,x", "-x+3/4,x,-x+3/4", "x,-x+3/4,-x+3/4", 
"-x,-x,-x", "x+1/4,x+1/4,-x", "x+1/4,-x,x+1/4", "-x,x+1/4,x+1/4", 

"1/2,1/2,1/2", "1/4,1/4,1/2", "1/4,1/2,1/4", "1/2,1/4,1/4", 

"0,0,0", "3/4,3/4,0", "3/4,0,3/4", "0,3/4,3/4", 

"5/8,5/8,5/8", "3/8,3/8,3/8", 

"1/8,1/8,1/8", "7/8,7/8,7/8", 
};

const char *gamgi_phys_symmetry_wyckoff_204 [64] = {
"x,y,z", "-x,-y,z", "-x,y,-z", "x,-y,-z", 
"z,x,y", "z,-x,-y", "-z,-x,y", "-z,x,-y", 
"y,z,x", "-y,z,-x", "y,-z,-x", "-y,-z,x", 
"-x,-y,-z", "x,y,-z", "x,-y,z", "-x,y,z", 
"-z,-x,-y", "-z,x,y", "z,x,-y", "z,-x,y", 
"-y,-z,-x", "y,-z,x", "-y,z,x", "y,z,-x", 

"0,y,z", "0,-y,z", "0,y,-z", "0,-y,-z", "z,0,y", "z,0,-y", 
"-z,0,y", "-z,0,-y", "y,z,0", "-y,z,0", "y,-z,0", "-y,-z,0", 

"x,x,x", "-x,-x,x", "-x,x,-x", "x,-x,-x", 
"-x,-x,-x", "x,x,-x", "x,-x,x", "-x,x,x", 

"x,0,1/2", "-x,0,1/2", "1/2,x,0", "1/2,-x,0", "0,1/2,x", "0,1/2,-x", 

"x,0,0", "-x,0,0", "0,x,0", "0,-x,0", "0,0,x", "0,0,-x", 

"1/4,1/4,1/4", "3/4,3/4,1/4", "3/4,1/4,3/4", "1/4,3/4,3/4", 

"0,1/2,1/2", "1/2,0,1/2", "1/2,1/2,0", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_205 [40] = {
"x,y,z", "-x+1/2,-y,z+1/2", "-x,y+1/2,-z+1/2", "x+1/2,-y+1/2,-z", 
"z,x,y", "z+1/2,-x+1/2,-y", "-z+1/2,-x,y+1/2", "-z,x+1/2,-y+1/2", 
"y,z,x", "-y,z+1/2,-x+1/2", "y+1/2,-z+1/2,-x", "-y+1/2,-z,x+1/2", 
"-x,-y,-z", "x+1/2,y,-z+1/2", "x,-y+1/2,z+1/2", "-x+1/2,y+1/2,z", 
"-z,-x,-y", "-z+1/2,x+1/2,y", "z+1/2,x,-y+1/2", "z,-x+1/2,y+1/2", 
"-y,-z,-x", "y,-z+1/2,x+1/2", "-y+1/2,z+1/2,x", "y+1/2,z,-x+1/2", 

"x,x,x", "-x+1/2,-x,x+1/2", "-x,x+1/2,-x+1/2", "x+1/2,-x+1/2,-x", 
"-x,-x,-x", "x+1/2,x,-x+1/2", "x,-x+1/2,x+1/2", "-x+1/2,x+1/2,x", 

"1/2,1/2,1/2", "0,1/2,0", "1/2,0,0", "0,0,1/2", 

"0,0,0", "1/2,0,1/2", "0,1/2,1/2", "1/2,1/2,0", 
};

const char *gamgi_phys_symmetry_wyckoff_206 [52] = {
"x,y,z", "-x+1/2,-y,z+1/2", "-x,y+1/2,-z+1/2", "x+1/2,-y+1/2,-z", 
"z,x,y", "z+1/2,-x+1/2,-y", "-z+1/2,-x,y+1/2", "-z,x+1/2,-y+1/2", 
"y,z,x", "-y,z+1/2,-x+1/2", "y+1/2,-z+1/2,-x", "-y+1/2,-z,x+1/2", 
"-x,-y,-z", "x+1/2,y,-z+1/2", "x,-y+1/2,z+1/2", "-x+1/2,y+1/2,z", 
"-z,-x,-y", "-z+1/2,x+1/2,y", "z+1/2,x,-y+1/2", "z,-x+1/2,y+1/2", 
"-y,-z,-x", "y,-z+1/2,x+1/2", "-y+1/2,z+1/2,x", "y+1/2,z,-x+1/2", 

"x,0,1/4", "-x+1/2,0,3/4", "1/4,x,0", "3/4,-x+1/2,0", "0,1/4,x", "0,3/4,-x+1/2", 
"-x,0,3/4", "x+1/2,0,1/4", "3/4,-x,0", "1/4,x+1/2,0", "0,3/4,-x", "0,1/4,x+1/2", 

"x,x,x", "-x+1/2,-x,x+1/2", "-x,x+1/2,-x+1/2", "x+1/2,-x+1/2,-x", 
"-x,-x,-x", "x+1/2,x,-x+1/2", "x,-x+1/2,x+1/2", "-x+1/2,x+1/2,x", 

"1/4,1/4,1/4", "1/4,3/4,3/4", "3/4,3/4,1/4", "3/4,1/4,3/4", 

"0,0,0", "1/2,0,1/2", "0,1/2,1/2", "1/2,1/2,0", 
};

const char *gamgi_phys_symmetry_wyckoff_207 [88] = {
"x,y,z", "-x,-y,z", "-x,y,-z", "x,-y,-z", 
"z,x,y", "z,-x,-y", "-z,-x,y", "-z,x,-y", 
"y,z,x", "-y,z,-x", "y,-z,-x", "-y,-z,x", 
"y,x,-z", "-y,-x,-z", "y,-x,z", "-y,x,z", 
"x,z,-y", "-x,z,y", "-x,-z,-y", "x,-z,y", 
"z,y,-x", "z,-y,x", "-z,y,x", "-z,-y,-x", 

"1/2,y,y", "1/2,-y,y", "1/2,y,-y", "1/2,-y,-y", "y,1/2,y", "y,1/2,-y", 
"-y,1/2,y", "-y,1/2,-y", "y,y,1/2", "-y,y,1/2", "y,-y,1/2", "-y,-y,1/2", 

"0,y,y", "0,-y,y", "0,y,-y", "0,-y,-y", "y,0,y", "y,0,-y", 
"-y,0,y", "-y,0,-y", "y,y,0", "-y,y,0", "y,-y,0", "-y,-y,0", 

"x,1/2,0", "-x,1/2,0", "0,x,1/2", "0,-x,1/2", "1/2,0,x", "1/2,0,-x", 
"1/2,x,0", "1/2,-x,0", "x,0,1/2", "-x,0,1/2", "0,1/2,-x", "0,1/2,x", 

"x,x,x", "-x,-x,x", "-x,x,-x", "x,-x,-x", 
"x,x,-x", "-x,-x,-x", "x,-x,x", "-x,x,x", 

"x,1/2,1/2", "-x,1/2,1/2", "1/2,x,1/2", "1/2,-x,1/2", "1/2,1/2,x", "1/2,1/2,-x", 

"x,0,0", "-x,0,0", "0,x,0", "0,-x,0", "0,0,x", "0,0,-x", 

"1/2,0,0", "0,1/2,0", "0,0,1/2", 

"0,1/2,1/2", "1/2,0,1/2", "1/2,1/2,0", 

"1/2,1/2,1/2", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_208 [120] = {
"x,y,z", "-x,-y,z", "-x,y,-z", "x,-y,-z", 
"z,x,y", "z,-x,-y", "-z,-x,y", "-z,x,-y", 
"y,z,x", "-y,z,-x", "y,-z,-x", "-y,-z,x", 
"y+1/2,x+1/2,-z+1/2", "-y+1/2,-x+1/2,-z+1/2", "y+1/2,-x+1/2,z+1/2", "-y+1/2,x+1/2,z+1/2", 
"x+1/2,z+1/2,-y+1/2", "-x+1/2,z+1/2,y+1/2", "-x+1/2,-z+1/2,-y+1/2", "x+1/2,-z+1/2,y+1/2", 
"z+1/2,y+1/2,-x+1/2", "z+1/2,-y+1/2,x+1/2", "-z+1/2,y+1/2,x+1/2", "-z+1/2,-y+1/2,-x+1/2", 

"1/4,y,y+1/2", "3/4,-y,y+1/2", "3/4,y,-y+1/2", "1/4,-y,-y+1/2", 
"y+1/2,1/4,y", "y+1/2,3/4,-y", "-y+1/2,3/4,y", "-y+1/2,1/4,-y", 
"y,y+1/2,1/4", "-y,y+1/2,3/4", "y,-y+1/2,3/4", "-y,-y+1/2,1/4", 

"1/4,y,-y+1/2", "3/4,-y,-y+1/2", "3/4,y,y+1/2", "1/4,-y,y+1/2", 
"-y+1/2,1/4,y", "-y+1/2,3/4,-y", "y+1/2,3/4,y", "y+1/2,1/4,-y", 
"y,-y+1/2,1/4", "-y,-y+1/2,3/4", "y,y+1/2,3/4", "-y,y+1/2,1/4", 

"x,1/2,0", "-x,1/2,0", "0,x,1/2", "0,-x,1/2", "1/2,0,x", "1/2,0,-x", 
"0,x+1/2,1/2", "0,-x+1/2,1/2", "x+1/2,1/2,0", "-x+1/2,1/2,0", "1/2,0,-x+1/2", "1/2,0,x+1/2", 

"x,0,1/2", "-x,0,1/2", "1/2,x,0", "1/2,-x,0", "0,1/2,x", "0,1/2,-x", 
"1/2,x+1/2,0", "1/2,-x+1/2,0", "x+1/2,0,1/2", "-x+1/2,0,1/2", "0,1/2,-x+1/2", "0,1/2,x+1/2", 

"x,0,0", "-x,0,0", "0,x,0", "0,-x,0", "0,0,x", "0,0,-x", 
"1/2,x+1/2,1/2", "1/2,-x+1/2,1/2", "x+1/2,1/2,1/2", "-x+1/2,1/2,1/2", "1/2,1/2,-x+1/2", "1/2,1/2,x+1/2", 

"x,x,x", "-x,-x,x", 
"-x,x,-x", "x,-x,-x", 
"x+1/2,x+1/2,-x+1/2", "-x+1/2,-x+1/2,-x+1/2", 
"x+1/2,-x+1/2,x+1/2", "-x+1/2,x+1/2,x+1/2", 

"1/4,1/2,0", "3/4,1/2,0", "0,1/4,1/2", "0,3/4,1/2", "1/2,0,1/4", "1/2,0,3/4", 

"1/4,0,1/2", "3/4,0,1/2", "1/2,1/4,0", "1/2,3/4,0", "0,1/2,1/4", "0,1/2,3/4", 

"0,1/2,1/2", "1/2,0,1/2", "1/2,1/2,0", "0,1/2,0", "1/2,0,0", "0,0,1/2", 

"3/4,3/4,3/4", "1/4,1/4,3/4", "1/4,3/4,1/4", "3/4,1/4,1/4", 

"1/4,1/4,1/4", "3/4,3/4,1/4", "3/4,1/4,3/4", "1/4,3/4,3/4", 

"0,0,0", "1/2,1/2,1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_209 [84] = {
"x,y,z", "-x,-y,z", "-x,y,-z", "x,-y,-z", 
"z,x,y", "z,-x,-y", "-z,-x,y", "-z,x,-y", 
"y,z,x", "-y,z,-x", "y,-z,-x", "-y,-z,x", 
"y,x,-z", "-y,-x,-z", "y,-x,z", "-y,x,z", 
"x,z,-y", "-x,z,y", "-x,-z,-y", "x,-z,y", 
"z,y,-x", "z,-y,x", "-z,y,x", "-z,-y,-x", 

"x,1/4,1/4", "-x,3/4,1/4", "1/4,x,1/4", "1/4,-x,3/4", "1/4,1/4,x", "3/4,1/4,-x", 
"1/4,x,3/4", "3/4,-x,3/4", "x,1/4,3/4", "-x,1/4,1/4", "1/4,1/4,-x", "1/4,3/4,x", 

"1/2,y,y", "1/2,-y,y", "1/2,y,-y", "1/2,-y,-y", "y,1/2,y", "y,1/2,-y", 
"-y,1/2,y", "-y,1/2,-y", "y,y,1/2", "-y,y,1/2", "y,-y,1/2", "-y,-y,1/2", 

"0,y,y", "0,-y,y", "0,y,-y", "0,-y,-y", "y,0,y", "y,0,-y", 
"-y,0,y", "-y,0,-y", "y,y,0", "-y,y,0", "y,-y,0", "-y,-y,0",

"x,x,x", "-x,-x,x", "-x,x,-x", "x,-x,-x", 
"x,x,-x", "-x,-x,-x", "x,-x,x", "-x,x,x", 

"x,0,0", "-x,0,0", "0,x,0", "0,-x,0", "0,0,x", "0,0,-x", 

"0,1/4,1/4", "0,3/4,1/4", "1/4,0,1/4", "1/4,0,3/4", "1/4,1/4,0", "3/4,1/4,0", 

"1/4,1/4,1/4", "1/4,1/4,3/4", 

"1/2,1/2,1/2", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_210 [68] = {
"x,y,z", "-x,-y+1/2,z+1/2", "-x+1/2,y+1/2,-z", "x+1/2,-y,-z+1/2", 
"z,x,y", "z+1/2,-x,-y+1/2", "-z,-x+1/2,y+1/2", "-z+1/2,x+1/2,-y", 
"y,z,x", "-y+1/2,z+1/2,-x", "y+1/2,-z,-x+1/2", "-y,-z+1/2,x+1/2", 
"y+3/4,x+1/4,-z+3/4", "-y+1/4,-x+1/4,-z+1/4", "y+1/4,-x+3/4,z+3/4", "-y+3/4,x+3/4,z+1/4", 
"x+3/4,z+1/4,-y+3/4", "-x+3/4,z+3/4,y+1/4", "-x+1/4,-z+1/4,-y+1/4", "x+1/4,-z+3/4,y+3/4", 
"z+3/4,y+1/4,-x+3/4", "z+1/4,-y+3/4,x+3/4", "-z+3/4,y+3/4,x+1/4", "-z+1/4,-y+1/4,-x+1/4", 

"1/8,y,-y+1/4", "7/8,-y+1/2,-y+3/4", "3/8,y+1/2,y+3/4", "5/8,-y,y+1/4", 
"-y+1/4,1/8,y", "-y+3/4,7/8,-y+1/2", "y+3/4,3/8,y+1/2", "y+1/4,5/8,-y", 
"y,-y+1/4,1/8", "-y+1/2,-y+3/4,7/8", "y+1/2,y+3/4,3/8", "-y,y+1/4,5/8", 

"x,0,0", "-x,1/2,1/2", "0,x,0", "1/2,-x,1/2", "0,0,x", "1/2,1/2,-x", 
"3/4,x+1/4,3/4", "1/4,-x+1/4,1/4", "x+3/4,1/4,3/4", "-x+3/4,3/4,1/4", "3/4,1/4,-x+3/4", "1/4,3/4,x+3/4", 

"x,x,x", "-x,-x+1/2,x+1/2", "-x+1/2,x+1/2,-x", "x+1/2,-x,-x+1/2", 
"x+3/4,x+1/4,-x+3/4", "-x+1/4,-x+1/4,-x+1/4", "x+1/4,-x+3/4,x+3/4", "-x+3/4,x+3/4,x+1/4", 

"5/8,5/8,5/8", "3/8,7/8,1/8", "7/8,1/8,3/8", "1/8,3/8,7/8", 

"1/8,1/8,1/8", "7/8,3/8,5/8", "3/8,5/8,7/8", "5/8,7/8,3/8", 

"1/2,1/2,1/2", "1/4,3/4,1/4", 

"0,0,0", "3/4,1/4,3/4", 
};

const char *gamgi_phys_symmetry_wyckoff_211 [88] = {
"x,y,z", "-x,-y,z", "-x,y,-z", "x,-y,-z", 
"z,x,y", "z,-x,-y", "-z,-x,y", "-z,x,-y", 
"y,z,x", "-y,z,-x", "y,-z,-x", "-y,-z,x", 
"y,x,-z", "-y,-x,-z", "y,-x,z", "-y,x,z", 
"x,z,-y", "-x,z,y", "-x,-z,-y", "x,-z,y", 
"z,y,-x", "z,-y,x", "-z,y,x", "-z,-y,-x", 

"1/4,y,-y+1/2", "3/4,-y,-y+1/2", "3/4,y,y+1/2", "1/4,-y,y+1/2", 
"-y+1/2,1/4,y", "-y+1/2,3/4,-y", "y+1/2,3/4,y", "y+1/2,1/4,-y", 
"y,-y+1/2,1/4", "-y,-y+1/2,3/4", "y,y+1/2,3/4", "-y,y+1/2,1/4", 

"0,y,y", "0,-y,y", "0,y,-y", "0,-y,-y", "y,0,y", "y,0,-y", 
"-y,0,y", "-y,0,-y", "y,y,0", "-y,y,0", "y,-y,0", "-y,-y,0", 

"x,1/2,0", "-x,1/2,0", "0,x,1/2", "0,-x,1/2", "1/2,0,x", "1/2,0,-x", 
"1/2,x,0", "1/2,-x,0", "x,0,1/2", "-x,0,1/2", "0,1/2,-x", "0,1/2,x", 

"x,x,x", "-x,-x,x", "-x,x,-x", "x,-x,-x", 
"x,x,-x", "-x,-x,-x", "x,-x,x", "-x,x,x", 

"x,0,0", "-x,0,0", "0,x,0", "0,-x,0", "0,0,x", "0,0,-x", 

"1/4,1/2,0", "3/4,1/2,0", "0,1/4,1/2", "0,3/4,1/2", "1/2,0,1/4", "1/2,0,3/4", 

"1/4,1/4,1/4", "3/4,3/4,1/4", "3/4,1/4,3/4", "1/4,3/4,3/4", 

"0,1/2,1/2", "1/2,0,1/2", "1/2,1/2,0", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_212 [52] = {
"x,y,z", "-x+1/2,-y,z+1/2", "-x,y+1/2,-z+1/2", "x+1/2,-y+1/2,-z", 
"z,x,y", "z+1/2,-x+1/2,-y", "-z+1/2,-x,y+1/2", "-z,x+1/2,-y+1/2", 
"y,z,x", "-y,z+1/2,-x+1/2", "y+1/2,-z+1/2,-x", "-y+1/2,-z,x+1/2", 
"y+1/4,x+3/4,-z+3/4", "-y+1/4,-x+1/4,-z+1/4", "y+3/4,-x+3/4,z+1/4", "-y+3/4,x+1/4,z+3/4", 
"x+1/4,z+3/4,-y+3/4", "-x+3/4,z+1/4,y+3/4", "-x+1/4,-z+1/4,-y+1/4", "x+3/4,-z+3/4,y+1/4", 
"z+1/4,y+3/4,-x+3/4", "z+3/4,-y+3/4,x+1/4", "-z+3/4,y+1/4,x+3/4", "-z+1/4,-y+1/4,-x+1/4", 

"1/8,y,-y+1/4", "3/8,-y,-y+3/4", "7/8,y+1/2,y+1/4", "5/8,-y+1/2,y+3/4", 
"-y+1/4,1/8,y", "-y+3/4,3/8,-y", "y+1/4,7/8,y+1/2", "y+3/4,5/8,-y+1/2", 
"y,-y+1/4,1/8", "-y,-y+3/4,3/8", "y+1/2,y+1/4,7/8", "-y+1/2,y+3/4,5/8", 

"x,x,x", "-x+1/2,-x,x+1/2", "-x,x+1/2,-x+1/2", "x+1/2,-x+1/2,-x", 
"x+1/4,x+3/4,-x+3/4", "-x+1/4,-x+1/4,-x+1/4", "x+3/4,-x+3/4,x+1/4", "-x+3/4,x+1/4,x+3/4", 

"5/8,5/8,5/8", "7/8,3/8,1/8", "3/8,1/8,7/8", "1/8,7/8,3/8", 

"1/8,1/8,1/8", "3/8,7/8,5/8", "7/8,5/8,3/8", "5/8,3/8,7/8", 
};

const char *gamgi_phys_symmetry_wyckoff_213 [52] = {
"x,y,z", "-x+1/2,-y,z+1/2", "-x,y+1/2,-z+1/2", "x+1/2,-y+1/2,-z", 
"z,x,y", "z+1/2,-x+1/2,-y", "-z+1/2,-x,y+1/2", "-z,x+1/2,-y+1/2", 
"y,z,x", "-y,z+1/2,-x+1/2", "y+1/2,-z+1/2,-x", "-y+1/2,-z,x+1/2", 
"y+3/4,x+1/4,-z+1/4", "-y+3/4,-x+3/4,-z+3/4", "y+1/4,-x+1/4,z+3/4", "-y+1/4,x+3/4,z+1/4", 
"x+3/4,z+1/4,-y+1/4", "-x+1/4,z+3/4,y+1/4", "-x+3/4,-z+3/4,-y+3/4", "x+1/4,-z+1/4,y+3/4", 
"z+3/4,y+1/4,-x+1/4", "z+1/4,-y+1/4,x+3/4", "-z+1/4,y+3/4,x+1/4", "-z+3/4,-y+3/4,-x+3/4", 

"1/8,y,y+1/4", "3/8,-y,y+3/4", "7/8,y+1/2,-y+1/4", "5/8,-y+1/2,-y+3/4", 
"y+1/4,1/8,y", "y+3/4,3/8,-y", "-y+1/4,7/8,y+1/2", "-y+3/4,5/8,-y+1/2", 
"y,y+1/4,1/8", "-y,y+3/4,3/8", "y+1/2,-y+1/4,7/8", "-y+1/2,-y+3/4,5/8", 

"x,x,x", "-x+1/2,-x,x+1/2", "-x,x+1/2,-x+1/2", "x+1/2,-x+1/2,-x", 
"x+3/4,x+1/4,-x+1/4", "-x+3/4,-x+3/4,-x+3/4", "x+1/4,-x+1/4,x+3/4", "-x+1/4,x+3/4,x+1/4", 

"7/8,7/8,7/8", "5/8,1/8,3/8", "1/8,3/8,5/8", "3/8,5/8,1/8", 

"3/8,3/8,3/8", "1/8,5/8,7/8", "5/8,7/8,1/8", "7/8,1/8,5/8", 
};

const char *gamgi_phys_symmetry_wyckoff_214 [88] = {
"x,y,z", "-x+1/2,-y,z+1/2", "-x,y+1/2,-z+1/2", "x+1/2,-y+1/2,-z", 
"z,x,y", "z+1/2,-x+1/2,-y", "-z+1/2,-x,y+1/2", "-z,x+1/2,-y+1/2", 
"y,z,x", "-y,z+1/2,-x+1/2", "y+1/2,-z+1/2,-x", "-y+1/2,-z,x+1/2", 
"y+3/4,x+1/4,-z+1/4", "-y+3/4,-x+3/4,-z+3/4", "y+1/4,-x+1/4,z+3/4", "-y+1/4,x+3/4,z+1/4", 
"x+3/4,z+1/4,-y+1/4", "-x+1/4,z+3/4,y+1/4", "-x+3/4,-z+3/4,-y+3/4", "x+1/4,-z+1/4,y+3/4", 
"z+3/4,y+1/4,-x+1/4", "z+1/4,-y+1/4,x+3/4", "-z+1/4,y+3/4,x+1/4", "-z+3/4,-y+3/4,-x+3/4", 

"1/8,y,-y+1/4", "3/8,-y,-y+3/4", "7/8,y+1/2,y+1/4", "5/8,-y+1/2,y+3/4", 
"-y+1/4,1/8,y", "-y+3/4,3/8,-y", "y+1/4,7/8,y+1/2", "y+3/4,5/8,-y+1/2", 
"y,-y+1/4,1/8", "-y,-y+3/4,3/8", "y+1/2,y+1/4,7/8", "-y+1/2,y+3/4,5/8", 

"1/8,y,y+1/4", "3/8,-y,y+3/4", "7/8,y+1/2,-y+1/4", "5/8,-y+1/2,-y+3/4", 
"y+1/4,1/8,y", "y+3/4,3/8,-y", "-y+1/4,7/8,y+1/2", "-y+3/4,5/8,-y+1/2", 
"y,y+1/4,1/8", "-y,y+3/4,3/8", "y+1/2,-y+1/4,7/8", "-y+1/2,-y+3/4,5/8", 

"x,0,1/4", "-x+1/2,0,3/4", "1/4,x,0", "3/4,-x+1/2,0", "0,1/4,x", "0,3/4,-x+1/2", 
"3/4,x+1/4,0", "3/4,-x+3/4,1/2", "x+3/4,1/2,1/4", "-x+1/4,0,1/4", "0,1/4,-x+1/4", "1/2,1/4,x+3/4", 

"x,x,x", "-x+1/2,-x,x+1/2", "-x,x+1/2,-x+1/2", "x+1/2,-x+1/2,-x", 
"x+3/4,x+1/4,-x+1/4", "-x+3/4,-x+3/4,-x+3/4", "x+1/4,-x+1/4,x+3/4", "-x+1/4,x+3/4,x+1/4", 

"5/8,0,1/4", "7/8,0,3/4", "1/4,5/8,0", "3/4,7/8,0", "0,1/4,5/8", "0,3/4,7/8", 

"1/8,0,1/4", "3/8,0,3/4", "1/4,1/8,0", "3/4,3/8,0", "0,1/4,1/8", "0,3/4,3/8", 

"7/8,7/8,7/8", "5/8,1/8,3/8", "1/8,3/8,5/8", "3/8,5/8,1/8", 

"1/8,1/8,1/8", "3/8,7/8,5/8", "7/8,5/8,3/8", "5/8,3/8,7/8", 
};

const char *gamgi_phys_symmetry_wyckoff_215 [72] = {
"x,y,z", "-x,-y,z", "-x,y,-z", "x,-y,-z", 
"z,x,y", "z,-x,-y", "-z,-x,y", "-z,x,-y", 
"y,z,x", "-y,z,-x", "y,-z,-x", "-y,-z,x", 
"y,x,z", "-y,-x,z", "y,-x,-z", "-y,x,-z", 
"x,z,y", "-x,z,-y", "-x,-z,y", "x,-z,-y", 
"z,y,x", "z,-y,-x", "-z,y,-x", "-z,-y,x", 

"x,x,z", "-x,-x,z", "-x,x,-z", "x,-x,-z", "z,x,x", "z,-x,-x", 
"-z,-x,x", "-z,x,-x", "x,z,x", "-x,z,-x", "x,-z,-x", "-x,-z,x", 

"x,1/2,0", "-x,1/2,0", "0,x,1/2", "0,-x,1/2", "1/2,0,x", "1/2,0,-x", 
"1/2,x,0", "1/2,-x,0", "x,0,1/2", "-x,0,1/2", "0,1/2,x", "0,1/2,-x", 

"x,1/2,1/2", "-x,1/2,1/2", "1/2,x,1/2", "1/2,-x,1/2", "1/2,1/2,x", "1/2,1/2,-x", 

"x,0,0", "-x,0,0", "0,x,0", "0,-x,0", "0,0,x", "0,0,-x", 

"x,x,x", "-x,-x,x", "-x,x,-x", "x,-x,-x", 

"1/2,0,0", "0,1/2,0", "0,0,1/2", 

"0,1/2,1/2", "1/2,0,1/2", "1/2,1/2,0", 

"1/2,1/2,1/2", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_216 [56] = {
"x,y,z", "-x,-y,z", "-x,y,-z", "x,-y,-z", 
"z,x,y", "z,-x,-y", "-z,-x,y", "-z,x,-y", 
"y,z,x", "-y,z,-x", "y,-z,-x", "-y,-z,x", 
"y,x,z", "-y,-x,z", "y,-x,-z", "-y,x,-z", 
"x,z,y", "-x,z,-y", "-x,-z,y", "x,-z,-y", 
"z,y,x", "z,-y,-x", "-z,y,-x", "-z,-y,x", 

"x,x,z", "-x,-x,z", "-x,x,-z", "x,-x,-z", "z,x,x", "z,-x,-x", 
"-z,-x,x", "-z,x,-x", "x,z,x", "-x,z,-x", "x,-z,-x", "-x,-z,x", 

"x,1/4,1/4", "-x,3/4,1/4", "1/4,x,1/4", "1/4,-x,3/4", "1/4,1/4,x", "3/4,1/4,-x", 

"x,0,0", "-x,0,0", "0,x,0", "0,-x,0", "0,0,x", "0,0,-x", 

"x,x,x", "-x,-x,x", "-x,x,-x", "x,-x,-x", 

"3/4,3/4,3/4", 

"1/4,1/4,1/4", 

"1/2,1/2,1/2", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_217 [68] = {
"x,y,z", "-x,-y,z", "-x,y,-z", "x,-y,-z", 
"z,x,y", "z,-x,-y", "-z,-x,y", "-z,x,-y", 
"y,z,x", "-y,z,-x", "y,-z,-x", "-y,-z,x", 
"y,x,z", "-y,-x,z", "y,-x,-z", "-y,x,-z", 
"x,z,y", "-x,z,-y", "-x,-z,y", "x,-z,-y", 
"z,y,x", "z,-y,-x", "-z,y,-x", "-z,-y,x", 

"x,x,z", "-x,-x,z", "-x,x,-z", "x,-x,-z", "z,x,x", "z,-x,-x", 
"-z,-x,x", "-z,x,-x", "x,z,x", "-x,z,-x", "x,-z,-x", "-x,-z,x", 

"x,1/2,0", "-x,1/2,0", "0,x,1/2", "0,-x,1/2", "1/2,0,x", "1/2,0,-x", 
"1/2,x,0", "1/2,-x,0", "x,0,1/2", "-x,0,1/2", "0,1/2,x", "0,1/2,-x", 

"x,0,0", "-x,0,0", "0,x,0", "0,-x,0", "0,0,x", "0,0,-x", 

"1/4,1/2,0", "3/4,1/2,0", "0,1/4,1/2", "0,3/4,1/2", "1/2,0,1/4", "1/2,0,3/4", 

"x,x,x", "-x,-x,x", "-x,x,-x", "x,-x,-x", 

"0,1/2,1/2", "1/2,0,1/2", "1/2,1/2,0",

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_218 [88] = {
"x,y,z", "-x,-y,z", "-x,y,-z", "x,-y,-z", 
"z,x,y", "z,-x,-y", "-z,-x,y", "-z,x,-y", 
"y,z,x", "-y,z,-x", "y,-z,-x", "-y,-z,x", 
"y+1/2,x+1/2,z+1/2", "-y+1/2,-x+1/2,z+1/2", "y+1/2,-x+1/2,-z+1/2", "-y+1/2,x+1/2,-z+1/2", 
"x+1/2,z+1/2,y+1/2", "-x+1/2,z+1/2,-y+1/2", "-x+1/2,-z+1/2,y+1/2", "x+1/2,-z+1/2,-y+1/2", 
"z+1/2,y+1/2,x+1/2", "z+1/2,-y+1/2,-x+1/2", "-z+1/2,y+1/2,-x+1/2", "-z+1/2,-y+1/2,x+1/2", 

"x,0,1/2", "-x,0,1/2", "1/2,x,0", "1/2,-x,0", "0,1/2,x", "0,1/2,-x", 
"1/2,x+1/2,0", "1/2,-x+1/2,0", "x+1/2,0,1/2", "-x+1/2,0,1/2", "0,1/2,x+1/2", "0,1/2,-x+1/2", 

"x,1/2,0", "-x,1/2,0", "0,x,1/2", "0,-x,1/2", "1/2,0,x", "1/2,0,-x", 
"0,x+1/2,1/2", "0,-x+1/2,1/2", "x+1/2,1/2,0", "-x+1/2,1/2,0", "1/2,0,x+1/2", "1/2,0,-x+1/2", 

"x,0,0", "-x,0,0", "0,x,0", "0,-x,0", "0,0,x", "0,0,-x", 
"1/2,x+1/2,1/2", "1/2,-x+1/2,1/2", "x+1/2,1/2,1/2", "-x+1/2,1/2,1/2", "1/2,1/2,x+1/2", "1/2,1/2,-x+1/2", 

"x,x,x", "-x,-x,x", "-x,x,-x", "x,-x,-x", 
"x+1/2,x+1/2,x+1/2", "-x+1/2,-x+1/2,x+1/2", "x+1/2,-x+1/2,-x+1/2", "-x+1/2,x+1/2,-x+1/2", 

"1/4,0,1/2", "3/4,0,1/2", "1/2,1/4,0", "1/2,3/4,0", "0,1/2,1/4", "0,1/2,3/4", 

"1/4,1/2,0", "3/4,1/2,0", "0,1/4,1/2", "0,3/4,1/2", "1/2,0,1/4", "1/2,0,3/4", 

"0,1/2,1/2", "1/2,0,1/2", "1/2,1/2,0", "0,1/2,0", "1/2,0,0", "0,0,1/2", 

"0,0,0", "1/2,1/2,1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_219 [72] = {
"x,y,z", "-x,-y,z", "-x,y,-z", "x,-y,-z", 
"z,x,y", "z,-x,-y", "-z,-x,y", "-z,x,-y", 
"y,z,x", "-y,z,-x", "y,-z,-x", "-y,-z,x", 
"y+1/2,x+1/2,z+1/2", "-y+1/2,-x+1/2,z+1/2", "y+1/2,-x+1/2,-z+1/2", "-y+1/2,x+1/2,-z+1/2", 
"x+1/2,z+1/2,y+1/2", "-x+1/2,z+1/2,-y+1/2", "-x+1/2,-z+1/2,y+1/2", "x+1/2,-z+1/2,-y+1/2", 
"z+1/2,y+1/2,x+1/2", "z+1/2,-y+1/2,-x+1/2", "-z+1/2,y+1/2,-x+1/2", "-z+1/2,-y+1/2,x+1/2", 

"x,1/4,1/4", "-x,3/4,1/4", "1/4,x,1/4", "1/4,-x,3/4", "1/4,1/4,x", "3/4,1/4,-x", 
"3/4,x+1/2,3/4", "1/4,-x+1/2,3/4", "x+1/2,3/4,3/4", "-x+1/2,3/4,1/4", "3/4,3/4,x+1/2", "3/4,1/4,-x+1/2", 

"x,0,0", "-x,0,0", "0,x,0", "0,-x,0", "0,0,x", "0,0,-x", 
"1/2,x+1/2,1/2", "1/2,-x+1/2,1/2", "x+1/2,1/2,1/2", "-x+1/2,1/2,1/2", "1/2,1/2,x+1/2", "1/2,1/2,-x+1/2", 

"x,x,x", "-x,-x,x", "-x,x,-x", "x,-x,-x", 
"x+1/2,x+1/2,x+1/2", "-x+1/2,-x+1/2,x+1/2", "x+1/2,-x+1/2,-x+1/2", "-x+1/2,x+1/2,-x+1/2", 

"1/4,0,0", "3/4,0,0", "0,1/4,0", "0,3/4,0", "0,0,1/4", "0,0,3/4", 

"0,1/4,1/4", "0,3/4,1/4", "1/4,0,1/4", "1/4,0,3/4", "1/4,1/4,0", "3/4,1/4,0", 

"1/4,1/4,1/4", "3/4,3/4,3/4", 

"0,0,0", "1/2,1/2,1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_220 [56] = {
"x,y,z", "-x+1/2,-y,z+1/2", "-x,y+1/2,-z+1/2", "x+1/2,-y+1/2,-z", 
"z,x,y", "z+1/2,-x+1/2,-y", "-z+1/2,-x,y+1/2", "-z,x+1/2,-y+1/2", 
"y,z,x", "-y,z+1/2,-x+1/2", "y+1/2,-z+1/2,-x", "-y+1/2,-z,x+1/2", 
"y+1/4,x+1/4,z+1/4", "-y+1/4,-x+3/4,z+3/4", "y+3/4,-x+1/4,-z+3/4", "-y+3/4,x+3/4,-z+1/4", 
"x+1/4,z+1/4,y+1/4", "-x+3/4,z+3/4,-y+1/4", "-x+1/4,-z+3/4,y+3/4", "x+3/4,-z+1/4,-y+3/4", 
"z+1/4,y+1/4,x+1/4", "z+3/4,-y+1/4,-x+3/4", "-z+3/4,y+3/4,-x+1/4", "-z+1/4,-y+3/4,x+3/4", 

"x,0,1/4", "-x+1/2,0,3/4", "1/4,x,0", "3/4,-x+1/2,0", "0,1/4,x", "0,3/4,-x+1/2", 
"1/4,x+1/4,1/2", "1/4,-x+3/4,0", "x+1/4,1/2,1/4", "-x+3/4,0,1/4", "1/2,1/4,x+1/4", "0,1/4,-x+3/4", 

"x,x,x", "-x+1/2,-x,x+1/2", "-x,x+1/2,-x+1/2", "x+1/2,-x+1/2,-x", 
"x+1/4,x+1/4,x+1/4", "-x+1/4,-x+3/4,x+3/4", "x+3/4,-x+1/4,-x+3/4", "-x+3/4,x+3/4,-x+1/4", 

"7/8,0,1/4", "5/8,0,3/4", "1/4,7/8,0", "3/4,5/8,0", "0,1/4,7/8", "0,3/4,5/8", 

"3/8,0,1/4", "1/8,0,3/4", "1/4,3/8,0", "3/4,1/8,0", "0,1/4,3/8", "0,3/4,1/8", 
};

const char *gamgi_phys_symmetry_wyckoff_221 [184] = {
"x,y,z", "-x,-y,z", "-x,y,-z", "x,-y,-z", 
"z,x,y", "z,-x,-y", "-z,-x,y", "-z,x,-y", 
"y,z,x", "-y,z,-x", "y,-z,-x", "-y,-z,x", 
"y,x,-z", "-y,-x,-z", "y,-x,z", "-y,x,z", 
"x,z,-y", "-x,z,y", "-x,-z,-y", "x,-z,y", 
"z,y,-x", "z,-y,x", "-z,y,x", "-z,-y,-x", 
"-x,-y,-z", "x,y,-z", "x,-y,z", "-x,y,z", 
"-z,-x,-y", "-z,x,y", "z,x,-y", "z,-x,y", 
"-y,-z,-x", "y,-z,x", "-y,z,x", "y,z,-x", 
"-y,-x,z", "y,x,z", "-y,x,-z", "y,-x,-z", 
"-x,-z,y", "x,-z,-y", "x,z,y", "-x,z,-y", 
"-z,-y,x", "-z,y,-x", "z,-y,-x", "z,y,x", 

"x,x,z", "-x,-x,z", "-x,x,-z", "x,-x,-z", "z,x,x", "z,-x,-x", 
"-z,-x,x", "-z,x,-x", "x,z,x", "-x,z,-x", "x,-z,-x", "-x,-z,x", 
"x,x,-z", "-x,-x,-z", "x,-x,z", "-x,x,z", "x,z,-x", "-x,z,x", 
"-x,-z,-x", "x,-z,x", "z,x,-x", "z,-x,x", "-z,x,x", "-z,-x,-x", 

"1/2,y,z", "1/2,-y,z", "1/2,y,-z", "1/2,-y,-z", "z,1/2,y", "z,1/2,-y", 
"-z,1/2,y", "-z,1/2,-y", "y,z,1/2", "-y,z,1/2", "y,-z,1/2", "-y,-z,1/2", 
"y,1/2,-z", "-y,1/2,-z", "y,1/2,z", "-y,1/2,z", "1/2,z,-y", "1/2,z,y", 
"1/2,-z,-y", "1/2,-z,y", "z,y,1/2", "z,-y,1/2", "-z,y,1/2", "-z,-y,1/2", 

"0,y,z", "0,-y,z", "0,y,-z", "0,-y,-z", "z,0,y", "z,0,-y", 
"-z,0,y", "-z,0,-y", "y,z,0", "-y,z,0", "y,-z,0", "-y,-z,0", 
"y,0,-z", "-y,0,-z", "y,0,z", "-y,0,z", "0,z,-y", "0,z,y", 
"0,-z,-y", "0,-z,y", "z,y,0", "z,-y,0", "-z,y,0", "-z,-y,0", 

"1/2,y,y", "1/2,-y,y", "1/2,y,-y", "1/2,-y,-y", "y,1/2,y", "y,1/2,-y", 
"-y,1/2,y", "-y,1/2,-y", "y,y,1/2", "-y,y,1/2", "y,-y,1/2", "-y,-y,1/2", 

"0,y,y", "0,-y,y", "0,y,-y", "0,-y,-y", "y,0,y", "y,0,-y", 
"-y,0,y", "-y,0,-y", "y,y,0", "-y,y,0", "y,-y,0", "-y,-y,0", 

"x,1/2,0", "-x,1/2,0", "0,x,1/2", "0,-x,1/2", "1/2,0,x", "1/2,0,-x", 
"1/2,x,0", "1/2,-x,0", "x,0,1/2", "-x,0,1/2", "0,1/2,-x", "0,1/2,x", 

"x,x,x", "-x,-x,x", "-x,x,-x", "x,-x,-x", 
"x,x,-x", "-x,-x,-x", "x,-x,x", "-x,x,x", 

"x,1/2,1/2", "-x,1/2,1/2", "1/2,x,1/2", "1/2,-x,1/2", "1/2,1/2,x", "1/2,1/2,-x", 

"x,0,0", "-x,0,0", "0,x,0", "0,-x,0", "0,0,x", "0,0,-x", 

"1/2,0,0", "0,1/2,0", "0,0,1/2", 

"0,1/2,1/2", "1/2,0,1/2", "1/2,1/2,0", 

"1/2,1/2,1/2", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_222 [152] = {
"x,y,z", "-x+1/2,-y+1/2,z", "-x+1/2,y,-z+1/2", "x,-y+1/2,-z+1/2", 
"z,x,y", "z,-x+1/2,-y+1/2", "-z+1/2,-x+1/2,y", "-z+1/2,x,-y+1/2", 
"y,z,x", "-y+1/2,z,-x+1/2", "y,-z+1/2,-x+1/2", "-y+1/2,-z+1/2,x", 
"y,x,-z+1/2", "-y+1/2,-x+1/2,-z+1/2", "y,-x+1/2,z", "-y+1/2,x,z", 
"x,z,-y+1/2", "-x+1/2,z,y", "-x+1/2,-z+1/2,-y+1/2", "x,-z+1/2,y", 
"z,y,-x+1/2", "z,-y+1/2,x", "-z+1/2,y,x", "-z+1/2,-y+1/2,-x+1/2", 
"-x,-y,-z", "x+1/2,y+1/2,-z", "x+1/2,-y,z+1/2", "-x,y+1/2,z+1/2", 
"-z,-x,-y", "-z,x+1/2,y+1/2", "z+1/2,x+1/2,-y", "z+1/2,-x,y+1/2", 
"-y,-z,-x", "y+1/2,-z,x+1/2", "-y,z+1/2,x+1/2", "y+1/2,z+1/2,-x", 
"-y,-x,z+1/2", "y+1/2,x+1/2,z+1/2", "-y,x+1/2,-z", "y+1/2,-x,-z", 
"-x,-z,y+1/2", "x+1/2,-z,-y", "x+1/2,z+1/2,y+1/2", "-x,z+1/2,-y", 
"-z,-y,x+1/2", "-z,y+1/2,-x", "z+1/2,-y,-x", "z+1/2,y+1/2,x+1/2", 

"1/4,y,y", "1/4,-y+1/2,y", "1/4,y,-y+1/2", "1/4,-y+1/2,-y+1/2", 
"y,1/4,y", "y,1/4,-y+1/2", "-y+1/2,1/4,y", "-y+1/2,1/4,-y+1/2", 
"y,y,1/4", "-y+1/2,y,1/4", "y,-y+1/2,1/4", "-y+1/2,-y+1/2,1/4", 
"3/4,-y,-y", "3/4,y+1/2,-y", "3/4,-y,y+1/2", "3/4,y+1/2,y+1/2", 
"-y,3/4,-y", "-y,3/4,y+1/2", "y+1/2,3/4,-y", "y+1/2,3/4,y+1/2", 
"-y,-y,3/4", "y+1/2,-y,3/4", "-y,y+1/2,3/4", "y+1/2,y+1/2,3/4", 

"x,3/4,1/4", "-x+1/2,3/4,1/4", "1/4,x,3/4", "1/4,-x+1/2,3/4", "3/4,1/4,x", "3/4,1/4,-x+1/2", 
"3/4,x,1/4", "3/4,-x+1/2,1/4", "x,1/4,3/4", "-x+1/2,1/4,3/4", "1/4,3/4,-x+1/2", "1/4,3/4,x", 
"-x,1/4,3/4", "x+1/2,1/4,3/4", "3/4,-x,1/4", "3/4,x+1/2,1/4", "1/4,3/4,-x", "1/4,3/4,x+1/2", 
"1/4,-x,3/4", "1/4,x+1/2,3/4", "-x,3/4,1/4", "x+1/2,3/4,1/4", "3/4,1/4,x+1/2", "3/4,1/4,-x", 

"x,x,x", "-x+1/2,-x+1/2,x", "-x+1/2,x,-x+1/2", "x,-x+1/2,-x+1/2", 
"x,x,-x+1/2", "-x+1/2,-x+1/2,-x+1/2", "x,-x+1/2,x", "-x+1/2,x,x", 
"-x,-x,-x", "x+1/2,x+1/2,-x", "x+1/2,-x,x+1/2", "-x,x+1/2,x+1/2", 
"-x,-x,x+1/2", "x+1/2,x+1/2,x+1/2", "-x,x+1/2,-x", "x+1/2,-x,-x", 

"x,1/4,1/4", "-x+1/2,1/4,1/4", "1/4,x,1/4", "1/4,-x+1/2,1/4", "1/4,1/4,x", "1/4,1/4,-x+1/2", 
"-x,3/4,3/4", "x+1/2,3/4,3/4", "3/4,-x,3/4", "3/4,x+1/2,3/4", "3/4,3/4,-x", "3/4,3/4,x+1/2", 

"0,3/4,1/4", "1/2,3/4,1/4", "1/4,0,3/4", "1/4,1/2,3/4", "3/4,1/4,0", "3/4,1/4,1/2", 
"3/4,0,1/4", "3/4,1/2,1/4", "0,1/4,3/4", "1/2,1/4,3/4", "1/4,3/4,1/2", "1/4,3/4,0", 

"0,0,0", "1/2,1/2,0", "1/2,0,1/2", "0,1/2,1/2", 
"0,0,1/2", "1/2,1/2,1/2", "0,1/2,0", "1/2,0,0", 

"3/4,1/4,1/4", "1/4,3/4,1/4", "1/4,1/4,3/4", "1/4,3/4,3/4", "3/4,1/4,3/4", "3/4,3/4,1/4", 

"1/4,1/4,1/4", "3/4,3/4,3/4", 
};

const char *gamgi_phys_symmetry_wyckoff_223 [176] = {
"x,y,z", "-x,-y,z", "-x,y,-z", "x,-y,-z", 
"z,x,y", "z,-x,-y", "-z,-x,y", "-z,x,-y", 
"y,z,x", "-y,z,-x", "y,-z,-x", "-y,-z,x", 
"y+1/2,x+1/2,-z+1/2", "-y+1/2,-x+1/2,-z+1/2", "y+1/2,-x+1/2,z+1/2", "-y+1/2,x+1/2,z+1/2", 
"x+1/2,z+1/2,-y+1/2", "-x+1/2,z+1/2,y+1/2", "-x+1/2,-z+1/2,-y+1/2", "x+1/2,-z+1/2,y+1/2", 
"z+1/2,y+1/2,-x+1/2", "z+1/2,-y+1/2,x+1/2", "-z+1/2,y+1/2,x+1/2", "-z+1/2,-y+1/2,-x+1/2", 
"-x,-y,-z", "x,y,-z", "x,-y,z", "-x,y,z", 
"-z,-x,-y", "-z,x,y", "z,x,-y", "z,-x,y", 
"-y,-z,-x", "y,-z,x", "-y,z,x", "y,z,-x", 
"-y+1/2,-x+1/2,z+1/2", "y+1/2,x+1/2,z+1/2", "-y+1/2,x+1/2,-z+1/2", "y+1/2,-x+1/2,-z+1/2", 
"-x+1/2,-z+1/2,y+1/2", "x+1/2,-z+1/2,-y+1/2", "x+1/2,z+1/2,y+1/2", "-x+1/2,z+1/2,-y+1/2", 
"-z+1/2,-y+1/2,x+1/2", "-z+1/2,y+1/2,-x+1/2", "z+1/2,-y+1/2,-x+1/2", "z+1/2,y+1/2,x+1/2", 

"0,y,z", "0,-y,z", "0,y,-z", "0,-y,-z", 
"z,0,y", "z,0,-y", "-z,0,y", "-z,0,-y", 
"y,z,0", "-y,z,0", "y,-z,0", "-y,-z,0", 
"y+1/2,1/2,-z+1/2", "-y+1/2,1/2,-z+1/2", "y+1/2,1/2,z+1/2", "-y+1/2,1/2,z+1/2", 
"1/2,z+1/2,-y+1/2", "1/2,z+1/2,y+1/2", "1/2,-z+1/2,-y+1/2", "1/2,-z+1/2,y+1/2", 
"z+1/2,y+1/2,1/2", "z+1/2,-y+1/2,1/2", "-z+1/2,y+1/2,1/2", "-z+1/2,-y+1/2,1/2", 

"1/4,y,y+1/2", "3/4,-y,y+1/2", "3/4,y,-y+1/2", "1/4,-y,-y+1/2", 
"y+1/2,1/4,y", "y+1/2,3/4,-y", "-y+1/2,3/4,y", "-y+1/2,1/4,-y", 
"y,y+1/2,1/4", "-y,y+1/2,3/4", "y,-y+1/2,3/4", "-y,-y+1/2,1/4", 
"3/4,-y,-y+1/2", "1/4,y,-y+1/2", "1/4,-y,y+1/2", "3/4,y,y+1/2", 
"-y+1/2,3/4,-y", "-y+1/2,1/4,y", "y+1/2,1/4,-y", "y+1/2,3/4,y", 
"-y,-y+1/2,3/4", "y,-y+1/2,1/4", "-y,y+1/2,1/4", "y,y+1/2,3/4", 

"x,x,x", "-x,-x,x", "-x,x,-x", "x,-x,-x", 
"x+1/2,x+1/2,-x+1/2", "-x+1/2,-x+1/2,-x+1/2", "x+1/2,-x+1/2,x+1/2", "-x+1/2,x+1/2,x+1/2", 
"-x,-x,-x", "x,x,-x", "x,-x,x", "-x,x,x", 
"-x+1/2,-x+1/2,x+1/2", "x+1/2,x+1/2,x+1/2", "-x+1/2,x+1/2,-x+1/2", "x+1/2,-x+1/2,-x+1/2", 

"x,1/2,0", "-x,1/2,0", "0,x,1/2", "0,-x,1/2", 
"1/2,0,x", "1/2,0,-x", "0,x+1/2,1/2", "0,-x+1/2,1/2", 
"x+1/2,1/2,0", "-x+1/2,1/2,0", "1/2,0,-x+1/2", "1/2,0,x+1/2", 

"x,0,1/2", "-x,0,1/2", "1/2,x,0", "1/2,-x,0", 
"0,1/2,x", "0,1/2,-x", "1/2,x+1/2,0", "1/2,-x+1/2,0", 
"x+1/2,0,1/2", "-x+1/2,0,1/2", "0,1/2,-x+1/2", "0,1/2,x+1/2", 

"x,0,0", "-x,0,0", "0,x,0", "0,-x,0", 
"0,0,x", "0,0,-x", "1/2,x+1/2,1/2", "1/2,-x+1/2,1/2", 
"x+1/2,1/2,1/2", "-x+1/2,1/2,1/2", "1/2,1/2,-x+1/2", "1/2,1/2,x+1/2", 

"1/4,1/4,1/4", "3/4,3/4,1/4", "3/4,1/4,3/4", "1/4,3/4,3/4", 
"3/4,3/4,3/4", "1/4,1/4,3/4", "1/4,3/4,1/4", "3/4,1/4,1/4", 

"1/4,1/2,0", "3/4,1/2,0", "0,1/4,1/2", "0,3/4,1/2", "1/2,0,1/4", "1/2,0,3/4", 

"1/4,0,1/2", "3/4,0,1/2", "1/2,1/4,0", "1/2,3/4,0", "0,1/2,1/4", "0,1/2,3/4", 

"0,1/2,1/2", "1/2,0,1/2", "1/2,1/2,0", "0,1/2,0", "1/2,0,0", "0,0,1/2", 

"0,0,0", "1/2,1/2,1/2", 
};

const char *gamgi_phys_symmetry_wyckoff_224 [192] = {
"x,y,z", "-x+1/2,-y+1/2,z", "-x+1/2,y,-z+1/2", "x,-y+1/2,-z+1/2", 
"z,x,y", "z,-x+1/2,-y+1/2", "-z+1/2,-x+1/2,y", "-z+1/2,x,-y+1/2", 
"y,z,x", "-y+1/2,z,-x+1/2", "y,-z+1/2,-x+1/2", "-y+1/2,-z+1/2,x", 
"y+1/2,x+1/2,-z", "-y,-x,-z", "y+1/2,-x,z+1/2", "-y,x+1/2,z+1/2", 
"x+1/2,z+1/2,-y", "-x,z+1/2,y+1/2", "-x,-z,-y", "x+1/2,-z,y+1/2", 
"z+1/2,y+1/2,-x", "z+1/2,-y,x+1/2", "-z,y+1/2,x+1/2", "-z,-y,-x", 
"-x,-y,-z", "x+1/2,y+1/2,-z", "x+1/2,-y,z+1/2", "-x,y+1/2,z+1/2", 
"-z,-x,-y", "-z,x+1/2,y+1/2", "z+1/2,x+1/2,-y", "z+1/2,-x,y+1/2", 
"-y,-z,-x", "y+1/2,-z,x+1/2", "-y,z+1/2,x+1/2", "y+1/2,z+1/2,-x", 
"-y+1/2,-x+1/2,z", "y,x,z", "-y+1/2,x,-z+1/2", "y,-x+1/2,-z+1/2", 
"-x+1/2,-z+1/2,y", "x,-z+1/2,-y+1/2", "x,z,y", "-x+1/2,z,-y+1/2", 
"-z+1/2,-y+1/2,x", "-z+1/2,y,-x+1/2", "z,-y+1/2,-x+1/2", "z,y,x", 

"x,x,z", "-x+1/2,-x+1/2,z", "-x+1/2,x,-z+1/2", "x,-x+1/2,-z+1/2", 
"z,x,x", "z,-x+1/2,-x+1/2", "-z+1/2,-x+1/2,x", "-z+1/2,x,-x+1/2", 
"x,z,x", "-x+1/2,z,-x+1/2", "x,-z+1/2,-x+1/2", "-x+1/2,-z+1/2,x", 
"x+1/2,x+1/2,-z", "-x,-x,-z", "x+1/2,-x,z+1/2", "-x,x+1/2,z+1/2", 
"x+1/2,z+1/2,-x", "-x,z+1/2,x+1/2", "-x,-z,-x", "x+1/2,-z,x+1/2", 
"z+1/2,x+1/2,-x", "z+1/2,-x,x+1/2", "-z,x+1/2,x+1/2", "-z,-x,-x", 

"1/2,y,-y", "0,-y+1/2,-y", "0,y,y+1/2", "1/2,-y+1/2,y+1/2", 
"-y,1/2,y", "-y,0,-y+1/2", "y+1/2,0,y", "y+1/2,1/2,-y+1/2", 
"y,-y,1/2", "-y+1/2,-y,0", "y,y+1/2,0", "-y+1/2,y+1/2,1/2", 
"1/2,-y,y", "0,y+1/2,y", "0,-y,-y+1/2", "1/2,y+1/2,-y+1/2", 
"y,1/2,-y", "y,0,y+1/2", "-y+1/2,0,-y", "-y+1/2,1/2,y+1/2", 
"-y,y,1/2", "y+1/2,y,0", "-y,-y+1/2,0", "y+1/2,-y+1/2,1/2", 

"1/2,y,y+1/2", "0,-y+1/2,y+1/2", "0,y,-y", "1/2,-y+1/2,-y",
"y+1/2,1/2,y", "y+1/2,0,-y+1/2", "-y,0,y", "-y,1/2,-y+1/2",
"y,y+1/2,1/2", "-y+1/2,y+1/2,0", "y,-y,0", "-y+1/2,-y,1/2",
"1/2,-y,-y+1/2", "0,y+1/2,-y+1/2", "0,-y,y", "1/2,y+1/2,y",
"-y+1/2,1/2,-y", "-y+1/2,0,y+1/2", "y,0,-y", "y,1/2,y+1/2",
"-y,-y+1/2,1/2", "y+1/2,-y+1/2,0", "-y,y,0", "y+1/2,y,1/2",

"x,1/4,3/4", "-x+1/2,1/4,3/4", "3/4,x,1/4", "3/4,-x+1/2,1/4", "1/4,3/4,x", "1/4,3/4,-x+1/2", 
"3/4,x+1/2,1/4", "3/4,-x,1/4", "x+1/2,1/4,3/4", "-x,1/4,3/4", "1/4,3/4,-x", "1/4,3/4,x+1/2", 
"-x,3/4,1/4", "x+1/2,3/4,1/4", "1/4,-x,3/4", "1/4,x+1/2,3/4", "3/4,1/4,-x", "3/4,1/4,x+1/2", 
"1/4,-x+1/2,3/4", "1/4,x,3/4", "-x+1/2,3/4,1/4", "x,3/4,1/4", "3/4,1/4,x", "3/4,1/4,-x+1/2", 

"x,1/4,1/4", "-x+1/2,1/4,1/4", "1/4,x,1/4", "1/4,-x+1/2,1/4", "1/4,1/4,x", "1/4,1/4,-x+1/2", 
"3/4,x+1/2,3/4", "3/4,-x,3/4", "x+1/2,3/4,3/4", "-x,3/4,3/4", "3/4,3/4,-x", "3/4,3/4,x+1/2", 

"1/2,1/4,3/4", "0,1/4,3/4", "3/4,1/2,1/4", "3/4,0,1/4", "1/4,3/4,1/2", "1/4,3/4,0", 
"1/2,3/4,1/4", "0,3/4,1/4", "1/4,1/2,3/4", "1/4,0,3/4", "3/4,1/4,1/2", "3/4,1/4,0", 

"x,x,x", "-x+1/2,-x+1/2,x", "-x+1/2,x,-x+1/2", "x,-x+1/2,-x+1/2", 
"x+1/2,x+1/2,-x", "-x,-x,-x", "x+1/2,-x,x+1/2", "-x,x+1/2,x+1/2", 

"1/4,3/4,3/4", "3/4,1/4,3/4", "3/4,3/4,1/4", "1/4,3/4,1/4", "3/4,1/4,1/4", "1/4,1/4,3/4", 

"1/2,1/2,1/2", "0,0,1/2", "0,1/2,0", "1/2,0,0", 

"0,0,0", "1/2,1/2,0", "1/2,0,1/2", "0,1/2,1/2", 

"1/4,1/4,1/4", "3/4,3/4,3/4", 
};

const char *gamgi_phys_symmetry_wyckoff_225 [156] = {
"x,y,z", "-x,-y,z", "-x,y,-z", "x,-y,-z", 
"z,x,y", "z,-x,-y", "-z,-x,y", "-z,x,-y", 
"y,z,x", "-y,z,-x", "y,-z,-x", "-y,-z,x", 
"y,x,-z", "-y,-x,-z", "y,-x,z", "-y,x,z", 
"x,z,-y", "-x,z,y", "-x,-z,-y", "x,-z,y", 
"z,y,-x", "z,-y,x", "-z,y,x", "-z,-y,-x", 
"-x,-y,-z", "x,y,-z", "x,-y,z", "-x,y,z", 
"-z,-x,-y", "-z,x,y", "z,x,-y", "z,-x,y", 
"-y,-z,-x", "y,-z,x", "-y,z,x", "y,z,-x", 
"-y,-x,z", "y,x,z", "-y,x,-z", "y,-x,-z", 
"-x,-z,y", "x,-z,-y", "x,z,y", "-x,z,-y", 
"-z,-y,x", "-z,y,-x", "z,-y,-x", "z,y,x", 

"x,x,z", "-x,-x,z", "-x,x,-z", "x,-x,-z", "z,x,x", "z,-x,-x", 
"-z,-x,x", "-z,x,-x", "x,z,x", "-x,z,-x", "x,-z,-x", "-x,-z,x", 
"x,x,-z", "-x,-x,-z", "x,-x,z", "-x,x,z", "x,z,-x", "-x,z,x", 
"-x,-z,-x", "x,-z,x", "z,x,-x", "z,-x,x", "-z,x,x", "-z,-x,-x", 

"0,y,z", "0,-y,z", "0,y,-z", "0,-y,-z", "z,0,y", "z,0,-y", 
"-z,0,y", "-z,0,-y", "y,z,0", "-y,z,0", "y,-z,0", "-y,-z,0", 
"y,0,-z", "-y,0,-z", "y,0,z", "-y,0,z", "0,z,-y", "0,z,y", 
"0,-z,-y", "0,-z,y", "z,y,0", "z,-y,0", "-z,y,0", "-z,-y,0", 

"1/2,y,y", "1/2,-y,y", "1/2,y,-y", "1/2,-y,-y", "y,1/2,y", "y,1/2,-y", 
"-y,1/2,y", "-y,1/2,-y", "y,y,1/2", "-y,y,1/2", "y,-y,1/2", "-y,-y,1/2", 

"0,y,y", "0,-y,y", "0,y,-y", "0,-y,-y", "y,0,y", "y,0,-y", 
"-y,0,y", "-y,0,-y", "y,y,0", "-y,y,0", "y,-y,0", "-y,-y,0", 

"x,1/4,1/4", "-x,3/4,1/4", "1/4,x,1/4", "1/4,-x,3/4", "1/4,1/4,x", "3/4,1/4,-x", 
"1/4,x,3/4", "3/4,-x,3/4", "x,1/4,3/4", "-x,1/4,1/4", "1/4,1/4,-x", "1/4,3/4,x", 

"x,x,x", "-x,-x,x", "-x,x,-x", "x,-x,-x", 
"x,x,-x", "-x,-x,-x", "x,-x,x", "-x,x,x", 

"x,0,0", "-x,0,0", "0,x,0", "0,-x,0", "0,0,x", "0,0,-x", 

"0,1/4,1/4", "0,3/4,1/4", "1/4,0,1/4", "1/4,0,3/4", "1/4,1/4,0", "3/4,1/4,0", 

"1/4,1/4,1/4", "1/4,1/4,3/4", 

"1/2,1/2,1/2", 

"0,0,0", 
};
  
const char *gamgi_phys_symmetry_wyckoff_226 [152] = {
"x,y,z", "-x,-y,z", "-x,y,-z", "x,-y,-z", 
"z,x,y", "z,-x,-y", "-z,-x,y", "-z,x,-y", 
"y,z,x", "-y,z,-x", "y,-z,-x", "-y,-z,x", 
"y+1/2,x+1/2,-z+1/2", "-y+1/2,-x+1/2,-z+1/2", "y+1/2,-x+1/2,z+1/2", "-y+1/2,x+1/2,z+1/2", 
"x+1/2,z+1/2,-y+1/2", "-x+1/2,z+1/2,y+1/2", "-x+1/2,-z+1/2,-y+1/2", "x+1/2,-z+1/2,y+1/2", 
"z+1/2,y+1/2,-x+1/2", "z+1/2,-y+1/2,x+1/2", "-z+1/2,y+1/2,x+1/2", "-z+1/2,-y+1/2,-x+1/2", 
"-x,-y,-z", "x,y,-z", "x,-y,z", "-x,y,z", 
"-z,-x,-y", "-z,x,y", "z,x,-y", "z,-x,y", 
"-y,-z,-x", "y,-z,x", "-y,z,x", "y,z,-x", 
"-y+1/2,-x+1/2,z+1/2", "y+1/2,x+1/2,z+1/2", "-y+1/2,x+1/2,-z+1/2", "y+1/2,-x+1/2,-z+1/2", 
"-x+1/2,-z+1/2,y+1/2", "x+1/2,-z+1/2,-y+1/2", "x+1/2,z+1/2,y+1/2", "-x+1/2,z+1/2,-y+1/2", 
"-z+1/2,-y+1/2,x+1/2", "-z+1/2,y+1/2,-x+1/2", "z+1/2,-y+1/2,-x+1/2", "z+1/2,y+1/2,x+1/2", 

"0,y,z", "0,-y,z", "0,y,-z", "0,-y,-z", 
"z,0,y", "z,0,-y", "-z,0,y", "-z,0,-y", 
"y,z,0", "-y,z,0", "y,-z,0", "-y,-z,0", 
"y+1/2,1/2,-z+1/2", "-y+1/2,1/2,-z+1/2", "y+1/2,1/2,z+1/2", "-y+1/2,1/2,z+1/2", 
"1/2,z+1/2,-y+1/2", "1/2,z+1/2,y+1/2", "1/2,-z+1/2,-y+1/2", "1/2,-z+1/2,y+1/2", 
"z+1/2,y+1/2,1/2", "z+1/2,-y+1/2,1/2", "-z+1/2,y+1/2,1/2", "-z+1/2,-y+1/2,1/2", 

"1/4,y,y", "3/4,-y,y", "3/4,y,-y", "1/4,-y,-y", "y,1/4,y", "y,3/4,-y", 
"-y,3/4,y", "-y,1/4,-y", "y,y,1/4", "-y,y,3/4", "y,-y,3/4", "-y,-y,1/4", 
"3/4,-y,-y", "1/4,y,-y", "1/4,-y,y", "3/4,y,y", "-y,3/4,-y", "-y,1/4,y", 
"y,1/4,-y", "y,3/4,y", "-y,-y,3/4", "y,-y,1/4", "-y,y,1/4", "y,y,3/4", 

"x,x,x", "-x,-x,x", "-x,x,-x", "x,-x,-x", 
"x+1/2,x+1/2,-x+1/2", "-x+1/2,-x+1/2,-x+1/2", "x+1/2,-x+1/2,x+1/2", "-x+1/2,x+1/2,x+1/2", 
"-x,-x,-x", "x,x,-x", "x,-x,x", "-x,x,x", 
"-x+1/2,-x+1/2,x+1/2", "x+1/2,x+1/2,x+1/2", "-x+1/2,x+1/2,-x+1/2", "x+1/2,-x+1/2,-x+1/2", 

"x,1/4,1/4", "-x,3/4,1/4", "1/4,x,1/4", "1/4,-x,3/4", "1/4,1/4,x", "3/4,1/4,-x", 
"-x,3/4,3/4", "x,1/4,3/4", "3/4,-x,3/4", "3/4,x,1/4", "3/4,3/4,-x", "1/4,3/4,x", 

"x,0,0", "-x,0,0", "0,x,0", "0,-x,0", 
"0,0,x", "0,0,-x", "1/2,x+1/2,1/2", "1/2,-x+1/2,1/2", 
"x+1/2,1/2,1/2", "-x+1/2,1/2,1/2", "1/2,1/2,-x+1/2", "1/2,1/2,x+1/2", 

"0,1/4,1/4", "0,3/4,1/4", "1/4,0,1/4", "1/4,0,3/4", "1/4,1/4,0", "3/4,1/4,0", 

"1/4,0,0", "3/4,0,0", "0,1/4,0", "0,3/4,0", "0,0,1/4", "0,0,3/4", 

"0,0,0", "1/2,1/2,1/2", 

"1/4,1/4,1/4", "3/4,3/4,3/4", 
};

const char *gamgi_phys_symmetry_wyckoff_227 [128] = {
"x,y,z", "-x+3/4,-y+1/4,z+1/2", "-x+1/4,y+1/2,-z+3/4", "x+1/2,-y+3/4,-z+1/4", 
"z,x,y", "z+1/2,-x+3/4,-y+1/4", "-z+3/4,-x+1/4,y+1/2", "-z+1/4,x+1/2,-y+3/4", 
"y,z,x", "-y+1/4,z+1/2,-x+3/4", "y+1/2,-z+3/4,-x+1/4", "-y+3/4,-z+1/4,x+1/2", 
"y+3/4,x+1/4,-z+1/2", "-y,-x,-z", "y+1/4,-x+1/2,z+3/4", "-y+1/2,x+3/4,z+1/4", 
"x+3/4,z+1/4,-y+1/2", "-x+1/2,z+3/4,y+1/4", "-x,-z,-y", "x+1/4,-z+1/2,y+3/4", 
"z+3/4,y+1/4,-x+1/2", "z+1/4,-y+1/2,x+3/4", "-z+1/2,y+3/4,x+1/4", "-z,-y,-x", 
"-x,-y,-z", "x+1/4,y+3/4,-z+1/2", "x+3/4,-y+1/2,z+1/4", "-x+1/2,y+1/4,z+3/4", 
"-z,-x,-y", "-z+1/2,x+1/4,y+3/4", "z+1/4,x+3/4,-y+1/2", "z+3/4,-x+1/2,y+1/4", 
"-y,-z,-x", "y+3/4,-z+1/2,x+1/4", "-y+1/2,z+1/4,x+3/4", "y+1/4,z+3/4,-x+1/2", 
"-y+1/4,-x+3/4,z+1/2", "y,x,z", "-y+3/4,x+1/2,-z+1/4", "y+1/2,-x+1/4,-z+3/4", 
"-x+1/4,-z+3/4,y+1/2", "x+1/2,-z+1/4,-y+3/4", "x,z,y", "-x+3/4,z+1/2,-y+1/4", 
"-z+1/4,-y+3/4,x+1/2", "-z+3/4,y+1/2,-x+1/4", "z+1/2,-y+1/4,-x+3/4", "z,y,x", 

"0,y,-y", "3/4,-y+1/4,-y+1/2", "1/4,y+1/2,y+3/4", "1/2,-y+3/4,y+1/4", 
"-y,0,y", "-y+1/2,3/4,-y+1/4", "y+3/4,1/4,y+1/2", "y+1/4,1/2,-y+3/4", 
"y,-y,0", "-y+1/4,-y+1/2,3/4", "y+1/2,y+3/4,1/4", "-y+3/4,y+1/4,1/2", 
"0,-y,y", "1/4,y+3/4,y+1/2", "3/4,-y+1/2,-y+1/4", "1/2,y+1/4,-y+3/4", 
"y,0,-y", "y+1/2,1/4,y+3/4", "-y+1/4,3/4,-y+1/2", "-y+3/4,1/2,y+1/4", 
"-y,y,0", "y+3/4,y+1/2,1/4", "-y+1/2,-y+1/4,3/4", "y+1/4,-y+3/4,1/2", 

"x,x,z", "-x+3/4,-x+1/4,z+1/2", "-x+1/4,x+1/2,-z+3/4", "x+1/2,-x+3/4,-z+1/4", 
"z,x,x", "z+1/2,-x+3/4,-x+1/4", "-z+3/4,-x+1/4,x+1/2", "-z+1/4,x+1/2,-x+3/4", 
"x,z,x", "-x+1/4,z+1/2,-x+3/4", "x+1/2,-z+3/4,-x+1/4", "-x+3/4,-z+1/4,x+1/2", 
"x+3/4,x+1/4,-z+1/2", "-x,-x,-z", "x+1/4,-x+1/2,z+3/4", "-x+1/2,x+3/4,z+1/4", 
"x+3/4,z+1/4,-x+1/2", "-x+1/2,z+3/4,x+1/4", "-x,-z,-x", "x+1/4,-z+1/2,x+3/4", 
"z+3/4,x+1/4,-x+1/2", "z+1/4,-x+1/2,x+3/4", "-z+1/2,x+3/4,x+1/4", "-z,-x,-x", 

"x,1/8,1/8", "-x+3/4,1/8,5/8", "1/8,x,1/8", "5/8,-x+3/4,1/8", "1/8,1/8,x", "1/8,5/8,-x+3/4", 
"7/8,x+1/4,3/8", "7/8,-x,7/8", "x+3/4,3/8,3/8", "-x+1/2,7/8,3/8", "7/8,3/8,-x+1/2", "3/8,3/8,x+3/4", 

"x,x,x", "-x+3/4,-x+1/4,x+1/2", "-x+1/4,x+1/2,-x+3/4", "x+1/2,-x+3/4,-x+1/4", 
"x+3/4,x+1/4,-x+1/2", "-x,-x,-x", "x+1/4,-x+1/2,x+3/4", "-x+1/2,x+3/4,x+1/4", 

"1/2,1/2,1/2", "1/4,3/4,0", "3/4,0,1/4", "0,1/4,3/4", 

"0,0,0", "3/4,1/4,1/2", "1/4,1/2,3/4", "1/2,3/4,1/4", 

"3/8,3/8,3/8", "1/8,5/8,1/8", 

"1/8,1/8,1/8", "7/8,3/8,3/8", 
};

const char *gamgi_phys_symmetry_wyckoff_228 [144] = {
"x,y,z", "-x+1/4,-y+3/4,z+1/2", "-x+3/4,y+1/2,-z+1/4", "x+1/2,-y+1/4,-z+3/4", 
"z,x,y", "z+1/2,-x+1/4,-y+3/4", "-z+1/4,-x+3/4,y+1/2", "-z+3/4,x+1/2,-y+1/4", 
"y,z,x", "-y+3/4,z+1/2,-x+1/4", "y+1/2,-z+1/4,-x+3/4", "-y+1/4,-z+3/4,x+1/2", 
"y+3/4,x+1/4,-z", "-y+1/2,-x+1/2,-z+1/2", "y+1/4,-x,z+3/4", "-y,x+3/4,z+1/4", 
"x+3/4,z+1/4,-y", "-x,z+3/4,y+1/4", "-x+1/2,-z+1/2,-y+1/2", "x+1/4,-z,y+3/4", 
"z+3/4,y+1/4,-x", "z+1/4,-y,x+3/4", "-z,y+3/4,x+1/4", "-z+1/2,-y+1/2,-x+1/2", 
"-x,-y,-z", "x+3/4,y+1/4,-z+1/2", "x+1/4,-y+1/2,z+3/4", "-x+1/2,y+3/4,z+1/4", 
"-z,-x,-y", "-z+1/2,x+3/4,y+1/4", "z+3/4,x+1/4,-y+1/2", "z+1/4,-x+1/2,y+3/4", 
"-y,-z,-x", "y+1/4,-z+1/2,x+3/4", "-y+1/2,z+3/4,x+1/4", "y+3/4,z+1/4,-x+1/2", 
"-y+1/4,-x+3/4,z", "y+1/2,x+1/2,z+1/2", "-y+3/4,x,-z+1/4", "y,-x+1/4,-z+3/4", 
"-x+1/4,-z+3/4,y", "x,-z+1/4,-y+3/4", "x+1/2,z+1/2,y+1/2", "-x+3/4,z,-y+1/4", 
"-z+1/4,-y+3/4,x", "-z+3/4,y,-x+1/4", "z,-y+1/4,-x+3/4", "z+1/2,y+1/2,x+1/2", 

"1/4,y,-y", "0,-y+3/4,-y+1/2", "1/2,y+1/2,y+1/4", "3/4,-y+1/4,y+3/4", 
"-y,1/4,y", "-y+1/2,0,-y+3/4", "y+1/4,1/2,y+1/2", "y+3/4,3/4,-y+1/4", 
"y,-y,1/4", "-y+3/4,-y+1/2,0", "y+1/2,y+1/4,1/2", "-y+1/4,y+3/4,3/4", 
"3/4,-y,y", "0,y+1/4,y+1/2", "1/2,-y+1/2,-y+3/4", "1/4,y+3/4,-y+1/4", 
"y,3/4,-y", "y+1/2,0,y+1/4", "-y+3/4,1/2,-y+1/2", "-y+1/4,1/4,y+3/4", 
"-y,y,3/4", "y+1/4,y+1/2,0", "-y+1/2,-y+3/4,1/2", "y+3/4,-y+1/4,1/4", 

"x,1/8,1/8", "-x+1/4,5/8,5/8", "1/8,x,1/8", "5/8,-x+1/4,5/8", "1/8,1/8,x", "5/8,5/8,-x+1/4", 
"7/8,x+1/4,7/8", "3/8,-x+1/2,3/8", "x+3/4,3/8,7/8", "-x,7/8,3/8", "7/8,3/8,-x", "3/8,7/8,x+3/4", 
"-x,7/8,7/8", "x+3/4,3/8,3/8", "7/8,-x,7/8", "3/8,x+3/4,3/8", "7/8,7/8,-x", "3/8,3/8,x+3/4", 
"1/8,-x+3/4,1/8", "5/8,x+1/2,5/8", "-x+1/4,5/8,1/8", "x,1/8,5/8", "1/8,5/8,x", "5/8,1/8,-x+1/4", 

"x,x,x", "-x+1/4,-x+3/4,x+1/2", "-x+3/4,x+1/2,-x+1/4", "x+1/2,-x+1/4,-x+3/4", 
"x+3/4,x+1/4,-x", "-x+1/2,-x+1/2,-x+1/2", "x+1/4,-x,x+3/4", "-x,x+3/4,x+1/4", 
"-x,-x,-x", "x+3/4,x+1/4,-x+1/2", "x+1/4,-x+1/2,x+3/4", "-x+1/2,x+3/4,x+1/4", 
"-x+1/4,-x+3/4,x", "x+1/2,x+1/2,x+1/2", "-x+3/4,x,-x+1/4", "x,-x+1/4,-x+3/4", 

"7/8,1/8,1/8", "3/8,5/8,5/8", "1/8,7/8,1/8", "5/8,3/8,5/8", "1/8,1/8,7/8", "5/8,5/8,3/8", 
"7/8,1/8,7/8", "3/8,5/8,3/8", "5/8,3/8,7/8", "1/8,7/8,3/8", "7/8,3/8,1/8", "3/8,7/8,5/8", 

"0,0,0", "1/4,3/4,1/2", "3/4,1/2,1/4", "1/2,1/4,3/4", 
"3/4,1/4,0", "1/2,1/2,1/2", "1/4,0,3/4", "0,3/4,1/4", 

"1/4,1/4,1/4", "0,1/2,3/4", "1/2,3/4,0", "3/4,0,1/2", 
"3/4,3/4,3/4", "0,1/2,1/4", "1/2,1/4,0", "1/4,0,1/2", 

"1/8,1/8,1/8", "7/8,3/8,7/8", "7/8,7/8,7/8", "1/8,5/8,1/8", 
};

const char *gamgi_phys_symmetry_wyckoff_229 [172] = {
"x,y,z", "-x,-y,z", "-x,y,-z", "x,-y,-z", 
"z,x,y", "z,-x,-y", "-z,-x,y", "-z,x,-y", 
"y,z,x", "-y,z,-x", "y,-z,-x", "-y,-z,x", 
"y,x,-z", "-y,-x,-z", "y,-x,z", "-y,x,z", 
"x,z,-y", "-x,z,y", "-x,-z,-y", "x,-z,y", 
"z,y,-x", "z,-y,x", "-z,y,x", "-z,-y,-x", 
"-x,-y,-z", "x,y,-z", "x,-y,z", "-x,y,z", 
"-z,-x,-y", "-z,x,y", "z,x,-y", "z,-x,y", 
"-y,-z,-x", "y,-z,x", "-y,z,x", "y,z,-x", 
"-y,-x,z", "y,x,z", "-y,x,-z", "y,-x,-z", 
"-x,-z,y", "x,-z,-y", "x,z,y", "-x,z,-y", 
"-z,-y,x", "-z,y,-x", "z,-y,-x", "z,y,x", 

"x,x,z", "-x,-x,z", "-x,x,-z", "x,-x,-z", "z,x,x", "z,-x,-x", 
"-z,-x,x", "-z,x,-x", "x,z,x", "-x,z,-x", "x,-z,-x", "-x,-z,x", 
"x,x,-z", "-x,-x,-z", "x,-x,z", "-x,x,z", "x,z,-x", "-x,z,x", 
"-x,-z,-x", "x,-z,x", "z,x,-x", "z,-x,x", "-z,x,x", "-z,-x,-x", 

"0,y,z", "0,-y,z", "0,y,-z", "0,-y,-z", "z,0,y", "z,0,-y", 
"-z,0,y", "-z,0,-y", "y,z,0", "-y,z,0", "y,-z,0", "-y,-z,0", 
"y,0,-z", "-y,0,-z", "y,0,z", "-y,0,z", "0,z,-y", "0,z,y", 
"0,-z,-y", "0,-z,y", "z,y,0", "z,-y,0", "-z,y,0", "-z,-y,0", 

"1/4,y,-y+1/2", "3/4,-y,-y+1/2", "3/4,y,y+1/2", "1/4,-y,y+1/2", 
"-y+1/2,1/4,y", "-y+1/2,3/4,-y", "y+1/2,3/4,y", "y+1/2,1/4,-y", 
"y,-y+1/2,1/4", "-y,-y+1/2,3/4", "y,y+1/2,3/4", "-y,y+1/2,1/4", 
"3/4,-y,y+1/2", "1/4,y,y+1/2", "1/4,-y,-y+1/2", "3/4,y,-y+1/2", 
"y+1/2,3/4,-y", "y+1/2,1/4,y", "-y+1/2,1/4,-y", "-y+1/2,3/4,y", 
"-y,y+1/2,3/4", "y,y+1/2,1/4", "-y,-y+1/2,1/4", "y,-y+1/2,3/4", 

"0,y,y", "0,-y,y", "0,y,-y", "0,-y,-y", "y,0,y", "y,0,-y", 
"-y,0,y", "-y,0,-y", "y,y,0", "-y,y,0", "y,-y,0", "-y,-y,0", 

"x,0,1/2", "-x,0,1/2", "1/2,x,0", "1/2,-x,0", "0,1/2,x", "0,1/2,-x", 
"0,x,1/2", "0,-x,1/2", "x,1/2,0", "-x,1/2,0", "1/2,0,-x", "1/2,0,x", 

"x,x,x", "-x,-x,x", "-x,x,-x", "x,-x,-x", 
"x,x,-x", "-x,-x,-x", "x,-x,x", "-x,x,x", 

"x,0,0", "-x,0,0", "0,x,0", "0,-x,0", "0,0,x", "0,0,-x", 

"1/4,0,1/2", "3/4,0,1/2", "1/2,1/4,0", "1/2,3/4,0", "0,1/2,1/4", "0,1/2,3/4", 

"1/4,1/4,1/4", "3/4,3/4,1/4", "3/4,1/4,3/4", "1/4,3/4,3/4", 

"0,1/2,1/2", "1/2,0,1/2", "1/2,1/2,0", 

"0,0,0", 
};

const char *gamgi_phys_symmetry_wyckoff_230 [152] = {
"x,y,z", "-x+1/2,-y,z+1/2", "-x,y+1/2,-z+1/2", "x+1/2,-y+1/2,-z", 
"z,x,y", "z+1/2,-x+1/2,-y", "-z+1/2,-x,y+1/2", "-z,x+1/2,-y+1/2", 
"y,z,x", "-y,z+1/2,-x+1/2", "y+1/2,-z+1/2,-x", "-y+1/2,-z,x+1/2", 
"y+3/4,x+1/4,-z+1/4", "-y+3/4,-x+3/4,-z+3/4", "y+1/4,-x+1/4,z+3/4", "-y+1/4,x+3/4,z+1/4", 
"x+3/4,z+1/4,-y+1/4", "-x+1/4,z+3/4,y+1/4", "-x+3/4,-z+3/4,-y+3/4", "x+1/4,-z+1/4,y+3/4", 
"z+3/4,y+1/4,-x+1/4", "z+1/4,-y+1/4,x+3/4", "-z+1/4,y+3/4,x+1/4", "-z+3/4,-y+3/4,-x+3/4", 
"-x,-y,-z", "x+1/2,y,-z+1/2", "x,-y+1/2,z+1/2", "-x+1/2,y+1/2,z", 
"-z,-x,-y", "-z+1/2,x+1/2,y", "z+1/2,x,-y+1/2", "z,-x+1/2,y+1/2", 
"-y,-z,-x", "y,-z+1/2,x+1/2", "-y+1/2,z+1/2,x", "y+1/2,z,-x+1/2", 
"-y+1/4,-x+3/4,z+3/4", "y+1/4,x+1/4,z+1/4", "-y+3/4,x+3/4,-z+1/4", "y+3/4,-x+1/4,-z+3/4", 
"-x+1/4,-z+3/4,y+3/4", "x+3/4,-z+1/4,-y+3/4", "x+1/4,z+1/4,y+1/4", "-x+3/4,z+3/4,-y+1/4", 
"-z+1/4,-y+3/4,x+3/4", "-z+3/4,y+3/4,-x+1/4", "z+3/4,-y+1/4,-x+3/4", "z+1/4,y+1/4,x+1/4", 

"1/8,y,-y+1/4", "3/8,-y,-y+3/4", "7/8,y+1/2,y+1/4", "5/8,-y+1/2,y+3/4", 
"-y+1/4,1/8,y", "-y+3/4,3/8,-y", "y+1/4,7/8,y+1/2", "y+3/4,5/8,-y+1/2", 
"y,-y+1/4,1/8", "-y,-y+3/4,3/8", "y+1/2,y+1/4,7/8", "-y+1/2,y+3/4,5/8", 
"7/8,-y,y+3/4", "5/8,y,y+1/4", "1/8,-y+1/2,-y+3/4", "3/8,y+1/2,-y+1/4", 
"y+3/4,7/8,-y", "y+1/4,5/8,y", "-y+3/4,1/8,-y+1/2", "-y+1/4,3/8,y+1/2", 
"-y,y+3/4,7/8", "y,y+1/4,5/8", "-y+1/2,-y+3/4,1/8", "y+1/2,-y+1/4,3/8", 

"x,0,1/4", "-x+1/2,0,3/4", "1/4,x,0", "3/4,-x+1/2,0", "0,1/4,x", "0,3/4,-x+1/2", 
"3/4,x+1/4,0", "3/4,-x+3/4,1/2", "x+3/4,1/2,1/4", "-x+1/4,0,1/4", "0,1/4,-x+1/4", "1/2,1/4,x+3/4", 
"-x,0,3/4", "x+1/2,0,1/4", "3/4,-x,0", "1/4,x+1/2,0", "0,3/4,-x", "0,1/4,x+1/2", 
"1/4,-x+3/4,0", "1/4,x+1/4,1/2", "-x+1/4,1/2,3/4", "x+3/4,0,3/4", "0,3/4,x+3/4", "1/2,3/4,-x+1/4", 

"x,x,x", "-x+1/2,-x,x+1/2", "-x,x+1/2,-x+1/2", "x+1/2,-x+1/2,-x", 
"x+3/4,x+1/4,-x+1/4", "-x+3/4,-x+3/4,-x+3/4", "x+1/4,-x+1/4,x+3/4", "-x+1/4,x+3/4,x+1/4", 
"-x,-x,-x", "x+1/2,x,-x+1/2", "x,-x+1/2,x+1/2", "-x+1/2,x+1/2,x", 
"-x+1/4,-x+3/4,x+3/4", "x+1/4,x+1/4,x+1/4", "-x+3/4,x+3/4,-x+1/4", "x+3/4,-x+1/4,-x+3/4", 

"3/8,0,1/4", "1/8,0,3/4", "1/4,3/8,0", "3/4,1/8,0", "0,1/4,3/8", "0,3/4,1/8", 
"3/4,5/8,0", "3/4,3/8,1/2", "1/8,1/2,1/4", "7/8,0,1/4", "0,1/4,7/8", "1/2,1/4,1/8", 

"1/8,0,1/4", "3/8,0,3/4", "1/4,1/8,0", "3/4,3/8,0", "0,1/4,1/8", "0,3/4,3/8", 
"7/8,0,3/4", "5/8,0,1/4", "3/4,7/8,0", "1/4,5/8,0", "0,3/4,7/8", "0,1/4,5/8", 

"1/8,1/8,1/8", "3/8,7/8,5/8", "7/8,5/8,3/8", "5/8,3/8,7/8", 
"7/8,7/8,7/8", "5/8,1/8,3/8", "1/8,3/8,5/8", "3/8,5/8,1/8", 

"0,0,0", "1/2,0,1/2", "0,1/2,1/2", "1/2,1/2,0", 
"3/4,1/4,1/4", "3/4,3/4,3/4", "1/4,1/4,3/4", "1/4,3/4,1/4", 
};

/********************
 * Wyckoff symmetry *
 ********************/

const char *gamgi_phys_symmetry_positions_1 [1] = {
"1",
};

const char *gamgi_phys_symmetry_positions_2 [9] = {
"1", "-1", "-1", "-1", "-1", "-1", "-1", "-1", "-1",
};

const char *gamgi_phys_symmetry_positions_3 [5] = {
"1", "2", "2", "2", "2", 
};

const char *gamgi_phys_symmetry_positions_4 [1] = {
"1", 
};

const char *gamgi_phys_symmetry_positions_5 [3] = {
"1", "2", "2",
};

const char *gamgi_phys_symmetry_positions_6 [3] = {
"1", "m", "m",
};

const char *gamgi_phys_symmetry_positions_7 [1] = {
"1", 
};

const char *gamgi_phys_symmetry_positions_8 [2] = {
"1", "m",
};

const char *gamgi_phys_symmetry_positions_9 [1] = {
"1", 
};

const char *gamgi_phys_symmetry_positions_10 [15] = {
"1", "m", "m", "2", "2", "2", "2", "2/m", "2/m", "2/m", "2/m", "2/m", "2/m", "2/m", "2/m",
};

const char *gamgi_phys_symmetry_positions_11 [6] = {
"1", "m", "-1", "-1", "-1", "-1", 
};

const char *gamgi_phys_symmetry_positions_12 [10] = {
"1", "m", "2", "2", "-1", "-1", "2/m", "2/m", "2/m", "2/m",
};

const char *gamgi_phys_symmetry_positions_13 [7] = {
"1", "2", "2", "-1", "-1", "-1", "-1", 
};

const char *gamgi_phys_symmetry_positions_14 [5] = {
"1", "-1", "-1", "-1", "-1",
};

const char *gamgi_phys_symmetry_positions_15 [6] = {
"1", "2", "-1", "-1", "-1", "-1",
};

const char *gamgi_phys_symmetry_positions_16 [21] = {
"1", "..2", "..2", "..2", "..2", ".2.", ".2.", ".2.", ".2.", "2..", "2..", 
"2..", "2..", "222", "222", "222", "222", "222", "222", "222", "222",
};

const char *gamgi_phys_symmetry_positions_17 [5] = {
"1", ".2.", ".2.", "2..", "2..",
};

const char *gamgi_phys_symmetry_positions_18 [3] = {
"1", "..2", "..2",
};

const char *gamgi_phys_symmetry_positions_19 [1] = {
"1", 
};

const char *gamgi_phys_symmetry_positions_20 [3] = {
"1", ".2.", "2..",
};

const char *gamgi_phys_symmetry_positions_21 [12] = {
"1", "..2", "..2", "..2", ".2.", ".2.", "2..", "2..", "222", "222", "222", "222", 
};

const char *gamgi_phys_symmetry_positions_22 [11] = {
"1", "2..", ".2.", "..2", "..2", ".2.", "2..", "222", "222", "222", "222",
};

const char *gamgi_phys_symmetry_positions_23 [11] = {
"1", "..2", "..2", ".2.", ".2.", "2..", "2..", "222", "222", "222", "222",
};

const char *gamgi_phys_symmetry_positions_24 [4] = {
"1", "..2", ".2.", "2..",
};

const char *gamgi_phys_symmetry_positions_25 [9] = {
"1", "m..", "m..", ".m.", ".m.", "mm2", "mm2", "mm2", "mm2",
};

const char *gamgi_phys_symmetry_positions_26 [3] = {
"1", "m..", "m..",
};

const char *gamgi_phys_symmetry_positions_27 [5] = {
"1", "..2", "..2", "..2", "..2",
};

const char *gamgi_phys_symmetry_positions_28 [4] = {
"1", "m..", "..2", "..2", 
};

const char *gamgi_phys_symmetry_positions_29 [1] = {
"1", 
};

const char *gamgi_phys_symmetry_positions_30 [3] = {
"1", "..2", "..2",
};

const char *gamgi_phys_symmetry_positions_31 [2] = {
"1", "m..", 
};

const char *gamgi_phys_symmetry_positions_32 [3] = {
"1", "..2", "..2",
};

const char *gamgi_phys_symmetry_positions_33 [1] = {
"1", 
};

const char *gamgi_phys_symmetry_positions_34 [3] = {
"1", "..2", "..2",
};

const char *gamgi_phys_symmetry_positions_35 [6] = {
"1", "m..", ".m.", "..2", "mm2", "mm2",
};

const char *gamgi_phys_symmetry_positions_36 [2] = {
"1", "m..", 
};

const char *gamgi_phys_symmetry_positions_37 [4] = {
"1", "..2", "..2", "..2", 
};

/*************************************************************
 * groups 38-41: Amm2, Aem2, Ama2 and Aea2 changed to Cm2m,  *
 * Cm2e, Cc2m and Cc2e, using the axes permutation abc->bca, *
 * as shown in the International Tables for Crystallography, *
 * so all base-centered lattices are described as C lattices *
 *************************************************************/

const char *gamgi_phys_symmetry_positions_38 [6] = {
"1", "..m", "..m", "m..", "m2m", "m2m",
};

const char *gamgi_phys_symmetry_positions_39 [4] = {
"1", "m..", ".2.", ".2.", 
};

const char *gamgi_phys_symmetry_positions_40 [3] = {
"1", "..m", ".2.", 
};

const char *gamgi_phys_symmetry_positions_41 [2] = {
"1", ".2.", 
};

const char *gamgi_phys_symmetry_positions_42 [5] = {
"1", ".m.", "m..", "..2", "mm2", 
};

const char *gamgi_phys_symmetry_positions_43 [2] = {
"1", "..2", 
};

const char *gamgi_phys_symmetry_positions_44 [5] = {
"1", "m..", ".m.", "mm2", "mm2",
};

const char *gamgi_phys_symmetry_positions_45 [3] = {
"1", "..2", "..2",
};

const char *gamgi_phys_symmetry_positions_46 [3] = {
"1", "m..", "..2",
};

const char *gamgi_phys_symmetry_positions_47 [27] = {
"1", "..m", "..m", ".m.", ".m.", "m..", "m..",
"mm2", "mm2", "mm2", "mm2", "m2m", "m2m", "m2m", "m2m",
"2mm", "2mm", "2mm", "2mm", "mmm", "mmm", "mmm", "mmm", 
"mmm", "mmm", "mmm", "mmm",
};

const char *gamgi_phys_symmetry_positions_48 [13] = {
"1", "..2", "..2", ".2.", ".2.", "2..", "2..",
"-1", "-1", "222",  "222",  "222",  "222",
};

const char *gamgi_phys_symmetry_positions_49 [18] = {
"1", "..m", "..2", "..2", "..2", "..2", ".2.", ".2.", "2..", "2..", 
"222", "222", "222", "222", "..2/m", "..2/m", "..2/m", "..2/m",
};

const char *gamgi_phys_symmetry_positions_50 [13] = {
"1", "..2", "..2", ".2.", ".2.", "2..", "2..",
"-1", "-1", "222",  "222",  "222",  "222",
};

const char *gamgi_phys_symmetry_positions_51 [12] = {
"1", "m..", ".m.", ".m.", ".2.", ".2." "mm2", "mm2", ".2/m.", ".2/m.", ".2/m.", ".2/m.",
};

const char *gamgi_phys_symmetry_positions_52 [5] = {
"1", "2..", "..2", "-1", "-1",
};

const char *gamgi_phys_symmetry_positions_53 [9] = {
"1", "m..", ".2." "2..", "2..", "2/m..", "2/m..", "2/m..", "2/m..",
};

const char *gamgi_phys_symmetry_positions_54 [6] = {
"1", "..2", "..2", ".2.", "-1", "-1",
};

const char *gamgi_phys_symmetry_positions_55 [9] = {
"1", "..m", "..m", "..2", "..2", "..2/m", "..2/m", "..2/m", "..2/m",
};

const char *gamgi_phys_symmetry_positions_56 [5] = {
"1", "..2", "..2", "-1", "-1",
};

const char *gamgi_phys_symmetry_positions_57 [5] = {
"1", "..m", "2..", "-1", "-1",
};

const char *gamgi_phys_symmetry_positions_58 [8] = {
"1", "..m", "..2", "..2", "..2/m", "..2/m", "..2/m", "..2/m",
};

const char *gamgi_phys_symmetry_positions_59 [7] = {
"1", ".m.", "m..", "-1", "-1", "mm2", "mm2",
};

const char *gamgi_phys_symmetry_positions_60 [4] = {
"1", ".2.", "-1", "-1",
};

const char *gamgi_phys_symmetry_positions_61 [3] = {
"1", "-1", "-1",
};

const char *gamgi_phys_symmetry_positions_62 [4] = {
"1", ".m.", "-1", "-1",
};

const char *gamgi_phys_symmetry_positions_63 [8] = {
"1", "..m", "m..", "2..", "-1", "m2m", "2/m..", "2/m..",
};

const char *gamgi_phys_symmetry_positions_64 [7] = {
"1", "m..", ".2.", "2..", "-1", "2/m..", "2/m..",
};

const char *gamgi_phys_symmetry_positions_65 [18] = {
"1", "..m", "..m", ".m.", "m..", "..2", "mm2", "mm2", "m2m", "m2m",
"2mm", "2mm", "..2/m", "..2/m", "mmm", "mmm", "mmm", "mmm",
};

const char *gamgi_phys_symmetry_positions_66 [13] = {
"1", "..m", "..2", "..2", "..2", ".2.", "2..", 
"..2/m", "..2/m", "..2/m", "..2/m", "222", "222",
};

const char *gamgi_phys_symmetry_positions_67 [15] = {
"1", ".m.", "m..", "..2", ".2.", ".2.", "2..", "2..", 
"mm2", ".2/m.", ".2/m.", "2/m..", "2/m..", "222", "222",
};

const char *gamgi_phys_symmetry_positions_68 [9] = {
"1", "..2", "..2", ".2.", "2..", "-1", "-1", "222", "222",
};

const char *gamgi_phys_symmetry_positions_69 [16] = {
"1", "..m", ".m.", "m..", "2..", ".2.", "..2", "mm2", 
"m2m", "2mm", "222", "..2/m", ".2/m.", "2/m..", "mmm", "mmm",
};

const char *gamgi_phys_symmetry_positions_70 [8] = {
"1", "..2", ".2.", "2..", "-1", "-1", "222", "222",
};

const char *gamgi_phys_symmetry_positions_71 [15] = {
"1", "..m", ".m.", "m..", "-1", "mm2", "mm2", "m2m", "m2m", 
"2mm", "2mm", "mmm", "mmm", "mmm", "mmm",
};

const char *gamgi_phys_symmetry_positions_72 [11] = {
"1", "..m", "..2", "..2", ".2.", "2..", "-1", 
"..2/m", "..2/m", "222", "222",
};

const char *gamgi_phys_symmetry_positions_73 [6] = {
"1", "..2", ".2.", "2..", "-1", "-1",
};

const char *gamgi_phys_symmetry_positions_74 [10] = {
"1", ".m.", "m..", ".2.", "2..", "mm2", ".2/m.", ".2/m.", "2/m..", "2/m..",
};

const char *gamgi_phys_symmetry_positions_75 [4] = {
"1", "2..", "4..", "4..", 
};

const char *gamgi_phys_symmetry_positions_76 [1] = {
"1",
};

const char *gamgi_phys_symmetry_positions_77 [4] = {
"1", "2..", "2..", "2..",
};

const char *gamgi_phys_symmetry_positions_78 [1] = {
"1",
};

const char *gamgi_phys_symmetry_positions_79 [3] = {
"1", "2..", "4..",
};

const char *gamgi_phys_symmetry_positions_80 [2] = {
"1", "2..", 
};

const char *gamgi_phys_symmetry_positions_81 [8] = {
"1", "2..", "2..", "2..", "-4..", "-4..", "-4..", "-4..",
};

const char *gamgi_phys_symmetry_positions_82 [7] = {
"1", "2..", "2..", "-4..", "-4..", "-4..", "-4..",
};

const char *gamgi_phys_symmetry_positions_83 [12] = {
"1", "m..", "m..", "2..", "4..", "4..", "2/m..", "2/m..",
"4/m..", "4/m..", "4/m..", "4/m..",
};


const char *gamgi_phys_symmetry_positions_84 [11] = {
"1", "m..", "2..", "2..", "2..", "-4..", "-4..",
"2/m..", "2/m..", "2/m..", "2/m..",
};

const char *gamgi_phys_symmetry_positions_85 [7] = {
"1", "2..", "-1", "-1", "4..", "-4..", "-4..",
};

const char *gamgi_phys_symmetry_positions_86 [7] = {
"1", "2..", "2..", "-1", "-1", "-4..", "-4..",
};

const char *gamgi_phys_symmetry_positions_87 [9] = {
"1", "m..", "2..", "-1", "4..", "-4..", "2/m..", "4/m..", "4/m..",
};

const char *gamgi_phys_symmetry_positions_88 [6] = {
"1", "2..", "-1", "-1", "-4..", "-4..",
};

const char *gamgi_phys_symmetry_positions_89 [16] = {
"1", ".2.", ".2.", ".2.", ".2.", "..2", "..2", "2..", "4..", "4..", 
"222.", "222.", "422", "422", "422", "422",
};

const char *gamgi_phys_symmetry_positions_90 [7] = {
"1", "..2", "..2", "2..", "4..", "2.22", "2.22",
};

const char *gamgi_phys_symmetry_positions_91 [4] = {
"1", "..2", ".2.", ".2.",
};

const char *gamgi_phys_symmetry_positions_92 [2] = {
"1", "..2", 
};

const char *gamgi_phys_symmetry_positions_93 [16] = {
"1", "..2", "..2", ".2.", ".2.", ".2.", ".2.", "2..", "2..", "2..",
"2.22", "2.22", "222.", "222.", "222.", "222.",
};

const char *gamgi_phys_symmetry_positions_94 [7] = {
"1", "..2", "..2", "2..", "2..", "2.22", "2.22",
};

const char *gamgi_phys_symmetry_positions_95 [4] = {
"1", "..2", ".2.", ".2.",
};

const char *gamgi_phys_symmetry_positions_96 [2] = {
"1", "..2", 
};

const char *gamgi_phys_symmetry_positions_97 [11] = {
"1", "..2", ".2.", ".2.", "..2", "2..", "4..", 
"2.22", "222.", "422", "422",
};

const char *gamgi_phys_symmetry_positions_98 [7] = {
"1", ".2.", "..2", "..2", "2..", "2.22", "2.22",
};

const char *gamgi_phys_symmetry_positions_99 [7] = {
"1", ".m.", ".m.", "..m", "2mm.", "4mm", "4mm",
};

const char *gamgi_phys_symmetry_positions_100 [4] = {
"1", "..m", "2.mm", "4..",
};

const char *gamgi_phys_symmetry_positions_101 [5] = {
"1", "..m", "2..", "2.mm", "2.mm", 
};

const char *gamgi_phys_symmetry_positions_102 [4] = {
"1", "..m", "2..", "2.mm", 
};

const char *gamgi_phys_symmetry_positions_103 [4] = {
"1", "2..", "4..", "4..",
};

const char *gamgi_phys_symmetry_positions_104 [3] = {
"1", "2..", "4..", 
};

const char *gamgi_phys_symmetry_positions_105 [6] = {
"1", ".m.", ".m.", "2mm.", "2mm.", "2mm.",
};

const char *gamgi_phys_symmetry_positions_106 [3] = {
"1", "2..", "2..", 
};

const char *gamgi_phys_symmetry_positions_107 [5] = {
"1", ".m.", "..m", "2mm.", "4mm",
};

const char *gamgi_phys_symmetry_positions_108 [4] = {
"1", "..m", "2.mm", "4..",
};

const char *gamgi_phys_symmetry_positions_109 [3] = {
"1", ".m.", "2mm.",
};

const char *gamgi_phys_symmetry_positions_110 [2] = {
"1", "2..", 
};

const char *gamgi_phys_symmetry_positions_111 [15] = {
"1", "..m", "2..", ".2.", ".2.", ".2.", ".2.", "2.mm", "2.mm", 
"222.", "222.", "-42m", "-42m", "-42m", "-42m",
};

const char *gamgi_phys_symmetry_positions_112 [14] = {
"1", "2..", "2..", "2..", ".2.", ".2.", ".2.", ".2.",
"-4..", "-4..", "222.", "222.", "222.", "222.",
};

const char *gamgi_phys_symmetry_positions_113 [6] = {
"1", "..m", "2..", "2.mm", "-4..", "-4..",
};

const char *gamgi_phys_symmetry_positions_114 [5] = {
"1", "2..", "2..", "-4..", "-4..",
};

const char *gamgi_phys_symmetry_positions_115 [12] = {
"1", ".m.", ".m.", "..2", "..2", "2mm.", "2mm.", "2mm.",
"-4m2", "-4m2", "-4m2", "-4m2",
};

const char *gamgi_phys_symmetry_positions_116 [10] = {
"1", "2..", "2..", "2..", "..2", "..2", "-4..", "-4..", "2.22", "2.22",
};

const char *gamgi_phys_symmetry_positions_117 [9] = {
"1", "..2", "..2", "2..", "2..", "2.22", "2.22", "-4..", "-4..",
};

const char *gamgi_phys_symmetry_positions_118 [9] = {
"1", "2..", "..2", "..2", "2..", "2.22", "2.22", "-4..", "-4..",
};

const char *gamgi_phys_symmetry_positions_119 [10] = {
"1", ".m.", "..2", "..2", "2mm.", "2mm.", "-4m2", "-4m2", "-4m2", "-4m2",
};

const char *gamgi_phys_symmetry_positions_120 [9] = {
"1", "..2", "2..", "2..", "..2", "2.22", "-4..", "-4..", "2.22",
};

const char *gamgi_phys_symmetry_positions_121 [10] = {
"1", "..m", "2..", ".2.", ".2.", "2.mm", "-4..", "222.", "-42m", "-42m",
};

const char *gamgi_phys_symmetry_positions_122 [5] = {
"1", ".2.", "2..", "-4..", "-4..",
};

const char *gamgi_phys_symmetry_positions_123 [21] = {
"1", ".m.", ".m.", "..m", "m..", "m..", "m2m.", "m2m.", "m2m.", "m2m.",
"m.2m", "m.2m", "2mm.", "4mm", "4mm", "mmm.", "mmm.", "4/mmm", "4/mmm",
"4/mmm", "4/mmm",
};

const char *gamgi_phys_symmetry_positions_124 [14] = {
"1", "m..", ".2.", ".2.", "..2", "2..", "4..", "4..", "222.", 
"2/m..", "4/m..", "422", "4/m..", "422",
};

const char *gamgi_phys_symmetry_positions_125 [14] = {
"1", "..m", ".2.", ".2.", "..2", "..2", "2.mm", "4..", 
"..2/m", "..2/m", "-42m", "-42m", "422", "422",
};

const char *gamgi_phys_symmetry_positions_126 [11] = {
"1", ".2.", ".2.", "..2", "2..", "-1", "4..", "-4..", "222.", "422", "422",
};

const char *gamgi_phys_symmetry_positions_127 [12] = {
"1", "..m", "m..", "m..", "m.2m", "m.2m", "2.mm", "4..", "m.mm", "m.mm", 
"4/m..", "4/m..",
};

const char *gamgi_phys_symmetry_positions_128 [9] = {
"1", "m..", "..2", "2..", "4..", "2.22", "2/m..", "4/m..", "4/m..",
};

const char *gamgi_phys_symmetry_positions_129 [11] = {
"1", "..m", ".m.", "..2", "..2", "2mm.", "..2/m", "..2/m",
"4mm", "-4m2", "-4m2",
};

const char *gamgi_phys_symmetry_positions_130 [7] = {
"1", "..2", "2..", "-1", "4..", "-4..", "2.22",
};

const char *gamgi_phys_symmetry_positions_131 [18] = {
"1", "m..", ".m.", ".m.", "..2", "m2m.", "m2m.", "m2m.", "m2m.",
"2mm.", "2mm.", "2mm.", "-4m2", "-4m2", "mmm.", "mmm.", "mmm.", "mmm.",
};

const char *gamgi_phys_symmetry_positions_132 [16] = {
"1", "..m", "m..", ".2.", ".2.", "2..", "m.2m", "m.2m",
"2.mm", "2.mm", "2/m..", "222.", "-42m", "m.mm", "-42m", "m.mm",
};

const char *gamgi_phys_symmetry_positions_133 [11] = {
"1", "..2", ".2.", ".2.", "2..", "2..", "-1", "-4..", "2.22", "222.", "222.",
};

const char *gamgi_phys_symmetry_positions_134 [14] = {
"1", "..m", "..2", "..2", ".2.", ".2.", "2..", "2.mm", "..2/m", "..2/m",
"2.22", "222.", "-42m", "-42m",
};

const char *gamgi_phys_symmetry_positions_135 [9] = {
"1", "m..", "..2", "2..", "2..", "2.22", "2/m..", "-4..", "2/m..",
};

const char *gamgi_phys_symmetry_positions_136 [11] = {
"1", "..m", "m..", "2..", "m.2m", "m.2m", "2.mm", "-4..", "2/m..",
"m.mm", "m.mm",
};

const char *gamgi_phys_symmetry_positions_137 [8] = {
"1", ".m.", "..2", "-1", "2mm.", "2mm.", "-4m2", "-4m2",
};

const char *gamgi_phys_symmetry_positions_138 [10] = {
"1", "..m", "..2", "..2", "2..", "2.mm", "..2/m", "..2/m", "-4..", "2.22",
};

const char *gamgi_phys_symmetry_positions_139 [15] = {
"1", ".m.", "..m", "m..", "..2", "m2m.", "m2m.", "m.2m", "2mm.", 
"..2/m", "4mm", "-4m2", "mmm.", "4/mmm", "4/mmm",
};

const char *gamgi_phys_symmetry_positions_140 [13] = {
"1", "..m", "m..", ".2.", "..2", "m.2m", "2.mm", "4..", 
"..2/m", "m.mm", "4/m..", "-42m", "422",
};

const char *gamgi_phys_symmetry_positions_141 [9] = {
"1", ".m.", "..2", ".2.", "2mm.", ".2/m.", ".2/m.", "-4m2", "-4m2",
};

const char *gamgi_phys_symmetry_positions_142 [7] = {
"1", "..2", ".2.", "2..", "-1", "2.22", "-4..", 
};

const char *gamgi_phys_symmetry_positions_143 [4] = {
"1", "3..", "3..", "3..",
};

const char *gamgi_phys_symmetry_positions_144 [1] = {
"1", 
};

const char *gamgi_phys_symmetry_positions_145 [1] = {
"1", 
};

const char *gamgi_phys_symmetry_positions_146 [2] = {
"1", "3.", 
};

const char *gamgi_phys_symmetry_positions_147 [7] = {
"1", "-1", "-1", "3..", "3..", "-3..", "-3..",
};

const char *gamgi_phys_symmetry_positions_148 [6] = {
"1", "-1", "-1", "3.", "-3.", "-3."
};

const char *gamgi_phys_symmetry_positions_149 [12] = {
"1", "..2", "..2", "3..", "3..", "3..", 
"3.2", "3.2", "3.2", "3.2", "3.2", "3.2",
};

const char *gamgi_phys_symmetry_positions_150 [7] = {
"1", ".2.", ".2.", "3..", "3..", "32.", "32.",
};

const char *gamgi_phys_symmetry_positions_151 [3] = {
"1", "..2", "..2",
};

const char *gamgi_phys_symmetry_positions_152 [3] = {
"1", ".2.", ".2.",
};

const char *gamgi_phys_symmetry_positions_153 [3] = {
"1", "..2", "..2",
};

const char *gamgi_phys_symmetry_positions_154 [3] = {
"1", ".2.", ".2.",
};

const char *gamgi_phys_symmetry_positions_155 [6] = {
"1", ".2", ".2", "3.", "32", "32",
};

const char *gamgi_phys_symmetry_positions_156 [5] = {
"1", ".m.", "3m.", "3m.", "3m.",
};

const char *gamgi_phys_symmetry_positions_157 [4] = {
"1", "..m", "3..", "3.m",
};

const char *gamgi_phys_symmetry_positions_158 [4] = {
"1", "3..", "3..", "3..",
};

const char *gamgi_phys_symmetry_positions_159 [3] = {
"1", "3..", "3..",
};

const char *gamgi_phys_symmetry_positions_160 [3] = {
"1", ".m", "3m", 
};

const char *gamgi_phys_symmetry_positions_161 [2] = {
"1", "3.",
};

const char *gamgi_phys_symmetry_positions_162 [12] = {
"1", "..m", "..2", "..2", "3..", "..2/m", "..2/m", "3.m", "3.2", "3.2", "-3.m", "-3.m",
};

const char *gamgi_phys_symmetry_positions_163 [9] = {
"1", "..2", "-1", "3..", "3..", "3.2", "3.2", "-3..", "3.2",
};

const char *gamgi_phys_symmetry_positions_164 [10] = {
"1", ".m.", ".2.", ".2.", ".2/m.", ".2/m.", "3m.", "3m.", "-3m.", "-3m.",
};

const char *gamgi_phys_symmetry_positions_165 [7] = {
"1", ".2.", "-1", "3..", "3..", "-3..", "32.", 
};

const char *gamgi_phys_symmetry_positions_166 [9] = {
"1", ".m", ".2", ".2", ".2/m", ".2/m", "3m", "-3m", "-3m",
};

const char *gamgi_phys_symmetry_positions_167 [6] = {
"1", ".2", "-1", "3.", "-3.", "32",
};

const char *gamgi_phys_symmetry_positions_168 [4] = {
"1", "2..", "3..", "6..", 
};

const char *gamgi_phys_symmetry_positions_169 [1] = {
"1",
};

const char *gamgi_phys_symmetry_positions_170 [1] = {
"1",
};

const char *gamgi_phys_symmetry_positions_171 [3] = {
"1", "2..", "2..",
};

const char *gamgi_phys_symmetry_positions_172 [3] = {
"1", "2..", "2..",
};

const char *gamgi_phys_symmetry_positions_173 [3] = {
"1", "3..", "3..",
};

const char *gamgi_phys_symmetry_positions_174 [12] = {
"1", "m..", "m..", "3..", "3..", "3..", "-6..", "-6..", 
"-6..", "-6..", "-6..", "-6..",
};

const char *gamgi_phys_symmetry_positions_175 [12] = {
"1", "m..", "m..", "2..", "3..", "2/m..", "2/m..",
"6..", "-6..", "-6..", "6/m..", "6/m..",
};

const char *gamgi_phys_symmetry_positions_176 [9] = {
"1", "m..", "-1", "3..", "3..", "-6..", "-6..", "-3..", "-6..",
};

const char *gamgi_phys_symmetry_positions_177 [14] = {
"1", "..2", "..2", ".2.", ".2.", "2..", "3..", "222", "222",
"6..", "3.2", "3.2", "622", "622",
};

const char *gamgi_phys_symmetry_positions_178 [3] = {
"1", "..2", ".2.",
};

const char *gamgi_phys_symmetry_positions_179 [3] = {
"1", "..2", ".2.",
};

const char *gamgi_phys_symmetry_positions_180 [11] = {
"1", "..2", "..2", ".2.", ".2.", "2..", "2..", "222", "222", "222", "222",
};

const char *gamgi_phys_symmetry_positions_181 [11] = {
"1", "..2", "..2", ".2.", ".2.", "2..", "2..", "222", "222", "222", "222",
};

const char *gamgi_phys_symmetry_positions_182 [9] = {
"1", "..2", ".2.", "3..", "3..", "3.2", "3.2", "3.2", "32.",
};

const char *gamgi_phys_symmetry_positions_183 [6] = {
"1", ".m.", "..m", "2mm", "3m.", "6mm",
};

const char *gamgi_phys_symmetry_positions_184 [4] = {
"1", "2..", "3..", "6..",
};

const char *gamgi_phys_symmetry_positions_185 [4] = {
"1", "..m", "3..", "3.m",
};

const char *gamgi_phys_symmetry_positions_186 [4] = {
"1", ".m.", "3m.", "3m.",
};

const char *gamgi_phys_symmetry_positions_187 [15] = {
"1", ".m.", "m..", "m..", "mm2", "mm2", "3m.", "3m.", "3m.",
"-6m2", "-6m2", "-6m2", "-6m2", "-6m2", "-6m2",
};

const char *gamgi_phys_symmetry_positions_188 [12] = {
"1", "m..", "..2", "3..", "3..", "3..", "-6..", "3.2", 
"-6..", "3.2", "-6..", "3.2",
};

const char *gamgi_phys_symmetry_positions_189 [12] = {
"1", "m..", "m..", "..m", "3..", "m2m", "m2m", "3.m", 
"-6..", "-6..", "-62m", "-62m", 
};

const char *gamgi_phys_symmetry_positions_190 [9] = {
"1", "m..", ".2.", "3..", "3..", "-6..", "-6..", "-6..", "32.", 
};

const char *gamgi_phys_symmetry_positions_191 [18] = {
"1", "m..", "m..", ".m.", "..m", "mm2", "mm2", "m2m", "m2m", "2mm",
"3m.", "mmm", "mmm", "6mm", "-6m2", "-6m2", "6/mmm", "6/mmm",
};

const char *gamgi_phys_symmetry_positions_192 [13] = {
"1", "m..", "..2", ".2.", "2..", "3..", "2/m..",
"222", "6..", "-6..", "3.2", "6/m..", "622",
};

const char *gamgi_phys_symmetry_positions_193 [12] = {
"1", "..m", "m..", "..2", "3..", "m2m", "..2/m", "3.m",
"3.2", "-6..", "-3.m", "-62m",
};

const char *gamgi_phys_symmetry_positions_194 [12] = {
"1", ".m.", "m..", ".2.", "mm2", ".2/m.", "3m.", "3m.",
"-6m2", "-6m2", "-6m2", "-3m.",
};

const char *gamgi_phys_symmetry_positions_195 [10] = {
"1", "2..", "2..", "2..", "2..", ".3.", "222..", "222..", "23.", "23.",
};

const char *gamgi_phys_symmetry_positions_196 [8] = {
"1", "2..", "2..", ".3.", "23.", "23.", "23.", "23.",
};

const char *gamgi_phys_symmetry_positions_197 [6] = {
"1", "2..", "2..", ".3.", "222..", "23.",
};

const char *gamgi_phys_symmetry_positions_198 [2] = {
"1", ".3.",
};

const char *gamgi_phys_symmetry_positions_199 [3] = {
"1", "2..", ".3.",
};

const char *gamgi_phys_symmetry_positions_200 [12] = {
"1", "m..", "m..", ".3.", "mm2..", "mm2..", "mm2..", "mm2..", 
"mmm..", "mmm..", "m-3.", "m-3.",
};

const char *gamgi_phys_symmetry_positions_201 [8] = {
"1", "2..", "2..", ".3.", "222..", ".-3.", ".-3.", "23.",
};

const char *gamgi_phys_symmetry_positions_202 [9] = {
"1", "m..", "2..", ".3.", "mm2..", "2/m..", "23.", "m-3.", "m-3.",
};

const char *gamgi_phys_symmetry_positions_203 [7] = {
"1", "2..", ".3.", ".-3.", ".-3.", "23.", "23.",
};

const char *gamgi_phys_symmetry_positions_204 [8] = {
"1", "m..", ".3.", "mm2..", "mm2..", ".-3.", "mmm..", "m-3.",
};

const char *gamgi_phys_symmetry_positions_205 [4] = {
"1", ".3.", ".-3.", ".-3.",
};

const char *gamgi_phys_symmetry_positions_206 [5] = {
"1", "2..", ".3.", ".-3.", ".-3.",
};

const char *gamgi_phys_symmetry_positions_207 [11] = {
"1", "..2", "..2", "2..", ".3.", "4..", "4..", "42.2", "42.2", "432", "432",
};

const char *gamgi_phys_symmetry_positions_208 [13] = {
"1", "..2", "..2", "2..", "2..", "2..", ".3.", "2.22", "2.22", 
"222..", ".32", ".32", "23.",
};

const char *gamgi_phys_symmetry_positions_209 [10] = {
"1", "2..", "..2", "..2", ".3.", "4..", "2.22", "23.", "432", "432",
};

const char *gamgi_phys_symmetry_positions_210 [8] = {
"1", "..2", "2..", ".3.", ".32", ".32", "23.", "23.",
};

const char *gamgi_phys_symmetry_positions_211 [10] = {
"1", "..2", "..2", "2..", ".3.", "4..", "2.22", ".32", "42.2", "432",
};

const char *gamgi_phys_symmetry_positions_212 [5] = {
"1", "..2", ".3.", ".32", ".32",
};

const char *gamgi_phys_symmetry_positions_213 [5] = {
"1", "..2", ".3.", ".32", ".32",
};

const char *gamgi_phys_symmetry_positions_214 [9] = {
"1", "..2", "..2", "2..", ".3.", "2.22", "2.22", ".32", ".32",
};

const char *gamgi_phys_symmetry_positions_215 [10] = {
"1", "..m", "2..", "2.mm", "2.mm", ".3m", "-42.m", "-42.m", "-43m", "-43m",
};

const char *gamgi_phys_symmetry_positions_216 [9] = {
"1", "..m", "2.mm", "2.mm", ".3m", "-43m", "-43m", "-43m", "-43m",
};

const char *gamgi_phys_symmetry_positions_217 [8] = {
"1", "..m", "2..", "2.mm", "-4..", ".3m", "-42.m", "-43m", 
};

const char *gamgi_phys_symmetry_positions_218 [9] = {
"1", "2..", "2..", "2..", ".3.", "-4..", "-4..", "222..", "23.",
};

const char *gamgi_phys_symmetry_positions_219 [8] = {
"1", "2..", "2..", ".3.", "-4..", "-4..", "23.", "23.",
};

const char *gamgi_phys_symmetry_positions_220 [5] = {
"1", "2..", ".3.", "-4..", "-4..",
};

const char *gamgi_phys_symmetry_positions_221 [14] = {
"1", "..m", "m..", "m..", "m.m2", "m.m2", "mm2..", ".3m",
"4m.m", "4m.m", "4/mm.m", "4/mm.m", "m-3m", "m-3m",
};

const char *gamgi_phys_symmetry_positions_222 [9] = {
"1", "..2", "2..", ".3.", "4..", "-4..", ".-3.", "42.2", "432",
};

const char *gamgi_phys_symmetry_positions_223 [12] = {
"1", "m..", "..2", ".3.", "mm2..", "mm2..", "mm2..",
".32", "-4m.2", "-4m.2", "mmm..", "m-3.",
};

const char *gamgi_phys_symmetry_positions_224 [12] = {
"1", "..m", "..2", "..2", "2..", "2.mm", "2.22", ".3m",
"-42.m", ".-3m", ".-3m", "-43m",
};

const char *gamgi_phys_symmetry_positions_225 [12] = {
"1", "..m", "m..", "m.m2", "m.m2", "2.mm", ".3m", "4m.m", "m.mm",
"-43m", "m-3m", "m-3m",
};

const char *gamgi_phys_symmetry_positions_226 [10] = {
"1", "m..", "..2", ".3.", "4..", "mm2..", "4/m..",
"-4m.2", "m-3.", "432",
};

const char *gamgi_phys_symmetry_positions_227 [9] = {
"1", "..2", "..m", "2.mm", ".3m", ".-3m", ".-3m", "-43m", "-43m",
};

const char *gamgi_phys_symmetry_positions_228 [8] = {
"1", "..2", "2..", ".3.", "-4..", ".-3.", ".32", "23.",
};

const char *gamgi_phys_symmetry_positions_229 [12] = {
"1", "..m", "m..", "..2", "m.m2", "mm2..", ".3m", "4m.m", 
"-4m.2", ".-3m", "4/mm.m", "m-3m",
};

const char *gamgi_phys_symmetry_positions_230 [8] = {
"1", "..2", "2..", ".3.", "-4..", "2.22", ".32", ".-3.",
};

/********************************
 * Format for driver arrays:    *
 * { number of sites, ... ,     *
 * { last position for site c,  *
 * { last position for site b,  *
 * { last position for site a } *
 ********************************/

const int gamgi_phys_symmetry_driver_1 [2] = {
1, 0 };

const int gamgi_phys_symmetry_driver_2 [10] = {
9, 1, 2, 3, 4, 5, 6, 7, 8, 9 };

const int gamgi_phys_symmetry_driver_3 [6] = {
5, 1, 2, 3, 4, 5 };

const int gamgi_phys_symmetry_driver_4 [2] = {
1, 1 };

const int gamgi_phys_symmetry_driver_5 [4] = {
3, 1, 2, 3 };

const int gamgi_phys_symmetry_driver_6 [4] = {
3, 1, 2, 3 };

const int gamgi_phys_symmetry_driver_7 [2] = {
1, 1 };

const int gamgi_phys_symmetry_driver_8 [3] = {
2, 1, 2 };

const int gamgi_phys_symmetry_driver_9 [2] = {
1, 1 };

const int gamgi_phys_symmetry_driver_10 [16] = {
15, 3, 5, 7, 9, 11, 13, 15, 16, 17, 18, 19, 20, 21, 22, 23 };

const int gamgi_phys_symmetry_driver_11 [7] = {
6, 3, 5, 7, 9, 11, 13 };

const int gamgi_phys_symmetry_driver_12 [11] = {
10, 3, 5, 7, 9, 11, 13, 14, 15, 16, 17 };

const int gamgi_phys_symmetry_driver_13 [8] = {
7, 3, 5, 7, 9, 11, 13, 15 };

const int gamgi_phys_symmetry_driver_14 [6] = {
5, 3, 5, 7, 9, 11 };

const int gamgi_phys_symmetry_driver_15 [7] = {
6, 3, 5, 7, 9, 11, 13 };

const int gamgi_phys_symmetry_driver_16 [22] = {
21, 3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 23, 25, 27, 28, 29, 30, 31, 32, 33, 34, 35 };

const int gamgi_phys_symmetry_driver_17 [6] = {
5, 3, 5, 7, 9, 11 };

const int gamgi_phys_symmetry_driver_18 [4] = {
3, 3, 5, 7 };

const int gamgi_phys_symmetry_driver_19 [2] = {
1, 3 };

const int gamgi_phys_symmetry_driver_20 [4] = {
3, 3, 5, 7 };

const int gamgi_phys_symmetry_driver_21 [13] = {
12, 3, 5, 7, 9, 11, 13, 15, 17, 18, 19, 20, 21 };

const int gamgi_phys_symmetry_driver_22 [12] = {
11, 3, 5, 7, 9, 11, 13, 15, 16, 17, 18, 19 };

const int gamgi_phys_symmetry_driver_23 [12] = {
11, 3, 5, 7, 9, 11, 13, 15, 16, 17, 18, 19 };

const int gamgi_phys_symmetry_driver_24 [5] = {
4, 3, 5, 7, 9 };

const int gamgi_phys_symmetry_driver_25 [10] = {
9, 3, 5, 7, 9, 11, 12, 13, 14, 15 };

const int gamgi_phys_symmetry_driver_26 [4] = {
3, 3, 5, 7 };

const int gamgi_phys_symmetry_driver_27 [6] = {
5, 3, 5, 7, 9, 11 };

const int gamgi_phys_symmetry_driver_28 [5] = {
4, 3, 5, 7, 9 };

const int gamgi_phys_symmetry_driver_29 [2] = {
1, 3 };

const int gamgi_phys_symmetry_driver_30 [4] = {
3, 3, 5, 7 };

const int gamgi_phys_symmetry_driver_31 [3] = {
2, 3, 5 };

const int gamgi_phys_symmetry_driver_32 [4] = {
3, 3, 5, 7 };

const int gamgi_phys_symmetry_driver_33 [2] = {
1, 3 };

const int gamgi_phys_symmetry_driver_34 [4] = {
3, 3, 5, 7 };

const int gamgi_phys_symmetry_driver_35 [7] = {
6, 3, 5, 7, 9, 10, 11 };

const int gamgi_phys_symmetry_driver_36 [3] = {
2, 3, 5 };

const int gamgi_phys_symmetry_driver_37 [5] = {
4, 3, 5, 7, 9 };

const int gamgi_phys_symmetry_driver_38 [7] = {
6, 3, 5, 7, 9, 10, 11 };

const int gamgi_phys_symmetry_driver_39 [5] = {
4, 3, 5, 7, 9 };

const int gamgi_phys_symmetry_driver_40 [4] = {
3, 3, 5, 7 };

const int gamgi_phys_symmetry_driver_41 [3] = {
2, 3, 5 };

const int gamgi_phys_symmetry_driver_42 [6] = {
5, 3, 5, 7, 9, 10 };

const int gamgi_phys_symmetry_driver_43 [3] = {
2, 3, 5 };

const int gamgi_phys_symmetry_driver_44 [6] = {
5, 3, 5, 7, 8, 9 };

const int gamgi_phys_symmetry_driver_45 [4] = {
3, 3, 5, 7 };

const int gamgi_phys_symmetry_driver_46 [4] = {
3, 3, 5, 7 };

const int gamgi_phys_symmetry_driver_47 [28] = {
27, 7, 11, 15, 19, 23, 27, 31, 33, 35, 37, 39, 41, 43, 45, 47, 49, 51, 53, 55, 56, 57, 58, 59, 60, 61, 62, 63 };

const int gamgi_phys_symmetry_driver_48 [14] = {
13, 7, 11, 15, 19, 23, 27, 31, 35, 39, 41, 43, 45, 47 };

const int gamgi_phys_symmetry_driver_49 [19] = {
18, 7, 11, 15, 19, 23, 27, 31, 35, 39, 43, 45, 47, 49, 51, 53, 55, 57, 59 };

const int gamgi_phys_symmetry_driver_50 [14] = {
13, 7, 11, 15, 19, 23, 27, 31, 35, 39, 41, 43, 45, 47 };

const int gamgi_phys_symmetry_driver_51 [13] = {
12, 7, 11, 15, 19, 23, 27, 29, 31, 33, 35, 37, 39 };

const int gamgi_phys_symmetry_driver_52 [6] = {
5, 7, 11, 15, 19, 23 };

const int gamgi_phys_symmetry_driver_53 [10] = {
9, 7, 11, 15, 19, 23, 25, 27, 29, 31 };

const int gamgi_phys_symmetry_driver_54 [7] = {
6, 7, 11, 15, 19, 23, 27 };

const int gamgi_phys_symmetry_driver_55 [10] = {
9, 7, 11, 15, 19, 23, 25, 27, 29, 31 };

const int gamgi_phys_symmetry_driver_56 [6] = {
5, 7, 11, 15, 19, 23 };

const int gamgi_phys_symmetry_driver_57 [6] = {
5, 7, 11, 15, 19, 23 };

const int gamgi_phys_symmetry_driver_58 [9] = {
8, 7, 11, 15, 19, 21, 23, 25, 27 };

const int gamgi_phys_symmetry_driver_59 [8] = {
7, 7, 11, 15, 19, 23, 25, 27 };

const int gamgi_phys_symmetry_driver_60 [5] = {
4, 7, 11, 15, 19 };

const int gamgi_phys_symmetry_driver_61 [4] = {
3, 7, 11, 15 };

const int gamgi_phys_symmetry_driver_62 [5] = {
4, 7, 11, 15, 19 };

const int gamgi_phys_symmetry_driver_63 [9] = {
8, 7, 11, 15, 19, 23, 25, 27, 29 };

const int gamgi_phys_symmetry_driver_64 [8] = {
7, 7, 11, 15, 19, 23, 25, 27 };

const int gamgi_phys_symmetry_driver_65 [19] = {
18, 7, 11, 15, 19, 23, 27, 29, 31, 33, 35, 37, 39, 41, 43, 44, 45, 46, 47 };

const int gamgi_phys_symmetry_driver_66 [14] = {
13, 7, 11, 15, 19, 23, 27, 31, 33, 35, 37, 39, 41, 43 };

const int gamgi_phys_symmetry_driver_67 [16] = {
15, 7, 11, 15, 19, 23, 27, 31, 35, 37, 39, 41, 43, 45, 47, 49 };

const int gamgi_phys_symmetry_driver_68 [10] = {
9, 7, 11, 15, 19, 23, 27, 31, 33, 35 };

const int gamgi_phys_symmetry_driver_69 [17] = {
16, 7, 11, 15, 19, 23, 27, 31, 33, 35, 37, 39, 41, 43, 45, 46, 47 };

const int gamgi_phys_symmetry_driver_70 [9] = {
8, 7, 11, 15, 19, 23, 27, 29, 31 };

const int gamgi_phys_symmetry_driver_71 [16] = {
15, 7, 11, 15, 19, 23, 25, 27, 29, 31, 33, 35, 36, 37, 38, 39 };

const int gamgi_phys_symmetry_driver_72 [12] = {
11, 7, 11, 15, 19, 23, 27, 31, 33, 35, 37, 39 };

const int gamgi_phys_symmetry_driver_73 [7] = {
6, 7, 11, 15, 19, 23, 27 };

const int gamgi_phys_symmetry_driver_74 [11] = {
10, 7, 11, 15, 19, 23, 25, 27, 29, 31, 33 };

const int gamgi_phys_symmetry_driver_75 [5] = {
4, 3, 5, 6, 7 };

const int gamgi_phys_symmetry_driver_76 [2] = {
1, 3 };

const int gamgi_phys_symmetry_driver_77 [5] = {
4, 3, 5, 7, 9 };

const int gamgi_phys_symmetry_driver_78 [2] = {
1, 3 };

const int gamgi_phys_symmetry_driver_79 [4] = {
3, 3, 5, 6 };

const int gamgi_phys_symmetry_driver_80 [3] = {
2, 3, 5 };

const int gamgi_phys_symmetry_driver_81 [9] = {
8, 3, 5, 7, 9, 10, 11, 12, 13 };

const int gamgi_phys_symmetry_driver_82 [8] = {
7, 3, 5, 7, 8, 9, 10, 11 };

const int gamgi_phys_symmetry_driver_83 [13] = {
12, 7, 11, 15, 19, 21, 23, 25, 27, 28, 29, 30, 31 };

const int gamgi_phys_symmetry_driver_84 [12] = {
11, 7, 11, 15, 19, 23, 25, 27, 29, 31, 33, 35 };

const int gamgi_phys_symmetry_driver_85 [8] = {
7, 7, 11, 15, 19, 21, 23, 25 };

const int gamgi_phys_symmetry_driver_86 [8] = {
7, 7, 11, 15, 19, 23, 25, 27 };

const int gamgi_phys_symmetry_driver_87 [10] = {
9, 7, 11, 15, 19, 21, 23, 25, 26, 27 };

const int gamgi_phys_symmetry_driver_88 [7] = {
6, 7, 11, 15, 19, 21, 23 };

const int gamgi_phys_symmetry_driver_89 [17] = {
16, 7, 11, 15, 19, 23, 27, 31, 35, 37, 39, 41, 43, 44, 45, 46, 47 };

const int gamgi_phys_symmetry_driver_90 [8] = {
7, 7, 11, 15, 19, 21, 23, 25 };

const int gamgi_phys_symmetry_driver_91 [5] = {
4, 7, 11, 15, 19 };

const int gamgi_phys_symmetry_driver_92 [3] = {
2, 7, 11 };

const int gamgi_phys_symmetry_driver_93 [17] = {
16, 7, 11, 15, 19, 23, 27, 31, 35, 39, 43, 45, 47, 49, 51, 53, 55 };

const int gamgi_phys_symmetry_driver_94 [8] = {
7, 7, 11, 15, 19, 23, 25, 27 };

const int gamgi_phys_symmetry_driver_95 [5] = {
4, 7, 11, 15, 19 };

const int gamgi_phys_symmetry_driver_96 [3] = {
2, 7, 11 };

const int gamgi_phys_symmetry_driver_97 [12] = {
11, 7, 11, 15, 19, 23, 27, 29, 31, 33, 34, 35 };

const int gamgi_phys_symmetry_driver_98 [8] = {
7, 7, 11, 15, 19, 23, 25, 27 };

const int gamgi_phys_symmetry_driver_99 [8] = {
7, 7, 11, 15, 19, 21, 22, 23 };

const int gamgi_phys_symmetry_driver_100 [5] = {
4, 7, 11, 13, 15 };

const int gamgi_phys_symmetry_driver_101 [6] = {
5, 7, 11, 15, 17, 19 };

const int gamgi_phys_symmetry_driver_102 [5] = {
4, 7, 11, 15, 17 };

const int gamgi_phys_symmetry_driver_103 [5] = {
4, 7, 11, 13, 15 };

const int gamgi_phys_symmetry_driver_104 [4] = {
3, 7, 11, 13 };

const int gamgi_phys_symmetry_driver_105 [7] = {
6, 7, 11, 15, 17, 19, 21 };

const int gamgi_phys_symmetry_driver_106 [4] = {
3, 7, 11, 15 };

const int gamgi_phys_symmetry_driver_107 [6] = {
5, 7, 11, 15, 17, 18 };

const int gamgi_phys_symmetry_driver_108 [5] = {
4, 7, 11, 13, 15 };

const int gamgi_phys_symmetry_driver_109 [4] = {
3, 7, 11, 13 };

const int gamgi_phys_symmetry_driver_110 [3] = {
2, 7, 11 };

const int gamgi_phys_symmetry_driver_111 [16] = {
15, 7, 11, 15, 19, 23, 27, 31, 33, 35, 37, 39, 40, 41, 42, 43 };

const int gamgi_phys_symmetry_driver_112 [15] = {
14, 7, 11, 15, 19, 23, 27, 31, 35, 37, 39, 41, 43, 45, 47 };

const int gamgi_phys_symmetry_driver_113 [7] = {
6, 7, 11, 15, 17, 19, 21 };

const int gamgi_phys_symmetry_driver_114 [6] = {
5, 7, 11, 15, 17, 19 };

const int gamgi_phys_symmetry_driver_115 [13] = {
12, 7, 11, 15, 19, 23, 25, 27, 29, 30, 31, 32, 33 };

const int gamgi_phys_symmetry_driver_116 [11] = {
10, 7, 11, 15, 19, 23, 27, 29, 31, 33, 35 };

const int gamgi_phys_symmetry_driver_117 [10] = {
9, 7, 11, 15, 19, 23, 25, 27, 29, 31 };

const int gamgi_phys_symmetry_driver_118 [10] = {
9, 7, 11, 15, 19, 23, 25, 27, 29, 31 };

const int gamgi_phys_symmetry_driver_119 [11] = {
10, 7, 11, 15, 19, 21, 23, 24, 25, 26, 27 };

const int gamgi_phys_symmetry_driver_120 [10] = {
9, 7, 11, 15, 19, 23, 25, 27, 29, 31 };

const int gamgi_phys_symmetry_driver_121 [11] = {
10, 7, 11, 15, 19, 23, 25, 27, 29, 30, 31 };

const int gamgi_phys_symmetry_driver_122 [6] = {
5, 7, 11, 15, 17, 19 };

const int gamgi_phys_symmetry_driver_123 [22] = {
21, 15, 23, 31, 39, 47, 55, 59, 63, 67, 71, 75, 79, 83, 85, 87, 89, 91, 92, 93, 94, 95 };

const int gamgi_phys_symmetry_driver_124 [15] = {
14, 15, 23, 31, 39, 47, 55, 59, 63, 67, 71, 73, 75, 77, 79 };

const int gamgi_phys_symmetry_driver_125 [15] = {
14, 15, 23, 31, 39, 47, 55, 59, 63, 67, 71, 73, 75, 77, 79 };

const int gamgi_phys_symmetry_driver_126 [12] = {
11, 15, 23, 31, 39, 47, 55, 59, 63, 67, 69, 71 };

const int gamgi_phys_symmetry_driver_127 [13] = {
12, 15, 23, 31, 39, 43, 47, 51, 55, 57, 59, 61, 63 };

const int gamgi_phys_symmetry_driver_128 [10] = {
9, 15, 23, 31, 39, 43, 47, 51, 53, 55 };

const int gamgi_phys_symmetry_driver_129 [12] = {
11, 15, 23, 31, 39, 47, 51, 55, 59, 61, 63, 65 };

const int gamgi_phys_symmetry_driver_130 [8] = {
7, 15, 23, 31, 39, 43, 47, 51 };

const int gamgi_phys_symmetry_driver_131 [19] = {
18, 15, 23, 31, 39, 47, 51, 55, 59, 63, 67, 71, 75, 77, 79, 81, 83, 85, 87 };

const int gamgi_phys_symmetry_driver_132 [17] = {
16, 15, 23, 31, 39, 47, 55, 59, 63, 67, 71, 75, 79, 81, 83, 85, 87 };

const int gamgi_phys_symmetry_driver_133 [12] = {
11, 15, 23, 31, 39, 47, 55, 63, 67, 71, 75, 79 };

const int gamgi_phys_symmetry_driver_134 [15] = {
14, 15, 23, 31, 39, 47, 55, 63, 67, 71, 75, 79, 83, 85, 87 };

const int gamgi_phys_symmetry_driver_135 [10] = {
9, 15, 23, 31, 39, 47, 51, 55, 59, 63 };

const int gamgi_phys_symmetry_driver_136 [12] = {
11, 15, 23, 31, 39, 43, 47, 51, 55, 59, 61, 63 };

const int gamgi_phys_symmetry_driver_137 [9] = {
8, 15, 23, 31, 39, 43, 47, 49, 51 };

const int gamgi_phys_symmetry_driver_138 [11] = {
10, 15, 23, 31, 39, 47, 51, 55, 59, 63, 67 };

const int gamgi_phys_symmetry_driver_139 [16] = {
15, 15, 23, 31, 39, 47, 51, 55, 59, 63, 67, 69, 71, 73, 74, 75 };

const int gamgi_phys_symmetry_driver_140 [14] = {
13, 15, 23, 31, 39, 47, 51, 55, 59, 63, 65, 67, 69, 71 };

const int gamgi_phys_symmetry_driver_141 [10] = {
9, 15, 23, 31, 39, 43, 47, 51, 53, 55 };

const int gamgi_phys_symmetry_driver_142 [8] = {
7, 15, 23, 31, 39, 47, 51, 55 };

const int gamgi_phys_symmetry_driver_143 [5] = {
4, 2, 3, 4, 5 };

const int gamgi_phys_symmetry_driver_144 [2] = {
1, 2 };

const int gamgi_phys_symmetry_driver_145 [2] = {
1, 2 };

const int gamgi_phys_symmetry_driver_146 [3] = {
2, 2, 3 };

const int gamgi_phys_symmetry_driver_147 [8] = {
7, 5, 8, 11, 13, 15, 16, 17 };

const int gamgi_phys_symmetry_driver_148 [7] = {
6, 5, 8, 11, 13, 14, 15 };

const int gamgi_phys_symmetry_driver_149 [13] = {
12, 5, 8, 11, 13, 15, 17, 18, 19, 20, 21, 22, 23 };

const int gamgi_phys_symmetry_driver_150 [8] = {
7, 5, 8, 11, 13, 15, 16, 17 };

const int gamgi_phys_symmetry_driver_151 [4] = {
3, 5, 8, 11 };

const int gamgi_phys_symmetry_driver_152 [4] = {
3, 5, 8, 11 };

const int gamgi_phys_symmetry_driver_153 [4] = {
3, 5, 8, 11 };

const int gamgi_phys_symmetry_driver_154 [4] = {
3, 5, 8, 11 };

const int gamgi_phys_symmetry_driver_155 [7] = {
6, 5, 8, 11, 13, 14, 15 };

const int gamgi_phys_symmetry_driver_156 [6] = {
5, 5, 8, 9, 10, 11 };

const int gamgi_phys_symmetry_driver_157 [5] = {
4, 5, 8, 10, 11 };

const int gamgi_phys_symmetry_driver_158 [5] = {
4, 5, 7, 9, 11 };

const int gamgi_phys_symmetry_driver_159 [4] = {
3, 5, 7, 9 };

const int gamgi_phys_symmetry_driver_160 [4] = {
3, 5, 8, 9 };

const int gamgi_phys_symmetry_driver_161 [3] = {
2, 5, 7 };

const int gamgi_phys_symmetry_driver_162 [13] = {
12, 11, 17, 23, 29, 33, 36, 39, 41, 43, 45, 46, 47 };

const int gamgi_phys_symmetry_driver_163 [10] = {
9, 11, 17, 23, 27, 31, 33, 35, 37, 39 };

const int gamgi_phys_symmetry_driver_164 [11] = {
10, 11, 17, 23, 29, 32, 35, 37, 39, 40, 41 };

const int gamgi_phys_symmetry_driver_165 [8] = {
7, 11, 17, 23, 27, 31, 33, 35 };

const int gamgi_phys_symmetry_driver_166 [10] = {
9, 11, 17, 23, 29, 32, 35, 37, 38, 39 };

const int gamgi_phys_symmetry_driver_167 [7] = {
6, 11, 17, 23, 27, 29, 31 };

const int gamgi_phys_symmetry_driver_168 [5] = {
4, 5, 8, 10, 11 };

const int gamgi_phys_symmetry_driver_169 [2] = {
1, 5 };

const int gamgi_phys_symmetry_driver_170 [2] = {
1, 5 };

const int gamgi_phys_symmetry_driver_171 [4] = {
3, 5, 8, 11 };

const int gamgi_phys_symmetry_driver_172 [4] = {
3, 5, 8, 11 };

const int gamgi_phys_symmetry_driver_173 [4] = {
3, 5, 7, 9 };

const int gamgi_phys_symmetry_driver_174 [13] = {
12, 5, 8, 11, 13, 15, 17, 18, 19, 20, 21, 22, 23 };

const int gamgi_phys_symmetry_driver_175 [13] = {
12, 11, 17, 23, 29, 33, 36, 39, 41, 43, 45, 46, 47 };

const int gamgi_phys_symmetry_driver_176 [10] = {
9, 11, 17, 23, 27, 31, 33, 35, 37, 39 };

const int gamgi_phys_symmetry_driver_177 [15] = {
14, 11, 17, 23, 29, 35, 41, 45, 48, 51, 53, 55, 57, 58, 59 };

const int gamgi_phys_symmetry_driver_178 [4] = {
3, 11, 17, 23 };

const int gamgi_phys_symmetry_driver_179 [4] = {
3, 11, 17, 23 };

const int gamgi_phys_symmetry_driver_180 [12] = {
11, 11, 17, 23, 29, 35, 41, 47, 50, 53, 56, 59 };

const int gamgi_phys_symmetry_driver_181 [12] = {
11, 11, 17, 23, 29, 35, 41, 47, 50, 53, 56, 59 };

const int gamgi_phys_symmetry_driver_182 [10] = {
9, 11, 17, 23, 27, 31, 33, 35, 37, 39 };

const int gamgi_phys_symmetry_driver_183 [7] = {
6, 11, 17, 23, 26, 28, 29 };

const int gamgi_phys_symmetry_driver_184 [5] = {
4, 11, 17, 21, 23 };

const int gamgi_phys_symmetry_driver_185 [5] = {
4, 11, 17, 21, 23 };

const int gamgi_phys_symmetry_driver_186 [5] = {
4, 11, 17, 19, 21 };

const int gamgi_phys_symmetry_driver_187 [16] = {
15, 11, 17, 23, 29, 32, 35, 37, 39, 41, 42, 43, 44, 45, 46, 47 };

const int gamgi_phys_symmetry_driver_188 [13] = {
12, 11, 17, 23, 27, 31, 35, 37, 39, 41, 43, 45, 47 };

const int gamgi_phys_symmetry_driver_189 [13] = {
12, 11, 17, 23, 29, 33, 36, 39, 41, 43, 45, 46, 47 };

const int gamgi_phys_symmetry_driver_190 [10] = {
9, 11, 17, 23, 27, 31, 33, 35, 37, 39 };

const int gamgi_phys_symmetry_driver_191 [19] = {
18, 23, 35, 47, 59, 71, 77, 83, 89, 95, 101, 105, 108, 111, 113, 115, 117, 118, 119 };

const int gamgi_phys_symmetry_driver_192 [14] = {
13, 23, 35, 47, 59, 71, 79, 85, 91, 95, 99, 103, 105, 107 };

const int gamgi_phys_symmetry_driver_193 [13] = {
12, 23, 35, 47, 59, 67, 73, 79, 83, 87, 91, 93, 95 };

const int gamgi_phys_symmetry_driver_194 [13] = {
12, 23, 35, 47, 59, 65, 71, 75, 79, 81, 83, 85, 87 };

const int gamgi_phys_symmetry_driver_195 [11] = {
10, 11, 17, 23, 29, 35, 39, 42, 45, 46, 47 };

const int gamgi_phys_symmetry_driver_196 [9] = {
8, 11, 17, 23, 27, 28, 29, 30, 31 };

const int gamgi_phys_symmetry_driver_197 [7] = {
6, 11, 17, 23, 27, 30, 31 };

const int gamgi_phys_symmetry_driver_198 [3] = {
2, 11, 15 };

const int gamgi_phys_symmetry_driver_199 [4] = {
3, 11, 17, 21 };

const int gamgi_phys_symmetry_driver_200 [13] = {
12, 23, 35, 47, 55, 61, 67, 73, 79, 82, 85, 86, 87 };

const int gamgi_phys_symmetry_driver_201 [9] = {
8, 23, 35, 47, 55, 61, 65, 69, 71 };

const int gamgi_phys_symmetry_driver_202 [10] = {
9, 23, 35, 47, 55, 61, 67, 69, 70, 71 };

const int gamgi_phys_symmetry_driver_203 [8] = {
7, 23, 35, 43, 47, 51, 53, 55 };

const int gamgi_phys_symmetry_driver_204 [9] = {
8, 23, 35, 43, 49, 55, 59, 62, 63 };

const int gamgi_phys_symmetry_driver_205 [5] = {
4, 23, 31, 35, 39 };

const int gamgi_phys_symmetry_driver_206 [6] = {
5, 23, 35, 43, 47, 51 };

const int gamgi_phys_symmetry_driver_207 [12] = {
11, 23, 35, 47, 59, 67, 73, 79, 82, 85, 86, 87 };

const int gamgi_phys_symmetry_driver_208 [14] = {
13, 23, 35, 47, 59, 71, 83, 91, 97, 103, 109, 113, 117, 119 };

const int gamgi_phys_symmetry_driver_209 [11] = {
10, 23, 35, 47, 59, 67, 73, 79, 81, 82, 83 };

const int gamgi_phys_symmetry_driver_210 [9] = {
8, 23, 35, 47, 55, 59, 63, 65, 67 };

const int gamgi_phys_symmetry_driver_211 [11] = {
10, 23, 35, 47, 59, 67, 73, 79, 83, 86, 87 };

const int gamgi_phys_symmetry_driver_212 [6] = {
5, 23, 35, 43, 47, 51 };

const int gamgi_phys_symmetry_driver_213 [6] = {
5, 23, 35, 43, 47, 51 };

const int gamgi_phys_symmetry_driver_214 [10] = {
9, 23, 35, 47, 59, 67, 73, 79, 83, 87 };

const int gamgi_phys_symmetry_driver_215 [11] = {
10, 23, 35, 47, 53, 59, 63, 66, 69, 70, 71 };

const int gamgi_phys_symmetry_driver_216 [10] = {
9, 23, 35, 41, 47, 51, 52, 53, 54, 55 };

const int gamgi_phys_symmetry_driver_217 [9] = {
8, 23, 35, 47, 53, 59, 63, 66, 67 };

const int gamgi_phys_symmetry_driver_218 [10] = {
9, 23, 35, 47, 59, 67, 73, 79, 85, 87 };

const int gamgi_phys_symmetry_driver_219 [9] = {
8, 23, 35, 47, 55, 61, 67, 69, 71 };

const int gamgi_phys_symmetry_driver_220 [6] = {
5, 23, 35, 43, 49, 55 };

const int gamgi_phys_symmetry_driver_221 [15] = {
14, 47, 71, 95, 119, 131, 143, 155, 163, 169, 175, 178, 181, 182, 183 };

const int gamgi_phys_symmetry_driver_222 [10] = {
9, 47, 71, 95, 111, 123, 135, 143, 149, 151 };

const int gamgi_phys_symmetry_driver_223 [13] = {
12, 47, 71, 95, 111, 123, 135, 147, 155, 161, 167, 173, 175 };

const int gamgi_phys_symmetry_driver_224 [13] = {
12, 47, 71, 95, 119, 143, 155, 167, 175, 181, 185, 189, 191 };

const int gamgi_phys_symmetry_driver_225 [13] = {
12, 47, 71, 95, 107, 119, 131, 139, 145, 151, 153, 154, 155 };

const int gamgi_phys_symmetry_driver_226 [11] = {
10, 47, 71, 95, 111, 123, 135, 141, 147, 149, 151 };

const int gamgi_phys_symmetry_driver_227 [10] = {
9, 47, 71, 95, 107, 115, 119, 123, 125, 127 };

const int gamgi_phys_symmetry_driver_228 [9] = {
8, 47, 71, 95, 111, 123, 131, 139, 143 };

const int gamgi_phys_symmetry_driver_229 [13] = {
12, 47, 71, 95, 119, 131, 143, 151, 157, 163, 167, 170, 171 };

const int gamgi_phys_symmetry_driver_230 [9] = {
8, 47, 71, 95, 111, 123, 135, 143, 151 };
