static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright (c) 2010, 2011 Mukund Sivaraman <muks@banu.com>                  \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_file_path (path, _(\"File\"), \"\")                                  \n"
"  description (_(\"Path of file to load\"))                                   \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_SOURCE                                                        \n"
"#define GEGL_OP_C_SOURCE jp2-load.c                                           \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <stdio.h>                                                            \n"
"#include <jasper/jasper.h>                                                    \n"
"                                                                              \n"
"static gboolean                                                               \n"
"query_jp2 (const gchar   *path,                                               \n"
"           gint          *width,                                              \n"
"           gint          *height,                                             \n"
"           gint          *depth,                                              \n"
"           jas_image_t  **jas_image)                                          \n"
"{                                                                             \n"
"  gboolean ret;                                                               \n"
"  jas_stream_t *in;                                                           \n"
"  int image_fmt;                                                              \n"
"  jas_image_t *image;                                                         \n"
"  jas_cmprof_t *output_profile;                                               \n"
"  jas_image_t *cimage;                                                        \n"
"  int numcmpts;                                                               \n"
"  int i;                                                                      \n"
"  gboolean b;                                                                 \n"
"                                                                              \n"
"  in = NULL;                                                                  \n"
"  cimage = image = NULL;                                                      \n"
"  output_profile = NULL;                                                      \n"
"  ret = FALSE;                                                                \n"
"                                                                              \n"
"  do                                                                          \n"
"    {                                                                         \n"
"      in = jas_stream_fopen (path, \"rb\");                                   \n"
"      if (!in)                                                                \n"
"        {                                                                     \n"
"          g_warning (\"Unable to open image file '%s'\", path);               \n"
"          break;                                                              \n"
"        }                                                                     \n"
"                                                                              \n"
"      image_fmt = jas_image_getfmt (in);                                      \n"
"      if (image_fmt < 0)                                                      \n"
"        {                                                                     \n"
"          g_warning (_(\"Unknown JPEG 2000 image format in '%s'\"), path);    \n"
"          break;                                                              \n"
"        }                                                                     \n"
"                                                                              \n"
"      image = jas_image_decode (in, image_fmt, NULL);                         \n"
"      if (!image)                                                             \n"
"        {                                                                     \n"
"          g_warning (_(\"Unable to open JPEG 2000 image in '%s'\"), path);    \n"
"          break;                                                              \n"
"        }                                                                     \n"
"                                                                              \n"
"      output_profile = jas_cmprof_createfromclrspc (JAS_CLRSPC_SRGB);         \n"
"      if (!output_profile)                                                    \n"
"        {                                                                     \n"
"          g_warning (_(\"Unable to create output color profile for '%s'\"), path);\n"
"          break;                                                              \n"
"        }                                                                     \n"
"                                                                              \n"
"      cimage = jas_image_chclrspc (image, output_profile,                     \n"
"                                   JAS_CMXFORM_INTENT_PER);                   \n"
"      if (!cimage)                                                            \n"
"        {                                                                     \n"
"          g_warning (_(\"Unable to convert image to sRGB color space \"       \n"
"                       \"when processing '%s'\"), path);                      \n"
"          break;                                                              \n"
"        }                                                                     \n"
"                                                                              \n"
"      numcmpts = jas_image_numcmpts (cimage);                                 \n"
"      if (numcmpts != 3)                                                      \n"
"        {                                                                     \n"
"          g_warning (_(\"Unsupported non-RGB JPEG 2000 file with \"           \n"
"                       \"%d components in '%s'\"), numcmpts, path);           \n"
"          break;                                                              \n"
"        }                                                                     \n"
"                                                                              \n"
"      *width = jas_image_cmptwidth (cimage, 0);                               \n"
"      *height = jas_image_cmptheight (cimage, 0);                             \n"
"      *depth = jas_image_cmptprec (cimage, 0);                                \n"
"                                                                              \n"
"      if ((*depth != 8) && (*depth != 16))                                    \n"
"        {                                                                     \n"
"          g_warning (_(\"Unsupported JPEG 2000 file with depth %d in '%s'\"), \n"
"                     *depth, path);                                           \n"
"          break;                                                              \n"
"        }                                                                     \n"
"                                                                              \n"
"      b = FALSE;                                                              \n"
"                                                                              \n"
"      for (i = 1; i < 3; i++)                                                 \n"
"        {                                                                     \n"
"          if ((jas_image_cmptprec (cimage, i) != *depth) ||                   \n"
"              (jas_image_cmptwidth (cimage, i) != *width) ||                  \n"
"              (jas_image_cmptheight (cimage, i) != *height))                  \n"
"            {                                                                 \n"
"              g_warning (_(\"Components of input image '%s' don't match\"),   \n"
"                         path);                                               \n"
"              b = TRUE;                                                       \n"
"              break;                                                          \n"
"            }                                                                 \n"
"        }                                                                     \n"
"                                                                              \n"
"      if (b)                                                                  \n"
"        break;                                                                \n"
"                                                                              \n"
"      ret = TRUE;                                                             \n"
"    }                                                                         \n"
"  while (FALSE); /* structured goto */                                        \n"
"                                                                              \n"
"  if (jas_image)                                                              \n"
"    *jas_image = cimage;                                                      \n"
"  else if (cimage)                                                            \n"
"    jas_image_destroy (cimage);                                               \n"
"                                                                              \n"
"  if (image)                                                                  \n"
"    jas_image_destroy (image);                                                \n"
"                                                                              \n"
"  if (output_profile)                                                         \n"
"    jas_cmprof_destroy (output_profile);                                      \n"
"                                                                              \n"
"  if (in)                                                                     \n"
"    jas_stream_close (in);                                                    \n"
"                                                                              \n"
"  return ret;                                                                 \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  static gboolean initialized = FALSE;                                        \n"
"                                                                              \n"
"  if (!initialized)                                                           \n"
"    {                                                                         \n"
"      jas_init ();                                                            \n"
"      initialized = TRUE;                                                     \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties   *o = GEGL_PROPERTIES (operation);                          \n"
"  GeglRectangle rect = {0,0,0,0};                                             \n"
"  jas_image_t *image;                                                         \n"
"  gint width, height, depth;                                                  \n"
"  guchar *data_b;                                                             \n"
"  gushort *data_s;                                                            \n"
"  gboolean ret;                                                               \n"
"  int components[3];                                                          \n"
"  jas_matrix_t *matrices[3] = {NULL, NULL, NULL};                             \n"
"  gint i;                                                                     \n"
"  gint row;                                                                   \n"
"  gboolean b;                                                                 \n"
"                                                                              \n"
"  image = NULL;                                                               \n"
"  data_b = NULL;                                                              \n"
"  data_s = NULL;                                                              \n"
"                                                                              \n"
"  width = height = depth = 0;                                                 \n"
"                                                                              \n"
"  if (!query_jp2 (o->path, &width, &height, &depth, &image))                  \n"
"    return FALSE;                                                             \n"
"                                                                              \n"
"  ret = FALSE;                                                                \n"
"  b = FALSE;                                                                  \n"
"                                                                              \n"
"  do                                                                          \n"
"    {                                                                         \n"
"      components[0] = jas_image_getcmptbytype                                 \n"
"        (image, JAS_IMAGE_CT_COLOR(JAS_IMAGE_CT_RGB_R));                      \n"
"      components[1] = jas_image_getcmptbytype                                 \n"
"        (image, JAS_IMAGE_CT_COLOR(JAS_IMAGE_CT_RGB_G));                      \n"
"      components[2] = jas_image_getcmptbytype                                 \n"
"        (image, JAS_IMAGE_CT_COLOR(JAS_IMAGE_CT_RGB_B));                      \n"
"                                                                              \n"
"      if ((components[0] < 0) || (components[1] < 0) || (components[2] < 0))  \n"
"        {                                                                     \n"
"          g_warning (_(\"One or more of R, G, B components are missing \"     \n"
"                       \"from '%s'\"), o->path);                              \n"
"          break;                                                              \n"
"        }                                                                     \n"
"                                                                              \n"
"      if (jas_image_cmptsgnd (image, components[0]) ||                        \n"
"          jas_image_cmptsgnd (image, components[1]) ||                        \n"
"          jas_image_cmptsgnd (image, components[2]))                          \n"
"        {                                                                     \n"
"          g_warning (_(\"One or more of R, G, B components have signed \"     \n"
"                       \"data in '%s'\"), o->path);                           \n"
"          break;                                                              \n"
"        }                                                                     \n"
"                                                                              \n"
"      for (i = 0; i < 3; i++)                                                 \n"
"        matrices[i] = jas_matrix_create(1, width);                            \n"
"                                                                              \n"
"      switch (depth)                                                          \n"
"        {                                                                     \n"
"        case 16:                                                              \n"
"          data_s = (gushort *) g_malloc (width * 3 * sizeof (gushort));       \n"
"          break;                                                              \n"
"                                                                              \n"
"        case 8:                                                               \n"
"          data_b = (guchar *) g_malloc (width * 3 * sizeof (guchar));         \n"
"          break;                                                              \n"
"                                                                              \n"
"        default:                                                              \n"
"          g_warning (\"%s: Programmer stupidity error\", G_STRLOC);           \n"
"          return FALSE;                                                       \n"
"        }                                                                     \n"
"                                                                              \n"
"      for (row = 0; row < height; row++)                                      \n"
"        {                                                                     \n"
"          gint plane, col;                                                    \n"
"          jas_seqent_t *jrow[3] = {NULL, NULL, NULL};                         \n"
"                                                                              \n"
"          for (plane = 0; plane < 3; plane++)                                 \n"
"            {                                                                 \n"
"              int r = jas_image_readcmpt (image, components[plane], 0, row,   \n"
"                                          width, 1, matrices[plane]);         \n"
"              if (r)                                                          \n"
"                {                                                             \n"
"                  g_warning (_(\"Error reading row %d component %d from '%s'\"),\n"
"                             row, plane, o->path);                            \n"
"                  b = TRUE;                                                   \n"
"                  break;                                                      \n"
"                }                                                             \n"
"            }                                                                 \n"
"                                                                              \n"
"          if (b)                                                              \n"
"            break;                                                            \n"
"                                                                              \n"
"          for (plane = 0; plane < 3; plane++)                                 \n"
"            jrow[plane] = jas_matrix_getref (matrices[plane], 0, 0);          \n"
"                                                                              \n"
"          switch (depth)                                                      \n"
"            {                                                                 \n"
"            case 16:                                                          \n"
"              for (col = 0; col < width; col++)                               \n"
"                {                                                             \n"
"                  data_s[col * 3]     = (gushort) jrow[0][col];               \n"
"                  data_s[col * 3 + 1] = (gushort) jrow[1][col];               \n"
"                  data_s[col * 3 + 2] = (gushort) jrow[2][col];               \n"
"                }                                                             \n"
"              break;                                                          \n"
"                                                                              \n"
"            case 8:                                                           \n"
"              for (col = 0; col < width; col++)                               \n"
"                {                                                             \n"
"                  data_b[col * 3]     = (guchar) jrow[0][col];                \n"
"                  data_b[col * 3 + 1] = (guchar) jrow[1][col];                \n"
"                  data_b[col * 3 + 2] = (guchar) jrow[2][col];                \n"
"                }                                                             \n"
"              break;                                                          \n"
"                                                                              \n"
"            default:                                                          \n"
"              g_warning (\"%s: Programmer stupidity error\", G_STRLOC);       \n"
"              b = TRUE;                                                       \n"
"            }                                                                 \n"
"                                                                              \n"
"          if (b)                                                              \n"
"            break;                                                            \n"
"                                                                              \n"
"          rect.x = 0;                                                         \n"
"          rect.y = row;                                                       \n"
"          rect.width = width;                                                 \n"
"          rect.height = 1;                                                    \n"
"                                                                              \n"
"          switch (depth)                                                      \n"
"            {                                                                 \n"
"            case 16:                                                          \n"
"              gegl_buffer_set (output, &rect, 0, babl_format (\"R'G'B' u16\"),\n"
"                               data_s, GEGL_AUTO_ROWSTRIDE);                  \n"
"              break;                                                          \n"
"                                                                              \n"
"            case 8:                                                           \n"
"              gegl_buffer_set (output, &rect, 0, babl_format (\"R'G'B' u8\"), \n"
"                               data_b, GEGL_AUTO_ROWSTRIDE);                  \n"
"	      break;                                                                 \n"
"                                                                              \n"
"            default:                                                          \n"
"              g_warning (\"%s: Programmer stupidity error\", G_STRLOC);       \n"
"              b = TRUE;                                                       \n"
"            }                                                                 \n"
"        }                                                                     \n"
"                                                                              \n"
"      if (b)                                                                  \n"
"        break;                                                                \n"
"                                                                              \n"
"      ret = TRUE;                                                             \n"
"    }                                                                         \n"
"  while (FALSE); /* structured goto */                                        \n"
"                                                                              \n"
"  for (i = 0; i < 3; i++)                                                     \n"
"    if (matrices[i])                                                          \n"
"      jas_matrix_destroy (matrices[i]);                                       \n"
"                                                                              \n"
"  if (data_b)                                                                 \n"
"    g_free (data_b);                                                          \n"
"                                                                              \n"
"  if (data_s)                                                                 \n"
"    g_free (data_s);                                                          \n"
"                                                                              \n"
"  if (image)                                                                  \n"
"    jas_image_destroy (image);                                                \n"
"                                                                              \n"
"  return ret;                                                                 \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation * operation)                                  \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  GeglRectangle result = { 0, 0, 0, 0 };                                      \n"
"  gint width, height, depth;                                                  \n"
"                                                                              \n"
"  width = height = depth = 0;                                                 \n"
"                                                                              \n"
"  if (!query_jp2 (o->path, &width, &height, &depth, NULL))                    \n"
"    return result;                                                            \n"
"                                                                              \n"
"  result.width = width;                                                       \n"
"  result.height = height;                                                     \n"
"                                                                              \n"
"  switch (depth)                                                              \n"
"    {                                                                         \n"
"    case 16:                                                                  \n"
"      gegl_operation_set_format (operation, \"output\",                       \n"
"                                 babl_format (\"R'G'B' u16\"));               \n"
"      break;                                                                  \n"
"                                                                              \n"
"    case 8:                                                                   \n"
"      gegl_operation_set_format (operation, \"output\",                       \n"
"                                 babl_format (\"R'G'B' u8\"));                \n"
"      break;                                                                  \n"
"                                                                              \n"
"    default:                                                                  \n"
"      g_warning (\"%s: Programmer stupidity error\", G_STRLOC);               \n"
"    }                                                                         \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_cached_region (GeglOperation       *operation,                            \n"
"                   const GeglRectangle *roi)                                  \n"
"{                                                                             \n"
"  return get_bounding_box (operation);                                        \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationSourceClass *source_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  source_class    = GEGL_OPERATION_SOURCE_CLASS (klass);                      \n"
"                                                                              \n"
"  source_class->process = process;                                            \n"
"  operation_class->prepare = prepare;                                         \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_class->get_cached_region = get_cached_region;                     \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:jp2-load\",                                       \n"
"    \"title\",       _(\"JPEG 2000 File Loader\"),                            \n"
"    \"categories\",  \"hidden\",                                              \n"
"    \"description\", _(\"JPEG 2000 image loader using jasper.\"),             \n"
"    NULL);                                                                    \n"
"                                                                              \n"
"  gegl_extension_handler_register (\".jp2\", \"gegl:jp2-load\");              \n"
"  gegl_extension_handler_register (\".jpx\", \"gegl:jp2-load\");              \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
