// Code generated by smithy-go-codegen DO NOT EDIT.

package comprehend

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/comprehend/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Gets a list of the events detection jobs that you have submitted.
func (c *Client) ListEventsDetectionJobs(ctx context.Context, params *ListEventsDetectionJobsInput, optFns ...func(*Options)) (*ListEventsDetectionJobsOutput, error) {
	if params == nil {
		params = &ListEventsDetectionJobsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListEventsDetectionJobs", params, optFns, c.addOperationListEventsDetectionJobsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListEventsDetectionJobsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListEventsDetectionJobsInput struct {

	// Filters the jobs that are returned. You can filter jobs on their name, status,
	// or the date and time that they were submitted. You can only set one filter at a
	// time.
	Filter *types.EventsDetectionJobFilter

	// The maximum number of results to return in each page.
	MaxResults *int32

	// Identifies the next page of results to return.
	NextToken *string

	noSmithyDocumentSerde
}

type ListEventsDetectionJobsOutput struct {

	// A list containing the properties of each job that is returned.
	EventsDetectionJobPropertiesList []types.EventsDetectionJobProperties

	// Identifies the next page of results to return.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListEventsDetectionJobsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListEventsDetectionJobs{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListEventsDetectionJobs{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListEventsDetectionJobs"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListEventsDetectionJobs(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListEventsDetectionJobsAPIClient is a client that implements the
// ListEventsDetectionJobs operation.
type ListEventsDetectionJobsAPIClient interface {
	ListEventsDetectionJobs(context.Context, *ListEventsDetectionJobsInput, ...func(*Options)) (*ListEventsDetectionJobsOutput, error)
}

var _ ListEventsDetectionJobsAPIClient = (*Client)(nil)

// ListEventsDetectionJobsPaginatorOptions is the paginator options for
// ListEventsDetectionJobs
type ListEventsDetectionJobsPaginatorOptions struct {
	// The maximum number of results to return in each page.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListEventsDetectionJobsPaginator is a paginator for ListEventsDetectionJobs
type ListEventsDetectionJobsPaginator struct {
	options   ListEventsDetectionJobsPaginatorOptions
	client    ListEventsDetectionJobsAPIClient
	params    *ListEventsDetectionJobsInput
	nextToken *string
	firstPage bool
}

// NewListEventsDetectionJobsPaginator returns a new
// ListEventsDetectionJobsPaginator
func NewListEventsDetectionJobsPaginator(client ListEventsDetectionJobsAPIClient, params *ListEventsDetectionJobsInput, optFns ...func(*ListEventsDetectionJobsPaginatorOptions)) *ListEventsDetectionJobsPaginator {
	if params == nil {
		params = &ListEventsDetectionJobsInput{}
	}

	options := ListEventsDetectionJobsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListEventsDetectionJobsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListEventsDetectionJobsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListEventsDetectionJobs page.
func (p *ListEventsDetectionJobsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListEventsDetectionJobsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListEventsDetectionJobs(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListEventsDetectionJobs(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListEventsDetectionJobs",
	}
}
