package hdinsight

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AsyncOperationState enumerates the values for async operation state.
type AsyncOperationState string

const (
	// AsyncOperationStateFailed ...
	AsyncOperationStateFailed AsyncOperationState = "Failed"
	// AsyncOperationStateInProgress ...
	AsyncOperationStateInProgress AsyncOperationState = "InProgress"
	// AsyncOperationStateSucceeded ...
	AsyncOperationStateSucceeded AsyncOperationState = "Succeeded"
)

// PossibleAsyncOperationStateValues returns an array of possible values for the AsyncOperationState const type.
func PossibleAsyncOperationStateValues() []AsyncOperationState {
	return []AsyncOperationState{AsyncOperationStateFailed, AsyncOperationStateInProgress, AsyncOperationStateSucceeded}
}

// ClusterProvisioningState enumerates the values for cluster provisioning state.
type ClusterProvisioningState string

const (
	// ClusterProvisioningStateCanceled ...
	ClusterProvisioningStateCanceled ClusterProvisioningState = "Canceled"
	// ClusterProvisioningStateDeleting ...
	ClusterProvisioningStateDeleting ClusterProvisioningState = "Deleting"
	// ClusterProvisioningStateFailed ...
	ClusterProvisioningStateFailed ClusterProvisioningState = "Failed"
	// ClusterProvisioningStateInProgress ...
	ClusterProvisioningStateInProgress ClusterProvisioningState = "InProgress"
	// ClusterProvisioningStateSucceeded ...
	ClusterProvisioningStateSucceeded ClusterProvisioningState = "Succeeded"
)

// PossibleClusterProvisioningStateValues returns an array of possible values for the ClusterProvisioningState const type.
func PossibleClusterProvisioningStateValues() []ClusterProvisioningState {
	return []ClusterProvisioningState{ClusterProvisioningStateCanceled, ClusterProvisioningStateDeleting, ClusterProvisioningStateFailed, ClusterProvisioningStateInProgress, ClusterProvisioningStateSucceeded}
}

// CreatedByType enumerates the values for created by type.
type CreatedByType string

const (
	// CreatedByTypeApplication ...
	CreatedByTypeApplication CreatedByType = "Application"
	// CreatedByTypeKey ...
	CreatedByTypeKey CreatedByType = "Key"
	// CreatedByTypeManagedIdentity ...
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	// CreatedByTypeUser ...
	CreatedByTypeUser CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns an array of possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{CreatedByTypeApplication, CreatedByTypeKey, CreatedByTypeManagedIdentity, CreatedByTypeUser}
}

// DaysOfWeek enumerates the values for days of week.
type DaysOfWeek string

const (
	// DaysOfWeekFriday ...
	DaysOfWeekFriday DaysOfWeek = "Friday"
	// DaysOfWeekMonday ...
	DaysOfWeekMonday DaysOfWeek = "Monday"
	// DaysOfWeekSaturday ...
	DaysOfWeekSaturday DaysOfWeek = "Saturday"
	// DaysOfWeekSunday ...
	DaysOfWeekSunday DaysOfWeek = "Sunday"
	// DaysOfWeekThursday ...
	DaysOfWeekThursday DaysOfWeek = "Thursday"
	// DaysOfWeekTuesday ...
	DaysOfWeekTuesday DaysOfWeek = "Tuesday"
	// DaysOfWeekWednesday ...
	DaysOfWeekWednesday DaysOfWeek = "Wednesday"
)

// PossibleDaysOfWeekValues returns an array of possible values for the DaysOfWeek const type.
func PossibleDaysOfWeekValues() []DaysOfWeek {
	return []DaysOfWeek{DaysOfWeekFriday, DaysOfWeekMonday, DaysOfWeekSaturday, DaysOfWeekSunday, DaysOfWeekThursday, DaysOfWeekTuesday, DaysOfWeekWednesday}
}

// DirectoryType enumerates the values for directory type.
type DirectoryType string

const (
	// DirectoryTypeActiveDirectory ...
	DirectoryTypeActiveDirectory DirectoryType = "ActiveDirectory"
)

// PossibleDirectoryTypeValues returns an array of possible values for the DirectoryType const type.
func PossibleDirectoryTypeValues() []DirectoryType {
	return []DirectoryType{DirectoryTypeActiveDirectory}
}

// FilterMode enumerates the values for filter mode.
type FilterMode string

const (
	// FilterModeDefault ...
	FilterModeDefault FilterMode = "Default"
	// FilterModeExclude ...
	FilterModeExclude FilterMode = "Exclude"
	// FilterModeInclude ...
	FilterModeInclude FilterMode = "Include"
	// FilterModeRecommend ...
	FilterModeRecommend FilterMode = "Recommend"
)

// PossibleFilterModeValues returns an array of possible values for the FilterMode const type.
func PossibleFilterModeValues() []FilterMode {
	return []FilterMode{FilterModeDefault, FilterModeExclude, FilterModeInclude, FilterModeRecommend}
}

// JSONWebKeyEncryptionAlgorithm enumerates the values for json web key encryption algorithm.
type JSONWebKeyEncryptionAlgorithm string

const (
	// JSONWebKeyEncryptionAlgorithmRSA15 ...
	JSONWebKeyEncryptionAlgorithmRSA15 JSONWebKeyEncryptionAlgorithm = "RSA1_5"
	// JSONWebKeyEncryptionAlgorithmRSAOAEP ...
	JSONWebKeyEncryptionAlgorithmRSAOAEP JSONWebKeyEncryptionAlgorithm = "RSA-OAEP"
	// JSONWebKeyEncryptionAlgorithmRSAOAEP256 ...
	JSONWebKeyEncryptionAlgorithmRSAOAEP256 JSONWebKeyEncryptionAlgorithm = "RSA-OAEP-256"
)

// PossibleJSONWebKeyEncryptionAlgorithmValues returns an array of possible values for the JSONWebKeyEncryptionAlgorithm const type.
func PossibleJSONWebKeyEncryptionAlgorithmValues() []JSONWebKeyEncryptionAlgorithm {
	return []JSONWebKeyEncryptionAlgorithm{JSONWebKeyEncryptionAlgorithmRSA15, JSONWebKeyEncryptionAlgorithmRSAOAEP, JSONWebKeyEncryptionAlgorithmRSAOAEP256}
}

// OSType enumerates the values for os type.
type OSType string

const (
	// OSTypeLinux ...
	OSTypeLinux OSType = "Linux"
	// OSTypeWindows ...
	OSTypeWindows OSType = "Windows"
)

// PossibleOSTypeValues returns an array of possible values for the OSType const type.
func PossibleOSTypeValues() []OSType {
	return []OSType{OSTypeLinux, OSTypeWindows}
}

// PrivateEndpointConnectionProvisioningState enumerates the values for private endpoint connection
// provisioning state.
type PrivateEndpointConnectionProvisioningState string

const (
	// PrivateEndpointConnectionProvisioningStateCanceled ...
	PrivateEndpointConnectionProvisioningStateCanceled PrivateEndpointConnectionProvisioningState = "Canceled"
	// PrivateEndpointConnectionProvisioningStateDeleting ...
	PrivateEndpointConnectionProvisioningStateDeleting PrivateEndpointConnectionProvisioningState = "Deleting"
	// PrivateEndpointConnectionProvisioningStateFailed ...
	PrivateEndpointConnectionProvisioningStateFailed PrivateEndpointConnectionProvisioningState = "Failed"
	// PrivateEndpointConnectionProvisioningStateInProgress ...
	PrivateEndpointConnectionProvisioningStateInProgress PrivateEndpointConnectionProvisioningState = "InProgress"
	// PrivateEndpointConnectionProvisioningStateSucceeded ...
	PrivateEndpointConnectionProvisioningStateSucceeded PrivateEndpointConnectionProvisioningState = "Succeeded"
	// PrivateEndpointConnectionProvisioningStateUpdating ...
	PrivateEndpointConnectionProvisioningStateUpdating PrivateEndpointConnectionProvisioningState = "Updating"
)

// PossiblePrivateEndpointConnectionProvisioningStateValues returns an array of possible values for the PrivateEndpointConnectionProvisioningState const type.
func PossiblePrivateEndpointConnectionProvisioningStateValues() []PrivateEndpointConnectionProvisioningState {
	return []PrivateEndpointConnectionProvisioningState{PrivateEndpointConnectionProvisioningStateCanceled, PrivateEndpointConnectionProvisioningStateDeleting, PrivateEndpointConnectionProvisioningStateFailed, PrivateEndpointConnectionProvisioningStateInProgress, PrivateEndpointConnectionProvisioningStateSucceeded, PrivateEndpointConnectionProvisioningStateUpdating}
}

// PrivateIPAllocationMethod enumerates the values for private ip allocation method.
type PrivateIPAllocationMethod string

const (
	// PrivateIPAllocationMethodDynamic ...
	PrivateIPAllocationMethodDynamic PrivateIPAllocationMethod = "dynamic"
	// PrivateIPAllocationMethodStatic ...
	PrivateIPAllocationMethodStatic PrivateIPAllocationMethod = "static"
)

// PossiblePrivateIPAllocationMethodValues returns an array of possible values for the PrivateIPAllocationMethod const type.
func PossiblePrivateIPAllocationMethodValues() []PrivateIPAllocationMethod {
	return []PrivateIPAllocationMethod{PrivateIPAllocationMethodDynamic, PrivateIPAllocationMethodStatic}
}

// PrivateLink enumerates the values for private link.
type PrivateLink string

const (
	// PrivateLinkDisabled ...
	PrivateLinkDisabled PrivateLink = "Disabled"
	// PrivateLinkEnabled ...
	PrivateLinkEnabled PrivateLink = "Enabled"
)

// PossiblePrivateLinkValues returns an array of possible values for the PrivateLink const type.
func PossiblePrivateLinkValues() []PrivateLink {
	return []PrivateLink{PrivateLinkDisabled, PrivateLinkEnabled}
}

// PrivateLinkConfigurationProvisioningState enumerates the values for private link configuration provisioning
// state.
type PrivateLinkConfigurationProvisioningState string

const (
	// PrivateLinkConfigurationProvisioningStateCanceled ...
	PrivateLinkConfigurationProvisioningStateCanceled PrivateLinkConfigurationProvisioningState = "Canceled"
	// PrivateLinkConfigurationProvisioningStateDeleting ...
	PrivateLinkConfigurationProvisioningStateDeleting PrivateLinkConfigurationProvisioningState = "Deleting"
	// PrivateLinkConfigurationProvisioningStateFailed ...
	PrivateLinkConfigurationProvisioningStateFailed PrivateLinkConfigurationProvisioningState = "Failed"
	// PrivateLinkConfigurationProvisioningStateInProgress ...
	PrivateLinkConfigurationProvisioningStateInProgress PrivateLinkConfigurationProvisioningState = "InProgress"
	// PrivateLinkConfigurationProvisioningStateSucceeded ...
	PrivateLinkConfigurationProvisioningStateSucceeded PrivateLinkConfigurationProvisioningState = "Succeeded"
)

// PossiblePrivateLinkConfigurationProvisioningStateValues returns an array of possible values for the PrivateLinkConfigurationProvisioningState const type.
func PossiblePrivateLinkConfigurationProvisioningStateValues() []PrivateLinkConfigurationProvisioningState {
	return []PrivateLinkConfigurationProvisioningState{PrivateLinkConfigurationProvisioningStateCanceled, PrivateLinkConfigurationProvisioningStateDeleting, PrivateLinkConfigurationProvisioningStateFailed, PrivateLinkConfigurationProvisioningStateInProgress, PrivateLinkConfigurationProvisioningStateSucceeded}
}

// PrivateLinkServiceConnectionStatus enumerates the values for private link service connection status.
type PrivateLinkServiceConnectionStatus string

const (
	// PrivateLinkServiceConnectionStatusApproved ...
	PrivateLinkServiceConnectionStatusApproved PrivateLinkServiceConnectionStatus = "Approved"
	// PrivateLinkServiceConnectionStatusPending ...
	PrivateLinkServiceConnectionStatusPending PrivateLinkServiceConnectionStatus = "Pending"
	// PrivateLinkServiceConnectionStatusRejected ...
	PrivateLinkServiceConnectionStatusRejected PrivateLinkServiceConnectionStatus = "Rejected"
	// PrivateLinkServiceConnectionStatusRemoved ...
	PrivateLinkServiceConnectionStatusRemoved PrivateLinkServiceConnectionStatus = "Removed"
)

// PossiblePrivateLinkServiceConnectionStatusValues returns an array of possible values for the PrivateLinkServiceConnectionStatus const type.
func PossiblePrivateLinkServiceConnectionStatusValues() []PrivateLinkServiceConnectionStatus {
	return []PrivateLinkServiceConnectionStatus{PrivateLinkServiceConnectionStatusApproved, PrivateLinkServiceConnectionStatusPending, PrivateLinkServiceConnectionStatusRejected, PrivateLinkServiceConnectionStatusRemoved}
}

// ResourceIdentityType enumerates the values for resource identity type.
type ResourceIdentityType string

const (
	// ResourceIdentityTypeNone ...
	ResourceIdentityTypeNone ResourceIdentityType = "None"
	// ResourceIdentityTypeSystemAssigned ...
	ResourceIdentityTypeSystemAssigned ResourceIdentityType = "SystemAssigned"
	// ResourceIdentityTypeSystemAssignedUserAssigned ...
	ResourceIdentityTypeSystemAssignedUserAssigned ResourceIdentityType = "SystemAssigned, UserAssigned"
	// ResourceIdentityTypeUserAssigned ...
	ResourceIdentityTypeUserAssigned ResourceIdentityType = "UserAssigned"
)

// PossibleResourceIdentityTypeValues returns an array of possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{ResourceIdentityTypeNone, ResourceIdentityTypeSystemAssigned, ResourceIdentityTypeSystemAssignedUserAssigned, ResourceIdentityTypeUserAssigned}
}

// ResourceProviderConnection enumerates the values for resource provider connection.
type ResourceProviderConnection string

const (
	// ResourceProviderConnectionInbound ...
	ResourceProviderConnectionInbound ResourceProviderConnection = "Inbound"
	// ResourceProviderConnectionOutbound ...
	ResourceProviderConnectionOutbound ResourceProviderConnection = "Outbound"
)

// PossibleResourceProviderConnectionValues returns an array of possible values for the ResourceProviderConnection const type.
func PossibleResourceProviderConnectionValues() []ResourceProviderConnection {
	return []ResourceProviderConnection{ResourceProviderConnectionInbound, ResourceProviderConnectionOutbound}
}

// Tier enumerates the values for tier.
type Tier string

const (
	// TierPremium ...
	TierPremium Tier = "Premium"
	// TierStandard ...
	TierStandard Tier = "Standard"
)

// PossibleTierValues returns an array of possible values for the Tier const type.
func PossibleTierValues() []Tier {
	return []Tier{TierPremium, TierStandard}
}
