// Code generated by protoc-gen-gogo.
// source: authorizer.proto
// DO NOT EDIT!

package mesosproto

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"

// discarding unused import gogoproto "github.com/gogo/protobuf/gogoproto"

import bytes "bytes"

import strings "strings"
import github_com_gogo_protobuf_proto "github.com/gogo/protobuf/proto"
import sort "sort"
import strconv "strconv"
import reflect "reflect"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type ACL_Entity_Type int32

const (
	ACL_Entity_SOME ACL_Entity_Type = 0
	ACL_Entity_ANY  ACL_Entity_Type = 1
	ACL_Entity_NONE ACL_Entity_Type = 2
)

var ACL_Entity_Type_name = map[int32]string{
	0: "SOME",
	1: "ANY",
	2: "NONE",
}
var ACL_Entity_Type_value = map[string]int32{
	"SOME": 0,
	"ANY":  1,
	"NONE": 2,
}

func (x ACL_Entity_Type) Enum() *ACL_Entity_Type {
	p := new(ACL_Entity_Type)
	*p = x
	return p
}
func (x ACL_Entity_Type) String() string {
	return proto.EnumName(ACL_Entity_Type_name, int32(x))
}
func (x *ACL_Entity_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ACL_Entity_Type_value, data, "ACL_Entity_Type")
	if err != nil {
		return err
	}
	*x = ACL_Entity_Type(value)
	return nil
}

// *
// ACLs used for local authorization (See authorization.md file in the
// docs).
type ACL struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *ACL) Reset()      { *m = ACL{} }
func (*ACL) ProtoMessage() {}

// Entity is used to describe a subject(s) or an object(s) of an ACL.
// NOTE:
// To allow everyone access to an Entity set its type to 'ANY'.
// To deny access to an Entity set its type to 'NONE'.
type ACL_Entity struct {
	Type             *ACL_Entity_Type `protobuf:"varint,1,opt,name=type,enum=mesosproto.ACL_Entity_Type,def=0" json:"type,omitempty"`
	Values           []string         `protobuf:"bytes,2,rep,name=values" json:"values,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *ACL_Entity) Reset()      { *m = ACL_Entity{} }
func (*ACL_Entity) ProtoMessage() {}

const Default_ACL_Entity_Type ACL_Entity_Type = ACL_Entity_SOME

func (m *ACL_Entity) GetType() ACL_Entity_Type {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return Default_ACL_Entity_Type
}

func (m *ACL_Entity) GetValues() []string {
	if m != nil {
		return m.Values
	}
	return nil
}

// ACLs.
type ACL_RegisterFramework struct {
	// Subjects.
	Principals *ACL_Entity `protobuf:"bytes,1,req,name=principals" json:"principals,omitempty"`
	// Objects.
	Roles            *ACL_Entity `protobuf:"bytes,2,req,name=roles" json:"roles,omitempty"`
	XXX_unrecognized []byte      `json:"-"`
}

func (m *ACL_RegisterFramework) Reset()      { *m = ACL_RegisterFramework{} }
func (*ACL_RegisterFramework) ProtoMessage() {}

func (m *ACL_RegisterFramework) GetPrincipals() *ACL_Entity {
	if m != nil {
		return m.Principals
	}
	return nil
}

func (m *ACL_RegisterFramework) GetRoles() *ACL_Entity {
	if m != nil {
		return m.Roles
	}
	return nil
}

type ACL_RunTask struct {
	// Subjects.
	Principals *ACL_Entity `protobuf:"bytes,1,req,name=principals" json:"principals,omitempty"`
	// Objects.
	Users            *ACL_Entity `protobuf:"bytes,2,req,name=users" json:"users,omitempty"`
	XXX_unrecognized []byte      `json:"-"`
}

func (m *ACL_RunTask) Reset()      { *m = ACL_RunTask{} }
func (*ACL_RunTask) ProtoMessage() {}

func (m *ACL_RunTask) GetPrincipals() *ACL_Entity {
	if m != nil {
		return m.Principals
	}
	return nil
}

func (m *ACL_RunTask) GetUsers() *ACL_Entity {
	if m != nil {
		return m.Users
	}
	return nil
}

// Which principals are authorized to shutdown frameworks of other
// principals.
type ACL_ShutdownFramework struct {
	// Subjects.
	Principals *ACL_Entity `protobuf:"bytes,1,req,name=principals" json:"principals,omitempty"`
	// Objects.
	FrameworkPrincipals *ACL_Entity `protobuf:"bytes,2,req,name=framework_principals" json:"framework_principals,omitempty"`
	XXX_unrecognized    []byte      `json:"-"`
}

func (m *ACL_ShutdownFramework) Reset()      { *m = ACL_ShutdownFramework{} }
func (*ACL_ShutdownFramework) ProtoMessage() {}

func (m *ACL_ShutdownFramework) GetPrincipals() *ACL_Entity {
	if m != nil {
		return m.Principals
	}
	return nil
}

func (m *ACL_ShutdownFramework) GetFrameworkPrincipals() *ACL_Entity {
	if m != nil {
		return m.FrameworkPrincipals
	}
	return nil
}

// *
// Collection of ACL.
//
// Each authorization request is evaluated against the ACLs in the order
// they are defined.
//
// For simplicity, the ACLs for a given action are not aggregated even
// when they have the same subjects or objects. The first ACL that
// matches the request determines whether that request should be
// permitted or not. An ACL matches iff both the subjects
// (e.g., clients, principals) and the objects (e.g., urls, users,
// roles) of the ACL match the request.
//
// If none of the ACLs match the request, the 'permissive' field
// determines whether the request should be permitted or not.
//
// TODO(vinod): Do aggregation of ACLs when possible.
//
type ACLs struct {
	Permissive         *bool                    `protobuf:"varint,1,opt,name=permissive,def=1" json:"permissive,omitempty"`
	RegisterFrameworks []*ACL_RegisterFramework `protobuf:"bytes,2,rep,name=register_frameworks" json:"register_frameworks,omitempty"`
	RunTasks           []*ACL_RunTask           `protobuf:"bytes,3,rep,name=run_tasks" json:"run_tasks,omitempty"`
	ShutdownFrameworks []*ACL_ShutdownFramework `protobuf:"bytes,4,rep,name=shutdown_frameworks" json:"shutdown_frameworks,omitempty"`
	XXX_unrecognized   []byte                   `json:"-"`
}

func (m *ACLs) Reset()      { *m = ACLs{} }
func (*ACLs) ProtoMessage() {}

const Default_ACLs_Permissive bool = true

func (m *ACLs) GetPermissive() bool {
	if m != nil && m.Permissive != nil {
		return *m.Permissive
	}
	return Default_ACLs_Permissive
}

func (m *ACLs) GetRegisterFrameworks() []*ACL_RegisterFramework {
	if m != nil {
		return m.RegisterFrameworks
	}
	return nil
}

func (m *ACLs) GetRunTasks() []*ACL_RunTask {
	if m != nil {
		return m.RunTasks
	}
	return nil
}

func (m *ACLs) GetShutdownFrameworks() []*ACL_ShutdownFramework {
	if m != nil {
		return m.ShutdownFrameworks
	}
	return nil
}

func init() {
	proto.RegisterEnum("mesosproto.ACL_Entity_Type", ACL_Entity_Type_name, ACL_Entity_Type_value)
}
func (this *ACL) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ACL)
	if !ok {
		return fmt.Errorf("that is not of type *ACL")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *ACL but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *ACLbut is not nil && this == nil")
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *ACL) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ACL)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *ACL_Entity) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ACL_Entity)
	if !ok {
		return fmt.Errorf("that is not of type *ACL_Entity")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *ACL_Entity but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *ACL_Entitybut is not nil && this == nil")
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return fmt.Errorf("Type this(%v) Not Equal that(%v)", *this.Type, *that1.Type)
		}
	} else if this.Type != nil {
		return fmt.Errorf("this.Type == nil && that.Type != nil")
	} else if that1.Type != nil {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if len(this.Values) != len(that1.Values) {
		return fmt.Errorf("Values this(%v) Not Equal that(%v)", len(this.Values), len(that1.Values))
	}
	for i := range this.Values {
		if this.Values[i] != that1.Values[i] {
			return fmt.Errorf("Values this[%v](%v) Not Equal that[%v](%v)", i, this.Values[i], i, that1.Values[i])
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *ACL_Entity) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ACL_Entity)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return false
		}
	} else if this.Type != nil {
		return false
	} else if that1.Type != nil {
		return false
	}
	if len(this.Values) != len(that1.Values) {
		return false
	}
	for i := range this.Values {
		if this.Values[i] != that1.Values[i] {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *ACL_RegisterFramework) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ACL_RegisterFramework)
	if !ok {
		return fmt.Errorf("that is not of type *ACL_RegisterFramework")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *ACL_RegisterFramework but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *ACL_RegisterFrameworkbut is not nil && this == nil")
	}
	if !this.Principals.Equal(that1.Principals) {
		return fmt.Errorf("Principals this(%v) Not Equal that(%v)", this.Principals, that1.Principals)
	}
	if !this.Roles.Equal(that1.Roles) {
		return fmt.Errorf("Roles this(%v) Not Equal that(%v)", this.Roles, that1.Roles)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *ACL_RegisterFramework) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ACL_RegisterFramework)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Principals.Equal(that1.Principals) {
		return false
	}
	if !this.Roles.Equal(that1.Roles) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *ACL_RunTask) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ACL_RunTask)
	if !ok {
		return fmt.Errorf("that is not of type *ACL_RunTask")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *ACL_RunTask but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *ACL_RunTaskbut is not nil && this == nil")
	}
	if !this.Principals.Equal(that1.Principals) {
		return fmt.Errorf("Principals this(%v) Not Equal that(%v)", this.Principals, that1.Principals)
	}
	if !this.Users.Equal(that1.Users) {
		return fmt.Errorf("Users this(%v) Not Equal that(%v)", this.Users, that1.Users)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *ACL_RunTask) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ACL_RunTask)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Principals.Equal(that1.Principals) {
		return false
	}
	if !this.Users.Equal(that1.Users) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *ACL_ShutdownFramework) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ACL_ShutdownFramework)
	if !ok {
		return fmt.Errorf("that is not of type *ACL_ShutdownFramework")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *ACL_ShutdownFramework but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *ACL_ShutdownFrameworkbut is not nil && this == nil")
	}
	if !this.Principals.Equal(that1.Principals) {
		return fmt.Errorf("Principals this(%v) Not Equal that(%v)", this.Principals, that1.Principals)
	}
	if !this.FrameworkPrincipals.Equal(that1.FrameworkPrincipals) {
		return fmt.Errorf("FrameworkPrincipals this(%v) Not Equal that(%v)", this.FrameworkPrincipals, that1.FrameworkPrincipals)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *ACL_ShutdownFramework) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ACL_ShutdownFramework)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Principals.Equal(that1.Principals) {
		return false
	}
	if !this.FrameworkPrincipals.Equal(that1.FrameworkPrincipals) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *ACLs) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ACLs)
	if !ok {
		return fmt.Errorf("that is not of type *ACLs")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *ACLs but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *ACLsbut is not nil && this == nil")
	}
	if this.Permissive != nil && that1.Permissive != nil {
		if *this.Permissive != *that1.Permissive {
			return fmt.Errorf("Permissive this(%v) Not Equal that(%v)", *this.Permissive, *that1.Permissive)
		}
	} else if this.Permissive != nil {
		return fmt.Errorf("this.Permissive == nil && that.Permissive != nil")
	} else if that1.Permissive != nil {
		return fmt.Errorf("Permissive this(%v) Not Equal that(%v)", this.Permissive, that1.Permissive)
	}
	if len(this.RegisterFrameworks) != len(that1.RegisterFrameworks) {
		return fmt.Errorf("RegisterFrameworks this(%v) Not Equal that(%v)", len(this.RegisterFrameworks), len(that1.RegisterFrameworks))
	}
	for i := range this.RegisterFrameworks {
		if !this.RegisterFrameworks[i].Equal(that1.RegisterFrameworks[i]) {
			return fmt.Errorf("RegisterFrameworks this[%v](%v) Not Equal that[%v](%v)", i, this.RegisterFrameworks[i], i, that1.RegisterFrameworks[i])
		}
	}
	if len(this.RunTasks) != len(that1.RunTasks) {
		return fmt.Errorf("RunTasks this(%v) Not Equal that(%v)", len(this.RunTasks), len(that1.RunTasks))
	}
	for i := range this.RunTasks {
		if !this.RunTasks[i].Equal(that1.RunTasks[i]) {
			return fmt.Errorf("RunTasks this[%v](%v) Not Equal that[%v](%v)", i, this.RunTasks[i], i, that1.RunTasks[i])
		}
	}
	if len(this.ShutdownFrameworks) != len(that1.ShutdownFrameworks) {
		return fmt.Errorf("ShutdownFrameworks this(%v) Not Equal that(%v)", len(this.ShutdownFrameworks), len(that1.ShutdownFrameworks))
	}
	for i := range this.ShutdownFrameworks {
		if !this.ShutdownFrameworks[i].Equal(that1.ShutdownFrameworks[i]) {
			return fmt.Errorf("ShutdownFrameworks this[%v](%v) Not Equal that[%v](%v)", i, this.ShutdownFrameworks[i], i, that1.ShutdownFrameworks[i])
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *ACLs) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ACLs)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Permissive != nil && that1.Permissive != nil {
		if *this.Permissive != *that1.Permissive {
			return false
		}
	} else if this.Permissive != nil {
		return false
	} else if that1.Permissive != nil {
		return false
	}
	if len(this.RegisterFrameworks) != len(that1.RegisterFrameworks) {
		return false
	}
	for i := range this.RegisterFrameworks {
		if !this.RegisterFrameworks[i].Equal(that1.RegisterFrameworks[i]) {
			return false
		}
	}
	if len(this.RunTasks) != len(that1.RunTasks) {
		return false
	}
	for i := range this.RunTasks {
		if !this.RunTasks[i].Equal(that1.RunTasks[i]) {
			return false
		}
	}
	if len(this.ShutdownFrameworks) != len(that1.ShutdownFrameworks) {
		return false
	}
	for i := range this.ShutdownFrameworks {
		if !this.ShutdownFrameworks[i].Equal(that1.ShutdownFrameworks[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *ACL) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&mesosproto.ACL{")
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ACL_Entity) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesosproto.ACL_Entity{")
	if this.Type != nil {
		s = append(s, "Type: "+valueToGoStringAuthorizer(this.Type, "mesosproto.ACL_Entity_Type")+",\n")
	}
	if this.Values != nil {
		s = append(s, "Values: "+fmt.Sprintf("%#v", this.Values)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ACL_RegisterFramework) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesosproto.ACL_RegisterFramework{")
	if this.Principals != nil {
		s = append(s, "Principals: "+fmt.Sprintf("%#v", this.Principals)+",\n")
	}
	if this.Roles != nil {
		s = append(s, "Roles: "+fmt.Sprintf("%#v", this.Roles)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ACL_RunTask) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesosproto.ACL_RunTask{")
	if this.Principals != nil {
		s = append(s, "Principals: "+fmt.Sprintf("%#v", this.Principals)+",\n")
	}
	if this.Users != nil {
		s = append(s, "Users: "+fmt.Sprintf("%#v", this.Users)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ACL_ShutdownFramework) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesosproto.ACL_ShutdownFramework{")
	if this.Principals != nil {
		s = append(s, "Principals: "+fmt.Sprintf("%#v", this.Principals)+",\n")
	}
	if this.FrameworkPrincipals != nil {
		s = append(s, "FrameworkPrincipals: "+fmt.Sprintf("%#v", this.FrameworkPrincipals)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ACLs) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&mesosproto.ACLs{")
	if this.Permissive != nil {
		s = append(s, "Permissive: "+valueToGoStringAuthorizer(this.Permissive, "bool")+",\n")
	}
	if this.RegisterFrameworks != nil {
		s = append(s, "RegisterFrameworks: "+fmt.Sprintf("%#v", this.RegisterFrameworks)+",\n")
	}
	if this.RunTasks != nil {
		s = append(s, "RunTasks: "+fmt.Sprintf("%#v", this.RunTasks)+",\n")
	}
	if this.ShutdownFrameworks != nil {
		s = append(s, "ShutdownFrameworks: "+fmt.Sprintf("%#v", this.ShutdownFrameworks)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringAuthorizer(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func extensionToGoStringAuthorizer(e map[int32]github_com_gogo_protobuf_proto.Extension) string {
	if e == nil {
		return "nil"
	}
	s := "map[int32]proto.Extension{"
	keys := make([]int, 0, len(e))
	for k := range e {
		keys = append(keys, int(k))
	}
	sort.Ints(keys)
	ss := []string{}
	for _, k := range keys {
		ss = append(ss, strconv.Itoa(k)+": "+e[int32(k)].GoString())
	}
	s += strings.Join(ss, ",") + "}"
	return s
}
func (m *ACL) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ACL) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ACL_Entity) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ACL_Entity) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Type != nil {
		data[i] = 0x8
		i++
		i = encodeVarintAuthorizer(data, i, uint64(*m.Type))
	}
	if len(m.Values) > 0 {
		for _, s := range m.Values {
			data[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				data[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			data[i] = uint8(l)
			i++
			i += copy(data[i:], s)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ACL_RegisterFramework) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ACL_RegisterFramework) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Principals == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("principals")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintAuthorizer(data, i, uint64(m.Principals.Size()))
		n1, err := m.Principals.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.Roles == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("roles")
	} else {
		data[i] = 0x12
		i++
		i = encodeVarintAuthorizer(data, i, uint64(m.Roles.Size()))
		n2, err := m.Roles.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ACL_RunTask) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ACL_RunTask) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Principals == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("principals")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintAuthorizer(data, i, uint64(m.Principals.Size()))
		n3, err := m.Principals.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.Users == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("users")
	} else {
		data[i] = 0x12
		i++
		i = encodeVarintAuthorizer(data, i, uint64(m.Users.Size()))
		n4, err := m.Users.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ACL_ShutdownFramework) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ACL_ShutdownFramework) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Principals == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("principals")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintAuthorizer(data, i, uint64(m.Principals.Size()))
		n5, err := m.Principals.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.FrameworkPrincipals == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("framework_principals")
	} else {
		data[i] = 0x12
		i++
		i = encodeVarintAuthorizer(data, i, uint64(m.FrameworkPrincipals.Size()))
		n6, err := m.FrameworkPrincipals.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ACLs) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ACLs) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Permissive != nil {
		data[i] = 0x8
		i++
		if *m.Permissive {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if len(m.RegisterFrameworks) > 0 {
		for _, msg := range m.RegisterFrameworks {
			data[i] = 0x12
			i++
			i = encodeVarintAuthorizer(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.RunTasks) > 0 {
		for _, msg := range m.RunTasks {
			data[i] = 0x1a
			i++
			i = encodeVarintAuthorizer(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.ShutdownFrameworks) > 0 {
		for _, msg := range m.ShutdownFrameworks {
			data[i] = 0x22
			i++
			i = encodeVarintAuthorizer(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeFixed64Authorizer(data []byte, offset int, v uint64) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	data[offset+4] = uint8(v >> 32)
	data[offset+5] = uint8(v >> 40)
	data[offset+6] = uint8(v >> 48)
	data[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Authorizer(data []byte, offset int, v uint32) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintAuthorizer(data []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		data[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	data[offset] = uint8(v)
	return offset + 1
}
func NewPopulatedACL(r randyAuthorizer, easy bool) *ACL {
	this := &ACL{}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedAuthorizer(r, 1)
	}
	return this
}

func NewPopulatedACL_Entity(r randyAuthorizer, easy bool) *ACL_Entity {
	this := &ACL_Entity{}
	if r.Intn(10) != 0 {
		v1 := ACL_Entity_Type([]int32{0, 1, 2}[r.Intn(3)])
		this.Type = &v1
	}
	if r.Intn(10) != 0 {
		v2 := r.Intn(10)
		this.Values = make([]string, v2)
		for i := 0; i < v2; i++ {
			this.Values[i] = randStringAuthorizer(r)
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedAuthorizer(r, 3)
	}
	return this
}

func NewPopulatedACL_RegisterFramework(r randyAuthorizer, easy bool) *ACL_RegisterFramework {
	this := &ACL_RegisterFramework{}
	this.Principals = NewPopulatedACL_Entity(r, easy)
	this.Roles = NewPopulatedACL_Entity(r, easy)
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedAuthorizer(r, 3)
	}
	return this
}

func NewPopulatedACL_RunTask(r randyAuthorizer, easy bool) *ACL_RunTask {
	this := &ACL_RunTask{}
	this.Principals = NewPopulatedACL_Entity(r, easy)
	this.Users = NewPopulatedACL_Entity(r, easy)
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedAuthorizer(r, 3)
	}
	return this
}

func NewPopulatedACL_ShutdownFramework(r randyAuthorizer, easy bool) *ACL_ShutdownFramework {
	this := &ACL_ShutdownFramework{}
	this.Principals = NewPopulatedACL_Entity(r, easy)
	this.FrameworkPrincipals = NewPopulatedACL_Entity(r, easy)
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedAuthorizer(r, 3)
	}
	return this
}

func NewPopulatedACLs(r randyAuthorizer, easy bool) *ACLs {
	this := &ACLs{}
	if r.Intn(10) != 0 {
		v3 := bool(bool(r.Intn(2) == 0))
		this.Permissive = &v3
	}
	if r.Intn(10) != 0 {
		v4 := r.Intn(10)
		this.RegisterFrameworks = make([]*ACL_RegisterFramework, v4)
		for i := 0; i < v4; i++ {
			this.RegisterFrameworks[i] = NewPopulatedACL_RegisterFramework(r, easy)
		}
	}
	if r.Intn(10) != 0 {
		v5 := r.Intn(10)
		this.RunTasks = make([]*ACL_RunTask, v5)
		for i := 0; i < v5; i++ {
			this.RunTasks[i] = NewPopulatedACL_RunTask(r, easy)
		}
	}
	if r.Intn(10) != 0 {
		v6 := r.Intn(10)
		this.ShutdownFrameworks = make([]*ACL_ShutdownFramework, v6)
		for i := 0; i < v6; i++ {
			this.ShutdownFrameworks[i] = NewPopulatedACL_ShutdownFramework(r, easy)
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedAuthorizer(r, 5)
	}
	return this
}

type randyAuthorizer interface {
	Float32() float32
	Float64() float64
	Int63() int64
	Int31() int32
	Uint32() uint32
	Intn(n int) int
}

func randUTF8RuneAuthorizer(r randyAuthorizer) rune {
	ru := r.Intn(62)
	if ru < 10 {
		return rune(ru + 48)
	} else if ru < 36 {
		return rune(ru + 55)
	}
	return rune(ru + 61)
}
func randStringAuthorizer(r randyAuthorizer) string {
	v7 := r.Intn(100)
	tmps := make([]rune, v7)
	for i := 0; i < v7; i++ {
		tmps[i] = randUTF8RuneAuthorizer(r)
	}
	return string(tmps)
}
func randUnrecognizedAuthorizer(r randyAuthorizer, maxFieldNumber int) (data []byte) {
	l := r.Intn(5)
	for i := 0; i < l; i++ {
		wire := r.Intn(4)
		if wire == 3 {
			wire = 5
		}
		fieldNumber := maxFieldNumber + r.Intn(100)
		data = randFieldAuthorizer(data, r, fieldNumber, wire)
	}
	return data
}
func randFieldAuthorizer(data []byte, r randyAuthorizer, fieldNumber int, wire int) []byte {
	key := uint32(fieldNumber)<<3 | uint32(wire)
	switch wire {
	case 0:
		data = encodeVarintPopulateAuthorizer(data, uint64(key))
		v8 := r.Int63()
		if r.Intn(2) == 0 {
			v8 *= -1
		}
		data = encodeVarintPopulateAuthorizer(data, uint64(v8))
	case 1:
		data = encodeVarintPopulateAuthorizer(data, uint64(key))
		data = append(data, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	case 2:
		data = encodeVarintPopulateAuthorizer(data, uint64(key))
		ll := r.Intn(100)
		data = encodeVarintPopulateAuthorizer(data, uint64(ll))
		for j := 0; j < ll; j++ {
			data = append(data, byte(r.Intn(256)))
		}
	default:
		data = encodeVarintPopulateAuthorizer(data, uint64(key))
		data = append(data, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	}
	return data
}
func encodeVarintPopulateAuthorizer(data []byte, v uint64) []byte {
	for v >= 1<<7 {
		data = append(data, uint8(uint64(v)&0x7f|0x80))
		v >>= 7
	}
	data = append(data, uint8(v))
	return data
}
func (m *ACL) Size() (n int) {
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ACL_Entity) Size() (n int) {
	var l int
	_ = l
	if m.Type != nil {
		n += 1 + sovAuthorizer(uint64(*m.Type))
	}
	if len(m.Values) > 0 {
		for _, s := range m.Values {
			l = len(s)
			n += 1 + l + sovAuthorizer(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ACL_RegisterFramework) Size() (n int) {
	var l int
	_ = l
	if m.Principals != nil {
		l = m.Principals.Size()
		n += 1 + l + sovAuthorizer(uint64(l))
	}
	if m.Roles != nil {
		l = m.Roles.Size()
		n += 1 + l + sovAuthorizer(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ACL_RunTask) Size() (n int) {
	var l int
	_ = l
	if m.Principals != nil {
		l = m.Principals.Size()
		n += 1 + l + sovAuthorizer(uint64(l))
	}
	if m.Users != nil {
		l = m.Users.Size()
		n += 1 + l + sovAuthorizer(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ACL_ShutdownFramework) Size() (n int) {
	var l int
	_ = l
	if m.Principals != nil {
		l = m.Principals.Size()
		n += 1 + l + sovAuthorizer(uint64(l))
	}
	if m.FrameworkPrincipals != nil {
		l = m.FrameworkPrincipals.Size()
		n += 1 + l + sovAuthorizer(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ACLs) Size() (n int) {
	var l int
	_ = l
	if m.Permissive != nil {
		n += 2
	}
	if len(m.RegisterFrameworks) > 0 {
		for _, e := range m.RegisterFrameworks {
			l = e.Size()
			n += 1 + l + sovAuthorizer(uint64(l))
		}
	}
	if len(m.RunTasks) > 0 {
		for _, e := range m.RunTasks {
			l = e.Size()
			n += 1 + l + sovAuthorizer(uint64(l))
		}
	}
	if len(m.ShutdownFrameworks) > 0 {
		for _, e := range m.ShutdownFrameworks {
			l = e.Size()
			n += 1 + l + sovAuthorizer(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovAuthorizer(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozAuthorizer(x uint64) (n int) {
	return sovAuthorizer(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *ACL) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ACL{`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ACL_Entity) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ACL_Entity{`,
		`Type:` + valueToStringAuthorizer(this.Type) + `,`,
		`Values:` + fmt.Sprintf("%v", this.Values) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ACL_RegisterFramework) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ACL_RegisterFramework{`,
		`Principals:` + strings.Replace(fmt.Sprintf("%v", this.Principals), "ACL_Entity", "ACL_Entity", 1) + `,`,
		`Roles:` + strings.Replace(fmt.Sprintf("%v", this.Roles), "ACL_Entity", "ACL_Entity", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ACL_RunTask) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ACL_RunTask{`,
		`Principals:` + strings.Replace(fmt.Sprintf("%v", this.Principals), "ACL_Entity", "ACL_Entity", 1) + `,`,
		`Users:` + strings.Replace(fmt.Sprintf("%v", this.Users), "ACL_Entity", "ACL_Entity", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ACL_ShutdownFramework) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ACL_ShutdownFramework{`,
		`Principals:` + strings.Replace(fmt.Sprintf("%v", this.Principals), "ACL_Entity", "ACL_Entity", 1) + `,`,
		`FrameworkPrincipals:` + strings.Replace(fmt.Sprintf("%v", this.FrameworkPrincipals), "ACL_Entity", "ACL_Entity", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ACLs) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ACLs{`,
		`Permissive:` + valueToStringAuthorizer(this.Permissive) + `,`,
		`RegisterFrameworks:` + strings.Replace(fmt.Sprintf("%v", this.RegisterFrameworks), "ACL_RegisterFramework", "ACL_RegisterFramework", 1) + `,`,
		`RunTasks:` + strings.Replace(fmt.Sprintf("%v", this.RunTasks), "ACL_RunTask", "ACL_RunTask", 1) + `,`,
		`ShutdownFrameworks:` + strings.Replace(fmt.Sprintf("%v", this.ShutdownFrameworks), "ACL_ShutdownFramework", "ACL_ShutdownFramework", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringAuthorizer(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *ACL) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		switch fieldNum {
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			iNdEx -= sizeOfWire
			skippy, err := skipAuthorizer(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAuthorizer
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	return nil
}
func (m *ACL_Entity) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var v ACL_Entity_Type
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (ACL_Entity_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Type = &v
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAuthorizer
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Values = append(m.Values, string(data[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			iNdEx -= sizeOfWire
			skippy, err := skipAuthorizer(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAuthorizer
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	return nil
}
func (m *ACL_RegisterFramework) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Principals", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuthorizer
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Principals == nil {
				m.Principals = &ACL_Entity{}
			}
			if err := m.Principals.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Roles", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuthorizer
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Roles == nil {
				m.Roles = &ACL_Entity{}
			}
			if err := m.Roles.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			iNdEx -= sizeOfWire
			skippy, err := skipAuthorizer(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAuthorizer
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("principals")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("roles")
	}

	return nil
}
func (m *ACL_RunTask) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Principals", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuthorizer
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Principals == nil {
				m.Principals = &ACL_Entity{}
			}
			if err := m.Principals.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Users", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuthorizer
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Users == nil {
				m.Users = &ACL_Entity{}
			}
			if err := m.Users.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			iNdEx -= sizeOfWire
			skippy, err := skipAuthorizer(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAuthorizer
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("principals")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("users")
	}

	return nil
}
func (m *ACL_ShutdownFramework) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Principals", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuthorizer
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Principals == nil {
				m.Principals = &ACL_Entity{}
			}
			if err := m.Principals.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FrameworkPrincipals", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuthorizer
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FrameworkPrincipals == nil {
				m.FrameworkPrincipals = &ACL_Entity{}
			}
			if err := m.FrameworkPrincipals.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			iNdEx -= sizeOfWire
			skippy, err := skipAuthorizer(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAuthorizer
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("principals")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("framework_principals")
	}

	return nil
}
func (m *ACLs) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Permissive", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Permissive = &b
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegisterFrameworks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuthorizer
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RegisterFrameworks = append(m.RegisterFrameworks, &ACL_RegisterFramework{})
			if err := m.RegisterFrameworks[len(m.RegisterFrameworks)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunTasks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuthorizer
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RunTasks = append(m.RunTasks, &ACL_RunTask{})
			if err := m.RunTasks[len(m.RunTasks)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShutdownFrameworks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAuthorizer
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ShutdownFrameworks = append(m.ShutdownFrameworks, &ACL_ShutdownFramework{})
			if err := m.ShutdownFrameworks[len(m.ShutdownFrameworks)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			iNdEx -= sizeOfWire
			skippy, err := skipAuthorizer(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAuthorizer
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	return nil
}
func skipAuthorizer(data []byte) (n int, err error) {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for {
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if data[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthAuthorizer
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := data[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipAuthorizer(data[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthAuthorizer = fmt.Errorf("proto: negative length found during unmarshaling")
)
