use warnings;
use strict;
use IPC::System::Simple qw(system capture);
use Test::More tests => 3;
use Gscan2pdf::Helpers;

BEGIN {
    use Gscan2pdf::Document;
}
use Gtk3 -init;  # on some systems, initialising earlier segfaults

#########################

Gscan2pdf::Translation::set_domain('gscan2pdf');

use Log::Log4perl qw(:easy);
Log::Log4perl->easy_init($ERROR);
my $logger = Log::Log4perl::get_logger;
Gscan2pdf::Document->setup($logger);

# Create test image
system(
    Gscan2pdf::Helpers::get_imagemagick_command(),
    'label:The quick brown fox',
    qw(-alpha Off -depth 1 -colorspace Gray),
    '-family',
    'DejaVu Sans',
    qw(-pointsize 12 -density 300),
    'test.png'
);

my $slist = Gscan2pdf::Document->new;

# dir for temporary files
my $dir = File::Temp->newdir;
$slist->set_dir($dir);

$slist->import_files(
    paths             => ['test.png'],
    finished_callback => sub {
        $slist->save_pdf(
            path              => 'test.pdf',
            list_of_pages     => [ $slist->{data}[0][2]{uuid} ],
            finished_callback => sub {
                $slist->save_pdf(
                    path          => 'test2.pdf',
                    list_of_pages => [ $slist->{data}[0][2]{uuid} ],
                    options       => {
                        downsample       => 1,
                        'downsample dpi' => 150,
                    },
                    finished_callback => sub { Gtk3->main_quit }
                );
            }
        );
    }
);
Gtk3->main;

is( -s 'test.pdf' > -s 'test2.pdf', 1,
    'downsampled PDF smaller than original' );
system(qw(pdfimages test2.pdf x));
my $input = capture( qw(identify -format), '%m %G %g %z-bit %r', 'test.png' );
my ( $in_width, $in_height, $out_width, $out_height );
if ( $input =~ /(\d+)x(\d+)/ ) { ( $in_width, $in_height ) = ( $1, $2 ) }
my $output = capture( qw(identify -format), '%m %G %g %z-bit %r', 'x-000.pbm' );
if ( $output =~ /(\d+)x(\d+)/ ) { ( $out_width, $out_height ) = ( $1, $2 ) }
ok abs( $out_width - $in_width / 2 ) < 1,   'downsampled width correct';
ok abs( $out_height - $in_height / 2 ) < 1, 'downsampled height correct';

#########################

unlink 'test.png', 'test.pdf', 'test2.pdf', 'x-000.pbm';
Gscan2pdf::Document->quit();
