# window.py
#
# Copyright 2024 Christopher Talbot
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.
#
# SPDX-License-Identifier: GPL-3.0-or-later

from gi.repository import Adw
from gi.repository import Gtk
import gettext

import gtk_meshtastic_client.channels_page
import gtk_meshtastic_client.connection_page
import gtk_meshtastic_client.maps_page
import gtk_meshtastic_client.nearby_nodes_page

@Gtk.Template(resource_path='/org/kop316/meshtastic/ui/window.ui')
class GtkMeshtasticClientWindow(Adw.ApplicationWindow):
    __gtype_name__ = 'GtkMeshtasticClientWindow'

    window_toast_overlay = Gtk.Template.Child()
    window_header_bar = Gtk.Template.Child()
    window_stack = Gtk.Template.Child()
    window_bottom_switcher_bar = Gtk.Template.Child()
    channels_page_bin = Gtk.Template.Child()
    nearby_nodes_page_bin = Gtk.Template.Child()
    connection_page_bin = Gtk.Template.Child()
    maps_page_bin = Gtk.Template.Child()

    quit_request = False

    """
    You need to close any active connections if you exit
    If you don't, the interface will continue to be active
    and any stored messages will stay stored on the device
    and will be sent on the stale connection
    """
    @Gtk.Template.Callback()
    def _window_close_request_cb(self, user):
        app = Gtk.Application.get_default()
        app.logger.debug("Closing Window")

        """
        We always want to gracefully disconnect the interface if we are quitting
        this program. If we don't, the interface is in an unknown state and we
        will miss messages while disconnected.
        """
        if hasattr(self.connection_page_bin, 'interface'):
            if app.app_settings.get_quit_if_connected():
                app.logger.debug("Quitting application even with active connection")
                self.connection_page_bin._disconnect_button_clicked_cb(self.connection_page_bin.disconnect_button)
                self.quit_request = True
                return False
            else:
                app.logger.debug("Active Connection, not quitting application")
                return False
        else:
            app = Gtk.Application.get_default()
            app.quit()
            return False

    def __init__(self, project_rdnn_name, **kwargs):
        super().__init__(**kwargs)
        app = Gtk.Application.get_default()
        self.logger = app.logger
        self.set_icon_name(project_rdnn_name)
