/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file XmlBasicNodeAttributes.h
    \brief Definition of XmlBasicNode Attributes class.
    \author Meteorological Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Mon Apr 15 17:55:22 2013
*/
   

#ifndef XmlBasicNodeAttributes_H
#define XmlBasicNodeAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "Colour.h"

namespace magics {

class XmlNode;



class XmlBasicNodeAttributes 
{
public:
//  --  constructor
    XmlBasicNodeAttributes();
    
//  --  destructor
    virtual ~XmlBasicNodeAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const XmlBasicNodeAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

	

public:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream& out) const;
	//  --  members:
	string tag_;
	bool standalone_;
	string standalone_path_;
	string standalone_format_;
	double standalone_width_;
	double standalone_height_;
	DisplayType display_;
	string bottom_;
	string left_;
	string width_;
	string height_;
	string margin_bottom_;
	string margin_left_;
	string margin_right_;
	string margin_top_;
	auto_ptr<Colour> background_;
	string border_bottom_;
	string border_left_;
	string border_right_;
	string border_top_;
	bool border_;
	bool blanking_;
	auto_ptr<Colour> border_colour_;
	LineStyle border_style_;
	int border_thickness_;
	string padding_bottom_;
	string padding_left_;
	string padding_right_;
	string padding_top_;
	auto_ptr<Colour> padding_colour_;

private:
  
	friend ostream& operator<<(ostream& s,const XmlBasicNodeAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
