/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#include "toolpop.h"

#include <QPaintEvent>
#include <QPainterPath>
#include <QPainter>

ToolPop::ToolPop(QWidget* parent) : QLabel (parent)
{
//    this->setAlignment(Qt::AlignCenter);
//    this->setStyleSheet("margin: 0 15");
}

void ToolPop::popupSlot(QPoint point) {
    this->move(point.x() - this->width() / 2 -4,
               point.y() - this->height() - 8);
    this->show();
}

void ToolPop::paintEvent(QPaintEvent *event) {
    QPainter painter(this);
    painter.setRenderHints(QPainter::Antialiasing | QPainter::TextAntialiasing,
                           true);

    painter.setPen(Qt::transparent);
    QPalette pal;
    painter.setBrush(pal.highlight());
    painter.drawRoundedRect(this->rect(), 4, 4);

    QFont font;
    font.setPixelSize(12);
    QFontMetrics fontMetrics(font);
    int labelLen = fontMetrics.width(this->text());
    painter.setPen(QPen(Qt::white));
    painter.setFont(font);
    painter.drawText((this->width() - labelLen) / 2, (this->height() + 10) / 2, this->text());
}


