---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, communication, 
              plusieurs pages par feuille, brochure
---

# Comment composer une brochure ?

## Avec l'extension <ctanpkg:booklet>

L'extension <ctanpkg:booklet>, de Peter Wilson et Will Robertson, permet
d'obtenir avec `pdflatex` et autres versions de TeX générant directement
un document PDF une brochure pliable. 

Dans l'exemple de 8 pages ci-dessous, basé sur une version simplifiée
d'un exemple de la [documentation](texdoc:booklet) de l'extension, observez 
bien les numéros de pages. Vous pourrez alors noter que le document suppose
une impression recto-verso. Ainsi, la page 7 sera alors bien au dos 
de la page 8. De même la première feuille imprimée contient la page 1 
comme la page 8. 

``` 
\documentclass[french,twoside]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)

  \usepackage{lipsum}
  \usepackage[print,largetypeblock]{booklet}
  \setpdftargetpages

\begin{document}
\section{Lipsum, quand tu nous tiens}
\lipsum[1-40]
\end{document}
```

:::{todo} Revoir la suite, pour isoler les solutions datées des solutions 
toujours valables.
:::


## Avec des commandes manuelles et `pstops`

Pour redéfinir un format de page, (par exemple un A4 plié en trois), il faut
utiliser la commande `\setlength`. Il suffit de savoir quelles sont 
les longueurs à préciser, le meilleur moyen pour ce faire est de les visualiser
avec la commande `\layout` (définie par l'extension <ctanpkg:layout>).

Vous pouvez à ce titre observer l'extension `a6size.sty` de Thierry Bouche, 
disponible [ici](/_static/old_extensions/a6size.sty).


Il faut ensuite opérer ce que les imprimeurs appellent une imposition : 
imprimer la page tant à tel endroit de la x-ième feuille de telle sorte qu'il
n'y ait plus qu'à plier la liasse pour obtenir un livre prêt à être relié. 
Cette étape est facile à réaliser soit à l'aide de `dvidvi` 
(mais qui n'autorise pas les rotations, ce qui peut en limiter l'intérêt
pour des formats spéciaux), soit avec `pstops`, disponible 
dans l'extension <ctanpkg:psutils> :

```bash
pstops "2:0L@.7(21cm,0)+1L@.7(21cm,14.85cm)" un.ps deux.ps
```

## Avec des commandes de base et `dvidvi`

L'option `a5paper` de LaTeX permet également de faire cela. Il faut ensuite 
utiliser `dvidvi` et `dvips -t landscape`.


## Avec l'extension [2up](ctanpkg:twoup-gen)

L'extension [2up](ctanpkg:twoup-gen), de Timothy Van Zandt et Herbert Voß, 
permet de générer des documents avec deux pages de texte par feuille de 
papier. Il a l'avantage de ne pas demander des traitements utilisant
des filtres DVI ou Postscript.


## Avec l'extension <ctanpkg:poligraf> 

L'extension <ctanpkg:poligraf> permet d'agir sur la mise en page d'un document
avant impression.


## Avec les programmes `psnup` et `psbook`

`psnup` et `psbook` peuvent également permettre de faire de la composition
mais il vaut alors mieux travailler avec des polices Postscript. Vous pouvez
consutler la question 
"[](/5_fichiers/formats/postscript/manipuler_un_fichier_postscript)"
pour savoir où télécharger ces programmes.

Voici un exemple (J.A. Ferrez) :

```bash
#!/bin/sh
#
# Turn a (clean) PS file into a booklet
#
# input on stdin or file in arg
#
# psbook -- reorder the pages
#           see -s option for _very_ large files
# psnup  -- scale and place two pages onto one
# pstops -- reverse the odd pages for duplex printing
#
# outup on stdout
#
psbook $1 | psnup -2 | pstops "2:0,1U(21cm,29.7cm)
```


## Avec le programme `dvips`

Le résultat est possible également en ne travaillant que sur le fichier
Postscript.

```bash
dvips -h twoup -t landscape fichier.dvi
```


## Avec le programme `dvidrv`

Vous pouvez aussi utiliser `dvidrv`.


## Avec le programme `twoup`

Le programme `twoup` permet aussi de faire cela mais il n'est pas 
dans le domaine public.