/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkGradientMagnitudeRecursiveGaussianImageFilter_h
#define sitkGradientMagnitudeRecursiveGaussianImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class GradientMagnitudeRecursiveGaussianImageFilter
\brief Computes the Magnitude of the Gradient of an image by convolution with the first derivative of a Gaussian.

This filter is implemented using the recursive gaussian filters
\sa itk::simple::GradientMagnitudeRecursiveGaussian for the procedural interface
\sa itk::GradientMagnitudeRecursiveGaussianImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT GradientMagnitudeRecursiveGaussianImageFilter : public ImageFilter {
    public:
      using Self = GradientMagnitudeRecursiveGaussianImageFilter;

      /** Destructor */
      virtual ~GradientMagnitudeRecursiveGaussianImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      GradientMagnitudeRecursiveGaussianImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = BasicPixelIDTypeList;
\

      /**
       * Set/Get Sigma value. Sigma is measured in the units of image spacing.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetSigma ( double Sigma ) { this->m_Sigma = Sigma; return *this; }

      /**
       * Set/Get Sigma value. Sigma is measured in the units of image spacing.
       */
      double GetSigma() const { return this->m_Sigma; }\

      /**
       * Set/Get the normalization factor that will be used for the Gaussian. \sa RecursiveGaussianImageFilter::SetNormalizeAcrossScale
       */
      SITK_RETURN_SELF_TYPE_HEADER SetNormalizeAcrossScale ( bool NormalizeAcrossScale ) { this->m_NormalizeAcrossScale = NormalizeAcrossScale; return *this; }

      /** Set the value of NormalizeAcrossScale to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER NormalizeAcrossScaleOn() { return this->SetNormalizeAcrossScale(true); }
      SITK_RETURN_SELF_TYPE_HEADER NormalizeAcrossScaleOff() { return this->SetNormalizeAcrossScale(false); }

      /**
       * Set/Get the normalization factor that will be used for the Gaussian. \sa RecursiveGaussianImageFilter::SetNormalizeAcrossScale
       */
      bool GetNormalizeAcrossScale() const { return this->m_NormalizeAcrossScale; }

      /** Name of this class */
      std::string GetName() const { return std::string ("GradientMagnitudeRecursiveGaussianImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
#ifndef SWIG
      Image Execute ( Image&& image1 );
#endif
      Image Execute ( const Image& image1 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /*  */
      double  m_Sigma{1.0};

      /*  */
      bool  m_NormalizeAcrossScale{false};


      bool m_InPlace{false};
    };

    /**\
     * \brief Computes the Magnitude of the Gradient of an image by convolution with the first derivative of a Gaussian.
     *
     * This function directly calls the execute method of GradientMagnitudeRecursiveGaussianImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::GradientMagnitudeRecursiveGaussianImageFilter for the object oriented interface
     * @{
     */
#ifndef SWIG
     SITKBasicFilters_EXPORT Image GradientMagnitudeRecursiveGaussian ( Image&& image1, double sigma = 1.0, bool normalizeAcrossScale = false );
#endif
     SITKBasicFilters_EXPORT Image GradientMagnitudeRecursiveGaussian ( const Image& image1, double sigma = 1.0, bool normalizeAcrossScale = false );

     /** @} */
}
#endif
