/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.om.unit;

import org.w3c.dom.DOMException;

public interface CSSUnit {
    public static final short CSS_NUMBER = 0;
    public static final short CSS_OTHER = 1;
    public static final short CSS_PERCENTAGE = 2;
    public static final short CSS_PX = 3;
    public static final short CSS_IN = 4;
    public static final short CSS_PC = 5;
    public static final short CSS_PT = 6;
    public static final short CSS_CM = 7;
    public static final short CSS_MM = 8;
    public static final short CSS_QUARTER_MM = 9;
    public static final short CSS_EM = 20;
    public static final short CSS_EX = 21;
    public static final short CSS_CAP = 22;
    public static final short CSS_CH = 23;
    public static final short CSS_IC = 24;
    public static final short CSS_LH = 25;
    public static final short CSS_REM = 26;
    public static final short CSS_RLH = 27;
    public static final short CSS_REX = 28;
    public static final short CSS_RCH = 29;
    public static final short CSS_RIC = 30;
    public static final short CSS_VB = 40;
    public static final short CSS_VH = 41;
    public static final short CSS_VI = 42;
    public static final short CSS_VMAX = 43;
    public static final short CSS_VMIN = 44;
    public static final short CSS_VW = 45;
    public static final short CSS_DPI = 60;
    public static final short CSS_DPCM = 61;
    public static final short CSS_DPPX = 62;
    public static final short CSS_FR = 70;
    public static final short CSS_DEG = 80;
    public static final short CSS_RAD = 81;
    public static final short CSS_GRAD = 82;
    public static final short CSS_TURN = 83;
    public static final short CSS_S = 90;
    public static final short CSS_MS = 91;
    public static final short CSS_HZ = 100;
    public static final short CSS_KHZ = 101;
    public static final short CSS_INVALID = 255;

    public static boolean isLengthUnitType(short unitType) {
        return unitType > 2 && unitType < 60;
    }

    public static boolean isRelativeLengthUnitType(short unitType) {
        return unitType >= 20 && unitType < 60;
    }

    public static boolean isAngleUnitType(short unitType) {
        return unitType > 79 && unitType < 90;
    }

    public static boolean isTimeUnitType(short unitType) {
        return unitType == 90 || unitType == 91;
    }

    public static boolean isResolutionUnitType(short unitType) {
        return unitType >= 60 && unitType <= 62;
    }

    public static String dimensionUnitString(short unitType) throws DOMException {
        switch (unitType) {
            case 20: {
                return "em";
            }
            case 21: {
                return "ex";
            }
            case 3: {
                return "px";
            }
            case 4: {
                return "in";
            }
            case 7: {
                return "cm";
            }
            case 8: {
                return "mm";
            }
            case 6: {
                return "pt";
            }
            case 5: {
                return "pc";
            }
            case 2: {
                return "%";
            }
            case 80: {
                return "deg";
            }
            case 82: {
                return "grad";
            }
            case 81: {
                return "rad";
            }
            case 91: {
                return "ms";
            }
            case 90: {
                return "s";
            }
            case 100: {
                return "Hz";
            }
            case 101: {
                return "kHz";
            }
            case 22: {
                return "cap";
            }
            case 23: {
                return "ch";
            }
            case 70: {
                return "fr";
            }
            case 24: {
                return "ic";
            }
            case 25: {
                return "lh";
            }
            case 9: {
                return "Q";
            }
            case 26: {
                return "rem";
            }
            case 27: {
                return "rlh";
            }
            case 28: {
                return "rex";
            }
            case 29: {
                return "rch";
            }
            case 30: {
                return "ric";
            }
            case 40: {
                return "vb";
            }
            case 41: {
                return "vh";
            }
            case 42: {
                return "vi";
            }
            case 43: {
                return "vmax";
            }
            case 44: {
                return "vmin";
            }
            case 45: {
                return "vw";
            }
            case 60: {
                return "dpi";
            }
            case 61: {
                return "dpcm";
            }
            case 62: {
                return "dppx";
            }
            case 0: 
            case 1: 
            case 255: {
                return "";
            }
        }
        throw new DOMException(15, "Unknown unit: " + unitType);
    }
}

