/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.fasterxml.aalto.in;

import org.jetbrains.kotlin.com.fasterxml.aalto.in.ByteBasedPName;
import org.jetbrains.kotlin.com.fasterxml.aalto.in.ByteBasedPNameFactory;
import org.jetbrains.kotlin.com.fasterxml.aalto.util.NameTable;

public final class ByteBasedPNameTable
extends NameTable {
    private int mCount;
    private int mMainHashMask;
    private int[] mMainHash;
    private ByteBasedPName[] mMainNames;
    private Bucket[] mCollList;
    private int mCollCount;
    private int mCollEnd;
    private transient boolean mNeedRehash;
    private boolean mMainHashShared;
    private boolean mMainNamesShared;
    private boolean mCollListShared;

    public ByteBasedPNameTable(int hashSize) {
        if (hashSize < 16) {
            hashSize = 16;
        } else if ((hashSize & hashSize - 1) != 0) {
            int curr;
            for (curr = 16; curr < hashSize; curr += curr) {
            }
            hashSize = curr;
        }
        this.mCount = 0;
        this.mMainHashShared = false;
        this.mMainNamesShared = false;
        this.mMainHashMask = hashSize - 1;
        this.mMainHash = new int[hashSize];
        this.mMainNames = new ByteBasedPName[hashSize];
        this.mCollListShared = true;
        this.mCollList = null;
        this.mCollEnd = 0;
        this.mNeedRehash = false;
    }

    ByteBasedPNameTable(ByteBasedPNameTable parent2) {
        this.mCount = parent2.mCount;
        this.mMainHashMask = parent2.mMainHashMask;
        this.mMainHash = parent2.mMainHash;
        this.mMainNames = parent2.mMainNames;
        this.mCollList = parent2.mCollList;
        this.mCollCount = parent2.mCollCount;
        this.mCollEnd = parent2.mCollEnd;
        this.mNeedRehash = false;
        this.mMainHashShared = true;
        this.mMainNamesShared = true;
        this.mCollListShared = true;
    }

    public boolean mergeFromChild(ByteBasedPNameTable child) {
        if (child.mCount <= this.mCount) {
            return false;
        }
        this.mCount = child.mCount;
        this.mMainHashMask = child.mMainHashMask;
        this.mMainHash = child.mMainHash;
        this.mMainNames = child.mMainNames;
        this.mCollList = child.mCollList;
        this.mCollCount = child.mCollCount;
        this.mCollEnd = child.mCollEnd;
        child.markAsShared();
        return true;
    }

    public void markAsShared() {
        this.mMainHashShared = true;
        this.mMainNamesShared = true;
        this.mCollListShared = true;
    }

    public boolean maybeDirty() {
        return !this.mMainHashShared;
    }

    public ByteBasedPName findSymbol(int hash, int firstQuad, int secondQuad) {
        Bucket bucket;
        int ix = hash & this.mMainHashMask;
        int val = this.mMainHash[ix];
        if ((val >> 8 ^ hash) << 8 == 0) {
            ByteBasedPName pname = this.mMainNames[ix];
            if (pname == null) {
                return null;
            }
            if (pname.equals(firstQuad, secondQuad)) {
                return pname;
            }
        } else if (val == 0) {
            return null;
        }
        if ((val &= 0xFF) > 0 && (bucket = this.mCollList[--val]) != null) {
            return bucket.find(hash, firstQuad, secondQuad);
        }
        return null;
    }

    public ByteBasedPName findSymbol(int hash, int[] quads, int qlen) {
        Bucket bucket;
        if (qlen < 3) {
            return this.findSymbol(hash, quads[0], qlen < 2 ? 0 : quads[1]);
        }
        int ix = hash & this.mMainHashMask;
        int val = this.mMainHash[ix];
        if ((val >> 8 ^ hash) << 8 == 0) {
            ByteBasedPName pname = this.mMainNames[ix];
            if (pname == null) {
                return null;
            }
            if (pname.equals(quads, qlen)) {
                return pname;
            }
        } else if (val == 0) {
            return null;
        }
        if ((val &= 0xFF) > 0 && (bucket = this.mCollList[--val]) != null) {
            return bucket.find(hash, quads, qlen);
        }
        return null;
    }

    public ByteBasedPName addSymbol(int hash, String symbolStr, int colonIx, int[] quads, int qlen) {
        ByteBasedPName symbol = ByteBasedPNameFactory.getInstance().constructPName(hash, symbolStr, colonIx, quads, qlen);
        this.doAddSymbol(hash, symbol);
        return symbol;
    }

    public static final int calcHash(int firstQuad) {
        int hash = firstQuad * 31;
        hash ^= hash >>> 16;
        hash ^= hash >>> 8;
        return hash;
    }

    public static final int calcHash(int firstQuad, int secondQuad) {
        int hash = firstQuad * 31 + secondQuad;
        hash ^= hash >>> 16;
        hash ^= hash >>> 8;
        return hash;
    }

    public static final int calcHash(int[] quads, int qlen) {
        int hash = quads[0];
        for (int i2 = 1; i2 < qlen; ++i2) {
            hash = hash * 31 + quads[i2];
        }
        hash ^= hash >>> 16;
        hash ^= hash >>> 8;
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[PNameTable, size: ");
        sb.append(this.mCount);
        sb.append('/');
        sb.append(this.mMainHash.length);
        sb.append(", ");
        sb.append(this.mCollCount);
        sb.append(" coll; avg length: ");
        int pathCount = this.mCount;
        for (int i2 = 0; i2 < this.mCollEnd; ++i2) {
            int spillLen = this.mCollList[i2].length();
            for (int j2 = 1; j2 <= spillLen; ++j2) {
                pathCount += j2;
            }
        }
        double avgLength = this.mCount == 0 ? 0.0 : (double)pathCount / (double)this.mCount;
        sb.append(avgLength);
        sb.append(']');
        return sb.toString();
    }

    private void doAddSymbol(int hash, ByteBasedPName symbol) {
        if (this.mMainHashShared) {
            this.unshareMain();
        }
        if (this.mNeedRehash) {
            this.rehash();
        }
        ++this.mCount;
        int ix = hash & this.mMainHashMask;
        if (this.mMainNames[ix] == null) {
            this.mMainHash[ix] = hash << 8;
            if (this.mMainNamesShared) {
                this.unshareNames();
            }
            this.mMainNames[ix] = symbol;
        } else {
            if (this.mCollListShared) {
                this.unshareCollision();
            }
            ++this.mCollCount;
            int entryValue = this.mMainHash[ix];
            int bucket = entryValue & 0xFF;
            if (bucket == 0) {
                if (this.mCollEnd <= 254) {
                    if ((bucket = this.mCollEnd++) >= this.mCollList.length) {
                        this.expandCollision();
                    }
                } else {
                    bucket = this.findBestBucket();
                }
                this.mMainHash[ix] = entryValue & 0xFFFFFF00 | bucket + 1;
            } else {
                --bucket;
            }
            this.mCollList[bucket] = new Bucket(symbol, this.mCollList[bucket]);
        }
        int hashSize = this.mMainHash.length;
        if (this.mCount > hashSize >> 1) {
            int hashQuarter = hashSize >> 2;
            if (this.mCount > hashSize - hashQuarter) {
                this.mNeedRehash = true;
            } else if (this.mCollCount >= hashQuarter) {
                this.mNeedRehash = true;
            }
        }
    }

    private void rehash() {
        this.mNeedRehash = false;
        this.mMainNamesShared = false;
        int symbolsSeen = 0;
        int[] oldMainHash = this.mMainHash;
        int len = oldMainHash.length;
        this.mMainHash = new int[len + len];
        this.mMainHashMask = len + len - 1;
        ByteBasedPName[] oldNames = this.mMainNames;
        this.mMainNames = new ByteBasedPName[len + len];
        for (int i2 = 0; i2 < len; ++i2) {
            ByteBasedPName symbol = oldNames[i2];
            if (symbol == null) continue;
            ++symbolsSeen;
            int hash = symbol.hashCode();
            int ix = hash & this.mMainHashMask;
            this.mMainNames[ix] = symbol;
            this.mMainHash[ix] = hash << 8;
        }
        int oldEnd = this.mCollEnd;
        if (oldEnd == 0) {
            return;
        }
        this.mCollCount = 0;
        this.mCollEnd = 0;
        this.mCollListShared = false;
        Bucket[] oldBuckets = this.mCollList;
        this.mCollList = new Bucket[oldBuckets.length];
        for (int i3 = 0; i3 < oldEnd; ++i3) {
            Bucket curr = oldBuckets[i3];
            while (curr != null) {
                ++symbolsSeen;
                ByteBasedPName symbol = curr.mName;
                int hash = symbol.hashCode();
                int ix = hash & this.mMainHashMask;
                int val = this.mMainHash[ix];
                if (this.mMainNames[ix] == null) {
                    this.mMainHash[ix] = hash << 8;
                    this.mMainNames[ix] = symbol;
                } else {
                    ++this.mCollCount;
                    int bucket = val & 0xFF;
                    if (bucket == 0) {
                        if (this.mCollEnd <= 254) {
                            if ((bucket = this.mCollEnd++) >= this.mCollList.length) {
                                this.expandCollision();
                            }
                        } else {
                            bucket = this.findBestBucket();
                        }
                        this.mMainHash[ix] = val & 0xFFFFFF00 | bucket + 1;
                    } else {
                        --bucket;
                    }
                    this.mCollList[bucket] = new Bucket(symbol, this.mCollList[bucket]);
                }
                curr = curr.mNext;
            }
        }
        if (symbolsSeen != this.mCount) {
            throw new Error("Internal error: count after rehash " + symbolsSeen + "; should be " + this.mCount);
        }
    }

    private int findBestBucket() {
        Bucket[] buckets = this.mCollList;
        int bestCount = Integer.MAX_VALUE;
        int bestIx = -1;
        int len = this.mCollEnd;
        for (int i2 = 0; i2 < len; ++i2) {
            int count = buckets[i2].length();
            if (count >= bestCount) continue;
            if (count == 1) {
                return i2;
            }
            bestCount = count;
            bestIx = i2;
        }
        return bestIx;
    }

    private void unshareMain() {
        int[] old = this.mMainHash;
        int len = this.mMainHash.length;
        this.mMainHash = new int[len];
        System.arraycopy(old, 0, this.mMainHash, 0, len);
        this.mMainHashShared = false;
    }

    private void unshareCollision() {
        Bucket[] old = this.mCollList;
        if (old == null) {
            this.mCollList = new Bucket[32];
        } else {
            int len = old.length;
            this.mCollList = new Bucket[len];
            System.arraycopy(old, 0, this.mCollList, 0, len);
        }
        this.mCollListShared = false;
    }

    private void unshareNames() {
        ByteBasedPName[] old = this.mMainNames;
        int len = old.length;
        this.mMainNames = new ByteBasedPName[len];
        System.arraycopy(old, 0, this.mMainNames, 0, len);
        this.mMainNamesShared = false;
    }

    private void expandCollision() {
        Bucket[] old = this.mCollList;
        int len = old.length;
        this.mCollList = new Bucket[len + len];
        System.arraycopy(old, 0, this.mCollList, 0, len);
    }

    static final class Bucket {
        final ByteBasedPName mName;
        final Bucket mNext;

        Bucket(ByteBasedPName name2, Bucket next) {
            this.mName = name2;
            this.mNext = next;
        }

        public int length() {
            int len = 1;
            Bucket curr = this.mNext;
            while (curr != null) {
                ++len;
                curr = curr.mNext;
            }
            return len;
        }

        public ByteBasedPName find(int hash, int firstQuad, int secondQuad) {
            if (this.mName.hashEquals(hash, firstQuad, secondQuad)) {
                return this.mName;
            }
            Bucket curr = this.mNext;
            while (curr != null) {
                ByteBasedPName currName = curr.mName;
                if (currName.hashEquals(hash, firstQuad, secondQuad)) {
                    return currName;
                }
                curr = curr.mNext;
            }
            return null;
        }

        public ByteBasedPName find(int hash, int[] quads, int qlen) {
            if (this.mName.hashEquals(hash, quads, qlen)) {
                return this.mName;
            }
            Bucket curr = this.mNext;
            while (curr != null) {
                ByteBasedPName currName = curr.mName;
                if (currName.hashEquals(hash, quads, qlen)) {
                    return currName;
                }
                curr = curr.mNext;
            }
            return null;
        }
    }
}

