# Copyright (c) Streamlit Inc. (2018-2022) Snowflake Inc. (2022-2026)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import streamlit as st

st.set_page_config(page_title="Hello", page_icon=":material/waving_hand:")
st.title("Welcome to Streamlit! 👋")
st.write(
    """
    Streamlit is an open-source app framework built specifically for
    machine learning and data science projects.

    **👈 Select a demo from the sidebar** to see some examples
    of what Streamlit can do!

    ### Want to learn more?
    - Check out [streamlit.io](https://streamlit.io)
    - Jump into our [documentation](https://docs.streamlit.io)
    - Ask a question in our [community
      forums](https://discuss.streamlit.io)

    ### See more complex demos
    - Use a neural net to [analyze the Udacity Self-driving Car Image
      Dataset](https://github.com/streamlit/demo-self-driving)
    - Explore a [New York City rideshare dataset](https://github.com/streamlit/demo-uber-nyc-pickups)
    """
)

# Preload Python modules that take a while to compile in a new venv.
# Otherwise, when users switch to another page, it seems that Streamlit
# is slow, when in reality this is just an artifact of loading/compiling
# large modules from zero.
with st.spinner("Preloading Python modules for other pages..."):
    import numpy  # noqa: ICN001 F401
    import pandas  # noqa: ICN001 F401
