find_path(LifTOPT_INCLUDE_DIR 
liftopt.hpp
HINTS $ENV{LifTOPT}/include
)

find_path(LifTOPT_SRC_INCLUDE_DIR 
liftopt.hpp
HINTS $ENV{LifTOPT_SRC}/INCLUDE
)

find_path(SONIC_INCLUDE_DIR 
sonic++.h
HINTS $ENV{SONIC}/include
)

find_path(COMMON_CODE_INCLUDE_DIR 
CommonCodeUtilitiesForwardDeclarations.hpp
HINTS $ENV{COMMON_CODE}/include
)

if(LifTOPT_INCLUDE_DIR AND SONIC_INCLUDE_DIR AND COMMON_CODE_INCLUDE_DIR AND LifTOPT_SRC_INCLUDE_DIR )
   set(LifTOPT_FOUND_INCLUDE TRUE)
   set(LifTOPT_INCLUDE_DIRS ${LifTOPT_INCLUDE_DIR} ${SONIC_INCLUDE_DIR} ${COMMON_CODE_INCLUDE_DIR} ${LifTOPT_SRC_INCLUDE_DIR} )
   message(STATUS "Found LifTOPT include dirs: ${LifTOPT_INCLUDE_DIRS}")
else(LifTOPT_INCLUDE_DIR AND SONIC_INCLUDE_DIR AND COMMON_CODE_INCLUDE_DIR AND LifTOPT_SRC_INCLUDE_DIR )
   message(STATUS "Could not find LifTOPT include dir")
endif(LifTOPT_INCLUDE_DIR AND SONIC_INCLUDE_DIR AND COMMON_CODE_INCLUDE_DIR AND LifTOPT_SRC_INCLUDE_DIR )

find_library(LifTOPT_LIBRARY
NAMES liftopt HINTS $ENV{LifTOPT}/lib $ENV{LifTOPT}/lib64)

find_library(SONIC_LIBRARY
NAMES sonic HINTS $ENV{SONIC}/lib $ENV{SONIC}/lib64)

find_library(COMMON_CODE_LOGGING NAMES common_code_logging HINTS $ENV{COMMON_CODE}/lib $ENV{COMMON_CODE}/lib64)
find_library(COMMON_CODE_PROBLEM_HANDLING NAMES common_code_problem_handling HINTS $ENV{COMMON_CODE}/lib $ENV{COMMON_CODE}/lib64)
find_library(COMMON_CODE_TYPE_CONVERSIONS NAMES common_code_type_conversion HINTS $ENV{COMMON_CODE}/lib $ENV{COMMON_CODE}/lib64)
find_library(COMMON_CODE_UTILITIES NAMES common_code_utilities HINTS $ENV{COMMON_CODE}/lib $ENV{COMMON_CODE}/lib64)

if(LifTOPT_LIBRARY AND SONIC_LIBRARY AND COMMON_CODE_LOGGING AND COMMON_CODE_PROBLEM_HANDLING AND COMMON_CODE_TYPE_CONVERSIONS AND COMMON_CODE_UTILITIES)
   set(LifTOPT_FOUND_LIBS TRUE)
   set(LifTOPT_LIBRARIES ${LifTOPT_LIBRARY} ${SONIC_LIBRARY} ${COMMON_CODE_LOGGING} ${COMMON_CODE_PROBLEM_HANDLING} ${COMMON_CODE_TYPE_CONVERSIONS} ${COMMON_CODE_UTILITIES} )
   message(STATUS "Found LifTOPT libs: ${LifTOPT_LIBRARIES}")
else(LifTOPT_LIBRARY AND SONIC_LIBRARY AND COMMON_CODE_LOGGING AND COMMON_CODE_PROBLEM_HANDLING AND COMMON_CODE_TYPE_CONVERSIONS AND COMMON_CODE_UTILITIES)
   message(STATUS "Could not find sundials libs")
endif(LifTOPT_LIBRARY AND SONIC_LIBRARY AND COMMON_CODE_LOGGING AND COMMON_CODE_PROBLEM_HANDLING AND COMMON_CODE_TYPE_CONVERSIONS AND COMMON_CODE_UTILITIES)

if(LifTOPT_FOUND_INCLUDE AND LifTOPT_FOUND_LIBS)
  set(LifTOPT_FOUND TRUE)
endif(LifTOPT_FOUND_INCLUDE AND LifTOPT_FOUND_LIBS)
