/******************************************************************************
 * Top contributors (to current version):
 *   Andrew Reynolds, Aina Niemetz
 *
 * This file is part of the cvc5 project.
 *
 * Copyright (c) 2009-2025 by the authors listed in the file AUTHORS
 * in the top-level source directory and their institutional affiliations.
 * All rights reserved.  See the file COPYING in the top-level source
 * directory for licensing information.
 * ****************************************************************************
 *
 * A shared statistics class for sygus.
 */

#include "cvc5_private.h"

#ifndef CVC5__THEORY__QUANTIFIERS__SYGUS_STATS_H
#define CVC5__THEORY__QUANTIFIERS__SYGUS_STATS_H

#include "util/statistics_registry.h"
#include "util/statistics_stats.h"

namespace cvc5::internal {
namespace theory {
namespace quantifiers {

/**
 * All statistics managed for the synth engine.
 */
class SygusStatistics
{
 public:
  SygusStatistics(StatisticsRegistry& sr);
  /** Number of solutions printed (could be >1 for --sygus-stream) */
  IntStat d_solutions;
  /** Number of solutions filtered */
  IntStat d_filtered_solutions;
  /** Number of terms checked for rewrite-based symmetry in fast enumerators */
  IntStat d_enumTermsRewrite;
  /** Number of terms checked for example-based symmetry in fast enumerators */
  IntStat d_enumTermsExampleEval;
  /** Number of non-redundant terms generated by fast enumerators */
  IntStat d_enumTerms;
};

}  // namespace quantifiers
}  // namespace theory
}  // namespace cvc5::internal

#endif
