
//
// File: test_mzcbor.cpp
// Created by: Olivier Langella
// Created on: 19/11/2025
//
/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella <Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/

// ./tests/pappsotree/catch2-only-pappsotree [mzcbor] -s

#include <catch2/catch_test_macros.hpp>
#include <pappsomspp/core/processing/cbor/mzcbor/mzmlconvert.h>
#include <pappsomspp/core/processing/uimonitor/uimonitorvoid.h>
#include <QDebug>
#include <QFileInfo>
#include "tests/tests-config.h"
#include <pappsomspp/core/msfile/msfileaccessor.h>
#include <catch2/matchers/catch_matchers_vector.hpp>


TEST_CASE("cbor psm map test suite.", "[mzcbor]")
{
  // Set the debugging message formatting pattern.
  qSetMessagePattern(QString("%{file}@%{line}, %{function}(): %{message}"));

  SECTION("..:: PSM cbor features::..", "[mzcbor]")
  {
    pappso::MsFileAccessor file_access(
      "/gorgone/pappso/moulon/raw/20250521_proteobench_dda_astral/mzcbor/"
      "LFQ_Astral_DDA_15min_50ng_Condition_A_REP3.mzcbor",
      "");
    pappso::MsRunReaderSPtr msrunA01 = file_access.getMsRunReaderSPtrByRunId("", "runa01");

    REQUIRE(msrunA01.get()->getMsRunId().get()->getSampleName().toStdString() ==
            "LFQ_Astral_DDA_15min_50ng_Condition_A_REP3");


    pappso::QualifiedMassSpectrum qualifiedMassSpectrum =
      msrunA01.get()->qualifiedMassSpectrum(2, true);
    REQUIRE(qualifiedMassSpectrum.getRtInSeconds() == 0.76824700000000201);
    REQUIRE(qualifiedMassSpectrum.getMsLevel() == 1);
    REQUIRE(qualifiedMassSpectrum.getMassSpectrumCstSPtr().get()->size() == 1140);
    
    qualifiedMassSpectrum =
      msrunA01.get()->qualifiedMassSpectrum(77766, true);
    REQUIRE(qualifiedMassSpectrum.getRtInSeconds() == 0.76824700000000201);
    REQUIRE(qualifiedMassSpectrum.getMsLevel() == 1);
    REQUIRE(qualifiedMassSpectrum.getMassSpectrumCstSPtr().get()->size() == 1140);
    
    qDebug();
    // msrunA01.get()->getRetentionTimeLine();
  }
  SECTION("..:: PSM cbor features::..", "[mzcbor]")
  {
    pappso::MsFileAccessor file_access(
      "/gorgone/pappso/data_extraction_pappso/mzcbor/20120906_balliau_extract_1_A01_urnb-1.mzcbor",
      "");
    pappso::MsRunReaderSPtr msrunA01 = file_access.getMsRunReaderSPtrByRunId("", "runa01");

    REQUIRE(msrunA01.get()->getMsRunId().get()->getSampleName().toStdString() ==
            "20120906_balliau_extract_1_A01_urnb-1");
  }

  SECTION("..:: PSM cbor features::..", "[mzcbor]")
  {
    pappso::UiMonitorVoid monitor;

    QFileInfo mzml_file(
      "/gorgone/pappso/data_extraction_pappso/mzML/20120906_balliau_extract_1_A01_urnb-1.mzML");

    QFile mzcbor_file("mzcbor.cbor");
    mzcbor_file.open(QIODevice::WriteOnly);
    pappso::cbor::CborStreamWriter writer(&mzcbor_file);


    pappso::cbor::mzcbor::MzmlConvert mzml_convert(&monitor, &writer);

    mzml_convert.readFile(mzml_file.absoluteFilePath());
    mzcbor_file.close();

    REQUIRE(mzml_convert.errorString().isEmpty());
  }


  SECTION("..:: PSM cbor features::..", "[mzcbor]")
  {
    pappso::MsFileAccessor file_access("mzcbor.cbor", "");
    pappso::MsRunReaderSPtr msrunA01 = file_access.getMsRunReaderSPtrByRunId("", "runa01");

    REQUIRE(msrunA01.get()->getMsRunId().get()->getSampleName().toStdString() ==
            "20120906_balliau_extract_1_A01_urnb-1");


    REQUIRE(msrunA01.get()->spectrumListSize() == 16576);
    qDebug();
    // msrunA01.get()->getRetentionTimeLine();
  }
}
