/*******************************************************************************
    Copyright (c) 2016 NVIDIA Corporation

    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to
    deal in the Software without restriction, including without limitation the
    rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
    sell copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:

        The above copyright notice and this permission notice shall be
        included in all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
    THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.

*******************************************************************************/

/* AUTO GENERATED FILE -- DO NOT EDIT */

#ifndef __CLC0C0QMD_H__
#define __CLC0C0QMD_H__

/*
** Queue Meta Data, Version 01_07
 */

// The below C preprocessor definitions describe "multi-word" structures, where
// fields may have bit numbers beyond 32.  For example, MW(127:96) means
// the field is in bits 0-31 of word number 3 of the structure.  The "MW(X:Y)"
// syntax is to distinguish from similar "X:Y" single-word definitions: the
// macros historically used for single-word definitions would fail with
// multi-word definitions.
//
// See nvmisc.h:DRF_VAL_MW() in the source code of the kernel
// interface layer of nvidia.ko for an example of how to manipulate
// these MW(X:Y) definitions.

#define NVC0C0_QMDV01_07_OUTER_PUT                                 MW(30:0)
#define NVC0C0_QMDV01_07_OUTER_OVERFLOW                            MW(31:31)
#define NVC0C0_QMDV01_07_OUTER_GET                                 MW(62:32)
#define NVC0C0_QMDV01_07_OUTER_STICKY_OVERFLOW                     MW(63:63)
#define NVC0C0_QMDV01_07_INNER_GET                                 MW(94:64)
#define NVC0C0_QMDV01_07_INNER_OVERFLOW                            MW(95:95)
#define NVC0C0_QMDV01_07_INNER_PUT                                 MW(126:96)
#define NVC0C0_QMDV01_07_INNER_STICKY_OVERFLOW                     MW(127:127)
#define NVC0C0_QMDV01_07_QMD_RESERVED_A_A                          MW(159:128)
#define NVC0C0_QMDV01_07_DEPENDENT_QMD_POINTER                     MW(191:160)
#define NVC0C0_QMDV01_07_QMD_GROUP_ID                              MW(197:192)
#define NVC0C0_QMDV01_07_SM_GLOBAL_CACHING_ENABLE                  MW(198:198)
#define NVC0C0_QMDV01_07_RUN_CTA_IN_ONE_SM_PARTITION               MW(199:199)
#define NVC0C0_QMDV01_07_RUN_CTA_IN_ONE_SM_PARTITION_FALSE         0x00000000
#define NVC0C0_QMDV01_07_RUN_CTA_IN_ONE_SM_PARTITION_TRUE          0x00000001
#define NVC0C0_QMDV01_07_IS_QUEUE                                  MW(200:200)
#define NVC0C0_QMDV01_07_IS_QUEUE_FALSE                            0x00000000
#define NVC0C0_QMDV01_07_IS_QUEUE_TRUE                             0x00000001
#define NVC0C0_QMDV01_07_ADD_TO_HEAD_OF_QMD_GROUP_LINKED_LIST      MW(201:201)
#define NVC0C0_QMDV01_07_ADD_TO_HEAD_OF_QMD_GROUP_LINKED_LIST_FALSE 0x00000000
#define NVC0C0_QMDV01_07_ADD_TO_HEAD_OF_QMD_GROUP_LINKED_LIST_TRUE 0x00000001
#define NVC0C0_QMDV01_07_SEMAPHORE_RELEASE_ENABLE0                 MW(202:202)
#define NVC0C0_QMDV01_07_SEMAPHORE_RELEASE_ENABLE0_FALSE           0x00000000
#define NVC0C0_QMDV01_07_SEMAPHORE_RELEASE_ENABLE0_TRUE            0x00000001
#define NVC0C0_QMDV01_07_SEMAPHORE_RELEASE_ENABLE1                 MW(203:203)
#define NVC0C0_QMDV01_07_SEMAPHORE_RELEASE_ENABLE1_FALSE           0x00000000
#define NVC0C0_QMDV01_07_SEMAPHORE_RELEASE_ENABLE1_TRUE            0x00000001
#define NVC0C0_QMDV01_07_REQUIRE_SCHEDULING_PCAS                   MW(204:204)
#define NVC0C0_QMDV01_07_REQUIRE_SCHEDULING_PCAS_FALSE             0x00000000
#define NVC0C0_QMDV01_07_REQUIRE_SCHEDULING_PCAS_TRUE              0x00000001
#define NVC0C0_QMDV01_07_DEPENDENT_QMD_SCHEDULE_ENABLE             MW(205:205)
#define NVC0C0_QMDV01_07_DEPENDENT_QMD_SCHEDULE_ENABLE_FALSE       0x00000000
#define NVC0C0_QMDV01_07_DEPENDENT_QMD_SCHEDULE_ENABLE_TRUE        0x00000001
#define NVC0C0_QMDV01_07_DEPENDENT_QMD_TYPE                        MW(206:206)
#define NVC0C0_QMDV01_07_DEPENDENT_QMD_TYPE_QUEUE                  0x00000000
#define NVC0C0_QMDV01_07_DEPENDENT_QMD_TYPE_GRID                   0x00000001
#define NVC0C0_QMDV01_07_DEPENDENT_QMD_FIELD_COPY                  MW(207:207)
#define NVC0C0_QMDV01_07_DEPENDENT_QMD_FIELD_COPY_FALSE            0x00000000
#define NVC0C0_QMDV01_07_DEPENDENT_QMD_FIELD_COPY_TRUE             0x00000001
#define NVC0C0_QMDV01_07_QMD_RESERVED_B                            MW(223:208)
#define NVC0C0_QMDV01_07_CIRCULAR_QUEUE_SIZE                       MW(248:224)
#define NVC0C0_QMDV01_07_QMD_RESERVED_C                            MW(249:249)
#define NVC0C0_QMDV01_07_INVALIDATE_TEXTURE_HEADER_CACHE           MW(250:250)
#define NVC0C0_QMDV01_07_INVALIDATE_TEXTURE_HEADER_CACHE_FALSE     0x00000000
#define NVC0C0_QMDV01_07_INVALIDATE_TEXTURE_HEADER_CACHE_TRUE      0x00000001
#define NVC0C0_QMDV01_07_INVALIDATE_TEXTURE_SAMPLER_CACHE          MW(251:251)
#define NVC0C0_QMDV01_07_INVALIDATE_TEXTURE_SAMPLER_CACHE_FALSE    0x00000000
#define NVC0C0_QMDV01_07_INVALIDATE_TEXTURE_SAMPLER_CACHE_TRUE     0x00000001
#define NVC0C0_QMDV01_07_INVALIDATE_TEXTURE_DATA_CACHE             MW(252:252)
#define NVC0C0_QMDV01_07_INVALIDATE_TEXTURE_DATA_CACHE_FALSE       0x00000000
#define NVC0C0_QMDV01_07_INVALIDATE_TEXTURE_DATA_CACHE_TRUE        0x00000001
#define NVC0C0_QMDV01_07_INVALIDATE_SHADER_DATA_CACHE              MW(253:253)
#define NVC0C0_QMDV01_07_INVALIDATE_SHADER_DATA_CACHE_FALSE        0x00000000
#define NVC0C0_QMDV01_07_INVALIDATE_SHADER_DATA_CACHE_TRUE         0x00000001
#define NVC0C0_QMDV01_07_INVALIDATE_INSTRUCTION_CACHE              MW(254:254)
#define NVC0C0_QMDV01_07_INVALIDATE_INSTRUCTION_CACHE_FALSE        0x00000000
#define NVC0C0_QMDV01_07_INVALIDATE_INSTRUCTION_CACHE_TRUE         0x00000001
#define NVC0C0_QMDV01_07_INVALIDATE_SHADER_CONSTANT_CACHE          MW(255:255)
#define NVC0C0_QMDV01_07_INVALIDATE_SHADER_CONSTANT_CACHE_FALSE    0x00000000
#define NVC0C0_QMDV01_07_INVALIDATE_SHADER_CONSTANT_CACHE_TRUE     0x00000001
#define NVC0C0_QMDV01_07_PROGRAM_OFFSET                            MW(287:256)
#define NVC0C0_QMDV01_07_CIRCULAR_QUEUE_ADDR_LOWER                 MW(319:288)
#define NVC0C0_QMDV01_07_CIRCULAR_QUEUE_ADDR_UPPER                 MW(327:320)
#define NVC0C0_QMDV01_07_QMD_RESERVED_D                            MW(335:328)
#define NVC0C0_QMDV01_07_CIRCULAR_QUEUE_ENTRY_SIZE                 MW(351:336)
#define NVC0C0_QMDV01_07_CWD_REFERENCE_COUNT_ID                    MW(357:352)
#define NVC0C0_QMDV01_07_CWD_REFERENCE_COUNT_DELTA_MINUS_ONE       MW(365:358)
#define NVC0C0_QMDV01_07_RELEASE_MEMBAR_TYPE                       MW(366:366)
#define NVC0C0_QMDV01_07_RELEASE_MEMBAR_TYPE_FE_NONE               0x00000000
#define NVC0C0_QMDV01_07_RELEASE_MEMBAR_TYPE_FE_SYSMEMBAR          0x00000001
#define NVC0C0_QMDV01_07_CWD_REFERENCE_COUNT_INCR_ENABLE           MW(367:367)
#define NVC0C0_QMDV01_07_CWD_REFERENCE_COUNT_INCR_ENABLE_FALSE     0x00000000
#define NVC0C0_QMDV01_07_CWD_REFERENCE_COUNT_INCR_ENABLE_TRUE      0x00000001
#define NVC0C0_QMDV01_07_CWD_MEMBAR_TYPE                           MW(369:368)
#define NVC0C0_QMDV01_07_CWD_MEMBAR_TYPE_L1_NONE                   0x00000000
#define NVC0C0_QMDV01_07_CWD_MEMBAR_TYPE_L1_SYSMEMBAR              0x00000001
#define NVC0C0_QMDV01_07_CWD_MEMBAR_TYPE_L1_MEMBAR                 0x00000003
#define NVC0C0_QMDV01_07_SEQUENTIALLY_RUN_CTAS                     MW(370:370)
#define NVC0C0_QMDV01_07_SEQUENTIALLY_RUN_CTAS_FALSE               0x00000000
#define NVC0C0_QMDV01_07_SEQUENTIALLY_RUN_CTAS_TRUE                0x00000001
#define NVC0C0_QMDV01_07_CWD_REFERENCE_COUNT_DECR_ENABLE           MW(371:371)
#define NVC0C0_QMDV01_07_CWD_REFERENCE_COUNT_DECR_ENABLE_FALSE     0x00000000
#define NVC0C0_QMDV01_07_CWD_REFERENCE_COUNT_DECR_ENABLE_TRUE      0x00000001
#define NVC0C0_QMDV01_07_THROTTLED                                 MW(372:372)
#define NVC0C0_QMDV01_07_THROTTLED_FALSE                           0x00000000
#define NVC0C0_QMDV01_07_THROTTLED_TRUE                            0x00000001
#define NVC0C0_QMDV01_07_FP32_NAN_BEHAVIOR                         MW(376:376)
#define NVC0C0_QMDV01_07_FP32_NAN_BEHAVIOR_LEGACY                  0x00000000
#define NVC0C0_QMDV01_07_FP32_NAN_BEHAVIOR_FP64_COMPATIBLE         0x00000001
#define NVC0C0_QMDV01_07_FP32_F2I_NAN_BEHAVIOR                     MW(377:377)
#define NVC0C0_QMDV01_07_FP32_F2I_NAN_BEHAVIOR_PASS_ZERO           0x00000000
#define NVC0C0_QMDV01_07_FP32_F2I_NAN_BEHAVIOR_PASS_INDEFINITE     0x00000001
#define NVC0C0_QMDV01_07_API_VISIBLE_CALL_LIMIT                    MW(378:378)
#define NVC0C0_QMDV01_07_API_VISIBLE_CALL_LIMIT__32                0x00000000
#define NVC0C0_QMDV01_07_API_VISIBLE_CALL_LIMIT_NO_CHECK           0x00000001
#define NVC0C0_QMDV01_07_SHARED_MEMORY_BANK_MAPPING                MW(379:379)
#define NVC0C0_QMDV01_07_SHARED_MEMORY_BANK_MAPPING_FOUR_BYTES_PER_BANK 0x00000000
#define NVC0C0_QMDV01_07_SHARED_MEMORY_BANK_MAPPING_EIGHT_BYTES_PER_BANK 0x00000001
#define NVC0C0_QMDV01_07_SAMPLER_INDEX                             MW(382:382)
#define NVC0C0_QMDV01_07_SAMPLER_INDEX_INDEPENDENTLY               0x00000000
#define NVC0C0_QMDV01_07_SAMPLER_INDEX_VIA_HEADER_INDEX            0x00000001
#define NVC0C0_QMDV01_07_FP32_NARROW_INSTRUCTION                   MW(383:383)
#define NVC0C0_QMDV01_07_FP32_NARROW_INSTRUCTION_KEEP_DENORMS      0x00000000
#define NVC0C0_QMDV01_07_FP32_NARROW_INSTRUCTION_FLUSH_DENORMS     0x00000001
#define NVC0C0_QMDV01_07_CTA_RASTER_WIDTH                          MW(415:384)
#define NVC0C0_QMDV01_07_CTA_RASTER_HEIGHT                         MW(431:416)
#define NVC0C0_QMDV01_07_CTA_RASTER_DEPTH                          MW(447:432)
#define NVC0C0_QMDV01_07_CTA_RASTER_WIDTH_RESUME                   MW(479:448)
#define NVC0C0_QMDV01_07_CTA_RASTER_HEIGHT_RESUME                  MW(495:480)
#define NVC0C0_QMDV01_07_CTA_RASTER_DEPTH_RESUME                   MW(511:496)
#define NVC0C0_QMDV01_07_QUEUE_ENTRIES_PER_CTA_MINUS_ONE           MW(518:512)
#define NVC0C0_QMDV01_07_COALESCE_WAITING_PERIOD                   MW(529:522)
#define NVC0C0_QMDV01_07_SHARED_MEMORY_SIZE                        MW(561:544)
#define NVC0C0_QMDV01_07_QMD_RESERVED_G                            MW(575:562)
#define NVC0C0_QMDV01_07_QMD_VERSION                               MW(579:576)
#define NVC0C0_QMDV01_07_QMD_MAJOR_VERSION                         MW(583:580)
#define NVC0C0_QMDV01_07_QMD_RESERVED_H                            MW(591:584)
#define NVC0C0_QMDV01_07_CTA_THREAD_DIMENSION0                     MW(607:592)
#define NVC0C0_QMDV01_07_CTA_THREAD_DIMENSION1                     MW(623:608)
#define NVC0C0_QMDV01_07_CTA_THREAD_DIMENSION2                     MW(639:624)
#define NVC0C0_QMDV01_07_CONSTANT_BUFFER_VALID(i)                  MW((640+(i)*1):(640+(i)*1))
#define NVC0C0_QMDV01_07_CONSTANT_BUFFER_VALID_FALSE               0x00000000
#define NVC0C0_QMDV01_07_CONSTANT_BUFFER_VALID_TRUE                0x00000001
#define NVC0C0_QMDV01_07_QMD_RESERVED_I                            MW(668:648)
#define NVC0C0_QMDV01_07_L1_CONFIGURATION                          MW(671:669)
#define NVC0C0_QMDV01_07_L1_CONFIGURATION_DIRECTLY_ADDRESSABLE_MEMORY_SIZE_16KB 0x00000001
#define NVC0C0_QMDV01_07_L1_CONFIGURATION_DIRECTLY_ADDRESSABLE_MEMORY_SIZE_32KB 0x00000002
#define NVC0C0_QMDV01_07_L1_CONFIGURATION_DIRECTLY_ADDRESSABLE_MEMORY_SIZE_48KB 0x00000003
#define NVC0C0_QMDV01_07_SM_DISABLE_MASK_LOWER                     MW(703:672)
#define NVC0C0_QMDV01_07_SM_DISABLE_MASK_UPPER                     MW(735:704)
#define NVC0C0_QMDV01_07_RELEASE0_ADDRESS_LOWER                    MW(767:736)
#define NVC0C0_QMDV01_07_RELEASE0_ADDRESS_UPPER                    MW(775:768)
#define NVC0C0_QMDV01_07_QMD_RESERVED_J                            MW(783:776)
#define NVC0C0_QMDV01_07_RELEASE0_REDUCTION_OP                     MW(790:788)
#define NVC0C0_QMDV01_07_RELEASE0_REDUCTION_OP_RED_ADD             0x00000000
#define NVC0C0_QMDV01_07_RELEASE0_REDUCTION_OP_RED_MIN             0x00000001
#define NVC0C0_QMDV01_07_RELEASE0_REDUCTION_OP_RED_MAX             0x00000002
#define NVC0C0_QMDV01_07_RELEASE0_REDUCTION_OP_RED_INC             0x00000003
#define NVC0C0_QMDV01_07_RELEASE0_REDUCTION_OP_RED_DEC             0x00000004
#define NVC0C0_QMDV01_07_RELEASE0_REDUCTION_OP_RED_AND             0x00000005
#define NVC0C0_QMDV01_07_RELEASE0_REDUCTION_OP_RED_OR              0x00000006
#define NVC0C0_QMDV01_07_RELEASE0_REDUCTION_OP_RED_XOR             0x00000007
#define NVC0C0_QMDV01_07_QMD_RESERVED_K                            MW(791:791)
#define NVC0C0_QMDV01_07_RELEASE0_REDUCTION_FORMAT                 MW(793:792)
#define NVC0C0_QMDV01_07_RELEASE0_REDUCTION_FORMAT_UNSIGNED_32     0x00000000
#define NVC0C0_QMDV01_07_RELEASE0_REDUCTION_FORMAT_SIGNED_32       0x00000001
#define NVC0C0_QMDV01_07_RELEASE0_REDUCTION_ENABLE                 MW(794:794)
#define NVC0C0_QMDV01_07_RELEASE0_REDUCTION_ENABLE_FALSE           0x00000000
#define NVC0C0_QMDV01_07_RELEASE0_REDUCTION_ENABLE_TRUE            0x00000001
#define NVC0C0_QMDV01_07_RELEASE0_STRUCTURE_SIZE                   MW(799:799)
#define NVC0C0_QMDV01_07_RELEASE0_STRUCTURE_SIZE_FOUR_WORDS        0x00000000
#define NVC0C0_QMDV01_07_RELEASE0_STRUCTURE_SIZE_ONE_WORD          0x00000001
#define NVC0C0_QMDV01_07_RELEASE0_PAYLOAD                          MW(831:800)
#define NVC0C0_QMDV01_07_RELEASE1_ADDRESS_LOWER                    MW(863:832)
#define NVC0C0_QMDV01_07_RELEASE1_ADDRESS_UPPER                    MW(871:864)
#define NVC0C0_QMDV01_07_QMD_RESERVED_L                            MW(879:872)
#define NVC0C0_QMDV01_07_RELEASE1_REDUCTION_OP                     MW(886:884)
#define NVC0C0_QMDV01_07_RELEASE1_REDUCTION_OP_RED_ADD             0x00000000
#define NVC0C0_QMDV01_07_RELEASE1_REDUCTION_OP_RED_MIN             0x00000001
#define NVC0C0_QMDV01_07_RELEASE1_REDUCTION_OP_RED_MAX             0x00000002
#define NVC0C0_QMDV01_07_RELEASE1_REDUCTION_OP_RED_INC             0x00000003
#define NVC0C0_QMDV01_07_RELEASE1_REDUCTION_OP_RED_DEC             0x00000004
#define NVC0C0_QMDV01_07_RELEASE1_REDUCTION_OP_RED_AND             0x00000005
#define NVC0C0_QMDV01_07_RELEASE1_REDUCTION_OP_RED_OR              0x00000006
#define NVC0C0_QMDV01_07_RELEASE1_REDUCTION_OP_RED_XOR             0x00000007
#define NVC0C0_QMDV01_07_QMD_RESERVED_M                            MW(887:887)
#define NVC0C0_QMDV01_07_RELEASE1_REDUCTION_FORMAT                 MW(889:888)
#define NVC0C0_QMDV01_07_RELEASE1_REDUCTION_FORMAT_UNSIGNED_32     0x00000000
#define NVC0C0_QMDV01_07_RELEASE1_REDUCTION_FORMAT_SIGNED_32       0x00000001
#define NVC0C0_QMDV01_07_RELEASE1_REDUCTION_ENABLE                 MW(890:890)
#define NVC0C0_QMDV01_07_RELEASE1_REDUCTION_ENABLE_FALSE           0x00000000
#define NVC0C0_QMDV01_07_RELEASE1_REDUCTION_ENABLE_TRUE            0x00000001
#define NVC0C0_QMDV01_07_RELEASE1_STRUCTURE_SIZE                   MW(895:895)
#define NVC0C0_QMDV01_07_RELEASE1_STRUCTURE_SIZE_FOUR_WORDS        0x00000000
#define NVC0C0_QMDV01_07_RELEASE1_STRUCTURE_SIZE_ONE_WORD          0x00000001
#define NVC0C0_QMDV01_07_RELEASE1_PAYLOAD                          MW(927:896)
#define NVC0C0_QMDV01_07_CONSTANT_BUFFER_ADDR_LOWER(i)             MW((959+(i)*64):(928+(i)*64))
#define NVC0C0_QMDV01_07_CONSTANT_BUFFER_ADDR_UPPER(i)             MW((967+(i)*64):(960+(i)*64))
#define NVC0C0_QMDV01_07_CONSTANT_BUFFER_RESERVED_ADDR(i)          MW((973+(i)*64):(968+(i)*64))
#define NVC0C0_QMDV01_07_CONSTANT_BUFFER_INVALIDATE(i)             MW((974+(i)*64):(974+(i)*64))
#define NVC0C0_QMDV01_07_CONSTANT_BUFFER_INVALIDATE_FALSE          0x00000000
#define NVC0C0_QMDV01_07_CONSTANT_BUFFER_INVALIDATE_TRUE           0x00000001
#define NVC0C0_QMDV01_07_CONSTANT_BUFFER_SIZE(i)                   MW((991+(i)*64):(975+(i)*64))
#define NVC0C0_QMDV01_07_SHADER_LOCAL_MEMORY_LOW_SIZE              MW(1463:1440)
#define NVC0C0_QMDV01_07_QMD_RESERVED_N                            MW(1466:1464)
#define NVC0C0_QMDV01_07_BARRIER_COUNT                             MW(1471:1467)
#define NVC0C0_QMDV01_07_SHADER_LOCAL_MEMORY_HIGH_SIZE             MW(1495:1472)
#define NVC0C0_QMDV01_07_REGISTER_COUNT                            MW(1503:1496)
#define NVC0C0_QMDV01_07_SHADER_LOCAL_MEMORY_CRS_SIZE              MW(1527:1504)
#define NVC0C0_QMDV01_07_SASS_VERSION                              MW(1535:1528)
#define NVC0C0_QMDV01_07_HW_ONLY_INNER_GET                         MW(1566:1536)
#define NVC0C0_QMDV01_07_HW_ONLY_REQUIRE_SCHEDULING_PCAS           MW(1567:1567)
#define NVC0C0_QMDV01_07_HW_ONLY_INNER_PUT                         MW(1598:1568)
#define NVC0C0_QMDV01_07_HW_ONLY_SCG_TYPE                          MW(1599:1599)
#define NVC0C0_QMDV01_07_HW_ONLY_SPAN_LIST_HEAD_INDEX              MW(1629:1600)
#define NVC0C0_QMDV01_07_QMD_RESERVED_Q                            MW(1630:1630)
#define NVC0C0_QMDV01_07_HW_ONLY_SPAN_LIST_HEAD_INDEX_VALID        MW(1631:1631)
#define NVC0C0_QMDV01_07_HW_ONLY_SPAN_LIST_HEAD_INDEX_VALID_FALSE  0x00000000
#define NVC0C0_QMDV01_07_HW_ONLY_SPAN_LIST_HEAD_INDEX_VALID_TRUE   0x00000001
#define NVC0C0_QMDV01_07_HW_ONLY_SKED_NEXT_QMD_POINTER             MW(1663:1632)
#define NVC0C0_QMDV01_07_QMD_SPARE_E                               MW(1695:1664)
#define NVC0C0_QMDV01_07_QMD_SPARE_F                               MW(1727:1696)
#define NVC0C0_QMDV01_07_QMD_SPARE_G                               MW(1759:1728)
#define NVC0C0_QMDV01_07_QMD_SPARE_H                               MW(1791:1760)
#define NVC0C0_QMDV01_07_QMD_SPARE_I                               MW(1823:1792)
#define NVC0C0_QMDV01_07_QMD_SPARE_J                               MW(1855:1824)
#define NVC0C0_QMDV01_07_QMD_SPARE_K                               MW(1887:1856)
#define NVC0C0_QMDV01_07_QMD_SPARE_L                               MW(1919:1888)
#define NVC0C0_QMDV01_07_QMD_SPARE_M                               MW(1951:1920)
#define NVC0C0_QMDV01_07_QMD_SPARE_N                               MW(1983:1952)
#define NVC0C0_QMDV01_07_DEBUG_ID_UPPER                            MW(2015:1984)
#define NVC0C0_QMDV01_07_DEBUG_ID_LOWER                            MW(2047:2016)


/*
** Queue Meta Data, Version 02_00
 */

#define NVC0C0_QMDV02_00_OUTER_PUT                                 MW(30:0)
#define NVC0C0_QMDV02_00_OUTER_OVERFLOW                            MW(31:31)
#define NVC0C0_QMDV02_00_OUTER_GET                                 MW(62:32)
#define NVC0C0_QMDV02_00_OUTER_STICKY_OVERFLOW                     MW(63:63)
#define NVC0C0_QMDV02_00_INNER_GET                                 MW(94:64)
#define NVC0C0_QMDV02_00_INNER_OVERFLOW                            MW(95:95)
#define NVC0C0_QMDV02_00_INNER_PUT                                 MW(126:96)
#define NVC0C0_QMDV02_00_INNER_STICKY_OVERFLOW                     MW(127:127)
#define NVC0C0_QMDV02_00_QMD_RESERVED_A_A                          MW(159:128)
#define NVC0C0_QMDV02_00_DEPENDENT_QMD_POINTER                     MW(191:160)
#define NVC0C0_QMDV02_00_QMD_GROUP_ID                              MW(197:192)
#define NVC0C0_QMDV02_00_SM_GLOBAL_CACHING_ENABLE                  MW(198:198)
#define NVC0C0_QMDV02_00_RUN_CTA_IN_ONE_SM_PARTITION               MW(199:199)
#define NVC0C0_QMDV02_00_RUN_CTA_IN_ONE_SM_PARTITION_FALSE         0x00000000
#define NVC0C0_QMDV02_00_RUN_CTA_IN_ONE_SM_PARTITION_TRUE          0x00000001
#define NVC0C0_QMDV02_00_IS_QUEUE                                  MW(200:200)
#define NVC0C0_QMDV02_00_IS_QUEUE_FALSE                            0x00000000
#define NVC0C0_QMDV02_00_IS_QUEUE_TRUE                             0x00000001
#define NVC0C0_QMDV02_00_ADD_TO_HEAD_OF_QMD_GROUP_LINKED_LIST      MW(201:201)
#define NVC0C0_QMDV02_00_ADD_TO_HEAD_OF_QMD_GROUP_LINKED_LIST_FALSE 0x00000000
#define NVC0C0_QMDV02_00_ADD_TO_HEAD_OF_QMD_GROUP_LINKED_LIST_TRUE 0x00000001
#define NVC0C0_QMDV02_00_SEMAPHORE_RELEASE_ENABLE0                 MW(202:202)
#define NVC0C0_QMDV02_00_SEMAPHORE_RELEASE_ENABLE0_FALSE           0x00000000
#define NVC0C0_QMDV02_00_SEMAPHORE_RELEASE_ENABLE0_TRUE            0x00000001
#define NVC0C0_QMDV02_00_SEMAPHORE_RELEASE_ENABLE1                 MW(203:203)
#define NVC0C0_QMDV02_00_SEMAPHORE_RELEASE_ENABLE1_FALSE           0x00000000
#define NVC0C0_QMDV02_00_SEMAPHORE_RELEASE_ENABLE1_TRUE            0x00000001
#define NVC0C0_QMDV02_00_REQUIRE_SCHEDULING_PCAS                   MW(204:204)
#define NVC0C0_QMDV02_00_REQUIRE_SCHEDULING_PCAS_FALSE             0x00000000
#define NVC0C0_QMDV02_00_REQUIRE_SCHEDULING_PCAS_TRUE              0x00000001
#define NVC0C0_QMDV02_00_DEPENDENT_QMD_SCHEDULE_ENABLE             MW(205:205)
#define NVC0C0_QMDV02_00_DEPENDENT_QMD_SCHEDULE_ENABLE_FALSE       0x00000000
#define NVC0C0_QMDV02_00_DEPENDENT_QMD_SCHEDULE_ENABLE_TRUE        0x00000001
#define NVC0C0_QMDV02_00_DEPENDENT_QMD_TYPE                        MW(206:206)
#define NVC0C0_QMDV02_00_DEPENDENT_QMD_TYPE_QUEUE                  0x00000000
#define NVC0C0_QMDV02_00_DEPENDENT_QMD_TYPE_GRID                   0x00000001
#define NVC0C0_QMDV02_00_DEPENDENT_QMD_FIELD_COPY                  MW(207:207)
#define NVC0C0_QMDV02_00_DEPENDENT_QMD_FIELD_COPY_FALSE            0x00000000
#define NVC0C0_QMDV02_00_DEPENDENT_QMD_FIELD_COPY_TRUE             0x00000001
#define NVC0C0_QMDV02_00_QMD_RESERVED_B                            MW(223:208)
#define NVC0C0_QMDV02_00_CIRCULAR_QUEUE_SIZE                       MW(248:224)
#define NVC0C0_QMDV02_00_QMD_RESERVED_C                            MW(249:249)
#define NVC0C0_QMDV02_00_INVALIDATE_TEXTURE_HEADER_CACHE           MW(250:250)
#define NVC0C0_QMDV02_00_INVALIDATE_TEXTURE_HEADER_CACHE_FALSE     0x00000000
#define NVC0C0_QMDV02_00_INVALIDATE_TEXTURE_HEADER_CACHE_TRUE      0x00000001
#define NVC0C0_QMDV02_00_INVALIDATE_TEXTURE_SAMPLER_CACHE          MW(251:251)
#define NVC0C0_QMDV02_00_INVALIDATE_TEXTURE_SAMPLER_CACHE_FALSE    0x00000000
#define NVC0C0_QMDV02_00_INVALIDATE_TEXTURE_SAMPLER_CACHE_TRUE     0x00000001
#define NVC0C0_QMDV02_00_INVALIDATE_TEXTURE_DATA_CACHE             MW(252:252)
#define NVC0C0_QMDV02_00_INVALIDATE_TEXTURE_DATA_CACHE_FALSE       0x00000000
#define NVC0C0_QMDV02_00_INVALIDATE_TEXTURE_DATA_CACHE_TRUE        0x00000001
#define NVC0C0_QMDV02_00_INVALIDATE_SHADER_DATA_CACHE              MW(253:253)
#define NVC0C0_QMDV02_00_INVALIDATE_SHADER_DATA_CACHE_FALSE        0x00000000
#define NVC0C0_QMDV02_00_INVALIDATE_SHADER_DATA_CACHE_TRUE         0x00000001
#define NVC0C0_QMDV02_00_INVALIDATE_INSTRUCTION_CACHE              MW(254:254)
#define NVC0C0_QMDV02_00_INVALIDATE_INSTRUCTION_CACHE_FALSE        0x00000000
#define NVC0C0_QMDV02_00_INVALIDATE_INSTRUCTION_CACHE_TRUE         0x00000001
#define NVC0C0_QMDV02_00_INVALIDATE_SHADER_CONSTANT_CACHE          MW(255:255)
#define NVC0C0_QMDV02_00_INVALIDATE_SHADER_CONSTANT_CACHE_FALSE    0x00000000
#define NVC0C0_QMDV02_00_INVALIDATE_SHADER_CONSTANT_CACHE_TRUE     0x00000001
#define NVC0C0_QMDV02_00_PROGRAM_OFFSET                            MW(287:256)
#define NVC0C0_QMDV02_00_CIRCULAR_QUEUE_ADDR_LOWER                 MW(319:288)
#define NVC0C0_QMDV02_00_CIRCULAR_QUEUE_ADDR_UPPER                 MW(327:320)
#define NVC0C0_QMDV02_00_QMD_RESERVED_D                            MW(335:328)
#define NVC0C0_QMDV02_00_CIRCULAR_QUEUE_ENTRY_SIZE                 MW(351:336)
#define NVC0C0_QMDV02_00_CWD_REFERENCE_COUNT_ID                    MW(357:352)
#define NVC0C0_QMDV02_00_CWD_REFERENCE_COUNT_DELTA_MINUS_ONE       MW(365:358)
#define NVC0C0_QMDV02_00_RELEASE_MEMBAR_TYPE                       MW(366:366)
#define NVC0C0_QMDV02_00_RELEASE_MEMBAR_TYPE_FE_NONE               0x00000000
#define NVC0C0_QMDV02_00_RELEASE_MEMBAR_TYPE_FE_SYSMEMBAR          0x00000001
#define NVC0C0_QMDV02_00_CWD_REFERENCE_COUNT_INCR_ENABLE           MW(367:367)
#define NVC0C0_QMDV02_00_CWD_REFERENCE_COUNT_INCR_ENABLE_FALSE     0x00000000
#define NVC0C0_QMDV02_00_CWD_REFERENCE_COUNT_INCR_ENABLE_TRUE      0x00000001
#define NVC0C0_QMDV02_00_CWD_MEMBAR_TYPE                           MW(369:368)
#define NVC0C0_QMDV02_00_CWD_MEMBAR_TYPE_L1_NONE                   0x00000000
#define NVC0C0_QMDV02_00_CWD_MEMBAR_TYPE_L1_SYSMEMBAR              0x00000001
#define NVC0C0_QMDV02_00_CWD_MEMBAR_TYPE_L1_MEMBAR                 0x00000003
#define NVC0C0_QMDV02_00_SEQUENTIALLY_RUN_CTAS                     MW(370:370)
#define NVC0C0_QMDV02_00_SEQUENTIALLY_RUN_CTAS_FALSE               0x00000000
#define NVC0C0_QMDV02_00_SEQUENTIALLY_RUN_CTAS_TRUE                0x00000001
#define NVC0C0_QMDV02_00_CWD_REFERENCE_COUNT_DECR_ENABLE           MW(371:371)
#define NVC0C0_QMDV02_00_CWD_REFERENCE_COUNT_DECR_ENABLE_FALSE     0x00000000
#define NVC0C0_QMDV02_00_CWD_REFERENCE_COUNT_DECR_ENABLE_TRUE      0x00000001
#define NVC0C0_QMDV02_00_THROTTLED                                 MW(372:372)
#define NVC0C0_QMDV02_00_THROTTLED_FALSE                           0x00000000
#define NVC0C0_QMDV02_00_THROTTLED_TRUE                            0x00000001
#define NVC0C0_QMDV02_00_API_VISIBLE_CALL_LIMIT                    MW(378:378)
#define NVC0C0_QMDV02_00_API_VISIBLE_CALL_LIMIT__32                0x00000000
#define NVC0C0_QMDV02_00_API_VISIBLE_CALL_LIMIT_NO_CHECK           0x00000001
#define NVC0C0_QMDV02_00_SAMPLER_INDEX                             MW(382:382)
#define NVC0C0_QMDV02_00_SAMPLER_INDEX_INDEPENDENTLY               0x00000000
#define NVC0C0_QMDV02_00_SAMPLER_INDEX_VIA_HEADER_INDEX            0x00000001
#define NVC0C0_QMDV02_00_CTA_RASTER_WIDTH                          MW(415:384)
#define NVC0C0_QMDV02_00_CTA_RASTER_HEIGHT                         MW(431:416)
#define NVC0C0_QMDV02_00_QMD_RESERVED13A                           MW(447:432)
#define NVC0C0_QMDV02_00_CTA_RASTER_DEPTH                          MW(463:448)
#define NVC0C0_QMDV02_00_QMD_RESERVED14A                           MW(479:464)
#define NVC0C0_QMDV02_00_QMD_RESERVED15A                           MW(511:480)
#define NVC0C0_QMDV02_00_QUEUE_ENTRIES_PER_CTA_MINUS_ONE           MW(518:512)
#define NVC0C0_QMDV02_00_COALESCE_WAITING_PERIOD                   MW(529:522)
#define NVC0C0_QMDV02_00_SHARED_MEMORY_SIZE                        MW(561:544)
#define NVC0C0_QMDV02_00_QMD_RESERVED_G                            MW(575:562)
#define NVC0C0_QMDV02_00_QMD_VERSION                               MW(579:576)
#define NVC0C0_QMDV02_00_QMD_MAJOR_VERSION                         MW(583:580)
#define NVC0C0_QMDV02_00_QMD_RESERVED_H                            MW(591:584)
#define NVC0C0_QMDV02_00_CTA_THREAD_DIMENSION0                     MW(607:592)
#define NVC0C0_QMDV02_00_CTA_THREAD_DIMENSION1                     MW(623:608)
#define NVC0C0_QMDV02_00_CTA_THREAD_DIMENSION2                     MW(639:624)
#define NVC0C0_QMDV02_00_CONSTANT_BUFFER_VALID(i)                  MW((640+(i)*1):(640+(i)*1))
#define NVC0C0_QMDV02_00_CONSTANT_BUFFER_VALID_FALSE               0x00000000
#define NVC0C0_QMDV02_00_CONSTANT_BUFFER_VALID_TRUE                0x00000001
#define NVC0C0_QMDV02_00_QMD_RESERVED_I                            MW(671:648)
#define NVC0C0_QMDV02_00_SM_DISABLE_MASK_LOWER                     MW(703:672)
#define NVC0C0_QMDV02_00_SM_DISABLE_MASK_UPPER                     MW(735:704)
#define NVC0C0_QMDV02_00_RELEASE0_ADDRESS_LOWER                    MW(767:736)
#define NVC0C0_QMDV02_00_RELEASE0_ADDRESS_UPPER                    MW(775:768)
#define NVC0C0_QMDV02_00_QMD_RESERVED_J                            MW(783:776)
#define NVC0C0_QMDV02_00_RELEASE0_REDUCTION_OP                     MW(790:788)
#define NVC0C0_QMDV02_00_RELEASE0_REDUCTION_OP_RED_ADD             0x00000000
#define NVC0C0_QMDV02_00_RELEASE0_REDUCTION_OP_RED_MIN             0x00000001
#define NVC0C0_QMDV02_00_RELEASE0_REDUCTION_OP_RED_MAX             0x00000002
#define NVC0C0_QMDV02_00_RELEASE0_REDUCTION_OP_RED_INC             0x00000003
#define NVC0C0_QMDV02_00_RELEASE0_REDUCTION_OP_RED_DEC             0x00000004
#define NVC0C0_QMDV02_00_RELEASE0_REDUCTION_OP_RED_AND             0x00000005
#define NVC0C0_QMDV02_00_RELEASE0_REDUCTION_OP_RED_OR              0x00000006
#define NVC0C0_QMDV02_00_RELEASE0_REDUCTION_OP_RED_XOR             0x00000007
#define NVC0C0_QMDV02_00_QMD_RESERVED_K                            MW(791:791)
#define NVC0C0_QMDV02_00_RELEASE0_REDUCTION_FORMAT                 MW(793:792)
#define NVC0C0_QMDV02_00_RELEASE0_REDUCTION_FORMAT_UNSIGNED_32     0x00000000
#define NVC0C0_QMDV02_00_RELEASE0_REDUCTION_FORMAT_SIGNED_32       0x00000001
#define NVC0C0_QMDV02_00_RELEASE0_REDUCTION_ENABLE                 MW(794:794)
#define NVC0C0_QMDV02_00_RELEASE0_REDUCTION_ENABLE_FALSE           0x00000000
#define NVC0C0_QMDV02_00_RELEASE0_REDUCTION_ENABLE_TRUE            0x00000001
#define NVC0C0_QMDV02_00_RELEASE0_STRUCTURE_SIZE                   MW(799:799)
#define NVC0C0_QMDV02_00_RELEASE0_STRUCTURE_SIZE_FOUR_WORDS        0x00000000
#define NVC0C0_QMDV02_00_RELEASE0_STRUCTURE_SIZE_ONE_WORD          0x00000001
#define NVC0C0_QMDV02_00_RELEASE0_PAYLOAD                          MW(831:800)
#define NVC0C0_QMDV02_00_RELEASE1_ADDRESS_LOWER                    MW(863:832)
#define NVC0C0_QMDV02_00_RELEASE1_ADDRESS_UPPER                    MW(871:864)
#define NVC0C0_QMDV02_00_QMD_RESERVED_L                            MW(879:872)
#define NVC0C0_QMDV02_00_RELEASE1_REDUCTION_OP                     MW(886:884)
#define NVC0C0_QMDV02_00_RELEASE1_REDUCTION_OP_RED_ADD             0x00000000
#define NVC0C0_QMDV02_00_RELEASE1_REDUCTION_OP_RED_MIN             0x00000001
#define NVC0C0_QMDV02_00_RELEASE1_REDUCTION_OP_RED_MAX             0x00000002
#define NVC0C0_QMDV02_00_RELEASE1_REDUCTION_OP_RED_INC             0x00000003
#define NVC0C0_QMDV02_00_RELEASE1_REDUCTION_OP_RED_DEC             0x00000004
#define NVC0C0_QMDV02_00_RELEASE1_REDUCTION_OP_RED_AND             0x00000005
#define NVC0C0_QMDV02_00_RELEASE1_REDUCTION_OP_RED_OR              0x00000006
#define NVC0C0_QMDV02_00_RELEASE1_REDUCTION_OP_RED_XOR             0x00000007
#define NVC0C0_QMDV02_00_QMD_RESERVED_M                            MW(887:887)
#define NVC0C0_QMDV02_00_RELEASE1_REDUCTION_FORMAT                 MW(889:888)
#define NVC0C0_QMDV02_00_RELEASE1_REDUCTION_FORMAT_UNSIGNED_32     0x00000000
#define NVC0C0_QMDV02_00_RELEASE1_REDUCTION_FORMAT_SIGNED_32       0x00000001
#define NVC0C0_QMDV02_00_RELEASE1_REDUCTION_ENABLE                 MW(890:890)
#define NVC0C0_QMDV02_00_RELEASE1_REDUCTION_ENABLE_FALSE           0x00000000
#define NVC0C0_QMDV02_00_RELEASE1_REDUCTION_ENABLE_TRUE            0x00000001
#define NVC0C0_QMDV02_00_RELEASE1_STRUCTURE_SIZE                   MW(895:895)
#define NVC0C0_QMDV02_00_RELEASE1_STRUCTURE_SIZE_FOUR_WORDS        0x00000000
#define NVC0C0_QMDV02_00_RELEASE1_STRUCTURE_SIZE_ONE_WORD          0x00000001
#define NVC0C0_QMDV02_00_RELEASE1_PAYLOAD                          MW(927:896)
#define NVC0C0_QMDV02_00_SHADER_LOCAL_MEMORY_LOW_SIZE              MW(951:928)
#define NVC0C0_QMDV02_00_QMD_RESERVED_N                            MW(954:952)
#define NVC0C0_QMDV02_00_BARRIER_COUNT                             MW(959:955)
#define NVC0C0_QMDV02_00_SHADER_LOCAL_MEMORY_HIGH_SIZE             MW(983:960)
#define NVC0C0_QMDV02_00_REGISTER_COUNT                            MW(991:984)
#define NVC0C0_QMDV02_00_SHADER_LOCAL_MEMORY_CRS_SIZE              MW(1015:992)
#define NVC0C0_QMDV02_00_SASS_VERSION                              MW(1023:1016)
#define NVC0C0_QMDV02_00_CONSTANT_BUFFER_ADDR_LOWER(i)             MW((1055+(i)*64):(1024+(i)*64))
#define NVC0C0_QMDV02_00_CONSTANT_BUFFER_ADDR_UPPER(i)             MW((1072+(i)*64):(1056+(i)*64))
#define NVC0C0_QMDV02_00_CONSTANT_BUFFER_RESERVED_ADDR(i)          MW((1073+(i)*64):(1073+(i)*64))
#define NVC0C0_QMDV02_00_CONSTANT_BUFFER_INVALIDATE(i)             MW((1074+(i)*64):(1074+(i)*64))
#define NVC0C0_QMDV02_00_CONSTANT_BUFFER_INVALIDATE_FALSE          0x00000000
#define NVC0C0_QMDV02_00_CONSTANT_BUFFER_INVALIDATE_TRUE           0x00000001
#define NVC0C0_QMDV02_00_CONSTANT_BUFFER_SIZE_SHIFTED4(i)          MW((1087+(i)*64):(1075+(i)*64))
#define NVC0C0_QMDV02_00_HW_ONLY_INNER_GET                         MW(1566:1536)
#define NVC0C0_QMDV02_00_HW_ONLY_REQUIRE_SCHEDULING_PCAS           MW(1567:1567)
#define NVC0C0_QMDV02_00_HW_ONLY_INNER_PUT                         MW(1598:1568)
#define NVC0C0_QMDV02_00_HW_ONLY_SCG_TYPE                          MW(1599:1599)
#define NVC0C0_QMDV02_00_HW_ONLY_SPAN_LIST_HEAD_INDEX              MW(1629:1600)
#define NVC0C0_QMDV02_00_QMD_RESERVED_Q                            MW(1630:1630)
#define NVC0C0_QMDV02_00_HW_ONLY_SPAN_LIST_HEAD_INDEX_VALID        MW(1631:1631)
#define NVC0C0_QMDV02_00_HW_ONLY_SPAN_LIST_HEAD_INDEX_VALID_FALSE  0x00000000
#define NVC0C0_QMDV02_00_HW_ONLY_SPAN_LIST_HEAD_INDEX_VALID_TRUE   0x00000001
#define NVC0C0_QMDV02_00_HW_ONLY_SKED_NEXT_QMD_POINTER             MW(1663:1632)
#define NVC0C0_QMDV02_00_CTA_RASTER_WIDTH_RESUME                   MW(1695:1664)
#define NVC0C0_QMDV02_00_CTA_RASTER_HEIGHT_RESUME                  MW(1711:1696)
#define NVC0C0_QMDV02_00_CTA_RASTER_DEPTH_RESUME                   MW(1727:1712)
#define NVC0C0_QMDV02_00_QMD_SPARE_G                               MW(1759:1728)
#define NVC0C0_QMDV02_00_QMD_SPARE_H                               MW(1791:1760)
#define NVC0C0_QMDV02_00_QMD_SPARE_I                               MW(1823:1792)
#define NVC0C0_QMDV02_00_QMD_SPARE_J                               MW(1855:1824)
#define NVC0C0_QMDV02_00_QMD_SPARE_K                               MW(1887:1856)
#define NVC0C0_QMDV02_00_QMD_SPARE_L                               MW(1919:1888)
#define NVC0C0_QMDV02_00_QMD_SPARE_M                               MW(1951:1920)
#define NVC0C0_QMDV02_00_QMD_SPARE_N                               MW(1983:1952)
#define NVC0C0_QMDV02_00_DEBUG_ID_UPPER                            MW(2015:1984)
#define NVC0C0_QMDV02_00_DEBUG_ID_LOWER                            MW(2047:2016)


/*
** Queue Meta Data, Version 02_01
 */

#define NVC0C0_QMDV02_01_OUTER_PUT                                 MW(30:0)
#define NVC0C0_QMDV02_01_OUTER_OVERFLOW                            MW(31:31)
#define NVC0C0_QMDV02_01_OUTER_GET                                 MW(62:32)
#define NVC0C0_QMDV02_01_OUTER_STICKY_OVERFLOW                     MW(63:63)
#define NVC0C0_QMDV02_01_INNER_GET                                 MW(94:64)
#define NVC0C0_QMDV02_01_INNER_OVERFLOW                            MW(95:95)
#define NVC0C0_QMDV02_01_INNER_PUT                                 MW(126:96)
#define NVC0C0_QMDV02_01_INNER_STICKY_OVERFLOW                     MW(127:127)
#define NVC0C0_QMDV02_01_QMD_GROUP_ID                              MW(133:128)
#define NVC0C0_QMDV02_01_SM_GLOBAL_CACHING_ENABLE                  MW(134:134)
#define NVC0C0_QMDV02_01_RUN_CTA_IN_ONE_SM_PARTITION               MW(135:135)
#define NVC0C0_QMDV02_01_RUN_CTA_IN_ONE_SM_PARTITION_FALSE         0x00000000
#define NVC0C0_QMDV02_01_RUN_CTA_IN_ONE_SM_PARTITION_TRUE          0x00000001
#define NVC0C0_QMDV02_01_IS_QUEUE                                  MW(136:136)
#define NVC0C0_QMDV02_01_IS_QUEUE_FALSE                            0x00000000
#define NVC0C0_QMDV02_01_IS_QUEUE_TRUE                             0x00000001
#define NVC0C0_QMDV02_01_ADD_TO_HEAD_OF_QMD_GROUP_LINKED_LIST      MW(137:137)
#define NVC0C0_QMDV02_01_ADD_TO_HEAD_OF_QMD_GROUP_LINKED_LIST_FALSE 0x00000000
#define NVC0C0_QMDV02_01_ADD_TO_HEAD_OF_QMD_GROUP_LINKED_LIST_TRUE 0x00000001
#define NVC0C0_QMDV02_01_SEMAPHORE_RELEASE_ENABLE0                 MW(138:138)
#define NVC0C0_QMDV02_01_SEMAPHORE_RELEASE_ENABLE0_FALSE           0x00000000
#define NVC0C0_QMDV02_01_SEMAPHORE_RELEASE_ENABLE0_TRUE            0x00000001
#define NVC0C0_QMDV02_01_SEMAPHORE_RELEASE_ENABLE1                 MW(139:139)
#define NVC0C0_QMDV02_01_SEMAPHORE_RELEASE_ENABLE1_FALSE           0x00000000
#define NVC0C0_QMDV02_01_SEMAPHORE_RELEASE_ENABLE1_TRUE            0x00000001
#define NVC0C0_QMDV02_01_REQUIRE_SCHEDULING_PCAS                   MW(140:140)
#define NVC0C0_QMDV02_01_REQUIRE_SCHEDULING_PCAS_FALSE             0x00000000
#define NVC0C0_QMDV02_01_REQUIRE_SCHEDULING_PCAS_TRUE              0x00000001
#define NVC0C0_QMDV02_01_DEPENDENT_QMD_SCHEDULE_ENABLE             MW(141:141)
#define NVC0C0_QMDV02_01_DEPENDENT_QMD_SCHEDULE_ENABLE_FALSE       0x00000000
#define NVC0C0_QMDV02_01_DEPENDENT_QMD_SCHEDULE_ENABLE_TRUE        0x00000001
#define NVC0C0_QMDV02_01_DEPENDENT_QMD_TYPE                        MW(142:142)
#define NVC0C0_QMDV02_01_DEPENDENT_QMD_TYPE_QUEUE                  0x00000000
#define NVC0C0_QMDV02_01_DEPENDENT_QMD_TYPE_GRID                   0x00000001
#define NVC0C0_QMDV02_01_DEPENDENT_QMD_FIELD_COPY                  MW(143:143)
#define NVC0C0_QMDV02_01_DEPENDENT_QMD_FIELD_COPY_FALSE            0x00000000
#define NVC0C0_QMDV02_01_DEPENDENT_QMD_FIELD_COPY_TRUE             0x00000001
#define NVC0C0_QMDV02_01_QMD_RESERVED_B                            MW(159:144)
#define NVC0C0_QMDV02_01_CIRCULAR_QUEUE_SIZE                       MW(184:160)
#define NVC0C0_QMDV02_01_QMD_RESERVED_C                            MW(185:185)
#define NVC0C0_QMDV02_01_INVALIDATE_TEXTURE_HEADER_CACHE           MW(186:186)
#define NVC0C0_QMDV02_01_INVALIDATE_TEXTURE_HEADER_CACHE_FALSE     0x00000000
#define NVC0C0_QMDV02_01_INVALIDATE_TEXTURE_HEADER_CACHE_TRUE      0x00000001
#define NVC0C0_QMDV02_01_INVALIDATE_TEXTURE_SAMPLER_CACHE          MW(187:187)
#define NVC0C0_QMDV02_01_INVALIDATE_TEXTURE_SAMPLER_CACHE_FALSE    0x00000000
#define NVC0C0_QMDV02_01_INVALIDATE_TEXTURE_SAMPLER_CACHE_TRUE     0x00000001
#define NVC0C0_QMDV02_01_INVALIDATE_TEXTURE_DATA_CACHE             MW(188:188)
#define NVC0C0_QMDV02_01_INVALIDATE_TEXTURE_DATA_CACHE_FALSE       0x00000000
#define NVC0C0_QMDV02_01_INVALIDATE_TEXTURE_DATA_CACHE_TRUE        0x00000001
#define NVC0C0_QMDV02_01_INVALIDATE_SHADER_DATA_CACHE              MW(189:189)
#define NVC0C0_QMDV02_01_INVALIDATE_SHADER_DATA_CACHE_FALSE        0x00000000
#define NVC0C0_QMDV02_01_INVALIDATE_SHADER_DATA_CACHE_TRUE         0x00000001
#define NVC0C0_QMDV02_01_INVALIDATE_INSTRUCTION_CACHE              MW(190:190)
#define NVC0C0_QMDV02_01_INVALIDATE_INSTRUCTION_CACHE_FALSE        0x00000000
#define NVC0C0_QMDV02_01_INVALIDATE_INSTRUCTION_CACHE_TRUE         0x00000001
#define NVC0C0_QMDV02_01_INVALIDATE_SHADER_CONSTANT_CACHE          MW(191:191)
#define NVC0C0_QMDV02_01_INVALIDATE_SHADER_CONSTANT_CACHE_FALSE    0x00000000
#define NVC0C0_QMDV02_01_INVALIDATE_SHADER_CONSTANT_CACHE_TRUE     0x00000001
#define NVC0C0_QMDV02_01_CTA_RASTER_WIDTH_RESUME                   MW(223:192)
#define NVC0C0_QMDV02_01_CTA_RASTER_HEIGHT_RESUME                  MW(239:224)
#define NVC0C0_QMDV02_01_CTA_RASTER_DEPTH_RESUME                   MW(255:240)
#define NVC0C0_QMDV02_01_PROGRAM_OFFSET                            MW(287:256)
#define NVC0C0_QMDV02_01_CIRCULAR_QUEUE_ADDR_LOWER                 MW(319:288)
#define NVC0C0_QMDV02_01_CIRCULAR_QUEUE_ADDR_UPPER                 MW(327:320)
#define NVC0C0_QMDV02_01_QMD_RESERVED_D                            MW(335:328)
#define NVC0C0_QMDV02_01_CIRCULAR_QUEUE_ENTRY_SIZE                 MW(351:336)
#define NVC0C0_QMDV02_01_CWD_REFERENCE_COUNT_ID                    MW(357:352)
#define NVC0C0_QMDV02_01_CWD_REFERENCE_COUNT_DELTA_MINUS_ONE       MW(365:358)
#define NVC0C0_QMDV02_01_RELEASE_MEMBAR_TYPE                       MW(366:366)
#define NVC0C0_QMDV02_01_RELEASE_MEMBAR_TYPE_FE_NONE               0x00000000
#define NVC0C0_QMDV02_01_RELEASE_MEMBAR_TYPE_FE_SYSMEMBAR          0x00000001
#define NVC0C0_QMDV02_01_CWD_REFERENCE_COUNT_INCR_ENABLE           MW(367:367)
#define NVC0C0_QMDV02_01_CWD_REFERENCE_COUNT_INCR_ENABLE_FALSE     0x00000000
#define NVC0C0_QMDV02_01_CWD_REFERENCE_COUNT_INCR_ENABLE_TRUE      0x00000001
#define NVC0C0_QMDV02_01_CWD_MEMBAR_TYPE                           MW(369:368)
#define NVC0C0_QMDV02_01_CWD_MEMBAR_TYPE_L1_NONE                   0x00000000
#define NVC0C0_QMDV02_01_CWD_MEMBAR_TYPE_L1_SYSMEMBAR              0x00000001
#define NVC0C0_QMDV02_01_CWD_MEMBAR_TYPE_L1_MEMBAR                 0x00000003
#define NVC0C0_QMDV02_01_SEQUENTIALLY_RUN_CTAS                     MW(370:370)
#define NVC0C0_QMDV02_01_SEQUENTIALLY_RUN_CTAS_FALSE               0x00000000
#define NVC0C0_QMDV02_01_SEQUENTIALLY_RUN_CTAS_TRUE                0x00000001
#define NVC0C0_QMDV02_01_CWD_REFERENCE_COUNT_DECR_ENABLE           MW(371:371)
#define NVC0C0_QMDV02_01_CWD_REFERENCE_COUNT_DECR_ENABLE_FALSE     0x00000000
#define NVC0C0_QMDV02_01_CWD_REFERENCE_COUNT_DECR_ENABLE_TRUE      0x00000001
#define NVC0C0_QMDV02_01_THROTTLED                                 MW(372:372)
#define NVC0C0_QMDV02_01_THROTTLED_FALSE                           0x00000000
#define NVC0C0_QMDV02_01_THROTTLED_TRUE                            0x00000001
#define NVC0C0_QMDV02_01_API_VISIBLE_CALL_LIMIT                    MW(378:378)
#define NVC0C0_QMDV02_01_API_VISIBLE_CALL_LIMIT__32                0x00000000
#define NVC0C0_QMDV02_01_API_VISIBLE_CALL_LIMIT_NO_CHECK           0x00000001
#define NVC0C0_QMDV02_01_SAMPLER_INDEX                             MW(382:382)
#define NVC0C0_QMDV02_01_SAMPLER_INDEX_INDEPENDENTLY               0x00000000
#define NVC0C0_QMDV02_01_SAMPLER_INDEX_VIA_HEADER_INDEX            0x00000001
#define NVC0C0_QMDV02_01_CTA_RASTER_WIDTH                          MW(415:384)
#define NVC0C0_QMDV02_01_CTA_RASTER_HEIGHT                         MW(431:416)
#define NVC0C0_QMDV02_01_QMD_RESERVED13A                           MW(447:432)
#define NVC0C0_QMDV02_01_CTA_RASTER_DEPTH                          MW(463:448)
#define NVC0C0_QMDV02_01_QMD_RESERVED14A                           MW(479:464)
#define NVC0C0_QMDV02_01_DEPENDENT_QMD_POINTER                     MW(511:480)
#define NVC0C0_QMDV02_01_QUEUE_ENTRIES_PER_CTA_MINUS_ONE           MW(518:512)
#define NVC0C0_QMDV02_01_COALESCE_WAITING_PERIOD                   MW(529:522)
#define NVC0C0_QMDV02_01_SHARED_MEMORY_SIZE                        MW(561:544)
#define NVC0C0_QMDV02_01_QMD_RESERVED_G                            MW(575:562)
#define NVC0C0_QMDV02_01_QMD_VERSION                               MW(579:576)
#define NVC0C0_QMDV02_01_QMD_MAJOR_VERSION                         MW(583:580)
#define NVC0C0_QMDV02_01_QMD_RESERVED_H                            MW(591:584)
#define NVC0C0_QMDV02_01_CTA_THREAD_DIMENSION0                     MW(607:592)
#define NVC0C0_QMDV02_01_CTA_THREAD_DIMENSION1                     MW(623:608)
#define NVC0C0_QMDV02_01_CTA_THREAD_DIMENSION2                     MW(639:624)
#define NVC0C0_QMDV02_01_CONSTANT_BUFFER_VALID(i)                  MW((640+(i)*1):(640+(i)*1))
#define NVC0C0_QMDV02_01_CONSTANT_BUFFER_VALID_FALSE               0x00000000
#define NVC0C0_QMDV02_01_CONSTANT_BUFFER_VALID_TRUE                0x00000001
#define NVC0C0_QMDV02_01_QMD_RESERVED_I                            MW(671:648)
#define NVC0C0_QMDV02_01_SM_DISABLE_MASK_LOWER                     MW(703:672)
#define NVC0C0_QMDV02_01_SM_DISABLE_MASK_UPPER                     MW(735:704)
#define NVC0C0_QMDV02_01_RELEASE0_ADDRESS_LOWER                    MW(767:736)
#define NVC0C0_QMDV02_01_RELEASE0_ADDRESS_UPPER                    MW(775:768)
#define NVC0C0_QMDV02_01_QMD_RESERVED_J                            MW(783:776)
#define NVC0C0_QMDV02_01_RELEASE0_REDUCTION_OP                     MW(790:788)
#define NVC0C0_QMDV02_01_RELEASE0_REDUCTION_OP_RED_ADD             0x00000000
#define NVC0C0_QMDV02_01_RELEASE0_REDUCTION_OP_RED_MIN             0x00000001
#define NVC0C0_QMDV02_01_RELEASE0_REDUCTION_OP_RED_MAX             0x00000002
#define NVC0C0_QMDV02_01_RELEASE0_REDUCTION_OP_RED_INC             0x00000003
#define NVC0C0_QMDV02_01_RELEASE0_REDUCTION_OP_RED_DEC             0x00000004
#define NVC0C0_QMDV02_01_RELEASE0_REDUCTION_OP_RED_AND             0x00000005
#define NVC0C0_QMDV02_01_RELEASE0_REDUCTION_OP_RED_OR              0x00000006
#define NVC0C0_QMDV02_01_RELEASE0_REDUCTION_OP_RED_XOR             0x00000007
#define NVC0C0_QMDV02_01_QMD_RESERVED_K                            MW(791:791)
#define NVC0C0_QMDV02_01_RELEASE0_REDUCTION_FORMAT                 MW(793:792)
#define NVC0C0_QMDV02_01_RELEASE0_REDUCTION_FORMAT_UNSIGNED_32     0x00000000
#define NVC0C0_QMDV02_01_RELEASE0_REDUCTION_FORMAT_SIGNED_32       0x00000001
#define NVC0C0_QMDV02_01_RELEASE0_REDUCTION_ENABLE                 MW(794:794)
#define NVC0C0_QMDV02_01_RELEASE0_REDUCTION_ENABLE_FALSE           0x00000000
#define NVC0C0_QMDV02_01_RELEASE0_REDUCTION_ENABLE_TRUE            0x00000001
#define NVC0C0_QMDV02_01_RELEASE0_STRUCTURE_SIZE                   MW(799:799)
#define NVC0C0_QMDV02_01_RELEASE0_STRUCTURE_SIZE_FOUR_WORDS        0x00000000
#define NVC0C0_QMDV02_01_RELEASE0_STRUCTURE_SIZE_ONE_WORD          0x00000001
#define NVC0C0_QMDV02_01_RELEASE0_PAYLOAD                          MW(831:800)
#define NVC0C0_QMDV02_01_RELEASE1_ADDRESS_LOWER                    MW(863:832)
#define NVC0C0_QMDV02_01_RELEASE1_ADDRESS_UPPER                    MW(871:864)
#define NVC0C0_QMDV02_01_QMD_RESERVED_L                            MW(879:872)
#define NVC0C0_QMDV02_01_RELEASE1_REDUCTION_OP                     MW(886:884)
#define NVC0C0_QMDV02_01_RELEASE1_REDUCTION_OP_RED_ADD             0x00000000
#define NVC0C0_QMDV02_01_RELEASE1_REDUCTION_OP_RED_MIN             0x00000001
#define NVC0C0_QMDV02_01_RELEASE1_REDUCTION_OP_RED_MAX             0x00000002
#define NVC0C0_QMDV02_01_RELEASE1_REDUCTION_OP_RED_INC             0x00000003
#define NVC0C0_QMDV02_01_RELEASE1_REDUCTION_OP_RED_DEC             0x00000004
#define NVC0C0_QMDV02_01_RELEASE1_REDUCTION_OP_RED_AND             0x00000005
#define NVC0C0_QMDV02_01_RELEASE1_REDUCTION_OP_RED_OR              0x00000006
#define NVC0C0_QMDV02_01_RELEASE1_REDUCTION_OP_RED_XOR             0x00000007
#define NVC0C0_QMDV02_01_QMD_RESERVED_M                            MW(887:887)
#define NVC0C0_QMDV02_01_RELEASE1_REDUCTION_FORMAT                 MW(889:888)
#define NVC0C0_QMDV02_01_RELEASE1_REDUCTION_FORMAT_UNSIGNED_32     0x00000000
#define NVC0C0_QMDV02_01_RELEASE1_REDUCTION_FORMAT_SIGNED_32       0x00000001
#define NVC0C0_QMDV02_01_RELEASE1_REDUCTION_ENABLE                 MW(890:890)
#define NVC0C0_QMDV02_01_RELEASE1_REDUCTION_ENABLE_FALSE           0x00000000
#define NVC0C0_QMDV02_01_RELEASE1_REDUCTION_ENABLE_TRUE            0x00000001
#define NVC0C0_QMDV02_01_RELEASE1_STRUCTURE_SIZE                   MW(895:895)
#define NVC0C0_QMDV02_01_RELEASE1_STRUCTURE_SIZE_FOUR_WORDS        0x00000000
#define NVC0C0_QMDV02_01_RELEASE1_STRUCTURE_SIZE_ONE_WORD          0x00000001
#define NVC0C0_QMDV02_01_RELEASE1_PAYLOAD                          MW(927:896)
#define NVC0C0_QMDV02_01_SHADER_LOCAL_MEMORY_LOW_SIZE              MW(951:928)
#define NVC0C0_QMDV02_01_QMD_RESERVED_N                            MW(954:952)
#define NVC0C0_QMDV02_01_BARRIER_COUNT                             MW(959:955)
#define NVC0C0_QMDV02_01_SHADER_LOCAL_MEMORY_HIGH_SIZE             MW(983:960)
#define NVC0C0_QMDV02_01_REGISTER_COUNT                            MW(991:984)
#define NVC0C0_QMDV02_01_SHADER_LOCAL_MEMORY_CRS_SIZE              MW(1015:992)
#define NVC0C0_QMDV02_01_SASS_VERSION                              MW(1023:1016)
#define NVC0C0_QMDV02_01_CONSTANT_BUFFER_ADDR_LOWER(i)             MW((1055+(i)*64):(1024+(i)*64))
#define NVC0C0_QMDV02_01_CONSTANT_BUFFER_ADDR_UPPER(i)             MW((1072+(i)*64):(1056+(i)*64))
#define NVC0C0_QMDV02_01_CONSTANT_BUFFER_RESERVED_ADDR(i)          MW((1073+(i)*64):(1073+(i)*64))
#define NVC0C0_QMDV02_01_CONSTANT_BUFFER_INVALIDATE(i)             MW((1074+(i)*64):(1074+(i)*64))
#define NVC0C0_QMDV02_01_CONSTANT_BUFFER_INVALIDATE_FALSE          0x00000000
#define NVC0C0_QMDV02_01_CONSTANT_BUFFER_INVALIDATE_TRUE           0x00000001
#define NVC0C0_QMDV02_01_CONSTANT_BUFFER_SIZE_SHIFTED4(i)          MW((1087+(i)*64):(1075+(i)*64))
#define NVC0C0_QMDV02_01_QMD_RESERVED_R                            MW(1567:1536)
#define NVC0C0_QMDV02_01_QMD_RESERVED_S                            MW(1599:1568)
#define NVC0C0_QMDV02_01_HW_ONLY_INNER_GET                         MW(1630:1600)
#define NVC0C0_QMDV02_01_HW_ONLY_REQUIRE_SCHEDULING_PCAS           MW(1631:1631)
#define NVC0C0_QMDV02_01_HW_ONLY_INNER_PUT                         MW(1662:1632)
#define NVC0C0_QMDV02_01_HW_ONLY_SCG_TYPE                          MW(1663:1663)
#define NVC0C0_QMDV02_01_HW_ONLY_SPAN_LIST_HEAD_INDEX              MW(1693:1664)
#define NVC0C0_QMDV02_01_QMD_RESERVED_Q                            MW(1694:1694)
#define NVC0C0_QMDV02_01_HW_ONLY_SPAN_LIST_HEAD_INDEX_VALID        MW(1695:1695)
#define NVC0C0_QMDV02_01_HW_ONLY_SPAN_LIST_HEAD_INDEX_VALID_FALSE  0x00000000
#define NVC0C0_QMDV02_01_HW_ONLY_SPAN_LIST_HEAD_INDEX_VALID_TRUE   0x00000001
#define NVC0C0_QMDV02_01_HW_ONLY_SKED_NEXT_QMD_POINTER             MW(1727:1696)
#define NVC0C0_QMDV02_01_QMD_SPARE_G                               MW(1759:1728)
#define NVC0C0_QMDV02_01_QMD_SPARE_H                               MW(1791:1760)
#define NVC0C0_QMDV02_01_QMD_SPARE_I                               MW(1823:1792)
#define NVC0C0_QMDV02_01_QMD_SPARE_J                               MW(1855:1824)
#define NVC0C0_QMDV02_01_QMD_SPARE_K                               MW(1887:1856)
#define NVC0C0_QMDV02_01_QMD_SPARE_L                               MW(1919:1888)
#define NVC0C0_QMDV02_01_QMD_SPARE_M                               MW(1951:1920)
#define NVC0C0_QMDV02_01_QMD_SPARE_N                               MW(1983:1952)
#define NVC0C0_QMDV02_01_DEBUG_ID_UPPER                            MW(2015:1984)
#define NVC0C0_QMDV02_01_DEBUG_ID_LOWER                            MW(2047:2016)



#endif // #ifndef __CLC0C0QMD_H__
