# Kode Mono

[![][Fontbakery]](https://isaozler.github.io/kode-mono/fontbakery/fontbakery-report.html)
[![][Universal]](https://isaozler.github.io/kode-mono/fontbakery/fontbakery-report.html)
[![][GF Profile]](https://isaozler.github.io/kode-mono/fontbakery/fontbakery-report.html)
[![][Outline Correctness]](https://isaozler.github.io/kode-mono/fontbakery/fontbakery-report.html)
[![][Shaping]](https://isaozler.github.io/kode-mono/fontbakery/fontbakery-report.html)

[Fontbakery]: https://img.shields.io/endpoint?url=https%3A%2F%2Fisaozler.github.io%2Fkode-mono%2Fbadges%2Foverall.json
[GF Profile]: https://img.shields.io/endpoint?url=https%3A%2F%2Fisaozler.github.io%2Fkode-mono%2Fbadges%2FGoogleFonts.json
[Outline Correctness]: https://img.shields.io/endpoint?url=https%3A%2F%2Fisaozler.github.io%2Fkode-mono%2Fbadges%2FOutlineCorrectnessChecks.json
[Shaping]: https://img.shields.io/endpoint?url=https%3A%2F%2Fisaozler.github.io%2Fkode-mono%2Fbadges%2FShapingChecks.json
[Universal]: https://img.shields.io/endpoint?url=https%3A%2F%2Fisaozler.github.io%2Fkode-mono%2Fbadges%2FUniversal.json

Available at\
[![Google Fonts - Kode Mono](/documentation/google-fonts-logo.svg 'Download Kode Mono from Google Fonts')](https://fonts.google.com/specimen/Kode+Mono)

A custom-designed typeface explicitly created for the developer community. 

This typeface is designed to enhance the user experience and reflect our principles of functionality and timelessness.

![Generated Image](documentation/kode-mono-google-fonts-release.webp)

## About

### Focus on Developer Experience

As a developer-focused platform, we are dedicated to providing a secure, scalable, and efficient infrastructure for decentralized applications, and this typeface is an extension of that commitment.

### Programming Ligatures

Kode Mono comes with a set of ligatures. Supporting a wide range of language-specific ligatures including our smart-contract language Pact, Javascript, Haskell, Rust and many more to come.

## Building

Fonts are built automatically by GitHub Actions - take a look in the "Actions" tab for the latest build.

If you want to build fonts manually on your own computer:

* `make build` will produce font files.
* `make test` will run [FontBakery](https://github.com/googlefonts/fontbakery)'s quality assurance tests.
* `make proof` will generate HTML proof files.

The proof files and QA tests are also available automatically via GitHub Actions - look at `https://isaozler.github.io/kode-mono`.

## Changelog
[See CHANGELOG.md](./CHANGELOG.md)

## License

This Font Software is licensed under the SIL Open Font License, Version 1.1.
This license is available with a FAQ at
https://openfontlicense.org/

## Repository Layout

This font repository structure is inspired by [Unified Font Repository v0.3](https://github.com/unified-font-repository/Unified-Font-Repository), modified for the Google Fonts workflow.

![Generated Image](documentation/wip-kode-mono.jpeg)

## Credits

**Type designer**\
Isa Ozler

**Special Thanks to**\
Randy Daal, John Wiegley, Andy Tang, Ashwin van Dijk, Rosalie Wagner, Emma Marichal, Marc Foley, Viviana Monsalve, and everyone else contributed to this typeface.
