; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
;=========================== begin_copyright_notice ============================
;
; Copyright (C) 2024 Intel Corporation
;
; SPDX-License-Identifier: MIT
;
;============================ end_copyright_notice =============================

; RUN: igc_opt %s --opaque-pointers -S -o - -types-legalization-pass | FileCheck %s
; REQUIRES: llvm-14-plus

%simple.struct.type = type { i64, float }
%nested.struct.type = type { i32, %simple.struct.type }

; should replace extractvalue with getelementptr + load instructions
define spir_kernel void @cover.ResolveExtractValue(ptr byval(%nested.struct.type) %struct.ptr)
; CHECK-LABEL: define spir_kernel void @cover.ResolveExtractValue(
; CHECK-SAME: ptr byval([[NESTED_STRUCT_TYPE:%.*]]) [[STRUCT_PTR:%.*]]) {
; CHECK-NEXT:    [[PTR_TO_INNER_STRUCT:%.*]] = getelementptr [[NESTED_STRUCT_TYPE]], ptr [[STRUCT_PTR]], i32 0, i32 1
; CHECK-NEXT:    [[TMP1:%.*]] = getelementptr [[SIMPLE_STRUCT_TYPE:%.*]], ptr [[PTR_TO_INNER_STRUCT]], i32 0, i32 1
; CHECK-NEXT:    [[TMP2:%.*]] = load float, ptr [[TMP1]], align 4
; CHECK-NEXT:    [[INNER_STRUCT_VALUE:%.*]] = load [[SIMPLE_STRUCT_TYPE]], ptr [[PTR_TO_INNER_STRUCT]], align 4
; CHECK-NEXT:    [[RESULT:%.*]] = fmul float [[TMP2]], 4.000000e+00
; CHECK-NEXT:    ret void
;
{
  %ptr.to.inner.struct = getelementptr %nested.struct.type, ptr %struct.ptr, i32 0, i32 1
  %inner.struct.value = load %simple.struct.type, ptr %ptr.to.inner.struct
  %inner.struct.value.float = extractvalue %simple.struct.type %inner.struct.value, 1
  %result = fmul float %inner.struct.value.float, 4.0
  ret void
}
