/***************************************************************************
      headertemplateprovider - template provider classes for header data
                               like addresses or texts
                             -------------------
    begin                : 2007-05-02
    copyright            : (C) 2007 by Klaas Freitag
    email                : freitag@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <QDebug>

#include "headertemplateprovider.h"
#include "texteditdialog.h"
#include "doctext.h"
#include "defaultprovider.h"

HeaderTemplateProvider::HeaderTemplateProvider( QWidget *parent )
  :TemplateProvider( parent )
{

}

void HeaderTemplateProvider::slotNewTemplate()
{
  // qDebug () << "SlotNewTemplate called!";

  TextEditDialog dia( mParent, KraftDoc::Part::Header );

  DocText dt;
  dt.setTextType( KraftDoc::Part::Header );
  dt.setDocType( mDocType );

  dia.setDocText( dt );

  if ( dia.exec() ) {
    // qDebug () << "Successfully edited texts";
    DocText dt = dia.docText();
    /* save to database */
    dbID newId = DefaultProvider::self()->saveDocumentText( dt );
    dt.setDbId( newId );

    Q_EMIT newHeaderText( dt );
  }
}

void HeaderTemplateProvider::slotEditTemplate()
{
  // qDebug () << "SlotEditTemplate called!";

  TextEditDialog dia( mParent, KraftDoc::Part::Header );

  /* mCurrentText is set through the slot slotSetCurrentDocText */
  DocText dt = currentText();
  if ( dt.type() == KraftDoc::Part::Unknown ) {
    dt.setTextType( KraftDoc::Part::Header );
    dt.setDocType( mDocType );
  }

  dia.setDocText( dt );

  if ( dia.exec() ) {
    // qDebug () << "Successfully edited texts";
    DocText dt = dia.docText();

    /* write back the listview item stored in the input text */
    dt.setListViewItem( currentText().listViewItem() );
    /* save to database */
    DefaultProvider::self()->saveDocumentText( dt );

    Q_EMIT updateHeaderText( dt );
  }

}

void HeaderTemplateProvider::slotDeleteTemplate()
{
  DefaultProvider::self()->deleteDocumentText( currentText() );
  Q_EMIT deleteHeaderText( currentText() );
}

void HeaderTemplateProvider::slotTemplateToDocument()
{
  // qDebug () << "Moving template to document";

  Q_EMIT headerTextToDocument(currentText(), true);
}

void HeaderTemplateProvider::slotInsertTemplateToDocument()
{
    Q_EMIT headerTextToDocument(currentText(), false);
}
