/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shared.uuid;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.Random;
import org.apache.jena.JenaRuntime;

class LibUUID {
    LibUUID() {
    }

    static Random makeRandom() {
        SecureRandom sRandom = new SecureRandom();
        byte[] seed1 = sRandom.generateSeed(16);
        byte[] seed2 = LibUUID.makeSeed();
        sRandom.setSeed(seed1);
        sRandom.setSeed(seed2);
        return sRandom;
    }

    static byte[] makeSeed() {
        StringBuilder seedInput = new StringBuilder(200);
        try {
            seedInput.append(InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        seedInput.append(JenaRuntime.getSystemProperty("os.version"));
        seedInput.append(JenaRuntime.getSystemProperty("user.name"));
        seedInput.append(JenaRuntime.getSystemProperty("java.version"));
        seedInput.append(Integer.toString(Thread.activeCount()));
        seedInput.append(Long.toString(Runtime.getRuntime().freeMemory()));
        seedInput.append(Long.toString(Runtime.getRuntime().totalMemory()));
        seedInput.append(Long.toString(System.currentTimeMillis()));
        seedInput.append(Long.toString(new Object().hashCode()));
        return seedInput.toString().getBytes();
    }
}

