/**************************************************************************/
/*                                                                        */
/*                                 OCaml                                  */
/*                                                                        */
/*  Contributed by Stephane Glondu <steph@glondu.net>                     */
/*                                                                        */
/*   Copyright 2009 Institut National de Recherche en Informatique et     */
/*     en Automatique.                                                    */
/*                                                                        */
/*   All rights reserved.  This file is distributed under the terms of    */
/*   the GNU Lesser General Public License version 2.1, with the          */
/*   special exception on linking described in the file LICENSE.          */
/*                                                                        */
/**************************************************************************/

#include <caml/mlvalues.h>
#include <caml/alloc.h>
#include <caml/fail.h>
#include <caml/memory.h>

#ifdef HAS_SETGROUPS

#include <sys/types.h>
#ifndef _WIN32
#include <unistd.h>
#endif
#include <limits.h>
#include <grp.h>
#include "caml/unixsupport.h"

CAMLprim value caml_unix_setgroups(value groups)
{
  gid_t * gidset;
  mlsize_t size;
  int n;

  size = Wosize_val(groups);
  gidset = (gid_t *) caml_stat_alloc(size * sizeof(gid_t));
  for (mlsize_t i = 0; i < size; i++) gidset[i] = Int_val(Field(groups, i));

  n = setgroups(size, gidset);

  caml_stat_free(gidset);
  if (n == -1) caml_uerror("setgroups", Nothing);
  return Val_unit;
}

#else

CAMLprim value caml_unix_setgroups(value groups)
{ caml_invalid_argument("setgroups not implemented"); }

#endif
